<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for apc
 */
class apc extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $apcid;
	public $grp;
	public $code;
	public $description;
	public $cron;
	public $next_cycle;
	public $delay;
	public $delay_method;
	public $last_updated;
	public $user_level;
	public $visible;
	public $operator;
	public $datetime;
	public $status;
	public $order_by;
	public $url;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'apc';
		$this->TableName = 'apc';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`apc`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('apc', 'apc', 'x_id', 'id', '`id`', '`id`', 200, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = FALSE; // Allow sort
		$this->fields['id'] = &$this->id;

		// apcid
		$this->apcid = new DbField('apc', 'apc', 'x_apcid', 'apcid', '`apcid`', '`apcid`', 18, -1, FALSE, '`apcid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->apcid->IsPrimaryKey = TRUE; // Primary key field
		$this->apcid->Nullable = FALSE; // NOT NULL field
		$this->apcid->Required = TRUE; // Required field
		$this->apcid->Sortable = TRUE; // Allow sort
		$this->apcid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['apcid'] = &$this->apcid;

		// grp
		$this->grp = new DbField('apc', 'apc', 'x_grp', 'grp', '`grp`', '`grp`', 200, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->Lookup = new Lookup('grp', 'int_fibre_apc_grp', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// code
		$this->code = new DbField('apc', 'apc', 'x_code', 'code', '`code`', '`code`', 201, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->code->Nullable = FALSE; // NOT NULL field
		$this->code->Required = TRUE; // Required field
		$this->code->Sortable = TRUE; // Allow sort
		$this->fields['code'] = &$this->code;

		// description
		$this->description = new DbField('apc', 'apc', 'x_description', 'description', '`description`', '`description`', 200, -1, FALSE, '`description`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description->Nullable = FALSE; // NOT NULL field
		$this->description->Required = TRUE; // Required field
		$this->description->Sortable = TRUE; // Allow sort
		$this->fields['description'] = &$this->description;

		// cron
		$this->cron = new DbField('apc', 'apc', 'x_cron', 'cron', '`cron`', '`cron`', 17, -1, FALSE, '`cron`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->cron->Nullable = FALSE; // NOT NULL field
		$this->cron->Required = TRUE; // Required field
		$this->cron->Sortable = TRUE; // Allow sort
		$this->cron->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->cron->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->cron->Lookup = new Lookup('cron', 'apc', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->cron->OptionCount = 2;
		$this->cron->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cron'] = &$this->cron;

		// next_cycle
		$this->next_cycle = new DbField('apc', 'apc', 'x_next_cycle', 'next_cycle', '`next_cycle`', CastDateFieldForLike('`next_cycle`', 11, "DB"), 135, 11, FALSE, '`next_cycle`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->next_cycle->Nullable = FALSE; // NOT NULL field
		$this->next_cycle->Sortable = TRUE; // Allow sort
		$this->next_cycle->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['next_cycle'] = &$this->next_cycle;

		// delay
		$this->delay = new DbField('apc', 'apc', 'x_delay', 'delay', '`delay`', '`delay`', 17, -1, FALSE, '`delay`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->delay->Nullable = FALSE; // NOT NULL field
		$this->delay->Required = TRUE; // Required field
		$this->delay->Sortable = TRUE; // Allow sort
		$this->delay->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['delay'] = &$this->delay;

		// delay_method
		$this->delay_method = new DbField('apc', 'apc', 'x_delay_method', 'delay_method', '`delay_method`', '`delay_method`', 17, -1, FALSE, '`delay_method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->delay_method->Nullable = FALSE; // NOT NULL field
		$this->delay_method->Sortable = TRUE; // Allow sort
		$this->delay_method->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->delay_method->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->delay_method->Lookup = new Lookup('delay_method', 'apc', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->delay_method->OptionCount = 4;
		$this->delay_method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['delay_method'] = &$this->delay_method;

		// last_updated
		$this->last_updated = new DbField('apc', 'apc', 'x_last_updated', 'last_updated', '`last_updated`', '`last_updated`', 200, -1, FALSE, '`last_updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->last_updated->Required = TRUE; // Required field
		$this->last_updated->Sortable = TRUE; // Allow sort
		$this->fields['last_updated'] = &$this->last_updated;

		// user_level
		$this->user_level = new DbField('apc', 'apc', 'x_user_level', 'user_level', '`user_level`', '`user_level`', 200, -1, FALSE, '`user_level`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->user_level->Sortable = TRUE; // Allow sort
		$this->user_level->Lookup = new Lookup('user_level', 'userlevels', FALSE, 'userlevelid', ["userlevelname","","",""], [], [], [], [], [], [], '`userlevelname` ASC', '');
		$this->user_level->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['user_level'] = &$this->user_level;

		// visible
		$this->visible = new DbField('apc', 'apc', 'x_visible', 'visible', '`visible`', '`visible`', 17, -1, FALSE, '`visible`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->visible->Nullable = FALSE; // NOT NULL field
		$this->visible->Sortable = TRUE; // Allow sort
		$this->visible->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->visible->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->visible->Lookup = new Lookup('visible', 'apc', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->visible->OptionCount = 2;
		$this->visible->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['visible'] = &$this->visible;

		// operator
		$this->operator = new DbField('apc', 'apc', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('apc', 'apc', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// status
		$this->status = new DbField('apc', 'apc', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'apc', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// order_by
		$this->order_by = new DbField('apc', 'apc', 'x_order_by', 'order_by', '`order_by`', '`order_by`', 17, -1, FALSE, '`order_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_by->Nullable = FALSE; // NOT NULL field
		$this->order_by->Sortable = TRUE; // Allow sort
		$this->order_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['order_by'] = &$this->order_by;

		// url
		$this->url = new DbField('apc', 'apc', 'x_url', 'url', '`url`', '`url`', 200, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->Sortable = TRUE; // Allow sort
		$this->fields['url'] = &$this->url;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`apc`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`operator` = " . CurrentUserID()." AND `operator`=-1";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`apcid` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('apcid', $rs))
				AddFilter($where, QuotedName('apcid', $this->Dbid) . '=' . QuotedValue($rs['apcid'], $this->apcid->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->apcid->DbValue = $row['apcid'];
		$this->grp->DbValue = $row['grp'];
		$this->code->DbValue = $row['code'];
		$this->description->DbValue = $row['description'];
		$this->cron->DbValue = $row['cron'];
		$this->next_cycle->DbValue = $row['next_cycle'];
		$this->delay->DbValue = $row['delay'];
		$this->delay_method->DbValue = $row['delay_method'];
		$this->last_updated->DbValue = $row['last_updated'];
		$this->user_level->DbValue = $row['user_level'];
		$this->visible->DbValue = $row['visible'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->status->DbValue = $row['status'];
		$this->order_by->DbValue = $row['order_by'];
		$this->url->DbValue = $row['url'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`apcid` = @apcid@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('apcid', $row) ? $row['apcid'] : NULL) : $this->apcid->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@apcid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "apclist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "apcview.php")
			return $Language->phrase("View");
		elseif ($pageName == "apcedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "apcadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "apclist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("apcview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("apcview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "apcadd.php?" . $this->getUrlParm($parm);
		else
			$url = "apcadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("apcedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("apcadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("apcdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "apcid:" . JsonEncode($this->apcid->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->apcid->CurrentValue != NULL) {
			$url .= "apcid=" . urlencode($this->apcid->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("apcid") !== NULL)
				$arKeys[] = Param("apcid");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->apcid->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->apcid->setDbValue($rs->fields('apcid'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->code->setDbValue($rs->fields('code'));
		$this->description->setDbValue($rs->fields('description'));
		$this->cron->setDbValue($rs->fields('cron'));
		$this->next_cycle->setDbValue($rs->fields('next_cycle'));
		$this->delay->setDbValue($rs->fields('delay'));
		$this->delay_method->setDbValue($rs->fields('delay_method'));
		$this->last_updated->setDbValue($rs->fields('last_updated'));
		$this->user_level->setDbValue($rs->fields('user_level'));
		$this->visible->setDbValue($rs->fields('visible'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->status->setDbValue($rs->fields('status'));
		$this->order_by->setDbValue($rs->fields('order_by'));
		$this->url->setDbValue($rs->fields('url'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id

		$this->id->CellCssStyle = "white-space: nowrap;";

		// apcid
		// grp
		// code
		// description
		// cron
		// next_cycle
		// delay
		// delay_method
		// last_updated
		// user_level
		// visible
		// operator
		// datetime
		// status
		// order_by
		// url
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// apcid
		$this->apcid->ViewValue = $this->apcid->CurrentValue;
		$this->apcid->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id`> 1 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// description
		$this->description->ViewValue = $this->description->CurrentValue;
		$this->description->ViewCustomAttributes = "";

		// cron
		if (strval($this->cron->CurrentValue) <> "") {
			$this->cron->ViewValue = $this->cron->optionCaption($this->cron->CurrentValue);
		} else {
			$this->cron->ViewValue = NULL;
		}
		$this->cron->ViewCustomAttributes = "";

		// next_cycle
		$this->next_cycle->ViewValue = $this->next_cycle->CurrentValue;
		$this->next_cycle->ViewValue = FormatDateTime($this->next_cycle->ViewValue, 11);
		$this->next_cycle->ViewCustomAttributes = "";

		// delay
		$this->delay->ViewValue = $this->delay->CurrentValue;
		$this->delay->ViewCustomAttributes = "";

		// delay_method
		if (strval($this->delay_method->CurrentValue) <> "") {
			$this->delay_method->ViewValue = $this->delay_method->optionCaption($this->delay_method->CurrentValue);
		} else {
			$this->delay_method->ViewValue = NULL;
		}
		$this->delay_method->ViewCustomAttributes = "";

		// last_updated
		$this->last_updated->ViewValue = $this->last_updated->CurrentValue;
		$this->last_updated->ViewCustomAttributes = "";

		// user_level
		$curVal = strval($this->user_level->CurrentValue);
		if ($curVal <> "") {
			$this->user_level->ViewValue = $this->user_level->lookupCacheOption($curVal);
			if ($this->user_level->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`userlevelid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->user_level->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->user_level->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->user_level->ViewValue->add($this->user_level->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->user_level->ViewValue = $this->user_level->CurrentValue;
				}
			}
		} else {
			$this->user_level->ViewValue = NULL;
		}
		$this->user_level->ViewCustomAttributes = "";

		// visible
		if (strval($this->visible->CurrentValue) <> "") {
			$this->visible->ViewValue = $this->visible->optionCaption($this->visible->CurrentValue);
		} else {
			$this->visible->ViewValue = NULL;
		}
		$this->visible->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// order_by
		$this->order_by->ViewValue = $this->order_by->CurrentValue;
		$this->order_by->ViewValue = FormatNumber($this->order_by->ViewValue, 0, -2, -2, -2);
		$this->order_by->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// apcid
		$this->apcid->LinkCustomAttributes = "";
		$this->apcid->HrefValue = "";
		$this->apcid->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		$this->code->HrefValue = "";
		$this->code->TooltipValue = "";

		// description
		$this->description->LinkCustomAttributes = "";
		if (!EmptyValue($this->id->CurrentValue)) {
			$this->description->HrefValue = "autoprogramme.php?apcid=" . $this->id->CurrentValue; // Add prefix/suffix
			$this->description->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
		} else {
			$this->description->HrefValue = "";
		}
		$this->description->TooltipValue = "";

		// cron
		$this->cron->LinkCustomAttributes = "";
		$this->cron->HrefValue = "";
		$this->cron->TooltipValue = "";

		// next_cycle
		$this->next_cycle->LinkCustomAttributes = "";
		$this->next_cycle->HrefValue = "";
		$this->next_cycle->TooltipValue = "";

		// delay
		$this->delay->LinkCustomAttributes = "";
		$this->delay->HrefValue = "";
		$this->delay->TooltipValue = "";

		// delay_method
		$this->delay_method->LinkCustomAttributes = "";
		$this->delay_method->HrefValue = "";
		$this->delay_method->TooltipValue = "";

		// last_updated
		$this->last_updated->LinkCustomAttributes = "";
		$this->last_updated->HrefValue = "";
		$this->last_updated->TooltipValue = "";

		// user_level
		$this->user_level->LinkCustomAttributes = "";
		$this->user_level->HrefValue = "";
		$this->user_level->TooltipValue = "";

		// visible
		$this->visible->LinkCustomAttributes = "";
		$this->visible->HrefValue = "";
		$this->visible->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// order_by
		$this->order_by->LinkCustomAttributes = "";
		$this->order_by->HrefValue = "";
		$this->order_by->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->id->CurrentValue = HtmlDecode($this->id->CurrentValue);
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// apcid
		$this->apcid->EditAttrs["class"] = "form-control";
		$this->apcid->EditCustomAttributes = "";
		$this->apcid->EditValue = $this->apcid->CurrentValue;
		$this->apcid->ViewCustomAttributes = "";

		// grp
		$this->grp->EditCustomAttributes = "";

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = "";
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->PlaceHolder = RemoveHtml($this->code->caption());

		// description
		$this->description->EditAttrs["class"] = "form-control";
		$this->description->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
		$this->description->EditValue = $this->description->CurrentValue;
		$this->description->PlaceHolder = RemoveHtml($this->description->caption());

		// cron
		$this->cron->EditAttrs["class"] = "form-control";
		$this->cron->EditCustomAttributes = "";
		$this->cron->EditValue = $this->cron->options(TRUE);

		// next_cycle
		$this->next_cycle->EditAttrs["class"] = "form-control";
		$this->next_cycle->EditCustomAttributes = "";
		$this->next_cycle->EditValue = FormatDateTime($this->next_cycle->CurrentValue, 11);
		$this->next_cycle->PlaceHolder = RemoveHtml($this->next_cycle->caption());

		// delay
		$this->delay->EditAttrs["class"] = "form-control";
		$this->delay->EditCustomAttributes = "";
		$this->delay->EditValue = $this->delay->CurrentValue;
		$this->delay->PlaceHolder = RemoveHtml($this->delay->caption());

		// delay_method
		$this->delay_method->EditAttrs["class"] = "form-control";
		$this->delay_method->EditCustomAttributes = "";
		$this->delay_method->EditValue = $this->delay_method->options(TRUE);

		// last_updated
		$this->last_updated->EditAttrs["class"] = "form-control";
		$this->last_updated->EditCustomAttributes = "";
		$this->last_updated->EditValue = $this->last_updated->CurrentValue;
		$this->last_updated->ViewCustomAttributes = "";

		// user_level
		$this->user_level->EditCustomAttributes = "";

		// visible
		$this->visible->EditAttrs["class"] = "form-control";
		$this->visible->EditCustomAttributes = "";
		$this->visible->EditValue = $this->visible->options(TRUE);

		// operator
		// datetime
		// status

		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// order_by
		$this->order_by->EditAttrs["class"] = "form-control";
		$this->order_by->EditCustomAttributes = "";
		$this->order_by->EditValue = $this->order_by->CurrentValue;
		$this->order_by->PlaceHolder = RemoveHtml($this->order_by->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->apcid);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->description);
					$doc->exportCaption($this->cron);
					$doc->exportCaption($this->next_cycle);
					$doc->exportCaption($this->delay);
					$doc->exportCaption($this->delay_method);
					$doc->exportCaption($this->last_updated);
					$doc->exportCaption($this->user_level);
					$doc->exportCaption($this->visible);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->order_by);
					$doc->exportCaption($this->url);
				} else {
					$doc->exportCaption($this->apcid);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->description);
					$doc->exportCaption($this->cron);
					$doc->exportCaption($this->next_cycle);
					$doc->exportCaption($this->delay);
					$doc->exportCaption($this->delay_method);
					$doc->exportCaption($this->last_updated);
					$doc->exportCaption($this->user_level);
					$doc->exportCaption($this->visible);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->order_by);
					$doc->exportCaption($this->url);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->apcid);
						$doc->exportField($this->grp);
						$doc->exportField($this->code);
						$doc->exportField($this->description);
						$doc->exportField($this->cron);
						$doc->exportField($this->next_cycle);
						$doc->exportField($this->delay);
						$doc->exportField($this->delay_method);
						$doc->exportField($this->last_updated);
						$doc->exportField($this->user_level);
						$doc->exportField($this->visible);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->status);
						$doc->exportField($this->order_by);
						$doc->exportField($this->url);
					} else {
						$doc->exportField($this->apcid);
						$doc->exportField($this->grp);
						$doc->exportField($this->description);
						$doc->exportField($this->cron);
						$doc->exportField($this->next_cycle);
						$doc->exportField($this->delay);
						$doc->exportField($this->delay_method);
						$doc->exportField($this->last_updated);
						$doc->exportField($this->user_level);
						$doc->exportField($this->visible);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->status);
						$doc->exportField($this->order_by);
						$doc->exportField($this->url);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>