<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for b_account_compiled
 */
class b_account_compiled extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $grp;
	public $account_no;
	public $formal_name;
	public $balance;
	public $loan_amount;
	public $emi_amount;
	public $no_of_emi;
	public $disbursement_amount;
	public $frequency;
	public $status;
	public $end_date;
	public $due_emi;
	public $branch;
	public $mobile;
	public $_email;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'b_account_compiled';
		$this->TableName = 'b_account_compiled';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`b_account_compiled`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('b_account_compiled', 'b_account_compiled', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = TRUE; // Allow sort
		$this->fields['id'] = &$this->id;

		// grp
		$this->grp = new DbField('b_account_compiled', 'b_account_compiled', 'x_grp', 'grp', '`grp`', '`grp`', 19, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'account_grp', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`ref` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// account_no
		$this->account_no = new DbField('b_account_compiled', 'b_account_compiled', 'x_account_no', 'account_no', '`account_no`', '`account_no`', 200, -1, FALSE, '`account_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->account_no->Nullable = FALSE; // NOT NULL field
		$this->account_no->Required = TRUE; // Required field
		$this->account_no->Sortable = TRUE; // Allow sort
		$this->fields['account_no'] = &$this->account_no;

		// formal_name
		$this->formal_name = new DbField('b_account_compiled', 'b_account_compiled', 'x_formal_name', 'formal_name', '`formal_name`', '`formal_name`', 200, -1, FALSE, '`formal_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->formal_name->Sortable = TRUE; // Allow sort
		$this->fields['formal_name'] = &$this->formal_name;

		// balance
		$this->balance = new DbField('b_account_compiled', 'b_account_compiled', 'x_balance', 'balance', '`balance`', '`balance`', 131, -1, FALSE, '`balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance->Sortable = TRUE; // Allow sort
		$this->balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['balance'] = &$this->balance;

		// loan_amount
		$this->loan_amount = new DbField('b_account_compiled', 'b_account_compiled', 'x_loan_amount', 'loan_amount', '`loan_amount`', '`loan_amount`', 131, -1, FALSE, '`loan_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->loan_amount->Nullable = FALSE; // NOT NULL field
		$this->loan_amount->Required = TRUE; // Required field
		$this->loan_amount->Sortable = TRUE; // Allow sort
		$this->loan_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['loan_amount'] = &$this->loan_amount;

		// emi_amount
		$this->emi_amount = new DbField('b_account_compiled', 'b_account_compiled', 'x_emi_amount', 'emi_amount', '`emi_amount`', '`emi_amount`', 131, -1, FALSE, '`emi_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emi_amount->Nullable = FALSE; // NOT NULL field
		$this->emi_amount->Required = TRUE; // Required field
		$this->emi_amount->Sortable = TRUE; // Allow sort
		$this->emi_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['emi_amount'] = &$this->emi_amount;

		// no_of_emi
		$this->no_of_emi = new DbField('b_account_compiled', 'b_account_compiled', 'x_no_of_emi', 'no_of_emi', '`no_of_emi`', '`no_of_emi`', 18, -1, FALSE, '`no_of_emi`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->no_of_emi->Sortable = TRUE; // Allow sort
		$this->no_of_emi->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['no_of_emi'] = &$this->no_of_emi;

		// disbursement_amount
		$this->disbursement_amount = new DbField('b_account_compiled', 'b_account_compiled', 'x_disbursement_amount', 'disbursement_amount', '`disbursement_amount`', '`disbursement_amount`', 131, -1, FALSE, '`disbursement_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->disbursement_amount->Nullable = FALSE; // NOT NULL field
		$this->disbursement_amount->Required = TRUE; // Required field
		$this->disbursement_amount->Sortable = TRUE; // Allow sort
		$this->disbursement_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['disbursement_amount'] = &$this->disbursement_amount;

		// frequency
		$this->frequency = new DbField('b_account_compiled', 'b_account_compiled', 'x_frequency', 'frequency', '`frequency`', '`frequency`', 2, -1, FALSE, '`frequency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->frequency->Required = TRUE; // Required field
		$this->frequency->Sortable = TRUE; // Allow sort
		$this->frequency->Lookup = new Lookup('frequency', 'b_account_compiled', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->frequency->OptionCount = 8;
		$this->frequency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['frequency'] = &$this->frequency;

		// status
		$this->status = new DbField('b_account_compiled', 'b_account_compiled', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', '_b_status_view', TRUE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// end_date
		$this->end_date = new DbField('b_account_compiled', 'b_account_compiled', 'x_end_date', 'end_date', '`end_date`', CastDateFieldForLike('`end_date`', 0, "DB"), 133, 0, FALSE, '`end_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->end_date->Sortable = TRUE; // Allow sort
		$this->end_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['end_date'] = &$this->end_date;

		// due_emi
		$this->due_emi = new DbField('b_account_compiled', 'b_account_compiled', 'x_due_emi', 'due_emi', '`due_emi`', '`due_emi`', 20, -1, FALSE, '`due_emi`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->due_emi->Nullable = FALSE; // NOT NULL field
		$this->due_emi->Required = TRUE; // Required field
		$this->due_emi->Sortable = TRUE; // Allow sort
		$this->due_emi->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['due_emi'] = &$this->due_emi;

		// branch
		$this->branch = new DbField('b_account_compiled', 'b_account_compiled', 'x_branch', 'branch', '`branch`', '`branch`', 18, -1, FALSE, '`branch`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->branch->Required = TRUE; // Required field
		$this->branch->Sortable = TRUE; // Allow sort
		$this->branch->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->branch->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->branch->Lookup = new Lookup('branch', 'godown', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->branch->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['branch'] = &$this->branch;

		// mobile
		$this->mobile = new DbField('b_account_compiled', 'b_account_compiled', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 21, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Sortable = TRUE; // Allow sort
		$this->mobile->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mobile'] = &$this->mobile;

		// email
		$this->_email = new DbField('b_account_compiled', 'b_account_compiled', 'x__email', 'email', '`email`', '`email`', 200, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->_email->DefaultErrorMessage = $Language->phrase("IncorrectEmail");
		$this->fields['email'] = &$this->_email;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`b_account_compiled`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->grp->DbValue = $row['grp'];
		$this->account_no->DbValue = $row['account_no'];
		$this->formal_name->DbValue = $row['formal_name'];
		$this->balance->DbValue = $row['balance'];
		$this->loan_amount->DbValue = $row['loan_amount'];
		$this->emi_amount->DbValue = $row['emi_amount'];
		$this->no_of_emi->DbValue = $row['no_of_emi'];
		$this->disbursement_amount->DbValue = $row['disbursement_amount'];
		$this->frequency->DbValue = $row['frequency'];
		$this->status->DbValue = $row['status'];
		$this->end_date->DbValue = $row['end_date'];
		$this->due_emi->DbValue = $row['due_emi'];
		$this->branch->DbValue = $row['branch'];
		$this->mobile->DbValue = $row['mobile'];
		$this->_email->DbValue = $row['email'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "b_account_compiledlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "b_account_compiledview.php")
			return $Language->phrase("View");
		elseif ($pageName == "b_account_compilededit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "b_account_compiledadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "b_account_compiledlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("b_account_compiledview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("b_account_compiledview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "b_account_compiledadd.php?" . $this->getUrlParm($parm);
		else
			$url = "b_account_compiledadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("b_account_compilededit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("b_account_compiledadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("b_account_compileddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->account_no->setDbValue($rs->fields('account_no'));
		$this->formal_name->setDbValue($rs->fields('formal_name'));
		$this->balance->setDbValue($rs->fields('balance'));
		$this->loan_amount->setDbValue($rs->fields('loan_amount'));
		$this->emi_amount->setDbValue($rs->fields('emi_amount'));
		$this->no_of_emi->setDbValue($rs->fields('no_of_emi'));
		$this->disbursement_amount->setDbValue($rs->fields('disbursement_amount'));
		$this->frequency->setDbValue($rs->fields('frequency'));
		$this->status->setDbValue($rs->fields('status'));
		$this->end_date->setDbValue($rs->fields('end_date'));
		$this->due_emi->setDbValue($rs->fields('due_emi'));
		$this->branch->setDbValue($rs->fields('branch'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->_email->setDbValue($rs->fields('email'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// grp

		$this->grp->CellCssStyle = "white-space: nowrap;";

		// account_no
		// formal_name
		// balance
		// loan_amount
		// emi_amount
		// no_of_emi
		// disbursement_amount
		// frequency
		// status
		// end_date
		// due_emi
		// branch
		// mobile
		// email
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id`>9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// account_no
		$this->account_no->ViewValue = $this->account_no->CurrentValue;
		$this->account_no->ViewCustomAttributes = "";

		// formal_name
		$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
		$this->formal_name->ViewCustomAttributes = "";

		// balance
		$this->balance->ViewValue = $this->balance->CurrentValue;
		$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
		$this->balance->ViewCustomAttributes = "";

		// loan_amount
		$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
		$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
		$this->loan_amount->ViewCustomAttributes = "";

		// emi_amount
		$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
		$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
		$this->emi_amount->ViewCustomAttributes = "";

		// no_of_emi
		$this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
		$this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, 0, -2, -2, -2);
		$this->no_of_emi->ViewCustomAttributes = "";

		// disbursement_amount
		$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
		$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
		$this->disbursement_amount->ViewCustomAttributes = "";

		// frequency
		if (strval($this->frequency->CurrentValue) <> "") {
			$this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
		} else {
			$this->frequency->ViewValue = NULL;
		}
		$this->frequency->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// end_date
		$this->end_date->ViewValue = $this->end_date->CurrentValue;
		$this->end_date->ViewValue = FormatDateTime($this->end_date->ViewValue, 0);
		$this->end_date->ViewCustomAttributes = "";

		// due_emi
		$this->due_emi->ViewValue = $this->due_emi->CurrentValue;
		$this->due_emi->ViewValue = FormatNumber($this->due_emi->ViewValue, 0, -2, -2, -2);
		$this->due_emi->ViewCustomAttributes = "";

		// branch
		$curVal = strval($this->branch->CurrentValue);
		if ($curVal <> "") {
			$this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
			if ($this->branch->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 10";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->branch->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->branch->ViewValue = $this->branch->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->branch->ViewValue = $this->branch->CurrentValue;
				}
			}
		} else {
			$this->branch->ViewValue = NULL;
		}
		$this->branch->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
		$this->mobile->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// account_no
		$this->account_no->LinkCustomAttributes = "";
		$this->account_no->HrefValue = "";
		$this->account_no->TooltipValue = "";

		// formal_name
		$this->formal_name->LinkCustomAttributes = "";
		$this->formal_name->HrefValue = "";
		$this->formal_name->TooltipValue = "";

		// balance
		$this->balance->LinkCustomAttributes = "";
		$this->balance->HrefValue = "";
		$this->balance->TooltipValue = "";

		// loan_amount
		$this->loan_amount->LinkCustomAttributes = "";
		$this->loan_amount->HrefValue = "";
		$this->loan_amount->TooltipValue = "";

		// emi_amount
		$this->emi_amount->LinkCustomAttributes = "";
		$this->emi_amount->HrefValue = "";
		$this->emi_amount->TooltipValue = "";

		// no_of_emi
		$this->no_of_emi->LinkCustomAttributes = "";
		$this->no_of_emi->HrefValue = "";
		$this->no_of_emi->TooltipValue = "";

		// disbursement_amount
		$this->disbursement_amount->LinkCustomAttributes = "";
		$this->disbursement_amount->HrefValue = "";
		$this->disbursement_amount->TooltipValue = "";

		// frequency
		$this->frequency->LinkCustomAttributes = "";
		$this->frequency->HrefValue = "";
		$this->frequency->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// end_date
		$this->end_date->LinkCustomAttributes = "";
		$this->end_date->HrefValue = "";
		$this->end_date->TooltipValue = "";

		// due_emi
		$this->due_emi->LinkCustomAttributes = "";
		$this->due_emi->HrefValue = "";
		$this->due_emi->TooltipValue = "";

		// branch
		$this->branch->LinkCustomAttributes = "";
		$this->branch->HrefValue = "";
		$this->branch->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id`>9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->EditValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->EditValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// account_no
		$this->account_no->EditAttrs["class"] = "form-control";
		$this->account_no->EditCustomAttributes = "";
		$this->account_no->EditValue = $this->account_no->CurrentValue;
		$this->account_no->ViewCustomAttributes = "";

		// formal_name
		$this->formal_name->EditAttrs["class"] = "form-control";
		$this->formal_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
		$this->formal_name->EditValue = $this->formal_name->CurrentValue;
		$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

		// balance
		$this->balance->EditAttrs["class"] = "form-control";
		$this->balance->EditCustomAttributes = "";
		$this->balance->EditValue = $this->balance->CurrentValue;
		$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
		if (strval($this->balance->EditValue) <> "" && is_numeric($this->balance->EditValue))
			$this->balance->EditValue = FormatNumber($this->balance->EditValue, -2, -2, -2, -2);

		// loan_amount
		$this->loan_amount->EditAttrs["class"] = "form-control";
		$this->loan_amount->EditCustomAttributes = "";
		$this->loan_amount->EditValue = $this->loan_amount->CurrentValue;
		$this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());
		if (strval($this->loan_amount->EditValue) <> "" && is_numeric($this->loan_amount->EditValue))
			$this->loan_amount->EditValue = FormatNumber($this->loan_amount->EditValue, -2, -2, -2, -2);

		// emi_amount
		$this->emi_amount->EditAttrs["class"] = "form-control";
		$this->emi_amount->EditCustomAttributes = "";
		$this->emi_amount->EditValue = $this->emi_amount->CurrentValue;
		$this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());
		if (strval($this->emi_amount->EditValue) <> "" && is_numeric($this->emi_amount->EditValue))
			$this->emi_amount->EditValue = FormatNumber($this->emi_amount->EditValue, -2, -2, -2, -2);

		// no_of_emi
		$this->no_of_emi->EditAttrs["class"] = "form-control";
		$this->no_of_emi->EditCustomAttributes = "";
		$this->no_of_emi->EditValue = $this->no_of_emi->CurrentValue;
		$this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

		// disbursement_amount
		$this->disbursement_amount->EditAttrs["class"] = "form-control";
		$this->disbursement_amount->EditCustomAttributes = "";
		$this->disbursement_amount->EditValue = $this->disbursement_amount->CurrentValue;
		$this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());
		if (strval($this->disbursement_amount->EditValue) <> "" && is_numeric($this->disbursement_amount->EditValue))
			$this->disbursement_amount->EditValue = FormatNumber($this->disbursement_amount->EditValue, -2, -2, -2, -2);

		// frequency
		$this->frequency->EditCustomAttributes = "";
		$this->frequency->EditValue = $this->frequency->options(FALSE);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// end_date
		$this->end_date->EditAttrs["class"] = "form-control";
		$this->end_date->EditCustomAttributes = "";
		$this->end_date->EditValue = FormatDateTime($this->end_date->CurrentValue, 8);
		$this->end_date->PlaceHolder = RemoveHtml($this->end_date->caption());

		// due_emi
		$this->due_emi->EditAttrs["class"] = "form-control";
		$this->due_emi->EditCustomAttributes = "";
		$this->due_emi->EditValue = $this->due_emi->CurrentValue;
		$this->due_emi->PlaceHolder = RemoveHtml($this->due_emi->caption());

		// branch
		$this->branch->EditAttrs["class"] = "form-control";
		$this->branch->EditCustomAttributes = "";

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->balance->CurrentValue))
				$this->balance->Total += $this->balance->CurrentValue; // Accumulate total
			if (is_numeric($this->loan_amount->CurrentValue))
				$this->loan_amount->Total += $this->loan_amount->CurrentValue; // Accumulate total
			if (is_numeric($this->emi_amount->CurrentValue))
				$this->emi_amount->Total += $this->emi_amount->CurrentValue; // Accumulate total
			if (is_numeric($this->disbursement_amount->CurrentValue))
				$this->disbursement_amount->Total += $this->disbursement_amount->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->balance->CurrentValue = $this->balance->Total;
			$this->balance->ViewValue = $this->balance->CurrentValue;
			$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
			$this->balance->ViewCustomAttributes = "";
			$this->balance->HrefValue = ""; // Clear href value
			$this->loan_amount->CurrentValue = $this->loan_amount->Total;
			$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
			$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
			$this->loan_amount->ViewCustomAttributes = "";
			$this->loan_amount->HrefValue = ""; // Clear href value
			$this->emi_amount->CurrentValue = $this->emi_amount->Total;
			$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
			$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
			$this->emi_amount->ViewCustomAttributes = "";
			$this->emi_amount->HrefValue = ""; // Clear href value
			$this->disbursement_amount->CurrentValue = $this->disbursement_amount->Total;
			$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
			$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
			$this->disbursement_amount->ViewCustomAttributes = "";
			$this->disbursement_amount->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->account_no);
					$doc->exportCaption($this->formal_name);
					$doc->exportCaption($this->balance);
					$doc->exportCaption($this->loan_amount);
					$doc->exportCaption($this->emi_amount);
					$doc->exportCaption($this->no_of_emi);
					$doc->exportCaption($this->disbursement_amount);
					$doc->exportCaption($this->frequency);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->end_date);
					$doc->exportCaption($this->due_emi);
					$doc->exportCaption($this->branch);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->account_no);
					$doc->exportCaption($this->formal_name);
					$doc->exportCaption($this->balance);
					$doc->exportCaption($this->loan_amount);
					$doc->exportCaption($this->emi_amount);
					$doc->exportCaption($this->no_of_emi);
					$doc->exportCaption($this->disbursement_amount);
					$doc->exportCaption($this->frequency);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->end_date);
					$doc->exportCaption($this->due_emi);
					$doc->exportCaption($this->branch);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->account_no);
						$doc->exportField($this->formal_name);
						$doc->exportField($this->balance);
						$doc->exportField($this->loan_amount);
						$doc->exportField($this->emi_amount);
						$doc->exportField($this->no_of_emi);
						$doc->exportField($this->disbursement_amount);
						$doc->exportField($this->frequency);
						$doc->exportField($this->status);
						$doc->exportField($this->end_date);
						$doc->exportField($this->due_emi);
						$doc->exportField($this->branch);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->account_no);
						$doc->exportField($this->formal_name);
						$doc->exportField($this->balance);
						$doc->exportField($this->loan_amount);
						$doc->exportField($this->emi_amount);
						$doc->exportField($this->no_of_emi);
						$doc->exportField($this->disbursement_amount);
						$doc->exportField($this->frequency);
						$doc->exportField($this->status);
						$doc->exportField($this->end_date);
						$doc->exportField($this->due_emi);
						$doc->exportField($this->branch);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->account_no, '');
				$doc->exportAggregate($this->formal_name, '');
				$doc->exportAggregate($this->balance, 'TOTAL');
				$doc->exportAggregate($this->loan_amount, 'TOTAL');
				$doc->exportAggregate($this->emi_amount, 'TOTAL');
				$doc->exportAggregate($this->no_of_emi, '');
				$doc->exportAggregate($this->disbursement_amount, 'TOTAL');
				$doc->exportAggregate($this->frequency, '');
				$doc->exportAggregate($this->status, '');
				$doc->exportAggregate($this->end_date, '');
				$doc->exportAggregate($this->due_emi, '');
				$doc->exportAggregate($this->branch, '');
				$doc->exportAggregate($this->mobile, '');
				$doc->exportAggregate($this->_email, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>