<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for b_account_info_agent
 */
class b_account_info_agent extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $b_type;
	public $grp;
	public $account_type;
	public $aadhaar_no;
	public $account_no;
	public $formal_name;
	public $mobile;
	public $_email;
	public $image;
	public $status;
	public $pan_no;
	public $id_proof;
	public $agent;
	public $other_details;
	public $loan_amount;
	public $int_40;
	public $disbursement_amount;
	public $emi_amount;
	public $no_of_emi;
	public $frequency;
	public $operator;
	public $datetime;
	public $otp;
	public $otp_delivery_datetime;
	public $otp_verify_datetime;
	public $fund_o;
	public $fund_o_no;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'b_account_info_agent';
		$this->TableName = 'b_account_info_agent';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`b_account_info_agent`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->fields['id'] = &$this->id;

		// b_type
		$this->b_type = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_b_type', 'b_type', '`b_type`', '`b_type`', 17, -1, FALSE, '`b_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->b_type->Nullable = FALSE; // NOT NULL field
		$this->b_type->Sortable = TRUE; // Allow sort
		$this->b_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->b_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->b_type->Lookup = new Lookup('b_type', 'b_account_info_agent', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->b_type->OptionCount = 2;
		$this->b_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['b_type'] = &$this->b_type;

		// grp
		$this->grp = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_grp', 'grp', '`grp`', '`grp`', 19, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'account_grp', FALSE, 'id', ["item","","",""], [], ["x_account_type"], [], [], [], [], '`item` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// account_type
		$this->account_type = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_account_type', 'account_type', '`account_type`', '`account_type`', 2, -1, FALSE, '`account_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->account_type->Sortable = TRUE; // Allow sort
		$this->account_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->account_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->account_type->Lookup = new Lookup('account_type', 'b_account_type', FALSE, 'id', ["code","description","",""], ["x_grp"], [], ["s_grp"], ["x_s_grp"], ["maximum","int_@","no_of_emi","repay_frequency"], ["x_loan_amount","x_int_40","x_no_of_emi","x_frequency"], '`code` ASC', '');
		$this->account_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['account_type'] = &$this->account_type;

		// aadhaar_no
		$this->aadhaar_no = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_aadhaar_no', 'aadhaar_no', '`aadhaar_no`', '`aadhaar_no`', 200, -1, FALSE, '`aadhaar_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->aadhaar_no->Required = TRUE; // Required field
		$this->aadhaar_no->Sortable = TRUE; // Allow sort
		$this->aadhaar_no->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['aadhaar_no'] = &$this->aadhaar_no;

		// account_no
		$this->account_no = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_account_no', 'account_no', '`account_no`', '`account_no`', 200, -1, FALSE, '`account_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->account_no->Nullable = FALSE; // NOT NULL field
		$this->account_no->Required = TRUE; // Required field
		$this->account_no->Sortable = TRUE; // Allow sort
		$this->fields['account_no'] = &$this->account_no;

		// formal_name
		$this->formal_name = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_formal_name', 'formal_name', '`formal_name`', '`formal_name`', 200, -1, FALSE, '`formal_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->formal_name->Required = TRUE; // Required field
		$this->formal_name->Sortable = TRUE; // Allow sort
		$this->fields['formal_name'] = &$this->formal_name;

		// mobile
		$this->mobile = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 21, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Required = TRUE; // Required field
		$this->mobile->Sortable = TRUE; // Allow sort
		$this->mobile->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['mobile'] = &$this->mobile;

		// email
		$this->_email = new DbField('b_account_info_agent', 'b_account_info_agent', 'x__email', 'email', '`email`', '`email`', 200, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->_email->DefaultErrorMessage = $Language->phrase("IncorrectEmail");
		$this->fields['email'] = &$this->_email;

		// image
		$this->image = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_image', 'image', '`image`', '`image`', 200, -1, TRUE, '`image`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->image->Sortable = TRUE; // Allow sort
		$this->fields['image'] = &$this->image;

		// status
		$this->status = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->Lookup = new Lookup('status', '_b_status_view', TRUE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// pan_no
		$this->pan_no = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_pan_no', 'pan_no', '`pan_no`', '`pan_no`', 200, -1, FALSE, '`pan_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan_no->Sortable = TRUE; // Allow sort
		$this->pan_no->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['pan_no'] = &$this->pan_no;

		// id_proof
		$this->id_proof = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_id_proof', 'id_proof', '`id_proof`', '`id_proof`', 200, -1, TRUE, '`id_proof`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->id_proof->Sortable = TRUE; // Allow sort
		$this->id_proof->UploadMultiple = TRUE;
		$this->id_proof->Upload->UploadMultiple = TRUE;
		$this->id_proof->UploadMaxFileCount = 0;
		$this->fields['id_proof'] = &$this->id_proof;

		// agent
		$this->agent = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_agent', 'agent', '`agent`', '`agent`', 200, -1, FALSE, '`agent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->agent->Sortable = TRUE; // Allow sort
		$this->agent->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->agent->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->agent->Lookup = new Lookup('agent', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->fields['agent'] = &$this->agent;

		// other_details
		$this->other_details = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_other_details', 'other_details', '`other_details`', '`other_details`', 201, -1, FALSE, '`other_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->other_details->Sortable = TRUE; // Allow sort
		$this->fields['other_details'] = &$this->other_details;

		// loan_amount
		$this->loan_amount = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_loan_amount', 'loan_amount', '`loan_amount`', '`loan_amount`', 131, -1, FALSE, '`loan_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->loan_amount->Nullable = FALSE; // NOT NULL field
		$this->loan_amount->Required = TRUE; // Required field
		$this->loan_amount->Sortable = TRUE; // Allow sort
		$this->loan_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['loan_amount'] = &$this->loan_amount;

		// int_@
		$this->int_40 = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_int_40', 'int_@', '`int_@`', '`int_@`', 131, -1, FALSE, '`int_@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->int_40->Sortable = TRUE; // Allow sort
		$this->int_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['int_@'] = &$this->int_40;

		// disbursement_amount
		$this->disbursement_amount = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_disbursement_amount', 'disbursement_amount', '`disbursement_amount`', '`disbursement_amount`', 131, -1, FALSE, '`disbursement_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->disbursement_amount->Nullable = FALSE; // NOT NULL field
		$this->disbursement_amount->Required = TRUE; // Required field
		$this->disbursement_amount->Sortable = TRUE; // Allow sort
		$this->disbursement_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['disbursement_amount'] = &$this->disbursement_amount;

		// emi_amount
		$this->emi_amount = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_emi_amount', 'emi_amount', '`emi_amount`', '`emi_amount`', 131, -1, FALSE, '`emi_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emi_amount->Nullable = FALSE; // NOT NULL field
		$this->emi_amount->Required = TRUE; // Required field
		$this->emi_amount->Sortable = TRUE; // Allow sort
		$this->emi_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['emi_amount'] = &$this->emi_amount;

		// no_of_emi
		$this->no_of_emi = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_no_of_emi', 'no_of_emi', '`no_of_emi`', '`no_of_emi`', 18, -1, FALSE, '`no_of_emi`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->no_of_emi->Sortable = TRUE; // Allow sort
		$this->no_of_emi->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['no_of_emi'] = &$this->no_of_emi;

		// frequency
		$this->frequency = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_frequency', 'frequency', '`frequency`', '`frequency`', 2, -1, FALSE, '`frequency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->frequency->Required = TRUE; // Required field
		$this->frequency->Sortable = TRUE; // Allow sort
		$this->frequency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->frequency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->frequency->Lookup = new Lookup('frequency', 'b_account_info_agent', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->frequency->OptionCount = 8;
		$this->frequency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['frequency'] = &$this->frequency;

		// operator
		$this->operator = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// otp
		$this->otp = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_otp', 'otp', '`otp`', '`otp`', 3, -1, FALSE, '`otp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->otp->Sortable = FALSE; // Allow sort
		$this->otp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['otp'] = &$this->otp;

		// otp_delivery_datetime
		$this->otp_delivery_datetime = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_otp_delivery_datetime', 'otp_delivery_datetime', '`otp_delivery_datetime`', CastDateFieldForLike('`otp_delivery_datetime`', 0, "DB"), 135, 0, FALSE, '`otp_delivery_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->otp_delivery_datetime->Sortable = FALSE; // Allow sort
		$this->otp_delivery_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['otp_delivery_datetime'] = &$this->otp_delivery_datetime;

		// otp_verify_datetime
		$this->otp_verify_datetime = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_otp_verify_datetime', 'otp_verify_datetime', '`otp_verify_datetime`', CastDateFieldForLike('`otp_verify_datetime`', 0, "DB"), 135, 0, FALSE, '`otp_verify_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->otp_verify_datetime->Sortable = FALSE; // Allow sort
		$this->otp_verify_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['otp_verify_datetime'] = &$this->otp_verify_datetime;

		// fund_o
		$this->fund_o = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_fund_o', 'fund_o', '`fund_o`', '`fund_o`', 131, -1, FALSE, '`fund_o`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fund_o->Sortable = FALSE; // Allow sort
		$this->fund_o->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['fund_o'] = &$this->fund_o;

		// fund_o_no
		$this->fund_o_no = new DbField('b_account_info_agent', 'b_account_info_agent', 'x_fund_o_no', 'fund_o_no', '`fund_o_no`', '`fund_o_no`', 200, -1, FALSE, '`fund_o_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fund_o_no->Sortable = FALSE; // Allow sort
		$this->fund_o_no->Lookup = new Lookup('fund_o_no', 'b_account_info_agent', FALSE, 'id', ["formal_name","aadhaar_no","",""], [], [], [], [], [], [], '`formal_name` ASC', '');
		$this->fields['fund_o_no'] = &$this->fund_o_no;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`b_account_info_agent`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Site() == 0) ? "" : "`agent` = " . CurrentUserID() ." and `status` < 121";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		global $Security;

		// Add User ID filter
		if ($Security->currentUserID() <> "" && !$Security->isAdmin()) { // Non system admin
			$filter = $this->addUserIDFilter($filter);
		}
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->b_type->DbValue = $row['b_type'];
		$this->grp->DbValue = $row['grp'];
		$this->account_type->DbValue = $row['account_type'];
		$this->aadhaar_no->DbValue = $row['aadhaar_no'];
		$this->account_no->DbValue = $row['account_no'];
		$this->formal_name->DbValue = $row['formal_name'];
		$this->mobile->DbValue = $row['mobile'];
		$this->_email->DbValue = $row['email'];
		$this->image->Upload->DbValue = $row['image'];
		$this->status->DbValue = $row['status'];
		$this->pan_no->DbValue = $row['pan_no'];
		$this->id_proof->Upload->DbValue = $row['id_proof'];
		$this->agent->DbValue = $row['agent'];
		$this->other_details->DbValue = $row['other_details'];
		$this->loan_amount->DbValue = $row['loan_amount'];
		$this->int_40->DbValue = $row['int_@'];
		$this->disbursement_amount->DbValue = $row['disbursement_amount'];
		$this->emi_amount->DbValue = $row['emi_amount'];
		$this->no_of_emi->DbValue = $row['no_of_emi'];
		$this->frequency->DbValue = $row['frequency'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->otp->DbValue = $row['otp'];
		$this->otp_delivery_datetime->DbValue = $row['otp_delivery_datetime'];
		$this->otp_verify_datetime->DbValue = $row['otp_verify_datetime'];
		$this->fund_o->DbValue = $row['fund_o'];
		$this->fund_o_no->DbValue = $row['fund_o_no'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->image->OldUploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
		$oldFiles = EmptyValue($row['image']) ? [] : [$row['image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
		}
		$this->id_proof->OldUploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
		$oldFiles = EmptyValue($row['id_proof']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['id_proof']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->id_proof->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->id_proof->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "b_account_info_agentlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "b_account_info_agentview.php")
			return $Language->phrase("View");
		elseif ($pageName == "b_account_info_agentedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "b_account_info_agentadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "b_account_info_agentlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("b_account_info_agentview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("b_account_info_agentview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "b_account_info_agentadd.php?" . $this->getUrlParm($parm);
		else
			$url = "b_account_info_agentadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("b_account_info_agentedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("b_account_info_agentadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("b_account_info_agentdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->b_type->setDbValue($rs->fields('b_type'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->account_type->setDbValue($rs->fields('account_type'));
		$this->aadhaar_no->setDbValue($rs->fields('aadhaar_no'));
		$this->account_no->setDbValue($rs->fields('account_no'));
		$this->formal_name->setDbValue($rs->fields('formal_name'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->_email->setDbValue($rs->fields('email'));
		$this->image->Upload->DbValue = $rs->fields('image');
		$this->status->setDbValue($rs->fields('status'));
		$this->pan_no->setDbValue($rs->fields('pan_no'));
		$this->id_proof->Upload->DbValue = $rs->fields('id_proof');
		$this->agent->setDbValue($rs->fields('agent'));
		$this->other_details->setDbValue($rs->fields('other_details'));
		$this->loan_amount->setDbValue($rs->fields('loan_amount'));
		$this->int_40->setDbValue($rs->fields('int_@'));
		$this->disbursement_amount->setDbValue($rs->fields('disbursement_amount'));
		$this->emi_amount->setDbValue($rs->fields('emi_amount'));
		$this->no_of_emi->setDbValue($rs->fields('no_of_emi'));
		$this->frequency->setDbValue($rs->fields('frequency'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->otp->setDbValue($rs->fields('otp'));
		$this->otp_delivery_datetime->setDbValue($rs->fields('otp_delivery_datetime'));
		$this->otp_verify_datetime->setDbValue($rs->fields('otp_verify_datetime'));
		$this->fund_o->setDbValue($rs->fields('fund_o'));
		$this->fund_o_no->setDbValue($rs->fields('fund_o_no'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// b_type
		// grp
		// account_type
		// aadhaar_no
		// account_no
		// formal_name
		// mobile
		// email
		// image
		// status
		// pan_no
		// id_proof
		// agent
		// other_details
		// loan_amount
		// int_@
		// disbursement_amount
		// emi_amount
		// no_of_emi
		// frequency
		// operator
		// datetime
		// otp

		$this->otp->CellCssStyle = "white-space: nowrap;";

		// otp_delivery_datetime
		$this->otp_delivery_datetime->CellCssStyle = "white-space: nowrap;";

		// otp_verify_datetime
		$this->otp_verify_datetime->CellCssStyle = "white-space: nowrap;";

		// fund_o
		$this->fund_o->CellCssStyle = "white-space: nowrap;";

		// fund_o_no
		$this->fund_o_no->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// b_type
		if (strval($this->b_type->CurrentValue) <> "") {
			$this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
		} else {
			$this->b_type->ViewValue = NULL;
		}
		$this->b_type->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=1301";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// account_type
		$curVal = strval($this->account_type->CurrentValue);
		if ($curVal <> "") {
			$this->account_type->ViewValue = $this->account_type->lookupCacheOption($curVal);
			if ($this->account_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->account_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->account_type->ViewValue = $this->account_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->account_type->ViewValue = $this->account_type->CurrentValue;
				}
			}
		} else {
			$this->account_type->ViewValue = NULL;
		}
		$this->account_type->ViewCustomAttributes = "";

		// aadhaar_no
		$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->ViewCustomAttributes = "";

		// account_no
		$this->account_no->ViewValue = $this->account_no->CurrentValue;
		$this->account_no->ViewCustomAttributes = "";

		// formal_name
		$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
		$this->formal_name->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
		$this->mobile->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// image
		$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ViewValue = $this->image->Upload->DbValue;
		} else {
			$this->image->ViewValue = "";
		}
		$this->image->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// pan_no
		$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
		$this->pan_no->ViewCustomAttributes = "";

		// id_proof
		$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
		if (!EmptyValue($this->id_proof->Upload->DbValue)) {
			$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
		} else {
			$this->id_proof->ViewValue = "";
		}
		$this->id_proof->ViewCustomAttributes = "";

		// agent
		$curVal = strval($this->agent->CurrentValue);
		if ($curVal <> "") {
			$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
			if ($this->agent->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`userlevel`=1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->agent->ViewValue = $this->agent->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->agent->ViewValue = $this->agent->CurrentValue;
				}
			}
		} else {
			$this->agent->ViewValue = NULL;
		}
		$this->agent->ViewCustomAttributes = "";

		// other_details
		$this->other_details->ViewValue = $this->other_details->CurrentValue;
		$this->other_details->ViewCustomAttributes = "";

		// loan_amount
		$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
		$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
		$this->loan_amount->ViewCustomAttributes = "";

		// int_@
		$this->int_40->ViewValue = $this->int_40->CurrentValue;
		$this->int_40->ViewValue = FormatNumber($this->int_40->ViewValue, 2, -2, -2, -2);
		$this->int_40->ViewCustomAttributes = "";

		// disbursement_amount
		$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
		$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
		$this->disbursement_amount->ViewCustomAttributes = "";

		// emi_amount
		$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
		$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
		$this->emi_amount->ViewCustomAttributes = "";

		// no_of_emi
		$this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
		$this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, 0, -2, -2, -2);
		$this->no_of_emi->ViewCustomAttributes = "";

		// frequency
		if (strval($this->frequency->CurrentValue) <> "") {
			$this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
		} else {
			$this->frequency->ViewValue = NULL;
		}
		$this->frequency->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// otp
		$this->otp->ViewValue = $this->otp->CurrentValue;
		$this->otp->ViewValue = FormatNumber($this->otp->ViewValue, 0, -2, -2, -2);
		$this->otp->ViewCustomAttributes = "";

		// otp_delivery_datetime
		$this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
		$this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, 0);
		$this->otp_delivery_datetime->ViewCustomAttributes = "";

		// otp_verify_datetime
		$this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
		$this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, 0);
		$this->otp_verify_datetime->ViewCustomAttributes = "";

		// fund_o
		$this->fund_o->ViewValue = $this->fund_o->CurrentValue;
		$this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, 2, -2, -2, -2);
		$this->fund_o->ViewCustomAttributes = "";

		// fund_o_no
		$this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
		$curVal = strval($this->fund_o_no->CurrentValue);
		if ($curVal <> "") {
			$this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
			if ($this->fund_o_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`= 230401";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->fund_o_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
				}
			}
		} else {
			$this->fund_o_no->ViewValue = NULL;
		}
		$this->fund_o_no->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// b_type
		$this->b_type->LinkCustomAttributes = "";
		$this->b_type->HrefValue = "";
		$this->b_type->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// account_type
		$this->account_type->LinkCustomAttributes = "";
		$this->account_type->HrefValue = "";
		$this->account_type->TooltipValue = "";

		// aadhaar_no
		$this->aadhaar_no->LinkCustomAttributes = "";
		$this->aadhaar_no->HrefValue = "";
		$this->aadhaar_no->TooltipValue = "";

		// account_no
		$this->account_no->LinkCustomAttributes = "";
		$this->account_no->HrefValue = "";
		$this->account_no->TooltipValue = "";

		// formal_name
		$this->formal_name->LinkCustomAttributes = "";
		$this->formal_name->HrefValue = "";
		$this->formal_name->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->HrefValue = "";
		$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		$this->image->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// pan_no
		$this->pan_no->LinkCustomAttributes = "";
		$this->pan_no->HrefValue = "";
		$this->pan_no->TooltipValue = "";

		// id_proof
		$this->id_proof->LinkCustomAttributes = "";
		$this->id_proof->HrefValue = "";
		$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
		$this->id_proof->TooltipValue = "";

		// agent
		$this->agent->LinkCustomAttributes = "";
		$this->agent->HrefValue = "";
		$this->agent->TooltipValue = "";

		// other_details
		$this->other_details->LinkCustomAttributes = "";
		$this->other_details->HrefValue = "";
		$this->other_details->TooltipValue = "";

		// loan_amount
		$this->loan_amount->LinkCustomAttributes = "";
		$this->loan_amount->HrefValue = "";
		$this->loan_amount->TooltipValue = "";

		// int_@
		$this->int_40->LinkCustomAttributes = "";
		$this->int_40->HrefValue = "";
		$this->int_40->TooltipValue = "";

		// disbursement_amount
		$this->disbursement_amount->LinkCustomAttributes = "";
		$this->disbursement_amount->HrefValue = "";
		$this->disbursement_amount->TooltipValue = "";

		// emi_amount
		$this->emi_amount->LinkCustomAttributes = "";
		$this->emi_amount->HrefValue = "";
		$this->emi_amount->TooltipValue = "";

		// no_of_emi
		$this->no_of_emi->LinkCustomAttributes = "";
		$this->no_of_emi->HrefValue = "";
		$this->no_of_emi->TooltipValue = "";

		// frequency
		$this->frequency->LinkCustomAttributes = "";
		$this->frequency->HrefValue = "";
		$this->frequency->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// otp
		$this->otp->LinkCustomAttributes = "";
		$this->otp->HrefValue = "";
		$this->otp->TooltipValue = "";

		// otp_delivery_datetime
		$this->otp_delivery_datetime->LinkCustomAttributes = "";
		$this->otp_delivery_datetime->HrefValue = "";
		$this->otp_delivery_datetime->TooltipValue = "";

		// otp_verify_datetime
		$this->otp_verify_datetime->LinkCustomAttributes = "";
		$this->otp_verify_datetime->HrefValue = "";
		$this->otp_verify_datetime->TooltipValue = "";

		// fund_o
		$this->fund_o->LinkCustomAttributes = "";
		$this->fund_o->HrefValue = "";
		$this->fund_o->TooltipValue = "";

		// fund_o_no
		$this->fund_o_no->LinkCustomAttributes = "";
		$this->fund_o_no->HrefValue = "";
		$this->fund_o_no->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// b_type
		$this->b_type->EditAttrs["class"] = "form-control";
		$this->b_type->EditCustomAttributes = "";
		$this->b_type->EditValue = $this->b_type->options(TRUE);

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=1301";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->EditValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->EditValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// account_type
		$this->account_type->EditAttrs["class"] = "form-control";
		$this->account_type->EditCustomAttributes = "";

		// aadhaar_no
		$this->aadhaar_no->EditAttrs["class"] = "form-control";
		$this->aadhaar_no->EditCustomAttributes = "";
		$this->aadhaar_no->EditValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->ViewCustomAttributes = "";

		// account_no
		$this->account_no->EditAttrs["class"] = "form-control";
		$this->account_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->account_no->CurrentValue = HtmlDecode($this->account_no->CurrentValue);
		$this->account_no->EditValue = $this->account_no->CurrentValue;
		$this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

		// formal_name
		$this->formal_name->EditAttrs["class"] = "form-control";
		$this->formal_name->EditCustomAttributes = "";
		$this->formal_name->EditValue = $this->formal_name->CurrentValue;
		$this->formal_name->ViewCustomAttributes = "";

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->EditValue = FormatNumber($this->mobile->EditValue, 0, -2, -2, -2);
		$this->mobile->ViewCustomAttributes = "";

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->EditValue = $this->image->Upload->DbValue;
		} else {
			$this->image->EditValue = "";
		}
		if (!EmptyValue($this->image->CurrentValue))
				$this->image->Upload->FileName = $this->image->CurrentValue;

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = 'ReadOnly';
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// pan_no
		$this->pan_no->EditAttrs["class"] = "form-control";
		$this->pan_no->EditCustomAttributes = "";
		$this->pan_no->EditValue = $this->pan_no->CurrentValue;
		$this->pan_no->ViewCustomAttributes = "";

		// id_proof
		$this->id_proof->EditAttrs["class"] = "form-control";
		$this->id_proof->EditCustomAttributes = "";
		$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
		if (!EmptyValue($this->id_proof->Upload->DbValue)) {
			$this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
		} else {
			$this->id_proof->EditValue = "";
		}
		if (!EmptyValue($this->id_proof->CurrentValue))
				$this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;

		// agent
		$this->agent->EditAttrs["class"] = "form-control";
		$this->agent->EditCustomAttributes = "";
		if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("info")) { // Non system admin
		} else {
		}

		// other_details
		$this->other_details->EditAttrs["class"] = "form-control";
		$this->other_details->EditCustomAttributes = "";
		$this->other_details->EditValue = $this->other_details->CurrentValue;
		$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

		// loan_amount
		$this->loan_amount->EditAttrs["class"] = "form-control";
		$this->loan_amount->EditCustomAttributes = "";
		$this->loan_amount->EditValue = $this->loan_amount->CurrentValue;
		$this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());
		if (strval($this->loan_amount->EditValue) <> "" && is_numeric($this->loan_amount->EditValue))
			$this->loan_amount->EditValue = FormatNumber($this->loan_amount->EditValue, -2, -2, -2, -2);

		// int_@
		$this->int_40->EditAttrs["class"] = "form-control";
		$this->int_40->EditCustomAttributes = "";
		$this->int_40->EditValue = $this->int_40->CurrentValue;
		$this->int_40->PlaceHolder = RemoveHtml($this->int_40->caption());
		if (strval($this->int_40->EditValue) <> "" && is_numeric($this->int_40->EditValue))
			$this->int_40->EditValue = FormatNumber($this->int_40->EditValue, -2, -2, -2, -2);

		// disbursement_amount
		$this->disbursement_amount->EditAttrs["class"] = "form-control";
		$this->disbursement_amount->EditCustomAttributes = "";
		$this->disbursement_amount->EditValue = $this->disbursement_amount->CurrentValue;
		$this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());
		if (strval($this->disbursement_amount->EditValue) <> "" && is_numeric($this->disbursement_amount->EditValue))
			$this->disbursement_amount->EditValue = FormatNumber($this->disbursement_amount->EditValue, -2, -2, -2, -2);

		// emi_amount
		$this->emi_amount->EditAttrs["class"] = "form-control";
		$this->emi_amount->EditCustomAttributes = "";
		$this->emi_amount->EditValue = $this->emi_amount->CurrentValue;
		$this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());
		if (strval($this->emi_amount->EditValue) <> "" && is_numeric($this->emi_amount->EditValue))
			$this->emi_amount->EditValue = FormatNumber($this->emi_amount->EditValue, -2, -2, -2, -2);

		// no_of_emi
		$this->no_of_emi->EditAttrs["class"] = "form-control";
		$this->no_of_emi->EditCustomAttributes = "";
		$this->no_of_emi->EditValue = $this->no_of_emi->CurrentValue;
		$this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

		// frequency
		$this->frequency->EditAttrs["class"] = "form-control";
		$this->frequency->EditCustomAttributes = "";
		$this->frequency->EditValue = $this->frequency->options(TRUE);

		// operator
		// datetime
		// otp

		$this->otp->EditAttrs["class"] = "form-control";
		$this->otp->EditCustomAttributes = "";
		$this->otp->EditValue = $this->otp->CurrentValue;
		$this->otp->PlaceHolder = RemoveHtml($this->otp->caption());

		// otp_delivery_datetime
		$this->otp_delivery_datetime->EditAttrs["class"] = "form-control";
		$this->otp_delivery_datetime->EditCustomAttributes = "";
		$this->otp_delivery_datetime->EditValue = FormatDateTime($this->otp_delivery_datetime->CurrentValue, 8);
		$this->otp_delivery_datetime->PlaceHolder = RemoveHtml($this->otp_delivery_datetime->caption());

		// otp_verify_datetime
		$this->otp_verify_datetime->EditAttrs["class"] = "form-control";
		$this->otp_verify_datetime->EditCustomAttributes = "";
		$this->otp_verify_datetime->EditValue = FormatDateTime($this->otp_verify_datetime->CurrentValue, 8);
		$this->otp_verify_datetime->PlaceHolder = RemoveHtml($this->otp_verify_datetime->caption());

		// fund_o
		$this->fund_o->EditAttrs["class"] = "form-control";
		$this->fund_o->EditCustomAttributes = "";
		$this->fund_o->EditValue = $this->fund_o->CurrentValue;
		$this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());
		if (strval($this->fund_o->EditValue) <> "" && is_numeric($this->fund_o->EditValue))
			$this->fund_o->EditValue = FormatNumber($this->fund_o->EditValue, -2, -2, -2, -2);

		// fund_o_no
		$this->fund_o_no->EditAttrs["class"] = "form-control";
		$this->fund_o_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->fund_o_no->CurrentValue = HtmlDecode($this->fund_o_no->CurrentValue);
		$this->fund_o_no->EditValue = $this->fund_o_no->CurrentValue;
		$this->fund_o_no->PlaceHolder = RemoveHtml($this->fund_o_no->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->b_type);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->account_type);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->account_no);
					$doc->exportCaption($this->formal_name);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->id_proof);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->other_details);
					$doc->exportCaption($this->loan_amount);
					$doc->exportCaption($this->int_40);
					$doc->exportCaption($this->disbursement_amount);
					$doc->exportCaption($this->emi_amount);
					$doc->exportCaption($this->no_of_emi);
					$doc->exportCaption($this->frequency);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->otp_delivery_datetime);
					$doc->exportCaption($this->otp_verify_datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->b_type);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->account_type);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->account_no);
					$doc->exportCaption($this->formal_name);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->id_proof);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->loan_amount);
					$doc->exportCaption($this->int_40);
					$doc->exportCaption($this->disbursement_amount);
					$doc->exportCaption($this->emi_amount);
					$doc->exportCaption($this->no_of_emi);
					$doc->exportCaption($this->frequency);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->otp_delivery_datetime);
					$doc->exportCaption($this->otp_verify_datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->b_type);
						$doc->exportField($this->grp);
						$doc->exportField($this->account_type);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->account_no);
						$doc->exportField($this->formal_name);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->image);
						$doc->exportField($this->status);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->id_proof);
						$doc->exportField($this->agent);
						$doc->exportField($this->other_details);
						$doc->exportField($this->loan_amount);
						$doc->exportField($this->int_40);
						$doc->exportField($this->disbursement_amount);
						$doc->exportField($this->emi_amount);
						$doc->exportField($this->no_of_emi);
						$doc->exportField($this->frequency);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->otp_delivery_datetime);
						$doc->exportField($this->otp_verify_datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->b_type);
						$doc->exportField($this->grp);
						$doc->exportField($this->account_type);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->account_no);
						$doc->exportField($this->formal_name);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->image);
						$doc->exportField($this->status);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->id_proof);
						$doc->exportField($this->agent);
						$doc->exportField($this->loan_amount);
						$doc->exportField($this->int_40);
						$doc->exportField($this->disbursement_amount);
						$doc->exportField($this->emi_amount);
						$doc->exportField($this->no_of_emi);
						$doc->exportField($this->frequency);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->otp_delivery_datetime);
						$doc->exportField($this->otp_verify_datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Add User ID filter
	public function addUserIDFilter($filter = "")
	{
		global $Security;
		$filterWrk = "";
		$id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
		if (!$this->userIdAllow($id) && !$Security->isAdmin()) {
			$filterWrk = $Security->userIdList();
			if ($filterWrk <> "")
				$filterWrk = '`agent` IN (' . $filterWrk . ')';
		}

		// Call User ID Filtering event
		$this->UserID_Filtering($filterWrk);
		AddFilter($filter, $filterWrk);
		return $filter;
	}

	// User ID subquery
	public function getUserIDSubquery(&$fld, &$masterfld)
	{
		global $UserTableConn;
		$wrk = "";
		$sql = "SELECT " . $masterfld->Expression . " FROM `b_account_info_agent`";
		$filter = $this->addUserIDFilter("");
		if ($filter <> "")
			$sql .= " WHERE " . $filter;

		// Use subquery
		if (USE_SUBQUERY_FOR_MASTER_USER_ID) {
			$wrk = $sql;
		} else {

			// List all values
			if ($rs = $UserTableConn->execute($sql)) {
				while (!$rs->EOF) {
					if ($wrk <> "")
						$wrk .= ",";
					$wrk .= QuotedValue($rs->fields[0], $masterfld->DataType, USER_TABLE_DBID);
					$rs->moveNext();
				}
				$rs->close();
			}
		}
		if ($wrk <> "")
			$wrk = $fld->Expression . " IN (" . $wrk . ")";
		return $wrk;
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'image') {
			$fldName = "image";
			$fileNameFld = "image";
		} elseif ($fldparm == 'id_proof') {
			$fldName = "id_proof";
			$fileNameFld = "id_proof";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'b_account_info_agent';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'b_account_info_agent';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'b_account_info_agent';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'b_account_info_agent';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>