<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class b_account_info_agent_add extends b_account_info_agent
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'b_account_info_agent';

	// Page object name
	public $PageObjName = "b_account_info_agent_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (b_account_info_agent)
		if (!isset($GLOBALS["b_account_info_agent"]) || get_class($GLOBALS["b_account_info_agent"]) == PROJECT_NAMESPACE . "b_account_info_agent") {
			$GLOBALS["b_account_info_agent"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["b_account_info_agent"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info_agent');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $b_account_info_agent;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($b_account_info_agent);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "b_account_info_agentview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("b_account_info_agentlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
				if (strval($Security->currentUserID()) == "") {
					$this->setFailureMessage(DeniedMessage()); // Set no permission
					$this->terminate(GetUrl("b_account_info_agentlist.php"));
					return;
				}
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->b_type->setVisibility();
		$this->grp->setVisibility();
		$this->account_type->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->account_no->Visible = FALSE;
		$this->formal_name->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->image->Visible = FALSE;
		$this->status->setVisibility();
		$this->pan_no->setVisibility();
		$this->id_proof->Visible = FALSE;
		$this->agent->Visible = FALSE;
		$this->other_details->setVisibility();
		$this->loan_amount->setVisibility();
		$this->int_40->setVisibility();
		$this->disbursement_amount->setVisibility();
		$this->emi_amount->setVisibility();
		$this->no_of_emi->setVisibility();
		$this->frequency->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->otp->Visible = FALSE;
		$this->otp_delivery_datetime->Visible = FALSE;
		$this->otp_verify_datetime->Visible = FALSE;
		$this->fund_o->Visible = FALSE;
		$this->fund_o_no->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->account_type);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->fund_o_no);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("b_account_info_agentlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = 'autoprogramme.php?apcid=ad92301430dc5fe354e6d0b1946e537f';
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = 0;
		$this->b_type->CurrentValue = 0;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->account_type->CurrentValue = NULL;
		$this->account_type->OldValue = $this->account_type->CurrentValue;
		$this->aadhaar_no->CurrentValue = NULL;
		$this->aadhaar_no->OldValue = $this->aadhaar_no->CurrentValue;
		$this->account_no->CurrentValue = NULL;
		$this->account_no->OldValue = $this->account_no->CurrentValue;
		$this->formal_name->CurrentValue = NULL;
		$this->formal_name->OldValue = $this->formal_name->CurrentValue;
		$this->mobile->CurrentValue = NULL;
		$this->mobile->OldValue = $this->mobile->CurrentValue;
		$this->_email->CurrentValue = NULL;
		$this->_email->OldValue = $this->_email->CurrentValue;
		$this->image->Upload->DbValue = NULL;
		$this->image->OldValue = $this->image->Upload->DbValue;
		$this->image->CurrentValue = NULL; // Clear file related field
		$this->status->CurrentValue = 101;
		$this->pan_no->CurrentValue = NULL;
		$this->pan_no->OldValue = $this->pan_no->CurrentValue;
		$this->id_proof->Upload->DbValue = NULL;
		$this->id_proof->OldValue = $this->id_proof->Upload->DbValue;
		$this->id_proof->CurrentValue = NULL; // Clear file related field
		$this->agent->CurrentValue = CurrentUserID();
		$this->other_details->CurrentValue = NULL;
		$this->other_details->OldValue = $this->other_details->CurrentValue;
		$this->loan_amount->CurrentValue = NULL;
		$this->loan_amount->OldValue = $this->loan_amount->CurrentValue;
		$this->int_40->CurrentValue = NULL;
		$this->int_40->OldValue = $this->int_40->CurrentValue;
		$this->disbursement_amount->CurrentValue = NULL;
		$this->disbursement_amount->OldValue = $this->disbursement_amount->CurrentValue;
		$this->emi_amount->CurrentValue = NULL;
		$this->emi_amount->OldValue = $this->emi_amount->CurrentValue;
		$this->no_of_emi->CurrentValue = 0;
		$this->frequency->CurrentValue = NULL;
		$this->frequency->OldValue = $this->frequency->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->otp->CurrentValue = NULL;
		$this->otp->OldValue = $this->otp->CurrentValue;
		$this->otp_delivery_datetime->CurrentValue = NULL;
		$this->otp_delivery_datetime->OldValue = $this->otp_delivery_datetime->CurrentValue;
		$this->otp_verify_datetime->CurrentValue = NULL;
		$this->otp_verify_datetime->OldValue = $this->otp_verify_datetime->CurrentValue;
		$this->fund_o->CurrentValue = 0.00;
		$this->fund_o_no->CurrentValue = NULL;
		$this->fund_o_no->OldValue = $this->fund_o_no->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");

		// Check field name 'b_type' first before field var 'x_b_type'
		$val = $CurrentForm->hasValue("b_type") ? $CurrentForm->getValue("b_type") : $CurrentForm->getValue("x_b_type");
		if (!$this->b_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_type->Visible = FALSE; // Disable update for API request
			else
				$this->b_type->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'account_type' first before field var 'x_account_type'
		$val = $CurrentForm->hasValue("account_type") ? $CurrentForm->getValue("account_type") : $CurrentForm->getValue("x_account_type");
		if (!$this->account_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->account_type->Visible = FALSE; // Disable update for API request
			else
				$this->account_type->setFormValue($val);
		}

		// Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
		$val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
		if (!$this->aadhaar_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->aadhaar_no->Visible = FALSE; // Disable update for API request
			else
				$this->aadhaar_no->setFormValue($val);
		}

		// Check field name 'formal_name' first before field var 'x_formal_name'
		$val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
		if (!$this->formal_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->formal_name->Visible = FALSE; // Disable update for API request
			else
				$this->formal_name->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'pan_no' first before field var 'x_pan_no'
		$val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
		if (!$this->pan_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pan_no->Visible = FALSE; // Disable update for API request
			else
				$this->pan_no->setFormValue($val);
		}

		// Check field name 'other_details' first before field var 'x_other_details'
		$val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
		if (!$this->other_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_details->Visible = FALSE; // Disable update for API request
			else
				$this->other_details->setFormValue($val);
		}

		// Check field name 'loan_amount' first before field var 'x_loan_amount'
		$val = $CurrentForm->hasValue("loan_amount") ? $CurrentForm->getValue("loan_amount") : $CurrentForm->getValue("x_loan_amount");
		if (!$this->loan_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->loan_amount->Visible = FALSE; // Disable update for API request
			else
				$this->loan_amount->setFormValue($val);
		}

		// Check field name 'int_@' first before field var 'x_int_40'
		$val = $CurrentForm->hasValue("int_@") ? $CurrentForm->getValue("int_@") : $CurrentForm->getValue("x_int_40");
		if (!$this->int_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->int_40->Visible = FALSE; // Disable update for API request
			else
				$this->int_40->setFormValue($val);
		}

		// Check field name 'disbursement_amount' first before field var 'x_disbursement_amount'
		$val = $CurrentForm->hasValue("disbursement_amount") ? $CurrentForm->getValue("disbursement_amount") : $CurrentForm->getValue("x_disbursement_amount");
		if (!$this->disbursement_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->disbursement_amount->Visible = FALSE; // Disable update for API request
			else
				$this->disbursement_amount->setFormValue($val);
		}

		// Check field name 'emi_amount' first before field var 'x_emi_amount'
		$val = $CurrentForm->hasValue("emi_amount") ? $CurrentForm->getValue("emi_amount") : $CurrentForm->getValue("x_emi_amount");
		if (!$this->emi_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emi_amount->Visible = FALSE; // Disable update for API request
			else
				$this->emi_amount->setFormValue($val);
		}

		// Check field name 'no_of_emi' first before field var 'x_no_of_emi'
		$val = $CurrentForm->hasValue("no_of_emi") ? $CurrentForm->getValue("no_of_emi") : $CurrentForm->getValue("x_no_of_emi");
		if (!$this->no_of_emi->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->no_of_emi->Visible = FALSE; // Disable update for API request
			else
				$this->no_of_emi->setFormValue($val);
		}

		// Check field name 'frequency' first before field var 'x_frequency'
		$val = $CurrentForm->hasValue("frequency") ? $CurrentForm->getValue("frequency") : $CurrentForm->getValue("x_frequency");
		if (!$this->frequency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->frequency->Visible = FALSE; // Disable update for API request
			else
				$this->frequency->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->b_type->CurrentValue = $this->b_type->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->account_type->CurrentValue = $this->account_type->FormValue;
		$this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
		$this->formal_name->CurrentValue = $this->formal_name->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->pan_no->CurrentValue = $this->pan_no->FormValue;
		$this->other_details->CurrentValue = $this->other_details->FormValue;
		$this->loan_amount->CurrentValue = $this->loan_amount->FormValue;
		$this->int_40->CurrentValue = $this->int_40->FormValue;
		$this->disbursement_amount->CurrentValue = $this->disbursement_amount->FormValue;
		$this->emi_amount->CurrentValue = $this->emi_amount->FormValue;
		$this->no_of_emi->CurrentValue = $this->no_of_emi->FormValue;
		$this->frequency->CurrentValue = $this->frequency->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}

		// Check if valid User ID
		if ($res) {
			$res = $this->showOptionLink('add');
			if (!$res) {
				$userIdMsg = DeniedMessage();
				$this->setFailureMessage($userIdMsg);
			}
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->b_type->setDbValue($row['b_type']);
		$this->grp->setDbValue($row['grp']);
		$this->account_type->setDbValue($row['account_type']);
		$this->aadhaar_no->setDbValue($row['aadhaar_no']);
		$this->account_no->setDbValue($row['account_no']);
		$this->formal_name->setDbValue($row['formal_name']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->status->setDbValue($row['status']);
		$this->pan_no->setDbValue($row['pan_no']);
		$this->id_proof->Upload->DbValue = $row['id_proof'];
		$this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
		$this->agent->setDbValue($row['agent']);
		$this->other_details->setDbValue($row['other_details']);
		$this->loan_amount->setDbValue($row['loan_amount']);
		$this->int_40->setDbValue($row['int_@']);
		$this->disbursement_amount->setDbValue($row['disbursement_amount']);
		$this->emi_amount->setDbValue($row['emi_amount']);
		$this->no_of_emi->setDbValue($row['no_of_emi']);
		$this->frequency->setDbValue($row['frequency']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->otp->setDbValue($row['otp']);
		$this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
		$this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
		$this->fund_o->setDbValue($row['fund_o']);
		$this->fund_o_no->setDbValue($row['fund_o_no']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['b_type'] = $this->b_type->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['account_type'] = $this->account_type->CurrentValue;
		$row['aadhaar_no'] = $this->aadhaar_no->CurrentValue;
		$row['account_no'] = $this->account_no->CurrentValue;
		$row['formal_name'] = $this->formal_name->CurrentValue;
		$row['mobile'] = $this->mobile->CurrentValue;
		$row['email'] = $this->_email->CurrentValue;
		$row['image'] = $this->image->Upload->DbValue;
		$row['status'] = $this->status->CurrentValue;
		$row['pan_no'] = $this->pan_no->CurrentValue;
		$row['id_proof'] = $this->id_proof->Upload->DbValue;
		$row['agent'] = $this->agent->CurrentValue;
		$row['other_details'] = $this->other_details->CurrentValue;
		$row['loan_amount'] = $this->loan_amount->CurrentValue;
		$row['int_@'] = $this->int_40->CurrentValue;
		$row['disbursement_amount'] = $this->disbursement_amount->CurrentValue;
		$row['emi_amount'] = $this->emi_amount->CurrentValue;
		$row['no_of_emi'] = $this->no_of_emi->CurrentValue;
		$row['frequency'] = $this->frequency->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['otp'] = $this->otp->CurrentValue;
		$row['otp_delivery_datetime'] = $this->otp_delivery_datetime->CurrentValue;
		$row['otp_verify_datetime'] = $this->otp_verify_datetime->CurrentValue;
		$row['fund_o'] = $this->fund_o->CurrentValue;
		$row['fund_o_no'] = $this->fund_o_no->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->loan_amount->FormValue == $this->loan_amount->CurrentValue && is_numeric(ConvertToFloatString($this->loan_amount->CurrentValue)))
			$this->loan_amount->CurrentValue = ConvertToFloatString($this->loan_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->int_40->FormValue == $this->int_40->CurrentValue && is_numeric(ConvertToFloatString($this->int_40->CurrentValue)))
			$this->int_40->CurrentValue = ConvertToFloatString($this->int_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->disbursement_amount->FormValue == $this->disbursement_amount->CurrentValue && is_numeric(ConvertToFloatString($this->disbursement_amount->CurrentValue)))
			$this->disbursement_amount->CurrentValue = ConvertToFloatString($this->disbursement_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->emi_amount->FormValue == $this->emi_amount->CurrentValue && is_numeric(ConvertToFloatString($this->emi_amount->CurrentValue)))
			$this->emi_amount->CurrentValue = ConvertToFloatString($this->emi_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// b_type
		// grp
		// account_type
		// aadhaar_no
		// account_no
		// formal_name
		// mobile
		// email
		// image
		// status
		// pan_no
		// id_proof
		// agent
		// other_details
		// loan_amount
		// int_@
		// disbursement_amount
		// emi_amount
		// no_of_emi
		// frequency
		// operator
		// datetime
		// otp
		// otp_delivery_datetime
		// otp_verify_datetime
		// fund_o
		// fund_o_no

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// b_type
			if (strval($this->b_type->CurrentValue) <> "") {
				$this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
			} else {
				$this->b_type->ViewValue = NULL;
			}
			$this->b_type->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=1301";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// account_type
			$curVal = strval($this->account_type->CurrentValue);
			if ($curVal <> "") {
				$this->account_type->ViewValue = $this->account_type->lookupCacheOption($curVal);
				if ($this->account_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->account_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->account_type->ViewValue = $this->account_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->account_type->ViewValue = $this->account_type->CurrentValue;
					}
				}
			} else {
				$this->account_type->ViewValue = NULL;
			}
			$this->account_type->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// account_no
			$this->account_no->ViewValue = $this->account_no->CurrentValue;
			$this->account_no->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
			$this->formal_name->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// id_proof
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->ViewValue = "";
			}
			$this->id_proof->ViewCustomAttributes = "";

			// agent
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			$this->agent->ViewCustomAttributes = "";

			// other_details
			$this->other_details->ViewValue = $this->other_details->CurrentValue;
			$this->other_details->ViewCustomAttributes = "";

			// loan_amount
			$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
			$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
			$this->loan_amount->ViewCustomAttributes = "";

			// int_@
			$this->int_40->ViewValue = $this->int_40->CurrentValue;
			$this->int_40->ViewValue = FormatNumber($this->int_40->ViewValue, 2, -2, -2, -2);
			$this->int_40->ViewCustomAttributes = "";

			// disbursement_amount
			$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
			$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
			$this->disbursement_amount->ViewCustomAttributes = "";

			// emi_amount
			$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
			$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
			$this->emi_amount->ViewCustomAttributes = "";

			// no_of_emi
			$this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
			$this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, 0, -2, -2, -2);
			$this->no_of_emi->ViewCustomAttributes = "";

			// frequency
			if (strval($this->frequency->CurrentValue) <> "") {
				$this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
			} else {
				$this->frequency->ViewValue = NULL;
			}
			$this->frequency->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// otp_delivery_datetime
			$this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
			$this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, 0);
			$this->otp_delivery_datetime->ViewCustomAttributes = "";

			// otp_verify_datetime
			$this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
			$this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, 0);
			$this->otp_verify_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// b_type
			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";
			$this->b_type->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// account_type
			$this->account_type->LinkCustomAttributes = "";
			$this->account_type->HrefValue = "";
			$this->account_type->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";
			$this->formal_name->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";
			$this->other_details->TooltipValue = "";

			// loan_amount
			$this->loan_amount->LinkCustomAttributes = "";
			$this->loan_amount->HrefValue = "";
			$this->loan_amount->TooltipValue = "";

			// int_@
			$this->int_40->LinkCustomAttributes = "";
			$this->int_40->HrefValue = "";
			$this->int_40->TooltipValue = "";

			// disbursement_amount
			$this->disbursement_amount->LinkCustomAttributes = "";
			$this->disbursement_amount->HrefValue = "";
			$this->disbursement_amount->TooltipValue = "";

			// emi_amount
			$this->emi_amount->LinkCustomAttributes = "";
			$this->emi_amount->HrefValue = "";
			$this->emi_amount->TooltipValue = "";

			// no_of_emi
			$this->no_of_emi->LinkCustomAttributes = "";
			$this->no_of_emi->HrefValue = "";
			$this->no_of_emi->TooltipValue = "";

			// frequency
			$this->frequency->LinkCustomAttributes = "";
			$this->frequency->HrefValue = "";
			$this->frequency->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			// b_type

			$this->b_type->EditAttrs["class"] = "form-control";
			$this->b_type->EditCustomAttributes = "";
			$this->b_type->EditValue = $this->b_type->options(TRUE);

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=1301";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// account_type
			$this->account_type->EditAttrs["class"] = "form-control";
			$this->account_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->account_type->CurrentValue));
			if ($curVal <> "")
				$this->account_type->ViewValue = $this->account_type->lookupCacheOption($curVal);
			else
				$this->account_type->ViewValue = $this->account_type->Lookup !== NULL && is_array($this->account_type->Lookup->Options) ? $curVal : NULL;
			if ($this->account_type->ViewValue !== NULL) { // Load from cache
				$this->account_type->EditValue = array_values($this->account_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->account_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->account_type->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->account_type->EditValue = $arwrk;
			}

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// formal_name
			$this->formal_name->EditAttrs["class"] = "form-control";
			$this->formal_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
			$this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
			$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = 'ReadOnly';
			$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->EditValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->status->EditValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
					}
				}
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// pan_no
			$this->pan_no->EditAttrs["class"] = "form-control";
			$this->pan_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
			$this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
			$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

			// other_details
			$this->other_details->EditAttrs["class"] = "form-control";
			$this->other_details->EditCustomAttributes = "";
			$this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
			$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

			// loan_amount
			$this->loan_amount->EditAttrs["class"] = "form-control";
			$this->loan_amount->EditCustomAttributes = "";
			$this->loan_amount->EditValue = HtmlEncode($this->loan_amount->CurrentValue);
			$this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());
			if (strval($this->loan_amount->EditValue) <> "" && is_numeric($this->loan_amount->EditValue))
				$this->loan_amount->EditValue = FormatNumber($this->loan_amount->EditValue, -2, -2, -2, -2);

			// int_@
			$this->int_40->EditAttrs["class"] = "form-control";
			$this->int_40->EditCustomAttributes = "";
			$this->int_40->EditValue = HtmlEncode($this->int_40->CurrentValue);
			$this->int_40->PlaceHolder = RemoveHtml($this->int_40->caption());
			if (strval($this->int_40->EditValue) <> "" && is_numeric($this->int_40->EditValue))
				$this->int_40->EditValue = FormatNumber($this->int_40->EditValue, -2, -2, -2, -2);

			// disbursement_amount
			$this->disbursement_amount->EditAttrs["class"] = "form-control";
			$this->disbursement_amount->EditCustomAttributes = "";
			$this->disbursement_amount->EditValue = HtmlEncode($this->disbursement_amount->CurrentValue);
			$this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());
			if (strval($this->disbursement_amount->EditValue) <> "" && is_numeric($this->disbursement_amount->EditValue))
				$this->disbursement_amount->EditValue = FormatNumber($this->disbursement_amount->EditValue, -2, -2, -2, -2);

			// emi_amount
			$this->emi_amount->EditAttrs["class"] = "form-control";
			$this->emi_amount->EditCustomAttributes = "";
			$this->emi_amount->EditValue = HtmlEncode($this->emi_amount->CurrentValue);
			$this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());
			if (strval($this->emi_amount->EditValue) <> "" && is_numeric($this->emi_amount->EditValue))
				$this->emi_amount->EditValue = FormatNumber($this->emi_amount->EditValue, -2, -2, -2, -2);

			// no_of_emi
			$this->no_of_emi->EditAttrs["class"] = "form-control";
			$this->no_of_emi->EditCustomAttributes = "";
			$this->no_of_emi->EditValue = HtmlEncode($this->no_of_emi->CurrentValue);
			$this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

			// frequency
			$this->frequency->EditAttrs["class"] = "form-control";
			$this->frequency->EditCustomAttributes = "";
			$this->frequency->EditValue = $this->frequency->options(TRUE);

			// operator
			// datetime
			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// b_type
			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// account_type
			$this->account_type->LinkCustomAttributes = "";
			$this->account_type->HrefValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";

			// loan_amount
			$this->loan_amount->LinkCustomAttributes = "";
			$this->loan_amount->HrefValue = "";

			// int_@
			$this->int_40->LinkCustomAttributes = "";
			$this->int_40->HrefValue = "";

			// disbursement_amount
			$this->disbursement_amount->LinkCustomAttributes = "";
			$this->disbursement_amount->HrefValue = "";

			// emi_amount
			$this->emi_amount->LinkCustomAttributes = "";
			$this->emi_amount->HrefValue = "";

			// no_of_emi
			$this->no_of_emi->LinkCustomAttributes = "";
			$this->no_of_emi->HrefValue = "";

			// frequency
			$this->frequency->LinkCustomAttributes = "";
			$this->frequency->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->b_type->Required) {
			if (!$this->b_type->IsDetailKey && $this->b_type->FormValue != NULL && $this->b_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_type->caption(), $this->b_type->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->account_type->Required) {
			if (!$this->account_type->IsDetailKey && $this->account_type->FormValue != NULL && $this->account_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->account_type->caption(), $this->account_type->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar_no->Required) {
			if (!$this->aadhaar_no->IsDetailKey && $this->aadhaar_no->FormValue != NULL && $this->aadhaar_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
			}
		}
		if ($this->account_no->Required) {
			if (!$this->account_no->IsDetailKey && $this->account_no->FormValue != NULL && $this->account_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->account_no->caption(), $this->account_no->RequiredErrorMessage));
			}
		}
		if ($this->formal_name->Required) {
			if (!$this->formal_name->IsDetailKey && $this->formal_name->FormValue != NULL && $this->formal_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->mobile->FormValue)) {
			AddMessage($FormError, $this->mobile->errorMessage());
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if (!CheckEmail($this->_email->FormValue)) {
			AddMessage($FormError, $this->_email->errorMessage());
		}
		if ($this->image->Required) {
			if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status->FormValue)) {
			AddMessage($FormError, $this->status->errorMessage());
		}
		if ($this->pan_no->Required) {
			if (!$this->pan_no->IsDetailKey && $this->pan_no->FormValue != NULL && $this->pan_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
			}
		}
		if ($this->id_proof->Required) {
			if ($this->id_proof->Upload->FileName == "" && !$this->id_proof->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
			}
		}
		if ($this->agent->Required) {
			if (!$this->agent->IsDetailKey && $this->agent->FormValue != NULL && $this->agent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
			}
		}
		if ($this->other_details->Required) {
			if (!$this->other_details->IsDetailKey && $this->other_details->FormValue != NULL && $this->other_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
			}
		}
		if ($this->loan_amount->Required) {
			if (!$this->loan_amount->IsDetailKey && $this->loan_amount->FormValue != NULL && $this->loan_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->loan_amount->caption(), $this->loan_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->loan_amount->FormValue)) {
			AddMessage($FormError, $this->loan_amount->errorMessage());
		}
		if ($this->int_40->Required) {
			if (!$this->int_40->IsDetailKey && $this->int_40->FormValue != NULL && $this->int_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->int_40->caption(), $this->int_40->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->int_40->FormValue)) {
			AddMessage($FormError, $this->int_40->errorMessage());
		}
		if ($this->disbursement_amount->Required) {
			if (!$this->disbursement_amount->IsDetailKey && $this->disbursement_amount->FormValue != NULL && $this->disbursement_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->disbursement_amount->caption(), $this->disbursement_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->disbursement_amount->FormValue)) {
			AddMessage($FormError, $this->disbursement_amount->errorMessage());
		}
		if ($this->emi_amount->Required) {
			if (!$this->emi_amount->IsDetailKey && $this->emi_amount->FormValue != NULL && $this->emi_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emi_amount->caption(), $this->emi_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->emi_amount->FormValue)) {
			AddMessage($FormError, $this->emi_amount->errorMessage());
		}
		if ($this->no_of_emi->Required) {
			if (!$this->no_of_emi->IsDetailKey && $this->no_of_emi->FormValue != NULL && $this->no_of_emi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->no_of_emi->caption(), $this->no_of_emi->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->no_of_emi->FormValue)) {
			AddMessage($FormError, $this->no_of_emi->errorMessage());
		}
		if ($this->frequency->Required) {
			if (!$this->frequency->IsDetailKey && $this->frequency->FormValue != NULL && $this->frequency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->frequency->caption(), $this->frequency->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->otp->Required) {
			if (!$this->otp->IsDetailKey && $this->otp->FormValue != NULL && $this->otp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->otp->caption(), $this->otp->RequiredErrorMessage));
			}
		}
		if ($this->otp_delivery_datetime->Required) {
			if (!$this->otp_delivery_datetime->IsDetailKey && $this->otp_delivery_datetime->FormValue != NULL && $this->otp_delivery_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->otp_delivery_datetime->caption(), $this->otp_delivery_datetime->RequiredErrorMessage));
			}
		}
		if ($this->otp_verify_datetime->Required) {
			if (!$this->otp_verify_datetime->IsDetailKey && $this->otp_verify_datetime->FormValue != NULL && $this->otp_verify_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->otp_verify_datetime->caption(), $this->otp_verify_datetime->RequiredErrorMessage));
			}
		}
		if ($this->fund_o->Required) {
			if (!$this->fund_o->IsDetailKey && $this->fund_o->FormValue != NULL && $this->fund_o->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fund_o->caption(), $this->fund_o->RequiredErrorMessage));
			}
		}
		if ($this->fund_o_no->Required) {
			if (!$this->fund_o_no->IsDetailKey && $this->fund_o_no->FormValue != NULL && $this->fund_o_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fund_o_no->caption(), $this->fund_o_no->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Check if valid User ID
		$validUser = FALSE;
		if ($Security->currentUserID() <> "" && !EmptyValue($this->agent->CurrentValue) && !$Security->isAdmin()) { // Non system admin
			$validUser = $Security->isValidUserID($this->agent->CurrentValue);
			if (!$validUser) {
				$userIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedUserID"));
				$userIdMsg = str_replace("%u", $this->agent->CurrentValue, $userIdMsg);
				$this->setFailureMessage($userIdMsg);
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->image->OldUploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			$this->image->UploadPath = $this->image->OldUploadPath;
			$this->id_proof->OldUploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			$this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
		}
		$rsnew = [];

		// b_type
		$this->b_type->setDbValueDef($rsnew, $this->b_type->CurrentValue, 0, strval($this->b_type->CurrentValue) == "");

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, FALSE);

		// account_type
		$this->account_type->setDbValueDef($rsnew, $this->account_type->CurrentValue, NULL, FALSE);

		// aadhaar_no
		$this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, NULL, FALSE);

		// formal_name
		$this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, NULL, FALSE);

		// mobile
		$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, FALSE);

		// email
		$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, FALSE);

		// pan_no
		$this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, NULL, FALSE);

		// other_details
		$this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, NULL, FALSE);

		// loan_amount
		$this->loan_amount->setDbValueDef($rsnew, $this->loan_amount->CurrentValue, 0, strval($this->loan_amount->CurrentValue) == "");

		// int_@
		$this->int_40->setDbValueDef($rsnew, $this->int_40->CurrentValue, NULL, FALSE);

		// disbursement_amount
		$this->disbursement_amount->setDbValueDef($rsnew, $this->disbursement_amount->CurrentValue, 0, strval($this->disbursement_amount->CurrentValue) == "");

		// emi_amount
		$this->emi_amount->setDbValueDef($rsnew, $this->emi_amount->CurrentValue, 0, strval($this->emi_amount->CurrentValue) == "");

		// no_of_emi
		$this->no_of_emi->setDbValueDef($rsnew, $this->no_of_emi->CurrentValue, NULL, strval($this->no_of_emi->CurrentValue) == "");

		// frequency
		$this->frequency->setDbValueDef($rsnew, $this->frequency->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// agent
		if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin
			$rsnew['agent'] = CurrentUserID();
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Show link optionally based on User ID
	protected function showOptionLink($id = "")
	{
		global $Security;
		if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id))
			return $Security->isValidUserID($this->agent->CurrentValue);
		return TRUE;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("b_account_info_agentlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`grp`=1301";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_fund_o_no":
					$lookupFilter = function() {
						return "`grp`= 230401";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_account_type":
							break;
						case "x_status":
							break;
						case "x_agent":
							break;
						case "x_fund_o_no":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'b_account_info_agent');	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>