<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class b_account_info_list extends b_account_info
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'b_account_info';

	// Page object name
	public $PageObjName = "b_account_info_list";

	// Grid form hidden field names
	public $FormName = "fb_account_infolist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (b_account_info)
		if (!isset($GLOBALS["b_account_info"]) || get_class($GLOBALS["b_account_info"]) == PROJECT_NAMESPACE . "b_account_info") {
			$GLOBALS["b_account_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["b_account_info"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "b_account_infoadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "b_account_infodelete.php";
		$this->MultiUpdateUrl = "b_account_infoupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fb_account_infolistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $b_account_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($b_account_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->d_operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->d_datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->b_type->setVisibility();
		$this->grp->setVisibility();
		$this->branch->setVisibility();
		$this->category->Visible = FALSE;
		$this->account_type->setVisibility();
		$this->type->setVisibility();
		$this->formal_name->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->sign_image->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->aadhaar_no->Visible = FALSE;
		$this->pan_no->Visible = FALSE;
		$this->id_proof->Visible = FALSE;
		$this->agent->setVisibility();
		$this->other_details->Visible = FALSE;
		$this->bank_name->Visible = FALSE;
		$this->bank_ifsc_code->Visible = FALSE;
		$this->bank_account_no->Visible = FALSE;
		$this->account_no->setVisibility();
		$this->loan_amount->setVisibility();
		$this->emi_amount->setVisibility();
		$this->frequency->setVisibility();
		$this->disbursement_amount->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->setVisibility();
		$this->d_operator->Visible = FALSE;
		$this->d_datetime->Visible = FALSE;
		$this->otp->Visible = FALSE;
		$this->otp_delivery_datetime->setVisibility();
		$this->otp_verify_datetime->setVisibility();
		$this->no_of_emi->setVisibility();
		$this->fund_o->setVisibility();
		$this->fund_o_no->setVisibility();
		$this->int_40->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->branch);
		$this->setupLookupOptions($this->type);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->fund_o_no);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export selected records
		if ($this->isExport())
			$this->CurrentFilter = $this->buildExportSelectedFilter();

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fb_account_infolistsrch");
		$filterList = Concat($filterList, $this->b_type->AdvancedSearch->toJson(), ","); // Field b_type
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->branch->AdvancedSearch->toJson(), ","); // Field branch
		$filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
		$filterList = Concat($filterList, $this->account_type->AdvancedSearch->toJson(), ","); // Field account_type
		$filterList = Concat($filterList, $this->type->AdvancedSearch->toJson(), ","); // Field type
		$filterList = Concat($filterList, $this->formal_name->AdvancedSearch->toJson(), ","); // Field formal_name
		$filterList = Concat($filterList, $this->mobile->AdvancedSearch->toJson(), ","); // Field mobile
		$filterList = Concat($filterList, $this->_email->AdvancedSearch->toJson(), ","); // Field email
		$filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
		$filterList = Concat($filterList, $this->sign_image->AdvancedSearch->toJson(), ","); // Field sign_image
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->aadhaar_no->AdvancedSearch->toJson(), ","); // Field aadhaar_no
		$filterList = Concat($filterList, $this->pan_no->AdvancedSearch->toJson(), ","); // Field pan_no
		$filterList = Concat($filterList, $this->id_proof->AdvancedSearch->toJson(), ","); // Field id_proof
		$filterList = Concat($filterList, $this->agent->AdvancedSearch->toJson(), ","); // Field agent
		$filterList = Concat($filterList, $this->other_details->AdvancedSearch->toJson(), ","); // Field other_details
		$filterList = Concat($filterList, $this->bank_name->AdvancedSearch->toJson(), ","); // Field bank_name
		$filterList = Concat($filterList, $this->bank_ifsc_code->AdvancedSearch->toJson(), ","); // Field bank_ifsc_code
		$filterList = Concat($filterList, $this->bank_account_no->AdvancedSearch->toJson(), ","); // Field bank_account_no
		$filterList = Concat($filterList, $this->account_no->AdvancedSearch->toJson(), ","); // Field account_no
		$filterList = Concat($filterList, $this->loan_amount->AdvancedSearch->toJson(), ","); // Field loan_amount
		$filterList = Concat($filterList, $this->emi_amount->AdvancedSearch->toJson(), ","); // Field emi_amount
		$filterList = Concat($filterList, $this->frequency->AdvancedSearch->toJson(), ","); // Field frequency
		$filterList = Concat($filterList, $this->disbursement_amount->AdvancedSearch->toJson(), ","); // Field disbursement_amount
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->d_operator->AdvancedSearch->toJson(), ","); // Field d_operator
		$filterList = Concat($filterList, $this->d_datetime->AdvancedSearch->toJson(), ","); // Field d_datetime
		$filterList = Concat($filterList, $this->no_of_emi->AdvancedSearch->toJson(), ","); // Field no_of_emi
		$filterList = Concat($filterList, $this->fund_o->AdvancedSearch->toJson(), ","); // Field fund_o
		$filterList = Concat($filterList, $this->fund_o_no->AdvancedSearch->toJson(), ","); // Field fund_o_no
		$filterList = Concat($filterList, $this->int_40->AdvancedSearch->toJson(), ","); // Field int_@
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fb_account_infolistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field b_type
		$this->b_type->AdvancedSearch->SearchValue = @$filter["x_b_type"];
		$this->b_type->AdvancedSearch->SearchOperator = @$filter["z_b_type"];
		$this->b_type->AdvancedSearch->SearchCondition = @$filter["v_b_type"];
		$this->b_type->AdvancedSearch->SearchValue2 = @$filter["y_b_type"];
		$this->b_type->AdvancedSearch->SearchOperator2 = @$filter["w_b_type"];
		$this->b_type->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field branch
		$this->branch->AdvancedSearch->SearchValue = @$filter["x_branch"];
		$this->branch->AdvancedSearch->SearchOperator = @$filter["z_branch"];
		$this->branch->AdvancedSearch->SearchCondition = @$filter["v_branch"];
		$this->branch->AdvancedSearch->SearchValue2 = @$filter["y_branch"];
		$this->branch->AdvancedSearch->SearchOperator2 = @$filter["w_branch"];
		$this->branch->AdvancedSearch->save();

		// Field category
		$this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
		$this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
		$this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
		$this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
		$this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
		$this->category->AdvancedSearch->save();

		// Field account_type
		$this->account_type->AdvancedSearch->SearchValue = @$filter["x_account_type"];
		$this->account_type->AdvancedSearch->SearchOperator = @$filter["z_account_type"];
		$this->account_type->AdvancedSearch->SearchCondition = @$filter["v_account_type"];
		$this->account_type->AdvancedSearch->SearchValue2 = @$filter["y_account_type"];
		$this->account_type->AdvancedSearch->SearchOperator2 = @$filter["w_account_type"];
		$this->account_type->AdvancedSearch->save();

		// Field type
		$this->type->AdvancedSearch->SearchValue = @$filter["x_type"];
		$this->type->AdvancedSearch->SearchOperator = @$filter["z_type"];
		$this->type->AdvancedSearch->SearchCondition = @$filter["v_type"];
		$this->type->AdvancedSearch->SearchValue2 = @$filter["y_type"];
		$this->type->AdvancedSearch->SearchOperator2 = @$filter["w_type"];
		$this->type->AdvancedSearch->save();

		// Field formal_name
		$this->formal_name->AdvancedSearch->SearchValue = @$filter["x_formal_name"];
		$this->formal_name->AdvancedSearch->SearchOperator = @$filter["z_formal_name"];
		$this->formal_name->AdvancedSearch->SearchCondition = @$filter["v_formal_name"];
		$this->formal_name->AdvancedSearch->SearchValue2 = @$filter["y_formal_name"];
		$this->formal_name->AdvancedSearch->SearchOperator2 = @$filter["w_formal_name"];
		$this->formal_name->AdvancedSearch->save();

		// Field mobile
		$this->mobile->AdvancedSearch->SearchValue = @$filter["x_mobile"];
		$this->mobile->AdvancedSearch->SearchOperator = @$filter["z_mobile"];
		$this->mobile->AdvancedSearch->SearchCondition = @$filter["v_mobile"];
		$this->mobile->AdvancedSearch->SearchValue2 = @$filter["y_mobile"];
		$this->mobile->AdvancedSearch->SearchOperator2 = @$filter["w_mobile"];
		$this->mobile->AdvancedSearch->save();

		// Field email
		$this->_email->AdvancedSearch->SearchValue = @$filter["x__email"];
		$this->_email->AdvancedSearch->SearchOperator = @$filter["z__email"];
		$this->_email->AdvancedSearch->SearchCondition = @$filter["v__email"];
		$this->_email->AdvancedSearch->SearchValue2 = @$filter["y__email"];
		$this->_email->AdvancedSearch->SearchOperator2 = @$filter["w__email"];
		$this->_email->AdvancedSearch->save();

		// Field image
		$this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
		$this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
		$this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
		$this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
		$this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
		$this->image->AdvancedSearch->save();

		// Field sign_image
		$this->sign_image->AdvancedSearch->SearchValue = @$filter["x_sign_image"];
		$this->sign_image->AdvancedSearch->SearchOperator = @$filter["z_sign_image"];
		$this->sign_image->AdvancedSearch->SearchCondition = @$filter["v_sign_image"];
		$this->sign_image->AdvancedSearch->SearchValue2 = @$filter["y_sign_image"];
		$this->sign_image->AdvancedSearch->SearchOperator2 = @$filter["w_sign_image"];
		$this->sign_image->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field aadhaar_no
		$this->aadhaar_no->AdvancedSearch->SearchValue = @$filter["x_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchOperator = @$filter["z_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchCondition = @$filter["v_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchValue2 = @$filter["y_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchOperator2 = @$filter["w_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->save();

		// Field pan_no
		$this->pan_no->AdvancedSearch->SearchValue = @$filter["x_pan_no"];
		$this->pan_no->AdvancedSearch->SearchOperator = @$filter["z_pan_no"];
		$this->pan_no->AdvancedSearch->SearchCondition = @$filter["v_pan_no"];
		$this->pan_no->AdvancedSearch->SearchValue2 = @$filter["y_pan_no"];
		$this->pan_no->AdvancedSearch->SearchOperator2 = @$filter["w_pan_no"];
		$this->pan_no->AdvancedSearch->save();

		// Field id_proof
		$this->id_proof->AdvancedSearch->SearchValue = @$filter["x_id_proof"];
		$this->id_proof->AdvancedSearch->SearchOperator = @$filter["z_id_proof"];
		$this->id_proof->AdvancedSearch->SearchCondition = @$filter["v_id_proof"];
		$this->id_proof->AdvancedSearch->SearchValue2 = @$filter["y_id_proof"];
		$this->id_proof->AdvancedSearch->SearchOperator2 = @$filter["w_id_proof"];
		$this->id_proof->AdvancedSearch->save();

		// Field agent
		$this->agent->AdvancedSearch->SearchValue = @$filter["x_agent"];
		$this->agent->AdvancedSearch->SearchOperator = @$filter["z_agent"];
		$this->agent->AdvancedSearch->SearchCondition = @$filter["v_agent"];
		$this->agent->AdvancedSearch->SearchValue2 = @$filter["y_agent"];
		$this->agent->AdvancedSearch->SearchOperator2 = @$filter["w_agent"];
		$this->agent->AdvancedSearch->save();

		// Field other_details
		$this->other_details->AdvancedSearch->SearchValue = @$filter["x_other_details"];
		$this->other_details->AdvancedSearch->SearchOperator = @$filter["z_other_details"];
		$this->other_details->AdvancedSearch->SearchCondition = @$filter["v_other_details"];
		$this->other_details->AdvancedSearch->SearchValue2 = @$filter["y_other_details"];
		$this->other_details->AdvancedSearch->SearchOperator2 = @$filter["w_other_details"];
		$this->other_details->AdvancedSearch->save();

		// Field bank_name
		$this->bank_name->AdvancedSearch->SearchValue = @$filter["x_bank_name"];
		$this->bank_name->AdvancedSearch->SearchOperator = @$filter["z_bank_name"];
		$this->bank_name->AdvancedSearch->SearchCondition = @$filter["v_bank_name"];
		$this->bank_name->AdvancedSearch->SearchValue2 = @$filter["y_bank_name"];
		$this->bank_name->AdvancedSearch->SearchOperator2 = @$filter["w_bank_name"];
		$this->bank_name->AdvancedSearch->save();

		// Field bank_ifsc_code
		$this->bank_ifsc_code->AdvancedSearch->SearchValue = @$filter["x_bank_ifsc_code"];
		$this->bank_ifsc_code->AdvancedSearch->SearchOperator = @$filter["z_bank_ifsc_code"];
		$this->bank_ifsc_code->AdvancedSearch->SearchCondition = @$filter["v_bank_ifsc_code"];
		$this->bank_ifsc_code->AdvancedSearch->SearchValue2 = @$filter["y_bank_ifsc_code"];
		$this->bank_ifsc_code->AdvancedSearch->SearchOperator2 = @$filter["w_bank_ifsc_code"];
		$this->bank_ifsc_code->AdvancedSearch->save();

		// Field bank_account_no
		$this->bank_account_no->AdvancedSearch->SearchValue = @$filter["x_bank_account_no"];
		$this->bank_account_no->AdvancedSearch->SearchOperator = @$filter["z_bank_account_no"];
		$this->bank_account_no->AdvancedSearch->SearchCondition = @$filter["v_bank_account_no"];
		$this->bank_account_no->AdvancedSearch->SearchValue2 = @$filter["y_bank_account_no"];
		$this->bank_account_no->AdvancedSearch->SearchOperator2 = @$filter["w_bank_account_no"];
		$this->bank_account_no->AdvancedSearch->save();

		// Field account_no
		$this->account_no->AdvancedSearch->SearchValue = @$filter["x_account_no"];
		$this->account_no->AdvancedSearch->SearchOperator = @$filter["z_account_no"];
		$this->account_no->AdvancedSearch->SearchCondition = @$filter["v_account_no"];
		$this->account_no->AdvancedSearch->SearchValue2 = @$filter["y_account_no"];
		$this->account_no->AdvancedSearch->SearchOperator2 = @$filter["w_account_no"];
		$this->account_no->AdvancedSearch->save();

		// Field loan_amount
		$this->loan_amount->AdvancedSearch->SearchValue = @$filter["x_loan_amount"];
		$this->loan_amount->AdvancedSearch->SearchOperator = @$filter["z_loan_amount"];
		$this->loan_amount->AdvancedSearch->SearchCondition = @$filter["v_loan_amount"];
		$this->loan_amount->AdvancedSearch->SearchValue2 = @$filter["y_loan_amount"];
		$this->loan_amount->AdvancedSearch->SearchOperator2 = @$filter["w_loan_amount"];
		$this->loan_amount->AdvancedSearch->save();

		// Field emi_amount
		$this->emi_amount->AdvancedSearch->SearchValue = @$filter["x_emi_amount"];
		$this->emi_amount->AdvancedSearch->SearchOperator = @$filter["z_emi_amount"];
		$this->emi_amount->AdvancedSearch->SearchCondition = @$filter["v_emi_amount"];
		$this->emi_amount->AdvancedSearch->SearchValue2 = @$filter["y_emi_amount"];
		$this->emi_amount->AdvancedSearch->SearchOperator2 = @$filter["w_emi_amount"];
		$this->emi_amount->AdvancedSearch->save();

		// Field frequency
		$this->frequency->AdvancedSearch->SearchValue = @$filter["x_frequency"];
		$this->frequency->AdvancedSearch->SearchOperator = @$filter["z_frequency"];
		$this->frequency->AdvancedSearch->SearchCondition = @$filter["v_frequency"];
		$this->frequency->AdvancedSearch->SearchValue2 = @$filter["y_frequency"];
		$this->frequency->AdvancedSearch->SearchOperator2 = @$filter["w_frequency"];
		$this->frequency->AdvancedSearch->save();

		// Field disbursement_amount
		$this->disbursement_amount->AdvancedSearch->SearchValue = @$filter["x_disbursement_amount"];
		$this->disbursement_amount->AdvancedSearch->SearchOperator = @$filter["z_disbursement_amount"];
		$this->disbursement_amount->AdvancedSearch->SearchCondition = @$filter["v_disbursement_amount"];
		$this->disbursement_amount->AdvancedSearch->SearchValue2 = @$filter["y_disbursement_amount"];
		$this->disbursement_amount->AdvancedSearch->SearchOperator2 = @$filter["w_disbursement_amount"];
		$this->disbursement_amount->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field d_operator
		$this->d_operator->AdvancedSearch->SearchValue = @$filter["x_d_operator"];
		$this->d_operator->AdvancedSearch->SearchOperator = @$filter["z_d_operator"];
		$this->d_operator->AdvancedSearch->SearchCondition = @$filter["v_d_operator"];
		$this->d_operator->AdvancedSearch->SearchValue2 = @$filter["y_d_operator"];
		$this->d_operator->AdvancedSearch->SearchOperator2 = @$filter["w_d_operator"];
		$this->d_operator->AdvancedSearch->save();

		// Field d_datetime
		$this->d_datetime->AdvancedSearch->SearchValue = @$filter["x_d_datetime"];
		$this->d_datetime->AdvancedSearch->SearchOperator = @$filter["z_d_datetime"];
		$this->d_datetime->AdvancedSearch->SearchCondition = @$filter["v_d_datetime"];
		$this->d_datetime->AdvancedSearch->SearchValue2 = @$filter["y_d_datetime"];
		$this->d_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_d_datetime"];
		$this->d_datetime->AdvancedSearch->save();

		// Field no_of_emi
		$this->no_of_emi->AdvancedSearch->SearchValue = @$filter["x_no_of_emi"];
		$this->no_of_emi->AdvancedSearch->SearchOperator = @$filter["z_no_of_emi"];
		$this->no_of_emi->AdvancedSearch->SearchCondition = @$filter["v_no_of_emi"];
		$this->no_of_emi->AdvancedSearch->SearchValue2 = @$filter["y_no_of_emi"];
		$this->no_of_emi->AdvancedSearch->SearchOperator2 = @$filter["w_no_of_emi"];
		$this->no_of_emi->AdvancedSearch->save();

		// Field fund_o
		$this->fund_o->AdvancedSearch->SearchValue = @$filter["x_fund_o"];
		$this->fund_o->AdvancedSearch->SearchOperator = @$filter["z_fund_o"];
		$this->fund_o->AdvancedSearch->SearchCondition = @$filter["v_fund_o"];
		$this->fund_o->AdvancedSearch->SearchValue2 = @$filter["y_fund_o"];
		$this->fund_o->AdvancedSearch->SearchOperator2 = @$filter["w_fund_o"];
		$this->fund_o->AdvancedSearch->save();

		// Field fund_o_no
		$this->fund_o_no->AdvancedSearch->SearchValue = @$filter["x_fund_o_no"];
		$this->fund_o_no->AdvancedSearch->SearchOperator = @$filter["z_fund_o_no"];
		$this->fund_o_no->AdvancedSearch->SearchCondition = @$filter["v_fund_o_no"];
		$this->fund_o_no->AdvancedSearch->SearchValue2 = @$filter["y_fund_o_no"];
		$this->fund_o_no->AdvancedSearch->SearchOperator2 = @$filter["w_fund_o_no"];
		$this->fund_o_no->AdvancedSearch->save();

		// Field int_@
		$this->int_40->AdvancedSearch->SearchValue = @$filter["x_int_40"];
		$this->int_40->AdvancedSearch->SearchOperator = @$filter["z_int_40"];
		$this->int_40->AdvancedSearch->SearchCondition = @$filter["v_int_40"];
		$this->int_40->AdvancedSearch->SearchValue2 = @$filter["y_int_40"];
		$this->int_40->AdvancedSearch->SearchOperator2 = @$filter["w_int_40"];
		$this->int_40->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->b_type, $default, FALSE); // b_type
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->branch, $default, FALSE); // branch
		$this->buildSearchSql($where, $this->category, $default, FALSE); // category
		$this->buildSearchSql($where, $this->account_type, $default, FALSE); // account_type
		$this->buildSearchSql($where, $this->type, $default, FALSE); // type
		$this->buildSearchSql($where, $this->formal_name, $default, FALSE); // formal_name
		$this->buildSearchSql($where, $this->mobile, $default, FALSE); // mobile
		$this->buildSearchSql($where, $this->_email, $default, FALSE); // email
		$this->buildSearchSql($where, $this->image, $default, FALSE); // image
		$this->buildSearchSql($where, $this->sign_image, $default, FALSE); // sign_image
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->aadhaar_no, $default, FALSE); // aadhaar_no
		$this->buildSearchSql($where, $this->pan_no, $default, FALSE); // pan_no
		$this->buildSearchSql($where, $this->id_proof, $default, FALSE); // id_proof
		$this->buildSearchSql($where, $this->agent, $default, FALSE); // agent
		$this->buildSearchSql($where, $this->other_details, $default, FALSE); // other_details
		$this->buildSearchSql($where, $this->bank_name, $default, FALSE); // bank_name
		$this->buildSearchSql($where, $this->bank_ifsc_code, $default, FALSE); // bank_ifsc_code
		$this->buildSearchSql($where, $this->bank_account_no, $default, FALSE); // bank_account_no
		$this->buildSearchSql($where, $this->account_no, $default, FALSE); // account_no
		$this->buildSearchSql($where, $this->loan_amount, $default, FALSE); // loan_amount
		$this->buildSearchSql($where, $this->emi_amount, $default, FALSE); // emi_amount
		$this->buildSearchSql($where, $this->frequency, $default, FALSE); // frequency
		$this->buildSearchSql($where, $this->disbursement_amount, $default, FALSE); // disbursement_amount
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->d_operator, $default, FALSE); // d_operator
		$this->buildSearchSql($where, $this->d_datetime, $default, FALSE); // d_datetime
		$this->buildSearchSql($where, $this->no_of_emi, $default, FALSE); // no_of_emi
		$this->buildSearchSql($where, $this->fund_o, $default, FALSE); // fund_o
		$this->buildSearchSql($where, $this->fund_o_no, $default, FALSE); // fund_o_no
		$this->buildSearchSql($where, $this->int_40, $default, FALSE); // int_@

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->b_type->AdvancedSearch->save(); // b_type
			$this->grp->AdvancedSearch->save(); // grp
			$this->branch->AdvancedSearch->save(); // branch
			$this->category->AdvancedSearch->save(); // category
			$this->account_type->AdvancedSearch->save(); // account_type
			$this->type->AdvancedSearch->save(); // type
			$this->formal_name->AdvancedSearch->save(); // formal_name
			$this->mobile->AdvancedSearch->save(); // mobile
			$this->_email->AdvancedSearch->save(); // email
			$this->image->AdvancedSearch->save(); // image
			$this->sign_image->AdvancedSearch->save(); // sign_image
			$this->status->AdvancedSearch->save(); // status
			$this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
			$this->pan_no->AdvancedSearch->save(); // pan_no
			$this->id_proof->AdvancedSearch->save(); // id_proof
			$this->agent->AdvancedSearch->save(); // agent
			$this->other_details->AdvancedSearch->save(); // other_details
			$this->bank_name->AdvancedSearch->save(); // bank_name
			$this->bank_ifsc_code->AdvancedSearch->save(); // bank_ifsc_code
			$this->bank_account_no->AdvancedSearch->save(); // bank_account_no
			$this->account_no->AdvancedSearch->save(); // account_no
			$this->loan_amount->AdvancedSearch->save(); // loan_amount
			$this->emi_amount->AdvancedSearch->save(); // emi_amount
			$this->frequency->AdvancedSearch->save(); // frequency
			$this->disbursement_amount->AdvancedSearch->save(); // disbursement_amount
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->d_operator->AdvancedSearch->save(); // d_operator
			$this->d_datetime->AdvancedSearch->save(); // d_datetime
			$this->no_of_emi->AdvancedSearch->save(); // no_of_emi
			$this->fund_o->AdvancedSearch->save(); // fund_o
			$this->fund_o_no->AdvancedSearch->save(); // fund_o_no
			$this->int_40->AdvancedSearch->save(); // int_@
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->category, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->formal_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_email, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->image, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sign_image, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->aadhaar_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pan_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->id_proof, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->agent, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->other_details, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->bank_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->bank_ifsc_code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->bank_account_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->account_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->fund_o_no, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->b_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->branch->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->category->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->account_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->formal_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->mobile->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_email->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->image->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sign_image->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->aadhaar_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pan_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_proof->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->agent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->other_details->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->bank_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->bank_ifsc_code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->bank_account_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->account_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->loan_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->emi_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->frequency->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->disbursement_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->no_of_emi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fund_o->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fund_o_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->int_40->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->b_type->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->branch->AdvancedSearch->unsetSession();
		$this->category->AdvancedSearch->unsetSession();
		$this->account_type->AdvancedSearch->unsetSession();
		$this->type->AdvancedSearch->unsetSession();
		$this->formal_name->AdvancedSearch->unsetSession();
		$this->mobile->AdvancedSearch->unsetSession();
		$this->_email->AdvancedSearch->unsetSession();
		$this->image->AdvancedSearch->unsetSession();
		$this->sign_image->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->aadhaar_no->AdvancedSearch->unsetSession();
		$this->pan_no->AdvancedSearch->unsetSession();
		$this->id_proof->AdvancedSearch->unsetSession();
		$this->agent->AdvancedSearch->unsetSession();
		$this->other_details->AdvancedSearch->unsetSession();
		$this->bank_name->AdvancedSearch->unsetSession();
		$this->bank_ifsc_code->AdvancedSearch->unsetSession();
		$this->bank_account_no->AdvancedSearch->unsetSession();
		$this->account_no->AdvancedSearch->unsetSession();
		$this->loan_amount->AdvancedSearch->unsetSession();
		$this->emi_amount->AdvancedSearch->unsetSession();
		$this->frequency->AdvancedSearch->unsetSession();
		$this->disbursement_amount->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->d_operator->AdvancedSearch->unsetSession();
		$this->d_datetime->AdvancedSearch->unsetSession();
		$this->no_of_emi->AdvancedSearch->unsetSession();
		$this->fund_o->AdvancedSearch->unsetSession();
		$this->fund_o_no->AdvancedSearch->unsetSession();
		$this->int_40->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->b_type->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->branch->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->account_type->AdvancedSearch->load();
		$this->type->AdvancedSearch->load();
		$this->formal_name->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->sign_image->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->aadhaar_no->AdvancedSearch->load();
		$this->pan_no->AdvancedSearch->load();
		$this->id_proof->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->other_details->AdvancedSearch->load();
		$this->bank_name->AdvancedSearch->load();
		$this->bank_ifsc_code->AdvancedSearch->load();
		$this->bank_account_no->AdvancedSearch->load();
		$this->account_no->AdvancedSearch->load();
		$this->loan_amount->AdvancedSearch->load();
		$this->emi_amount->AdvancedSearch->load();
		$this->frequency->AdvancedSearch->load();
		$this->disbursement_amount->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->d_operator->AdvancedSearch->load();
		$this->d_datetime->AdvancedSearch->load();
		$this->no_of_emi->AdvancedSearch->load();
		$this->fund_o->AdvancedSearch->load();
		$this->fund_o_no->AdvancedSearch->load();
		$this->int_40->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id); // id
			$this->updateSort($this->b_type); // b_type
			$this->updateSort($this->grp); // grp
			$this->updateSort($this->branch); // branch
			$this->updateSort($this->account_type); // account_type
			$this->updateSort($this->type); // type
			$this->updateSort($this->formal_name); // formal_name
			$this->updateSort($this->mobile); // mobile
			$this->updateSort($this->agent); // agent
			$this->updateSort($this->account_no); // account_no
			$this->updateSort($this->loan_amount); // loan_amount
			$this->updateSort($this->emi_amount); // emi_amount
			$this->updateSort($this->frequency); // frequency
			$this->updateSort($this->disbursement_amount); // disbursement_amount
			$this->updateSort($this->datetime); // datetime
			$this->updateSort($this->otp_delivery_datetime); // otp_delivery_datetime
			$this->updateSort($this->otp_verify_datetime); // otp_verify_datetime
			$this->updateSort($this->no_of_emi); // no_of_emi
			$this->updateSort($this->fund_o); // fund_o
			$this->updateSort($this->fund_o_no); // fund_o_no
			$this->updateSort($this->int_40); // int_@
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->b_type->setSort("");
				$this->grp->setSort("");
				$this->branch->setSort("");
				$this->account_type->setSort("");
				$this->type->setSort("");
				$this->formal_name->setSort("");
				$this->mobile->setSort("");
				$this->agent->setSort("");
				$this->account_no->setSort("");
				$this->loan_amount->setSort("");
				$this->emi_amount->setSort("");
				$this->frequency->setSort("");
				$this->disbursement_amount->setSort("");
				$this->datetime->setSort("");
				$this->otp_delivery_datetime->setSort("");
				$this->otp_verify_datetime->setSort("");
				$this->no_of_emi->setSort("");
				$this->fund_o->setSort("");
				$this->fund_o_no->setSort("");
				$this->int_40->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = TRUE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Add multi update
		$item = &$option->add("multiupdate");
		$item->Body = "<a class=\"ew-action ew-multi-update\" title=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" data-table=\"b_account_info\" data-caption=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" href=\"\" onclick=\"ew.modalDialogShow({lnk:this,btn:'UpdateBtn',f:document.fb_account_infolist,url:'" . $this->MultiUpdateUrl . "'});return false;\">" . $Language->phrase("UpdateSelectedLink") . "</a>";
		$item->Visible = ($Security->canEdit());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fb_account_infolistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fb_account_infolistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fb_account_infolist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fb_account_infolistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"b_account_infosrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"b_account_info\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'b_account_infosrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fb_account_infolistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// b_type

		if (!$this->isAddOrEdit())
			$this->b_type->AdvancedSearch->setSearchValue(Get("x_b_type", Get("b_type", "")));
		if ($this->b_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_type->AdvancedSearch->setSearchOperator(Get("z_b_type", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// branch
		if (!$this->isAddOrEdit())
			$this->branch->AdvancedSearch->setSearchValue(Get("x_branch", Get("branch", "")));
		if ($this->branch->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->branch->AdvancedSearch->setSearchOperator(Get("z_branch", ""));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue(Get("x_category", Get("category", "")));
		if ($this->category->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->category->AdvancedSearch->setSearchOperator(Get("z_category", ""));

		// account_type
		if (!$this->isAddOrEdit())
			$this->account_type->AdvancedSearch->setSearchValue(Get("x_account_type", Get("account_type", "")));
		if ($this->account_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->account_type->AdvancedSearch->setSearchOperator(Get("z_account_type", ""));

		// type
		if (!$this->isAddOrEdit())
			$this->type->AdvancedSearch->setSearchValue(Get("x_type", Get("type", "")));
		if ($this->type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->type->AdvancedSearch->setSearchOperator(Get("z_type", ""));

		// formal_name
		if (!$this->isAddOrEdit())
			$this->formal_name->AdvancedSearch->setSearchValue(Get("x_formal_name", Get("formal_name", "")));
		if ($this->formal_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->formal_name->AdvancedSearch->setSearchOperator(Get("z_formal_name", ""));

		// mobile
		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue(Get("x_mobile", Get("mobile", "")));
		if ($this->mobile->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->mobile->AdvancedSearch->setSearchOperator(Get("z_mobile", ""));

		// email
		if (!$this->isAddOrEdit())
			$this->_email->AdvancedSearch->setSearchValue(Get("x__email", Get("_email", "")));
		if ($this->_email->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_email->AdvancedSearch->setSearchOperator(Get("z__email", ""));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue(Get("x_image", Get("image", "")));
		if ($this->image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->image->AdvancedSearch->setSearchOperator(Get("z_image", ""));

		// sign_image
		if (!$this->isAddOrEdit())
			$this->sign_image->AdvancedSearch->setSearchValue(Get("x_sign_image", Get("sign_image", "")));
		if ($this->sign_image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sign_image->AdvancedSearch->setSearchOperator(Get("z_sign_image", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// aadhaar_no
		if (!$this->isAddOrEdit())
			$this->aadhaar_no->AdvancedSearch->setSearchValue(Get("x_aadhaar_no", Get("aadhaar_no", "")));
		if ($this->aadhaar_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->aadhaar_no->AdvancedSearch->setSearchOperator(Get("z_aadhaar_no", ""));

		// pan_no
		if (!$this->isAddOrEdit())
			$this->pan_no->AdvancedSearch->setSearchValue(Get("x_pan_no", Get("pan_no", "")));
		if ($this->pan_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pan_no->AdvancedSearch->setSearchOperator(Get("z_pan_no", ""));

		// id_proof
		if (!$this->isAddOrEdit())
			$this->id_proof->AdvancedSearch->setSearchValue(Get("x_id_proof", Get("id_proof", "")));
		if ($this->id_proof->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id_proof->AdvancedSearch->setSearchOperator(Get("z_id_proof", ""));

		// agent
		if (!$this->isAddOrEdit())
			$this->agent->AdvancedSearch->setSearchValue(Get("x_agent", Get("agent", "")));
		if ($this->agent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->agent->AdvancedSearch->setSearchOperator(Get("z_agent", ""));

		// other_details
		if (!$this->isAddOrEdit())
			$this->other_details->AdvancedSearch->setSearchValue(Get("x_other_details", Get("other_details", "")));
		if ($this->other_details->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->other_details->AdvancedSearch->setSearchOperator(Get("z_other_details", ""));

		// bank_name
		if (!$this->isAddOrEdit())
			$this->bank_name->AdvancedSearch->setSearchValue(Get("x_bank_name", Get("bank_name", "")));
		if ($this->bank_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->bank_name->AdvancedSearch->setSearchOperator(Get("z_bank_name", ""));

		// bank_ifsc_code
		if (!$this->isAddOrEdit())
			$this->bank_ifsc_code->AdvancedSearch->setSearchValue(Get("x_bank_ifsc_code", Get("bank_ifsc_code", "")));
		if ($this->bank_ifsc_code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->bank_ifsc_code->AdvancedSearch->setSearchOperator(Get("z_bank_ifsc_code", ""));

		// bank_account_no
		if (!$this->isAddOrEdit())
			$this->bank_account_no->AdvancedSearch->setSearchValue(Get("x_bank_account_no", Get("bank_account_no", "")));
		if ($this->bank_account_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->bank_account_no->AdvancedSearch->setSearchOperator(Get("z_bank_account_no", ""));

		// account_no
		if (!$this->isAddOrEdit())
			$this->account_no->AdvancedSearch->setSearchValue(Get("x_account_no", Get("account_no", "")));
		if ($this->account_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->account_no->AdvancedSearch->setSearchOperator(Get("z_account_no", ""));

		// loan_amount
		if (!$this->isAddOrEdit())
			$this->loan_amount->AdvancedSearch->setSearchValue(Get("x_loan_amount", Get("loan_amount", "")));
		if ($this->loan_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->loan_amount->AdvancedSearch->setSearchOperator(Get("z_loan_amount", ""));

		// emi_amount
		if (!$this->isAddOrEdit())
			$this->emi_amount->AdvancedSearch->setSearchValue(Get("x_emi_amount", Get("emi_amount", "")));
		if ($this->emi_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->emi_amount->AdvancedSearch->setSearchOperator(Get("z_emi_amount", ""));

		// frequency
		if (!$this->isAddOrEdit())
			$this->frequency->AdvancedSearch->setSearchValue(Get("x_frequency", Get("frequency", "")));
		if ($this->frequency->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->frequency->AdvancedSearch->setSearchOperator(Get("z_frequency", ""));

		// disbursement_amount
		if (!$this->isAddOrEdit())
			$this->disbursement_amount->AdvancedSearch->setSearchValue(Get("x_disbursement_amount", Get("disbursement_amount", "")));
		if ($this->disbursement_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->disbursement_amount->AdvancedSearch->setSearchOperator(Get("z_disbursement_amount", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchCondition(Get("v_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchValue2(Get("y_datetime", ""));
		if ($this->datetime->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator2(Get("w_datetime", ""));

		// d_operator
		if (!$this->isAddOrEdit())
			$this->d_operator->AdvancedSearch->setSearchValue(Get("x_d_operator", Get("d_operator", "")));
		if ($this->d_operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_operator->AdvancedSearch->setSearchOperator(Get("z_d_operator", ""));

		// d_datetime
		if (!$this->isAddOrEdit())
			$this->d_datetime->AdvancedSearch->setSearchValue(Get("x_d_datetime", Get("d_datetime", "")));
		if ($this->d_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_datetime->AdvancedSearch->setSearchOperator(Get("z_d_datetime", ""));

		// no_of_emi
		if (!$this->isAddOrEdit())
			$this->no_of_emi->AdvancedSearch->setSearchValue(Get("x_no_of_emi", Get("no_of_emi", "")));
		if ($this->no_of_emi->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->no_of_emi->AdvancedSearch->setSearchOperator(Get("z_no_of_emi", ""));

		// fund_o
		if (!$this->isAddOrEdit())
			$this->fund_o->AdvancedSearch->setSearchValue(Get("x_fund_o", Get("fund_o", "")));
		if ($this->fund_o->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fund_o->AdvancedSearch->setSearchOperator(Get("z_fund_o", ""));

		// fund_o_no
		if (!$this->isAddOrEdit())
			$this->fund_o_no->AdvancedSearch->setSearchValue(Get("x_fund_o_no", Get("fund_o_no", "")));
		if ($this->fund_o_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fund_o_no->AdvancedSearch->setSearchOperator(Get("z_fund_o_no", ""));

		// int_@
		if (!$this->isAddOrEdit())
			$this->int_40->AdvancedSearch->setSearchValue(Get("x_int_40", Get("int_40", "")));
		if ($this->int_40->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->int_40->AdvancedSearch->setSearchOperator(Get("z_int_40", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->b_type->setDbValue($row['b_type']);
		$this->grp->setDbValue($row['grp']);
		$this->branch->setDbValue($row['branch']);
		$this->category->setDbValue($row['category']);
		$this->account_type->setDbValue($row['account_type']);
		$this->type->setDbValue($row['type']);
		$this->formal_name->setDbValue($row['formal_name']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->sign_image->Upload->DbValue = $row['sign_image'];
		$this->sign_image->setDbValue($this->sign_image->Upload->DbValue);
		$this->status->setDbValue($row['status']);
		$this->aadhaar_no->setDbValue($row['aadhaar_no']);
		$this->pan_no->setDbValue($row['pan_no']);
		$this->id_proof->Upload->DbValue = $row['id_proof'];
		$this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
		$this->agent->setDbValue($row['agent']);
		$this->other_details->setDbValue($row['other_details']);
		$this->bank_name->setDbValue($row['bank_name']);
		$this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
		$this->bank_account_no->setDbValue($row['bank_account_no']);
		$this->account_no->setDbValue($row['account_no']);
		$this->loan_amount->setDbValue($row['loan_amount']);
		$this->emi_amount->setDbValue($row['emi_amount']);
		$this->frequency->setDbValue($row['frequency']);
		$this->disbursement_amount->setDbValue($row['disbursement_amount']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->d_operator->setDbValue($row['d_operator']);
		$this->d_datetime->setDbValue($row['d_datetime']);
		$this->otp->setDbValue($row['otp']);
		$this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
		$this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
		$this->no_of_emi->setDbValue($row['no_of_emi']);
		$this->fund_o->setDbValue($row['fund_o']);
		$this->fund_o_no->setDbValue($row['fund_o_no']);
		$this->int_40->setDbValue($row['int_@']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['b_type'] = NULL;
		$row['grp'] = NULL;
		$row['branch'] = NULL;
		$row['category'] = NULL;
		$row['account_type'] = NULL;
		$row['type'] = NULL;
		$row['formal_name'] = NULL;
		$row['mobile'] = NULL;
		$row['email'] = NULL;
		$row['image'] = NULL;
		$row['sign_image'] = NULL;
		$row['status'] = NULL;
		$row['aadhaar_no'] = NULL;
		$row['pan_no'] = NULL;
		$row['id_proof'] = NULL;
		$row['agent'] = NULL;
		$row['other_details'] = NULL;
		$row['bank_name'] = NULL;
		$row['bank_ifsc_code'] = NULL;
		$row['bank_account_no'] = NULL;
		$row['account_no'] = NULL;
		$row['loan_amount'] = NULL;
		$row['emi_amount'] = NULL;
		$row['frequency'] = NULL;
		$row['disbursement_amount'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['d_operator'] = NULL;
		$row['d_datetime'] = NULL;
		$row['otp'] = NULL;
		$row['otp_delivery_datetime'] = NULL;
		$row['otp_verify_datetime'] = NULL;
		$row['no_of_emi'] = NULL;
		$row['fund_o'] = NULL;
		$row['fund_o_no'] = NULL;
		$row['int_@'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->loan_amount->FormValue == $this->loan_amount->CurrentValue && is_numeric(ConvertToFloatString($this->loan_amount->CurrentValue)))
			$this->loan_amount->CurrentValue = ConvertToFloatString($this->loan_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->emi_amount->FormValue == $this->emi_amount->CurrentValue && is_numeric(ConvertToFloatString($this->emi_amount->CurrentValue)))
			$this->emi_amount->CurrentValue = ConvertToFloatString($this->emi_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->disbursement_amount->FormValue == $this->disbursement_amount->CurrentValue && is_numeric(ConvertToFloatString($this->disbursement_amount->CurrentValue)))
			$this->disbursement_amount->CurrentValue = ConvertToFloatString($this->disbursement_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fund_o->FormValue == $this->fund_o->CurrentValue && is_numeric(ConvertToFloatString($this->fund_o->CurrentValue)))
			$this->fund_o->CurrentValue = ConvertToFloatString($this->fund_o->CurrentValue);

		// Convert decimal values if posted back
		if ($this->int_40->FormValue == $this->int_40->CurrentValue && is_numeric(ConvertToFloatString($this->int_40->CurrentValue)))
			$this->int_40->CurrentValue = ConvertToFloatString($this->int_40->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// b_type
		// grp

		$this->grp->CellCssStyle = "white-space: nowrap;";

		// branch
		// category
		// account_type
		// type
		// formal_name
		// mobile
		// email
		// image
		// sign_image
		// status
		// aadhaar_no
		// pan_no
		// id_proof
		// agent
		// other_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// account_no
		// loan_amount
		// emi_amount
		// frequency
		// disbursement_amount
		// operator
		// datetime
		// d_operator
		// d_datetime
		// otp

		$this->otp->CellCssStyle = "white-space: nowrap;";

		// otp_delivery_datetime
		$this->otp_delivery_datetime->CellCssStyle = "white-space: nowrap;";

		// otp_verify_datetime
		$this->otp_verify_datetime->CellCssStyle = "white-space: nowrap;";

		// no_of_emi
		// fund_o
		// fund_o_no
		// int_@
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->loan_amount->CurrentValue))
				$this->loan_amount->Total += $this->loan_amount->CurrentValue; // Accumulate total
			if (is_numeric($this->emi_amount->CurrentValue))
				$this->emi_amount->Total += $this->emi_amount->CurrentValue; // Accumulate total
			if (is_numeric($this->disbursement_amount->CurrentValue))
				$this->disbursement_amount->Total += $this->disbursement_amount->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// b_type
			if (strval($this->b_type->CurrentValue) <> "") {
				$this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
			} else {
				$this->b_type->ViewValue = NULL;
			}
			$this->b_type->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// branch
			$curVal = strval($this->branch->CurrentValue);
			if ($curVal <> "") {
				$this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
				if ($this->branch->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->branch->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->branch->ViewValue = $this->branch->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->branch->ViewValue = $this->branch->CurrentValue;
					}
				}
			} else {
				$this->branch->ViewValue = NULL;
			}
			$this->branch->ViewCustomAttributes = "";

			// category
			if (strval($this->category->CurrentValue) <> "") {
				$this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// account_type
			$this->account_type->ViewValue = $this->account_type->CurrentValue;
			$this->account_type->ViewValue = FormatNumber($this->account_type->ViewValue, 0, -2, -2, -2);
			$this->account_type->ViewCustomAttributes = "";

			// type
			$curVal = strval($this->type->CurrentValue);
			if ($curVal <> "") {
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->type->ViewValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->ViewValue = $this->type->CurrentValue;
					}
				}
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
			$this->formal_name->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// sign_image
			$this->sign_image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->sign_image->Upload->DbValue)) {
				$this->sign_image->ViewValue = $this->sign_image->Upload->DbValue;
			} else {
				$this->sign_image->ViewValue = "";
			}
			$this->sign_image->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// id_proof
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->ViewValue = "";
			}
			$this->id_proof->ViewCustomAttributes = "";

			// agent
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel` = 1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			$this->agent->ViewCustomAttributes = "";

			// bank_name
			$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
			$this->bank_name->ViewCustomAttributes = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
			$this->bank_ifsc_code->ViewCustomAttributes = "";

			// bank_account_no
			$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
			$this->bank_account_no->ViewCustomAttributes = "";

			// account_no
			$this->account_no->ViewValue = $this->account_no->CurrentValue;
			$this->account_no->ViewCustomAttributes = "";

			// loan_amount
			$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
			$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
			$this->loan_amount->ViewCustomAttributes = "";

			// emi_amount
			$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
			$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
			$this->emi_amount->ViewCustomAttributes = "";

			// frequency
			if (strval($this->frequency->CurrentValue) <> "") {
				$this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
			} else {
				$this->frequency->ViewValue = NULL;
			}
			$this->frequency->ViewCustomAttributes = "";

			// disbursement_amount
			$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
			$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
			$this->disbursement_amount->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// d_operator
			$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
			$this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, 0, -2, -2, -2);
			$this->d_operator->ViewCustomAttributes = "";

			// d_datetime
			$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
			$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 0);
			$this->d_datetime->ViewCustomAttributes = "";

			// otp_delivery_datetime
			$this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
			$this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, 0);
			$this->otp_delivery_datetime->ViewCustomAttributes = "";

			// otp_verify_datetime
			$this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
			$this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, 0);
			$this->otp_verify_datetime->ViewCustomAttributes = "";

			// no_of_emi
			$this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
			$this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, 0, -2, -2, -2);
			$this->no_of_emi->ViewCustomAttributes = "";

			// fund_o
			$this->fund_o->ViewValue = $this->fund_o->CurrentValue;
			$this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, 2, -2, -2, -2);
			$this->fund_o->ViewCustomAttributes = "";

			// fund_o_no
			$curVal = strval($this->fund_o_no->CurrentValue);
			if ($curVal <> "") {
				$this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
				if ($this->fund_o_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`= 230401";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->fund_o_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
					}
				}
			} else {
				$this->fund_o_no->ViewValue = NULL;
			}
			$this->fund_o_no->ViewCustomAttributes = "";

			// int_@
			$this->int_40->ViewValue = $this->int_40->CurrentValue;
			$this->int_40->ViewValue = FormatNumber($this->int_40->ViewValue, 2, -2, -2, -2);
			$this->int_40->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// b_type
			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";
			$this->b_type->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// branch
			$this->branch->LinkCustomAttributes = "";
			$this->branch->HrefValue = "";
			$this->branch->TooltipValue = "";

			// account_type
			$this->account_type->LinkCustomAttributes = "";
			$this->account_type->HrefValue = "";
			$this->account_type->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";
			$this->formal_name->TooltipValue = "";
			if (!$this->isExport())
				$this->formal_name->ViewValue = $this->highlightValue($this->formal_name);

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// account_no
			$this->account_no->LinkCustomAttributes = "";
			$this->account_no->HrefValue = "";
			$this->account_no->TooltipValue = "";
			if (!$this->isExport())
				$this->account_no->ViewValue = $this->highlightValue($this->account_no);

			// loan_amount
			$this->loan_amount->LinkCustomAttributes = "";
			$this->loan_amount->HrefValue = "";
			$this->loan_amount->TooltipValue = "";

			// emi_amount
			$this->emi_amount->LinkCustomAttributes = "";
			$this->emi_amount->HrefValue = "";
			$this->emi_amount->TooltipValue = "";

			// frequency
			$this->frequency->LinkCustomAttributes = "";
			$this->frequency->HrefValue = "";
			$this->frequency->TooltipValue = "";

			// disbursement_amount
			$this->disbursement_amount->LinkCustomAttributes = "";
			$this->disbursement_amount->HrefValue = "";
			$this->disbursement_amount->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// otp_delivery_datetime
			$this->otp_delivery_datetime->LinkCustomAttributes = "";
			$this->otp_delivery_datetime->HrefValue = "";
			$this->otp_delivery_datetime->TooltipValue = "";

			// otp_verify_datetime
			$this->otp_verify_datetime->LinkCustomAttributes = "";
			$this->otp_verify_datetime->HrefValue = "";
			$this->otp_verify_datetime->TooltipValue = "";

			// no_of_emi
			$this->no_of_emi->LinkCustomAttributes = "";
			$this->no_of_emi->HrefValue = "";
			$this->no_of_emi->TooltipValue = "";

			// fund_o
			$this->fund_o->LinkCustomAttributes = "";
			$this->fund_o->HrefValue = "";
			$this->fund_o->TooltipValue = "";

			// fund_o_no
			$this->fund_o_no->LinkCustomAttributes = "";
			$this->fund_o_no->HrefValue = "";
			$this->fund_o_no->TooltipValue = "";

			// int_@
			$this->int_40->LinkCustomAttributes = "";
			$this->int_40->HrefValue = "";
			$this->int_40->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// b_type
			$this->b_type->EditAttrs["class"] = "form-control";
			$this->b_type->EditCustomAttributes = "";
			$this->b_type->EditValue = $this->b_type->options(TRUE);

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";

			// branch
			$this->branch->EditAttrs["class"] = "form-control";
			$this->branch->EditCustomAttributes = "";

			// account_type
			$this->account_type->EditAttrs["class"] = "form-control";
			$this->account_type->EditCustomAttributes = "";
			$this->account_type->EditValue = HtmlEncode($this->account_type->AdvancedSearch->SearchValue);
			$this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";

			// formal_name
			$this->formal_name->EditAttrs["class"] = "form-control";
			$this->formal_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->formal_name->AdvancedSearch->SearchValue = HtmlDecode($this->formal_name->AdvancedSearch->SearchValue);
			$this->formal_name->EditValue = HtmlEncode($this->formal_name->AdvancedSearch->SearchValue);
			$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$curVal = trim(strval($this->agent->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->agent->AdvancedSearch->ViewValue = $this->agent->lookupCacheOption($curVal);
			else
				$this->agent->AdvancedSearch->ViewValue = $this->agent->Lookup !== NULL && is_array($this->agent->Lookup->Options) ? $curVal : NULL;
			if ($this->agent->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->agent->EditValue = array_values($this->agent->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->agent->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`userlevel` = 1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->agent->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->agent->EditValue = $arwrk;
			}

			// account_no
			$this->account_no->EditAttrs["class"] = "form-control";
			$this->account_no->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->account_no->AdvancedSearch->SearchValue = HtmlDecode($this->account_no->AdvancedSearch->SearchValue);
			$this->account_no->EditValue = HtmlEncode($this->account_no->AdvancedSearch->SearchValue);
			$this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

			// loan_amount
			$this->loan_amount->EditAttrs["class"] = "form-control";
			$this->loan_amount->EditCustomAttributes = "";
			$this->loan_amount->EditValue = HtmlEncode($this->loan_amount->AdvancedSearch->SearchValue);
			$this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());

			// emi_amount
			$this->emi_amount->EditAttrs["class"] = "form-control";
			$this->emi_amount->EditCustomAttributes = "";
			$this->emi_amount->EditValue = HtmlEncode($this->emi_amount->AdvancedSearch->SearchValue);
			$this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());

			// frequency
			$this->frequency->EditAttrs["class"] = "form-control";
			$this->frequency->EditCustomAttributes = "";
			$this->frequency->EditValue = $this->frequency->options(TRUE);

			// disbursement_amount
			$this->disbursement_amount->EditAttrs["class"] = "form-control";
			$this->disbursement_amount->EditCustomAttributes = "";
			$this->disbursement_amount->EditValue = HtmlEncode($this->disbursement_amount->AdvancedSearch->SearchValue);
			$this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// otp_delivery_datetime
			$this->otp_delivery_datetime->EditAttrs["class"] = "form-control";
			$this->otp_delivery_datetime->EditCustomAttributes = "";
			$this->otp_delivery_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->otp_delivery_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->otp_delivery_datetime->PlaceHolder = RemoveHtml($this->otp_delivery_datetime->caption());

			// otp_verify_datetime
			$this->otp_verify_datetime->EditAttrs["class"] = "form-control";
			$this->otp_verify_datetime->EditCustomAttributes = "";
			$this->otp_verify_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->otp_verify_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->otp_verify_datetime->PlaceHolder = RemoveHtml($this->otp_verify_datetime->caption());

			// no_of_emi
			$this->no_of_emi->EditAttrs["class"] = "form-control";
			$this->no_of_emi->EditCustomAttributes = "";
			$this->no_of_emi->EditValue = HtmlEncode($this->no_of_emi->AdvancedSearch->SearchValue);
			$this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

			// fund_o
			$this->fund_o->EditAttrs["class"] = "form-control";
			$this->fund_o->EditCustomAttributes = "";
			$this->fund_o->EditValue = HtmlEncode($this->fund_o->AdvancedSearch->SearchValue);
			$this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());

			// fund_o_no
			$this->fund_o_no->EditAttrs["class"] = "form-control";
			$this->fund_o_no->EditCustomAttributes = "";

			// int_@
			$this->int_40->EditAttrs["class"] = "form-control";
			$this->int_40->EditCustomAttributes = "";
			$this->int_40->EditValue = HtmlEncode($this->int_40->AdvancedSearch->SearchValue);
			$this->int_40->PlaceHolder = RemoveHtml($this->int_40->caption());
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->loan_amount->Total = 0; // Initialize total
			$this->emi_amount->Total = 0; // Initialize total
			$this->disbursement_amount->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->loan_amount->CurrentValue = $this->loan_amount->Total;
			$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
			$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
			$this->loan_amount->ViewCustomAttributes = "";
			$this->loan_amount->HrefValue = ""; // Clear href value
			$this->emi_amount->CurrentValue = $this->emi_amount->Total;
			$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
			$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
			$this->emi_amount->ViewCustomAttributes = "";
			$this->emi_amount->HrefValue = ""; // Clear href value
			$this->disbursement_amount->CurrentValue = $this->disbursement_amount->Total;
			$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
			$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
			$this->disbursement_amount->ViewCustomAttributes = "";
			$this->disbursement_amount->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->b_type->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->branch->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->account_type->AdvancedSearch->load();
		$this->type->AdvancedSearch->load();
		$this->formal_name->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->sign_image->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->aadhaar_no->AdvancedSearch->load();
		$this->pan_no->AdvancedSearch->load();
		$this->id_proof->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->other_details->AdvancedSearch->load();
		$this->bank_name->AdvancedSearch->load();
		$this->bank_ifsc_code->AdvancedSearch->load();
		$this->bank_account_no->AdvancedSearch->load();
		$this->account_no->AdvancedSearch->load();
		$this->loan_amount->AdvancedSearch->load();
		$this->emi_amount->AdvancedSearch->load();
		$this->frequency->AdvancedSearch->load();
		$this->disbursement_amount->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->d_operator->AdvancedSearch->load();
		$this->d_datetime->AdvancedSearch->load();
		$this->no_of_emi->AdvancedSearch->load();
		$this->fund_o->AdvancedSearch->load();
		$this->fund_o_no->AdvancedSearch->load();
		$this->int_40->AdvancedSearch->load();
	}

	// Build export filter for selected records
	protected function buildExportSelectedFilter()
	{
		global $Language;
		$wrkFilter = "";
		if ($this->isExport())
			$wrkFilter = $this->getFilterFromRecordKeys();
		return $wrkFilter;
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','excel',true,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','excel',false,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','word',true,true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','word',false,true);\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','pdf',true,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','pdf',false,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','html',false,true);\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','xml',false,true);\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','csv',false,true);\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" onclick=\"ew.export(document.fb_account_infolist,'" . CurrentPageName() . "','print',false,true);\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_b_account_info\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_b_account_info',hdr:ew.language.phrase('ExportToEmailText'),f:document.fb_account_infolist,sel:true" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`id`>9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_branch":
					$lookupFilter = function() {
						return "`id` > 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`userlevel` = 1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_fund_o_no":
					$lookupFilter = function() {
						return "`grp`= 230401";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_branch":
							break;
						case "x_type":
							break;
						case "x_status":
							break;
						case "x_agent":
							break;
						case "x_fund_o_no":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'account_info');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

		$this->ListOptions->Add("View Ledger Book"); // Replace abclink with your name of the link
		$this->ListOptions->Items["View Ledger Book"]->Body = '<a href="ledgerlist.php?ID='.$this->id->CurrentValue.'" data-original-title ="View Ledger Book"><i data-phrase="View Ledger Book"  class="fa fa-list ew-icon" ></i></a>';
	$app_test = 1;
	$no_of_emi = $this->no_of_emi->CurrentValue;
	$coll_log = ExecuteScalar("SELECT count(`account_no`) FROM `collection_log` WHERE `account_no` = " . $this->id->CurrentValue);
	if ($this->grp->CurrentValue == 130102)
	{
	$int_log_tmp = ExecuteScalar("SELECT count(`account_no`) FROM `b_account_int_log_tmp` WHERE `account_no` = " . $this->id->CurrentValue);
	$int_log = ExecuteScalar("SELECT count(`account_no`) FROM `b_account_int_log` WHERE `account_no` = " . $this->id->CurrentValue);
		if (is_null($this->fund_o_no->CurrentValue))
		{
			$this->ListOptions->Add("Link Security Account"); 
			$this->ListOptions->Items["Link Security Account"]->Body = '<a href="/b_account_infoedit.php?id=' . $this->id->CurrentValue . '" data-original-title ="Link Security Account"><i data-phrase="Link Security Account"  style="color:red" class="fa fa-info-circle ew-icon" ></i></a>';
			$app_test = 0;
		}
		if ( ($int_log_tmp == 0) )
		{
			$this->ListOptions->Add("Create Interest Log"); 
			$this->ListOptions->Items["Create Interest Log"]->Body = '<a href="/b_account_int_log_tmplist.php" data-original-title ="Create Interest Log"><i data-phrase="Create Interest Log"  style="color:IndianRed" class="fa fa-info-circle ew-icon" ></i></a>';
			$app_test = 0;
		}	
		elseif ( ($int_log_tmp < $no_of_emi) && ($this->status->CurrentValue < 120) )
		{
			$this->ListOptions->Add("Tmp Int Log Error"); 
			$this->ListOptions->Items["Tmp Int Log Error"]->Body = '<a href="/b_account_int_log_tmplist.php?x_account_no_id=' . $this->id->CurrentValue . '" data-original-title ="Tmp Int Log Error"><i data-phrase="Tmp Int Log Error"  style="color:DarkRed" class="fa fa-info-circle ew-icon" ></i></a>';
			$app_test = 0;	
		}
		if ( ($int_log < $no_of_emi) && ($this->status->CurrentValue >= 120) && ($this->status->CurrentValue < 122) )
		{
			$this->ListOptions->Add("Int Log Error"); 
			$this->ListOptions->Items["Int Log Error"]->Body = '<a href="/b_account_int_loglist.php?x_account_no_id=' . $this->id->CurrentValue . '" data-original-title ="Int Log Error"><i data-phrase="Int Log Error"  style="color:DarkRed" class="fa fa-info-circle ew-icon" ></i></a>';
			$app_test = 0;	
		}
		if ( ($coll_log < $int_log) && ($this->status->CurrentValue >= 120) && ($this->status->CurrentValue < 122) )
		{
			$this->ListOptions->Add("Collection Log Error"); 
			$this->ListOptions->Items["Collection Log Error"]->Body = '<a href="/collection_loglist.php?x_account_no=' . $this->id->CurrentValue . '" data-original-title ="Collection Log Error"><i data-phrase="Collection Log Error"  style="color:Blue" class="fa fa-info-circle ew-icon" ></i></a>';
		}
	}
		if ( ($this->grp->CurrentValue == 130101) || ($this->grp->CurrentValue == 130102))
		{
			if ( $this->status->CurrentValue < 103 )
			{
				$this->ListOptions->Add("Send OTP"); 
				$this->ListOptions->Items["Send OTP"]->Body = '<a href="autoprogramme.php?apcid=043485b042179e1b0547288346a47044&id=' . $this->id->CurrentValue . '" data-original-title ="Send OTP"><i data-phrase="Send OTP"  class="fa fa-thumbs-up ew-icon" ></i></a>';
			}
			if (($this->status->CurrentValue == 103) && (CurrentUserID() == 51) && ($app_test == 1) )
			{
				$this->ListOptions->Add("Reject/Approve"); 
				$this->ListOptions->Items["Reject/Approve"]->Body = '<a href="autoprogramme.php?apcid=0dd989c64c054921672af61a0c7a5e95&id=' . $this->id->CurrentValue . '" data-original-title ="Reject/Approve"><i data-phrase="Reject/Approve"  class="fa fa-thumbs-up ew-icon"  style="color:orange"></i></a>';
			}
			if (($this->status->CurrentValue > 110) && ($this->status->CurrentValue < 121) && (CurrentUserID() == 51))
			{
				$this->ListOptions->Add("Disburse"); 
				$this->ListOptions->Items["Disburse"]->Body = '<a href="autoprogramme.php?apcid=7602980244b8793fb90d3bfb3bef1639&id=' . $this->id->CurrentValue . '" data-original-title ="Disburse"><i data-phrase="Disburse"  class="fa fa-thumbs-up ew-icon"  style="color:red"></i></a>';
			}
		}
		if ( ($coll_log < ($this->loan_amount->CurrentValue / $this->emi_amount->CurrentValue)) && ($this->status->CurrentValue >= 120) && ($this->status->CurrentValue < 122) && ($this->grp->CurrentValue == 130101) )
		{
			$this->ListOptions->Add("Collection Log Error"); 
			$this->ListOptions->Items["Collection Log Error"]->Body = '<a href="/collection_loglist.php?x_account_no=' . $this->id->CurrentValue . '" data-original-title ="Collection Log Error"><i data-phrase="Collection Log Error"  style="color:Blue" class="fa fa-info-circle ew-icon" ></i></a>';
		}
		if (($this->status->CurrentValue > 120) && ($this->status->CurrentValue < 122) && (CurrentUserID() == 51))
			{
				$this->ListOptions->Add("Close Account"); 
				$this->ListOptions->Items["Close Account"]->Body = '<a href="autoprogramme.php?apcid=b5ab45423ffb576accdb554b967cdad5&id=' . $this->id->CurrentValue . '" data-original-title ="Close Account"><i data-phrase="Close Account"  class="fa fa-thumbs-up ew-icon"  style="color:yellow"></i></a>';
			}		
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>