<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class b_account_info_search extends b_account_info
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'b_account_info';

	// Page object name
	public $PageObjName = "b_account_info_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (b_account_info)
		if (!isset($GLOBALS["b_account_info"]) || get_class($GLOBALS["b_account_info"]) == PROJECT_NAMESPACE . "b_account_info") {
			$GLOBALS["b_account_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["b_account_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $b_account_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($b_account_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "b_account_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("b_account_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->b_type->setVisibility();
		$this->grp->setVisibility();
		$this->branch->setVisibility();
		$this->category->setVisibility();
		$this->account_type->setVisibility();
		$this->type->setVisibility();
		$this->formal_name->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->image->setVisibility();
		$this->sign_image->setVisibility();
		$this->status->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->pan_no->setVisibility();
		$this->id_proof->setVisibility();
		$this->agent->setVisibility();
		$this->other_details->setVisibility();
		$this->bank_name->setVisibility();
		$this->bank_ifsc_code->setVisibility();
		$this->bank_account_no->setVisibility();
		$this->account_no->setVisibility();
		$this->loan_amount->setVisibility();
		$this->emi_amount->setVisibility();
		$this->frequency->setVisibility();
		$this->disbursement_amount->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->d_operator->setVisibility();
		$this->d_datetime->setVisibility();
		$this->otp->Visible = FALSE;
		$this->otp_delivery_datetime->Visible = FALSE;
		$this->otp_verify_datetime->Visible = FALSE;
		$this->no_of_emi->setVisibility();
		$this->fund_o->setVisibility();
		$this->fund_o_no->setVisibility();
		$this->int_40->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->branch);
		$this->setupLookupOptions($this->type);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->fund_o_no);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "b_account_infolist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->b_type); // b_type
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->branch); // branch
		$this->buildSearchUrl($srchUrl, $this->category); // category
		$this->buildSearchUrl($srchUrl, $this->account_type); // account_type
		$this->buildSearchUrl($srchUrl, $this->type); // type
		$this->buildSearchUrl($srchUrl, $this->formal_name); // formal_name
		$this->buildSearchUrl($srchUrl, $this->mobile); // mobile
		$this->buildSearchUrl($srchUrl, $this->_email); // email
		$this->buildSearchUrl($srchUrl, $this->image); // image
		$this->buildSearchUrl($srchUrl, $this->sign_image); // sign_image
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->aadhaar_no); // aadhaar_no
		$this->buildSearchUrl($srchUrl, $this->pan_no); // pan_no
		$this->buildSearchUrl($srchUrl, $this->id_proof); // id_proof
		$this->buildSearchUrl($srchUrl, $this->agent); // agent
		$this->buildSearchUrl($srchUrl, $this->other_details); // other_details
		$this->buildSearchUrl($srchUrl, $this->bank_name); // bank_name
		$this->buildSearchUrl($srchUrl, $this->bank_ifsc_code); // bank_ifsc_code
		$this->buildSearchUrl($srchUrl, $this->bank_account_no); // bank_account_no
		$this->buildSearchUrl($srchUrl, $this->account_no); // account_no
		$this->buildSearchUrl($srchUrl, $this->loan_amount); // loan_amount
		$this->buildSearchUrl($srchUrl, $this->emi_amount); // emi_amount
		$this->buildSearchUrl($srchUrl, $this->frequency); // frequency
		$this->buildSearchUrl($srchUrl, $this->disbursement_amount); // disbursement_amount
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->d_operator); // d_operator
		$this->buildSearchUrl($srchUrl, $this->d_datetime); // d_datetime
		$this->buildSearchUrl($srchUrl, $this->no_of_emi); // no_of_emi
		$this->buildSearchUrl($srchUrl, $this->fund_o); // fund_o
		$this->buildSearchUrl($srchUrl, $this->fund_o_no); // fund_o_no
		$this->buildSearchUrl($srchUrl, $this->int_40); // int_@
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// b_type

		if (!$this->isAddOrEdit())
			$this->b_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_type"));
		$this->b_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_type"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// branch
		if (!$this->isAddOrEdit())
			$this->branch->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_branch"));
		$this->branch->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_branch"));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));

		// account_type
		if (!$this->isAddOrEdit())
			$this->account_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_account_type"));
		$this->account_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_account_type"));

		// type
		if (!$this->isAddOrEdit())
			$this->type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_type"));
		$this->type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_type"));

		// formal_name
		if (!$this->isAddOrEdit())
			$this->formal_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_formal_name"));
		$this->formal_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_formal_name"));

		// mobile
		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile"));
		$this->mobile->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile"));

		// email
		if (!$this->isAddOrEdit())
			$this->_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__email"));
		$this->_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__email"));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_image"));
		$this->image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_image"));

		// sign_image
		if (!$this->isAddOrEdit())
			$this->sign_image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sign_image"));
		$this->sign_image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sign_image"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// aadhaar_no
		if (!$this->isAddOrEdit())
			$this->aadhaar_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_aadhaar_no"));
		$this->aadhaar_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_aadhaar_no"));

		// pan_no
		if (!$this->isAddOrEdit())
			$this->pan_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pan_no"));
		$this->pan_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pan_no"));

		// id_proof
		if (!$this->isAddOrEdit())
			$this->id_proof->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id_proof"));
		$this->id_proof->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id_proof"));

		// agent
		if (!$this->isAddOrEdit())
			$this->agent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_agent"));
		$this->agent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_agent"));

		// other_details
		if (!$this->isAddOrEdit())
			$this->other_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other_details"));
		$this->other_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other_details"));

		// bank_name
		if (!$this->isAddOrEdit())
			$this->bank_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_name"));
		$this->bank_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_name"));

		// bank_ifsc_code
		if (!$this->isAddOrEdit())
			$this->bank_ifsc_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_ifsc_code"));
		$this->bank_ifsc_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_ifsc_code"));

		// bank_account_no
		if (!$this->isAddOrEdit())
			$this->bank_account_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bank_account_no"));
		$this->bank_account_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bank_account_no"));

		// account_no
		if (!$this->isAddOrEdit())
			$this->account_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_account_no"));
		$this->account_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_account_no"));

		// loan_amount
		if (!$this->isAddOrEdit())
			$this->loan_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_loan_amount"));
		$this->loan_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_loan_amount"));

		// emi_amount
		if (!$this->isAddOrEdit())
			$this->emi_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_emi_amount"));
		$this->emi_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_emi_amount"));

		// frequency
		if (!$this->isAddOrEdit())
			$this->frequency->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_frequency"));
		$this->frequency->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_frequency"));

		// disbursement_amount
		if (!$this->isAddOrEdit())
			$this->disbursement_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_disbursement_amount"));
		$this->disbursement_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_disbursement_amount"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
		$this->datetime->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_datetime"));
		$this->datetime->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_datetime"));

		// d_operator
		if (!$this->isAddOrEdit())
			$this->d_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_operator"));
		$this->d_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_operator"));

		// d_datetime
		if (!$this->isAddOrEdit())
			$this->d_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_datetime"));
		$this->d_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_datetime"));

		// no_of_emi
		if (!$this->isAddOrEdit())
			$this->no_of_emi->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_no_of_emi"));
		$this->no_of_emi->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_no_of_emi"));

		// fund_o
		if (!$this->isAddOrEdit())
			$this->fund_o->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fund_o"));
		$this->fund_o->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fund_o"));

		// fund_o_no
		if (!$this->isAddOrEdit())
			$this->fund_o_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fund_o_no"));
		$this->fund_o_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fund_o_no"));

		// int_@
		if (!$this->isAddOrEdit())
			$this->int_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_int_40"));
		$this->int_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_int_40"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->loan_amount->FormValue == $this->loan_amount->CurrentValue && is_numeric(ConvertToFloatString($this->loan_amount->CurrentValue)))
			$this->loan_amount->CurrentValue = ConvertToFloatString($this->loan_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->emi_amount->FormValue == $this->emi_amount->CurrentValue && is_numeric(ConvertToFloatString($this->emi_amount->CurrentValue)))
			$this->emi_amount->CurrentValue = ConvertToFloatString($this->emi_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->disbursement_amount->FormValue == $this->disbursement_amount->CurrentValue && is_numeric(ConvertToFloatString($this->disbursement_amount->CurrentValue)))
			$this->disbursement_amount->CurrentValue = ConvertToFloatString($this->disbursement_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fund_o->FormValue == $this->fund_o->CurrentValue && is_numeric(ConvertToFloatString($this->fund_o->CurrentValue)))
			$this->fund_o->CurrentValue = ConvertToFloatString($this->fund_o->CurrentValue);

		// Convert decimal values if posted back
		if ($this->int_40->FormValue == $this->int_40->CurrentValue && is_numeric(ConvertToFloatString($this->int_40->CurrentValue)))
			$this->int_40->CurrentValue = ConvertToFloatString($this->int_40->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// b_type
		// grp
		// branch
		// category
		// account_type
		// type
		// formal_name
		// mobile
		// email
		// image
		// sign_image
		// status
		// aadhaar_no
		// pan_no
		// id_proof
		// agent
		// other_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// account_no
		// loan_amount
		// emi_amount
		// frequency
		// disbursement_amount
		// operator
		// datetime
		// d_operator
		// d_datetime
		// otp
		// otp_delivery_datetime
		// otp_verify_datetime
		// no_of_emi
		// fund_o
		// fund_o_no
		// int_@

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// b_type
			if (strval($this->b_type->CurrentValue) <> "") {
				$this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
			} else {
				$this->b_type->ViewValue = NULL;
			}
			$this->b_type->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// branch
			$curVal = strval($this->branch->CurrentValue);
			if ($curVal <> "") {
				$this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
				if ($this->branch->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->branch->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->branch->ViewValue = $this->branch->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->branch->ViewValue = $this->branch->CurrentValue;
					}
				}
			} else {
				$this->branch->ViewValue = NULL;
			}
			$this->branch->ViewCustomAttributes = "";

			// category
			if (strval($this->category->CurrentValue) <> "") {
				$this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// account_type
			$this->account_type->ViewValue = $this->account_type->CurrentValue;
			$this->account_type->ViewValue = FormatNumber($this->account_type->ViewValue, 0, -2, -2, -2);
			$this->account_type->ViewCustomAttributes = "";

			// type
			$curVal = strval($this->type->CurrentValue);
			if ($curVal <> "") {
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->type->ViewValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->ViewValue = $this->type->CurrentValue;
					}
				}
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
			$this->formal_name->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// sign_image
			$this->sign_image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->sign_image->Upload->DbValue)) {
				$this->sign_image->ViewValue = $this->sign_image->Upload->DbValue;
			} else {
				$this->sign_image->ViewValue = "";
			}
			$this->sign_image->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// id_proof
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->ViewValue = "";
			}
			$this->id_proof->ViewCustomAttributes = "";

			// agent
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel` = 1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			$this->agent->ViewCustomAttributes = "";

			// other_details
			$this->other_details->ViewValue = $this->other_details->CurrentValue;
			$this->other_details->ViewCustomAttributes = "";

			// bank_name
			$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
			$this->bank_name->ViewCustomAttributes = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
			$this->bank_ifsc_code->ViewCustomAttributes = "";

			// bank_account_no
			$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
			$this->bank_account_no->ViewCustomAttributes = "";

			// account_no
			$this->account_no->ViewValue = $this->account_no->CurrentValue;
			$this->account_no->ViewCustomAttributes = "";

			// loan_amount
			$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
			$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
			$this->loan_amount->ViewCustomAttributes = "";

			// emi_amount
			$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
			$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
			$this->emi_amount->ViewCustomAttributes = "";

			// frequency
			if (strval($this->frequency->CurrentValue) <> "") {
				$this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
			} else {
				$this->frequency->ViewValue = NULL;
			}
			$this->frequency->ViewCustomAttributes = "";

			// disbursement_amount
			$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
			$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
			$this->disbursement_amount->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// d_operator
			$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
			$this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, 0, -2, -2, -2);
			$this->d_operator->ViewCustomAttributes = "";

			// d_datetime
			$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
			$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 0);
			$this->d_datetime->ViewCustomAttributes = "";

			// otp_delivery_datetime
			$this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
			$this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, 0);
			$this->otp_delivery_datetime->ViewCustomAttributes = "";

			// otp_verify_datetime
			$this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
			$this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, 0);
			$this->otp_verify_datetime->ViewCustomAttributes = "";

			// no_of_emi
			$this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
			$this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, 0, -2, -2, -2);
			$this->no_of_emi->ViewCustomAttributes = "";

			// fund_o
			$this->fund_o->ViewValue = $this->fund_o->CurrentValue;
			$this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, 2, -2, -2, -2);
			$this->fund_o->ViewCustomAttributes = "";

			// fund_o_no
			$curVal = strval($this->fund_o_no->CurrentValue);
			if ($curVal <> "") {
				$this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
				if ($this->fund_o_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`= 230401";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->fund_o_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
					}
				}
			} else {
				$this->fund_o_no->ViewValue = NULL;
			}
			$this->fund_o_no->ViewCustomAttributes = "";

			// int_@
			$this->int_40->ViewValue = $this->int_40->CurrentValue;
			$this->int_40->ViewValue = FormatNumber($this->int_40->ViewValue, 2, -2, -2, -2);
			$this->int_40->ViewCustomAttributes = "";

			// b_type
			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";
			$this->b_type->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// branch
			$this->branch->LinkCustomAttributes = "";
			$this->branch->HrefValue = "";
			$this->branch->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// account_type
			$this->account_type->LinkCustomAttributes = "";
			$this->account_type->HrefValue = "";
			$this->account_type->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";
			$this->formal_name->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";

			// sign_image
			$this->sign_image->LinkCustomAttributes = "";
			$this->sign_image->HrefValue = "";
			$this->sign_image->ExportHrefValue = $this->sign_image->UploadPath . $this->sign_image->Upload->DbValue;
			$this->sign_image->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = 'download';
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->HrefValue = "%u"; // Add prefix/suffix
				$this->id_proof->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->id_proof->HrefValue = FullUrl($this->id_proof->HrefValue, "href");
			} else {
				$this->id_proof->HrefValue = "";
			}
			$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
			$this->id_proof->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";
			$this->other_details->TooltipValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";
			$this->bank_name->TooltipValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";
			$this->bank_ifsc_code->TooltipValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";
			$this->bank_account_no->TooltipValue = "";

			// account_no
			$this->account_no->LinkCustomAttributes = "";
			$this->account_no->HrefValue = "";
			$this->account_no->TooltipValue = "";

			// loan_amount
			$this->loan_amount->LinkCustomAttributes = "";
			$this->loan_amount->HrefValue = "";
			$this->loan_amount->TooltipValue = "";

			// emi_amount
			$this->emi_amount->LinkCustomAttributes = "";
			$this->emi_amount->HrefValue = "";
			$this->emi_amount->TooltipValue = "";

			// frequency
			$this->frequency->LinkCustomAttributes = "";
			$this->frequency->HrefValue = "";
			$this->frequency->TooltipValue = "";

			// disbursement_amount
			$this->disbursement_amount->LinkCustomAttributes = "";
			$this->disbursement_amount->HrefValue = "";
			$this->disbursement_amount->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// d_operator
			$this->d_operator->LinkCustomAttributes = "";
			$this->d_operator->HrefValue = "";
			$this->d_operator->TooltipValue = "";

			// d_datetime
			$this->d_datetime->LinkCustomAttributes = "";
			$this->d_datetime->HrefValue = "";
			$this->d_datetime->TooltipValue = "";

			// no_of_emi
			$this->no_of_emi->LinkCustomAttributes = "";
			$this->no_of_emi->HrefValue = "";
			$this->no_of_emi->TooltipValue = "";

			// fund_o
			$this->fund_o->LinkCustomAttributes = "";
			$this->fund_o->HrefValue = "";
			$this->fund_o->TooltipValue = "";

			// fund_o_no
			$this->fund_o_no->LinkCustomAttributes = "";
			$this->fund_o_no->HrefValue = "";
			$this->fund_o_no->TooltipValue = "";

			// int_@
			$this->int_40->LinkCustomAttributes = "";
			$this->int_40->HrefValue = "";
			$this->int_40->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// b_type
			$this->b_type->EditAttrs["class"] = "form-control";
			$this->b_type->EditCustomAttributes = "";
			$this->b_type->EditValue = $this->b_type->options(TRUE);

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id`>9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// branch
			$this->branch->EditAttrs["class"] = "form-control";
			$this->branch->EditCustomAttributes = "";
			$curVal = trim(strval($this->branch->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->branch->AdvancedSearch->ViewValue = $this->branch->lookupCacheOption($curVal);
			else
				$this->branch->AdvancedSearch->ViewValue = $this->branch->Lookup !== NULL && is_array($this->branch->Lookup->Options) ? $curVal : NULL;
			if ($this->branch->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->branch->EditValue = array_values($this->branch->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->branch->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 10";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->branch->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->branch->EditValue = $arwrk;
			}

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$this->category->EditValue = $this->category->options(TRUE);

			// account_type
			$this->account_type->EditAttrs["class"] = "form-control";
			$this->account_type->EditCustomAttributes = "";
			$this->account_type->EditValue = HtmlEncode($this->account_type->AdvancedSearch->SearchValue);
			$this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$curVal = trim(strval($this->type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->type->AdvancedSearch->ViewValue = $this->type->lookupCacheOption($curVal);
			else
				$this->type->AdvancedSearch->ViewValue = $this->type->Lookup !== NULL && is_array($this->type->Lookup->Options) ? $curVal : NULL;
			if ($this->type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->type->EditValue = array_values($this->type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->type->EditValue = $arwrk;
			}

			// formal_name
			$this->formal_name->EditAttrs["class"] = "form-control";
			$this->formal_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->formal_name->AdvancedSearch->SearchValue = HtmlDecode($this->formal_name->AdvancedSearch->SearchValue);
			$this->formal_name->EditValue = HtmlEncode($this->formal_name->AdvancedSearch->SearchValue);
			$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
			$this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
			$this->image->PlaceHolder = RemoveHtml($this->image->caption());

			// sign_image
			$this->sign_image->EditAttrs["class"] = "form-control";
			$this->sign_image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sign_image->AdvancedSearch->SearchValue = HtmlDecode($this->sign_image->AdvancedSearch->SearchValue);
			$this->sign_image->EditValue = HtmlEncode($this->sign_image->AdvancedSearch->SearchValue);
			$this->sign_image->PlaceHolder = RemoveHtml($this->sign_image->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = 'ReadOnly';
			$this->status->EditValue = HtmlEncode($this->status->AdvancedSearch->SearchValue);
			$curVal = strval($this->status->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->status->EditValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->status->EditValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->EditValue = HtmlEncode($this->status->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar_no->AdvancedSearch->SearchValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->AdvancedSearch->SearchValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// pan_no
			$this->pan_no->EditAttrs["class"] = "form-control";
			$this->pan_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_no->AdvancedSearch->SearchValue = HtmlDecode($this->pan_no->AdvancedSearch->SearchValue);
			$this->pan_no->EditValue = HtmlEncode($this->pan_no->AdvancedSearch->SearchValue);
			$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

			// id_proof
			$this->id_proof->EditAttrs["class"] = "form-control";
			$this->id_proof->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->id_proof->AdvancedSearch->SearchValue = HtmlDecode($this->id_proof->AdvancedSearch->SearchValue);
			$this->id_proof->EditValue = HtmlEncode($this->id_proof->AdvancedSearch->SearchValue);
			$this->id_proof->PlaceHolder = RemoveHtml($this->id_proof->caption());

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$curVal = trim(strval($this->agent->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->agent->AdvancedSearch->ViewValue = $this->agent->lookupCacheOption($curVal);
			else
				$this->agent->AdvancedSearch->ViewValue = $this->agent->Lookup !== NULL && is_array($this->agent->Lookup->Options) ? $curVal : NULL;
			if ($this->agent->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->agent->EditValue = array_values($this->agent->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->agent->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`userlevel` = 1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->agent->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->agent->EditValue = $arwrk;
			}

			// other_details
			$this->other_details->EditAttrs["class"] = "form-control";
			$this->other_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other_details->AdvancedSearch->SearchValue = HtmlDecode($this->other_details->AdvancedSearch->SearchValue);
			$this->other_details->EditValue = HtmlEncode($this->other_details->AdvancedSearch->SearchValue);
			$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

			// bank_name
			$this->bank_name->EditAttrs["class"] = "form-control";
			$this->bank_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_name->AdvancedSearch->SearchValue = HtmlDecode($this->bank_name->AdvancedSearch->SearchValue);
			$this->bank_name->EditValue = HtmlEncode($this->bank_name->AdvancedSearch->SearchValue);
			$this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

			// bank_ifsc_code
			$this->bank_ifsc_code->EditAttrs["class"] = "form-control";
			$this->bank_ifsc_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_ifsc_code->AdvancedSearch->SearchValue = HtmlDecode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
			$this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->AdvancedSearch->SearchValue);
			$this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

			// bank_account_no
			$this->bank_account_no->EditAttrs["class"] = "form-control";
			$this->bank_account_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_account_no->AdvancedSearch->SearchValue = HtmlDecode($this->bank_account_no->AdvancedSearch->SearchValue);
			$this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->AdvancedSearch->SearchValue);
			$this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

			// account_no
			$this->account_no->EditAttrs["class"] = "form-control";
			$this->account_no->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->account_no->AdvancedSearch->SearchValue = HtmlDecode($this->account_no->AdvancedSearch->SearchValue);
			$this->account_no->EditValue = HtmlEncode($this->account_no->AdvancedSearch->SearchValue);
			$this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

			// loan_amount
			$this->loan_amount->EditAttrs["class"] = "form-control";
			$this->loan_amount->EditCustomAttributes = "";
			$this->loan_amount->EditValue = HtmlEncode($this->loan_amount->AdvancedSearch->SearchValue);
			$this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());

			// emi_amount
			$this->emi_amount->EditAttrs["class"] = "form-control";
			$this->emi_amount->EditCustomAttributes = "";
			$this->emi_amount->EditValue = HtmlEncode($this->emi_amount->AdvancedSearch->SearchValue);
			$this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());

			// frequency
			$this->frequency->EditAttrs["class"] = "form-control";
			$this->frequency->EditCustomAttributes = "";
			$this->frequency->EditValue = $this->frequency->options(TRUE);

			// disbursement_amount
			$this->disbursement_amount->EditAttrs["class"] = "form-control";
			$this->disbursement_amount->EditCustomAttributes = "";
			$this->disbursement_amount->EditValue = HtmlEncode($this->disbursement_amount->AdvancedSearch->SearchValue);
			$this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// d_operator
			$this->d_operator->EditAttrs["class"] = "form-control";
			$this->d_operator->EditCustomAttributes = "";
			$this->d_operator->EditValue = HtmlEncode($this->d_operator->AdvancedSearch->SearchValue);
			$this->d_operator->PlaceHolder = RemoveHtml($this->d_operator->caption());

			// d_datetime
			$this->d_datetime->EditAttrs["class"] = "form-control";
			$this->d_datetime->EditCustomAttributes = "";
			$this->d_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->d_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());

			// no_of_emi
			$this->no_of_emi->EditAttrs["class"] = "form-control";
			$this->no_of_emi->EditCustomAttributes = "";
			$this->no_of_emi->EditValue = HtmlEncode($this->no_of_emi->AdvancedSearch->SearchValue);
			$this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

			// fund_o
			$this->fund_o->EditAttrs["class"] = "form-control";
			$this->fund_o->EditCustomAttributes = "";
			$this->fund_o->EditValue = HtmlEncode($this->fund_o->AdvancedSearch->SearchValue);
			$this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());

			// fund_o_no
			$this->fund_o_no->EditAttrs["class"] = "form-control";
			$this->fund_o_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->fund_o_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->fund_o_no->AdvancedSearch->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
			else
				$this->fund_o_no->AdvancedSearch->ViewValue = $this->fund_o_no->Lookup !== NULL && is_array($this->fund_o_no->Lookup->Options) ? $curVal : NULL;
			if ($this->fund_o_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->fund_o_no->EditValue = array_values($this->fund_o_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->fund_o_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`= 230401";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->fund_o_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->fund_o_no->EditValue = $arwrk;
			}

			// int_@
			$this->int_40->EditAttrs["class"] = "form-control";
			$this->int_40->EditCustomAttributes = "";
			$this->int_40->EditValue = HtmlEncode($this->int_40->AdvancedSearch->SearchValue);
			$this->int_40->PlaceHolder = RemoveHtml($this->int_40->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->account_type->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->account_type->errorMessage());
		}
		if (!CheckInteger($this->mobile->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->mobile->errorMessage());
		}
		if (!CheckInteger($this->status->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->status->errorMessage());
		}
		if (!CheckInteger($this->aadhaar_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->aadhaar_no->errorMessage());
		}
		if (!CheckNumber($this->loan_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->loan_amount->errorMessage());
		}
		if (!CheckNumber($this->emi_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->emi_amount->errorMessage());
		}
		if (!CheckNumber($this->disbursement_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->disbursement_amount->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->d_operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->d_operator->errorMessage());
		}
		if (!CheckDate($this->d_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->d_datetime->errorMessage());
		}
		if (!CheckInteger($this->no_of_emi->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->no_of_emi->errorMessage());
		}
		if (!CheckNumber($this->fund_o->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->fund_o->errorMessage());
		}
		if (!CheckNumber($this->int_40->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->int_40->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->b_type->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->branch->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->account_type->AdvancedSearch->load();
		$this->type->AdvancedSearch->load();
		$this->formal_name->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->sign_image->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->aadhaar_no->AdvancedSearch->load();
		$this->pan_no->AdvancedSearch->load();
		$this->id_proof->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->other_details->AdvancedSearch->load();
		$this->bank_name->AdvancedSearch->load();
		$this->bank_ifsc_code->AdvancedSearch->load();
		$this->bank_account_no->AdvancedSearch->load();
		$this->account_no->AdvancedSearch->load();
		$this->loan_amount->AdvancedSearch->load();
		$this->emi_amount->AdvancedSearch->load();
		$this->frequency->AdvancedSearch->load();
		$this->disbursement_amount->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->d_operator->AdvancedSearch->load();
		$this->d_datetime->AdvancedSearch->load();
		$this->no_of_emi->AdvancedSearch->load();
		$this->fund_o->AdvancedSearch->load();
		$this->fund_o_no->AdvancedSearch->load();
		$this->int_40->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("b_account_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`id`>9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_branch":
					$lookupFilter = function() {
						return "`id` > 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`userlevel` = 1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_fund_o_no":
					$lookupFilter = function() {
						return "`grp`= 230401";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_branch":
							break;
						case "x_type":
							break;
						case "x_status":
							break;
						case "x_agent":
							break;
						case "x_fund_o_no":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'account_info');	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>