<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class b_account_info_update extends b_account_info
{

	// Page ID
	public $PageID = "update";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'b_account_info';

	// Page object name
	public $PageObjName = "b_account_info_update";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (b_account_info)
		if (!isset($GLOBALS["b_account_info"]) || get_class($GLOBALS["b_account_info"]) == PROJECT_NAMESPACE . "b_account_info") {
			$GLOBALS["b_account_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["b_account_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'update');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $b_account_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($b_account_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "b_account_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-update-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $RecKeys;
	public $Disabled;
	public $UpdateCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("b_account_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->b_type->setVisibility();
		$this->grp->setVisibility();
		$this->branch->setVisibility();
		$this->category->Visible = FALSE;
		$this->account_type->setVisibility();
		$this->type->setVisibility();
		$this->formal_name->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->image->setVisibility();
		$this->sign_image->setVisibility();
		$this->status->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->pan_no->setVisibility();
		$this->id_proof->setVisibility();
		$this->agent->setVisibility();
		$this->other_details->setVisibility();
		$this->bank_name->setVisibility();
		$this->bank_ifsc_code->setVisibility();
		$this->bank_account_no->setVisibility();
		$this->account_no->setVisibility();
		$this->loan_amount->setVisibility();
		$this->emi_amount->setVisibility();
		$this->frequency->setVisibility();
		$this->disbursement_amount->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->d_operator->setVisibility();
		$this->d_datetime->setVisibility();
		$this->otp->Visible = FALSE;
		$this->otp_delivery_datetime->Visible = FALSE;
		$this->otp_verify_datetime->Visible = FALSE;
		$this->no_of_emi->setVisibility();
		$this->fund_o->setVisibility();
		$this->fund_o_no->setVisibility();
		$this->int_40->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->grp->Required = FALSE;
		$this->account_no->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->branch);
		$this->setupLookupOptions($this->type);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->fund_o_no);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-update-form ew-horizontal";

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Try to load keys from list form
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		if (Post("action") !== NULL && Post("action") !== "") {

			// Get action
			$this->CurrentAction = Post("action");
			$this->loadFormValues(); // Get form values

			// Validate form
			if (!$this->validateForm()) {
				$this->CurrentAction = "show"; // Form error, reset action
				$this->setFailureMessage($FormError);
			}
		} else {
			$this->loadMultiUpdateValues(); // Load initial values to form
		}
		if (count($this->RecKeys) <= 0)
			$this->terminate("b_account_infolist.php"); // No records selected, return to list
		if ($this->isUpdate()) {
				if ($this->updateRows()) { // Update Records based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
					$this->terminate($this->getReturnUrl()); // Return to caller
				} else {
					$this->restoreFormValues(); // Restore form values
				}
		}

		// Render row
		if ($this->isConfirm()) { // Confirm page
			$this->RowType = ROWTYPE_VIEW; // Render view
			$this->Disabled = " disabled";
		} else {
			$this->RowType = ROWTYPE_EDIT; // Render edit
			$this->Disabled = "";
		}
		$this->resetAttributes();
		$this->renderRow();
	}

	// Load initial values to form if field values are identical in all selected records
	protected function loadMultiUpdateValues()
	{
		$this->CurrentFilter = $this->getFilterFromRecordKeys();

		// Load recordset
		if ($this->Recordset = $this->loadRecordset()) {
			$i = 1;
			while (!$this->Recordset->EOF) {
				if ($i == 1) {
					$this->b_type->setDbValue($this->Recordset->fields('b_type'));
					$this->grp->setDbValue($this->Recordset->fields('grp'));
					$this->branch->setDbValue($this->Recordset->fields('branch'));
					$this->account_type->setDbValue($this->Recordset->fields('account_type'));
					$this->type->setDbValue($this->Recordset->fields('type'));
					$this->formal_name->setDbValue($this->Recordset->fields('formal_name'));
					$this->mobile->setDbValue($this->Recordset->fields('mobile'));
					$this->_email->setDbValue($this->Recordset->fields('email'));
					$this->status->setDbValue($this->Recordset->fields('status'));
					$this->aadhaar_no->setDbValue($this->Recordset->fields('aadhaar_no'));
					$this->pan_no->setDbValue($this->Recordset->fields('pan_no'));
					$this->agent->setDbValue($this->Recordset->fields('agent'));
					$this->other_details->setDbValue($this->Recordset->fields('other_details'));
					$this->bank_name->setDbValue($this->Recordset->fields('bank_name'));
					$this->bank_ifsc_code->setDbValue($this->Recordset->fields('bank_ifsc_code'));
					$this->bank_account_no->setDbValue($this->Recordset->fields('bank_account_no'));
					$this->account_no->setDbValue($this->Recordset->fields('account_no'));
					$this->loan_amount->setDbValue($this->Recordset->fields('loan_amount'));
					$this->emi_amount->setDbValue($this->Recordset->fields('emi_amount'));
					$this->frequency->setDbValue($this->Recordset->fields('frequency'));
					$this->disbursement_amount->setDbValue($this->Recordset->fields('disbursement_amount'));
					$this->operator->setDbValue($this->Recordset->fields('operator'));
					$this->datetime->setDbValue($this->Recordset->fields('datetime'));
					$this->d_operator->setDbValue($this->Recordset->fields('d_operator'));
					$this->d_datetime->setDbValue($this->Recordset->fields('d_datetime'));
					$this->no_of_emi->setDbValue($this->Recordset->fields('no_of_emi'));
					$this->fund_o->setDbValue($this->Recordset->fields('fund_o'));
					$this->fund_o_no->setDbValue($this->Recordset->fields('fund_o_no'));
					$this->int_40->setDbValue($this->Recordset->fields('int_@'));
				} else {
					if (!CompareValue($this->b_type->DbValue, $this->Recordset->fields('b_type')))
						$this->b_type->CurrentValue = NULL;
					if (!CompareValue($this->grp->DbValue, $this->Recordset->fields('grp')))
						$this->grp->CurrentValue = NULL;
					if (!CompareValue($this->branch->DbValue, $this->Recordset->fields('branch')))
						$this->branch->CurrentValue = NULL;
					if (!CompareValue($this->account_type->DbValue, $this->Recordset->fields('account_type')))
						$this->account_type->CurrentValue = NULL;
					if (!CompareValue($this->type->DbValue, $this->Recordset->fields('type')))
						$this->type->CurrentValue = NULL;
					if (!CompareValue($this->formal_name->DbValue, $this->Recordset->fields('formal_name')))
						$this->formal_name->CurrentValue = NULL;
					if (!CompareValue($this->mobile->DbValue, $this->Recordset->fields('mobile')))
						$this->mobile->CurrentValue = NULL;
					if (!CompareValue($this->_email->DbValue, $this->Recordset->fields('email')))
						$this->_email->CurrentValue = NULL;
					if (!CompareValue($this->status->DbValue, $this->Recordset->fields('status')))
						$this->status->CurrentValue = NULL;
					if (!CompareValue($this->aadhaar_no->DbValue, $this->Recordset->fields('aadhaar_no')))
						$this->aadhaar_no->CurrentValue = NULL;
					if (!CompareValue($this->pan_no->DbValue, $this->Recordset->fields('pan_no')))
						$this->pan_no->CurrentValue = NULL;
					if (!CompareValue($this->agent->DbValue, $this->Recordset->fields('agent')))
						$this->agent->CurrentValue = NULL;
					if (!CompareValue($this->other_details->DbValue, $this->Recordset->fields('other_details')))
						$this->other_details->CurrentValue = NULL;
					if (!CompareValue($this->bank_name->DbValue, $this->Recordset->fields('bank_name')))
						$this->bank_name->CurrentValue = NULL;
					if (!CompareValue($this->bank_ifsc_code->DbValue, $this->Recordset->fields('bank_ifsc_code')))
						$this->bank_ifsc_code->CurrentValue = NULL;
					if (!CompareValue($this->bank_account_no->DbValue, $this->Recordset->fields('bank_account_no')))
						$this->bank_account_no->CurrentValue = NULL;
					if (!CompareValue($this->account_no->DbValue, $this->Recordset->fields('account_no')))
						$this->account_no->CurrentValue = NULL;
					if (!CompareValue($this->loan_amount->DbValue, $this->Recordset->fields('loan_amount')))
						$this->loan_amount->CurrentValue = NULL;
					if (!CompareValue($this->emi_amount->DbValue, $this->Recordset->fields('emi_amount')))
						$this->emi_amount->CurrentValue = NULL;
					if (!CompareValue($this->frequency->DbValue, $this->Recordset->fields('frequency')))
						$this->frequency->CurrentValue = NULL;
					if (!CompareValue($this->disbursement_amount->DbValue, $this->Recordset->fields('disbursement_amount')))
						$this->disbursement_amount->CurrentValue = NULL;
					if (!CompareValue($this->operator->DbValue, $this->Recordset->fields('operator')))
						$this->operator->CurrentValue = NULL;
					if (!CompareValue($this->datetime->DbValue, $this->Recordset->fields('datetime')))
						$this->datetime->CurrentValue = NULL;
					if (!CompareValue($this->d_operator->DbValue, $this->Recordset->fields('d_operator')))
						$this->d_operator->CurrentValue = NULL;
					if (!CompareValue($this->d_datetime->DbValue, $this->Recordset->fields('d_datetime')))
						$this->d_datetime->CurrentValue = NULL;
					if (!CompareValue($this->no_of_emi->DbValue, $this->Recordset->fields('no_of_emi')))
						$this->no_of_emi->CurrentValue = NULL;
					if (!CompareValue($this->fund_o->DbValue, $this->Recordset->fields('fund_o')))
						$this->fund_o->CurrentValue = NULL;
					if (!CompareValue($this->fund_o_no->DbValue, $this->Recordset->fields('fund_o_no')))
						$this->fund_o_no->CurrentValue = NULL;
					if (!CompareValue($this->int_40->DbValue, $this->Recordset->fields('int_@')))
						$this->int_40->CurrentValue = NULL;
				}
				$i++;
				$this->Recordset->moveNext();
			}
			$this->Recordset->close();
		}
	}

	// Set up key value
	protected function setupKeyValues($key)
	{
		$keyFld = $key;
		if (!is_numeric($keyFld))
			return FALSE;
		$this->id->CurrentValue = $keyFld;
		return TRUE;
	}

	// Update all selected rows
	protected function updateRows()
	{
		global $Language;
		$conn = &$this->getConnection();
		$conn->beginTrans();
		if ($this->AuditTrailOnEdit)
			$this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin

		// Get old recordset
		$this->CurrentFilter = $this->getFilterFromRecordKeys();
		$sql = $this->getCurrentSql();
		$rsold = $conn->execute($sql);

		// Update all rows
		$key = "";
		foreach ($this->RecKeys as $reckey) {
			if ($this->setupKeyValues($reckey)) {
				$thisKey = $reckey;
				$this->SendEmail = FALSE; // Do not send email on update success
				$this->UpdateCount += 1; // Update record count for records being updated
				$updateRows = $this->editRow(); // Update this row
			} else {
				$updateRows = FALSE;
			}
			if (!$updateRows)
				break; // Update failed
			if ($key <> "")
				$key .= ", ";
			$key .= $thisKey;
		}

		// Check if all rows updated
		if ($updateRows) {
			$conn->commitTrans(); // Commit transaction

			// Get new recordset
			$rsnew = $conn->execute($sql);
			if ($this->AuditTrailOnEdit)
				$this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
		} else {
			$conn->rollbackTrans(); // Rollback transaction
			if ($this->AuditTrailOnEdit)
				$this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
		}
		return $updateRows;
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->image->Upload->Index = $CurrentForm->Index;
		$this->image->Upload->uploadFile();
		$this->image->CurrentValue = $this->image->Upload->FileName;
		$this->image->MultiUpdate = $CurrentForm->getValue("u_image");
		$this->sign_image->Upload->Index = $CurrentForm->Index;
		$this->sign_image->Upload->uploadFile();
		$this->sign_image->CurrentValue = $this->sign_image->Upload->FileName;
		$this->sign_image->MultiUpdate = $CurrentForm->getValue("u_sign_image");
		$this->id_proof->Upload->Index = $CurrentForm->Index;
		$this->id_proof->Upload->uploadFile();
		$this->id_proof->CurrentValue = $this->id_proof->Upload->FileName;
		$this->id_proof->MultiUpdate = $CurrentForm->getValue("u_id_proof");
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'b_type' first before field var 'x_b_type'
		$val = $CurrentForm->hasValue("b_type") ? $CurrentForm->getValue("b_type") : $CurrentForm->getValue("x_b_type");
		if (!$this->b_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_type->Visible = FALSE; // Disable update for API request
			else
				$this->b_type->setFormValue($val);
		}
		$this->b_type->MultiUpdate = $CurrentForm->getValue("u_b_type");

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}
		$this->grp->MultiUpdate = $CurrentForm->getValue("u_grp");

		// Check field name 'branch' first before field var 'x_branch'
		$val = $CurrentForm->hasValue("branch") ? $CurrentForm->getValue("branch") : $CurrentForm->getValue("x_branch");
		if (!$this->branch->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->branch->Visible = FALSE; // Disable update for API request
			else
				$this->branch->setFormValue($val);
		}
		$this->branch->MultiUpdate = $CurrentForm->getValue("u_branch");

		// Check field name 'account_type' first before field var 'x_account_type'
		$val = $CurrentForm->hasValue("account_type") ? $CurrentForm->getValue("account_type") : $CurrentForm->getValue("x_account_type");
		if (!$this->account_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->account_type->Visible = FALSE; // Disable update for API request
			else
				$this->account_type->setFormValue($val);
		}
		$this->account_type->MultiUpdate = $CurrentForm->getValue("u_account_type");

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}
		$this->type->MultiUpdate = $CurrentForm->getValue("u_type");

		// Check field name 'formal_name' first before field var 'x_formal_name'
		$val = $CurrentForm->hasValue("formal_name") ? $CurrentForm->getValue("formal_name") : $CurrentForm->getValue("x_formal_name");
		if (!$this->formal_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->formal_name->Visible = FALSE; // Disable update for API request
			else
				$this->formal_name->setFormValue($val);
		}
		$this->formal_name->MultiUpdate = $CurrentForm->getValue("u_formal_name");

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}
		$this->mobile->MultiUpdate = $CurrentForm->getValue("u_mobile");

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}
		$this->_email->MultiUpdate = $CurrentForm->getValue("u__email");

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}
		$this->status->MultiUpdate = $CurrentForm->getValue("u_status");

		// Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
		$val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
		if (!$this->aadhaar_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->aadhaar_no->Visible = FALSE; // Disable update for API request
			else
				$this->aadhaar_no->setFormValue($val);
		}
		$this->aadhaar_no->MultiUpdate = $CurrentForm->getValue("u_aadhaar_no");

		// Check field name 'pan_no' first before field var 'x_pan_no'
		$val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
		if (!$this->pan_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pan_no->Visible = FALSE; // Disable update for API request
			else
				$this->pan_no->setFormValue($val);
		}
		$this->pan_no->MultiUpdate = $CurrentForm->getValue("u_pan_no");

		// Check field name 'agent' first before field var 'x_agent'
		$val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
		if (!$this->agent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->agent->Visible = FALSE; // Disable update for API request
			else
				$this->agent->setFormValue($val);
		}
		$this->agent->MultiUpdate = $CurrentForm->getValue("u_agent");

		// Check field name 'other_details' first before field var 'x_other_details'
		$val = $CurrentForm->hasValue("other_details") ? $CurrentForm->getValue("other_details") : $CurrentForm->getValue("x_other_details");
		if (!$this->other_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_details->Visible = FALSE; // Disable update for API request
			else
				$this->other_details->setFormValue($val);
		}
		$this->other_details->MultiUpdate = $CurrentForm->getValue("u_other_details");

		// Check field name 'bank_name' first before field var 'x_bank_name'
		$val = $CurrentForm->hasValue("bank_name") ? $CurrentForm->getValue("bank_name") : $CurrentForm->getValue("x_bank_name");
		if (!$this->bank_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_name->Visible = FALSE; // Disable update for API request
			else
				$this->bank_name->setFormValue($val);
		}
		$this->bank_name->MultiUpdate = $CurrentForm->getValue("u_bank_name");

		// Check field name 'bank_ifsc_code' first before field var 'x_bank_ifsc_code'
		$val = $CurrentForm->hasValue("bank_ifsc_code") ? $CurrentForm->getValue("bank_ifsc_code") : $CurrentForm->getValue("x_bank_ifsc_code");
		if (!$this->bank_ifsc_code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_ifsc_code->Visible = FALSE; // Disable update for API request
			else
				$this->bank_ifsc_code->setFormValue($val);
		}
		$this->bank_ifsc_code->MultiUpdate = $CurrentForm->getValue("u_bank_ifsc_code");

		// Check field name 'bank_account_no' first before field var 'x_bank_account_no'
		$val = $CurrentForm->hasValue("bank_account_no") ? $CurrentForm->getValue("bank_account_no") : $CurrentForm->getValue("x_bank_account_no");
		if (!$this->bank_account_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bank_account_no->Visible = FALSE; // Disable update for API request
			else
				$this->bank_account_no->setFormValue($val);
		}
		$this->bank_account_no->MultiUpdate = $CurrentForm->getValue("u_bank_account_no");

		// Check field name 'account_no' first before field var 'x_account_no'
		$val = $CurrentForm->hasValue("account_no") ? $CurrentForm->getValue("account_no") : $CurrentForm->getValue("x_account_no");
		if (!$this->account_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->account_no->Visible = FALSE; // Disable update for API request
			else
				$this->account_no->setFormValue($val);
		}
		$this->account_no->MultiUpdate = $CurrentForm->getValue("u_account_no");

		// Check field name 'loan_amount' first before field var 'x_loan_amount'
		$val = $CurrentForm->hasValue("loan_amount") ? $CurrentForm->getValue("loan_amount") : $CurrentForm->getValue("x_loan_amount");
		if (!$this->loan_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->loan_amount->Visible = FALSE; // Disable update for API request
			else
				$this->loan_amount->setFormValue($val);
		}
		$this->loan_amount->MultiUpdate = $CurrentForm->getValue("u_loan_amount");

		// Check field name 'emi_amount' first before field var 'x_emi_amount'
		$val = $CurrentForm->hasValue("emi_amount") ? $CurrentForm->getValue("emi_amount") : $CurrentForm->getValue("x_emi_amount");
		if (!$this->emi_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emi_amount->Visible = FALSE; // Disable update for API request
			else
				$this->emi_amount->setFormValue($val);
		}
		$this->emi_amount->MultiUpdate = $CurrentForm->getValue("u_emi_amount");

		// Check field name 'frequency' first before field var 'x_frequency'
		$val = $CurrentForm->hasValue("frequency") ? $CurrentForm->getValue("frequency") : $CurrentForm->getValue("x_frequency");
		if (!$this->frequency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->frequency->Visible = FALSE; // Disable update for API request
			else
				$this->frequency->setFormValue($val);
		}
		$this->frequency->MultiUpdate = $CurrentForm->getValue("u_frequency");

		// Check field name 'disbursement_amount' first before field var 'x_disbursement_amount'
		$val = $CurrentForm->hasValue("disbursement_amount") ? $CurrentForm->getValue("disbursement_amount") : $CurrentForm->getValue("x_disbursement_amount");
		if (!$this->disbursement_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->disbursement_amount->Visible = FALSE; // Disable update for API request
			else
				$this->disbursement_amount->setFormValue($val);
		}
		$this->disbursement_amount->MultiUpdate = $CurrentForm->getValue("u_disbursement_amount");

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}
		$this->operator->MultiUpdate = $CurrentForm->getValue("u_operator");

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
		$this->datetime->MultiUpdate = $CurrentForm->getValue("u_datetime");

		// Check field name 'd_operator' first before field var 'x_d_operator'
		$val = $CurrentForm->hasValue("d_operator") ? $CurrentForm->getValue("d_operator") : $CurrentForm->getValue("x_d_operator");
		if (!$this->d_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_operator->Visible = FALSE; // Disable update for API request
			else
				$this->d_operator->setFormValue($val);
		}
		$this->d_operator->MultiUpdate = $CurrentForm->getValue("u_d_operator");

		// Check field name 'd_datetime' first before field var 'x_d_datetime'
		$val = $CurrentForm->hasValue("d_datetime") ? $CurrentForm->getValue("d_datetime") : $CurrentForm->getValue("x_d_datetime");
		if (!$this->d_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->d_datetime->setFormValue($val);
			$this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, 0);
		}
		$this->d_datetime->MultiUpdate = $CurrentForm->getValue("u_d_datetime");

		// Check field name 'no_of_emi' first before field var 'x_no_of_emi'
		$val = $CurrentForm->hasValue("no_of_emi") ? $CurrentForm->getValue("no_of_emi") : $CurrentForm->getValue("x_no_of_emi");
		if (!$this->no_of_emi->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->no_of_emi->Visible = FALSE; // Disable update for API request
			else
				$this->no_of_emi->setFormValue($val);
		}
		$this->no_of_emi->MultiUpdate = $CurrentForm->getValue("u_no_of_emi");

		// Check field name 'fund_o' first before field var 'x_fund_o'
		$val = $CurrentForm->hasValue("fund_o") ? $CurrentForm->getValue("fund_o") : $CurrentForm->getValue("x_fund_o");
		if (!$this->fund_o->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fund_o->Visible = FALSE; // Disable update for API request
			else
				$this->fund_o->setFormValue($val);
		}
		$this->fund_o->MultiUpdate = $CurrentForm->getValue("u_fund_o");

		// Check field name 'fund_o_no' first before field var 'x_fund_o_no'
		$val = $CurrentForm->hasValue("fund_o_no") ? $CurrentForm->getValue("fund_o_no") : $CurrentForm->getValue("x_fund_o_no");
		if (!$this->fund_o_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fund_o_no->Visible = FALSE; // Disable update for API request
			else
				$this->fund_o_no->setFormValue($val);
		}
		$this->fund_o_no->MultiUpdate = $CurrentForm->getValue("u_fund_o_no");

		// Check field name 'int_@' first before field var 'x_int_40'
		$val = $CurrentForm->hasValue("int_@") ? $CurrentForm->getValue("int_@") : $CurrentForm->getValue("x_int_40");
		if (!$this->int_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->int_40->Visible = FALSE; // Disable update for API request
			else
				$this->int_40->setFormValue($val);
		}
		$this->int_40->MultiUpdate = $CurrentForm->getValue("u_int_40");

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->b_type->CurrentValue = $this->b_type->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->branch->CurrentValue = $this->branch->FormValue;
		$this->account_type->CurrentValue = $this->account_type->FormValue;
		$this->type->CurrentValue = $this->type->FormValue;
		$this->formal_name->CurrentValue = $this->formal_name->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
		$this->pan_no->CurrentValue = $this->pan_no->FormValue;
		$this->agent->CurrentValue = $this->agent->FormValue;
		$this->other_details->CurrentValue = $this->other_details->FormValue;
		$this->bank_name->CurrentValue = $this->bank_name->FormValue;
		$this->bank_ifsc_code->CurrentValue = $this->bank_ifsc_code->FormValue;
		$this->bank_account_no->CurrentValue = $this->bank_account_no->FormValue;
		$this->account_no->CurrentValue = $this->account_no->FormValue;
		$this->loan_amount->CurrentValue = $this->loan_amount->FormValue;
		$this->emi_amount->CurrentValue = $this->emi_amount->FormValue;
		$this->frequency->CurrentValue = $this->frequency->FormValue;
		$this->disbursement_amount->CurrentValue = $this->disbursement_amount->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->d_operator->CurrentValue = $this->d_operator->FormValue;
		$this->d_datetime->CurrentValue = $this->d_datetime->FormValue;
		$this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, 0);
		$this->no_of_emi->CurrentValue = $this->no_of_emi->FormValue;
		$this->fund_o->CurrentValue = $this->fund_o->FormValue;
		$this->fund_o_no->CurrentValue = $this->fund_o_no->FormValue;
		$this->int_40->CurrentValue = $this->int_40->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->b_type->setDbValue($row['b_type']);
		$this->grp->setDbValue($row['grp']);
		$this->branch->setDbValue($row['branch']);
		$this->category->setDbValue($row['category']);
		$this->account_type->setDbValue($row['account_type']);
		$this->type->setDbValue($row['type']);
		$this->formal_name->setDbValue($row['formal_name']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->sign_image->Upload->DbValue = $row['sign_image'];
		$this->sign_image->setDbValue($this->sign_image->Upload->DbValue);
		$this->status->setDbValue($row['status']);
		$this->aadhaar_no->setDbValue($row['aadhaar_no']);
		$this->pan_no->setDbValue($row['pan_no']);
		$this->id_proof->Upload->DbValue = $row['id_proof'];
		$this->id_proof->setDbValue($this->id_proof->Upload->DbValue);
		$this->agent->setDbValue($row['agent']);
		$this->other_details->setDbValue($row['other_details']);
		$this->bank_name->setDbValue($row['bank_name']);
		$this->bank_ifsc_code->setDbValue($row['bank_ifsc_code']);
		$this->bank_account_no->setDbValue($row['bank_account_no']);
		$this->account_no->setDbValue($row['account_no']);
		$this->loan_amount->setDbValue($row['loan_amount']);
		$this->emi_amount->setDbValue($row['emi_amount']);
		$this->frequency->setDbValue($row['frequency']);
		$this->disbursement_amount->setDbValue($row['disbursement_amount']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->d_operator->setDbValue($row['d_operator']);
		$this->d_datetime->setDbValue($row['d_datetime']);
		$this->otp->setDbValue($row['otp']);
		$this->otp_delivery_datetime->setDbValue($row['otp_delivery_datetime']);
		$this->otp_verify_datetime->setDbValue($row['otp_verify_datetime']);
		$this->no_of_emi->setDbValue($row['no_of_emi']);
		$this->fund_o->setDbValue($row['fund_o']);
		$this->fund_o_no->setDbValue($row['fund_o_no']);
		$this->int_40->setDbValue($row['int_@']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['b_type'] = NULL;
		$row['grp'] = NULL;
		$row['branch'] = NULL;
		$row['category'] = NULL;
		$row['account_type'] = NULL;
		$row['type'] = NULL;
		$row['formal_name'] = NULL;
		$row['mobile'] = NULL;
		$row['email'] = NULL;
		$row['image'] = NULL;
		$row['sign_image'] = NULL;
		$row['status'] = NULL;
		$row['aadhaar_no'] = NULL;
		$row['pan_no'] = NULL;
		$row['id_proof'] = NULL;
		$row['agent'] = NULL;
		$row['other_details'] = NULL;
		$row['bank_name'] = NULL;
		$row['bank_ifsc_code'] = NULL;
		$row['bank_account_no'] = NULL;
		$row['account_no'] = NULL;
		$row['loan_amount'] = NULL;
		$row['emi_amount'] = NULL;
		$row['frequency'] = NULL;
		$row['disbursement_amount'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['d_operator'] = NULL;
		$row['d_datetime'] = NULL;
		$row['otp'] = NULL;
		$row['otp_delivery_datetime'] = NULL;
		$row['otp_verify_datetime'] = NULL;
		$row['no_of_emi'] = NULL;
		$row['fund_o'] = NULL;
		$row['fund_o_no'] = NULL;
		$row['int_@'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->loan_amount->FormValue == $this->loan_amount->CurrentValue && is_numeric(ConvertToFloatString($this->loan_amount->CurrentValue)))
			$this->loan_amount->CurrentValue = ConvertToFloatString($this->loan_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->emi_amount->FormValue == $this->emi_amount->CurrentValue && is_numeric(ConvertToFloatString($this->emi_amount->CurrentValue)))
			$this->emi_amount->CurrentValue = ConvertToFloatString($this->emi_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->disbursement_amount->FormValue == $this->disbursement_amount->CurrentValue && is_numeric(ConvertToFloatString($this->disbursement_amount->CurrentValue)))
			$this->disbursement_amount->CurrentValue = ConvertToFloatString($this->disbursement_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fund_o->FormValue == $this->fund_o->CurrentValue && is_numeric(ConvertToFloatString($this->fund_o->CurrentValue)))
			$this->fund_o->CurrentValue = ConvertToFloatString($this->fund_o->CurrentValue);

		// Convert decimal values if posted back
		if ($this->int_40->FormValue == $this->int_40->CurrentValue && is_numeric(ConvertToFloatString($this->int_40->CurrentValue)))
			$this->int_40->CurrentValue = ConvertToFloatString($this->int_40->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// b_type
		// grp
		// branch
		// category
		// account_type
		// type
		// formal_name
		// mobile
		// email
		// image
		// sign_image
		// status
		// aadhaar_no
		// pan_no
		// id_proof
		// agent
		// other_details
		// bank_name
		// bank_ifsc_code
		// bank_account_no
		// account_no
		// loan_amount
		// emi_amount
		// frequency
		// disbursement_amount
		// operator
		// datetime
		// d_operator
		// d_datetime
		// otp
		// otp_delivery_datetime
		// otp_verify_datetime
		// no_of_emi
		// fund_o
		// fund_o_no
		// int_@

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// b_type
			if (strval($this->b_type->CurrentValue) <> "") {
				$this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
			} else {
				$this->b_type->ViewValue = NULL;
			}
			$this->b_type->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// branch
			$curVal = strval($this->branch->CurrentValue);
			if ($curVal <> "") {
				$this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
				if ($this->branch->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->branch->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->branch->ViewValue = $this->branch->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->branch->ViewValue = $this->branch->CurrentValue;
					}
				}
			} else {
				$this->branch->ViewValue = NULL;
			}
			$this->branch->ViewCustomAttributes = "";

			// category
			if (strval($this->category->CurrentValue) <> "") {
				$this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// account_type
			$this->account_type->ViewValue = $this->account_type->CurrentValue;
			$this->account_type->ViewValue = FormatNumber($this->account_type->ViewValue, 0, -2, -2, -2);
			$this->account_type->ViewCustomAttributes = "";

			// type
			$curVal = strval($this->type->CurrentValue);
			if ($curVal <> "") {
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->type->ViewValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->ViewValue = $this->type->CurrentValue;
					}
				}
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// formal_name
			$this->formal_name->ViewValue = $this->formal_name->CurrentValue;
			$this->formal_name->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewValue = FormatNumber($this->mobile->ViewValue, 0, -2, -2, -2);
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// sign_image
			$this->sign_image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->sign_image->Upload->DbValue)) {
				$this->sign_image->ViewValue = $this->sign_image->Upload->DbValue;
			} else {
				$this->sign_image->ViewValue = "";
			}
			$this->sign_image->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// id_proof
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->ViewValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->ViewValue = "";
			}
			$this->id_proof->ViewCustomAttributes = "";

			// agent
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel` = 1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			$this->agent->ViewCustomAttributes = "";

			// other_details
			$this->other_details->ViewValue = $this->other_details->CurrentValue;
			$this->other_details->ViewCustomAttributes = "";

			// bank_name
			$this->bank_name->ViewValue = $this->bank_name->CurrentValue;
			$this->bank_name->ViewCustomAttributes = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->ViewValue = $this->bank_ifsc_code->CurrentValue;
			$this->bank_ifsc_code->ViewCustomAttributes = "";

			// bank_account_no
			$this->bank_account_no->ViewValue = $this->bank_account_no->CurrentValue;
			$this->bank_account_no->ViewCustomAttributes = "";

			// account_no
			$this->account_no->ViewValue = $this->account_no->CurrentValue;
			$this->account_no->ViewCustomAttributes = "";

			// loan_amount
			$this->loan_amount->ViewValue = $this->loan_amount->CurrentValue;
			$this->loan_amount->ViewValue = FormatNumber($this->loan_amount->ViewValue, 2, -2, -2, -2);
			$this->loan_amount->ViewCustomAttributes = "";

			// emi_amount
			$this->emi_amount->ViewValue = $this->emi_amount->CurrentValue;
			$this->emi_amount->ViewValue = FormatNumber($this->emi_amount->ViewValue, 2, -2, -2, -2);
			$this->emi_amount->ViewCustomAttributes = "";

			// frequency
			if (strval($this->frequency->CurrentValue) <> "") {
				$this->frequency->ViewValue = $this->frequency->optionCaption($this->frequency->CurrentValue);
			} else {
				$this->frequency->ViewValue = NULL;
			}
			$this->frequency->ViewCustomAttributes = "";

			// disbursement_amount
			$this->disbursement_amount->ViewValue = $this->disbursement_amount->CurrentValue;
			$this->disbursement_amount->ViewValue = FormatNumber($this->disbursement_amount->ViewValue, 2, -2, -2, -2);
			$this->disbursement_amount->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// d_operator
			$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
			$this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, 0, -2, -2, -2);
			$this->d_operator->ViewCustomAttributes = "";

			// d_datetime
			$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
			$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 0);
			$this->d_datetime->ViewCustomAttributes = "";

			// otp_delivery_datetime
			$this->otp_delivery_datetime->ViewValue = $this->otp_delivery_datetime->CurrentValue;
			$this->otp_delivery_datetime->ViewValue = FormatDateTime($this->otp_delivery_datetime->ViewValue, 0);
			$this->otp_delivery_datetime->ViewCustomAttributes = "";

			// otp_verify_datetime
			$this->otp_verify_datetime->ViewValue = $this->otp_verify_datetime->CurrentValue;
			$this->otp_verify_datetime->ViewValue = FormatDateTime($this->otp_verify_datetime->ViewValue, 0);
			$this->otp_verify_datetime->ViewCustomAttributes = "";

			// no_of_emi
			$this->no_of_emi->ViewValue = $this->no_of_emi->CurrentValue;
			$this->no_of_emi->ViewValue = FormatNumber($this->no_of_emi->ViewValue, 0, -2, -2, -2);
			$this->no_of_emi->ViewCustomAttributes = "";

			// fund_o
			$this->fund_o->ViewValue = $this->fund_o->CurrentValue;
			$this->fund_o->ViewValue = FormatNumber($this->fund_o->ViewValue, 2, -2, -2, -2);
			$this->fund_o->ViewCustomAttributes = "";

			// fund_o_no
			$curVal = strval($this->fund_o_no->CurrentValue);
			if ($curVal <> "") {
				$this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
				if ($this->fund_o_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`= 230401";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->fund_o_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->fund_o_no->ViewValue = $this->fund_o_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->fund_o_no->ViewValue = $this->fund_o_no->CurrentValue;
					}
				}
			} else {
				$this->fund_o_no->ViewValue = NULL;
			}
			$this->fund_o_no->ViewCustomAttributes = "";

			// int_@
			$this->int_40->ViewValue = $this->int_40->CurrentValue;
			$this->int_40->ViewValue = FormatNumber($this->int_40->ViewValue, 2, -2, -2, -2);
			$this->int_40->ViewCustomAttributes = "";

			// b_type
			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";
			$this->b_type->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// branch
			$this->branch->LinkCustomAttributes = "";
			$this->branch->HrefValue = "";
			$this->branch->TooltipValue = "";

			// account_type
			$this->account_type->LinkCustomAttributes = "";
			$this->account_type->HrefValue = "";
			$this->account_type->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";
			$this->formal_name->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";

			// sign_image
			$this->sign_image->LinkCustomAttributes = "";
			$this->sign_image->HrefValue = "";
			$this->sign_image->ExportHrefValue = $this->sign_image->UploadPath . $this->sign_image->Upload->DbValue;
			$this->sign_image->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = 'download';
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->HrefValue = "%u"; // Add prefix/suffix
				$this->id_proof->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->id_proof->HrefValue = FullUrl($this->id_proof->HrefValue, "href");
			} else {
				$this->id_proof->HrefValue = "";
			}
			$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;
			$this->id_proof->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";
			$this->other_details->TooltipValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";
			$this->bank_name->TooltipValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";
			$this->bank_ifsc_code->TooltipValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";
			$this->bank_account_no->TooltipValue = "";

			// account_no
			$this->account_no->LinkCustomAttributes = "";
			$this->account_no->HrefValue = "";
			$this->account_no->TooltipValue = "";

			// loan_amount
			$this->loan_amount->LinkCustomAttributes = "";
			$this->loan_amount->HrefValue = "";
			$this->loan_amount->TooltipValue = "";

			// emi_amount
			$this->emi_amount->LinkCustomAttributes = "";
			$this->emi_amount->HrefValue = "";
			$this->emi_amount->TooltipValue = "";

			// frequency
			$this->frequency->LinkCustomAttributes = "";
			$this->frequency->HrefValue = "";
			$this->frequency->TooltipValue = "";

			// disbursement_amount
			$this->disbursement_amount->LinkCustomAttributes = "";
			$this->disbursement_amount->HrefValue = "";
			$this->disbursement_amount->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// d_operator
			$this->d_operator->LinkCustomAttributes = "";
			$this->d_operator->HrefValue = "";
			$this->d_operator->TooltipValue = "";

			// d_datetime
			$this->d_datetime->LinkCustomAttributes = "";
			$this->d_datetime->HrefValue = "";
			$this->d_datetime->TooltipValue = "";

			// no_of_emi
			$this->no_of_emi->LinkCustomAttributes = "";
			$this->no_of_emi->HrefValue = "";
			$this->no_of_emi->TooltipValue = "";

			// fund_o
			$this->fund_o->LinkCustomAttributes = "";
			$this->fund_o->HrefValue = "";
			$this->fund_o->TooltipValue = "";

			// fund_o_no
			$this->fund_o_no->LinkCustomAttributes = "";
			$this->fund_o_no->HrefValue = "";
			$this->fund_o_no->TooltipValue = "";

			// int_@
			$this->int_40->LinkCustomAttributes = "";
			$this->int_40->HrefValue = "";
			$this->int_40->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// b_type
			$this->b_type->EditAttrs["class"] = "form-control";
			$this->b_type->EditCustomAttributes = "";
			$this->b_type->EditValue = $this->b_type->options(TRUE);

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// branch
			$this->branch->EditAttrs["class"] = "form-control";
			$this->branch->EditCustomAttributes = "";
			$curVal = trim(strval($this->branch->CurrentValue));
			if ($curVal <> "")
				$this->branch->ViewValue = $this->branch->lookupCacheOption($curVal);
			else
				$this->branch->ViewValue = $this->branch->Lookup !== NULL && is_array($this->branch->Lookup->Options) ? $curVal : NULL;
			if ($this->branch->ViewValue !== NULL) { // Load from cache
				$this->branch->EditValue = array_values($this->branch->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->branch->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 10";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->branch->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->branch->EditValue = $arwrk;
			}

			// account_type
			$this->account_type->EditAttrs["class"] = "form-control";
			$this->account_type->EditCustomAttributes = "";
			$this->account_type->EditValue = HtmlEncode($this->account_type->CurrentValue);
			$this->account_type->PlaceHolder = RemoveHtml($this->account_type->caption());

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$curVal = trim(strval($this->type->CurrentValue));
			if ($curVal <> "")
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
			else
				$this->type->ViewValue = $this->type->Lookup !== NULL && is_array($this->type->Lookup->Options) ? $curVal : NULL;
			if ($this->type->ViewValue !== NULL) { // Load from cache
				$this->type->EditValue = array_values($this->type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->type->EditValue = $arwrk;
			}

			// formal_name
			$this->formal_name->EditAttrs["class"] = "form-control";
			$this->formal_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->formal_name->CurrentValue = HtmlDecode($this->formal_name->CurrentValue);
			$this->formal_name->EditValue = HtmlEncode($this->formal_name->CurrentValue);
			$this->formal_name->PlaceHolder = RemoveHtml($this->formal_name->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->EditValue = $this->image->Upload->DbValue;
			} else {
				$this->image->EditValue = "";
			}
			if (!EmptyValue($this->image->CurrentValue))
					$this->image->Upload->FileName = $this->image->CurrentValue;

			// sign_image
			$this->sign_image->EditAttrs["class"] = "form-control";
			$this->sign_image->EditCustomAttributes = "";
			$this->sign_image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->sign_image->Upload->DbValue)) {
				$this->sign_image->EditValue = $this->sign_image->Upload->DbValue;
			} else {
				$this->sign_image->EditValue = "";
			}
			if (!EmptyValue($this->sign_image->CurrentValue))
					$this->sign_image->Upload->FileName = $this->sign_image->CurrentValue;

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = 'ReadOnly';
			$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->EditValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->status->EditValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
					}
				}
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// pan_no
			$this->pan_no->EditAttrs["class"] = "form-control";
			$this->pan_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
			$this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
			$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

			// id_proof
			$this->id_proof->EditAttrs["class"] = "form-control";
			$this->id_proof->EditCustomAttributes = "";
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->EditValue = $this->id_proof->Upload->DbValue;
			} else {
				$this->id_proof->EditValue = "";
			}
			if (!EmptyValue($this->id_proof->CurrentValue))
					$this->id_proof->Upload->FileName = $this->id_proof->CurrentValue;

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$curVal = trim(strval($this->agent->CurrentValue));
			if ($curVal <> "")
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
			else
				$this->agent->ViewValue = $this->agent->Lookup !== NULL && is_array($this->agent->Lookup->Options) ? $curVal : NULL;
			if ($this->agent->ViewValue !== NULL) { // Load from cache
				$this->agent->EditValue = array_values($this->agent->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->agent->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`userlevel` = 1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->agent->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->agent->EditValue = $arwrk;
			}

			// other_details
			$this->other_details->EditAttrs["class"] = "form-control";
			$this->other_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other_details->CurrentValue = HtmlDecode($this->other_details->CurrentValue);
			$this->other_details->EditValue = HtmlEncode($this->other_details->CurrentValue);
			$this->other_details->PlaceHolder = RemoveHtml($this->other_details->caption());

			// bank_name
			$this->bank_name->EditAttrs["class"] = "form-control";
			$this->bank_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_name->CurrentValue = HtmlDecode($this->bank_name->CurrentValue);
			$this->bank_name->EditValue = HtmlEncode($this->bank_name->CurrentValue);
			$this->bank_name->PlaceHolder = RemoveHtml($this->bank_name->caption());

			// bank_ifsc_code
			$this->bank_ifsc_code->EditAttrs["class"] = "form-control";
			$this->bank_ifsc_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_ifsc_code->CurrentValue = HtmlDecode($this->bank_ifsc_code->CurrentValue);
			$this->bank_ifsc_code->EditValue = HtmlEncode($this->bank_ifsc_code->CurrentValue);
			$this->bank_ifsc_code->PlaceHolder = RemoveHtml($this->bank_ifsc_code->caption());

			// bank_account_no
			$this->bank_account_no->EditAttrs["class"] = "form-control";
			$this->bank_account_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bank_account_no->CurrentValue = HtmlDecode($this->bank_account_no->CurrentValue);
			$this->bank_account_no->EditValue = HtmlEncode($this->bank_account_no->CurrentValue);
			$this->bank_account_no->PlaceHolder = RemoveHtml($this->bank_account_no->caption());

			// account_no
			$this->account_no->EditAttrs["class"] = "form-control";
			$this->account_no->EditCustomAttributes = 'ReadOnly';
			$this->account_no->EditValue = $this->account_no->CurrentValue;
			$this->account_no->ViewCustomAttributes = "";

			// loan_amount
			$this->loan_amount->EditAttrs["class"] = "form-control";
			$this->loan_amount->EditCustomAttributes = "";
			$this->loan_amount->EditValue = HtmlEncode($this->loan_amount->CurrentValue);
			$this->loan_amount->PlaceHolder = RemoveHtml($this->loan_amount->caption());
			if (strval($this->loan_amount->EditValue) <> "" && is_numeric($this->loan_amount->EditValue))
				$this->loan_amount->EditValue = FormatNumber($this->loan_amount->EditValue, -2, -2, -2, -2);

			// emi_amount
			$this->emi_amount->EditAttrs["class"] = "form-control";
			$this->emi_amount->EditCustomAttributes = "";
			$this->emi_amount->EditValue = HtmlEncode($this->emi_amount->CurrentValue);
			$this->emi_amount->PlaceHolder = RemoveHtml($this->emi_amount->caption());
			if (strval($this->emi_amount->EditValue) <> "" && is_numeric($this->emi_amount->EditValue))
				$this->emi_amount->EditValue = FormatNumber($this->emi_amount->EditValue, -2, -2, -2, -2);

			// frequency
			$this->frequency->EditAttrs["class"] = "form-control";
			$this->frequency->EditCustomAttributes = "";
			$this->frequency->EditValue = $this->frequency->options(TRUE);

			// disbursement_amount
			$this->disbursement_amount->EditAttrs["class"] = "form-control";
			$this->disbursement_amount->EditCustomAttributes = "";
			$this->disbursement_amount->EditValue = HtmlEncode($this->disbursement_amount->CurrentValue);
			$this->disbursement_amount->PlaceHolder = RemoveHtml($this->disbursement_amount->caption());
			if (strval($this->disbursement_amount->EditValue) <> "" && is_numeric($this->disbursement_amount->EditValue))
				$this->disbursement_amount->EditValue = FormatNumber($this->disbursement_amount->EditValue, -2, -2, -2, -2);

			// operator
			// datetime
			// d_operator
			// d_datetime
			// no_of_emi

			$this->no_of_emi->EditAttrs["class"] = "form-control";
			$this->no_of_emi->EditCustomAttributes = "";
			$this->no_of_emi->EditValue = HtmlEncode($this->no_of_emi->CurrentValue);
			$this->no_of_emi->PlaceHolder = RemoveHtml($this->no_of_emi->caption());

			// fund_o
			$this->fund_o->EditAttrs["class"] = "form-control";
			$this->fund_o->EditCustomAttributes = "";
			$this->fund_o->EditValue = HtmlEncode($this->fund_o->CurrentValue);
			$this->fund_o->PlaceHolder = RemoveHtml($this->fund_o->caption());
			if (strval($this->fund_o->EditValue) <> "" && is_numeric($this->fund_o->EditValue))
				$this->fund_o->EditValue = FormatNumber($this->fund_o->EditValue, -2, -2, -2, -2);

			// fund_o_no
			$this->fund_o_no->EditAttrs["class"] = "form-control";
			$this->fund_o_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->fund_o_no->CurrentValue));
			if ($curVal <> "")
				$this->fund_o_no->ViewValue = $this->fund_o_no->lookupCacheOption($curVal);
			else
				$this->fund_o_no->ViewValue = $this->fund_o_no->Lookup !== NULL && is_array($this->fund_o_no->Lookup->Options) ? $curVal : NULL;
			if ($this->fund_o_no->ViewValue !== NULL) { // Load from cache
				$this->fund_o_no->EditValue = array_values($this->fund_o_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->fund_o_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`= 230401";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->fund_o_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->fund_o_no->EditValue = $arwrk;
			}

			// int_@
			$this->int_40->EditAttrs["class"] = "form-control";
			$this->int_40->EditCustomAttributes = "";
			$this->int_40->EditValue = HtmlEncode($this->int_40->CurrentValue);
			$this->int_40->PlaceHolder = RemoveHtml($this->int_40->caption());
			if (strval($this->int_40->EditValue) <> "" && is_numeric($this->int_40->EditValue))
				$this->int_40->EditValue = FormatNumber($this->int_40->EditValue, -2, -2, -2, -2);

			// Edit refer script
			// b_type

			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// branch
			$this->branch->LinkCustomAttributes = "";
			$this->branch->HrefValue = "";

			// account_type
			$this->account_type->LinkCustomAttributes = "";
			$this->account_type->HrefValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";

			// formal_name
			$this->formal_name->LinkCustomAttributes = "";
			$this->formal_name->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->HrefValue = "";
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

			// sign_image
			$this->sign_image->LinkCustomAttributes = "";
			$this->sign_image->HrefValue = "";
			$this->sign_image->ExportHrefValue = $this->sign_image->UploadPath . $this->sign_image->Upload->DbValue;

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";

			// id_proof
			$this->id_proof->LinkCustomAttributes = 'download';
			$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			if (!EmptyValue($this->id_proof->Upload->DbValue)) {
				$this->id_proof->HrefValue = "%u"; // Add prefix/suffix
				$this->id_proof->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->id_proof->HrefValue = FullUrl($this->id_proof->HrefValue, "href");
			} else {
				$this->id_proof->HrefValue = "";
			}
			$this->id_proof->ExportHrefValue = $this->id_proof->UploadPath . $this->id_proof->Upload->DbValue;

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";

			// other_details
			$this->other_details->LinkCustomAttributes = "";
			$this->other_details->HrefValue = "";

			// bank_name
			$this->bank_name->LinkCustomAttributes = "";
			$this->bank_name->HrefValue = "";

			// bank_ifsc_code
			$this->bank_ifsc_code->LinkCustomAttributes = "";
			$this->bank_ifsc_code->HrefValue = "";

			// bank_account_no
			$this->bank_account_no->LinkCustomAttributes = "";
			$this->bank_account_no->HrefValue = "";

			// account_no
			$this->account_no->LinkCustomAttributes = "";
			$this->account_no->HrefValue = "";
			$this->account_no->TooltipValue = "";

			// loan_amount
			$this->loan_amount->LinkCustomAttributes = "";
			$this->loan_amount->HrefValue = "";

			// emi_amount
			$this->emi_amount->LinkCustomAttributes = "";
			$this->emi_amount->HrefValue = "";

			// frequency
			$this->frequency->LinkCustomAttributes = "";
			$this->frequency->HrefValue = "";

			// disbursement_amount
			$this->disbursement_amount->LinkCustomAttributes = "";
			$this->disbursement_amount->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// d_operator
			$this->d_operator->LinkCustomAttributes = "";
			$this->d_operator->HrefValue = "";

			// d_datetime
			$this->d_datetime->LinkCustomAttributes = "";
			$this->d_datetime->HrefValue = "";

			// no_of_emi
			$this->no_of_emi->LinkCustomAttributes = "";
			$this->no_of_emi->HrefValue = "";

			// fund_o
			$this->fund_o->LinkCustomAttributes = "";
			$this->fund_o->HrefValue = "";

			// fund_o_no
			$this->fund_o_no->LinkCustomAttributes = "";
			$this->fund_o_no->HrefValue = "";

			// int_@
			$this->int_40->LinkCustomAttributes = "";
			$this->int_40->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";
		$updateCnt = 0;
		if ($this->b_type->MultiUpdate == "1")
			$updateCnt++;
		if ($this->grp->MultiUpdate == "1")
			$updateCnt++;
		if ($this->branch->MultiUpdate == "1")
			$updateCnt++;
		if ($this->account_type->MultiUpdate == "1")
			$updateCnt++;
		if ($this->type->MultiUpdate == "1")
			$updateCnt++;
		if ($this->formal_name->MultiUpdate == "1")
			$updateCnt++;
		if ($this->mobile->MultiUpdate == "1")
			$updateCnt++;
		if ($this->_email->MultiUpdate == "1")
			$updateCnt++;
		if ($this->image->MultiUpdate == "1")
			$updateCnt++;
		if ($this->sign_image->MultiUpdate == "1")
			$updateCnt++;
		if ($this->status->MultiUpdate == "1")
			$updateCnt++;
		if ($this->aadhaar_no->MultiUpdate == "1")
			$updateCnt++;
		if ($this->pan_no->MultiUpdate == "1")
			$updateCnt++;
		if ($this->id_proof->MultiUpdate == "1")
			$updateCnt++;
		if ($this->agent->MultiUpdate == "1")
			$updateCnt++;
		if ($this->other_details->MultiUpdate == "1")
			$updateCnt++;
		if ($this->bank_name->MultiUpdate == "1")
			$updateCnt++;
		if ($this->bank_ifsc_code->MultiUpdate == "1")
			$updateCnt++;
		if ($this->bank_account_no->MultiUpdate == "1")
			$updateCnt++;
		if ($this->account_no->MultiUpdate == "1")
			$updateCnt++;
		if ($this->loan_amount->MultiUpdate == "1")
			$updateCnt++;
		if ($this->emi_amount->MultiUpdate == "1")
			$updateCnt++;
		if ($this->frequency->MultiUpdate == "1")
			$updateCnt++;
		if ($this->disbursement_amount->MultiUpdate == "1")
			$updateCnt++;
		if ($this->operator->MultiUpdate == "1")
			$updateCnt++;
		if ($this->datetime->MultiUpdate == "1")
			$updateCnt++;
		if ($this->d_operator->MultiUpdate == "1")
			$updateCnt++;
		if ($this->d_datetime->MultiUpdate == "1")
			$updateCnt++;
		if ($this->no_of_emi->MultiUpdate == "1")
			$updateCnt++;
		if ($this->fund_o->MultiUpdate == "1")
			$updateCnt++;
		if ($this->fund_o_no->MultiUpdate == "1")
			$updateCnt++;
		if ($this->int_40->MultiUpdate == "1")
			$updateCnt++;
		if ($updateCnt == 0) {
			$FormError = $Language->phrase("NoFieldSelected");
			return FALSE;
		}

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if ($this->id->MultiUpdate <> "" && !$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->b_type->Required) {
			if ($this->b_type->MultiUpdate <> "" && !$this->b_type->IsDetailKey && $this->b_type->FormValue != NULL && $this->b_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_type->caption(), $this->b_type->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if ($this->grp->MultiUpdate <> "" && !$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->branch->Required) {
			if ($this->branch->MultiUpdate <> "" && !$this->branch->IsDetailKey && $this->branch->FormValue != NULL && $this->branch->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->branch->caption(), $this->branch->RequiredErrorMessage));
			}
		}
		if ($this->category->Required) {
			if ($this->category->MultiUpdate <> "" && !$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->account_type->Required) {
			if ($this->account_type->MultiUpdate <> "" && !$this->account_type->IsDetailKey && $this->account_type->FormValue != NULL && $this->account_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->account_type->caption(), $this->account_type->RequiredErrorMessage));
			}
		}
		if ($this->account_type->MultiUpdate <> "") {
			if (!CheckInteger($this->account_type->FormValue)) {
				AddMessage($FormError, $this->account_type->errorMessage());
			}
		}
		if ($this->type->Required) {
			if ($this->type->MultiUpdate <> "" && !$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->formal_name->Required) {
			if ($this->formal_name->MultiUpdate <> "" && !$this->formal_name->IsDetailKey && $this->formal_name->FormValue != NULL && $this->formal_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->formal_name->caption(), $this->formal_name->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if ($this->mobile->MultiUpdate <> "" && !$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if ($this->mobile->MultiUpdate <> "") {
			if (!CheckInteger($this->mobile->FormValue)) {
				AddMessage($FormError, $this->mobile->errorMessage());
			}
		}
		if ($this->_email->Required) {
			if ($this->_email->MultiUpdate <> "" && !$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if ($this->_email->MultiUpdate <> "") {
			if (!CheckEmail($this->_email->FormValue)) {
				AddMessage($FormError, $this->_email->errorMessage());
			}
		}
		if ($this->image->Required) {
			if ($this->image->MultiUpdate <> "" && $this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->sign_image->Required) {
			if ($this->sign_image->MultiUpdate <> "" && $this->sign_image->Upload->FileName == "" && !$this->sign_image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->sign_image->caption(), $this->sign_image->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if ($this->status->MultiUpdate <> "" && !$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->status->MultiUpdate <> "") {
			if (!CheckInteger($this->status->FormValue)) {
				AddMessage($FormError, $this->status->errorMessage());
			}
		}
		if ($this->aadhaar_no->Required) {
			if ($this->aadhaar_no->MultiUpdate <> "" && !$this->aadhaar_no->IsDetailKey && $this->aadhaar_no->FormValue != NULL && $this->aadhaar_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar_no->MultiUpdate <> "") {
			if (!CheckInteger($this->aadhaar_no->FormValue)) {
				AddMessage($FormError, $this->aadhaar_no->errorMessage());
			}
		}
		if ($this->pan_no->Required) {
			if ($this->pan_no->MultiUpdate <> "" && !$this->pan_no->IsDetailKey && $this->pan_no->FormValue != NULL && $this->pan_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
			}
		}
		if ($this->id_proof->Required) {
			if ($this->id_proof->MultiUpdate <> "" && $this->id_proof->Upload->FileName == "" && !$this->id_proof->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->id_proof->caption(), $this->id_proof->RequiredErrorMessage));
			}
		}
		if ($this->agent->Required) {
			if ($this->agent->MultiUpdate <> "" && !$this->agent->IsDetailKey && $this->agent->FormValue != NULL && $this->agent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
			}
		}
		if ($this->other_details->Required) {
			if ($this->other_details->MultiUpdate <> "" && !$this->other_details->IsDetailKey && $this->other_details->FormValue != NULL && $this->other_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_details->caption(), $this->other_details->RequiredErrorMessage));
			}
		}
		if ($this->bank_name->Required) {
			if ($this->bank_name->MultiUpdate <> "" && !$this->bank_name->IsDetailKey && $this->bank_name->FormValue != NULL && $this->bank_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_name->caption(), $this->bank_name->RequiredErrorMessage));
			}
		}
		if ($this->bank_ifsc_code->Required) {
			if ($this->bank_ifsc_code->MultiUpdate <> "" && !$this->bank_ifsc_code->IsDetailKey && $this->bank_ifsc_code->FormValue != NULL && $this->bank_ifsc_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_ifsc_code->caption(), $this->bank_ifsc_code->RequiredErrorMessage));
			}
		}
		if ($this->bank_account_no->Required) {
			if ($this->bank_account_no->MultiUpdate <> "" && !$this->bank_account_no->IsDetailKey && $this->bank_account_no->FormValue != NULL && $this->bank_account_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bank_account_no->caption(), $this->bank_account_no->RequiredErrorMessage));
			}
		}
		if ($this->account_no->Required) {
			if ($this->account_no->MultiUpdate <> "" && !$this->account_no->IsDetailKey && $this->account_no->FormValue != NULL && $this->account_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->account_no->caption(), $this->account_no->RequiredErrorMessage));
			}
		}
		if ($this->loan_amount->Required) {
			if ($this->loan_amount->MultiUpdate <> "" && !$this->loan_amount->IsDetailKey && $this->loan_amount->FormValue != NULL && $this->loan_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->loan_amount->caption(), $this->loan_amount->RequiredErrorMessage));
			}
		}
		if ($this->loan_amount->MultiUpdate <> "") {
			if (!CheckNumber($this->loan_amount->FormValue)) {
				AddMessage($FormError, $this->loan_amount->errorMessage());
			}
		}
		if ($this->emi_amount->Required) {
			if ($this->emi_amount->MultiUpdate <> "" && !$this->emi_amount->IsDetailKey && $this->emi_amount->FormValue != NULL && $this->emi_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emi_amount->caption(), $this->emi_amount->RequiredErrorMessage));
			}
		}
		if ($this->emi_amount->MultiUpdate <> "") {
			if (!CheckNumber($this->emi_amount->FormValue)) {
				AddMessage($FormError, $this->emi_amount->errorMessage());
			}
		}
		if ($this->frequency->Required) {
			if ($this->frequency->MultiUpdate <> "" && !$this->frequency->IsDetailKey && $this->frequency->FormValue != NULL && $this->frequency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->frequency->caption(), $this->frequency->RequiredErrorMessage));
			}
		}
		if ($this->disbursement_amount->Required) {
			if ($this->disbursement_amount->MultiUpdate <> "" && !$this->disbursement_amount->IsDetailKey && $this->disbursement_amount->FormValue != NULL && $this->disbursement_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->disbursement_amount->caption(), $this->disbursement_amount->RequiredErrorMessage));
			}
		}
		if ($this->disbursement_amount->MultiUpdate <> "") {
			if (!CheckNumber($this->disbursement_amount->FormValue)) {
				AddMessage($FormError, $this->disbursement_amount->errorMessage());
			}
		}
		if ($this->operator->Required) {
			if ($this->operator->MultiUpdate <> "" && !$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if ($this->datetime->MultiUpdate <> "" && !$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->d_operator->Required) {
			if ($this->d_operator->MultiUpdate <> "" && !$this->d_operator->IsDetailKey && $this->d_operator->FormValue != NULL && $this->d_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_operator->caption(), $this->d_operator->RequiredErrorMessage));
			}
		}
		if ($this->d_datetime->Required) {
			if ($this->d_datetime->MultiUpdate <> "" && !$this->d_datetime->IsDetailKey && $this->d_datetime->FormValue != NULL && $this->d_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_datetime->caption(), $this->d_datetime->RequiredErrorMessage));
			}
		}
		if ($this->otp->Required) {
			if ($this->otp->MultiUpdate <> "" && !$this->otp->IsDetailKey && $this->otp->FormValue != NULL && $this->otp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->otp->caption(), $this->otp->RequiredErrorMessage));
			}
		}
		if ($this->otp_delivery_datetime->Required) {
			if ($this->otp_delivery_datetime->MultiUpdate <> "" && !$this->otp_delivery_datetime->IsDetailKey && $this->otp_delivery_datetime->FormValue != NULL && $this->otp_delivery_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->otp_delivery_datetime->caption(), $this->otp_delivery_datetime->RequiredErrorMessage));
			}
		}
		if ($this->otp_verify_datetime->Required) {
			if ($this->otp_verify_datetime->MultiUpdate <> "" && !$this->otp_verify_datetime->IsDetailKey && $this->otp_verify_datetime->FormValue != NULL && $this->otp_verify_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->otp_verify_datetime->caption(), $this->otp_verify_datetime->RequiredErrorMessage));
			}
		}
		if ($this->no_of_emi->Required) {
			if ($this->no_of_emi->MultiUpdate <> "" && !$this->no_of_emi->IsDetailKey && $this->no_of_emi->FormValue != NULL && $this->no_of_emi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->no_of_emi->caption(), $this->no_of_emi->RequiredErrorMessage));
			}
		}
		if ($this->no_of_emi->MultiUpdate <> "") {
			if (!CheckInteger($this->no_of_emi->FormValue)) {
				AddMessage($FormError, $this->no_of_emi->errorMessage());
			}
		}
		if ($this->fund_o->Required) {
			if ($this->fund_o->MultiUpdate <> "" && !$this->fund_o->IsDetailKey && $this->fund_o->FormValue != NULL && $this->fund_o->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fund_o->caption(), $this->fund_o->RequiredErrorMessage));
			}
		}
		if ($this->fund_o->MultiUpdate <> "") {
			if (!CheckNumber($this->fund_o->FormValue)) {
				AddMessage($FormError, $this->fund_o->errorMessage());
			}
		}
		if ($this->fund_o_no->Required) {
			if ($this->fund_o_no->MultiUpdate <> "" && !$this->fund_o_no->IsDetailKey && $this->fund_o_no->FormValue != NULL && $this->fund_o_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fund_o_no->caption(), $this->fund_o_no->RequiredErrorMessage));
			}
		}
		if ($this->int_40->Required) {
			if ($this->int_40->MultiUpdate <> "" && !$this->int_40->IsDetailKey && $this->int_40->FormValue != NULL && $this->int_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->int_40->caption(), $this->int_40->RequiredErrorMessage));
			}
		}
		if ($this->int_40->MultiUpdate <> "") {
			if (!CheckNumber($this->int_40->FormValue)) {
				AddMessage($FormError, $this->int_40->errorMessage());
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->account_no->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`account_no` = '" . AdjustSql($this->account_no->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->account_no->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->account_no->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->image->OldUploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			$this->image->UploadPath = $this->image->OldUploadPath;
			$this->sign_image->OldUploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
			$this->sign_image->UploadPath = $this->sign_image->OldUploadPath;
			$this->id_proof->OldUploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
			$this->id_proof->UploadPath = $this->id_proof->OldUploadPath;
			$rsnew = [];

			// b_type
			$this->b_type->setDbValueDef($rsnew, $this->b_type->CurrentValue, 0, $this->b_type->ReadOnly || $this->b_type->MultiUpdate <> "1");

			// branch
			$this->branch->setDbValueDef($rsnew, $this->branch->CurrentValue, NULL, $this->branch->ReadOnly || $this->branch->MultiUpdate <> "1");

			// account_type
			$this->account_type->setDbValueDef($rsnew, $this->account_type->CurrentValue, NULL, $this->account_type->ReadOnly || $this->account_type->MultiUpdate <> "1");

			// type
			$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, NULL, $this->type->ReadOnly || $this->type->MultiUpdate <> "1");

			// formal_name
			$this->formal_name->setDbValueDef($rsnew, $this->formal_name->CurrentValue, NULL, $this->formal_name->ReadOnly || $this->formal_name->MultiUpdate <> "1");

			// mobile
			$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, $this->mobile->ReadOnly || $this->mobile->MultiUpdate <> "1");

			// email
			$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, $this->_email->ReadOnly || $this->_email->MultiUpdate <> "1");

			// image
			if ($this->image->Visible && !$this->image->ReadOnly && strval($this->image->MultiUpdate) == "1" && !$this->image->Upload->KeepFile) {
				$this->image->Upload->DbValue = $rsold['image']; // Get original value
				if ($this->image->Upload->FileName == "") {
					$rsnew['image'] = NULL;
				} else {
					$rsnew['image'] = $this->image->Upload->FileName;
				}
				$this->image->ImageWidth = 600; // Resize width
				$this->image->ImageHeight = 600; // Resize height
			}

			// sign_image
			if ($this->sign_image->Visible && !$this->sign_image->ReadOnly && strval($this->sign_image->MultiUpdate) == "1" && !$this->sign_image->Upload->KeepFile) {
				$this->sign_image->Upload->DbValue = $rsold['sign_image']; // Get original value
				if ($this->sign_image->Upload->FileName == "") {
					$rsnew['sign_image'] = NULL;
				} else {
					$rsnew['sign_image'] = $this->sign_image->Upload->FileName;
				}
				$this->sign_image->ImageWidth = 300; // Resize width
				$this->sign_image->ImageHeight = 300; // Resize height
			}

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, $this->status->ReadOnly || $this->status->MultiUpdate <> "1");

			// aadhaar_no
			$this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, NULL, $this->aadhaar_no->ReadOnly || $this->aadhaar_no->MultiUpdate <> "1");

			// pan_no
			$this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, NULL, $this->pan_no->ReadOnly || $this->pan_no->MultiUpdate <> "1");

			// id_proof
			if ($this->id_proof->Visible && !$this->id_proof->ReadOnly && strval($this->id_proof->MultiUpdate) == "1" && !$this->id_proof->Upload->KeepFile) {
				$this->id_proof->Upload->DbValue = $rsold['id_proof']; // Get original value
				if ($this->id_proof->Upload->FileName == "") {
					$rsnew['id_proof'] = NULL;
				} else {
					$rsnew['id_proof'] = $this->id_proof->Upload->FileName;
				}
				$this->id_proof->ImageWidth = 600; // Resize width
				$this->id_proof->ImageHeight = 600; // Resize height
			}

			// agent
			$this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, NULL, $this->agent->ReadOnly || $this->agent->MultiUpdate <> "1");

			// other_details
			$this->other_details->setDbValueDef($rsnew, $this->other_details->CurrentValue, NULL, $this->other_details->ReadOnly || $this->other_details->MultiUpdate <> "1");

			// bank_name
			$this->bank_name->setDbValueDef($rsnew, $this->bank_name->CurrentValue, NULL, $this->bank_name->ReadOnly || $this->bank_name->MultiUpdate <> "1");

			// bank_ifsc_code
			$this->bank_ifsc_code->setDbValueDef($rsnew, $this->bank_ifsc_code->CurrentValue, NULL, $this->bank_ifsc_code->ReadOnly || $this->bank_ifsc_code->MultiUpdate <> "1");

			// bank_account_no
			$this->bank_account_no->setDbValueDef($rsnew, $this->bank_account_no->CurrentValue, NULL, $this->bank_account_no->ReadOnly || $this->bank_account_no->MultiUpdate <> "1");

			// loan_amount
			$this->loan_amount->setDbValueDef($rsnew, $this->loan_amount->CurrentValue, 0, $this->loan_amount->ReadOnly || $this->loan_amount->MultiUpdate <> "1");

			// emi_amount
			$this->emi_amount->setDbValueDef($rsnew, $this->emi_amount->CurrentValue, 0, $this->emi_amount->ReadOnly || $this->emi_amount->MultiUpdate <> "1");

			// frequency
			$this->frequency->setDbValueDef($rsnew, $this->frequency->CurrentValue, NULL, $this->frequency->ReadOnly || $this->frequency->MultiUpdate <> "1");

			// disbursement_amount
			$this->disbursement_amount->setDbValueDef($rsnew, $this->disbursement_amount->CurrentValue, 0, $this->disbursement_amount->ReadOnly || $this->disbursement_amount->MultiUpdate <> "1");

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// d_operator
			$this->d_operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['d_operator'] = &$this->d_operator->DbValue;

			// d_datetime
			$this->d_datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['d_datetime'] = &$this->d_datetime->DbValue;

			// no_of_emi
			$this->no_of_emi->setDbValueDef($rsnew, $this->no_of_emi->CurrentValue, NULL, $this->no_of_emi->ReadOnly || $this->no_of_emi->MultiUpdate <> "1");

			// fund_o
			$this->fund_o->setDbValueDef($rsnew, $this->fund_o->CurrentValue, NULL, $this->fund_o->ReadOnly || $this->fund_o->MultiUpdate <> "1");

			// fund_o_no
			$this->fund_o_no->setDbValueDef($rsnew, $this->fund_o_no->CurrentValue, NULL, $this->fund_o_no->ReadOnly || $this->fund_o_no->MultiUpdate <> "1");

			// int_@
			$this->int_40->setDbValueDef($rsnew, $this->int_40->CurrentValue, NULL, $this->int_40->ReadOnly || $this->int_40->MultiUpdate <> "1");
			if ($this->image->Visible && !$this->image->Upload->KeepFile) {
				$this->image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
				$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
				if (!EmptyValue($this->image->Upload->FileName) && $this->UpdateCount == 1) {
					$newFiles = array($this->image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file1) || file_exists($this->image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->image, $this->image->Upload->Index) . $file, UploadTempPath($this->image, $this->image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, NULL, $this->image->ReadOnly || $this->image->MultiUpdate <> "1");
				}
			}
			if ($this->sign_image->Visible && !$this->sign_image->Upload->KeepFile) {
				$this->sign_image->UploadPath = '.p_uploads/account_uploads/'.  $this->account_no->CurrentValue . '/';
				$oldFiles = EmptyValue($this->sign_image->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->sign_image->Upload->DbValue));
				if (!EmptyValue($this->sign_image->Upload->FileName) && $this->UpdateCount == 1) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->sign_image->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->sign_image, $this->sign_image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->sign_image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->sign_image, $this->sign_image->Upload->Index) . $file1) || file_exists($this->sign_image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->sign_image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->sign_image, $this->sign_image->Upload->Index) . $file, UploadTempPath($this->sign_image, $this->sign_image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->sign_image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->sign_image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->sign_image->setDbValueDef($rsnew, $this->sign_image->Upload->FileName, NULL, $this->sign_image->ReadOnly || $this->sign_image->MultiUpdate <> "1");
				}
			}
			if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
				$this->id_proof->UploadPath = '.p_uploads/account_uploads/'. $this->account_no->CurrentValue . '/';
				$oldFiles = EmptyValue($this->id_proof->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->id_proof->Upload->DbValue));
				if (!EmptyValue($this->id_proof->Upload->FileName) && $this->UpdateCount == 1) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->id_proof->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->id_proof->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file1) || file_exists($this->id_proof->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->id_proof->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file, UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->id_proof->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->id_proof->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->id_proof->setDbValueDef($rsnew, $this->id_proof->Upload->FileName, NULL, $this->id_proof->ReadOnly || $this->id_proof->MultiUpdate <> "1");
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->image->Visible && !$this->image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
						if (!EmptyValue($this->image->Upload->FileName) && $this->UpdateCount == 1) {
							$newFiles = array($this->image->Upload->FileName);
							$newFiles2 = array($rsnew['image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->image->Upload->resizeAndSaveToFile($this->image->ImageWidth, $this->image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->sign_image->Visible && !$this->sign_image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->sign_image->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->sign_image->Upload->DbValue));
						if (!EmptyValue($this->sign_image->Upload->FileName) && $this->UpdateCount == 1) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->sign_image->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['sign_image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->sign_image, $this->sign_image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->sign_image->Upload->resizeAndSaveToFile($this->sign_image->ImageWidth, $this->sign_image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->sign_image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->id_proof->Visible && !$this->id_proof->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->id_proof->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->id_proof->Upload->DbValue));
						if (!EmptyValue($this->id_proof->Upload->FileName) && $this->UpdateCount == 1) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->id_proof->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['id_proof']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->id_proof, $this->id_proof->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->id_proof->Upload->resizeAndSaveToFile($this->id_proof->ImageWidth, $this->id_proof->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->id_proof->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// image
		if ($this->image->Upload->FileToken <> "")
			CleanUploadTempPath($this->image->Upload->FileToken, $this->image->Upload->Index);
		else
			CleanUploadTempPath($this->image, $this->image->Upload->Index);

		// sign_image
		if ($this->sign_image->Upload->FileToken <> "")
			CleanUploadTempPath($this->sign_image->Upload->FileToken, $this->sign_image->Upload->Index);
		else
			CleanUploadTempPath($this->sign_image, $this->sign_image->Upload->Index);

		// id_proof
		if ($this->id_proof->Upload->FileToken <> "")
			CleanUploadTempPath($this->id_proof->Upload->FileToken, $this->id_proof->Upload->Index);
		else
			CleanUploadTempPath($this->id_proof, $this->id_proof->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("b_account_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "update";
		$Breadcrumb->add("update", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`id`>9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_branch":
					$lookupFilter = function() {
						return "`id` > 10";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`userlevel` = 1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_fund_o_no":
					$lookupFilter = function() {
						return "`grp`= 230401";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_branch":
							break;
						case "x_type":
							break;
						case "x_status":
							break;
						case "x_agent":
							break;
						case "x_fund_o_no":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'account_info');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>