<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class b_account_int_log_edit extends b_account_int_log
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'b_account_int_log';

	// Page object name
	public $PageObjName = "b_account_int_log_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (b_account_int_log)
		if (!isset($GLOBALS["b_account_int_log"]) || get_class($GLOBALS["b_account_int_log"]) == PROJECT_NAMESPACE . "b_account_int_log") {
			$GLOBALS["b_account_int_log"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["b_account_int_log"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_account_int_log');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $b_account_int_log;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($b_account_int_log);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "b_account_int_logview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("b_account_int_loglist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->account_no->setVisibility();
		$this->status->setVisibility();
		$this->emi_no->setVisibility();
		$this->emi_date->setVisibility();
		$this->principal->setVisibility();
		$this->emi->setVisibility();
		$this->interest->setVisibility();
		$this->deposited->setVisibility();
		$this->balance->setVisibility();
		$this->description->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->url->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->account_no);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("b_account_int_loglist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "b_account_int_loglist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'account_no' first before field var 'x_account_no'
		$val = $CurrentForm->hasValue("account_no") ? $CurrentForm->getValue("account_no") : $CurrentForm->getValue("x_account_no");
		if (!$this->account_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->account_no->Visible = FALSE; // Disable update for API request
			else
				$this->account_no->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'emi_no' first before field var 'x_emi_no'
		$val = $CurrentForm->hasValue("emi_no") ? $CurrentForm->getValue("emi_no") : $CurrentForm->getValue("x_emi_no");
		if (!$this->emi_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emi_no->Visible = FALSE; // Disable update for API request
			else
				$this->emi_no->setFormValue($val);
		}

		// Check field name 'emi_date' first before field var 'x_emi_date'
		$val = $CurrentForm->hasValue("emi_date") ? $CurrentForm->getValue("emi_date") : $CurrentForm->getValue("x_emi_date");
		if (!$this->emi_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emi_date->Visible = FALSE; // Disable update for API request
			else
				$this->emi_date->setFormValue($val);
			$this->emi_date->CurrentValue = UnFormatDateTime($this->emi_date->CurrentValue, 0);
		}

		// Check field name 'principal' first before field var 'x_principal'
		$val = $CurrentForm->hasValue("principal") ? $CurrentForm->getValue("principal") : $CurrentForm->getValue("x_principal");
		if (!$this->principal->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->principal->Visible = FALSE; // Disable update for API request
			else
				$this->principal->setFormValue($val);
		}

		// Check field name 'emi' first before field var 'x_emi'
		$val = $CurrentForm->hasValue("emi") ? $CurrentForm->getValue("emi") : $CurrentForm->getValue("x_emi");
		if (!$this->emi->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->emi->Visible = FALSE; // Disable update for API request
			else
				$this->emi->setFormValue($val);
		}

		// Check field name 'interest' first before field var 'x_interest'
		$val = $CurrentForm->hasValue("interest") ? $CurrentForm->getValue("interest") : $CurrentForm->getValue("x_interest");
		if (!$this->interest->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->interest->Visible = FALSE; // Disable update for API request
			else
				$this->interest->setFormValue($val);
		}

		// Check field name 'deposited' first before field var 'x_deposited'
		$val = $CurrentForm->hasValue("deposited") ? $CurrentForm->getValue("deposited") : $CurrentForm->getValue("x_deposited");
		if (!$this->deposited->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->deposited->Visible = FALSE; // Disable update for API request
			else
				$this->deposited->setFormValue($val);
		}

		// Check field name 'balance' first before field var 'x_balance'
		$val = $CurrentForm->hasValue("balance") ? $CurrentForm->getValue("balance") : $CurrentForm->getValue("x_balance");
		if (!$this->balance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->balance->Visible = FALSE; // Disable update for API request
			else
				$this->balance->setFormValue($val);
		}

		// Check field name 'description' first before field var 'x_description'
		$val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
		if (!$this->description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description->Visible = FALSE; // Disable update for API request
			else
				$this->description->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->account_no->CurrentValue = $this->account_no->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->emi_no->CurrentValue = $this->emi_no->FormValue;
		$this->emi_date->CurrentValue = $this->emi_date->FormValue;
		$this->emi_date->CurrentValue = UnFormatDateTime($this->emi_date->CurrentValue, 0);
		$this->principal->CurrentValue = $this->principal->FormValue;
		$this->emi->CurrentValue = $this->emi->FormValue;
		$this->interest->CurrentValue = $this->interest->FormValue;
		$this->deposited->CurrentValue = $this->deposited->FormValue;
		$this->balance->CurrentValue = $this->balance->FormValue;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->account_no->setDbValue($row['account_no']);
		if (array_key_exists('EV__account_no', $rs->fields)) {
			$this->account_no->VirtualValue = $rs->fields('EV__account_no'); // Set up virtual field value
		} else {
			$this->account_no->VirtualValue = ""; // Clear value
		}
		$this->status->setDbValue($row['status']);
		$this->emi_no->setDbValue($row['emi_no']);
		$this->emi_date->setDbValue($row['emi_date']);
		$this->principal->setDbValue($row['principal']);
		$this->emi->setDbValue($row['emi']);
		$this->interest->setDbValue($row['interest']);
		$this->deposited->setDbValue($row['deposited']);
		$this->balance->setDbValue($row['balance']);
		$this->description->setDbValue($row['description']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->url->setDbValue($row['url']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['account_no'] = NULL;
		$row['status'] = NULL;
		$row['emi_no'] = NULL;
		$row['emi_date'] = NULL;
		$row['principal'] = NULL;
		$row['emi'] = NULL;
		$row['interest'] = NULL;
		$row['deposited'] = NULL;
		$row['balance'] = NULL;
		$row['description'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['url'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->principal->FormValue == $this->principal->CurrentValue && is_numeric(ConvertToFloatString($this->principal->CurrentValue)))
			$this->principal->CurrentValue = ConvertToFloatString($this->principal->CurrentValue);

		// Convert decimal values if posted back
		if ($this->emi->FormValue == $this->emi->CurrentValue && is_numeric(ConvertToFloatString($this->emi->CurrentValue)))
			$this->emi->CurrentValue = ConvertToFloatString($this->emi->CurrentValue);

		// Convert decimal values if posted back
		if ($this->interest->FormValue == $this->interest->CurrentValue && is_numeric(ConvertToFloatString($this->interest->CurrentValue)))
			$this->interest->CurrentValue = ConvertToFloatString($this->interest->CurrentValue);

		// Convert decimal values if posted back
		if ($this->deposited->FormValue == $this->deposited->CurrentValue && is_numeric(ConvertToFloatString($this->deposited->CurrentValue)))
			$this->deposited->CurrentValue = ConvertToFloatString($this->deposited->CurrentValue);

		// Convert decimal values if posted back
		if ($this->balance->FormValue == $this->balance->CurrentValue && is_numeric(ConvertToFloatString($this->balance->CurrentValue)))
			$this->balance->CurrentValue = ConvertToFloatString($this->balance->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// account_no
		// status
		// emi_no
		// emi_date
		// principal
		// emi
		// interest
		// deposited
		// balance
		// description
		// operator
		// datetime
		// url

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// account_no
			if ($this->account_no->VirtualValue <> "") {
				$this->account_no->ViewValue = $this->account_no->VirtualValue;
			} else {
				$this->account_no->ViewValue = $this->account_no->CurrentValue;
			$curVal = strval($this->account_no->CurrentValue);
			if ($curVal <> "") {
				$this->account_no->ViewValue = $this->account_no->lookupCacheOption($curVal);
				if ($this->account_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`account_no` > 100000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->account_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
						$this->account_no->ViewValue = $this->account_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->account_no->ViewValue = $this->account_no->CurrentValue;
					}
				}
			} else {
				$this->account_no->ViewValue = NULL;
			}
			}
			$this->account_no->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// emi_no
			$this->emi_no->ViewValue = $this->emi_no->CurrentValue;
			$this->emi_no->ViewValue = FormatNumber($this->emi_no->ViewValue, 0, -2, -2, -2);
			$this->emi_no->ViewCustomAttributes = "";

			// emi_date
			$this->emi_date->ViewValue = $this->emi_date->CurrentValue;
			$this->emi_date->ViewValue = FormatDateTime($this->emi_date->ViewValue, 0);
			$this->emi_date->ViewCustomAttributes = "";

			// principal
			$this->principal->ViewValue = $this->principal->CurrentValue;
			$this->principal->ViewValue = FormatNumber($this->principal->ViewValue, 2, -2, -2, -2);
			$this->principal->ViewCustomAttributes = "";

			// emi
			$this->emi->ViewValue = $this->emi->CurrentValue;
			$this->emi->ViewValue = FormatNumber($this->emi->ViewValue, 2, -2, -2, -2);
			$this->emi->ViewCustomAttributes = "";

			// interest
			$this->interest->ViewValue = $this->interest->CurrentValue;
			$this->interest->ViewValue = FormatNumber($this->interest->ViewValue, 2, -2, -2, -2);
			$this->interest->ViewCustomAttributes = "";

			// deposited
			$this->deposited->ViewValue = $this->deposited->CurrentValue;
			$this->deposited->ViewValue = FormatNumber($this->deposited->ViewValue, 2, -2, -2, -2);
			$this->deposited->ViewCustomAttributes = "";

			// balance
			$this->balance->ViewValue = $this->balance->CurrentValue;
			$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
			$this->balance->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// account_no
			$this->account_no->LinkCustomAttributes = "";
			$this->account_no->HrefValue = "";
			$this->account_no->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// emi_no
			$this->emi_no->LinkCustomAttributes = "";
			$this->emi_no->HrefValue = "";
			$this->emi_no->TooltipValue = "";

			// emi_date
			$this->emi_date->LinkCustomAttributes = "";
			$this->emi_date->HrefValue = "";
			$this->emi_date->TooltipValue = "";

			// principal
			$this->principal->LinkCustomAttributes = "";
			$this->principal->HrefValue = "";
			$this->principal->TooltipValue = "";

			// emi
			$this->emi->LinkCustomAttributes = "";
			$this->emi->HrefValue = "";
			$this->emi->TooltipValue = "";

			// interest
			$this->interest->LinkCustomAttributes = "";
			$this->interest->HrefValue = "";
			$this->interest->TooltipValue = "";

			// deposited
			$this->deposited->LinkCustomAttributes = "";
			$this->deposited->HrefValue = "";
			$this->deposited->TooltipValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";
			$this->balance->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->description->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->description->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
			} else {
				$this->description->HrefValue = "";
			}
			$this->description->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// account_no
			$this->account_no->EditAttrs["class"] = "form-control";
			$this->account_no->EditCustomAttributes = "";
			$this->account_no->EditValue = HtmlEncode($this->account_no->CurrentValue);
			$curVal = strval($this->account_no->CurrentValue);
			if ($curVal <> "") {
				$this->account_no->EditValue = $this->account_no->lookupCacheOption($curVal);
				if ($this->account_no->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`account_no` > 100000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->account_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2));
						$arwrk[4] = HtmlEncode(FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2));
						$this->account_no->EditValue = $this->account_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->account_no->EditValue = HtmlEncode($this->account_no->CurrentValue);
					}
				}
			} else {
				$this->account_no->EditValue = NULL;
			}
			$this->account_no->PlaceHolder = RemoveHtml($this->account_no->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// emi_no
			$this->emi_no->EditAttrs["class"] = "form-control";
			$this->emi_no->EditCustomAttributes = "";
			$this->emi_no->EditValue = HtmlEncode($this->emi_no->CurrentValue);
			$this->emi_no->PlaceHolder = RemoveHtml($this->emi_no->caption());

			// emi_date
			$this->emi_date->EditAttrs["class"] = "form-control";
			$this->emi_date->EditCustomAttributes = "";
			$this->emi_date->EditValue = HtmlEncode(FormatDateTime($this->emi_date->CurrentValue, 8));
			$this->emi_date->PlaceHolder = RemoveHtml($this->emi_date->caption());

			// principal
			$this->principal->EditAttrs["class"] = "form-control";
			$this->principal->EditCustomAttributes = "";
			$this->principal->EditValue = HtmlEncode($this->principal->CurrentValue);
			$this->principal->PlaceHolder = RemoveHtml($this->principal->caption());
			if (strval($this->principal->EditValue) <> "" && is_numeric($this->principal->EditValue))
				$this->principal->EditValue = FormatNumber($this->principal->EditValue, -2, -2, -2, -2);

			// emi
			$this->emi->EditAttrs["class"] = "form-control";
			$this->emi->EditCustomAttributes = "";
			$this->emi->EditValue = HtmlEncode($this->emi->CurrentValue);
			$this->emi->PlaceHolder = RemoveHtml($this->emi->caption());
			if (strval($this->emi->EditValue) <> "" && is_numeric($this->emi->EditValue))
				$this->emi->EditValue = FormatNumber($this->emi->EditValue, -2, -2, -2, -2);

			// interest
			$this->interest->EditAttrs["class"] = "form-control";
			$this->interest->EditCustomAttributes = "";
			$this->interest->EditValue = HtmlEncode($this->interest->CurrentValue);
			$this->interest->PlaceHolder = RemoveHtml($this->interest->caption());
			if (strval($this->interest->EditValue) <> "" && is_numeric($this->interest->EditValue))
				$this->interest->EditValue = FormatNumber($this->interest->EditValue, -2, -2, -2, -2);

			// deposited
			$this->deposited->EditAttrs["class"] = "form-control";
			$this->deposited->EditCustomAttributes = "";
			$this->deposited->EditValue = HtmlEncode($this->deposited->CurrentValue);
			$this->deposited->PlaceHolder = RemoveHtml($this->deposited->caption());
			if (strval($this->deposited->EditValue) <> "" && is_numeric($this->deposited->EditValue))
				$this->deposited->EditValue = FormatNumber($this->deposited->EditValue, -2, -2, -2, -2);

			// balance
			$this->balance->EditAttrs["class"] = "form-control";
			$this->balance->EditCustomAttributes = "";
			$this->balance->EditValue = HtmlEncode($this->balance->CurrentValue);
			$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
			if (strval($this->balance->EditValue) <> "" && is_numeric($this->balance->EditValue))
				$this->balance->EditValue = FormatNumber($this->balance->EditValue, -2, -2, -2, -2);

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
			$this->description->EditValue = HtmlEncode($this->description->CurrentValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// account_no
			$this->account_no->LinkCustomAttributes = "";
			$this->account_no->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// emi_no
			$this->emi_no->LinkCustomAttributes = "";
			$this->emi_no->HrefValue = "";

			// emi_date
			$this->emi_date->LinkCustomAttributes = "";
			$this->emi_date->HrefValue = "";

			// principal
			$this->principal->LinkCustomAttributes = "";
			$this->principal->HrefValue = "";

			// emi
			$this->emi->LinkCustomAttributes = "";
			$this->emi->HrefValue = "";

			// interest
			$this->interest->LinkCustomAttributes = "";
			$this->interest->HrefValue = "";

			// deposited
			$this->deposited->LinkCustomAttributes = "";
			$this->deposited->HrefValue = "";

			// balance
			$this->balance->LinkCustomAttributes = "";
			$this->balance->HrefValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->description->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->description->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->description->HrefValue = FullUrl($this->description->HrefValue, "href");
			} else {
				$this->description->HrefValue = "";
			}

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->account_no->Required) {
			if (!$this->account_no->IsDetailKey && $this->account_no->FormValue != NULL && $this->account_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->account_no->caption(), $this->account_no->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->emi_no->Required) {
			if (!$this->emi_no->IsDetailKey && $this->emi_no->FormValue != NULL && $this->emi_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emi_no->caption(), $this->emi_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->emi_no->FormValue)) {
			AddMessage($FormError, $this->emi_no->errorMessage());
		}
		if ($this->emi_date->Required) {
			if (!$this->emi_date->IsDetailKey && $this->emi_date->FormValue != NULL && $this->emi_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emi_date->caption(), $this->emi_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->emi_date->FormValue)) {
			AddMessage($FormError, $this->emi_date->errorMessage());
		}
		if ($this->principal->Required) {
			if (!$this->principal->IsDetailKey && $this->principal->FormValue != NULL && $this->principal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->principal->caption(), $this->principal->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->principal->FormValue)) {
			AddMessage($FormError, $this->principal->errorMessage());
		}
		if ($this->emi->Required) {
			if (!$this->emi->IsDetailKey && $this->emi->FormValue != NULL && $this->emi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emi->caption(), $this->emi->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->emi->FormValue)) {
			AddMessage($FormError, $this->emi->errorMessage());
		}
		if ($this->interest->Required) {
			if (!$this->interest->IsDetailKey && $this->interest->FormValue != NULL && $this->interest->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->interest->caption(), $this->interest->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->interest->FormValue)) {
			AddMessage($FormError, $this->interest->errorMessage());
		}
		if ($this->deposited->Required) {
			if (!$this->deposited->IsDetailKey && $this->deposited->FormValue != NULL && $this->deposited->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->deposited->caption(), $this->deposited->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->deposited->FormValue)) {
			AddMessage($FormError, $this->deposited->errorMessage());
		}
		if ($this->balance->Required) {
			if (!$this->balance->IsDetailKey && $this->balance->FormValue != NULL && $this->balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->balance->caption(), $this->balance->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->balance->FormValue)) {
			AddMessage($FormError, $this->balance->errorMessage());
		}
		if ($this->description->Required) {
			if (!$this->description->IsDetailKey && $this->description->FormValue != NULL && $this->description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// account_no
			$this->account_no->setDbValueDef($rsnew, $this->account_no->CurrentValue, NULL, $this->account_no->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, $this->status->ReadOnly);

			// emi_no
			$this->emi_no->setDbValueDef($rsnew, $this->emi_no->CurrentValue, NULL, $this->emi_no->ReadOnly);

			// emi_date
			$this->emi_date->setDbValueDef($rsnew, UnFormatDateTime($this->emi_date->CurrentValue, 0), NULL, $this->emi_date->ReadOnly);

			// principal
			$this->principal->setDbValueDef($rsnew, $this->principal->CurrentValue, NULL, $this->principal->ReadOnly);

			// emi
			$this->emi->setDbValueDef($rsnew, $this->emi->CurrentValue, NULL, $this->emi->ReadOnly);

			// interest
			$this->interest->setDbValueDef($rsnew, $this->interest->CurrentValue, NULL, $this->interest->ReadOnly);

			// deposited
			$this->deposited->setDbValueDef($rsnew, $this->deposited->CurrentValue, NULL, $this->deposited->ReadOnly);

			// balance
			$this->balance->setDbValueDef($rsnew, $this->balance->CurrentValue, NULL, $this->balance->ReadOnly);

			// description
			$this->description->setDbValueDef($rsnew, $this->description->CurrentValue, "", $this->description->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("b_account_int_loglist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_account_no":
					$lookupFilter = function() {
						return "`account_no` > 100000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_account_no":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 0, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>