<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class b_incentive_add extends b_incentive
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'b_incentive';

	// Page object name
	public $PageObjName = "b_incentive_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (b_incentive)
		if (!isset($GLOBALS["b_incentive"]) || get_class($GLOBALS["b_incentive"]) == PROJECT_NAMESPACE . "b_incentive") {
			$GLOBALS["b_incentive"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["b_incentive"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'b_incentive');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $b_incentive;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($b_incentive);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "b_incentiveview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("b_incentivelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->category->setVisibility();
		$this->type->setVisibility();
		$this->target_amount->setVisibility();
		$this->target_file->setVisibility();
		$this->file_inc->setVisibility();
		$this->neg_file_inc->setVisibility();
		$this->inc_min_amount->setVisibility();
		$this->inc_max_amount->setVisibility();
		$this->inc_percent->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->type);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("b_incentivelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "b_incentivelist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "b_incentiveview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->category->CurrentValue = NULL;
		$this->category->OldValue = $this->category->CurrentValue;
		$this->type->CurrentValue = NULL;
		$this->type->OldValue = $this->type->CurrentValue;
		$this->target_amount->CurrentValue = 0;
		$this->target_file->CurrentValue = 0;
		$this->file_inc->CurrentValue = 0;
		$this->neg_file_inc->CurrentValue = 0;
		$this->inc_min_amount->CurrentValue = 0;
		$this->inc_max_amount->CurrentValue = 0;
		$this->inc_percent->CurrentValue = 0.000;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'category' first before field var 'x_category'
		$val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
		if (!$this->category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->category->Visible = FALSE; // Disable update for API request
			else
				$this->category->setFormValue($val);
		}

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}

		// Check field name 'target_amount' first before field var 'x_target_amount'
		$val = $CurrentForm->hasValue("target_amount") ? $CurrentForm->getValue("target_amount") : $CurrentForm->getValue("x_target_amount");
		if (!$this->target_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->target_amount->Visible = FALSE; // Disable update for API request
			else
				$this->target_amount->setFormValue($val);
		}

		// Check field name 'target_file' first before field var 'x_target_file'
		$val = $CurrentForm->hasValue("target_file") ? $CurrentForm->getValue("target_file") : $CurrentForm->getValue("x_target_file");
		if (!$this->target_file->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->target_file->Visible = FALSE; // Disable update for API request
			else
				$this->target_file->setFormValue($val);
		}

		// Check field name 'file_inc' first before field var 'x_file_inc'
		$val = $CurrentForm->hasValue("file_inc") ? $CurrentForm->getValue("file_inc") : $CurrentForm->getValue("x_file_inc");
		if (!$this->file_inc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->file_inc->Visible = FALSE; // Disable update for API request
			else
				$this->file_inc->setFormValue($val);
		}

		// Check field name 'neg_file_inc' first before field var 'x_neg_file_inc'
		$val = $CurrentForm->hasValue("neg_file_inc") ? $CurrentForm->getValue("neg_file_inc") : $CurrentForm->getValue("x_neg_file_inc");
		if (!$this->neg_file_inc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->neg_file_inc->Visible = FALSE; // Disable update for API request
			else
				$this->neg_file_inc->setFormValue($val);
		}

		// Check field name 'inc_min_amount' first before field var 'x_inc_min_amount'
		$val = $CurrentForm->hasValue("inc_min_amount") ? $CurrentForm->getValue("inc_min_amount") : $CurrentForm->getValue("x_inc_min_amount");
		if (!$this->inc_min_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->inc_min_amount->Visible = FALSE; // Disable update for API request
			else
				$this->inc_min_amount->setFormValue($val);
		}

		// Check field name 'inc_max_amount' first before field var 'x_inc_max_amount'
		$val = $CurrentForm->hasValue("inc_max_amount") ? $CurrentForm->getValue("inc_max_amount") : $CurrentForm->getValue("x_inc_max_amount");
		if (!$this->inc_max_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->inc_max_amount->Visible = FALSE; // Disable update for API request
			else
				$this->inc_max_amount->setFormValue($val);
		}

		// Check field name 'inc_percent' first before field var 'x_inc_percent'
		$val = $CurrentForm->hasValue("inc_percent") ? $CurrentForm->getValue("inc_percent") : $CurrentForm->getValue("x_inc_percent");
		if (!$this->inc_percent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->inc_percent->Visible = FALSE; // Disable update for API request
			else
				$this->inc_percent->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->category->CurrentValue = $this->category->FormValue;
		$this->type->CurrentValue = $this->type->FormValue;
		$this->target_amount->CurrentValue = $this->target_amount->FormValue;
		$this->target_file->CurrentValue = $this->target_file->FormValue;
		$this->file_inc->CurrentValue = $this->file_inc->FormValue;
		$this->neg_file_inc->CurrentValue = $this->neg_file_inc->FormValue;
		$this->inc_min_amount->CurrentValue = $this->inc_min_amount->FormValue;
		$this->inc_max_amount->CurrentValue = $this->inc_max_amount->FormValue;
		$this->inc_percent->CurrentValue = $this->inc_percent->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->category->setDbValue($row['category']);
		$this->type->setDbValue($row['type']);
		$this->target_amount->setDbValue($row['target_amount']);
		$this->target_file->setDbValue($row['target_file']);
		$this->file_inc->setDbValue($row['file_inc']);
		$this->neg_file_inc->setDbValue($row['neg_file_inc']);
		$this->inc_min_amount->setDbValue($row['inc_min_amount']);
		$this->inc_max_amount->setDbValue($row['inc_max_amount']);
		$this->inc_percent->setDbValue($row['inc_percent']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['category'] = $this->category->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['target_amount'] = $this->target_amount->CurrentValue;
		$row['target_file'] = $this->target_file->CurrentValue;
		$row['file_inc'] = $this->file_inc->CurrentValue;
		$row['neg_file_inc'] = $this->neg_file_inc->CurrentValue;
		$row['inc_min_amount'] = $this->inc_min_amount->CurrentValue;
		$row['inc_max_amount'] = $this->inc_max_amount->CurrentValue;
		$row['inc_percent'] = $this->inc_percent->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->inc_percent->FormValue == $this->inc_percent->CurrentValue && is_numeric(ConvertToFloatString($this->inc_percent->CurrentValue)))
			$this->inc_percent->CurrentValue = ConvertToFloatString($this->inc_percent->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// category
		// type
		// target_amount
		// target_file
		// file_inc
		// neg_file_inc
		// inc_min_amount
		// inc_max_amount
		// inc_percent
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `id` between 101 and 110";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// type
			$curVal = strval($this->type->CurrentValue);
			if ($curVal <> "") {
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
				if ($this->type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 1301 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->type->ViewValue = $this->type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->type->ViewValue = $this->type->CurrentValue;
					}
				}
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// target_amount
			$this->target_amount->ViewValue = $this->target_amount->CurrentValue;
			$this->target_amount->ViewValue = FormatNumber($this->target_amount->ViewValue, 0, -2, -2, -2);
			$this->target_amount->ViewCustomAttributes = "";

			// target_file
			$this->target_file->ViewValue = $this->target_file->CurrentValue;
			$this->target_file->ViewValue = FormatNumber($this->target_file->ViewValue, 0, -2, -2, -2);
			$this->target_file->ViewCustomAttributes = "";

			// file_inc
			$this->file_inc->ViewValue = $this->file_inc->CurrentValue;
			$this->file_inc->ViewValue = FormatNumber($this->file_inc->ViewValue, 0, -2, -2, -2);
			$this->file_inc->ViewCustomAttributes = "";

			// neg_file_inc
			$this->neg_file_inc->ViewValue = $this->neg_file_inc->CurrentValue;
			$this->neg_file_inc->ViewValue = FormatNumber($this->neg_file_inc->ViewValue, 0, -2, -2, -2);
			$this->neg_file_inc->ViewCustomAttributes = "";

			// inc_min_amount
			$this->inc_min_amount->ViewValue = $this->inc_min_amount->CurrentValue;
			$this->inc_min_amount->ViewValue = FormatNumber($this->inc_min_amount->ViewValue, 0, -2, -2, -2);
			$this->inc_min_amount->ViewCustomAttributes = "";

			// inc_max_amount
			$this->inc_max_amount->ViewValue = $this->inc_max_amount->CurrentValue;
			$this->inc_max_amount->ViewValue = FormatNumber($this->inc_max_amount->ViewValue, 0, -2, -2, -2);
			$this->inc_max_amount->ViewCustomAttributes = "";

			// inc_percent
			$this->inc_percent->ViewValue = $this->inc_percent->CurrentValue;
			$this->inc_percent->ViewValue = FormatNumber($this->inc_percent->ViewValue, 2, -2, -2, -2);
			$this->inc_percent->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// target_amount
			$this->target_amount->LinkCustomAttributes = "";
			$this->target_amount->HrefValue = "";
			$this->target_amount->TooltipValue = "";

			// target_file
			$this->target_file->LinkCustomAttributes = "";
			$this->target_file->HrefValue = "";
			$this->target_file->TooltipValue = "";

			// file_inc
			$this->file_inc->LinkCustomAttributes = "";
			$this->file_inc->HrefValue = "";
			$this->file_inc->TooltipValue = "";

			// neg_file_inc
			$this->neg_file_inc->LinkCustomAttributes = "";
			$this->neg_file_inc->HrefValue = "";
			$this->neg_file_inc->TooltipValue = "";

			// inc_min_amount
			$this->inc_min_amount->LinkCustomAttributes = "";
			$this->inc_min_amount->HrefValue = "";
			$this->inc_min_amount->TooltipValue = "";

			// inc_max_amount
			$this->inc_max_amount->LinkCustomAttributes = "";
			$this->inc_max_amount->HrefValue = "";
			$this->inc_max_amount->TooltipValue = "";

			// inc_percent
			$this->inc_percent->LinkCustomAttributes = "";
			$this->inc_percent->HrefValue = "";
			$this->inc_percent->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->CurrentValue));
			if ($curVal <> "")
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `id` between 101 and 110";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$curVal = trim(strval($this->type->CurrentValue));
			if ($curVal <> "")
				$this->type->ViewValue = $this->type->lookupCacheOption($curVal);
			else
				$this->type->ViewValue = $this->type->Lookup !== NULL && is_array($this->type->Lookup->Options) ? $curVal : NULL;
			if ($this->type->ViewValue !== NULL) { // Load from cache
				$this->type->EditValue = array_values($this->type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 1301 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->type->EditValue = $arwrk;
			}

			// target_amount
			$this->target_amount->EditAttrs["class"] = "form-control";
			$this->target_amount->EditCustomAttributes = "";
			$this->target_amount->EditValue = HtmlEncode($this->target_amount->CurrentValue);
			$this->target_amount->PlaceHolder = RemoveHtml($this->target_amount->caption());

			// target_file
			$this->target_file->EditAttrs["class"] = "form-control";
			$this->target_file->EditCustomAttributes = "";
			$this->target_file->EditValue = HtmlEncode($this->target_file->CurrentValue);
			$this->target_file->PlaceHolder = RemoveHtml($this->target_file->caption());

			// file_inc
			$this->file_inc->EditAttrs["class"] = "form-control";
			$this->file_inc->EditCustomAttributes = "";
			$this->file_inc->EditValue = HtmlEncode($this->file_inc->CurrentValue);
			$this->file_inc->PlaceHolder = RemoveHtml($this->file_inc->caption());

			// neg_file_inc
			$this->neg_file_inc->EditAttrs["class"] = "form-control";
			$this->neg_file_inc->EditCustomAttributes = "";
			$this->neg_file_inc->EditValue = HtmlEncode($this->neg_file_inc->CurrentValue);
			$this->neg_file_inc->PlaceHolder = RemoveHtml($this->neg_file_inc->caption());

			// inc_min_amount
			$this->inc_min_amount->EditAttrs["class"] = "form-control";
			$this->inc_min_amount->EditCustomAttributes = "";
			$this->inc_min_amount->EditValue = HtmlEncode($this->inc_min_amount->CurrentValue);
			$this->inc_min_amount->PlaceHolder = RemoveHtml($this->inc_min_amount->caption());

			// inc_max_amount
			$this->inc_max_amount->EditAttrs["class"] = "form-control";
			$this->inc_max_amount->EditCustomAttributes = "";
			$this->inc_max_amount->EditValue = HtmlEncode($this->inc_max_amount->CurrentValue);
			$this->inc_max_amount->PlaceHolder = RemoveHtml($this->inc_max_amount->caption());

			// inc_percent
			$this->inc_percent->EditAttrs["class"] = "form-control";
			$this->inc_percent->EditCustomAttributes = "";
			$this->inc_percent->EditValue = HtmlEncode($this->inc_percent->CurrentValue);
			$this->inc_percent->PlaceHolder = RemoveHtml($this->inc_percent->caption());
			if (strval($this->inc_percent->EditValue) <> "" && is_numeric($this->inc_percent->EditValue))
				$this->inc_percent->EditValue = FormatNumber($this->inc_percent->EditValue, -2, -2, -2, -2);

			// operator
			// datetime
			// Add refer script
			// category

			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";

			// target_amount
			$this->target_amount->LinkCustomAttributes = "";
			$this->target_amount->HrefValue = "";

			// target_file
			$this->target_file->LinkCustomAttributes = "";
			$this->target_file->HrefValue = "";

			// file_inc
			$this->file_inc->LinkCustomAttributes = "";
			$this->file_inc->HrefValue = "";

			// neg_file_inc
			$this->neg_file_inc->LinkCustomAttributes = "";
			$this->neg_file_inc->HrefValue = "";

			// inc_min_amount
			$this->inc_min_amount->LinkCustomAttributes = "";
			$this->inc_min_amount->HrefValue = "";

			// inc_max_amount
			$this->inc_max_amount->LinkCustomAttributes = "";
			$this->inc_max_amount->HrefValue = "";

			// inc_percent
			$this->inc_percent->LinkCustomAttributes = "";
			$this->inc_percent->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->target_amount->Required) {
			if (!$this->target_amount->IsDetailKey && $this->target_amount->FormValue != NULL && $this->target_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->target_amount->caption(), $this->target_amount->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->target_amount->FormValue)) {
			AddMessage($FormError, $this->target_amount->errorMessage());
		}
		if ($this->target_file->Required) {
			if (!$this->target_file->IsDetailKey && $this->target_file->FormValue != NULL && $this->target_file->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->target_file->caption(), $this->target_file->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->target_file->FormValue)) {
			AddMessage($FormError, $this->target_file->errorMessage());
		}
		if ($this->file_inc->Required) {
			if (!$this->file_inc->IsDetailKey && $this->file_inc->FormValue != NULL && $this->file_inc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->file_inc->caption(), $this->file_inc->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->file_inc->FormValue)) {
			AddMessage($FormError, $this->file_inc->errorMessage());
		}
		if ($this->neg_file_inc->Required) {
			if (!$this->neg_file_inc->IsDetailKey && $this->neg_file_inc->FormValue != NULL && $this->neg_file_inc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->neg_file_inc->caption(), $this->neg_file_inc->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->neg_file_inc->FormValue)) {
			AddMessage($FormError, $this->neg_file_inc->errorMessage());
		}
		if ($this->inc_min_amount->Required) {
			if (!$this->inc_min_amount->IsDetailKey && $this->inc_min_amount->FormValue != NULL && $this->inc_min_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->inc_min_amount->caption(), $this->inc_min_amount->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->inc_min_amount->FormValue)) {
			AddMessage($FormError, $this->inc_min_amount->errorMessage());
		}
		if ($this->inc_max_amount->Required) {
			if (!$this->inc_max_amount->IsDetailKey && $this->inc_max_amount->FormValue != NULL && $this->inc_max_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->inc_max_amount->caption(), $this->inc_max_amount->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->inc_max_amount->FormValue)) {
			AddMessage($FormError, $this->inc_max_amount->errorMessage());
		}
		if ($this->inc_percent->Required) {
			if (!$this->inc_percent->IsDetailKey && $this->inc_percent->FormValue != NULL && $this->inc_percent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->inc_percent->caption(), $this->inc_percent->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->inc_percent->FormValue)) {
			AddMessage($FormError, $this->inc_percent->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// category
		$this->category->setDbValueDef($rsnew, $this->category->CurrentValue, 0, FALSE);

		// type
		$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, 0, FALSE);

		// target_amount
		$this->target_amount->setDbValueDef($rsnew, $this->target_amount->CurrentValue, 0, strval($this->target_amount->CurrentValue) == "");

		// target_file
		$this->target_file->setDbValueDef($rsnew, $this->target_file->CurrentValue, 0, strval($this->target_file->CurrentValue) == "");

		// file_inc
		$this->file_inc->setDbValueDef($rsnew, $this->file_inc->CurrentValue, 0, strval($this->file_inc->CurrentValue) == "");

		// neg_file_inc
		$this->neg_file_inc->setDbValueDef($rsnew, $this->neg_file_inc->CurrentValue, 0, strval($this->neg_file_inc->CurrentValue) == "");

		// inc_min_amount
		$this->inc_min_amount->setDbValueDef($rsnew, $this->inc_min_amount->CurrentValue, 0, strval($this->inc_min_amount->CurrentValue) == "");

		// inc_max_amount
		$this->inc_max_amount->setDbValueDef($rsnew, $this->inc_max_amount->CurrentValue, 0, strval($this->inc_max_amount->CurrentValue) == "");

		// inc_percent
		$this->inc_percent->setDbValueDef($rsnew, $this->inc_percent->CurrentValue, 0, strval($this->inc_percent->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("b_incentivelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_category":
					$lookupFilter = function() {
						return "`status` = 1 and `id` between 101 and 110";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_type":
					$lookupFilter = function() {
						return "`grp` = 1301 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_category":
							break;
						case "x_type":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>