<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for balance
 */
class balance extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $reference;
	public $grp;
	public $sub_category;
	public $account;
	public $name;
	public $ref_account;
	public $debit;
	public $credit;
	public $balance;
	public $at;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'balance';
		$this->TableName = 'balance';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`balance`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('balance', 'balance', 'x_id', 'id', '`id`', '`id`', 200, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['id'] = &$this->id;

		// reference
		$this->reference = new DbField('balance', 'balance', 'x_reference', 'reference', '`reference`', '`reference`', 200, -1, FALSE, '`reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reference->Sortable = TRUE; // Allow sort
		$this->fields['reference'] = &$this->reference;

		// grp
		$this->grp = new DbField('balance', 'balance', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->fields['grp'] = &$this->grp;

		// sub_category
		$this->sub_category = new DbField('balance', 'balance', 'x_sub_category', 'sub_category', '(select `sub_category` from `buyer` where`buyer`.`id` = account)', '(select `sub_category` from `buyer` where`buyer`.`id` = account)', 2, -1, FALSE, '(select `sub_category` from `buyer` where`buyer`.`id` = account)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->sub_category->IsCustom = TRUE; // Custom field
		$this->sub_category->Sortable = TRUE; // Allow sort
		$this->sub_category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->sub_category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->sub_category->Lookup = new Lookup('sub_category', 'pp_category', FALSE, 'id', ["category","","",""], [], [], [], [], [], [], '`category` ASC', '');
		$this->sub_category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sub_category'] = &$this->sub_category;

		// account
		$this->account = new DbField('balance', 'balance', 'x_account', 'account', '`account`', '`account`', 19, -1, FALSE, '`account`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->account->Sortable = TRUE; // Allow sort
		$this->account->Lookup = new Lookup('account', 'buyer_seller_employee', FALSE, 'id', ["id","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->account->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['account'] = &$this->account;

		// name
		$this->name = new DbField('balance', 'balance', 'x_name', 'name', '`name`', '`name`', 200, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Sortable = TRUE; // Allow sort
		$this->fields['name'] = &$this->name;

		// ref_account
		$this->ref_account = new DbField('balance', 'balance', 'x_ref_account', 'ref_account', '`ref_account`', '`ref_account`', 131, -1, FALSE, '`ref_account`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ref_account->Sortable = FALSE; // Allow sort
		$this->ref_account->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ref_account->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->ref_account->Lookup = new Lookup('ref_account', 'buyer_seller_employee', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['ref_account'] = &$this->ref_account;

		// debit
		$this->debit = new DbField('balance', 'balance', 'x_debit', 'debit', '`debit`', '`debit`', 131, -1, FALSE, '`debit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->debit->Sortable = TRUE; // Allow sort
		$this->debit->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['debit'] = &$this->debit;

		// credit
		$this->credit = new DbField('balance', 'balance', 'x_credit', 'credit', '`credit`', '`credit`', 131, -1, FALSE, '`credit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->credit->Sortable = TRUE; // Allow sort
		$this->credit->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['credit'] = &$this->credit;

		// balance
		$this->balance = new DbField('balance', 'balance', 'x_balance', 'balance', '`balance`', '`balance`', 131, -1, FALSE, '`balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance->Sortable = TRUE; // Allow sort
		$this->balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['balance'] = &$this->balance;

		// at
		$this->at = new DbField('balance', 'balance', 'x_at', 'at', '`at`', '`at`', 200, -1, FALSE, '`at`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->at->Sortable = FALSE; // Allow sort
		$this->fields['at'] = &$this->at;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`balance`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, (select `sub_category` from `buyer` where`buyer`.`id` = account) AS `sub_category` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (CurrentUserLevel() == 999) ? "FIND_IN_SET(`account`, '" . getAccountAadhaar() . "')" : "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`account` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->reference->DbValue = $row['reference'];
		$this->grp->DbValue = $row['grp'];
		$this->sub_category->DbValue = $row['sub_category'];
		$this->account->DbValue = $row['account'];
		$this->name->DbValue = $row['name'];
		$this->ref_account->DbValue = $row['ref_account'];
		$this->debit->DbValue = $row['debit'];
		$this->credit->DbValue = $row['credit'];
		$this->balance->DbValue = $row['balance'];
		$this->at->DbValue = $row['at'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "balancelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "balanceview.php")
			return $Language->phrase("View");
		elseif ($pageName == "balanceedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "balanceadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "balancelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("balanceview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("balanceview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "balanceadd.php?" . $this->getUrlParm($parm);
		else
			$url = "balanceadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("balanceedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("balanceadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("balancedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->reference->setDbValue($rs->fields('reference'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->sub_category->setDbValue($rs->fields('sub_category'));
		$this->account->setDbValue($rs->fields('account'));
		$this->name->setDbValue($rs->fields('name'));
		$this->ref_account->setDbValue($rs->fields('ref_account'));
		$this->debit->setDbValue($rs->fields('debit'));
		$this->credit->setDbValue($rs->fields('credit'));
		$this->balance->setDbValue($rs->fields('balance'));
		$this->at->setDbValue($rs->fields('at'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id

		$this->id->CellCssStyle = "white-space: nowrap;";

		// reference
		$this->reference->CellCssStyle = "white-space: nowrap;";

		// grp
		// sub_category
		// account

		$this->account->CellCssStyle = "white-space: nowrap;";

		// name
		// ref_account

		$this->ref_account->CellCssStyle = "white-space: nowrap;";

		// debit
		// credit
		// balance
		// at

		$this->at->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// reference
		$this->reference->ViewValue = $this->reference->CurrentValue;
		$this->reference->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// sub_category
		$curVal = strval($this->sub_category->CurrentValue);
		if ($curVal <> "") {
			$this->sub_category->ViewValue = $this->sub_category->lookupCacheOption($curVal);
			if ($this->sub_category->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->sub_category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->sub_category->ViewValue = $this->sub_category->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->sub_category->ViewValue = $this->sub_category->CurrentValue;
				}
			}
		} else {
			$this->sub_category->ViewValue = NULL;
		}
		$this->sub_category->ViewCustomAttributes = "";

		// account
		$this->account->ViewValue = $this->account->CurrentValue;
		$curVal = strval($this->account->CurrentValue);
		if ($curVal <> "") {
			$this->account->ViewValue = $this->account->lookupCacheOption($curVal);
			if ($this->account->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->account->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$this->account->ViewValue = $this->account->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->account->ViewValue = $this->account->CurrentValue;
				}
			}
		} else {
			$this->account->ViewValue = NULL;
		}
		$this->account->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$this->name->ViewCustomAttributes = "";

		// ref_account
		$curVal = strval($this->ref_account->CurrentValue);
		if ($curVal <> "") {
			$this->ref_account->ViewValue = $this->ref_account->lookupCacheOption($curVal);
			if ($this->ref_account->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ref_account->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ref_account->ViewValue = $this->ref_account->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ref_account->ViewValue = $this->ref_account->CurrentValue;
				}
			}
		} else {
			$this->ref_account->ViewValue = NULL;
		}
		$this->ref_account->ViewCustomAttributes = "";

		// debit
		$this->debit->ViewValue = $this->debit->CurrentValue;
		$this->debit->ViewValue = FormatNumber($this->debit->ViewValue, 2, -2, -2, -2);
		$this->debit->ViewCustomAttributes = "";

		// credit
		$this->credit->ViewValue = $this->credit->CurrentValue;
		$this->credit->ViewValue = FormatNumber($this->credit->ViewValue, 2, -2, -2, -2);
		$this->credit->ViewCustomAttributes = "";

		// balance
		$this->balance->ViewValue = $this->balance->CurrentValue;
		$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
		$this->balance->ViewCustomAttributes = "";

		// at
		$this->at->ViewValue = $this->at->CurrentValue;
		$this->at->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// reference
		$this->reference->LinkCustomAttributes = "";
		$this->reference->HrefValue = "";
		$this->reference->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// sub_category
		$this->sub_category->LinkCustomAttributes = "";
		$this->sub_category->HrefValue = "";
		$this->sub_category->TooltipValue = "";

		// account
		$this->account->LinkCustomAttributes = "";
		if (!EmptyValue($this->account->CurrentValue)) {
			$this->account->HrefValue = "balancelist.php?x_account=" . $this->account->CurrentValue; // Add prefix/suffix
			$this->account->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->account->HrefValue = FullUrl($this->account->HrefValue, "href");
		} else {
			$this->account->HrefValue = "";
		}
		$this->account->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		if (!EmptyValue($this->name->CurrentValue)) {
			$this->name->HrefValue = "balancelist.php?x_name=" . $this->name->CurrentValue; // Add prefix/suffix
			$this->name->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->name->HrefValue = FullUrl($this->name->HrefValue, "href");
		} else {
			$this->name->HrefValue = "";
		}
		$this->name->TooltipValue = "";

		// ref_account
		$this->ref_account->LinkCustomAttributes = "";
		$this->ref_account->HrefValue = "";
		$this->ref_account->TooltipValue = "";

		// debit
		$this->debit->LinkCustomAttributes = "";
		$this->debit->HrefValue = "";
		$this->debit->TooltipValue = "";

		// credit
		$this->credit->LinkCustomAttributes = "";
		$this->credit->HrefValue = "";
		$this->credit->TooltipValue = "";

		// balance
		$this->balance->LinkCustomAttributes = "";
		if (!EmptyValue($this->name->CurrentValue)) {
			$this->balance->HrefValue = "balance_detailedlist.php?x_name=" . $this->name->CurrentValue; // Add prefix/suffix
			$this->balance->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->balance->HrefValue = FullUrl($this->balance->HrefValue, "href");
		} else {
			$this->balance->HrefValue = "";
		}
		$this->balance->TooltipValue = "";

		// at
		$this->at->LinkCustomAttributes = "";
		$this->at->HrefValue = "";
		$this->at->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->id->CurrentValue = HtmlDecode($this->id->CurrentValue);
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// reference
		$this->reference->EditAttrs["class"] = "form-control";
		$this->reference->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
		$this->reference->EditValue = $this->reference->CurrentValue;
		$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// sub_category
		$this->sub_category->EditAttrs["class"] = "form-control";
		$this->sub_category->EditCustomAttributes = "";

		// account
		$this->account->EditAttrs["class"] = "form-control";
		$this->account->EditCustomAttributes = "";
		$this->account->EditValue = $this->account->CurrentValue;
		$this->account->PlaceHolder = RemoveHtml($this->account->caption());

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// ref_account
		$this->ref_account->EditAttrs["class"] = "form-control";
		$this->ref_account->EditCustomAttributes = "";

		// debit
		$this->debit->EditAttrs["class"] = "form-control";
		$this->debit->EditCustomAttributes = "";
		$this->debit->EditValue = $this->debit->CurrentValue;
		$this->debit->PlaceHolder = RemoveHtml($this->debit->caption());
		if (strval($this->debit->EditValue) <> "" && is_numeric($this->debit->EditValue))
			$this->debit->EditValue = FormatNumber($this->debit->EditValue, -2, -2, -2, -2);

		// credit
		$this->credit->EditAttrs["class"] = "form-control";
		$this->credit->EditCustomAttributes = "";
		$this->credit->EditValue = $this->credit->CurrentValue;
		$this->credit->PlaceHolder = RemoveHtml($this->credit->caption());
		if (strval($this->credit->EditValue) <> "" && is_numeric($this->credit->EditValue))
			$this->credit->EditValue = FormatNumber($this->credit->EditValue, -2, -2, -2, -2);

		// balance
		$this->balance->EditAttrs["class"] = "form-control";
		$this->balance->EditCustomAttributes = "";
		$this->balance->EditValue = $this->balance->CurrentValue;
		$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
		if (strval($this->balance->EditValue) <> "" && is_numeric($this->balance->EditValue))
			$this->balance->EditValue = FormatNumber($this->balance->EditValue, -2, -2, -2, -2);

		// at
		$this->at->EditAttrs["class"] = "form-control";
		$this->at->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->at->CurrentValue = HtmlDecode($this->at->CurrentValue);
		$this->at->EditValue = $this->at->CurrentValue;
		$this->at->PlaceHolder = RemoveHtml($this->at->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->debit->CurrentValue))
				$this->debit->Total += $this->debit->CurrentValue; // Accumulate total
			if (is_numeric($this->credit->CurrentValue))
				$this->credit->Total += $this->credit->CurrentValue; // Accumulate total
			if (is_numeric($this->balance->CurrentValue))
				$this->balance->Total += $this->balance->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->debit->CurrentValue = $this->debit->Total;
			$this->debit->ViewValue = $this->debit->CurrentValue;
			$this->debit->ViewValue = FormatNumber($this->debit->ViewValue, 2, -2, -2, -2);
			$this->debit->ViewCustomAttributes = "";
			$this->debit->HrefValue = ""; // Clear href value
			$this->credit->CurrentValue = $this->credit->Total;
			$this->credit->ViewValue = $this->credit->CurrentValue;
			$this->credit->ViewValue = FormatNumber($this->credit->ViewValue, 2, -2, -2, -2);
			$this->credit->ViewCustomAttributes = "";
			$this->credit->HrefValue = ""; // Clear href value
			$this->balance->CurrentValue = $this->balance->Total;
			$this->balance->ViewValue = $this->balance->CurrentValue;
			$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
			$this->balance->ViewCustomAttributes = "";
			$this->balance->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->sub_category);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->debit);
					$doc->exportCaption($this->credit);
					$doc->exportCaption($this->balance);
				} else {
					$doc->exportCaption($this->sub_category);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->debit);
					$doc->exportCaption($this->credit);
					$doc->exportCaption($this->balance);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->grp);
						$doc->exportField($this->sub_category);
						$doc->exportField($this->name);
						$doc->exportField($this->debit);
						$doc->exportField($this->credit);
						$doc->exportField($this->balance);
					} else {
						$doc->exportField($this->sub_category);
						$doc->exportField($this->name);
						$doc->exportField($this->debit);
						$doc->exportField($this->credit);
						$doc->exportField($this->balance);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->sub_category, '');
				$doc->exportAggregate($this->name, '');
				$doc->exportAggregate($this->debit, 'TOTAL');
				$doc->exportAggregate($this->credit, 'TOTAL');
				$doc->exportAggregate($this->balance, 'TOTAL');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>