<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for batch_no
 */
class batch_no extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $packing_type;
	public $batch_no;
	public $description;
	public $bom;
	public $ted;
	public $payment;
	public $remarks;
	public $status;
	public $image;
	public $operator;
	public $datetime;
	public $a_operator;
	public $a_datetime;
	public $process_id_tmp;
	public $process;
	public $bom_app_id;
	public $bom_id;
	public $process_id;
	public $payment_id;
	public $bom_url;
	public $ted_url;
	public $payment_url;
	public $uid;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'batch_no';
		$this->TableName = 'batch_no';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`batch_no`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('batch_no', 'batch_no', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->IsForeignKey = TRUE; // Foreign key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// grp
		$this->grp = new DbField('batch_no', 'batch_no', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('batch_no', 'batch_no', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product","x_process_id_tmp[]","x_process_id"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('batch_no', 'batch_no', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', TRUE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('batch_no', 'batch_no', 'x_rid', 'rid', '`rid`', '`rid`', 200, -1, FALSE, '`EV__rid`', TRUE, TRUE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref', TRUE, 'id', ["product_code","","",""], ["x_product"], [], ["product"], ["x_product"], [], [], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// packing_type
		$this->packing_type = new DbField('batch_no', 'batch_no', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 2, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["code","packing","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// batch_no
		$this->batch_no = new DbField('batch_no', 'batch_no', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 200, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Nullable = FALSE; // NOT NULL field
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->fields['batch_no'] = &$this->batch_no;

		// description
		$this->description = new DbField('batch_no', 'batch_no', 'x_description', 'description', '`description`', '`description`', 200, -1, FALSE, '`description`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description->Sortable = TRUE; // Allow sort
		$this->fields['description'] = &$this->description;

		// bom
		$this->bom = new DbField('batch_no', 'batch_no', 'x_bom', 'bom', 'if (`bom_id` is null, \'Update BOM\', \'View BOM\')', 'if (`bom_id` is null, \'Update BOM\', \'View BOM\')', 200, -1, FALSE, 'if (`bom_id` is null, \'Update BOM\', \'View BOM\')', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bom->IsCustom = TRUE; // Custom field
		$this->bom->Sortable = TRUE; // Allow sort
		$this->fields['bom'] = &$this->bom;

		// ted
		$this->ted = new DbField('batch_no', 'batch_no', 'x_ted', 'ted', 'if (`process_id` is null, \'Update TD\', \'View TD\')', 'if (`process_id` is null, \'Update TD\', \'View TD\')', 200, -1, FALSE, 'if (`process_id` is null, \'Update TD\', \'View TD\')', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ted->IsCustom = TRUE; // Custom field
		$this->ted->Sortable = TRUE; // Allow sort
		$this->fields['ted'] = &$this->ted;

		// payment
		$this->payment = new DbField('batch_no', 'batch_no', 'x_payment', 'payment', 'if (`payment_id` is null, \'Update Payment\', \'View Payment\')', 'if (`payment_id` is null, \'Update Payment\', \'View Payment\')', 200, -1, FALSE, 'if (`payment_id` is null, \'Update Payment\', \'View Payment\')', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment->IsCustom = TRUE; // Custom field
		$this->payment->Sortable = TRUE; // Allow sort
		$this->fields['payment'] = &$this->payment;

		// remarks
		$this->remarks = new DbField('batch_no', 'batch_no', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// status
		$this->status = new DbField('batch_no', 'batch_no', 'x_status', 'status', '`status`', '`status`', 16, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'batch_no', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// image
		$this->image = new DbField('batch_no', 'batch_no', 'x_image', 'image', '`image`', '`image`', 200, -1, TRUE, '`image`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->image->Sortable = TRUE; // Allow sort
		$this->fields['image'] = &$this->image;

		// operator
		$this->operator = new DbField('batch_no', 'batch_no', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('batch_no', 'batch_no', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// a_operator
		$this->a_operator = new DbField('batch_no', 'batch_no', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 2, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Nullable = FALSE; // NOT NULL field
		$this->a_operator->Required = TRUE; // Required field
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` DESC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('batch_no', 'batch_no', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 0, "DB"), 135, 0, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Nullable = FALSE; // NOT NULL field
		$this->a_datetime->Required = TRUE; // Required field
		$this->a_datetime->Sortable = TRUE; // Allow sort
		$this->a_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['a_datetime'] = &$this->a_datetime;

		// process_id_tmp
		$this->process_id_tmp = new DbField('batch_no', 'batch_no', 'x_process_id_tmp', 'process_id_tmp', '`process`', '`process`', 200, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->process_id_tmp->IsCustom = TRUE; // Custom field
		$this->process_id_tmp->Sortable = TRUE; // Allow sort
		$this->process_id_tmp->Lookup = new Lookup('process_id_tmp', 'sub_process_type_view', TRUE, 'id', ["name","","",""], ["x_s_grp"], [], ["process"], ["x_process"], [], [], '`name` ASC', '');
		$this->fields['process_id_tmp'] = &$this->process_id_tmp;

		// process
		$this->process = new DbField('batch_no', 'batch_no', 'x_process', 'process', '`process`', '`process`', 200, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process->Sortable = FALSE; // Allow sort
		$this->fields['process'] = &$this->process;

		// bom_app_id
		$this->bom_app_id = new DbField('batch_no', 'batch_no', 'x_bom_app_id', 'bom_app_id', '`bom_app_id`', '`bom_app_id`', 18, -1, FALSE, '`bom_app_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bom_app_id->Nullable = FALSE; // NOT NULL field
		$this->bom_app_id->Required = TRUE; // Required field
		$this->bom_app_id->Sortable = FALSE; // Allow sort
		$this->bom_app_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['bom_app_id'] = &$this->bom_app_id;

		// bom_id
		$this->bom_id = new DbField('batch_no', 'batch_no', 'x_bom_id', 'bom_id', '`bom_id`', '`bom_id`', 201, -1, FALSE, '`bom_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bom_id->Sortable = FALSE; // Allow sort
		$this->fields['bom_id'] = &$this->bom_id;

		// process_id
		$this->process_id = new DbField('batch_no', 'batch_no', 'x_process_id', 'process_id', '`process_id`', '`process_id`', 201, -1, FALSE, '`process_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process_id->Sortable = FALSE; // Allow sort
		$this->process_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process_id->Lookup = new Lookup('process_id', 'sub_process_type', TRUE, 'id', ["name","","",""], ["x_s_grp"], [], ["s_grp"], ["x_s_grp[]"], [], [], '`name` ASC', '');
		$this->fields['process_id'] = &$this->process_id;

		// payment_id
		$this->payment_id = new DbField('batch_no', 'batch_no', 'x_payment_id', 'payment_id', '`payment_id`', '`payment_id`', 201, -1, FALSE, '`payment_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment_id->Sortable = FALSE; // Allow sort
		$this->fields['payment_id'] = &$this->payment_id;

		// bom_url
		$this->bom_url = new DbField('batch_no', 'batch_no', 'x_bom_url', 'bom_url', 'if (`bom_id` is null, concat(\'bomlist.php?action=gridadd&GRP=\',`grp`, \'&SGRP=\', `s_grp`, \'&PROD=\', `product`, \'&RID=\', `rid`, \'&BN=\', `id`, \'&PT=\', `packing_type`), concat(\'bomlist.php?&x_batch_no=\', `id`))', 'if (`bom_id` is null, concat(\'bomlist.php?action=gridadd&GRP=\',`grp`, \'&SGRP=\', `s_grp`, \'&PROD=\', `product`, \'&RID=\', `rid`, \'&BN=\', `id`, \'&PT=\', `packing_type`), concat(\'bomlist.php?&x_batch_no=\', `id`))', 200, -1, FALSE, 'if (`bom_id` is null, concat(\'bomlist.php?action=gridadd&GRP=\',`grp`, \'&SGRP=\', `s_grp`, \'&PROD=\', `product`, \'&RID=\', `rid`, \'&BN=\', `id`, \'&PT=\', `packing_type`), concat(\'bomlist.php?&x_batch_no=\', `id`))', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bom_url->IsCustom = TRUE; // Custom field
		$this->bom_url->Sortable = FALSE; // Allow sort
		$this->fields['bom_url'] = &$this->bom_url;

		// ted_url
		$this->ted_url = new DbField('batch_no', 'batch_no', 'x_ted_url', 'ted_url', 'if (`process_id` is null, concat(\'production_processadd.php?GRP=\',`grp`, \'&SGRP=\', `s_grp`, \'&PROD=\', `product`, \'&RID=\', `rid`, \'&BN=\', `id`,\'&seq=\', ifnull(`process`,0)), concat(\'production_processlist.php?x_grp=\', `grp` , \'&x_s_grp=\', `s_grp`, \'&x_product=\', `product`, \'&x_batch_no=\', `id`))', 'if (`process_id` is null, concat(\'production_processadd.php?GRP=\',`grp`, \'&SGRP=\', `s_grp`, \'&PROD=\', `product`, \'&RID=\', `rid`, \'&BN=\', `id`,\'&seq=\', ifnull(`process`,0)), concat(\'production_processlist.php?x_grp=\', `grp` , \'&x_s_grp=\', `s_grp`, \'&x_product=\', `product`, \'&x_batch_no=\', `id`))', 201, -1, FALSE, 'if (`process_id` is null, concat(\'production_processadd.php?GRP=\',`grp`, \'&SGRP=\', `s_grp`, \'&PROD=\', `product`, \'&RID=\', `rid`, \'&BN=\', `id`,\'&seq=\', ifnull(`process`,0)), concat(\'production_processlist.php?x_grp=\', `grp` , \'&x_s_grp=\', `s_grp`, \'&x_product=\', `product`, \'&x_batch_no=\', `id`))', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->ted_url->IsCustom = TRUE; // Custom field
		$this->ted_url->Sortable = FALSE; // Allow sort
		$this->fields['ted_url'] = &$this->ted_url;

		// payment_url
		$this->payment_url = new DbField('batch_no', 'batch_no', 'x_payment_url', 'payment_url', 'if (`payment_id` is null, concat(\'payment_planadd.php?GRP=\', `grp`, \'&SGRP=\', `s_grp`, \'&RID=\',`rid`, \'&GC=\', (SELECT gcode FROM `ref` WHERE `id` = `rid`)), concat(\'payment_planlist.php?x_gcode=\',(SELECT gcode FROM `ref` WHERE `id` = `rid`)))', 'if (`payment_id` is null, concat(\'payment_planadd.php?GRP=\', `grp`, \'&SGRP=\', `s_grp`, \'&RID=\',`rid`, \'&GC=\', (SELECT gcode FROM `ref` WHERE `id` = `rid`)), concat(\'payment_planlist.php?x_gcode=\',(SELECT gcode FROM `ref` WHERE `id` = `rid`)))', 200, -1, FALSE, 'if (`payment_id` is null, concat(\'payment_planadd.php?GRP=\', `grp`, \'&SGRP=\', `s_grp`, \'&RID=\',`rid`, \'&GC=\', (SELECT gcode FROM `ref` WHERE `id` = `rid`)), concat(\'payment_planlist.php?x_gcode=\',(SELECT gcode FROM `ref` WHERE `id` = `rid`)))', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment_url->IsCustom = TRUE; // Custom field
		$this->payment_url->Sortable = FALSE; // Allow sort
		$this->fields['payment_url'] = &$this->payment_url;

		// uid
		$this->uid = new DbField('batch_no', 'batch_no', 'x_uid', 'uid', '`uid`', '`uid`', 200, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->uid->Nullable = FALSE; // NOT NULL field
		$this->uid->Required = TRUE; // Required field
		$this->uid->Sortable = FALSE; // Allow sort
		$this->fields['uid'] = &$this->uid;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "bom") {
			$detailUrl = $GLOBALS["bom"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "production_process") {
			$detailUrl = $GLOBALS["production_process"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "batch_nolist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`batch_no`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, if (`bom_id` is null, 'Update BOM', 'View BOM') AS `bom`, if (`process_id` is null, 'Update TD', 'View TD') AS `ted`, if (`payment_id` is null, 'Update Payment', 'View Payment') AS `payment`, `process` AS `process_id_tmp`, if (`bom_id` is null, concat('bomlist.php?action=gridadd&GRP=',`grp`, '&SGRP=', `s_grp`, '&PROD=', `product`, '&RID=', `rid`, '&BN=', `id`, '&PT=', `packing_type`), concat('bomlist.php?&x_batch_no=', `id`)) AS `bom_url`, if (`process_id` is null, concat('production_processadd.php?GRP=',`grp`, '&SGRP=', `s_grp`, '&PROD=', `product`, '&RID=', `rid`, '&BN=', `id`,'&seq=', ifnull(`process`,0)), concat('production_processlist.php?x_grp=', `grp` , '&x_s_grp=', `s_grp`, '&x_product=', `product`, '&x_batch_no=', `id`)) AS `ted_url`, if (`payment_id` is null, concat('payment_planadd.php?GRP=', `grp`, '&SGRP=', `s_grp`, '&RID=',`rid`, '&GC=', (SELECT gcode FROM `ref` WHERE `id` = `rid`)), concat('payment_planlist.php?x_gcode=',(SELECT gcode FROM `ref` WHERE `id` = `rid`))) AS `payment_url` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, if (`bom_id` is null, 'Update BOM', 'View BOM') AS `bom`, if (`process_id` is null, 'Update TD', 'View TD') AS `ted`, if (`payment_id` is null, 'Update Payment', 'View Payment') AS `payment`, `process` AS `process_id_tmp`, if (`bom_id` is null, concat('bomlist.php?action=gridadd&GRP=',`grp`, '&SGRP=', `s_grp`, '&PROD=', `product`, '&RID=', `rid`, '&BN=', `id`, '&PT=', `packing_type`), concat('bomlist.php?&x_batch_no=', `id`)) AS `bom_url`, if (`process_id` is null, concat('production_processadd.php?GRP=',`grp`, '&SGRP=', `s_grp`, '&PROD=', `product`, '&RID=', `rid`, '&BN=', `id`,'&seq=', ifnull(`process`,0)), concat('production_processlist.php?x_grp=', `grp` , '&x_s_grp=', `s_grp`, '&x_product=', `product`, '&x_batch_no=', `id`)) AS `ted_url`, if (`payment_id` is null, concat('payment_planadd.php?GRP=', `grp`, '&SGRP=', `s_grp`, '&RID=',`rid`, '&GC=', (SELECT gcode FROM `ref` WHERE `id` = `rid`)), concat('payment_planlist.php?x_gcode=',(SELECT gcode FROM `ref` WHERE `id` = `rid`))) AS `payment_url`, (SELECT DISTINCT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `batch_no`.`rid` LIMIT 1) AS `EV__rid` FROM `batch_no`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->description->DbValue = $row['description'];
		$this->bom->DbValue = $row['bom'];
		$this->ted->DbValue = $row['ted'];
		$this->payment->DbValue = $row['payment'];
		$this->remarks->DbValue = $row['remarks'];
		$this->status->DbValue = $row['status'];
		$this->image->Upload->DbValue = $row['image'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->process_id_tmp->DbValue = $row['process_id_tmp'];
		$this->process->DbValue = $row['process'];
		$this->bom_app_id->DbValue = $row['bom_app_id'];
		$this->bom_id->DbValue = $row['bom_id'];
		$this->process_id->DbValue = $row['process_id'];
		$this->payment_id->DbValue = $row['payment_id'];
		$this->bom_url->DbValue = $row['bom_url'];
		$this->ted_url->DbValue = $row['ted_url'];
		$this->payment_url->DbValue = $row['payment_url'];
		$this->uid->DbValue = $row['uid'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$oldFiles = EmptyValue($row['image']) ? [] : [$row['image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "batch_nolist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "batch_noview.php")
			return $Language->phrase("View");
		elseif ($pageName == "batch_noedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "batch_noadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "batch_nolist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("batch_noview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("batch_noview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "batch_noadd.php?" . $this->getUrlParm($parm);
		else
			$url = "batch_noadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("batch_noedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("batch_noedit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("batch_noadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("batch_noadd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("batch_nodelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->description->setDbValue($rs->fields('description'));
		$this->bom->setDbValue($rs->fields('bom'));
		$this->ted->setDbValue($rs->fields('ted'));
		$this->payment->setDbValue($rs->fields('payment'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->status->setDbValue($rs->fields('status'));
		$this->image->Upload->DbValue = $rs->fields('image');
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->process_id_tmp->setDbValue($rs->fields('process_id_tmp'));
		$this->process->setDbValue($rs->fields('process'));
		$this->bom_app_id->setDbValue($rs->fields('bom_app_id'));
		$this->bom_id->setDbValue($rs->fields('bom_id'));
		$this->process_id->setDbValue($rs->fields('process_id'));
		$this->payment_id->setDbValue($rs->fields('payment_id'));
		$this->bom_url->setDbValue($rs->fields('bom_url'));
		$this->ted_url->setDbValue($rs->fields('ted_url'));
		$this->payment_url->setDbValue($rs->fields('payment_url'));
		$this->uid->setDbValue($rs->fields('uid'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// grp
		// s_grp
		// product
		// rid
		// packing_type
		// batch_no
		// description
		// bom

		$this->bom->CellCssStyle = "white-space: nowrap;";

		// ted
		$this->ted->CellCssStyle = "white-space: nowrap;";

		// payment
		// remarks
		// status
		// image
		// operator

		$this->operator->CellCssStyle = "white-space: nowrap;";

		// datetime
		$this->datetime->CellCssStyle = "white-space: nowrap;";

		// a_operator
		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// a_datetime
		$this->a_datetime->CellCssStyle = "white-space: nowrap;";

		// process_id_tmp
		// process

		$this->process->CellCssStyle = "white-space: nowrap;";

		// bom_app_id
		$this->bom_app_id->CellCssStyle = "white-space: nowrap;";

		// bom_id
		$this->bom_id->CellCssStyle = "white-space: nowrap;";

		// process_id
		$this->process_id->CellCssStyle = "white-space: nowrap;";

		// payment_id
		$this->payment_id->CellCssStyle = "white-space: nowrap;";

		// bom_url
		$this->bom_url->CellCssStyle = "white-space: nowrap;";

		// ted_url
		$this->ted_url->CellCssStyle = "white-space: nowrap;";

		// payment_url
		$this->payment_url->CellCssStyle = "white-space: nowrap;";

		// uid
		$this->uid->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `product_type` != 9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewCustomAttributes = "";

		// description
		$this->description->ViewValue = $this->description->CurrentValue;
		$this->description->ViewCustomAttributes = "";

		// bom
		$this->bom->ViewValue = $this->bom->CurrentValue;
		$this->bom->CssClass = "font-weight-bold";
		$this->bom->ViewCustomAttributes = 'class = "btn btn-default"';

		// ted
		$this->ted->ViewValue = $this->ted->CurrentValue;
		$this->ted->CssClass = "font-weight-bold";
		$this->ted->ViewCustomAttributes = 'class = "btn btn-default"';

		// payment
		$this->payment->ViewValue = $this->payment->CurrentValue;
		$this->payment->CssClass = "font-weight-bold";
		$this->payment->ViewCustomAttributes = 'class="btn btn-default"';

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// image
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 100;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->ViewValue = $this->image->Upload->DbValue;
		} else {
			$this->image->ViewValue = "";
		}
		$this->image->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
		$this->a_datetime->ViewCustomAttributes = "";

		// process_id_tmp
		$curVal = strval($this->process_id_tmp->CurrentValue);
		if ($curVal <> "") {
			$this->process_id_tmp->ViewValue = $this->process_id_tmp->lookupCacheOption($curVal);
			if ($this->process_id_tmp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_id_tmp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_id_tmp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_id_tmp->ViewValue->add($this->process_id_tmp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process_id_tmp->ViewValue = $this->process_id_tmp->CurrentValue;
				}
			}
		} else {
			$this->process_id_tmp->ViewValue = NULL;
		}
		$this->process_id_tmp->ViewCustomAttributes = "";

		// process
		$this->process->ViewValue = $this->process->CurrentValue;
		$this->process->ViewCustomAttributes = "";

		// bom_app_id
		$this->bom_app_id->ViewValue = $this->bom_app_id->CurrentValue;
		$this->bom_app_id->ViewValue = FormatNumber($this->bom_app_id->ViewValue, 0, -2, -2, -2);
		$this->bom_app_id->ViewCustomAttributes = "";

		// bom_id
		$this->bom_id->ViewValue = $this->bom_id->CurrentValue;
		$this->bom_id->ViewCustomAttributes = "";

		// process_id
		$curVal = strval($this->process_id->CurrentValue);
		if ($curVal <> "") {
			$this->process_id->ViewValue = $this->process_id->lookupCacheOption($curVal);
			if ($this->process_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->process_id->ViewValue = $this->process_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->process_id->ViewValue = $this->process_id->CurrentValue;
				}
			}
		} else {
			$this->process_id->ViewValue = NULL;
		}
		$this->process_id->ViewCustomAttributes = "";

		// payment_id
		$this->payment_id->ViewValue = $this->payment_id->CurrentValue;
		$this->payment_id->ViewCustomAttributes = "";

		// bom_url
		$this->bom_url->ViewValue = $this->bom_url->CurrentValue;
		$this->bom_url->ViewCustomAttributes = "";

		// ted_url
		$this->ted_url->ViewValue = $this->ted_url->CurrentValue;
		$this->ted_url->ViewCustomAttributes = "";

		// payment_url
		$this->payment_url->ViewValue = $this->payment_url->CurrentValue;
		$this->payment_url->ViewCustomAttributes = "";

		// uid
		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "batch_nolist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "batch_nolist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// description
		$this->description->LinkCustomAttributes = "";
		$this->description->HrefValue = "";
		$this->description->TooltipValue = "";

		// bom
		$this->bom->LinkCustomAttributes = "";
		if (!EmptyValue($this->bom_url->CurrentValue)) {
			$this->bom->HrefValue = $this->bom_url->CurrentValue; // Add prefix/suffix
			$this->bom->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->bom->HrefValue = FullUrl($this->bom->HrefValue, "href");
		} else {
			$this->bom->HrefValue = "";
		}
		$this->bom->TooltipValue = "";

		// ted
		$this->ted->LinkCustomAttributes = "";
		if (!EmptyValue($this->ted_url->CurrentValue)) {
			$this->ted->HrefValue = $this->ted_url->CurrentValue; // Add prefix/suffix
			$this->ted->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->ted->HrefValue = FullUrl($this->ted->HrefValue, "href");
		} else {
			$this->ted->HrefValue = "";
		}
		$this->ted->TooltipValue = "";

		// payment
		$this->payment->LinkCustomAttributes = "";
		if (!EmptyValue($this->payment_url->CurrentValue)) {
			$this->payment->HrefValue = $this->payment_url->CurrentValue; // Add prefix/suffix
			$this->payment->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->payment->HrefValue = FullUrl($this->payment->HrefValue, "href");
		} else {
			$this->payment->HrefValue = "";
		}
		$this->payment->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// image
		$this->image->LinkCustomAttributes = "";
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
			$this->image->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
		} else {
			$this->image->HrefValue = "";
		}
		$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		$this->image->TooltipValue = "";
		if ($this->image->UseColorbox) {
			if (EmptyValue($this->image->TooltipValue))
				$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->image->LinkAttrs["data-rel"] = "batch_no_x_image";
			AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
		}

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// process_id_tmp
		$this->process_id_tmp->LinkCustomAttributes = "";
		$this->process_id_tmp->HrefValue = "";
		$this->process_id_tmp->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// bom_app_id
		$this->bom_app_id->LinkCustomAttributes = "";
		$this->bom_app_id->HrefValue = "";
		$this->bom_app_id->TooltipValue = "";

		// bom_id
		$this->bom_id->LinkCustomAttributes = "";
		$this->bom_id->HrefValue = "";
		$this->bom_id->TooltipValue = "";

		// process_id
		$this->process_id->LinkCustomAttributes = "";
		$this->process_id->HrefValue = "";
		$this->process_id->TooltipValue = "";

		// payment_id
		$this->payment_id->LinkCustomAttributes = "";
		$this->payment_id->HrefValue = "";
		$this->payment_id->TooltipValue = "";

		// bom_url
		$this->bom_url->LinkCustomAttributes = "";
		$this->bom_url->HrefValue = "";
		$this->bom_url->TooltipValue = "";

		// ted_url
		$this->ted_url->LinkCustomAttributes = "";
		$this->ted_url->HrefValue = "";
		$this->ted_url->TooltipValue = "";

		// payment_url
		$this->payment_url->LinkCustomAttributes = "";
		$this->payment_url->HrefValue = "";
		$this->payment_url->TooltipValue = "";

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = 'ReadOnly';

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// rid
		$this->rid->EditCustomAttributes = "";

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->batch_no->CurrentValue = HtmlDecode($this->batch_no->CurrentValue);
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// description
		$this->description->EditAttrs["class"] = "form-control";
		$this->description->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
		$this->description->EditValue = $this->description->CurrentValue;
		$this->description->PlaceHolder = RemoveHtml($this->description->caption());

		// bom
		$this->bom->EditAttrs["class"] = "form-control";
		$this->bom->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bom->CurrentValue = HtmlDecode($this->bom->CurrentValue);
		$this->bom->EditValue = $this->bom->CurrentValue;
		$this->bom->PlaceHolder = RemoveHtml($this->bom->caption());

		// ted
		$this->ted->EditAttrs["class"] = "form-control";
		$this->ted->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ted->CurrentValue = HtmlDecode($this->ted->CurrentValue);
		$this->ted->EditValue = $this->ted->CurrentValue;
		$this->ted->PlaceHolder = RemoveHtml($this->ted->caption());

		// payment
		$this->payment->EditAttrs["class"] = "form-control";
		$this->payment->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment->CurrentValue = HtmlDecode($this->payment->CurrentValue);
		$this->payment->EditValue = $this->payment->CurrentValue;
		$this->payment->PlaceHolder = RemoveHtml($this->payment->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 100;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->EditValue = $this->image->Upload->DbValue;
		} else {
			$this->image->EditValue = "";
		}
		if (!EmptyValue($this->image->CurrentValue))
				$this->image->Upload->FileName = $this->image->CurrentValue;

		// operator
		// datetime
		// a_operator

		$this->a_operator->EditAttrs["class"] = "form-control";
		$this->a_operator->EditCustomAttributes = "";

		// a_datetime
		$this->a_datetime->EditAttrs["class"] = "form-control";
		$this->a_datetime->EditCustomAttributes = "";
		$this->a_datetime->EditValue = FormatDateTime($this->a_datetime->CurrentValue, 8);
		$this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());

		// process_id_tmp
		$this->process_id_tmp->EditCustomAttributes = "";

		// process
		$this->process->EditAttrs["class"] = "form-control";
		$this->process->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->process->CurrentValue = HtmlDecode($this->process->CurrentValue);
		$this->process->EditValue = $this->process->CurrentValue;
		$this->process->PlaceHolder = RemoveHtml($this->process->caption());

		// bom_app_id
		$this->bom_app_id->EditAttrs["class"] = "form-control";
		$this->bom_app_id->EditCustomAttributes = "";
		$this->bom_app_id->EditValue = $this->bom_app_id->CurrentValue;
		$this->bom_app_id->PlaceHolder = RemoveHtml($this->bom_app_id->caption());

		// bom_id
		$this->bom_id->EditAttrs["class"] = "form-control";
		$this->bom_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bom_id->CurrentValue = HtmlDecode($this->bom_id->CurrentValue);
		$this->bom_id->EditValue = $this->bom_id->CurrentValue;
		$this->bom_id->PlaceHolder = RemoveHtml($this->bom_id->caption());

		// process_id
		$this->process_id->EditAttrs["class"] = "form-control";
		$this->process_id->EditCustomAttributes = "";

		// payment_id
		$this->payment_id->EditAttrs["class"] = "form-control";
		$this->payment_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment_id->CurrentValue = HtmlDecode($this->payment_id->CurrentValue);
		$this->payment_id->EditValue = $this->payment_id->CurrentValue;
		$this->payment_id->PlaceHolder = RemoveHtml($this->payment_id->caption());

		// bom_url
		$this->bom_url->EditAttrs["class"] = "form-control";
		$this->bom_url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->bom_url->CurrentValue = HtmlDecode($this->bom_url->CurrentValue);
		$this->bom_url->EditValue = $this->bom_url->CurrentValue;
		$this->bom_url->PlaceHolder = RemoveHtml($this->bom_url->caption());

		// ted_url
		$this->ted_url->EditAttrs["class"] = "form-control";
		$this->ted_url->EditCustomAttributes = "";
		$this->ted_url->EditValue = $this->ted_url->CurrentValue;
		$this->ted_url->PlaceHolder = RemoveHtml($this->ted_url->caption());

		// payment_url
		$this->payment_url->EditAttrs["class"] = "form-control";
		$this->payment_url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment_url->CurrentValue = HtmlDecode($this->payment_url->CurrentValue);
		$this->payment_url->EditValue = $this->payment_url->CurrentValue;
		$this->payment_url->PlaceHolder = RemoveHtml($this->payment_url->caption());

		// uid
		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->description);
					$doc->exportCaption($this->bom);
					$doc->exportCaption($this->ted);
					$doc->exportCaption($this->payment);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->process_id_tmp);
					$doc->exportCaption($this->bom_url);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->description);
					$doc->exportCaption($this->bom);
					$doc->exportCaption($this->ted);
					$doc->exportCaption($this->payment);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
					$doc->exportCaption($this->process_id_tmp);
					$doc->exportCaption($this->bom_url);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->description);
						$doc->exportField($this->bom);
						$doc->exportField($this->ted);
						$doc->exportField($this->payment);
						$doc->exportField($this->remarks);
						$doc->exportField($this->status);
						$doc->exportField($this->image);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->process_id_tmp);
						$doc->exportField($this->bom_url);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->description);
						$doc->exportField($this->bom);
						$doc->exportField($this->ted);
						$doc->exportField($this->payment);
						$doc->exportField($this->remarks);
						$doc->exportField($this->status);
						$doc->exportField($this->image);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
						$doc->exportField($this->process_id_tmp);
						$doc->exportField($this->bom_url);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'image') {
			$fldName = "image";
			$fileNameFld = "image";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'batch_no';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'batch_no';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'batch_no';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'batch_no';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>