<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class batch_no_edit extends batch_no
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'batch_no';

	// Page object name
	public $PageObjName = "batch_no_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (batch_no)
		if (!isset($GLOBALS["batch_no"]) || get_class($GLOBALS["batch_no"]) == PROJECT_NAMESPACE . "batch_no") {
			$GLOBALS["batch_no"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["batch_no"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'batch_no');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $batch_no;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($batch_no);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "batch_noview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("batch_nolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->packing_type->setVisibility();
		$this->batch_no->setVisibility();
		$this->description->setVisibility();
		$this->bom->Visible = FALSE;
		$this->ted->Visible = FALSE;
		$this->payment->Visible = FALSE;
		$this->remarks->setVisibility();
		$this->status->setVisibility();
		$this->image->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->process_id_tmp->setVisibility();
		$this->process->setVisibility();
		$this->bom_app_id->Visible = FALSE;
		$this->bom_id->Visible = FALSE;
		$this->process_id->Visible = FALSE;
		$this->payment_id->Visible = FALSE;
		$this->bom_url->setVisibility();
		$this->ted_url->Visible = FALSE;
		$this->payment_url->Visible = FALSE;
		$this->uid->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->process_id_tmp);
		$this->setupLookupOptions($this->process_id);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("batch_nolist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() <> "") // Master/detail edit
					$returnUrl = $this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "batch_nolist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->image->Upload->Index = $CurrentForm->Index;
		$this->image->Upload->uploadFile();
		$this->image->CurrentValue = $this->image->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'description' first before field var 'x_description'
		$val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
		if (!$this->description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description->Visible = FALSE; // Disable update for API request
			else
				$this->description->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'process_id_tmp' first before field var 'x_process_id_tmp'
		$val = $CurrentForm->hasValue("process_id_tmp") ? $CurrentForm->getValue("process_id_tmp") : $CurrentForm->getValue("x_process_id_tmp");
		if (!$this->process_id_tmp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process_id_tmp->Visible = FALSE; // Disable update for API request
			else
				$this->process_id_tmp->setFormValue($val);
		}

		// Check field name 'process' first before field var 'x_process'
		$val = $CurrentForm->hasValue("process") ? $CurrentForm->getValue("process") : $CurrentForm->getValue("x_process");
		if (!$this->process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->process->Visible = FALSE; // Disable update for API request
			else
				$this->process->setFormValue($val);
		}

		// Check field name 'bom_url' first before field var 'x_bom_url'
		$val = $CurrentForm->hasValue("bom_url") ? $CurrentForm->getValue("bom_url") : $CurrentForm->getValue("x_bom_url");
		if (!$this->bom_url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bom_url->Visible = FALSE; // Disable update for API request
			else
				$this->bom_url->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->process_id_tmp->CurrentValue = $this->process_id_tmp->FormValue;
		$this->process->CurrentValue = $this->process->FormValue;
		$this->bom_url->CurrentValue = $this->bom_url->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->packing_type->setDbValue($row['packing_type']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->description->setDbValue($row['description']);
		$this->bom->setDbValue($row['bom']);
		$this->ted->setDbValue($row['ted']);
		$this->payment->setDbValue($row['payment']);
		$this->remarks->setDbValue($row['remarks']);
		$this->status->setDbValue($row['status']);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->process_id_tmp->setDbValue($row['process_id_tmp']);
		$this->process->setDbValue($row['process']);
		$this->bom_app_id->setDbValue($row['bom_app_id']);
		$this->bom_id->setDbValue($row['bom_id']);
		$this->process_id->setDbValue($row['process_id']);
		$this->payment_id->setDbValue($row['payment_id']);
		$this->bom_url->setDbValue($row['bom_url']);
		$this->ted_url->setDbValue($row['ted_url']);
		$this->payment_url->setDbValue($row['payment_url']);
		$this->uid->setDbValue($row['uid']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['packing_type'] = NULL;
		$row['batch_no'] = NULL;
		$row['description'] = NULL;
		$row['bom'] = NULL;
		$row['ted'] = NULL;
		$row['payment'] = NULL;
		$row['remarks'] = NULL;
		$row['status'] = NULL;
		$row['image'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['process_id_tmp'] = NULL;
		$row['process'] = NULL;
		$row['bom_app_id'] = NULL;
		$row['bom_id'] = NULL;
		$row['process_id'] = NULL;
		$row['payment_id'] = NULL;
		$row['bom_url'] = NULL;
		$row['ted_url'] = NULL;
		$row['payment_url'] = NULL;
		$row['uid'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// s_grp
		// product
		// rid
		// packing_type
		// batch_no
		// description
		// bom
		// ted
		// payment
		// remarks
		// status
		// image
		// operator
		// datetime
		// a_operator
		// a_datetime
		// process_id_tmp
		// process
		// bom_app_id
		// bom_id
		// process_id
		// payment_id
		// bom_url
		// ted_url
		// payment_url
		// uid

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `product_type` != 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// bom
			$this->bom->ViewValue = $this->bom->CurrentValue;
			$this->bom->CssClass = "font-weight-bold";
			$this->bom->ViewCustomAttributes = 'class = "btn btn-default"';

			// ted
			$this->ted->ViewValue = $this->ted->CurrentValue;
			$this->ted->CssClass = "font-weight-bold";
			$this->ted->ViewCustomAttributes = 'class = "btn btn-default"';

			// payment
			$this->payment->ViewValue = $this->payment->CurrentValue;
			$this->payment->CssClass = "font-weight-bold";
			$this->payment->ViewCustomAttributes = 'class="btn btn-default"';

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// image
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 100;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
			$this->a_datetime->ViewCustomAttributes = "";

			// process_id_tmp
			$curVal = strval($this->process_id_tmp->CurrentValue);
			if ($curVal <> "") {
				$this->process_id_tmp->ViewValue = $this->process_id_tmp->lookupCacheOption($curVal);
				if ($this->process_id_tmp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_id_tmp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_id_tmp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_id_tmp->ViewValue->add($this->process_id_tmp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_id_tmp->ViewValue = $this->process_id_tmp->CurrentValue;
					}
				}
			} else {
				$this->process_id_tmp->ViewValue = NULL;
			}
			$this->process_id_tmp->ViewCustomAttributes = "";

			// process
			$this->process->ViewValue = $this->process->CurrentValue;
			$this->process->ViewCustomAttributes = "";

			// bom_url
			$this->bom_url->ViewValue = $this->bom_url->CurrentValue;
			$this->bom_url->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "batch_nolist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "batch_nolist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "batch_no_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// process_id_tmp
			$this->process_id_tmp->LinkCustomAttributes = "";
			$this->process_id_tmp->HrefValue = "";
			$this->process_id_tmp->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// bom_url
			$this->bom_url->LinkCustomAttributes = "";
			$this->bom_url->HrefValue = "";
			$this->bom_url->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = 'ReadOnly';
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid->CurrentValue));
			if ($curVal <> "")
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			else
				$this->rid->ViewValue = $this->rid->Lookup !== NULL && is_array($this->rid->Lookup->Options) ? $curVal : NULL;
			if ($this->rid->ViewValue !== NULL) { // Load from cache
				$this->rid->EditValue = array_values($this->rid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `product_type` != 9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->rid->EditValue = $arwrk;
			}

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->batch_no->CurrentValue = HtmlDecode($this->batch_no->CurrentValue);
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
			$this->description->EditValue = HtmlEncode($this->description->CurrentValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 100;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->EditValue = $this->image->Upload->DbValue;
			} else {
				$this->image->EditValue = "";
			}
			if (!EmptyValue($this->image->CurrentValue))
					$this->image->Upload->FileName = $this->image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->image);

			// operator
			// datetime
			// process_id_tmp

			$this->process_id_tmp->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_id_tmp->CurrentValue));
			if ($curVal <> "")
				$this->process_id_tmp->ViewValue = $this->process_id_tmp->lookupCacheOption($curVal);
			else
				$this->process_id_tmp->ViewValue = $this->process_id_tmp->Lookup !== NULL && is_array($this->process_id_tmp->Lookup->Options) ? $curVal : NULL;
			if ($this->process_id_tmp->ViewValue !== NULL) { // Load from cache
				$this->process_id_tmp->EditValue = array_values($this->process_id_tmp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_id_tmp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_id_tmp->EditValue = $arwrk;
			}

			// process
			$this->process->EditAttrs["class"] = "form-control";
			$this->process->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->process->CurrentValue = HtmlDecode($this->process->CurrentValue);
			$this->process->EditValue = HtmlEncode($this->process->CurrentValue);
			$this->process->PlaceHolder = RemoveHtml($this->process->caption());

			// bom_url
			$this->bom_url->EditAttrs["class"] = "form-control";
			$this->bom_url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->bom_url->CurrentValue = HtmlDecode($this->bom_url->CurrentValue);
			$this->bom_url->EditValue = HtmlEncode($this->bom_url->CurrentValue);
			$this->bom_url->PlaceHolder = RemoveHtml($this->bom_url->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "batch_nolist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "batch_nolist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// image
			$this->image->LinkCustomAttributes = "";
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// process_id_tmp
			$this->process_id_tmp->LinkCustomAttributes = "";
			$this->process_id_tmp->HrefValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";

			// bom_url
			$this->bom_url->LinkCustomAttributes = "";
			$this->bom_url->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if ($this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->description->Required) {
			if (!$this->description->IsDetailKey && $this->description->FormValue != NULL && $this->description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
			}
		}
		if ($this->bom->Required) {
			if (!$this->bom->IsDetailKey && $this->bom->FormValue != NULL && $this->bom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom->caption(), $this->bom->RequiredErrorMessage));
			}
		}
		if ($this->ted->Required) {
			if (!$this->ted->IsDetailKey && $this->ted->FormValue != NULL && $this->ted->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ted->caption(), $this->ted->RequiredErrorMessage));
			}
		}
		if ($this->payment->Required) {
			if (!$this->payment->IsDetailKey && $this->payment->FormValue != NULL && $this->payment->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment->caption(), $this->payment->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->process_id_tmp->Required) {
			if ($this->process_id_tmp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_id_tmp->caption(), $this->process_id_tmp->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if (!$this->process->IsDetailKey && $this->process->FormValue != NULL && $this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->bom_app_id->Required) {
			if (!$this->bom_app_id->IsDetailKey && $this->bom_app_id->FormValue != NULL && $this->bom_app_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom_app_id->caption(), $this->bom_app_id->RequiredErrorMessage));
			}
		}
		if ($this->bom_id->Required) {
			if (!$this->bom_id->IsDetailKey && $this->bom_id->FormValue != NULL && $this->bom_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom_id->caption(), $this->bom_id->RequiredErrorMessage));
			}
		}
		if ($this->process_id->Required) {
			if (!$this->process_id->IsDetailKey && $this->process_id->FormValue != NULL && $this->process_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_id->caption(), $this->process_id->RequiredErrorMessage));
			}
		}
		if ($this->payment_id->Required) {
			if (!$this->payment_id->IsDetailKey && $this->payment_id->FormValue != NULL && $this->payment_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_id->caption(), $this->payment_id->RequiredErrorMessage));
			}
		}
		if ($this->bom_url->Required) {
			if (!$this->bom_url->IsDetailKey && $this->bom_url->FormValue != NULL && $this->bom_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom_url->caption(), $this->bom_url->RequiredErrorMessage));
			}
		}
		if ($this->ted_url->Required) {
			if (!$this->ted_url->IsDetailKey && $this->ted_url->FormValue != NULL && $this->ted_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ted_url->caption(), $this->ted_url->RequiredErrorMessage));
			}
		}
		if ($this->payment_url->Required) {
			if (!$this->payment_url->IsDetailKey && $this->payment_url->FormValue != NULL && $this->payment_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_url->caption(), $this->payment_url->RequiredErrorMessage));
			}
		}
		if ($this->uid->Required) {
			if (!$this->uid->IsDetailKey && $this->uid->FormValue != NULL && $this->uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("bom", $detailTblVar) && $GLOBALS["bom"]->DetailEdit) {
			if (!isset($GLOBALS["bom_grid"]))
				$GLOBALS["bom_grid"] = new bom_grid(); // Get detail page object
			$GLOBALS["bom_grid"]->validateGridForm();
		}
		if (in_array("production_process", $detailTblVar) && $GLOBALS["production_process"]->DetailEdit) {
			if (!isset($GLOBALS["production_process_grid"]))
				$GLOBALS["production_process_grid"] = new production_process_grid(); // Get detail page object
			$GLOBALS["production_process_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->batch_no->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`batch_no` = '" . AdjustSql($this->batch_no->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->batch_no->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->batch_no->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() <> "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// grp
			$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, $this->grp->ReadOnly);

			// s_grp
			$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, $this->s_grp->ReadOnly);

			// product
			$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, 0, $this->product->ReadOnly);

			// rid
			$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, "", $this->rid->ReadOnly);

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, 0, $this->packing_type->ReadOnly);

			// batch_no
			$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, "", $this->batch_no->ReadOnly);

			// description
			$this->description->setDbValueDef($rsnew, $this->description->CurrentValue, NULL, $this->description->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, $this->status->ReadOnly);

			// image
			if ($this->image->Visible && !$this->image->ReadOnly && !$this->image->Upload->KeepFile) {
				$this->image->Upload->DbValue = $rsold['image']; // Get original value
				if ($this->image->Upload->FileName == "") {
					$rsnew['image'] = NULL;
				} else {
					$rsnew['image'] = $this->image->Upload->FileName;
				}
				$this->image->ImageWidth = 640; // Resize width
				$this->image->ImageHeight = 640; // Resize height
			}

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// process_id_tmp
			$this->process_id_tmp->setDbValueDef($rsnew, $this->process_id_tmp->CurrentValue, NULL, $this->process_id_tmp->ReadOnly);

			// process
			$this->process->setDbValueDef($rsnew, $this->process->CurrentValue, NULL, $this->process->ReadOnly);

			// bom_url
			$this->bom_url->setDbValueDef($rsnew, $this->bom_url->CurrentValue, "", $this->bom_url->ReadOnly);
			if ($this->image->Visible && !$this->image->Upload->KeepFile) {
				$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
				if (!EmptyValue($this->image->Upload->FileName)) {
					$newFiles = array($this->image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->image, $this->image->Upload->Index) . $file1) || file_exists($this->image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->image, $this->image->Upload->Index) . $file, UploadTempPath($this->image, $this->image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, NULL, $this->image->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->image->Visible && !$this->image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->image->Upload->DbValue) ? array() : array($this->image->Upload->DbValue);
						if (!EmptyValue($this->image->Upload->FileName)) {
							$newFiles = array($this->image->Upload->FileName);
							$newFiles2 = array($rsnew['image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->image, $this->image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->image->Upload->resizeAndSaveToFile($this->image->ImageWidth, $this->image->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("bom", $detailTblVar) && $GLOBALS["bom"]->DetailEdit) {
						if (!isset($GLOBALS["bom_grid"]))
							$GLOBALS["bom_grid"] = new bom_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "bom"); // Load user level of detail table
						$editRow = $GLOBALS["bom_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("production_process", $detailTblVar) && $GLOBALS["production_process"]->DetailEdit) {
						if (!isset($GLOBALS["production_process_grid"]))
							$GLOBALS["production_process_grid"] = new production_process_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "production_process"); // Load user level of detail table
						$editRow = $GLOBALS["production_process_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() <> "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// image
		if ($this->image->Upload->FileToken <> "")
			CleanUploadTempPath($this->image->Upload->FileToken, $this->image->Upload->Index);
		else
			CleanUploadTempPath($this->image, $this->image->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("bom", $detailTblVar)) {
				if (!isset($GLOBALS["bom_grid"]))
					$GLOBALS["bom_grid"] = new bom_grid();
				if ($GLOBALS["bom_grid"]->DetailEdit) {
					$GLOBALS["bom_grid"]->CurrentMode = "edit";
					$GLOBALS["bom_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["bom_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["bom_grid"]->setStartRecordNumber(1);
					$GLOBALS["bom_grid"]->batch_no->IsDetailKey = TRUE;
					$GLOBALS["bom_grid"]->batch_no->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["bom_grid"]->batch_no->setSessionValue($GLOBALS["bom_grid"]->batch_no->CurrentValue);
				}
			}
			if (in_array("production_process", $detailTblVar)) {
				if (!isset($GLOBALS["production_process_grid"]))
					$GLOBALS["production_process_grid"] = new production_process_grid();
				if ($GLOBALS["production_process_grid"]->DetailEdit) {
					$GLOBALS["production_process_grid"]->CurrentMode = "edit";
					$GLOBALS["production_process_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["production_process_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["production_process_grid"]->setStartRecordNumber(1);
					$GLOBALS["production_process_grid"]->batch_no->IsDetailKey = TRUE;
					$GLOBALS["production_process_grid"]->batch_no->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["production_process_grid"]->batch_no->setSessionValue($GLOBALS["production_process_grid"]->batch_no->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("batch_nolist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status`=1 and `product_type` != 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_id_tmp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
						case "x_process_id_tmp":
							break;
						case "x_process_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		$this->process->ReadOnly = True;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>