<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for bcode
 */
class bcode extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $pid;
	public $po;
	public $design_id;
	public $size_cm;
	public $_barcode;
	public $process_d;
	public $buyer_ref;
	public $order_date;
	public $despatch_date;
	public $despatch_week;
	public $dispatch_week_p;
	public $loom_plan;
	public $status;
	public $buyers_id;
	public $buyer_uid;
	public $buyer_loc;
	public $quantity;
	public $sqm;
	public $sqm_u;
	public $c_sqm;
	public $weaving_works;
	public $current_works;
	public $size_buyer;
	public $design;
	public $w_cm;
	public $l_cm;
	public $q_sku;
	public $po_price;
	public $po_discount;
	public $po_currency;
	public $product_type;
	public $shape;
	public $payment_plan;
	public $production_plan;
	public $datetime;
	public $completed;
	public $buyer_po;
	public $operator;
	public $jc_no;
	public $sqm_a;
	public $_2srm;
	public $_2srm_a;
	public $_4srm;
	public $_4srm_a;
	public $buyer_tid;
	public $grp;
	public $s_grp;
	public $batch_no;
	public $cs;
	public $process;
	public $process_c;
	public $weight;
	public $remarks;
	public $roll_no;
	public $qty;
	public $pl_no;
	public $category;
	public $pp_id;
	public $consignee;
	public $buyer_barcode;
	public $design_next;
	public $_11;
	public $_12;
	public $_13;
	public $_14;
	public $_15;
	public $_16;
	public $_17;
	public $_18;
	public $_19;
	public $_20;
	public $_21;
	public $_22;
	public $_23;
	public $_24;
	public $_25;
	public $_26;
	public $_27;
	public $_28;
	public $_29;
	public $_30;
	public $_31;
	public $_32;
	public $_33;
	public $_34;
	public $_35;
	public $_36;
	public $_37;
	public $_38;
	public $_39;
	public $_40;
	public $_41;
	public $_42;
	public $_43;
	public $_44;
	public $_45;
	public $_46;
	public $_47;
	public $_48;
	public $_49;
	public $_50;
	public $packing_type;
	public $qc_weaving;
	public $p_remarks;
	public $roll_no_qty_tmp;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'bcode';
		$this->TableName = 'bcode';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`bcode`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('bcode', 'bcode', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// pid
		$this->pid = new DbField('bcode', 'bcode', 'x_pid', 'pid', '`pid`', '`pid`', 131, -1, FALSE, '`pid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pid->Sortable = TRUE; // Allow sort
		$this->pid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pid'] = &$this->pid;

		// po
		$this->po = new DbField('bcode', 'bcode', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Required = TRUE; // Required field
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// design_id
		$this->design_id = new DbField('bcode', 'bcode', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`EV__design_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->design_id->Required = TRUE; // Required field
		$this->design_id->Sortable = TRUE; // Allow sort
		$this->design_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->design_id->Lookup = new Lookup('design_id', 'ref', FALSE, 'id', ["product_code","","",""], [], ["x_batch_no"], [], [], [], [], '`product_code` ASC', '');
		$this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design_id'] = &$this->design_id;

		// size_cm
		$this->size_cm = new DbField('bcode', 'bcode', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Nullable = FALSE; // NOT NULL field
		$this->size_cm->Required = TRUE; // Required field
		$this->size_cm->Sortable = TRUE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// barcode
		$this->_barcode = new DbField('bcode', 'bcode', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Nullable = FALSE; // NOT NULL field
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['barcode'] = &$this->_barcode;

		// process_d
		$this->process_d = new DbField('bcode', 'bcode', 'x_process_d', 'process_d', '`process_d`', '`process_d`', 200, -1, FALSE, '`process_d`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->process_d->Sortable = TRUE; // Allow sort
		$this->process_d->Lookup = new Lookup('process_d', 'sub_process_type_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process_d'] = &$this->process_d;

		// buyer_ref
		$this->buyer_ref = new DbField('bcode', 'bcode', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 2, -1, FALSE, '`EV__buyer_ref`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->buyer_ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_ref->Lookup = new Lookup('buyer_ref', 'partner_product_ref', FALSE, 'id', ["partner_ref","","",""], ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], '`partner_ref` ASC', '');
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// order_date
		$this->order_date = new DbField('bcode', 'bcode', 'x_order_date', 'order_date', '`order_date`', CastDateFieldForLike('`order_date`', 0, "DB"), 133, 0, FALSE, '`order_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->order_date->Sortable = TRUE; // Allow sort
		$this->order_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['order_date'] = &$this->order_date;

		// despatch_date
		$this->despatch_date = new DbField('bcode', 'bcode', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// despatch_week
		$this->despatch_week = new DbField('bcode', 'bcode', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// dispatch_week_p
		$this->dispatch_week_p = new DbField('bcode', 'bcode', 'x_dispatch_week_p', 'dispatch_week_p', '`dispatch_week_p`', '`dispatch_week_p`', 18, -1, FALSE, '`dispatch_week_p`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->dispatch_week_p->Sortable = TRUE; // Allow sort
		$this->dispatch_week_p->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->dispatch_week_p->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->dispatch_week_p->Lookup = new Lookup('dispatch_week_p', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->dispatch_week_p->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['dispatch_week_p'] = &$this->dispatch_week_p;

		// loom_plan
		$this->loom_plan = new DbField('bcode', 'bcode', 'x_loom_plan', 'loom_plan', '`loom_plan`', '`loom_plan`', 200, -1, FALSE, '`loom_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->loom_plan->Nullable = FALSE; // NOT NULL field
		$this->loom_plan->Sortable = FALSE; // Allow sort
		$this->fields['loom_plan'] = &$this->loom_plan;

		// status
		$this->status = new DbField('bcode', 'bcode', 'x_status', 'status', '`status`', '`status`', 18, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'status', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// buyers_id
		$this->buyers_id = new DbField('bcode', 'bcode', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyers_id->Lookup = new Lookup('buyers_id', 'buyer_seller_view', FALSE, 'id', ["name","code","",""], [], ["x_buyer_ref"], [], [], [], [], '`name` ASC', '');
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// buyer_uid
		$this->buyer_uid = new DbField('bcode', 'bcode', 'x_buyer_uid', 'buyer_uid', '`buyer_uid`', '`buyer_uid`', 200, -1, FALSE, '`buyer_uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_uid->Sortable = TRUE; // Allow sort
		$this->fields['buyer_uid'] = &$this->buyer_uid;

		// buyer_loc
		$this->buyer_loc = new DbField('bcode', 'bcode', 'x_buyer_loc', 'buyer_loc', '`buyer_loc`', '`buyer_loc`', 200, -1, FALSE, '`buyer_loc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_loc->Sortable = TRUE; // Allow sort
		$this->fields['buyer_loc'] = &$this->buyer_loc;

		// quantity
		$this->quantity = new DbField('bcode', 'bcode', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// sqm
		$this->sqm = new DbField('bcode', 'bcode', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 131, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Nullable = FALSE; // NOT NULL field
		$this->sqm->Required = TRUE; // Required field
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// sqm_u
		$this->sqm_u = new DbField('bcode', 'bcode', 'x_sqm_u', 'sqm_u', '`sqm_u`', '`sqm_u`', 4, -1, FALSE, '`sqm_u`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_u->Required = TRUE; // Required field
		$this->sqm_u->Sortable = TRUE; // Allow sort
		$this->sqm_u->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_u'] = &$this->sqm_u;

		// c_sqm
		$this->c_sqm = new DbField('bcode', 'bcode', 'x_c_sqm', 'c_sqm', '`c_sqm`', '`c_sqm`', 131, -1, FALSE, '`c_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->c_sqm->Nullable = FALSE; // NOT NULL field
		$this->c_sqm->Sortable = TRUE; // Allow sort
		$this->c_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['c_sqm'] = &$this->c_sqm;

		// weaving_works
		$this->weaving_works = new DbField('bcode', 'bcode', 'x_weaving_works', 'weaving_works', '`weaving_works`', '`weaving_works`', 18, -1, FALSE, '`weaving_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->weaving_works->Nullable = FALSE; // NOT NULL field
		$this->weaving_works->Required = TRUE; // Required field
		$this->weaving_works->Sortable = TRUE; // Allow sort
		$this->weaving_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->weaving_works->Lookup = new Lookup('weaving_works', 'godown', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['weaving_works'] = &$this->weaving_works;

		// current_works
		$this->current_works = new DbField('bcode', 'bcode', 'x_current_works', 'current_works', '`current_works`', '`current_works`', 18, -1, FALSE, '`current_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->current_works->Nullable = FALSE; // NOT NULL field
		$this->current_works->Required = TRUE; // Required field
		$this->current_works->Sortable = TRUE; // Allow sort
		$this->current_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->current_works->Lookup = new Lookup('current_works', 'godown', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['current_works'] = &$this->current_works;

		// size_buyer
		$this->size_buyer = new DbField('bcode', 'bcode', 'x_size_buyer', 'size_buyer', '`size_buyer`', '`size_buyer`', 200, -1, FALSE, '`size_buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_buyer->Required = TRUE; // Required field
		$this->size_buyer->Sortable = TRUE; // Allow sort
		$this->fields['size_buyer'] = &$this->size_buyer;

		// design
		$this->design = new DbField('bcode', 'bcode', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Sortable = TRUE; // Allow sort
		$this->design->Lookup = new Lookup('design', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design'] = &$this->design;

		// w_cm
		$this->w_cm = new DbField('bcode', 'bcode', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 18, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Required = TRUE; // Required field
		$this->w_cm->Sortable = TRUE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['w_cm'] = &$this->w_cm;

		// l_cm
		$this->l_cm = new DbField('bcode', 'bcode', 'x_l_cm', 'l_cm', '`l_cm`', '`l_cm`', 18, -1, FALSE, '`l_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l_cm->Required = TRUE; // Required field
		$this->l_cm->Sortable = TRUE; // Allow sort
		$this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['l_cm'] = &$this->l_cm;

		// q_sku
		$this->q_sku = new DbField('bcode', 'bcode', 'x_q_sku', 'q_sku', '`q_sku`', '`q_sku`', 131, -1, FALSE, '`q_sku`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->q_sku->Nullable = FALSE; // NOT NULL field
		$this->q_sku->Sortable = TRUE; // Allow sort
		$this->q_sku->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['q_sku'] = &$this->q_sku;

		// po_price
		$this->po_price = new DbField('bcode', 'bcode', 'x_po_price', 'po_price', '`po_price`', '`po_price`', 200, -1, FALSE, '`po_price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_price->Sortable = TRUE; // Allow sort
		$this->fields['po_price'] = &$this->po_price;

		// po_discount
		$this->po_discount = new DbField('bcode', 'bcode', 'x_po_discount', 'po_discount', '`po_discount`', '`po_discount`', 131, -1, FALSE, '`po_discount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_discount->Nullable = FALSE; // NOT NULL field
		$this->po_discount->Sortable = TRUE; // Allow sort
		$this->po_discount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['po_discount'] = &$this->po_discount;

		// po_currency
		$this->po_currency = new DbField('bcode', 'bcode', 'x_po_currency', 'po_currency', '`po_currency`', '`po_currency`', 18, -1, FALSE, '`po_currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->po_currency->Sortable = TRUE; // Allow sort
		$this->po_currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->po_currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->po_currency->Lookup = new Lookup('po_currency', 'currency', FALSE, 'id', ["code","","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->po_currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_currency'] = &$this->po_currency;

		// product_type
		$this->product_type = new DbField('bcode', 'bcode', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 2, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_type->Nullable = FALSE; // NOT NULL field
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_type->Lookup = new Lookup('product_type', 'bcode', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->product_type->OptionCount = 4;
		$this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_type'] = &$this->product_type;

		// shape
		$this->shape = new DbField('bcode', 'bcode', 'x_shape', 'shape', '`shape`', '`shape`', 17, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Nullable = FALSE; // NOT NULL field
		$this->shape->Required = TRUE; // Required field
		$this->shape->Sortable = TRUE; // Allow sort
		$this->shape->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shape->Lookup = new Lookup('shape', 'shape', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shape'] = &$this->shape;

		// payment_plan
		$this->payment_plan = new DbField('bcode', 'bcode', 'x_payment_plan', 'payment_plan', '`payment_plan`', '`payment_plan`', 18, -1, FALSE, '`payment_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment_plan->Sortable = TRUE; // Allow sort
		$this->payment_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment_plan->Lookup = new Lookup('payment_plan', 'payment_plan', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->payment_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['payment_plan'] = &$this->payment_plan;

		// production_plan
		$this->production_plan = new DbField('bcode', 'bcode', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 17, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_plan->Sortable = TRUE; // Allow sort
		$this->production_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_plan->Lookup = new Lookup('production_plan', 'bcode', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->production_plan->OptionCount = 6;
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;

		// datetime
		$this->datetime = new DbField('bcode', 'bcode', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// completed
		$this->completed = new DbField('bcode', 'bcode', 'x_completed', 'completed', '`completed`', '`completed`', 17, -1, FALSE, '`completed`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->completed->Sortable = TRUE; // Allow sort
		$this->completed->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->completed->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->completed->Lookup = new Lookup('completed', 'bcode', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->completed->OptionCount = 2;
		$this->completed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['completed'] = &$this->completed;

		// buyer_po
		$this->buyer_po = new DbField('bcode', 'bcode', 'x_buyer_po', 'buyer_po', '`buyer_po`', '`buyer_po`', 200, -1, FALSE, '`buyer_po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_po->Sortable = TRUE; // Allow sort
		$this->fields['buyer_po'] = &$this->buyer_po;

		// operator
		$this->operator = new DbField('bcode', 'bcode', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// jc_no
		$this->jc_no = new DbField('bcode', 'bcode', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 19, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// sqm_a
		$this->sqm_a = new DbField('bcode', 'bcode', 'x_sqm_a', 'sqm_a', '`sqm_a`', '`sqm_a`', 4, -1, FALSE, '`sqm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_a->Nullable = FALSE; // NOT NULL field
		$this->sqm_a->Required = TRUE; // Required field
		$this->sqm_a->Sortable = FALSE; // Allow sort
		$this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_a'] = &$this->sqm_a;

		// 2srm
		$this->_2srm = new DbField('bcode', 'bcode', 'x__2srm', '2srm', '`2srm`', '`2srm`', 4, -1, FALSE, '`2srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2srm->Nullable = FALSE; // NOT NULL field
		$this->_2srm->Required = TRUE; // Required field
		$this->_2srm->Sortable = FALSE; // Allow sort
		$this->_2srm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['2srm'] = &$this->_2srm;

		// 2srm_a
		$this->_2srm_a = new DbField('bcode', 'bcode', 'x__2srm_a', '2srm_a', '`2srm_a`', '`2srm_a`', 4, -1, FALSE, '`2srm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2srm_a->Nullable = FALSE; // NOT NULL field
		$this->_2srm_a->Required = TRUE; // Required field
		$this->_2srm_a->Sortable = FALSE; // Allow sort
		$this->_2srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['2srm_a'] = &$this->_2srm_a;

		// 4srm
		$this->_4srm = new DbField('bcode', 'bcode', 'x__4srm', '4srm', '`4srm`', '`4srm`', 4, -1, FALSE, '`4srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4srm->Nullable = FALSE; // NOT NULL field
		$this->_4srm->Required = TRUE; // Required field
		$this->_4srm->Sortable = FALSE; // Allow sort
		$this->_4srm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['4srm'] = &$this->_4srm;

		// 4srm_a
		$this->_4srm_a = new DbField('bcode', 'bcode', 'x__4srm_a', '4srm_a', '`4srm_a`', '`4srm_a`', 4, -1, FALSE, '`4srm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4srm_a->Nullable = FALSE; // NOT NULL field
		$this->_4srm_a->Required = TRUE; // Required field
		$this->_4srm_a->Sortable = FALSE; // Allow sort
		$this->_4srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['4srm_a'] = &$this->_4srm_a;

		// buyer_tid
		$this->buyer_tid = new DbField('bcode', 'bcode', 'x_buyer_tid', 'buyer_tid', '`buyer_tid`', '`buyer_tid`', 200, -1, FALSE, '`buyer_tid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_tid->Sortable = FALSE; // Allow sort
		$this->fields['buyer_tid'] = &$this->buyer_tid;

		// grp
		$this->grp = new DbField('bcode', 'bcode', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('bcode', 'bcode', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 2, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// batch_no
		$this->batch_no = new DbField('bcode', 'bcode', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","","",""], ["x_design_id"], [], ["rid"], ["x_rid"], [], [], '`batch_no` ASC', '');
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// cs
		$this->cs = new DbField('bcode', 'bcode', 'x_cs', 'cs', '`cs`', '`cs`', 19, -1, FALSE, '`cs`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->cs->Nullable = FALSE; // NOT NULL field
		$this->cs->Sortable = TRUE; // Allow sort
		$this->cs->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->cs->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->cs->Lookup = new Lookup('cs', 'bcode', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->cs->OptionCount = 2;
		$this->cs->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cs'] = &$this->cs;

		// process
		$this->process = new DbField('bcode', 'bcode', 'x_process', 'process', '`process`', '`process`', 200, -1, FALSE, '`process`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->process->Sortable = TRUE; // Allow sort
		$this->process->Lookup = new Lookup('process', 'sub_process_type_view', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process'] = &$this->process;

		// process_c
		$this->process_c = new DbField('bcode', 'bcode', 'x_process_c', 'process_c', '`process_c`', '`process_c`', 200, -1, FALSE, '`process_c`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->process_c->Sortable = TRUE; // Allow sort
		$this->process_c->Lookup = new Lookup('process_c', 'sub_process_type', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['process_c'] = &$this->process_c;

		// weight
		$this->weight = new DbField('bcode', 'bcode', 'x_weight', 'weight', '`weight`', '`weight`', 131, -1, FALSE, '`weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->weight->Sortable = TRUE; // Allow sort
		$this->weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['weight'] = &$this->weight;

		// remarks
		$this->remarks = new DbField('bcode', 'bcode', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// roll_no
		$this->roll_no = new DbField('bcode', 'bcode', 'x_roll_no', 'roll_no', '`roll_no`', '`roll_no`', 18, -1, FALSE, '`roll_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->roll_no->Sortable = TRUE; // Allow sort
		$this->roll_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['roll_no'] = &$this->roll_no;

		// qty
		$this->qty = new DbField('bcode', 'bcode', 'x_qty', 'qty', '`qty`', '`qty`', 18, -1, FALSE, '`qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty->Sortable = TRUE; // Allow sort
		$this->qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['qty'] = &$this->qty;

		// pl_no
		$this->pl_no = new DbField('bcode', 'bcode', 'x_pl_no', 'pl_no', '`pl_no`', '`pl_no`', 131, -1, FALSE, '`pl_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pl_no->Nullable = FALSE; // NOT NULL field
		$this->pl_no->Sortable = TRUE; // Allow sort
		$this->pl_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pl_no'] = &$this->pl_no;

		// category
		$this->category = new DbField('bcode', 'bcode', 'x_category', 'category', '`category`', '`category`', 200, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->category->Nullable = FALSE; // NOT NULL field
		$this->category->Required = TRUE; // Required field
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->category->Lookup = new Lookup('category', 'product_category', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['category'] = &$this->category;

		// pp_id
		$this->pp_id = new DbField('bcode', 'bcode', 'x_pp_id', 'pp_id', '`pp_id`', '`pp_id`', 19, -1, FALSE, '`pp_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pp_id->Sortable = TRUE; // Allow sort
		$this->pp_id->Lookup = new Lookup('pp_id', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pp_id'] = &$this->pp_id;

		// consignee
		$this->consignee = new DbField('bcode', 'bcode', 'x_consignee', 'consignee', '`consignee`', '`consignee`', 19, -1, FALSE, '`consignee`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->consignee->Sortable = FALSE; // Allow sort
		$this->consignee->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['consignee'] = &$this->consignee;

		// buyer_barcode
		$this->buyer_barcode = new DbField('bcode', 'bcode', 'x_buyer_barcode', 'buyer_barcode', '`buyer_barcode`', '`buyer_barcode`', 200, -1, FALSE, '`buyer_barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_barcode->Sortable = FALSE; // Allow sort
		$this->fields['buyer_barcode'] = &$this->buyer_barcode;

		// design_next
		$this->design_next = new DbField('bcode', 'bcode', 'x_design_next', 'design_next', '`design_next`', '`design_next`', 200, -1, FALSE, '`design_next`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design_next->Sortable = FALSE; // Allow sort
		$this->fields['design_next'] = &$this->design_next;

		// 11
		$this->_11 = new DbField('bcode', 'bcode', 'x__11', '11', '`11`', '`11`', 200, -1, FALSE, '`11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_11->Sortable = TRUE; // Allow sort
		$this->fields['11'] = &$this->_11;

		// 12
		$this->_12 = new DbField('bcode', 'bcode', 'x__12', '12', '`12`', '`12`', 200, -1, FALSE, '`12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_12->Sortable = TRUE; // Allow sort
		$this->fields['12'] = &$this->_12;

		// 13
		$this->_13 = new DbField('bcode', 'bcode', 'x__13', '13', '`13`', '`13`', 200, -1, FALSE, '`13`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_13->Sortable = TRUE; // Allow sort
		$this->fields['13'] = &$this->_13;

		// 14
		$this->_14 = new DbField('bcode', 'bcode', 'x__14', '14', '`14`', '`14`', 200, -1, FALSE, '`14`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_14->Sortable = TRUE; // Allow sort
		$this->fields['14'] = &$this->_14;

		// 15
		$this->_15 = new DbField('bcode', 'bcode', 'x__15', '15', '`15`', '`15`', 200, -1, FALSE, '`15`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_15->Sortable = TRUE; // Allow sort
		$this->fields['15'] = &$this->_15;

		// 16
		$this->_16 = new DbField('bcode', 'bcode', 'x__16', '16', '`16`', '`16`', 200, -1, FALSE, '`16`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_16->Sortable = TRUE; // Allow sort
		$this->fields['16'] = &$this->_16;

		// 17
		$this->_17 = new DbField('bcode', 'bcode', 'x__17', '17', '`17`', '`17`', 200, -1, FALSE, '`17`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_17->Sortable = TRUE; // Allow sort
		$this->fields['17'] = &$this->_17;

		// 18
		$this->_18 = new DbField('bcode', 'bcode', 'x__18', '18', '`18`', '`18`', 200, -1, FALSE, '`18`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_18->Sortable = TRUE; // Allow sort
		$this->fields['18'] = &$this->_18;

		// 19
		$this->_19 = new DbField('bcode', 'bcode', 'x__19', '19', '`19`', '`19`', 200, -1, FALSE, '`19`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_19->Sortable = TRUE; // Allow sort
		$this->fields['19'] = &$this->_19;

		// 20
		$this->_20 = new DbField('bcode', 'bcode', 'x__20', '20', '`20`', '`20`', 200, -1, FALSE, '`20`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_20->Sortable = TRUE; // Allow sort
		$this->fields['20'] = &$this->_20;

		// 21
		$this->_21 = new DbField('bcode', 'bcode', 'x__21', '21', '`21`', '`21`', 200, -1, FALSE, '`21`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_21->Sortable = TRUE; // Allow sort
		$this->fields['21'] = &$this->_21;

		// 22
		$this->_22 = new DbField('bcode', 'bcode', 'x__22', '22', '`22`', '`22`', 200, -1, FALSE, '`22`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_22->Sortable = TRUE; // Allow sort
		$this->fields['22'] = &$this->_22;

		// 23
		$this->_23 = new DbField('bcode', 'bcode', 'x__23', '23', '`23`', '`23`', 200, -1, FALSE, '`23`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_23->Sortable = TRUE; // Allow sort
		$this->fields['23'] = &$this->_23;

		// 24
		$this->_24 = new DbField('bcode', 'bcode', 'x__24', '24', '`24`', '`24`', 200, -1, FALSE, '`24`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_24->Sortable = TRUE; // Allow sort
		$this->fields['24'] = &$this->_24;

		// 25
		$this->_25 = new DbField('bcode', 'bcode', 'x__25', '25', '`25`', '`25`', 200, -1, FALSE, '`25`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_25->Sortable = TRUE; // Allow sort
		$this->fields['25'] = &$this->_25;

		// 26
		$this->_26 = new DbField('bcode', 'bcode', 'x__26', '26', '`26`', '`26`', 200, -1, FALSE, '`26`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_26->Sortable = TRUE; // Allow sort
		$this->fields['26'] = &$this->_26;

		// 27
		$this->_27 = new DbField('bcode', 'bcode', 'x__27', '27', '`27`', '`27`', 200, -1, FALSE, '`27`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_27->Sortable = TRUE; // Allow sort
		$this->fields['27'] = &$this->_27;

		// 28
		$this->_28 = new DbField('bcode', 'bcode', 'x__28', '28', '`28`', '`28`', 200, -1, FALSE, '`28`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_28->Sortable = TRUE; // Allow sort
		$this->fields['28'] = &$this->_28;

		// 29
		$this->_29 = new DbField('bcode', 'bcode', 'x__29', '29', '`29`', '`29`', 200, -1, FALSE, '`29`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_29->Sortable = TRUE; // Allow sort
		$this->fields['29'] = &$this->_29;

		// 30
		$this->_30 = new DbField('bcode', 'bcode', 'x__30', '30', '`30`', '`30`', 200, -1, FALSE, '`30`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_30->Sortable = TRUE; // Allow sort
		$this->fields['30'] = &$this->_30;

		// 31
		$this->_31 = new DbField('bcode', 'bcode', 'x__31', '31', '`31`', '`31`', 200, -1, FALSE, '`31`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_31->Sortable = TRUE; // Allow sort
		$this->fields['31'] = &$this->_31;

		// 32
		$this->_32 = new DbField('bcode', 'bcode', 'x__32', '32', '`32`', '`32`', 200, -1, FALSE, '`32`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_32->Sortable = TRUE; // Allow sort
		$this->fields['32'] = &$this->_32;

		// 33
		$this->_33 = new DbField('bcode', 'bcode', 'x__33', '33', '`33`', '`33`', 200, -1, FALSE, '`33`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_33->Sortable = TRUE; // Allow sort
		$this->fields['33'] = &$this->_33;

		// 34
		$this->_34 = new DbField('bcode', 'bcode', 'x__34', '34', '`34`', '`34`', 200, -1, FALSE, '`34`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_34->Sortable = TRUE; // Allow sort
		$this->fields['34'] = &$this->_34;

		// 35
		$this->_35 = new DbField('bcode', 'bcode', 'x__35', '35', '`35`', '`35`', 200, -1, FALSE, '`35`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_35->Sortable = TRUE; // Allow sort
		$this->fields['35'] = &$this->_35;

		// 36
		$this->_36 = new DbField('bcode', 'bcode', 'x__36', '36', '`36`', '`36`', 200, -1, FALSE, '`36`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_36->Sortable = TRUE; // Allow sort
		$this->fields['36'] = &$this->_36;

		// 37
		$this->_37 = new DbField('bcode', 'bcode', 'x__37', '37', '`37`', '`37`', 200, -1, FALSE, '`37`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_37->Sortable = TRUE; // Allow sort
		$this->fields['37'] = &$this->_37;

		// 38
		$this->_38 = new DbField('bcode', 'bcode', 'x__38', '38', '`38`', '`38`', 200, -1, FALSE, '`38`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_38->Sortable = TRUE; // Allow sort
		$this->fields['38'] = &$this->_38;

		// 39
		$this->_39 = new DbField('bcode', 'bcode', 'x__39', '39', '`39`', '`39`', 200, -1, FALSE, '`39`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_39->Sortable = TRUE; // Allow sort
		$this->fields['39'] = &$this->_39;

		// 40
		$this->_40 = new DbField('bcode', 'bcode', 'x__40', '40', '`40`', '`40`', 200, -1, FALSE, '`40`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40->Sortable = TRUE; // Allow sort
		$this->fields['40'] = &$this->_40;

		// 41
		$this->_41 = new DbField('bcode', 'bcode', 'x__41', '41', '`41`', '`41`', 200, -1, FALSE, '`41`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_41->Sortable = TRUE; // Allow sort
		$this->fields['41'] = &$this->_41;

		// 42
		$this->_42 = new DbField('bcode', 'bcode', 'x__42', '42', '`42`', '`42`', 200, -1, FALSE, '`42`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_42->Sortable = TRUE; // Allow sort
		$this->fields['42'] = &$this->_42;

		// 43
		$this->_43 = new DbField('bcode', 'bcode', 'x__43', '43', '`43`', '`43`', 200, -1, FALSE, '`43`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_43->Sortable = TRUE; // Allow sort
		$this->fields['43'] = &$this->_43;

		// 44
		$this->_44 = new DbField('bcode', 'bcode', 'x__44', '44', '`44`', '`44`', 200, -1, FALSE, '`44`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_44->Sortable = TRUE; // Allow sort
		$this->fields['44'] = &$this->_44;

		// 45
		$this->_45 = new DbField('bcode', 'bcode', 'x__45', '45', '`45`', '`45`', 200, -1, FALSE, '`45`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_45->Sortable = TRUE; // Allow sort
		$this->fields['45'] = &$this->_45;

		// 46
		$this->_46 = new DbField('bcode', 'bcode', 'x__46', '46', '`46`', '`46`', 200, -1, FALSE, '`46`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_46->Sortable = TRUE; // Allow sort
		$this->fields['46'] = &$this->_46;

		// 47
		$this->_47 = new DbField('bcode', 'bcode', 'x__47', '47', '`47`', '`47`', 200, -1, FALSE, '`47`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_47->Sortable = TRUE; // Allow sort
		$this->fields['47'] = &$this->_47;

		// 48
		$this->_48 = new DbField('bcode', 'bcode', 'x__48', '48', '`48`', '`48`', 200, -1, FALSE, '`48`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_48->Sortable = TRUE; // Allow sort
		$this->fields['48'] = &$this->_48;

		// 49
		$this->_49 = new DbField('bcode', 'bcode', 'x__49', '49', '`49`', '`49`', 200, -1, FALSE, '`49`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_49->Sortable = TRUE; // Allow sort
		$this->fields['49'] = &$this->_49;

		// 50
		$this->_50 = new DbField('bcode', 'bcode', 'x__50', '50', '`50`', '`50`', 200, -1, FALSE, '`50`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_50->Sortable = TRUE; // Allow sort
		$this->fields['50'] = &$this->_50;

		// packing_type
		$this->packing_type = new DbField('bcode', 'bcode', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Sortable = FALSE; // Allow sort
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// qc_weaving
		$this->qc_weaving = new DbField('bcode', 'bcode', 'x_qc_weaving', 'qc_weaving', '`qc_weaving`', CastDateFieldForLike('`qc_weaving`', 0, "DB"), 133, 0, FALSE, '`qc_weaving`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qc_weaving->Sortable = FALSE; // Allow sort
		$this->qc_weaving->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['qc_weaving'] = &$this->qc_weaving;

		// p_remarks
		$this->p_remarks = new DbField('bcode', 'bcode', 'x_p_remarks', 'p_remarks', '`p_remarks`', '`p_remarks`', 201, -1, FALSE, '`p_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->p_remarks->Sortable = TRUE; // Allow sort
		$this->fields['p_remarks'] = &$this->p_remarks;

		// roll_no_qty_tmp
		$this->roll_no_qty_tmp = new DbField('bcode', 'bcode', 'x_roll_no_qty_tmp', 'roll_no_qty_tmp', '`roll_no_qty_tmp`', '`roll_no_qty_tmp`', 131, -1, FALSE, '`roll_no_qty_tmp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->roll_no_qty_tmp->Nullable = FALSE; // NOT NULL field
		$this->roll_no_qty_tmp->Required = TRUE; // Required field
		$this->roll_no_qty_tmp->Sortable = TRUE; // Allow sort
		$this->roll_no_qty_tmp->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['roll_no_qty_tmp'] = &$this->roll_no_qty_tmp;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`bcode`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `bcode`.`design_id` LIMIT 1) AS `EV__design_id`, (SELECT `partner_ref` FROM `partner_product_ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `bcode`.`buyer_ref` LIMIT 1) AS `EV__buyer_ref` FROM `bcode`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`barcode` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->design_id->AdvancedSearch->SearchValue <> "" ||
			$this->design_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->design_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->design_id->VirtualExpression . " "))
			return TRUE;
		if ($this->buyer_ref->AdvancedSearch->SearchValue <> "" ||
			$this->buyer_ref->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->buyer_ref->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->buyer_ref->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->pid->DbValue = $row['pid'];
		$this->po->DbValue = $row['po'];
		$this->design_id->DbValue = $row['design_id'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->process_d->DbValue = $row['process_d'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->order_date->DbValue = $row['order_date'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->dispatch_week_p->DbValue = $row['dispatch_week_p'];
		$this->loom_plan->DbValue = $row['loom_plan'];
		$this->status->DbValue = $row['status'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->buyer_uid->DbValue = $row['buyer_uid'];
		$this->buyer_loc->DbValue = $row['buyer_loc'];
		$this->quantity->DbValue = $row['quantity'];
		$this->sqm->DbValue = $row['sqm'];
		$this->sqm_u->DbValue = $row['sqm_u'];
		$this->c_sqm->DbValue = $row['c_sqm'];
		$this->weaving_works->DbValue = $row['weaving_works'];
		$this->current_works->DbValue = $row['current_works'];
		$this->size_buyer->DbValue = $row['size_buyer'];
		$this->design->DbValue = $row['design'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->l_cm->DbValue = $row['l_cm'];
		$this->q_sku->DbValue = $row['q_sku'];
		$this->po_price->DbValue = $row['po_price'];
		$this->po_discount->DbValue = $row['po_discount'];
		$this->po_currency->DbValue = $row['po_currency'];
		$this->product_type->DbValue = $row['product_type'];
		$this->shape->DbValue = $row['shape'];
		$this->payment_plan->DbValue = $row['payment_plan'];
		$this->production_plan->DbValue = $row['production_plan'];
		$this->datetime->DbValue = $row['datetime'];
		$this->completed->DbValue = $row['completed'];
		$this->buyer_po->DbValue = $row['buyer_po'];
		$this->operator->DbValue = $row['operator'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->sqm_a->DbValue = $row['sqm_a'];
		$this->_2srm->DbValue = $row['2srm'];
		$this->_2srm_a->DbValue = $row['2srm_a'];
		$this->_4srm->DbValue = $row['4srm'];
		$this->_4srm_a->DbValue = $row['4srm_a'];
		$this->buyer_tid->DbValue = $row['buyer_tid'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->cs->DbValue = $row['cs'];
		$this->process->DbValue = $row['process'];
		$this->process_c->DbValue = $row['process_c'];
		$this->weight->DbValue = $row['weight'];
		$this->remarks->DbValue = $row['remarks'];
		$this->roll_no->DbValue = $row['roll_no'];
		$this->qty->DbValue = $row['qty'];
		$this->pl_no->DbValue = $row['pl_no'];
		$this->category->DbValue = $row['category'];
		$this->pp_id->DbValue = $row['pp_id'];
		$this->consignee->DbValue = $row['consignee'];
		$this->buyer_barcode->DbValue = $row['buyer_barcode'];
		$this->design_next->DbValue = $row['design_next'];
		$this->_11->DbValue = $row['11'];
		$this->_12->DbValue = $row['12'];
		$this->_13->DbValue = $row['13'];
		$this->_14->DbValue = $row['14'];
		$this->_15->DbValue = $row['15'];
		$this->_16->DbValue = $row['16'];
		$this->_17->DbValue = $row['17'];
		$this->_18->DbValue = $row['18'];
		$this->_19->DbValue = $row['19'];
		$this->_20->DbValue = $row['20'];
		$this->_21->DbValue = $row['21'];
		$this->_22->DbValue = $row['22'];
		$this->_23->DbValue = $row['23'];
		$this->_24->DbValue = $row['24'];
		$this->_25->DbValue = $row['25'];
		$this->_26->DbValue = $row['26'];
		$this->_27->DbValue = $row['27'];
		$this->_28->DbValue = $row['28'];
		$this->_29->DbValue = $row['29'];
		$this->_30->DbValue = $row['30'];
		$this->_31->DbValue = $row['31'];
		$this->_32->DbValue = $row['32'];
		$this->_33->DbValue = $row['33'];
		$this->_34->DbValue = $row['34'];
		$this->_35->DbValue = $row['35'];
		$this->_36->DbValue = $row['36'];
		$this->_37->DbValue = $row['37'];
		$this->_38->DbValue = $row['38'];
		$this->_39->DbValue = $row['39'];
		$this->_40->DbValue = $row['40'];
		$this->_41->DbValue = $row['41'];
		$this->_42->DbValue = $row['42'];
		$this->_43->DbValue = $row['43'];
		$this->_44->DbValue = $row['44'];
		$this->_45->DbValue = $row['45'];
		$this->_46->DbValue = $row['46'];
		$this->_47->DbValue = $row['47'];
		$this->_48->DbValue = $row['48'];
		$this->_49->DbValue = $row['49'];
		$this->_50->DbValue = $row['50'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->qc_weaving->DbValue = $row['qc_weaving'];
		$this->p_remarks->DbValue = $row['p_remarks'];
		$this->roll_no_qty_tmp->DbValue = $row['roll_no_qty_tmp'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "bcodelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "bcodeview.php")
			return $Language->phrase("View");
		elseif ($pageName == "bcodeedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "bcodeadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "bcodelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("bcodeview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("bcodeview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "bcodeadd.php?" . $this->getUrlParm($parm);
		else
			$url = "bcodeadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("bcodeedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("bcodeadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("bcodedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->pid->setDbValue($rs->fields('pid'));
		$this->po->setDbValue($rs->fields('po'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->process_d->setDbValue($rs->fields('process_d'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->order_date->setDbValue($rs->fields('order_date'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->dispatch_week_p->setDbValue($rs->fields('dispatch_week_p'));
		$this->loom_plan->setDbValue($rs->fields('loom_plan'));
		$this->status->setDbValue($rs->fields('status'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->buyer_uid->setDbValue($rs->fields('buyer_uid'));
		$this->buyer_loc->setDbValue($rs->fields('buyer_loc'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->sqm_u->setDbValue($rs->fields('sqm_u'));
		$this->c_sqm->setDbValue($rs->fields('c_sqm'));
		$this->weaving_works->setDbValue($rs->fields('weaving_works'));
		$this->current_works->setDbValue($rs->fields('current_works'));
		$this->size_buyer->setDbValue($rs->fields('size_buyer'));
		$this->design->setDbValue($rs->fields('design'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->l_cm->setDbValue($rs->fields('l_cm'));
		$this->q_sku->setDbValue($rs->fields('q_sku'));
		$this->po_price->setDbValue($rs->fields('po_price'));
		$this->po_discount->setDbValue($rs->fields('po_discount'));
		$this->po_currency->setDbValue($rs->fields('po_currency'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->payment_plan->setDbValue($rs->fields('payment_plan'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->completed->setDbValue($rs->fields('completed'));
		$this->buyer_po->setDbValue($rs->fields('buyer_po'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->sqm_a->setDbValue($rs->fields('sqm_a'));
		$this->_2srm->setDbValue($rs->fields('2srm'));
		$this->_2srm_a->setDbValue($rs->fields('2srm_a'));
		$this->_4srm->setDbValue($rs->fields('4srm'));
		$this->_4srm_a->setDbValue($rs->fields('4srm_a'));
		$this->buyer_tid->setDbValue($rs->fields('buyer_tid'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->cs->setDbValue($rs->fields('cs'));
		$this->process->setDbValue($rs->fields('process'));
		$this->process_c->setDbValue($rs->fields('process_c'));
		$this->weight->setDbValue($rs->fields('weight'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->roll_no->setDbValue($rs->fields('roll_no'));
		$this->qty->setDbValue($rs->fields('qty'));
		$this->pl_no->setDbValue($rs->fields('pl_no'));
		$this->category->setDbValue($rs->fields('category'));
		$this->pp_id->setDbValue($rs->fields('pp_id'));
		$this->consignee->setDbValue($rs->fields('consignee'));
		$this->buyer_barcode->setDbValue($rs->fields('buyer_barcode'));
		$this->design_next->setDbValue($rs->fields('design_next'));
		$this->_11->setDbValue($rs->fields('11'));
		$this->_12->setDbValue($rs->fields('12'));
		$this->_13->setDbValue($rs->fields('13'));
		$this->_14->setDbValue($rs->fields('14'));
		$this->_15->setDbValue($rs->fields('15'));
		$this->_16->setDbValue($rs->fields('16'));
		$this->_17->setDbValue($rs->fields('17'));
		$this->_18->setDbValue($rs->fields('18'));
		$this->_19->setDbValue($rs->fields('19'));
		$this->_20->setDbValue($rs->fields('20'));
		$this->_21->setDbValue($rs->fields('21'));
		$this->_22->setDbValue($rs->fields('22'));
		$this->_23->setDbValue($rs->fields('23'));
		$this->_24->setDbValue($rs->fields('24'));
		$this->_25->setDbValue($rs->fields('25'));
		$this->_26->setDbValue($rs->fields('26'));
		$this->_27->setDbValue($rs->fields('27'));
		$this->_28->setDbValue($rs->fields('28'));
		$this->_29->setDbValue($rs->fields('29'));
		$this->_30->setDbValue($rs->fields('30'));
		$this->_31->setDbValue($rs->fields('31'));
		$this->_32->setDbValue($rs->fields('32'));
		$this->_33->setDbValue($rs->fields('33'));
		$this->_34->setDbValue($rs->fields('34'));
		$this->_35->setDbValue($rs->fields('35'));
		$this->_36->setDbValue($rs->fields('36'));
		$this->_37->setDbValue($rs->fields('37'));
		$this->_38->setDbValue($rs->fields('38'));
		$this->_39->setDbValue($rs->fields('39'));
		$this->_40->setDbValue($rs->fields('40'));
		$this->_41->setDbValue($rs->fields('41'));
		$this->_42->setDbValue($rs->fields('42'));
		$this->_43->setDbValue($rs->fields('43'));
		$this->_44->setDbValue($rs->fields('44'));
		$this->_45->setDbValue($rs->fields('45'));
		$this->_46->setDbValue($rs->fields('46'));
		$this->_47->setDbValue($rs->fields('47'));
		$this->_48->setDbValue($rs->fields('48'));
		$this->_49->setDbValue($rs->fields('49'));
		$this->_50->setDbValue($rs->fields('50'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->qc_weaving->setDbValue($rs->fields('qc_weaving'));
		$this->p_remarks->setDbValue($rs->fields('p_remarks'));
		$this->roll_no_qty_tmp->setDbValue($rs->fields('roll_no_qty_tmp'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// pid
		// po
		// design_id
		// size_cm
		// barcode

		$this->_barcode->CellCssStyle = "width: 300px;";

		// process_d
		// buyer_ref
		// order_date
		// despatch_date
		// despatch_week
		// dispatch_week_p
		// loom_plan

		$this->loom_plan->CellCssStyle = "white-space: nowrap;";

		// status
		// buyers_id
		// buyer_uid

		$this->buyer_uid->CellCssStyle = "width: 200px;";

		// buyer_loc
		// quantity
		// sqm
		// sqm_u
		// c_sqm
		// weaving_works

		$this->weaving_works->CellCssStyle = "white-space: nowrap;";

		// current_works
		$this->current_works->CellCssStyle = "white-space: nowrap;";

		// size_buyer
		// design

		$this->design->CellCssStyle = "white-space: nowrap;";

		// w_cm
		$this->w_cm->CellCssStyle = "white-space: nowrap;";

		// l_cm
		$this->l_cm->CellCssStyle = "white-space: nowrap;";

		// q_sku
		// po_price
		// po_discount
		// po_currency
		// product_type
		// shape
		// payment_plan
		// production_plan
		// datetime
		// completed
		// buyer_po
		// operator
		// jc_no
		// sqm_a

		$this->sqm_a->CellCssStyle = "white-space: nowrap;";

		// 2srm
		$this->_2srm->CellCssStyle = "white-space: nowrap;";

		// 2srm_a
		$this->_2srm_a->CellCssStyle = "white-space: nowrap;";

		// 4srm
		$this->_4srm->CellCssStyle = "white-space: nowrap;";

		// 4srm_a
		$this->_4srm_a->CellCssStyle = "white-space: nowrap;";

		// buyer_tid
		$this->buyer_tid->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// batch_no
		// cs
		// process
		// process_c
		// weight
		// remarks
		// roll_no
		// qty
		// pl_no
		// category
		// pp_id
		// consignee

		$this->consignee->CellCssStyle = "white-space: nowrap;";

		// buyer_barcode
		$this->buyer_barcode->CellCssStyle = "white-space: nowrap;";

		// design_next
		$this->design_next->CellCssStyle = "white-space: nowrap;";

		// 11
		$this->_11->CellCssStyle = "white-space: nowrap;";

		// 12
		$this->_12->CellCssStyle = "white-space: nowrap;";

		// 13
		$this->_13->CellCssStyle = "white-space: nowrap;";

		// 14
		$this->_14->CellCssStyle = "white-space: nowrap;";

		// 15
		$this->_15->CellCssStyle = "white-space: nowrap;";

		// 16
		$this->_16->CellCssStyle = "white-space: nowrap;";

		// 17
		$this->_17->CellCssStyle = "white-space: nowrap;";

		// 18
		$this->_18->CellCssStyle = "white-space: nowrap;";

		// 19
		$this->_19->CellCssStyle = "white-space: nowrap;";

		// 20
		$this->_20->CellCssStyle = "white-space: nowrap;";

		// 21
		$this->_21->CellCssStyle = "white-space: nowrap;";

		// 22
		$this->_22->CellCssStyle = "white-space: nowrap;";

		// 23
		$this->_23->CellCssStyle = "white-space: nowrap;";

		// 24
		$this->_24->CellCssStyle = "white-space: nowrap;";

		// 25
		$this->_25->CellCssStyle = "white-space: nowrap;";

		// 26
		$this->_26->CellCssStyle = "white-space: nowrap;";

		// 27
		$this->_27->CellCssStyle = "white-space: nowrap;";

		// 28
		$this->_28->CellCssStyle = "white-space: nowrap;";

		// 29
		$this->_29->CellCssStyle = "white-space: nowrap;";

		// 30
		$this->_30->CellCssStyle = "white-space: nowrap;";

		// 31
		$this->_31->CellCssStyle = "white-space: nowrap;";

		// 32
		$this->_32->CellCssStyle = "white-space: nowrap;";

		// 33
		$this->_33->CellCssStyle = "white-space: nowrap;";

		// 34
		$this->_34->CellCssStyle = "white-space: nowrap;";

		// 35
		$this->_35->CellCssStyle = "white-space: nowrap;";

		// 36
		$this->_36->CellCssStyle = "white-space: nowrap;";

		// 37
		$this->_37->CellCssStyle = "white-space: nowrap;";

		// 38
		$this->_38->CellCssStyle = "white-space: nowrap;";

		// 39
		$this->_39->CellCssStyle = "white-space: nowrap;";

		// 40
		$this->_40->CellCssStyle = "white-space: nowrap;";

		// 41
		$this->_41->CellCssStyle = "white-space: nowrap;";

		// 42
		$this->_42->CellCssStyle = "white-space: nowrap;";

		// 43
		$this->_43->CellCssStyle = "white-space: nowrap;";

		// 44
		$this->_44->CellCssStyle = "white-space: nowrap;";

		// 45
		$this->_45->CellCssStyle = "white-space: nowrap;";

		// 46
		$this->_46->CellCssStyle = "white-space: nowrap;";

		// 47
		$this->_47->CellCssStyle = "white-space: nowrap;";

		// 48
		$this->_48->CellCssStyle = "white-space: nowrap;";

		// 49
		$this->_49->CellCssStyle = "white-space: nowrap;";

		// 50
		$this->_50->CellCssStyle = "white-space: nowrap;";

		// packing_type
		$this->packing_type->CellCssStyle = "white-space: nowrap;";

		// qc_weaving
		$this->qc_weaving->CellCssStyle = "white-space: nowrap;";

		// p_remarks
		// roll_no_qty_tmp
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pid
		$this->pid->ViewValue = $this->pid->CurrentValue;
		$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
		$this->pid->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// design_id
		if ($this->design_id->VirtualValue <> "") {
			$this->design_id->ViewValue = $this->design_id->VirtualValue;
		} else {
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->ViewValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->ViewValue = NULL;
		}
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// process_d
		$curVal = strval($this->process_d->CurrentValue);
		if ($curVal <> "") {
			$this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
			if ($this->process_d->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_d->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_d->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process_d->ViewValue = $this->process_d->CurrentValue;
				}
			}
		} else {
			$this->process_d->ViewValue = NULL;
		}
		$this->process_d->ViewCustomAttributes = "";

		// buyer_ref
		if ($this->buyer_ref->VirtualValue <> "") {
			$this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
		} else {
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->ViewValue = NULL;
		}
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// order_date
		$this->order_date->ViewValue = $this->order_date->CurrentValue;
		$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
		$this->order_date->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// dispatch_week_p
		$curVal = strval($this->dispatch_week_p->CurrentValue);
		if ($curVal <> "") {
			$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
			if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
				}
			}
		} else {
			$this->dispatch_week_p->ViewValue = NULL;
		}
		$this->dispatch_week_p->ViewCustomAttributes = "";

		// loom_plan
		$this->loom_plan->ViewValue = $this->loom_plan->CurrentValue;
		$this->loom_plan->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `grp` != 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// buyers_id
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->ViewValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->ViewCustomAttributes = "";

		// buyer_loc
		$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
		$this->buyer_loc->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_u
		$this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
		$this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, 2, -2, -2, -2);
		$this->sqm_u->ViewCustomAttributes = "";

		// c_sqm
		$this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
		$this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, 2, -2, -2, -2);
		$this->c_sqm->ViewCustomAttributes = "";

		// weaving_works
		$curVal = strval($this->weaving_works->CurrentValue);
		if ($curVal <> "") {
			$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
				}
			}
		} else {
			$this->weaving_works->ViewValue = NULL;
		}
		$this->weaving_works->ViewCustomAttributes = "";

		// current_works
		$curVal = strval($this->current_works->CurrentValue);
		if ($curVal <> "") {
			$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
			if ($this->current_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->current_works->ViewValue = $this->current_works->CurrentValue;
				}
			}
		} else {
			$this->current_works->ViewValue = NULL;
		}
		$this->current_works->ViewCustomAttributes = "";

		// size_buyer
		$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$curVal = strval($this->design->CurrentValue);
		if ($curVal <> "") {
			$this->design->ViewValue = $this->design->lookupCacheOption($curVal);
			if ($this->design->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design->ViewValue = $this->design->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design->ViewValue = $this->design->CurrentValue;
				}
			}
		} else {
			$this->design->ViewValue = NULL;
		}
		$this->design->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 0, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// l_cm
		$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
		$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 0, -2, -2, -2);
		$this->l_cm->ViewCustomAttributes = "";

		// q_sku
		$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
		$this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, 2, -2, -2, -2);
		$this->q_sku->ViewCustomAttributes = "";

		// po_price
		$this->po_price->ViewValue = $this->po_price->CurrentValue;
		$this->po_price->ViewCustomAttributes = "";

		// po_discount
		$this->po_discount->ViewValue = $this->po_discount->CurrentValue;
		$this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, 2, -2, -2, -2);
		$this->po_discount->ViewCustomAttributes = "";

		// po_currency
		$curVal = strval($this->po_currency->CurrentValue);
		if ($curVal <> "") {
			$this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
			if ($this->po_currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->po_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po_currency->ViewValue = $this->po_currency->CurrentValue;
				}
			}
		} else {
			$this->po_currency->ViewValue = NULL;
		}
		$this->po_currency->ViewCustomAttributes = "";

		// product_type
		if (strval($this->product_type->CurrentValue) <> "") {
			$this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
		} else {
			$this->product_type->ViewValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->ViewValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// payment_plan
		$curVal = strval($this->payment_plan->CurrentValue);
		if ($curVal <> "") {
			$this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
			if ($this->payment_plan->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->payment_plan->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->payment_plan->ViewValue = $this->payment_plan->CurrentValue;
				}
			}
		} else {
			$this->payment_plan->ViewValue = NULL;
		}
		$this->payment_plan->ViewCustomAttributes = "";

		// production_plan
		if (strval($this->production_plan->CurrentValue) <> "") {
			$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
		} else {
			$this->production_plan->ViewValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// completed
		if (strval($this->completed->CurrentValue) <> "") {
			$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
		} else {
			$this->completed->ViewValue = NULL;
		}
		$this->completed->ViewCustomAttributes = "";

		// buyer_po
		$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
		$this->jc_no->ViewCustomAttributes = "";

		// sqm_a
		$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
		$this->sqm_a->ViewCustomAttributes = "";

		// 2srm
		$this->_2srm->ViewValue = $this->_2srm->CurrentValue;
		$this->_2srm->ViewValue = FormatNumber($this->_2srm->ViewValue, 2, -2, -2, -2);
		$this->_2srm->ViewCustomAttributes = "";

		// 2srm_a
		$this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
		$this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, 2, -2, -2, -2);
		$this->_2srm_a->ViewCustomAttributes = "";

		// 4srm
		$this->_4srm->ViewValue = $this->_4srm->CurrentValue;
		$this->_4srm->ViewValue = FormatNumber($this->_4srm->ViewValue, 2, -2, -2, -2);
		$this->_4srm->ViewCustomAttributes = "";

		// 4srm_a
		$this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
		$this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, 2, -2, -2, -2);
		$this->_4srm_a->ViewCustomAttributes = "";

		// buyer_tid
		$this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;
		$this->buyer_tid->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// cs
		if (strval($this->cs->CurrentValue) <> "") {
			$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
		} else {
			$this->cs->ViewValue = NULL;
		}
		$this->cs->ViewCustomAttributes = "";

		// process
		$curVal = strval($this->process->CurrentValue);
		if ($curVal <> "") {
			$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
			if ($this->process->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process->ViewValue->add($this->process->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process->ViewValue = $this->process->CurrentValue;
				}
			}
		} else {
			$this->process->ViewValue = NULL;
		}
		$this->process->ViewCustomAttributes = "";

		// process_c
		$curVal = strval($this->process_c->CurrentValue);
		if ($curVal <> "") {
			$this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
			if ($this->process_c->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_c->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->process_c->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->process_c->ViewValue = $this->process_c->CurrentValue;
				}
			}
		} else {
			$this->process_c->ViewValue = NULL;
		}
		$this->process_c->ViewCustomAttributes = "";

		// weight
		$this->weight->ViewValue = $this->weight->CurrentValue;
		$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
		$this->weight->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// roll_no
		$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
		$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
		$this->roll_no->ViewCustomAttributes = "";

		// qty
		$this->qty->ViewValue = $this->qty->CurrentValue;
		$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
		$this->qty->ViewCustomAttributes = "";

		// pl_no
		$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
		$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
		$this->pl_no->ViewCustomAttributes = "";

		// category
		$curVal = strval($this->category->CurrentValue);
		if ($curVal <> "") {
			$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			if ($this->category->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->category->ViewValue = $this->category->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->category->ViewValue = $this->category->CurrentValue;
				}
			}
		} else {
			$this->category->ViewValue = NULL;
		}
		$this->category->ViewCustomAttributes = "";

		// pp_id
		$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
		$curVal = strval($this->pp_id->CurrentValue);
		if ($curVal <> "") {
			$this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
			if ($this->pp_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
				}
			}
		} else {
			$this->pp_id->ViewValue = NULL;
		}
		$this->pp_id->ViewCustomAttributes = "";

		// consignee
		$this->consignee->ViewValue = $this->consignee->CurrentValue;
		$this->consignee->ViewValue = FormatNumber($this->consignee->ViewValue, 0, -2, -2, -2);
		$this->consignee->ViewCustomAttributes = "";

		// buyer_barcode
		$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
		$this->buyer_barcode->ViewCustomAttributes = "";

		// design_next
		$this->design_next->ViewValue = $this->design_next->CurrentValue;
		$this->design_next->ViewCustomAttributes = "";

		// 11
		$this->_11->ViewValue = $this->_11->CurrentValue;
		$this->_11->ViewCustomAttributes = "";

		// 12
		$this->_12->ViewValue = $this->_12->CurrentValue;
		$this->_12->ViewCustomAttributes = "";

		// 13
		$this->_13->ViewValue = $this->_13->CurrentValue;
		$this->_13->ViewCustomAttributes = "";

		// 14
		$this->_14->ViewValue = $this->_14->CurrentValue;
		$this->_14->ViewCustomAttributes = "";

		// 15
		$this->_15->ViewValue = $this->_15->CurrentValue;
		$this->_15->ViewCustomAttributes = "";

		// 16
		$this->_16->ViewValue = $this->_16->CurrentValue;
		$this->_16->ViewCustomAttributes = "";

		// 17
		$this->_17->ViewValue = $this->_17->CurrentValue;
		$this->_17->ViewCustomAttributes = "";

		// 18
		$this->_18->ViewValue = $this->_18->CurrentValue;
		$this->_18->ViewCustomAttributes = "";

		// 19
		$this->_19->ViewValue = $this->_19->CurrentValue;
		$this->_19->ViewCustomAttributes = "";

		// 20
		$this->_20->ViewValue = $this->_20->CurrentValue;
		$this->_20->ViewCustomAttributes = "";

		// 21
		$this->_21->ViewValue = $this->_21->CurrentValue;
		$this->_21->ViewCustomAttributes = "";

		// 22
		$this->_22->ViewValue = $this->_22->CurrentValue;
		$this->_22->ViewCustomAttributes = "";

		// 23
		$this->_23->ViewValue = $this->_23->CurrentValue;
		$this->_23->ViewCustomAttributes = "";

		// 24
		$this->_24->ViewValue = $this->_24->CurrentValue;
		$this->_24->ViewCustomAttributes = "";

		// 25
		$this->_25->ViewValue = $this->_25->CurrentValue;
		$this->_25->ViewCustomAttributes = "";

		// 26
		$this->_26->ViewValue = $this->_26->CurrentValue;
		$this->_26->ViewCustomAttributes = "";

		// 27
		$this->_27->ViewValue = $this->_27->CurrentValue;
		$this->_27->ViewCustomAttributes = "";

		// 28
		$this->_28->ViewValue = $this->_28->CurrentValue;
		$this->_28->ViewCustomAttributes = "";

		// 29
		$this->_29->ViewValue = $this->_29->CurrentValue;
		$this->_29->ViewCustomAttributes = "";

		// 30
		$this->_30->ViewValue = $this->_30->CurrentValue;
		$this->_30->ViewCustomAttributes = "";

		// 31
		$this->_31->ViewValue = $this->_31->CurrentValue;
		$this->_31->ViewCustomAttributes = "";

		// 32
		$this->_32->ViewValue = $this->_32->CurrentValue;
		$this->_32->ViewCustomAttributes = "";

		// 33
		$this->_33->ViewValue = $this->_33->CurrentValue;
		$this->_33->ViewCustomAttributes = "";

		// 34
		$this->_34->ViewValue = $this->_34->CurrentValue;
		$this->_34->ViewCustomAttributes = "";

		// 35
		$this->_35->ViewValue = $this->_35->CurrentValue;
		$this->_35->ViewCustomAttributes = "";

		// 36
		$this->_36->ViewValue = $this->_36->CurrentValue;
		$this->_36->ViewCustomAttributes = "";

		// 37
		$this->_37->ViewValue = $this->_37->CurrentValue;
		$this->_37->ViewCustomAttributes = "";

		// 38
		$this->_38->ViewValue = $this->_38->CurrentValue;
		$this->_38->ViewCustomAttributes = "";

		// 39
		$this->_39->ViewValue = $this->_39->CurrentValue;
		$this->_39->ViewCustomAttributes = "";

		// 40
		$this->_40->ViewValue = $this->_40->CurrentValue;
		$this->_40->ViewCustomAttributes = "";

		// 41
		$this->_41->ViewValue = $this->_41->CurrentValue;
		$this->_41->ViewCustomAttributes = "";

		// 42
		$this->_42->ViewValue = $this->_42->CurrentValue;
		$this->_42->ViewCustomAttributes = "";

		// 43
		$this->_43->ViewValue = $this->_43->CurrentValue;
		$this->_43->ViewCustomAttributes = "";

		// 44
		$this->_44->ViewValue = $this->_44->CurrentValue;
		$this->_44->ViewCustomAttributes = "";

		// 45
		$this->_45->ViewValue = $this->_45->CurrentValue;
		$this->_45->ViewCustomAttributes = "";

		// 46
		$this->_46->ViewValue = $this->_46->CurrentValue;
		$this->_46->ViewCustomAttributes = "";

		// 47
		$this->_47->ViewValue = $this->_47->CurrentValue;
		$this->_47->ViewCustomAttributes = "";

		// 48
		$this->_48->ViewValue = $this->_48->CurrentValue;
		$this->_48->ViewCustomAttributes = "";

		// 49
		$this->_49->ViewValue = $this->_49->CurrentValue;
		$this->_49->ViewCustomAttributes = "";

		// 50
		$this->_50->ViewValue = $this->_50->CurrentValue;
		$this->_50->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 0, -2, -2, -2);
		$this->packing_type->ViewCustomAttributes = "";

		// qc_weaving
		$this->qc_weaving->ViewValue = $this->qc_weaving->CurrentValue;
		$this->qc_weaving->ViewValue = FormatDateTime($this->qc_weaving->ViewValue, 0);
		$this->qc_weaving->ViewCustomAttributes = "";

		// p_remarks
		$this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
		$this->p_remarks->ViewCustomAttributes = "";

		// roll_no_qty_tmp
		$this->roll_no_qty_tmp->ViewValue = $this->roll_no_qty_tmp->CurrentValue;
		$this->roll_no_qty_tmp->ViewValue = FormatNumber($this->roll_no_qty_tmp->ViewValue, 2, -2, -2, -2);
		$this->roll_no_qty_tmp->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// pid
		$this->pid->LinkCustomAttributes = "";
		$this->pid->HrefValue = "";
		$this->pid->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->design_id->CurrentValue)) {
			$this->design_id->HrefValue = "bcodelist.php?x_design_id=" . ((!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue)) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
			$this->design_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
		} else {
			$this->design_id->HrefValue = "";
		}
		$this->design_id->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		$this->size_cm->HrefValue = "";
		$this->size_cm->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// process_d
		$this->process_d->LinkCustomAttributes = "";
		$this->process_d->HrefValue = "";
		$this->process_d->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyer_ref->CurrentValue)) {
			$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
			$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
		} else {
			$this->buyer_ref->HrefValue = "";
		}
		$this->buyer_ref->TooltipValue = "";

		// order_date
		$this->order_date->LinkCustomAttributes = "";
		$this->order_date->HrefValue = "";
		$this->order_date->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// dispatch_week_p
		$this->dispatch_week_p->LinkCustomAttributes = "";
		$this->dispatch_week_p->HrefValue = "";
		$this->dispatch_week_p->TooltipValue = "";

		// loom_plan
		$this->loom_plan->LinkCustomAttributes = "";
		$this->loom_plan->HrefValue = "";
		$this->loom_plan->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyers_id->CurrentValue)) {
			$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
			$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
		} else {
			$this->buyers_id->HrefValue = "";
		}
		$this->buyers_id->TooltipValue = "";

		// buyer_uid
		$this->buyer_uid->LinkCustomAttributes = "";
		$this->buyer_uid->HrefValue = "";
		$this->buyer_uid->TooltipValue = "";

		// buyer_loc
		$this->buyer_loc->LinkCustomAttributes = "";
		$this->buyer_loc->HrefValue = "";
		$this->buyer_loc->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// sqm_u
		$this->sqm_u->LinkCustomAttributes = "";
		$this->sqm_u->HrefValue = "";
		$this->sqm_u->TooltipValue = "";

		// c_sqm
		$this->c_sqm->LinkCustomAttributes = "";
		$this->c_sqm->HrefValue = "";
		$this->c_sqm->TooltipValue = "";

		// weaving_works
		$this->weaving_works->LinkCustomAttributes = "";
		$this->weaving_works->HrefValue = "";
		$this->weaving_works->TooltipValue = "";

		// current_works
		$this->current_works->LinkCustomAttributes = "";
		$this->current_works->HrefValue = "";
		$this->current_works->TooltipValue = "";

		// size_buyer
		$this->size_buyer->LinkCustomAttributes = "";
		$this->size_buyer->HrefValue = "";
		$this->size_buyer->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// l_cm
		$this->l_cm->LinkCustomAttributes = "";
		$this->l_cm->HrefValue = "";
		$this->l_cm->TooltipValue = "";

		// q_sku
		$this->q_sku->LinkCustomAttributes = "";
		$this->q_sku->HrefValue = "";
		$this->q_sku->TooltipValue = "";

		// po_price
		$this->po_price->LinkCustomAttributes = "";
		$this->po_price->HrefValue = "";
		$this->po_price->TooltipValue = "";

		// po_discount
		$this->po_discount->LinkCustomAttributes = "";
		$this->po_discount->HrefValue = "";
		$this->po_discount->TooltipValue = "";

		// po_currency
		$this->po_currency->LinkCustomAttributes = "";
		$this->po_currency->HrefValue = "";
		$this->po_currency->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// payment_plan
		$this->payment_plan->LinkCustomAttributes = "";
		$this->payment_plan->HrefValue = "";
		$this->payment_plan->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// completed
		$this->completed->LinkCustomAttributes = "";
		$this->completed->HrefValue = "";
		$this->completed->TooltipValue = "";

		// buyer_po
		$this->buyer_po->LinkCustomAttributes = "";
		$this->buyer_po->HrefValue = "";
		$this->buyer_po->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// sqm_a
		$this->sqm_a->LinkCustomAttributes = "";
		$this->sqm_a->HrefValue = "";
		$this->sqm_a->TooltipValue = "";

		// 2srm
		$this->_2srm->LinkCustomAttributes = "";
		$this->_2srm->HrefValue = "";
		$this->_2srm->TooltipValue = "";

		// 2srm_a
		$this->_2srm_a->LinkCustomAttributes = "";
		$this->_2srm_a->HrefValue = "";
		$this->_2srm_a->TooltipValue = "";

		// 4srm
		$this->_4srm->LinkCustomAttributes = "";
		$this->_4srm->HrefValue = "";
		$this->_4srm->TooltipValue = "";

		// 4srm_a
		$this->_4srm_a->LinkCustomAttributes = "";
		$this->_4srm_a->HrefValue = "";
		$this->_4srm_a->TooltipValue = "";

		// buyer_tid
		$this->buyer_tid->LinkCustomAttributes = "";
		$this->buyer_tid->HrefValue = "";
		$this->buyer_tid->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->batch_no->CurrentValue)) {
			$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
			$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
		} else {
			$this->batch_no->HrefValue = "";
		}
		$this->batch_no->TooltipValue = "";

		// cs
		$this->cs->LinkCustomAttributes = "";
		$this->cs->HrefValue = "";
		$this->cs->TooltipValue = "";

		// process
		$this->process->LinkCustomAttributes = "";
		$this->process->HrefValue = "";
		$this->process->TooltipValue = "";

		// process_c
		$this->process_c->LinkCustomAttributes = "";
		$this->process_c->HrefValue = "";
		$this->process_c->TooltipValue = "";

		// weight
		$this->weight->LinkCustomAttributes = "";
		$this->weight->HrefValue = "";
		$this->weight->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// roll_no
		$this->roll_no->LinkCustomAttributes = "";
		$this->roll_no->HrefValue = "";
		$this->roll_no->TooltipValue = "";

		// qty
		$this->qty->LinkCustomAttributes = "";
		$this->qty->HrefValue = "";
		$this->qty->TooltipValue = "";

		// pl_no
		$this->pl_no->LinkCustomAttributes = "";
		$this->pl_no->HrefValue = "";
		$this->pl_no->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// pp_id
		$this->pp_id->LinkCustomAttributes = "";
		$this->pp_id->HrefValue = "";
		$this->pp_id->TooltipValue = "";

		// consignee
		$this->consignee->LinkCustomAttributes = "";
		$this->consignee->HrefValue = "";
		$this->consignee->TooltipValue = "";

		// buyer_barcode
		$this->buyer_barcode->LinkCustomAttributes = "";
		$this->buyer_barcode->HrefValue = "";
		$this->buyer_barcode->TooltipValue = "";

		// design_next
		$this->design_next->LinkCustomAttributes = "";
		$this->design_next->HrefValue = "";
		$this->design_next->TooltipValue = "";

		// 11
		$this->_11->LinkCustomAttributes = "";
		$this->_11->HrefValue = "";
		$this->_11->TooltipValue = "";

		// 12
		$this->_12->LinkCustomAttributes = "";
		$this->_12->HrefValue = "";
		$this->_12->TooltipValue = "";

		// 13
		$this->_13->LinkCustomAttributes = "";
		$this->_13->HrefValue = "";
		$this->_13->TooltipValue = "";

		// 14
		$this->_14->LinkCustomAttributes = "";
		$this->_14->HrefValue = "";
		$this->_14->TooltipValue = "";

		// 15
		$this->_15->LinkCustomAttributes = "";
		$this->_15->HrefValue = "";
		$this->_15->TooltipValue = "";

		// 16
		$this->_16->LinkCustomAttributes = "";
		$this->_16->HrefValue = "";
		$this->_16->TooltipValue = "";

		// 17
		$this->_17->LinkCustomAttributes = "";
		$this->_17->HrefValue = "";
		$this->_17->TooltipValue = "";

		// 18
		$this->_18->LinkCustomAttributes = "";
		$this->_18->HrefValue = "";
		$this->_18->TooltipValue = "";

		// 19
		$this->_19->LinkCustomAttributes = "";
		$this->_19->HrefValue = "";
		$this->_19->TooltipValue = "";

		// 20
		$this->_20->LinkCustomAttributes = "";
		$this->_20->HrefValue = "";
		$this->_20->TooltipValue = "";

		// 21
		$this->_21->LinkCustomAttributes = "";
		$this->_21->HrefValue = "";
		$this->_21->TooltipValue = "";

		// 22
		$this->_22->LinkCustomAttributes = "";
		$this->_22->HrefValue = "";
		$this->_22->TooltipValue = "";

		// 23
		$this->_23->LinkCustomAttributes = "";
		$this->_23->HrefValue = "";
		$this->_23->TooltipValue = "";

		// 24
		$this->_24->LinkCustomAttributes = "";
		$this->_24->HrefValue = "";
		$this->_24->TooltipValue = "";

		// 25
		$this->_25->LinkCustomAttributes = "";
		$this->_25->HrefValue = "";
		$this->_25->TooltipValue = "";

		// 26
		$this->_26->LinkCustomAttributes = "";
		$this->_26->HrefValue = "";
		$this->_26->TooltipValue = "";

		// 27
		$this->_27->LinkCustomAttributes = "";
		$this->_27->HrefValue = "";
		$this->_27->TooltipValue = "";

		// 28
		$this->_28->LinkCustomAttributes = "";
		$this->_28->HrefValue = "";
		$this->_28->TooltipValue = "";

		// 29
		$this->_29->LinkCustomAttributes = "";
		$this->_29->HrefValue = "";
		$this->_29->TooltipValue = "";

		// 30
		$this->_30->LinkCustomAttributes = "";
		$this->_30->HrefValue = "";
		$this->_30->TooltipValue = "";

		// 31
		$this->_31->LinkCustomAttributes = "";
		$this->_31->HrefValue = "";
		$this->_31->TooltipValue = "";

		// 32
		$this->_32->LinkCustomAttributes = "";
		$this->_32->HrefValue = "";
		$this->_32->TooltipValue = "";

		// 33
		$this->_33->LinkCustomAttributes = "";
		$this->_33->HrefValue = "";
		$this->_33->TooltipValue = "";

		// 34
		$this->_34->LinkCustomAttributes = "";
		$this->_34->HrefValue = "";
		$this->_34->TooltipValue = "";

		// 35
		$this->_35->LinkCustomAttributes = "";
		$this->_35->HrefValue = "";
		$this->_35->TooltipValue = "";

		// 36
		$this->_36->LinkCustomAttributes = "";
		$this->_36->HrefValue = "";
		$this->_36->TooltipValue = "";

		// 37
		$this->_37->LinkCustomAttributes = "";
		$this->_37->HrefValue = "";
		$this->_37->TooltipValue = "";

		// 38
		$this->_38->LinkCustomAttributes = "";
		$this->_38->HrefValue = "";
		$this->_38->TooltipValue = "";

		// 39
		$this->_39->LinkCustomAttributes = "";
		$this->_39->HrefValue = "";
		$this->_39->TooltipValue = "";

		// 40
		$this->_40->LinkCustomAttributes = "";
		$this->_40->HrefValue = "";
		$this->_40->TooltipValue = "";

		// 41
		$this->_41->LinkCustomAttributes = "";
		$this->_41->HrefValue = "";
		$this->_41->TooltipValue = "";

		// 42
		$this->_42->LinkCustomAttributes = "";
		$this->_42->HrefValue = "";
		$this->_42->TooltipValue = "";

		// 43
		$this->_43->LinkCustomAttributes = "";
		$this->_43->HrefValue = "";
		$this->_43->TooltipValue = "";

		// 44
		$this->_44->LinkCustomAttributes = "";
		$this->_44->HrefValue = "";
		$this->_44->TooltipValue = "";

		// 45
		$this->_45->LinkCustomAttributes = "";
		$this->_45->HrefValue = "";
		$this->_45->TooltipValue = "";

		// 46
		$this->_46->LinkCustomAttributes = "";
		$this->_46->HrefValue = "";
		$this->_46->TooltipValue = "";

		// 47
		$this->_47->LinkCustomAttributes = "";
		$this->_47->HrefValue = "";
		$this->_47->TooltipValue = "";

		// 48
		$this->_48->LinkCustomAttributes = "";
		$this->_48->HrefValue = "";
		$this->_48->TooltipValue = "";

		// 49
		$this->_49->LinkCustomAttributes = "";
		$this->_49->HrefValue = "";
		$this->_49->TooltipValue = "";

		// 50
		$this->_50->LinkCustomAttributes = "";
		$this->_50->HrefValue = "";
		$this->_50->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// qc_weaving
		$this->qc_weaving->LinkCustomAttributes = "";
		$this->qc_weaving->HrefValue = "";
		$this->qc_weaving->TooltipValue = "";

		// p_remarks
		$this->p_remarks->LinkCustomAttributes = "";
		$this->p_remarks->HrefValue = "";
		$this->p_remarks->TooltipValue = "";

		// roll_no_qty_tmp
		$this->roll_no_qty_tmp->LinkCustomAttributes = "";
		$this->roll_no_qty_tmp->HrefValue = "";
		$this->roll_no_qty_tmp->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pid
		$this->pid->EditAttrs["class"] = "form-control";
		$this->pid->EditCustomAttributes = "";
		$this->pid->EditValue = $this->pid->CurrentValue;
		$this->pid->EditValue = FormatNumber($this->pid->EditValue, 0, -2, -2, -2);
		$this->pid->ViewCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";
		if ($this->design_id->VirtualValue <> "") {
			$this->design_id->EditValue = $this->design_id->VirtualValue;
		} else {
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->EditValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->EditValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->EditValue = NULL;
		}
		}
		$this->design_id->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// process_d
		$this->process_d->EditCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		if ($this->buyer_ref->VirtualValue <> "") {
			$this->buyer_ref->EditValue = $this->buyer_ref->VirtualValue;
		} else {
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->EditValue = NULL;
		}
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// order_date
		$this->order_date->EditAttrs["class"] = "form-control";
		$this->order_date->EditCustomAttributes = "";
		$this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, 8);
		$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->EditValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";

		// dispatch_week_p
		$this->dispatch_week_p->EditAttrs["class"] = "form-control";
		$this->dispatch_week_p->EditCustomAttributes = "";
		$curVal = strval($this->dispatch_week_p->CurrentValue);
		if ($curVal <> "") {
			$this->dispatch_week_p->EditValue = $this->dispatch_week_p->lookupCacheOption($curVal);
			if ($this->dispatch_week_p->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->dispatch_week_p->EditValue = $this->dispatch_week_p->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->dispatch_week_p->EditValue = $this->dispatch_week_p->CurrentValue;
				}
			}
		} else {
			$this->dispatch_week_p->EditValue = NULL;
		}
		$this->dispatch_week_p->ViewCustomAttributes = "";

		// loom_plan
		$this->loom_plan->EditAttrs["class"] = "form-control";
		$this->loom_plan->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->loom_plan->CurrentValue = HtmlDecode($this->loom_plan->CurrentValue);
		$this->loom_plan->EditValue = $this->loom_plan->CurrentValue;
		$this->loom_plan->PlaceHolder = RemoveHtml($this->loom_plan->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->EditValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->EditAttrs["class"] = "form-control";
		$this->buyer_uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
		$this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

		// buyer_loc
		$this->buyer_loc->EditAttrs["class"] = "form-control";
		$this->buyer_loc->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
		$this->buyer_loc->EditValue = $this->buyer_loc->CurrentValue;
		$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_u
		$this->sqm_u->EditAttrs["class"] = "form-control";
		$this->sqm_u->EditCustomAttributes = "";
		$this->sqm_u->EditValue = $this->sqm_u->CurrentValue;
		$this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());
		if (strval($this->sqm_u->EditValue) <> "" && is_numeric($this->sqm_u->EditValue))
			$this->sqm_u->EditValue = FormatNumber($this->sqm_u->EditValue, -2, -2, -2, -2);

		// c_sqm
		$this->c_sqm->EditAttrs["class"] = "form-control";
		$this->c_sqm->EditCustomAttributes = "";
		$this->c_sqm->EditValue = $this->c_sqm->CurrentValue;
		$this->c_sqm->PlaceHolder = RemoveHtml($this->c_sqm->caption());
		if (strval($this->c_sqm->EditValue) <> "" && is_numeric($this->c_sqm->EditValue))
			$this->c_sqm->EditValue = FormatNumber($this->c_sqm->EditValue, -2, -2, -2, -2);

		// weaving_works
		$this->weaving_works->EditAttrs["class"] = "form-control";
		$this->weaving_works->EditCustomAttributes = "";

		// current_works
		$this->current_works->EditAttrs["class"] = "form-control";
		$this->current_works->EditCustomAttributes = "";

		// size_buyer
		$this->size_buyer->EditAttrs["class"] = "form-control";
		$this->size_buyer->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size_buyer->CurrentValue = HtmlDecode($this->size_buyer->CurrentValue);
		$this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->PlaceHolder = RemoveHtml($this->design->caption());

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = "";
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

		// l_cm
		$this->l_cm->EditAttrs["class"] = "form-control";
		$this->l_cm->EditCustomAttributes = "";
		$this->l_cm->EditValue = $this->l_cm->CurrentValue;
		$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

		// q_sku
		$this->q_sku->EditAttrs["class"] = "form-control";
		$this->q_sku->EditCustomAttributes = "";
		$this->q_sku->EditValue = $this->q_sku->CurrentValue;
		$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
		if (strval($this->q_sku->EditValue) <> "" && is_numeric($this->q_sku->EditValue))
			$this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, -2, -2, -2, -2);

		// po_price
		$this->po_price->EditAttrs["class"] = "form-control";
		$this->po_price->EditCustomAttributes = "";
		$this->po_price->EditValue = $this->po_price->CurrentValue;
		$this->po_price->ViewCustomAttributes = "";

		// po_discount
		$this->po_discount->EditAttrs["class"] = "form-control";
		$this->po_discount->EditCustomAttributes = "";
		$this->po_discount->EditValue = $this->po_discount->CurrentValue;
		$this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
		if (strval($this->po_discount->EditValue) <> "" && is_numeric($this->po_discount->EditValue))
			$this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, -2, -2, -2, -2);

		// po_currency
		$this->po_currency->EditAttrs["class"] = "form-control";
		$this->po_currency->EditCustomAttributes = "";
		$curVal = strval($this->po_currency->CurrentValue);
		if ($curVal <> "") {
			$this->po_currency->EditValue = $this->po_currency->lookupCacheOption($curVal);
			if ($this->po_currency->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->po_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->po_currency->EditValue = $this->po_currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->po_currency->EditValue = $this->po_currency->CurrentValue;
				}
			}
		} else {
			$this->po_currency->EditValue = NULL;
		}
		$this->po_currency->ViewCustomAttributes = "";

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";
		if (strval($this->product_type->CurrentValue) <> "") {
			$this->product_type->EditValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
		} else {
			$this->product_type->EditValue = NULL;
		}
		$this->product_type->ViewCustomAttributes = "";

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->EditValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->EditValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->EditValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->EditValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// payment_plan
		$this->payment_plan->EditAttrs["class"] = "form-control";
		$this->payment_plan->EditCustomAttributes = "";

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";
		$this->production_plan->EditValue = $this->production_plan->options(TRUE);

		// datetime
		// completed

		$this->completed->EditAttrs["class"] = "form-control";
		$this->completed->EditCustomAttributes = "";
		$this->completed->EditValue = $this->completed->options(TRUE);

		// buyer_po
		$this->buyer_po->EditAttrs["class"] = "form-control";
		$this->buyer_po->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
		$this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

		// operator
		// jc_no

		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// sqm_a
		$this->sqm_a->EditAttrs["class"] = "form-control";
		$this->sqm_a->EditCustomAttributes = "";
		$this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
		if (strval($this->sqm_a->EditValue) <> "" && is_numeric($this->sqm_a->EditValue))
			$this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, -2, -2, -2, -2);

		// 2srm
		$this->_2srm->EditAttrs["class"] = "form-control";
		$this->_2srm->EditCustomAttributes = "";
		$this->_2srm->EditValue = $this->_2srm->CurrentValue;
		$this->_2srm->PlaceHolder = RemoveHtml($this->_2srm->caption());
		if (strval($this->_2srm->EditValue) <> "" && is_numeric($this->_2srm->EditValue))
			$this->_2srm->EditValue = FormatNumber($this->_2srm->EditValue, -2, -2, -2, -2);

		// 2srm_a
		$this->_2srm_a->EditAttrs["class"] = "form-control";
		$this->_2srm_a->EditCustomAttributes = "";
		$this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
		$this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
		if (strval($this->_2srm_a->EditValue) <> "" && is_numeric($this->_2srm_a->EditValue))
			$this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, -2, -2, -2, -2);

		// 4srm
		$this->_4srm->EditAttrs["class"] = "form-control";
		$this->_4srm->EditCustomAttributes = "";
		$this->_4srm->EditValue = $this->_4srm->CurrentValue;
		$this->_4srm->PlaceHolder = RemoveHtml($this->_4srm->caption());
		if (strval($this->_4srm->EditValue) <> "" && is_numeric($this->_4srm->EditValue))
			$this->_4srm->EditValue = FormatNumber($this->_4srm->EditValue, -2, -2, -2, -2);

		// 4srm_a
		$this->_4srm_a->EditAttrs["class"] = "form-control";
		$this->_4srm_a->EditCustomAttributes = "";
		$this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
		$this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
		if (strval($this->_4srm_a->EditValue) <> "" && is_numeric($this->_4srm_a->EditValue))
			$this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, -2, -2, -2, -2);

		// buyer_tid
		$this->buyer_tid->EditAttrs["class"] = "form-control";
		$this->buyer_tid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_tid->CurrentValue = HtmlDecode($this->buyer_tid->CurrentValue);
		$this->buyer_tid->EditValue = $this->buyer_tid->CurrentValue;
		$this->buyer_tid->PlaceHolder = RemoveHtml($this->buyer_tid->caption());

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// cs
		$this->cs->EditAttrs["class"] = "form-control";
		$this->cs->EditCustomAttributes = "";
		$this->cs->EditValue = $this->cs->options(TRUE);

		// process
		$this->process->EditCustomAttributes = "";

		// process_c
		$this->process_c->EditCustomAttributes = "";

		// weight
		$this->weight->EditAttrs["class"] = "form-control";
		$this->weight->EditCustomAttributes = "";
		$this->weight->EditValue = $this->weight->CurrentValue;
		$this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
		if (strval($this->weight->EditValue) <> "" && is_numeric($this->weight->EditValue))
			$this->weight->EditValue = FormatNumber($this->weight->EditValue, -2, -2, -2, -2);

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// roll_no
		$this->roll_no->EditAttrs["class"] = "form-control";
		$this->roll_no->EditCustomAttributes = "";
		$this->roll_no->EditValue = $this->roll_no->CurrentValue;
		$this->roll_no->EditValue = FormatNumber($this->roll_no->EditValue, 0, -2, -2, -2);
		$this->roll_no->ViewCustomAttributes = "";

		// qty
		$this->qty->EditAttrs["class"] = "form-control";
		$this->qty->EditCustomAttributes = "";
		$this->qty->EditValue = $this->qty->CurrentValue;
		$this->qty->EditValue = FormatNumber($this->qty->EditValue, 0, -2, -2, -2);
		$this->qty->ViewCustomAttributes = "";

		// pl_no
		$this->pl_no->EditAttrs["class"] = "form-control";
		$this->pl_no->EditCustomAttributes = "";
		$this->pl_no->EditValue = $this->pl_no->CurrentValue;
		$this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, 2, -2, -2, -2);
		$this->pl_no->ViewCustomAttributes = "";

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";

		// pp_id
		$this->pp_id->EditAttrs["class"] = "form-control";
		$this->pp_id->EditCustomAttributes = "";
		$this->pp_id->EditValue = $this->pp_id->CurrentValue;
		$this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

		// consignee
		$this->consignee->EditAttrs["class"] = "form-control";
		$this->consignee->EditCustomAttributes = "";
		$this->consignee->EditValue = $this->consignee->CurrentValue;
		$this->consignee->PlaceHolder = RemoveHtml($this->consignee->caption());

		// buyer_barcode
		$this->buyer_barcode->EditAttrs["class"] = "form-control";
		$this->buyer_barcode->EditCustomAttributes = "";
		$this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;
		$this->buyer_barcode->ViewCustomAttributes = "";

		// design_next
		$this->design_next->EditAttrs["class"] = "form-control";
		$this->design_next->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design_next->CurrentValue = HtmlDecode($this->design_next->CurrentValue);
		$this->design_next->EditValue = $this->design_next->CurrentValue;
		$this->design_next->PlaceHolder = RemoveHtml($this->design_next->caption());

		// 11
		$this->_11->EditAttrs["class"] = "form-control";
		$this->_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_11->CurrentValue = HtmlDecode($this->_11->CurrentValue);
		$this->_11->EditValue = $this->_11->CurrentValue;
		$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

		// 12
		$this->_12->EditAttrs["class"] = "form-control";
		$this->_12->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_12->CurrentValue = HtmlDecode($this->_12->CurrentValue);
		$this->_12->EditValue = $this->_12->CurrentValue;
		$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

		// 13
		$this->_13->EditAttrs["class"] = "form-control";
		$this->_13->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_13->CurrentValue = HtmlDecode($this->_13->CurrentValue);
		$this->_13->EditValue = $this->_13->CurrentValue;
		$this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

		// 14
		$this->_14->EditAttrs["class"] = "form-control";
		$this->_14->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_14->CurrentValue = HtmlDecode($this->_14->CurrentValue);
		$this->_14->EditValue = $this->_14->CurrentValue;
		$this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

		// 15
		$this->_15->EditAttrs["class"] = "form-control";
		$this->_15->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_15->CurrentValue = HtmlDecode($this->_15->CurrentValue);
		$this->_15->EditValue = $this->_15->CurrentValue;
		$this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

		// 16
		$this->_16->EditAttrs["class"] = "form-control";
		$this->_16->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_16->CurrentValue = HtmlDecode($this->_16->CurrentValue);
		$this->_16->EditValue = $this->_16->CurrentValue;
		$this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

		// 17
		$this->_17->EditAttrs["class"] = "form-control";
		$this->_17->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_17->CurrentValue = HtmlDecode($this->_17->CurrentValue);
		$this->_17->EditValue = $this->_17->CurrentValue;
		$this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

		// 18
		$this->_18->EditAttrs["class"] = "form-control";
		$this->_18->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_18->CurrentValue = HtmlDecode($this->_18->CurrentValue);
		$this->_18->EditValue = $this->_18->CurrentValue;
		$this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

		// 19
		$this->_19->EditAttrs["class"] = "form-control";
		$this->_19->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_19->CurrentValue = HtmlDecode($this->_19->CurrentValue);
		$this->_19->EditValue = $this->_19->CurrentValue;
		$this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

		// 20
		$this->_20->EditAttrs["class"] = "form-control";
		$this->_20->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_20->CurrentValue = HtmlDecode($this->_20->CurrentValue);
		$this->_20->EditValue = $this->_20->CurrentValue;
		$this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

		// 21
		$this->_21->EditAttrs["class"] = "form-control";
		$this->_21->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_21->CurrentValue = HtmlDecode($this->_21->CurrentValue);
		$this->_21->EditValue = $this->_21->CurrentValue;
		$this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

		// 22
		$this->_22->EditAttrs["class"] = "form-control";
		$this->_22->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_22->CurrentValue = HtmlDecode($this->_22->CurrentValue);
		$this->_22->EditValue = $this->_22->CurrentValue;
		$this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

		// 23
		$this->_23->EditAttrs["class"] = "form-control";
		$this->_23->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_23->CurrentValue = HtmlDecode($this->_23->CurrentValue);
		$this->_23->EditValue = $this->_23->CurrentValue;
		$this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

		// 24
		$this->_24->EditAttrs["class"] = "form-control";
		$this->_24->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_24->CurrentValue = HtmlDecode($this->_24->CurrentValue);
		$this->_24->EditValue = $this->_24->CurrentValue;
		$this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

		// 25
		$this->_25->EditAttrs["class"] = "form-control";
		$this->_25->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_25->CurrentValue = HtmlDecode($this->_25->CurrentValue);
		$this->_25->EditValue = $this->_25->CurrentValue;
		$this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

		// 26
		$this->_26->EditAttrs["class"] = "form-control";
		$this->_26->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_26->CurrentValue = HtmlDecode($this->_26->CurrentValue);
		$this->_26->EditValue = $this->_26->CurrentValue;
		$this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

		// 27
		$this->_27->EditAttrs["class"] = "form-control";
		$this->_27->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_27->CurrentValue = HtmlDecode($this->_27->CurrentValue);
		$this->_27->EditValue = $this->_27->CurrentValue;
		$this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

		// 28
		$this->_28->EditAttrs["class"] = "form-control";
		$this->_28->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_28->CurrentValue = HtmlDecode($this->_28->CurrentValue);
		$this->_28->EditValue = $this->_28->CurrentValue;
		$this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

		// 29
		$this->_29->EditAttrs["class"] = "form-control";
		$this->_29->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_29->CurrentValue = HtmlDecode($this->_29->CurrentValue);
		$this->_29->EditValue = $this->_29->CurrentValue;
		$this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

		// 30
		$this->_30->EditAttrs["class"] = "form-control";
		$this->_30->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_30->CurrentValue = HtmlDecode($this->_30->CurrentValue);
		$this->_30->EditValue = $this->_30->CurrentValue;
		$this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

		// 31
		$this->_31->EditAttrs["class"] = "form-control";
		$this->_31->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_31->CurrentValue = HtmlDecode($this->_31->CurrentValue);
		$this->_31->EditValue = $this->_31->CurrentValue;
		$this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

		// 32
		$this->_32->EditAttrs["class"] = "form-control";
		$this->_32->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_32->CurrentValue = HtmlDecode($this->_32->CurrentValue);
		$this->_32->EditValue = $this->_32->CurrentValue;
		$this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

		// 33
		$this->_33->EditAttrs["class"] = "form-control";
		$this->_33->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_33->CurrentValue = HtmlDecode($this->_33->CurrentValue);
		$this->_33->EditValue = $this->_33->CurrentValue;
		$this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

		// 34
		$this->_34->EditAttrs["class"] = "form-control";
		$this->_34->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_34->CurrentValue = HtmlDecode($this->_34->CurrentValue);
		$this->_34->EditValue = $this->_34->CurrentValue;
		$this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

		// 35
		$this->_35->EditAttrs["class"] = "form-control";
		$this->_35->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_35->CurrentValue = HtmlDecode($this->_35->CurrentValue);
		$this->_35->EditValue = $this->_35->CurrentValue;
		$this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

		// 36
		$this->_36->EditAttrs["class"] = "form-control";
		$this->_36->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_36->CurrentValue = HtmlDecode($this->_36->CurrentValue);
		$this->_36->EditValue = $this->_36->CurrentValue;
		$this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

		// 37
		$this->_37->EditAttrs["class"] = "form-control";
		$this->_37->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_37->CurrentValue = HtmlDecode($this->_37->CurrentValue);
		$this->_37->EditValue = $this->_37->CurrentValue;
		$this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

		// 38
		$this->_38->EditAttrs["class"] = "form-control";
		$this->_38->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_38->CurrentValue = HtmlDecode($this->_38->CurrentValue);
		$this->_38->EditValue = $this->_38->CurrentValue;
		$this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

		// 39
		$this->_39->EditAttrs["class"] = "form-control";
		$this->_39->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_39->CurrentValue = HtmlDecode($this->_39->CurrentValue);
		$this->_39->EditValue = $this->_39->CurrentValue;
		$this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

		// 40
		$this->_40->EditAttrs["class"] = "form-control";
		$this->_40->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_40->CurrentValue = HtmlDecode($this->_40->CurrentValue);
		$this->_40->EditValue = $this->_40->CurrentValue;
		$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

		// 41
		$this->_41->EditAttrs["class"] = "form-control";
		$this->_41->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_41->CurrentValue = HtmlDecode($this->_41->CurrentValue);
		$this->_41->EditValue = $this->_41->CurrentValue;
		$this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

		// 42
		$this->_42->EditAttrs["class"] = "form-control";
		$this->_42->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_42->CurrentValue = HtmlDecode($this->_42->CurrentValue);
		$this->_42->EditValue = $this->_42->CurrentValue;
		$this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

		// 43
		$this->_43->EditAttrs["class"] = "form-control";
		$this->_43->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_43->CurrentValue = HtmlDecode($this->_43->CurrentValue);
		$this->_43->EditValue = $this->_43->CurrentValue;
		$this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

		// 44
		$this->_44->EditAttrs["class"] = "form-control";
		$this->_44->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_44->CurrentValue = HtmlDecode($this->_44->CurrentValue);
		$this->_44->EditValue = $this->_44->CurrentValue;
		$this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

		// 45
		$this->_45->EditAttrs["class"] = "form-control";
		$this->_45->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_45->CurrentValue = HtmlDecode($this->_45->CurrentValue);
		$this->_45->EditValue = $this->_45->CurrentValue;
		$this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

		// 46
		$this->_46->EditAttrs["class"] = "form-control";
		$this->_46->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_46->CurrentValue = HtmlDecode($this->_46->CurrentValue);
		$this->_46->EditValue = $this->_46->CurrentValue;
		$this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

		// 47
		$this->_47->EditAttrs["class"] = "form-control";
		$this->_47->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_47->CurrentValue = HtmlDecode($this->_47->CurrentValue);
		$this->_47->EditValue = $this->_47->CurrentValue;
		$this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

		// 48
		$this->_48->EditAttrs["class"] = "form-control";
		$this->_48->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_48->CurrentValue = HtmlDecode($this->_48->CurrentValue);
		$this->_48->EditValue = $this->_48->CurrentValue;
		$this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

		// 49
		$this->_49->EditAttrs["class"] = "form-control";
		$this->_49->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_49->CurrentValue = HtmlDecode($this->_49->CurrentValue);
		$this->_49->EditValue = $this->_49->CurrentValue;
		$this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

		// 50
		$this->_50->EditAttrs["class"] = "form-control";
		$this->_50->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_50->CurrentValue = HtmlDecode($this->_50->CurrentValue);
		$this->_50->EditValue = $this->_50->CurrentValue;
		$this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

		// qc_weaving
		$this->qc_weaving->EditAttrs["class"] = "form-control";
		$this->qc_weaving->EditCustomAttributes = "";
		$this->qc_weaving->EditValue = FormatDateTime($this->qc_weaving->CurrentValue, 8);
		$this->qc_weaving->PlaceHolder = RemoveHtml($this->qc_weaving->caption());

		// p_remarks
		$this->p_remarks->EditAttrs["class"] = "form-control";
		$this->p_remarks->EditCustomAttributes = "";
		$this->p_remarks->EditValue = $this->p_remarks->CurrentValue;
		$this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

		// roll_no_qty_tmp
		$this->roll_no_qty_tmp->EditAttrs["class"] = "form-control";
		$this->roll_no_qty_tmp->EditCustomAttributes = "";
		$this->roll_no_qty_tmp->EditValue = $this->roll_no_qty_tmp->CurrentValue;
		$this->roll_no_qty_tmp->PlaceHolder = RemoveHtml($this->roll_no_qty_tmp->caption());
		if (strval($this->roll_no_qty_tmp->EditValue) <> "" && is_numeric($this->roll_no_qty_tmp->EditValue))
			$this->roll_no_qty_tmp->EditValue = FormatNumber($this->roll_no_qty_tmp->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pid);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->process_d);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->dispatch_week_p);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->buyer_uid);
					$doc->exportCaption($this->buyer_loc);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->sqm_u);
					$doc->exportCaption($this->c_sqm);
					$doc->exportCaption($this->q_sku);
					$doc->exportCaption($this->po_price);
					$doc->exportCaption($this->po_discount);
					$doc->exportCaption($this->po_currency);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->payment_plan);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->completed);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->sqm_a);
					$doc->exportCaption($this->_2srm);
					$doc->exportCaption($this->_2srm_a);
					$doc->exportCaption($this->_4srm);
					$doc->exportCaption($this->_4srm_a);
					$doc->exportCaption($this->buyer_tid);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->cs);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->process_c);
					$doc->exportCaption($this->weight);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->roll_no);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->pp_id);
					$doc->exportCaption($this->_11);
					$doc->exportCaption($this->_12);
					$doc->exportCaption($this->_13);
					$doc->exportCaption($this->_14);
					$doc->exportCaption($this->_15);
					$doc->exportCaption($this->_16);
					$doc->exportCaption($this->_17);
					$doc->exportCaption($this->_18);
					$doc->exportCaption($this->_19);
					$doc->exportCaption($this->_20);
					$doc->exportCaption($this->_21);
					$doc->exportCaption($this->_22);
					$doc->exportCaption($this->_23);
					$doc->exportCaption($this->_24);
					$doc->exportCaption($this->_25);
					$doc->exportCaption($this->_26);
					$doc->exportCaption($this->_27);
					$doc->exportCaption($this->_28);
					$doc->exportCaption($this->_29);
					$doc->exportCaption($this->_30);
					$doc->exportCaption($this->_31);
					$doc->exportCaption($this->_32);
					$doc->exportCaption($this->_33);
					$doc->exportCaption($this->_34);
					$doc->exportCaption($this->_35);
					$doc->exportCaption($this->_36);
					$doc->exportCaption($this->_37);
					$doc->exportCaption($this->_38);
					$doc->exportCaption($this->_39);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->_41);
					$doc->exportCaption($this->_42);
					$doc->exportCaption($this->_43);
					$doc->exportCaption($this->_44);
					$doc->exportCaption($this->_45);
					$doc->exportCaption($this->_46);
					$doc->exportCaption($this->_47);
					$doc->exportCaption($this->_48);
					$doc->exportCaption($this->_49);
					$doc->exportCaption($this->_50);
					$doc->exportCaption($this->p_remarks);
					$doc->exportCaption($this->roll_no_qty_tmp);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pid);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->process_d);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->order_date);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->dispatch_week_p);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->buyer_uid);
					$doc->exportCaption($this->buyer_loc);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->sqm_u);
					$doc->exportCaption($this->c_sqm);
					$doc->exportCaption($this->weaving_works);
					$doc->exportCaption($this->current_works);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->q_sku);
					$doc->exportCaption($this->po_price);
					$doc->exportCaption($this->po_discount);
					$doc->exportCaption($this->po_currency);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->payment_plan);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->completed);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->cs);
					$doc->exportCaption($this->process);
					$doc->exportCaption($this->process_c);
					$doc->exportCaption($this->weight);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->roll_no);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->pl_no);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->pp_id);
					$doc->exportCaption($this->_11);
					$doc->exportCaption($this->_12);
					$doc->exportCaption($this->_13);
					$doc->exportCaption($this->_14);
					$doc->exportCaption($this->_15);
					$doc->exportCaption($this->_16);
					$doc->exportCaption($this->_17);
					$doc->exportCaption($this->_18);
					$doc->exportCaption($this->_19);
					$doc->exportCaption($this->_20);
					$doc->exportCaption($this->_21);
					$doc->exportCaption($this->_22);
					$doc->exportCaption($this->_23);
					$doc->exportCaption($this->_24);
					$doc->exportCaption($this->_25);
					$doc->exportCaption($this->_26);
					$doc->exportCaption($this->_27);
					$doc->exportCaption($this->_28);
					$doc->exportCaption($this->_29);
					$doc->exportCaption($this->_30);
					$doc->exportCaption($this->_31);
					$doc->exportCaption($this->_32);
					$doc->exportCaption($this->_33);
					$doc->exportCaption($this->_34);
					$doc->exportCaption($this->_35);
					$doc->exportCaption($this->_36);
					$doc->exportCaption($this->_37);
					$doc->exportCaption($this->_38);
					$doc->exportCaption($this->_39);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->_41);
					$doc->exportCaption($this->_42);
					$doc->exportCaption($this->_43);
					$doc->exportCaption($this->_44);
					$doc->exportCaption($this->_45);
					$doc->exportCaption($this->_46);
					$doc->exportCaption($this->_47);
					$doc->exportCaption($this->_48);
					$doc->exportCaption($this->_49);
					$doc->exportCaption($this->_50);
					$doc->exportCaption($this->roll_no_qty_tmp);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->pid);
						$doc->exportField($this->po);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->process_d);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->order_date);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->dispatch_week_p);
						$doc->exportField($this->status);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->buyer_uid);
						$doc->exportField($this->buyer_loc);
						$doc->exportField($this->quantity);
						$doc->exportField($this->sqm);
						$doc->exportField($this->sqm_u);
						$doc->exportField($this->c_sqm);
						$doc->exportField($this->q_sku);
						$doc->exportField($this->po_price);
						$doc->exportField($this->po_discount);
						$doc->exportField($this->po_currency);
						$doc->exportField($this->product_type);
						$doc->exportField($this->shape);
						$doc->exportField($this->payment_plan);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->datetime);
						$doc->exportField($this->completed);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->operator);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->sqm_a);
						$doc->exportField($this->_2srm);
						$doc->exportField($this->_2srm_a);
						$doc->exportField($this->_4srm);
						$doc->exportField($this->_4srm_a);
						$doc->exportField($this->buyer_tid);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->cs);
						$doc->exportField($this->process);
						$doc->exportField($this->process_c);
						$doc->exportField($this->weight);
						$doc->exportField($this->remarks);
						$doc->exportField($this->roll_no);
						$doc->exportField($this->qty);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->category);
						$doc->exportField($this->pp_id);
						$doc->exportField($this->_11);
						$doc->exportField($this->_12);
						$doc->exportField($this->_13);
						$doc->exportField($this->_14);
						$doc->exportField($this->_15);
						$doc->exportField($this->_16);
						$doc->exportField($this->_17);
						$doc->exportField($this->_18);
						$doc->exportField($this->_19);
						$doc->exportField($this->_20);
						$doc->exportField($this->_21);
						$doc->exportField($this->_22);
						$doc->exportField($this->_23);
						$doc->exportField($this->_24);
						$doc->exportField($this->_25);
						$doc->exportField($this->_26);
						$doc->exportField($this->_27);
						$doc->exportField($this->_28);
						$doc->exportField($this->_29);
						$doc->exportField($this->_30);
						$doc->exportField($this->_31);
						$doc->exportField($this->_32);
						$doc->exportField($this->_33);
						$doc->exportField($this->_34);
						$doc->exportField($this->_35);
						$doc->exportField($this->_36);
						$doc->exportField($this->_37);
						$doc->exportField($this->_38);
						$doc->exportField($this->_39);
						$doc->exportField($this->_40);
						$doc->exportField($this->_41);
						$doc->exportField($this->_42);
						$doc->exportField($this->_43);
						$doc->exportField($this->_44);
						$doc->exportField($this->_45);
						$doc->exportField($this->_46);
						$doc->exportField($this->_47);
						$doc->exportField($this->_48);
						$doc->exportField($this->_49);
						$doc->exportField($this->_50);
						$doc->exportField($this->p_remarks);
						$doc->exportField($this->roll_no_qty_tmp);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->pid);
						$doc->exportField($this->po);
						$doc->exportField($this->design_id);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->process_d);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->order_date);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->dispatch_week_p);
						$doc->exportField($this->status);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->buyer_uid);
						$doc->exportField($this->buyer_loc);
						$doc->exportField($this->quantity);
						$doc->exportField($this->sqm);
						$doc->exportField($this->sqm_u);
						$doc->exportField($this->c_sqm);
						$doc->exportField($this->weaving_works);
						$doc->exportField($this->current_works);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->q_sku);
						$doc->exportField($this->po_price);
						$doc->exportField($this->po_discount);
						$doc->exportField($this->po_currency);
						$doc->exportField($this->product_type);
						$doc->exportField($this->shape);
						$doc->exportField($this->payment_plan);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->datetime);
						$doc->exportField($this->completed);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->operator);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->cs);
						$doc->exportField($this->process);
						$doc->exportField($this->process_c);
						$doc->exportField($this->weight);
						$doc->exportField($this->remarks);
						$doc->exportField($this->roll_no);
						$doc->exportField($this->qty);
						$doc->exportField($this->pl_no);
						$doc->exportField($this->category);
						$doc->exportField($this->pp_id);
						$doc->exportField($this->_11);
						$doc->exportField($this->_12);
						$doc->exportField($this->_13);
						$doc->exportField($this->_14);
						$doc->exportField($this->_15);
						$doc->exportField($this->_16);
						$doc->exportField($this->_17);
						$doc->exportField($this->_18);
						$doc->exportField($this->_19);
						$doc->exportField($this->_20);
						$doc->exportField($this->_21);
						$doc->exportField($this->_22);
						$doc->exportField($this->_23);
						$doc->exportField($this->_24);
						$doc->exportField($this->_25);
						$doc->exportField($this->_26);
						$doc->exportField($this->_27);
						$doc->exportField($this->_28);
						$doc->exportField($this->_29);
						$doc->exportField($this->_30);
						$doc->exportField($this->_31);
						$doc->exportField($this->_32);
						$doc->exportField($this->_33);
						$doc->exportField($this->_34);
						$doc->exportField($this->_35);
						$doc->exportField($this->_36);
						$doc->exportField($this->_37);
						$doc->exportField($this->_38);
						$doc->exportField($this->_39);
						$doc->exportField($this->_40);
						$doc->exportField($this->_41);
						$doc->exportField($this->_42);
						$doc->exportField($this->_43);
						$doc->exportField($this->_44);
						$doc->exportField($this->_45);
						$doc->exportField($this->_46);
						$doc->exportField($this->_47);
						$doc->exportField($this->_48);
						$doc->exportField($this->_49);
						$doc->exportField($this->_50);
						$doc->exportField($this->roll_no_qty_tmp);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'bcode';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'bcode';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'bcode';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'bcode';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>