<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class bcode_edit extends bcode
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'bcode';

	// Page object name
	public $PageObjName = "bcode_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (bcode)
		if (!isset($GLOBALS["bcode"]) || get_class($GLOBALS["bcode"]) == PROJECT_NAMESPACE . "bcode") {
			$GLOBALS["bcode"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bcode"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $bcode;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($bcode);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "bcodeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("bcodelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->pid->Visible = FALSE;
		$this->po->setVisibility();
		$this->design_id->setVisibility();
		$this->size_cm->setVisibility();
		$this->_barcode->setVisibility();
		$this->process_d->Visible = FALSE;
		$this->buyer_ref->setVisibility();
		$this->order_date->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->dispatch_week_p->setVisibility();
		$this->loom_plan->Visible = FALSE;
		$this->status->setVisibility();
		$this->buyers_id->setVisibility();
		$this->buyer_uid->setVisibility();
		$this->buyer_loc->setVisibility();
		$this->quantity->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_u->setVisibility();
		$this->c_sqm->setVisibility();
		$this->weaving_works->setVisibility();
		$this->current_works->setVisibility();
		$this->size_buyer->setVisibility();
		$this->design->Visible = FALSE;
		$this->w_cm->setVisibility();
		$this->l_cm->setVisibility();
		$this->q_sku->setVisibility();
		$this->po_price->setVisibility();
		$this->po_discount->setVisibility();
		$this->po_currency->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->payment_plan->Visible = FALSE;
		$this->production_plan->setVisibility();
		$this->datetime->setVisibility();
		$this->completed->setVisibility();
		$this->buyer_po->setVisibility();
		$this->operator->setVisibility();
		$this->jc_no->setVisibility();
		$this->sqm_a->Visible = FALSE;
		$this->_2srm->Visible = FALSE;
		$this->_2srm_a->Visible = FALSE;
		$this->_4srm->Visible = FALSE;
		$this->_4srm_a->Visible = FALSE;
		$this->buyer_tid->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->batch_no->setVisibility();
		$this->cs->setVisibility();
		$this->process->Visible = FALSE;
		$this->process_c->Visible = FALSE;
		$this->weight->setVisibility();
		$this->remarks->setVisibility();
		$this->roll_no->setVisibility();
		$this->qty->setVisibility();
		$this->pl_no->setVisibility();
		$this->category->setVisibility();
		$this->pp_id->setVisibility();
		$this->consignee->Visible = FALSE;
		$this->buyer_barcode->setVisibility();
		$this->design_next->Visible = FALSE;
		$this->_11->Visible = FALSE;
		$this->_12->Visible = FALSE;
		$this->_13->Visible = FALSE;
		$this->_14->Visible = FALSE;
		$this->_15->Visible = FALSE;
		$this->_16->Visible = FALSE;
		$this->_17->Visible = FALSE;
		$this->_18->Visible = FALSE;
		$this->_19->Visible = FALSE;
		$this->_20->Visible = FALSE;
		$this->_21->Visible = FALSE;
		$this->_22->Visible = FALSE;
		$this->_23->Visible = FALSE;
		$this->_24->Visible = FALSE;
		$this->_25->Visible = FALSE;
		$this->_26->Visible = FALSE;
		$this->_27->Visible = FALSE;
		$this->_28->Visible = FALSE;
		$this->_29->Visible = FALSE;
		$this->_30->Visible = FALSE;
		$this->_31->Visible = FALSE;
		$this->_32->Visible = FALSE;
		$this->_33->Visible = FALSE;
		$this->_34->Visible = FALSE;
		$this->_35->Visible = FALSE;
		$this->_36->Visible = FALSE;
		$this->_37->Visible = FALSE;
		$this->_38->Visible = FALSE;
		$this->_39->Visible = FALSE;
		$this->_40->Visible = FALSE;
		$this->_41->Visible = FALSE;
		$this->_42->Visible = FALSE;
		$this->_43->Visible = FALSE;
		$this->_44->Visible = FALSE;
		$this->_45->Visible = FALSE;
		$this->_46->Visible = FALSE;
		$this->_47->Visible = FALSE;
		$this->_48->Visible = FALSE;
		$this->_49->Visible = FALSE;
		$this->_50->Visible = FALSE;
		$this->packing_type->Visible = FALSE;
		$this->qc_weaving->Visible = FALSE;
		$this->p_remarks->setVisibility();
		$this->roll_no_qty_tmp->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->po->Required = FALSE;
		$this->design_id->Required = FALSE;
		$this->size_cm->Required = FALSE;
		$this->_barcode->Required = FALSE;
		$this->quantity->Required = FALSE;
		$this->sqm->Required = FALSE;
		$this->product_type->Required = FALSE;
		$this->shape->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->process_d);
		$this->setupLookupOptions($this->buyer_ref);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->dispatch_week_p);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->design);
		$this->setupLookupOptions($this->po_currency);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->payment_plan);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_c);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->pp_id);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("bcodelist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "bcodelist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po->Visible = FALSE; // Disable update for API request
			else
				$this->po->setFormValue($val);
		}

		// Check field name 'design_id' first before field var 'x_design_id'
		$val = $CurrentForm->hasValue("design_id") ? $CurrentForm->getValue("design_id") : $CurrentForm->getValue("x_design_id");
		if (!$this->design_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->design_id->Visible = FALSE; // Disable update for API request
			else
				$this->design_id->setFormValue($val);
		}

		// Check field name 'size_cm' first before field var 'x_size_cm'
		$val = $CurrentForm->hasValue("size_cm") ? $CurrentForm->getValue("size_cm") : $CurrentForm->getValue("x_size_cm");
		if (!$this->size_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size_cm->Visible = FALSE; // Disable update for API request
			else
				$this->size_cm->setFormValue($val);
		}

		// Check field name 'barcode' first before field var 'x__barcode'
		$val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
		if (!$this->_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->_barcode->setFormValue($val);
		}

		// Check field name 'buyer_ref' first before field var 'x_buyer_ref'
		$val = $CurrentForm->hasValue("buyer_ref") ? $CurrentForm->getValue("buyer_ref") : $CurrentForm->getValue("x_buyer_ref");
		if (!$this->buyer_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_ref->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_ref->setFormValue($val);
		}

		// Check field name 'order_date' first before field var 'x_order_date'
		$val = $CurrentForm->hasValue("order_date") ? $CurrentForm->getValue("order_date") : $CurrentForm->getValue("x_order_date");
		if (!$this->order_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->order_date->Visible = FALSE; // Disable update for API request
			else
				$this->order_date->setFormValue($val);
			$this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, 0);
		}

		// Check field name 'despatch_date' first before field var 'x_despatch_date'
		$val = $CurrentForm->hasValue("despatch_date") ? $CurrentForm->getValue("despatch_date") : $CurrentForm->getValue("x_despatch_date");
		if (!$this->despatch_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_date->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_date->setFormValue($val);
			$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		}

		// Check field name 'despatch_week' first before field var 'x_despatch_week'
		$val = $CurrentForm->hasValue("despatch_week") ? $CurrentForm->getValue("despatch_week") : $CurrentForm->getValue("x_despatch_week");
		if (!$this->despatch_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_week->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_week->setFormValue($val);
		}

		// Check field name 'dispatch_week_p' first before field var 'x_dispatch_week_p'
		$val = $CurrentForm->hasValue("dispatch_week_p") ? $CurrentForm->getValue("dispatch_week_p") : $CurrentForm->getValue("x_dispatch_week_p");
		if (!$this->dispatch_week_p->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dispatch_week_p->Visible = FALSE; // Disable update for API request
			else
				$this->dispatch_week_p->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'buyers_id' first before field var 'x_buyers_id'
		$val = $CurrentForm->hasValue("buyers_id") ? $CurrentForm->getValue("buyers_id") : $CurrentForm->getValue("x_buyers_id");
		if (!$this->buyers_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyers_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyers_id->setFormValue($val);
		}

		// Check field name 'buyer_uid' first before field var 'x_buyer_uid'
		$val = $CurrentForm->hasValue("buyer_uid") ? $CurrentForm->getValue("buyer_uid") : $CurrentForm->getValue("x_buyer_uid");
		if (!$this->buyer_uid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_uid->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_uid->setFormValue($val);
		}

		// Check field name 'buyer_loc' first before field var 'x_buyer_loc'
		$val = $CurrentForm->hasValue("buyer_loc") ? $CurrentForm->getValue("buyer_loc") : $CurrentForm->getValue("x_buyer_loc");
		if (!$this->buyer_loc->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_loc->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_loc->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'sqm' first before field var 'x_sqm'
		$val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
		if (!$this->sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm->Visible = FALSE; // Disable update for API request
			else
				$this->sqm->setFormValue($val);
		}

		// Check field name 'sqm_u' first before field var 'x_sqm_u'
		$val = $CurrentForm->hasValue("sqm_u") ? $CurrentForm->getValue("sqm_u") : $CurrentForm->getValue("x_sqm_u");
		if (!$this->sqm_u->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sqm_u->Visible = FALSE; // Disable update for API request
			else
				$this->sqm_u->setFormValue($val);
		}

		// Check field name 'c_sqm' first before field var 'x_c_sqm'
		$val = $CurrentForm->hasValue("c_sqm") ? $CurrentForm->getValue("c_sqm") : $CurrentForm->getValue("x_c_sqm");
		if (!$this->c_sqm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->c_sqm->Visible = FALSE; // Disable update for API request
			else
				$this->c_sqm->setFormValue($val);
		}

		// Check field name 'weaving_works' first before field var 'x_weaving_works'
		$val = $CurrentForm->hasValue("weaving_works") ? $CurrentForm->getValue("weaving_works") : $CurrentForm->getValue("x_weaving_works");
		if (!$this->weaving_works->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weaving_works->Visible = FALSE; // Disable update for API request
			else
				$this->weaving_works->setFormValue($val);
		}

		// Check field name 'current_works' first before field var 'x_current_works'
		$val = $CurrentForm->hasValue("current_works") ? $CurrentForm->getValue("current_works") : $CurrentForm->getValue("x_current_works");
		if (!$this->current_works->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->current_works->Visible = FALSE; // Disable update for API request
			else
				$this->current_works->setFormValue($val);
		}

		// Check field name 'size_buyer' first before field var 'x_size_buyer'
		$val = $CurrentForm->hasValue("size_buyer") ? $CurrentForm->getValue("size_buyer") : $CurrentForm->getValue("x_size_buyer");
		if (!$this->size_buyer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size_buyer->Visible = FALSE; // Disable update for API request
			else
				$this->size_buyer->setFormValue($val);
		}

		// Check field name 'w_cm' first before field var 'x_w_cm'
		$val = $CurrentForm->hasValue("w_cm") ? $CurrentForm->getValue("w_cm") : $CurrentForm->getValue("x_w_cm");
		if (!$this->w_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->w_cm->Visible = FALSE; // Disable update for API request
			else
				$this->w_cm->setFormValue($val);
		}

		// Check field name 'l_cm' first before field var 'x_l_cm'
		$val = $CurrentForm->hasValue("l_cm") ? $CurrentForm->getValue("l_cm") : $CurrentForm->getValue("x_l_cm");
		if (!$this->l_cm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->l_cm->Visible = FALSE; // Disable update for API request
			else
				$this->l_cm->setFormValue($val);
		}

		// Check field name 'q_sku' first before field var 'x_q_sku'
		$val = $CurrentForm->hasValue("q_sku") ? $CurrentForm->getValue("q_sku") : $CurrentForm->getValue("x_q_sku");
		if (!$this->q_sku->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->q_sku->Visible = FALSE; // Disable update for API request
			else
				$this->q_sku->setFormValue($val);
		}

		// Check field name 'po_price' first before field var 'x_po_price'
		$val = $CurrentForm->hasValue("po_price") ? $CurrentForm->getValue("po_price") : $CurrentForm->getValue("x_po_price");
		if (!$this->po_price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_price->Visible = FALSE; // Disable update for API request
			else
				$this->po_price->setFormValue($val);
		}

		// Check field name 'po_discount' first before field var 'x_po_discount'
		$val = $CurrentForm->hasValue("po_discount") ? $CurrentForm->getValue("po_discount") : $CurrentForm->getValue("x_po_discount");
		if (!$this->po_discount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_discount->Visible = FALSE; // Disable update for API request
			else
				$this->po_discount->setFormValue($val);
		}

		// Check field name 'po_currency' first before field var 'x_po_currency'
		$val = $CurrentForm->hasValue("po_currency") ? $CurrentForm->getValue("po_currency") : $CurrentForm->getValue("x_po_currency");
		if (!$this->po_currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_currency->Visible = FALSE; // Disable update for API request
			else
				$this->po_currency->setFormValue($val);
		}

		// Check field name 'product_type' first before field var 'x_product_type'
		$val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
		if (!$this->product_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_type->Visible = FALSE; // Disable update for API request
			else
				$this->product_type->setFormValue($val);
		}

		// Check field name 'shape' first before field var 'x_shape'
		$val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
		if (!$this->shape->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shape->Visible = FALSE; // Disable update for API request
			else
				$this->shape->setFormValue($val);
		}

		// Check field name 'production_plan' first before field var 'x_production_plan'
		$val = $CurrentForm->hasValue("production_plan") ? $CurrentForm->getValue("production_plan") : $CurrentForm->getValue("x_production_plan");
		if (!$this->production_plan->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->production_plan->Visible = FALSE; // Disable update for API request
			else
				$this->production_plan->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'completed' first before field var 'x_completed'
		$val = $CurrentForm->hasValue("completed") ? $CurrentForm->getValue("completed") : $CurrentForm->getValue("x_completed");
		if (!$this->completed->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->completed->Visible = FALSE; // Disable update for API request
			else
				$this->completed->setFormValue($val);
		}

		// Check field name 'buyer_po' first before field var 'x_buyer_po'
		$val = $CurrentForm->hasValue("buyer_po") ? $CurrentForm->getValue("buyer_po") : $CurrentForm->getValue("x_buyer_po");
		if (!$this->buyer_po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_po->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_po->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'cs' first before field var 'x_cs'
		$val = $CurrentForm->hasValue("cs") ? $CurrentForm->getValue("cs") : $CurrentForm->getValue("x_cs");
		if (!$this->cs->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cs->Visible = FALSE; // Disable update for API request
			else
				$this->cs->setFormValue($val);
		}

		// Check field name 'weight' first before field var 'x_weight'
		$val = $CurrentForm->hasValue("weight") ? $CurrentForm->getValue("weight") : $CurrentForm->getValue("x_weight");
		if (!$this->weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->weight->Visible = FALSE; // Disable update for API request
			else
				$this->weight->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'roll_no' first before field var 'x_roll_no'
		$val = $CurrentForm->hasValue("roll_no") ? $CurrentForm->getValue("roll_no") : $CurrentForm->getValue("x_roll_no");
		if (!$this->roll_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->roll_no->Visible = FALSE; // Disable update for API request
			else
				$this->roll_no->setFormValue($val);
		}

		// Check field name 'qty' first before field var 'x_qty'
		$val = $CurrentForm->hasValue("qty") ? $CurrentForm->getValue("qty") : $CurrentForm->getValue("x_qty");
		if (!$this->qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->qty->Visible = FALSE; // Disable update for API request
			else
				$this->qty->setFormValue($val);
		}

		// Check field name 'pl_no' first before field var 'x_pl_no'
		$val = $CurrentForm->hasValue("pl_no") ? $CurrentForm->getValue("pl_no") : $CurrentForm->getValue("x_pl_no");
		if (!$this->pl_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_no->Visible = FALSE; // Disable update for API request
			else
				$this->pl_no->setFormValue($val);
		}

		// Check field name 'category' first before field var 'x_category'
		$val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
		if (!$this->category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->category->Visible = FALSE; // Disable update for API request
			else
				$this->category->setFormValue($val);
		}

		// Check field name 'pp_id' first before field var 'x_pp_id'
		$val = $CurrentForm->hasValue("pp_id") ? $CurrentForm->getValue("pp_id") : $CurrentForm->getValue("x_pp_id");
		if (!$this->pp_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_id->Visible = FALSE; // Disable update for API request
			else
				$this->pp_id->setFormValue($val);
		}

		// Check field name 'buyer_barcode' first before field var 'x_buyer_barcode'
		$val = $CurrentForm->hasValue("buyer_barcode") ? $CurrentForm->getValue("buyer_barcode") : $CurrentForm->getValue("x_buyer_barcode");
		if (!$this->buyer_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_barcode->setFormValue($val);
		}

		// Check field name 'p_remarks' first before field var 'x_p_remarks'
		$val = $CurrentForm->hasValue("p_remarks") ? $CurrentForm->getValue("p_remarks") : $CurrentForm->getValue("x_p_remarks");
		if (!$this->p_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->p_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->p_remarks->setFormValue($val);
		}

		// Check field name 'roll_no_qty_tmp' first before field var 'x_roll_no_qty_tmp'
		$val = $CurrentForm->hasValue("roll_no_qty_tmp") ? $CurrentForm->getValue("roll_no_qty_tmp") : $CurrentForm->getValue("x_roll_no_qty_tmp");
		if (!$this->roll_no_qty_tmp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->roll_no_qty_tmp->Visible = FALSE; // Disable update for API request
			else
				$this->roll_no_qty_tmp->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->po->CurrentValue = $this->po->FormValue;
		$this->design_id->CurrentValue = $this->design_id->FormValue;
		$this->size_cm->CurrentValue = $this->size_cm->FormValue;
		$this->_barcode->CurrentValue = $this->_barcode->FormValue;
		$this->buyer_ref->CurrentValue = $this->buyer_ref->FormValue;
		$this->order_date->CurrentValue = $this->order_date->FormValue;
		$this->order_date->CurrentValue = UnFormatDateTime($this->order_date->CurrentValue, 0);
		$this->despatch_date->CurrentValue = $this->despatch_date->FormValue;
		$this->despatch_date->CurrentValue = UnFormatDateTime($this->despatch_date->CurrentValue, 0);
		$this->despatch_week->CurrentValue = $this->despatch_week->FormValue;
		$this->dispatch_week_p->CurrentValue = $this->dispatch_week_p->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->buyers_id->CurrentValue = $this->buyers_id->FormValue;
		$this->buyer_uid->CurrentValue = $this->buyer_uid->FormValue;
		$this->buyer_loc->CurrentValue = $this->buyer_loc->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->sqm->CurrentValue = $this->sqm->FormValue;
		$this->sqm_u->CurrentValue = $this->sqm_u->FormValue;
		$this->c_sqm->CurrentValue = $this->c_sqm->FormValue;
		$this->weaving_works->CurrentValue = $this->weaving_works->FormValue;
		$this->current_works->CurrentValue = $this->current_works->FormValue;
		$this->size_buyer->CurrentValue = $this->size_buyer->FormValue;
		$this->w_cm->CurrentValue = $this->w_cm->FormValue;
		$this->l_cm->CurrentValue = $this->l_cm->FormValue;
		$this->q_sku->CurrentValue = $this->q_sku->FormValue;
		$this->po_price->CurrentValue = $this->po_price->FormValue;
		$this->po_discount->CurrentValue = $this->po_discount->FormValue;
		$this->po_currency->CurrentValue = $this->po_currency->FormValue;
		$this->product_type->CurrentValue = $this->product_type->FormValue;
		$this->shape->CurrentValue = $this->shape->FormValue;
		$this->production_plan->CurrentValue = $this->production_plan->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->completed->CurrentValue = $this->completed->FormValue;
		$this->buyer_po->CurrentValue = $this->buyer_po->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->cs->CurrentValue = $this->cs->FormValue;
		$this->weight->CurrentValue = $this->weight->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->roll_no->CurrentValue = $this->roll_no->FormValue;
		$this->qty->CurrentValue = $this->qty->FormValue;
		$this->pl_no->CurrentValue = $this->pl_no->FormValue;
		$this->category->CurrentValue = $this->category->FormValue;
		$this->pp_id->CurrentValue = $this->pp_id->FormValue;
		$this->buyer_barcode->CurrentValue = $this->buyer_barcode->FormValue;
		$this->p_remarks->CurrentValue = $this->p_remarks->FormValue;
		$this->roll_no_qty_tmp->CurrentValue = $this->roll_no_qty_tmp->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->pid->setDbValue($row['pid']);
		$this->po->setDbValue($row['po']);
		$this->design_id->setDbValue($row['design_id']);
		if (array_key_exists('EV__design_id', $rs->fields)) {
			$this->design_id->VirtualValue = $rs->fields('EV__design_id'); // Set up virtual field value
		} else {
			$this->design_id->VirtualValue = ""; // Clear value
		}
		$this->size_cm->setDbValue($row['size_cm']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->process_d->setDbValue($row['process_d']);
		$this->buyer_ref->setDbValue($row['buyer_ref']);
		if (array_key_exists('EV__buyer_ref', $rs->fields)) {
			$this->buyer_ref->VirtualValue = $rs->fields('EV__buyer_ref'); // Set up virtual field value
		} else {
			$this->buyer_ref->VirtualValue = ""; // Clear value
		}
		$this->order_date->setDbValue($row['order_date']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
		$this->loom_plan->setDbValue($row['loom_plan']);
		$this->status->setDbValue($row['status']);
		$this->buyers_id->setDbValue($row['buyers_id']);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->buyer_loc->setDbValue($row['buyer_loc']);
		$this->quantity->setDbValue($row['quantity']);
		$this->sqm->setDbValue($row['sqm']);
		$this->sqm_u->setDbValue($row['sqm_u']);
		$this->c_sqm->setDbValue($row['c_sqm']);
		$this->weaving_works->setDbValue($row['weaving_works']);
		$this->current_works->setDbValue($row['current_works']);
		$this->size_buyer->setDbValue($row['size_buyer']);
		$this->design->setDbValue($row['design']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->po_price->setDbValue($row['po_price']);
		$this->po_discount->setDbValue($row['po_discount']);
		$this->po_currency->setDbValue($row['po_currency']);
		$this->product_type->setDbValue($row['product_type']);
		$this->shape->setDbValue($row['shape']);
		$this->payment_plan->setDbValue($row['payment_plan']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->datetime->setDbValue($row['datetime']);
		$this->completed->setDbValue($row['completed']);
		$this->buyer_po->setDbValue($row['buyer_po']);
		$this->operator->setDbValue($row['operator']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->sqm_a->setDbValue($row['sqm_a']);
		$this->_2srm->setDbValue($row['2srm']);
		$this->_2srm_a->setDbValue($row['2srm_a']);
		$this->_4srm->setDbValue($row['4srm']);
		$this->_4srm_a->setDbValue($row['4srm_a']);
		$this->buyer_tid->setDbValue($row['buyer_tid']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->cs->setDbValue($row['cs']);
		$this->process->setDbValue($row['process']);
		$this->process_c->setDbValue($row['process_c']);
		$this->weight->setDbValue($row['weight']);
		$this->remarks->setDbValue($row['remarks']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->qty->setDbValue($row['qty']);
		$this->pl_no->setDbValue($row['pl_no']);
		$this->category->setDbValue($row['category']);
		$this->pp_id->setDbValue($row['pp_id']);
		$this->consignee->setDbValue($row['consignee']);
		$this->buyer_barcode->setDbValue($row['buyer_barcode']);
		$this->design_next->setDbValue($row['design_next']);
		$this->_11->setDbValue($row['11']);
		$this->_12->setDbValue($row['12']);
		$this->_13->setDbValue($row['13']);
		$this->_14->setDbValue($row['14']);
		$this->_15->setDbValue($row['15']);
		$this->_16->setDbValue($row['16']);
		$this->_17->setDbValue($row['17']);
		$this->_18->setDbValue($row['18']);
		$this->_19->setDbValue($row['19']);
		$this->_20->setDbValue($row['20']);
		$this->_21->setDbValue($row['21']);
		$this->_22->setDbValue($row['22']);
		$this->_23->setDbValue($row['23']);
		$this->_24->setDbValue($row['24']);
		$this->_25->setDbValue($row['25']);
		$this->_26->setDbValue($row['26']);
		$this->_27->setDbValue($row['27']);
		$this->_28->setDbValue($row['28']);
		$this->_29->setDbValue($row['29']);
		$this->_30->setDbValue($row['30']);
		$this->_31->setDbValue($row['31']);
		$this->_32->setDbValue($row['32']);
		$this->_33->setDbValue($row['33']);
		$this->_34->setDbValue($row['34']);
		$this->_35->setDbValue($row['35']);
		$this->_36->setDbValue($row['36']);
		$this->_37->setDbValue($row['37']);
		$this->_38->setDbValue($row['38']);
		$this->_39->setDbValue($row['39']);
		$this->_40->setDbValue($row['40']);
		$this->_41->setDbValue($row['41']);
		$this->_42->setDbValue($row['42']);
		$this->_43->setDbValue($row['43']);
		$this->_44->setDbValue($row['44']);
		$this->_45->setDbValue($row['45']);
		$this->_46->setDbValue($row['46']);
		$this->_47->setDbValue($row['47']);
		$this->_48->setDbValue($row['48']);
		$this->_49->setDbValue($row['49']);
		$this->_50->setDbValue($row['50']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->qc_weaving->setDbValue($row['qc_weaving']);
		$this->p_remarks->setDbValue($row['p_remarks']);
		$this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['pid'] = NULL;
		$row['po'] = NULL;
		$row['design_id'] = NULL;
		$row['size_cm'] = NULL;
		$row['barcode'] = NULL;
		$row['process_d'] = NULL;
		$row['buyer_ref'] = NULL;
		$row['order_date'] = NULL;
		$row['despatch_date'] = NULL;
		$row['despatch_week'] = NULL;
		$row['dispatch_week_p'] = NULL;
		$row['loom_plan'] = NULL;
		$row['status'] = NULL;
		$row['buyers_id'] = NULL;
		$row['buyer_uid'] = NULL;
		$row['buyer_loc'] = NULL;
		$row['quantity'] = NULL;
		$row['sqm'] = NULL;
		$row['sqm_u'] = NULL;
		$row['c_sqm'] = NULL;
		$row['weaving_works'] = NULL;
		$row['current_works'] = NULL;
		$row['size_buyer'] = NULL;
		$row['design'] = NULL;
		$row['w_cm'] = NULL;
		$row['l_cm'] = NULL;
		$row['q_sku'] = NULL;
		$row['po_price'] = NULL;
		$row['po_discount'] = NULL;
		$row['po_currency'] = NULL;
		$row['product_type'] = NULL;
		$row['shape'] = NULL;
		$row['payment_plan'] = NULL;
		$row['production_plan'] = NULL;
		$row['datetime'] = NULL;
		$row['completed'] = NULL;
		$row['buyer_po'] = NULL;
		$row['operator'] = NULL;
		$row['jc_no'] = NULL;
		$row['sqm_a'] = NULL;
		$row['2srm'] = NULL;
		$row['2srm_a'] = NULL;
		$row['4srm'] = NULL;
		$row['4srm_a'] = NULL;
		$row['buyer_tid'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['batch_no'] = NULL;
		$row['cs'] = NULL;
		$row['process'] = NULL;
		$row['process_c'] = NULL;
		$row['weight'] = NULL;
		$row['remarks'] = NULL;
		$row['roll_no'] = NULL;
		$row['qty'] = NULL;
		$row['pl_no'] = NULL;
		$row['category'] = NULL;
		$row['pp_id'] = NULL;
		$row['consignee'] = NULL;
		$row['buyer_barcode'] = NULL;
		$row['design_next'] = NULL;
		$row['11'] = NULL;
		$row['12'] = NULL;
		$row['13'] = NULL;
		$row['14'] = NULL;
		$row['15'] = NULL;
		$row['16'] = NULL;
		$row['17'] = NULL;
		$row['18'] = NULL;
		$row['19'] = NULL;
		$row['20'] = NULL;
		$row['21'] = NULL;
		$row['22'] = NULL;
		$row['23'] = NULL;
		$row['24'] = NULL;
		$row['25'] = NULL;
		$row['26'] = NULL;
		$row['27'] = NULL;
		$row['28'] = NULL;
		$row['29'] = NULL;
		$row['30'] = NULL;
		$row['31'] = NULL;
		$row['32'] = NULL;
		$row['33'] = NULL;
		$row['34'] = NULL;
		$row['35'] = NULL;
		$row['36'] = NULL;
		$row['37'] = NULL;
		$row['38'] = NULL;
		$row['39'] = NULL;
		$row['40'] = NULL;
		$row['41'] = NULL;
		$row['42'] = NULL;
		$row['43'] = NULL;
		$row['44'] = NULL;
		$row['45'] = NULL;
		$row['46'] = NULL;
		$row['47'] = NULL;
		$row['48'] = NULL;
		$row['49'] = NULL;
		$row['50'] = NULL;
		$row['packing_type'] = NULL;
		$row['qc_weaving'] = NULL;
		$row['p_remarks'] = NULL;
		$row['roll_no_qty_tmp'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_u->FormValue == $this->sqm_u->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_u->CurrentValue)))
			$this->sqm_u->CurrentValue = ConvertToFloatString($this->sqm_u->CurrentValue);

		// Convert decimal values if posted back
		if ($this->c_sqm->FormValue == $this->c_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->c_sqm->CurrentValue)))
			$this->c_sqm->CurrentValue = ConvertToFloatString($this->c_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->q_sku->FormValue == $this->q_sku->CurrentValue && is_numeric(ConvertToFloatString($this->q_sku->CurrentValue)))
			$this->q_sku->CurrentValue = ConvertToFloatString($this->q_sku->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_discount->FormValue == $this->po_discount->CurrentValue && is_numeric(ConvertToFloatString($this->po_discount->CurrentValue)))
			$this->po_discount->CurrentValue = ConvertToFloatString($this->po_discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight->FormValue == $this->weight->CurrentValue && is_numeric(ConvertToFloatString($this->weight->CurrentValue)))
			$this->weight->CurrentValue = ConvertToFloatString($this->weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pl_no->FormValue == $this->pl_no->CurrentValue && is_numeric(ConvertToFloatString($this->pl_no->CurrentValue)))
			$this->pl_no->CurrentValue = ConvertToFloatString($this->pl_no->CurrentValue);

		// Convert decimal values if posted back
		if ($this->roll_no_qty_tmp->FormValue == $this->roll_no_qty_tmp->CurrentValue && is_numeric(ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue)))
			$this->roll_no_qty_tmp->CurrentValue = ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pid
		// po
		// design_id
		// size_cm
		// barcode
		// process_d
		// buyer_ref
		// order_date
		// despatch_date
		// despatch_week
		// dispatch_week_p
		// loom_plan
		// status
		// buyers_id
		// buyer_uid
		// buyer_loc
		// quantity
		// sqm
		// sqm_u
		// c_sqm
		// weaving_works
		// current_works
		// size_buyer
		// design
		// w_cm
		// l_cm
		// q_sku
		// po_price
		// po_discount
		// po_currency
		// product_type
		// shape
		// payment_plan
		// production_plan
		// datetime
		// completed
		// buyer_po
		// operator
		// jc_no
		// sqm_a
		// 2srm
		// 2srm_a
		// 4srm
		// 4srm_a
		// buyer_tid
		// grp
		// s_grp
		// batch_no
		// cs
		// process
		// process_c
		// weight
		// remarks
		// roll_no
		// qty
		// pl_no
		// category
		// pp_id
		// consignee
		// buyer_barcode
		// design_next
		// 11
		// 12
		// 13
		// 14
		// 15
		// 16
		// 17
		// 18
		// 19
		// 20
		// 21
		// 22
		// 23
		// 24
		// 25
		// 26
		// 27
		// 28
		// 29
		// 30
		// 31
		// 32
		// 33
		// 34
		// 35
		// 36
		// 37
		// 38
		// 39
		// 40
		// 41
		// 42
		// 43
		// 44
		// 45
		// 46
		// 47
		// 48
		// 49
		// 50
		// packing_type
		// qc_weaving
		// p_remarks
		// roll_no_qty_tmp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pid
			$this->pid->ViewValue = $this->pid->CurrentValue;
			$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
			$this->pid->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design_id
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->ViewValue = $this->design_id->VirtualValue;
			} else {
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// process_d
			$curVal = strval($this->process_d->CurrentValue);
			if ($curVal <> "") {
				$this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
				if ($this->process_d->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_d->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_d->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_d->ViewValue = $this->process_d->CurrentValue;
					}
				}
			} else {
				$this->process_d->ViewValue = NULL;
			}
			$this->process_d->ViewCustomAttributes = "";

			// buyer_ref
			if ($this->buyer_ref->VirtualValue <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
			} else {
			$curVal = strval($this->buyer_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_ref->ViewValue = NULL;
			}
			}
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
			$this->order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// dispatch_week_p
			$curVal = strval($this->dispatch_week_p->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
				if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
					}
				}
			} else {
				$this->dispatch_week_p->ViewValue = NULL;
			}
			$this->dispatch_week_p->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
			$this->buyer_uid->ViewCustomAttributes = "";

			// buyer_loc
			$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
			$this->buyer_loc->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_u
			$this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
			$this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, 2, -2, -2, -2);
			$this->sqm_u->ViewCustomAttributes = "";

			// c_sqm
			$this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
			$this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, 2, -2, -2, -2);
			$this->c_sqm->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// w_cm
			$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
			$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 0, -2, -2, -2);
			$this->w_cm->ViewCustomAttributes = "";

			// l_cm
			$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
			$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 0, -2, -2, -2);
			$this->l_cm->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, 2, -2, -2, -2);
			$this->q_sku->ViewCustomAttributes = "";

			// po_price
			$this->po_price->ViewValue = $this->po_price->CurrentValue;
			$this->po_price->ViewCustomAttributes = "";

			// po_discount
			$this->po_discount->ViewValue = $this->po_discount->CurrentValue;
			$this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, 2, -2, -2, -2);
			$this->po_discount->ViewCustomAttributes = "";

			// po_currency
			$curVal = strval($this->po_currency->CurrentValue);
			if ($curVal <> "") {
				$this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
				if ($this->po_currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_currency->ViewValue = $this->po_currency->CurrentValue;
					}
				}
			} else {
				$this->po_currency->ViewValue = NULL;
			}
			$this->po_currency->ViewCustomAttributes = "";

			// product_type
			if (strval($this->product_type->CurrentValue) <> "") {
				$this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// payment_plan
			$curVal = strval($this->payment_plan->CurrentValue);
			if ($curVal <> "") {
				$this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
				if ($this->payment_plan->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->payment_plan->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_plan->ViewValue = $this->payment_plan->CurrentValue;
					}
				}
			} else {
				$this->payment_plan->ViewValue = NULL;
			}
			$this->payment_plan->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// buyer_po
			$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
			$this->buyer_po->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// cs
			if (strval($this->cs->CurrentValue) <> "") {
				$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
			} else {
				$this->cs->ViewValue = NULL;
			}
			$this->cs->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process->ViewValue->add($this->process->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_c
			$curVal = strval($this->process_c->CurrentValue);
			if ($curVal <> "") {
				$this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
				if ($this->process_c->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_c->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_c->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_c->ViewValue = $this->process_c->CurrentValue;
					}
				}
			} else {
				$this->process_c->ViewValue = NULL;
			}
			$this->process_c->ViewCustomAttributes = "";

			// weight
			$this->weight->ViewValue = $this->weight->CurrentValue;
			$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
			$this->weight->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// pp_id
			$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
			$curVal = strval($this->pp_id->CurrentValue);
			if ($curVal <> "") {
				$this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
				if ($this->pp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
					}
				}
			} else {
				$this->pp_id->ViewValue = NULL;
			}
			$this->pp_id->ViewCustomAttributes = "";

			// buyer_barcode
			$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
			$this->buyer_barcode->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// p_remarks
			$this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
			$this->p_remarks->ViewCustomAttributes = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->ViewValue = $this->roll_no_qty_tmp->CurrentValue;
			$this->roll_no_qty_tmp->ViewValue = FormatNumber($this->roll_no_qty_tmp->ViewValue, 2, -2, -2, -2);
			$this->roll_no_qty_tmp->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->design_id->CurrentValue)) {
				$this->design_id->HrefValue = "bcodelist.php?x_design_id=" . ((!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue)) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
				$this->design_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
			} else {
				$this->design_id->HrefValue = "";
			}
			$this->design_id->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_ref->CurrentValue)) {
				$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
				$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
			} else {
				$this->buyer_ref->HrefValue = "";
			}
			$this->buyer_ref->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// dispatch_week_p
			$this->dispatch_week_p->LinkCustomAttributes = "";
			$this->dispatch_week_p->HrefValue = "";
			$this->dispatch_week_p->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyers_id->CurrentValue)) {
				$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
				$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
			} else {
				$this->buyers_id->HrefValue = "";
			}
			$this->buyers_id->TooltipValue = "";

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";
			$this->buyer_uid->TooltipValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";
			$this->buyer_loc->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_u
			$this->sqm_u->LinkCustomAttributes = "";
			$this->sqm_u->HrefValue = "";
			$this->sqm_u->TooltipValue = "";

			// c_sqm
			$this->c_sqm->LinkCustomAttributes = "";
			$this->c_sqm->HrefValue = "";
			$this->c_sqm->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";
			$this->current_works->TooltipValue = "";

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";
			$this->size_buyer->TooltipValue = "";

			// w_cm
			$this->w_cm->LinkCustomAttributes = "";
			$this->w_cm->HrefValue = "";
			$this->w_cm->TooltipValue = "";

			// l_cm
			$this->l_cm->LinkCustomAttributes = "";
			$this->l_cm->HrefValue = "";
			$this->l_cm->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// po_price
			$this->po_price->LinkCustomAttributes = "";
			$this->po_price->HrefValue = "";
			$this->po_price->TooltipValue = "";

			// po_discount
			$this->po_discount->LinkCustomAttributes = "";
			$this->po_discount->HrefValue = "";
			$this->po_discount->TooltipValue = "";

			// po_currency
			$this->po_currency->LinkCustomAttributes = "";
			$this->po_currency->HrefValue = "";
			$this->po_currency->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";
			$this->completed->TooltipValue = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";
			$this->buyer_po->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// cs
			$this->cs->LinkCustomAttributes = "";
			$this->cs->HrefValue = "";
			$this->cs->TooltipValue = "";

			// weight
			$this->weight->LinkCustomAttributes = "";
			$this->weight->HrefValue = "";
			$this->weight->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";
			$this->pp_id->TooltipValue = "";

			// buyer_barcode
			$this->buyer_barcode->LinkCustomAttributes = "";
			$this->buyer_barcode->HrefValue = "";
			$this->buyer_barcode->TooltipValue = "";

			// p_remarks
			$this->p_remarks->LinkCustomAttributes = "";
			$this->p_remarks->HrefValue = "";
			$this->p_remarks->TooltipValue = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->LinkCustomAttributes = "";
			$this->roll_no_qty_tmp->HrefValue = "";
			$this->roll_no_qty_tmp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = $this->po->CurrentValue;
			$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design_id
			$this->design_id->EditAttrs["class"] = "form-control";
			$this->design_id->EditCustomAttributes = "";
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->EditValue = $this->design_id->VirtualValue;
			} else {
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->EditValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->EditValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->EditValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->EditAttrs["class"] = "form-control";
			$this->size_cm->EditCustomAttributes = "";
			$this->size_cm->EditValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = $this->_barcode->CurrentValue;
			$this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			if ($this->buyer_ref->VirtualValue <> "") {
				$this->buyer_ref->EditValue = $this->buyer_ref->VirtualValue;
			} else {
			$curVal = strval($this->buyer_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_ref->EditValue = NULL;
			}
			}
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_date
			$this->order_date->EditAttrs["class"] = "form-control";
			$this->order_date->EditCustomAttributes = "";
			$this->order_date->EditValue = HtmlEncode(FormatDateTime($this->order_date->CurrentValue, 8));
			$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->EditValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->CurrentValue));
			if ($curVal <> "")
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// dispatch_week_p
			$this->dispatch_week_p->EditAttrs["class"] = "form-control";
			$this->dispatch_week_p->EditCustomAttributes = "";
			$curVal = strval($this->dispatch_week_p->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_week_p->EditValue = $this->dispatch_week_p->lookupCacheOption($curVal);
				if ($this->dispatch_week_p->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->dispatch_week_p->EditValue = $this->dispatch_week_p->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_week_p->EditValue = $this->dispatch_week_p->CurrentValue;
					}
				}
			} else {
				$this->dispatch_week_p->EditValue = NULL;
			}
			$this->dispatch_week_p->ViewCustomAttributes = "";

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->CurrentValue));
			if ($curVal <> "")
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->status->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `grp` != 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->EditValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->EditAttrs["class"] = "form-control";
			$this->buyer_uid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
			$this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->CurrentValue);
			$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

			// buyer_loc
			$this->buyer_loc->EditAttrs["class"] = "form-control";
			$this->buyer_loc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_loc->CurrentValue = HtmlDecode($this->buyer_loc->CurrentValue);
			$this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->CurrentValue);
			$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = $this->quantity->CurrentValue;
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = $this->sqm->CurrentValue;
			$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_u
			$this->sqm_u->EditAttrs["class"] = "form-control";
			$this->sqm_u->EditCustomAttributes = "";
			$this->sqm_u->EditValue = HtmlEncode($this->sqm_u->CurrentValue);
			$this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());
			if (strval($this->sqm_u->EditValue) <> "" && is_numeric($this->sqm_u->EditValue))
				$this->sqm_u->EditValue = FormatNumber($this->sqm_u->EditValue, -2, -2, -2, -2);

			// c_sqm
			$this->c_sqm->EditAttrs["class"] = "form-control";
			$this->c_sqm->EditCustomAttributes = "";
			$this->c_sqm->EditValue = HtmlEncode($this->c_sqm->CurrentValue);
			$this->c_sqm->PlaceHolder = RemoveHtml($this->c_sqm->caption());
			if (strval($this->c_sqm->EditValue) <> "" && is_numeric($this->c_sqm->EditValue))
				$this->c_sqm->EditValue = FormatNumber($this->c_sqm->EditValue, -2, -2, -2, -2);

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->weaving_works->CurrentValue));
			if ($curVal <> "")
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			else
				$this->weaving_works->ViewValue = $this->weaving_works->Lookup !== NULL && is_array($this->weaving_works->Lookup->Options) ? $curVal : NULL;
			if ($this->weaving_works->ViewValue !== NULL) { // Load from cache
				$this->weaving_works->EditValue = array_values($this->weaving_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->weaving_works->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->weaving_works->EditValue = $arwrk;
			}

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->current_works->CurrentValue));
			if ($curVal <> "")
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
			else
				$this->current_works->ViewValue = $this->current_works->Lookup !== NULL && is_array($this->current_works->Lookup->Options) ? $curVal : NULL;
			if ($this->current_works->ViewValue !== NULL) { // Load from cache
				$this->current_works->EditValue = array_values($this->current_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->current_works->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->current_works->EditValue = $arwrk;
			}

			// size_buyer
			$this->size_buyer->EditAttrs["class"] = "form-control";
			$this->size_buyer->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_buyer->CurrentValue = HtmlDecode($this->size_buyer->CurrentValue);
			$this->size_buyer->EditValue = HtmlEncode($this->size_buyer->CurrentValue);
			$this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

			// w_cm
			$this->w_cm->EditAttrs["class"] = "form-control";
			$this->w_cm->EditCustomAttributes = "";
			$this->w_cm->EditValue = HtmlEncode($this->w_cm->CurrentValue);
			$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

			// l_cm
			$this->l_cm->EditAttrs["class"] = "form-control";
			$this->l_cm->EditCustomAttributes = "";
			$this->l_cm->EditValue = HtmlEncode($this->l_cm->CurrentValue);
			$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

			// q_sku
			$this->q_sku->EditAttrs["class"] = "form-control";
			$this->q_sku->EditCustomAttributes = "";
			$this->q_sku->EditValue = HtmlEncode($this->q_sku->CurrentValue);
			$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
			if (strval($this->q_sku->EditValue) <> "" && is_numeric($this->q_sku->EditValue))
				$this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, -2, -2, -2, -2);

			// po_price
			$this->po_price->EditAttrs["class"] = "form-control";
			$this->po_price->EditCustomAttributes = "";
			$this->po_price->EditValue = $this->po_price->CurrentValue;
			$this->po_price->ViewCustomAttributes = "";

			// po_discount
			$this->po_discount->EditAttrs["class"] = "form-control";
			$this->po_discount->EditCustomAttributes = "";
			$this->po_discount->EditValue = HtmlEncode($this->po_discount->CurrentValue);
			$this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());
			if (strval($this->po_discount->EditValue) <> "" && is_numeric($this->po_discount->EditValue))
				$this->po_discount->EditValue = FormatNumber($this->po_discount->EditValue, -2, -2, -2, -2);

			// po_currency
			$this->po_currency->EditAttrs["class"] = "form-control";
			$this->po_currency->EditCustomAttributes = "";
			$curVal = strval($this->po_currency->CurrentValue);
			if ($curVal <> "") {
				$this->po_currency->EditValue = $this->po_currency->lookupCacheOption($curVal);
				if ($this->po_currency->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po_currency->EditValue = $this->po_currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_currency->EditValue = $this->po_currency->CurrentValue;
					}
				}
			} else {
				$this->po_currency->EditValue = NULL;
			}
			$this->po_currency->ViewCustomAttributes = "";

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			if (strval($this->product_type->CurrentValue) <> "") {
				$this->product_type->EditValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
			} else {
				$this->product_type->EditValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->EditValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->EditValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->EditValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->EditValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			$this->production_plan->EditValue = $this->production_plan->options(TRUE);

			// datetime
			// completed

			$this->completed->EditAttrs["class"] = "form-control";
			$this->completed->EditCustomAttributes = "";
			$this->completed->EditValue = $this->completed->options(TRUE);

			// buyer_po
			$this->buyer_po->EditAttrs["class"] = "form-control";
			$this->buyer_po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
			$this->buyer_po->EditValue = HtmlEncode($this->buyer_po->CurrentValue);
			$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

			// operator
			// jc_no

			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->CurrentValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->CurrentValue));
			if ($curVal <> "")
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// cs
			$this->cs->EditAttrs["class"] = "form-control";
			$this->cs->EditCustomAttributes = "";
			$this->cs->EditValue = $this->cs->options(TRUE);

			// weight
			$this->weight->EditAttrs["class"] = "form-control";
			$this->weight->EditCustomAttributes = "";
			$this->weight->EditValue = HtmlEncode($this->weight->CurrentValue);
			$this->weight->PlaceHolder = RemoveHtml($this->weight->caption());
			if (strval($this->weight->EditValue) <> "" && is_numeric($this->weight->EditValue))
				$this->weight->EditValue = FormatNumber($this->weight->EditValue, -2, -2, -2, -2);

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			$this->roll_no->EditValue = $this->roll_no->CurrentValue;
			$this->roll_no->EditValue = FormatNumber($this->roll_no->EditValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = $this->qty->CurrentValue;
			$this->qty->EditValue = FormatNumber($this->qty->EditValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			$this->pl_no->EditValue = $this->pl_no->CurrentValue;
			$this->pl_no->EditValue = FormatNumber($this->pl_no->EditValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->CurrentValue));
			if ($curVal <> "")
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// pp_id
			$this->pp_id->EditAttrs["class"] = "form-control";
			$this->pp_id->EditCustomAttributes = "";
			$this->pp_id->EditValue = HtmlEncode($this->pp_id->CurrentValue);
			$curVal = strval($this->pp_id->CurrentValue);
			if ($curVal <> "") {
				$this->pp_id->EditValue = $this->pp_id->lookupCacheOption($curVal);
				if ($this->pp_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pp_id->EditValue = $this->pp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pp_id->EditValue = HtmlEncode($this->pp_id->CurrentValue);
					}
				}
			} else {
				$this->pp_id->EditValue = NULL;
			}
			$this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

			// buyer_barcode
			$this->buyer_barcode->EditAttrs["class"] = "form-control";
			$this->buyer_barcode->EditCustomAttributes = "";
			$this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;
			$this->buyer_barcode->ViewCustomAttributes = "";

			// p_remarks
			$this->p_remarks->EditAttrs["class"] = "form-control";
			$this->p_remarks->EditCustomAttributes = "";
			$this->p_remarks->EditValue = HtmlEncode($this->p_remarks->CurrentValue);
			$this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->EditAttrs["class"] = "form-control";
			$this->roll_no_qty_tmp->EditCustomAttributes = "";
			$this->roll_no_qty_tmp->EditValue = HtmlEncode($this->roll_no_qty_tmp->CurrentValue);
			$this->roll_no_qty_tmp->PlaceHolder = RemoveHtml($this->roll_no_qty_tmp->caption());
			if (strval($this->roll_no_qty_tmp->EditValue) <> "" && is_numeric($this->roll_no_qty_tmp->EditValue))
				$this->roll_no_qty_tmp->EditValue = FormatNumber($this->roll_no_qty_tmp->EditValue, -2, -2, -2, -2);

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->design_id->CurrentValue)) {
				$this->design_id->HrefValue = "bcodelist.php?x_design_id=" . ((!empty($this->design_id->EditValue) && !is_array($this->design_id->EditValue)) ? RemoveHtml($this->design_id->EditValue) : $this->design_id->CurrentValue); // Add prefix/suffix
				$this->design_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
			} else {
				$this->design_id->HrefValue = "";
			}
			$this->design_id->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_ref->CurrentValue)) {
				$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
				$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
			} else {
				$this->buyer_ref->HrefValue = "";
			}
			$this->buyer_ref->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";

			// dispatch_week_p
			$this->dispatch_week_p->LinkCustomAttributes = "";
			$this->dispatch_week_p->HrefValue = "";
			$this->dispatch_week_p->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyers_id->CurrentValue)) {
				$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
				$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
			} else {
				$this->buyers_id->HrefValue = "";
			}
			$this->buyers_id->TooltipValue = "";

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_u
			$this->sqm_u->LinkCustomAttributes = "";
			$this->sqm_u->HrefValue = "";

			// c_sqm
			$this->c_sqm->LinkCustomAttributes = "";
			$this->c_sqm->HrefValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";

			// w_cm
			$this->w_cm->LinkCustomAttributes = "";
			$this->w_cm->HrefValue = "";

			// l_cm
			$this->l_cm->LinkCustomAttributes = "";
			$this->l_cm->HrefValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";

			// po_price
			$this->po_price->LinkCustomAttributes = "";
			$this->po_price->HrefValue = "";
			$this->po_price->TooltipValue = "";

			// po_discount
			$this->po_discount->LinkCustomAttributes = "";
			$this->po_discount->HrefValue = "";

			// po_currency
			$this->po_currency->LinkCustomAttributes = "";
			$this->po_currency->HrefValue = "";
			$this->po_currency->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}

			// cs
			$this->cs->LinkCustomAttributes = "";
			$this->cs->HrefValue = "";

			// weight
			$this->weight->LinkCustomAttributes = "";
			$this->weight->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";

			// buyer_barcode
			$this->buyer_barcode->LinkCustomAttributes = "";
			$this->buyer_barcode->HrefValue = "";
			$this->buyer_barcode->TooltipValue = "";

			// p_remarks
			$this->p_remarks->LinkCustomAttributes = "";
			$this->p_remarks->HrefValue = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->LinkCustomAttributes = "";
			$this->roll_no_qty_tmp->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->pid->Required) {
			if (!$this->pid->IsDetailKey && $this->pid->FormValue != NULL && $this->pid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pid->caption(), $this->pid->RequiredErrorMessage));
			}
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if ($this->design_id->Required) {
			if (!$this->design_id->IsDetailKey && $this->design_id->FormValue != NULL && $this->design_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design_id->caption(), $this->design_id->RequiredErrorMessage));
			}
		}
		if ($this->size_cm->Required) {
			if (!$this->size_cm->IsDetailKey && $this->size_cm->FormValue != NULL && $this->size_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size_cm->caption(), $this->size_cm->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->process_d->Required) {
			if ($this->process_d->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_d->caption(), $this->process_d->RequiredErrorMessage));
			}
		}
		if ($this->buyer_ref->Required) {
			if (!$this->buyer_ref->IsDetailKey && $this->buyer_ref->FormValue != NULL && $this->buyer_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_ref->caption(), $this->buyer_ref->RequiredErrorMessage));
			}
		}
		if ($this->order_date->Required) {
			if (!$this->order_date->IsDetailKey && $this->order_date->FormValue != NULL && $this->order_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->order_date->caption(), $this->order_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->order_date->FormValue)) {
			AddMessage($FormError, $this->order_date->errorMessage());
		}
		if ($this->despatch_date->Required) {
			if (!$this->despatch_date->IsDetailKey && $this->despatch_date->FormValue != NULL && $this->despatch_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_date->caption(), $this->despatch_date->RequiredErrorMessage));
			}
		}
		if ($this->despatch_week->Required) {
			if (!$this->despatch_week->IsDetailKey && $this->despatch_week->FormValue != NULL && $this->despatch_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_week->caption(), $this->despatch_week->RequiredErrorMessage));
			}
		}
		if ($this->dispatch_week_p->Required) {
			if (!$this->dispatch_week_p->IsDetailKey && $this->dispatch_week_p->FormValue != NULL && $this->dispatch_week_p->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dispatch_week_p->caption(), $this->dispatch_week_p->RequiredErrorMessage));
			}
		}
		if ($this->loom_plan->Required) {
			if (!$this->loom_plan->IsDetailKey && $this->loom_plan->FormValue != NULL && $this->loom_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->loom_plan->caption(), $this->loom_plan->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->buyers_id->Required) {
			if (!$this->buyers_id->IsDetailKey && $this->buyers_id->FormValue != NULL && $this->buyers_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyers_id->caption(), $this->buyers_id->RequiredErrorMessage));
			}
		}
		if ($this->buyer_uid->Required) {
			if (!$this->buyer_uid->IsDetailKey && $this->buyer_uid->FormValue != NULL && $this->buyer_uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_uid->caption(), $this->buyer_uid->RequiredErrorMessage));
			}
		}
		if ($this->buyer_loc->Required) {
			if (!$this->buyer_loc->IsDetailKey && $this->buyer_loc->FormValue != NULL && $this->buyer_loc->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_loc->caption(), $this->buyer_loc->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->sqm->Required) {
			if (!$this->sqm->IsDetailKey && $this->sqm->FormValue != NULL && $this->sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
			}
		}
		if ($this->sqm_u->Required) {
			if (!$this->sqm_u->IsDetailKey && $this->sqm_u->FormValue != NULL && $this->sqm_u->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm_u->caption(), $this->sqm_u->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->sqm_u->FormValue)) {
			AddMessage($FormError, $this->sqm_u->errorMessage());
		}
		if ($this->c_sqm->Required) {
			if (!$this->c_sqm->IsDetailKey && $this->c_sqm->FormValue != NULL && $this->c_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->c_sqm->caption(), $this->c_sqm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->c_sqm->FormValue)) {
			AddMessage($FormError, $this->c_sqm->errorMessage());
		}
		if ($this->weaving_works->Required) {
			if (!$this->weaving_works->IsDetailKey && $this->weaving_works->FormValue != NULL && $this->weaving_works->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weaving_works->caption(), $this->weaving_works->RequiredErrorMessage));
			}
		}
		if ($this->current_works->Required) {
			if (!$this->current_works->IsDetailKey && $this->current_works->FormValue != NULL && $this->current_works->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->current_works->caption(), $this->current_works->RequiredErrorMessage));
			}
		}
		if ($this->size_buyer->Required) {
			if (!$this->size_buyer->IsDetailKey && $this->size_buyer->FormValue != NULL && $this->size_buyer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size_buyer->caption(), $this->size_buyer->RequiredErrorMessage));
			}
		}
		if ($this->design->Required) {
			if (!$this->design->IsDetailKey && $this->design->FormValue != NULL && $this->design->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
			}
		}
		if ($this->w_cm->Required) {
			if (!$this->w_cm->IsDetailKey && $this->w_cm->FormValue != NULL && $this->w_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->w_cm->caption(), $this->w_cm->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->w_cm->FormValue)) {
			AddMessage($FormError, $this->w_cm->errorMessage());
		}
		if ($this->l_cm->Required) {
			if (!$this->l_cm->IsDetailKey && $this->l_cm->FormValue != NULL && $this->l_cm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->l_cm->caption(), $this->l_cm->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->l_cm->FormValue)) {
			AddMessage($FormError, $this->l_cm->errorMessage());
		}
		if ($this->q_sku->Required) {
			if (!$this->q_sku->IsDetailKey && $this->q_sku->FormValue != NULL && $this->q_sku->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->q_sku->FormValue)) {
			AddMessage($FormError, $this->q_sku->errorMessage());
		}
		if ($this->po_price->Required) {
			if (!$this->po_price->IsDetailKey && $this->po_price->FormValue != NULL && $this->po_price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_price->caption(), $this->po_price->RequiredErrorMessage));
			}
		}
		if ($this->po_discount->Required) {
			if (!$this->po_discount->IsDetailKey && $this->po_discount->FormValue != NULL && $this->po_discount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_discount->caption(), $this->po_discount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->po_discount->FormValue)) {
			AddMessage($FormError, $this->po_discount->errorMessage());
		}
		if ($this->po_currency->Required) {
			if (!$this->po_currency->IsDetailKey && $this->po_currency->FormValue != NULL && $this->po_currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_currency->caption(), $this->po_currency->RequiredErrorMessage));
			}
		}
		if ($this->product_type->Required) {
			if (!$this->product_type->IsDetailKey && $this->product_type->FormValue != NULL && $this->product_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
			}
		}
		if ($this->shape->Required) {
			if (!$this->shape->IsDetailKey && $this->shape->FormValue != NULL && $this->shape->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
			}
		}
		if ($this->payment_plan->Required) {
			if (!$this->payment_plan->IsDetailKey && $this->payment_plan->FormValue != NULL && $this->payment_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_plan->caption(), $this->payment_plan->RequiredErrorMessage));
			}
		}
		if ($this->production_plan->Required) {
			if (!$this->production_plan->IsDetailKey && $this->production_plan->FormValue != NULL && $this->production_plan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->production_plan->caption(), $this->production_plan->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->completed->Required) {
			if (!$this->completed->IsDetailKey && $this->completed->FormValue != NULL && $this->completed->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->completed->caption(), $this->completed->RequiredErrorMessage));
			}
		}
		if ($this->buyer_po->Required) {
			if (!$this->buyer_po->IsDetailKey && $this->buyer_po->FormValue != NULL && $this->buyer_po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_po->caption(), $this->buyer_po->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_no->FormValue)) {
			AddMessage($FormError, $this->jc_no->errorMessage());
		}
		if ($this->sqm_a->Required) {
			if (!$this->sqm_a->IsDetailKey && $this->sqm_a->FormValue != NULL && $this->sqm_a->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sqm_a->caption(), $this->sqm_a->RequiredErrorMessage));
			}
		}
		if ($this->_2srm->Required) {
			if (!$this->_2srm->IsDetailKey && $this->_2srm->FormValue != NULL && $this->_2srm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_2srm->caption(), $this->_2srm->RequiredErrorMessage));
			}
		}
		if ($this->_2srm_a->Required) {
			if (!$this->_2srm_a->IsDetailKey && $this->_2srm_a->FormValue != NULL && $this->_2srm_a->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_2srm_a->caption(), $this->_2srm_a->RequiredErrorMessage));
			}
		}
		if ($this->_4srm->Required) {
			if (!$this->_4srm->IsDetailKey && $this->_4srm->FormValue != NULL && $this->_4srm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_4srm->caption(), $this->_4srm->RequiredErrorMessage));
			}
		}
		if ($this->_4srm_a->Required) {
			if (!$this->_4srm_a->IsDetailKey && $this->_4srm_a->FormValue != NULL && $this->_4srm_a->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_4srm_a->caption(), $this->_4srm_a->RequiredErrorMessage));
			}
		}
		if ($this->buyer_tid->Required) {
			if (!$this->buyer_tid->IsDetailKey && $this->buyer_tid->FormValue != NULL && $this->buyer_tid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_tid->caption(), $this->buyer_tid->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->cs->Required) {
			if (!$this->cs->IsDetailKey && $this->cs->FormValue != NULL && $this->cs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cs->caption(), $this->cs->RequiredErrorMessage));
			}
		}
		if ($this->process->Required) {
			if ($this->process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process->caption(), $this->process->RequiredErrorMessage));
			}
		}
		if ($this->process_c->Required) {
			if ($this->process_c->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_c->caption(), $this->process_c->RequiredErrorMessage));
			}
		}
		if ($this->weight->Required) {
			if (!$this->weight->IsDetailKey && $this->weight->FormValue != NULL && $this->weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->weight->caption(), $this->weight->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->weight->FormValue)) {
			AddMessage($FormError, $this->weight->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->roll_no->Required) {
			if (!$this->roll_no->IsDetailKey && $this->roll_no->FormValue != NULL && $this->roll_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->roll_no->caption(), $this->roll_no->RequiredErrorMessage));
			}
		}
		if ($this->qty->Required) {
			if (!$this->qty->IsDetailKey && $this->qty->FormValue != NULL && $this->qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
			}
		}
		if ($this->pl_no->Required) {
			if (!$this->pl_no->IsDetailKey && $this->pl_no->FormValue != NULL && $this->pl_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_no->caption(), $this->pl_no->RequiredErrorMessage));
			}
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->pp_id->Required) {
			if (!$this->pp_id->IsDetailKey && $this->pp_id->FormValue != NULL && $this->pp_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_id->caption(), $this->pp_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->pp_id->FormValue)) {
			AddMessage($FormError, $this->pp_id->errorMessage());
		}
		if ($this->consignee->Required) {
			if (!$this->consignee->IsDetailKey && $this->consignee->FormValue != NULL && $this->consignee->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consignee->caption(), $this->consignee->RequiredErrorMessage));
			}
		}
		if ($this->buyer_barcode->Required) {
			if (!$this->buyer_barcode->IsDetailKey && $this->buyer_barcode->FormValue != NULL && $this->buyer_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_barcode->caption(), $this->buyer_barcode->RequiredErrorMessage));
			}
		}
		if ($this->design_next->Required) {
			if (!$this->design_next->IsDetailKey && $this->design_next->FormValue != NULL && $this->design_next->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design_next->caption(), $this->design_next->RequiredErrorMessage));
			}
		}
		if ($this->_11->Required) {
			if (!$this->_11->IsDetailKey && $this->_11->FormValue != NULL && $this->_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_11->caption(), $this->_11->RequiredErrorMessage));
			}
		}
		if ($this->_12->Required) {
			if (!$this->_12->IsDetailKey && $this->_12->FormValue != NULL && $this->_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_12->caption(), $this->_12->RequiredErrorMessage));
			}
		}
		if ($this->_13->Required) {
			if (!$this->_13->IsDetailKey && $this->_13->FormValue != NULL && $this->_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_13->caption(), $this->_13->RequiredErrorMessage));
			}
		}
		if ($this->_14->Required) {
			if (!$this->_14->IsDetailKey && $this->_14->FormValue != NULL && $this->_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_14->caption(), $this->_14->RequiredErrorMessage));
			}
		}
		if ($this->_15->Required) {
			if (!$this->_15->IsDetailKey && $this->_15->FormValue != NULL && $this->_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_15->caption(), $this->_15->RequiredErrorMessage));
			}
		}
		if ($this->_16->Required) {
			if (!$this->_16->IsDetailKey && $this->_16->FormValue != NULL && $this->_16->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_16->caption(), $this->_16->RequiredErrorMessage));
			}
		}
		if ($this->_17->Required) {
			if (!$this->_17->IsDetailKey && $this->_17->FormValue != NULL && $this->_17->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_17->caption(), $this->_17->RequiredErrorMessage));
			}
		}
		if ($this->_18->Required) {
			if (!$this->_18->IsDetailKey && $this->_18->FormValue != NULL && $this->_18->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_18->caption(), $this->_18->RequiredErrorMessage));
			}
		}
		if ($this->_19->Required) {
			if (!$this->_19->IsDetailKey && $this->_19->FormValue != NULL && $this->_19->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_19->caption(), $this->_19->RequiredErrorMessage));
			}
		}
		if ($this->_20->Required) {
			if (!$this->_20->IsDetailKey && $this->_20->FormValue != NULL && $this->_20->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_20->caption(), $this->_20->RequiredErrorMessage));
			}
		}
		if ($this->_21->Required) {
			if (!$this->_21->IsDetailKey && $this->_21->FormValue != NULL && $this->_21->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_21->caption(), $this->_21->RequiredErrorMessage));
			}
		}
		if ($this->_22->Required) {
			if (!$this->_22->IsDetailKey && $this->_22->FormValue != NULL && $this->_22->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_22->caption(), $this->_22->RequiredErrorMessage));
			}
		}
		if ($this->_23->Required) {
			if (!$this->_23->IsDetailKey && $this->_23->FormValue != NULL && $this->_23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_23->caption(), $this->_23->RequiredErrorMessage));
			}
		}
		if ($this->_24->Required) {
			if (!$this->_24->IsDetailKey && $this->_24->FormValue != NULL && $this->_24->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_24->caption(), $this->_24->RequiredErrorMessage));
			}
		}
		if ($this->_25->Required) {
			if (!$this->_25->IsDetailKey && $this->_25->FormValue != NULL && $this->_25->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_25->caption(), $this->_25->RequiredErrorMessage));
			}
		}
		if ($this->_26->Required) {
			if (!$this->_26->IsDetailKey && $this->_26->FormValue != NULL && $this->_26->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_26->caption(), $this->_26->RequiredErrorMessage));
			}
		}
		if ($this->_27->Required) {
			if (!$this->_27->IsDetailKey && $this->_27->FormValue != NULL && $this->_27->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_27->caption(), $this->_27->RequiredErrorMessage));
			}
		}
		if ($this->_28->Required) {
			if (!$this->_28->IsDetailKey && $this->_28->FormValue != NULL && $this->_28->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_28->caption(), $this->_28->RequiredErrorMessage));
			}
		}
		if ($this->_29->Required) {
			if (!$this->_29->IsDetailKey && $this->_29->FormValue != NULL && $this->_29->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_29->caption(), $this->_29->RequiredErrorMessage));
			}
		}
		if ($this->_30->Required) {
			if (!$this->_30->IsDetailKey && $this->_30->FormValue != NULL && $this->_30->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_30->caption(), $this->_30->RequiredErrorMessage));
			}
		}
		if ($this->_31->Required) {
			if (!$this->_31->IsDetailKey && $this->_31->FormValue != NULL && $this->_31->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_31->caption(), $this->_31->RequiredErrorMessage));
			}
		}
		if ($this->_32->Required) {
			if (!$this->_32->IsDetailKey && $this->_32->FormValue != NULL && $this->_32->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_32->caption(), $this->_32->RequiredErrorMessage));
			}
		}
		if ($this->_33->Required) {
			if (!$this->_33->IsDetailKey && $this->_33->FormValue != NULL && $this->_33->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_33->caption(), $this->_33->RequiredErrorMessage));
			}
		}
		if ($this->_34->Required) {
			if (!$this->_34->IsDetailKey && $this->_34->FormValue != NULL && $this->_34->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_34->caption(), $this->_34->RequiredErrorMessage));
			}
		}
		if ($this->_35->Required) {
			if (!$this->_35->IsDetailKey && $this->_35->FormValue != NULL && $this->_35->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_35->caption(), $this->_35->RequiredErrorMessage));
			}
		}
		if ($this->_36->Required) {
			if (!$this->_36->IsDetailKey && $this->_36->FormValue != NULL && $this->_36->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_36->caption(), $this->_36->RequiredErrorMessage));
			}
		}
		if ($this->_37->Required) {
			if (!$this->_37->IsDetailKey && $this->_37->FormValue != NULL && $this->_37->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_37->caption(), $this->_37->RequiredErrorMessage));
			}
		}
		if ($this->_38->Required) {
			if (!$this->_38->IsDetailKey && $this->_38->FormValue != NULL && $this->_38->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_38->caption(), $this->_38->RequiredErrorMessage));
			}
		}
		if ($this->_39->Required) {
			if (!$this->_39->IsDetailKey && $this->_39->FormValue != NULL && $this->_39->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_39->caption(), $this->_39->RequiredErrorMessage));
			}
		}
		if ($this->_40->Required) {
			if (!$this->_40->IsDetailKey && $this->_40->FormValue != NULL && $this->_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
			}
		}
		if ($this->_41->Required) {
			if (!$this->_41->IsDetailKey && $this->_41->FormValue != NULL && $this->_41->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_41->caption(), $this->_41->RequiredErrorMessage));
			}
		}
		if ($this->_42->Required) {
			if (!$this->_42->IsDetailKey && $this->_42->FormValue != NULL && $this->_42->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_42->caption(), $this->_42->RequiredErrorMessage));
			}
		}
		if ($this->_43->Required) {
			if (!$this->_43->IsDetailKey && $this->_43->FormValue != NULL && $this->_43->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_43->caption(), $this->_43->RequiredErrorMessage));
			}
		}
		if ($this->_44->Required) {
			if (!$this->_44->IsDetailKey && $this->_44->FormValue != NULL && $this->_44->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_44->caption(), $this->_44->RequiredErrorMessage));
			}
		}
		if ($this->_45->Required) {
			if (!$this->_45->IsDetailKey && $this->_45->FormValue != NULL && $this->_45->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_45->caption(), $this->_45->RequiredErrorMessage));
			}
		}
		if ($this->_46->Required) {
			if (!$this->_46->IsDetailKey && $this->_46->FormValue != NULL && $this->_46->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_46->caption(), $this->_46->RequiredErrorMessage));
			}
		}
		if ($this->_47->Required) {
			if (!$this->_47->IsDetailKey && $this->_47->FormValue != NULL && $this->_47->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_47->caption(), $this->_47->RequiredErrorMessage));
			}
		}
		if ($this->_48->Required) {
			if (!$this->_48->IsDetailKey && $this->_48->FormValue != NULL && $this->_48->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_48->caption(), $this->_48->RequiredErrorMessage));
			}
		}
		if ($this->_49->Required) {
			if (!$this->_49->IsDetailKey && $this->_49->FormValue != NULL && $this->_49->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_49->caption(), $this->_49->RequiredErrorMessage));
			}
		}
		if ($this->_50->Required) {
			if (!$this->_50->IsDetailKey && $this->_50->FormValue != NULL && $this->_50->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_50->caption(), $this->_50->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->qc_weaving->Required) {
			if (!$this->qc_weaving->IsDetailKey && $this->qc_weaving->FormValue != NULL && $this->qc_weaving->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qc_weaving->caption(), $this->qc_weaving->RequiredErrorMessage));
			}
		}
		if ($this->p_remarks->Required) {
			if (!$this->p_remarks->IsDetailKey && $this->p_remarks->FormValue != NULL && $this->p_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->p_remarks->caption(), $this->p_remarks->RequiredErrorMessage));
			}
		}
		if ($this->roll_no_qty_tmp->Required) {
			if (!$this->roll_no_qty_tmp->IsDetailKey && $this->roll_no_qty_tmp->FormValue != NULL && $this->roll_no_qty_tmp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->roll_no_qty_tmp->caption(), $this->roll_no_qty_tmp->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->roll_no_qty_tmp->FormValue)) {
			AddMessage($FormError, $this->roll_no_qty_tmp->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->_barcode->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`barcode` = " . AdjustSql($this->_barcode->CurrentValue, $this->Dbid) . ")";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->_barcode->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->_barcode->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// order_date
			$this->order_date->setDbValueDef($rsnew, UnFormatDateTime($this->order_date->CurrentValue, 0), NULL, $this->order_date->ReadOnly);

			// despatch_week
			$this->despatch_week->setDbValueDef($rsnew, $this->despatch_week->CurrentValue, NULL, $this->despatch_week->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, $this->status->ReadOnly);

			// buyer_uid
			$this->buyer_uid->setDbValueDef($rsnew, $this->buyer_uid->CurrentValue, NULL, $this->buyer_uid->ReadOnly);

			// buyer_loc
			$this->buyer_loc->setDbValueDef($rsnew, $this->buyer_loc->CurrentValue, NULL, $this->buyer_loc->ReadOnly);

			// sqm_u
			$this->sqm_u->setDbValueDef($rsnew, $this->sqm_u->CurrentValue, NULL, $this->sqm_u->ReadOnly);

			// c_sqm
			$this->c_sqm->setDbValueDef($rsnew, $this->c_sqm->CurrentValue, 0, $this->c_sqm->ReadOnly);

			// weaving_works
			$this->weaving_works->setDbValueDef($rsnew, $this->weaving_works->CurrentValue, 0, $this->weaving_works->ReadOnly);

			// current_works
			$this->current_works->setDbValueDef($rsnew, $this->current_works->CurrentValue, 0, $this->current_works->ReadOnly);

			// size_buyer
			$this->size_buyer->setDbValueDef($rsnew, $this->size_buyer->CurrentValue, NULL, $this->size_buyer->ReadOnly);

			// w_cm
			$this->w_cm->setDbValueDef($rsnew, $this->w_cm->CurrentValue, NULL, $this->w_cm->ReadOnly);

			// l_cm
			$this->l_cm->setDbValueDef($rsnew, $this->l_cm->CurrentValue, NULL, $this->l_cm->ReadOnly);

			// q_sku
			$this->q_sku->setDbValueDef($rsnew, $this->q_sku->CurrentValue, 0, $this->q_sku->ReadOnly);

			// po_discount
			$this->po_discount->setDbValueDef($rsnew, $this->po_discount->CurrentValue, 0, $this->po_discount->ReadOnly);

			// production_plan
			$this->production_plan->setDbValueDef($rsnew, $this->production_plan->CurrentValue, NULL, $this->production_plan->ReadOnly);

			// completed
			$this->completed->setDbValueDef($rsnew, $this->completed->CurrentValue, NULL, $this->completed->ReadOnly);

			// buyer_po
			$this->buyer_po->setDbValueDef($rsnew, $this->buyer_po->CurrentValue, NULL, $this->buyer_po->ReadOnly);

			// jc_no
			$this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, 0, $this->jc_no->ReadOnly);

			// batch_no
			$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, NULL, $this->batch_no->ReadOnly);

			// cs
			$this->cs->setDbValueDef($rsnew, $this->cs->CurrentValue, 0, $this->cs->ReadOnly);

			// weight
			$this->weight->setDbValueDef($rsnew, $this->weight->CurrentValue, NULL, $this->weight->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// category
			$this->category->setDbValueDef($rsnew, $this->category->CurrentValue, "", $this->category->ReadOnly);

			// pp_id
			$this->pp_id->setDbValueDef($rsnew, $this->pp_id->CurrentValue, NULL, $this->pp_id->ReadOnly);

			// p_remarks
			$this->p_remarks->setDbValueDef($rsnew, $this->p_remarks->CurrentValue, NULL, $this->p_remarks->ReadOnly);

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->setDbValueDef($rsnew, $this->roll_no_qty_tmp->CurrentValue, 0, $this->roll_no_qty_tmp->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_design_id":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_d":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_weaving_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_design":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_c":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pp_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_design_id":
							break;
						case "x_process_d":
							break;
						case "x_buyer_ref":
							break;
						case "x_despatch_week":
							break;
						case "x_dispatch_week_p":
							break;
						case "x_status":
							break;
						case "x_buyers_id":
							break;
						case "x_weaving_works":
							break;
						case "x_current_works":
							break;
						case "x_design":
							break;
						case "x_po_currency":
							break;
						case "x_shape":
							break;
						case "x_payment_plan":
							break;
						case "x_operator":
							break;
						case "x_batch_no":
							break;
						case "x_process":
							break;
						case "x_process_c":
							break;
						case "x_category":
							break;
						case "x_pp_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'bcode');
			$this->_barcode->ReadOnly = True;
				if (($this->status->CurrentValue == 201) || ($this->status->CurrentValue == 202) || ($this->status->CurrentValue == 203) || ($this->status->CurrentValue == 209) || ($this->status->CurrentValue == 11) || ($this->status->CurrentValue == 21) || ($this->status->CurrentValue == 31) || ($this->status->CurrentValue == 41) || ($this->status->CurrentValue == 211))
				{
				$this->status->ReadOnly = True;
				}
				if (($this->jc_no->CurrentValue > 0 ) && ($this->process_c->CurrentValue == NULL))
				{
				$this->jc_no->ReadOnly = False;
				}
				else
				{
				$this->jc_no->ReadOnly = True;
				}

				//if ($this->jc_no->CurrentValue > 0 )
				//{
				//$this->weaving_works->ReadOnly = True;
				//$this->current_works->ReadOnly = True;
				//}
				//else
				//{
				//$this->weaving_works->ReadOnly = False;
				//$this->current_works->ReadOnly = False;
				//}

	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>