<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class bcode_list extends bcode
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'bcode';

	// Page object name
	public $PageObjName = "bcode_list";

	// Grid form hidden field names
	public $FormName = "fbcodelist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (bcode)
		if (!isset($GLOBALS["bcode"]) || get_class($GLOBALS["bcode"]) == PROJECT_NAMESPACE . "bcode") {
			$GLOBALS["bcode"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bcode"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "bcodeadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "bcodedelete.php";
		$this->MultiUpdateUrl = "bcodeupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fbcodelistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $bcode;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($bcode);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->Visible = FALSE;
		$this->pid->Visible = FALSE;
		$this->po->setVisibility();
		$this->design_id->setVisibility();
		$this->size_cm->setVisibility();
		$this->_barcode->setVisibility();
		$this->process_d->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->order_date->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->dispatch_week_p->setVisibility();
		$this->loom_plan->Visible = FALSE;
		$this->status->setVisibility();
		$this->buyers_id->setVisibility();
		$this->buyer_uid->setVisibility();
		$this->buyer_loc->setVisibility();
		$this->quantity->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_u->setVisibility();
		$this->c_sqm->setVisibility();
		$this->weaving_works->setVisibility();
		$this->current_works->setVisibility();
		$this->size_buyer->Visible = FALSE;
		$this->design->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->q_sku->setVisibility();
		$this->po_price->setVisibility();
		$this->po_discount->setVisibility();
		$this->po_currency->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->payment_plan->Visible = FALSE;
		$this->production_plan->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->completed->setVisibility();
		$this->buyer_po->setVisibility();
		$this->operator->Visible = FALSE;
		$this->jc_no->Visible = FALSE;
		$this->sqm_a->Visible = FALSE;
		$this->_2srm->Visible = FALSE;
		$this->_2srm_a->Visible = FALSE;
		$this->_4srm->Visible = FALSE;
		$this->_4srm_a->Visible = FALSE;
		$this->buyer_tid->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->batch_no->setVisibility();
		$this->cs->setVisibility();
		$this->process->Visible = FALSE;
		$this->process_c->Visible = FALSE;
		$this->weight->setVisibility();
		$this->remarks->setVisibility();
		$this->roll_no->setVisibility();
		$this->qty->setVisibility();
		$this->pl_no->setVisibility();
		$this->category->setVisibility();
		$this->pp_id->Visible = FALSE;
		$this->consignee->Visible = FALSE;
		$this->buyer_barcode->setVisibility();
		$this->design_next->Visible = FALSE;
		$this->_11->setVisibility();
		$this->_12->setVisibility();
		$this->_13->setVisibility();
		$this->_14->setVisibility();
		$this->_15->setVisibility();
		$this->_16->setVisibility();
		$this->_17->setVisibility();
		$this->_18->setVisibility();
		$this->_19->setVisibility();
		$this->_20->setVisibility();
		$this->_21->setVisibility();
		$this->_22->setVisibility();
		$this->_23->setVisibility();
		$this->_24->setVisibility();
		$this->_25->setVisibility();
		$this->_26->setVisibility();
		$this->_27->setVisibility();
		$this->_28->setVisibility();
		$this->_29->setVisibility();
		$this->_30->setVisibility();
		$this->_31->setVisibility();
		$this->_32->setVisibility();
		$this->_33->setVisibility();
		$this->_34->setVisibility();
		$this->_35->setVisibility();
		$this->_36->setVisibility();
		$this->_37->setVisibility();
		$this->_38->setVisibility();
		$this->_39->setVisibility();
		$this->_40->setVisibility();
		$this->_41->setVisibility();
		$this->_42->setVisibility();
		$this->_43->setVisibility();
		$this->_44->setVisibility();
		$this->_45->setVisibility();
		$this->_46->setVisibility();
		$this->_47->setVisibility();
		$this->_48->setVisibility();
		$this->_49->setVisibility();
		$this->_50->setVisibility();
		$this->packing_type->Visible = FALSE;
		$this->qc_weaving->Visible = FALSE;
		$this->p_remarks->Visible = FALSE;
		$this->roll_no_qty_tmp->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->process_d);
		$this->setupLookupOptions($this->buyer_ref);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->dispatch_week_p);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->design);
		$this->setupLookupOptions($this->po_currency);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->payment_plan);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_c);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->pp_id);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fbcodelistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->pid->AdvancedSearch->toJson(), ","); // Field pid
		$filterList = Concat($filterList, $this->po->AdvancedSearch->toJson(), ","); // Field po
		$filterList = Concat($filterList, $this->design_id->AdvancedSearch->toJson(), ","); // Field design_id
		$filterList = Concat($filterList, $this->size_cm->AdvancedSearch->toJson(), ","); // Field size_cm
		$filterList = Concat($filterList, $this->_barcode->AdvancedSearch->toJson(), ","); // Field barcode
		$filterList = Concat($filterList, $this->process_d->AdvancedSearch->toJson(), ","); // Field process_d
		$filterList = Concat($filterList, $this->buyer_ref->AdvancedSearch->toJson(), ","); // Field buyer_ref
		$filterList = Concat($filterList, $this->order_date->AdvancedSearch->toJson(), ","); // Field order_date
		$filterList = Concat($filterList, $this->despatch_date->AdvancedSearch->toJson(), ","); // Field despatch_date
		$filterList = Concat($filterList, $this->despatch_week->AdvancedSearch->toJson(), ","); // Field despatch_week
		$filterList = Concat($filterList, $this->dispatch_week_p->AdvancedSearch->toJson(), ","); // Field dispatch_week_p
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->buyers_id->AdvancedSearch->toJson(), ","); // Field buyers_id
		$filterList = Concat($filterList, $this->buyer_uid->AdvancedSearch->toJson(), ","); // Field buyer_uid
		$filterList = Concat($filterList, $this->buyer_loc->AdvancedSearch->toJson(), ","); // Field buyer_loc
		$filterList = Concat($filterList, $this->quantity->AdvancedSearch->toJson(), ","); // Field quantity
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->sqm_u->AdvancedSearch->toJson(), ","); // Field sqm_u
		$filterList = Concat($filterList, $this->c_sqm->AdvancedSearch->toJson(), ","); // Field c_sqm
		$filterList = Concat($filterList, $this->weaving_works->AdvancedSearch->toJson(), ","); // Field weaving_works
		$filterList = Concat($filterList, $this->current_works->AdvancedSearch->toJson(), ","); // Field current_works
		$filterList = Concat($filterList, $this->size_buyer->AdvancedSearch->toJson(), ","); // Field size_buyer
		$filterList = Concat($filterList, $this->q_sku->AdvancedSearch->toJson(), ","); // Field q_sku
		$filterList = Concat($filterList, $this->po_price->AdvancedSearch->toJson(), ","); // Field po_price
		$filterList = Concat($filterList, $this->po_discount->AdvancedSearch->toJson(), ","); // Field po_discount
		$filterList = Concat($filterList, $this->po_currency->AdvancedSearch->toJson(), ","); // Field po_currency
		$filterList = Concat($filterList, $this->product_type->AdvancedSearch->toJson(), ","); // Field product_type
		$filterList = Concat($filterList, $this->shape->AdvancedSearch->toJson(), ","); // Field shape
		$filterList = Concat($filterList, $this->payment_plan->AdvancedSearch->toJson(), ","); // Field payment_plan
		$filterList = Concat($filterList, $this->production_plan->AdvancedSearch->toJson(), ","); // Field production_plan
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->completed->AdvancedSearch->toJson(), ","); // Field completed
		$filterList = Concat($filterList, $this->buyer_po->AdvancedSearch->toJson(), ","); // Field buyer_po
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->jc_no->AdvancedSearch->toJson(), ","); // Field jc_no
		$filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
		$filterList = Concat($filterList, $this->cs->AdvancedSearch->toJson(), ","); // Field cs
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->roll_no->AdvancedSearch->toJson(), ","); // Field roll_no
		$filterList = Concat($filterList, $this->qty->AdvancedSearch->toJson(), ","); // Field qty
		$filterList = Concat($filterList, $this->pl_no->AdvancedSearch->toJson(), ","); // Field pl_no
		$filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
		$filterList = Concat($filterList, $this->pp_id->AdvancedSearch->toJson(), ","); // Field pp_id
		$filterList = Concat($filterList, $this->_11->AdvancedSearch->toJson(), ","); // Field 11
		$filterList = Concat($filterList, $this->_12->AdvancedSearch->toJson(), ","); // Field 12
		$filterList = Concat($filterList, $this->_13->AdvancedSearch->toJson(), ","); // Field 13
		$filterList = Concat($filterList, $this->_14->AdvancedSearch->toJson(), ","); // Field 14
		$filterList = Concat($filterList, $this->_15->AdvancedSearch->toJson(), ","); // Field 15
		$filterList = Concat($filterList, $this->_16->AdvancedSearch->toJson(), ","); // Field 16
		$filterList = Concat($filterList, $this->_17->AdvancedSearch->toJson(), ","); // Field 17
		$filterList = Concat($filterList, $this->_18->AdvancedSearch->toJson(), ","); // Field 18
		$filterList = Concat($filterList, $this->_19->AdvancedSearch->toJson(), ","); // Field 19
		$filterList = Concat($filterList, $this->_20->AdvancedSearch->toJson(), ","); // Field 20
		$filterList = Concat($filterList, $this->_21->AdvancedSearch->toJson(), ","); // Field 21
		$filterList = Concat($filterList, $this->_22->AdvancedSearch->toJson(), ","); // Field 22
		$filterList = Concat($filterList, $this->_23->AdvancedSearch->toJson(), ","); // Field 23
		$filterList = Concat($filterList, $this->_24->AdvancedSearch->toJson(), ","); // Field 24
		$filterList = Concat($filterList, $this->_25->AdvancedSearch->toJson(), ","); // Field 25
		$filterList = Concat($filterList, $this->_26->AdvancedSearch->toJson(), ","); // Field 26
		$filterList = Concat($filterList, $this->_27->AdvancedSearch->toJson(), ","); // Field 27
		$filterList = Concat($filterList, $this->_28->AdvancedSearch->toJson(), ","); // Field 28
		$filterList = Concat($filterList, $this->_29->AdvancedSearch->toJson(), ","); // Field 29
		$filterList = Concat($filterList, $this->_30->AdvancedSearch->toJson(), ","); // Field 30
		$filterList = Concat($filterList, $this->_31->AdvancedSearch->toJson(), ","); // Field 31
		$filterList = Concat($filterList, $this->_32->AdvancedSearch->toJson(), ","); // Field 32
		$filterList = Concat($filterList, $this->_33->AdvancedSearch->toJson(), ","); // Field 33
		$filterList = Concat($filterList, $this->_34->AdvancedSearch->toJson(), ","); // Field 34
		$filterList = Concat($filterList, $this->_35->AdvancedSearch->toJson(), ","); // Field 35
		$filterList = Concat($filterList, $this->_36->AdvancedSearch->toJson(), ","); // Field 36
		$filterList = Concat($filterList, $this->_37->AdvancedSearch->toJson(), ","); // Field 37
		$filterList = Concat($filterList, $this->_38->AdvancedSearch->toJson(), ","); // Field 38
		$filterList = Concat($filterList, $this->_39->AdvancedSearch->toJson(), ","); // Field 39
		$filterList = Concat($filterList, $this->_40->AdvancedSearch->toJson(), ","); // Field 40
		$filterList = Concat($filterList, $this->_41->AdvancedSearch->toJson(), ","); // Field 41
		$filterList = Concat($filterList, $this->_42->AdvancedSearch->toJson(), ","); // Field 42
		$filterList = Concat($filterList, $this->_43->AdvancedSearch->toJson(), ","); // Field 43
		$filterList = Concat($filterList, $this->_44->AdvancedSearch->toJson(), ","); // Field 44
		$filterList = Concat($filterList, $this->_45->AdvancedSearch->toJson(), ","); // Field 45
		$filterList = Concat($filterList, $this->_46->AdvancedSearch->toJson(), ","); // Field 46
		$filterList = Concat($filterList, $this->_47->AdvancedSearch->toJson(), ","); // Field 47
		$filterList = Concat($filterList, $this->_48->AdvancedSearch->toJson(), ","); // Field 48
		$filterList = Concat($filterList, $this->_49->AdvancedSearch->toJson(), ","); // Field 49
		$filterList = Concat($filterList, $this->_50->AdvancedSearch->toJson(), ","); // Field 50
		$filterList = Concat($filterList, $this->p_remarks->AdvancedSearch->toJson(), ","); // Field p_remarks
		$filterList = Concat($filterList, $this->roll_no_qty_tmp->AdvancedSearch->toJson(), ","); // Field roll_no_qty_tmp
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fbcodelistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field pid
		$this->pid->AdvancedSearch->SearchValue = @$filter["x_pid"];
		$this->pid->AdvancedSearch->SearchOperator = @$filter["z_pid"];
		$this->pid->AdvancedSearch->SearchCondition = @$filter["v_pid"];
		$this->pid->AdvancedSearch->SearchValue2 = @$filter["y_pid"];
		$this->pid->AdvancedSearch->SearchOperator2 = @$filter["w_pid"];
		$this->pid->AdvancedSearch->save();

		// Field po
		$this->po->AdvancedSearch->SearchValue = @$filter["x_po"];
		$this->po->AdvancedSearch->SearchOperator = @$filter["z_po"];
		$this->po->AdvancedSearch->SearchCondition = @$filter["v_po"];
		$this->po->AdvancedSearch->SearchValue2 = @$filter["y_po"];
		$this->po->AdvancedSearch->SearchOperator2 = @$filter["w_po"];
		$this->po->AdvancedSearch->save();

		// Field design_id
		$this->design_id->AdvancedSearch->SearchValue = @$filter["x_design_id"];
		$this->design_id->AdvancedSearch->SearchOperator = @$filter["z_design_id"];
		$this->design_id->AdvancedSearch->SearchCondition = @$filter["v_design_id"];
		$this->design_id->AdvancedSearch->SearchValue2 = @$filter["y_design_id"];
		$this->design_id->AdvancedSearch->SearchOperator2 = @$filter["w_design_id"];
		$this->design_id->AdvancedSearch->save();

		// Field size_cm
		$this->size_cm->AdvancedSearch->SearchValue = @$filter["x_size_cm"];
		$this->size_cm->AdvancedSearch->SearchOperator = @$filter["z_size_cm"];
		$this->size_cm->AdvancedSearch->SearchCondition = @$filter["v_size_cm"];
		$this->size_cm->AdvancedSearch->SearchValue2 = @$filter["y_size_cm"];
		$this->size_cm->AdvancedSearch->SearchOperator2 = @$filter["w_size_cm"];
		$this->size_cm->AdvancedSearch->save();

		// Field barcode
		$this->_barcode->AdvancedSearch->SearchValue = @$filter["x__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator = @$filter["z__barcode"];
		$this->_barcode->AdvancedSearch->SearchCondition = @$filter["v__barcode"];
		$this->_barcode->AdvancedSearch->SearchValue2 = @$filter["y__barcode"];
		$this->_barcode->AdvancedSearch->SearchOperator2 = @$filter["w__barcode"];
		$this->_barcode->AdvancedSearch->save();

		// Field process_d
		$this->process_d->AdvancedSearch->SearchValue = @$filter["x_process_d"];
		$this->process_d->AdvancedSearch->SearchOperator = @$filter["z_process_d"];
		$this->process_d->AdvancedSearch->SearchCondition = @$filter["v_process_d"];
		$this->process_d->AdvancedSearch->SearchValue2 = @$filter["y_process_d"];
		$this->process_d->AdvancedSearch->SearchOperator2 = @$filter["w_process_d"];
		$this->process_d->AdvancedSearch->save();

		// Field buyer_ref
		$this->buyer_ref->AdvancedSearch->SearchValue = @$filter["x_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator = @$filter["z_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchCondition = @$filter["v_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchValue2 = @$filter["y_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_ref"];
		$this->buyer_ref->AdvancedSearch->save();

		// Field order_date
		$this->order_date->AdvancedSearch->SearchValue = @$filter["x_order_date"];
		$this->order_date->AdvancedSearch->SearchOperator = @$filter["z_order_date"];
		$this->order_date->AdvancedSearch->SearchCondition = @$filter["v_order_date"];
		$this->order_date->AdvancedSearch->SearchValue2 = @$filter["y_order_date"];
		$this->order_date->AdvancedSearch->SearchOperator2 = @$filter["w_order_date"];
		$this->order_date->AdvancedSearch->save();

		// Field despatch_date
		$this->despatch_date->AdvancedSearch->SearchValue = @$filter["x_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchOperator = @$filter["z_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchCondition = @$filter["v_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchValue2 = @$filter["y_despatch_date"];
		$this->despatch_date->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_date"];
		$this->despatch_date->AdvancedSearch->save();

		// Field despatch_week
		$this->despatch_week->AdvancedSearch->SearchValue = @$filter["x_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchOperator = @$filter["z_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchCondition = @$filter["v_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchValue2 = @$filter["y_despatch_week"];
		$this->despatch_week->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_week"];
		$this->despatch_week->AdvancedSearch->save();

		// Field dispatch_week_p
		$this->dispatch_week_p->AdvancedSearch->SearchValue = @$filter["x_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchOperator = @$filter["z_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchCondition = @$filter["v_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchValue2 = @$filter["y_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->SearchOperator2 = @$filter["w_dispatch_week_p"];
		$this->dispatch_week_p->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field buyers_id
		$this->buyers_id->AdvancedSearch->SearchValue = @$filter["x_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchOperator = @$filter["z_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchCondition = @$filter["v_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchValue2 = @$filter["y_buyers_id"];
		$this->buyers_id->AdvancedSearch->SearchOperator2 = @$filter["w_buyers_id"];
		$this->buyers_id->AdvancedSearch->save();

		// Field buyer_uid
		$this->buyer_uid->AdvancedSearch->SearchValue = @$filter["x_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchOperator = @$filter["z_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchCondition = @$filter["v_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchValue2 = @$filter["y_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_uid"];
		$this->buyer_uid->AdvancedSearch->save();

		// Field buyer_loc
		$this->buyer_loc->AdvancedSearch->SearchValue = @$filter["x_buyer_loc"];
		$this->buyer_loc->AdvancedSearch->SearchOperator = @$filter["z_buyer_loc"];
		$this->buyer_loc->AdvancedSearch->SearchCondition = @$filter["v_buyer_loc"];
		$this->buyer_loc->AdvancedSearch->SearchValue2 = @$filter["y_buyer_loc"];
		$this->buyer_loc->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_loc"];
		$this->buyer_loc->AdvancedSearch->save();

		// Field quantity
		$this->quantity->AdvancedSearch->SearchValue = @$filter["x_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator = @$filter["z_quantity"];
		$this->quantity->AdvancedSearch->SearchCondition = @$filter["v_quantity"];
		$this->quantity->AdvancedSearch->SearchValue2 = @$filter["y_quantity"];
		$this->quantity->AdvancedSearch->SearchOperator2 = @$filter["w_quantity"];
		$this->quantity->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field sqm_u
		$this->sqm_u->AdvancedSearch->SearchValue = @$filter["x_sqm_u"];
		$this->sqm_u->AdvancedSearch->SearchOperator = @$filter["z_sqm_u"];
		$this->sqm_u->AdvancedSearch->SearchCondition = @$filter["v_sqm_u"];
		$this->sqm_u->AdvancedSearch->SearchValue2 = @$filter["y_sqm_u"];
		$this->sqm_u->AdvancedSearch->SearchOperator2 = @$filter["w_sqm_u"];
		$this->sqm_u->AdvancedSearch->save();

		// Field c_sqm
		$this->c_sqm->AdvancedSearch->SearchValue = @$filter["x_c_sqm"];
		$this->c_sqm->AdvancedSearch->SearchOperator = @$filter["z_c_sqm"];
		$this->c_sqm->AdvancedSearch->SearchCondition = @$filter["v_c_sqm"];
		$this->c_sqm->AdvancedSearch->SearchValue2 = @$filter["y_c_sqm"];
		$this->c_sqm->AdvancedSearch->SearchOperator2 = @$filter["w_c_sqm"];
		$this->c_sqm->AdvancedSearch->save();

		// Field weaving_works
		$this->weaving_works->AdvancedSearch->SearchValue = @$filter["x_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchOperator = @$filter["z_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchCondition = @$filter["v_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchValue2 = @$filter["y_weaving_works"];
		$this->weaving_works->AdvancedSearch->SearchOperator2 = @$filter["w_weaving_works"];
		$this->weaving_works->AdvancedSearch->save();

		// Field current_works
		$this->current_works->AdvancedSearch->SearchValue = @$filter["x_current_works"];
		$this->current_works->AdvancedSearch->SearchOperator = @$filter["z_current_works"];
		$this->current_works->AdvancedSearch->SearchCondition = @$filter["v_current_works"];
		$this->current_works->AdvancedSearch->SearchValue2 = @$filter["y_current_works"];
		$this->current_works->AdvancedSearch->SearchOperator2 = @$filter["w_current_works"];
		$this->current_works->AdvancedSearch->save();

		// Field size_buyer
		$this->size_buyer->AdvancedSearch->SearchValue = @$filter["x_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchOperator = @$filter["z_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchCondition = @$filter["v_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchValue2 = @$filter["y_size_buyer"];
		$this->size_buyer->AdvancedSearch->SearchOperator2 = @$filter["w_size_buyer"];
		$this->size_buyer->AdvancedSearch->save();

		// Field q_sku
		$this->q_sku->AdvancedSearch->SearchValue = @$filter["x_q_sku"];
		$this->q_sku->AdvancedSearch->SearchOperator = @$filter["z_q_sku"];
		$this->q_sku->AdvancedSearch->SearchCondition = @$filter["v_q_sku"];
		$this->q_sku->AdvancedSearch->SearchValue2 = @$filter["y_q_sku"];
		$this->q_sku->AdvancedSearch->SearchOperator2 = @$filter["w_q_sku"];
		$this->q_sku->AdvancedSearch->save();

		// Field po_price
		$this->po_price->AdvancedSearch->SearchValue = @$filter["x_po_price"];
		$this->po_price->AdvancedSearch->SearchOperator = @$filter["z_po_price"];
		$this->po_price->AdvancedSearch->SearchCondition = @$filter["v_po_price"];
		$this->po_price->AdvancedSearch->SearchValue2 = @$filter["y_po_price"];
		$this->po_price->AdvancedSearch->SearchOperator2 = @$filter["w_po_price"];
		$this->po_price->AdvancedSearch->save();

		// Field po_discount
		$this->po_discount->AdvancedSearch->SearchValue = @$filter["x_po_discount"];
		$this->po_discount->AdvancedSearch->SearchOperator = @$filter["z_po_discount"];
		$this->po_discount->AdvancedSearch->SearchCondition = @$filter["v_po_discount"];
		$this->po_discount->AdvancedSearch->SearchValue2 = @$filter["y_po_discount"];
		$this->po_discount->AdvancedSearch->SearchOperator2 = @$filter["w_po_discount"];
		$this->po_discount->AdvancedSearch->save();

		// Field po_currency
		$this->po_currency->AdvancedSearch->SearchValue = @$filter["x_po_currency"];
		$this->po_currency->AdvancedSearch->SearchOperator = @$filter["z_po_currency"];
		$this->po_currency->AdvancedSearch->SearchCondition = @$filter["v_po_currency"];
		$this->po_currency->AdvancedSearch->SearchValue2 = @$filter["y_po_currency"];
		$this->po_currency->AdvancedSearch->SearchOperator2 = @$filter["w_po_currency"];
		$this->po_currency->AdvancedSearch->save();

		// Field product_type
		$this->product_type->AdvancedSearch->SearchValue = @$filter["x_product_type"];
		$this->product_type->AdvancedSearch->SearchOperator = @$filter["z_product_type"];
		$this->product_type->AdvancedSearch->SearchCondition = @$filter["v_product_type"];
		$this->product_type->AdvancedSearch->SearchValue2 = @$filter["y_product_type"];
		$this->product_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_type"];
		$this->product_type->AdvancedSearch->save();

		// Field shape
		$this->shape->AdvancedSearch->SearchValue = @$filter["x_shape"];
		$this->shape->AdvancedSearch->SearchOperator = @$filter["z_shape"];
		$this->shape->AdvancedSearch->SearchCondition = @$filter["v_shape"];
		$this->shape->AdvancedSearch->SearchValue2 = @$filter["y_shape"];
		$this->shape->AdvancedSearch->SearchOperator2 = @$filter["w_shape"];
		$this->shape->AdvancedSearch->save();

		// Field payment_plan
		$this->payment_plan->AdvancedSearch->SearchValue = @$filter["x_payment_plan"];
		$this->payment_plan->AdvancedSearch->SearchOperator = @$filter["z_payment_plan"];
		$this->payment_plan->AdvancedSearch->SearchCondition = @$filter["v_payment_plan"];
		$this->payment_plan->AdvancedSearch->SearchValue2 = @$filter["y_payment_plan"];
		$this->payment_plan->AdvancedSearch->SearchOperator2 = @$filter["w_payment_plan"];
		$this->payment_plan->AdvancedSearch->save();

		// Field production_plan
		$this->production_plan->AdvancedSearch->SearchValue = @$filter["x_production_plan"];
		$this->production_plan->AdvancedSearch->SearchOperator = @$filter["z_production_plan"];
		$this->production_plan->AdvancedSearch->SearchCondition = @$filter["v_production_plan"];
		$this->production_plan->AdvancedSearch->SearchValue2 = @$filter["y_production_plan"];
		$this->production_plan->AdvancedSearch->SearchOperator2 = @$filter["w_production_plan"];
		$this->production_plan->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field completed
		$this->completed->AdvancedSearch->SearchValue = @$filter["x_completed"];
		$this->completed->AdvancedSearch->SearchOperator = @$filter["z_completed"];
		$this->completed->AdvancedSearch->SearchCondition = @$filter["v_completed"];
		$this->completed->AdvancedSearch->SearchValue2 = @$filter["y_completed"];
		$this->completed->AdvancedSearch->SearchOperator2 = @$filter["w_completed"];
		$this->completed->AdvancedSearch->save();

		// Field buyer_po
		$this->buyer_po->AdvancedSearch->SearchValue = @$filter["x_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchOperator = @$filter["z_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchCondition = @$filter["v_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchValue2 = @$filter["y_buyer_po"];
		$this->buyer_po->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_po"];
		$this->buyer_po->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field jc_no
		$this->jc_no->AdvancedSearch->SearchValue = @$filter["x_jc_no"];
		$this->jc_no->AdvancedSearch->SearchOperator = @$filter["z_jc_no"];
		$this->jc_no->AdvancedSearch->SearchCondition = @$filter["v_jc_no"];
		$this->jc_no->AdvancedSearch->SearchValue2 = @$filter["y_jc_no"];
		$this->jc_no->AdvancedSearch->SearchOperator2 = @$filter["w_jc_no"];
		$this->jc_no->AdvancedSearch->save();

		// Field batch_no
		$this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
		$this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
		$this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
		$this->batch_no->AdvancedSearch->save();

		// Field cs
		$this->cs->AdvancedSearch->SearchValue = @$filter["x_cs"];
		$this->cs->AdvancedSearch->SearchOperator = @$filter["z_cs"];
		$this->cs->AdvancedSearch->SearchCondition = @$filter["v_cs"];
		$this->cs->AdvancedSearch->SearchValue2 = @$filter["y_cs"];
		$this->cs->AdvancedSearch->SearchOperator2 = @$filter["w_cs"];
		$this->cs->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field roll_no
		$this->roll_no->AdvancedSearch->SearchValue = @$filter["x_roll_no"];
		$this->roll_no->AdvancedSearch->SearchOperator = @$filter["z_roll_no"];
		$this->roll_no->AdvancedSearch->SearchCondition = @$filter["v_roll_no"];
		$this->roll_no->AdvancedSearch->SearchValue2 = @$filter["y_roll_no"];
		$this->roll_no->AdvancedSearch->SearchOperator2 = @$filter["w_roll_no"];
		$this->roll_no->AdvancedSearch->save();

		// Field qty
		$this->qty->AdvancedSearch->SearchValue = @$filter["x_qty"];
		$this->qty->AdvancedSearch->SearchOperator = @$filter["z_qty"];
		$this->qty->AdvancedSearch->SearchCondition = @$filter["v_qty"];
		$this->qty->AdvancedSearch->SearchValue2 = @$filter["y_qty"];
		$this->qty->AdvancedSearch->SearchOperator2 = @$filter["w_qty"];
		$this->qty->AdvancedSearch->save();

		// Field pl_no
		$this->pl_no->AdvancedSearch->SearchValue = @$filter["x_pl_no"];
		$this->pl_no->AdvancedSearch->SearchOperator = @$filter["z_pl_no"];
		$this->pl_no->AdvancedSearch->SearchCondition = @$filter["v_pl_no"];
		$this->pl_no->AdvancedSearch->SearchValue2 = @$filter["y_pl_no"];
		$this->pl_no->AdvancedSearch->SearchOperator2 = @$filter["w_pl_no"];
		$this->pl_no->AdvancedSearch->save();

		// Field category
		$this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
		$this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
		$this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
		$this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
		$this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
		$this->category->AdvancedSearch->save();

		// Field pp_id
		$this->pp_id->AdvancedSearch->SearchValue = @$filter["x_pp_id"];
		$this->pp_id->AdvancedSearch->SearchOperator = @$filter["z_pp_id"];
		$this->pp_id->AdvancedSearch->SearchCondition = @$filter["v_pp_id"];
		$this->pp_id->AdvancedSearch->SearchValue2 = @$filter["y_pp_id"];
		$this->pp_id->AdvancedSearch->SearchOperator2 = @$filter["w_pp_id"];
		$this->pp_id->AdvancedSearch->save();

		// Field 11
		$this->_11->AdvancedSearch->SearchValue = @$filter["x__11"];
		$this->_11->AdvancedSearch->SearchOperator = @$filter["z__11"];
		$this->_11->AdvancedSearch->SearchCondition = @$filter["v__11"];
		$this->_11->AdvancedSearch->SearchValue2 = @$filter["y__11"];
		$this->_11->AdvancedSearch->SearchOperator2 = @$filter["w__11"];
		$this->_11->AdvancedSearch->save();

		// Field 12
		$this->_12->AdvancedSearch->SearchValue = @$filter["x__12"];
		$this->_12->AdvancedSearch->SearchOperator = @$filter["z__12"];
		$this->_12->AdvancedSearch->SearchCondition = @$filter["v__12"];
		$this->_12->AdvancedSearch->SearchValue2 = @$filter["y__12"];
		$this->_12->AdvancedSearch->SearchOperator2 = @$filter["w__12"];
		$this->_12->AdvancedSearch->save();

		// Field 13
		$this->_13->AdvancedSearch->SearchValue = @$filter["x__13"];
		$this->_13->AdvancedSearch->SearchOperator = @$filter["z__13"];
		$this->_13->AdvancedSearch->SearchCondition = @$filter["v__13"];
		$this->_13->AdvancedSearch->SearchValue2 = @$filter["y__13"];
		$this->_13->AdvancedSearch->SearchOperator2 = @$filter["w__13"];
		$this->_13->AdvancedSearch->save();

		// Field 14
		$this->_14->AdvancedSearch->SearchValue = @$filter["x__14"];
		$this->_14->AdvancedSearch->SearchOperator = @$filter["z__14"];
		$this->_14->AdvancedSearch->SearchCondition = @$filter["v__14"];
		$this->_14->AdvancedSearch->SearchValue2 = @$filter["y__14"];
		$this->_14->AdvancedSearch->SearchOperator2 = @$filter["w__14"];
		$this->_14->AdvancedSearch->save();

		// Field 15
		$this->_15->AdvancedSearch->SearchValue = @$filter["x__15"];
		$this->_15->AdvancedSearch->SearchOperator = @$filter["z__15"];
		$this->_15->AdvancedSearch->SearchCondition = @$filter["v__15"];
		$this->_15->AdvancedSearch->SearchValue2 = @$filter["y__15"];
		$this->_15->AdvancedSearch->SearchOperator2 = @$filter["w__15"];
		$this->_15->AdvancedSearch->save();

		// Field 16
		$this->_16->AdvancedSearch->SearchValue = @$filter["x__16"];
		$this->_16->AdvancedSearch->SearchOperator = @$filter["z__16"];
		$this->_16->AdvancedSearch->SearchCondition = @$filter["v__16"];
		$this->_16->AdvancedSearch->SearchValue2 = @$filter["y__16"];
		$this->_16->AdvancedSearch->SearchOperator2 = @$filter["w__16"];
		$this->_16->AdvancedSearch->save();

		// Field 17
		$this->_17->AdvancedSearch->SearchValue = @$filter["x__17"];
		$this->_17->AdvancedSearch->SearchOperator = @$filter["z__17"];
		$this->_17->AdvancedSearch->SearchCondition = @$filter["v__17"];
		$this->_17->AdvancedSearch->SearchValue2 = @$filter["y__17"];
		$this->_17->AdvancedSearch->SearchOperator2 = @$filter["w__17"];
		$this->_17->AdvancedSearch->save();

		// Field 18
		$this->_18->AdvancedSearch->SearchValue = @$filter["x__18"];
		$this->_18->AdvancedSearch->SearchOperator = @$filter["z__18"];
		$this->_18->AdvancedSearch->SearchCondition = @$filter["v__18"];
		$this->_18->AdvancedSearch->SearchValue2 = @$filter["y__18"];
		$this->_18->AdvancedSearch->SearchOperator2 = @$filter["w__18"];
		$this->_18->AdvancedSearch->save();

		// Field 19
		$this->_19->AdvancedSearch->SearchValue = @$filter["x__19"];
		$this->_19->AdvancedSearch->SearchOperator = @$filter["z__19"];
		$this->_19->AdvancedSearch->SearchCondition = @$filter["v__19"];
		$this->_19->AdvancedSearch->SearchValue2 = @$filter["y__19"];
		$this->_19->AdvancedSearch->SearchOperator2 = @$filter["w__19"];
		$this->_19->AdvancedSearch->save();

		// Field 20
		$this->_20->AdvancedSearch->SearchValue = @$filter["x__20"];
		$this->_20->AdvancedSearch->SearchOperator = @$filter["z__20"];
		$this->_20->AdvancedSearch->SearchCondition = @$filter["v__20"];
		$this->_20->AdvancedSearch->SearchValue2 = @$filter["y__20"];
		$this->_20->AdvancedSearch->SearchOperator2 = @$filter["w__20"];
		$this->_20->AdvancedSearch->save();

		// Field 21
		$this->_21->AdvancedSearch->SearchValue = @$filter["x__21"];
		$this->_21->AdvancedSearch->SearchOperator = @$filter["z__21"];
		$this->_21->AdvancedSearch->SearchCondition = @$filter["v__21"];
		$this->_21->AdvancedSearch->SearchValue2 = @$filter["y__21"];
		$this->_21->AdvancedSearch->SearchOperator2 = @$filter["w__21"];
		$this->_21->AdvancedSearch->save();

		// Field 22
		$this->_22->AdvancedSearch->SearchValue = @$filter["x__22"];
		$this->_22->AdvancedSearch->SearchOperator = @$filter["z__22"];
		$this->_22->AdvancedSearch->SearchCondition = @$filter["v__22"];
		$this->_22->AdvancedSearch->SearchValue2 = @$filter["y__22"];
		$this->_22->AdvancedSearch->SearchOperator2 = @$filter["w__22"];
		$this->_22->AdvancedSearch->save();

		// Field 23
		$this->_23->AdvancedSearch->SearchValue = @$filter["x__23"];
		$this->_23->AdvancedSearch->SearchOperator = @$filter["z__23"];
		$this->_23->AdvancedSearch->SearchCondition = @$filter["v__23"];
		$this->_23->AdvancedSearch->SearchValue2 = @$filter["y__23"];
		$this->_23->AdvancedSearch->SearchOperator2 = @$filter["w__23"];
		$this->_23->AdvancedSearch->save();

		// Field 24
		$this->_24->AdvancedSearch->SearchValue = @$filter["x__24"];
		$this->_24->AdvancedSearch->SearchOperator = @$filter["z__24"];
		$this->_24->AdvancedSearch->SearchCondition = @$filter["v__24"];
		$this->_24->AdvancedSearch->SearchValue2 = @$filter["y__24"];
		$this->_24->AdvancedSearch->SearchOperator2 = @$filter["w__24"];
		$this->_24->AdvancedSearch->save();

		// Field 25
		$this->_25->AdvancedSearch->SearchValue = @$filter["x__25"];
		$this->_25->AdvancedSearch->SearchOperator = @$filter["z__25"];
		$this->_25->AdvancedSearch->SearchCondition = @$filter["v__25"];
		$this->_25->AdvancedSearch->SearchValue2 = @$filter["y__25"];
		$this->_25->AdvancedSearch->SearchOperator2 = @$filter["w__25"];
		$this->_25->AdvancedSearch->save();

		// Field 26
		$this->_26->AdvancedSearch->SearchValue = @$filter["x__26"];
		$this->_26->AdvancedSearch->SearchOperator = @$filter["z__26"];
		$this->_26->AdvancedSearch->SearchCondition = @$filter["v__26"];
		$this->_26->AdvancedSearch->SearchValue2 = @$filter["y__26"];
		$this->_26->AdvancedSearch->SearchOperator2 = @$filter["w__26"];
		$this->_26->AdvancedSearch->save();

		// Field 27
		$this->_27->AdvancedSearch->SearchValue = @$filter["x__27"];
		$this->_27->AdvancedSearch->SearchOperator = @$filter["z__27"];
		$this->_27->AdvancedSearch->SearchCondition = @$filter["v__27"];
		$this->_27->AdvancedSearch->SearchValue2 = @$filter["y__27"];
		$this->_27->AdvancedSearch->SearchOperator2 = @$filter["w__27"];
		$this->_27->AdvancedSearch->save();

		// Field 28
		$this->_28->AdvancedSearch->SearchValue = @$filter["x__28"];
		$this->_28->AdvancedSearch->SearchOperator = @$filter["z__28"];
		$this->_28->AdvancedSearch->SearchCondition = @$filter["v__28"];
		$this->_28->AdvancedSearch->SearchValue2 = @$filter["y__28"];
		$this->_28->AdvancedSearch->SearchOperator2 = @$filter["w__28"];
		$this->_28->AdvancedSearch->save();

		// Field 29
		$this->_29->AdvancedSearch->SearchValue = @$filter["x__29"];
		$this->_29->AdvancedSearch->SearchOperator = @$filter["z__29"];
		$this->_29->AdvancedSearch->SearchCondition = @$filter["v__29"];
		$this->_29->AdvancedSearch->SearchValue2 = @$filter["y__29"];
		$this->_29->AdvancedSearch->SearchOperator2 = @$filter["w__29"];
		$this->_29->AdvancedSearch->save();

		// Field 30
		$this->_30->AdvancedSearch->SearchValue = @$filter["x__30"];
		$this->_30->AdvancedSearch->SearchOperator = @$filter["z__30"];
		$this->_30->AdvancedSearch->SearchCondition = @$filter["v__30"];
		$this->_30->AdvancedSearch->SearchValue2 = @$filter["y__30"];
		$this->_30->AdvancedSearch->SearchOperator2 = @$filter["w__30"];
		$this->_30->AdvancedSearch->save();

		// Field 31
		$this->_31->AdvancedSearch->SearchValue = @$filter["x__31"];
		$this->_31->AdvancedSearch->SearchOperator = @$filter["z__31"];
		$this->_31->AdvancedSearch->SearchCondition = @$filter["v__31"];
		$this->_31->AdvancedSearch->SearchValue2 = @$filter["y__31"];
		$this->_31->AdvancedSearch->SearchOperator2 = @$filter["w__31"];
		$this->_31->AdvancedSearch->save();

		// Field 32
		$this->_32->AdvancedSearch->SearchValue = @$filter["x__32"];
		$this->_32->AdvancedSearch->SearchOperator = @$filter["z__32"];
		$this->_32->AdvancedSearch->SearchCondition = @$filter["v__32"];
		$this->_32->AdvancedSearch->SearchValue2 = @$filter["y__32"];
		$this->_32->AdvancedSearch->SearchOperator2 = @$filter["w__32"];
		$this->_32->AdvancedSearch->save();

		// Field 33
		$this->_33->AdvancedSearch->SearchValue = @$filter["x__33"];
		$this->_33->AdvancedSearch->SearchOperator = @$filter["z__33"];
		$this->_33->AdvancedSearch->SearchCondition = @$filter["v__33"];
		$this->_33->AdvancedSearch->SearchValue2 = @$filter["y__33"];
		$this->_33->AdvancedSearch->SearchOperator2 = @$filter["w__33"];
		$this->_33->AdvancedSearch->save();

		// Field 34
		$this->_34->AdvancedSearch->SearchValue = @$filter["x__34"];
		$this->_34->AdvancedSearch->SearchOperator = @$filter["z__34"];
		$this->_34->AdvancedSearch->SearchCondition = @$filter["v__34"];
		$this->_34->AdvancedSearch->SearchValue2 = @$filter["y__34"];
		$this->_34->AdvancedSearch->SearchOperator2 = @$filter["w__34"];
		$this->_34->AdvancedSearch->save();

		// Field 35
		$this->_35->AdvancedSearch->SearchValue = @$filter["x__35"];
		$this->_35->AdvancedSearch->SearchOperator = @$filter["z__35"];
		$this->_35->AdvancedSearch->SearchCondition = @$filter["v__35"];
		$this->_35->AdvancedSearch->SearchValue2 = @$filter["y__35"];
		$this->_35->AdvancedSearch->SearchOperator2 = @$filter["w__35"];
		$this->_35->AdvancedSearch->save();

		// Field 36
		$this->_36->AdvancedSearch->SearchValue = @$filter["x__36"];
		$this->_36->AdvancedSearch->SearchOperator = @$filter["z__36"];
		$this->_36->AdvancedSearch->SearchCondition = @$filter["v__36"];
		$this->_36->AdvancedSearch->SearchValue2 = @$filter["y__36"];
		$this->_36->AdvancedSearch->SearchOperator2 = @$filter["w__36"];
		$this->_36->AdvancedSearch->save();

		// Field 37
		$this->_37->AdvancedSearch->SearchValue = @$filter["x__37"];
		$this->_37->AdvancedSearch->SearchOperator = @$filter["z__37"];
		$this->_37->AdvancedSearch->SearchCondition = @$filter["v__37"];
		$this->_37->AdvancedSearch->SearchValue2 = @$filter["y__37"];
		$this->_37->AdvancedSearch->SearchOperator2 = @$filter["w__37"];
		$this->_37->AdvancedSearch->save();

		// Field 38
		$this->_38->AdvancedSearch->SearchValue = @$filter["x__38"];
		$this->_38->AdvancedSearch->SearchOperator = @$filter["z__38"];
		$this->_38->AdvancedSearch->SearchCondition = @$filter["v__38"];
		$this->_38->AdvancedSearch->SearchValue2 = @$filter["y__38"];
		$this->_38->AdvancedSearch->SearchOperator2 = @$filter["w__38"];
		$this->_38->AdvancedSearch->save();

		// Field 39
		$this->_39->AdvancedSearch->SearchValue = @$filter["x__39"];
		$this->_39->AdvancedSearch->SearchOperator = @$filter["z__39"];
		$this->_39->AdvancedSearch->SearchCondition = @$filter["v__39"];
		$this->_39->AdvancedSearch->SearchValue2 = @$filter["y__39"];
		$this->_39->AdvancedSearch->SearchOperator2 = @$filter["w__39"];
		$this->_39->AdvancedSearch->save();

		// Field 40
		$this->_40->AdvancedSearch->SearchValue = @$filter["x__40"];
		$this->_40->AdvancedSearch->SearchOperator = @$filter["z__40"];
		$this->_40->AdvancedSearch->SearchCondition = @$filter["v__40"];
		$this->_40->AdvancedSearch->SearchValue2 = @$filter["y__40"];
		$this->_40->AdvancedSearch->SearchOperator2 = @$filter["w__40"];
		$this->_40->AdvancedSearch->save();

		// Field 41
		$this->_41->AdvancedSearch->SearchValue = @$filter["x__41"];
		$this->_41->AdvancedSearch->SearchOperator = @$filter["z__41"];
		$this->_41->AdvancedSearch->SearchCondition = @$filter["v__41"];
		$this->_41->AdvancedSearch->SearchValue2 = @$filter["y__41"];
		$this->_41->AdvancedSearch->SearchOperator2 = @$filter["w__41"];
		$this->_41->AdvancedSearch->save();

		// Field 42
		$this->_42->AdvancedSearch->SearchValue = @$filter["x__42"];
		$this->_42->AdvancedSearch->SearchOperator = @$filter["z__42"];
		$this->_42->AdvancedSearch->SearchCondition = @$filter["v__42"];
		$this->_42->AdvancedSearch->SearchValue2 = @$filter["y__42"];
		$this->_42->AdvancedSearch->SearchOperator2 = @$filter["w__42"];
		$this->_42->AdvancedSearch->save();

		// Field 43
		$this->_43->AdvancedSearch->SearchValue = @$filter["x__43"];
		$this->_43->AdvancedSearch->SearchOperator = @$filter["z__43"];
		$this->_43->AdvancedSearch->SearchCondition = @$filter["v__43"];
		$this->_43->AdvancedSearch->SearchValue2 = @$filter["y__43"];
		$this->_43->AdvancedSearch->SearchOperator2 = @$filter["w__43"];
		$this->_43->AdvancedSearch->save();

		// Field 44
		$this->_44->AdvancedSearch->SearchValue = @$filter["x__44"];
		$this->_44->AdvancedSearch->SearchOperator = @$filter["z__44"];
		$this->_44->AdvancedSearch->SearchCondition = @$filter["v__44"];
		$this->_44->AdvancedSearch->SearchValue2 = @$filter["y__44"];
		$this->_44->AdvancedSearch->SearchOperator2 = @$filter["w__44"];
		$this->_44->AdvancedSearch->save();

		// Field 45
		$this->_45->AdvancedSearch->SearchValue = @$filter["x__45"];
		$this->_45->AdvancedSearch->SearchOperator = @$filter["z__45"];
		$this->_45->AdvancedSearch->SearchCondition = @$filter["v__45"];
		$this->_45->AdvancedSearch->SearchValue2 = @$filter["y__45"];
		$this->_45->AdvancedSearch->SearchOperator2 = @$filter["w__45"];
		$this->_45->AdvancedSearch->save();

		// Field 46
		$this->_46->AdvancedSearch->SearchValue = @$filter["x__46"];
		$this->_46->AdvancedSearch->SearchOperator = @$filter["z__46"];
		$this->_46->AdvancedSearch->SearchCondition = @$filter["v__46"];
		$this->_46->AdvancedSearch->SearchValue2 = @$filter["y__46"];
		$this->_46->AdvancedSearch->SearchOperator2 = @$filter["w__46"];
		$this->_46->AdvancedSearch->save();

		// Field 47
		$this->_47->AdvancedSearch->SearchValue = @$filter["x__47"];
		$this->_47->AdvancedSearch->SearchOperator = @$filter["z__47"];
		$this->_47->AdvancedSearch->SearchCondition = @$filter["v__47"];
		$this->_47->AdvancedSearch->SearchValue2 = @$filter["y__47"];
		$this->_47->AdvancedSearch->SearchOperator2 = @$filter["w__47"];
		$this->_47->AdvancedSearch->save();

		// Field 48
		$this->_48->AdvancedSearch->SearchValue = @$filter["x__48"];
		$this->_48->AdvancedSearch->SearchOperator = @$filter["z__48"];
		$this->_48->AdvancedSearch->SearchCondition = @$filter["v__48"];
		$this->_48->AdvancedSearch->SearchValue2 = @$filter["y__48"];
		$this->_48->AdvancedSearch->SearchOperator2 = @$filter["w__48"];
		$this->_48->AdvancedSearch->save();

		// Field 49
		$this->_49->AdvancedSearch->SearchValue = @$filter["x__49"];
		$this->_49->AdvancedSearch->SearchOperator = @$filter["z__49"];
		$this->_49->AdvancedSearch->SearchCondition = @$filter["v__49"];
		$this->_49->AdvancedSearch->SearchValue2 = @$filter["y__49"];
		$this->_49->AdvancedSearch->SearchOperator2 = @$filter["w__49"];
		$this->_49->AdvancedSearch->save();

		// Field 50
		$this->_50->AdvancedSearch->SearchValue = @$filter["x__50"];
		$this->_50->AdvancedSearch->SearchOperator = @$filter["z__50"];
		$this->_50->AdvancedSearch->SearchCondition = @$filter["v__50"];
		$this->_50->AdvancedSearch->SearchValue2 = @$filter["y__50"];
		$this->_50->AdvancedSearch->SearchOperator2 = @$filter["w__50"];
		$this->_50->AdvancedSearch->save();

		// Field p_remarks
		$this->p_remarks->AdvancedSearch->SearchValue = @$filter["x_p_remarks"];
		$this->p_remarks->AdvancedSearch->SearchOperator = @$filter["z_p_remarks"];
		$this->p_remarks->AdvancedSearch->SearchCondition = @$filter["v_p_remarks"];
		$this->p_remarks->AdvancedSearch->SearchValue2 = @$filter["y_p_remarks"];
		$this->p_remarks->AdvancedSearch->SearchOperator2 = @$filter["w_p_remarks"];
		$this->p_remarks->AdvancedSearch->save();

		// Field roll_no_qty_tmp
		$this->roll_no_qty_tmp->AdvancedSearch->SearchValue = @$filter["x_roll_no_qty_tmp"];
		$this->roll_no_qty_tmp->AdvancedSearch->SearchOperator = @$filter["z_roll_no_qty_tmp"];
		$this->roll_no_qty_tmp->AdvancedSearch->SearchCondition = @$filter["v_roll_no_qty_tmp"];
		$this->roll_no_qty_tmp->AdvancedSearch->SearchValue2 = @$filter["y_roll_no_qty_tmp"];
		$this->roll_no_qty_tmp->AdvancedSearch->SearchOperator2 = @$filter["w_roll_no_qty_tmp"];
		$this->roll_no_qty_tmp->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->pid, $default, FALSE); // pid
		$this->buildSearchSql($where, $this->po, $default, FALSE); // po
		$this->buildSearchSql($where, $this->design_id, $default, FALSE); // design_id
		$this->buildSearchSql($where, $this->size_cm, $default, FALSE); // size_cm
		$this->buildSearchSql($where, $this->_barcode, $default, FALSE); // barcode
		$this->buildSearchSql($where, $this->process_d, $default, TRUE); // process_d
		$this->buildSearchSql($where, $this->buyer_ref, $default, FALSE); // buyer_ref
		$this->buildSearchSql($where, $this->order_date, $default, FALSE); // order_date
		$this->buildSearchSql($where, $this->despatch_date, $default, FALSE); // despatch_date
		$this->buildSearchSql($where, $this->despatch_week, $default, FALSE); // despatch_week
		$this->buildSearchSql($where, $this->dispatch_week_p, $default, FALSE); // dispatch_week_p
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->buyers_id, $default, FALSE); // buyers_id
		$this->buildSearchSql($where, $this->buyer_uid, $default, FALSE); // buyer_uid
		$this->buildSearchSql($where, $this->buyer_loc, $default, FALSE); // buyer_loc
		$this->buildSearchSql($where, $this->quantity, $default, FALSE); // quantity
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->sqm_u, $default, FALSE); // sqm_u
		$this->buildSearchSql($where, $this->c_sqm, $default, FALSE); // c_sqm
		$this->buildSearchSql($where, $this->weaving_works, $default, FALSE); // weaving_works
		$this->buildSearchSql($where, $this->current_works, $default, FALSE); // current_works
		$this->buildSearchSql($where, $this->size_buyer, $default, FALSE); // size_buyer
		$this->buildSearchSql($where, $this->q_sku, $default, FALSE); // q_sku
		$this->buildSearchSql($where, $this->po_price, $default, FALSE); // po_price
		$this->buildSearchSql($where, $this->po_discount, $default, FALSE); // po_discount
		$this->buildSearchSql($where, $this->po_currency, $default, FALSE); // po_currency
		$this->buildSearchSql($where, $this->product_type, $default, FALSE); // product_type
		$this->buildSearchSql($where, $this->shape, $default, FALSE); // shape
		$this->buildSearchSql($where, $this->payment_plan, $default, FALSE); // payment_plan
		$this->buildSearchSql($where, $this->production_plan, $default, FALSE); // production_plan
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->completed, $default, FALSE); // completed
		$this->buildSearchSql($where, $this->buyer_po, $default, FALSE); // buyer_po
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->jc_no, $default, FALSE); // jc_no
		$this->buildSearchSql($where, $this->batch_no, $default, FALSE); // batch_no
		$this->buildSearchSql($where, $this->cs, $default, FALSE); // cs
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->roll_no, $default, FALSE); // roll_no
		$this->buildSearchSql($where, $this->qty, $default, FALSE); // qty
		$this->buildSearchSql($where, $this->pl_no, $default, FALSE); // pl_no
		$this->buildSearchSql($where, $this->category, $default, FALSE); // category
		$this->buildSearchSql($where, $this->pp_id, $default, FALSE); // pp_id
		$this->buildSearchSql($where, $this->_11, $default, FALSE); // 11
		$this->buildSearchSql($where, $this->_12, $default, FALSE); // 12
		$this->buildSearchSql($where, $this->_13, $default, FALSE); // 13
		$this->buildSearchSql($where, $this->_14, $default, FALSE); // 14
		$this->buildSearchSql($where, $this->_15, $default, FALSE); // 15
		$this->buildSearchSql($where, $this->_16, $default, FALSE); // 16
		$this->buildSearchSql($where, $this->_17, $default, FALSE); // 17
		$this->buildSearchSql($where, $this->_18, $default, FALSE); // 18
		$this->buildSearchSql($where, $this->_19, $default, FALSE); // 19
		$this->buildSearchSql($where, $this->_20, $default, FALSE); // 20
		$this->buildSearchSql($where, $this->_21, $default, FALSE); // 21
		$this->buildSearchSql($where, $this->_22, $default, FALSE); // 22
		$this->buildSearchSql($where, $this->_23, $default, FALSE); // 23
		$this->buildSearchSql($where, $this->_24, $default, FALSE); // 24
		$this->buildSearchSql($where, $this->_25, $default, FALSE); // 25
		$this->buildSearchSql($where, $this->_26, $default, FALSE); // 26
		$this->buildSearchSql($where, $this->_27, $default, FALSE); // 27
		$this->buildSearchSql($where, $this->_28, $default, FALSE); // 28
		$this->buildSearchSql($where, $this->_29, $default, FALSE); // 29
		$this->buildSearchSql($where, $this->_30, $default, FALSE); // 30
		$this->buildSearchSql($where, $this->_31, $default, FALSE); // 31
		$this->buildSearchSql($where, $this->_32, $default, FALSE); // 32
		$this->buildSearchSql($where, $this->_33, $default, FALSE); // 33
		$this->buildSearchSql($where, $this->_34, $default, FALSE); // 34
		$this->buildSearchSql($where, $this->_35, $default, FALSE); // 35
		$this->buildSearchSql($where, $this->_36, $default, FALSE); // 36
		$this->buildSearchSql($where, $this->_37, $default, FALSE); // 37
		$this->buildSearchSql($where, $this->_38, $default, FALSE); // 38
		$this->buildSearchSql($where, $this->_39, $default, FALSE); // 39
		$this->buildSearchSql($where, $this->_40, $default, FALSE); // 40
		$this->buildSearchSql($where, $this->_41, $default, FALSE); // 41
		$this->buildSearchSql($where, $this->_42, $default, FALSE); // 42
		$this->buildSearchSql($where, $this->_43, $default, FALSE); // 43
		$this->buildSearchSql($where, $this->_44, $default, FALSE); // 44
		$this->buildSearchSql($where, $this->_45, $default, FALSE); // 45
		$this->buildSearchSql($where, $this->_46, $default, FALSE); // 46
		$this->buildSearchSql($where, $this->_47, $default, FALSE); // 47
		$this->buildSearchSql($where, $this->_48, $default, FALSE); // 48
		$this->buildSearchSql($where, $this->_49, $default, FALSE); // 49
		$this->buildSearchSql($where, $this->_50, $default, FALSE); // 50
		$this->buildSearchSql($where, $this->p_remarks, $default, FALSE); // p_remarks
		$this->buildSearchSql($where, $this->roll_no_qty_tmp, $default, FALSE); // roll_no_qty_tmp

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->pid->AdvancedSearch->save(); // pid
			$this->po->AdvancedSearch->save(); // po
			$this->design_id->AdvancedSearch->save(); // design_id
			$this->size_cm->AdvancedSearch->save(); // size_cm
			$this->_barcode->AdvancedSearch->save(); // barcode
			$this->process_d->AdvancedSearch->save(); // process_d
			$this->buyer_ref->AdvancedSearch->save(); // buyer_ref
			$this->order_date->AdvancedSearch->save(); // order_date
			$this->despatch_date->AdvancedSearch->save(); // despatch_date
			$this->despatch_week->AdvancedSearch->save(); // despatch_week
			$this->dispatch_week_p->AdvancedSearch->save(); // dispatch_week_p
			$this->status->AdvancedSearch->save(); // status
			$this->buyers_id->AdvancedSearch->save(); // buyers_id
			$this->buyer_uid->AdvancedSearch->save(); // buyer_uid
			$this->buyer_loc->AdvancedSearch->save(); // buyer_loc
			$this->quantity->AdvancedSearch->save(); // quantity
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->sqm_u->AdvancedSearch->save(); // sqm_u
			$this->c_sqm->AdvancedSearch->save(); // c_sqm
			$this->weaving_works->AdvancedSearch->save(); // weaving_works
			$this->current_works->AdvancedSearch->save(); // current_works
			$this->size_buyer->AdvancedSearch->save(); // size_buyer
			$this->q_sku->AdvancedSearch->save(); // q_sku
			$this->po_price->AdvancedSearch->save(); // po_price
			$this->po_discount->AdvancedSearch->save(); // po_discount
			$this->po_currency->AdvancedSearch->save(); // po_currency
			$this->product_type->AdvancedSearch->save(); // product_type
			$this->shape->AdvancedSearch->save(); // shape
			$this->payment_plan->AdvancedSearch->save(); // payment_plan
			$this->production_plan->AdvancedSearch->save(); // production_plan
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->completed->AdvancedSearch->save(); // completed
			$this->buyer_po->AdvancedSearch->save(); // buyer_po
			$this->operator->AdvancedSearch->save(); // operator
			$this->jc_no->AdvancedSearch->save(); // jc_no
			$this->batch_no->AdvancedSearch->save(); // batch_no
			$this->cs->AdvancedSearch->save(); // cs
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->roll_no->AdvancedSearch->save(); // roll_no
			$this->qty->AdvancedSearch->save(); // qty
			$this->pl_no->AdvancedSearch->save(); // pl_no
			$this->category->AdvancedSearch->save(); // category
			$this->pp_id->AdvancedSearch->save(); // pp_id
			$this->_11->AdvancedSearch->save(); // 11
			$this->_12->AdvancedSearch->save(); // 12
			$this->_13->AdvancedSearch->save(); // 13
			$this->_14->AdvancedSearch->save(); // 14
			$this->_15->AdvancedSearch->save(); // 15
			$this->_16->AdvancedSearch->save(); // 16
			$this->_17->AdvancedSearch->save(); // 17
			$this->_18->AdvancedSearch->save(); // 18
			$this->_19->AdvancedSearch->save(); // 19
			$this->_20->AdvancedSearch->save(); // 20
			$this->_21->AdvancedSearch->save(); // 21
			$this->_22->AdvancedSearch->save(); // 22
			$this->_23->AdvancedSearch->save(); // 23
			$this->_24->AdvancedSearch->save(); // 24
			$this->_25->AdvancedSearch->save(); // 25
			$this->_26->AdvancedSearch->save(); // 26
			$this->_27->AdvancedSearch->save(); // 27
			$this->_28->AdvancedSearch->save(); // 28
			$this->_29->AdvancedSearch->save(); // 29
			$this->_30->AdvancedSearch->save(); // 30
			$this->_31->AdvancedSearch->save(); // 31
			$this->_32->AdvancedSearch->save(); // 32
			$this->_33->AdvancedSearch->save(); // 33
			$this->_34->AdvancedSearch->save(); // 34
			$this->_35->AdvancedSearch->save(); // 35
			$this->_36->AdvancedSearch->save(); // 36
			$this->_37->AdvancedSearch->save(); // 37
			$this->_38->AdvancedSearch->save(); // 38
			$this->_39->AdvancedSearch->save(); // 39
			$this->_40->AdvancedSearch->save(); // 40
			$this->_41->AdvancedSearch->save(); // 41
			$this->_42->AdvancedSearch->save(); // 42
			$this->_43->AdvancedSearch->save(); // 43
			$this->_44->AdvancedSearch->save(); // 44
			$this->_45->AdvancedSearch->save(); // 45
			$this->_46->AdvancedSearch->save(); // 46
			$this->_47->AdvancedSearch->save(); // 47
			$this->_48->AdvancedSearch->save(); // 48
			$this->_49->AdvancedSearch->save(); // 49
			$this->_50->AdvancedSearch->save(); // 50
			$this->p_remarks->AdvancedSearch->save(); // p_remarks
			$this->roll_no_qty_tmp->AdvancedSearch->save(); // roll_no_qty_tmp
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->design_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->size_cm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_barcode, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->process_d, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->despatch_date, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->despatch_week, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->loom_plan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyers_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_uid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_loc, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->quantity, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sqm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->weaving_works, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->current_works, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->size_buyer, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->design, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->w_cm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->l_cm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->po_price, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->shape, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->payment_plan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->production_plan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->completed, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_po, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->jc_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sqm_a, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_2srm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_2srm_a, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_4srm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_4srm_a, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_tid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->batch_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cs, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->process, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->process_c, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->category, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pp_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer_barcode, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->p_remarks, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->design_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->size_cm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_barcode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->process_d->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->order_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->despatch_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->despatch_week->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->dispatch_week_p->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyers_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_uid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_loc->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->quantity->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm_u->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->c_sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->weaving_works->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->current_works->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->size_buyer->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->q_sku->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_price->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_discount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_currency->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->shape->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->payment_plan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->production_plan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->completed->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_po->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->batch_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->roll_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pl_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->category->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pp_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_13->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_14->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_15->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_16->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_17->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_18->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_19->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_20->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_21->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_22->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_23->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_24->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_25->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_26->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_27->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_28->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_29->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_30->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_31->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_32->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_33->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_34->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_35->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_36->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_37->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_38->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_39->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_40->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_41->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_42->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_43->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_44->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_45->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_46->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_47->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_48->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_49->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_50->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->p_remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->roll_no_qty_tmp->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->pid->AdvancedSearch->unsetSession();
		$this->po->AdvancedSearch->unsetSession();
		$this->design_id->AdvancedSearch->unsetSession();
		$this->size_cm->AdvancedSearch->unsetSession();
		$this->_barcode->AdvancedSearch->unsetSession();
		$this->process_d->AdvancedSearch->unsetSession();
		$this->buyer_ref->AdvancedSearch->unsetSession();
		$this->order_date->AdvancedSearch->unsetSession();
		$this->despatch_date->AdvancedSearch->unsetSession();
		$this->despatch_week->AdvancedSearch->unsetSession();
		$this->dispatch_week_p->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->buyers_id->AdvancedSearch->unsetSession();
		$this->buyer_uid->AdvancedSearch->unsetSession();
		$this->buyer_loc->AdvancedSearch->unsetSession();
		$this->quantity->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->sqm_u->AdvancedSearch->unsetSession();
		$this->c_sqm->AdvancedSearch->unsetSession();
		$this->weaving_works->AdvancedSearch->unsetSession();
		$this->current_works->AdvancedSearch->unsetSession();
		$this->size_buyer->AdvancedSearch->unsetSession();
		$this->q_sku->AdvancedSearch->unsetSession();
		$this->po_price->AdvancedSearch->unsetSession();
		$this->po_discount->AdvancedSearch->unsetSession();
		$this->po_currency->AdvancedSearch->unsetSession();
		$this->product_type->AdvancedSearch->unsetSession();
		$this->shape->AdvancedSearch->unsetSession();
		$this->payment_plan->AdvancedSearch->unsetSession();
		$this->production_plan->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->completed->AdvancedSearch->unsetSession();
		$this->buyer_po->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->jc_no->AdvancedSearch->unsetSession();
		$this->batch_no->AdvancedSearch->unsetSession();
		$this->cs->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->roll_no->AdvancedSearch->unsetSession();
		$this->qty->AdvancedSearch->unsetSession();
		$this->pl_no->AdvancedSearch->unsetSession();
		$this->category->AdvancedSearch->unsetSession();
		$this->pp_id->AdvancedSearch->unsetSession();
		$this->_11->AdvancedSearch->unsetSession();
		$this->_12->AdvancedSearch->unsetSession();
		$this->_13->AdvancedSearch->unsetSession();
		$this->_14->AdvancedSearch->unsetSession();
		$this->_15->AdvancedSearch->unsetSession();
		$this->_16->AdvancedSearch->unsetSession();
		$this->_17->AdvancedSearch->unsetSession();
		$this->_18->AdvancedSearch->unsetSession();
		$this->_19->AdvancedSearch->unsetSession();
		$this->_20->AdvancedSearch->unsetSession();
		$this->_21->AdvancedSearch->unsetSession();
		$this->_22->AdvancedSearch->unsetSession();
		$this->_23->AdvancedSearch->unsetSession();
		$this->_24->AdvancedSearch->unsetSession();
		$this->_25->AdvancedSearch->unsetSession();
		$this->_26->AdvancedSearch->unsetSession();
		$this->_27->AdvancedSearch->unsetSession();
		$this->_28->AdvancedSearch->unsetSession();
		$this->_29->AdvancedSearch->unsetSession();
		$this->_30->AdvancedSearch->unsetSession();
		$this->_31->AdvancedSearch->unsetSession();
		$this->_32->AdvancedSearch->unsetSession();
		$this->_33->AdvancedSearch->unsetSession();
		$this->_34->AdvancedSearch->unsetSession();
		$this->_35->AdvancedSearch->unsetSession();
		$this->_36->AdvancedSearch->unsetSession();
		$this->_37->AdvancedSearch->unsetSession();
		$this->_38->AdvancedSearch->unsetSession();
		$this->_39->AdvancedSearch->unsetSession();
		$this->_40->AdvancedSearch->unsetSession();
		$this->_41->AdvancedSearch->unsetSession();
		$this->_42->AdvancedSearch->unsetSession();
		$this->_43->AdvancedSearch->unsetSession();
		$this->_44->AdvancedSearch->unsetSession();
		$this->_45->AdvancedSearch->unsetSession();
		$this->_46->AdvancedSearch->unsetSession();
		$this->_47->AdvancedSearch->unsetSession();
		$this->_48->AdvancedSearch->unsetSession();
		$this->_49->AdvancedSearch->unsetSession();
		$this->_50->AdvancedSearch->unsetSession();
		$this->p_remarks->AdvancedSearch->unsetSession();
		$this->roll_no_qty_tmp->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->pid->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->size_cm->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->process_d->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->order_date->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->dispatch_week_p->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->buyer_uid->AdvancedSearch->load();
		$this->buyer_loc->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_u->AdvancedSearch->load();
		$this->c_sqm->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->size_buyer->AdvancedSearch->load();
		$this->q_sku->AdvancedSearch->load();
		$this->po_price->AdvancedSearch->load();
		$this->po_discount->AdvancedSearch->load();
		$this->po_currency->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->payment_plan->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->completed->AdvancedSearch->load();
		$this->buyer_po->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->cs->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->pp_id->AdvancedSearch->load();
		$this->_11->AdvancedSearch->load();
		$this->_12->AdvancedSearch->load();
		$this->_13->AdvancedSearch->load();
		$this->_14->AdvancedSearch->load();
		$this->_15->AdvancedSearch->load();
		$this->_16->AdvancedSearch->load();
		$this->_17->AdvancedSearch->load();
		$this->_18->AdvancedSearch->load();
		$this->_19->AdvancedSearch->load();
		$this->_20->AdvancedSearch->load();
		$this->_21->AdvancedSearch->load();
		$this->_22->AdvancedSearch->load();
		$this->_23->AdvancedSearch->load();
		$this->_24->AdvancedSearch->load();
		$this->_25->AdvancedSearch->load();
		$this->_26->AdvancedSearch->load();
		$this->_27->AdvancedSearch->load();
		$this->_28->AdvancedSearch->load();
		$this->_29->AdvancedSearch->load();
		$this->_30->AdvancedSearch->load();
		$this->_31->AdvancedSearch->load();
		$this->_32->AdvancedSearch->load();
		$this->_33->AdvancedSearch->load();
		$this->_34->AdvancedSearch->load();
		$this->_35->AdvancedSearch->load();
		$this->_36->AdvancedSearch->load();
		$this->_37->AdvancedSearch->load();
		$this->_38->AdvancedSearch->load();
		$this->_39->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->_41->AdvancedSearch->load();
		$this->_42->AdvancedSearch->load();
		$this->_43->AdvancedSearch->load();
		$this->_44->AdvancedSearch->load();
		$this->_45->AdvancedSearch->load();
		$this->_46->AdvancedSearch->load();
		$this->_47->AdvancedSearch->load();
		$this->_48->AdvancedSearch->load();
		$this->_49->AdvancedSearch->load();
		$this->_50->AdvancedSearch->load();
		$this->p_remarks->AdvancedSearch->load();
		$this->roll_no_qty_tmp->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->po, $ctrl); // po
			$this->updateSort($this->design_id, $ctrl); // design_id
			$this->updateSort($this->size_cm, $ctrl); // size_cm
			$this->updateSort($this->_barcode, $ctrl); // barcode
			$this->updateSort($this->process_d, $ctrl); // process_d
			$this->updateSort($this->buyer_ref, $ctrl); // buyer_ref
			$this->updateSort($this->order_date, $ctrl); // order_date
			$this->updateSort($this->despatch_date, $ctrl); // despatch_date
			$this->updateSort($this->despatch_week, $ctrl); // despatch_week
			$this->updateSort($this->dispatch_week_p, $ctrl); // dispatch_week_p
			$this->updateSort($this->status, $ctrl); // status
			$this->updateSort($this->buyers_id, $ctrl); // buyers_id
			$this->updateSort($this->buyer_uid, $ctrl); // buyer_uid
			$this->updateSort($this->buyer_loc, $ctrl); // buyer_loc
			$this->updateSort($this->quantity, $ctrl); // quantity
			$this->updateSort($this->sqm, $ctrl); // sqm
			$this->updateSort($this->sqm_u, $ctrl); // sqm_u
			$this->updateSort($this->c_sqm, $ctrl); // c_sqm
			$this->updateSort($this->weaving_works, $ctrl); // weaving_works
			$this->updateSort($this->current_works, $ctrl); // current_works
			$this->updateSort($this->q_sku, $ctrl); // q_sku
			$this->updateSort($this->po_price, $ctrl); // po_price
			$this->updateSort($this->po_discount, $ctrl); // po_discount
			$this->updateSort($this->po_currency, $ctrl); // po_currency
			$this->updateSort($this->product_type, $ctrl); // product_type
			$this->updateSort($this->shape, $ctrl); // shape
			$this->updateSort($this->completed, $ctrl); // completed
			$this->updateSort($this->buyer_po, $ctrl); // buyer_po
			$this->updateSort($this->batch_no, $ctrl); // batch_no
			$this->updateSort($this->cs, $ctrl); // cs
			$this->updateSort($this->weight, $ctrl); // weight
			$this->updateSort($this->remarks, $ctrl); // remarks
			$this->updateSort($this->roll_no, $ctrl); // roll_no
			$this->updateSort($this->qty, $ctrl); // qty
			$this->updateSort($this->pl_no, $ctrl); // pl_no
			$this->updateSort($this->category, $ctrl); // category
			$this->updateSort($this->buyer_barcode, $ctrl); // buyer_barcode
			$this->updateSort($this->_11, $ctrl); // 11
			$this->updateSort($this->_12, $ctrl); // 12
			$this->updateSort($this->_13, $ctrl); // 13
			$this->updateSort($this->_14, $ctrl); // 14
			$this->updateSort($this->_15, $ctrl); // 15
			$this->updateSort($this->_16, $ctrl); // 16
			$this->updateSort($this->_17, $ctrl); // 17
			$this->updateSort($this->_18, $ctrl); // 18
			$this->updateSort($this->_19, $ctrl); // 19
			$this->updateSort($this->_20, $ctrl); // 20
			$this->updateSort($this->_21, $ctrl); // 21
			$this->updateSort($this->_22, $ctrl); // 22
			$this->updateSort($this->_23, $ctrl); // 23
			$this->updateSort($this->_24, $ctrl); // 24
			$this->updateSort($this->_25, $ctrl); // 25
			$this->updateSort($this->_26, $ctrl); // 26
			$this->updateSort($this->_27, $ctrl); // 27
			$this->updateSort($this->_28, $ctrl); // 28
			$this->updateSort($this->_29, $ctrl); // 29
			$this->updateSort($this->_30, $ctrl); // 30
			$this->updateSort($this->_31, $ctrl); // 31
			$this->updateSort($this->_32, $ctrl); // 32
			$this->updateSort($this->_33, $ctrl); // 33
			$this->updateSort($this->_34, $ctrl); // 34
			$this->updateSort($this->_35, $ctrl); // 35
			$this->updateSort($this->_36, $ctrl); // 36
			$this->updateSort($this->_37, $ctrl); // 37
			$this->updateSort($this->_38, $ctrl); // 38
			$this->updateSort($this->_39, $ctrl); // 39
			$this->updateSort($this->_40, $ctrl); // 40
			$this->updateSort($this->_41, $ctrl); // 41
			$this->updateSort($this->_42, $ctrl); // 42
			$this->updateSort($this->_43, $ctrl); // 43
			$this->updateSort($this->_44, $ctrl); // 44
			$this->updateSort($this->_45, $ctrl); // 45
			$this->updateSort($this->_46, $ctrl); // 46
			$this->updateSort($this->_47, $ctrl); // 47
			$this->updateSort($this->_48, $ctrl); // 48
			$this->updateSort($this->_49, $ctrl); // 49
			$this->updateSort($this->_50, $ctrl); // 50
			$this->updateSort($this->roll_no_qty_tmp, $ctrl); // roll_no_qty_tmp
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->_barcode->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->po->setSort("");
				$this->design_id->setSort("");
				$this->size_cm->setSort("");
				$this->_barcode->setSort("");
				$this->process_d->setSort("");
				$this->buyer_ref->setSort("");
				$this->order_date->setSort("");
				$this->despatch_date->setSort("");
				$this->despatch_week->setSort("");
				$this->dispatch_week_p->setSort("");
				$this->status->setSort("");
				$this->buyers_id->setSort("");
				$this->buyer_uid->setSort("");
				$this->buyer_loc->setSort("");
				$this->quantity->setSort("");
				$this->sqm->setSort("");
				$this->sqm_u->setSort("");
				$this->c_sqm->setSort("");
				$this->weaving_works->setSort("");
				$this->current_works->setSort("");
				$this->q_sku->setSort("");
				$this->po_price->setSort("");
				$this->po_discount->setSort("");
				$this->po_currency->setSort("");
				$this->product_type->setSort("");
				$this->shape->setSort("");
				$this->completed->setSort("");
				$this->buyer_po->setSort("");
				$this->batch_no->setSort("");
				$this->cs->setSort("");
				$this->weight->setSort("");
				$this->remarks->setSort("");
				$this->roll_no->setSort("");
				$this->qty->setSort("");
				$this->pl_no->setSort("");
				$this->category->setSort("");
				$this->buyer_barcode->setSort("");
				$this->_11->setSort("");
				$this->_12->setSort("");
				$this->_13->setSort("");
				$this->_14->setSort("");
				$this->_15->setSort("");
				$this->_16->setSort("");
				$this->_17->setSort("");
				$this->_18->setSort("");
				$this->_19->setSort("");
				$this->_20->setSort("");
				$this->_21->setSort("");
				$this->_22->setSort("");
				$this->_23->setSort("");
				$this->_24->setSort("");
				$this->_25->setSort("");
				$this->_26->setSort("");
				$this->_27->setSort("");
				$this->_28->setSort("");
				$this->_29->setSort("");
				$this->_30->setSort("");
				$this->_31->setSort("");
				$this->_32->setSort("");
				$this->_33->setSort("");
				$this->_34->setSort("");
				$this->_35->setSort("");
				$this->_36->setSort("");
				$this->_37->setSort("");
				$this->_38->setSort("");
				$this->_39->setSort("");
				$this->_40->setSort("");
				$this->_41->setSort("");
				$this->_42->setSort("");
				$this->_43->setSort("");
				$this->_44->setSort("");
				$this->_45->setSort("");
				$this->_46->setSort("");
				$this->_47->setSort("");
				$this->_48->setSort("");
				$this->_49->setSort("");
				$this->_50->setSort("");
				$this->roll_no_qty_tmp->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add multi update
		$item = &$option->add("multiupdate");
		$item->Body = "<a class=\"ew-action ew-multi-update\" title=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" data-table=\"bcode\" data-caption=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" href=\"\" onclick=\"ew.modalDialogShow({lnk:this,btn:'UpdateBtn',f:document.fbcodelist,url:'" . $this->MultiUpdateUrl . "'});return false;\">" . $Language->phrase("UpdateSelectedLink") . "</a>";
		$item->Visible = ($Security->canEdit());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fbcodelistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fbcodelistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fbcodelist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fbcodelistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"bcodesrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fbcodelistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// pid
		if (!$this->isAddOrEdit())
			$this->pid->AdvancedSearch->setSearchValue(Get("x_pid", Get("pid", "")));
		if ($this->pid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pid->AdvancedSearch->setSearchOperator(Get("z_pid", ""));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue(Get("x_po", Get("po", "")));
		if ($this->po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator(Get("z_po", ""));
		$this->po->AdvancedSearch->setSearchCondition(Get("v_po", ""));
		$this->po->AdvancedSearch->setSearchValue2(Get("y_po", ""));
		if ($this->po->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po->AdvancedSearch->setSearchOperator2(Get("w_po", ""));

		// design_id
		if (!$this->isAddOrEdit())
			$this->design_id->AdvancedSearch->setSearchValue(Get("x_design_id", Get("design_id", "")));
		if ($this->design_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->design_id->AdvancedSearch->setSearchOperator(Get("z_design_id", ""));

		// size_cm
		if (!$this->isAddOrEdit())
			$this->size_cm->AdvancedSearch->setSearchValue(Get("x_size_cm", Get("size_cm", "")));
		if ($this->size_cm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->size_cm->AdvancedSearch->setSearchOperator(Get("z_size_cm", ""));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue(Get("x__barcode", Get("_barcode", "")));
		if ($this->_barcode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_barcode->AdvancedSearch->setSearchOperator(Get("z__barcode", ""));
		$this->_barcode->AdvancedSearch->setSearchCondition(Get("v__barcode", ""));
		$this->_barcode->AdvancedSearch->setSearchValue2(Get("y__barcode", ""));
		if ($this->_barcode->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_barcode->AdvancedSearch->setSearchOperator2(Get("w__barcode", ""));

		// process_d
		if (!$this->isAddOrEdit())
			$this->process_d->AdvancedSearch->setSearchValue(Get("x_process_d", Get("process_d", "")));
		if ($this->process_d->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->process_d->AdvancedSearch->setSearchOperator(Get("z_process_d", ""));
		if (is_array($this->process_d->AdvancedSearch->SearchValue))
			$this->process_d->AdvancedSearch->SearchValue = implode(",", $this->process_d->AdvancedSearch->SearchValue);
		if (is_array($this->process_d->AdvancedSearch->SearchValue2))
			$this->process_d->AdvancedSearch->SearchValue2 = implode(",", $this->process_d->AdvancedSearch->SearchValue2);

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue(Get("x_buyer_ref", Get("buyer_ref", "")));
		if ($this->buyer_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_ref->AdvancedSearch->setSearchOperator(Get("z_buyer_ref", ""));

		// order_date
		if (!$this->isAddOrEdit())
			$this->order_date->AdvancedSearch->setSearchValue(Get("x_order_date", Get("order_date", "")));
		if ($this->order_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->order_date->AdvancedSearch->setSearchOperator(Get("z_order_date", ""));

		// despatch_date
		if (!$this->isAddOrEdit())
			$this->despatch_date->AdvancedSearch->setSearchValue(Get("x_despatch_date", Get("despatch_date", "")));
		if ($this->despatch_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->despatch_date->AdvancedSearch->setSearchOperator(Get("z_despatch_date", ""));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue(Get("x_despatch_week", Get("despatch_week", "")));
		if ($this->despatch_week->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->despatch_week->AdvancedSearch->setSearchOperator(Get("z_despatch_week", ""));

		// dispatch_week_p
		if (!$this->isAddOrEdit())
			$this->dispatch_week_p->AdvancedSearch->setSearchValue(Get("x_dispatch_week_p", Get("dispatch_week_p", "")));
		if ($this->dispatch_week_p->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->dispatch_week_p->AdvancedSearch->setSearchOperator(Get("z_dispatch_week_p", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue(Get("x_buyers_id", Get("buyers_id", "")));
		if ($this->buyers_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyers_id->AdvancedSearch->setSearchOperator(Get("z_buyers_id", ""));

		// buyer_uid
		if (!$this->isAddOrEdit())
			$this->buyer_uid->AdvancedSearch->setSearchValue(Get("x_buyer_uid", Get("buyer_uid", "")));
		if ($this->buyer_uid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_uid->AdvancedSearch->setSearchOperator(Get("z_buyer_uid", ""));

		// buyer_loc
		if (!$this->isAddOrEdit())
			$this->buyer_loc->AdvancedSearch->setSearchValue(Get("x_buyer_loc", Get("buyer_loc", "")));
		if ($this->buyer_loc->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_loc->AdvancedSearch->setSearchOperator(Get("z_buyer_loc", ""));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue(Get("x_quantity", Get("quantity", "")));
		if ($this->quantity->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->quantity->AdvancedSearch->setSearchOperator(Get("z_quantity", ""));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue(Get("x_sqm", Get("sqm", "")));
		if ($this->sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm->AdvancedSearch->setSearchOperator(Get("z_sqm", ""));

		// sqm_u
		if (!$this->isAddOrEdit())
			$this->sqm_u->AdvancedSearch->setSearchValue(Get("x_sqm_u", Get("sqm_u", "")));
		if ($this->sqm_u->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sqm_u->AdvancedSearch->setSearchOperator(Get("z_sqm_u", ""));

		// c_sqm
		if (!$this->isAddOrEdit())
			$this->c_sqm->AdvancedSearch->setSearchValue(Get("x_c_sqm", Get("c_sqm", "")));
		if ($this->c_sqm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->c_sqm->AdvancedSearch->setSearchOperator(Get("z_c_sqm", ""));

		// weaving_works
		if (!$this->isAddOrEdit())
			$this->weaving_works->AdvancedSearch->setSearchValue(Get("x_weaving_works", Get("weaving_works", "")));
		if ($this->weaving_works->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->weaving_works->AdvancedSearch->setSearchOperator(Get("z_weaving_works", ""));

		// current_works
		if (!$this->isAddOrEdit())
			$this->current_works->AdvancedSearch->setSearchValue(Get("x_current_works", Get("current_works", "")));
		if ($this->current_works->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->current_works->AdvancedSearch->setSearchOperator(Get("z_current_works", ""));

		// size_buyer
		if (!$this->isAddOrEdit())
			$this->size_buyer->AdvancedSearch->setSearchValue(Get("x_size_buyer", Get("size_buyer", "")));
		if ($this->size_buyer->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->size_buyer->AdvancedSearch->setSearchOperator(Get("z_size_buyer", ""));

		// q_sku
		if (!$this->isAddOrEdit())
			$this->q_sku->AdvancedSearch->setSearchValue(Get("x_q_sku", Get("q_sku", "")));
		if ($this->q_sku->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->q_sku->AdvancedSearch->setSearchOperator(Get("z_q_sku", ""));

		// po_price
		if (!$this->isAddOrEdit())
			$this->po_price->AdvancedSearch->setSearchValue(Get("x_po_price", Get("po_price", "")));
		if ($this->po_price->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_price->AdvancedSearch->setSearchOperator(Get("z_po_price", ""));

		// po_discount
		if (!$this->isAddOrEdit())
			$this->po_discount->AdvancedSearch->setSearchValue(Get("x_po_discount", Get("po_discount", "")));
		if ($this->po_discount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_discount->AdvancedSearch->setSearchOperator(Get("z_po_discount", ""));

		// po_currency
		if (!$this->isAddOrEdit())
			$this->po_currency->AdvancedSearch->setSearchValue(Get("x_po_currency", Get("po_currency", "")));
		if ($this->po_currency->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_currency->AdvancedSearch->setSearchOperator(Get("z_po_currency", ""));

		// product_type
		if (!$this->isAddOrEdit())
			$this->product_type->AdvancedSearch->setSearchValue(Get("x_product_type", Get("product_type", "")));
		if ($this->product_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_type->AdvancedSearch->setSearchOperator(Get("z_product_type", ""));

		// shape
		if (!$this->isAddOrEdit())
			$this->shape->AdvancedSearch->setSearchValue(Get("x_shape", Get("shape", "")));
		if ($this->shape->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->shape->AdvancedSearch->setSearchOperator(Get("z_shape", ""));

		// payment_plan
		if (!$this->isAddOrEdit())
			$this->payment_plan->AdvancedSearch->setSearchValue(Get("x_payment_plan", Get("payment_plan", "")));
		if ($this->payment_plan->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->payment_plan->AdvancedSearch->setSearchOperator(Get("z_payment_plan", ""));

		// production_plan
		if (!$this->isAddOrEdit())
			$this->production_plan->AdvancedSearch->setSearchValue(Get("x_production_plan", Get("production_plan", "")));
		if ($this->production_plan->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->production_plan->AdvancedSearch->setSearchOperator(Get("z_production_plan", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// completed
		if (!$this->isAddOrEdit())
			$this->completed->AdvancedSearch->setSearchValue(Get("x_completed", Get("completed", "")));
		if ($this->completed->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->completed->AdvancedSearch->setSearchOperator(Get("z_completed", ""));

		// buyer_po
		if (!$this->isAddOrEdit())
			$this->buyer_po->AdvancedSearch->setSearchValue(Get("x_buyer_po", Get("buyer_po", "")));
		if ($this->buyer_po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_po->AdvancedSearch->setSearchOperator(Get("z_buyer_po", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue(Get("x_jc_no", Get("jc_no", "")));
		if ($this->jc_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_no->AdvancedSearch->setSearchOperator(Get("z_jc_no", ""));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue(Get("x_batch_no", Get("batch_no", "")));
		if ($this->batch_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->batch_no->AdvancedSearch->setSearchOperator(Get("z_batch_no", ""));

		// cs
		if (!$this->isAddOrEdit())
			$this->cs->AdvancedSearch->setSearchValue(Get("x_cs", Get("cs", "")));
		if ($this->cs->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cs->AdvancedSearch->setSearchOperator(Get("z_cs", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// roll_no
		if (!$this->isAddOrEdit())
			$this->roll_no->AdvancedSearch->setSearchValue(Get("x_roll_no", Get("roll_no", "")));
		if ($this->roll_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->roll_no->AdvancedSearch->setSearchOperator(Get("z_roll_no", ""));

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue(Get("x_qty", Get("qty", "")));
		if ($this->qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty->AdvancedSearch->setSearchOperator(Get("z_qty", ""));

		// pl_no
		if (!$this->isAddOrEdit())
			$this->pl_no->AdvancedSearch->setSearchValue(Get("x_pl_no", Get("pl_no", "")));
		if ($this->pl_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pl_no->AdvancedSearch->setSearchOperator(Get("z_pl_no", ""));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue(Get("x_category", Get("category", "")));
		if ($this->category->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->category->AdvancedSearch->setSearchOperator(Get("z_category", ""));

		// pp_id
		if (!$this->isAddOrEdit())
			$this->pp_id->AdvancedSearch->setSearchValue(Get("x_pp_id", Get("pp_id", "")));
		if ($this->pp_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pp_id->AdvancedSearch->setSearchOperator(Get("z_pp_id", ""));

		// 11
		if (!$this->isAddOrEdit())
			$this->_11->AdvancedSearch->setSearchValue(Get("x__11", Get("_11", "")));
		if ($this->_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_11->AdvancedSearch->setSearchOperator(Get("z__11", ""));

		// 12
		if (!$this->isAddOrEdit())
			$this->_12->AdvancedSearch->setSearchValue(Get("x__12", Get("_12", "")));
		if ($this->_12->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_12->AdvancedSearch->setSearchOperator(Get("z__12", ""));

		// 13
		if (!$this->isAddOrEdit())
			$this->_13->AdvancedSearch->setSearchValue(Get("x__13", Get("_13", "")));
		if ($this->_13->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_13->AdvancedSearch->setSearchOperator(Get("z__13", ""));

		// 14
		if (!$this->isAddOrEdit())
			$this->_14->AdvancedSearch->setSearchValue(Get("x__14", Get("_14", "")));
		if ($this->_14->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_14->AdvancedSearch->setSearchOperator(Get("z__14", ""));

		// 15
		if (!$this->isAddOrEdit())
			$this->_15->AdvancedSearch->setSearchValue(Get("x__15", Get("_15", "")));
		if ($this->_15->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_15->AdvancedSearch->setSearchOperator(Get("z__15", ""));

		// 16
		if (!$this->isAddOrEdit())
			$this->_16->AdvancedSearch->setSearchValue(Get("x__16", Get("_16", "")));
		if ($this->_16->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_16->AdvancedSearch->setSearchOperator(Get("z__16", ""));

		// 17
		if (!$this->isAddOrEdit())
			$this->_17->AdvancedSearch->setSearchValue(Get("x__17", Get("_17", "")));
		if ($this->_17->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_17->AdvancedSearch->setSearchOperator(Get("z__17", ""));

		// 18
		if (!$this->isAddOrEdit())
			$this->_18->AdvancedSearch->setSearchValue(Get("x__18", Get("_18", "")));
		if ($this->_18->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_18->AdvancedSearch->setSearchOperator(Get("z__18", ""));

		// 19
		if (!$this->isAddOrEdit())
			$this->_19->AdvancedSearch->setSearchValue(Get("x__19", Get("_19", "")));
		if ($this->_19->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_19->AdvancedSearch->setSearchOperator(Get("z__19", ""));

		// 20
		if (!$this->isAddOrEdit())
			$this->_20->AdvancedSearch->setSearchValue(Get("x__20", Get("_20", "")));
		if ($this->_20->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_20->AdvancedSearch->setSearchOperator(Get("z__20", ""));

		// 21
		if (!$this->isAddOrEdit())
			$this->_21->AdvancedSearch->setSearchValue(Get("x__21", Get("_21", "")));
		if ($this->_21->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_21->AdvancedSearch->setSearchOperator(Get("z__21", ""));

		// 22
		if (!$this->isAddOrEdit())
			$this->_22->AdvancedSearch->setSearchValue(Get("x__22", Get("_22", "")));
		if ($this->_22->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_22->AdvancedSearch->setSearchOperator(Get("z__22", ""));

		// 23
		if (!$this->isAddOrEdit())
			$this->_23->AdvancedSearch->setSearchValue(Get("x__23", Get("_23", "")));
		if ($this->_23->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_23->AdvancedSearch->setSearchOperator(Get("z__23", ""));

		// 24
		if (!$this->isAddOrEdit())
			$this->_24->AdvancedSearch->setSearchValue(Get("x__24", Get("_24", "")));
		if ($this->_24->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_24->AdvancedSearch->setSearchOperator(Get("z__24", ""));

		// 25
		if (!$this->isAddOrEdit())
			$this->_25->AdvancedSearch->setSearchValue(Get("x__25", Get("_25", "")));
		if ($this->_25->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_25->AdvancedSearch->setSearchOperator(Get("z__25", ""));

		// 26
		if (!$this->isAddOrEdit())
			$this->_26->AdvancedSearch->setSearchValue(Get("x__26", Get("_26", "")));
		if ($this->_26->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_26->AdvancedSearch->setSearchOperator(Get("z__26", ""));

		// 27
		if (!$this->isAddOrEdit())
			$this->_27->AdvancedSearch->setSearchValue(Get("x__27", Get("_27", "")));
		if ($this->_27->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_27->AdvancedSearch->setSearchOperator(Get("z__27", ""));

		// 28
		if (!$this->isAddOrEdit())
			$this->_28->AdvancedSearch->setSearchValue(Get("x__28", Get("_28", "")));
		if ($this->_28->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_28->AdvancedSearch->setSearchOperator(Get("z__28", ""));

		// 29
		if (!$this->isAddOrEdit())
			$this->_29->AdvancedSearch->setSearchValue(Get("x__29", Get("_29", "")));
		if ($this->_29->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_29->AdvancedSearch->setSearchOperator(Get("z__29", ""));

		// 30
		if (!$this->isAddOrEdit())
			$this->_30->AdvancedSearch->setSearchValue(Get("x__30", Get("_30", "")));
		if ($this->_30->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_30->AdvancedSearch->setSearchOperator(Get("z__30", ""));

		// 31
		if (!$this->isAddOrEdit())
			$this->_31->AdvancedSearch->setSearchValue(Get("x__31", Get("_31", "")));
		if ($this->_31->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_31->AdvancedSearch->setSearchOperator(Get("z__31", ""));

		// 32
		if (!$this->isAddOrEdit())
			$this->_32->AdvancedSearch->setSearchValue(Get("x__32", Get("_32", "")));
		if ($this->_32->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_32->AdvancedSearch->setSearchOperator(Get("z__32", ""));

		// 33
		if (!$this->isAddOrEdit())
			$this->_33->AdvancedSearch->setSearchValue(Get("x__33", Get("_33", "")));
		if ($this->_33->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_33->AdvancedSearch->setSearchOperator(Get("z__33", ""));

		// 34
		if (!$this->isAddOrEdit())
			$this->_34->AdvancedSearch->setSearchValue(Get("x__34", Get("_34", "")));
		if ($this->_34->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_34->AdvancedSearch->setSearchOperator(Get("z__34", ""));

		// 35
		if (!$this->isAddOrEdit())
			$this->_35->AdvancedSearch->setSearchValue(Get("x__35", Get("_35", "")));
		if ($this->_35->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_35->AdvancedSearch->setSearchOperator(Get("z__35", ""));

		// 36
		if (!$this->isAddOrEdit())
			$this->_36->AdvancedSearch->setSearchValue(Get("x__36", Get("_36", "")));
		if ($this->_36->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_36->AdvancedSearch->setSearchOperator(Get("z__36", ""));

		// 37
		if (!$this->isAddOrEdit())
			$this->_37->AdvancedSearch->setSearchValue(Get("x__37", Get("_37", "")));
		if ($this->_37->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_37->AdvancedSearch->setSearchOperator(Get("z__37", ""));

		// 38
		if (!$this->isAddOrEdit())
			$this->_38->AdvancedSearch->setSearchValue(Get("x__38", Get("_38", "")));
		if ($this->_38->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_38->AdvancedSearch->setSearchOperator(Get("z__38", ""));

		// 39
		if (!$this->isAddOrEdit())
			$this->_39->AdvancedSearch->setSearchValue(Get("x__39", Get("_39", "")));
		if ($this->_39->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_39->AdvancedSearch->setSearchOperator(Get("z__39", ""));

		// 40
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue(Get("x__40", Get("_40", "")));
		if ($this->_40->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_40->AdvancedSearch->setSearchOperator(Get("z__40", ""));

		// 41
		if (!$this->isAddOrEdit())
			$this->_41->AdvancedSearch->setSearchValue(Get("x__41", Get("_41", "")));
		if ($this->_41->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_41->AdvancedSearch->setSearchOperator(Get("z__41", ""));

		// 42
		if (!$this->isAddOrEdit())
			$this->_42->AdvancedSearch->setSearchValue(Get("x__42", Get("_42", "")));
		if ($this->_42->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_42->AdvancedSearch->setSearchOperator(Get("z__42", ""));

		// 43
		if (!$this->isAddOrEdit())
			$this->_43->AdvancedSearch->setSearchValue(Get("x__43", Get("_43", "")));
		if ($this->_43->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_43->AdvancedSearch->setSearchOperator(Get("z__43", ""));

		// 44
		if (!$this->isAddOrEdit())
			$this->_44->AdvancedSearch->setSearchValue(Get("x__44", Get("_44", "")));
		if ($this->_44->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_44->AdvancedSearch->setSearchOperator(Get("z__44", ""));

		// 45
		if (!$this->isAddOrEdit())
			$this->_45->AdvancedSearch->setSearchValue(Get("x__45", Get("_45", "")));
		if ($this->_45->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_45->AdvancedSearch->setSearchOperator(Get("z__45", ""));

		// 46
		if (!$this->isAddOrEdit())
			$this->_46->AdvancedSearch->setSearchValue(Get("x__46", Get("_46", "")));
		if ($this->_46->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_46->AdvancedSearch->setSearchOperator(Get("z__46", ""));

		// 47
		if (!$this->isAddOrEdit())
			$this->_47->AdvancedSearch->setSearchValue(Get("x__47", Get("_47", "")));
		if ($this->_47->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_47->AdvancedSearch->setSearchOperator(Get("z__47", ""));

		// 48
		if (!$this->isAddOrEdit())
			$this->_48->AdvancedSearch->setSearchValue(Get("x__48", Get("_48", "")));
		if ($this->_48->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_48->AdvancedSearch->setSearchOperator(Get("z__48", ""));

		// 49
		if (!$this->isAddOrEdit())
			$this->_49->AdvancedSearch->setSearchValue(Get("x__49", Get("_49", "")));
		if ($this->_49->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_49->AdvancedSearch->setSearchOperator(Get("z__49", ""));

		// 50
		if (!$this->isAddOrEdit())
			$this->_50->AdvancedSearch->setSearchValue(Get("x__50", Get("_50", "")));
		if ($this->_50->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_50->AdvancedSearch->setSearchOperator(Get("z__50", ""));

		// p_remarks
		if (!$this->isAddOrEdit())
			$this->p_remarks->AdvancedSearch->setSearchValue(Get("x_p_remarks", Get("p_remarks", "")));
		if ($this->p_remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->p_remarks->AdvancedSearch->setSearchOperator(Get("z_p_remarks", ""));

		// roll_no_qty_tmp
		if (!$this->isAddOrEdit())
			$this->roll_no_qty_tmp->AdvancedSearch->setSearchValue(Get("x_roll_no_qty_tmp", Get("roll_no_qty_tmp", "")));
		if ($this->roll_no_qty_tmp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->roll_no_qty_tmp->AdvancedSearch->setSearchOperator(Get("z_roll_no_qty_tmp", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->pid->setDbValue($row['pid']);
		$this->po->setDbValue($row['po']);
		$this->design_id->setDbValue($row['design_id']);
		if (array_key_exists('EV__design_id', $rs->fields)) {
			$this->design_id->VirtualValue = $rs->fields('EV__design_id'); // Set up virtual field value
		} else {
			$this->design_id->VirtualValue = ""; // Clear value
		}
		$this->size_cm->setDbValue($row['size_cm']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->process_d->setDbValue($row['process_d']);
		$this->buyer_ref->setDbValue($row['buyer_ref']);
		if (array_key_exists('EV__buyer_ref', $rs->fields)) {
			$this->buyer_ref->VirtualValue = $rs->fields('EV__buyer_ref'); // Set up virtual field value
		} else {
			$this->buyer_ref->VirtualValue = ""; // Clear value
		}
		$this->order_date->setDbValue($row['order_date']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
		$this->loom_plan->setDbValue($row['loom_plan']);
		$this->status->setDbValue($row['status']);
		$this->buyers_id->setDbValue($row['buyers_id']);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->buyer_loc->setDbValue($row['buyer_loc']);
		$this->quantity->setDbValue($row['quantity']);
		$this->sqm->setDbValue($row['sqm']);
		$this->sqm_u->setDbValue($row['sqm_u']);
		$this->c_sqm->setDbValue($row['c_sqm']);
		$this->weaving_works->setDbValue($row['weaving_works']);
		$this->current_works->setDbValue($row['current_works']);
		$this->size_buyer->setDbValue($row['size_buyer']);
		$this->design->setDbValue($row['design']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->po_price->setDbValue($row['po_price']);
		$this->po_discount->setDbValue($row['po_discount']);
		$this->po_currency->setDbValue($row['po_currency']);
		$this->product_type->setDbValue($row['product_type']);
		$this->shape->setDbValue($row['shape']);
		$this->payment_plan->setDbValue($row['payment_plan']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->datetime->setDbValue($row['datetime']);
		$this->completed->setDbValue($row['completed']);
		$this->buyer_po->setDbValue($row['buyer_po']);
		$this->operator->setDbValue($row['operator']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->sqm_a->setDbValue($row['sqm_a']);
		$this->_2srm->setDbValue($row['2srm']);
		$this->_2srm_a->setDbValue($row['2srm_a']);
		$this->_4srm->setDbValue($row['4srm']);
		$this->_4srm_a->setDbValue($row['4srm_a']);
		$this->buyer_tid->setDbValue($row['buyer_tid']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->cs->setDbValue($row['cs']);
		$this->process->setDbValue($row['process']);
		$this->process_c->setDbValue($row['process_c']);
		$this->weight->setDbValue($row['weight']);
		$this->remarks->setDbValue($row['remarks']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->qty->setDbValue($row['qty']);
		$this->pl_no->setDbValue($row['pl_no']);
		$this->category->setDbValue($row['category']);
		$this->pp_id->setDbValue($row['pp_id']);
		$this->consignee->setDbValue($row['consignee']);
		$this->buyer_barcode->setDbValue($row['buyer_barcode']);
		$this->design_next->setDbValue($row['design_next']);
		$this->_11->setDbValue($row['11']);
		$this->_12->setDbValue($row['12']);
		$this->_13->setDbValue($row['13']);
		$this->_14->setDbValue($row['14']);
		$this->_15->setDbValue($row['15']);
		$this->_16->setDbValue($row['16']);
		$this->_17->setDbValue($row['17']);
		$this->_18->setDbValue($row['18']);
		$this->_19->setDbValue($row['19']);
		$this->_20->setDbValue($row['20']);
		$this->_21->setDbValue($row['21']);
		$this->_22->setDbValue($row['22']);
		$this->_23->setDbValue($row['23']);
		$this->_24->setDbValue($row['24']);
		$this->_25->setDbValue($row['25']);
		$this->_26->setDbValue($row['26']);
		$this->_27->setDbValue($row['27']);
		$this->_28->setDbValue($row['28']);
		$this->_29->setDbValue($row['29']);
		$this->_30->setDbValue($row['30']);
		$this->_31->setDbValue($row['31']);
		$this->_32->setDbValue($row['32']);
		$this->_33->setDbValue($row['33']);
		$this->_34->setDbValue($row['34']);
		$this->_35->setDbValue($row['35']);
		$this->_36->setDbValue($row['36']);
		$this->_37->setDbValue($row['37']);
		$this->_38->setDbValue($row['38']);
		$this->_39->setDbValue($row['39']);
		$this->_40->setDbValue($row['40']);
		$this->_41->setDbValue($row['41']);
		$this->_42->setDbValue($row['42']);
		$this->_43->setDbValue($row['43']);
		$this->_44->setDbValue($row['44']);
		$this->_45->setDbValue($row['45']);
		$this->_46->setDbValue($row['46']);
		$this->_47->setDbValue($row['47']);
		$this->_48->setDbValue($row['48']);
		$this->_49->setDbValue($row['49']);
		$this->_50->setDbValue($row['50']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->qc_weaving->setDbValue($row['qc_weaving']);
		$this->p_remarks->setDbValue($row['p_remarks']);
		$this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['pid'] = NULL;
		$row['po'] = NULL;
		$row['design_id'] = NULL;
		$row['size_cm'] = NULL;
		$row['barcode'] = NULL;
		$row['process_d'] = NULL;
		$row['buyer_ref'] = NULL;
		$row['order_date'] = NULL;
		$row['despatch_date'] = NULL;
		$row['despatch_week'] = NULL;
		$row['dispatch_week_p'] = NULL;
		$row['loom_plan'] = NULL;
		$row['status'] = NULL;
		$row['buyers_id'] = NULL;
		$row['buyer_uid'] = NULL;
		$row['buyer_loc'] = NULL;
		$row['quantity'] = NULL;
		$row['sqm'] = NULL;
		$row['sqm_u'] = NULL;
		$row['c_sqm'] = NULL;
		$row['weaving_works'] = NULL;
		$row['current_works'] = NULL;
		$row['size_buyer'] = NULL;
		$row['design'] = NULL;
		$row['w_cm'] = NULL;
		$row['l_cm'] = NULL;
		$row['q_sku'] = NULL;
		$row['po_price'] = NULL;
		$row['po_discount'] = NULL;
		$row['po_currency'] = NULL;
		$row['product_type'] = NULL;
		$row['shape'] = NULL;
		$row['payment_plan'] = NULL;
		$row['production_plan'] = NULL;
		$row['datetime'] = NULL;
		$row['completed'] = NULL;
		$row['buyer_po'] = NULL;
		$row['operator'] = NULL;
		$row['jc_no'] = NULL;
		$row['sqm_a'] = NULL;
		$row['2srm'] = NULL;
		$row['2srm_a'] = NULL;
		$row['4srm'] = NULL;
		$row['4srm_a'] = NULL;
		$row['buyer_tid'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['batch_no'] = NULL;
		$row['cs'] = NULL;
		$row['process'] = NULL;
		$row['process_c'] = NULL;
		$row['weight'] = NULL;
		$row['remarks'] = NULL;
		$row['roll_no'] = NULL;
		$row['qty'] = NULL;
		$row['pl_no'] = NULL;
		$row['category'] = NULL;
		$row['pp_id'] = NULL;
		$row['consignee'] = NULL;
		$row['buyer_barcode'] = NULL;
		$row['design_next'] = NULL;
		$row['11'] = NULL;
		$row['12'] = NULL;
		$row['13'] = NULL;
		$row['14'] = NULL;
		$row['15'] = NULL;
		$row['16'] = NULL;
		$row['17'] = NULL;
		$row['18'] = NULL;
		$row['19'] = NULL;
		$row['20'] = NULL;
		$row['21'] = NULL;
		$row['22'] = NULL;
		$row['23'] = NULL;
		$row['24'] = NULL;
		$row['25'] = NULL;
		$row['26'] = NULL;
		$row['27'] = NULL;
		$row['28'] = NULL;
		$row['29'] = NULL;
		$row['30'] = NULL;
		$row['31'] = NULL;
		$row['32'] = NULL;
		$row['33'] = NULL;
		$row['34'] = NULL;
		$row['35'] = NULL;
		$row['36'] = NULL;
		$row['37'] = NULL;
		$row['38'] = NULL;
		$row['39'] = NULL;
		$row['40'] = NULL;
		$row['41'] = NULL;
		$row['42'] = NULL;
		$row['43'] = NULL;
		$row['44'] = NULL;
		$row['45'] = NULL;
		$row['46'] = NULL;
		$row['47'] = NULL;
		$row['48'] = NULL;
		$row['49'] = NULL;
		$row['50'] = NULL;
		$row['packing_type'] = NULL;
		$row['qc_weaving'] = NULL;
		$row['p_remarks'] = NULL;
		$row['roll_no_qty_tmp'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_u->FormValue == $this->sqm_u->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_u->CurrentValue)))
			$this->sqm_u->CurrentValue = ConvertToFloatString($this->sqm_u->CurrentValue);

		// Convert decimal values if posted back
		if ($this->c_sqm->FormValue == $this->c_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->c_sqm->CurrentValue)))
			$this->c_sqm->CurrentValue = ConvertToFloatString($this->c_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->q_sku->FormValue == $this->q_sku->CurrentValue && is_numeric(ConvertToFloatString($this->q_sku->CurrentValue)))
			$this->q_sku->CurrentValue = ConvertToFloatString($this->q_sku->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_discount->FormValue == $this->po_discount->CurrentValue && is_numeric(ConvertToFloatString($this->po_discount->CurrentValue)))
			$this->po_discount->CurrentValue = ConvertToFloatString($this->po_discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight->FormValue == $this->weight->CurrentValue && is_numeric(ConvertToFloatString($this->weight->CurrentValue)))
			$this->weight->CurrentValue = ConvertToFloatString($this->weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pl_no->FormValue == $this->pl_no->CurrentValue && is_numeric(ConvertToFloatString($this->pl_no->CurrentValue)))
			$this->pl_no->CurrentValue = ConvertToFloatString($this->pl_no->CurrentValue);

		// Convert decimal values if posted back
		if ($this->roll_no_qty_tmp->FormValue == $this->roll_no_qty_tmp->CurrentValue && is_numeric(ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue)))
			$this->roll_no_qty_tmp->CurrentValue = ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pid
		// po
		// design_id
		// size_cm
		// barcode

		$this->_barcode->CellCssStyle = "width: 300px;";

		// process_d
		// buyer_ref
		// order_date
		// despatch_date
		// despatch_week
		// dispatch_week_p
		// loom_plan

		$this->loom_plan->CellCssStyle = "white-space: nowrap;";

		// status
		// buyers_id
		// buyer_uid

		$this->buyer_uid->CellCssStyle = "width: 200px;";

		// buyer_loc
		// quantity
		// sqm
		// sqm_u
		// c_sqm
		// weaving_works

		$this->weaving_works->CellCssStyle = "white-space: nowrap;";

		// current_works
		$this->current_works->CellCssStyle = "white-space: nowrap;";

		// size_buyer
		// design

		$this->design->CellCssStyle = "white-space: nowrap;";

		// w_cm
		$this->w_cm->CellCssStyle = "white-space: nowrap;";

		// l_cm
		$this->l_cm->CellCssStyle = "white-space: nowrap;";

		// q_sku
		// po_price
		// po_discount
		// po_currency
		// product_type
		// shape
		// payment_plan
		// production_plan
		// datetime
		// completed
		// buyer_po
		// operator
		// jc_no
		// sqm_a

		$this->sqm_a->CellCssStyle = "white-space: nowrap;";

		// 2srm
		$this->_2srm->CellCssStyle = "white-space: nowrap;";

		// 2srm_a
		$this->_2srm_a->CellCssStyle = "white-space: nowrap;";

		// 4srm
		$this->_4srm->CellCssStyle = "white-space: nowrap;";

		// 4srm_a
		$this->_4srm_a->CellCssStyle = "white-space: nowrap;";

		// buyer_tid
		$this->buyer_tid->CellCssStyle = "white-space: nowrap;";

		// grp
		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// batch_no
		// cs
		// process
		// process_c
		// weight
		// remarks
		// roll_no
		// qty
		// pl_no
		// category
		// pp_id
		// consignee

		$this->consignee->CellCssStyle = "white-space: nowrap;";

		// buyer_barcode
		$this->buyer_barcode->CellCssStyle = "white-space: nowrap;";

		// design_next
		$this->design_next->CellCssStyle = "white-space: nowrap;";

		// 11
		$this->_11->CellCssStyle = "white-space: nowrap;";

		// 12
		$this->_12->CellCssStyle = "white-space: nowrap;";

		// 13
		$this->_13->CellCssStyle = "white-space: nowrap;";

		// 14
		$this->_14->CellCssStyle = "white-space: nowrap;";

		// 15
		$this->_15->CellCssStyle = "white-space: nowrap;";

		// 16
		$this->_16->CellCssStyle = "white-space: nowrap;";

		// 17
		$this->_17->CellCssStyle = "white-space: nowrap;";

		// 18
		$this->_18->CellCssStyle = "white-space: nowrap;";

		// 19
		$this->_19->CellCssStyle = "white-space: nowrap;";

		// 20
		$this->_20->CellCssStyle = "white-space: nowrap;";

		// 21
		$this->_21->CellCssStyle = "white-space: nowrap;";

		// 22
		$this->_22->CellCssStyle = "white-space: nowrap;";

		// 23
		$this->_23->CellCssStyle = "white-space: nowrap;";

		// 24
		$this->_24->CellCssStyle = "white-space: nowrap;";

		// 25
		$this->_25->CellCssStyle = "white-space: nowrap;";

		// 26
		$this->_26->CellCssStyle = "white-space: nowrap;";

		// 27
		$this->_27->CellCssStyle = "white-space: nowrap;";

		// 28
		$this->_28->CellCssStyle = "white-space: nowrap;";

		// 29
		$this->_29->CellCssStyle = "white-space: nowrap;";

		// 30
		$this->_30->CellCssStyle = "white-space: nowrap;";

		// 31
		$this->_31->CellCssStyle = "white-space: nowrap;";

		// 32
		$this->_32->CellCssStyle = "white-space: nowrap;";

		// 33
		$this->_33->CellCssStyle = "white-space: nowrap;";

		// 34
		$this->_34->CellCssStyle = "white-space: nowrap;";

		// 35
		$this->_35->CellCssStyle = "white-space: nowrap;";

		// 36
		$this->_36->CellCssStyle = "white-space: nowrap;";

		// 37
		$this->_37->CellCssStyle = "white-space: nowrap;";

		// 38
		$this->_38->CellCssStyle = "white-space: nowrap;";

		// 39
		$this->_39->CellCssStyle = "white-space: nowrap;";

		// 40
		$this->_40->CellCssStyle = "white-space: nowrap;";

		// 41
		$this->_41->CellCssStyle = "white-space: nowrap;";

		// 42
		$this->_42->CellCssStyle = "white-space: nowrap;";

		// 43
		$this->_43->CellCssStyle = "white-space: nowrap;";

		// 44
		$this->_44->CellCssStyle = "white-space: nowrap;";

		// 45
		$this->_45->CellCssStyle = "white-space: nowrap;";

		// 46
		$this->_46->CellCssStyle = "white-space: nowrap;";

		// 47
		$this->_47->CellCssStyle = "white-space: nowrap;";

		// 48
		$this->_48->CellCssStyle = "white-space: nowrap;";

		// 49
		$this->_49->CellCssStyle = "white-space: nowrap;";

		// 50
		$this->_50->CellCssStyle = "white-space: nowrap;";

		// packing_type
		$this->packing_type->CellCssStyle = "white-space: nowrap;";

		// qc_weaving
		$this->qc_weaving->CellCssStyle = "white-space: nowrap;";

		// p_remarks
		// roll_no_qty_tmp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pid
			$this->pid->ViewValue = $this->pid->CurrentValue;
			$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
			$this->pid->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design_id
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->ViewValue = $this->design_id->VirtualValue;
			} else {
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// process_d
			$curVal = strval($this->process_d->CurrentValue);
			if ($curVal <> "") {
				$this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
				if ($this->process_d->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_d->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_d->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_d->ViewValue = $this->process_d->CurrentValue;
					}
				}
			} else {
				$this->process_d->ViewValue = NULL;
			}
			$this->process_d->ViewCustomAttributes = "";

			// buyer_ref
			if ($this->buyer_ref->VirtualValue <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
			} else {
			$curVal = strval($this->buyer_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_ref->ViewValue = NULL;
			}
			}
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
			$this->order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// dispatch_week_p
			$curVal = strval($this->dispatch_week_p->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
				if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
					}
				}
			} else {
				$this->dispatch_week_p->ViewValue = NULL;
			}
			$this->dispatch_week_p->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
			$this->buyer_uid->ViewCustomAttributes = "";

			// buyer_loc
			$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
			$this->buyer_loc->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_u
			$this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
			$this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, 2, -2, -2, -2);
			$this->sqm_u->ViewCustomAttributes = "";

			// c_sqm
			$this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
			$this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, 2, -2, -2, -2);
			$this->c_sqm->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, 2, -2, -2, -2);
			$this->q_sku->ViewCustomAttributes = "";

			// po_price
			$this->po_price->ViewValue = $this->po_price->CurrentValue;
			$this->po_price->ViewCustomAttributes = "";

			// po_discount
			$this->po_discount->ViewValue = $this->po_discount->CurrentValue;
			$this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, 2, -2, -2, -2);
			$this->po_discount->ViewCustomAttributes = "";

			// po_currency
			$curVal = strval($this->po_currency->CurrentValue);
			if ($curVal <> "") {
				$this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
				if ($this->po_currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_currency->ViewValue = $this->po_currency->CurrentValue;
					}
				}
			} else {
				$this->po_currency->ViewValue = NULL;
			}
			$this->po_currency->ViewCustomAttributes = "";

			// product_type
			if (strval($this->product_type->CurrentValue) <> "") {
				$this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// payment_plan
			$curVal = strval($this->payment_plan->CurrentValue);
			if ($curVal <> "") {
				$this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
				if ($this->payment_plan->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->payment_plan->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_plan->ViewValue = $this->payment_plan->CurrentValue;
					}
				}
			} else {
				$this->payment_plan->ViewValue = NULL;
			}
			$this->payment_plan->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// buyer_po
			$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
			$this->buyer_po->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// cs
			if (strval($this->cs->CurrentValue) <> "") {
				$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
			} else {
				$this->cs->ViewValue = NULL;
			}
			$this->cs->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process->ViewValue->add($this->process->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_c
			$curVal = strval($this->process_c->CurrentValue);
			if ($curVal <> "") {
				$this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
				if ($this->process_c->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_c->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_c->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_c->ViewValue = $this->process_c->CurrentValue;
					}
				}
			} else {
				$this->process_c->ViewValue = NULL;
			}
			$this->process_c->ViewCustomAttributes = "";

			// weight
			$this->weight->ViewValue = $this->weight->CurrentValue;
			$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
			$this->weight->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// pp_id
			$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
			$curVal = strval($this->pp_id->CurrentValue);
			if ($curVal <> "") {
				$this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
				if ($this->pp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
					}
				}
			} else {
				$this->pp_id->ViewValue = NULL;
			}
			$this->pp_id->ViewCustomAttributes = "";

			// buyer_barcode
			$this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;
			$this->buyer_barcode->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->ViewValue = $this->roll_no_qty_tmp->CurrentValue;
			$this->roll_no_qty_tmp->ViewValue = FormatNumber($this->roll_no_qty_tmp->ViewValue, 2, -2, -2, -2);
			$this->roll_no_qty_tmp->ViewCustomAttributes = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->design_id->CurrentValue)) {
				$this->design_id->HrefValue = "bcodelist.php?x_design_id=" . ((!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue)) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
				$this->design_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
			} else {
				$this->design_id->HrefValue = "";
			}
			$this->design_id->TooltipValue = "";
			if (!$this->isExport())
				$this->design_id->ViewValue = $this->highlightValue($this->design_id);

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";
			if (!$this->isExport())
				$this->size_cm->ViewValue = $this->highlightValue($this->size_cm);

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// process_d
			$this->process_d->LinkCustomAttributes = "";
			$this->process_d->HrefValue = "";
			$this->process_d->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_ref->CurrentValue)) {
				$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
				$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
			} else {
				$this->buyer_ref->HrefValue = "";
			}
			$this->buyer_ref->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_ref->ViewValue = $this->highlightValue($this->buyer_ref);

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// dispatch_week_p
			$this->dispatch_week_p->LinkCustomAttributes = "";
			$this->dispatch_week_p->HrefValue = "";
			$this->dispatch_week_p->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyers_id->CurrentValue)) {
				$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
				$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
			} else {
				$this->buyers_id->HrefValue = "";
			}
			$this->buyers_id->TooltipValue = "";

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";
			$this->buyer_uid->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_uid->ViewValue = $this->highlightValue($this->buyer_uid);

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";
			$this->buyer_loc->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_loc->ViewValue = $this->highlightValue($this->buyer_loc);

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_u
			$this->sqm_u->LinkCustomAttributes = "";
			$this->sqm_u->HrefValue = "";
			$this->sqm_u->TooltipValue = "";

			// c_sqm
			$this->c_sqm->LinkCustomAttributes = "";
			$this->c_sqm->HrefValue = "";
			$this->c_sqm->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";
			$this->current_works->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// po_price
			$this->po_price->LinkCustomAttributes = "";
			$this->po_price->HrefValue = "";
			$this->po_price->TooltipValue = "";
			if (!$this->isExport())
				$this->po_price->ViewValue = $this->highlightValue($this->po_price);

			// po_discount
			$this->po_discount->LinkCustomAttributes = "";
			$this->po_discount->HrefValue = "";
			$this->po_discount->TooltipValue = "";

			// po_currency
			$this->po_currency->LinkCustomAttributes = "";
			$this->po_currency->HrefValue = "";
			$this->po_currency->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";
			$this->completed->TooltipValue = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";
			$this->buyer_po->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_po->ViewValue = $this->highlightValue($this->buyer_po);

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// cs
			$this->cs->LinkCustomAttributes = "";
			$this->cs->HrefValue = "";
			$this->cs->TooltipValue = "";

			// weight
			$this->weight->LinkCustomAttributes = "";
			$this->weight->HrefValue = "";
			$this->weight->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";
			if (!$this->isExport())
				$this->remarks->ViewValue = $this->highlightValue($this->remarks);

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// buyer_barcode
			$this->buyer_barcode->LinkCustomAttributes = "";
			$this->buyer_barcode->HrefValue = "";
			$this->buyer_barcode->TooltipValue = "";
			if (!$this->isExport())
				$this->buyer_barcode->ViewValue = $this->highlightValue($this->buyer_barcode);

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";
			$this->_11->TooltipValue = "";
			if (!$this->isExport())
				$this->_11->ViewValue = $this->highlightValue($this->_11);

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";
			$this->_12->TooltipValue = "";
			if (!$this->isExport())
				$this->_12->ViewValue = $this->highlightValue($this->_12);

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";
			$this->_13->TooltipValue = "";
			if (!$this->isExport())
				$this->_13->ViewValue = $this->highlightValue($this->_13);

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";
			$this->_14->TooltipValue = "";
			if (!$this->isExport())
				$this->_14->ViewValue = $this->highlightValue($this->_14);

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";
			$this->_15->TooltipValue = "";
			if (!$this->isExport())
				$this->_15->ViewValue = $this->highlightValue($this->_15);

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";
			$this->_16->TooltipValue = "";
			if (!$this->isExport())
				$this->_16->ViewValue = $this->highlightValue($this->_16);

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";
			$this->_17->TooltipValue = "";
			if (!$this->isExport())
				$this->_17->ViewValue = $this->highlightValue($this->_17);

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";
			$this->_18->TooltipValue = "";
			if (!$this->isExport())
				$this->_18->ViewValue = $this->highlightValue($this->_18);

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";
			$this->_19->TooltipValue = "";
			if (!$this->isExport())
				$this->_19->ViewValue = $this->highlightValue($this->_19);

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";
			$this->_20->TooltipValue = "";
			if (!$this->isExport())
				$this->_20->ViewValue = $this->highlightValue($this->_20);

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";
			$this->_21->TooltipValue = "";
			if (!$this->isExport())
				$this->_21->ViewValue = $this->highlightValue($this->_21);

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";
			$this->_22->TooltipValue = "";
			if (!$this->isExport())
				$this->_22->ViewValue = $this->highlightValue($this->_22);

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";
			$this->_23->TooltipValue = "";
			if (!$this->isExport())
				$this->_23->ViewValue = $this->highlightValue($this->_23);

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";
			$this->_24->TooltipValue = "";
			if (!$this->isExport())
				$this->_24->ViewValue = $this->highlightValue($this->_24);

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";
			$this->_25->TooltipValue = "";
			if (!$this->isExport())
				$this->_25->ViewValue = $this->highlightValue($this->_25);

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";
			$this->_26->TooltipValue = "";
			if (!$this->isExport())
				$this->_26->ViewValue = $this->highlightValue($this->_26);

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";
			$this->_27->TooltipValue = "";
			if (!$this->isExport())
				$this->_27->ViewValue = $this->highlightValue($this->_27);

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";
			$this->_28->TooltipValue = "";
			if (!$this->isExport())
				$this->_28->ViewValue = $this->highlightValue($this->_28);

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";
			$this->_29->TooltipValue = "";
			if (!$this->isExport())
				$this->_29->ViewValue = $this->highlightValue($this->_29);

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";
			$this->_30->TooltipValue = "";
			if (!$this->isExport())
				$this->_30->ViewValue = $this->highlightValue($this->_30);

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";
			$this->_31->TooltipValue = "";
			if (!$this->isExport())
				$this->_31->ViewValue = $this->highlightValue($this->_31);

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";
			$this->_32->TooltipValue = "";
			if (!$this->isExport())
				$this->_32->ViewValue = $this->highlightValue($this->_32);

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";
			$this->_33->TooltipValue = "";
			if (!$this->isExport())
				$this->_33->ViewValue = $this->highlightValue($this->_33);

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";
			$this->_34->TooltipValue = "";
			if (!$this->isExport())
				$this->_34->ViewValue = $this->highlightValue($this->_34);

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";
			$this->_35->TooltipValue = "";
			if (!$this->isExport())
				$this->_35->ViewValue = $this->highlightValue($this->_35);

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";
			$this->_36->TooltipValue = "";
			if (!$this->isExport())
				$this->_36->ViewValue = $this->highlightValue($this->_36);

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";
			$this->_37->TooltipValue = "";
			if (!$this->isExport())
				$this->_37->ViewValue = $this->highlightValue($this->_37);

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";
			$this->_38->TooltipValue = "";
			if (!$this->isExport())
				$this->_38->ViewValue = $this->highlightValue($this->_38);

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";
			$this->_39->TooltipValue = "";
			if (!$this->isExport())
				$this->_39->ViewValue = $this->highlightValue($this->_39);

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";
			if (!$this->isExport())
				$this->_40->ViewValue = $this->highlightValue($this->_40);

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";
			$this->_41->TooltipValue = "";
			if (!$this->isExport())
				$this->_41->ViewValue = $this->highlightValue($this->_41);

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";
			$this->_42->TooltipValue = "";
			if (!$this->isExport())
				$this->_42->ViewValue = $this->highlightValue($this->_42);

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";
			$this->_43->TooltipValue = "";
			if (!$this->isExport())
				$this->_43->ViewValue = $this->highlightValue($this->_43);

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";
			$this->_44->TooltipValue = "";
			if (!$this->isExport())
				$this->_44->ViewValue = $this->highlightValue($this->_44);

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";
			$this->_45->TooltipValue = "";
			if (!$this->isExport())
				$this->_45->ViewValue = $this->highlightValue($this->_45);

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";
			$this->_46->TooltipValue = "";
			if (!$this->isExport())
				$this->_46->ViewValue = $this->highlightValue($this->_46);

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";
			$this->_47->TooltipValue = "";
			if (!$this->isExport())
				$this->_47->ViewValue = $this->highlightValue($this->_47);

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";
			$this->_48->TooltipValue = "";
			if (!$this->isExport())
				$this->_48->ViewValue = $this->highlightValue($this->_48);

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";
			$this->_49->TooltipValue = "";
			if (!$this->isExport())
				$this->_49->ViewValue = $this->highlightValue($this->_49);

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";
			$this->_50->TooltipValue = "";
			if (!$this->isExport())
				$this->_50->ViewValue = $this->highlightValue($this->_50);

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->LinkCustomAttributes = "";
			$this->roll_no_qty_tmp->HrefValue = "";
			$this->roll_no_qty_tmp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// design_id
			$this->design_id->EditAttrs["class"] = "form-control";
			$this->design_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design_id->AdvancedSearch->SearchValue = HtmlDecode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->EditValue = HtmlEncode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

			// size_cm
			$this->size_cm->EditAttrs["class"] = "form-control";
			$this->size_cm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue2 = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue2);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// process_d
			$this->process_d->EditCustomAttributes = "";

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// order_date
			$this->order_date->EditAttrs["class"] = "form-control";
			$this->order_date->EditCustomAttributes = "";
			$this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, 0), 8));
			$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, 0), 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";

			// dispatch_week_p
			$this->dispatch_week_p->EditAttrs["class"] = "form-control";
			$this->dispatch_week_p->EditCustomAttributes = "";

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `grp` != 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->EditAttrs["class"] = "form-control";
			$this->buyer_uid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_uid->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_uid->AdvancedSearch->SearchValue);
			$this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->AdvancedSearch->SearchValue);
			$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

			// buyer_loc
			$this->buyer_loc->EditAttrs["class"] = "form-control";
			$this->buyer_loc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_loc->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_loc->AdvancedSearch->SearchValue);
			$this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->AdvancedSearch->SearchValue);
			$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// sqm_u
			$this->sqm_u->EditAttrs["class"] = "form-control";
			$this->sqm_u->EditCustomAttributes = "";
			$this->sqm_u->EditValue = HtmlEncode($this->sqm_u->AdvancedSearch->SearchValue);
			$this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());

			// c_sqm
			$this->c_sqm->EditAttrs["class"] = "form-control";
			$this->c_sqm->EditCustomAttributes = "";
			$this->c_sqm->EditValue = HtmlEncode($this->c_sqm->AdvancedSearch->SearchValue);
			$this->c_sqm->PlaceHolder = RemoveHtml($this->c_sqm->caption());

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
			else
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== NULL && is_array($this->current_works->Lookup->Options) ? $curVal : NULL;
			if ($this->current_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->current_works->EditValue = array_values($this->current_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->current_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->current_works->EditValue = $arwrk;
			}

			// q_sku
			$this->q_sku->EditAttrs["class"] = "form-control";
			$this->q_sku->EditCustomAttributes = "";
			$this->q_sku->EditValue = HtmlEncode($this->q_sku->AdvancedSearch->SearchValue);
			$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

			// po_price
			$this->po_price->EditAttrs["class"] = "form-control";
			$this->po_price->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_price->AdvancedSearch->SearchValue = HtmlDecode($this->po_price->AdvancedSearch->SearchValue);
			$this->po_price->EditValue = HtmlEncode($this->po_price->AdvancedSearch->SearchValue);
			$this->po_price->PlaceHolder = RemoveHtml($this->po_price->caption());

			// po_discount
			$this->po_discount->EditAttrs["class"] = "form-control";
			$this->po_discount->EditCustomAttributes = "";
			$this->po_discount->EditValue = HtmlEncode($this->po_discount->AdvancedSearch->SearchValue);
			$this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());

			// po_currency
			$this->po_currency->EditAttrs["class"] = "form-control";
			$this->po_currency->EditCustomAttributes = "";

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$this->product_type->EditValue = $this->product_type->options(TRUE);

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";

			// completed
			$this->completed->EditAttrs["class"] = "form-control";
			$this->completed->EditCustomAttributes = "";
			$this->completed->EditValue = $this->completed->options(TRUE);

			// buyer_po
			$this->buyer_po->EditAttrs["class"] = "form-control";
			$this->buyer_po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";

			// cs
			$this->cs->EditAttrs["class"] = "form-control";
			$this->cs->EditCustomAttributes = "";
			$this->cs->EditValue = $this->cs->options(TRUE);

			// weight
			$this->weight->EditAttrs["class"] = "form-control";
			$this->weight->EditCustomAttributes = "";
			$this->weight->EditValue = HtmlEncode($this->weight->AdvancedSearch->SearchValue);
			$this->weight->PlaceHolder = RemoveHtml($this->weight->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->AdvancedSearch->SearchValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			$this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";

			// buyer_barcode
			$this->buyer_barcode->EditAttrs["class"] = "form-control";
			$this->buyer_barcode->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->AdvancedSearch->SearchValue);
			$this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

			// 11
			$this->_11->EditAttrs["class"] = "form-control";
			$this->_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

			// 12
			$this->_12->EditAttrs["class"] = "form-control";
			$this->_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

			// 13
			$this->_13->EditAttrs["class"] = "form-control";
			$this->_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

			// 14
			$this->_14->EditAttrs["class"] = "form-control";
			$this->_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

			// 15
			$this->_15->EditAttrs["class"] = "form-control";
			$this->_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

			// 16
			$this->_16->EditAttrs["class"] = "form-control";
			$this->_16->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

			// 17
			$this->_17->EditAttrs["class"] = "form-control";
			$this->_17->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

			// 18
			$this->_18->EditAttrs["class"] = "form-control";
			$this->_18->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

			// 19
			$this->_19->EditAttrs["class"] = "form-control";
			$this->_19->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

			// 20
			$this->_20->EditAttrs["class"] = "form-control";
			$this->_20->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

			// 21
			$this->_21->EditAttrs["class"] = "form-control";
			$this->_21->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

			// 22
			$this->_22->EditAttrs["class"] = "form-control";
			$this->_22->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

			// 23
			$this->_23->EditAttrs["class"] = "form-control";
			$this->_23->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

			// 24
			$this->_24->EditAttrs["class"] = "form-control";
			$this->_24->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

			// 25
			$this->_25->EditAttrs["class"] = "form-control";
			$this->_25->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

			// 26
			$this->_26->EditAttrs["class"] = "form-control";
			$this->_26->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

			// 27
			$this->_27->EditAttrs["class"] = "form-control";
			$this->_27->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

			// 28
			$this->_28->EditAttrs["class"] = "form-control";
			$this->_28->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

			// 29
			$this->_29->EditAttrs["class"] = "form-control";
			$this->_29->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

			// 30
			$this->_30->EditAttrs["class"] = "form-control";
			$this->_30->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

			// 31
			$this->_31->EditAttrs["class"] = "form-control";
			$this->_31->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

			// 32
			$this->_32->EditAttrs["class"] = "form-control";
			$this->_32->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

			// 33
			$this->_33->EditAttrs["class"] = "form-control";
			$this->_33->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

			// 34
			$this->_34->EditAttrs["class"] = "form-control";
			$this->_34->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

			// 35
			$this->_35->EditAttrs["class"] = "form-control";
			$this->_35->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

			// 36
			$this->_36->EditAttrs["class"] = "form-control";
			$this->_36->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

			// 37
			$this->_37->EditAttrs["class"] = "form-control";
			$this->_37->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

			// 38
			$this->_38->EditAttrs["class"] = "form-control";
			$this->_38->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

			// 39
			$this->_39->EditAttrs["class"] = "form-control";
			$this->_39->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

			// 40
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// 41
			$this->_41->EditAttrs["class"] = "form-control";
			$this->_41->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

			// 42
			$this->_42->EditAttrs["class"] = "form-control";
			$this->_42->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

			// 43
			$this->_43->EditAttrs["class"] = "form-control";
			$this->_43->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

			// 44
			$this->_44->EditAttrs["class"] = "form-control";
			$this->_44->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

			// 45
			$this->_45->EditAttrs["class"] = "form-control";
			$this->_45->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

			// 46
			$this->_46->EditAttrs["class"] = "form-control";
			$this->_46->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

			// 47
			$this->_47->EditAttrs["class"] = "form-control";
			$this->_47->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

			// 48
			$this->_48->EditAttrs["class"] = "form-control";
			$this->_48->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

			// 49
			$this->_49->EditAttrs["class"] = "form-control";
			$this->_49->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

			// 50
			$this->_50->EditAttrs["class"] = "form-control";
			$this->_50->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->EditAttrs["class"] = "form-control";
			$this->roll_no_qty_tmp->EditCustomAttributes = "";
			$this->roll_no_qty_tmp->EditValue = HtmlEncode($this->roll_no_qty_tmp->AdvancedSearch->SearchValue);
			$this->roll_no_qty_tmp->PlaceHolder = RemoveHtml($this->roll_no_qty_tmp->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->pid->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->size_cm->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->process_d->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->order_date->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->dispatch_week_p->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->buyer_uid->AdvancedSearch->load();
		$this->buyer_loc->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_u->AdvancedSearch->load();
		$this->c_sqm->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->size_buyer->AdvancedSearch->load();
		$this->q_sku->AdvancedSearch->load();
		$this->po_price->AdvancedSearch->load();
		$this->po_discount->AdvancedSearch->load();
		$this->po_currency->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->payment_plan->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->completed->AdvancedSearch->load();
		$this->buyer_po->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->cs->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->pp_id->AdvancedSearch->load();
		$this->_11->AdvancedSearch->load();
		$this->_12->AdvancedSearch->load();
		$this->_13->AdvancedSearch->load();
		$this->_14->AdvancedSearch->load();
		$this->_15->AdvancedSearch->load();
		$this->_16->AdvancedSearch->load();
		$this->_17->AdvancedSearch->load();
		$this->_18->AdvancedSearch->load();
		$this->_19->AdvancedSearch->load();
		$this->_20->AdvancedSearch->load();
		$this->_21->AdvancedSearch->load();
		$this->_22->AdvancedSearch->load();
		$this->_23->AdvancedSearch->load();
		$this->_24->AdvancedSearch->load();
		$this->_25->AdvancedSearch->load();
		$this->_26->AdvancedSearch->load();
		$this->_27->AdvancedSearch->load();
		$this->_28->AdvancedSearch->load();
		$this->_29->AdvancedSearch->load();
		$this->_30->AdvancedSearch->load();
		$this->_31->AdvancedSearch->load();
		$this->_32->AdvancedSearch->load();
		$this->_33->AdvancedSearch->load();
		$this->_34->AdvancedSearch->load();
		$this->_35->AdvancedSearch->load();
		$this->_36->AdvancedSearch->load();
		$this->_37->AdvancedSearch->load();
		$this->_38->AdvancedSearch->load();
		$this->_39->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->_41->AdvancedSearch->load();
		$this->_42->AdvancedSearch->load();
		$this->_43->AdvancedSearch->load();
		$this->_44->AdvancedSearch->load();
		$this->_45->AdvancedSearch->load();
		$this->_46->AdvancedSearch->load();
		$this->_47->AdvancedSearch->load();
		$this->_48->AdvancedSearch->load();
		$this->_49->AdvancedSearch->load();
		$this->_50->AdvancedSearch->load();
		$this->p_remarks->AdvancedSearch->load();
		$this->roll_no_qty_tmp->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fbcodelist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fbcodelist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fbcodelist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_bcode\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_bcode',hdr:ew.language.phrase('ExportToEmailText'),f:document.fbcodelist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_design_id":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_d":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_weaving_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_design":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_c":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pp_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_design_id":
							break;
						case "x_process_d":
							break;
						case "x_buyer_ref":
							break;
						case "x_despatch_week":
							break;
						case "x_dispatch_week_p":
							break;
						case "x_status":
							break;
						case "x_buyers_id":
							break;
						case "x_weaving_works":
							break;
						case "x_current_works":
							break;
						case "x_design":
							break;
						case "x_po_currency":
							break;
						case "x_shape":
							break;
						case "x_payment_plan":
							break;
						case "x_operator":
							break;
						case "x_batch_no":
							break;
						case "x_process":
							break;
						case "x_process_c":
							break;
						case "x_category":
							break;
						case "x_pp_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'bcode');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

				if (($this->status->CurrentValue == 201) || ($this->status->CurrentValue == 202) || ($this->status->CurrentValue == 11) || ($this->status->CurrentValue == 21) || ($this->status->CurrentValue == 31) || ($this->status->CurrentValue == 41) || ($this->status->CurrentValue == 211) || ($this->jc_no->CurrentValue > 0) )
				{
				$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-hand-paper-o fa-lg"></i>';
				}
		if ((($this->status->CurrentValue == 203) || ($this->status->CurrentValue == 210) || ($this->status->CurrentValue == 220)) && ($this->completed->CurrentValue == 0))
		{
			$this->ListOptions->Add("Clone Rejected BarCode"); // Replace abclink with your name of the link
			$this->ListOptions->Items["Clone Rejected BarCode"]->Body =
			'<a href="autoprogramme.php?action=cr&apcid=9f53d83ec0691550f7d2507d57f4f5a2&ID='.$this->id->CurrentValue.'" data-original-title ="Clone Rejected BarCode"><i data-phrase="Clone Rejected BarCode"  class="fa fa-clone ew-icon" style="color:RED"></i></a>'; 
		}
			$this->ListOptions->Add("Clone BarCode"); // Replace abclink with your name of the link
			$this->ListOptions->Items["Clone BarCode"]->Body =
			'<a href="autoprogramme.php?action=cn&apcid=9f53d83ec0691550f7d2507d57f4f5a2&ID='.$this->id->CurrentValue.'" data-original-title ="Clone BarCode"><i data-phrase="Clone BarCode"  class="fa fa-clone ew-icon" style="color:Yellow"></i></a>'; 
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>