<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for bcode_s
 */
class bcode_s extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $po;
	public $_barcode;
	public $operator;
	public $datetime;
	public $pid;
	public $grp;
	public $s_grp;
	public $weaving_works;
	public $current_works;
	public $buyers_id;
	public $buyer_ref;
	public $buyer_tid;
	public $design;
	public $design_id;
	public $batch_no;
	public $l_cm;
	public $w_cm;
	public $sqm;
	public $sqm_a;
	public $_2srm;
	public $_2srm_a;
	public $_4srm;
	public $_4srm_a;
	public $shape;
	public $product_type;
	public $size_cm;
	public $size_buyer;
	public $buyer_uid;
	public $quantity;
	public $po_price;
	public $despatch_week;
	public $despatch_date;
	public $payment_plan;
	public $production_plan;
	public $status;
	public $completed;
	public $buyer_po;
	public $jc_no;
	public $pp_id;
	public $in_id;
	public $out_id;
	public $remarks;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'bcode_s';
		$this->TableName = 'bcode_s';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`bcode_s`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('bcode_s', 'bcode_s', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// po
		$this->po = new DbField('bcode_s', 'bcode_s', 'x_po', 'po', '`po`', '`po`', 18, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// barcode
		$this->_barcode = new DbField('bcode_s', 'bcode_s', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 19, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_barcode->Nullable = FALSE; // NOT NULL field
		$this->_barcode->Required = TRUE; // Required field
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['barcode'] = &$this->_barcode;

		// operator
		$this->operator = new DbField('bcode_s', 'bcode_s', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('bcode_s', 'bcode_s', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// pid
		$this->pid = new DbField('bcode_s', 'bcode_s', 'x_pid', 'pid', '`pid`', '`pid`', 18, -1, FALSE, '`pid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pid->Sortable = TRUE; // Allow sort
		$this->pid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pid'] = &$this->pid;

		// grp
		$this->grp = new DbField('bcode_s', 'bcode_s', 'x_grp', 'grp', '`grp`', '`grp`', 2, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('bcode_s', 'bcode_s', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 2, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// weaving_works
		$this->weaving_works = new DbField('bcode_s', 'bcode_s', 'x_weaving_works', 'weaving_works', '`weaving_works`', '`weaving_works`', 18, -1, FALSE, '`weaving_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->weaving_works->Nullable = FALSE; // NOT NULL field
		$this->weaving_works->Sortable = FALSE; // Allow sort
		$this->weaving_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->weaving_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->weaving_works->Lookup = new Lookup('weaving_works', 'godown', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['weaving_works'] = &$this->weaving_works;

		// current_works
		$this->current_works = new DbField('bcode_s', 'bcode_s', 'x_current_works', 'current_works', '`current_works`', '`current_works`', 18, -1, FALSE, '`current_works`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->current_works->Nullable = FALSE; // NOT NULL field
		$this->current_works->Sortable = FALSE; // Allow sort
		$this->current_works->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->current_works->Lookup = new Lookup('current_works', 'godown', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['current_works'] = &$this->current_works;

		// buyers_id
		$this->buyers_id = new DbField('bcode_s', 'bcode_s', 'x_buyers_id', 'buyers_id', '`buyers_id`', '`buyers_id`', 19, -1, FALSE, '`buyers_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyers_id->Sortable = TRUE; // Allow sort
		$this->buyers_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyers_id->Lookup = new Lookup('buyers_id', 'production_partner', FALSE, 'id', ["name","code","",""], [], ["x_buyer_ref"], [], [], [], [], '`name` ASC', '');
		$this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyers_id'] = &$this->buyers_id;

		// buyer_ref
		$this->buyer_ref = new DbField('bcode_s', 'bcode_s', 'x_buyer_ref', 'buyer_ref', '`buyer_ref`', '`buyer_ref`', 201, -1, FALSE, '`buyer_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_ref->Sortable = TRUE; // Allow sort
		$this->buyer_ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_ref->Lookup = new Lookup('buyer_ref', 'partner_product_ref', FALSE, 'id', ["partner_ref","","",""], ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], '`partner_ref` ASC', '');
		$this->fields['buyer_ref'] = &$this->buyer_ref;

		// buyer_tid
		$this->buyer_tid = new DbField('bcode_s', 'bcode_s', 'x_buyer_tid', 'buyer_tid', '`buyer_tid`', '`buyer_tid`', 200, -1, FALSE, '`buyer_tid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_tid->Sortable = FALSE; // Allow sort
		$this->fields['buyer_tid'] = &$this->buyer_tid;

		// design
		$this->design = new DbField('bcode_s', 'bcode_s', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Sortable = FALSE; // Allow sort
		$this->design->Lookup = new Lookup('design', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design'] = &$this->design;

		// design_id
		$this->design_id = new DbField('bcode_s', 'bcode_s', 'x_design_id', 'design_id', '`design_id`', '`design_id`', 200, -1, FALSE, '`design_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->design_id->Sortable = TRUE; // Allow sort
		$this->design_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->design_id->Lookup = new Lookup('design_id', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['design_id'] = &$this->design_id;

		// batch_no
		$this->batch_no = new DbField('bcode_s', 'bcode_s', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// l_cm
		$this->l_cm = new DbField('bcode_s', 'bcode_s', 'x_l_cm', 'l_cm', '`l_cm`', '`l_cm`', 18, -1, FALSE, '`l_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l_cm->Sortable = FALSE; // Allow sort
		$this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['l_cm'] = &$this->l_cm;

		// w_cm
		$this->w_cm = new DbField('bcode_s', 'bcode_s', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 18, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Sortable = FALSE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['w_cm'] = &$this->w_cm;

		// sqm
		$this->sqm = new DbField('bcode_s', 'bcode_s', 'x_sqm', 'sqm', '`sqm`', '`sqm`', 4, -1, FALSE, '`sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm->Nullable = FALSE; // NOT NULL field
		$this->sqm->Required = TRUE; // Required field
		$this->sqm->Sortable = TRUE; // Allow sort
		$this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm'] = &$this->sqm;

		// sqm_a
		$this->sqm_a = new DbField('bcode_s', 'bcode_s', 'x_sqm_a', 'sqm_a', '`sqm_a`', '`sqm_a`', 4, -1, FALSE, '`sqm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sqm_a->Nullable = FALSE; // NOT NULL field
		$this->sqm_a->Required = TRUE; // Required field
		$this->sqm_a->Sortable = FALSE; // Allow sort
		$this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sqm_a'] = &$this->sqm_a;

		// 2srm
		$this->_2srm = new DbField('bcode_s', 'bcode_s', 'x__2srm', '2srm', '`2srm`', '`2srm`', 4, -1, FALSE, '`2srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2srm->Nullable = FALSE; // NOT NULL field
		$this->_2srm->Required = TRUE; // Required field
		$this->_2srm->Sortable = FALSE; // Allow sort
		$this->_2srm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['2srm'] = &$this->_2srm;

		// 2srm_a
		$this->_2srm_a = new DbField('bcode_s', 'bcode_s', 'x__2srm_a', '2srm_a', '`2srm_a`', '`2srm_a`', 4, -1, FALSE, '`2srm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_2srm_a->Nullable = FALSE; // NOT NULL field
		$this->_2srm_a->Required = TRUE; // Required field
		$this->_2srm_a->Sortable = FALSE; // Allow sort
		$this->_2srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['2srm_a'] = &$this->_2srm_a;

		// 4srm
		$this->_4srm = new DbField('bcode_s', 'bcode_s', 'x__4srm', '4srm', '`4srm`', '`4srm`', 4, -1, FALSE, '`4srm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4srm->Nullable = FALSE; // NOT NULL field
		$this->_4srm->Required = TRUE; // Required field
		$this->_4srm->Sortable = FALSE; // Allow sort
		$this->_4srm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['4srm'] = &$this->_4srm;

		// 4srm_a
		$this->_4srm_a = new DbField('bcode_s', 'bcode_s', 'x__4srm_a', '4srm_a', '`4srm_a`', '`4srm_a`', 4, -1, FALSE, '`4srm_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_4srm_a->Nullable = FALSE; // NOT NULL field
		$this->_4srm_a->Required = TRUE; // Required field
		$this->_4srm_a->Sortable = FALSE; // Allow sort
		$this->_4srm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['4srm_a'] = &$this->_4srm_a;

		// shape
		$this->shape = new DbField('bcode_s', 'bcode_s', 'x_shape', 'shape', '`shape`', '`shape`', 17, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Nullable = FALSE; // NOT NULL field
		$this->shape->Required = TRUE; // Required field
		$this->shape->Sortable = TRUE; // Allow sort
		$this->shape->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shape->Lookup = new Lookup('shape', 'd_04', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shape'] = &$this->shape;

		// product_type
		$this->product_type = new DbField('bcode_s', 'bcode_s', 'x_product_type', 'product_type', '`product_type`', '`product_type`', 2, -1, FALSE, '`product_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_type->Nullable = FALSE; // NOT NULL field
		$this->product_type->Required = TRUE; // Required field
		$this->product_type->Sortable = TRUE; // Allow sort
		$this->product_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_type'] = &$this->product_type;

		// size_cm
		$this->size_cm = new DbField('bcode_s', 'bcode_s', 'x_size_cm', 'size_cm', '`size_cm`', '`size_cm`', 200, -1, FALSE, '`size_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_cm->Nullable = FALSE; // NOT NULL field
		$this->size_cm->Required = TRUE; // Required field
		$this->size_cm->Sortable = TRUE; // Allow sort
		$this->fields['size_cm'] = &$this->size_cm;

		// size_buyer
		$this->size_buyer = new DbField('bcode_s', 'bcode_s', 'x_size_buyer', 'size_buyer', '`size_buyer`', '`size_buyer`', 200, -1, FALSE, '`size_buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size_buyer->Sortable = TRUE; // Allow sort
		$this->fields['size_buyer'] = &$this->size_buyer;

		// buyer_uid
		$this->buyer_uid = new DbField('bcode_s', 'bcode_s', 'x_buyer_uid', 'buyer_uid', '`buyer_uid`', '`buyer_uid`', 200, -1, FALSE, '`buyer_uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_uid->Sortable = TRUE; // Allow sort
		$this->fields['buyer_uid'] = &$this->buyer_uid;

		// quantity
		$this->quantity = new DbField('bcode_s', 'bcode_s', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// po_price
		$this->po_price = new DbField('bcode_s', 'bcode_s', 'x_po_price', 'po_price', '`po_price`', '`po_price`', 200, -1, FALSE, '`po_price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_price->Sortable = TRUE; // Allow sort
		$this->fields['po_price'] = &$this->po_price;

		// despatch_week
		$this->despatch_week = new DbField('bcode_s', 'bcode_s', 'x_despatch_week', 'despatch_week', '`despatch_week`', '`despatch_week`', 18, -1, FALSE, '`despatch_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->despatch_week->Sortable = TRUE; // Allow sort
		$this->despatch_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->despatch_week->Lookup = new Lookup('despatch_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['despatch_week'] = &$this->despatch_week;

		// despatch_date
		$this->despatch_date = new DbField('bcode_s', 'bcode_s', 'x_despatch_date', 'despatch_date', '`despatch_date`', CastDateFieldForLike('`despatch_date`', 0, "DB"), 133, 0, FALSE, '`despatch_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_date->Nullable = FALSE; // NOT NULL field
		$this->despatch_date->Required = TRUE; // Required field
		$this->despatch_date->Sortable = TRUE; // Allow sort
		$this->despatch_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['despatch_date'] = &$this->despatch_date;

		// payment_plan
		$this->payment_plan = new DbField('bcode_s', 'bcode_s', 'x_payment_plan', 'payment_plan', '`payment_plan`', '`payment_plan`', 18, -1, FALSE, '`payment_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment_plan->Sortable = TRUE; // Allow sort
		$this->payment_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment_plan->Lookup = new Lookup('payment_plan', 'payment_plan', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->payment_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['payment_plan'] = &$this->payment_plan;

		// production_plan
		$this->production_plan = new DbField('bcode_s', 'bcode_s', 'x_production_plan', 'production_plan', '`production_plan`', '`production_plan`', 17, -1, FALSE, '`production_plan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->production_plan->Sortable = TRUE; // Allow sort
		$this->production_plan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->production_plan->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->production_plan->Lookup = new Lookup('production_plan', 'bcode_s', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->production_plan->OptionCount = 6;
		$this->production_plan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['production_plan'] = &$this->production_plan;

		// status
		$this->status = new DbField('bcode_s', 'bcode_s', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'bcode_s', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 23;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// completed
		$this->completed = new DbField('bcode_s', 'bcode_s', 'x_completed', 'completed', '`completed`', '`completed`', 17, -1, FALSE, '`completed`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->completed->Sortable = TRUE; // Allow sort
		$this->completed->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->completed->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->completed->Lookup = new Lookup('completed', 'bcode_s', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->completed->OptionCount = 2;
		$this->completed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['completed'] = &$this->completed;

		// buyer_po
		$this->buyer_po = new DbField('bcode_s', 'bcode_s', 'x_buyer_po', 'buyer_po', '`buyer_po`', '`buyer_po`', 200, -1, FALSE, '`buyer_po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_po->Sortable = TRUE; // Allow sort
		$this->fields['buyer_po'] = &$this->buyer_po;

		// jc_no
		$this->jc_no = new DbField('bcode_s', 'bcode_s', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 19, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// pp_id
		$this->pp_id = new DbField('bcode_s', 'bcode_s', 'x_pp_id', 'pp_id', '`pp_id`', '`pp_id`', 19, -1, FALSE, '`pp_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pp_id->Sortable = TRUE; // Allow sort
		$this->pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pp_id'] = &$this->pp_id;

		// in_id
		$this->in_id = new DbField('bcode_s', 'bcode_s', 'x_in_id', 'in_id', '`in_id`', '`in_id`', 3, -1, FALSE, '`in_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->in_id->Sortable = TRUE; // Allow sort
		$this->in_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['in_id'] = &$this->in_id;

		// out_id
		$this->out_id = new DbField('bcode_s', 'bcode_s', 'x_out_id', 'out_id', '`out_id`', '`out_id`', 3, -1, FALSE, '`out_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->out_id->Sortable = TRUE; // Allow sort
		$this->out_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['out_id'] = &$this->out_id;

		// remarks
		$this->remarks = new DbField('bcode_s', 'bcode_s', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`bcode_s`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`barcode` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->po->DbValue = $row['po'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->pid->DbValue = $row['pid'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->weaving_works->DbValue = $row['weaving_works'];
		$this->current_works->DbValue = $row['current_works'];
		$this->buyers_id->DbValue = $row['buyers_id'];
		$this->buyer_ref->DbValue = $row['buyer_ref'];
		$this->buyer_tid->DbValue = $row['buyer_tid'];
		$this->design->DbValue = $row['design'];
		$this->design_id->DbValue = $row['design_id'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->l_cm->DbValue = $row['l_cm'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->sqm->DbValue = $row['sqm'];
		$this->sqm_a->DbValue = $row['sqm_a'];
		$this->_2srm->DbValue = $row['2srm'];
		$this->_2srm_a->DbValue = $row['2srm_a'];
		$this->_4srm->DbValue = $row['4srm'];
		$this->_4srm_a->DbValue = $row['4srm_a'];
		$this->shape->DbValue = $row['shape'];
		$this->product_type->DbValue = $row['product_type'];
		$this->size_cm->DbValue = $row['size_cm'];
		$this->size_buyer->DbValue = $row['size_buyer'];
		$this->buyer_uid->DbValue = $row['buyer_uid'];
		$this->quantity->DbValue = $row['quantity'];
		$this->po_price->DbValue = $row['po_price'];
		$this->despatch_week->DbValue = $row['despatch_week'];
		$this->despatch_date->DbValue = $row['despatch_date'];
		$this->payment_plan->DbValue = $row['payment_plan'];
		$this->production_plan->DbValue = $row['production_plan'];
		$this->status->DbValue = $row['status'];
		$this->completed->DbValue = $row['completed'];
		$this->buyer_po->DbValue = $row['buyer_po'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->pp_id->DbValue = $row['pp_id'];
		$this->in_id->DbValue = $row['in_id'];
		$this->out_id->DbValue = $row['out_id'];
		$this->remarks->DbValue = $row['remarks'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "bcode_slist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "bcode_sview.php")
			return $Language->phrase("View");
		elseif ($pageName == "bcode_sedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "bcode_sadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "bcode_slist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("bcode_sview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("bcode_sview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "bcode_sadd.php?" . $this->getUrlParm($parm);
		else
			$url = "bcode_sadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("bcode_sedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("bcode_sadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("bcode_sdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->po->setDbValue($rs->fields('po'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->pid->setDbValue($rs->fields('pid'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->weaving_works->setDbValue($rs->fields('weaving_works'));
		$this->current_works->setDbValue($rs->fields('current_works'));
		$this->buyers_id->setDbValue($rs->fields('buyers_id'));
		$this->buyer_ref->setDbValue($rs->fields('buyer_ref'));
		$this->buyer_tid->setDbValue($rs->fields('buyer_tid'));
		$this->design->setDbValue($rs->fields('design'));
		$this->design_id->setDbValue($rs->fields('design_id'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->l_cm->setDbValue($rs->fields('l_cm'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->sqm->setDbValue($rs->fields('sqm'));
		$this->sqm_a->setDbValue($rs->fields('sqm_a'));
		$this->_2srm->setDbValue($rs->fields('2srm'));
		$this->_2srm_a->setDbValue($rs->fields('2srm_a'));
		$this->_4srm->setDbValue($rs->fields('4srm'));
		$this->_4srm_a->setDbValue($rs->fields('4srm_a'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->product_type->setDbValue($rs->fields('product_type'));
		$this->size_cm->setDbValue($rs->fields('size_cm'));
		$this->size_buyer->setDbValue($rs->fields('size_buyer'));
		$this->buyer_uid->setDbValue($rs->fields('buyer_uid'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->po_price->setDbValue($rs->fields('po_price'));
		$this->despatch_week->setDbValue($rs->fields('despatch_week'));
		$this->despatch_date->setDbValue($rs->fields('despatch_date'));
		$this->payment_plan->setDbValue($rs->fields('payment_plan'));
		$this->production_plan->setDbValue($rs->fields('production_plan'));
		$this->status->setDbValue($rs->fields('status'));
		$this->completed->setDbValue($rs->fields('completed'));
		$this->buyer_po->setDbValue($rs->fields('buyer_po'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->pp_id->setDbValue($rs->fields('pp_id'));
		$this->in_id->setDbValue($rs->fields('in_id'));
		$this->out_id->setDbValue($rs->fields('out_id'));
		$this->remarks->setDbValue($rs->fields('remarks'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// po
		// barcode
		// operator
		// datetime
		// pid
		// grp

		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// weaving_works
		$this->weaving_works->CellCssStyle = "white-space: nowrap;";

		// current_works
		$this->current_works->CellCssStyle = "white-space: nowrap;";

		// buyers_id
		// buyer_ref
		// buyer_tid

		$this->buyer_tid->CellCssStyle = "white-space: nowrap;";

		// design
		$this->design->CellCssStyle = "white-space: nowrap;";

		// design_id
		// batch_no
		// l_cm

		$this->l_cm->CellCssStyle = "white-space: nowrap;";

		// w_cm
		$this->w_cm->CellCssStyle = "white-space: nowrap;";

		// sqm
		// sqm_a

		$this->sqm_a->CellCssStyle = "white-space: nowrap;";

		// 2srm
		$this->_2srm->CellCssStyle = "white-space: nowrap;";

		// 2srm_a
		$this->_2srm_a->CellCssStyle = "white-space: nowrap;";

		// 4srm
		$this->_4srm->CellCssStyle = "white-space: nowrap;";

		// 4srm_a
		$this->_4srm_a->CellCssStyle = "white-space: nowrap;";

		// shape
		// product_type
		// size_cm
		// size_buyer
		// buyer_uid
		// quantity
		// po_price
		// despatch_week
		// despatch_date
		// payment_plan
		// production_plan
		// status
		// completed
		// buyer_po
		// jc_no
		// pp_id
		// in_id
		// out_id
		// remarks
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// pid
		$this->pid->ViewValue = $this->pid->CurrentValue;
		$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
		$this->pid->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// weaving_works
		$curVal = strval($this->weaving_works->CurrentValue);
		if ($curVal <> "") {
			$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
				}
			}
		} else {
			$this->weaving_works->ViewValue = NULL;
		}
		$this->weaving_works->ViewCustomAttributes = "";

		// current_works
		$curVal = strval($this->current_works->CurrentValue);
		if ($curVal <> "") {
			$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
			if ($this->current_works->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->current_works->ViewValue = $this->current_works->CurrentValue;
				}
			}
		} else {
			$this->current_works->ViewValue = NULL;
		}
		$this->current_works->ViewCustomAttributes = "";

		// buyers_id
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 20000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->ViewValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// buyer_ref
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->ViewValue = NULL;
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// buyer_tid
		$this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;
		$this->buyer_tid->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$curVal = strval($this->design->CurrentValue);
		if ($curVal <> "") {
			$this->design->ViewValue = $this->design->lookupCacheOption($curVal);
			if ($this->design->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design->ViewValue = $this->design->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design->ViewValue = $this->design->CurrentValue;
				}
			}
		} else {
			$this->design->ViewValue = NULL;
		}
		$this->design->ViewCustomAttributes = "";

		// design_id
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->ViewValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->ViewValue = NULL;
		}
		$this->design_id->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewValue = FormatNumber($this->batch_no->ViewValue, 0, -2, -2, -2);
		$this->batch_no->ViewCustomAttributes = "";

		// l_cm
		$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
		$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 0, -2, -2, -2);
		$this->l_cm->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 0, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// sqm
		$this->sqm->ViewValue = $this->sqm->CurrentValue;
		$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_a
		$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
		$this->sqm_a->ViewCustomAttributes = "";

		// 2srm
		$this->_2srm->ViewValue = $this->_2srm->CurrentValue;
		$this->_2srm->ViewValue = FormatNumber($this->_2srm->ViewValue, 2, -2, -2, -2);
		$this->_2srm->ViewCustomAttributes = "";

		// 2srm_a
		$this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
		$this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, 2, -2, -2, -2);
		$this->_2srm_a->ViewCustomAttributes = "";

		// 4srm
		$this->_4srm->ViewValue = $this->_4srm->CurrentValue;
		$this->_4srm->ViewValue = FormatNumber($this->_4srm->ViewValue, 2, -2, -2, -2);
		$this->_4srm->ViewCustomAttributes = "";

		// 4srm_a
		$this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
		$this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, 2, -2, -2, -2);
		$this->_4srm_a->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->ViewValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// product_type
		$this->product_type->ViewValue = $this->product_type->CurrentValue;
		$this->product_type->ViewValue = FormatNumber($this->product_type->ViewValue, 0, -2, -2, -2);
		$this->product_type->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// size_buyer
		$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// po_price
		$this->po_price->ViewValue = $this->po_price->CurrentValue;
		$this->po_price->ViewCustomAttributes = "";

		// despatch_week
		$curVal = strval($this->despatch_week->CurrentValue);
		if ($curVal <> "") {
			$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
				}
			}
		} else {
			$this->despatch_week->ViewValue = NULL;
		}
		$this->despatch_week->ViewCustomAttributes = "";

		// despatch_date
		$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
		$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
		$this->despatch_date->ViewCustomAttributes = "";

		// payment_plan
		$curVal = strval($this->payment_plan->CurrentValue);
		if ($curVal <> "") {
			$this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
			if ($this->payment_plan->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->payment_plan->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->payment_plan->ViewValue = $this->payment_plan->CurrentValue;
				}
			}
		} else {
			$this->payment_plan->ViewValue = NULL;
		}
		$this->payment_plan->ViewCustomAttributes = "";

		// production_plan
		if (strval($this->production_plan->CurrentValue) <> "") {
			$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
		} else {
			$this->production_plan->ViewValue = NULL;
		}
		$this->production_plan->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// completed
		if (strval($this->completed->CurrentValue) <> "") {
			$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
		} else {
			$this->completed->ViewValue = NULL;
		}
		$this->completed->ViewCustomAttributes = "";

		// buyer_po
		$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
		$this->jc_no->ViewCustomAttributes = "";

		// pp_id
		$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
		$this->pp_id->ViewValue = FormatNumber($this->pp_id->ViewValue, 0, -2, -2, -2);
		$this->pp_id->ViewCustomAttributes = "";

		// in_id
		$this->in_id->ViewValue = $this->in_id->CurrentValue;
		$this->in_id->ViewValue = FormatNumber($this->in_id->ViewValue, 0, -2, -2, -2);
		$this->in_id->ViewCustomAttributes = "";

		// out_id
		$this->out_id->ViewValue = $this->out_id->CurrentValue;
		$this->out_id->ViewValue = FormatNumber($this->out_id->ViewValue, 0, -2, -2, -2);
		$this->out_id->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		$this->po->HrefValue = "";
		$this->po->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// pid
		$this->pid->LinkCustomAttributes = "";
		$this->pid->HrefValue = "";
		$this->pid->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// weaving_works
		$this->weaving_works->LinkCustomAttributes = "";
		$this->weaving_works->HrefValue = "";
		$this->weaving_works->TooltipValue = "";

		// current_works
		$this->current_works->LinkCustomAttributes = "";
		$this->current_works->HrefValue = "";
		$this->current_works->TooltipValue = "";

		// buyers_id
		$this->buyers_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyers_id->CurrentValue)) {
			$this->buyers_id->HrefValue = "bcode_slist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
			$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
		} else {
			$this->buyers_id->HrefValue = "";
		}
		$this->buyers_id->TooltipValue = "";

		// buyer_ref
		$this->buyer_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyer_ref->CurrentValue)) {
			$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
			$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
		} else {
			$this->buyer_ref->HrefValue = "";
		}
		$this->buyer_ref->TooltipValue = "";

		// buyer_tid
		$this->buyer_tid->LinkCustomAttributes = "";
		$this->buyer_tid->HrefValue = "";
		$this->buyer_tid->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// design_id
		$this->design_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->design_id->CurrentValue)) {
			$this->design_id->HrefValue = "bcodelist.php?x_design_id=" . $this->design_id->CurrentValue; // Add prefix/suffix
			$this->design_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
		} else {
			$this->design_id->HrefValue = "";
		}
		$this->design_id->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// l_cm
		$this->l_cm->LinkCustomAttributes = "";
		$this->l_cm->HrefValue = "";
		$this->l_cm->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// sqm
		$this->sqm->LinkCustomAttributes = "";
		$this->sqm->HrefValue = "";
		$this->sqm->TooltipValue = "";

		// sqm_a
		$this->sqm_a->LinkCustomAttributes = "";
		$this->sqm_a->HrefValue = "";
		$this->sqm_a->TooltipValue = "";

		// 2srm
		$this->_2srm->LinkCustomAttributes = "";
		$this->_2srm->HrefValue = "";
		$this->_2srm->TooltipValue = "";

		// 2srm_a
		$this->_2srm_a->LinkCustomAttributes = "";
		$this->_2srm_a->HrefValue = "";
		$this->_2srm_a->TooltipValue = "";

		// 4srm
		$this->_4srm->LinkCustomAttributes = "";
		$this->_4srm->HrefValue = "";
		$this->_4srm->TooltipValue = "";

		// 4srm_a
		$this->_4srm_a->LinkCustomAttributes = "";
		$this->_4srm_a->HrefValue = "";
		$this->_4srm_a->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// product_type
		$this->product_type->LinkCustomAttributes = "";
		$this->product_type->HrefValue = "";
		$this->product_type->TooltipValue = "";

		// size_cm
		$this->size_cm->LinkCustomAttributes = "";
		$this->size_cm->HrefValue = "";
		$this->size_cm->TooltipValue = "";

		// size_buyer
		$this->size_buyer->LinkCustomAttributes = "";
		$this->size_buyer->HrefValue = "";
		$this->size_buyer->TooltipValue = "";

		// buyer_uid
		$this->buyer_uid->LinkCustomAttributes = "";
		$this->buyer_uid->HrefValue = "";
		$this->buyer_uid->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// po_price
		$this->po_price->LinkCustomAttributes = "";
		$this->po_price->HrefValue = "";
		$this->po_price->TooltipValue = "";

		// despatch_week
		$this->despatch_week->LinkCustomAttributes = "";
		$this->despatch_week->HrefValue = "";
		$this->despatch_week->TooltipValue = "";

		// despatch_date
		$this->despatch_date->LinkCustomAttributes = "";
		$this->despatch_date->HrefValue = "";
		$this->despatch_date->TooltipValue = "";

		// payment_plan
		$this->payment_plan->LinkCustomAttributes = "";
		$this->payment_plan->HrefValue = "";
		$this->payment_plan->TooltipValue = "";

		// production_plan
		$this->production_plan->LinkCustomAttributes = "";
		$this->production_plan->HrefValue = "";
		$this->production_plan->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// completed
		$this->completed->LinkCustomAttributes = "";
		$this->completed->HrefValue = "";
		$this->completed->TooltipValue = "";

		// buyer_po
		$this->buyer_po->LinkCustomAttributes = "";
		$this->buyer_po->HrefValue = "";
		$this->buyer_po->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// pp_id
		$this->pp_id->LinkCustomAttributes = "";
		$this->pp_id->HrefValue = "";
		$this->pp_id->TooltipValue = "";

		// in_id
		$this->in_id->LinkCustomAttributes = "";
		$this->in_id->HrefValue = "";
		$this->in_id->TooltipValue = "";

		// out_id
		$this->out_id->LinkCustomAttributes = "";
		$this->out_id->HrefValue = "";
		$this->out_id->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->EditValue = FormatNumber($this->po->EditValue, 0, -2, -2, -2);
		$this->po->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, 0, -2, -2, -2);
		$this->_barcode->ViewCustomAttributes = "";

		// operator
		// datetime
		// pid

		$this->pid->EditAttrs["class"] = "form-control";
		$this->pid->EditCustomAttributes = "";
		$this->pid->EditValue = $this->pid->CurrentValue;
		$this->pid->EditValue = FormatNumber($this->pid->EditValue, 0, -2, -2, -2);
		$this->pid->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// weaving_works
		$this->weaving_works->EditAttrs["class"] = "form-control";
		$this->weaving_works->EditCustomAttributes = "";

		// current_works
		$this->current_works->EditAttrs["class"] = "form-control";
		$this->current_works->EditCustomAttributes = "";

		// buyers_id
		$this->buyers_id->EditAttrs["class"] = "form-control";
		$this->buyers_id->EditCustomAttributes = "";
		$curVal = strval($this->buyers_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
			if ($this->buyers_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 20000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyers_id->EditValue = $this->buyers_id->CurrentValue;
				}
			}
		} else {
			$this->buyers_id->EditValue = NULL;
		}
		$this->buyers_id->ViewCustomAttributes = "";

		// buyer_ref
		$this->buyer_ref->EditAttrs["class"] = "form-control";
		$this->buyer_ref->EditCustomAttributes = "";
		$curVal = strval($this->buyer_ref->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
			if ($this->buyer_ref->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
				}
			}
		} else {
			$this->buyer_ref->EditValue = NULL;
		}
		$this->buyer_ref->ViewCustomAttributes = "";

		// buyer_tid
		$this->buyer_tid->EditAttrs["class"] = "form-control";
		$this->buyer_tid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_tid->CurrentValue = HtmlDecode($this->buyer_tid->CurrentValue);
		$this->buyer_tid->EditValue = $this->buyer_tid->CurrentValue;
		$this->buyer_tid->PlaceHolder = RemoveHtml($this->buyer_tid->caption());

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->PlaceHolder = RemoveHtml($this->design->caption());

		// design_id
		$this->design_id->EditAttrs["class"] = "form-control";
		$this->design_id->EditCustomAttributes = "";
		$curVal = strval($this->design_id->CurrentValue);
		if ($curVal <> "") {
			$this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
			if ($this->design_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->design_id->EditValue = $this->design_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->design_id->EditValue = $this->design_id->CurrentValue;
				}
			}
		} else {
			$this->design_id->EditValue = NULL;
		}
		$this->design_id->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// l_cm
		$this->l_cm->EditAttrs["class"] = "form-control";
		$this->l_cm->EditCustomAttributes = "";
		$this->l_cm->EditValue = $this->l_cm->CurrentValue;
		$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = "";
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

		// sqm
		$this->sqm->EditAttrs["class"] = "form-control";
		$this->sqm->EditCustomAttributes = "";
		$this->sqm->EditValue = $this->sqm->CurrentValue;
		$this->sqm->EditValue = FormatNumber($this->sqm->EditValue, 2, -2, -2, -2);
		$this->sqm->ViewCustomAttributes = "";

		// sqm_a
		$this->sqm_a->EditAttrs["class"] = "form-control";
		$this->sqm_a->EditCustomAttributes = "";
		$this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
		$this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
		if (strval($this->sqm_a->EditValue) <> "" && is_numeric($this->sqm_a->EditValue))
			$this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, -2, -2, -2, -2);

		// 2srm
		$this->_2srm->EditAttrs["class"] = "form-control";
		$this->_2srm->EditCustomAttributes = "";
		$this->_2srm->EditValue = $this->_2srm->CurrentValue;
		$this->_2srm->PlaceHolder = RemoveHtml($this->_2srm->caption());
		if (strval($this->_2srm->EditValue) <> "" && is_numeric($this->_2srm->EditValue))
			$this->_2srm->EditValue = FormatNumber($this->_2srm->EditValue, -2, -2, -2, -2);

		// 2srm_a
		$this->_2srm_a->EditAttrs["class"] = "form-control";
		$this->_2srm_a->EditCustomAttributes = "";
		$this->_2srm_a->EditValue = $this->_2srm_a->CurrentValue;
		$this->_2srm_a->PlaceHolder = RemoveHtml($this->_2srm_a->caption());
		if (strval($this->_2srm_a->EditValue) <> "" && is_numeric($this->_2srm_a->EditValue))
			$this->_2srm_a->EditValue = FormatNumber($this->_2srm_a->EditValue, -2, -2, -2, -2);

		// 4srm
		$this->_4srm->EditAttrs["class"] = "form-control";
		$this->_4srm->EditCustomAttributes = "";
		$this->_4srm->EditValue = $this->_4srm->CurrentValue;
		$this->_4srm->PlaceHolder = RemoveHtml($this->_4srm->caption());
		if (strval($this->_4srm->EditValue) <> "" && is_numeric($this->_4srm->EditValue))
			$this->_4srm->EditValue = FormatNumber($this->_4srm->EditValue, -2, -2, -2, -2);

		// 4srm_a
		$this->_4srm_a->EditAttrs["class"] = "form-control";
		$this->_4srm_a->EditCustomAttributes = "";
		$this->_4srm_a->EditValue = $this->_4srm_a->CurrentValue;
		$this->_4srm_a->PlaceHolder = RemoveHtml($this->_4srm_a->caption());
		if (strval($this->_4srm_a->EditValue) <> "" && is_numeric($this->_4srm_a->EditValue))
			$this->_4srm_a->EditValue = FormatNumber($this->_4srm_a->EditValue, -2, -2, -2, -2);

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->EditValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->EditValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->EditValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->EditValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// product_type
		$this->product_type->EditAttrs["class"] = "form-control";
		$this->product_type->EditCustomAttributes = "";
		$this->product_type->EditValue = $this->product_type->CurrentValue;
		$this->product_type->EditValue = FormatNumber($this->product_type->EditValue, 0, -2, -2, -2);
		$this->product_type->ViewCustomAttributes = "";

		// size_cm
		$this->size_cm->EditAttrs["class"] = "form-control";
		$this->size_cm->EditCustomAttributes = "";
		$this->size_cm->EditValue = $this->size_cm->CurrentValue;
		$this->size_cm->ViewCustomAttributes = "";

		// size_buyer
		$this->size_buyer->EditAttrs["class"] = "form-control";
		$this->size_buyer->EditCustomAttributes = "";
		$this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
		$this->size_buyer->ViewCustomAttributes = "";

		// buyer_uid
		$this->buyer_uid->EditAttrs["class"] = "form-control";
		$this->buyer_uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_uid->CurrentValue = HtmlDecode($this->buyer_uid->CurrentValue);
		$this->buyer_uid->EditValue = $this->buyer_uid->CurrentValue;
		$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// po_price
		$this->po_price->EditAttrs["class"] = "form-control";
		$this->po_price->EditCustomAttributes = "";
		$this->po_price->EditValue = $this->po_price->CurrentValue;
		$this->po_price->ViewCustomAttributes = "";

		// despatch_week
		$this->despatch_week->EditAttrs["class"] = "form-control";
		$this->despatch_week->EditCustomAttributes = "";

		// despatch_date
		$this->despatch_date->EditAttrs["class"] = "form-control";
		$this->despatch_date->EditCustomAttributes = "";
		$this->despatch_date->EditValue = FormatDateTime($this->despatch_date->CurrentValue, 8);
		$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

		// payment_plan
		$this->payment_plan->EditAttrs["class"] = "form-control";
		$this->payment_plan->EditCustomAttributes = "";

		// production_plan
		$this->production_plan->EditAttrs["class"] = "form-control";
		$this->production_plan->EditCustomAttributes = "";
		$this->production_plan->EditValue = $this->production_plan->options(TRUE);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// completed
		$this->completed->EditAttrs["class"] = "form-control";
		$this->completed->EditCustomAttributes = "";
		$this->completed->EditValue = $this->completed->options(TRUE);

		// buyer_po
		$this->buyer_po->EditAttrs["class"] = "form-control";
		$this->buyer_po->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->buyer_po->CurrentValue = HtmlDecode($this->buyer_po->CurrentValue);
		$this->buyer_po->EditValue = $this->buyer_po->CurrentValue;
		$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// pp_id
		$this->pp_id->EditAttrs["class"] = "form-control";
		$this->pp_id->EditCustomAttributes = "";
		$this->pp_id->EditValue = $this->pp_id->CurrentValue;
		$this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

		// in_id
		$this->in_id->EditAttrs["class"] = "form-control";
		$this->in_id->EditCustomAttributes = "";
		$this->in_id->EditValue = $this->in_id->CurrentValue;
		$this->in_id->PlaceHolder = RemoveHtml($this->in_id->caption());

		// out_id
		$this->out_id->EditAttrs["class"] = "form-control";
		$this->out_id->EditCustomAttributes = "";
		$this->out_id->EditValue = $this->out_id->CurrentValue;
		$this->out_id->PlaceHolder = RemoveHtml($this->out_id->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->pid);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->buyer_uid);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->po_price);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->completed);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->pp_id);
					$doc->exportCaption($this->in_id);
					$doc->exportCaption($this->out_id);
					$doc->exportCaption($this->remarks);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->pid);
					$doc->exportCaption($this->buyers_id);
					$doc->exportCaption($this->buyer_ref);
					$doc->exportCaption($this->buyer_tid);
					$doc->exportCaption($this->design_id);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->sqm);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->product_type);
					$doc->exportCaption($this->size_cm);
					$doc->exportCaption($this->size_buyer);
					$doc->exportCaption($this->buyer_uid);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->po_price);
					$doc->exportCaption($this->despatch_week);
					$doc->exportCaption($this->despatch_date);
					$doc->exportCaption($this->payment_plan);
					$doc->exportCaption($this->production_plan);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->completed);
					$doc->exportCaption($this->buyer_po);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->pp_id);
					$doc->exportCaption($this->in_id);
					$doc->exportCaption($this->out_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->pid);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->design_id);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->sqm);
						$doc->exportField($this->shape);
						$doc->exportField($this->product_type);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->buyer_uid);
						$doc->exportField($this->quantity);
						$doc->exportField($this->po_price);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->status);
						$doc->exportField($this->completed);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->pp_id);
						$doc->exportField($this->in_id);
						$doc->exportField($this->out_id);
						$doc->exportField($this->remarks);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->po);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->pid);
						$doc->exportField($this->buyers_id);
						$doc->exportField($this->buyer_ref);
						$doc->exportField($this->buyer_tid);
						$doc->exportField($this->design_id);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->sqm);
						$doc->exportField($this->shape);
						$doc->exportField($this->product_type);
						$doc->exportField($this->size_cm);
						$doc->exportField($this->size_buyer);
						$doc->exportField($this->buyer_uid);
						$doc->exportField($this->quantity);
						$doc->exportField($this->po_price);
						$doc->exportField($this->despatch_week);
						$doc->exportField($this->despatch_date);
						$doc->exportField($this->payment_plan);
						$doc->exportField($this->production_plan);
						$doc->exportField($this->status);
						$doc->exportField($this->completed);
						$doc->exportField($this->buyer_po);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->pp_id);
						$doc->exportField($this->in_id);
						$doc->exportField($this->out_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>