<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class bcode_search extends bcode
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'bcode';

	// Page object name
	public $PageObjName = "bcode_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (bcode)
		if (!isset($GLOBALS["bcode"]) || get_class($GLOBALS["bcode"]) == PROJECT_NAMESPACE . "bcode") {
			$GLOBALS["bcode"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bcode"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $bcode;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($bcode);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "bcodeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("bcodelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->pid->setVisibility();
		$this->po->setVisibility();
		$this->design_id->setVisibility();
		$this->size_cm->setVisibility();
		$this->_barcode->setVisibility();
		$this->process_d->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->order_date->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->dispatch_week_p->setVisibility();
		$this->loom_plan->Visible = FALSE;
		$this->status->setVisibility();
		$this->buyers_id->setVisibility();
		$this->buyer_uid->setVisibility();
		$this->buyer_loc->setVisibility();
		$this->quantity->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_u->setVisibility();
		$this->c_sqm->setVisibility();
		$this->weaving_works->setVisibility();
		$this->current_works->setVisibility();
		$this->size_buyer->setVisibility();
		$this->design->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->q_sku->setVisibility();
		$this->po_price->setVisibility();
		$this->po_discount->setVisibility();
		$this->po_currency->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->payment_plan->setVisibility();
		$this->production_plan->setVisibility();
		$this->datetime->setVisibility();
		$this->completed->setVisibility();
		$this->buyer_po->setVisibility();
		$this->operator->setVisibility();
		$this->jc_no->setVisibility();
		$this->sqm_a->Visible = FALSE;
		$this->_2srm->Visible = FALSE;
		$this->_2srm_a->Visible = FALSE;
		$this->_4srm->Visible = FALSE;
		$this->_4srm_a->Visible = FALSE;
		$this->buyer_tid->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->batch_no->setVisibility();
		$this->cs->setVisibility();
		$this->process->Visible = FALSE;
		$this->process_c->Visible = FALSE;
		$this->weight->Visible = FALSE;
		$this->remarks->setVisibility();
		$this->roll_no->setVisibility();
		$this->qty->setVisibility();
		$this->pl_no->setVisibility();
		$this->category->setVisibility();
		$this->pp_id->setVisibility();
		$this->consignee->Visible = FALSE;
		$this->buyer_barcode->Visible = FALSE;
		$this->design_next->Visible = FALSE;
		$this->_11->setVisibility();
		$this->_12->setVisibility();
		$this->_13->setVisibility();
		$this->_14->setVisibility();
		$this->_15->setVisibility();
		$this->_16->setVisibility();
		$this->_17->setVisibility();
		$this->_18->setVisibility();
		$this->_19->setVisibility();
		$this->_20->setVisibility();
		$this->_21->setVisibility();
		$this->_22->setVisibility();
		$this->_23->setVisibility();
		$this->_24->setVisibility();
		$this->_25->setVisibility();
		$this->_26->setVisibility();
		$this->_27->setVisibility();
		$this->_28->setVisibility();
		$this->_29->setVisibility();
		$this->_30->setVisibility();
		$this->_31->setVisibility();
		$this->_32->setVisibility();
		$this->_33->setVisibility();
		$this->_34->setVisibility();
		$this->_35->setVisibility();
		$this->_36->setVisibility();
		$this->_37->setVisibility();
		$this->_38->setVisibility();
		$this->_39->setVisibility();
		$this->_40->setVisibility();
		$this->_41->setVisibility();
		$this->_42->setVisibility();
		$this->_43->setVisibility();
		$this->_44->setVisibility();
		$this->_45->setVisibility();
		$this->_46->setVisibility();
		$this->_47->setVisibility();
		$this->_48->setVisibility();
		$this->_49->setVisibility();
		$this->_50->setVisibility();
		$this->packing_type->Visible = FALSE;
		$this->qc_weaving->Visible = FALSE;
		$this->p_remarks->setVisibility();
		$this->roll_no_qty_tmp->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->process_d);
		$this->setupLookupOptions($this->buyer_ref);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->dispatch_week_p);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->design);
		$this->setupLookupOptions($this->po_currency);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->payment_plan);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_c);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->pp_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "bcodelist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->pid); // pid
		$this->buildSearchUrl($srchUrl, $this->po); // po
		$this->buildSearchUrl($srchUrl, $this->design_id); // design_id
		$this->buildSearchUrl($srchUrl, $this->size_cm); // size_cm
		$this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
		$this->buildSearchUrl($srchUrl, $this->process_d); // process_d
		$this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
		$this->buildSearchUrl($srchUrl, $this->order_date); // order_date
		$this->buildSearchUrl($srchUrl, $this->despatch_date); // despatch_date
		$this->buildSearchUrl($srchUrl, $this->despatch_week); // despatch_week
		$this->buildSearchUrl($srchUrl, $this->dispatch_week_p); // dispatch_week_p
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->buyers_id); // buyers_id
		$this->buildSearchUrl($srchUrl, $this->buyer_uid); // buyer_uid
		$this->buildSearchUrl($srchUrl, $this->buyer_loc); // buyer_loc
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->sqm); // sqm
		$this->buildSearchUrl($srchUrl, $this->sqm_u); // sqm_u
		$this->buildSearchUrl($srchUrl, $this->c_sqm); // c_sqm
		$this->buildSearchUrl($srchUrl, $this->weaving_works); // weaving_works
		$this->buildSearchUrl($srchUrl, $this->current_works); // current_works
		$this->buildSearchUrl($srchUrl, $this->size_buyer); // size_buyer
		$this->buildSearchUrl($srchUrl, $this->q_sku); // q_sku
		$this->buildSearchUrl($srchUrl, $this->po_price); // po_price
		$this->buildSearchUrl($srchUrl, $this->po_discount); // po_discount
		$this->buildSearchUrl($srchUrl, $this->po_currency); // po_currency
		$this->buildSearchUrl($srchUrl, $this->product_type); // product_type
		$this->buildSearchUrl($srchUrl, $this->shape); // shape
		$this->buildSearchUrl($srchUrl, $this->payment_plan); // payment_plan
		$this->buildSearchUrl($srchUrl, $this->production_plan); // production_plan
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->completed); // completed
		$this->buildSearchUrl($srchUrl, $this->buyer_po); // buyer_po
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->cs); // cs
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
		$this->buildSearchUrl($srchUrl, $this->qty); // qty
		$this->buildSearchUrl($srchUrl, $this->pl_no); // pl_no
		$this->buildSearchUrl($srchUrl, $this->category); // category
		$this->buildSearchUrl($srchUrl, $this->pp_id); // pp_id
		$this->buildSearchUrl($srchUrl, $this->_11); // 11
		$this->buildSearchUrl($srchUrl, $this->_12); // 12
		$this->buildSearchUrl($srchUrl, $this->_13); // 13
		$this->buildSearchUrl($srchUrl, $this->_14); // 14
		$this->buildSearchUrl($srchUrl, $this->_15); // 15
		$this->buildSearchUrl($srchUrl, $this->_16); // 16
		$this->buildSearchUrl($srchUrl, $this->_17); // 17
		$this->buildSearchUrl($srchUrl, $this->_18); // 18
		$this->buildSearchUrl($srchUrl, $this->_19); // 19
		$this->buildSearchUrl($srchUrl, $this->_20); // 20
		$this->buildSearchUrl($srchUrl, $this->_21); // 21
		$this->buildSearchUrl($srchUrl, $this->_22); // 22
		$this->buildSearchUrl($srchUrl, $this->_23); // 23
		$this->buildSearchUrl($srchUrl, $this->_24); // 24
		$this->buildSearchUrl($srchUrl, $this->_25); // 25
		$this->buildSearchUrl($srchUrl, $this->_26); // 26
		$this->buildSearchUrl($srchUrl, $this->_27); // 27
		$this->buildSearchUrl($srchUrl, $this->_28); // 28
		$this->buildSearchUrl($srchUrl, $this->_29); // 29
		$this->buildSearchUrl($srchUrl, $this->_30); // 30
		$this->buildSearchUrl($srchUrl, $this->_31); // 31
		$this->buildSearchUrl($srchUrl, $this->_32); // 32
		$this->buildSearchUrl($srchUrl, $this->_33); // 33
		$this->buildSearchUrl($srchUrl, $this->_34); // 34
		$this->buildSearchUrl($srchUrl, $this->_35); // 35
		$this->buildSearchUrl($srchUrl, $this->_36); // 36
		$this->buildSearchUrl($srchUrl, $this->_37); // 37
		$this->buildSearchUrl($srchUrl, $this->_38); // 38
		$this->buildSearchUrl($srchUrl, $this->_39); // 39
		$this->buildSearchUrl($srchUrl, $this->_40); // 40
		$this->buildSearchUrl($srchUrl, $this->_41); // 41
		$this->buildSearchUrl($srchUrl, $this->_42); // 42
		$this->buildSearchUrl($srchUrl, $this->_43); // 43
		$this->buildSearchUrl($srchUrl, $this->_44); // 44
		$this->buildSearchUrl($srchUrl, $this->_45); // 45
		$this->buildSearchUrl($srchUrl, $this->_46); // 46
		$this->buildSearchUrl($srchUrl, $this->_47); // 47
		$this->buildSearchUrl($srchUrl, $this->_48); // 48
		$this->buildSearchUrl($srchUrl, $this->_49); // 49
		$this->buildSearchUrl($srchUrl, $this->_50); // 50
		$this->buildSearchUrl($srchUrl, $this->p_remarks); // p_remarks
		$this->buildSearchUrl($srchUrl, $this->roll_no_qty_tmp); // roll_no_qty_tmp
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// pid
		if (!$this->isAddOrEdit())
			$this->pid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pid"));
		$this->pid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pid"));

		// po
		if (!$this->isAddOrEdit())
			$this->po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po"));
		$this->po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po"));
		$this->po->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_po"));
		$this->po->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_po"));
		$this->po->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_po"));

		// design_id
		if (!$this->isAddOrEdit())
			$this->design_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design_id"));
		$this->design_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design_id"));

		// size_cm
		if (!$this->isAddOrEdit())
			$this->size_cm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size_cm"));
		$this->size_cm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size_cm"));

		// barcode
		if (!$this->isAddOrEdit())
			$this->_barcode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__barcode"));
		$this->_barcode->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v__barcode"));
		$this->_barcode->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y__barcode"));
		$this->_barcode->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w__barcode"));

		// process_d
		if (!$this->isAddOrEdit())
			$this->process_d->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_d"));
		$this->process_d->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_d"));
		if (is_array($this->process_d->AdvancedSearch->SearchValue))
			$this->process_d->AdvancedSearch->SearchValue = implode(",", $this->process_d->AdvancedSearch->SearchValue);
		if (is_array($this->process_d->AdvancedSearch->SearchValue2))
			$this->process_d->AdvancedSearch->SearchValue2 = implode(",", $this->process_d->AdvancedSearch->SearchValue2);

		// buyer_ref
		if (!$this->isAddOrEdit())
			$this->buyer_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_ref"));
		$this->buyer_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_ref"));

		// order_date
		if (!$this->isAddOrEdit())
			$this->order_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_order_date"));
		$this->order_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_order_date"));

		// despatch_date
		if (!$this->isAddOrEdit())
			$this->despatch_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_date"));
		$this->despatch_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_date"));

		// despatch_week
		if (!$this->isAddOrEdit())
			$this->despatch_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_week"));
		$this->despatch_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_week"));

		// dispatch_week_p
		if (!$this->isAddOrEdit())
			$this->dispatch_week_p->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dispatch_week_p"));
		$this->dispatch_week_p->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dispatch_week_p"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// buyers_id
		if (!$this->isAddOrEdit())
			$this->buyers_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyers_id"));
		$this->buyers_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyers_id"));

		// buyer_uid
		if (!$this->isAddOrEdit())
			$this->buyer_uid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_uid"));
		$this->buyer_uid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_uid"));

		// buyer_loc
		if (!$this->isAddOrEdit())
			$this->buyer_loc->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_loc"));
		$this->buyer_loc->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_loc"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// sqm
		if (!$this->isAddOrEdit())
			$this->sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm"));
		$this->sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm"));

		// sqm_u
		if (!$this->isAddOrEdit())
			$this->sqm_u->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sqm_u"));
		$this->sqm_u->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sqm_u"));

		// c_sqm
		if (!$this->isAddOrEdit())
			$this->c_sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_c_sqm"));
		$this->c_sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_c_sqm"));

		// weaving_works
		if (!$this->isAddOrEdit())
			$this->weaving_works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_weaving_works"));
		$this->weaving_works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_weaving_works"));

		// current_works
		if (!$this->isAddOrEdit())
			$this->current_works->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_current_works"));
		$this->current_works->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_current_works"));

		// size_buyer
		if (!$this->isAddOrEdit())
			$this->size_buyer->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size_buyer"));
		$this->size_buyer->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size_buyer"));

		// q_sku
		if (!$this->isAddOrEdit())
			$this->q_sku->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_q_sku"));
		$this->q_sku->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_q_sku"));

		// po_price
		if (!$this->isAddOrEdit())
			$this->po_price->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_price"));
		$this->po_price->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_price"));

		// po_discount
		if (!$this->isAddOrEdit())
			$this->po_discount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_discount"));
		$this->po_discount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_discount"));

		// po_currency
		if (!$this->isAddOrEdit())
			$this->po_currency->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_currency"));
		$this->po_currency->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_currency"));

		// product_type
		if (!$this->isAddOrEdit())
			$this->product_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_type"));
		$this->product_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_type"));

		// shape
		if (!$this->isAddOrEdit())
			$this->shape->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shape"));
		$this->shape->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shape"));

		// payment_plan
		if (!$this->isAddOrEdit())
			$this->payment_plan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_payment_plan"));
		$this->payment_plan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_payment_plan"));

		// production_plan
		if (!$this->isAddOrEdit())
			$this->production_plan->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_production_plan"));
		$this->production_plan->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_production_plan"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// completed
		if (!$this->isAddOrEdit())
			$this->completed->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_completed"));
		$this->completed->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_completed"));

		// buyer_po
		if (!$this->isAddOrEdit())
			$this->buyer_po->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_po"));
		$this->buyer_po->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_po"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no"));
		$this->jc_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));

		// cs
		if (!$this->isAddOrEdit())
			$this->cs->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cs"));
		$this->cs->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cs"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// roll_no
		if (!$this->isAddOrEdit())
			$this->roll_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_roll_no"));
		$this->roll_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_roll_no"));

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty"));
		$this->qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty"));

		// pl_no
		if (!$this->isAddOrEdit())
			$this->pl_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pl_no"));
		$this->pl_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pl_no"));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));

		// pp_id
		if (!$this->isAddOrEdit())
			$this->pp_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pp_id"));
		$this->pp_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pp_id"));

		// 11
		if (!$this->isAddOrEdit())
			$this->_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__11"));
		$this->_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__11"));

		// 12
		if (!$this->isAddOrEdit())
			$this->_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__12"));
		$this->_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__12"));

		// 13
		if (!$this->isAddOrEdit())
			$this->_13->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__13"));
		$this->_13->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__13"));

		// 14
		if (!$this->isAddOrEdit())
			$this->_14->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__14"));
		$this->_14->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__14"));

		// 15
		if (!$this->isAddOrEdit())
			$this->_15->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__15"));
		$this->_15->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__15"));

		// 16
		if (!$this->isAddOrEdit())
			$this->_16->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__16"));
		$this->_16->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__16"));

		// 17
		if (!$this->isAddOrEdit())
			$this->_17->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__17"));
		$this->_17->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__17"));

		// 18
		if (!$this->isAddOrEdit())
			$this->_18->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__18"));
		$this->_18->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__18"));

		// 19
		if (!$this->isAddOrEdit())
			$this->_19->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__19"));
		$this->_19->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__19"));

		// 20
		if (!$this->isAddOrEdit())
			$this->_20->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__20"));
		$this->_20->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__20"));

		// 21
		if (!$this->isAddOrEdit())
			$this->_21->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__21"));
		$this->_21->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__21"));

		// 22
		if (!$this->isAddOrEdit())
			$this->_22->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__22"));
		$this->_22->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__22"));

		// 23
		if (!$this->isAddOrEdit())
			$this->_23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__23"));
		$this->_23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__23"));

		// 24
		if (!$this->isAddOrEdit())
			$this->_24->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__24"));
		$this->_24->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__24"));

		// 25
		if (!$this->isAddOrEdit())
			$this->_25->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__25"));
		$this->_25->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__25"));

		// 26
		if (!$this->isAddOrEdit())
			$this->_26->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__26"));
		$this->_26->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__26"));

		// 27
		if (!$this->isAddOrEdit())
			$this->_27->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__27"));
		$this->_27->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__27"));

		// 28
		if (!$this->isAddOrEdit())
			$this->_28->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__28"));
		$this->_28->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__28"));

		// 29
		if (!$this->isAddOrEdit())
			$this->_29->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__29"));
		$this->_29->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__29"));

		// 30
		if (!$this->isAddOrEdit())
			$this->_30->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__30"));
		$this->_30->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__30"));

		// 31
		if (!$this->isAddOrEdit())
			$this->_31->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__31"));
		$this->_31->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__31"));

		// 32
		if (!$this->isAddOrEdit())
			$this->_32->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__32"));
		$this->_32->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__32"));

		// 33
		if (!$this->isAddOrEdit())
			$this->_33->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__33"));
		$this->_33->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__33"));

		// 34
		if (!$this->isAddOrEdit())
			$this->_34->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__34"));
		$this->_34->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__34"));

		// 35
		if (!$this->isAddOrEdit())
			$this->_35->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__35"));
		$this->_35->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__35"));

		// 36
		if (!$this->isAddOrEdit())
			$this->_36->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__36"));
		$this->_36->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__36"));

		// 37
		if (!$this->isAddOrEdit())
			$this->_37->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__37"));
		$this->_37->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__37"));

		// 38
		if (!$this->isAddOrEdit())
			$this->_38->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__38"));
		$this->_38->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__38"));

		// 39
		if (!$this->isAddOrEdit())
			$this->_39->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__39"));
		$this->_39->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__39"));

		// 40
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__40"));
		$this->_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__40"));

		// 41
		if (!$this->isAddOrEdit())
			$this->_41->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__41"));
		$this->_41->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__41"));

		// 42
		if (!$this->isAddOrEdit())
			$this->_42->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__42"));
		$this->_42->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__42"));

		// 43
		if (!$this->isAddOrEdit())
			$this->_43->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__43"));
		$this->_43->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__43"));

		// 44
		if (!$this->isAddOrEdit())
			$this->_44->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__44"));
		$this->_44->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__44"));

		// 45
		if (!$this->isAddOrEdit())
			$this->_45->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__45"));
		$this->_45->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__45"));

		// 46
		if (!$this->isAddOrEdit())
			$this->_46->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__46"));
		$this->_46->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__46"));

		// 47
		if (!$this->isAddOrEdit())
			$this->_47->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__47"));
		$this->_47->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__47"));

		// 48
		if (!$this->isAddOrEdit())
			$this->_48->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__48"));
		$this->_48->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__48"));

		// 49
		if (!$this->isAddOrEdit())
			$this->_49->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__49"));
		$this->_49->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__49"));

		// 50
		if (!$this->isAddOrEdit())
			$this->_50->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__50"));
		$this->_50->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__50"));

		// p_remarks
		if (!$this->isAddOrEdit())
			$this->p_remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p_remarks"));
		$this->p_remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p_remarks"));

		// roll_no_qty_tmp
		if (!$this->isAddOrEdit())
			$this->roll_no_qty_tmp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_roll_no_qty_tmp"));
		$this->roll_no_qty_tmp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_roll_no_qty_tmp"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->pid->FormValue == $this->pid->CurrentValue && is_numeric(ConvertToFloatString($this->pid->CurrentValue)))
			$this->pid->CurrentValue = ConvertToFloatString($this->pid->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_u->FormValue == $this->sqm_u->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_u->CurrentValue)))
			$this->sqm_u->CurrentValue = ConvertToFloatString($this->sqm_u->CurrentValue);

		// Convert decimal values if posted back
		if ($this->c_sqm->FormValue == $this->c_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->c_sqm->CurrentValue)))
			$this->c_sqm->CurrentValue = ConvertToFloatString($this->c_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->q_sku->FormValue == $this->q_sku->CurrentValue && is_numeric(ConvertToFloatString($this->q_sku->CurrentValue)))
			$this->q_sku->CurrentValue = ConvertToFloatString($this->q_sku->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_discount->FormValue == $this->po_discount->CurrentValue && is_numeric(ConvertToFloatString($this->po_discount->CurrentValue)))
			$this->po_discount->CurrentValue = ConvertToFloatString($this->po_discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pl_no->FormValue == $this->pl_no->CurrentValue && is_numeric(ConvertToFloatString($this->pl_no->CurrentValue)))
			$this->pl_no->CurrentValue = ConvertToFloatString($this->pl_no->CurrentValue);

		// Convert decimal values if posted back
		if ($this->roll_no_qty_tmp->FormValue == $this->roll_no_qty_tmp->CurrentValue && is_numeric(ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue)))
			$this->roll_no_qty_tmp->CurrentValue = ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pid
		// po
		// design_id
		// size_cm
		// barcode
		// process_d
		// buyer_ref
		// order_date
		// despatch_date
		// despatch_week
		// dispatch_week_p
		// loom_plan
		// status
		// buyers_id
		// buyer_uid
		// buyer_loc
		// quantity
		// sqm
		// sqm_u
		// c_sqm
		// weaving_works
		// current_works
		// size_buyer
		// design
		// w_cm
		// l_cm
		// q_sku
		// po_price
		// po_discount
		// po_currency
		// product_type
		// shape
		// payment_plan
		// production_plan
		// datetime
		// completed
		// buyer_po
		// operator
		// jc_no
		// sqm_a
		// 2srm
		// 2srm_a
		// 4srm
		// 4srm_a
		// buyer_tid
		// grp
		// s_grp
		// batch_no
		// cs
		// process
		// process_c
		// weight
		// remarks
		// roll_no
		// qty
		// pl_no
		// category
		// pp_id
		// consignee
		// buyer_barcode
		// design_next
		// 11
		// 12
		// 13
		// 14
		// 15
		// 16
		// 17
		// 18
		// 19
		// 20
		// 21
		// 22
		// 23
		// 24
		// 25
		// 26
		// 27
		// 28
		// 29
		// 30
		// 31
		// 32
		// 33
		// 34
		// 35
		// 36
		// 37
		// 38
		// 39
		// 40
		// 41
		// 42
		// 43
		// 44
		// 45
		// 46
		// 47
		// 48
		// 49
		// 50
		// packing_type
		// qc_weaving
		// p_remarks
		// roll_no_qty_tmp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pid
			$this->pid->ViewValue = $this->pid->CurrentValue;
			$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
			$this->pid->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design_id
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->ViewValue = $this->design_id->VirtualValue;
			} else {
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// process_d
			$curVal = strval($this->process_d->CurrentValue);
			if ($curVal <> "") {
				$this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
				if ($this->process_d->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_d->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_d->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_d->ViewValue = $this->process_d->CurrentValue;
					}
				}
			} else {
				$this->process_d->ViewValue = NULL;
			}
			$this->process_d->ViewCustomAttributes = "";

			// buyer_ref
			if ($this->buyer_ref->VirtualValue <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
			} else {
			$curVal = strval($this->buyer_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_ref->ViewValue = NULL;
			}
			}
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
			$this->order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// dispatch_week_p
			$curVal = strval($this->dispatch_week_p->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
				if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
					}
				}
			} else {
				$this->dispatch_week_p->ViewValue = NULL;
			}
			$this->dispatch_week_p->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
			$this->buyer_uid->ViewCustomAttributes = "";

			// buyer_loc
			$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
			$this->buyer_loc->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_u
			$this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
			$this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, 2, -2, -2, -2);
			$this->sqm_u->ViewCustomAttributes = "";

			// c_sqm
			$this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
			$this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, 2, -2, -2, -2);
			$this->c_sqm->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, 2, -2, -2, -2);
			$this->q_sku->ViewCustomAttributes = "";

			// po_price
			$this->po_price->ViewValue = $this->po_price->CurrentValue;
			$this->po_price->ViewCustomAttributes = "";

			// po_discount
			$this->po_discount->ViewValue = $this->po_discount->CurrentValue;
			$this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, 2, -2, -2, -2);
			$this->po_discount->ViewCustomAttributes = "";

			// po_currency
			$curVal = strval($this->po_currency->CurrentValue);
			if ($curVal <> "") {
				$this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
				if ($this->po_currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_currency->ViewValue = $this->po_currency->CurrentValue;
					}
				}
			} else {
				$this->po_currency->ViewValue = NULL;
			}
			$this->po_currency->ViewCustomAttributes = "";

			// product_type
			if (strval($this->product_type->CurrentValue) <> "") {
				$this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// payment_plan
			$curVal = strval($this->payment_plan->CurrentValue);
			if ($curVal <> "") {
				$this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
				if ($this->payment_plan->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->payment_plan->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_plan->ViewValue = $this->payment_plan->CurrentValue;
					}
				}
			} else {
				$this->payment_plan->ViewValue = NULL;
			}
			$this->payment_plan->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// buyer_po
			$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
			$this->buyer_po->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// cs
			if (strval($this->cs->CurrentValue) <> "") {
				$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
			} else {
				$this->cs->ViewValue = NULL;
			}
			$this->cs->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process->ViewValue->add($this->process->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_c
			$curVal = strval($this->process_c->CurrentValue);
			if ($curVal <> "") {
				$this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
				if ($this->process_c->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_c->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_c->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_c->ViewValue = $this->process_c->CurrentValue;
					}
				}
			} else {
				$this->process_c->ViewValue = NULL;
			}
			$this->process_c->ViewCustomAttributes = "";

			// weight
			$this->weight->ViewValue = $this->weight->CurrentValue;
			$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
			$this->weight->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// pp_id
			$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
			$curVal = strval($this->pp_id->CurrentValue);
			if ($curVal <> "") {
				$this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
				if ($this->pp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
					}
				}
			} else {
				$this->pp_id->ViewValue = NULL;
			}
			$this->pp_id->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// p_remarks
			$this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
			$this->p_remarks->ViewCustomAttributes = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->ViewValue = $this->roll_no_qty_tmp->CurrentValue;
			$this->roll_no_qty_tmp->ViewValue = FormatNumber($this->roll_no_qty_tmp->ViewValue, 2, -2, -2, -2);
			$this->roll_no_qty_tmp->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// pid
			$this->pid->LinkCustomAttributes = "";
			$this->pid->HrefValue = "";
			$this->pid->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->design_id->CurrentValue)) {
				$this->design_id->HrefValue = "bcodelist.php?x_design_id=" . ((!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue)) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
				$this->design_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
			} else {
				$this->design_id->HrefValue = "";
			}
			$this->design_id->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// process_d
			$this->process_d->LinkCustomAttributes = "";
			$this->process_d->HrefValue = "";
			$this->process_d->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_ref->CurrentValue)) {
				$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
				$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
			} else {
				$this->buyer_ref->HrefValue = "";
			}
			$this->buyer_ref->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// dispatch_week_p
			$this->dispatch_week_p->LinkCustomAttributes = "";
			$this->dispatch_week_p->HrefValue = "";
			$this->dispatch_week_p->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyers_id->CurrentValue)) {
				$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
				$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
			} else {
				$this->buyers_id->HrefValue = "";
			}
			$this->buyers_id->TooltipValue = "";

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";
			$this->buyer_uid->TooltipValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";
			$this->buyer_loc->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_u
			$this->sqm_u->LinkCustomAttributes = "";
			$this->sqm_u->HrefValue = "";
			$this->sqm_u->TooltipValue = "";

			// c_sqm
			$this->c_sqm->LinkCustomAttributes = "";
			$this->c_sqm->HrefValue = "";
			$this->c_sqm->TooltipValue = "";

			// weaving_works
			$this->weaving_works->LinkCustomAttributes = "";
			$this->weaving_works->HrefValue = "";
			$this->weaving_works->TooltipValue = "";

			// current_works
			$this->current_works->LinkCustomAttributes = "";
			$this->current_works->HrefValue = "";
			$this->current_works->TooltipValue = "";

			// size_buyer
			$this->size_buyer->LinkCustomAttributes = "";
			$this->size_buyer->HrefValue = "";
			$this->size_buyer->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// po_price
			$this->po_price->LinkCustomAttributes = "";
			$this->po_price->HrefValue = "";
			$this->po_price->TooltipValue = "";

			// po_discount
			$this->po_discount->LinkCustomAttributes = "";
			$this->po_discount->HrefValue = "";
			$this->po_discount->TooltipValue = "";

			// po_currency
			$this->po_currency->LinkCustomAttributes = "";
			$this->po_currency->HrefValue = "";
			$this->po_currency->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// payment_plan
			$this->payment_plan->LinkCustomAttributes = "";
			$this->payment_plan->HrefValue = "";
			$this->payment_plan->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";
			$this->completed->TooltipValue = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";
			$this->buyer_po->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// cs
			$this->cs->LinkCustomAttributes = "";
			$this->cs->HrefValue = "";
			$this->cs->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";
			$this->pp_id->TooltipValue = "";

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";
			$this->_11->TooltipValue = "";

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";
			$this->_12->TooltipValue = "";

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";
			$this->_13->TooltipValue = "";

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";
			$this->_14->TooltipValue = "";

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";
			$this->_15->TooltipValue = "";

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";
			$this->_16->TooltipValue = "";

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";
			$this->_17->TooltipValue = "";

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";
			$this->_18->TooltipValue = "";

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";
			$this->_19->TooltipValue = "";

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";
			$this->_20->TooltipValue = "";

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";
			$this->_21->TooltipValue = "";

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";
			$this->_22->TooltipValue = "";

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";
			$this->_23->TooltipValue = "";

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";
			$this->_24->TooltipValue = "";

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";
			$this->_25->TooltipValue = "";

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";
			$this->_26->TooltipValue = "";

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";
			$this->_27->TooltipValue = "";

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";
			$this->_28->TooltipValue = "";

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";
			$this->_29->TooltipValue = "";

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";
			$this->_30->TooltipValue = "";

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";
			$this->_31->TooltipValue = "";

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";
			$this->_32->TooltipValue = "";

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";
			$this->_33->TooltipValue = "";

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";
			$this->_34->TooltipValue = "";

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";
			$this->_35->TooltipValue = "";

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";
			$this->_36->TooltipValue = "";

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";
			$this->_37->TooltipValue = "";

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";
			$this->_38->TooltipValue = "";

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";
			$this->_39->TooltipValue = "";

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";
			$this->_41->TooltipValue = "";

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";
			$this->_42->TooltipValue = "";

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";
			$this->_43->TooltipValue = "";

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";
			$this->_44->TooltipValue = "";

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";
			$this->_45->TooltipValue = "";

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";
			$this->_46->TooltipValue = "";

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";
			$this->_47->TooltipValue = "";

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";
			$this->_48->TooltipValue = "";

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";
			$this->_49->TooltipValue = "";

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";
			$this->_50->TooltipValue = "";

			// p_remarks
			$this->p_remarks->LinkCustomAttributes = "";
			$this->p_remarks->HrefValue = "";
			$this->p_remarks->TooltipValue = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->LinkCustomAttributes = "";
			$this->roll_no_qty_tmp->HrefValue = "";
			$this->roll_no_qty_tmp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// pid
			$this->pid->EditAttrs["class"] = "form-control";
			$this->pid->EditCustomAttributes = "";
			$this->pid->EditValue = HtmlEncode($this->pid->AdvancedSearch->SearchValue);
			$this->pid->PlaceHolder = RemoveHtml($this->pid->caption());

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue = HtmlEncode($this->po->AdvancedSearch->SearchValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			$this->po->EditValue2 = HtmlEncode($this->po->AdvancedSearch->SearchValue2);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// design_id
			$this->design_id->EditAttrs["class"] = "form-control";
			$this->design_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design_id->AdvancedSearch->SearchValue = HtmlDecode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->EditValue = HtmlEncode($this->design_id->AdvancedSearch->SearchValue);
			$this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

			// size_cm
			$this->size_cm->EditAttrs["class"] = "form-control";
			$this->size_cm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
			$this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue2 = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue2);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// process_d
			$this->process_d->EditCustomAttributes = "";
			$curVal = trim(strval($this->process_d->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->process_d->AdvancedSearch->ViewValue = $this->process_d->lookupCacheOption($curVal);
			else
				$this->process_d->AdvancedSearch->ViewValue = $this->process_d->Lookup !== NULL && is_array($this->process_d->Lookup->Options) ? $curVal : NULL;
			if ($this->process_d->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->process_d->EditValue = array_values($this->process_d->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->process_d->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->process_d->EditValue = $arwrk;
			}

			// buyer_ref
			$this->buyer_ref->EditAttrs["class"] = "form-control";
			$this->buyer_ref->EditCustomAttributes = "";
			$this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
			$this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

			// order_date
			$this->order_date->EditAttrs["class"] = "form-control";
			$this->order_date->EditCustomAttributes = "";
			$this->order_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->order_date->AdvancedSearch->SearchValue, 0), 8));
			$this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

			// despatch_date
			$this->despatch_date->EditAttrs["class"] = "form-control";
			$this->despatch_date->EditCustomAttributes = "";
			$this->despatch_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->despatch_date->AdvancedSearch->SearchValue, 0), 8));
			$this->despatch_date->PlaceHolder = RemoveHtml($this->despatch_date->caption());

			// despatch_week
			$this->despatch_week->EditAttrs["class"] = "form-control";
			$this->despatch_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->despatch_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
			else
				$this->despatch_week->AdvancedSearch->ViewValue = $this->despatch_week->Lookup !== NULL && is_array($this->despatch_week->Lookup->Options) ? $curVal : NULL;
			if ($this->despatch_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->despatch_week->EditValue = array_values($this->despatch_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->despatch_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->despatch_week->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->despatch_week->EditValue = $arwrk;
			}

			// dispatch_week_p
			$this->dispatch_week_p->EditAttrs["class"] = "form-control";
			$this->dispatch_week_p->EditCustomAttributes = "";
			$curVal = trim(strval($this->dispatch_week_p->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
			else
				$this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->Lookup !== NULL && is_array($this->dispatch_week_p->Lookup->Options) ? $curVal : NULL;
			if ($this->dispatch_week_p->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->dispatch_week_p->EditValue = array_values($this->dispatch_week_p->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->dispatch_week_p->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->dispatch_week_p->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->dispatch_week_p->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `grp` != 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// buyers_id
			$this->buyers_id->EditAttrs["class"] = "form-control";
			$this->buyers_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyers_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
			else
				$this->buyers_id->AdvancedSearch->ViewValue = $this->buyers_id->Lookup !== NULL && is_array($this->buyers_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyers_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyers_id->EditValue = array_values($this->buyers_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyers_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->buyers_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyers_id->EditValue = $arwrk;
			}

			// buyer_uid
			$this->buyer_uid->EditAttrs["class"] = "form-control";
			$this->buyer_uid->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_uid->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_uid->AdvancedSearch->SearchValue);
			$this->buyer_uid->EditValue = HtmlEncode($this->buyer_uid->AdvancedSearch->SearchValue);
			$this->buyer_uid->PlaceHolder = RemoveHtml($this->buyer_uid->caption());

			// buyer_loc
			$this->buyer_loc->EditAttrs["class"] = "form-control";
			$this->buyer_loc->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_loc->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_loc->AdvancedSearch->SearchValue);
			$this->buyer_loc->EditValue = HtmlEncode($this->buyer_loc->AdvancedSearch->SearchValue);
			$this->buyer_loc->PlaceHolder = RemoveHtml($this->buyer_loc->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// sqm
			$this->sqm->EditAttrs["class"] = "form-control";
			$this->sqm->EditCustomAttributes = "";
			$this->sqm->EditValue = HtmlEncode($this->sqm->AdvancedSearch->SearchValue);
			$this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

			// sqm_u
			$this->sqm_u->EditAttrs["class"] = "form-control";
			$this->sqm_u->EditCustomAttributes = "";
			$this->sqm_u->EditValue = HtmlEncode($this->sqm_u->AdvancedSearch->SearchValue);
			$this->sqm_u->PlaceHolder = RemoveHtml($this->sqm_u->caption());

			// c_sqm
			$this->c_sqm->EditAttrs["class"] = "form-control";
			$this->c_sqm->EditCustomAttributes = "";
			$this->c_sqm->EditValue = HtmlEncode($this->c_sqm->AdvancedSearch->SearchValue);
			$this->c_sqm->PlaceHolder = RemoveHtml($this->c_sqm->caption());

			// weaving_works
			$this->weaving_works->EditAttrs["class"] = "form-control";
			$this->weaving_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->weaving_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
			else
				$this->weaving_works->AdvancedSearch->ViewValue = $this->weaving_works->Lookup !== NULL && is_array($this->weaving_works->Lookup->Options) ? $curVal : NULL;
			if ($this->weaving_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->weaving_works->EditValue = array_values($this->weaving_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->weaving_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->weaving_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->weaving_works->EditValue = $arwrk;
			}

			// current_works
			$this->current_works->EditAttrs["class"] = "form-control";
			$this->current_works->EditCustomAttributes = "";
			$curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
			else
				$this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== NULL && is_array($this->current_works->Lookup->Options) ? $curVal : NULL;
			if ($this->current_works->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->current_works->EditValue = array_values($this->current_works->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->current_works->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->current_works->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->current_works->EditValue = $arwrk;
			}

			// size_buyer
			$this->size_buyer->EditAttrs["class"] = "form-control";
			$this->size_buyer->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size_buyer->AdvancedSearch->SearchValue = HtmlDecode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->EditValue = HtmlEncode($this->size_buyer->AdvancedSearch->SearchValue);
			$this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

			// q_sku
			$this->q_sku->EditAttrs["class"] = "form-control";
			$this->q_sku->EditCustomAttributes = "";
			$this->q_sku->EditValue = HtmlEncode($this->q_sku->AdvancedSearch->SearchValue);
			$this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

			// po_price
			$this->po_price->EditAttrs["class"] = "form-control";
			$this->po_price->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_price->AdvancedSearch->SearchValue = HtmlDecode($this->po_price->AdvancedSearch->SearchValue);
			$this->po_price->EditValue = HtmlEncode($this->po_price->AdvancedSearch->SearchValue);
			$this->po_price->PlaceHolder = RemoveHtml($this->po_price->caption());

			// po_discount
			$this->po_discount->EditAttrs["class"] = "form-control";
			$this->po_discount->EditCustomAttributes = "";
			$this->po_discount->EditValue = HtmlEncode($this->po_discount->AdvancedSearch->SearchValue);
			$this->po_discount->PlaceHolder = RemoveHtml($this->po_discount->caption());

			// po_currency
			$this->po_currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->po_currency->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->po_currency->AdvancedSearch->ViewValue = $this->po_currency->lookupCacheOption($curVal);
			else
				$this->po_currency->AdvancedSearch->ViewValue = $this->po_currency->Lookup !== NULL && is_array($this->po_currency->Lookup->Options) ? $curVal : NULL;
			if ($this->po_currency->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->po_currency->EditValue = array_values($this->po_currency->Lookup->Options);
				if ($this->po_currency->AdvancedSearch->ViewValue == "")
					$this->po_currency->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->po_currency->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->po_currency->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$this->po_currency->AdvancedSearch->ViewValue = $this->po_currency->displayValue($arwrk);
				} else {
					$this->po_currency->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->po_currency->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = "";
			$this->product_type->EditValue = $this->product_type->options(TRUE);

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->shape->AdvancedSearch->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->AdvancedSearch->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->shape->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// payment_plan
			$this->payment_plan->EditAttrs["class"] = "form-control";
			$this->payment_plan->EditCustomAttributes = "";
			$curVal = trim(strval($this->payment_plan->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->payment_plan->AdvancedSearch->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
			else
				$this->payment_plan->AdvancedSearch->ViewValue = $this->payment_plan->Lookup !== NULL && is_array($this->payment_plan->Lookup->Options) ? $curVal : NULL;
			if ($this->payment_plan->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->payment_plan->EditValue = array_values($this->payment_plan->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->payment_plan->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->payment_plan->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->payment_plan->EditValue = $arwrk;
			}

			// production_plan
			$this->production_plan->EditAttrs["class"] = "form-control";
			$this->production_plan->EditCustomAttributes = "";
			$this->production_plan->EditValue = $this->production_plan->options(TRUE);

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// completed
			$this->completed->EditAttrs["class"] = "form-control";
			$this->completed->EditCustomAttributes = "";
			$this->completed->EditValue = $this->completed->options(TRUE);

			// buyer_po
			$this->buyer_po->EditAttrs["class"] = "form-control";
			$this->buyer_po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->buyer_po->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->EditValue = HtmlEncode($this->buyer_po->AdvancedSearch->SearchValue);
			$this->buyer_po->PlaceHolder = RemoveHtml($this->buyer_po->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// cs
			$this->cs->EditAttrs["class"] = "form-control";
			$this->cs->EditCustomAttributes = "";
			$this->cs->EditValue = $this->cs->options(TRUE);

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->AdvancedSearch->SearchValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// pl_no
			$this->pl_no->EditAttrs["class"] = "form-control";
			$this->pl_no->EditCustomAttributes = "";
			$this->pl_no->EditValue = HtmlEncode($this->pl_no->AdvancedSearch->SearchValue);
			$this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// pp_id
			$this->pp_id->EditAttrs["class"] = "form-control";
			$this->pp_id->EditCustomAttributes = "";
			$this->pp_id->EditValue = HtmlEncode($this->pp_id->AdvancedSearch->SearchValue);
			$curVal = strval($this->pp_id->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->pp_id->EditValue = $this->pp_id->lookupCacheOption($curVal);
				if ($this->pp_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->pp_id->EditValue = $this->pp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pp_id->EditValue = HtmlEncode($this->pp_id->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->pp_id->EditValue = NULL;
			}
			$this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

			// 11
			$this->_11->EditAttrs["class"] = "form-control";
			$this->_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

			// 12
			$this->_12->EditAttrs["class"] = "form-control";
			$this->_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

			// 13
			$this->_13->EditAttrs["class"] = "form-control";
			$this->_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

			// 14
			$this->_14->EditAttrs["class"] = "form-control";
			$this->_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

			// 15
			$this->_15->EditAttrs["class"] = "form-control";
			$this->_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

			// 16
			$this->_16->EditAttrs["class"] = "form-control";
			$this->_16->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

			// 17
			$this->_17->EditAttrs["class"] = "form-control";
			$this->_17->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

			// 18
			$this->_18->EditAttrs["class"] = "form-control";
			$this->_18->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

			// 19
			$this->_19->EditAttrs["class"] = "form-control";
			$this->_19->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

			// 20
			$this->_20->EditAttrs["class"] = "form-control";
			$this->_20->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

			// 21
			$this->_21->EditAttrs["class"] = "form-control";
			$this->_21->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

			// 22
			$this->_22->EditAttrs["class"] = "form-control";
			$this->_22->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

			// 23
			$this->_23->EditAttrs["class"] = "form-control";
			$this->_23->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

			// 24
			$this->_24->EditAttrs["class"] = "form-control";
			$this->_24->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

			// 25
			$this->_25->EditAttrs["class"] = "form-control";
			$this->_25->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

			// 26
			$this->_26->EditAttrs["class"] = "form-control";
			$this->_26->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

			// 27
			$this->_27->EditAttrs["class"] = "form-control";
			$this->_27->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

			// 28
			$this->_28->EditAttrs["class"] = "form-control";
			$this->_28->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

			// 29
			$this->_29->EditAttrs["class"] = "form-control";
			$this->_29->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

			// 30
			$this->_30->EditAttrs["class"] = "form-control";
			$this->_30->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

			// 31
			$this->_31->EditAttrs["class"] = "form-control";
			$this->_31->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

			// 32
			$this->_32->EditAttrs["class"] = "form-control";
			$this->_32->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

			// 33
			$this->_33->EditAttrs["class"] = "form-control";
			$this->_33->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

			// 34
			$this->_34->EditAttrs["class"] = "form-control";
			$this->_34->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

			// 35
			$this->_35->EditAttrs["class"] = "form-control";
			$this->_35->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

			// 36
			$this->_36->EditAttrs["class"] = "form-control";
			$this->_36->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

			// 37
			$this->_37->EditAttrs["class"] = "form-control";
			$this->_37->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

			// 38
			$this->_38->EditAttrs["class"] = "form-control";
			$this->_38->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

			// 39
			$this->_39->EditAttrs["class"] = "form-control";
			$this->_39->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

			// 40
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// 41
			$this->_41->EditAttrs["class"] = "form-control";
			$this->_41->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

			// 42
			$this->_42->EditAttrs["class"] = "form-control";
			$this->_42->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

			// 43
			$this->_43->EditAttrs["class"] = "form-control";
			$this->_43->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

			// 44
			$this->_44->EditAttrs["class"] = "form-control";
			$this->_44->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

			// 45
			$this->_45->EditAttrs["class"] = "form-control";
			$this->_45->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

			// 46
			$this->_46->EditAttrs["class"] = "form-control";
			$this->_46->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

			// 47
			$this->_47->EditAttrs["class"] = "form-control";
			$this->_47->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

			// 48
			$this->_48->EditAttrs["class"] = "form-control";
			$this->_48->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

			// 49
			$this->_49->EditAttrs["class"] = "form-control";
			$this->_49->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

			// 50
			$this->_50->EditAttrs["class"] = "form-control";
			$this->_50->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

			// p_remarks
			$this->p_remarks->EditAttrs["class"] = "form-control";
			$this->p_remarks->EditCustomAttributes = "";
			$this->p_remarks->EditValue = HtmlEncode($this->p_remarks->AdvancedSearch->SearchValue);
			$this->p_remarks->PlaceHolder = RemoveHtml($this->p_remarks->caption());

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->EditAttrs["class"] = "form-control";
			$this->roll_no_qty_tmp->EditCustomAttributes = "";
			$this->roll_no_qty_tmp->EditValue = HtmlEncode($this->roll_no_qty_tmp->AdvancedSearch->SearchValue);
			$this->roll_no_qty_tmp->PlaceHolder = RemoveHtml($this->roll_no_qty_tmp->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->pid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pid->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->po->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}
		if (!CheckInteger($this->_barcode->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->_barcode->errorMessage());
		}
		if (!CheckDate($this->order_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->order_date->errorMessage());
		}
		if (!CheckDate($this->despatch_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->despatch_date->errorMessage());
		}
		if (!CheckInteger($this->quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->quantity->errorMessage());
		}
		if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm->errorMessage());
		}
		if (!CheckNumber($this->sqm_u->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->sqm_u->errorMessage());
		}
		if (!CheckNumber($this->c_sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->c_sqm->errorMessage());
		}
		if (!CheckNumber($this->q_sku->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->q_sku->errorMessage());
		}
		if (!CheckNumber($this->po_discount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po_discount->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->jc_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->jc_no->errorMessage());
		}
		if (!CheckInteger($this->roll_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->roll_no->errorMessage());
		}
		if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty->errorMessage());
		}
		if (!CheckNumber($this->pl_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pl_no->errorMessage());
		}
		if (!CheckInteger($this->pp_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pp_id->errorMessage());
		}
		if (!CheckNumber($this->roll_no_qty_tmp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->roll_no_qty_tmp->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->pid->AdvancedSearch->load();
		$this->po->AdvancedSearch->load();
		$this->design_id->AdvancedSearch->load();
		$this->size_cm->AdvancedSearch->load();
		$this->_barcode->AdvancedSearch->load();
		$this->process_d->AdvancedSearch->load();
		$this->buyer_ref->AdvancedSearch->load();
		$this->order_date->AdvancedSearch->load();
		$this->despatch_date->AdvancedSearch->load();
		$this->despatch_week->AdvancedSearch->load();
		$this->dispatch_week_p->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->buyers_id->AdvancedSearch->load();
		$this->buyer_uid->AdvancedSearch->load();
		$this->buyer_loc->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->sqm_u->AdvancedSearch->load();
		$this->c_sqm->AdvancedSearch->load();
		$this->weaving_works->AdvancedSearch->load();
		$this->current_works->AdvancedSearch->load();
		$this->size_buyer->AdvancedSearch->load();
		$this->q_sku->AdvancedSearch->load();
		$this->po_price->AdvancedSearch->load();
		$this->po_discount->AdvancedSearch->load();
		$this->po_currency->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->payment_plan->AdvancedSearch->load();
		$this->production_plan->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->completed->AdvancedSearch->load();
		$this->buyer_po->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->cs->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->pl_no->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->pp_id->AdvancedSearch->load();
		$this->_11->AdvancedSearch->load();
		$this->_12->AdvancedSearch->load();
		$this->_13->AdvancedSearch->load();
		$this->_14->AdvancedSearch->load();
		$this->_15->AdvancedSearch->load();
		$this->_16->AdvancedSearch->load();
		$this->_17->AdvancedSearch->load();
		$this->_18->AdvancedSearch->load();
		$this->_19->AdvancedSearch->load();
		$this->_20->AdvancedSearch->load();
		$this->_21->AdvancedSearch->load();
		$this->_22->AdvancedSearch->load();
		$this->_23->AdvancedSearch->load();
		$this->_24->AdvancedSearch->load();
		$this->_25->AdvancedSearch->load();
		$this->_26->AdvancedSearch->load();
		$this->_27->AdvancedSearch->load();
		$this->_28->AdvancedSearch->load();
		$this->_29->AdvancedSearch->load();
		$this->_30->AdvancedSearch->load();
		$this->_31->AdvancedSearch->load();
		$this->_32->AdvancedSearch->load();
		$this->_33->AdvancedSearch->load();
		$this->_34->AdvancedSearch->load();
		$this->_35->AdvancedSearch->load();
		$this->_36->AdvancedSearch->load();
		$this->_37->AdvancedSearch->load();
		$this->_38->AdvancedSearch->load();
		$this->_39->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->_41->AdvancedSearch->load();
		$this->_42->AdvancedSearch->load();
		$this->_43->AdvancedSearch->load();
		$this->_44->AdvancedSearch->load();
		$this->_45->AdvancedSearch->load();
		$this->_46->AdvancedSearch->load();
		$this->_47->AdvancedSearch->load();
		$this->_48->AdvancedSearch->load();
		$this->_49->AdvancedSearch->load();
		$this->_50->AdvancedSearch->load();
		$this->p_remarks->AdvancedSearch->load();
		$this->roll_no_qty_tmp->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodelist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_design_id":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_d":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_weaving_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_design":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_c":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pp_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_design_id":
							break;
						case "x_process_d":
							break;
						case "x_buyer_ref":
							break;
						case "x_despatch_week":
							break;
						case "x_dispatch_week_p":
							break;
						case "x_status":
							break;
						case "x_buyers_id":
							break;
						case "x_weaving_works":
							break;
						case "x_current_works":
							break;
						case "x_design":
							break;
						case "x_po_currency":
							break;
						case "x_shape":
							break;
						case "x_payment_plan":
							break;
						case "x_operator":
							break;
						case "x_batch_no":
							break;
						case "x_process":
							break;
						case "x_process_c":
							break;
						case "x_category":
							break;
						case "x_pp_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'bcode');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>