<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class bcode_view extends bcode
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'bcode';

	// Page object name
	public $PageObjName = "bcode_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (bcode)
		if (!isset($GLOBALS["bcode"]) || get_class($GLOBALS["bcode"]) == PROJECT_NAMESPACE . "bcode") {
			$GLOBALS["bcode"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bcode"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'bcode');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $bcode;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($bcode);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "bcodeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("bcodelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->pid->setVisibility();
		$this->po->setVisibility();
		$this->design_id->setVisibility();
		$this->size_cm->setVisibility();
		$this->_barcode->setVisibility();
		$this->process_d->setVisibility();
		$this->buyer_ref->setVisibility();
		$this->order_date->setVisibility();
		$this->despatch_date->setVisibility();
		$this->despatch_week->setVisibility();
		$this->dispatch_week_p->setVisibility();
		$this->loom_plan->Visible = FALSE;
		$this->status->setVisibility();
		$this->buyers_id->setVisibility();
		$this->buyer_uid->setVisibility();
		$this->buyer_loc->setVisibility();
		$this->quantity->setVisibility();
		$this->sqm->setVisibility();
		$this->sqm_u->setVisibility();
		$this->c_sqm->setVisibility();
		$this->weaving_works->Visible = FALSE;
		$this->current_works->Visible = FALSE;
		$this->size_buyer->Visible = FALSE;
		$this->design->Visible = FALSE;
		$this->w_cm->Visible = FALSE;
		$this->l_cm->Visible = FALSE;
		$this->q_sku->setVisibility();
		$this->po_price->setVisibility();
		$this->po_discount->setVisibility();
		$this->po_currency->setVisibility();
		$this->product_type->setVisibility();
		$this->shape->setVisibility();
		$this->payment_plan->setVisibility();
		$this->production_plan->setVisibility();
		$this->datetime->setVisibility();
		$this->completed->setVisibility();
		$this->buyer_po->setVisibility();
		$this->operator->setVisibility();
		$this->jc_no->setVisibility();
		$this->sqm_a->setVisibility();
		$this->_2srm->setVisibility();
		$this->_2srm_a->setVisibility();
		$this->_4srm->setVisibility();
		$this->_4srm_a->setVisibility();
		$this->buyer_tid->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->batch_no->setVisibility();
		$this->cs->setVisibility();
		$this->process->setVisibility();
		$this->process_c->setVisibility();
		$this->weight->setVisibility();
		$this->remarks->setVisibility();
		$this->roll_no->setVisibility();
		$this->qty->setVisibility();
		$this->pl_no->setVisibility();
		$this->category->setVisibility();
		$this->pp_id->setVisibility();
		$this->consignee->Visible = FALSE;
		$this->buyer_barcode->Visible = FALSE;
		$this->design_next->Visible = FALSE;
		$this->_11->setVisibility();
		$this->_12->setVisibility();
		$this->_13->setVisibility();
		$this->_14->setVisibility();
		$this->_15->setVisibility();
		$this->_16->setVisibility();
		$this->_17->setVisibility();
		$this->_18->setVisibility();
		$this->_19->setVisibility();
		$this->_20->setVisibility();
		$this->_21->setVisibility();
		$this->_22->setVisibility();
		$this->_23->setVisibility();
		$this->_24->setVisibility();
		$this->_25->setVisibility();
		$this->_26->setVisibility();
		$this->_27->setVisibility();
		$this->_28->setVisibility();
		$this->_29->setVisibility();
		$this->_30->setVisibility();
		$this->_31->setVisibility();
		$this->_32->setVisibility();
		$this->_33->setVisibility();
		$this->_34->setVisibility();
		$this->_35->setVisibility();
		$this->_36->setVisibility();
		$this->_37->setVisibility();
		$this->_38->setVisibility();
		$this->_39->setVisibility();
		$this->_40->setVisibility();
		$this->_41->setVisibility();
		$this->_42->setVisibility();
		$this->_43->setVisibility();
		$this->_44->setVisibility();
		$this->_45->setVisibility();
		$this->_46->setVisibility();
		$this->_47->setVisibility();
		$this->_48->setVisibility();
		$this->_49->setVisibility();
		$this->_50->setVisibility();
		$this->packing_type->Visible = FALSE;
		$this->qc_weaving->Visible = FALSE;
		$this->p_remarks->setVisibility();
		$this->roll_no_qty_tmp->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->design_id);
		$this->setupLookupOptions($this->process_d);
		$this->setupLookupOptions($this->buyer_ref);
		$this->setupLookupOptions($this->despatch_week);
		$this->setupLookupOptions($this->dispatch_week_p);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->buyers_id);
		$this->setupLookupOptions($this->weaving_works);
		$this->setupLookupOptions($this->current_works);
		$this->setupLookupOptions($this->design);
		$this->setupLookupOptions($this->po_currency);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->payment_plan);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->process);
		$this->setupLookupOptions($this->process_c);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->pp_id);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "bcodelist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "bcodelist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "bcodelist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		if ($this->AuditTrailOnView)
			$this->writeAuditTrailOnView($row);
		$this->id->setDbValue($row['id']);
		$this->pid->setDbValue($row['pid']);
		$this->po->setDbValue($row['po']);
		$this->design_id->setDbValue($row['design_id']);
		if (array_key_exists('EV__design_id', $rs->fields)) {
			$this->design_id->VirtualValue = $rs->fields('EV__design_id'); // Set up virtual field value
		} else {
			$this->design_id->VirtualValue = ""; // Clear value
		}
		$this->size_cm->setDbValue($row['size_cm']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->process_d->setDbValue($row['process_d']);
		$this->buyer_ref->setDbValue($row['buyer_ref']);
		if (array_key_exists('EV__buyer_ref', $rs->fields)) {
			$this->buyer_ref->VirtualValue = $rs->fields('EV__buyer_ref'); // Set up virtual field value
		} else {
			$this->buyer_ref->VirtualValue = ""; // Clear value
		}
		$this->order_date->setDbValue($row['order_date']);
		$this->despatch_date->setDbValue($row['despatch_date']);
		$this->despatch_week->setDbValue($row['despatch_week']);
		$this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
		$this->loom_plan->setDbValue($row['loom_plan']);
		$this->status->setDbValue($row['status']);
		$this->buyers_id->setDbValue($row['buyers_id']);
		$this->buyer_uid->setDbValue($row['buyer_uid']);
		$this->buyer_loc->setDbValue($row['buyer_loc']);
		$this->quantity->setDbValue($row['quantity']);
		$this->sqm->setDbValue($row['sqm']);
		$this->sqm_u->setDbValue($row['sqm_u']);
		$this->c_sqm->setDbValue($row['c_sqm']);
		$this->weaving_works->setDbValue($row['weaving_works']);
		$this->current_works->setDbValue($row['current_works']);
		$this->size_buyer->setDbValue($row['size_buyer']);
		$this->design->setDbValue($row['design']);
		$this->w_cm->setDbValue($row['w_cm']);
		$this->l_cm->setDbValue($row['l_cm']);
		$this->q_sku->setDbValue($row['q_sku']);
		$this->po_price->setDbValue($row['po_price']);
		$this->po_discount->setDbValue($row['po_discount']);
		$this->po_currency->setDbValue($row['po_currency']);
		$this->product_type->setDbValue($row['product_type']);
		$this->shape->setDbValue($row['shape']);
		$this->payment_plan->setDbValue($row['payment_plan']);
		$this->production_plan->setDbValue($row['production_plan']);
		$this->datetime->setDbValue($row['datetime']);
		$this->completed->setDbValue($row['completed']);
		$this->buyer_po->setDbValue($row['buyer_po']);
		$this->operator->setDbValue($row['operator']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->sqm_a->setDbValue($row['sqm_a']);
		$this->_2srm->setDbValue($row['2srm']);
		$this->_2srm_a->setDbValue($row['2srm_a']);
		$this->_4srm->setDbValue($row['4srm']);
		$this->_4srm_a->setDbValue($row['4srm_a']);
		$this->buyer_tid->setDbValue($row['buyer_tid']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->cs->setDbValue($row['cs']);
		$this->process->setDbValue($row['process']);
		$this->process_c->setDbValue($row['process_c']);
		$this->weight->setDbValue($row['weight']);
		$this->remarks->setDbValue($row['remarks']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->qty->setDbValue($row['qty']);
		$this->pl_no->setDbValue($row['pl_no']);
		$this->category->setDbValue($row['category']);
		$this->pp_id->setDbValue($row['pp_id']);
		$this->consignee->setDbValue($row['consignee']);
		$this->buyer_barcode->setDbValue($row['buyer_barcode']);
		$this->design_next->setDbValue($row['design_next']);
		$this->_11->setDbValue($row['11']);
		$this->_12->setDbValue($row['12']);
		$this->_13->setDbValue($row['13']);
		$this->_14->setDbValue($row['14']);
		$this->_15->setDbValue($row['15']);
		$this->_16->setDbValue($row['16']);
		$this->_17->setDbValue($row['17']);
		$this->_18->setDbValue($row['18']);
		$this->_19->setDbValue($row['19']);
		$this->_20->setDbValue($row['20']);
		$this->_21->setDbValue($row['21']);
		$this->_22->setDbValue($row['22']);
		$this->_23->setDbValue($row['23']);
		$this->_24->setDbValue($row['24']);
		$this->_25->setDbValue($row['25']);
		$this->_26->setDbValue($row['26']);
		$this->_27->setDbValue($row['27']);
		$this->_28->setDbValue($row['28']);
		$this->_29->setDbValue($row['29']);
		$this->_30->setDbValue($row['30']);
		$this->_31->setDbValue($row['31']);
		$this->_32->setDbValue($row['32']);
		$this->_33->setDbValue($row['33']);
		$this->_34->setDbValue($row['34']);
		$this->_35->setDbValue($row['35']);
		$this->_36->setDbValue($row['36']);
		$this->_37->setDbValue($row['37']);
		$this->_38->setDbValue($row['38']);
		$this->_39->setDbValue($row['39']);
		$this->_40->setDbValue($row['40']);
		$this->_41->setDbValue($row['41']);
		$this->_42->setDbValue($row['42']);
		$this->_43->setDbValue($row['43']);
		$this->_44->setDbValue($row['44']);
		$this->_45->setDbValue($row['45']);
		$this->_46->setDbValue($row['46']);
		$this->_47->setDbValue($row['47']);
		$this->_48->setDbValue($row['48']);
		$this->_49->setDbValue($row['49']);
		$this->_50->setDbValue($row['50']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->qc_weaving->setDbValue($row['qc_weaving']);
		$this->p_remarks->setDbValue($row['p_remarks']);
		$this->roll_no_qty_tmp->setDbValue($row['roll_no_qty_tmp']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['pid'] = NULL;
		$row['po'] = NULL;
		$row['design_id'] = NULL;
		$row['size_cm'] = NULL;
		$row['barcode'] = NULL;
		$row['process_d'] = NULL;
		$row['buyer_ref'] = NULL;
		$row['order_date'] = NULL;
		$row['despatch_date'] = NULL;
		$row['despatch_week'] = NULL;
		$row['dispatch_week_p'] = NULL;
		$row['loom_plan'] = NULL;
		$row['status'] = NULL;
		$row['buyers_id'] = NULL;
		$row['buyer_uid'] = NULL;
		$row['buyer_loc'] = NULL;
		$row['quantity'] = NULL;
		$row['sqm'] = NULL;
		$row['sqm_u'] = NULL;
		$row['c_sqm'] = NULL;
		$row['weaving_works'] = NULL;
		$row['current_works'] = NULL;
		$row['size_buyer'] = NULL;
		$row['design'] = NULL;
		$row['w_cm'] = NULL;
		$row['l_cm'] = NULL;
		$row['q_sku'] = NULL;
		$row['po_price'] = NULL;
		$row['po_discount'] = NULL;
		$row['po_currency'] = NULL;
		$row['product_type'] = NULL;
		$row['shape'] = NULL;
		$row['payment_plan'] = NULL;
		$row['production_plan'] = NULL;
		$row['datetime'] = NULL;
		$row['completed'] = NULL;
		$row['buyer_po'] = NULL;
		$row['operator'] = NULL;
		$row['jc_no'] = NULL;
		$row['sqm_a'] = NULL;
		$row['2srm'] = NULL;
		$row['2srm_a'] = NULL;
		$row['4srm'] = NULL;
		$row['4srm_a'] = NULL;
		$row['buyer_tid'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['batch_no'] = NULL;
		$row['cs'] = NULL;
		$row['process'] = NULL;
		$row['process_c'] = NULL;
		$row['weight'] = NULL;
		$row['remarks'] = NULL;
		$row['roll_no'] = NULL;
		$row['qty'] = NULL;
		$row['pl_no'] = NULL;
		$row['category'] = NULL;
		$row['pp_id'] = NULL;
		$row['consignee'] = NULL;
		$row['buyer_barcode'] = NULL;
		$row['design_next'] = NULL;
		$row['11'] = NULL;
		$row['12'] = NULL;
		$row['13'] = NULL;
		$row['14'] = NULL;
		$row['15'] = NULL;
		$row['16'] = NULL;
		$row['17'] = NULL;
		$row['18'] = NULL;
		$row['19'] = NULL;
		$row['20'] = NULL;
		$row['21'] = NULL;
		$row['22'] = NULL;
		$row['23'] = NULL;
		$row['24'] = NULL;
		$row['25'] = NULL;
		$row['26'] = NULL;
		$row['27'] = NULL;
		$row['28'] = NULL;
		$row['29'] = NULL;
		$row['30'] = NULL;
		$row['31'] = NULL;
		$row['32'] = NULL;
		$row['33'] = NULL;
		$row['34'] = NULL;
		$row['35'] = NULL;
		$row['36'] = NULL;
		$row['37'] = NULL;
		$row['38'] = NULL;
		$row['39'] = NULL;
		$row['40'] = NULL;
		$row['41'] = NULL;
		$row['42'] = NULL;
		$row['43'] = NULL;
		$row['44'] = NULL;
		$row['45'] = NULL;
		$row['46'] = NULL;
		$row['47'] = NULL;
		$row['48'] = NULL;
		$row['49'] = NULL;
		$row['50'] = NULL;
		$row['packing_type'] = NULL;
		$row['qc_weaving'] = NULL;
		$row['p_remarks'] = NULL;
		$row['roll_no_qty_tmp'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->pid->FormValue == $this->pid->CurrentValue && is_numeric(ConvertToFloatString($this->pid->CurrentValue)))
			$this->pid->CurrentValue = ConvertToFloatString($this->pid->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_u->FormValue == $this->sqm_u->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_u->CurrentValue)))
			$this->sqm_u->CurrentValue = ConvertToFloatString($this->sqm_u->CurrentValue);

		// Convert decimal values if posted back
		if ($this->c_sqm->FormValue == $this->c_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->c_sqm->CurrentValue)))
			$this->c_sqm->CurrentValue = ConvertToFloatString($this->c_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->q_sku->FormValue == $this->q_sku->CurrentValue && is_numeric(ConvertToFloatString($this->q_sku->CurrentValue)))
			$this->q_sku->CurrentValue = ConvertToFloatString($this->q_sku->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_discount->FormValue == $this->po_discount->CurrentValue && is_numeric(ConvertToFloatString($this->po_discount->CurrentValue)))
			$this->po_discount->CurrentValue = ConvertToFloatString($this->po_discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm_a->FormValue == $this->sqm_a->CurrentValue && is_numeric(ConvertToFloatString($this->sqm_a->CurrentValue)))
			$this->sqm_a->CurrentValue = ConvertToFloatString($this->sqm_a->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_2srm->FormValue == $this->_2srm->CurrentValue && is_numeric(ConvertToFloatString($this->_2srm->CurrentValue)))
			$this->_2srm->CurrentValue = ConvertToFloatString($this->_2srm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_2srm_a->FormValue == $this->_2srm_a->CurrentValue && is_numeric(ConvertToFloatString($this->_2srm_a->CurrentValue)))
			$this->_2srm_a->CurrentValue = ConvertToFloatString($this->_2srm_a->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_4srm->FormValue == $this->_4srm->CurrentValue && is_numeric(ConvertToFloatString($this->_4srm->CurrentValue)))
			$this->_4srm->CurrentValue = ConvertToFloatString($this->_4srm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_4srm_a->FormValue == $this->_4srm_a->CurrentValue && is_numeric(ConvertToFloatString($this->_4srm_a->CurrentValue)))
			$this->_4srm_a->CurrentValue = ConvertToFloatString($this->_4srm_a->CurrentValue);

		// Convert decimal values if posted back
		if ($this->weight->FormValue == $this->weight->CurrentValue && is_numeric(ConvertToFloatString($this->weight->CurrentValue)))
			$this->weight->CurrentValue = ConvertToFloatString($this->weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pl_no->FormValue == $this->pl_no->CurrentValue && is_numeric(ConvertToFloatString($this->pl_no->CurrentValue)))
			$this->pl_no->CurrentValue = ConvertToFloatString($this->pl_no->CurrentValue);

		// Convert decimal values if posted back
		if ($this->roll_no_qty_tmp->FormValue == $this->roll_no_qty_tmp->CurrentValue && is_numeric(ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue)))
			$this->roll_no_qty_tmp->CurrentValue = ConvertToFloatString($this->roll_no_qty_tmp->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pid
		// po
		// design_id
		// size_cm
		// barcode
		// process_d
		// buyer_ref
		// order_date
		// despatch_date
		// despatch_week
		// dispatch_week_p
		// loom_plan
		// status
		// buyers_id
		// buyer_uid
		// buyer_loc
		// quantity
		// sqm
		// sqm_u
		// c_sqm
		// weaving_works
		// current_works
		// size_buyer
		// design
		// w_cm
		// l_cm
		// q_sku
		// po_price
		// po_discount
		// po_currency
		// product_type
		// shape
		// payment_plan
		// production_plan
		// datetime
		// completed
		// buyer_po
		// operator
		// jc_no
		// sqm_a
		// 2srm
		// 2srm_a
		// 4srm
		// 4srm_a
		// buyer_tid
		// grp
		// s_grp
		// batch_no
		// cs
		// process
		// process_c
		// weight
		// remarks
		// roll_no
		// qty
		// pl_no
		// category
		// pp_id
		// consignee
		// buyer_barcode
		// design_next
		// 11
		// 12
		// 13
		// 14
		// 15
		// 16
		// 17
		// 18
		// 19
		// 20
		// 21
		// 22
		// 23
		// 24
		// 25
		// 26
		// 27
		// 28
		// 29
		// 30
		// 31
		// 32
		// 33
		// 34
		// 35
		// 36
		// 37
		// 38
		// 39
		// 40
		// 41
		// 42
		// 43
		// 44
		// 45
		// 46
		// 47
		// 48
		// 49
		// 50
		// packing_type
		// qc_weaving
		// p_remarks
		// roll_no_qty_tmp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pid
			$this->pid->ViewValue = $this->pid->CurrentValue;
			$this->pid->ViewValue = FormatNumber($this->pid->ViewValue, 0, -2, -2, -2);
			$this->pid->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewValue = FormatNumber($this->po->ViewValue, 0, -2, -2, -2);
			$this->po->ViewCustomAttributes = "";

			// design_id
			if ($this->design_id->VirtualValue <> "") {
				$this->design_id->ViewValue = $this->design_id->VirtualValue;
			} else {
			$curVal = strval($this->design_id->CurrentValue);
			if ($curVal <> "") {
				$this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
				if ($this->design_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->design_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->design_id->ViewValue = $this->design_id->CurrentValue;
					}
				}
			} else {
				$this->design_id->ViewValue = NULL;
			}
			}
			$this->design_id->ViewCustomAttributes = "";

			// size_cm
			$this->size_cm->ViewValue = $this->size_cm->CurrentValue;
			$this->size_cm->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, 0, -2, -2, -2);
			$this->_barcode->ViewCustomAttributes = "";

			// process_d
			$curVal = strval($this->process_d->CurrentValue);
			if ($curVal <> "") {
				$this->process_d->ViewValue = $this->process_d->lookupCacheOption($curVal);
				if ($this->process_d->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_d->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_d->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_d->ViewValue->add($this->process_d->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_d->ViewValue = $this->process_d->CurrentValue;
					}
				}
			} else {
				$this->process_d->ViewValue = NULL;
			}
			$this->process_d->ViewCustomAttributes = "";

			// buyer_ref
			if ($this->buyer_ref->VirtualValue <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->VirtualValue;
			} else {
			$curVal = strval($this->buyer_ref->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
				if ($this->buyer_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyer_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
					}
				}
			} else {
				$this->buyer_ref->ViewValue = NULL;
			}
			}
			$this->buyer_ref->ViewCustomAttributes = "";

			// order_date
			$this->order_date->ViewValue = $this->order_date->CurrentValue;
			$this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, 0);
			$this->order_date->ViewCustomAttributes = "";

			// despatch_date
			$this->despatch_date->ViewValue = $this->despatch_date->CurrentValue;
			$this->despatch_date->ViewValue = FormatDateTime($this->despatch_date->ViewValue, 0);
			$this->despatch_date->ViewCustomAttributes = "";

			// despatch_week
			$curVal = strval($this->despatch_week->CurrentValue);
			if ($curVal <> "") {
				$this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
				if ($this->despatch_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->despatch_week->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->despatch_week->ViewValue = $this->despatch_week->CurrentValue;
					}
				}
			} else {
				$this->despatch_week->ViewValue = NULL;
			}
			$this->despatch_week->ViewCustomAttributes = "";

			// dispatch_week_p
			$curVal = strval($this->dispatch_week_p->CurrentValue);
			if ($curVal <> "") {
				$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
				if ($this->dispatch_week_p->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->dispatch_week_p->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->dispatch_week_p->ViewValue = $this->dispatch_week_p->CurrentValue;
					}
				}
			} else {
				$this->dispatch_week_p->ViewValue = NULL;
			}
			$this->dispatch_week_p->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyers_id
			$curVal = strval($this->buyers_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
				if ($this->buyers_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->buyers_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyers_id->ViewValue = $this->buyers_id->CurrentValue;
					}
				}
			} else {
				$this->buyers_id->ViewValue = NULL;
			}
			$this->buyers_id->ViewCustomAttributes = "";

			// buyer_uid
			$this->buyer_uid->ViewValue = $this->buyer_uid->CurrentValue;
			$this->buyer_uid->ViewCustomAttributes = "";

			// buyer_loc
			$this->buyer_loc->ViewValue = $this->buyer_loc->CurrentValue;
			$this->buyer_loc->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, 2, -2, -2, -2);
			$this->sqm->ViewCustomAttributes = "";

			// sqm_u
			$this->sqm_u->ViewValue = $this->sqm_u->CurrentValue;
			$this->sqm_u->ViewValue = FormatNumber($this->sqm_u->ViewValue, 2, -2, -2, -2);
			$this->sqm_u->ViewCustomAttributes = "";

			// c_sqm
			$this->c_sqm->ViewValue = $this->c_sqm->CurrentValue;
			$this->c_sqm->ViewValue = FormatNumber($this->c_sqm->ViewValue, 2, -2, -2, -2);
			$this->c_sqm->ViewCustomAttributes = "";

			// weaving_works
			$curVal = strval($this->weaving_works->CurrentValue);
			if ($curVal <> "") {
				$this->weaving_works->ViewValue = $this->weaving_works->lookupCacheOption($curVal);
				if ($this->weaving_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->weaving_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->weaving_works->ViewValue = $this->weaving_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
					}
				}
			} else {
				$this->weaving_works->ViewValue = NULL;
			}
			$this->weaving_works->ViewCustomAttributes = "";

			// current_works
			$curVal = strval($this->current_works->CurrentValue);
			if ($curVal <> "") {
				$this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
				if ($this->current_works->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->current_works->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->current_works->ViewValue = $this->current_works->CurrentValue;
					}
				}
			} else {
				$this->current_works->ViewValue = NULL;
			}
			$this->current_works->ViewCustomAttributes = "";

			// size_buyer
			$this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;
			$this->size_buyer->ViewCustomAttributes = "";

			// q_sku
			$this->q_sku->ViewValue = $this->q_sku->CurrentValue;
			$this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, 2, -2, -2, -2);
			$this->q_sku->ViewCustomAttributes = "";

			// po_price
			$this->po_price->ViewValue = $this->po_price->CurrentValue;
			$this->po_price->ViewCustomAttributes = "";

			// po_discount
			$this->po_discount->ViewValue = $this->po_discount->CurrentValue;
			$this->po_discount->ViewValue = FormatNumber($this->po_discount->ViewValue, 2, -2, -2, -2);
			$this->po_discount->ViewCustomAttributes = "";

			// po_currency
			$curVal = strval($this->po_currency->CurrentValue);
			if ($curVal <> "") {
				$this->po_currency->ViewValue = $this->po_currency->lookupCacheOption($curVal);
				if ($this->po_currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po_currency->ViewValue = $this->po_currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_currency->ViewValue = $this->po_currency->CurrentValue;
					}
				}
			} else {
				$this->po_currency->ViewValue = NULL;
			}
			$this->po_currency->ViewCustomAttributes = "";

			// product_type
			if (strval($this->product_type->CurrentValue) <> "") {
				$this->product_type->ViewValue = $this->product_type->optionCaption($this->product_type->CurrentValue);
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// payment_plan
			$curVal = strval($this->payment_plan->CurrentValue);
			if ($curVal <> "") {
				$this->payment_plan->ViewValue = $this->payment_plan->lookupCacheOption($curVal);
				if ($this->payment_plan->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->payment_plan->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->payment_plan->ViewValue = $this->payment_plan->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->payment_plan->ViewValue = $this->payment_plan->CurrentValue;
					}
				}
			} else {
				$this->payment_plan->ViewValue = NULL;
			}
			$this->payment_plan->ViewCustomAttributes = "";

			// production_plan
			if (strval($this->production_plan->CurrentValue) <> "") {
				$this->production_plan->ViewValue = $this->production_plan->optionCaption($this->production_plan->CurrentValue);
			} else {
				$this->production_plan->ViewValue = NULL;
			}
			$this->production_plan->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// completed
			if (strval($this->completed->CurrentValue) <> "") {
				$this->completed->ViewValue = $this->completed->optionCaption($this->completed->CurrentValue);
			} else {
				$this->completed->ViewValue = NULL;
			}
			$this->completed->ViewCustomAttributes = "";

			// buyer_po
			$this->buyer_po->ViewValue = $this->buyer_po->CurrentValue;
			$this->buyer_po->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// sqm_a
			$this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
			$this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, 2, -2, -2, -2);
			$this->sqm_a->ViewCustomAttributes = "";

			// 2srm
			$this->_2srm->ViewValue = $this->_2srm->CurrentValue;
			$this->_2srm->ViewValue = FormatNumber($this->_2srm->ViewValue, 2, -2, -2, -2);
			$this->_2srm->ViewCustomAttributes = "";

			// 2srm_a
			$this->_2srm_a->ViewValue = $this->_2srm_a->CurrentValue;
			$this->_2srm_a->ViewValue = FormatNumber($this->_2srm_a->ViewValue, 2, -2, -2, -2);
			$this->_2srm_a->ViewCustomAttributes = "";

			// 4srm
			$this->_4srm->ViewValue = $this->_4srm->CurrentValue;
			$this->_4srm->ViewValue = FormatNumber($this->_4srm->ViewValue, 2, -2, -2, -2);
			$this->_4srm->ViewCustomAttributes = "";

			// 4srm_a
			$this->_4srm_a->ViewValue = $this->_4srm_a->CurrentValue;
			$this->_4srm_a->ViewValue = FormatNumber($this->_4srm_a->ViewValue, 2, -2, -2, -2);
			$this->_4srm_a->ViewCustomAttributes = "";

			// buyer_tid
			$this->buyer_tid->ViewValue = $this->buyer_tid->CurrentValue;
			$this->buyer_tid->ViewCustomAttributes = "";

			// grp
			$this->grp->ViewValue = $this->grp->CurrentValue;
			$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
			$this->s_grp->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// cs
			if (strval($this->cs->CurrentValue) <> "") {
				$this->cs->ViewValue = $this->cs->optionCaption($this->cs->CurrentValue);
			} else {
				$this->cs->ViewValue = NULL;
			}
			$this->cs->ViewCustomAttributes = "";

			// process
			$curVal = strval($this->process->CurrentValue);
			if ($curVal <> "") {
				$this->process->ViewValue = $this->process->lookupCacheOption($curVal);
				if ($this->process->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process->ViewValue->add($this->process->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process->ViewValue = $this->process->CurrentValue;
					}
				}
			} else {
				$this->process->ViewValue = NULL;
			}
			$this->process->ViewCustomAttributes = "";

			// process_c
			$curVal = strval($this->process_c->CurrentValue);
			if ($curVal <> "") {
				$this->process_c->ViewValue = $this->process_c->lookupCacheOption($curVal);
				if ($this->process_c->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->process_c->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->process_c->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->process_c->ViewValue->add($this->process_c->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->process_c->ViewValue = $this->process_c->CurrentValue;
					}
				}
			} else {
				$this->process_c->ViewValue = NULL;
			}
			$this->process_c->ViewCustomAttributes = "";

			// weight
			$this->weight->ViewValue = $this->weight->CurrentValue;
			$this->weight->ViewValue = FormatNumber($this->weight->ViewValue, 2, -2, -2, -2);
			$this->weight->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewValue = FormatNumber($this->roll_no->ViewValue, 0, -2, -2, -2);
			$this->roll_no->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// pl_no
			$this->pl_no->ViewValue = $this->pl_no->CurrentValue;
			$this->pl_no->ViewValue = FormatNumber($this->pl_no->ViewValue, 2, -2, -2, -2);
			$this->pl_no->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// pp_id
			$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
			$curVal = strval($this->pp_id->CurrentValue);
			if ($curVal <> "") {
				$this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
				if ($this->pp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pp_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pp_id->ViewValue = $this->pp_id->CurrentValue;
					}
				}
			} else {
				$this->pp_id->ViewValue = NULL;
			}
			$this->pp_id->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// p_remarks
			$this->p_remarks->ViewValue = $this->p_remarks->CurrentValue;
			$this->p_remarks->ViewCustomAttributes = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->ViewValue = $this->roll_no_qty_tmp->CurrentValue;
			$this->roll_no_qty_tmp->ViewValue = FormatNumber($this->roll_no_qty_tmp->ViewValue, 2, -2, -2, -2);
			$this->roll_no_qty_tmp->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// pid
			$this->pid->LinkCustomAttributes = "";
			$this->pid->HrefValue = "";
			$this->pid->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// design_id
			$this->design_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->design_id->CurrentValue)) {
				$this->design_id->HrefValue = "bcodelist.php?x_design_id=" . ((!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue)) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
				$this->design_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
			} else {
				$this->design_id->HrefValue = "";
			}
			$this->design_id->TooltipValue = "";

			// size_cm
			$this->size_cm->LinkCustomAttributes = "";
			$this->size_cm->HrefValue = "";
			$this->size_cm->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// process_d
			$this->process_d->LinkCustomAttributes = "";
			$this->process_d->HrefValue = "";
			$this->process_d->TooltipValue = "";

			// buyer_ref
			$this->buyer_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyer_ref->CurrentValue)) {
				$this->buyer_ref->HrefValue = "bcodelist.php?x_buyer_ref=" . $this->buyer_ref->CurrentValue; // Add prefix/suffix
				$this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
			} else {
				$this->buyer_ref->HrefValue = "";
			}
			$this->buyer_ref->TooltipValue = "";

			// order_date
			$this->order_date->LinkCustomAttributes = "";
			$this->order_date->HrefValue = "";
			$this->order_date->TooltipValue = "";

			// despatch_date
			$this->despatch_date->LinkCustomAttributes = "";
			$this->despatch_date->HrefValue = "";
			$this->despatch_date->TooltipValue = "";

			// despatch_week
			$this->despatch_week->LinkCustomAttributes = "";
			$this->despatch_week->HrefValue = "";
			$this->despatch_week->TooltipValue = "";

			// dispatch_week_p
			$this->dispatch_week_p->LinkCustomAttributes = "";
			$this->dispatch_week_p->HrefValue = "";
			$this->dispatch_week_p->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// buyers_id
			$this->buyers_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->buyers_id->CurrentValue)) {
				$this->buyers_id->HrefValue = "bcodelist.php?x_buyers_id=" . $this->buyers_id->CurrentValue; // Add prefix/suffix
				$this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
			} else {
				$this->buyers_id->HrefValue = "";
			}
			$this->buyers_id->TooltipValue = "";

			// buyer_uid
			$this->buyer_uid->LinkCustomAttributes = "";
			$this->buyer_uid->HrefValue = "";
			$this->buyer_uid->TooltipValue = "";

			// buyer_loc
			$this->buyer_loc->LinkCustomAttributes = "";
			$this->buyer_loc->HrefValue = "";
			$this->buyer_loc->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// sqm_u
			$this->sqm_u->LinkCustomAttributes = "";
			$this->sqm_u->HrefValue = "";
			$this->sqm_u->TooltipValue = "";

			// c_sqm
			$this->c_sqm->LinkCustomAttributes = "";
			$this->c_sqm->HrefValue = "";
			$this->c_sqm->TooltipValue = "";

			// q_sku
			$this->q_sku->LinkCustomAttributes = "";
			$this->q_sku->HrefValue = "";
			$this->q_sku->TooltipValue = "";

			// po_price
			$this->po_price->LinkCustomAttributes = "";
			$this->po_price->HrefValue = "";
			$this->po_price->TooltipValue = "";

			// po_discount
			$this->po_discount->LinkCustomAttributes = "";
			$this->po_discount->HrefValue = "";
			$this->po_discount->TooltipValue = "";

			// po_currency
			$this->po_currency->LinkCustomAttributes = "";
			$this->po_currency->HrefValue = "";
			$this->po_currency->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// payment_plan
			$this->payment_plan->LinkCustomAttributes = "";
			$this->payment_plan->HrefValue = "";
			$this->payment_plan->TooltipValue = "";

			// production_plan
			$this->production_plan->LinkCustomAttributes = "";
			$this->production_plan->HrefValue = "";
			$this->production_plan->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// completed
			$this->completed->LinkCustomAttributes = "";
			$this->completed->HrefValue = "";
			$this->completed->TooltipValue = "";

			// buyer_po
			$this->buyer_po->LinkCustomAttributes = "";
			$this->buyer_po->HrefValue = "";
			$this->buyer_po->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// sqm_a
			$this->sqm_a->LinkCustomAttributes = "";
			$this->sqm_a->HrefValue = "";
			$this->sqm_a->TooltipValue = "";

			// 2srm
			$this->_2srm->LinkCustomAttributes = "";
			$this->_2srm->HrefValue = "";
			$this->_2srm->TooltipValue = "";

			// 2srm_a
			$this->_2srm_a->LinkCustomAttributes = "";
			$this->_2srm_a->HrefValue = "";
			$this->_2srm_a->TooltipValue = "";

			// 4srm
			$this->_4srm->LinkCustomAttributes = "";
			$this->_4srm->HrefValue = "";
			$this->_4srm->TooltipValue = "";

			// 4srm_a
			$this->_4srm_a->LinkCustomAttributes = "";
			$this->_4srm_a->HrefValue = "";
			$this->_4srm_a->TooltipValue = "";

			// buyer_tid
			$this->buyer_tid->LinkCustomAttributes = "";
			$this->buyer_tid->HrefValue = "";
			$this->buyer_tid->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// cs
			$this->cs->LinkCustomAttributes = "";
			$this->cs->HrefValue = "";
			$this->cs->TooltipValue = "";

			// process
			$this->process->LinkCustomAttributes = "";
			$this->process->HrefValue = "";
			$this->process->TooltipValue = "";

			// process_c
			$this->process_c->LinkCustomAttributes = "";
			$this->process_c->HrefValue = "";
			$this->process_c->TooltipValue = "";

			// weight
			$this->weight->LinkCustomAttributes = "";
			$this->weight->HrefValue = "";
			$this->weight->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			$this->qty->HrefValue = "";
			$this->qty->TooltipValue = "";

			// pl_no
			$this->pl_no->LinkCustomAttributes = "";
			$this->pl_no->HrefValue = "";
			$this->pl_no->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// pp_id
			$this->pp_id->LinkCustomAttributes = "";
			$this->pp_id->HrefValue = "";
			$this->pp_id->TooltipValue = "";

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";
			$this->_11->TooltipValue = "";

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";
			$this->_12->TooltipValue = "";

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";
			$this->_13->TooltipValue = "";

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";
			$this->_14->TooltipValue = "";

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";
			$this->_15->TooltipValue = "";

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";
			$this->_16->TooltipValue = "";

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";
			$this->_17->TooltipValue = "";

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";
			$this->_18->TooltipValue = "";

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";
			$this->_19->TooltipValue = "";

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";
			$this->_20->TooltipValue = "";

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";
			$this->_21->TooltipValue = "";

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";
			$this->_22->TooltipValue = "";

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";
			$this->_23->TooltipValue = "";

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";
			$this->_24->TooltipValue = "";

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";
			$this->_25->TooltipValue = "";

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";
			$this->_26->TooltipValue = "";

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";
			$this->_27->TooltipValue = "";

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";
			$this->_28->TooltipValue = "";

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";
			$this->_29->TooltipValue = "";

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";
			$this->_30->TooltipValue = "";

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";
			$this->_31->TooltipValue = "";

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";
			$this->_32->TooltipValue = "";

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";
			$this->_33->TooltipValue = "";

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";
			$this->_34->TooltipValue = "";

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";
			$this->_35->TooltipValue = "";

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";
			$this->_36->TooltipValue = "";

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";
			$this->_37->TooltipValue = "";

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";
			$this->_38->TooltipValue = "";

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";
			$this->_39->TooltipValue = "";

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";
			$this->_41->TooltipValue = "";

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";
			$this->_42->TooltipValue = "";

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";
			$this->_43->TooltipValue = "";

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";
			$this->_44->TooltipValue = "";

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";
			$this->_45->TooltipValue = "";

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";
			$this->_46->TooltipValue = "";

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";
			$this->_47->TooltipValue = "";

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";
			$this->_48->TooltipValue = "";

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";
			$this->_49->TooltipValue = "";

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";
			$this->_50->TooltipValue = "";

			// p_remarks
			$this->p_remarks->LinkCustomAttributes = "";
			$this->p_remarks->HrefValue = "";
			$this->p_remarks->TooltipValue = "";

			// roll_no_qty_tmp
			$this->roll_no_qty_tmp->LinkCustomAttributes = "";
			$this->roll_no_qty_tmp->HrefValue = "";
			$this->roll_no_qty_tmp->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bcodelist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_design_id":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_d":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` != 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_weaving_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_current_works":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_design":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_process_c":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pp_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_design_id":
							break;
						case "x_process_d":
							break;
						case "x_buyer_ref":
							break;
						case "x_despatch_week":
							break;
						case "x_dispatch_week_p":
							break;
						case "x_status":
							break;
						case "x_buyers_id":
							break;
						case "x_weaving_works":
							break;
						case "x_current_works":
							break;
						case "x_design":
							break;
						case "x_po_currency":
							break;
						case "x_shape":
							break;
						case "x_payment_plan":
							break;
						case "x_operator":
							break;
						case "x_batch_no":
							break;
						case "x_process":
							break;
						case "x_process_c":
							break;
						case "x_category":
							break;
						case "x_pp_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'bcode');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>