<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class bom_edit extends bom
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'bom';

	// Page object name
	public $PageObjName = "bom_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (bom)
		if (!isset($GLOBALS["bom"]) || get_class($GLOBALS["bom"]) == PROJECT_NAMESPACE . "bom") {
			$GLOBALS["bom"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["bom"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (batch_no)
		if (!isset($GLOBALS['batch_no']))
			$GLOBALS['batch_no'] = new batch_no();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'bom');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $bom;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($bom);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "bomview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("bomlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->batch_no->setVisibility();
		$this->warp_weft->setVisibility();
		$this->m_grp->setVisibility();
		$this->m_sgrp->setVisibility();
		$this->m_product->setVisibility();
		$this->m_rid->setVisibility();
		$this->m_packing->setVisibility();
		$this->m_name->Visible = FALSE;
		$this->quantity_a->setVisibility();
		$this->bom_waste->setVisibility();
		$this->quantity->Visible = FALSE;
		$this->method->setVisibility();
		$this->unit->setVisibility();
		$this->gross_nett->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->packing_type->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->pp_qty->Visible = FALSE;
		$this->pp_bal->Visible = FALSE;
		$this->pp_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();
		$this->grp->Required = FALSE;
		$this->s_grp->Required = FALSE;
		$this->product->Required = FALSE;
		$this->rid->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->m_grp);
		$this->setupLookupOptions($this->m_sgrp);
		$this->setupLookupOptions($this->m_product);
		$this->setupLookupOptions($this->m_rid);
		$this->setupLookupOptions($this->m_packing);
		$this->setupLookupOptions($this->method);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Set up master detail parameters
		$this->setupMasterParms();

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("bomlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "bomlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_no->Visible = FALSE; // Disable update for API request
			else
				$this->batch_no->setFormValue($val);
		}

		// Check field name 'warp_weft' first before field var 'x_warp_weft'
		$val = $CurrentForm->hasValue("warp_weft") ? $CurrentForm->getValue("warp_weft") : $CurrentForm->getValue("x_warp_weft");
		if (!$this->warp_weft->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->warp_weft->Visible = FALSE; // Disable update for API request
			else
				$this->warp_weft->setFormValue($val);
		}

		// Check field name 'm_grp' first before field var 'x_m_grp'
		$val = $CurrentForm->hasValue("m_grp") ? $CurrentForm->getValue("m_grp") : $CurrentForm->getValue("x_m_grp");
		if (!$this->m_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_grp->Visible = FALSE; // Disable update for API request
			else
				$this->m_grp->setFormValue($val);
		}

		// Check field name 'm_sgrp' first before field var 'x_m_sgrp'
		$val = $CurrentForm->hasValue("m_sgrp") ? $CurrentForm->getValue("m_sgrp") : $CurrentForm->getValue("x_m_sgrp");
		if (!$this->m_sgrp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_sgrp->Visible = FALSE; // Disable update for API request
			else
				$this->m_sgrp->setFormValue($val);
		}

		// Check field name 'm_product' first before field var 'x_m_product'
		$val = $CurrentForm->hasValue("m_product") ? $CurrentForm->getValue("m_product") : $CurrentForm->getValue("x_m_product");
		if (!$this->m_product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_product->Visible = FALSE; // Disable update for API request
			else
				$this->m_product->setFormValue($val);
		}

		// Check field name 'm_rid' first before field var 'x_m_rid'
		$val = $CurrentForm->hasValue("m_rid") ? $CurrentForm->getValue("m_rid") : $CurrentForm->getValue("x_m_rid");
		if (!$this->m_rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_rid->Visible = FALSE; // Disable update for API request
			else
				$this->m_rid->setFormValue($val);
		}

		// Check field name 'm_packing' first before field var 'x_m_packing'
		$val = $CurrentForm->hasValue("m_packing") ? $CurrentForm->getValue("m_packing") : $CurrentForm->getValue("x_m_packing");
		if (!$this->m_packing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_packing->Visible = FALSE; // Disable update for API request
			else
				$this->m_packing->setFormValue($val);
		}

		// Check field name 'quantity_a' first before field var 'x_quantity_a'
		$val = $CurrentForm->hasValue("quantity_a") ? $CurrentForm->getValue("quantity_a") : $CurrentForm->getValue("x_quantity_a");
		if (!$this->quantity_a->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity_a->Visible = FALSE; // Disable update for API request
			else
				$this->quantity_a->setFormValue($val);
		}

		// Check field name 'bom_waste' first before field var 'x_bom_waste'
		$val = $CurrentForm->hasValue("bom_waste") ? $CurrentForm->getValue("bom_waste") : $CurrentForm->getValue("x_bom_waste");
		if (!$this->bom_waste->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bom_waste->Visible = FALSE; // Disable update for API request
			else
				$this->bom_waste->setFormValue($val);
		}

		// Check field name 'method' first before field var 'x_method'
		$val = $CurrentForm->hasValue("method") ? $CurrentForm->getValue("method") : $CurrentForm->getValue("x_method");
		if (!$this->method->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->method->Visible = FALSE; // Disable update for API request
			else
				$this->method->setFormValue($val);
		}

		// Check field name 'unit' first before field var 'x_unit'
		$val = $CurrentForm->hasValue("unit") ? $CurrentForm->getValue("unit") : $CurrentForm->getValue("x_unit");
		if (!$this->unit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unit->Visible = FALSE; // Disable update for API request
			else
				$this->unit->setFormValue($val);
		}

		// Check field name 'gross_nett' first before field var 'x_gross_nett'
		$val = $CurrentForm->hasValue("gross_nett") ? $CurrentForm->getValue("gross_nett") : $CurrentForm->getValue("x_gross_nett");
		if (!$this->gross_nett->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gross_nett->Visible = FALSE; // Disable update for API request
			else
				$this->gross_nett->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rid->Visible = FALSE; // Disable update for API request
			else
				$this->rid->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->batch_no->CurrentValue = $this->batch_no->FormValue;
		$this->warp_weft->CurrentValue = $this->warp_weft->FormValue;
		$this->m_grp->CurrentValue = $this->m_grp->FormValue;
		$this->m_sgrp->CurrentValue = $this->m_sgrp->FormValue;
		$this->m_product->CurrentValue = $this->m_product->FormValue;
		$this->m_rid->CurrentValue = $this->m_rid->FormValue;
		$this->m_packing->CurrentValue = $this->m_packing->FormValue;
		$this->quantity_a->CurrentValue = $this->quantity_a->FormValue;
		$this->bom_waste->CurrentValue = $this->bom_waste->FormValue;
		$this->method->CurrentValue = $this->method->FormValue;
		$this->unit->CurrentValue = $this->unit->FormValue;
		$this->gross_nett->CurrentValue = $this->gross_nett->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->rid->CurrentValue = $this->rid->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->warp_weft->setDbValue($row['warp_weft']);
		$this->m_grp->setDbValue($row['m_grp']);
		$this->m_sgrp->setDbValue($row['m_sgrp']);
		if (array_key_exists('EV__m_sgrp', $rs->fields)) {
			$this->m_sgrp->VirtualValue = $rs->fields('EV__m_sgrp'); // Set up virtual field value
		} else {
			$this->m_sgrp->VirtualValue = ""; // Clear value
		}
		$this->m_product->setDbValue($row['m_product']);
		if (array_key_exists('EV__m_product', $rs->fields)) {
			$this->m_product->VirtualValue = $rs->fields('EV__m_product'); // Set up virtual field value
		} else {
			$this->m_product->VirtualValue = ""; // Clear value
		}
		$this->m_rid->setDbValue($row['m_rid']);
		if (array_key_exists('EV__m_rid', $rs->fields)) {
			$this->m_rid->VirtualValue = $rs->fields('EV__m_rid'); // Set up virtual field value
		} else {
			$this->m_rid->VirtualValue = ""; // Clear value
		}
		$this->m_packing->setDbValue($row['m_packing']);
		$this->m_name->setDbValue($row['m_name']);
		$this->quantity_a->setDbValue($row['quantity_a']);
		$this->bom_waste->setDbValue($row['bom_waste']);
		$this->quantity->setDbValue($row['quantity']);
		$this->method->setDbValue($row['method']);
		$this->unit->setDbValue($row['unit']);
		$this->gross_nett->setDbValue($row['gross_nett']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->packing_type->setDbValue($row['packing_type']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->pp_qty->setDbValue($row['pp_qty']);
		$this->pp_bal->setDbValue($row['pp_bal']);
		$this->pp_id->setDbValue($row['pp_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['batch_no'] = NULL;
		$row['warp_weft'] = NULL;
		$row['m_grp'] = NULL;
		$row['m_sgrp'] = NULL;
		$row['m_product'] = NULL;
		$row['m_rid'] = NULL;
		$row['m_packing'] = NULL;
		$row['m_name'] = NULL;
		$row['quantity_a'] = NULL;
		$row['bom_waste'] = NULL;
		$row['quantity'] = NULL;
		$row['method'] = NULL;
		$row['unit'] = NULL;
		$row['gross_nett'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['packing_type'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['pp_qty'] = NULL;
		$row['pp_bal'] = NULL;
		$row['pp_id'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity_a->FormValue == $this->quantity_a->CurrentValue && is_numeric(ConvertToFloatString($this->quantity_a->CurrentValue)))
			$this->quantity_a->CurrentValue = ConvertToFloatString($this->quantity_a->CurrentValue);

		// Convert decimal values if posted back
		if ($this->bom_waste->FormValue == $this->bom_waste->CurrentValue && is_numeric(ConvertToFloatString($this->bom_waste->CurrentValue)))
			$this->bom_waste->CurrentValue = ConvertToFloatString($this->bom_waste->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// batch_no
		// warp_weft
		// m_grp
		// m_sgrp
		// m_product
		// m_rid
		// m_packing
		// m_name
		// quantity_a
		// bom_waste
		// quantity
		// method
		// unit
		// gross_nett
		// grp
		// s_grp
		// product
		// rid
		// packing_type
		// operator
		// datetime
		// a_operator
		// a_datetime
		// pp_qty
		// pp_bal
		// pp_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// warp_weft
			if (strval($this->warp_weft->CurrentValue) <> "") {
				$this->warp_weft->ViewValue = $this->warp_weft->optionCaption($this->warp_weft->CurrentValue);
			} else {
				$this->warp_weft->ViewValue = NULL;
			}
			$this->warp_weft->ViewCustomAttributes = "";

			// m_grp
			$curVal = strval($this->m_grp->CurrentValue);
			if ($curVal <> "") {
				$this->m_grp->ViewValue = $this->m_grp->lookupCacheOption($curVal);
				if ($this->m_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->m_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->m_grp->ViewValue = $this->m_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->m_grp->ViewValue = $this->m_grp->CurrentValue;
					}
				}
			} else {
				$this->m_grp->ViewValue = NULL;
			}
			$this->m_grp->ViewCustomAttributes = "";

			// m_sgrp
			if ($this->m_sgrp->VirtualValue <> "") {
				$this->m_sgrp->ViewValue = $this->m_sgrp->VirtualValue;
			} else {
			$curVal = strval($this->m_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->m_sgrp->ViewValue = $this->m_sgrp->lookupCacheOption($curVal);
				if ($this->m_sgrp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->m_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->m_sgrp->ViewValue = $this->m_sgrp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->m_sgrp->ViewValue = $this->m_sgrp->CurrentValue;
					}
				}
			} else {
				$this->m_sgrp->ViewValue = NULL;
			}
			}
			$this->m_sgrp->ViewCustomAttributes = "";

			// m_product
			if ($this->m_product->VirtualValue <> "") {
				$this->m_product->ViewValue = $this->m_product->VirtualValue;
			} else {
			$curVal = strval($this->m_product->CurrentValue);
			if ($curVal <> "") {
				$this->m_product->ViewValue = $this->m_product->lookupCacheOption($curVal);
				if ($this->m_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->m_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->m_product->ViewValue = $this->m_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->m_product->ViewValue = $this->m_product->CurrentValue;
					}
				}
			} else {
				$this->m_product->ViewValue = NULL;
			}
			}
			$this->m_product->ViewCustomAttributes = "";

			// m_rid
			if ($this->m_rid->VirtualValue <> "") {
				$this->m_rid->ViewValue = $this->m_rid->VirtualValue;
			} else {
				$this->m_rid->ViewValue = $this->m_rid->CurrentValue;
			$curVal = strval($this->m_rid->CurrentValue);
			if ($curVal <> "") {
				$this->m_rid->ViewValue = $this->m_rid->lookupCacheOption($curVal);
				if ($this->m_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->m_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->m_rid->ViewValue = $this->m_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->m_rid->ViewValue = $this->m_rid->CurrentValue;
					}
				}
			} else {
				$this->m_rid->ViewValue = NULL;
			}
			}
			$this->m_rid->ViewCustomAttributes = "";

			// m_packing
			$curVal = strval($this->m_packing->CurrentValue);
			if ($curVal <> "") {
				$this->m_packing->ViewValue = $this->m_packing->lookupCacheOption($curVal);
				if ($this->m_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->m_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->m_packing->ViewValue = $this->m_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->m_packing->ViewValue = $this->m_packing->CurrentValue;
					}
				}
			} else {
				$this->m_packing->ViewValue = NULL;
			}
			$this->m_packing->ViewCustomAttributes = "";

			// quantity_a
			$this->quantity_a->ViewValue = $this->quantity_a->CurrentValue;
			$this->quantity_a->ViewValue = FormatNumber($this->quantity_a->ViewValue, 3, -2, -2, -2);
			$this->quantity_a->ViewCustomAttributes = "";

			// bom_waste
			$this->bom_waste->ViewValue = $this->bom_waste->CurrentValue;
			$this->bom_waste->ViewValue = FormatNumber($this->bom_waste->ViewValue, 2, -2, -2, -2);
			$this->bom_waste->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewCustomAttributes = "";

			// method
			$curVal = strval($this->method->CurrentValue);
			if ($curVal <> "") {
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
				if ($this->method->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->method->ViewValue = $this->method->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->method->ViewValue = $this->method->CurrentValue;
					}
				}
			} else {
				$this->method->ViewValue = NULL;
			}
			$this->method->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// gross_nett
			if (strval($this->gross_nett->CurrentValue) <> "") {
				$this->gross_nett->ViewValue = $this->gross_nett->optionCaption($this->gross_nett->CurrentValue);
			} else {
				$this->gross_nett->ViewValue = NULL;
			}
			$this->gross_nett->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// warp_weft
			$this->warp_weft->LinkCustomAttributes = "";
			$this->warp_weft->HrefValue = "";
			$this->warp_weft->TooltipValue = "";

			// m_grp
			$this->m_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->m_grp->CurrentValue)) {
				$this->m_grp->HrefValue = "bomlist.php?x_m_grp=" . $this->m_grp->CurrentValue; // Add prefix/suffix
				$this->m_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
			} else {
				$this->m_grp->HrefValue = "";
			}
			$this->m_grp->TooltipValue = "";

			// m_sgrp
			$this->m_sgrp->LinkCustomAttributes = "";
			$this->m_sgrp->HrefValue = "";
			$this->m_sgrp->TooltipValue = "";

			// m_product
			$this->m_product->LinkCustomAttributes = "";
			$this->m_product->HrefValue = "";
			$this->m_product->TooltipValue = "";

			// m_rid
			$this->m_rid->LinkCustomAttributes = "";
			$this->m_rid->HrefValue = "";
			$this->m_rid->TooltipValue = "";

			// m_packing
			$this->m_packing->LinkCustomAttributes = "";
			$this->m_packing->HrefValue = "";
			$this->m_packing->TooltipValue = "";

			// quantity_a
			$this->quantity_a->LinkCustomAttributes = "";
			$this->quantity_a->HrefValue = "";
			$this->quantity_a->TooltipValue = "";

			// bom_waste
			$this->bom_waste->LinkCustomAttributes = "";
			$this->bom_waste->HrefValue = "";
			$this->bom_waste->TooltipValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";
			$this->method->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// gross_nett
			$this->gross_nett->LinkCustomAttributes = "";
			$this->gross_nett->HrefValue = "";
			$this->gross_nett->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			if ($this->batch_no->getSessionValue() <> "") {
				$this->batch_no->CurrentValue = $this->batch_no->getSessionValue();
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";
			} else {
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->EditValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->batch_no->EditValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
					}
				}
			} else {
				$this->batch_no->EditValue = NULL;
			}
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());
			}

			// warp_weft
			$this->warp_weft->EditAttrs["class"] = "form-control";
			$this->warp_weft->EditCustomAttributes = "";
			$this->warp_weft->EditValue = $this->warp_weft->options(TRUE);

			// m_grp
			$this->m_grp->EditAttrs["class"] = "form-control";
			$this->m_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->m_grp->CurrentValue));
			if ($curVal <> "")
				$this->m_grp->ViewValue = $this->m_grp->lookupCacheOption($curVal);
			else
				$this->m_grp->ViewValue = $this->m_grp->Lookup !== NULL && is_array($this->m_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->m_grp->ViewValue !== NULL) { // Load from cache
				$this->m_grp->EditValue = array_values($this->m_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->m_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->m_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->m_grp->EditValue = $arwrk;
			}

			// m_sgrp
			$this->m_sgrp->EditAttrs["class"] = "form-control";
			$this->m_sgrp->EditCustomAttributes = "";
			$curVal = trim(strval($this->m_sgrp->CurrentValue));
			if ($curVal <> "")
				$this->m_sgrp->ViewValue = $this->m_sgrp->lookupCacheOption($curVal);
			else
				$this->m_sgrp->ViewValue = $this->m_sgrp->Lookup !== NULL && is_array($this->m_sgrp->Lookup->Options) ? $curVal : NULL;
			if ($this->m_sgrp->ViewValue !== NULL) { // Load from cache
				$this->m_sgrp->EditValue = array_values($this->m_sgrp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->m_sgrp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->m_sgrp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->m_sgrp->EditValue = $arwrk;
			}

			// m_product
			$this->m_product->EditAttrs["class"] = "form-control";
			$this->m_product->EditCustomAttributes = "";
			$curVal = trim(strval($this->m_product->CurrentValue));
			if ($curVal <> "")
				$this->m_product->ViewValue = $this->m_product->lookupCacheOption($curVal);
			else
				$this->m_product->ViewValue = $this->m_product->Lookup !== NULL && is_array($this->m_product->Lookup->Options) ? $curVal : NULL;
			if ($this->m_product->ViewValue !== NULL) { // Load from cache
				$this->m_product->EditValue = array_values($this->m_product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->m_product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->m_product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->m_product->EditValue = $arwrk;
			}

			// m_rid
			$this->m_rid->EditAttrs["class"] = "form-control";
			$this->m_rid->EditCustomAttributes = "";
			$this->m_rid->EditValue = HtmlEncode($this->m_rid->CurrentValue);
			$curVal = strval($this->m_rid->CurrentValue);
			if ($curVal <> "") {
				$this->m_rid->EditValue = $this->m_rid->lookupCacheOption($curVal);
				if ($this->m_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->m_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->m_rid->EditValue = $this->m_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->m_rid->EditValue = HtmlEncode($this->m_rid->CurrentValue);
					}
				}
			} else {
				$this->m_rid->EditValue = NULL;
			}
			$this->m_rid->PlaceHolder = RemoveHtml($this->m_rid->caption());

			// m_packing
			$this->m_packing->EditAttrs["class"] = "form-control";
			$this->m_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->m_packing->CurrentValue));
			if ($curVal <> "")
				$this->m_packing->ViewValue = $this->m_packing->lookupCacheOption($curVal);
			else
				$this->m_packing->ViewValue = $this->m_packing->Lookup !== NULL && is_array($this->m_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->m_packing->ViewValue !== NULL) { // Load from cache
				$this->m_packing->EditValue = array_values($this->m_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->m_packing->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->m_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->m_packing->EditValue = $arwrk;
			}

			// quantity_a
			$this->quantity_a->EditAttrs["class"] = "form-control";
			$this->quantity_a->EditCustomAttributes = "";
			$this->quantity_a->EditValue = HtmlEncode($this->quantity_a->CurrentValue);
			$this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());
			if (strval($this->quantity_a->EditValue) <> "" && is_numeric($this->quantity_a->EditValue))
				$this->quantity_a->EditValue = FormatNumber($this->quantity_a->EditValue, -2, -2, -2, -2);

			// bom_waste
			$this->bom_waste->EditAttrs["class"] = "form-control";
			$this->bom_waste->EditCustomAttributes = "";
			$this->bom_waste->EditValue = HtmlEncode($this->bom_waste->CurrentValue);
			$this->bom_waste->PlaceHolder = RemoveHtml($this->bom_waste->caption());
			if (strval($this->bom_waste->EditValue) <> "" && is_numeric($this->bom_waste->EditValue))
				$this->bom_waste->EditValue = FormatNumber($this->bom_waste->EditValue, -2, -2, -2, -2);

			// method
			$this->method->EditAttrs["class"] = "form-control";
			$this->method->EditCustomAttributes = "";
			$curVal = trim(strval($this->method->CurrentValue));
			if ($curVal <> "")
				$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
			else
				$this->method->ViewValue = $this->method->Lookup !== NULL && is_array($this->method->Lookup->Options) ? $curVal : NULL;
			if ($this->method->ViewValue !== NULL) { // Load from cache
				$this->method->EditValue = array_values($this->method->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->method->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=21";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->method->EditValue = $arwrk;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = trim(strval($this->unit->CurrentValue));
			if ($curVal <> "")
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			else
				$this->unit->ViewValue = $this->unit->Lookup !== NULL && is_array($this->unit->Lookup->Options) ? $curVal : NULL;
			if ($this->unit->ViewValue !== NULL) { // Load from cache
				$this->unit->EditValue = array_values($this->unit->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->unit->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->unit->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->unit->EditValue = $arwrk;
			}

			// gross_nett
			$this->gross_nett->EditAttrs["class"] = "form-control";
			$this->gross_nett->EditCustomAttributes = "";
			$this->gross_nett->EditValue = $this->gross_nett->options(TRUE);

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->EditValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->EditValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->EditValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->EditValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->EditValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->EditValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->EditValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->EditValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->EditValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			if ($this->rid->VirtualValue <> "") {
				$this->rid->EditValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->EditValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->EditValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";

			// warp_weft
			$this->warp_weft->LinkCustomAttributes = "";
			$this->warp_weft->HrefValue = "";

			// m_grp
			$this->m_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->m_grp->CurrentValue)) {
				$this->m_grp->HrefValue = "bomlist.php?x_m_grp=" . $this->m_grp->CurrentValue; // Add prefix/suffix
				$this->m_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->m_grp->HrefValue = FullUrl($this->m_grp->HrefValue, "href");
			} else {
				$this->m_grp->HrefValue = "";
			}

			// m_sgrp
			$this->m_sgrp->LinkCustomAttributes = "";
			$this->m_sgrp->HrefValue = "";

			// m_product
			$this->m_product->LinkCustomAttributes = "";
			$this->m_product->HrefValue = "";

			// m_rid
			$this->m_rid->LinkCustomAttributes = "";
			$this->m_rid->HrefValue = "";

			// m_packing
			$this->m_packing->LinkCustomAttributes = "";
			$this->m_packing->HrefValue = "";

			// quantity_a
			$this->quantity_a->LinkCustomAttributes = "";
			$this->quantity_a->HrefValue = "";

			// bom_waste
			$this->bom_waste->LinkCustomAttributes = "";
			$this->bom_waste->HrefValue = "";

			// method
			$this->method->LinkCustomAttributes = "";
			$this->method->HrefValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";

			// gross_nett
			$this->gross_nett->LinkCustomAttributes = "";
			$this->gross_nett->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->batch_no->FormValue)) {
			AddMessage($FormError, $this->batch_no->errorMessage());
		}
		if ($this->warp_weft->Required) {
			if (!$this->warp_weft->IsDetailKey && $this->warp_weft->FormValue != NULL && $this->warp_weft->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->warp_weft->caption(), $this->warp_weft->RequiredErrorMessage));
			}
		}
		if ($this->m_grp->Required) {
			if (!$this->m_grp->IsDetailKey && $this->m_grp->FormValue != NULL && $this->m_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_grp->caption(), $this->m_grp->RequiredErrorMessage));
			}
		}
		if ($this->m_sgrp->Required) {
			if (!$this->m_sgrp->IsDetailKey && $this->m_sgrp->FormValue != NULL && $this->m_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_sgrp->caption(), $this->m_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->m_product->Required) {
			if (!$this->m_product->IsDetailKey && $this->m_product->FormValue != NULL && $this->m_product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_product->caption(), $this->m_product->RequiredErrorMessage));
			}
		}
		if ($this->m_rid->Required) {
			if (!$this->m_rid->IsDetailKey && $this->m_rid->FormValue != NULL && $this->m_rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_rid->caption(), $this->m_rid->RequiredErrorMessage));
			}
		}
		if ($this->m_packing->Required) {
			if (!$this->m_packing->IsDetailKey && $this->m_packing->FormValue != NULL && $this->m_packing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_packing->caption(), $this->m_packing->RequiredErrorMessage));
			}
		}
		if ($this->m_name->Required) {
			if (!$this->m_name->IsDetailKey && $this->m_name->FormValue != NULL && $this->m_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_name->caption(), $this->m_name->RequiredErrorMessage));
			}
		}
		if ($this->quantity_a->Required) {
			if (!$this->quantity_a->IsDetailKey && $this->quantity_a->FormValue != NULL && $this->quantity_a->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity_a->caption(), $this->quantity_a->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity_a->FormValue)) {
			AddMessage($FormError, $this->quantity_a->errorMessage());
		}
		if ($this->bom_waste->Required) {
			if (!$this->bom_waste->IsDetailKey && $this->bom_waste->FormValue != NULL && $this->bom_waste->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom_waste->caption(), $this->bom_waste->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->bom_waste->FormValue)) {
			AddMessage($FormError, $this->bom_waste->errorMessage());
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->method->Required) {
			if (!$this->method->IsDetailKey && $this->method->FormValue != NULL && $this->method->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->method->caption(), $this->method->RequiredErrorMessage));
			}
		}
		if ($this->unit->Required) {
			if (!$this->unit->IsDetailKey && $this->unit->FormValue != NULL && $this->unit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unit->caption(), $this->unit->RequiredErrorMessage));
			}
		}
		if ($this->gross_nett->Required) {
			if (!$this->gross_nett->IsDetailKey && $this->gross_nett->FormValue != NULL && $this->gross_nett->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gross_nett->caption(), $this->gross_nett->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->pp_qty->Required) {
			if (!$this->pp_qty->IsDetailKey && $this->pp_qty->FormValue != NULL && $this->pp_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_qty->caption(), $this->pp_qty->RequiredErrorMessage));
			}
		}
		if ($this->pp_bal->Required) {
			if (!$this->pp_bal->IsDetailKey && $this->pp_bal->FormValue != NULL && $this->pp_bal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_bal->caption(), $this->pp_bal->RequiredErrorMessage));
			}
		}
		if ($this->pp_id->Required) {
			if (!$this->pp_id->IsDetailKey && $this->pp_id->FormValue != NULL && $this->pp_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_id->caption(), $this->pp_id->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// batch_no
			$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, NULL, $this->batch_no->ReadOnly);

			// warp_weft
			$this->warp_weft->setDbValueDef($rsnew, $this->warp_weft->CurrentValue, 0, $this->warp_weft->ReadOnly);

			// m_grp
			$this->m_grp->setDbValueDef($rsnew, $this->m_grp->CurrentValue, 0, $this->m_grp->ReadOnly);

			// m_sgrp
			$this->m_sgrp->setDbValueDef($rsnew, $this->m_sgrp->CurrentValue, 0, $this->m_sgrp->ReadOnly);

			// m_product
			$this->m_product->setDbValueDef($rsnew, $this->m_product->CurrentValue, NULL, $this->m_product->ReadOnly);

			// m_rid
			$this->m_rid->setDbValueDef($rsnew, $this->m_rid->CurrentValue, NULL, $this->m_rid->ReadOnly);

			// m_packing
			$this->m_packing->setDbValueDef($rsnew, $this->m_packing->CurrentValue, NULL, $this->m_packing->ReadOnly);

			// quantity_a
			$this->quantity_a->setDbValueDef($rsnew, $this->quantity_a->CurrentValue, 0, $this->quantity_a->ReadOnly);

			// bom_waste
			$this->bom_waste->setDbValueDef($rsnew, $this->bom_waste->CurrentValue, 0, $this->bom_waste->ReadOnly);

			// method
			$this->method->setDbValueDef($rsnew, $this->method->CurrentValue, NULL, $this->method->ReadOnly);

			// unit
			$this->unit->setDbValueDef($rsnew, $this->unit->CurrentValue, NULL, $this->unit->ReadOnly);

			// gross_nett
			$this->gross_nett->setDbValueDef($rsnew, $this->gross_nett->CurrentValue, 0, $this->gross_nett->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "batch_no") {
				$validMaster = TRUE;
				if (Get("fk_id") !== NULL) {
					$this->batch_no->setQueryStringValue(Get("fk_id"));
					$this->batch_no->setSessionValue($this->batch_no->QueryStringValue);
					if (!is_numeric($this->batch_no->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "batch_no") {
				$validMaster = TRUE;
				if (Post("fk_id") !== NULL) {
					$this->batch_no->setFormValue(Post("fk_id"));
					$this->batch_no->setSessionValue($this->batch_no->FormValue);
					if (!is_numeric($this->batch_no->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);
			$this->setSessionWhere($this->getDetailFilter());

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "batch_no") {
				if ($this->batch_no->CurrentValue == "")
					$this->batch_no->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("bomlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_m_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_m_sgrp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_m_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_m_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_method":
					$lookupFilter = function() {
						return "`grp`=21";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_batch_no":
							break;
						case "x_m_grp":
							break;
						case "x_m_sgrp":
							break;
						case "x_m_product":
							break;
						case "x_m_rid":
							break;
						case "x_m_packing":
							break;
						case "x_method":
							break;
						case "x_unit":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_packing_type":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
			PageFieldValidate($this,'bom');
	$this->grp->ReadOnly=true;
	$this->s_grp->ReadOnly=true;
	$this->product->ReadOnly=true;
	$this->rid->ReadOnly=true;
	$this->packing_type->ReadOnly=true;
	$this->batch_no->ReadOnly=true;
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>