<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for bom_f
 */
class bom_f extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $batch_no;
	public $material_group;
	public $material;
	public $material_id;
	public $material_name;
	public $quantity;
	public $method;
	public $unit;
	public $operator;
	public $datetime;
	public $a_operator;
	public $a_datetime;
	public $quantity_a;
	public $bom_waste;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'bom_f';
		$this->TableName = 'bom_f';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`bom_f`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('bom_f', 'bom_f', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// grp
		$this->grp = new DbField('bom_f', 'bom_f', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->grp->OptionCount = 1;
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('bom_f', 'bom_f', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], [], ["x_product"], [], [], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('bom_f', 'bom_f', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->Lookup = new Lookup('product', 'product_f', TRUE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('bom_f', 'bom_f', 'x_rid', 'rid', '`rid`', '`rid`', 200, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref_f', FALSE, 'id', ["product_code","","",""], ["x_product"], ["x_batch_no"], ["product"], ["x_product"], [], [], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// batch_no
		$this->batch_no = new DbField('bom_f', 'bom_f', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 18, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// material_group
		$this->material_group = new DbField('bom_f', 'bom_f', 'x_material_group', 'material_group', '`material_group`', '`material_group`', 18, -1, FALSE, '`material_group`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->material_group->Nullable = FALSE; // NOT NULL field
		$this->material_group->Required = TRUE; // Required field
		$this->material_group->Sortable = TRUE; // Allow sort
		$this->material_group->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->material_group->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->material_group->Lookup = new Lookup('material_group', 'product_group', FALSE, 'id', ["product_group","","",""], [], ["x_material"], [], [], [], [], '`product_group` ASC', '');
		$this->material_group->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['material_group'] = &$this->material_group;

		// material
		$this->material = new DbField('bom_f', 'bom_f', 'x_material', 'material', '`material`', '`material`', 18, -1, FALSE, '`material`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->material->Required = TRUE; // Required field
		$this->material->Sortable = TRUE; // Allow sort
		$this->material->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->material->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->material->Lookup = new Lookup('material', 'product', TRUE, 'id', ["product","","",""], ["x_material_group"], ["x_material_id"], ["s_grp"], ["x_s_grp[]"], [], [], '`product` ASC', '');
		$this->material->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['material'] = &$this->material;

		// material_id
		$this->material_id = new DbField('bom_f', 'bom_f', 'x_material_id', 'material_id', '`material_id`', '`material_id`', 18, -1, FALSE, '`material_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->material_id->Sortable = TRUE; // Allow sort
		$this->material_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->material_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->material_id->Lookup = new Lookup('material_id', 'ref_f', FALSE, 'id', ["product_code","","",""], ["x_material"], [], ["product"], ["x_product"], ["product_code"], ["x_material_name"], '', '');
		$this->fields['material_id'] = &$this->material_id;

		// material_name
		$this->material_name = new DbField('bom_f', 'bom_f', 'x_material_name', 'material_name', '`material_name`', '`material_name`', 200, -1, FALSE, '`material_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material_name->Sortable = FALSE; // Allow sort
		$this->fields['material_name'] = &$this->material_name;

		// quantity
		$this->quantity = new DbField('bom_f', 'bom_f', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// method
		$this->method = new DbField('bom_f', 'bom_f', 'x_method', 'method', '`method`', '`method`', 18, -1, FALSE, '`method`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->method->Required = TRUE; // Required field
		$this->method->Sortable = TRUE; // Allow sort
		$this->method->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->method->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->method->Lookup = new Lookup('method', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->method->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['method'] = &$this->method;

		// unit
		$this->unit = new DbField('bom_f', 'bom_f', 'x_unit', 'unit', '`unit`', '`unit`', 18, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Required = TRUE; // Required field
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// operator
		$this->operator = new DbField('bom_f', 'bom_f', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('bom_f', 'bom_f', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// a_operator
		$this->a_operator = new DbField('bom_f', 'bom_f', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Nullable = FALSE; // NOT NULL field
		$this->a_operator->Required = TRUE; // Required field
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('bom_f', 'bom_f', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 0, "DB"), 135, -1, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Nullable = FALSE; // NOT NULL field
		$this->a_datetime->Required = TRUE; // Required field
		$this->a_datetime->Sortable = TRUE; // Allow sort
		$this->fields['a_datetime'] = &$this->a_datetime;

		// quantity_a
		$this->quantity_a = new DbField('bom_f', 'bom_f', 'x_quantity_a', 'quantity_a', '`quantity_a`', '`quantity_a`', 131, -1, FALSE, '`quantity_a`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity_a->Nullable = FALSE; // NOT NULL field
		$this->quantity_a->Required = TRUE; // Required field
		$this->quantity_a->Sortable = FALSE; // Allow sort
		$this->quantity_a->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity_a'] = &$this->quantity_a;

		// bom_waste
		$this->bom_waste = new DbField('bom_f', 'bom_f', 'x_bom_waste', 'bom_waste', '`bom_waste`', '`bom_waste`', 131, -1, FALSE, '`bom_waste`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bom_waste->Nullable = FALSE; // NOT NULL field
		$this->bom_waste->Required = TRUE; // Required field
		$this->bom_waste->Sortable = FALSE; // Allow sort
		$this->bom_waste->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['bom_waste'] = &$this->bom_waste;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`bom_f`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->material_group->DbValue = $row['material_group'];
		$this->material->DbValue = $row['material'];
		$this->material_id->DbValue = $row['material_id'];
		$this->material_name->DbValue = $row['material_name'];
		$this->quantity->DbValue = $row['quantity'];
		$this->method->DbValue = $row['method'];
		$this->unit->DbValue = $row['unit'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->quantity_a->DbValue = $row['quantity_a'];
		$this->bom_waste->DbValue = $row['bom_waste'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "bom_flist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "bom_fview.php")
			return $Language->phrase("View");
		elseif ($pageName == "bom_fedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "bom_fadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "bom_flist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("bom_fview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("bom_fview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "bom_fadd.php?" . $this->getUrlParm($parm);
		else
			$url = "bom_fadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("bom_fedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("bom_fadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("bom_fdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->material_group->setDbValue($rs->fields('material_group'));
		$this->material->setDbValue($rs->fields('material'));
		$this->material_id->setDbValue($rs->fields('material_id'));
		$this->material_name->setDbValue($rs->fields('material_name'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->method->setDbValue($rs->fields('method'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->quantity_a->setDbValue($rs->fields('quantity_a'));
		$this->bom_waste->setDbValue($rs->fields('bom_waste'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// grp
		// s_grp
		// product
		// rid
		// batch_no
		// material_group
		// material
		// material_id
		// material_name

		$this->material_name->CellCssStyle = "white-space: nowrap;";

		// quantity
		// method
		// unit
		// operator
		// datetime
		// a_operator
		// a_datetime
		// quantity_a

		$this->quantity_a->CellCssStyle = "white-space: nowrap;";

		// bom_waste
		$this->bom_waste->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		if (strval($this->grp->CurrentValue) <> "") {
			$this->grp->ViewValue = $this->grp->optionCaption($this->grp->CurrentValue);
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 AND `grp`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
		$this->batch_no->ViewCustomAttributes = "";

		// material_group
		$curVal = strval($this->material_group->CurrentValue);
		if ($curVal <> "") {
			$this->material_group->ViewValue = $this->material_group->lookupCacheOption($curVal);
			if ($this->material_group->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `grp`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->material_group->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->material_group->ViewValue = $this->material_group->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->material_group->ViewValue = $this->material_group->CurrentValue;
				}
			}
		} else {
			$this->material_group->ViewValue = NULL;
		}
		$this->material_group->ViewCustomAttributes = "";

		// material
		$curVal = strval($this->material->CurrentValue);
		if ($curVal <> "") {
			$this->material->ViewValue = $this->material->lookupCacheOption($curVal);
			if ($this->material->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->material->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->material->ViewValue = $this->material->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->material->ViewValue = $this->material->CurrentValue;
				}
			}
		} else {
			$this->material->ViewValue = NULL;
		}
		$this->material->ViewCustomAttributes = "";

		// material_id
		$curVal = strval($this->material_id->CurrentValue);
		if ($curVal <> "") {
			$this->material_id->ViewValue = $this->material_id->lookupCacheOption($curVal);
			if ($this->material_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->material_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->material_id->ViewValue = $this->material_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->material_id->ViewValue = $this->material_id->CurrentValue;
				}
			}
		} else {
			$this->material_id->ViewValue = NULL;
		}
		$this->material_id->ViewCustomAttributes = "";

		// material_name
		$this->material_name->ViewValue = $this->material_name->CurrentValue;
		$this->material_name->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewCustomAttributes = "";

		// method
		$curVal = strval($this->method->CurrentValue);
		if ($curVal <> "") {
			$this->method->ViewValue = $this->method->lookupCacheOption($curVal);
			if ($this->method->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=21 and id = 22";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->method->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->method->ViewValue = $this->method->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->method->ViewValue = $this->method->CurrentValue;
				}
			}
		} else {
			$this->method->ViewValue = NULL;
		}
		$this->method->ViewCustomAttributes = "";

		// unit
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->unit->ViewValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->ViewValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewCustomAttributes = "";

		// quantity_a
		$this->quantity_a->ViewValue = $this->quantity_a->CurrentValue;
		$this->quantity_a->ViewCustomAttributes = "";

		// bom_waste
		$this->bom_waste->ViewValue = $this->bom_waste->CurrentValue;
		$this->bom_waste->ViewValue = FormatNumber($this->bom_waste->ViewValue, 2, -2, -2, -2);
		$this->bom_waste->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		$this->batch_no->HrefValue = "";
		$this->batch_no->TooltipValue = "";

		// material_group
		$this->material_group->LinkCustomAttributes = "";
		$this->material_group->HrefValue = "";
		$this->material_group->TooltipValue = "";

		// material
		$this->material->LinkCustomAttributes = "";
		$this->material->HrefValue = "";
		$this->material->TooltipValue = "";

		// material_id
		$this->material_id->LinkCustomAttributes = "";
		$this->material_id->HrefValue = "";
		$this->material_id->TooltipValue = "";

		// material_name
		$this->material_name->LinkCustomAttributes = "";
		$this->material_name->HrefValue = "";
		$this->material_name->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// method
		$this->method->LinkCustomAttributes = "";
		$this->method->HrefValue = "";
		$this->method->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		$this->unit->HrefValue = "";
		$this->unit->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// quantity_a
		$this->quantity_a->LinkCustomAttributes = "";
		$this->quantity_a->HrefValue = "";
		$this->quantity_a->TooltipValue = "";

		// bom_waste
		$this->bom_waste->LinkCustomAttributes = "";
		$this->bom_waste->HrefValue = "";
		$this->bom_waste->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		if (strval($this->grp->CurrentValue) <> "") {
			$this->grp->EditValue = $this->grp->optionCaption($this->grp->CurrentValue);
		} else {
			$this->grp->EditValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 AND `grp`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->EditValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->EditValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rid->CurrentValue = HtmlDecode($this->rid->CurrentValue);
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";
		$this->batch_no->EditValue = $this->batch_no->CurrentValue;
		$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

		// material_group
		$this->material_group->EditAttrs["class"] = "form-control";
		$this->material_group->EditCustomAttributes = "";

		// material
		$this->material->EditAttrs["class"] = "form-control";
		$this->material->EditCustomAttributes = "";

		// material_id
		$this->material_id->EditAttrs["class"] = "form-control";
		$this->material_id->EditCustomAttributes = "";

		// material_name
		$this->material_name->EditAttrs["class"] = "form-control";
		$this->material_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->material_name->CurrentValue = HtmlDecode($this->material_name->CurrentValue);
		$this->material_name->EditValue = $this->material_name->CurrentValue;
		$this->material_name->PlaceHolder = RemoveHtml($this->material_name->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -1, -2, 0);

		// method
		$this->method->EditAttrs["class"] = "form-control";
		$this->method->EditCustomAttributes = "";

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";

		// operator
		// datetime
		// a_operator

		$this->a_operator->EditAttrs["class"] = "form-control";
		$this->a_operator->EditCustomAttributes = "";
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->EditValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->EditValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->EditValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->EditValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->EditAttrs["class"] = "form-control";
		$this->a_datetime->EditCustomAttributes = "";
		$this->a_datetime->EditValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewCustomAttributes = "";

		// quantity_a
		$this->quantity_a->EditAttrs["class"] = "form-control";
		$this->quantity_a->EditCustomAttributes = "";
		$this->quantity_a->EditValue = $this->quantity_a->CurrentValue;
		$this->quantity_a->PlaceHolder = RemoveHtml($this->quantity_a->caption());
		if (strval($this->quantity_a->EditValue) <> "" && is_numeric($this->quantity_a->EditValue))
			$this->quantity_a->EditValue = FormatNumber($this->quantity_a->EditValue, -2, -1, -2, 0);

		// bom_waste
		$this->bom_waste->EditAttrs["class"] = "form-control";
		$this->bom_waste->EditCustomAttributes = "";
		$this->bom_waste->EditValue = $this->bom_waste->CurrentValue;
		$this->bom_waste->PlaceHolder = RemoveHtml($this->bom_waste->caption());
		if (strval($this->bom_waste->EditValue) <> "" && is_numeric($this->bom_waste->EditValue))
			$this->bom_waste->EditValue = FormatNumber($this->bom_waste->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->material_group);
					$doc->exportCaption($this->material);
					$doc->exportCaption($this->material_id);
					$doc->exportCaption($this->material_name);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->material_group);
					$doc->exportCaption($this->material);
					$doc->exportCaption($this->material_id);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->method);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->material_group);
						$doc->exportField($this->material);
						$doc->exportField($this->material_id);
						$doc->exportField($this->material_name);
						$doc->exportField($this->quantity);
						$doc->exportField($this->method);
						$doc->exportField($this->unit);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->material_group);
						$doc->exportField($this->material);
						$doc->exportField($this->material_id);
						$doc->exportField($this->quantity);
						$doc->exportField($this->method);
						$doc->exportField($this->unit);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->grp, '');
				$doc->exportAggregate($this->s_grp, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->batch_no, '');
				$doc->exportAggregate($this->material_group, '');
				$doc->exportAggregate($this->material, '');
				$doc->exportAggregate($this->material_id, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->method, '');
				$doc->exportAggregate($this->unit, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->exportAggregate($this->a_operator, '');
				$doc->exportAggregate($this->a_datetime, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>