<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for booking_details
 */
class booking_details extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $ref;
	public $product_code;
	public $agent;
	public $supplier;
	public $quantity;
	public $b_quantity;
	public $confirm_quantity;
	public $containers;
	public $booking_currency;
	public $amount;
	public $paid;
	public $balance;
	public $remarks;
	public $status;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'booking_details';
		$this->TableName = 'booking_details';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`booking_details`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('booking_details', 'booking_details', 'x_id', 'id', '`id`', '`id`', 201, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->id->Sortable = TRUE; // Allow sort
		$this->fields['id'] = &$this->id;

		// ref
		$this->ref = new DbField('booking_details', 'booking_details', 'x_ref', 'ref', '`ref`', '`ref`', 200, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ref->Nullable = FALSE; // NOT NULL field
		$this->ref->Required = TRUE; // Required field
		$this->ref->Sortable = TRUE; // Allow sort
		$this->fields['ref'] = &$this->ref;

		// product_code
		$this->product_code = new DbField('booking_details', 'booking_details', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// agent
		$this->agent = new DbField('booking_details', 'booking_details', 'x_agent', 'agent', '`agent`', '`agent`', 17, -1, FALSE, '`agent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->agent->Sortable = TRUE; // Allow sort
		$this->agent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['agent'] = &$this->agent;

		// supplier
		$this->supplier = new DbField('booking_details', 'booking_details', 'x_supplier', 'supplier', '`supplier`', '`supplier`', 19, -1, FALSE, '`supplier`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->supplier->Sortable = TRUE; // Allow sort
		$this->supplier->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['supplier'] = &$this->supplier;

		// quantity
		$this->quantity = new DbField('booking_details', 'booking_details', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// b_quantity
		$this->b_quantity = new DbField('booking_details', 'booking_details', 'x_b_quantity', 'b_quantity', '`b_quantity`', '`b_quantity`', 131, -1, FALSE, '`b_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_quantity->Sortable = TRUE; // Allow sort
		$this->b_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b_quantity'] = &$this->b_quantity;

		// confirm_quantity
		$this->confirm_quantity = new DbField('booking_details', 'booking_details', 'x_confirm_quantity', 'confirm_quantity', '`confirm_quantity`', '`confirm_quantity`', 131, -1, FALSE, '`confirm_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->confirm_quantity->Nullable = FALSE; // NOT NULL field
		$this->confirm_quantity->Required = TRUE; // Required field
		$this->confirm_quantity->Sortable = TRUE; // Allow sort
		$this->confirm_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['confirm_quantity'] = &$this->confirm_quantity;

		// containers
		$this->containers = new DbField('booking_details', 'booking_details', 'x_containers', 'containers', '`containers`', '`containers`', 131, -1, FALSE, '`containers`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->containers->Sortable = TRUE; // Allow sort
		$this->containers->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['containers'] = &$this->containers;

		// booking_currency
		$this->booking_currency = new DbField('booking_details', 'booking_details', 'x_booking_currency', 'booking_currency', '`booking_currency`', '`booking_currency`', 17, -1, FALSE, '`booking_currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->booking_currency->Sortable = TRUE; // Allow sort
		$this->booking_currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['booking_currency'] = &$this->booking_currency;

		// amount
		$this->amount = new DbField('booking_details', 'booking_details', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// paid
		$this->paid = new DbField('booking_details', 'booking_details', 'x_paid', 'paid', '`paid`', '`paid`', 131, -1, FALSE, '`paid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->paid->Nullable = FALSE; // NOT NULL field
		$this->paid->Required = TRUE; // Required field
		$this->paid->Sortable = TRUE; // Allow sort
		$this->paid->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['paid'] = &$this->paid;

		// balance
		$this->balance = new DbField('booking_details', 'booking_details', 'x_balance', 'balance', '`balance`', '`balance`', 131, -1, FALSE, '`balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->balance->Sortable = TRUE; // Allow sort
		$this->balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['balance'] = &$this->balance;

		// remarks
		$this->remarks = new DbField('booking_details', 'booking_details', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// status
		$this->status = new DbField('booking_details', 'booking_details', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`booking_details`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->ref->DbValue = $row['ref'];
		$this->product_code->DbValue = $row['product_code'];
		$this->agent->DbValue = $row['agent'];
		$this->supplier->DbValue = $row['supplier'];
		$this->quantity->DbValue = $row['quantity'];
		$this->b_quantity->DbValue = $row['b_quantity'];
		$this->confirm_quantity->DbValue = $row['confirm_quantity'];
		$this->containers->DbValue = $row['containers'];
		$this->booking_currency->DbValue = $row['booking_currency'];
		$this->amount->DbValue = $row['amount'];
		$this->paid->DbValue = $row['paid'];
		$this->balance->DbValue = $row['balance'];
		$this->remarks->DbValue = $row['remarks'];
		$this->status->DbValue = $row['status'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "booking_detailslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "booking_detailsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "booking_detailsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "booking_detailsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "booking_detailslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("booking_detailsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("booking_detailsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "booking_detailsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "booking_detailsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("booking_detailsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("booking_detailsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("booking_detailsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->agent->setDbValue($rs->fields('agent'));
		$this->supplier->setDbValue($rs->fields('supplier'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->b_quantity->setDbValue($rs->fields('b_quantity'));
		$this->confirm_quantity->setDbValue($rs->fields('confirm_quantity'));
		$this->containers->setDbValue($rs->fields('containers'));
		$this->booking_currency->setDbValue($rs->fields('booking_currency'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->paid->setDbValue($rs->fields('paid'));
		$this->balance->setDbValue($rs->fields('balance'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->status->setDbValue($rs->fields('status'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// ref
		// product_code
		// agent
		// supplier
		// quantity
		// b_quantity
		// confirm_quantity
		// containers
		// booking_currency
		// amount
		// paid
		// balance
		// remarks
		// status
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// ref
		$this->ref->ViewValue = $this->ref->CurrentValue;
		$this->ref->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// agent
		$this->agent->ViewValue = $this->agent->CurrentValue;
		$this->agent->ViewValue = FormatNumber($this->agent->ViewValue, 0, -2, -2, -2);
		$this->agent->ViewCustomAttributes = "";

		// supplier
		$this->supplier->ViewValue = $this->supplier->CurrentValue;
		$this->supplier->ViewValue = FormatNumber($this->supplier->ViewValue, 0, -2, -2, -2);
		$this->supplier->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// b_quantity
		$this->b_quantity->ViewValue = $this->b_quantity->CurrentValue;
		$this->b_quantity->ViewValue = FormatNumber($this->b_quantity->ViewValue, 2, -2, -2, -2);
		$this->b_quantity->ViewCustomAttributes = "";

		// confirm_quantity
		$this->confirm_quantity->ViewValue = $this->confirm_quantity->CurrentValue;
		$this->confirm_quantity->ViewValue = FormatNumber($this->confirm_quantity->ViewValue, 2, -2, -2, -2);
		$this->confirm_quantity->ViewCustomAttributes = "";

		// containers
		$this->containers->ViewValue = $this->containers->CurrentValue;
		$this->containers->ViewValue = FormatNumber($this->containers->ViewValue, 2, -2, -2, -2);
		$this->containers->ViewCustomAttributes = "";

		// booking_currency
		$this->booking_currency->ViewValue = $this->booking_currency->CurrentValue;
		$this->booking_currency->ViewValue = FormatNumber($this->booking_currency->ViewValue, 0, -2, -2, -2);
		$this->booking_currency->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// paid
		$this->paid->ViewValue = $this->paid->CurrentValue;
		$this->paid->ViewValue = FormatNumber($this->paid->ViewValue, 2, -2, -2, -2);
		$this->paid->ViewCustomAttributes = "";

		// balance
		$this->balance->ViewValue = $this->balance->CurrentValue;
		$this->balance->ViewValue = FormatNumber($this->balance->ViewValue, 2, -2, -2, -2);
		$this->balance->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// agent
		$this->agent->LinkCustomAttributes = "";
		$this->agent->HrefValue = "";
		$this->agent->TooltipValue = "";

		// supplier
		$this->supplier->LinkCustomAttributes = "";
		$this->supplier->HrefValue = "";
		$this->supplier->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// b_quantity
		$this->b_quantity->LinkCustomAttributes = "";
		$this->b_quantity->HrefValue = "";
		$this->b_quantity->TooltipValue = "";

		// confirm_quantity
		$this->confirm_quantity->LinkCustomAttributes = "";
		$this->confirm_quantity->HrefValue = "";
		$this->confirm_quantity->TooltipValue = "";

		// containers
		$this->containers->LinkCustomAttributes = "";
		$this->containers->HrefValue = "";
		$this->containers->TooltipValue = "";

		// booking_currency
		$this->booking_currency->LinkCustomAttributes = "";
		$this->booking_currency->HrefValue = "";
		$this->booking_currency->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// paid
		$this->paid->LinkCustomAttributes = "";
		$this->paid->HrefValue = "";
		$this->paid->TooltipValue = "";

		// balance
		$this->balance->LinkCustomAttributes = "";
		$this->balance->HrefValue = "";
		$this->balance->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
		$this->ref->EditValue = $this->ref->CurrentValue;
		$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// agent
		$this->agent->EditAttrs["class"] = "form-control";
		$this->agent->EditCustomAttributes = "";
		$this->agent->EditValue = $this->agent->CurrentValue;
		$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

		// supplier
		$this->supplier->EditAttrs["class"] = "form-control";
		$this->supplier->EditCustomAttributes = "";
		$this->supplier->EditValue = $this->supplier->CurrentValue;
		$this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// b_quantity
		$this->b_quantity->EditAttrs["class"] = "form-control";
		$this->b_quantity->EditCustomAttributes = "";
		$this->b_quantity->EditValue = $this->b_quantity->CurrentValue;
		$this->b_quantity->PlaceHolder = RemoveHtml($this->b_quantity->caption());
		if (strval($this->b_quantity->EditValue) <> "" && is_numeric($this->b_quantity->EditValue))
			$this->b_quantity->EditValue = FormatNumber($this->b_quantity->EditValue, -2, -2, -2, -2);

		// confirm_quantity
		$this->confirm_quantity->EditAttrs["class"] = "form-control";
		$this->confirm_quantity->EditCustomAttributes = "";
		$this->confirm_quantity->EditValue = $this->confirm_quantity->CurrentValue;
		$this->confirm_quantity->PlaceHolder = RemoveHtml($this->confirm_quantity->caption());
		if (strval($this->confirm_quantity->EditValue) <> "" && is_numeric($this->confirm_quantity->EditValue))
			$this->confirm_quantity->EditValue = FormatNumber($this->confirm_quantity->EditValue, -2, -2, -2, -2);

		// containers
		$this->containers->EditAttrs["class"] = "form-control";
		$this->containers->EditCustomAttributes = "";
		$this->containers->EditValue = $this->containers->CurrentValue;
		$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
		if (strval($this->containers->EditValue) <> "" && is_numeric($this->containers->EditValue))
			$this->containers->EditValue = FormatNumber($this->containers->EditValue, -2, -2, -2, -2);

		// booking_currency
		$this->booking_currency->EditAttrs["class"] = "form-control";
		$this->booking_currency->EditCustomAttributes = "";
		$this->booking_currency->EditValue = $this->booking_currency->CurrentValue;
		$this->booking_currency->PlaceHolder = RemoveHtml($this->booking_currency->caption());

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// paid
		$this->paid->EditAttrs["class"] = "form-control";
		$this->paid->EditCustomAttributes = "";
		$this->paid->EditValue = $this->paid->CurrentValue;
		$this->paid->PlaceHolder = RemoveHtml($this->paid->caption());
		if (strval($this->paid->EditValue) <> "" && is_numeric($this->paid->EditValue))
			$this->paid->EditValue = FormatNumber($this->paid->EditValue, -2, -2, -2, -2);

		// balance
		$this->balance->EditAttrs["class"] = "form-control";
		$this->balance->EditCustomAttributes = "";
		$this->balance->EditValue = $this->balance->CurrentValue;
		$this->balance->PlaceHolder = RemoveHtml($this->balance->caption());
		if (strval($this->balance->EditValue) <> "" && is_numeric($this->balance->EditValue))
			$this->balance->EditValue = FormatNumber($this->balance->EditValue, -2, -2, -2, -2);

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->supplier);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->b_quantity);
					$doc->exportCaption($this->confirm_quantity);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->booking_currency);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->paid);
					$doc->exportCaption($this->balance);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->status);
				} else {
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->supplier);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->b_quantity);
					$doc->exportCaption($this->confirm_quantity);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->booking_currency);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->paid);
					$doc->exportCaption($this->balance);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->status);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->ref);
						$doc->exportField($this->product_code);
						$doc->exportField($this->agent);
						$doc->exportField($this->supplier);
						$doc->exportField($this->quantity);
						$doc->exportField($this->b_quantity);
						$doc->exportField($this->confirm_quantity);
						$doc->exportField($this->containers);
						$doc->exportField($this->booking_currency);
						$doc->exportField($this->amount);
						$doc->exportField($this->paid);
						$doc->exportField($this->balance);
						$doc->exportField($this->remarks);
						$doc->exportField($this->status);
					} else {
						$doc->exportField($this->ref);
						$doc->exportField($this->agent);
						$doc->exportField($this->supplier);
						$doc->exportField($this->quantity);
						$doc->exportField($this->b_quantity);
						$doc->exportField($this->confirm_quantity);
						$doc->exportField($this->containers);
						$doc->exportField($this->booking_currency);
						$doc->exportField($this->amount);
						$doc->exportField($this->paid);
						$doc->exportField($this->balance);
						$doc->exportField($this->remarks);
						$doc->exportField($this->status);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>