<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for booking_ref
 */
class booking_ref extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $ref;
	public $supplier_id;
	public $rid;
	public $quantity;
	public $b_quantity;
	public $containers;
	public $booking_date;
	public $booking_rate;
	public $booking_currency;
	public $currency_current_rate;
	public $shipment_date;
	public $our_port;
	public $operator;
	public $datetime;
	public $remarks;
	public $status;
	public $url;
	public $confirm_type;
	public $product_code;
	public $confirm_quantity;
	public $confirm_pending;
	public $amount;
	public $currency;
	public $confirm_port_eta;
	public $reference;
	public $packets;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'booking_ref';
		$this->TableName = 'booking_ref';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`booking_ref`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('booking_ref', 'booking_ref', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// ref
		$this->ref = new DbField('booking_ref', 'booking_ref', 'x_ref', 'ref', '`ref`', '`ref`', 200, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ref->Nullable = FALSE; // NOT NULL field
		$this->ref->Required = TRUE; // Required field
		$this->ref->Sortable = TRUE; // Allow sort
		$this->fields['ref'] = &$this->ref;

		// supplier_id
		$this->supplier_id = new DbField('booking_ref', 'booking_ref', 'x_supplier_id', 'supplier_id', '`supplier_id`', '`supplier_id`', 19, -1, FALSE, '`supplier_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->supplier_id->Sortable = FALSE; // Allow sort
		$this->supplier_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->supplier_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->supplier_id->Lookup = new Lookup('supplier_id', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->supplier_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['supplier_id'] = &$this->supplier_id;

		// rid
		$this->rid = new DbField('booking_ref', 'booking_ref', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'product_f', FALSE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// quantity
		$this->quantity = new DbField('booking_ref', 'booking_ref', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// b_quantity
		$this->b_quantity = new DbField('booking_ref', 'booking_ref', 'x_b_quantity', 'b_quantity', '`b_quantity`', '`b_quantity`', 131, -1, FALSE, '`b_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_quantity->Sortable = TRUE; // Allow sort
		$this->b_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['b_quantity'] = &$this->b_quantity;

		// containers
		$this->containers = new DbField('booking_ref', 'booking_ref', 'x_containers', 'containers', '`containers`', '`containers`', 131, -1, FALSE, '`containers`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->containers->Sortable = TRUE; // Allow sort
		$this->containers->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['containers'] = &$this->containers;

		// booking_date
		$this->booking_date = new DbField('booking_ref', 'booking_ref', 'x_booking_date', 'booking_date', '`booking_date`', CastDateFieldForLike('`booking_date`', 0, "DB"), 135, 0, FALSE, '`booking_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->booking_date->Sortable = TRUE; // Allow sort
		$this->booking_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['booking_date'] = &$this->booking_date;

		// booking_rate
		$this->booking_rate = new DbField('booking_ref', 'booking_ref', 'x_booking_rate', 'booking_rate', '`booking_rate`', '`booking_rate`', 131, -1, FALSE, '`booking_rate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->booking_rate->Sortable = TRUE; // Allow sort
		$this->booking_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['booking_rate'] = &$this->booking_rate;

		// booking_currency
		$this->booking_currency = new DbField('booking_ref', 'booking_ref', 'x_booking_currency', 'booking_currency', '`booking_currency`', '`booking_currency`', 17, -1, FALSE, '`booking_currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->booking_currency->Required = TRUE; // Required field
		$this->booking_currency->Sortable = TRUE; // Allow sort
		$this->booking_currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->booking_currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->booking_currency->Lookup = new Lookup('booking_currency', 'currency', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->booking_currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['booking_currency'] = &$this->booking_currency;

		// currency_current_rate
		$this->currency_current_rate = new DbField('booking_ref', 'booking_ref', 'x_currency_current_rate', 'currency_current_rate', '`currency_current_rate`', '`currency_current_rate`', 131, -1, FALSE, '`currency_current_rate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->currency_current_rate->Sortable = TRUE; // Allow sort
		$this->currency_current_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['currency_current_rate'] = &$this->currency_current_rate;

		// shipment_date
		$this->shipment_date = new DbField('booking_ref', 'booking_ref', 'x_shipment_date', 'shipment_date', '`shipment_date`', CastDateFieldForLike('`shipment_date`', 0, "DB"), 135, 0, FALSE, '`shipment_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipment_date->Sortable = TRUE; // Allow sort
		$this->shipment_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['shipment_date'] = &$this->shipment_date;

		// our_port
		$this->our_port = new DbField('booking_ref', 'booking_ref', 'x_our_port', 'our_port', '`our_port`', '`our_port`', 17, -1, FALSE, '`our_port`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->our_port->Sortable = TRUE; // Allow sort
		$this->our_port->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->our_port->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->our_port->Lookup = new Lookup('our_port', 'port', FALSE, 'id', ["port","code","",""], [], [], [], [], [], [], '`status` ASC', '');
		$this->our_port->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['our_port'] = &$this->our_port;

		// operator
		$this->operator = new DbField('booking_ref', 'booking_ref', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('booking_ref', 'booking_ref', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// remarks
		$this->remarks = new DbField('booking_ref', 'booking_ref', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// status
		$this->status = new DbField('booking_ref', 'booking_ref', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'booking_ref', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 5;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// url
		$this->url = new DbField('booking_ref', 'booking_ref', 'x_url', 'url', '`url`', '`url`', 200, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->Nullable = FALSE; // NOT NULL field
		$this->url->Required = TRUE; // Required field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;

		// confirm_type
		$this->confirm_type = new DbField('booking_ref', 'booking_ref', 'x_confirm_type', 'confirm_type', '`confirm_type`', '`confirm_type`', 200, -1, FALSE, '`confirm_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->confirm_type->Sortable = TRUE; // Allow sort
		$this->fields['confirm_type'] = &$this->confirm_type;

		// product_code
		$this->product_code = new DbField('booking_ref', 'booking_ref', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// confirm_quantity
		$this->confirm_quantity = new DbField('booking_ref', 'booking_ref', 'x_confirm_quantity', 'confirm_quantity', '`confirm_quantity`', '`confirm_quantity`', 131, -1, FALSE, '`confirm_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->confirm_quantity->Nullable = FALSE; // NOT NULL field
		$this->confirm_quantity->Sortable = TRUE; // Allow sort
		$this->confirm_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['confirm_quantity'] = &$this->confirm_quantity;

		// confirm_pending
		$this->confirm_pending = new DbField('booking_ref', 'booking_ref', 'x_confirm_pending', 'confirm_pending', '`confirm_pending`', '`confirm_pending`', 131, -1, FALSE, '`confirm_pending`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->confirm_pending->Sortable = TRUE; // Allow sort
		$this->confirm_pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['confirm_pending'] = &$this->confirm_pending;

		// amount
		$this->amount = new DbField('booking_ref', 'booking_ref', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// currency
		$this->currency = new DbField('booking_ref', 'booking_ref', 'x_currency', 'currency', '`currency`', '`currency`', 201, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->currency->Sortable = TRUE; // Allow sort
		$this->fields['currency'] = &$this->currency;

		// confirm_port_eta
		$this->confirm_port_eta = new DbField('booking_ref', 'booking_ref', 'x_confirm_port_eta', 'confirm_port_eta', '`confirm_port_eta`', '`confirm_port_eta`', 201, -1, FALSE, '`confirm_port_eta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->confirm_port_eta->Sortable = TRUE; // Allow sort
		$this->fields['confirm_port_eta'] = &$this->confirm_port_eta;

		// reference
		$this->reference = new DbField('booking_ref', 'booking_ref', 'x_reference', 'reference', '`reference`', '`reference`', 201, -1, FALSE, '`reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->reference->Sortable = TRUE; // Allow sort
		$this->fields['reference'] = &$this->reference;

		// packets
		$this->packets = new DbField('booking_ref', 'booking_ref', 'x_packets', 'packets', '`packets`', '`packets`', 2, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packets'] = &$this->packets;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`booking_ref`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`status` = 1";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->ref->DbValue = $row['ref'];
		$this->supplier_id->DbValue = $row['supplier_id'];
		$this->rid->DbValue = $row['rid'];
		$this->quantity->DbValue = $row['quantity'];
		$this->b_quantity->DbValue = $row['b_quantity'];
		$this->containers->DbValue = $row['containers'];
		$this->booking_date->DbValue = $row['booking_date'];
		$this->booking_rate->DbValue = $row['booking_rate'];
		$this->booking_currency->DbValue = $row['booking_currency'];
		$this->currency_current_rate->DbValue = $row['currency_current_rate'];
		$this->shipment_date->DbValue = $row['shipment_date'];
		$this->our_port->DbValue = $row['our_port'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->remarks->DbValue = $row['remarks'];
		$this->status->DbValue = $row['status'];
		$this->url->DbValue = $row['url'];
		$this->confirm_type->DbValue = $row['confirm_type'];
		$this->product_code->DbValue = $row['product_code'];
		$this->confirm_quantity->DbValue = $row['confirm_quantity'];
		$this->confirm_pending->DbValue = $row['confirm_pending'];
		$this->amount->DbValue = $row['amount'];
		$this->currency->DbValue = $row['currency'];
		$this->confirm_port_eta->DbValue = $row['confirm_port_eta'];
		$this->reference->DbValue = $row['reference'];
		$this->packets->DbValue = $row['packets'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "booking_reflist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "booking_refview.php")
			return $Language->phrase("View");
		elseif ($pageName == "booking_refedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "booking_refadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "booking_reflist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("booking_refview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("booking_refview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "booking_refadd.php?" . $this->getUrlParm($parm);
		else
			$url = "booking_refadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("booking_refedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("booking_refadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("booking_refdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->supplier_id->setDbValue($rs->fields('supplier_id'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->b_quantity->setDbValue($rs->fields('b_quantity'));
		$this->containers->setDbValue($rs->fields('containers'));
		$this->booking_date->setDbValue($rs->fields('booking_date'));
		$this->booking_rate->setDbValue($rs->fields('booking_rate'));
		$this->booking_currency->setDbValue($rs->fields('booking_currency'));
		$this->currency_current_rate->setDbValue($rs->fields('currency_current_rate'));
		$this->shipment_date->setDbValue($rs->fields('shipment_date'));
		$this->our_port->setDbValue($rs->fields('our_port'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->status->setDbValue($rs->fields('status'));
		$this->url->setDbValue($rs->fields('url'));
		$this->confirm_type->setDbValue($rs->fields('confirm_type'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->confirm_quantity->setDbValue($rs->fields('confirm_quantity'));
		$this->confirm_pending->setDbValue($rs->fields('confirm_pending'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->confirm_port_eta->setDbValue($rs->fields('confirm_port_eta'));
		$this->reference->setDbValue($rs->fields('reference'));
		$this->packets->setDbValue($rs->fields('packets'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// ref
		// supplier_id

		$this->supplier_id->CellCssStyle = "white-space: nowrap;";

		// rid
		// quantity
		// b_quantity
		// containers
		// booking_date
		// booking_rate
		// booking_currency
		// currency_current_rate
		// shipment_date
		// our_port
		// operator
		// datetime
		// remarks
		// status
		// url

		$this->url->CellCssStyle = "white-space: nowrap;";

		// confirm_type
		// product_code
		// confirm_quantity
		// confirm_pending
		// amount
		// currency
		// confirm_port_eta
		// reference
		// packets
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// ref
		$this->ref->ViewValue = $this->ref->CurrentValue;
		$this->ref->ViewCustomAttributes = "";

		// supplier_id
		$curVal = strval($this->supplier_id->CurrentValue);
		if ($curVal <> "") {
			$this->supplier_id->ViewValue = $this->supplier_id->lookupCacheOption($curVal);
			if ($this->supplier_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1 and `category` = 200";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->supplier_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->supplier_id->ViewValue = $this->supplier_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->supplier_id->ViewValue = $this->supplier_id->CurrentValue;
				}
			}
		} else {
			$this->supplier_id->ViewValue = NULL;
		}
		$this->supplier_id->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id`>1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewCustomAttributes = "";

		// b_quantity
		$this->b_quantity->ViewValue = $this->b_quantity->CurrentValue;
		$this->b_quantity->CssClass = "font-weight-bold";
		$this->b_quantity->ViewCustomAttributes = "";

		// containers
		$this->containers->ViewValue = $this->containers->CurrentValue;
		$this->containers->ViewCustomAttributes = "";

		// booking_date
		$this->booking_date->ViewValue = $this->booking_date->CurrentValue;
		$this->booking_date->ViewValue = FormatDateTime($this->booking_date->ViewValue, 0);
		$this->booking_date->ViewCustomAttributes = "";

		// booking_rate
		$this->booking_rate->ViewValue = $this->booking_rate->CurrentValue;
		$this->booking_rate->ViewCustomAttributes = "";

		// booking_currency
		$curVal = strval($this->booking_currency->CurrentValue);
		if ($curVal <> "") {
			$this->booking_currency->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
			if ($this->booking_currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->booking_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->booking_currency->ViewValue = $this->booking_currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->booking_currency->ViewValue = $this->booking_currency->CurrentValue;
				}
			}
		} else {
			$this->booking_currency->ViewValue = NULL;
		}
		$this->booking_currency->ViewCustomAttributes = "";

		// currency_current_rate
		$this->currency_current_rate->ViewValue = $this->currency_current_rate->CurrentValue;
		$this->currency_current_rate->ViewCustomAttributes = "";

		// shipment_date
		$this->shipment_date->ViewValue = $this->shipment_date->CurrentValue;
		$this->shipment_date->ViewValue = FormatDateTime($this->shipment_date->ViewValue, 0);
		$this->shipment_date->ViewCustomAttributes = "";

		// our_port
		$curVal = strval($this->our_port->CurrentValue);
		if ($curVal <> "") {
			$this->our_port->ViewValue = $this->our_port->lookupCacheOption($curVal);
			if ($this->our_port->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->our_port->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->our_port->ViewValue = $this->our_port->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->our_port->ViewValue = $this->our_port->CurrentValue;
				}
			}
		} else {
			$this->our_port->ViewValue = NULL;
		}
		$this->our_port->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// confirm_type
		$this->confirm_type->ViewValue = $this->confirm_type->CurrentValue;
		$this->confirm_type->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// confirm_quantity
		$this->confirm_quantity->ViewValue = $this->confirm_quantity->CurrentValue;
		$this->confirm_quantity->ViewValue = FormatNumber($this->confirm_quantity->ViewValue, 2, -2, -2, -2);
		$this->confirm_quantity->ViewCustomAttributes = "";

		// confirm_pending
		$this->confirm_pending->ViewValue = $this->confirm_pending->CurrentValue;
		$this->confirm_pending->ViewValue = FormatNumber($this->confirm_pending->ViewValue, 2, -2, -2, -2);
		$this->confirm_pending->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// currency
		$this->currency->ViewValue = $this->currency->CurrentValue;
		$this->currency->ViewCustomAttributes = "";

		// confirm_port_eta
		$this->confirm_port_eta->ViewValue = $this->confirm_port_eta->CurrentValue;
		$this->confirm_port_eta->ViewCustomAttributes = "";

		// reference
		$this->reference->ViewValue = $this->reference->CurrentValue;
		$this->reference->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
		$this->packets->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// supplier_id
		$this->supplier_id->LinkCustomAttributes = "";
		$this->supplier_id->HrefValue = "";
		$this->supplier_id->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "booking_reflist.php?x_product=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// b_quantity
		$this->b_quantity->LinkCustomAttributes = "";
		$this->b_quantity->HrefValue = "";
		$this->b_quantity->TooltipValue = "";

		// containers
		$this->containers->LinkCustomAttributes = "";
		$this->containers->HrefValue = "";
		$this->containers->TooltipValue = "";

		// booking_date
		$this->booking_date->LinkCustomAttributes = "";
		if (!EmptyValue($this->booking_date->CurrentValue)) {
			$this->booking_date->HrefValue = "booking_reflist.php?x_booking_date=" . $this->booking_date->CurrentValue; // Add prefix/suffix
			$this->booking_date->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->booking_date->HrefValue = FullUrl($this->booking_date->HrefValue, "href");
		} else {
			$this->booking_date->HrefValue = "";
		}
		$this->booking_date->TooltipValue = "";

		// booking_rate
		$this->booking_rate->LinkCustomAttributes = "";
		$this->booking_rate->HrefValue = "";
		$this->booking_rate->TooltipValue = "";

		// booking_currency
		$this->booking_currency->LinkCustomAttributes = "";
		$this->booking_currency->HrefValue = "";
		$this->booking_currency->TooltipValue = "";

		// currency_current_rate
		$this->currency_current_rate->LinkCustomAttributes = "";
		$this->currency_current_rate->HrefValue = "";
		$this->currency_current_rate->TooltipValue = "";

		// shipment_date
		$this->shipment_date->LinkCustomAttributes = "";
		if (!EmptyValue($this->shipment_date->CurrentValue)) {
			$this->shipment_date->HrefValue = "booking_reflist.php?x_shipment_date=" . $this->shipment_date->CurrentValue; // Add prefix/suffix
			$this->shipment_date->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->shipment_date->HrefValue = FullUrl($this->shipment_date->HrefValue, "href");
		} else {
			$this->shipment_date->HrefValue = "";
		}
		$this->shipment_date->TooltipValue = "";

		// our_port
		$this->our_port->LinkCustomAttributes = "";
		$this->our_port->HrefValue = "";
		$this->our_port->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// confirm_type
		$this->confirm_type->LinkCustomAttributes = "";
		$this->confirm_type->HrefValue = "";
		$this->confirm_type->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// confirm_quantity
		$this->confirm_quantity->LinkCustomAttributes = "";
		$this->confirm_quantity->HrefValue = "";
		$this->confirm_quantity->TooltipValue = "";

		// confirm_pending
		$this->confirm_pending->LinkCustomAttributes = "";
		$this->confirm_pending->HrefValue = "";
		$this->confirm_pending->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// confirm_port_eta
		$this->confirm_port_eta->LinkCustomAttributes = "";
		$this->confirm_port_eta->HrefValue = "";
		$this->confirm_port_eta->TooltipValue = "";

		// reference
		$this->reference->LinkCustomAttributes = "";
		$this->reference->HrefValue = "";
		$this->reference->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
		$this->ref->EditValue = $this->ref->CurrentValue;
		$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

		// supplier_id
		$this->supplier_id->EditAttrs["class"] = "form-control";
		$this->supplier_id->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -1, -2, 0);

		// b_quantity
		$this->b_quantity->EditAttrs["class"] = "form-control";
		$this->b_quantity->EditCustomAttributes = "";
		$this->b_quantity->EditValue = $this->b_quantity->CurrentValue;
		$this->b_quantity->PlaceHolder = RemoveHtml($this->b_quantity->caption());
		if (strval($this->b_quantity->EditValue) <> "" && is_numeric($this->b_quantity->EditValue))
			$this->b_quantity->EditValue = FormatNumber($this->b_quantity->EditValue, -2, -1, -2, 0);

		// containers
		$this->containers->EditAttrs["class"] = "form-control";
		$this->containers->EditCustomAttributes = "";
		$this->containers->EditValue = $this->containers->CurrentValue;
		$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
		if (strval($this->containers->EditValue) <> "" && is_numeric($this->containers->EditValue))
			$this->containers->EditValue = FormatNumber($this->containers->EditValue, -2, -1, -2, 0);

		// booking_date
		$this->booking_date->EditAttrs["class"] = "form-control";
		$this->booking_date->EditCustomAttributes = "";
		$this->booking_date->EditValue = FormatDateTime($this->booking_date->CurrentValue, 8);
		$this->booking_date->PlaceHolder = RemoveHtml($this->booking_date->caption());

		// booking_rate
		$this->booking_rate->EditAttrs["class"] = "form-control";
		$this->booking_rate->EditCustomAttributes = "";
		$this->booking_rate->EditValue = $this->booking_rate->CurrentValue;
		$this->booking_rate->PlaceHolder = RemoveHtml($this->booking_rate->caption());
		if (strval($this->booking_rate->EditValue) <> "" && is_numeric($this->booking_rate->EditValue))
			$this->booking_rate->EditValue = FormatNumber($this->booking_rate->EditValue, -2, -1, -2, 0);

		// booking_currency
		$this->booking_currency->EditAttrs["class"] = "form-control";
		$this->booking_currency->EditCustomAttributes = "";

		// currency_current_rate
		$this->currency_current_rate->EditAttrs["class"] = "form-control";
		$this->currency_current_rate->EditCustomAttributes = "";
		$this->currency_current_rate->EditValue = $this->currency_current_rate->CurrentValue;
		$this->currency_current_rate->PlaceHolder = RemoveHtml($this->currency_current_rate->caption());
		if (strval($this->currency_current_rate->EditValue) <> "" && is_numeric($this->currency_current_rate->EditValue))
			$this->currency_current_rate->EditValue = FormatNumber($this->currency_current_rate->EditValue, -2, -1, -2, 0);

		// shipment_date
		$this->shipment_date->EditAttrs["class"] = "form-control";
		$this->shipment_date->EditCustomAttributes = "";
		$this->shipment_date->EditValue = FormatDateTime($this->shipment_date->CurrentValue, 8);
		$this->shipment_date->PlaceHolder = RemoveHtml($this->shipment_date->caption());

		// our_port
		$this->our_port->EditAttrs["class"] = "form-control";
		$this->our_port->EditCustomAttributes = "";

		// operator
		// datetime
		// remarks

		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// confirm_type
		$this->confirm_type->EditAttrs["class"] = "form-control";
		$this->confirm_type->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->confirm_type->CurrentValue = HtmlDecode($this->confirm_type->CurrentValue);
		$this->confirm_type->EditValue = $this->confirm_type->CurrentValue;
		$this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// confirm_quantity
		$this->confirm_quantity->EditAttrs["class"] = "form-control";
		$this->confirm_quantity->EditCustomAttributes = "";
		$this->confirm_quantity->EditValue = $this->confirm_quantity->CurrentValue;
		$this->confirm_quantity->PlaceHolder = RemoveHtml($this->confirm_quantity->caption());
		if (strval($this->confirm_quantity->EditValue) <> "" && is_numeric($this->confirm_quantity->EditValue))
			$this->confirm_quantity->EditValue = FormatNumber($this->confirm_quantity->EditValue, -2, -2, -2, -2);

		// confirm_pending
		$this->confirm_pending->EditAttrs["class"] = "form-control";
		$this->confirm_pending->EditCustomAttributes = "";
		$this->confirm_pending->EditValue = $this->confirm_pending->CurrentValue;
		$this->confirm_pending->PlaceHolder = RemoveHtml($this->confirm_pending->caption());
		if (strval($this->confirm_pending->EditValue) <> "" && is_numeric($this->confirm_pending->EditValue))
			$this->confirm_pending->EditValue = FormatNumber($this->confirm_pending->EditValue, -2, -2, -2, -2);

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";
		$this->currency->EditValue = $this->currency->CurrentValue;
		$this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

		// confirm_port_eta
		$this->confirm_port_eta->EditAttrs["class"] = "form-control";
		$this->confirm_port_eta->EditCustomAttributes = "";
		$this->confirm_port_eta->EditValue = $this->confirm_port_eta->CurrentValue;
		$this->confirm_port_eta->PlaceHolder = RemoveHtml($this->confirm_port_eta->caption());

		// reference
		$this->reference->EditAttrs["class"] = "form-control";
		$this->reference->EditCustomAttributes = "";
		$this->reference->EditValue = $this->reference->CurrentValue;
		$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->b_quantity);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->booking_date);
					$doc->exportCaption($this->booking_rate);
					$doc->exportCaption($this->booking_currency);
					$doc->exportCaption($this->currency_current_rate);
					$doc->exportCaption($this->shipment_date);
					$doc->exportCaption($this->our_port);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->confirm_type);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->confirm_quantity);
					$doc->exportCaption($this->confirm_pending);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->confirm_port_eta);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->packets);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->b_quantity);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->booking_date);
					$doc->exportCaption($this->booking_rate);
					$doc->exportCaption($this->booking_currency);
					$doc->exportCaption($this->currency_current_rate);
					$doc->exportCaption($this->shipment_date);
					$doc->exportCaption($this->our_port);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->confirm_type);
					$doc->exportCaption($this->confirm_quantity);
					$doc->exportCaption($this->confirm_pending);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->packets);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->ref);
						$doc->exportField($this->rid);
						$doc->exportField($this->quantity);
						$doc->exportField($this->b_quantity);
						$doc->exportField($this->containers);
						$doc->exportField($this->booking_date);
						$doc->exportField($this->booking_rate);
						$doc->exportField($this->booking_currency);
						$doc->exportField($this->currency_current_rate);
						$doc->exportField($this->shipment_date);
						$doc->exportField($this->our_port);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->remarks);
						$doc->exportField($this->status);
						$doc->exportField($this->url);
						$doc->exportField($this->confirm_type);
						$doc->exportField($this->product_code);
						$doc->exportField($this->confirm_quantity);
						$doc->exportField($this->confirm_pending);
						$doc->exportField($this->amount);
						$doc->exportField($this->currency);
						$doc->exportField($this->confirm_port_eta);
						$doc->exportField($this->reference);
						$doc->exportField($this->packets);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->ref);
						$doc->exportField($this->rid);
						$doc->exportField($this->quantity);
						$doc->exportField($this->b_quantity);
						$doc->exportField($this->containers);
						$doc->exportField($this->booking_date);
						$doc->exportField($this->booking_rate);
						$doc->exportField($this->booking_currency);
						$doc->exportField($this->currency_current_rate);
						$doc->exportField($this->shipment_date);
						$doc->exportField($this->our_port);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->remarks);
						$doc->exportField($this->status);
						$doc->exportField($this->confirm_type);
						$doc->exportField($this->confirm_quantity);
						$doc->exportField($this->confirm_pending);
						$doc->exportField($this->amount);
						$doc->exportField($this->packets);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>