<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class booking_ref_search extends booking_ref
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'booking_ref';

	// Page object name
	public $PageObjName = "booking_ref_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (booking_ref)
		if (!isset($GLOBALS["booking_ref"]) || get_class($GLOBALS["booking_ref"]) == PROJECT_NAMESPACE . "booking_ref") {
			$GLOBALS["booking_ref"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["booking_ref"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'booking_ref');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $booking_ref;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($booking_ref);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "booking_refview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("booking_reflist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->ref->setVisibility();
		$this->supplier_id->Visible = FALSE;
		$this->rid->setVisibility();
		$this->quantity->Visible = FALSE;
		$this->b_quantity->setVisibility();
		$this->containers->Visible = FALSE;
		$this->booking_date->setVisibility();
		$this->booking_rate->setVisibility();
		$this->booking_currency->setVisibility();
		$this->currency_current_rate->setVisibility();
		$this->shipment_date->setVisibility();
		$this->our_port->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->remarks->setVisibility();
		$this->status->setVisibility();
		$this->url->Visible = FALSE;
		$this->confirm_type->setVisibility();
		$this->product_code->setVisibility();
		$this->confirm_quantity->setVisibility();
		$this->confirm_pending->setVisibility();
		$this->amount->setVisibility();
		$this->currency->setVisibility();
		$this->confirm_port_eta->setVisibility();
		$this->reference->setVisibility();
		$this->packets->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->supplier_id);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->booking_currency);
		$this->setupLookupOptions($this->our_port);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "booking_reflist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->ref); // ref
		$this->buildSearchUrl($srchUrl, $this->rid); // rid
		$this->buildSearchUrl($srchUrl, $this->b_quantity); // b_quantity
		$this->buildSearchUrl($srchUrl, $this->booking_date); // booking_date
		$this->buildSearchUrl($srchUrl, $this->booking_rate); // booking_rate
		$this->buildSearchUrl($srchUrl, $this->booking_currency); // booking_currency
		$this->buildSearchUrl($srchUrl, $this->currency_current_rate); // currency_current_rate
		$this->buildSearchUrl($srchUrl, $this->shipment_date); // shipment_date
		$this->buildSearchUrl($srchUrl, $this->our_port); // our_port
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->confirm_type); // confirm_type
		$this->buildSearchUrl($srchUrl, $this->product_code); // product_code
		$this->buildSearchUrl($srchUrl, $this->confirm_quantity); // confirm_quantity
		$this->buildSearchUrl($srchUrl, $this->confirm_pending); // confirm_pending
		$this->buildSearchUrl($srchUrl, $this->amount); // amount
		$this->buildSearchUrl($srchUrl, $this->currency); // currency
		$this->buildSearchUrl($srchUrl, $this->confirm_port_eta); // confirm_port_eta
		$this->buildSearchUrl($srchUrl, $this->reference); // reference
		$this->buildSearchUrl($srchUrl, $this->packets); // packets
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// ref
		if (!$this->isAddOrEdit())
			$this->ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ref"));
		$this->ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ref"));

		// rid
		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rid"));
		$this->rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rid"));

		// b_quantity
		if (!$this->isAddOrEdit())
			$this->b_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_quantity"));
		$this->b_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_quantity"));

		// booking_date
		if (!$this->isAddOrEdit())
			$this->booking_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_booking_date"));
		$this->booking_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_booking_date"));
		$this->booking_date->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_booking_date"));
		$this->booking_date->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_booking_date"));
		$this->booking_date->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_booking_date"));

		// booking_rate
		if (!$this->isAddOrEdit())
			$this->booking_rate->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_booking_rate"));
		$this->booking_rate->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_booking_rate"));
		$this->booking_rate->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_booking_rate"));
		$this->booking_rate->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_booking_rate"));
		$this->booking_rate->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_booking_rate"));

		// booking_currency
		if (!$this->isAddOrEdit())
			$this->booking_currency->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_booking_currency"));
		$this->booking_currency->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_booking_currency"));

		// currency_current_rate
		if (!$this->isAddOrEdit())
			$this->currency_current_rate->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_currency_current_rate"));
		$this->currency_current_rate->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_currency_current_rate"));
		$this->currency_current_rate->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_currency_current_rate"));
		$this->currency_current_rate->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_currency_current_rate"));
		$this->currency_current_rate->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_currency_current_rate"));

		// shipment_date
		if (!$this->isAddOrEdit())
			$this->shipment_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shipment_date"));
		$this->shipment_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shipment_date"));
		$this->shipment_date->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_shipment_date"));
		$this->shipment_date->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_shipment_date"));
		$this->shipment_date->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_shipment_date"));

		// our_port
		if (!$this->isAddOrEdit())
			$this->our_port->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_our_port"));
		$this->our_port->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_our_port"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// confirm_type
		if (!$this->isAddOrEdit())
			$this->confirm_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_confirm_type"));
		$this->confirm_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_confirm_type"));

		// product_code
		if (!$this->isAddOrEdit())
			$this->product_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_code"));
		$this->product_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_code"));

		// confirm_quantity
		if (!$this->isAddOrEdit())
			$this->confirm_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_confirm_quantity"));
		$this->confirm_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_confirm_quantity"));

		// confirm_pending
		if (!$this->isAddOrEdit())
			$this->confirm_pending->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_confirm_pending"));
		$this->confirm_pending->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_confirm_pending"));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_amount"));
		$this->amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_amount"));

		// currency
		if (!$this->isAddOrEdit())
			$this->currency->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_currency"));
		$this->currency->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_currency"));

		// confirm_port_eta
		if (!$this->isAddOrEdit())
			$this->confirm_port_eta->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_confirm_port_eta"));
		$this->confirm_port_eta->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_confirm_port_eta"));

		// reference
		if (!$this->isAddOrEdit())
			$this->reference->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_reference"));
		$this->reference->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_reference"));

		// packets
		if (!$this->isAddOrEdit())
			$this->packets->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packets"));
		$this->packets->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packets"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->b_quantity->FormValue == $this->b_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->b_quantity->CurrentValue)))
			$this->b_quantity->CurrentValue = ConvertToFloatString($this->b_quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->booking_rate->FormValue == $this->booking_rate->CurrentValue && is_numeric(ConvertToFloatString($this->booking_rate->CurrentValue)))
			$this->booking_rate->CurrentValue = ConvertToFloatString($this->booking_rate->CurrentValue);

		// Convert decimal values if posted back
		if ($this->currency_current_rate->FormValue == $this->currency_current_rate->CurrentValue && is_numeric(ConvertToFloatString($this->currency_current_rate->CurrentValue)))
			$this->currency_current_rate->CurrentValue = ConvertToFloatString($this->currency_current_rate->CurrentValue);

		// Convert decimal values if posted back
		if ($this->confirm_quantity->FormValue == $this->confirm_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->confirm_quantity->CurrentValue)))
			$this->confirm_quantity->CurrentValue = ConvertToFloatString($this->confirm_quantity->CurrentValue);

		// Convert decimal values if posted back
		if ($this->confirm_pending->FormValue == $this->confirm_pending->CurrentValue && is_numeric(ConvertToFloatString($this->confirm_pending->CurrentValue)))
			$this->confirm_pending->CurrentValue = ConvertToFloatString($this->confirm_pending->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// ref
		// supplier_id
		// rid
		// quantity
		// b_quantity
		// containers
		// booking_date
		// booking_rate
		// booking_currency
		// currency_current_rate
		// shipment_date
		// our_port
		// operator
		// datetime
		// remarks
		// status
		// url
		// confirm_type
		// product_code
		// confirm_quantity
		// confirm_pending
		// amount
		// currency
		// confirm_port_eta
		// reference
		// packets

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// ref
			$this->ref->ViewValue = $this->ref->CurrentValue;
			$this->ref->ViewCustomAttributes = "";

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewCustomAttributes = "";

			// b_quantity
			$this->b_quantity->ViewValue = $this->b_quantity->CurrentValue;
			$this->b_quantity->CssClass = "font-weight-bold";
			$this->b_quantity->ViewCustomAttributes = "";

			// containers
			$this->containers->ViewValue = $this->containers->CurrentValue;
			$this->containers->ViewCustomAttributes = "";

			// booking_date
			$this->booking_date->ViewValue = $this->booking_date->CurrentValue;
			$this->booking_date->ViewValue = FormatDateTime($this->booking_date->ViewValue, 0);
			$this->booking_date->ViewCustomAttributes = "";

			// booking_rate
			$this->booking_rate->ViewValue = $this->booking_rate->CurrentValue;
			$this->booking_rate->ViewCustomAttributes = "";

			// booking_currency
			$curVal = strval($this->booking_currency->CurrentValue);
			if ($curVal <> "") {
				$this->booking_currency->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
				if ($this->booking_currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->booking_currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->booking_currency->ViewValue = $this->booking_currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->booking_currency->ViewValue = $this->booking_currency->CurrentValue;
					}
				}
			} else {
				$this->booking_currency->ViewValue = NULL;
			}
			$this->booking_currency->ViewCustomAttributes = "";

			// currency_current_rate
			$this->currency_current_rate->ViewValue = $this->currency_current_rate->CurrentValue;
			$this->currency_current_rate->ViewCustomAttributes = "";

			// shipment_date
			$this->shipment_date->ViewValue = $this->shipment_date->CurrentValue;
			$this->shipment_date->ViewValue = FormatDateTime($this->shipment_date->ViewValue, 0);
			$this->shipment_date->ViewCustomAttributes = "";

			// our_port
			$curVal = strval($this->our_port->CurrentValue);
			if ($curVal <> "") {
				$this->our_port->ViewValue = $this->our_port->lookupCacheOption($curVal);
				if ($this->our_port->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->our_port->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->our_port->ViewValue = $this->our_port->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->our_port->ViewValue = $this->our_port->CurrentValue;
					}
				}
			} else {
				$this->our_port->ViewValue = NULL;
			}
			$this->our_port->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// confirm_type
			$this->confirm_type->ViewValue = $this->confirm_type->CurrentValue;
			$this->confirm_type->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// confirm_quantity
			$this->confirm_quantity->ViewValue = $this->confirm_quantity->CurrentValue;
			$this->confirm_quantity->ViewValue = FormatNumber($this->confirm_quantity->ViewValue, 2, -2, -2, -2);
			$this->confirm_quantity->ViewCustomAttributes = "";

			// confirm_pending
			$this->confirm_pending->ViewValue = $this->confirm_pending->CurrentValue;
			$this->confirm_pending->ViewValue = FormatNumber($this->confirm_pending->ViewValue, 2, -2, -2, -2);
			$this->confirm_pending->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// currency
			$this->currency->ViewValue = $this->currency->CurrentValue;
			$this->currency->ViewCustomAttributes = "";

			// confirm_port_eta
			$this->confirm_port_eta->ViewValue = $this->confirm_port_eta->CurrentValue;
			$this->confirm_port_eta->ViewCustomAttributes = "";

			// reference
			$this->reference->ViewValue = $this->reference->CurrentValue;
			$this->reference->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 0, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "booking_reflist.php?x_product=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// b_quantity
			$this->b_quantity->LinkCustomAttributes = "";
			$this->b_quantity->HrefValue = "";
			$this->b_quantity->TooltipValue = "";

			// booking_date
			$this->booking_date->LinkCustomAttributes = "";
			if (!EmptyValue($this->booking_date->CurrentValue)) {
				$this->booking_date->HrefValue = "booking_reflist.php?x_booking_date=" . $this->booking_date->CurrentValue; // Add prefix/suffix
				$this->booking_date->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->booking_date->HrefValue = FullUrl($this->booking_date->HrefValue, "href");
			} else {
				$this->booking_date->HrefValue = "";
			}
			$this->booking_date->TooltipValue = "";

			// booking_rate
			$this->booking_rate->LinkCustomAttributes = "";
			$this->booking_rate->HrefValue = "";
			$this->booking_rate->TooltipValue = "";

			// booking_currency
			$this->booking_currency->LinkCustomAttributes = "";
			$this->booking_currency->HrefValue = "";
			$this->booking_currency->TooltipValue = "";

			// currency_current_rate
			$this->currency_current_rate->LinkCustomAttributes = "";
			$this->currency_current_rate->HrefValue = "";
			$this->currency_current_rate->TooltipValue = "";

			// shipment_date
			$this->shipment_date->LinkCustomAttributes = "";
			if (!EmptyValue($this->shipment_date->CurrentValue)) {
				$this->shipment_date->HrefValue = "booking_reflist.php?x_shipment_date=" . $this->shipment_date->CurrentValue; // Add prefix/suffix
				$this->shipment_date->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->shipment_date->HrefValue = FullUrl($this->shipment_date->HrefValue, "href");
			} else {
				$this->shipment_date->HrefValue = "";
			}
			$this->shipment_date->TooltipValue = "";

			// our_port
			$this->our_port->LinkCustomAttributes = "";
			$this->our_port->HrefValue = "";
			$this->our_port->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// confirm_type
			$this->confirm_type->LinkCustomAttributes = "";
			$this->confirm_type->HrefValue = "";
			$this->confirm_type->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			$this->product_code->HrefValue = "";
			$this->product_code->TooltipValue = "";

			// confirm_quantity
			$this->confirm_quantity->LinkCustomAttributes = "";
			$this->confirm_quantity->HrefValue = "";
			$this->confirm_quantity->TooltipValue = "";

			// confirm_pending
			$this->confirm_pending->LinkCustomAttributes = "";
			$this->confirm_pending->HrefValue = "";
			$this->confirm_pending->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// confirm_port_eta
			$this->confirm_port_eta->LinkCustomAttributes = "";
			$this->confirm_port_eta->HrefValue = "";
			$this->confirm_port_eta->TooltipValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";
			$this->reference->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
			$curVal = strval($this->rid->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// b_quantity
			$this->b_quantity->EditAttrs["class"] = "form-control";
			$this->b_quantity->EditCustomAttributes = "";
			$this->b_quantity->EditValue = HtmlEncode($this->b_quantity->AdvancedSearch->SearchValue);
			$this->b_quantity->PlaceHolder = RemoveHtml($this->b_quantity->caption());

			// booking_date
			$this->booking_date->EditAttrs["class"] = "form-control";
			$this->booking_date->EditCustomAttributes = "";
			$this->booking_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->booking_date->AdvancedSearch->SearchValue, 0), 8));
			$this->booking_date->PlaceHolder = RemoveHtml($this->booking_date->caption());
			$this->booking_date->EditAttrs["class"] = "form-control";
			$this->booking_date->EditCustomAttributes = "";
			$this->booking_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->booking_date->AdvancedSearch->SearchValue2, 0), 8));
			$this->booking_date->PlaceHolder = RemoveHtml($this->booking_date->caption());

			// booking_rate
			$this->booking_rate->EditAttrs["class"] = "form-control";
			$this->booking_rate->EditCustomAttributes = "";
			$this->booking_rate->EditValue = HtmlEncode($this->booking_rate->AdvancedSearch->SearchValue);
			$this->booking_rate->PlaceHolder = RemoveHtml($this->booking_rate->caption());
			$this->booking_rate->EditAttrs["class"] = "form-control";
			$this->booking_rate->EditCustomAttributes = "";
			$this->booking_rate->EditValue2 = HtmlEncode($this->booking_rate->AdvancedSearch->SearchValue2);
			$this->booking_rate->PlaceHolder = RemoveHtml($this->booking_rate->caption());

			// booking_currency
			$this->booking_currency->EditAttrs["class"] = "form-control";
			$this->booking_currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->booking_currency->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->booking_currency->AdvancedSearch->ViewValue = $this->booking_currency->lookupCacheOption($curVal);
			else
				$this->booking_currency->AdvancedSearch->ViewValue = $this->booking_currency->Lookup !== NULL && is_array($this->booking_currency->Lookup->Options) ? $curVal : NULL;
			if ($this->booking_currency->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->booking_currency->EditValue = array_values($this->booking_currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->booking_currency->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->booking_currency->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->booking_currency->EditValue = $arwrk;
			}

			// currency_current_rate
			$this->currency_current_rate->EditAttrs["class"] = "form-control";
			$this->currency_current_rate->EditCustomAttributes = "";
			$this->currency_current_rate->EditValue = HtmlEncode($this->currency_current_rate->AdvancedSearch->SearchValue);
			$this->currency_current_rate->PlaceHolder = RemoveHtml($this->currency_current_rate->caption());
			$this->currency_current_rate->EditAttrs["class"] = "form-control";
			$this->currency_current_rate->EditCustomAttributes = "";
			$this->currency_current_rate->EditValue2 = HtmlEncode($this->currency_current_rate->AdvancedSearch->SearchValue2);
			$this->currency_current_rate->PlaceHolder = RemoveHtml($this->currency_current_rate->caption());

			// shipment_date
			$this->shipment_date->EditAttrs["class"] = "form-control";
			$this->shipment_date->EditCustomAttributes = "";
			$this->shipment_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->shipment_date->AdvancedSearch->SearchValue, 0), 8));
			$this->shipment_date->PlaceHolder = RemoveHtml($this->shipment_date->caption());
			$this->shipment_date->EditAttrs["class"] = "form-control";
			$this->shipment_date->EditCustomAttributes = "";
			$this->shipment_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->shipment_date->AdvancedSearch->SearchValue2, 0), 8));
			$this->shipment_date->PlaceHolder = RemoveHtml($this->shipment_date->caption());

			// our_port
			$this->our_port->EditAttrs["class"] = "form-control";
			$this->our_port->EditCustomAttributes = "";
			$curVal = trim(strval($this->our_port->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->our_port->AdvancedSearch->ViewValue = $this->our_port->lookupCacheOption($curVal);
			else
				$this->our_port->AdvancedSearch->ViewValue = $this->our_port->Lookup !== NULL && is_array($this->our_port->Lookup->Options) ? $curVal : NULL;
			if ($this->our_port->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->our_port->EditValue = array_values($this->our_port->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->our_port->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->our_port->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->our_port->EditValue = $arwrk;
			}

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// confirm_type
			$this->confirm_type->EditAttrs["class"] = "form-control";
			$this->confirm_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->confirm_type->AdvancedSearch->SearchValue = HtmlDecode($this->confirm_type->AdvancedSearch->SearchValue);
			$this->confirm_type->EditValue = HtmlEncode($this->confirm_type->AdvancedSearch->SearchValue);
			$this->confirm_type->PlaceHolder = RemoveHtml($this->confirm_type->caption());

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			$this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// confirm_quantity
			$this->confirm_quantity->EditAttrs["class"] = "form-control";
			$this->confirm_quantity->EditCustomAttributes = "";
			$this->confirm_quantity->EditValue = HtmlEncode($this->confirm_quantity->AdvancedSearch->SearchValue);
			$this->confirm_quantity->PlaceHolder = RemoveHtml($this->confirm_quantity->caption());

			// confirm_pending
			$this->confirm_pending->EditAttrs["class"] = "form-control";
			$this->confirm_pending->EditCustomAttributes = "";
			$this->confirm_pending->EditValue = HtmlEncode($this->confirm_pending->AdvancedSearch->SearchValue);
			$this->confirm_pending->PlaceHolder = RemoveHtml($this->confirm_pending->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$this->currency->EditValue = HtmlEncode($this->currency->AdvancedSearch->SearchValue);
			$this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

			// confirm_port_eta
			$this->confirm_port_eta->EditAttrs["class"] = "form-control";
			$this->confirm_port_eta->EditCustomAttributes = "";
			$this->confirm_port_eta->EditValue = HtmlEncode($this->confirm_port_eta->AdvancedSearch->SearchValue);
			$this->confirm_port_eta->PlaceHolder = RemoveHtml($this->confirm_port_eta->caption());

			// reference
			$this->reference->EditAttrs["class"] = "form-control";
			$this->reference->EditCustomAttributes = "";
			$this->reference->EditValue = HtmlEncode($this->reference->AdvancedSearch->SearchValue);
			$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->AdvancedSearch->SearchValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->rid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->rid->errorMessage());
		}
		if (!CheckNumber($this->b_quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->b_quantity->errorMessage());
		}
		if (!CheckDate($this->booking_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->booking_date->errorMessage());
		}
		if (!CheckDate($this->booking_date->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->booking_date->errorMessage());
		}
		if (!CheckNumber($this->booking_rate->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->booking_rate->errorMessage());
		}
		if (!CheckNumber($this->booking_rate->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->booking_rate->errorMessage());
		}
		if (!CheckNumber($this->currency_current_rate->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->currency_current_rate->errorMessage());
		}
		if (!CheckNumber($this->currency_current_rate->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->currency_current_rate->errorMessage());
		}
		if (!CheckDate($this->shipment_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->shipment_date->errorMessage());
		}
		if (!CheckDate($this->shipment_date->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->shipment_date->errorMessage());
		}
		if (!CheckNumber($this->confirm_quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->confirm_quantity->errorMessage());
		}
		if (!CheckNumber($this->confirm_pending->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->confirm_pending->errorMessage());
		}
		if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->amount->errorMessage());
		}
		if (!CheckInteger($this->packets->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->packets->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->b_quantity->AdvancedSearch->load();
		$this->booking_date->AdvancedSearch->load();
		$this->booking_rate->AdvancedSearch->load();
		$this->booking_currency->AdvancedSearch->load();
		$this->currency_current_rate->AdvancedSearch->load();
		$this->shipment_date->AdvancedSearch->load();
		$this->our_port->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->confirm_type->AdvancedSearch->load();
		$this->product_code->AdvancedSearch->load();
		$this->confirm_quantity->AdvancedSearch->load();
		$this->confirm_pending->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->confirm_port_eta->AdvancedSearch->load();
		$this->reference->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("booking_reflist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_supplier_id":
					$lookupFilter = function() {
						return "`status` = 1 and `category` = 200";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`id`>1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_our_port":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_supplier_id":
							break;
						case "x_rid":
							break;
						case "x_booking_currency":
							break;
						case "x_our_port":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>