<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for buyer
 */
class buyer extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $user_name;
	public $password;
	public $category;
	public $sub_category;
	public $grp;
	public $name;
	public $code;
	public $seller;
	public $mobile;
	public $_email;
	public $country;
	public $region;
	public $city;
	public $address;
	public $location;
	public $reports_to;
	public $status;
	public $tax_registration;
	public $currency;
	public $port_sea;
	public $incoterm;
	public $port_air;
	public $type;
	public $operator;
	public $datetime;
	public $uid;
	public $performance;
	public $price_percent;
	public $last_login;
	public $reg_date;
	public $reg_device;
	public $device_id;
	public $device_token_id;
	public $cart_number;
	public $r_text;
	public $city_name;
	public $remarks;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'buyer';
		$this->TableName = 'buyer';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`buyer`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('buyer', 'buyer', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// user_name
		$this->user_name = new DbField('buyer', 'buyer', 'x_user_name', 'user_name', '`user_name`', '`user_name`', 200, -1, FALSE, '`user_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->user_name->Sortable = TRUE; // Allow sort
		$this->fields['user_name'] = &$this->user_name;

		// password
		$this->password = new DbField('buyer', 'buyer', 'x_password', 'password', '`password`', '`password`', 200, -1, FALSE, '`password`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->password->Sortable = TRUE; // Allow sort
		$this->fields['password'] = &$this->password;

		// category
		$this->category = new DbField('buyer', 'buyer', 'x_category', 'category', '`category`', '`category`', 2, -1, FALSE, '`category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->category->Nullable = FALSE; // NOT NULL field
		$this->category->Required = TRUE; // Required field
		$this->category->Sortable = TRUE; // Allow sort
		$this->category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->category->Lookup = new Lookup('category', 'pp_category', FALSE, 'id', ["category","","",""], [], ["x_sub_category"], [], [], [], [], '`category` ASC', '');
		$this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['category'] = &$this->category;

		// sub_category
		$this->sub_category = new DbField('buyer', 'buyer', 'x_sub_category', 'sub_category', '`sub_category`', '`sub_category`', 2, -1, FALSE, '`sub_category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->sub_category->Sortable = TRUE; // Allow sort
		$this->sub_category->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->sub_category->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->sub_category->Lookup = new Lookup('sub_category', 'pp_category', TRUE, 'id', ["category","","",""], ["x_category"], [], ["grp"], ["x_grp"], [], [], '`id` ASC', '');
		$this->sub_category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sub_category'] = &$this->sub_category;

		// grp
		$this->grp = new DbField('buyer', 'buyer', 'x_grp', 'grp', '`grp`', '`grp`', 200, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// name
		$this->name = new DbField('buyer', 'buyer', 'x_name', 'name', '`name`', '`name`', 200, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Nullable = FALSE; // NOT NULL field
		$this->name->Required = TRUE; // Required field
		$this->name->Sortable = TRUE; // Allow sort
		$this->fields['name'] = &$this->name;

		// code
		$this->code = new DbField('buyer', 'buyer', 'x_code', 'code', '`code`', '`code`', 200, -1, FALSE, '`code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->code->Sortable = TRUE; // Allow sort
		$this->code->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['code'] = &$this->code;

		// seller
		$this->seller = new DbField('buyer', 'buyer', 'x_seller', 'seller', '`seller`', '`seller`', 3, -1, FALSE, '`seller`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->seller->Sortable = TRUE; // Allow sort
		$this->seller->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->seller->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->seller->Lookup = new Lookup('seller', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->seller->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['seller'] = &$this->seller;

		// mobile
		$this->mobile = new DbField('buyer', 'buyer', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 200, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Sortable = FALSE; // Allow sort
		$this->fields['mobile'] = &$this->mobile;

		// email
		$this->_email = new DbField('buyer', 'buyer', 'x__email', 'email', '`email`', '`email`', 200, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->fields['email'] = &$this->_email;

		// country
		$this->country = new DbField('buyer', 'buyer', 'x_country', 'country', '`country`', '`country`', 18, -1, FALSE, '`country`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->country->Sortable = TRUE; // Allow sort
		$this->country->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->country->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->country->Lookup = new Lookup('country', 'world_country', FALSE, 'id', ["name","","",""], [], ["x_region"], [], [], [], [], '`name` ASC', '');
		$this->country->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['country'] = &$this->country;

		// region
		$this->region = new DbField('buyer', 'buyer', 'x_region', 'region', '`region`', '`region`', 19, -1, FALSE, '`region`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->region->Sortable = TRUE; // Allow sort
		$this->region->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->region->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->region->Lookup = new Lookup('region', 'world_state', FALSE, 'id', ["name","","",""], ["x_country"], ["x_city"], ["country_id"], ["x_country_id"], [], [], '`name` ASC', '');
		$this->region->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['region'] = &$this->region;

		// city
		$this->city = new DbField('buyer', 'buyer', 'x_city', 'city', '`city`', '`city`', 21, -1, FALSE, '`EV__city`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->city->Sortable = TRUE; // Allow sort
		$this->city->Lookup = new Lookup('city', 'world_city', FALSE, 'id', ["name","","",""], ["x_region"], ["x_location"], ["state_id"], ["x_state_id"], [], [], '`name` ASC', '');
		$this->city->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['city'] = &$this->city;

		// address
		$this->address = new DbField('buyer', 'buyer', 'x_address', 'address', '`address`', '`address`', 200, -1, FALSE, '`address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->address->Sortable = TRUE; // Allow sort
		$this->fields['address'] = &$this->address;

		// location
		$this->location = new DbField('buyer', 'buyer', 'x_location', 'location', '`location`', '`location`', 201, -1, FALSE, '`EV__location`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->location->Sortable = TRUE; // Allow sort
		$this->location->Lookup = new Lookup('location', 'buyer', FALSE, 'location', ["location","","",""], ["x_city"], [], ["city"], ["x_city"], [], [], '`location` ASC', '');
		$this->fields['location'] = &$this->location;

		// reports_to
		$this->reports_to = new DbField('buyer', 'buyer', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 200, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->reports_to->Nullable = FALSE; // NOT NULL field
		$this->reports_to->Required = TRUE; // Required field
		$this->reports_to->Sortable = TRUE; // Allow sort
		$this->reports_to->SelectMultiple = TRUE; // Multiple select
		$this->reports_to->Lookup = new Lookup('reports_to', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reports_to'] = &$this->reports_to;

		// status
		$this->status = new DbField('buyer', 'buyer', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'buyer', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// tax_registration
		$this->tax_registration = new DbField('buyer', 'buyer', 'x_tax_registration', 'tax_registration', '`tax_registration`', '`tax_registration`', 200, -1, FALSE, '`tax_registration`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tax_registration->Sortable = TRUE; // Allow sort
		$this->fields['tax_registration'] = &$this->tax_registration;

		// currency
		$this->currency = new DbField('buyer', 'buyer', 'x_currency', 'currency', '`currency`', '`currency`', 18, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', TRUE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// port_sea
		$this->port_sea = new DbField('buyer', 'buyer', 'x_port_sea', 'port_sea', '`port_sea`', '`port_sea`', 18, -1, FALSE, '`port_sea`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->port_sea->Sortable = TRUE; // Allow sort
		$this->port_sea->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->port_sea->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->port_sea->Lookup = new Lookup('port_sea', 'port', FALSE, 'id', ["port","code","",""], [], [], [], [], [], [], '`port` ASC', '');
		$this->fields['port_sea'] = &$this->port_sea;

		// incoterm
		$this->incoterm = new DbField('buyer', 'buyer', 'x_incoterm', 'incoterm', '`incoterm`', '`incoterm`', 200, -1, FALSE, '`incoterm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->incoterm->Sortable = TRUE; // Allow sort
		$this->incoterm->SelectMultiple = TRUE; // Multiple select
		$this->incoterm->Lookup = new Lookup('incoterm', 'incoterm', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['incoterm'] = &$this->incoterm;

		// port_air
		$this->port_air = new DbField('buyer', 'buyer', 'x_port_air', 'port_air', '`port_air`', '`port_air`', 18, -1, FALSE, '`port_air`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->port_air->Sortable = TRUE; // Allow sort
		$this->port_air->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->port_air->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->port_air->Lookup = new Lookup('port_air', 'port', FALSE, 'id', ["port","code","",""], [], [], [], [], [], [], '`port` ASC', '');
		$this->fields['port_air'] = &$this->port_air;

		// type
		$this->type = new DbField('buyer', 'buyer', 'x_type', 'type', '`type`', '`type`', 200, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->type->Sortable = FALSE; // Allow sort
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// operator
		$this->operator = new DbField('buyer', 'buyer', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('buyer', 'buyer', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// uid
		$this->uid = new DbField('buyer', 'buyer', 'x_uid', 'uid', '`uid`', '`uid`', 200, -1, FALSE, '`uid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->uid->Nullable = FALSE; // NOT NULL field
		$this->uid->Sortable = FALSE; // Allow sort
		$this->uid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['uid'] = &$this->uid;

		// performance
		$this->performance = new DbField('buyer', 'buyer', 'x_performance', 'performance', '`performance`', '`performance`', 16, -1, FALSE, '`performance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->performance->Sortable = TRUE; // Allow sort
		$this->performance->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['performance'] = &$this->performance;

		// price_percent
		$this->price_percent = new DbField('buyer', 'buyer', 'x_price_percent', 'price_percent', '`price_percent`', '`price_percent`', 4, -1, FALSE, '`price_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price_percent->Sortable = TRUE; // Allow sort
		$this->price_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price_percent'] = &$this->price_percent;

		// last_login
		$this->last_login = new DbField('buyer', 'buyer', 'x_last_login', 'last_login', '`last_login`', CastDateFieldForLike('`last_login`', 0, "DB"), 135, 0, FALSE, '`last_login`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->last_login->Sortable = FALSE; // Allow sort
		$this->last_login->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['last_login'] = &$this->last_login;

		// reg_date
		$this->reg_date = new DbField('buyer', 'buyer', 'x_reg_date', 'reg_date', '`reg_date`', CastDateFieldForLike('`reg_date`', 0, "DB"), 135, 0, FALSE, '`reg_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reg_date->Sortable = FALSE; // Allow sort
		$this->reg_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['reg_date'] = &$this->reg_date;

		// reg_device
		$this->reg_device = new DbField('buyer', 'buyer', 'x_reg_device', 'reg_device', '`reg_device`', '`reg_device`', 2, -1, FALSE, '`reg_device`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reg_device->Sortable = FALSE; // Allow sort
		$this->reg_device->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reg_device'] = &$this->reg_device;

		// device_id
		$this->device_id = new DbField('buyer', 'buyer', 'x_device_id', 'device_id', '`device_id`', '`device_id`', 200, -1, FALSE, '`device_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->device_id->Sortable = FALSE; // Allow sort
		$this->fields['device_id'] = &$this->device_id;

		// device_token_id
		$this->device_token_id = new DbField('buyer', 'buyer', 'x_device_token_id', 'device_token_id', '`device_token_id`', '`device_token_id`', 200, -1, FALSE, '`device_token_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->device_token_id->Sortable = FALSE; // Allow sort
		$this->fields['device_token_id'] = &$this->device_token_id;

		// cart_number
		$this->cart_number = new DbField('buyer', 'buyer', 'x_cart_number', 'cart_number', '`cart_number`', '`cart_number`', 3, -1, FALSE, '`cart_number`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_number->Sortable = FALSE; // Allow sort
		$this->cart_number->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cart_number'] = &$this->cart_number;

		// r_text
		$this->r_text = new DbField('buyer', 'buyer', 'x_r_text', 'r_text', '`r_text`', '`r_text`', 201, -1, FALSE, '`r_text`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->r_text->Sortable = FALSE; // Allow sort
		$this->fields['r_text'] = &$this->r_text;

		// city_name
		$this->city_name = new DbField('buyer', 'buyer', 'x_city_name', 'city_name', '`city_name`', '`city_name`', 200, -1, FALSE, '`city_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->city_name->Sortable = FALSE; // Allow sort
		$this->fields['city_name'] = &$this->city_name;

		// remarks
		$this->remarks = new DbField('buyer', 'buyer', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`buyer`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `world_city` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `buyer`.`city` LIMIT 1) AS `EV__city`, (SELECT `location` FROM `buyer` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`location` = `buyer`.`location` LIMIT 1) AS `EV__location` FROM `buyer`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`id`>1000";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->city->AdvancedSearch->SearchValue <> "" ||
			$this->city->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->city->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->city->VirtualExpression . " "))
			return TRUE;
		if ($this->location->AdvancedSearch->SearchValue <> "" ||
			$this->location->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->location->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->location->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->user_name->DbValue = $row['user_name'];
		$this->password->DbValue = $row['password'];
		$this->category->DbValue = $row['category'];
		$this->sub_category->DbValue = $row['sub_category'];
		$this->grp->DbValue = $row['grp'];
		$this->name->DbValue = $row['name'];
		$this->code->DbValue = $row['code'];
		$this->seller->DbValue = $row['seller'];
		$this->mobile->DbValue = $row['mobile'];
		$this->_email->DbValue = $row['email'];
		$this->country->DbValue = $row['country'];
		$this->region->DbValue = $row['region'];
		$this->city->DbValue = $row['city'];
		$this->address->DbValue = $row['address'];
		$this->location->DbValue = $row['location'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->status->DbValue = $row['status'];
		$this->tax_registration->DbValue = $row['tax_registration'];
		$this->currency->DbValue = $row['currency'];
		$this->port_sea->DbValue = $row['port_sea'];
		$this->incoterm->DbValue = $row['incoterm'];
		$this->port_air->DbValue = $row['port_air'];
		$this->type->DbValue = $row['type'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->uid->DbValue = $row['uid'];
		$this->performance->DbValue = $row['performance'];
		$this->price_percent->DbValue = $row['price_percent'];
		$this->last_login->DbValue = $row['last_login'];
		$this->reg_date->DbValue = $row['reg_date'];
		$this->reg_device->DbValue = $row['reg_device'];
		$this->device_id->DbValue = $row['device_id'];
		$this->device_token_id->DbValue = $row['device_token_id'];
		$this->cart_number->DbValue = $row['cart_number'];
		$this->r_text->DbValue = $row['r_text'];
		$this->city_name->DbValue = $row['city_name'];
		$this->remarks->DbValue = $row['remarks'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "buyerlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "buyerview.php")
			return $Language->phrase("View");
		elseif ($pageName == "buyeredit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "buyeradd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "buyerlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("buyerview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("buyerview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "buyeradd.php?" . $this->getUrlParm($parm);
		else
			$url = "buyeradd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("buyeredit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("buyeradd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("buyerdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->user_name->setDbValue($rs->fields('user_name'));
		$this->password->setDbValue($rs->fields('password'));
		$this->category->setDbValue($rs->fields('category'));
		$this->sub_category->setDbValue($rs->fields('sub_category'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->name->setDbValue($rs->fields('name'));
		$this->code->setDbValue($rs->fields('code'));
		$this->seller->setDbValue($rs->fields('seller'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->_email->setDbValue($rs->fields('email'));
		$this->country->setDbValue($rs->fields('country'));
		$this->region->setDbValue($rs->fields('region'));
		$this->city->setDbValue($rs->fields('city'));
		$this->address->setDbValue($rs->fields('address'));
		$this->location->setDbValue($rs->fields('location'));
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->status->setDbValue($rs->fields('status'));
		$this->tax_registration->setDbValue($rs->fields('tax_registration'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->port_sea->setDbValue($rs->fields('port_sea'));
		$this->incoterm->setDbValue($rs->fields('incoterm'));
		$this->port_air->setDbValue($rs->fields('port_air'));
		$this->type->setDbValue($rs->fields('type'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->uid->setDbValue($rs->fields('uid'));
		$this->performance->setDbValue($rs->fields('performance'));
		$this->price_percent->setDbValue($rs->fields('price_percent'));
		$this->last_login->setDbValue($rs->fields('last_login'));
		$this->reg_date->setDbValue($rs->fields('reg_date'));
		$this->reg_device->setDbValue($rs->fields('reg_device'));
		$this->device_id->setDbValue($rs->fields('device_id'));
		$this->device_token_id->setDbValue($rs->fields('device_token_id'));
		$this->cart_number->setDbValue($rs->fields('cart_number'));
		$this->r_text->setDbValue($rs->fields('r_text'));
		$this->city_name->setDbValue($rs->fields('city_name'));
		$this->remarks->setDbValue($rs->fields('remarks'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// user_name
		// password
		// category
		// sub_category
		// grp
		// name
		// code
		// seller
		// mobile
		// email
		// country
		// region
		// city
		// address
		// location
		// reports_to
		// status
		// tax_registration
		// currency
		// port_sea
		// incoterm
		// port_air
		// type

		$this->type->CellCssStyle = "white-space: nowrap;";

		// operator
		// datetime
		// uid

		$this->uid->CellCssStyle = "white-space: nowrap;";

		// performance
		// price_percent
		// last_login

		$this->last_login->CellCssStyle = "white-space: nowrap;";

		// reg_date
		$this->reg_date->CellCssStyle = "white-space: nowrap;";

		// reg_device
		$this->reg_device->CellCssStyle = "white-space: nowrap;";

		// device_id
		$this->device_id->CellCssStyle = "white-space: nowrap;";

		// device_token_id
		$this->device_token_id->CellCssStyle = "white-space: nowrap;";

		// cart_number
		$this->cart_number->CellCssStyle = "white-space: nowrap;";

		// r_text
		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// city_name
		$this->city_name->CellCssStyle = "white-space: nowrap;";

		// remarks
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// user_name
		$this->user_name->ViewValue = $this->user_name->CurrentValue;
		$this->user_name->ViewCustomAttributes = "";

		// password
		$this->password->ViewValue = $this->password->CurrentValue;
		$this->password->ViewCustomAttributes = "";

		// category
		$curVal = strval($this->category->CurrentValue);
		if ($curVal <> "") {
			$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			if ($this->category->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and FIND_IN_SET('2', `partner_type`) and `grp` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->category->ViewValue = $this->category->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->category->ViewValue = $this->category->CurrentValue;
				}
			}
		} else {
			$this->category->ViewValue = NULL;
		}
		$this->category->ViewCustomAttributes = "";

		// sub_category
		$curVal = strval($this->sub_category->CurrentValue);
		if ($curVal <> "") {
			$this->sub_category->ViewValue = $this->sub_category->lookupCacheOption($curVal);
			if ($this->sub_category->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and FIND_IN_SET('2', `partner_type`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->sub_category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->sub_category->ViewValue = $this->sub_category->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->sub_category->ViewValue = $this->sub_category->CurrentValue;
				}
			}
		} else {
			$this->sub_category->ViewValue = NULL;
		}
		$this->sub_category->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$this->name->ViewCustomAttributes = "";

		// code
		$this->code->ViewValue = $this->code->CurrentValue;
		$this->code->ViewCustomAttributes = "";

		// seller
		$curVal = strval($this->seller->CurrentValue);
		if ($curVal <> "") {
			$this->seller->ViewValue = $this->seller->lookupCacheOption($curVal);
			if ($this->seller->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->seller->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->seller->ViewValue = $this->seller->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->seller->ViewValue = $this->seller->CurrentValue;
				}
			}
		} else {
			$this->seller->ViewValue = NULL;
		}
		$this->seller->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$this->mobile->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// country
		$curVal = strval($this->country->CurrentValue);
		if ($curVal <> "") {
			$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
			if ($this->country->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->country->ViewValue = $this->country->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->country->ViewValue = $this->country->CurrentValue;
				}
			}
		} else {
			$this->country->ViewValue = NULL;
		}
		$this->country->ViewCustomAttributes = "";

		// region
		$curVal = strval($this->region->CurrentValue);
		if ($curVal <> "") {
			$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
			if ($this->region->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->region->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->region->ViewValue = $this->region->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->region->ViewValue = $this->region->CurrentValue;
				}
			}
		} else {
			$this->region->ViewValue = NULL;
		}
		$this->region->ViewCustomAttributes = "";

		// city
		if ($this->city->VirtualValue <> "") {
			$this->city->ViewValue = $this->city->VirtualValue;
		} else {
			$this->city->ViewValue = $this->city->CurrentValue;
		$curVal = strval($this->city->CurrentValue);
		if ($curVal <> "") {
			$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
			if ($this->city->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->city->ViewValue = $this->city->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->city->ViewValue = $this->city->CurrentValue;
				}
			}
		} else {
			$this->city->ViewValue = NULL;
		}
		}
		$this->city->ViewCustomAttributes = "";

		// address
		$this->address->ViewValue = $this->address->CurrentValue;
		$this->address->ViewCustomAttributes = "";

		// location
		if ($this->location->VirtualValue <> "") {
			$this->location->ViewValue = $this->location->VirtualValue;
		} else {
			$this->location->ViewValue = $this->location->CurrentValue;
		$arwrk = array();
		$arwrk[1] = $this->location->CurrentValue;
		$this->location->ViewValue = $this->location->displayValue($arwrk);
		}
		$this->location->ViewCustomAttributes = "";

		// reports_to
		$curVal = strval($this->reports_to->CurrentValue);
		if ($curVal <> "") {
			$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			if ($this->reports_to->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 10 and `activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->reports_to->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue->add($this->reports_to->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
				}
			}
		} else {
			$this->reports_to->ViewValue = NULL;
		}
		$this->reports_to->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// tax_registration
		$this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;
		$this->tax_registration->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// port_sea
		$curVal = strval($this->port_sea->CurrentValue);
		if ($curVal <> "") {
			$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
			if ($this->port_sea->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`mode`=0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_sea->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->port_sea->ViewValue = $this->port_sea->CurrentValue;
				}
			}
		} else {
			$this->port_sea->ViewValue = NULL;
		}
		$this->port_sea->ViewCustomAttributes = "";

		// incoterm
		$curVal = strval($this->incoterm->CurrentValue);
		if ($curVal <> "") {
			$this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
			if ($this->incoterm->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->incoterm->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->incoterm->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->incoterm->ViewValue->add($this->incoterm->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->incoterm->ViewValue = $this->incoterm->CurrentValue;
				}
			}
		} else {
			$this->incoterm->ViewValue = NULL;
		}
		$this->incoterm->ViewCustomAttributes = "";

		// port_air
		$curVal = strval($this->port_air->CurrentValue);
		if ($curVal <> "") {
			$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
			if ($this->port_air->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`mode`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_air->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->port_air->ViewValue = $this->port_air->CurrentValue;
				}
			}
		} else {
			$this->port_air->ViewValue = NULL;
		}
		$this->port_air->ViewCustomAttributes = "";

		// type
		$this->type->ViewValue = $this->type->CurrentValue;
		$this->type->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// uid
		$this->uid->ViewValue = $this->uid->CurrentValue;
		$this->uid->ViewCustomAttributes = "";

		// performance
		$this->performance->ViewValue = $this->performance->CurrentValue;
		$this->performance->ViewValue = FormatNumber($this->performance->ViewValue, 0, -2, -2, -2);
		$this->performance->ViewCustomAttributes = "";

		// price_percent
		$this->price_percent->ViewValue = $this->price_percent->CurrentValue;
		$this->price_percent->ViewValue = FormatNumber($this->price_percent->ViewValue, 2, -2, -2, -2);
		$this->price_percent->ViewCustomAttributes = "";

		// last_login
		$this->last_login->ViewValue = $this->last_login->CurrentValue;
		$this->last_login->ViewValue = FormatDateTime($this->last_login->ViewValue, 0);
		$this->last_login->ViewCustomAttributes = "";

		// reg_date
		$this->reg_date->ViewValue = $this->reg_date->CurrentValue;
		$this->reg_date->ViewValue = FormatDateTime($this->reg_date->ViewValue, 0);
		$this->reg_date->ViewCustomAttributes = "";

		// reg_device
		$this->reg_device->ViewValue = $this->reg_device->CurrentValue;
		$this->reg_device->ViewValue = FormatNumber($this->reg_device->ViewValue, 0, -2, -2, -2);
		$this->reg_device->ViewCustomAttributes = "";

		// device_id
		$this->device_id->ViewValue = $this->device_id->CurrentValue;
		$this->device_id->ViewCustomAttributes = "";

		// device_token_id
		$this->device_token_id->ViewValue = $this->device_token_id->CurrentValue;
		$this->device_token_id->ViewCustomAttributes = "";

		// cart_number
		$this->cart_number->ViewValue = $this->cart_number->CurrentValue;
		$this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, 0, -2, -2, -2);
		$this->cart_number->ViewCustomAttributes = "";

		// r_text
		$this->r_text->ViewValue = $this->r_text->CurrentValue;
		$this->r_text->ViewCustomAttributes = "";

		// city_name
		$this->city_name->ViewValue = $this->city_name->CurrentValue;
		$this->city_name->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// user_name
		$this->user_name->LinkCustomAttributes = "";
		$this->user_name->HrefValue = "";
		$this->user_name->TooltipValue = "";

		// password
		$this->password->LinkCustomAttributes = "";
		$this->password->HrefValue = "";
		$this->password->TooltipValue = "";

		// category
		$this->category->LinkCustomAttributes = "";
		$this->category->HrefValue = "";
		$this->category->TooltipValue = "";

		// sub_category
		$this->sub_category->LinkCustomAttributes = "";
		$this->sub_category->HrefValue = "";
		$this->sub_category->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		$this->name->HrefValue = "";
		$this->name->TooltipValue = "";

		// code
		$this->code->LinkCustomAttributes = "";
		$this->code->HrefValue = "";
		$this->code->TooltipValue = "";

		// seller
		$this->seller->LinkCustomAttributes = "";
		$this->seller->HrefValue = "";
		$this->seller->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// country
		$this->country->LinkCustomAttributes = "";
		$this->country->HrefValue = "";
		$this->country->TooltipValue = "";

		// region
		$this->region->LinkCustomAttributes = "";
		$this->region->HrefValue = "";
		$this->region->TooltipValue = "";

		// city
		$this->city->LinkCustomAttributes = "";
		$this->city->HrefValue = "";
		$this->city->TooltipValue = "";

		// address
		$this->address->LinkCustomAttributes = "";
		$this->address->HrefValue = "";
		$this->address->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// tax_registration
		$this->tax_registration->LinkCustomAttributes = "";
		$this->tax_registration->HrefValue = "";
		$this->tax_registration->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// port_sea
		$this->port_sea->LinkCustomAttributes = "";
		$this->port_sea->HrefValue = "";
		$this->port_sea->TooltipValue = "";

		// incoterm
		$this->incoterm->LinkCustomAttributes = "";
		$this->incoterm->HrefValue = "";
		$this->incoterm->TooltipValue = "";

		// port_air
		$this->port_air->LinkCustomAttributes = "";
		$this->port_air->HrefValue = "";
		$this->port_air->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// uid
		$this->uid->LinkCustomAttributes = "";
		$this->uid->HrefValue = "";
		$this->uid->TooltipValue = "";

		// performance
		$this->performance->LinkCustomAttributes = "";
		$this->performance->HrefValue = "";
		$this->performance->TooltipValue = "";

		// price_percent
		$this->price_percent->LinkCustomAttributes = "";
		$this->price_percent->HrefValue = "";
		$this->price_percent->TooltipValue = "";

		// last_login
		$this->last_login->LinkCustomAttributes = "";
		$this->last_login->HrefValue = "";
		$this->last_login->TooltipValue = "";

		// reg_date
		$this->reg_date->LinkCustomAttributes = "";
		$this->reg_date->HrefValue = "";
		$this->reg_date->TooltipValue = "";

		// reg_device
		$this->reg_device->LinkCustomAttributes = "";
		$this->reg_device->HrefValue = "";
		$this->reg_device->TooltipValue = "";

		// device_id
		$this->device_id->LinkCustomAttributes = "";
		$this->device_id->HrefValue = "";
		$this->device_id->TooltipValue = "";

		// device_token_id
		$this->device_token_id->LinkCustomAttributes = "";
		$this->device_token_id->HrefValue = "";
		$this->device_token_id->TooltipValue = "";

		// cart_number
		$this->cart_number->LinkCustomAttributes = "";
		$this->cart_number->HrefValue = "";
		$this->cart_number->TooltipValue = "";

		// r_text
		$this->r_text->LinkCustomAttributes = "";
		$this->r_text->HrefValue = "";
		$this->r_text->TooltipValue = "";

		// city_name
		$this->city_name->LinkCustomAttributes = "";
		$this->city_name->HrefValue = "";
		$this->city_name->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// user_name
		$this->user_name->EditAttrs["class"] = "form-control";
		$this->user_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
		$this->user_name->EditValue = $this->user_name->CurrentValue;
		$this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

		// password
		$this->password->EditAttrs["class"] = "form-control";
		$this->password->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->password->CurrentValue = HtmlDecode($this->password->CurrentValue);
		$this->password->EditValue = $this->password->CurrentValue;
		$this->password->PlaceHolder = RemoveHtml($this->password->caption());

		// category
		$this->category->EditAttrs["class"] = "form-control";
		$this->category->EditCustomAttributes = "";

		// sub_category
		$this->sub_category->EditAttrs["class"] = "form-control";
		$this->sub_category->EditCustomAttributes = "";

		// grp
		$this->grp->EditCustomAttributes = "";

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// code
		$this->code->EditAttrs["class"] = "form-control";
		$this->code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
		$this->code->EditValue = $this->code->CurrentValue;
		$this->code->PlaceHolder = RemoveHtml($this->code->caption());

		// seller
		$this->seller->EditAttrs["class"] = "form-control";
		$this->seller->EditCustomAttributes = "";

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// country
		$this->country->EditAttrs["class"] = "form-control";
		$this->country->EditCustomAttributes = "";

		// region
		$this->region->EditAttrs["class"] = "form-control";
		$this->region->EditCustomAttributes = "";

		// city
		$this->city->EditAttrs["class"] = "form-control";
		$this->city->EditCustomAttributes = "";
		$this->city->EditValue = $this->city->CurrentValue;
		$this->city->PlaceHolder = RemoveHtml($this->city->caption());

		// address
		$this->address->EditAttrs["class"] = "form-control";
		$this->address->EditCustomAttributes = "";
		$this->address->EditValue = $this->address->CurrentValue;
		$this->address->PlaceHolder = RemoveHtml($this->address->caption());

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->location->CurrentValue = HtmlDecode($this->location->CurrentValue);
		$this->location->EditValue = $this->location->CurrentValue;
		$this->location->PlaceHolder = RemoveHtml($this->location->caption());

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// tax_registration
		$this->tax_registration->EditAttrs["class"] = "form-control";
		$this->tax_registration->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->tax_registration->CurrentValue = HtmlDecode($this->tax_registration->CurrentValue);
		$this->tax_registration->EditValue = $this->tax_registration->CurrentValue;
		$this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// port_sea
		$this->port_sea->EditAttrs["class"] = "form-control";
		$this->port_sea->EditCustomAttributes = "";

		// incoterm
		$this->incoterm->EditAttrs["class"] = "form-control";
		$this->incoterm->EditCustomAttributes = "";

		// port_air
		$this->port_air->EditAttrs["class"] = "form-control";
		$this->port_air->EditCustomAttributes = "";

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->type->CurrentValue = HtmlDecode($this->type->CurrentValue);
		$this->type->EditValue = $this->type->CurrentValue;
		$this->type->PlaceHolder = RemoveHtml($this->type->caption());

		// operator
		// datetime
		// uid

		$this->uid->EditAttrs["class"] = "form-control";
		$this->uid->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
		$this->uid->EditValue = $this->uid->CurrentValue;
		$this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

		// performance
		$this->performance->EditAttrs["class"] = "form-control";
		$this->performance->EditCustomAttributes = "";
		$this->performance->EditValue = $this->performance->CurrentValue;
		$this->performance->PlaceHolder = RemoveHtml($this->performance->caption());

		// price_percent
		$this->price_percent->EditAttrs["class"] = "form-control";
		$this->price_percent->EditCustomAttributes = "";
		$this->price_percent->EditValue = $this->price_percent->CurrentValue;
		$this->price_percent->PlaceHolder = RemoveHtml($this->price_percent->caption());
		if (strval($this->price_percent->EditValue) <> "" && is_numeric($this->price_percent->EditValue))
			$this->price_percent->EditValue = FormatNumber($this->price_percent->EditValue, -2, -2, -2, -2);

		// last_login
		$this->last_login->EditAttrs["class"] = "form-control";
		$this->last_login->EditCustomAttributes = "";
		$this->last_login->EditValue = FormatDateTime($this->last_login->CurrentValue, 8);
		$this->last_login->PlaceHolder = RemoveHtml($this->last_login->caption());

		// reg_date
		$this->reg_date->EditAttrs["class"] = "form-control";
		$this->reg_date->EditCustomAttributes = "";
		$this->reg_date->EditValue = FormatDateTime($this->reg_date->CurrentValue, 8);
		$this->reg_date->PlaceHolder = RemoveHtml($this->reg_date->caption());

		// reg_device
		$this->reg_device->EditAttrs["class"] = "form-control";
		$this->reg_device->EditCustomAttributes = "";
		$this->reg_device->EditValue = $this->reg_device->CurrentValue;
		$this->reg_device->PlaceHolder = RemoveHtml($this->reg_device->caption());

		// device_id
		$this->device_id->EditAttrs["class"] = "form-control";
		$this->device_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->device_id->CurrentValue = HtmlDecode($this->device_id->CurrentValue);
		$this->device_id->EditValue = $this->device_id->CurrentValue;
		$this->device_id->PlaceHolder = RemoveHtml($this->device_id->caption());

		// device_token_id
		$this->device_token_id->EditAttrs["class"] = "form-control";
		$this->device_token_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->device_token_id->CurrentValue = HtmlDecode($this->device_token_id->CurrentValue);
		$this->device_token_id->EditValue = $this->device_token_id->CurrentValue;
		$this->device_token_id->PlaceHolder = RemoveHtml($this->device_token_id->caption());

		// cart_number
		$this->cart_number->EditAttrs["class"] = "form-control";
		$this->cart_number->EditCustomAttributes = "";
		$this->cart_number->EditValue = $this->cart_number->CurrentValue;
		$this->cart_number->EditValue = FormatNumber($this->cart_number->EditValue, 0, -2, -2, -2);
		$this->cart_number->ViewCustomAttributes = "";

		// r_text
		$this->r_text->EditAttrs["class"] = "form-control";
		$this->r_text->EditCustomAttributes = "";
		$this->r_text->EditValue = $this->r_text->CurrentValue;
		$this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

		// city_name
		$this->city_name->EditAttrs["class"] = "form-control";
		$this->city_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
		$this->city_name->EditValue = $this->city_name->CurrentValue;
		$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->user_name);
					$doc->exportCaption($this->password);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->sub_category);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->seller);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->country);
					$doc->exportCaption($this->region);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->tax_registration);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->port_sea);
					$doc->exportCaption($this->incoterm);
					$doc->exportCaption($this->port_air);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->performance);
					$doc->exportCaption($this->price_percent);
					$doc->exportCaption($this->last_login);
					$doc->exportCaption($this->reg_date);
					$doc->exportCaption($this->reg_device);
					$doc->exportCaption($this->device_id);
					$doc->exportCaption($this->device_token_id);
					$doc->exportCaption($this->cart_number);
					$doc->exportCaption($this->remarks);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->user_name);
					$doc->exportCaption($this->password);
					$doc->exportCaption($this->category);
					$doc->exportCaption($this->sub_category);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->code);
					$doc->exportCaption($this->seller);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->country);
					$doc->exportCaption($this->region);
					$doc->exportCaption($this->city);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->tax_registration);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->port_sea);
					$doc->exportCaption($this->incoterm);
					$doc->exportCaption($this->port_air);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->performance);
					$doc->exportCaption($this->price_percent);
					$doc->exportCaption($this->remarks);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->user_name);
						$doc->exportField($this->password);
						$doc->exportField($this->category);
						$doc->exportField($this->sub_category);
						$doc->exportField($this->grp);
						$doc->exportField($this->name);
						$doc->exportField($this->code);
						$doc->exportField($this->seller);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->country);
						$doc->exportField($this->region);
						$doc->exportField($this->city);
						$doc->exportField($this->address);
						$doc->exportField($this->location);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->status);
						$doc->exportField($this->tax_registration);
						$doc->exportField($this->currency);
						$doc->exportField($this->port_sea);
						$doc->exportField($this->incoterm);
						$doc->exportField($this->port_air);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->performance);
						$doc->exportField($this->price_percent);
						$doc->exportField($this->last_login);
						$doc->exportField($this->reg_date);
						$doc->exportField($this->reg_device);
						$doc->exportField($this->device_id);
						$doc->exportField($this->device_token_id);
						$doc->exportField($this->cart_number);
						$doc->exportField($this->remarks);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->user_name);
						$doc->exportField($this->password);
						$doc->exportField($this->category);
						$doc->exportField($this->sub_category);
						$doc->exportField($this->grp);
						$doc->exportField($this->name);
						$doc->exportField($this->code);
						$doc->exportField($this->seller);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->country);
						$doc->exportField($this->region);
						$doc->exportField($this->city);
						$doc->exportField($this->address);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->status);
						$doc->exportField($this->tax_registration);
						$doc->exportField($this->currency);
						$doc->exportField($this->port_sea);
						$doc->exportField($this->incoterm);
						$doc->exportField($this->port_air);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->performance);
						$doc->exportField($this->price_percent);
						$doc->exportField($this->remarks);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>