<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class buyer_add extends buyer
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'buyer';

	// Page object name
	public $PageObjName = "buyer_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (buyer)
		if (!isset($GLOBALS["buyer"]) || get_class($GLOBALS["buyer"]) == PROJECT_NAMESPACE . "buyer") {
			$GLOBALS["buyer"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["buyer"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'buyer');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $buyer;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($buyer);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "buyerview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("buyerlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->user_name->setVisibility();
		$this->password->setVisibility();
		$this->category->setVisibility();
		$this->sub_category->setVisibility();
		$this->grp->setVisibility();
		$this->name->setVisibility();
		$this->code->setVisibility();
		$this->seller->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->country->setVisibility();
		$this->region->setVisibility();
		$this->city->setVisibility();
		$this->address->setVisibility();
		$this->location->setVisibility();
		$this->reports_to->setVisibility();
		$this->status->setVisibility();
		$this->tax_registration->setVisibility();
		$this->currency->setVisibility();
		$this->port_sea->setVisibility();
		$this->incoterm->setVisibility();
		$this->port_air->setVisibility();
		$this->type->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->uid->Visible = FALSE;
		$this->performance->Visible = FALSE;
		$this->price_percent->setVisibility();
		$this->last_login->Visible = FALSE;
		$this->reg_date->Visible = FALSE;
		$this->reg_device->Visible = FALSE;
		$this->device_id->Visible = FALSE;
		$this->device_token_id->Visible = FALSE;
		$this->cart_number->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->city_name->Visible = FALSE;
		$this->remarks->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->sub_category);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->seller);
		$this->setupLookupOptions($this->country);
		$this->setupLookupOptions($this->region);
		$this->setupLookupOptions($this->city);
		$this->setupLookupOptions($this->location);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->port_sea);
		$this->setupLookupOptions($this->incoterm);
		$this->setupLookupOptions($this->port_air);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("buyerlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "buyerlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "buyerview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->user_name->CurrentValue = NULL;
		$this->user_name->OldValue = $this->user_name->CurrentValue;
		$this->password->CurrentValue = NULL;
		$this->password->OldValue = $this->password->CurrentValue;
		$this->category->CurrentValue = NULL;
		$this->category->OldValue = $this->category->CurrentValue;
		$this->sub_category->CurrentValue = NULL;
		$this->sub_category->OldValue = $this->sub_category->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->name->CurrentValue = NULL;
		$this->name->OldValue = $this->name->CurrentValue;
		$this->code->CurrentValue = NULL;
		$this->code->OldValue = $this->code->CurrentValue;
		$this->seller->CurrentValue = 200000;
		$this->mobile->CurrentValue = NULL;
		$this->mobile->OldValue = $this->mobile->CurrentValue;
		$this->_email->CurrentValue = NULL;
		$this->_email->OldValue = $this->_email->CurrentValue;
		$this->country->CurrentValue = 96;
		$this->region->CurrentValue = NULL;
		$this->region->OldValue = $this->region->CurrentValue;
		$this->city->CurrentValue = NULL;
		$this->city->OldValue = $this->city->CurrentValue;
		$this->address->CurrentValue = NULL;
		$this->address->OldValue = $this->address->CurrentValue;
		$this->location->CurrentValue = NULL;
		$this->location->OldValue = $this->location->CurrentValue;
		$this->reports_to->CurrentValue = NULL;
		$this->reports_to->OldValue = $this->reports_to->CurrentValue;
		$this->status->CurrentValue = 1;
		$this->tax_registration->CurrentValue = NULL;
		$this->tax_registration->OldValue = $this->tax_registration->CurrentValue;
		$this->currency->CurrentValue = NULL;
		$this->currency->OldValue = $this->currency->CurrentValue;
		$this->port_sea->CurrentValue = NULL;
		$this->port_sea->OldValue = $this->port_sea->CurrentValue;
		$this->incoterm->CurrentValue = NULL;
		$this->incoterm->OldValue = $this->incoterm->CurrentValue;
		$this->port_air->CurrentValue = NULL;
		$this->port_air->OldValue = $this->port_air->CurrentValue;
		$this->type->CurrentValue = NULL;
		$this->type->OldValue = $this->type->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->uid->CurrentValue = NULL;
		$this->uid->OldValue = $this->uid->CurrentValue;
		$this->performance->CurrentValue = NULL;
		$this->performance->OldValue = $this->performance->CurrentValue;
		$this->price_percent->CurrentValue = 100;
		$this->last_login->CurrentValue = NULL;
		$this->last_login->OldValue = $this->last_login->CurrentValue;
		$this->reg_date->CurrentValue = NULL;
		$this->reg_date->OldValue = $this->reg_date->CurrentValue;
		$this->reg_device->CurrentValue = NULL;
		$this->reg_device->OldValue = $this->reg_device->CurrentValue;
		$this->device_id->CurrentValue = NULL;
		$this->device_id->OldValue = $this->device_id->CurrentValue;
		$this->device_token_id->CurrentValue = NULL;
		$this->device_token_id->OldValue = $this->device_token_id->CurrentValue;
		$this->cart_number->CurrentValue = NULL;
		$this->cart_number->OldValue = $this->cart_number->CurrentValue;
		$this->r_text->CurrentValue = NULL;
		$this->r_text->OldValue = $this->r_text->CurrentValue;
		$this->city_name->CurrentValue = NULL;
		$this->city_name->OldValue = $this->city_name->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'user_name' first before field var 'x_user_name'
		$val = $CurrentForm->hasValue("user_name") ? $CurrentForm->getValue("user_name") : $CurrentForm->getValue("x_user_name");
		if (!$this->user_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->user_name->Visible = FALSE; // Disable update for API request
			else
				$this->user_name->setFormValue($val);
		}

		// Check field name 'password' first before field var 'x_password'
		$val = $CurrentForm->hasValue("password") ? $CurrentForm->getValue("password") : $CurrentForm->getValue("x_password");
		if (!$this->password->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->password->Visible = FALSE; // Disable update for API request
			else
				$this->password->setFormValue($val);
		}

		// Check field name 'category' first before field var 'x_category'
		$val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
		if (!$this->category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->category->Visible = FALSE; // Disable update for API request
			else
				$this->category->setFormValue($val);
		}

		// Check field name 'sub_category' first before field var 'x_sub_category'
		$val = $CurrentForm->hasValue("sub_category") ? $CurrentForm->getValue("sub_category") : $CurrentForm->getValue("x_sub_category");
		if (!$this->sub_category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sub_category->Visible = FALSE; // Disable update for API request
			else
				$this->sub_category->setFormValue($val);
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'name' first before field var 'x_name'
		$val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
		if (!$this->name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->name->Visible = FALSE; // Disable update for API request
			else
				$this->name->setFormValue($val);
		}

		// Check field name 'code' first before field var 'x_code'
		$val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
		if (!$this->code->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->code->Visible = FALSE; // Disable update for API request
			else
				$this->code->setFormValue($val);
		}

		// Check field name 'seller' first before field var 'x_seller'
		$val = $CurrentForm->hasValue("seller") ? $CurrentForm->getValue("seller") : $CurrentForm->getValue("x_seller");
		if (!$this->seller->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->seller->Visible = FALSE; // Disable update for API request
			else
				$this->seller->setFormValue($val);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'country' first before field var 'x_country'
		$val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
		if (!$this->country->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->country->Visible = FALSE; // Disable update for API request
			else
				$this->country->setFormValue($val);
		}

		// Check field name 'region' first before field var 'x_region'
		$val = $CurrentForm->hasValue("region") ? $CurrentForm->getValue("region") : $CurrentForm->getValue("x_region");
		if (!$this->region->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->region->Visible = FALSE; // Disable update for API request
			else
				$this->region->setFormValue($val);
		}

		// Check field name 'city' first before field var 'x_city'
		$val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
		if (!$this->city->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->city->Visible = FALSE; // Disable update for API request
			else
				$this->city->setFormValue($val);
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address->Visible = FALSE; // Disable update for API request
			else
				$this->address->setFormValue($val);
		}

		// Check field name 'location' first before field var 'x_location'
		$val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
		if (!$this->location->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->location->Visible = FALSE; // Disable update for API request
			else
				$this->location->setFormValue($val);
		}

		// Check field name 'reports_to' first before field var 'x_reports_to'
		$val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
		if (!$this->reports_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reports_to->Visible = FALSE; // Disable update for API request
			else
				$this->reports_to->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'tax_registration' first before field var 'x_tax_registration'
		$val = $CurrentForm->hasValue("tax_registration") ? $CurrentForm->getValue("tax_registration") : $CurrentForm->getValue("x_tax_registration");
		if (!$this->tax_registration->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tax_registration->Visible = FALSE; // Disable update for API request
			else
				$this->tax_registration->setFormValue($val);
		}

		// Check field name 'currency' first before field var 'x_currency'
		$val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
		if (!$this->currency->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->currency->Visible = FALSE; // Disable update for API request
			else
				$this->currency->setFormValue($val);
		}

		// Check field name 'port_sea' first before field var 'x_port_sea'
		$val = $CurrentForm->hasValue("port_sea") ? $CurrentForm->getValue("port_sea") : $CurrentForm->getValue("x_port_sea");
		if (!$this->port_sea->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_sea->Visible = FALSE; // Disable update for API request
			else
				$this->port_sea->setFormValue($val);
		}

		// Check field name 'incoterm' first before field var 'x_incoterm'
		$val = $CurrentForm->hasValue("incoterm") ? $CurrentForm->getValue("incoterm") : $CurrentForm->getValue("x_incoterm");
		if (!$this->incoterm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->incoterm->Visible = FALSE; // Disable update for API request
			else
				$this->incoterm->setFormValue($val);
		}

		// Check field name 'port_air' first before field var 'x_port_air'
		$val = $CurrentForm->hasValue("port_air") ? $CurrentForm->getValue("port_air") : $CurrentForm->getValue("x_port_air");
		if (!$this->port_air->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_air->Visible = FALSE; // Disable update for API request
			else
				$this->port_air->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'price_percent' first before field var 'x_price_percent'
		$val = $CurrentForm->hasValue("price_percent") ? $CurrentForm->getValue("price_percent") : $CurrentForm->getValue("x_price_percent");
		if (!$this->price_percent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price_percent->Visible = FALSE; // Disable update for API request
			else
				$this->price_percent->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->user_name->CurrentValue = $this->user_name->FormValue;
		$this->password->CurrentValue = $this->password->FormValue;
		$this->category->CurrentValue = $this->category->FormValue;
		$this->sub_category->CurrentValue = $this->sub_category->FormValue;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->name->CurrentValue = $this->name->FormValue;
		$this->code->CurrentValue = $this->code->FormValue;
		$this->seller->CurrentValue = $this->seller->FormValue;
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->country->CurrentValue = $this->country->FormValue;
		$this->region->CurrentValue = $this->region->FormValue;
		$this->city->CurrentValue = $this->city->FormValue;
		$this->address->CurrentValue = $this->address->FormValue;
		$this->location->CurrentValue = $this->location->FormValue;
		$this->reports_to->CurrentValue = $this->reports_to->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->tax_registration->CurrentValue = $this->tax_registration->FormValue;
		$this->currency->CurrentValue = $this->currency->FormValue;
		$this->port_sea->CurrentValue = $this->port_sea->FormValue;
		$this->incoterm->CurrentValue = $this->incoterm->FormValue;
		$this->port_air->CurrentValue = $this->port_air->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->price_percent->CurrentValue = $this->price_percent->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->user_name->setDbValue($row['user_name']);
		$this->password->setDbValue($row['password']);
		$this->category->setDbValue($row['category']);
		$this->sub_category->setDbValue($row['sub_category']);
		$this->grp->setDbValue($row['grp']);
		$this->name->setDbValue($row['name']);
		$this->code->setDbValue($row['code']);
		$this->seller->setDbValue($row['seller']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->country->setDbValue($row['country']);
		$this->region->setDbValue($row['region']);
		$this->city->setDbValue($row['city']);
		if (array_key_exists('EV__city', $rs->fields)) {
			$this->city->VirtualValue = $rs->fields('EV__city'); // Set up virtual field value
		} else {
			$this->city->VirtualValue = ""; // Clear value
		}
		$this->address->setDbValue($row['address']);
		$this->location->setDbValue($row['location']);
		if (array_key_exists('EV__location', $rs->fields)) {
			$this->location->VirtualValue = $rs->fields('EV__location'); // Set up virtual field value
		} else {
			$this->location->VirtualValue = ""; // Clear value
		}
		$this->reports_to->setDbValue($row['reports_to']);
		$this->status->setDbValue($row['status']);
		$this->tax_registration->setDbValue($row['tax_registration']);
		$this->currency->setDbValue($row['currency']);
		$this->port_sea->setDbValue($row['port_sea']);
		$this->incoterm->setDbValue($row['incoterm']);
		$this->port_air->setDbValue($row['port_air']);
		$this->type->setDbValue($row['type']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->uid->setDbValue($row['uid']);
		$this->performance->setDbValue($row['performance']);
		$this->price_percent->setDbValue($row['price_percent']);
		$this->last_login->setDbValue($row['last_login']);
		$this->reg_date->setDbValue($row['reg_date']);
		$this->reg_device->setDbValue($row['reg_device']);
		$this->device_id->setDbValue($row['device_id']);
		$this->device_token_id->setDbValue($row['device_token_id']);
		$this->cart_number->setDbValue($row['cart_number']);
		$this->r_text->setDbValue($row['r_text']);
		$this->city_name->setDbValue($row['city_name']);
		$this->remarks->setDbValue($row['remarks']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['user_name'] = $this->user_name->CurrentValue;
		$row['password'] = $this->password->CurrentValue;
		$row['category'] = $this->category->CurrentValue;
		$row['sub_category'] = $this->sub_category->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['name'] = $this->name->CurrentValue;
		$row['code'] = $this->code->CurrentValue;
		$row['seller'] = $this->seller->CurrentValue;
		$row['mobile'] = $this->mobile->CurrentValue;
		$row['email'] = $this->_email->CurrentValue;
		$row['country'] = $this->country->CurrentValue;
		$row['region'] = $this->region->CurrentValue;
		$row['city'] = $this->city->CurrentValue;
		$row['address'] = $this->address->CurrentValue;
		$row['location'] = $this->location->CurrentValue;
		$row['reports_to'] = $this->reports_to->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['tax_registration'] = $this->tax_registration->CurrentValue;
		$row['currency'] = $this->currency->CurrentValue;
		$row['port_sea'] = $this->port_sea->CurrentValue;
		$row['incoterm'] = $this->incoterm->CurrentValue;
		$row['port_air'] = $this->port_air->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['uid'] = $this->uid->CurrentValue;
		$row['performance'] = $this->performance->CurrentValue;
		$row['price_percent'] = $this->price_percent->CurrentValue;
		$row['last_login'] = $this->last_login->CurrentValue;
		$row['reg_date'] = $this->reg_date->CurrentValue;
		$row['reg_device'] = $this->reg_device->CurrentValue;
		$row['device_id'] = $this->device_id->CurrentValue;
		$row['device_token_id'] = $this->device_token_id->CurrentValue;
		$row['cart_number'] = $this->cart_number->CurrentValue;
		$row['r_text'] = $this->r_text->CurrentValue;
		$row['city_name'] = $this->city_name->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->price_percent->FormValue == $this->price_percent->CurrentValue && is_numeric(ConvertToFloatString($this->price_percent->CurrentValue)))
			$this->price_percent->CurrentValue = ConvertToFloatString($this->price_percent->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// user_name
		// password
		// category
		// sub_category
		// grp
		// name
		// code
		// seller
		// mobile
		// email
		// country
		// region
		// city
		// address
		// location
		// reports_to
		// status
		// tax_registration
		// currency
		// port_sea
		// incoterm
		// port_air
		// type
		// operator
		// datetime
		// uid
		// performance
		// price_percent
		// last_login
		// reg_date
		// reg_device
		// device_id
		// device_token_id
		// cart_number
		// r_text
		// city_name
		// remarks

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// user_name
			$this->user_name->ViewValue = $this->user_name->CurrentValue;
			$this->user_name->ViewCustomAttributes = "";

			// password
			$this->password->ViewValue = $this->password->CurrentValue;
			$this->password->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('2', `partner_type`) and `grp` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->category->ViewValue = $this->category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// sub_category
			$curVal = strval($this->sub_category->CurrentValue);
			if ($curVal <> "") {
				$this->sub_category->ViewValue = $this->sub_category->lookupCacheOption($curVal);
				if ($this->sub_category->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('2', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->sub_category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->sub_category->ViewValue = $this->sub_category->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->sub_category->ViewValue = $this->sub_category->CurrentValue;
					}
				}
			} else {
				$this->sub_category->ViewValue = NULL;
			}
			$this->sub_category->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->grp->ViewValue->add($this->grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// seller
			$curVal = strval($this->seller->CurrentValue);
			if ($curVal <> "") {
				$this->seller->ViewValue = $this->seller->lookupCacheOption($curVal);
				if ($this->seller->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->seller->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->seller->ViewValue = $this->seller->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->seller->ViewValue = $this->seller->CurrentValue;
					}
				}
			} else {
				$this->seller->ViewValue = NULL;
			}
			$this->seller->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// country
			$curVal = strval($this->country->CurrentValue);
			if ($curVal <> "") {
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
				if ($this->country->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->country->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->country->ViewValue = $this->country->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->country->ViewValue = $this->country->CurrentValue;
					}
				}
			} else {
				$this->country->ViewValue = NULL;
			}
			$this->country->ViewCustomAttributes = "";

			// region
			$curVal = strval($this->region->CurrentValue);
			if ($curVal <> "") {
				$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
				if ($this->region->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->region->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->region->ViewValue = $this->region->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->region->ViewValue = $this->region->CurrentValue;
					}
				}
			} else {
				$this->region->ViewValue = NULL;
			}
			$this->region->ViewCustomAttributes = "";

			// city
			if ($this->city->VirtualValue <> "") {
				$this->city->ViewValue = $this->city->VirtualValue;
			} else {
				$this->city->ViewValue = $this->city->CurrentValue;
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->ViewValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->city->ViewValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->ViewValue = $this->city->CurrentValue;
					}
				}
			} else {
				$this->city->ViewValue = NULL;
			}
			}
			$this->city->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// location
			if ($this->location->VirtualValue <> "") {
				$this->location->ViewValue = $this->location->VirtualValue;
			} else {
				$this->location->ViewValue = $this->location->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->location->CurrentValue;
			$this->location->ViewValue = $this->location->displayValue($arwrk);
			}
			$this->location->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`id` > 10 and `activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->reports_to->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->reports_to->ViewValue->add($this->reports_to->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// tax_registration
			$this->tax_registration->ViewValue = $this->tax_registration->CurrentValue;
			$this->tax_registration->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// port_sea
			$curVal = strval($this->port_sea->CurrentValue);
			if ($curVal <> "") {
				$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
				if ($this->port_sea->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_sea->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_sea->ViewValue = $this->port_sea->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_sea->ViewValue = $this->port_sea->CurrentValue;
					}
				}
			} else {
				$this->port_sea->ViewValue = NULL;
			}
			$this->port_sea->ViewCustomAttributes = "";

			// incoterm
			$curVal = strval($this->incoterm->CurrentValue);
			if ($curVal <> "") {
				$this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
				if ($this->incoterm->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->incoterm->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->incoterm->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->incoterm->ViewValue->add($this->incoterm->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->incoterm->ViewValue = $this->incoterm->CurrentValue;
					}
				}
			} else {
				$this->incoterm->ViewValue = NULL;
			}
			$this->incoterm->ViewCustomAttributes = "";

			// port_air
			$curVal = strval($this->port_air->CurrentValue);
			if ($curVal <> "") {
				$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
				if ($this->port_air->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`mode`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->port_air->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->port_air->ViewValue = $this->port_air->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->port_air->ViewValue = $this->port_air->CurrentValue;
					}
				}
			} else {
				$this->port_air->ViewValue = NULL;
			}
			$this->port_air->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// performance
			$this->performance->ViewValue = $this->performance->CurrentValue;
			$this->performance->ViewValue = FormatNumber($this->performance->ViewValue, 0, -2, -2, -2);
			$this->performance->ViewCustomAttributes = "";

			// price_percent
			$this->price_percent->ViewValue = $this->price_percent->CurrentValue;
			$this->price_percent->ViewValue = FormatNumber($this->price_percent->ViewValue, 2, -2, -2, -2);
			$this->price_percent->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// user_name
			$this->user_name->LinkCustomAttributes = "";
			$this->user_name->HrefValue = "";
			$this->user_name->TooltipValue = "";

			// password
			$this->password->LinkCustomAttributes = "";
			$this->password->HrefValue = "";
			$this->password->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// sub_category
			$this->sub_category->LinkCustomAttributes = "";
			$this->sub_category->HrefValue = "";
			$this->sub_category->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";
			$this->code->TooltipValue = "";

			// seller
			$this->seller->LinkCustomAttributes = "";
			$this->seller->HrefValue = "";
			$this->seller->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";
			$this->country->TooltipValue = "";

			// region
			$this->region->LinkCustomAttributes = "";
			$this->region->HrefValue = "";
			$this->region->TooltipValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";
			$this->city->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// tax_registration
			$this->tax_registration->LinkCustomAttributes = "";
			$this->tax_registration->HrefValue = "";
			$this->tax_registration->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// port_sea
			$this->port_sea->LinkCustomAttributes = "";
			$this->port_sea->HrefValue = "";
			$this->port_sea->TooltipValue = "";

			// incoterm
			$this->incoterm->LinkCustomAttributes = "";
			$this->incoterm->HrefValue = "";
			$this->incoterm->TooltipValue = "";

			// port_air
			$this->port_air->LinkCustomAttributes = "";
			$this->port_air->HrefValue = "";
			$this->port_air->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// price_percent
			$this->price_percent->LinkCustomAttributes = "";
			$this->price_percent->HrefValue = "";
			$this->price_percent->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// user_name
			$this->user_name->EditAttrs["class"] = "form-control";
			$this->user_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->user_name->CurrentValue = HtmlDecode($this->user_name->CurrentValue);
			$this->user_name->EditValue = HtmlEncode($this->user_name->CurrentValue);
			$this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

			// password
			$this->password->EditAttrs["class"] = "form-control";
			$this->password->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->password->CurrentValue = HtmlDecode($this->password->CurrentValue);
			$this->password->EditValue = HtmlEncode($this->password->CurrentValue);
			$this->password->PlaceHolder = RemoveHtml($this->password->caption());

			// category
			$this->category->EditAttrs["class"] = "form-control";
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->CurrentValue));
			if ($curVal <> "")
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->category->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and FIND_IN_SET('2', `partner_type`) and `grp` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// sub_category
			$this->sub_category->EditAttrs["class"] = "form-control";
			$this->sub_category->EditCustomAttributes = "";
			$curVal = trim(strval($this->sub_category->CurrentValue));
			if ($curVal <> "")
				$this->sub_category->ViewValue = $this->sub_category->lookupCacheOption($curVal);
			else
				$this->sub_category->ViewValue = $this->sub_category->Lookup !== NULL && is_array($this->sub_category->Lookup->Options) ? $curVal : NULL;
			if ($this->sub_category->ViewValue !== NULL) { // Load from cache
				$this->sub_category->EditValue = array_values($this->sub_category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->sub_category->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and FIND_IN_SET('2', `partner_type`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->sub_category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->sub_category->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
			$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// code
			$this->code->EditAttrs["class"] = "form-control";
			$this->code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
			$this->code->EditValue = HtmlEncode($this->code->CurrentValue);
			$this->code->PlaceHolder = RemoveHtml($this->code->caption());

			// seller
			$this->seller->EditAttrs["class"] = "form-control";
			$this->seller->EditCustomAttributes = "";
			$curVal = trim(strval($this->seller->CurrentValue));
			if ($curVal <> "")
				$this->seller->ViewValue = $this->seller->lookupCacheOption($curVal);
			else
				$this->seller->ViewValue = $this->seller->Lookup !== NULL && is_array($this->seller->Lookup->Options) ? $curVal : NULL;
			if ($this->seller->ViewValue !== NULL) { // Load from cache
				$this->seller->EditValue = array_values($this->seller->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->seller->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->seller->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->seller->EditValue = $arwrk;
			}

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// country
			$this->country->EditAttrs["class"] = "form-control";
			$this->country->EditCustomAttributes = "";
			$curVal = trim(strval($this->country->CurrentValue));
			if ($curVal <> "")
				$this->country->ViewValue = $this->country->lookupCacheOption($curVal);
			else
				$this->country->ViewValue = $this->country->Lookup !== NULL && is_array($this->country->Lookup->Options) ? $curVal : NULL;
			if ($this->country->ViewValue !== NULL) { // Load from cache
				$this->country->EditValue = array_values($this->country->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->country->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->country->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->country->EditValue = $arwrk;
			}

			// region
			$this->region->EditAttrs["class"] = "form-control";
			$this->region->EditCustomAttributes = "";
			$curVal = trim(strval($this->region->CurrentValue));
			if ($curVal <> "")
				$this->region->ViewValue = $this->region->lookupCacheOption($curVal);
			else
				$this->region->ViewValue = $this->region->Lookup !== NULL && is_array($this->region->Lookup->Options) ? $curVal : NULL;
			if ($this->region->ViewValue !== NULL) { // Load from cache
				$this->region->EditValue = array_values($this->region->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->region->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->region->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->region->EditValue = $arwrk;
			}

			// city
			$this->city->EditAttrs["class"] = "form-control";
			$this->city->EditCustomAttributes = "";
			$this->city->EditValue = HtmlEncode($this->city->CurrentValue);
			$curVal = strval($this->city->CurrentValue);
			if ($curVal <> "") {
				$this->city->EditValue = $this->city->lookupCacheOption($curVal);
				if ($this->city->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->city->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->city->EditValue = $this->city->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->city->EditValue = HtmlEncode($this->city->CurrentValue);
					}
				}
			} else {
				$this->city->EditValue = NULL;
			}
			$this->city->PlaceHolder = RemoveHtml($this->city->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->location->CurrentValue = HtmlDecode($this->location->CurrentValue);
			$this->location->EditValue = HtmlEncode($this->location->CurrentValue);
			$this->location->PlaceHolder = RemoveHtml($this->location->caption());

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->CurrentValue));
			if ($curVal <> "")
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`id` > 10 and `activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// tax_registration
			$this->tax_registration->EditAttrs["class"] = "form-control";
			$this->tax_registration->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->tax_registration->CurrentValue = HtmlDecode($this->tax_registration->CurrentValue);
			$this->tax_registration->EditValue = HtmlEncode($this->tax_registration->CurrentValue);
			$this->tax_registration->PlaceHolder = RemoveHtml($this->tax_registration->caption());

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->CurrentValue));
			if ($curVal <> "")
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// port_sea
			$this->port_sea->EditAttrs["class"] = "form-control";
			$this->port_sea->EditCustomAttributes = "";
			$curVal = trim(strval($this->port_sea->CurrentValue));
			if ($curVal <> "")
				$this->port_sea->ViewValue = $this->port_sea->lookupCacheOption($curVal);
			else
				$this->port_sea->ViewValue = $this->port_sea->Lookup !== NULL && is_array($this->port_sea->Lookup->Options) ? $curVal : NULL;
			if ($this->port_sea->ViewValue !== NULL) { // Load from cache
				$this->port_sea->EditValue = array_values($this->port_sea->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->port_sea->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`mode`=0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_sea->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->port_sea->EditValue = $arwrk;
			}

			// incoterm
			$this->incoterm->EditAttrs["class"] = "form-control";
			$this->incoterm->EditCustomAttributes = "";
			$curVal = trim(strval($this->incoterm->CurrentValue));
			if ($curVal <> "")
				$this->incoterm->ViewValue = $this->incoterm->lookupCacheOption($curVal);
			else
				$this->incoterm->ViewValue = $this->incoterm->Lookup !== NULL && is_array($this->incoterm->Lookup->Options) ? $curVal : NULL;
			if ($this->incoterm->ViewValue !== NULL) { // Load from cache
				$this->incoterm->EditValue = array_values($this->incoterm->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->incoterm->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->incoterm->EditValue = $arwrk;
			}

			// port_air
			$this->port_air->EditAttrs["class"] = "form-control";
			$this->port_air->EditCustomAttributes = "";
			$curVal = trim(strval($this->port_air->CurrentValue));
			if ($curVal <> "")
				$this->port_air->ViewValue = $this->port_air->lookupCacheOption($curVal);
			else
				$this->port_air->ViewValue = $this->port_air->Lookup !== NULL && is_array($this->port_air->Lookup->Options) ? $curVal : NULL;
			if ($this->port_air->ViewValue !== NULL) { // Load from cache
				$this->port_air->EditValue = array_values($this->port_air->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->port_air->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`mode`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->port_air->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->port_air->EditValue = $arwrk;
			}

			// operator
			// datetime
			// price_percent

			$this->price_percent->EditAttrs["class"] = "form-control";
			$this->price_percent->EditCustomAttributes = "";
			$this->price_percent->EditValue = HtmlEncode($this->price_percent->CurrentValue);
			$this->price_percent->PlaceHolder = RemoveHtml($this->price_percent->caption());
			if (strval($this->price_percent->EditValue) <> "" && is_numeric($this->price_percent->EditValue))
				$this->price_percent->EditValue = FormatNumber($this->price_percent->EditValue, -2, -2, -2, -2);

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// Add refer script
			// user_name

			$this->user_name->LinkCustomAttributes = "";
			$this->user_name->HrefValue = "";

			// password
			$this->password->LinkCustomAttributes = "";
			$this->password->HrefValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";

			// sub_category
			$this->sub_category->LinkCustomAttributes = "";
			$this->sub_category->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";

			// code
			$this->code->LinkCustomAttributes = "";
			$this->code->HrefValue = "";

			// seller
			$this->seller->LinkCustomAttributes = "";
			$this->seller->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// country
			$this->country->LinkCustomAttributes = "";
			$this->country->HrefValue = "";

			// region
			$this->region->LinkCustomAttributes = "";
			$this->region->HrefValue = "";

			// city
			$this->city->LinkCustomAttributes = "";
			$this->city->HrefValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// tax_registration
			$this->tax_registration->LinkCustomAttributes = "";
			$this->tax_registration->HrefValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";

			// port_sea
			$this->port_sea->LinkCustomAttributes = "";
			$this->port_sea->HrefValue = "";

			// incoterm
			$this->incoterm->LinkCustomAttributes = "";
			$this->incoterm->HrefValue = "";

			// port_air
			$this->port_air->LinkCustomAttributes = "";
			$this->port_air->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// price_percent
			$this->price_percent->LinkCustomAttributes = "";
			$this->price_percent->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->user_name->Required) {
			if (!$this->user_name->IsDetailKey && $this->user_name->FormValue != NULL && $this->user_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->user_name->caption(), $this->user_name->RequiredErrorMessage));
			}
		}
		if ($this->password->Required) {
			if (!$this->password->IsDetailKey && $this->password->FormValue != NULL && $this->password->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->password->caption(), $this->password->RequiredErrorMessage));
			}
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->sub_category->Required) {
			if (!$this->sub_category->IsDetailKey && $this->sub_category->FormValue != NULL && $this->sub_category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sub_category->caption(), $this->sub_category->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if ($this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->name->Required) {
			if (!$this->name->IsDetailKey && $this->name->FormValue != NULL && $this->name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
			}
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->seller->Required) {
			if (!$this->seller->IsDetailKey && $this->seller->FormValue != NULL && $this->seller->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->seller->caption(), $this->seller->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if ($this->country->Required) {
			if (!$this->country->IsDetailKey && $this->country->FormValue != NULL && $this->country->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
			}
		}
		if ($this->region->Required) {
			if (!$this->region->IsDetailKey && $this->region->FormValue != NULL && $this->region->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->region->caption(), $this->region->RequiredErrorMessage));
			}
		}
		if ($this->city->Required) {
			if (!$this->city->IsDetailKey && $this->city->FormValue != NULL && $this->city->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
			}
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->location->Required) {
			if (!$this->location->IsDetailKey && $this->location->FormValue != NULL && $this->location->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if ($this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->tax_registration->Required) {
			if (!$this->tax_registration->IsDetailKey && $this->tax_registration->FormValue != NULL && $this->tax_registration->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tax_registration->caption(), $this->tax_registration->RequiredErrorMessage));
			}
		}
		if ($this->currency->Required) {
			if (!$this->currency->IsDetailKey && $this->currency->FormValue != NULL && $this->currency->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
			}
		}
		if ($this->port_sea->Required) {
			if (!$this->port_sea->IsDetailKey && $this->port_sea->FormValue != NULL && $this->port_sea->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_sea->caption(), $this->port_sea->RequiredErrorMessage));
			}
		}
		if ($this->incoterm->Required) {
			if ($this->incoterm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->incoterm->caption(), $this->incoterm->RequiredErrorMessage));
			}
		}
		if ($this->port_air->Required) {
			if (!$this->port_air->IsDetailKey && $this->port_air->FormValue != NULL && $this->port_air->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_air->caption(), $this->port_air->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->uid->Required) {
			if (!$this->uid->IsDetailKey && $this->uid->FormValue != NULL && $this->uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
			}
		}
		if ($this->performance->Required) {
			if (!$this->performance->IsDetailKey && $this->performance->FormValue != NULL && $this->performance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->performance->caption(), $this->performance->RequiredErrorMessage));
			}
		}
		if ($this->price_percent->Required) {
			if (!$this->price_percent->IsDetailKey && $this->price_percent->FormValue != NULL && $this->price_percent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price_percent->caption(), $this->price_percent->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->price_percent->FormValue)) {
			AddMessage($FormError, $this->price_percent->errorMessage());
		}
		if ($this->last_login->Required) {
			if (!$this->last_login->IsDetailKey && $this->last_login->FormValue != NULL && $this->last_login->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_login->caption(), $this->last_login->RequiredErrorMessage));
			}
		}
		if ($this->reg_date->Required) {
			if (!$this->reg_date->IsDetailKey && $this->reg_date->FormValue != NULL && $this->reg_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reg_date->caption(), $this->reg_date->RequiredErrorMessage));
			}
		}
		if ($this->reg_device->Required) {
			if (!$this->reg_device->IsDetailKey && $this->reg_device->FormValue != NULL && $this->reg_device->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reg_device->caption(), $this->reg_device->RequiredErrorMessage));
			}
		}
		if ($this->device_id->Required) {
			if (!$this->device_id->IsDetailKey && $this->device_id->FormValue != NULL && $this->device_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->device_id->caption(), $this->device_id->RequiredErrorMessage));
			}
		}
		if ($this->device_token_id->Required) {
			if (!$this->device_token_id->IsDetailKey && $this->device_token_id->FormValue != NULL && $this->device_token_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->device_token_id->caption(), $this->device_token_id->RequiredErrorMessage));
			}
		}
		if ($this->cart_number->Required) {
			if (!$this->cart_number->IsDetailKey && $this->cart_number->FormValue != NULL && $this->cart_number->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_number->caption(), $this->cart_number->RequiredErrorMessage));
			}
		}
		if ($this->r_text->Required) {
			if (!$this->r_text->IsDetailKey && $this->r_text->FormValue != NULL && $this->r_text->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_text->caption(), $this->r_text->RequiredErrorMessage));
			}
		}
		if ($this->city_name->Required) {
			if (!$this->city_name->IsDetailKey && $this->city_name->FormValue != NULL && $this->city_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->city_name->caption(), $this->city_name->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->code->CurrentValue <> "") { // Check field with unique index
			$filter = "(code = '" . AdjustSql($this->code->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->code->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->code->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// user_name
		$this->user_name->setDbValueDef($rsnew, $this->user_name->CurrentValue, NULL, FALSE);

		// password
		$this->password->setDbValueDef($rsnew, $this->password->CurrentValue, NULL, FALSE);

		// category
		$this->category->setDbValueDef($rsnew, $this->category->CurrentValue, 0, FALSE);

		// sub_category
		$this->sub_category->setDbValueDef($rsnew, $this->sub_category->CurrentValue, NULL, FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// name
		$this->name->setDbValueDef($rsnew, $this->name->CurrentValue, "", FALSE);

		// code
		$this->code->setDbValueDef($rsnew, $this->code->CurrentValue, NULL, FALSE);

		// seller
		$this->seller->setDbValueDef($rsnew, $this->seller->CurrentValue, NULL, strval($this->seller->CurrentValue) == "");

		// mobile
		$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, FALSE);

		// email
		$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, FALSE);

		// country
		$this->country->setDbValueDef($rsnew, $this->country->CurrentValue, NULL, FALSE);

		// region
		$this->region->setDbValueDef($rsnew, $this->region->CurrentValue, NULL, FALSE);

		// city
		$this->city->setDbValueDef($rsnew, $this->city->CurrentValue, NULL, FALSE);

		// address
		$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, NULL, FALSE);

		// location
		$this->location->setDbValueDef($rsnew, $this->location->CurrentValue, NULL, FALSE);

		// reports_to
		$this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, "", FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, FALSE);

		// tax_registration
		$this->tax_registration->setDbValueDef($rsnew, $this->tax_registration->CurrentValue, NULL, FALSE);

		// currency
		$this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, NULL, FALSE);

		// port_sea
		$this->port_sea->setDbValueDef($rsnew, $this->port_sea->CurrentValue, NULL, FALSE);

		// incoterm
		$this->incoterm->setDbValueDef($rsnew, $this->incoterm->CurrentValue, NULL, FALSE);

		// port_air
		$this->port_air->setDbValueDef($rsnew, $this->port_air->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// price_percent
		$this->price_percent->setDbValueDef($rsnew, $this->price_percent->CurrentValue, NULL, strval($this->price_percent->CurrentValue) == "");

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("buyerlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('2', `partner_type`) and `grp` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_sub_category":
					$lookupFilter = function() {
						return "`status`=1 and FIND_IN_SET('2', `partner_type`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_seller":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`id` > 10 and `activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_sea":
					$lookupFilter = function() {
						return "`mode`=0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_port_air":
					$lookupFilter = function() {
						return "`mode`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_category":
							break;
						case "x_sub_category":
							break;
						case "x_grp":
							break;
						case "x_seller":
							break;
						case "x_country":
							break;
						case "x_region":
							break;
						case "x_city":
							break;
						case "x_location":
							break;
						case "x_reports_to":
							break;
						case "x_currency":
							break;
						case "x_port_sea":
							break;
						case "x_incoterm":
							break;
						case "x_port_air":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'buyer');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>