<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for carpet_setup
 */
class carpet_setup extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $cs_min_width;
	public $cs_min_qty;
	public $payment_sqm;
	public $process_byepass;
	public $jc_bom_wastage;
	public $bom_1000;
	public $batch_authorized_id;
	public $tufting_plan_sgrp;
	public $tufting_plan_loom_group;
	public $jc_weeks;
	public $required_material_overall_update;
	public $jc_material_issue;
	public $operator;
	public $datetime;
	public $jc_qr;
	public $tufting_performance_percent;
	public $jc_mrlot;
	public $batch_pp_id;
	public $tufting_plan_active;
	public $max_jobcard;
	public $jc_pending_delete_days;
	public $payment_sqm_byepass_category;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'carpet_setup';
		$this->TableName = 'carpet_setup';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`carpet_setup`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('carpet_setup', 'carpet_setup', 'x_id', 'id', '`id`', '`id`', 16, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// cs_min_width
		$this->cs_min_width = new DbField('carpet_setup', 'carpet_setup', 'x_cs_min_width', 'cs_min_width', '`cs_min_width`', '`cs_min_width`', 131, -1, FALSE, '`cs_min_width`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cs_min_width->Required = TRUE; // Required field
		$this->cs_min_width->Sortable = TRUE; // Allow sort
		$this->cs_min_width->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cs_min_width'] = &$this->cs_min_width;

		// cs_min_qty
		$this->cs_min_qty = new DbField('carpet_setup', 'carpet_setup', 'x_cs_min_qty', 'cs_min_qty', '`cs_min_qty`', '`cs_min_qty`', 2, -1, FALSE, '`cs_min_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cs_min_qty->Required = TRUE; // Required field
		$this->cs_min_qty->Sortable = TRUE; // Allow sort
		$this->cs_min_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['cs_min_qty'] = &$this->cs_min_qty;

		// payment_sqm
		$this->payment_sqm = new DbField('carpet_setup', 'carpet_setup', 'x_payment_sqm', 'payment_sqm', '`payment_sqm`', '`payment_sqm`', 200, -1, FALSE, '`payment_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment_sqm->Nullable = FALSE; // NOT NULL field
		$this->payment_sqm->Required = TRUE; // Required field
		$this->payment_sqm->Sortable = TRUE; // Allow sort
		$this->payment_sqm->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment_sqm->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment_sqm->Lookup = new Lookup('payment_sqm', 'carpet_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->payment_sqm->OptionCount = 2;
		$this->fields['payment_sqm'] = &$this->payment_sqm;

		// process_byepass
		$this->process_byepass = new DbField('carpet_setup', 'carpet_setup', 'x_process_byepass', 'process_byepass', '`process_byepass`', '`process_byepass`', 17, -1, FALSE, '`process_byepass`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->process_byepass->Nullable = FALSE; // NOT NULL field
		$this->process_byepass->Required = TRUE; // Required field
		$this->process_byepass->Sortable = TRUE; // Allow sort
		$this->process_byepass->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->process_byepass->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->process_byepass->Lookup = new Lookup('process_byepass', 'carpet_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->process_byepass->OptionCount = 2;
		$this->process_byepass->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['process_byepass'] = &$this->process_byepass;

		// jc_bom_wastage
		$this->jc_bom_wastage = new DbField('carpet_setup', 'carpet_setup', 'x_jc_bom_wastage', 'jc_bom_wastage', '`jc_bom_wastage`', '`jc_bom_wastage`', 17, -1, FALSE, '`jc_bom_wastage`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->jc_bom_wastage->Nullable = FALSE; // NOT NULL field
		$this->jc_bom_wastage->Required = TRUE; // Required field
		$this->jc_bom_wastage->Sortable = TRUE; // Allow sort
		$this->jc_bom_wastage->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->jc_bom_wastage->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->jc_bom_wastage->Lookup = new Lookup('jc_bom_wastage', 'carpet_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->jc_bom_wastage->OptionCount = 2;
		$this->jc_bom_wastage->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_bom_wastage'] = &$this->jc_bom_wastage;

		// bom_1000
		$this->bom_1000 = new DbField('carpet_setup', 'carpet_setup', 'x_bom_1000', 'bom_1000', '`bom_1000`', '`bom_1000`', 17, -1, FALSE, '`bom_1000`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bom_1000->Nullable = FALSE; // NOT NULL field
		$this->bom_1000->Required = TRUE; // Required field
		$this->bom_1000->Sortable = TRUE; // Allow sort
		$this->bom_1000->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['bom_1000'] = &$this->bom_1000;

		// batch_authorized_id
		$this->batch_authorized_id = new DbField('carpet_setup', 'carpet_setup', 'x_batch_authorized_id', 'batch_authorized_id', '`batch_authorized_id`', '`batch_authorized_id`', 200, -1, FALSE, '`batch_authorized_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_authorized_id->Sortable = TRUE; // Allow sort
		$this->batch_authorized_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_authorized_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_authorized_id->Lookup = new Lookup('batch_authorized_id', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->batch_authorized_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_authorized_id'] = &$this->batch_authorized_id;

		// tufting_plan_sgrp
		$this->tufting_plan_sgrp = new DbField('carpet_setup', 'carpet_setup', 'x_tufting_plan_sgrp', 'tufting_plan_sgrp', '`tufting_plan_sgrp`', '`tufting_plan_sgrp`', 200, -1, FALSE, '`tufting_plan_sgrp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->tufting_plan_sgrp->Required = TRUE; // Required field
		$this->tufting_plan_sgrp->Sortable = TRUE; // Allow sort
		$this->tufting_plan_sgrp->SelectMultiple = TRUE; // Multiple select
		$this->tufting_plan_sgrp->Lookup = new Lookup('tufting_plan_sgrp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->fields['tufting_plan_sgrp'] = &$this->tufting_plan_sgrp;

		// tufting_plan_loom_group
		$this->tufting_plan_loom_group = new DbField('carpet_setup', 'carpet_setup', 'x_tufting_plan_loom_group', 'tufting_plan_loom_group', '`tufting_plan_loom_group`', '`tufting_plan_loom_group`', 2, -1, FALSE, '`tufting_plan_loom_group`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->tufting_plan_loom_group->Required = TRUE; // Required field
		$this->tufting_plan_loom_group->Sortable = TRUE; // Allow sort
		$this->tufting_plan_loom_group->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->tufting_plan_loom_group->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->tufting_plan_loom_group->Lookup = new Lookup('tufting_plan_loom_group', 'carpet_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->tufting_plan_loom_group->OptionCount = 2;
		$this->tufting_plan_loom_group->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tufting_plan_loom_group'] = &$this->tufting_plan_loom_group;

		// jc_weeks
		$this->jc_weeks = new DbField('carpet_setup', 'carpet_setup', 'x_jc_weeks', 'jc_weeks', '`jc_weeks`', '`jc_weeks`', 18, -1, FALSE, '`jc_weeks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_weeks->Nullable = FALSE; // NOT NULL field
		$this->jc_weeks->Sortable = TRUE; // Allow sort
		$this->jc_weeks->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_weeks'] = &$this->jc_weeks;

		// required_material_overall_update
		$this->required_material_overall_update = new DbField('carpet_setup', 'carpet_setup', 'x_required_material_overall_update', 'required_material_overall_update', '`required_material_overall_update`', '`required_material_overall_update`', 18, -1, FALSE, '`required_material_overall_update`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->required_material_overall_update->Nullable = FALSE; // NOT NULL field
		$this->required_material_overall_update->Sortable = TRUE; // Allow sort
		$this->required_material_overall_update->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['required_material_overall_update'] = &$this->required_material_overall_update;

		// jc_material_issue
		$this->jc_material_issue = new DbField('carpet_setup', 'carpet_setup', 'x_jc_material_issue', 'jc_material_issue', '`jc_material_issue`', '`jc_material_issue`', 16, -1, FALSE, '`jc_material_issue`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->jc_material_issue->Sortable = TRUE; // Allow sort
		$this->jc_material_issue->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->jc_material_issue->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->jc_material_issue->Lookup = new Lookup('jc_material_issue', 'carpet_setup', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->jc_material_issue->OptionCount = 3;
		$this->jc_material_issue->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_material_issue'] = &$this->jc_material_issue;

		// operator
		$this->operator = new DbField('carpet_setup', 'carpet_setup', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('carpet_setup', 'carpet_setup', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// jc_qr
		$this->jc_qr = new DbField('carpet_setup', 'carpet_setup', 'x_jc_qr', 'jc_qr', '`jc_qr`', '`jc_qr`', 17, -1, FALSE, '`jc_qr`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_qr->Nullable = FALSE; // NOT NULL field
		$this->jc_qr->Required = TRUE; // Required field
		$this->jc_qr->Sortable = TRUE; // Allow sort
		$this->jc_qr->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_qr'] = &$this->jc_qr;

		// tufting_performance_percent
		$this->tufting_performance_percent = new DbField('carpet_setup', 'carpet_setup', 'x_tufting_performance_percent', 'tufting_performance_percent', '`tufting_performance_percent`', '`tufting_performance_percent`', 131, -1, FALSE, '`tufting_performance_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tufting_performance_percent->Nullable = FALSE; // NOT NULL field
		$this->tufting_performance_percent->Required = TRUE; // Required field
		$this->tufting_performance_percent->Sortable = TRUE; // Allow sort
		$this->tufting_performance_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tufting_performance_percent'] = &$this->tufting_performance_percent;

		// jc_mrlot
		$this->jc_mrlot = new DbField('carpet_setup', 'carpet_setup', 'x_jc_mrlot', 'jc_mrlot', '`jc_mrlot`', '`jc_mrlot`', 200, -1, FALSE, '`jc_mrlot`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_mrlot->Sortable = TRUE; // Allow sort
		$this->jc_mrlot->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_mrlot'] = &$this->jc_mrlot;

		// batch_pp_id
		$this->batch_pp_id = new DbField('carpet_setup', 'carpet_setup', 'x_batch_pp_id', 'batch_pp_id', '`batch_pp_id`', '`batch_pp_id`', 2, -1, FALSE, '`batch_pp_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->batch_pp_id->Sortable = TRUE; // Allow sort
		$this->batch_pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_pp_id'] = &$this->batch_pp_id;

		// tufting_plan_active
		$this->tufting_plan_active = new DbField('carpet_setup', 'carpet_setup', 'x_tufting_plan_active', 'tufting_plan_active', '`tufting_plan_active`', '`tufting_plan_active`', 16, -1, FALSE, '`tufting_plan_active`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tufting_plan_active->Sortable = TRUE; // Allow sort
		$this->tufting_plan_active->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['tufting_plan_active'] = &$this->tufting_plan_active;

		// max_jobcard
		$this->max_jobcard = new DbField('carpet_setup', 'carpet_setup', 'x_max_jobcard', 'max_jobcard', '`max_jobcard`', '`max_jobcard`', 16, -1, FALSE, '`max_jobcard`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->max_jobcard->Nullable = FALSE; // NOT NULL field
		$this->max_jobcard->Sortable = TRUE; // Allow sort
		$this->max_jobcard->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['max_jobcard'] = &$this->max_jobcard;

		// jc_pending_delete_days
		$this->jc_pending_delete_days = new DbField('carpet_setup', 'carpet_setup', 'x_jc_pending_delete_days', 'jc_pending_delete_days', '`jc_pending_delete_days`', '`jc_pending_delete_days`', 18, -1, FALSE, '`jc_pending_delete_days`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_pending_delete_days->Nullable = FALSE; // NOT NULL field
		$this->jc_pending_delete_days->Sortable = TRUE; // Allow sort
		$this->jc_pending_delete_days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_pending_delete_days'] = &$this->jc_pending_delete_days;

		// payment_sqm_byepass_category
		$this->payment_sqm_byepass_category = new DbField('carpet_setup', 'carpet_setup', 'x_payment_sqm_byepass_category', 'payment_sqm_byepass_category', '`payment_sqm_byepass_category`', '`payment_sqm_byepass_category`', 200, -1, FALSE, '`payment_sqm_byepass_category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->payment_sqm_byepass_category->Nullable = FALSE; // NOT NULL field
		$this->payment_sqm_byepass_category->Sortable = TRUE; // Allow sort
		$this->fields['payment_sqm_byepass_category'] = &$this->payment_sqm_byepass_category;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`carpet_setup`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->cs_min_width->DbValue = $row['cs_min_width'];
		$this->cs_min_qty->DbValue = $row['cs_min_qty'];
		$this->payment_sqm->DbValue = $row['payment_sqm'];
		$this->process_byepass->DbValue = $row['process_byepass'];
		$this->jc_bom_wastage->DbValue = $row['jc_bom_wastage'];
		$this->bom_1000->DbValue = $row['bom_1000'];
		$this->batch_authorized_id->DbValue = $row['batch_authorized_id'];
		$this->tufting_plan_sgrp->DbValue = $row['tufting_plan_sgrp'];
		$this->tufting_plan_loom_group->DbValue = $row['tufting_plan_loom_group'];
		$this->jc_weeks->DbValue = $row['jc_weeks'];
		$this->required_material_overall_update->DbValue = $row['required_material_overall_update'];
		$this->jc_material_issue->DbValue = $row['jc_material_issue'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->jc_qr->DbValue = $row['jc_qr'];
		$this->tufting_performance_percent->DbValue = $row['tufting_performance_percent'];
		$this->jc_mrlot->DbValue = $row['jc_mrlot'];
		$this->batch_pp_id->DbValue = $row['batch_pp_id'];
		$this->tufting_plan_active->DbValue = $row['tufting_plan_active'];
		$this->max_jobcard->DbValue = $row['max_jobcard'];
		$this->jc_pending_delete_days->DbValue = $row['jc_pending_delete_days'];
		$this->payment_sqm_byepass_category->DbValue = $row['payment_sqm_byepass_category'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "carpet_setuplist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "carpet_setupview.php")
			return $Language->phrase("View");
		elseif ($pageName == "carpet_setupedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "carpet_setupadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "carpet_setuplist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("carpet_setupview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("carpet_setupview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "carpet_setupadd.php?" . $this->getUrlParm($parm);
		else
			$url = "carpet_setupadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("carpet_setupedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("carpet_setupadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("carpet_setupdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->cs_min_width->setDbValue($rs->fields('cs_min_width'));
		$this->cs_min_qty->setDbValue($rs->fields('cs_min_qty'));
		$this->payment_sqm->setDbValue($rs->fields('payment_sqm'));
		$this->process_byepass->setDbValue($rs->fields('process_byepass'));
		$this->jc_bom_wastage->setDbValue($rs->fields('jc_bom_wastage'));
		$this->bom_1000->setDbValue($rs->fields('bom_1000'));
		$this->batch_authorized_id->setDbValue($rs->fields('batch_authorized_id'));
		$this->tufting_plan_sgrp->setDbValue($rs->fields('tufting_plan_sgrp'));
		$this->tufting_plan_loom_group->setDbValue($rs->fields('tufting_plan_loom_group'));
		$this->jc_weeks->setDbValue($rs->fields('jc_weeks'));
		$this->required_material_overall_update->setDbValue($rs->fields('required_material_overall_update'));
		$this->jc_material_issue->setDbValue($rs->fields('jc_material_issue'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->jc_qr->setDbValue($rs->fields('jc_qr'));
		$this->tufting_performance_percent->setDbValue($rs->fields('tufting_performance_percent'));
		$this->jc_mrlot->setDbValue($rs->fields('jc_mrlot'));
		$this->batch_pp_id->setDbValue($rs->fields('batch_pp_id'));
		$this->tufting_plan_active->setDbValue($rs->fields('tufting_plan_active'));
		$this->max_jobcard->setDbValue($rs->fields('max_jobcard'));
		$this->jc_pending_delete_days->setDbValue($rs->fields('jc_pending_delete_days'));
		$this->payment_sqm_byepass_category->setDbValue($rs->fields('payment_sqm_byepass_category'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// cs_min_width
		// cs_min_qty
		// payment_sqm
		// process_byepass
		// jc_bom_wastage
		// bom_1000
		// batch_authorized_id
		// tufting_plan_sgrp
		// tufting_plan_loom_group
		// jc_weeks
		// required_material_overall_update
		// jc_material_issue
		// operator
		// datetime

		$this->datetime->CellCssStyle = "white-space: nowrap;";

		// jc_qr
		// tufting_performance_percent
		// jc_mrlot
		// batch_pp_id
		// tufting_plan_active
		// max_jobcard
		// jc_pending_delete_days
		// payment_sqm_byepass_category
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// cs_min_width
		$this->cs_min_width->ViewValue = $this->cs_min_width->CurrentValue;
		$this->cs_min_width->ViewValue = FormatNumber($this->cs_min_width->ViewValue, 2, -2, -2, -2);
		$this->cs_min_width->ViewCustomAttributes = "";

		// cs_min_qty
		$this->cs_min_qty->ViewValue = $this->cs_min_qty->CurrentValue;
		$this->cs_min_qty->ViewValue = FormatNumber($this->cs_min_qty->ViewValue, 0, -2, -2, -2);
		$this->cs_min_qty->ViewCustomAttributes = "";

		// payment_sqm
		if (strval($this->payment_sqm->CurrentValue) <> "") {
			$this->payment_sqm->ViewValue = $this->payment_sqm->optionCaption($this->payment_sqm->CurrentValue);
		} else {
			$this->payment_sqm->ViewValue = NULL;
		}
		$this->payment_sqm->ViewCustomAttributes = "";

		// process_byepass
		if (strval($this->process_byepass->CurrentValue) <> "") {
			$this->process_byepass->ViewValue = $this->process_byepass->optionCaption($this->process_byepass->CurrentValue);
		} else {
			$this->process_byepass->ViewValue = NULL;
		}
		$this->process_byepass->ViewCustomAttributes = "";

		// jc_bom_wastage
		if (strval($this->jc_bom_wastage->CurrentValue) <> "") {
			$this->jc_bom_wastage->ViewValue = $this->jc_bom_wastage->optionCaption($this->jc_bom_wastage->CurrentValue);
		} else {
			$this->jc_bom_wastage->ViewValue = NULL;
		}
		$this->jc_bom_wastage->ViewCustomAttributes = "";

		// bom_1000
		$this->bom_1000->ViewValue = $this->bom_1000->CurrentValue;
		$this->bom_1000->ViewValue = FormatNumber($this->bom_1000->ViewValue, 0, -2, -2, -2);
		$this->bom_1000->ViewCustomAttributes = "";

		// batch_authorized_id
		$curVal = strval($this->batch_authorized_id->CurrentValue);
		if ($curVal <> "") {
			$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->lookupCacheOption($curVal);
			if ($this->batch_authorized_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_authorized_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->CurrentValue;
				}
			}
		} else {
			$this->batch_authorized_id->ViewValue = NULL;
		}
		$this->batch_authorized_id->ViewCustomAttributes = "";

		// tufting_plan_sgrp
		$curVal = strval($this->tufting_plan_sgrp->CurrentValue);
		if ($curVal <> "") {
			$this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->lookupCacheOption($curVal);
			if ($this->tufting_plan_sgrp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->tufting_plan_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->tufting_plan_sgrp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->tufting_plan_sgrp->ViewValue->add($this->tufting_plan_sgrp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->CurrentValue;
				}
			}
		} else {
			$this->tufting_plan_sgrp->ViewValue = NULL;
		}
		$this->tufting_plan_sgrp->ViewCustomAttributes = "";

		// tufting_plan_loom_group
		if (strval($this->tufting_plan_loom_group->CurrentValue) <> "") {
			$this->tufting_plan_loom_group->ViewValue = $this->tufting_plan_loom_group->optionCaption($this->tufting_plan_loom_group->CurrentValue);
		} else {
			$this->tufting_plan_loom_group->ViewValue = NULL;
		}
		$this->tufting_plan_loom_group->ViewCustomAttributes = "";

		// jc_weeks
		$this->jc_weeks->ViewValue = $this->jc_weeks->CurrentValue;
		$this->jc_weeks->ViewValue = FormatNumber($this->jc_weeks->ViewValue, 0, -2, -2, -2);
		$this->jc_weeks->ViewCustomAttributes = "";

		// required_material_overall_update
		$this->required_material_overall_update->ViewValue = $this->required_material_overall_update->CurrentValue;
		$this->required_material_overall_update->ViewValue = FormatNumber($this->required_material_overall_update->ViewValue, 0, -2, -2, -2);
		$this->required_material_overall_update->ViewCustomAttributes = "";

		// jc_material_issue
		if (strval($this->jc_material_issue->CurrentValue) <> "") {
			$this->jc_material_issue->ViewValue = $this->jc_material_issue->optionCaption($this->jc_material_issue->CurrentValue);
		} else {
			$this->jc_material_issue->ViewValue = NULL;
		}
		$this->jc_material_issue->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// jc_qr
		$this->jc_qr->ViewValue = $this->jc_qr->CurrentValue;
		$this->jc_qr->ViewValue = FormatNumber($this->jc_qr->ViewValue, 0, -2, -2, -2);
		$this->jc_qr->ViewCustomAttributes = "";

		// tufting_performance_percent
		$this->tufting_performance_percent->ViewValue = $this->tufting_performance_percent->CurrentValue;
		$this->tufting_performance_percent->ViewValue = FormatNumber($this->tufting_performance_percent->ViewValue, 2, -2, -2, -2);
		$this->tufting_performance_percent->ViewCustomAttributes = "";

		// jc_mrlot
		$this->jc_mrlot->ViewValue = $this->jc_mrlot->CurrentValue;
		$this->jc_mrlot->ViewCustomAttributes = "";

		// batch_pp_id
		$this->batch_pp_id->ViewValue = $this->batch_pp_id->CurrentValue;
		$this->batch_pp_id->ViewValue = FormatNumber($this->batch_pp_id->ViewValue, 0, -2, -2, -2);
		$this->batch_pp_id->ViewCustomAttributes = "";

		// tufting_plan_active
		$this->tufting_plan_active->ViewValue = $this->tufting_plan_active->CurrentValue;
		$this->tufting_plan_active->ViewValue = FormatNumber($this->tufting_plan_active->ViewValue, 0, -2, -2, -2);
		$this->tufting_plan_active->ViewCustomAttributes = "";

		// max_jobcard
		$this->max_jobcard->ViewValue = $this->max_jobcard->CurrentValue;
		$this->max_jobcard->ViewValue = FormatNumber($this->max_jobcard->ViewValue, 0, -2, -2, -2);
		$this->max_jobcard->ViewCustomAttributes = "";

		// jc_pending_delete_days
		$this->jc_pending_delete_days->ViewValue = $this->jc_pending_delete_days->CurrentValue;
		$this->jc_pending_delete_days->ViewValue = FormatNumber($this->jc_pending_delete_days->ViewValue, 0, -2, -2, -2);
		$this->jc_pending_delete_days->ViewCustomAttributes = "";

		// payment_sqm_byepass_category
		$this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->CurrentValue;
		$this->payment_sqm_byepass_category->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// cs_min_width
		$this->cs_min_width->LinkCustomAttributes = "";
		$this->cs_min_width->HrefValue = "";
		$this->cs_min_width->TooltipValue = "";

		// cs_min_qty
		$this->cs_min_qty->LinkCustomAttributes = "";
		$this->cs_min_qty->HrefValue = "";
		$this->cs_min_qty->TooltipValue = "";

		// payment_sqm
		$this->payment_sqm->LinkCustomAttributes = "";
		$this->payment_sqm->HrefValue = "";
		$this->payment_sqm->TooltipValue = "";

		// process_byepass
		$this->process_byepass->LinkCustomAttributes = "";
		$this->process_byepass->HrefValue = "";
		$this->process_byepass->TooltipValue = "";

		// jc_bom_wastage
		$this->jc_bom_wastage->LinkCustomAttributes = "";
		$this->jc_bom_wastage->HrefValue = "";
		$this->jc_bom_wastage->TooltipValue = "";

		// bom_1000
		$this->bom_1000->LinkCustomAttributes = "";
		$this->bom_1000->HrefValue = "";
		$this->bom_1000->TooltipValue = "";

		// batch_authorized_id
		$this->batch_authorized_id->LinkCustomAttributes = "";
		$this->batch_authorized_id->HrefValue = "";
		$this->batch_authorized_id->TooltipValue = "";

		// tufting_plan_sgrp
		$this->tufting_plan_sgrp->LinkCustomAttributes = "";
		$this->tufting_plan_sgrp->HrefValue = "";
		$this->tufting_plan_sgrp->TooltipValue = "";

		// tufting_plan_loom_group
		$this->tufting_plan_loom_group->LinkCustomAttributes = "";
		$this->tufting_plan_loom_group->HrefValue = "";
		$this->tufting_plan_loom_group->TooltipValue = "";

		// jc_weeks
		$this->jc_weeks->LinkCustomAttributes = "";
		$this->jc_weeks->HrefValue = "";
		$this->jc_weeks->TooltipValue = "";

		// required_material_overall_update
		$this->required_material_overall_update->LinkCustomAttributes = "";
		$this->required_material_overall_update->HrefValue = "";
		$this->required_material_overall_update->TooltipValue = "";

		// jc_material_issue
		$this->jc_material_issue->LinkCustomAttributes = "";
		$this->jc_material_issue->HrefValue = "";
		$this->jc_material_issue->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// jc_qr
		$this->jc_qr->LinkCustomAttributes = "";
		$this->jc_qr->HrefValue = "";
		$this->jc_qr->TooltipValue = "";

		// tufting_performance_percent
		$this->tufting_performance_percent->LinkCustomAttributes = "";
		$this->tufting_performance_percent->HrefValue = "";
		$this->tufting_performance_percent->TooltipValue = "";

		// jc_mrlot
		$this->jc_mrlot->LinkCustomAttributes = "";
		$this->jc_mrlot->HrefValue = "";
		$this->jc_mrlot->TooltipValue = "";

		// batch_pp_id
		$this->batch_pp_id->LinkCustomAttributes = "";
		$this->batch_pp_id->HrefValue = "";
		$this->batch_pp_id->TooltipValue = "";

		// tufting_plan_active
		$this->tufting_plan_active->LinkCustomAttributes = "";
		$this->tufting_plan_active->HrefValue = "";
		$this->tufting_plan_active->TooltipValue = "";

		// max_jobcard
		$this->max_jobcard->LinkCustomAttributes = "";
		$this->max_jobcard->HrefValue = "";
		$this->max_jobcard->TooltipValue = "";

		// jc_pending_delete_days
		$this->jc_pending_delete_days->LinkCustomAttributes = "";
		$this->jc_pending_delete_days->HrefValue = "";
		$this->jc_pending_delete_days->TooltipValue = "";

		// payment_sqm_byepass_category
		$this->payment_sqm_byepass_category->LinkCustomAttributes = "";
		$this->payment_sqm_byepass_category->HrefValue = "";
		$this->payment_sqm_byepass_category->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// cs_min_width
		$this->cs_min_width->EditAttrs["class"] = "form-control";
		$this->cs_min_width->EditCustomAttributes = "";
		$this->cs_min_width->EditValue = $this->cs_min_width->CurrentValue;
		$this->cs_min_width->PlaceHolder = RemoveHtml($this->cs_min_width->caption());
		if (strval($this->cs_min_width->EditValue) <> "" && is_numeric($this->cs_min_width->EditValue))
			$this->cs_min_width->EditValue = FormatNumber($this->cs_min_width->EditValue, -2, -2, -2, -2);

		// cs_min_qty
		$this->cs_min_qty->EditAttrs["class"] = "form-control";
		$this->cs_min_qty->EditCustomAttributes = "";
		$this->cs_min_qty->EditValue = $this->cs_min_qty->CurrentValue;
		$this->cs_min_qty->PlaceHolder = RemoveHtml($this->cs_min_qty->caption());

		// payment_sqm
		$this->payment_sqm->EditAttrs["class"] = "form-control";
		$this->payment_sqm->EditCustomAttributes = "";
		$this->payment_sqm->EditValue = $this->payment_sqm->options(TRUE);

		// process_byepass
		$this->process_byepass->EditAttrs["class"] = "form-control";
		$this->process_byepass->EditCustomAttributes = "";
		$this->process_byepass->EditValue = $this->process_byepass->options(TRUE);

		// jc_bom_wastage
		$this->jc_bom_wastage->EditAttrs["class"] = "form-control";
		$this->jc_bom_wastage->EditCustomAttributes = "";
		$this->jc_bom_wastage->EditValue = $this->jc_bom_wastage->options(TRUE);

		// bom_1000
		$this->bom_1000->EditAttrs["class"] = "form-control";
		$this->bom_1000->EditCustomAttributes = "";
		$this->bom_1000->EditValue = $this->bom_1000->CurrentValue;
		$this->bom_1000->PlaceHolder = RemoveHtml($this->bom_1000->caption());

		// batch_authorized_id
		$this->batch_authorized_id->EditAttrs["class"] = "form-control";
		$this->batch_authorized_id->EditCustomAttributes = "";

		// tufting_plan_sgrp
		$this->tufting_plan_sgrp->EditAttrs["class"] = "form-control";
		$this->tufting_plan_sgrp->EditCustomAttributes = "";

		// tufting_plan_loom_group
		$this->tufting_plan_loom_group->EditAttrs["class"] = "form-control";
		$this->tufting_plan_loom_group->EditCustomAttributes = "";
		$this->tufting_plan_loom_group->EditValue = $this->tufting_plan_loom_group->options(TRUE);

		// jc_weeks
		$this->jc_weeks->EditAttrs["class"] = "form-control";
		$this->jc_weeks->EditCustomAttributes = "";
		$this->jc_weeks->EditValue = $this->jc_weeks->CurrentValue;
		$this->jc_weeks->PlaceHolder = RemoveHtml($this->jc_weeks->caption());

		// required_material_overall_update
		$this->required_material_overall_update->EditAttrs["class"] = "form-control";
		$this->required_material_overall_update->EditCustomAttributes = "";
		$this->required_material_overall_update->EditValue = $this->required_material_overall_update->CurrentValue;
		$this->required_material_overall_update->PlaceHolder = RemoveHtml($this->required_material_overall_update->caption());

		// jc_material_issue
		$this->jc_material_issue->EditAttrs["class"] = "form-control";
		$this->jc_material_issue->EditCustomAttributes = "";
		$this->jc_material_issue->EditValue = $this->jc_material_issue->options(TRUE);

		// operator
		// datetime
		// jc_qr

		$this->jc_qr->EditAttrs["class"] = "form-control";
		$this->jc_qr->EditCustomAttributes = "";
		$this->jc_qr->EditValue = $this->jc_qr->CurrentValue;
		$this->jc_qr->PlaceHolder = RemoveHtml($this->jc_qr->caption());

		// tufting_performance_percent
		$this->tufting_performance_percent->EditAttrs["class"] = "form-control";
		$this->tufting_performance_percent->EditCustomAttributes = "";
		$this->tufting_performance_percent->EditValue = $this->tufting_performance_percent->CurrentValue;
		$this->tufting_performance_percent->PlaceHolder = RemoveHtml($this->tufting_performance_percent->caption());
		if (strval($this->tufting_performance_percent->EditValue) <> "" && is_numeric($this->tufting_performance_percent->EditValue))
			$this->tufting_performance_percent->EditValue = FormatNumber($this->tufting_performance_percent->EditValue, -2, -2, -2, -2);

		// jc_mrlot
		$this->jc_mrlot->EditAttrs["class"] = "form-control";
		$this->jc_mrlot->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->jc_mrlot->CurrentValue = HtmlDecode($this->jc_mrlot->CurrentValue);
		$this->jc_mrlot->EditValue = $this->jc_mrlot->CurrentValue;
		$this->jc_mrlot->PlaceHolder = RemoveHtml($this->jc_mrlot->caption());

		// batch_pp_id
		$this->batch_pp_id->EditAttrs["class"] = "form-control";
		$this->batch_pp_id->EditCustomAttributes = "";
		$this->batch_pp_id->EditValue = $this->batch_pp_id->CurrentValue;
		$this->batch_pp_id->PlaceHolder = RemoveHtml($this->batch_pp_id->caption());

		// tufting_plan_active
		$this->tufting_plan_active->EditAttrs["class"] = "form-control";
		$this->tufting_plan_active->EditCustomAttributes = "";
		$this->tufting_plan_active->EditValue = $this->tufting_plan_active->CurrentValue;
		$this->tufting_plan_active->PlaceHolder = RemoveHtml($this->tufting_plan_active->caption());

		// max_jobcard
		$this->max_jobcard->EditAttrs["class"] = "form-control";
		$this->max_jobcard->EditCustomAttributes = "";
		$this->max_jobcard->EditValue = $this->max_jobcard->CurrentValue;
		$this->max_jobcard->PlaceHolder = RemoveHtml($this->max_jobcard->caption());

		// jc_pending_delete_days
		$this->jc_pending_delete_days->EditAttrs["class"] = "form-control";
		$this->jc_pending_delete_days->EditCustomAttributes = "";
		$this->jc_pending_delete_days->EditValue = $this->jc_pending_delete_days->CurrentValue;
		$this->jc_pending_delete_days->PlaceHolder = RemoveHtml($this->jc_pending_delete_days->caption());

		// payment_sqm_byepass_category
		$this->payment_sqm_byepass_category->EditAttrs["class"] = "form-control";
		$this->payment_sqm_byepass_category->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->payment_sqm_byepass_category->CurrentValue = HtmlDecode($this->payment_sqm_byepass_category->CurrentValue);
		$this->payment_sqm_byepass_category->EditValue = $this->payment_sqm_byepass_category->CurrentValue;
		$this->payment_sqm_byepass_category->PlaceHolder = RemoveHtml($this->payment_sqm_byepass_category->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->cs_min_width);
					$doc->exportCaption($this->cs_min_qty);
					$doc->exportCaption($this->payment_sqm);
					$doc->exportCaption($this->process_byepass);
					$doc->exportCaption($this->jc_bom_wastage);
					$doc->exportCaption($this->bom_1000);
					$doc->exportCaption($this->batch_authorized_id);
					$doc->exportCaption($this->tufting_plan_sgrp);
					$doc->exportCaption($this->tufting_plan_loom_group);
					$doc->exportCaption($this->jc_weeks);
					$doc->exportCaption($this->required_material_overall_update);
					$doc->exportCaption($this->jc_material_issue);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->jc_qr);
					$doc->exportCaption($this->tufting_performance_percent);
					$doc->exportCaption($this->jc_mrlot);
					$doc->exportCaption($this->batch_pp_id);
					$doc->exportCaption($this->tufting_plan_active);
					$doc->exportCaption($this->max_jobcard);
					$doc->exportCaption($this->jc_pending_delete_days);
					$doc->exportCaption($this->payment_sqm_byepass_category);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->cs_min_width);
					$doc->exportCaption($this->cs_min_qty);
					$doc->exportCaption($this->payment_sqm);
					$doc->exportCaption($this->process_byepass);
					$doc->exportCaption($this->jc_bom_wastage);
					$doc->exportCaption($this->bom_1000);
					$doc->exportCaption($this->batch_authorized_id);
					$doc->exportCaption($this->tufting_plan_sgrp);
					$doc->exportCaption($this->tufting_plan_loom_group);
					$doc->exportCaption($this->jc_weeks);
					$doc->exportCaption($this->required_material_overall_update);
					$doc->exportCaption($this->jc_material_issue);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->jc_qr);
					$doc->exportCaption($this->tufting_performance_percent);
					$doc->exportCaption($this->jc_mrlot);
					$doc->exportCaption($this->batch_pp_id);
					$doc->exportCaption($this->tufting_plan_active);
					$doc->exportCaption($this->max_jobcard);
					$doc->exportCaption($this->jc_pending_delete_days);
					$doc->exportCaption($this->payment_sqm_byepass_category);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->cs_min_width);
						$doc->exportField($this->cs_min_qty);
						$doc->exportField($this->payment_sqm);
						$doc->exportField($this->process_byepass);
						$doc->exportField($this->jc_bom_wastage);
						$doc->exportField($this->bom_1000);
						$doc->exportField($this->batch_authorized_id);
						$doc->exportField($this->tufting_plan_sgrp);
						$doc->exportField($this->tufting_plan_loom_group);
						$doc->exportField($this->jc_weeks);
						$doc->exportField($this->required_material_overall_update);
						$doc->exportField($this->jc_material_issue);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->jc_qr);
						$doc->exportField($this->tufting_performance_percent);
						$doc->exportField($this->jc_mrlot);
						$doc->exportField($this->batch_pp_id);
						$doc->exportField($this->tufting_plan_active);
						$doc->exportField($this->max_jobcard);
						$doc->exportField($this->jc_pending_delete_days);
						$doc->exportField($this->payment_sqm_byepass_category);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->cs_min_width);
						$doc->exportField($this->cs_min_qty);
						$doc->exportField($this->payment_sqm);
						$doc->exportField($this->process_byepass);
						$doc->exportField($this->jc_bom_wastage);
						$doc->exportField($this->bom_1000);
						$doc->exportField($this->batch_authorized_id);
						$doc->exportField($this->tufting_plan_sgrp);
						$doc->exportField($this->tufting_plan_loom_group);
						$doc->exportField($this->jc_weeks);
						$doc->exportField($this->required_material_overall_update);
						$doc->exportField($this->jc_material_issue);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->jc_qr);
						$doc->exportField($this->tufting_performance_percent);
						$doc->exportField($this->jc_mrlot);
						$doc->exportField($this->batch_pp_id);
						$doc->exportField($this->tufting_plan_active);
						$doc->exportField($this->max_jobcard);
						$doc->exportField($this->jc_pending_delete_days);
						$doc->exportField($this->payment_sqm_byepass_category);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>