<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class carpet_setup_edit extends carpet_setup
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'carpet_setup';

	// Page object name
	public $PageObjName = "carpet_setup_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (carpet_setup)
		if (!isset($GLOBALS["carpet_setup"]) || get_class($GLOBALS["carpet_setup"]) == PROJECT_NAMESPACE . "carpet_setup") {
			$GLOBALS["carpet_setup"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["carpet_setup"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'carpet_setup');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $carpet_setup;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($carpet_setup);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "carpet_setupview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("carpet_setuplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->cs_min_width->Visible = FALSE;
		$this->cs_min_qty->Visible = FALSE;
		$this->payment_sqm->Visible = FALSE;
		$this->process_byepass->Visible = FALSE;
		$this->jc_bom_wastage->Visible = FALSE;
		$this->bom_1000->setVisibility();
		$this->batch_authorized_id->setVisibility();
		$this->tufting_plan_sgrp->setVisibility();
		$this->tufting_plan_loom_group->setVisibility();
		$this->jc_weeks->setVisibility();
		$this->required_material_overall_update->Visible = FALSE;
		$this->jc_material_issue->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->jc_qr->setVisibility();
		$this->tufting_performance_percent->setVisibility();
		$this->jc_mrlot->setVisibility();
		$this->batch_pp_id->setVisibility();
		$this->tufting_plan_active->setVisibility();
		$this->max_jobcard->setVisibility();
		$this->jc_pending_delete_days->setVisibility();
		$this->payment_sqm_byepass_category->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->batch_authorized_id);
		$this->setupLookupOptions($this->tufting_plan_sgrp);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("carpet_setuplist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "carpet_setuplist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}

		// Check field name 'bom_1000' first before field var 'x_bom_1000'
		$val = $CurrentForm->hasValue("bom_1000") ? $CurrentForm->getValue("bom_1000") : $CurrentForm->getValue("x_bom_1000");
		if (!$this->bom_1000->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bom_1000->Visible = FALSE; // Disable update for API request
			else
				$this->bom_1000->setFormValue($val);
		}

		// Check field name 'batch_authorized_id' first before field var 'x_batch_authorized_id'
		$val = $CurrentForm->hasValue("batch_authorized_id") ? $CurrentForm->getValue("batch_authorized_id") : $CurrentForm->getValue("x_batch_authorized_id");
		if (!$this->batch_authorized_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_authorized_id->Visible = FALSE; // Disable update for API request
			else
				$this->batch_authorized_id->setFormValue($val);
		}

		// Check field name 'tufting_plan_sgrp' first before field var 'x_tufting_plan_sgrp'
		$val = $CurrentForm->hasValue("tufting_plan_sgrp") ? $CurrentForm->getValue("tufting_plan_sgrp") : $CurrentForm->getValue("x_tufting_plan_sgrp");
		if (!$this->tufting_plan_sgrp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tufting_plan_sgrp->Visible = FALSE; // Disable update for API request
			else
				$this->tufting_plan_sgrp->setFormValue($val);
		}

		// Check field name 'tufting_plan_loom_group' first before field var 'x_tufting_plan_loom_group'
		$val = $CurrentForm->hasValue("tufting_plan_loom_group") ? $CurrentForm->getValue("tufting_plan_loom_group") : $CurrentForm->getValue("x_tufting_plan_loom_group");
		if (!$this->tufting_plan_loom_group->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tufting_plan_loom_group->Visible = FALSE; // Disable update for API request
			else
				$this->tufting_plan_loom_group->setFormValue($val);
		}

		// Check field name 'jc_weeks' first before field var 'x_jc_weeks'
		$val = $CurrentForm->hasValue("jc_weeks") ? $CurrentForm->getValue("jc_weeks") : $CurrentForm->getValue("x_jc_weeks");
		if (!$this->jc_weeks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_weeks->Visible = FALSE; // Disable update for API request
			else
				$this->jc_weeks->setFormValue($val);
		}

		// Check field name 'jc_material_issue' first before field var 'x_jc_material_issue'
		$val = $CurrentForm->hasValue("jc_material_issue") ? $CurrentForm->getValue("jc_material_issue") : $CurrentForm->getValue("x_jc_material_issue");
		if (!$this->jc_material_issue->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_material_issue->Visible = FALSE; // Disable update for API request
			else
				$this->jc_material_issue->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'jc_qr' first before field var 'x_jc_qr'
		$val = $CurrentForm->hasValue("jc_qr") ? $CurrentForm->getValue("jc_qr") : $CurrentForm->getValue("x_jc_qr");
		if (!$this->jc_qr->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_qr->Visible = FALSE; // Disable update for API request
			else
				$this->jc_qr->setFormValue($val);
		}

		// Check field name 'tufting_performance_percent' first before field var 'x_tufting_performance_percent'
		$val = $CurrentForm->hasValue("tufting_performance_percent") ? $CurrentForm->getValue("tufting_performance_percent") : $CurrentForm->getValue("x_tufting_performance_percent");
		if (!$this->tufting_performance_percent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tufting_performance_percent->Visible = FALSE; // Disable update for API request
			else
				$this->tufting_performance_percent->setFormValue($val);
		}

		// Check field name 'jc_mrlot' first before field var 'x_jc_mrlot'
		$val = $CurrentForm->hasValue("jc_mrlot") ? $CurrentForm->getValue("jc_mrlot") : $CurrentForm->getValue("x_jc_mrlot");
		if (!$this->jc_mrlot->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_mrlot->Visible = FALSE; // Disable update for API request
			else
				$this->jc_mrlot->setFormValue($val);
		}

		// Check field name 'batch_pp_id' first before field var 'x_batch_pp_id'
		$val = $CurrentForm->hasValue("batch_pp_id") ? $CurrentForm->getValue("batch_pp_id") : $CurrentForm->getValue("x_batch_pp_id");
		if (!$this->batch_pp_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->batch_pp_id->Visible = FALSE; // Disable update for API request
			else
				$this->batch_pp_id->setFormValue($val);
		}

		// Check field name 'tufting_plan_active' first before field var 'x_tufting_plan_active'
		$val = $CurrentForm->hasValue("tufting_plan_active") ? $CurrentForm->getValue("tufting_plan_active") : $CurrentForm->getValue("x_tufting_plan_active");
		if (!$this->tufting_plan_active->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->tufting_plan_active->Visible = FALSE; // Disable update for API request
			else
				$this->tufting_plan_active->setFormValue($val);
		}

		// Check field name 'max_jobcard' first before field var 'x_max_jobcard'
		$val = $CurrentForm->hasValue("max_jobcard") ? $CurrentForm->getValue("max_jobcard") : $CurrentForm->getValue("x_max_jobcard");
		if (!$this->max_jobcard->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->max_jobcard->Visible = FALSE; // Disable update for API request
			else
				$this->max_jobcard->setFormValue($val);
		}

		// Check field name 'jc_pending_delete_days' first before field var 'x_jc_pending_delete_days'
		$val = $CurrentForm->hasValue("jc_pending_delete_days") ? $CurrentForm->getValue("jc_pending_delete_days") : $CurrentForm->getValue("x_jc_pending_delete_days");
		if (!$this->jc_pending_delete_days->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_pending_delete_days->Visible = FALSE; // Disable update for API request
			else
				$this->jc_pending_delete_days->setFormValue($val);
		}

		// Check field name 'payment_sqm_byepass_category' first before field var 'x_payment_sqm_byepass_category'
		$val = $CurrentForm->hasValue("payment_sqm_byepass_category") ? $CurrentForm->getValue("payment_sqm_byepass_category") : $CurrentForm->getValue("x_payment_sqm_byepass_category");
		if (!$this->payment_sqm_byepass_category->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_sqm_byepass_category->Visible = FALSE; // Disable update for API request
			else
				$this->payment_sqm_byepass_category->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->bom_1000->CurrentValue = $this->bom_1000->FormValue;
		$this->batch_authorized_id->CurrentValue = $this->batch_authorized_id->FormValue;
		$this->tufting_plan_sgrp->CurrentValue = $this->tufting_plan_sgrp->FormValue;
		$this->tufting_plan_loom_group->CurrentValue = $this->tufting_plan_loom_group->FormValue;
		$this->jc_weeks->CurrentValue = $this->jc_weeks->FormValue;
		$this->jc_material_issue->CurrentValue = $this->jc_material_issue->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->jc_qr->CurrentValue = $this->jc_qr->FormValue;
		$this->tufting_performance_percent->CurrentValue = $this->tufting_performance_percent->FormValue;
		$this->jc_mrlot->CurrentValue = $this->jc_mrlot->FormValue;
		$this->batch_pp_id->CurrentValue = $this->batch_pp_id->FormValue;
		$this->tufting_plan_active->CurrentValue = $this->tufting_plan_active->FormValue;
		$this->max_jobcard->CurrentValue = $this->max_jobcard->FormValue;
		$this->jc_pending_delete_days->CurrentValue = $this->jc_pending_delete_days->FormValue;
		$this->payment_sqm_byepass_category->CurrentValue = $this->payment_sqm_byepass_category->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->cs_min_width->setDbValue($row['cs_min_width']);
		$this->cs_min_qty->setDbValue($row['cs_min_qty']);
		$this->payment_sqm->setDbValue($row['payment_sqm']);
		$this->process_byepass->setDbValue($row['process_byepass']);
		$this->jc_bom_wastage->setDbValue($row['jc_bom_wastage']);
		$this->bom_1000->setDbValue($row['bom_1000']);
		$this->batch_authorized_id->setDbValue($row['batch_authorized_id']);
		$this->tufting_plan_sgrp->setDbValue($row['tufting_plan_sgrp']);
		$this->tufting_plan_loom_group->setDbValue($row['tufting_plan_loom_group']);
		$this->jc_weeks->setDbValue($row['jc_weeks']);
		$this->required_material_overall_update->setDbValue($row['required_material_overall_update']);
		$this->jc_material_issue->setDbValue($row['jc_material_issue']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->jc_qr->setDbValue($row['jc_qr']);
		$this->tufting_performance_percent->setDbValue($row['tufting_performance_percent']);
		$this->jc_mrlot->setDbValue($row['jc_mrlot']);
		$this->batch_pp_id->setDbValue($row['batch_pp_id']);
		$this->tufting_plan_active->setDbValue($row['tufting_plan_active']);
		$this->max_jobcard->setDbValue($row['max_jobcard']);
		$this->jc_pending_delete_days->setDbValue($row['jc_pending_delete_days']);
		$this->payment_sqm_byepass_category->setDbValue($row['payment_sqm_byepass_category']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['cs_min_width'] = NULL;
		$row['cs_min_qty'] = NULL;
		$row['payment_sqm'] = NULL;
		$row['process_byepass'] = NULL;
		$row['jc_bom_wastage'] = NULL;
		$row['bom_1000'] = NULL;
		$row['batch_authorized_id'] = NULL;
		$row['tufting_plan_sgrp'] = NULL;
		$row['tufting_plan_loom_group'] = NULL;
		$row['jc_weeks'] = NULL;
		$row['required_material_overall_update'] = NULL;
		$row['jc_material_issue'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['jc_qr'] = NULL;
		$row['tufting_performance_percent'] = NULL;
		$row['jc_mrlot'] = NULL;
		$row['batch_pp_id'] = NULL;
		$row['tufting_plan_active'] = NULL;
		$row['max_jobcard'] = NULL;
		$row['jc_pending_delete_days'] = NULL;
		$row['payment_sqm_byepass_category'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->tufting_performance_percent->FormValue == $this->tufting_performance_percent->CurrentValue && is_numeric(ConvertToFloatString($this->tufting_performance_percent->CurrentValue)))
			$this->tufting_performance_percent->CurrentValue = ConvertToFloatString($this->tufting_performance_percent->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// cs_min_width
		// cs_min_qty
		// payment_sqm
		// process_byepass
		// jc_bom_wastage
		// bom_1000
		// batch_authorized_id
		// tufting_plan_sgrp
		// tufting_plan_loom_group
		// jc_weeks
		// required_material_overall_update
		// jc_material_issue
		// operator
		// datetime
		// jc_qr
		// tufting_performance_percent
		// jc_mrlot
		// batch_pp_id
		// tufting_plan_active
		// max_jobcard
		// jc_pending_delete_days
		// payment_sqm_byepass_category

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// cs_min_width
			$this->cs_min_width->ViewValue = $this->cs_min_width->CurrentValue;
			$this->cs_min_width->ViewValue = FormatNumber($this->cs_min_width->ViewValue, 2, -2, -2, -2);
			$this->cs_min_width->ViewCustomAttributes = "";

			// cs_min_qty
			$this->cs_min_qty->ViewValue = $this->cs_min_qty->CurrentValue;
			$this->cs_min_qty->ViewValue = FormatNumber($this->cs_min_qty->ViewValue, 0, -2, -2, -2);
			$this->cs_min_qty->ViewCustomAttributes = "";

			// payment_sqm
			if (strval($this->payment_sqm->CurrentValue) <> "") {
				$this->payment_sqm->ViewValue = $this->payment_sqm->optionCaption($this->payment_sqm->CurrentValue);
			} else {
				$this->payment_sqm->ViewValue = NULL;
			}
			$this->payment_sqm->ViewCustomAttributes = "";

			// process_byepass
			if (strval($this->process_byepass->CurrentValue) <> "") {
				$this->process_byepass->ViewValue = $this->process_byepass->optionCaption($this->process_byepass->CurrentValue);
			} else {
				$this->process_byepass->ViewValue = NULL;
			}
			$this->process_byepass->ViewCustomAttributes = "";

			// jc_bom_wastage
			if (strval($this->jc_bom_wastage->CurrentValue) <> "") {
				$this->jc_bom_wastage->ViewValue = $this->jc_bom_wastage->optionCaption($this->jc_bom_wastage->CurrentValue);
			} else {
				$this->jc_bom_wastage->ViewValue = NULL;
			}
			$this->jc_bom_wastage->ViewCustomAttributes = "";

			// bom_1000
			$this->bom_1000->ViewValue = $this->bom_1000->CurrentValue;
			$this->bom_1000->ViewValue = FormatNumber($this->bom_1000->ViewValue, 0, -2, -2, -2);
			$this->bom_1000->ViewCustomAttributes = "";

			// batch_authorized_id
			$curVal = strval($this->batch_authorized_id->CurrentValue);
			if ($curVal <> "") {
				$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->lookupCacheOption($curVal);
				if ($this->batch_authorized_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_authorized_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->CurrentValue;
					}
				}
			} else {
				$this->batch_authorized_id->ViewValue = NULL;
			}
			$this->batch_authorized_id->ViewCustomAttributes = "";

			// tufting_plan_sgrp
			$curVal = strval($this->tufting_plan_sgrp->CurrentValue);
			if ($curVal <> "") {
				$this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->lookupCacheOption($curVal);
				if ($this->tufting_plan_sgrp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->tufting_plan_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->tufting_plan_sgrp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->tufting_plan_sgrp->ViewValue->add($this->tufting_plan_sgrp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->CurrentValue;
					}
				}
			} else {
				$this->tufting_plan_sgrp->ViewValue = NULL;
			}
			$this->tufting_plan_sgrp->ViewCustomAttributes = "";

			// tufting_plan_loom_group
			if (strval($this->tufting_plan_loom_group->CurrentValue) <> "") {
				$this->tufting_plan_loom_group->ViewValue = $this->tufting_plan_loom_group->optionCaption($this->tufting_plan_loom_group->CurrentValue);
			} else {
				$this->tufting_plan_loom_group->ViewValue = NULL;
			}
			$this->tufting_plan_loom_group->ViewCustomAttributes = "";

			// jc_weeks
			$this->jc_weeks->ViewValue = $this->jc_weeks->CurrentValue;
			$this->jc_weeks->ViewValue = FormatNumber($this->jc_weeks->ViewValue, 0, -2, -2, -2);
			$this->jc_weeks->ViewCustomAttributes = "";

			// required_material_overall_update
			$this->required_material_overall_update->ViewValue = $this->required_material_overall_update->CurrentValue;
			$this->required_material_overall_update->ViewValue = FormatNumber($this->required_material_overall_update->ViewValue, 0, -2, -2, -2);
			$this->required_material_overall_update->ViewCustomAttributes = "";

			// jc_material_issue
			if (strval($this->jc_material_issue->CurrentValue) <> "") {
				$this->jc_material_issue->ViewValue = $this->jc_material_issue->optionCaption($this->jc_material_issue->CurrentValue);
			} else {
				$this->jc_material_issue->ViewValue = NULL;
			}
			$this->jc_material_issue->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// jc_qr
			$this->jc_qr->ViewValue = $this->jc_qr->CurrentValue;
			$this->jc_qr->ViewValue = FormatNumber($this->jc_qr->ViewValue, 0, -2, -2, -2);
			$this->jc_qr->ViewCustomAttributes = "";

			// tufting_performance_percent
			$this->tufting_performance_percent->ViewValue = $this->tufting_performance_percent->CurrentValue;
			$this->tufting_performance_percent->ViewValue = FormatNumber($this->tufting_performance_percent->ViewValue, 2, -2, -2, -2);
			$this->tufting_performance_percent->ViewCustomAttributes = "";

			// jc_mrlot
			$this->jc_mrlot->ViewValue = $this->jc_mrlot->CurrentValue;
			$this->jc_mrlot->ViewCustomAttributes = "";

			// batch_pp_id
			$this->batch_pp_id->ViewValue = $this->batch_pp_id->CurrentValue;
			$this->batch_pp_id->ViewValue = FormatNumber($this->batch_pp_id->ViewValue, 0, -2, -2, -2);
			$this->batch_pp_id->ViewCustomAttributes = "";

			// tufting_plan_active
			$this->tufting_plan_active->ViewValue = $this->tufting_plan_active->CurrentValue;
			$this->tufting_plan_active->ViewValue = FormatNumber($this->tufting_plan_active->ViewValue, 0, -2, -2, -2);
			$this->tufting_plan_active->ViewCustomAttributes = "";

			// max_jobcard
			$this->max_jobcard->ViewValue = $this->max_jobcard->CurrentValue;
			$this->max_jobcard->ViewValue = FormatNumber($this->max_jobcard->ViewValue, 0, -2, -2, -2);
			$this->max_jobcard->ViewCustomAttributes = "";

			// jc_pending_delete_days
			$this->jc_pending_delete_days->ViewValue = $this->jc_pending_delete_days->CurrentValue;
			$this->jc_pending_delete_days->ViewValue = FormatNumber($this->jc_pending_delete_days->ViewValue, 0, -2, -2, -2);
			$this->jc_pending_delete_days->ViewCustomAttributes = "";

			// payment_sqm_byepass_category
			$this->payment_sqm_byepass_category->ViewValue = $this->payment_sqm_byepass_category->CurrentValue;
			$this->payment_sqm_byepass_category->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// bom_1000
			$this->bom_1000->LinkCustomAttributes = "";
			$this->bom_1000->HrefValue = "";
			$this->bom_1000->TooltipValue = "";

			// batch_authorized_id
			$this->batch_authorized_id->LinkCustomAttributes = "";
			$this->batch_authorized_id->HrefValue = "";
			$this->batch_authorized_id->TooltipValue = "";

			// tufting_plan_sgrp
			$this->tufting_plan_sgrp->LinkCustomAttributes = "";
			$this->tufting_plan_sgrp->HrefValue = "";
			$this->tufting_plan_sgrp->TooltipValue = "";

			// tufting_plan_loom_group
			$this->tufting_plan_loom_group->LinkCustomAttributes = "";
			$this->tufting_plan_loom_group->HrefValue = "";
			$this->tufting_plan_loom_group->TooltipValue = "";

			// jc_weeks
			$this->jc_weeks->LinkCustomAttributes = "";
			$this->jc_weeks->HrefValue = "";
			$this->jc_weeks->TooltipValue = "";

			// jc_material_issue
			$this->jc_material_issue->LinkCustomAttributes = "";
			$this->jc_material_issue->HrefValue = "";
			$this->jc_material_issue->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// jc_qr
			$this->jc_qr->LinkCustomAttributes = "";
			$this->jc_qr->HrefValue = "";
			$this->jc_qr->TooltipValue = "";

			// tufting_performance_percent
			$this->tufting_performance_percent->LinkCustomAttributes = "";
			$this->tufting_performance_percent->HrefValue = "";
			$this->tufting_performance_percent->TooltipValue = "";

			// jc_mrlot
			$this->jc_mrlot->LinkCustomAttributes = "";
			$this->jc_mrlot->HrefValue = "";
			$this->jc_mrlot->TooltipValue = "";

			// batch_pp_id
			$this->batch_pp_id->LinkCustomAttributes = "";
			$this->batch_pp_id->HrefValue = "";
			$this->batch_pp_id->TooltipValue = "";

			// tufting_plan_active
			$this->tufting_plan_active->LinkCustomAttributes = "";
			$this->tufting_plan_active->HrefValue = "";
			$this->tufting_plan_active->TooltipValue = "";

			// max_jobcard
			$this->max_jobcard->LinkCustomAttributes = "";
			$this->max_jobcard->HrefValue = "";
			$this->max_jobcard->TooltipValue = "";

			// jc_pending_delete_days
			$this->jc_pending_delete_days->LinkCustomAttributes = "";
			$this->jc_pending_delete_days->HrefValue = "";
			$this->jc_pending_delete_days->TooltipValue = "";

			// payment_sqm_byepass_category
			$this->payment_sqm_byepass_category->LinkCustomAttributes = "";
			$this->payment_sqm_byepass_category->HrefValue = "";
			$this->payment_sqm_byepass_category->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// bom_1000
			$this->bom_1000->EditAttrs["class"] = "form-control";
			$this->bom_1000->EditCustomAttributes = "";
			$this->bom_1000->EditValue = HtmlEncode($this->bom_1000->CurrentValue);
			$this->bom_1000->PlaceHolder = RemoveHtml($this->bom_1000->caption());

			// batch_authorized_id
			$this->batch_authorized_id->EditAttrs["class"] = "form-control";
			$this->batch_authorized_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_authorized_id->CurrentValue));
			if ($curVal <> "")
				$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->lookupCacheOption($curVal);
			else
				$this->batch_authorized_id->ViewValue = $this->batch_authorized_id->Lookup !== NULL && is_array($this->batch_authorized_id->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_authorized_id->ViewValue !== NULL) { // Load from cache
				$this->batch_authorized_id->EditValue = array_values($this->batch_authorized_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_authorized_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_authorized_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_authorized_id->EditValue = $arwrk;
			}

			// tufting_plan_sgrp
			$this->tufting_plan_sgrp->EditAttrs["class"] = "form-control";
			$this->tufting_plan_sgrp->EditCustomAttributes = "";
			$curVal = trim(strval($this->tufting_plan_sgrp->CurrentValue));
			if ($curVal <> "")
				$this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->lookupCacheOption($curVal);
			else
				$this->tufting_plan_sgrp->ViewValue = $this->tufting_plan_sgrp->Lookup !== NULL && is_array($this->tufting_plan_sgrp->Lookup->Options) ? $curVal : NULL;
			if ($this->tufting_plan_sgrp->ViewValue !== NULL) { // Load from cache
				$this->tufting_plan_sgrp->EditValue = array_values($this->tufting_plan_sgrp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->tufting_plan_sgrp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->tufting_plan_sgrp->EditValue = $arwrk;
			}

			// tufting_plan_loom_group
			$this->tufting_plan_loom_group->EditAttrs["class"] = "form-control";
			$this->tufting_plan_loom_group->EditCustomAttributes = "";
			$this->tufting_plan_loom_group->EditValue = $this->tufting_plan_loom_group->options(TRUE);

			// jc_weeks
			$this->jc_weeks->EditAttrs["class"] = "form-control";
			$this->jc_weeks->EditCustomAttributes = "";
			$this->jc_weeks->EditValue = HtmlEncode($this->jc_weeks->CurrentValue);
			$this->jc_weeks->PlaceHolder = RemoveHtml($this->jc_weeks->caption());

			// jc_material_issue
			$this->jc_material_issue->EditAttrs["class"] = "form-control";
			$this->jc_material_issue->EditCustomAttributes = "";
			$this->jc_material_issue->EditValue = $this->jc_material_issue->options(TRUE);

			// operator
			// datetime
			// jc_qr

			$this->jc_qr->EditAttrs["class"] = "form-control";
			$this->jc_qr->EditCustomAttributes = "";
			$this->jc_qr->EditValue = HtmlEncode($this->jc_qr->CurrentValue);
			$this->jc_qr->PlaceHolder = RemoveHtml($this->jc_qr->caption());

			// tufting_performance_percent
			$this->tufting_performance_percent->EditAttrs["class"] = "form-control";
			$this->tufting_performance_percent->EditCustomAttributes = "";
			$this->tufting_performance_percent->EditValue = HtmlEncode($this->tufting_performance_percent->CurrentValue);
			$this->tufting_performance_percent->PlaceHolder = RemoveHtml($this->tufting_performance_percent->caption());
			if (strval($this->tufting_performance_percent->EditValue) <> "" && is_numeric($this->tufting_performance_percent->EditValue))
				$this->tufting_performance_percent->EditValue = FormatNumber($this->tufting_performance_percent->EditValue, -2, -2, -2, -2);

			// jc_mrlot
			$this->jc_mrlot->EditAttrs["class"] = "form-control";
			$this->jc_mrlot->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->jc_mrlot->CurrentValue = HtmlDecode($this->jc_mrlot->CurrentValue);
			$this->jc_mrlot->EditValue = HtmlEncode($this->jc_mrlot->CurrentValue);
			$this->jc_mrlot->PlaceHolder = RemoveHtml($this->jc_mrlot->caption());

			// batch_pp_id
			$this->batch_pp_id->EditAttrs["class"] = "form-control";
			$this->batch_pp_id->EditCustomAttributes = "";
			$this->batch_pp_id->EditValue = HtmlEncode($this->batch_pp_id->CurrentValue);
			$this->batch_pp_id->PlaceHolder = RemoveHtml($this->batch_pp_id->caption());

			// tufting_plan_active
			$this->tufting_plan_active->EditAttrs["class"] = "form-control";
			$this->tufting_plan_active->EditCustomAttributes = "";
			$this->tufting_plan_active->EditValue = HtmlEncode($this->tufting_plan_active->CurrentValue);
			$this->tufting_plan_active->PlaceHolder = RemoveHtml($this->tufting_plan_active->caption());

			// max_jobcard
			$this->max_jobcard->EditAttrs["class"] = "form-control";
			$this->max_jobcard->EditCustomAttributes = "";
			$this->max_jobcard->EditValue = HtmlEncode($this->max_jobcard->CurrentValue);
			$this->max_jobcard->PlaceHolder = RemoveHtml($this->max_jobcard->caption());

			// jc_pending_delete_days
			$this->jc_pending_delete_days->EditAttrs["class"] = "form-control";
			$this->jc_pending_delete_days->EditCustomAttributes = "";
			$this->jc_pending_delete_days->EditValue = HtmlEncode($this->jc_pending_delete_days->CurrentValue);
			$this->jc_pending_delete_days->PlaceHolder = RemoveHtml($this->jc_pending_delete_days->caption());

			// payment_sqm_byepass_category
			$this->payment_sqm_byepass_category->EditAttrs["class"] = "form-control";
			$this->payment_sqm_byepass_category->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->payment_sqm_byepass_category->CurrentValue = HtmlDecode($this->payment_sqm_byepass_category->CurrentValue);
			$this->payment_sqm_byepass_category->EditValue = HtmlEncode($this->payment_sqm_byepass_category->CurrentValue);
			$this->payment_sqm_byepass_category->PlaceHolder = RemoveHtml($this->payment_sqm_byepass_category->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// bom_1000
			$this->bom_1000->LinkCustomAttributes = "";
			$this->bom_1000->HrefValue = "";

			// batch_authorized_id
			$this->batch_authorized_id->LinkCustomAttributes = "";
			$this->batch_authorized_id->HrefValue = "";

			// tufting_plan_sgrp
			$this->tufting_plan_sgrp->LinkCustomAttributes = "";
			$this->tufting_plan_sgrp->HrefValue = "";

			// tufting_plan_loom_group
			$this->tufting_plan_loom_group->LinkCustomAttributes = "";
			$this->tufting_plan_loom_group->HrefValue = "";

			// jc_weeks
			$this->jc_weeks->LinkCustomAttributes = "";
			$this->jc_weeks->HrefValue = "";

			// jc_material_issue
			$this->jc_material_issue->LinkCustomAttributes = "";
			$this->jc_material_issue->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// jc_qr
			$this->jc_qr->LinkCustomAttributes = "";
			$this->jc_qr->HrefValue = "";

			// tufting_performance_percent
			$this->tufting_performance_percent->LinkCustomAttributes = "";
			$this->tufting_performance_percent->HrefValue = "";

			// jc_mrlot
			$this->jc_mrlot->LinkCustomAttributes = "";
			$this->jc_mrlot->HrefValue = "";

			// batch_pp_id
			$this->batch_pp_id->LinkCustomAttributes = "";
			$this->batch_pp_id->HrefValue = "";

			// tufting_plan_active
			$this->tufting_plan_active->LinkCustomAttributes = "";
			$this->tufting_plan_active->HrefValue = "";

			// max_jobcard
			$this->max_jobcard->LinkCustomAttributes = "";
			$this->max_jobcard->HrefValue = "";

			// jc_pending_delete_days
			$this->jc_pending_delete_days->LinkCustomAttributes = "";
			$this->jc_pending_delete_days->HrefValue = "";

			// payment_sqm_byepass_category
			$this->payment_sqm_byepass_category->LinkCustomAttributes = "";
			$this->payment_sqm_byepass_category->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id->FormValue)) {
			AddMessage($FormError, $this->id->errorMessage());
		}
		if ($this->cs_min_width->Required) {
			if (!$this->cs_min_width->IsDetailKey && $this->cs_min_width->FormValue != NULL && $this->cs_min_width->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cs_min_width->caption(), $this->cs_min_width->RequiredErrorMessage));
			}
		}
		if ($this->cs_min_qty->Required) {
			if (!$this->cs_min_qty->IsDetailKey && $this->cs_min_qty->FormValue != NULL && $this->cs_min_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cs_min_qty->caption(), $this->cs_min_qty->RequiredErrorMessage));
			}
		}
		if ($this->payment_sqm->Required) {
			if (!$this->payment_sqm->IsDetailKey && $this->payment_sqm->FormValue != NULL && $this->payment_sqm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_sqm->caption(), $this->payment_sqm->RequiredErrorMessage));
			}
		}
		if ($this->process_byepass->Required) {
			if (!$this->process_byepass->IsDetailKey && $this->process_byepass->FormValue != NULL && $this->process_byepass->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->process_byepass->caption(), $this->process_byepass->RequiredErrorMessage));
			}
		}
		if ($this->jc_bom_wastage->Required) {
			if (!$this->jc_bom_wastage->IsDetailKey && $this->jc_bom_wastage->FormValue != NULL && $this->jc_bom_wastage->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_bom_wastage->caption(), $this->jc_bom_wastage->RequiredErrorMessage));
			}
		}
		if ($this->bom_1000->Required) {
			if (!$this->bom_1000->IsDetailKey && $this->bom_1000->FormValue != NULL && $this->bom_1000->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom_1000->caption(), $this->bom_1000->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->bom_1000->FormValue)) {
			AddMessage($FormError, $this->bom_1000->errorMessage());
		}
		if ($this->batch_authorized_id->Required) {
			if (!$this->batch_authorized_id->IsDetailKey && $this->batch_authorized_id->FormValue != NULL && $this->batch_authorized_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_authorized_id->caption(), $this->batch_authorized_id->RequiredErrorMessage));
			}
		}
		if ($this->tufting_plan_sgrp->Required) {
			if ($this->tufting_plan_sgrp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tufting_plan_sgrp->caption(), $this->tufting_plan_sgrp->RequiredErrorMessage));
			}
		}
		if ($this->tufting_plan_loom_group->Required) {
			if (!$this->tufting_plan_loom_group->IsDetailKey && $this->tufting_plan_loom_group->FormValue != NULL && $this->tufting_plan_loom_group->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tufting_plan_loom_group->caption(), $this->tufting_plan_loom_group->RequiredErrorMessage));
			}
		}
		if ($this->jc_weeks->Required) {
			if (!$this->jc_weeks->IsDetailKey && $this->jc_weeks->FormValue != NULL && $this->jc_weeks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_weeks->caption(), $this->jc_weeks->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_weeks->FormValue)) {
			AddMessage($FormError, $this->jc_weeks->errorMessage());
		}
		if ($this->required_material_overall_update->Required) {
			if (!$this->required_material_overall_update->IsDetailKey && $this->required_material_overall_update->FormValue != NULL && $this->required_material_overall_update->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->required_material_overall_update->caption(), $this->required_material_overall_update->RequiredErrorMessage));
			}
		}
		if ($this->jc_material_issue->Required) {
			if (!$this->jc_material_issue->IsDetailKey && $this->jc_material_issue->FormValue != NULL && $this->jc_material_issue->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_material_issue->caption(), $this->jc_material_issue->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->jc_qr->Required) {
			if (!$this->jc_qr->IsDetailKey && $this->jc_qr->FormValue != NULL && $this->jc_qr->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_qr->caption(), $this->jc_qr->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_qr->FormValue)) {
			AddMessage($FormError, $this->jc_qr->errorMessage());
		}
		if ($this->tufting_performance_percent->Required) {
			if (!$this->tufting_performance_percent->IsDetailKey && $this->tufting_performance_percent->FormValue != NULL && $this->tufting_performance_percent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tufting_performance_percent->caption(), $this->tufting_performance_percent->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->tufting_performance_percent->FormValue)) {
			AddMessage($FormError, $this->tufting_performance_percent->errorMessage());
		}
		if ($this->jc_mrlot->Required) {
			if (!$this->jc_mrlot->IsDetailKey && $this->jc_mrlot->FormValue != NULL && $this->jc_mrlot->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_mrlot->caption(), $this->jc_mrlot->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_mrlot->FormValue)) {
			AddMessage($FormError, $this->jc_mrlot->errorMessage());
		}
		if ($this->batch_pp_id->Required) {
			if (!$this->batch_pp_id->IsDetailKey && $this->batch_pp_id->FormValue != NULL && $this->batch_pp_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_pp_id->caption(), $this->batch_pp_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->batch_pp_id->FormValue)) {
			AddMessage($FormError, $this->batch_pp_id->errorMessage());
		}
		if ($this->tufting_plan_active->Required) {
			if (!$this->tufting_plan_active->IsDetailKey && $this->tufting_plan_active->FormValue != NULL && $this->tufting_plan_active->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tufting_plan_active->caption(), $this->tufting_plan_active->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->tufting_plan_active->FormValue)) {
			AddMessage($FormError, $this->tufting_plan_active->errorMessage());
		}
		if ($this->max_jobcard->Required) {
			if (!$this->max_jobcard->IsDetailKey && $this->max_jobcard->FormValue != NULL && $this->max_jobcard->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->max_jobcard->caption(), $this->max_jobcard->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->max_jobcard->FormValue)) {
			AddMessage($FormError, $this->max_jobcard->errorMessage());
		}
		if ($this->jc_pending_delete_days->Required) {
			if (!$this->jc_pending_delete_days->IsDetailKey && $this->jc_pending_delete_days->FormValue != NULL && $this->jc_pending_delete_days->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_pending_delete_days->caption(), $this->jc_pending_delete_days->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_pending_delete_days->FormValue)) {
			AddMessage($FormError, $this->jc_pending_delete_days->errorMessage());
		}
		if ($this->payment_sqm_byepass_category->Required) {
			if (!$this->payment_sqm_byepass_category->IsDetailKey && $this->payment_sqm_byepass_category->FormValue != NULL && $this->payment_sqm_byepass_category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_sqm_byepass_category->caption(), $this->payment_sqm_byepass_category->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// id
			// bom_1000

			$this->bom_1000->setDbValueDef($rsnew, $this->bom_1000->CurrentValue, 0, $this->bom_1000->ReadOnly);

			// batch_authorized_id
			$this->batch_authorized_id->setDbValueDef($rsnew, $this->batch_authorized_id->CurrentValue, NULL, $this->batch_authorized_id->ReadOnly);

			// tufting_plan_sgrp
			$this->tufting_plan_sgrp->setDbValueDef($rsnew, $this->tufting_plan_sgrp->CurrentValue, NULL, $this->tufting_plan_sgrp->ReadOnly);

			// tufting_plan_loom_group
			$this->tufting_plan_loom_group->setDbValueDef($rsnew, $this->tufting_plan_loom_group->CurrentValue, NULL, $this->tufting_plan_loom_group->ReadOnly);

			// jc_weeks
			$this->jc_weeks->setDbValueDef($rsnew, $this->jc_weeks->CurrentValue, 0, $this->jc_weeks->ReadOnly);

			// jc_material_issue
			$this->jc_material_issue->setDbValueDef($rsnew, $this->jc_material_issue->CurrentValue, NULL, $this->jc_material_issue->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// jc_qr
			$this->jc_qr->setDbValueDef($rsnew, $this->jc_qr->CurrentValue, 0, $this->jc_qr->ReadOnly);

			// tufting_performance_percent
			$this->tufting_performance_percent->setDbValueDef($rsnew, $this->tufting_performance_percent->CurrentValue, 0, $this->tufting_performance_percent->ReadOnly);

			// jc_mrlot
			$this->jc_mrlot->setDbValueDef($rsnew, $this->jc_mrlot->CurrentValue, NULL, $this->jc_mrlot->ReadOnly);

			// batch_pp_id
			$this->batch_pp_id->setDbValueDef($rsnew, $this->batch_pp_id->CurrentValue, NULL, $this->batch_pp_id->ReadOnly);

			// tufting_plan_active
			$this->tufting_plan_active->setDbValueDef($rsnew, $this->tufting_plan_active->CurrentValue, NULL, $this->tufting_plan_active->ReadOnly);

			// max_jobcard
			$this->max_jobcard->setDbValueDef($rsnew, $this->max_jobcard->CurrentValue, 0, $this->max_jobcard->ReadOnly);

			// jc_pending_delete_days
			$this->jc_pending_delete_days->setDbValueDef($rsnew, $this->jc_pending_delete_days->CurrentValue, 0, $this->jc_pending_delete_days->ReadOnly);

			// payment_sqm_byepass_category
			$this->payment_sqm_byepass_category->setDbValueDef($rsnew, $this->payment_sqm_byepass_category->CurrentValue, "", $this->payment_sqm_byepass_category->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("carpet_setuplist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_batch_authorized_id":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_tufting_plan_sgrp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_batch_authorized_id":
							break;
						case "x_tufting_plan_sgrp":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>