<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for client_hardware_data
 */
class client_hardware_data extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $customer_grp;
	public $ref;
	public $partner_id;
	public $name_ref;
	public $city_name;
	public $area;
	public $billing_name;
	public $address;
	public $personal_ref;
	public $grp;
	public $s_grp;
	public $product;
	public $rid;
	public $rid_1;
	public $harward_code;
	public $serial_no;
	public $invoice_no;
	public $invoice_date;
	public $first_counter;
	public $guarantee;
	public $valid_till;
	public $valid_till_counter;
	public $free_service;
	public $toner_life;
	public $drum_life;
	public $developer_life;
	public $date_install;
	public $date_start;
	public $remark;
	public $status;
	public $operator;
	public $datetime;
	public $copy_average_1;
	public $copy_average_2;
	public $copy_average_3;
	public $schedule_service_type;
	public $schedule_service_interval_days;
	public $schedule_service_updated_till;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'client_hardware_data';
		$this->TableName = 'client_hardware_data';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`client_hardware_data`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('client_hardware_data', 'client_hardware_data', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// customer_grp
		$this->customer_grp = new DbField('client_hardware_data', 'client_hardware_data', 'x_customer_grp', 'customer_grp', '`customer_grp`', '`customer_grp`', 200, -1, FALSE, '`customer_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->customer_grp->Nullable = FALSE; // NOT NULL field
		$this->customer_grp->Required = TRUE; // Required field
		$this->customer_grp->Sortable = TRUE; // Allow sort
		$this->customer_grp->Lookup = new Lookup('customer_grp', 'client_category', FALSE, 'id', ["category","","",""], [], [], [], [], [], [], '`category` ASC', '');
		$this->fields['customer_grp'] = &$this->customer_grp;

		// ref
		$this->ref = new DbField('client_hardware_data', 'client_hardware_data', 'x_ref', 'ref', '`ref`', '`ref`', 200, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ref->Sortable = TRUE; // Allow sort
		$this->fields['ref'] = &$this->ref;

		// partner_id
		$this->partner_id = new DbField('client_hardware_data', 'client_hardware_data', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 18, -1, FALSE, '`EV__partner_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer', FALSE, 'id', ["name","code","mobile",""], [], [], [], [], ["city_name"], ["x_city_name"], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// name_ref
		$this->name_ref = new DbField('client_hardware_data', 'client_hardware_data', 'x_name_ref', 'name_ref', '`name_ref`', '`name_ref`', 200, -1, FALSE, '`name_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name_ref->Sortable = TRUE; // Allow sort
		$this->fields['name_ref'] = &$this->name_ref;

		// city_name
		$this->city_name = new DbField('client_hardware_data', 'client_hardware_data', 'x_city_name', 'city_name', '`city_name`', '`city_name`', 200, -1, FALSE, '`city_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->city_name->Sortable = TRUE; // Allow sort
		$this->fields['city_name'] = &$this->city_name;

		// area
		$this->area = new DbField('client_hardware_data', 'client_hardware_data', 'x_area', 'area', '`area`', '`area`', 201, -1, FALSE, '`area`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->area->Sortable = TRUE; // Allow sort
		$this->area->Lookup = new Lookup('area', 'client_hardware_data', TRUE, 'area', ["area","","",""], ["x_city_name"], [], ["city_name"], ["x_city_name"], [], [], '`area` ASC', '');
		$this->fields['area'] = &$this->area;

		// billing_name
		$this->billing_name = new DbField('client_hardware_data', 'client_hardware_data', 'x_billing_name', 'billing_name', '`billing_name`', '`billing_name`', 200, -1, FALSE, '`billing_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->billing_name->Sortable = TRUE; // Allow sort
		$this->fields['billing_name'] = &$this->billing_name;

		// address
		$this->address = new DbField('client_hardware_data', 'client_hardware_data', 'x_address', 'address', '`address`', '`address`', 201, -1, FALSE, '`address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->address->Nullable = FALSE; // NOT NULL field
		$this->address->Required = TRUE; // Required field
		$this->address->Sortable = TRUE; // Allow sort
		$this->fields['address'] = &$this->address;

		// personal_ref
		$this->personal_ref = new DbField('client_hardware_data', 'client_hardware_data', 'x_personal_ref', 'personal_ref', '`personal_ref`', '`personal_ref`', 200, -1, FALSE, '`personal_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->personal_ref->Sortable = TRUE; // Allow sort
		$this->personal_ref->Lookup = new Lookup('personal_ref', 'personal_info', FALSE, 'id', ["formal_name","work_details","mobile",""], [], [], [], [], [], [], '`formal_name` ASC', '');
		$this->fields['personal_ref'] = &$this->personal_ref;

		// grp
		$this->grp = new DbField('client_hardware_data', 'client_hardware_data', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = FALSE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp","x_rid"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('client_hardware_data', 'client_hardware_data', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = FALSE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product","x_rid"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('client_hardware_data', 'client_hardware_data', 'x_product', 'product', '`product`', '`product`', 200, -1, FALSE, '`EV__product`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = FALSE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', '_product_view', TRUE, 'id', ["product","","",""], ["x_s_grp"], ["x_rid"], ["s_grp"], ["x_s_grp"], [], [], '`product` ASC', '');
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('client_hardware_data', 'client_hardware_data', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`EV__rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = FALSE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], ["x_grp","x_s_grp","x_product"], [], ["grp","s_grp","product"], ["x_grp","x_s_grp","x_product"], ["product_code","v_00"], ["x_rid_1","x_harward_code"], '`product_code` ASC', '');
		$this->fields['rid'] = &$this->rid;

		// rid_1
		$this->rid_1 = new DbField('client_hardware_data', 'client_hardware_data', 'x_rid_1', 'rid_1', '`rid_1`', '`rid_1`', 200, -1, FALSE, '`rid_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid_1->Required = TRUE; // Required field
		$this->rid_1->Sortable = FALSE; // Allow sort
		$this->fields['rid_1'] = &$this->rid_1;

		// harward_code
		$this->harward_code = new DbField('client_hardware_data', 'client_hardware_data', 'x_harward_code', 'harward_code', '`harward_code`', '`harward_code`', 200, -1, FALSE, '`harward_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->harward_code->Required = TRUE; // Required field
		$this->harward_code->Sortable = TRUE; // Allow sort
		$this->fields['harward_code'] = &$this->harward_code;

		// serial_no
		$this->serial_no = new DbField('client_hardware_data', 'client_hardware_data', 'x_serial_no', 'serial_no', '`serial_no`', '`serial_no`', 200, -1, FALSE, '`serial_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->serial_no->Sortable = TRUE; // Allow sort
		$this->fields['serial_no'] = &$this->serial_no;

		// invoice_no
		$this->invoice_no = new DbField('client_hardware_data', 'client_hardware_data', 'x_invoice_no', 'invoice_no', '`invoice_no`', '`invoice_no`', 200, -1, FALSE, '`invoice_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_no->Sortable = TRUE; // Allow sort
		$this->fields['invoice_no'] = &$this->invoice_no;

		// invoice_date
		$this->invoice_date = new DbField('client_hardware_data', 'client_hardware_data', 'x_invoice_date', 'invoice_date', '`invoice_date`', CastDateFieldForLike('`invoice_date`', 7, "DB"), 133, 7, FALSE, '`invoice_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_date->Sortable = TRUE; // Allow sort
		$this->invoice_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['invoice_date'] = &$this->invoice_date;

		// first_counter
		$this->first_counter = new DbField('client_hardware_data', 'client_hardware_data', 'x_first_counter', 'first_counter', '`first_counter`', '`first_counter`', 19, -1, FALSE, '`first_counter`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->first_counter->Sortable = TRUE; // Allow sort
		$this->first_counter->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['first_counter'] = &$this->first_counter;

		// guarantee
		$this->guarantee = new DbField('client_hardware_data', 'client_hardware_data', 'x_guarantee', 'guarantee', '`guarantee`', '`guarantee`', 16, -1, FALSE, '`guarantee`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->guarantee->Sortable = TRUE; // Allow sort
		$this->guarantee->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->guarantee->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->guarantee->Lookup = new Lookup('guarantee', 'client_hardware_data', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->guarantee->OptionCount = 3;
		$this->guarantee->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['guarantee'] = &$this->guarantee;

		// valid_till
		$this->valid_till = new DbField('client_hardware_data', 'client_hardware_data', 'x_valid_till', 'valid_till', '`valid_till`', CastDateFieldForLike('`valid_till`', 7, "DB"), 133, 7, FALSE, '`valid_till`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->valid_till->Sortable = TRUE; // Allow sort
		$this->valid_till->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['valid_till'] = &$this->valid_till;

		// valid_till_counter
		$this->valid_till_counter = new DbField('client_hardware_data', 'client_hardware_data', 'x_valid_till_counter', 'valid_till_counter', '`valid_till_counter`', '`valid_till_counter`', 19, -1, FALSE, '`valid_till_counter`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->valid_till_counter->Sortable = TRUE; // Allow sort
		$this->valid_till_counter->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['valid_till_counter'] = &$this->valid_till_counter;

		// free_service
		$this->free_service = new DbField('client_hardware_data', 'client_hardware_data', 'x_free_service', 'free_service', '`free_service`', '`free_service`', 18, -1, FALSE, '`free_service`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->free_service->Sortable = TRUE; // Allow sort
		$this->free_service->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['free_service'] = &$this->free_service;

		// toner_life
		$this->toner_life = new DbField('client_hardware_data', 'client_hardware_data', 'x_toner_life', 'toner_life', '`toner_life`', '`toner_life`', 3, -1, FALSE, '`toner_life`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->toner_life->Sortable = TRUE; // Allow sort
		$this->toner_life->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['toner_life'] = &$this->toner_life;

		// drum_life
		$this->drum_life = new DbField('client_hardware_data', 'client_hardware_data', 'x_drum_life', 'drum_life', '`drum_life`', '`drum_life`', 3, -1, FALSE, '`drum_life`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->drum_life->Sortable = TRUE; // Allow sort
		$this->drum_life->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['drum_life'] = &$this->drum_life;

		// developer_life
		$this->developer_life = new DbField('client_hardware_data', 'client_hardware_data', 'x_developer_life', 'developer_life', '`developer_life`', '`developer_life`', 3, -1, FALSE, '`developer_life`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->developer_life->Sortable = TRUE; // Allow sort
		$this->developer_life->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['developer_life'] = &$this->developer_life;

		// date_install
		$this->date_install = new DbField('client_hardware_data', 'client_hardware_data', 'x_date_install', 'date_install', '`date_install`', CastDateFieldForLike('`date_install`', 7, "DB"), 133, 7, FALSE, '`date_install`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->date_install->Sortable = TRUE; // Allow sort
		$this->date_install->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['date_install'] = &$this->date_install;

		// date_start
		$this->date_start = new DbField('client_hardware_data', 'client_hardware_data', 'x_date_start', 'date_start', '`date_start`', CastDateFieldForLike('`date_start`', 7, "DB"), 133, 7, FALSE, '`date_start`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->date_start->Sortable = TRUE; // Allow sort
		$this->date_start->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['date_start'] = &$this->date_start;

		// remark
		$this->remark = new DbField('client_hardware_data', 'client_hardware_data', 'x_remark', 'remark', '`remark`', '`remark`', 200, -1, FALSE, '`remark`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remark->Sortable = TRUE; // Allow sort
		$this->fields['remark'] = &$this->remark;

		// status
		$this->status = new DbField('client_hardware_data', 'client_hardware_data', 'x_status', 'status', '`status`', '`status`', 18, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'client_hardware_data', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('client_hardware_data', 'client_hardware_data', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('client_hardware_data', 'client_hardware_data', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 7, "DB"), 135, 7, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// copy_average_1
		$this->copy_average_1 = new DbField('client_hardware_data', 'client_hardware_data', 'x_copy_average_1', 'copy_average_1', '`copy_average_1`', '`copy_average_1`', 19, -1, FALSE, '`copy_average_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->copy_average_1->Sortable = TRUE; // Allow sort
		$this->copy_average_1->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['copy_average_1'] = &$this->copy_average_1;

		// copy_average_2
		$this->copy_average_2 = new DbField('client_hardware_data', 'client_hardware_data', 'x_copy_average_2', 'copy_average_2', '`copy_average_2`', '`copy_average_2`', 19, -1, FALSE, '`copy_average_2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->copy_average_2->Sortable = TRUE; // Allow sort
		$this->copy_average_2->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['copy_average_2'] = &$this->copy_average_2;

		// copy_average_3
		$this->copy_average_3 = new DbField('client_hardware_data', 'client_hardware_data', 'x_copy_average_3', 'copy_average_3', '`copy_average_3`', '`copy_average_3`', 19, -1, FALSE, '`copy_average_3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->copy_average_3->Sortable = TRUE; // Allow sort
		$this->copy_average_3->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['copy_average_3'] = &$this->copy_average_3;

		// schedule_service_type
		$this->schedule_service_type = new DbField('client_hardware_data', 'client_hardware_data', 'x_schedule_service_type', 'schedule_service_type', '`schedule_service_type`', '`schedule_service_type`', 18, -1, FALSE, '`schedule_service_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->schedule_service_type->Nullable = FALSE; // NOT NULL field
		$this->schedule_service_type->Required = TRUE; // Required field
		$this->schedule_service_type->Sortable = TRUE; // Allow sort
		$this->schedule_service_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['schedule_service_type'] = &$this->schedule_service_type;

		// schedule_service_interval_days
		$this->schedule_service_interval_days = new DbField('client_hardware_data', 'client_hardware_data', 'x_schedule_service_interval_days', 'schedule_service_interval_days', '`schedule_service_interval_days`', '`schedule_service_interval_days`', 18, -1, FALSE, '`schedule_service_interval_days`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->schedule_service_interval_days->Nullable = FALSE; // NOT NULL field
		$this->schedule_service_interval_days->Required = TRUE; // Required field
		$this->schedule_service_interval_days->Sortable = TRUE; // Allow sort
		$this->schedule_service_interval_days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['schedule_service_interval_days'] = &$this->schedule_service_interval_days;

		// schedule_service_updated_till
		$this->schedule_service_updated_till = new DbField('client_hardware_data', 'client_hardware_data', 'x_schedule_service_updated_till', 'schedule_service_updated_till', '`schedule_service_updated_till`', CastDateFieldForLike('`schedule_service_updated_till`', 0, "DB"), 133, 0, FALSE, '`schedule_service_updated_till`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->schedule_service_updated_till->Nullable = FALSE; // NOT NULL field
		$this->schedule_service_updated_till->Required = TRUE; // Required field
		$this->schedule_service_updated_till->Sortable = TRUE; // Allow sort
		$this->schedule_service_updated_till->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['schedule_service_updated_till'] = &$this->schedule_service_updated_till;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`client_hardware_data`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->partner_id) . "',COALESCE(`code`,''),'" . ValueSeparator(2, $this->partner_id) . "',COALESCE(`mobile`,'')) FROM `buyer` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `client_hardware_data`.`partner_id` LIMIT 1) AS `EV__partner_id`, (SELECT DISTINCT `product` FROM `product_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `client_hardware_data`.`product` LIMIT 1) AS `EV__product`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `client_hardware_data`.`rid` LIMIT 1) AS `EV__rid` FROM `client_hardware_data`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if ($this->product->AdvancedSearch->SearchValue <> "" ||
			$this->product->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->product->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->product->VirtualExpression . " "))
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->customer_grp->DbValue = $row['customer_grp'];
		$this->ref->DbValue = $row['ref'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->name_ref->DbValue = $row['name_ref'];
		$this->city_name->DbValue = $row['city_name'];
		$this->area->DbValue = $row['area'];
		$this->billing_name->DbValue = $row['billing_name'];
		$this->address->DbValue = $row['address'];
		$this->personal_ref->DbValue = $row['personal_ref'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->rid_1->DbValue = $row['rid_1'];
		$this->harward_code->DbValue = $row['harward_code'];
		$this->serial_no->DbValue = $row['serial_no'];
		$this->invoice_no->DbValue = $row['invoice_no'];
		$this->invoice_date->DbValue = $row['invoice_date'];
		$this->first_counter->DbValue = $row['first_counter'];
		$this->guarantee->DbValue = $row['guarantee'];
		$this->valid_till->DbValue = $row['valid_till'];
		$this->valid_till_counter->DbValue = $row['valid_till_counter'];
		$this->free_service->DbValue = $row['free_service'];
		$this->toner_life->DbValue = $row['toner_life'];
		$this->drum_life->DbValue = $row['drum_life'];
		$this->developer_life->DbValue = $row['developer_life'];
		$this->date_install->DbValue = $row['date_install'];
		$this->date_start->DbValue = $row['date_start'];
		$this->remark->DbValue = $row['remark'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->copy_average_1->DbValue = $row['copy_average_1'];
		$this->copy_average_2->DbValue = $row['copy_average_2'];
		$this->copy_average_3->DbValue = $row['copy_average_3'];
		$this->schedule_service_type->DbValue = $row['schedule_service_type'];
		$this->schedule_service_interval_days->DbValue = $row['schedule_service_interval_days'];
		$this->schedule_service_updated_till->DbValue = $row['schedule_service_updated_till'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "client_hardware_datalist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "client_hardware_dataview.php")
			return $Language->phrase("View");
		elseif ($pageName == "client_hardware_dataedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "client_hardware_dataadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "client_hardware_datalist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("client_hardware_dataview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("client_hardware_dataview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "client_hardware_dataadd.php?" . $this->getUrlParm($parm);
		else
			$url = "client_hardware_dataadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("client_hardware_dataedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("client_hardware_dataadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("client_hardware_datadelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->customer_grp->setDbValue($rs->fields('customer_grp'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->name_ref->setDbValue($rs->fields('name_ref'));
		$this->city_name->setDbValue($rs->fields('city_name'));
		$this->area->setDbValue($rs->fields('area'));
		$this->billing_name->setDbValue($rs->fields('billing_name'));
		$this->address->setDbValue($rs->fields('address'));
		$this->personal_ref->setDbValue($rs->fields('personal_ref'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->rid_1->setDbValue($rs->fields('rid_1'));
		$this->harward_code->setDbValue($rs->fields('harward_code'));
		$this->serial_no->setDbValue($rs->fields('serial_no'));
		$this->invoice_no->setDbValue($rs->fields('invoice_no'));
		$this->invoice_date->setDbValue($rs->fields('invoice_date'));
		$this->first_counter->setDbValue($rs->fields('first_counter'));
		$this->guarantee->setDbValue($rs->fields('guarantee'));
		$this->valid_till->setDbValue($rs->fields('valid_till'));
		$this->valid_till_counter->setDbValue($rs->fields('valid_till_counter'));
		$this->free_service->setDbValue($rs->fields('free_service'));
		$this->toner_life->setDbValue($rs->fields('toner_life'));
		$this->drum_life->setDbValue($rs->fields('drum_life'));
		$this->developer_life->setDbValue($rs->fields('developer_life'));
		$this->date_install->setDbValue($rs->fields('date_install'));
		$this->date_start->setDbValue($rs->fields('date_start'));
		$this->remark->setDbValue($rs->fields('remark'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->copy_average_1->setDbValue($rs->fields('copy_average_1'));
		$this->copy_average_2->setDbValue($rs->fields('copy_average_2'));
		$this->copy_average_3->setDbValue($rs->fields('copy_average_3'));
		$this->schedule_service_type->setDbValue($rs->fields('schedule_service_type'));
		$this->schedule_service_interval_days->setDbValue($rs->fields('schedule_service_interval_days'));
		$this->schedule_service_updated_till->setDbValue($rs->fields('schedule_service_updated_till'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// customer_grp
		// ref
		// partner_id
		// name_ref
		// city_name
		// area
		// billing_name
		// address
		// personal_ref
		// grp

		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// product
		$this->product->CellCssStyle = "white-space: nowrap;";

		// rid
		$this->rid->CellCssStyle = "white-space: nowrap;";

		// rid_1
		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// harward_code
		// serial_no
		// invoice_no
		// invoice_date
		// first_counter
		// guarantee
		// valid_till
		// valid_till_counter
		// free_service
		// toner_life
		// drum_life
		// developer_life
		// date_install
		// date_start
		// remark
		// status
		// operator
		// datetime
		// copy_average_1
		// copy_average_2
		// copy_average_3
		// schedule_service_type
		// schedule_service_interval_days
		// schedule_service_updated_till
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// customer_grp
		$curVal = strval($this->customer_grp->CurrentValue);
		if ($curVal <> "") {
			$this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
			if ($this->customer_grp->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->customer_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->customer_grp->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
				}
			}
		} else {
			$this->customer_grp->ViewValue = NULL;
		}
		$this->customer_grp->ViewCustomAttributes = "";

		// ref
		$this->ref->ViewValue = $this->ref->CurrentValue;
		$this->ref->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// name_ref
		$this->name_ref->ViewValue = $this->name_ref->CurrentValue;
		$this->name_ref->ViewCustomAttributes = "";

		// city_name
		$this->city_name->ViewValue = $this->city_name->CurrentValue;
		$this->city_name->ViewCustomAttributes = "";

		// area
		$this->area->ViewValue = $this->area->CurrentValue;
		$arwrk = array();
		$arwrk[1] = $this->area->CurrentValue;
		$this->area->ViewValue = $this->area->displayValue($arwrk);
		$this->area->ViewCustomAttributes = "";

		// billing_name
		$this->billing_name->ViewValue = $this->billing_name->CurrentValue;
		$this->billing_name->ViewCustomAttributes = "";

		// address
		$this->address->ViewValue = $this->address->CurrentValue;
		$this->address->ViewCustomAttributes = "";

		// personal_ref
		$curVal = strval($this->personal_ref->CurrentValue);
		if ($curVal <> "") {
			$this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
			if ($this->personal_ref->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->personal_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->personal_ref->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
				}
			}
		} else {
			$this->personal_ref->ViewValue = NULL;
		}
		$this->personal_ref->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		if ($this->product->VirtualValue <> "") {
			$this->product->ViewValue = $this->product->VirtualValue;
		} else {
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		}
		$this->product->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
			$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
		$this->rid_1->ViewCustomAttributes = "";

		// harward_code
		$this->harward_code->ViewValue = $this->harward_code->CurrentValue;
		$this->harward_code->ViewCustomAttributes = "";

		// serial_no
		$this->serial_no->ViewValue = $this->serial_no->CurrentValue;
		$this->serial_no->ViewCustomAttributes = "";

		// invoice_no
		$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
		$this->invoice_no->ViewCustomAttributes = "";

		// invoice_date
		$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
		$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 7);
		$this->invoice_date->ViewCustomAttributes = "";

		// first_counter
		$this->first_counter->ViewValue = $this->first_counter->CurrentValue;
		$this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, 0, -2, -2, -2);
		$this->first_counter->ViewCustomAttributes = "";

		// guarantee
		if (strval($this->guarantee->CurrentValue) <> "") {
			$this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
		} else {
			$this->guarantee->ViewValue = NULL;
		}
		$this->guarantee->ViewCustomAttributes = "";

		// valid_till
		$this->valid_till->ViewValue = $this->valid_till->CurrentValue;
		$this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, 7);
		$this->valid_till->ViewCustomAttributes = "";

		// valid_till_counter
		$this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
		$this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, 0, -2, -2, -2);
		$this->valid_till_counter->ViewCustomAttributes = "";

		// free_service
		$this->free_service->ViewValue = $this->free_service->CurrentValue;
		$this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, 0, -2, -2, -2);
		$this->free_service->ViewCustomAttributes = "";

		// toner_life
		$this->toner_life->ViewValue = $this->toner_life->CurrentValue;
		$this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, 0, -2, -2, -2);
		$this->toner_life->ViewCustomAttributes = "";

		// drum_life
		$this->drum_life->ViewValue = $this->drum_life->CurrentValue;
		$this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, 0, -2, -2, -2);
		$this->drum_life->ViewCustomAttributes = "";

		// developer_life
		$this->developer_life->ViewValue = $this->developer_life->CurrentValue;
		$this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, 0, -2, -2, -2);
		$this->developer_life->ViewCustomAttributes = "";

		// date_install
		$this->date_install->ViewValue = $this->date_install->CurrentValue;
		$this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, 7);
		$this->date_install->ViewCustomAttributes = "";

		// date_start
		$this->date_start->ViewValue = $this->date_start->CurrentValue;
		$this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, 7);
		$this->date_start->ViewCustomAttributes = "";

		// remark
		$this->remark->ViewValue = $this->remark->CurrentValue;
		$this->remark->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
		$this->datetime->ViewCustomAttributes = "";

		// copy_average_1
		$this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
		$this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, 0, -2, -2, -2);
		$this->copy_average_1->ViewCustomAttributes = "";

		// copy_average_2
		$this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
		$this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, 0, -2, -2, -2);
		$this->copy_average_2->ViewCustomAttributes = "";

		// copy_average_3
		$this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
		$this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, 0, -2, -2, -2);
		$this->copy_average_3->ViewCustomAttributes = "";

		// schedule_service_type
		$this->schedule_service_type->ViewValue = $this->schedule_service_type->CurrentValue;
		$this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->ViewValue, 0, -2, -2, -2);
		$this->schedule_service_type->ViewCustomAttributes = "";

		// schedule_service_interval_days
		$this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
		$this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, 0, -2, -2, -2);
		$this->schedule_service_interval_days->ViewCustomAttributes = "";

		// schedule_service_updated_till
		$this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
		$this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, 0);
		$this->schedule_service_updated_till->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// customer_grp
		$this->customer_grp->LinkCustomAttributes = "";
		$this->customer_grp->HrefValue = "";
		$this->customer_grp->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		$this->partner_id->HrefValue = "";
		$this->partner_id->TooltipValue = "";

		// name_ref
		$this->name_ref->LinkCustomAttributes = "";
		$this->name_ref->HrefValue = "";
		$this->name_ref->TooltipValue = "";

		// city_name
		$this->city_name->LinkCustomAttributes = "";
		$this->city_name->HrefValue = "";
		$this->city_name->TooltipValue = "";

		// area
		$this->area->LinkCustomAttributes = "";
		$this->area->HrefValue = "";
		$this->area->TooltipValue = "";

		// billing_name
		$this->billing_name->LinkCustomAttributes = "";
		$this->billing_name->HrefValue = "";
		$this->billing_name->TooltipValue = "";

		// address
		$this->address->LinkCustomAttributes = "";
		$this->address->HrefValue = "";
		$this->address->TooltipValue = "";

		// personal_ref
		$this->personal_ref->LinkCustomAttributes = "";
		$this->personal_ref->HrefValue = "";
		$this->personal_ref->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->grp->CurrentValue)) {
			$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
			$this->grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
		} else {
			$this->grp->HrefValue = "";
		}
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		if (!EmptyValue($this->s_grp->CurrentValue)) {
			$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
			$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
		} else {
			$this->s_grp->HrefValue = "";
		}
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// rid_1
		$this->rid_1->LinkCustomAttributes = "";
		$this->rid_1->HrefValue = "";
		$this->rid_1->TooltipValue = "";

		// harward_code
		$this->harward_code->LinkCustomAttributes = "";
		$this->harward_code->HrefValue = "";
		$this->harward_code->TooltipValue = "";

		// serial_no
		$this->serial_no->LinkCustomAttributes = "";
		$this->serial_no->HrefValue = "";
		$this->serial_no->TooltipValue = "";

		// invoice_no
		$this->invoice_no->LinkCustomAttributes = "";
		$this->invoice_no->HrefValue = "";
		$this->invoice_no->TooltipValue = "";

		// invoice_date
		$this->invoice_date->LinkCustomAttributes = "";
		$this->invoice_date->HrefValue = "";
		$this->invoice_date->TooltipValue = "";

		// first_counter
		$this->first_counter->LinkCustomAttributes = "";
		$this->first_counter->HrefValue = "";
		$this->first_counter->TooltipValue = "";

		// guarantee
		$this->guarantee->LinkCustomAttributes = "";
		$this->guarantee->HrefValue = "";
		$this->guarantee->TooltipValue = "";

		// valid_till
		$this->valid_till->LinkCustomAttributes = "";
		$this->valid_till->HrefValue = "";
		$this->valid_till->TooltipValue = "";

		// valid_till_counter
		$this->valid_till_counter->LinkCustomAttributes = "";
		$this->valid_till_counter->HrefValue = "";
		$this->valid_till_counter->TooltipValue = "";

		// free_service
		$this->free_service->LinkCustomAttributes = "";
		$this->free_service->HrefValue = "";
		$this->free_service->TooltipValue = "";

		// toner_life
		$this->toner_life->LinkCustomAttributes = "";
		$this->toner_life->HrefValue = "";
		$this->toner_life->TooltipValue = "";

		// drum_life
		$this->drum_life->LinkCustomAttributes = "";
		$this->drum_life->HrefValue = "";
		$this->drum_life->TooltipValue = "";

		// developer_life
		$this->developer_life->LinkCustomAttributes = "";
		$this->developer_life->HrefValue = "";
		$this->developer_life->TooltipValue = "";

		// date_install
		$this->date_install->LinkCustomAttributes = "";
		$this->date_install->HrefValue = "";
		$this->date_install->TooltipValue = "";

		// date_start
		$this->date_start->LinkCustomAttributes = "";
		$this->date_start->HrefValue = "";
		$this->date_start->TooltipValue = "";

		// remark
		$this->remark->LinkCustomAttributes = "";
		$this->remark->HrefValue = "";
		$this->remark->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// copy_average_1
		$this->copy_average_1->LinkCustomAttributes = "";
		$this->copy_average_1->HrefValue = "";
		$this->copy_average_1->TooltipValue = "";

		// copy_average_2
		$this->copy_average_2->LinkCustomAttributes = "";
		$this->copy_average_2->HrefValue = "";
		$this->copy_average_2->TooltipValue = "";

		// copy_average_3
		$this->copy_average_3->LinkCustomAttributes = "";
		$this->copy_average_3->HrefValue = "";
		$this->copy_average_3->TooltipValue = "";

		// schedule_service_type
		$this->schedule_service_type->LinkCustomAttributes = "";
		$this->schedule_service_type->HrefValue = "";
		$this->schedule_service_type->TooltipValue = "";

		// schedule_service_interval_days
		$this->schedule_service_interval_days->LinkCustomAttributes = "";
		$this->schedule_service_interval_days->HrefValue = "";
		$this->schedule_service_interval_days->TooltipValue = "";

		// schedule_service_updated_till
		$this->schedule_service_updated_till->LinkCustomAttributes = "";
		$this->schedule_service_updated_till->HrefValue = "";
		$this->schedule_service_updated_till->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// customer_grp
		$this->customer_grp->EditCustomAttributes = "";

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
		$this->ref->EditValue = $this->ref->CurrentValue;
		$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

		// name_ref
		$this->name_ref->EditAttrs["class"] = "form-control";
		$this->name_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name_ref->CurrentValue = HtmlDecode($this->name_ref->CurrentValue);
		$this->name_ref->EditValue = $this->name_ref->CurrentValue;
		$this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

		// city_name
		$this->city_name->EditAttrs["class"] = "form-control";
		$this->city_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
		$this->city_name->EditValue = $this->city_name->CurrentValue;
		$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

		// area
		$this->area->EditAttrs["class"] = "form-control";
		$this->area->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->area->CurrentValue = HtmlDecode($this->area->CurrentValue);
		$this->area->EditValue = $this->area->CurrentValue;
		$this->area->PlaceHolder = RemoveHtml($this->area->caption());

		// billing_name
		$this->billing_name->EditAttrs["class"] = "form-control";
		$this->billing_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->billing_name->CurrentValue = HtmlDecode($this->billing_name->CurrentValue);
		$this->billing_name->EditValue = $this->billing_name->CurrentValue;
		$this->billing_name->PlaceHolder = RemoveHtml($this->billing_name->caption());

		// address
		$this->address->EditAttrs["class"] = "form-control";
		$this->address->EditCustomAttributes = "";
		$this->address->EditValue = $this->address->CurrentValue;
		$this->address->PlaceHolder = RemoveHtml($this->address->caption());

		// personal_ref
		$this->personal_ref->EditCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// rid_1
		$this->rid_1->EditAttrs["class"] = "form-control";
		$this->rid_1->EditCustomAttributes = 'ReadOnly';
		if (REMOVE_XSS)
			$this->rid_1->CurrentValue = HtmlDecode($this->rid_1->CurrentValue);
		$this->rid_1->EditValue = $this->rid_1->CurrentValue;
		$this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

		// harward_code
		$this->harward_code->EditAttrs["class"] = "form-control";
		$this->harward_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->harward_code->CurrentValue = HtmlDecode($this->harward_code->CurrentValue);
		$this->harward_code->EditValue = $this->harward_code->CurrentValue;
		$this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

		// serial_no
		$this->serial_no->EditAttrs["class"] = "form-control";
		$this->serial_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->serial_no->CurrentValue = HtmlDecode($this->serial_no->CurrentValue);
		$this->serial_no->EditValue = $this->serial_no->CurrentValue;
		$this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

		// invoice_no
		$this->invoice_no->EditAttrs["class"] = "form-control";
		$this->invoice_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
		$this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
		$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

		// invoice_date
		$this->invoice_date->EditAttrs["class"] = "form-control";
		$this->invoice_date->EditCustomAttributes = "";
		$this->invoice_date->EditValue = FormatDateTime($this->invoice_date->CurrentValue, 7);
		$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

		// first_counter
		$this->first_counter->EditAttrs["class"] = "form-control";
		$this->first_counter->EditCustomAttributes = "";
		$this->first_counter->EditValue = $this->first_counter->CurrentValue;
		$this->first_counter->PlaceHolder = RemoveHtml($this->first_counter->caption());

		// guarantee
		$this->guarantee->EditAttrs["class"] = "form-control";
		$this->guarantee->EditCustomAttributes = "";
		$this->guarantee->EditValue = $this->guarantee->options(TRUE);

		// valid_till
		$this->valid_till->EditAttrs["class"] = "form-control";
		$this->valid_till->EditCustomAttributes = "";
		$this->valid_till->EditValue = FormatDateTime($this->valid_till->CurrentValue, 7);
		$this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

		// valid_till_counter
		$this->valid_till_counter->EditAttrs["class"] = "form-control";
		$this->valid_till_counter->EditCustomAttributes = "";
		$this->valid_till_counter->EditValue = $this->valid_till_counter->CurrentValue;
		$this->valid_till_counter->PlaceHolder = RemoveHtml($this->valid_till_counter->caption());

		// free_service
		$this->free_service->EditAttrs["class"] = "form-control";
		$this->free_service->EditCustomAttributes = "";
		$this->free_service->EditValue = $this->free_service->CurrentValue;
		$this->free_service->PlaceHolder = RemoveHtml($this->free_service->caption());

		// toner_life
		$this->toner_life->EditAttrs["class"] = "form-control";
		$this->toner_life->EditCustomAttributes = "";
		$this->toner_life->EditValue = $this->toner_life->CurrentValue;
		$this->toner_life->PlaceHolder = RemoveHtml($this->toner_life->caption());

		// drum_life
		$this->drum_life->EditAttrs["class"] = "form-control";
		$this->drum_life->EditCustomAttributes = "";
		$this->drum_life->EditValue = $this->drum_life->CurrentValue;
		$this->drum_life->PlaceHolder = RemoveHtml($this->drum_life->caption());

		// developer_life
		$this->developer_life->EditAttrs["class"] = "form-control";
		$this->developer_life->EditCustomAttributes = "";
		$this->developer_life->EditValue = $this->developer_life->CurrentValue;
		$this->developer_life->PlaceHolder = RemoveHtml($this->developer_life->caption());

		// date_install
		$this->date_install->EditAttrs["class"] = "form-control";
		$this->date_install->EditCustomAttributes = "";
		$this->date_install->EditValue = FormatDateTime($this->date_install->CurrentValue, 7);
		$this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

		// date_start
		$this->date_start->EditAttrs["class"] = "form-control";
		$this->date_start->EditCustomAttributes = "";
		$this->date_start->EditValue = FormatDateTime($this->date_start->CurrentValue, 7);
		$this->date_start->PlaceHolder = RemoveHtml($this->date_start->caption());

		// remark
		$this->remark->EditAttrs["class"] = "form-control";
		$this->remark->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
		$this->remark->EditValue = $this->remark->CurrentValue;
		$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// operator
		// datetime
		// copy_average_1

		$this->copy_average_1->EditAttrs["class"] = "form-control";
		$this->copy_average_1->EditCustomAttributes = "";
		$this->copy_average_1->EditValue = $this->copy_average_1->CurrentValue;
		$this->copy_average_1->PlaceHolder = RemoveHtml($this->copy_average_1->caption());

		// copy_average_2
		$this->copy_average_2->EditAttrs["class"] = "form-control";
		$this->copy_average_2->EditCustomAttributes = "";
		$this->copy_average_2->EditValue = $this->copy_average_2->CurrentValue;
		$this->copy_average_2->PlaceHolder = RemoveHtml($this->copy_average_2->caption());

		// copy_average_3
		$this->copy_average_3->EditAttrs["class"] = "form-control";
		$this->copy_average_3->EditCustomAttributes = "";
		$this->copy_average_3->EditValue = $this->copy_average_3->CurrentValue;
		$this->copy_average_3->PlaceHolder = RemoveHtml($this->copy_average_3->caption());

		// schedule_service_type
		$this->schedule_service_type->EditAttrs["class"] = "form-control";
		$this->schedule_service_type->EditCustomAttributes = "";
		$this->schedule_service_type->EditValue = $this->schedule_service_type->CurrentValue;
		$this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

		// schedule_service_interval_days
		$this->schedule_service_interval_days->EditAttrs["class"] = "form-control";
		$this->schedule_service_interval_days->EditCustomAttributes = "";
		$this->schedule_service_interval_days->EditValue = $this->schedule_service_interval_days->CurrentValue;
		$this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());

		// schedule_service_updated_till
		$this->schedule_service_updated_till->EditAttrs["class"] = "form-control";
		$this->schedule_service_updated_till->EditCustomAttributes = "";
		$this->schedule_service_updated_till->EditValue = FormatDateTime($this->schedule_service_updated_till->CurrentValue, 8);
		$this->schedule_service_updated_till->PlaceHolder = RemoveHtml($this->schedule_service_updated_till->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->customer_grp);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->name_ref);
					$doc->exportCaption($this->city_name);
					$doc->exportCaption($this->area);
					$doc->exportCaption($this->billing_name);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->personal_ref);
					$doc->exportCaption($this->harward_code);
					$doc->exportCaption($this->serial_no);
					$doc->exportCaption($this->invoice_no);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->first_counter);
					$doc->exportCaption($this->guarantee);
					$doc->exportCaption($this->valid_till);
					$doc->exportCaption($this->valid_till_counter);
					$doc->exportCaption($this->free_service);
					$doc->exportCaption($this->toner_life);
					$doc->exportCaption($this->drum_life);
					$doc->exportCaption($this->developer_life);
					$doc->exportCaption($this->date_install);
					$doc->exportCaption($this->date_start);
					$doc->exportCaption($this->remark);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->copy_average_1);
					$doc->exportCaption($this->copy_average_2);
					$doc->exportCaption($this->copy_average_3);
					$doc->exportCaption($this->schedule_service_type);
					$doc->exportCaption($this->schedule_service_interval_days);
					$doc->exportCaption($this->schedule_service_updated_till);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->customer_grp);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->name_ref);
					$doc->exportCaption($this->city_name);
					$doc->exportCaption($this->billing_name);
					$doc->exportCaption($this->personal_ref);
					$doc->exportCaption($this->harward_code);
					$doc->exportCaption($this->serial_no);
					$doc->exportCaption($this->invoice_no);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->first_counter);
					$doc->exportCaption($this->guarantee);
					$doc->exportCaption($this->valid_till);
					$doc->exportCaption($this->valid_till_counter);
					$doc->exportCaption($this->free_service);
					$doc->exportCaption($this->toner_life);
					$doc->exportCaption($this->drum_life);
					$doc->exportCaption($this->developer_life);
					$doc->exportCaption($this->date_install);
					$doc->exportCaption($this->date_start);
					$doc->exportCaption($this->remark);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->copy_average_1);
					$doc->exportCaption($this->copy_average_2);
					$doc->exportCaption($this->copy_average_3);
					$doc->exportCaption($this->schedule_service_type);
					$doc->exportCaption($this->schedule_service_interval_days);
					$doc->exportCaption($this->schedule_service_updated_till);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->customer_grp);
						$doc->exportField($this->ref);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->name_ref);
						$doc->exportField($this->city_name);
						$doc->exportField($this->area);
						$doc->exportField($this->billing_name);
						$doc->exportField($this->address);
						$doc->exportField($this->personal_ref);
						$doc->exportField($this->harward_code);
						$doc->exportField($this->serial_no);
						$doc->exportField($this->invoice_no);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->first_counter);
						$doc->exportField($this->guarantee);
						$doc->exportField($this->valid_till);
						$doc->exportField($this->valid_till_counter);
						$doc->exportField($this->free_service);
						$doc->exportField($this->toner_life);
						$doc->exportField($this->drum_life);
						$doc->exportField($this->developer_life);
						$doc->exportField($this->date_install);
						$doc->exportField($this->date_start);
						$doc->exportField($this->remark);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->copy_average_1);
						$doc->exportField($this->copy_average_2);
						$doc->exportField($this->copy_average_3);
						$doc->exportField($this->schedule_service_type);
						$doc->exportField($this->schedule_service_interval_days);
						$doc->exportField($this->schedule_service_updated_till);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->customer_grp);
						$doc->exportField($this->ref);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->name_ref);
						$doc->exportField($this->city_name);
						$doc->exportField($this->billing_name);
						$doc->exportField($this->personal_ref);
						$doc->exportField($this->harward_code);
						$doc->exportField($this->serial_no);
						$doc->exportField($this->invoice_no);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->first_counter);
						$doc->exportField($this->guarantee);
						$doc->exportField($this->valid_till);
						$doc->exportField($this->valid_till_counter);
						$doc->exportField($this->free_service);
						$doc->exportField($this->toner_life);
						$doc->exportField($this->drum_life);
						$doc->exportField($this->developer_life);
						$doc->exportField($this->date_install);
						$doc->exportField($this->date_start);
						$doc->exportField($this->remark);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->copy_average_1);
						$doc->exportField($this->copy_average_2);
						$doc->exportField($this->copy_average_3);
						$doc->exportField($this->schedule_service_type);
						$doc->exportField($this->schedule_service_interval_days);
						$doc->exportField($this->schedule_service_updated_till);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'client_hardware_data';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'client_hardware_data';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'client_hardware_data';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'client_hardware_data';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>