<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class client_hardware_data_addopt extends client_hardware_data
{

	// Page ID
	public $PageID = "addopt";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'client_hardware_data';

	// Page object name
	public $PageObjName = "client_hardware_data_addopt";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (client_hardware_data)
		if (!isset($GLOBALS["client_hardware_data"]) || get_class($GLOBALS["client_hardware_data"]) == PROJECT_NAMESPACE . "client_hardware_data") {
			$GLOBALS["client_hardware_data"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["client_hardware_data"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'addopt');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $client_hardware_data;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($client_hardware_data);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("client_hardware_datalist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->customer_grp->setVisibility();
		$this->ref->setVisibility();
		$this->partner_id->setVisibility();
		$this->name_ref->setVisibility();
		$this->city_name->setVisibility();
		$this->area->setVisibility();
		$this->billing_name->setVisibility();
		$this->address->setVisibility();
		$this->personal_ref->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->rid->setVisibility();
		$this->rid_1->setVisibility();
		$this->harward_code->setVisibility();
		$this->serial_no->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->first_counter->setVisibility();
		$this->guarantee->setVisibility();
		$this->valid_till->setVisibility();
		$this->valid_till_counter->setVisibility();
		$this->free_service->setVisibility();
		$this->toner_life->setVisibility();
		$this->drum_life->setVisibility();
		$this->developer_life->setVisibility();
		$this->date_install->setVisibility();
		$this->date_start->setVisibility();
		$this->remark->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->copy_average_1->setVisibility();
		$this->copy_average_2->setVisibility();
		$this->copy_average_3->setVisibility();
		$this->schedule_service_type->setVisibility();
		$this->schedule_service_interval_days->setVisibility();
		$this->schedule_service_updated_till->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->customer_grp);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->area);
		$this->setupLookupOptions($this->personal_ref);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->operator);
		set_error_handler(PROJECT_NAMESPACE . "ErrorHandler");

		// Set up Breadcrumb
		//$this->setupBreadcrumb(); // Not used

		$this->loadRowValues(); // Load default values

		// Render row
		$this->RowType = ROWTYPE_ADD; // Render add type
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->customer_grp->CurrentValue = NULL;
		$this->customer_grp->OldValue = $this->customer_grp->CurrentValue;
		$this->ref->CurrentValue = NULL;
		$this->ref->OldValue = $this->ref->CurrentValue;
		$this->partner_id->CurrentValue = NULL;
		$this->partner_id->OldValue = $this->partner_id->CurrentValue;
		$this->name_ref->CurrentValue = NULL;
		$this->name_ref->OldValue = $this->name_ref->CurrentValue;
		$this->city_name->CurrentValue = NULL;
		$this->city_name->OldValue = $this->city_name->CurrentValue;
		$this->area->CurrentValue = NULL;
		$this->area->OldValue = $this->area->CurrentValue;
		$this->billing_name->CurrentValue = NULL;
		$this->billing_name->OldValue = $this->billing_name->CurrentValue;
		$this->address->CurrentValue = NULL;
		$this->address->OldValue = $this->address->CurrentValue;
		$this->personal_ref->CurrentValue = NULL;
		$this->personal_ref->OldValue = $this->personal_ref->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->rid_1->CurrentValue = NULL;
		$this->rid_1->OldValue = $this->rid_1->CurrentValue;
		$this->harward_code->CurrentValue = NULL;
		$this->harward_code->OldValue = $this->harward_code->CurrentValue;
		$this->serial_no->CurrentValue = NULL;
		$this->serial_no->OldValue = $this->serial_no->CurrentValue;
		$this->invoice_no->CurrentValue = NULL;
		$this->invoice_no->OldValue = $this->invoice_no->CurrentValue;
		$this->invoice_date->CurrentValue = NULL;
		$this->invoice_date->OldValue = $this->invoice_date->CurrentValue;
		$this->first_counter->CurrentValue = NULL;
		$this->first_counter->OldValue = $this->first_counter->CurrentValue;
		$this->guarantee->CurrentValue = NULL;
		$this->guarantee->OldValue = $this->guarantee->CurrentValue;
		$this->valid_till->CurrentValue = NULL;
		$this->valid_till->OldValue = $this->valid_till->CurrentValue;
		$this->valid_till_counter->CurrentValue = NULL;
		$this->valid_till_counter->OldValue = $this->valid_till_counter->CurrentValue;
		$this->free_service->CurrentValue = NULL;
		$this->free_service->OldValue = $this->free_service->CurrentValue;
		$this->toner_life->CurrentValue = NULL;
		$this->toner_life->OldValue = $this->toner_life->CurrentValue;
		$this->drum_life->CurrentValue = NULL;
		$this->drum_life->OldValue = $this->drum_life->CurrentValue;
		$this->developer_life->CurrentValue = NULL;
		$this->developer_life->OldValue = $this->developer_life->CurrentValue;
		$this->date_install->CurrentValue = NULL;
		$this->date_install->OldValue = $this->date_install->CurrentValue;
		$this->date_start->CurrentValue = NULL;
		$this->date_start->OldValue = $this->date_start->CurrentValue;
		$this->remark->CurrentValue = NULL;
		$this->remark->OldValue = $this->remark->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->copy_average_1->CurrentValue = NULL;
		$this->copy_average_1->OldValue = $this->copy_average_1->CurrentValue;
		$this->copy_average_2->CurrentValue = NULL;
		$this->copy_average_2->OldValue = $this->copy_average_2->CurrentValue;
		$this->copy_average_3->CurrentValue = NULL;
		$this->copy_average_3->OldValue = $this->copy_average_3->CurrentValue;
		$this->schedule_service_type->CurrentValue = NULL;
		$this->schedule_service_type->OldValue = $this->schedule_service_type->CurrentValue;
		$this->schedule_service_interval_days->CurrentValue = NULL;
		$this->schedule_service_interval_days->OldValue = $this->schedule_service_interval_days->CurrentValue;
		$this->schedule_service_updated_till->CurrentValue = NULL;
		$this->schedule_service_updated_till->OldValue = $this->schedule_service_updated_till->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'customer_grp' first before field var 'x_customer_grp'
		$val = $CurrentForm->hasValue("customer_grp") ? $CurrentForm->getValue("customer_grp") : $CurrentForm->getValue("x_customer_grp");
		if (!$this->customer_grp->IsDetailKey) {
			$this->customer_grp->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'ref' first before field var 'x_ref'
		$val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
		if (!$this->ref->IsDetailKey) {
			$this->ref->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'partner_id' first before field var 'x_partner_id'
		$val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
		if (!$this->partner_id->IsDetailKey) {
			$this->partner_id->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'name_ref' first before field var 'x_name_ref'
		$val = $CurrentForm->hasValue("name_ref") ? $CurrentForm->getValue("name_ref") : $CurrentForm->getValue("x_name_ref");
		if (!$this->name_ref->IsDetailKey) {
			$this->name_ref->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'city_name' first before field var 'x_city_name'
		$val = $CurrentForm->hasValue("city_name") ? $CurrentForm->getValue("city_name") : $CurrentForm->getValue("x_city_name");
		if (!$this->city_name->IsDetailKey) {
			$this->city_name->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'area' first before field var 'x_area'
		$val = $CurrentForm->hasValue("area") ? $CurrentForm->getValue("area") : $CurrentForm->getValue("x_area");
		if (!$this->area->IsDetailKey) {
			$this->area->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'billing_name' first before field var 'x_billing_name'
		$val = $CurrentForm->hasValue("billing_name") ? $CurrentForm->getValue("billing_name") : $CurrentForm->getValue("x_billing_name");
		if (!$this->billing_name->IsDetailKey) {
			$this->billing_name->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			$this->address->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'personal_ref' first before field var 'x_personal_ref'
		$val = $CurrentForm->hasValue("personal_ref") ? $CurrentForm->getValue("personal_ref") : $CurrentForm->getValue("x_personal_ref");
		if (!$this->personal_ref->IsDetailKey) {
			$this->personal_ref->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			$this->grp->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			$this->s_grp->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			$this->product->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			$this->rid->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'rid_1' first before field var 'x_rid_1'
		$val = $CurrentForm->hasValue("rid_1") ? $CurrentForm->getValue("rid_1") : $CurrentForm->getValue("x_rid_1");
		if (!$this->rid_1->IsDetailKey) {
			$this->rid_1->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'harward_code' first before field var 'x_harward_code'
		$val = $CurrentForm->hasValue("harward_code") ? $CurrentForm->getValue("harward_code") : $CurrentForm->getValue("x_harward_code");
		if (!$this->harward_code->IsDetailKey) {
			$this->harward_code->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'serial_no' first before field var 'x_serial_no'
		$val = $CurrentForm->hasValue("serial_no") ? $CurrentForm->getValue("serial_no") : $CurrentForm->getValue("x_serial_no");
		if (!$this->serial_no->IsDetailKey) {
			$this->serial_no->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'invoice_no' first before field var 'x_invoice_no'
		$val = $CurrentForm->hasValue("invoice_no") ? $CurrentForm->getValue("invoice_no") : $CurrentForm->getValue("x_invoice_no");
		if (!$this->invoice_no->IsDetailKey) {
			$this->invoice_no->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'invoice_date' first before field var 'x_invoice_date'
		$val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
		if (!$this->invoice_date->IsDetailKey) {
			$this->invoice_date->setFormValue(ConvertFromUtf8($val));
			$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 7);
		}

		// Check field name 'first_counter' first before field var 'x_first_counter'
		$val = $CurrentForm->hasValue("first_counter") ? $CurrentForm->getValue("first_counter") : $CurrentForm->getValue("x_first_counter");
		if (!$this->first_counter->IsDetailKey) {
			$this->first_counter->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'guarantee' first before field var 'x_guarantee'
		$val = $CurrentForm->hasValue("guarantee") ? $CurrentForm->getValue("guarantee") : $CurrentForm->getValue("x_guarantee");
		if (!$this->guarantee->IsDetailKey) {
			$this->guarantee->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'valid_till' first before field var 'x_valid_till'
		$val = $CurrentForm->hasValue("valid_till") ? $CurrentForm->getValue("valid_till") : $CurrentForm->getValue("x_valid_till");
		if (!$this->valid_till->IsDetailKey) {
			$this->valid_till->setFormValue(ConvertFromUtf8($val));
			$this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, 7);
		}

		// Check field name 'valid_till_counter' first before field var 'x_valid_till_counter'
		$val = $CurrentForm->hasValue("valid_till_counter") ? $CurrentForm->getValue("valid_till_counter") : $CurrentForm->getValue("x_valid_till_counter");
		if (!$this->valid_till_counter->IsDetailKey) {
			$this->valid_till_counter->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'free_service' first before field var 'x_free_service'
		$val = $CurrentForm->hasValue("free_service") ? $CurrentForm->getValue("free_service") : $CurrentForm->getValue("x_free_service");
		if (!$this->free_service->IsDetailKey) {
			$this->free_service->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'toner_life' first before field var 'x_toner_life'
		$val = $CurrentForm->hasValue("toner_life") ? $CurrentForm->getValue("toner_life") : $CurrentForm->getValue("x_toner_life");
		if (!$this->toner_life->IsDetailKey) {
			$this->toner_life->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'drum_life' first before field var 'x_drum_life'
		$val = $CurrentForm->hasValue("drum_life") ? $CurrentForm->getValue("drum_life") : $CurrentForm->getValue("x_drum_life");
		if (!$this->drum_life->IsDetailKey) {
			$this->drum_life->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'developer_life' first before field var 'x_developer_life'
		$val = $CurrentForm->hasValue("developer_life") ? $CurrentForm->getValue("developer_life") : $CurrentForm->getValue("x_developer_life");
		if (!$this->developer_life->IsDetailKey) {
			$this->developer_life->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'date_install' first before field var 'x_date_install'
		$val = $CurrentForm->hasValue("date_install") ? $CurrentForm->getValue("date_install") : $CurrentForm->getValue("x_date_install");
		if (!$this->date_install->IsDetailKey) {
			$this->date_install->setFormValue(ConvertFromUtf8($val));
			$this->date_install->CurrentValue = UnFormatDateTime($this->date_install->CurrentValue, 7);
		}

		// Check field name 'date_start' first before field var 'x_date_start'
		$val = $CurrentForm->hasValue("date_start") ? $CurrentForm->getValue("date_start") : $CurrentForm->getValue("x_date_start");
		if (!$this->date_start->IsDetailKey) {
			$this->date_start->setFormValue(ConvertFromUtf8($val));
			$this->date_start->CurrentValue = UnFormatDateTime($this->date_start->CurrentValue, 7);
		}

		// Check field name 'remark' first before field var 'x_remark'
		$val = $CurrentForm->hasValue("remark") ? $CurrentForm->getValue("remark") : $CurrentForm->getValue("x_remark");
		if (!$this->remark->IsDetailKey) {
			$this->remark->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			$this->status->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			$this->operator->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			$this->datetime->setFormValue(ConvertFromUtf8($val));
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		}

		// Check field name 'copy_average_1' first before field var 'x_copy_average_1'
		$val = $CurrentForm->hasValue("copy_average_1") ? $CurrentForm->getValue("copy_average_1") : $CurrentForm->getValue("x_copy_average_1");
		if (!$this->copy_average_1->IsDetailKey) {
			$this->copy_average_1->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'copy_average_2' first before field var 'x_copy_average_2'
		$val = $CurrentForm->hasValue("copy_average_2") ? $CurrentForm->getValue("copy_average_2") : $CurrentForm->getValue("x_copy_average_2");
		if (!$this->copy_average_2->IsDetailKey) {
			$this->copy_average_2->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'copy_average_3' first before field var 'x_copy_average_3'
		$val = $CurrentForm->hasValue("copy_average_3") ? $CurrentForm->getValue("copy_average_3") : $CurrentForm->getValue("x_copy_average_3");
		if (!$this->copy_average_3->IsDetailKey) {
			$this->copy_average_3->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'schedule_service_type' first before field var 'x_schedule_service_type'
		$val = $CurrentForm->hasValue("schedule_service_type") ? $CurrentForm->getValue("schedule_service_type") : $CurrentForm->getValue("x_schedule_service_type");
		if (!$this->schedule_service_type->IsDetailKey) {
			$this->schedule_service_type->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'schedule_service_interval_days' first before field var 'x_schedule_service_interval_days'
		$val = $CurrentForm->hasValue("schedule_service_interval_days") ? $CurrentForm->getValue("schedule_service_interval_days") : $CurrentForm->getValue("x_schedule_service_interval_days");
		if (!$this->schedule_service_interval_days->IsDetailKey) {
			$this->schedule_service_interval_days->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'schedule_service_updated_till' first before field var 'x_schedule_service_updated_till'
		$val = $CurrentForm->hasValue("schedule_service_updated_till") ? $CurrentForm->getValue("schedule_service_updated_till") : $CurrentForm->getValue("x_schedule_service_updated_till");
		if (!$this->schedule_service_updated_till->IsDetailKey) {
			$this->schedule_service_updated_till->setFormValue(ConvertFromUtf8($val));
			$this->schedule_service_updated_till->CurrentValue = UnFormatDateTime($this->schedule_service_updated_till->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->customer_grp->CurrentValue = ConvertToUtf8($this->customer_grp->FormValue);
		$this->ref->CurrentValue = ConvertToUtf8($this->ref->FormValue);
		$this->partner_id->CurrentValue = ConvertToUtf8($this->partner_id->FormValue);
		$this->name_ref->CurrentValue = ConvertToUtf8($this->name_ref->FormValue);
		$this->city_name->CurrentValue = ConvertToUtf8($this->city_name->FormValue);
		$this->area->CurrentValue = ConvertToUtf8($this->area->FormValue);
		$this->billing_name->CurrentValue = ConvertToUtf8($this->billing_name->FormValue);
		$this->address->CurrentValue = ConvertToUtf8($this->address->FormValue);
		$this->personal_ref->CurrentValue = ConvertToUtf8($this->personal_ref->FormValue);
		$this->grp->CurrentValue = ConvertToUtf8($this->grp->FormValue);
		$this->s_grp->CurrentValue = ConvertToUtf8($this->s_grp->FormValue);
		$this->product->CurrentValue = ConvertToUtf8($this->product->FormValue);
		$this->rid->CurrentValue = ConvertToUtf8($this->rid->FormValue);
		$this->rid_1->CurrentValue = ConvertToUtf8($this->rid_1->FormValue);
		$this->harward_code->CurrentValue = ConvertToUtf8($this->harward_code->FormValue);
		$this->serial_no->CurrentValue = ConvertToUtf8($this->serial_no->FormValue);
		$this->invoice_no->CurrentValue = ConvertToUtf8($this->invoice_no->FormValue);
		$this->invoice_date->CurrentValue = ConvertToUtf8($this->invoice_date->FormValue);
		$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 7);
		$this->first_counter->CurrentValue = ConvertToUtf8($this->first_counter->FormValue);
		$this->guarantee->CurrentValue = ConvertToUtf8($this->guarantee->FormValue);
		$this->valid_till->CurrentValue = ConvertToUtf8($this->valid_till->FormValue);
		$this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, 7);
		$this->valid_till_counter->CurrentValue = ConvertToUtf8($this->valid_till_counter->FormValue);
		$this->free_service->CurrentValue = ConvertToUtf8($this->free_service->FormValue);
		$this->toner_life->CurrentValue = ConvertToUtf8($this->toner_life->FormValue);
		$this->drum_life->CurrentValue = ConvertToUtf8($this->drum_life->FormValue);
		$this->developer_life->CurrentValue = ConvertToUtf8($this->developer_life->FormValue);
		$this->date_install->CurrentValue = ConvertToUtf8($this->date_install->FormValue);
		$this->date_install->CurrentValue = UnFormatDateTime($this->date_install->CurrentValue, 7);
		$this->date_start->CurrentValue = ConvertToUtf8($this->date_start->FormValue);
		$this->date_start->CurrentValue = UnFormatDateTime($this->date_start->CurrentValue, 7);
		$this->remark->CurrentValue = ConvertToUtf8($this->remark->FormValue);
		$this->status->CurrentValue = ConvertToUtf8($this->status->FormValue);
		$this->operator->CurrentValue = ConvertToUtf8($this->operator->FormValue);
		$this->datetime->CurrentValue = ConvertToUtf8($this->datetime->FormValue);
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 7);
		$this->copy_average_1->CurrentValue = ConvertToUtf8($this->copy_average_1->FormValue);
		$this->copy_average_2->CurrentValue = ConvertToUtf8($this->copy_average_2->FormValue);
		$this->copy_average_3->CurrentValue = ConvertToUtf8($this->copy_average_3->FormValue);
		$this->schedule_service_type->CurrentValue = ConvertToUtf8($this->schedule_service_type->FormValue);
		$this->schedule_service_interval_days->CurrentValue = ConvertToUtf8($this->schedule_service_interval_days->FormValue);
		$this->schedule_service_updated_till->CurrentValue = ConvertToUtf8($this->schedule_service_updated_till->FormValue);
		$this->schedule_service_updated_till->CurrentValue = UnFormatDateTime($this->schedule_service_updated_till->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->customer_grp->setDbValue($row['customer_grp']);
		$this->ref->setDbValue($row['ref']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->name_ref->setDbValue($row['name_ref']);
		$this->city_name->setDbValue($row['city_name']);
		$this->area->setDbValue($row['area']);
		$this->billing_name->setDbValue($row['billing_name']);
		$this->address->setDbValue($row['address']);
		$this->personal_ref->setDbValue($row['personal_ref']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		if (array_key_exists('EV__product', $rs->fields)) {
			$this->product->VirtualValue = $rs->fields('EV__product'); // Set up virtual field value
		} else {
			$this->product->VirtualValue = ""; // Clear value
		}
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->rid_1->setDbValue($row['rid_1']);
		$this->harward_code->setDbValue($row['harward_code']);
		$this->serial_no->setDbValue($row['serial_no']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->first_counter->setDbValue($row['first_counter']);
		$this->guarantee->setDbValue($row['guarantee']);
		$this->valid_till->setDbValue($row['valid_till']);
		$this->valid_till_counter->setDbValue($row['valid_till_counter']);
		$this->free_service->setDbValue($row['free_service']);
		$this->toner_life->setDbValue($row['toner_life']);
		$this->drum_life->setDbValue($row['drum_life']);
		$this->developer_life->setDbValue($row['developer_life']);
		$this->date_install->setDbValue($row['date_install']);
		$this->date_start->setDbValue($row['date_start']);
		$this->remark->setDbValue($row['remark']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->copy_average_1->setDbValue($row['copy_average_1']);
		$this->copy_average_2->setDbValue($row['copy_average_2']);
		$this->copy_average_3->setDbValue($row['copy_average_3']);
		$this->schedule_service_type->setDbValue($row['schedule_service_type']);
		$this->schedule_service_interval_days->setDbValue($row['schedule_service_interval_days']);
		$this->schedule_service_updated_till->setDbValue($row['schedule_service_updated_till']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['customer_grp'] = $this->customer_grp->CurrentValue;
		$row['ref'] = $this->ref->CurrentValue;
		$row['partner_id'] = $this->partner_id->CurrentValue;
		$row['name_ref'] = $this->name_ref->CurrentValue;
		$row['city_name'] = $this->city_name->CurrentValue;
		$row['area'] = $this->area->CurrentValue;
		$row['billing_name'] = $this->billing_name->CurrentValue;
		$row['address'] = $this->address->CurrentValue;
		$row['personal_ref'] = $this->personal_ref->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['rid_1'] = $this->rid_1->CurrentValue;
		$row['harward_code'] = $this->harward_code->CurrentValue;
		$row['serial_no'] = $this->serial_no->CurrentValue;
		$row['invoice_no'] = $this->invoice_no->CurrentValue;
		$row['invoice_date'] = $this->invoice_date->CurrentValue;
		$row['first_counter'] = $this->first_counter->CurrentValue;
		$row['guarantee'] = $this->guarantee->CurrentValue;
		$row['valid_till'] = $this->valid_till->CurrentValue;
		$row['valid_till_counter'] = $this->valid_till_counter->CurrentValue;
		$row['free_service'] = $this->free_service->CurrentValue;
		$row['toner_life'] = $this->toner_life->CurrentValue;
		$row['drum_life'] = $this->drum_life->CurrentValue;
		$row['developer_life'] = $this->developer_life->CurrentValue;
		$row['date_install'] = $this->date_install->CurrentValue;
		$row['date_start'] = $this->date_start->CurrentValue;
		$row['remark'] = $this->remark->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['copy_average_1'] = $this->copy_average_1->CurrentValue;
		$row['copy_average_2'] = $this->copy_average_2->CurrentValue;
		$row['copy_average_3'] = $this->copy_average_3->CurrentValue;
		$row['schedule_service_type'] = $this->schedule_service_type->CurrentValue;
		$row['schedule_service_interval_days'] = $this->schedule_service_interval_days->CurrentValue;
		$row['schedule_service_updated_till'] = $this->schedule_service_updated_till->CurrentValue;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// customer_grp
		// ref
		// partner_id
		// name_ref
		// city_name
		// area
		// billing_name
		// address
		// personal_ref
		// grp
		// s_grp
		// product
		// rid
		// rid_1
		// harward_code
		// serial_no
		// invoice_no
		// invoice_date
		// first_counter
		// guarantee
		// valid_till
		// valid_till_counter
		// free_service
		// toner_life
		// drum_life
		// developer_life
		// date_install
		// date_start
		// remark
		// status
		// operator
		// datetime
		// copy_average_1
		// copy_average_2
		// copy_average_3
		// schedule_service_type
		// schedule_service_interval_days
		// schedule_service_updated_till

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// customer_grp
			$curVal = strval($this->customer_grp->CurrentValue);
			if ($curVal <> "") {
				$this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
				if ($this->customer_grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->customer_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->customer_grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
					}
				}
			} else {
				$this->customer_grp->ViewValue = NULL;
			}
			$this->customer_grp->ViewCustomAttributes = "";

			// ref
			$this->ref->ViewValue = $this->ref->CurrentValue;
			$this->ref->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// name_ref
			$this->name_ref->ViewValue = $this->name_ref->CurrentValue;
			$this->name_ref->ViewCustomAttributes = "";

			// city_name
			$this->city_name->ViewValue = $this->city_name->CurrentValue;
			$this->city_name->ViewCustomAttributes = "";

			// area
			$this->area->ViewValue = $this->area->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->area->CurrentValue;
			$this->area->ViewValue = $this->area->displayValue($arwrk);
			$this->area->ViewCustomAttributes = "";

			// billing_name
			$this->billing_name->ViewValue = $this->billing_name->CurrentValue;
			$this->billing_name->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// personal_ref
			$curVal = strval($this->personal_ref->CurrentValue);
			if ($curVal <> "") {
				$this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
				if ($this->personal_ref->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->personal_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->personal_ref->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
							$this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
					}
				}
			} else {
				$this->personal_ref->ViewValue = NULL;
			}
			$this->personal_ref->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			if ($this->product->VirtualValue <> "") {
				$this->product->ViewValue = $this->product->VirtualValue;
			} else {
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			}
			$this->product->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
				$this->rid->ViewValue = $this->rid->CurrentValue;
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// rid_1
			$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
			$this->rid_1->ViewCustomAttributes = "";

			// harward_code
			$this->harward_code->ViewValue = $this->harward_code->CurrentValue;
			$this->harward_code->ViewCustomAttributes = "";

			// serial_no
			$this->serial_no->ViewValue = $this->serial_no->CurrentValue;
			$this->serial_no->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 7);
			$this->invoice_date->ViewCustomAttributes = "";

			// first_counter
			$this->first_counter->ViewValue = $this->first_counter->CurrentValue;
			$this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, 0, -2, -2, -2);
			$this->first_counter->ViewCustomAttributes = "";

			// guarantee
			if (strval($this->guarantee->CurrentValue) <> "") {
				$this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
			} else {
				$this->guarantee->ViewValue = NULL;
			}
			$this->guarantee->ViewCustomAttributes = "";

			// valid_till
			$this->valid_till->ViewValue = $this->valid_till->CurrentValue;
			$this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, 7);
			$this->valid_till->ViewCustomAttributes = "";

			// valid_till_counter
			$this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
			$this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, 0, -2, -2, -2);
			$this->valid_till_counter->ViewCustomAttributes = "";

			// free_service
			$this->free_service->ViewValue = $this->free_service->CurrentValue;
			$this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, 0, -2, -2, -2);
			$this->free_service->ViewCustomAttributes = "";

			// toner_life
			$this->toner_life->ViewValue = $this->toner_life->CurrentValue;
			$this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, 0, -2, -2, -2);
			$this->toner_life->ViewCustomAttributes = "";

			// drum_life
			$this->drum_life->ViewValue = $this->drum_life->CurrentValue;
			$this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, 0, -2, -2, -2);
			$this->drum_life->ViewCustomAttributes = "";

			// developer_life
			$this->developer_life->ViewValue = $this->developer_life->CurrentValue;
			$this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, 0, -2, -2, -2);
			$this->developer_life->ViewCustomAttributes = "";

			// date_install
			$this->date_install->ViewValue = $this->date_install->CurrentValue;
			$this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, 7);
			$this->date_install->ViewCustomAttributes = "";

			// date_start
			$this->date_start->ViewValue = $this->date_start->CurrentValue;
			$this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, 7);
			$this->date_start->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// copy_average_1
			$this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
			$this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, 0, -2, -2, -2);
			$this->copy_average_1->ViewCustomAttributes = "";

			// copy_average_2
			$this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
			$this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, 0, -2, -2, -2);
			$this->copy_average_2->ViewCustomAttributes = "";

			// copy_average_3
			$this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
			$this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, 0, -2, -2, -2);
			$this->copy_average_3->ViewCustomAttributes = "";

			// schedule_service_type
			$this->schedule_service_type->ViewValue = $this->schedule_service_type->CurrentValue;
			$this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->ViewValue, 0, -2, -2, -2);
			$this->schedule_service_type->ViewCustomAttributes = "";

			// schedule_service_interval_days
			$this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
			$this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, 0, -2, -2, -2);
			$this->schedule_service_interval_days->ViewCustomAttributes = "";

			// schedule_service_updated_till
			$this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
			$this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, 0);
			$this->schedule_service_updated_till->ViewCustomAttributes = "";

			// customer_grp
			$this->customer_grp->LinkCustomAttributes = "";
			$this->customer_grp->HrefValue = "";
			$this->customer_grp->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// name_ref
			$this->name_ref->LinkCustomAttributes = "";
			$this->name_ref->HrefValue = "";
			$this->name_ref->TooltipValue = "";

			// city_name
			$this->city_name->LinkCustomAttributes = "";
			$this->city_name->HrefValue = "";
			$this->city_name->TooltipValue = "";

			// area
			$this->area->LinkCustomAttributes = "";
			$this->area->HrefValue = "";
			$this->area->TooltipValue = "";

			// billing_name
			$this->billing_name->LinkCustomAttributes = "";
			$this->billing_name->HrefValue = "";
			$this->billing_name->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// personal_ref
			$this->personal_ref->LinkCustomAttributes = "";
			$this->personal_ref->HrefValue = "";
			$this->personal_ref->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";
			$this->rid_1->TooltipValue = "";

			// harward_code
			$this->harward_code->LinkCustomAttributes = "";
			$this->harward_code->HrefValue = "";
			$this->harward_code->TooltipValue = "";

			// serial_no
			$this->serial_no->LinkCustomAttributes = "";
			$this->serial_no->HrefValue = "";
			$this->serial_no->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// first_counter
			$this->first_counter->LinkCustomAttributes = "";
			$this->first_counter->HrefValue = "";
			$this->first_counter->TooltipValue = "";

			// guarantee
			$this->guarantee->LinkCustomAttributes = "";
			$this->guarantee->HrefValue = "";
			$this->guarantee->TooltipValue = "";

			// valid_till
			$this->valid_till->LinkCustomAttributes = "";
			$this->valid_till->HrefValue = "";
			$this->valid_till->TooltipValue = "";

			// valid_till_counter
			$this->valid_till_counter->LinkCustomAttributes = "";
			$this->valid_till_counter->HrefValue = "";
			$this->valid_till_counter->TooltipValue = "";

			// free_service
			$this->free_service->LinkCustomAttributes = "";
			$this->free_service->HrefValue = "";
			$this->free_service->TooltipValue = "";

			// toner_life
			$this->toner_life->LinkCustomAttributes = "";
			$this->toner_life->HrefValue = "";
			$this->toner_life->TooltipValue = "";

			// drum_life
			$this->drum_life->LinkCustomAttributes = "";
			$this->drum_life->HrefValue = "";
			$this->drum_life->TooltipValue = "";

			// developer_life
			$this->developer_life->LinkCustomAttributes = "";
			$this->developer_life->HrefValue = "";
			$this->developer_life->TooltipValue = "";

			// date_install
			$this->date_install->LinkCustomAttributes = "";
			$this->date_install->HrefValue = "";
			$this->date_install->TooltipValue = "";

			// date_start
			$this->date_start->LinkCustomAttributes = "";
			$this->date_start->HrefValue = "";
			$this->date_start->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// copy_average_1
			$this->copy_average_1->LinkCustomAttributes = "";
			$this->copy_average_1->HrefValue = "";
			$this->copy_average_1->TooltipValue = "";

			// copy_average_2
			$this->copy_average_2->LinkCustomAttributes = "";
			$this->copy_average_2->HrefValue = "";
			$this->copy_average_2->TooltipValue = "";

			// copy_average_3
			$this->copy_average_3->LinkCustomAttributes = "";
			$this->copy_average_3->HrefValue = "";
			$this->copy_average_3->TooltipValue = "";

			// schedule_service_type
			$this->schedule_service_type->LinkCustomAttributes = "";
			$this->schedule_service_type->HrefValue = "";
			$this->schedule_service_type->TooltipValue = "";

			// schedule_service_interval_days
			$this->schedule_service_interval_days->LinkCustomAttributes = "";
			$this->schedule_service_interval_days->HrefValue = "";
			$this->schedule_service_interval_days->TooltipValue = "";

			// schedule_service_updated_till
			$this->schedule_service_updated_till->LinkCustomAttributes = "";
			$this->schedule_service_updated_till->HrefValue = "";
			$this->schedule_service_updated_till->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// customer_grp
			$this->customer_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->customer_grp->CurrentValue));
			if ($curVal <> "")
				$this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
			else
				$this->customer_grp->ViewValue = $this->customer_grp->Lookup !== NULL && is_array($this->customer_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->customer_grp->ViewValue !== NULL) { // Load from cache
				$this->customer_grp->EditValue = array_values($this->customer_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->customer_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->customer_grp->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref->CurrentValue = HtmlDecode($this->ref->CurrentValue);
			$this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->EditValue = HtmlEncode($this->partner_id->CurrentValue);
					}
				}
			} else {
				$this->partner_id->EditValue = NULL;
			}
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

			// name_ref
			$this->name_ref->EditAttrs["class"] = "form-control";
			$this->name_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name_ref->CurrentValue = HtmlDecode($this->name_ref->CurrentValue);
			$this->name_ref->EditValue = HtmlEncode($this->name_ref->CurrentValue);
			$this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

			// city_name
			$this->city_name->EditAttrs["class"] = "form-control";
			$this->city_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->city_name->CurrentValue = HtmlDecode($this->city_name->CurrentValue);
			$this->city_name->EditValue = HtmlEncode($this->city_name->CurrentValue);
			$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

			// area
			$this->area->EditAttrs["class"] = "form-control";
			$this->area->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->area->CurrentValue = HtmlDecode($this->area->CurrentValue);
			$this->area->EditValue = HtmlEncode($this->area->CurrentValue);
			$arwrk = array();
			$arwrk[1] = HtmlEncode($this->area->CurrentValue);
			$this->area->EditValue = $this->area->displayValue($arwrk);
			$this->area->PlaceHolder = RemoveHtml($this->area->caption());

			// billing_name
			$this->billing_name->EditAttrs["class"] = "form-control";
			$this->billing_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->billing_name->CurrentValue = HtmlDecode($this->billing_name->CurrentValue);
			$this->billing_name->EditValue = HtmlEncode($this->billing_name->CurrentValue);
			$this->billing_name->PlaceHolder = RemoveHtml($this->billing_name->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// personal_ref
			$this->personal_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->personal_ref->CurrentValue));
			if ($curVal <> "")
				$this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
			else
				$this->personal_ref->ViewValue = $this->personal_ref->Lookup !== NULL && is_array($this->personal_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->personal_ref->ViewValue !== NULL) { // Load from cache
				$this->personal_ref->EditValue = array_values($this->personal_ref->Lookup->Options);
				if ($this->personal_ref->ViewValue == "")
					$this->personal_ref->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->personal_ref->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->personal_ref->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2));
						$this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->personal_ref->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 0, -2, -2, -2);
				}
				$this->personal_ref->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->rid->EditValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
					}
				}
			} else {
				$this->rid->EditValue = NULL;
			}
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// rid_1
			$this->rid_1->EditAttrs["class"] = "form-control";
			$this->rid_1->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->rid_1->CurrentValue = HtmlDecode($this->rid_1->CurrentValue);
			$this->rid_1->EditValue = HtmlEncode($this->rid_1->CurrentValue);
			$this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

			// harward_code
			$this->harward_code->EditAttrs["class"] = "form-control";
			$this->harward_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->harward_code->CurrentValue = HtmlDecode($this->harward_code->CurrentValue);
			$this->harward_code->EditValue = HtmlEncode($this->harward_code->CurrentValue);
			$this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

			// serial_no
			$this->serial_no->EditAttrs["class"] = "form-control";
			$this->serial_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->serial_no->CurrentValue = HtmlDecode($this->serial_no->CurrentValue);
			$this->serial_no->EditValue = HtmlEncode($this->serial_no->CurrentValue);
			$this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

			// invoice_no
			$this->invoice_no->EditAttrs["class"] = "form-control";
			$this->invoice_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
			$this->invoice_no->EditValue = HtmlEncode($this->invoice_no->CurrentValue);
			$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime($this->invoice_date->CurrentValue, 7));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// first_counter
			$this->first_counter->EditAttrs["class"] = "form-control";
			$this->first_counter->EditCustomAttributes = "";
			$this->first_counter->EditValue = HtmlEncode($this->first_counter->CurrentValue);
			$this->first_counter->PlaceHolder = RemoveHtml($this->first_counter->caption());

			// guarantee
			$this->guarantee->EditAttrs["class"] = "form-control";
			$this->guarantee->EditCustomAttributes = "";
			$this->guarantee->EditValue = $this->guarantee->options(TRUE);

			// valid_till
			$this->valid_till->EditAttrs["class"] = "form-control";
			$this->valid_till->EditCustomAttributes = "";
			$this->valid_till->EditValue = HtmlEncode(FormatDateTime($this->valid_till->CurrentValue, 7));
			$this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

			// valid_till_counter
			$this->valid_till_counter->EditAttrs["class"] = "form-control";
			$this->valid_till_counter->EditCustomAttributes = "";
			$this->valid_till_counter->EditValue = HtmlEncode($this->valid_till_counter->CurrentValue);
			$this->valid_till_counter->PlaceHolder = RemoveHtml($this->valid_till_counter->caption());

			// free_service
			$this->free_service->EditAttrs["class"] = "form-control";
			$this->free_service->EditCustomAttributes = "";
			$this->free_service->EditValue = HtmlEncode($this->free_service->CurrentValue);
			$this->free_service->PlaceHolder = RemoveHtml($this->free_service->caption());

			// toner_life
			$this->toner_life->EditAttrs["class"] = "form-control";
			$this->toner_life->EditCustomAttributes = "";
			$this->toner_life->EditValue = HtmlEncode($this->toner_life->CurrentValue);
			$this->toner_life->PlaceHolder = RemoveHtml($this->toner_life->caption());

			// drum_life
			$this->drum_life->EditAttrs["class"] = "form-control";
			$this->drum_life->EditCustomAttributes = "";
			$this->drum_life->EditValue = HtmlEncode($this->drum_life->CurrentValue);
			$this->drum_life->PlaceHolder = RemoveHtml($this->drum_life->caption());

			// developer_life
			$this->developer_life->EditAttrs["class"] = "form-control";
			$this->developer_life->EditCustomAttributes = "";
			$this->developer_life->EditValue = HtmlEncode($this->developer_life->CurrentValue);
			$this->developer_life->PlaceHolder = RemoveHtml($this->developer_life->caption());

			// date_install
			$this->date_install->EditAttrs["class"] = "form-control";
			$this->date_install->EditCustomAttributes = "";
			$this->date_install->EditValue = HtmlEncode(FormatDateTime($this->date_install->CurrentValue, 7));
			$this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

			// date_start
			$this->date_start->EditAttrs["class"] = "form-control";
			$this->date_start->EditCustomAttributes = "";
			$this->date_start->EditValue = HtmlEncode(FormatDateTime($this->date_start->CurrentValue, 7));
			$this->date_start->PlaceHolder = RemoveHtml($this->date_start->caption());

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->CurrentValue = HtmlDecode($this->remark->CurrentValue);
			$this->remark->EditValue = HtmlEncode($this->remark->CurrentValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->CurrentValue = CurrentUserID();

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->CurrentValue = FormatDateTime(CurrentDateTime(), 7);

			// copy_average_1
			$this->copy_average_1->EditAttrs["class"] = "form-control";
			$this->copy_average_1->EditCustomAttributes = "";
			$this->copy_average_1->EditValue = HtmlEncode($this->copy_average_1->CurrentValue);
			$this->copy_average_1->PlaceHolder = RemoveHtml($this->copy_average_1->caption());

			// copy_average_2
			$this->copy_average_2->EditAttrs["class"] = "form-control";
			$this->copy_average_2->EditCustomAttributes = "";
			$this->copy_average_2->EditValue = HtmlEncode($this->copy_average_2->CurrentValue);
			$this->copy_average_2->PlaceHolder = RemoveHtml($this->copy_average_2->caption());

			// copy_average_3
			$this->copy_average_3->EditAttrs["class"] = "form-control";
			$this->copy_average_3->EditCustomAttributes = "";
			$this->copy_average_3->EditValue = HtmlEncode($this->copy_average_3->CurrentValue);
			$this->copy_average_3->PlaceHolder = RemoveHtml($this->copy_average_3->caption());

			// schedule_service_type
			$this->schedule_service_type->EditAttrs["class"] = "form-control";
			$this->schedule_service_type->EditCustomAttributes = "";
			$this->schedule_service_type->EditValue = HtmlEncode($this->schedule_service_type->CurrentValue);
			$this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

			// schedule_service_interval_days
			$this->schedule_service_interval_days->EditAttrs["class"] = "form-control";
			$this->schedule_service_interval_days->EditCustomAttributes = "";
			$this->schedule_service_interval_days->EditValue = HtmlEncode($this->schedule_service_interval_days->CurrentValue);
			$this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());

			// schedule_service_updated_till
			$this->schedule_service_updated_till->EditAttrs["class"] = "form-control";
			$this->schedule_service_updated_till->EditCustomAttributes = "";
			$this->schedule_service_updated_till->EditValue = HtmlEncode(FormatDateTime($this->schedule_service_updated_till->CurrentValue, 8));
			$this->schedule_service_updated_till->PlaceHolder = RemoveHtml($this->schedule_service_updated_till->caption());

			// Add refer script
			// customer_grp

			$this->customer_grp->LinkCustomAttributes = "";
			$this->customer_grp->HrefValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";

			// name_ref
			$this->name_ref->LinkCustomAttributes = "";
			$this->name_ref->HrefValue = "";

			// city_name
			$this->city_name->LinkCustomAttributes = "";
			$this->city_name->HrefValue = "";

			// area
			$this->area->LinkCustomAttributes = "";
			$this->area->HrefValue = "";

			// billing_name
			$this->billing_name->LinkCustomAttributes = "";
			$this->billing_name->HrefValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// personal_ref
			$this->personal_ref->LinkCustomAttributes = "";
			$this->personal_ref->HrefValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "product_cart_blist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->s_grp->CurrentValue)) {
				$this->s_grp->HrefValue = "product_cart_blist.php?x_s_grp=" . $this->s_grp->CurrentValue; // Add prefix/suffix
				$this->s_grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
			} else {
				$this->s_grp->HrefValue = "";
			}

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "product_cart_blist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// rid_1
			$this->rid_1->LinkCustomAttributes = "";
			$this->rid_1->HrefValue = "";

			// harward_code
			$this->harward_code->LinkCustomAttributes = "";
			$this->harward_code->HrefValue = "";

			// serial_no
			$this->serial_no->LinkCustomAttributes = "";
			$this->serial_no->HrefValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";

			// first_counter
			$this->first_counter->LinkCustomAttributes = "";
			$this->first_counter->HrefValue = "";

			// guarantee
			$this->guarantee->LinkCustomAttributes = "";
			$this->guarantee->HrefValue = "";

			// valid_till
			$this->valid_till->LinkCustomAttributes = "";
			$this->valid_till->HrefValue = "";

			// valid_till_counter
			$this->valid_till_counter->LinkCustomAttributes = "";
			$this->valid_till_counter->HrefValue = "";

			// free_service
			$this->free_service->LinkCustomAttributes = "";
			$this->free_service->HrefValue = "";

			// toner_life
			$this->toner_life->LinkCustomAttributes = "";
			$this->toner_life->HrefValue = "";

			// drum_life
			$this->drum_life->LinkCustomAttributes = "";
			$this->drum_life->HrefValue = "";

			// developer_life
			$this->developer_life->LinkCustomAttributes = "";
			$this->developer_life->HrefValue = "";

			// date_install
			$this->date_install->LinkCustomAttributes = "";
			$this->date_install->HrefValue = "";

			// date_start
			$this->date_start->LinkCustomAttributes = "";
			$this->date_start->HrefValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// copy_average_1
			$this->copy_average_1->LinkCustomAttributes = "";
			$this->copy_average_1->HrefValue = "";

			// copy_average_2
			$this->copy_average_2->LinkCustomAttributes = "";
			$this->copy_average_2->HrefValue = "";

			// copy_average_3
			$this->copy_average_3->LinkCustomAttributes = "";
			$this->copy_average_3->HrefValue = "";

			// schedule_service_type
			$this->schedule_service_type->LinkCustomAttributes = "";
			$this->schedule_service_type->HrefValue = "";

			// schedule_service_interval_days
			$this->schedule_service_interval_days->LinkCustomAttributes = "";
			$this->schedule_service_interval_days->HrefValue = "";

			// schedule_service_updated_till
			$this->schedule_service_updated_till->LinkCustomAttributes = "";
			$this->schedule_service_updated_till->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->customer_grp->Required) {
			if ($this->customer_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->customer_grp->caption(), $this->customer_grp->RequiredErrorMessage));
			}
		}
		if ($this->ref->Required) {
			if (!$this->ref->IsDetailKey && $this->ref->FormValue != NULL && $this->ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
			}
		}
		if ($this->partner_id->Required) {
			if (!$this->partner_id->IsDetailKey && $this->partner_id->FormValue != NULL && $this->partner_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
			}
		}
		if ($this->name_ref->Required) {
			if (!$this->name_ref->IsDetailKey && $this->name_ref->FormValue != NULL && $this->name_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name_ref->caption(), $this->name_ref->RequiredErrorMessage));
			}
		}
		if ($this->city_name->Required) {
			if (!$this->city_name->IsDetailKey && $this->city_name->FormValue != NULL && $this->city_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->city_name->caption(), $this->city_name->RequiredErrorMessage));
			}
		}
		if ($this->area->Required) {
			if (!$this->area->IsDetailKey && $this->area->FormValue != NULL && $this->area->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->area->caption(), $this->area->RequiredErrorMessage));
			}
		}
		if ($this->billing_name->Required) {
			if (!$this->billing_name->IsDetailKey && $this->billing_name->FormValue != NULL && $this->billing_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->billing_name->caption(), $this->billing_name->RequiredErrorMessage));
			}
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->personal_ref->Required) {
			if ($this->personal_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->personal_ref->caption(), $this->personal_ref->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->rid_1->Required) {
			if (!$this->rid_1->IsDetailKey && $this->rid_1->FormValue != NULL && $this->rid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
			}
		}
		if ($this->harward_code->Required) {
			if (!$this->harward_code->IsDetailKey && $this->harward_code->FormValue != NULL && $this->harward_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->harward_code->caption(), $this->harward_code->RequiredErrorMessage));
			}
		}
		if ($this->serial_no->Required) {
			if (!$this->serial_no->IsDetailKey && $this->serial_no->FormValue != NULL && $this->serial_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->serial_no->caption(), $this->serial_no->RequiredErrorMessage));
			}
		}
		if ($this->invoice_no->Required) {
			if (!$this->invoice_no->IsDetailKey && $this->invoice_no->FormValue != NULL && $this->invoice_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_no->caption(), $this->invoice_no->RequiredErrorMessage));
			}
		}
		if ($this->invoice_date->Required) {
			if (!$this->invoice_date->IsDetailKey && $this->invoice_date->FormValue != NULL && $this->invoice_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->invoice_date->FormValue)) {
			AddMessage($FormError, $this->invoice_date->errorMessage());
		}
		if ($this->first_counter->Required) {
			if (!$this->first_counter->IsDetailKey && $this->first_counter->FormValue != NULL && $this->first_counter->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->first_counter->caption(), $this->first_counter->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->first_counter->FormValue)) {
			AddMessage($FormError, $this->first_counter->errorMessage());
		}
		if ($this->guarantee->Required) {
			if (!$this->guarantee->IsDetailKey && $this->guarantee->FormValue != NULL && $this->guarantee->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->guarantee->caption(), $this->guarantee->RequiredErrorMessage));
			}
		}
		if ($this->valid_till->Required) {
			if (!$this->valid_till->IsDetailKey && $this->valid_till->FormValue != NULL && $this->valid_till->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->valid_till->caption(), $this->valid_till->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->valid_till->FormValue)) {
			AddMessage($FormError, $this->valid_till->errorMessage());
		}
		if ($this->valid_till_counter->Required) {
			if (!$this->valid_till_counter->IsDetailKey && $this->valid_till_counter->FormValue != NULL && $this->valid_till_counter->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->valid_till_counter->caption(), $this->valid_till_counter->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->valid_till_counter->FormValue)) {
			AddMessage($FormError, $this->valid_till_counter->errorMessage());
		}
		if ($this->free_service->Required) {
			if (!$this->free_service->IsDetailKey && $this->free_service->FormValue != NULL && $this->free_service->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->free_service->caption(), $this->free_service->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->free_service->FormValue)) {
			AddMessage($FormError, $this->free_service->errorMessage());
		}
		if ($this->toner_life->Required) {
			if (!$this->toner_life->IsDetailKey && $this->toner_life->FormValue != NULL && $this->toner_life->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->toner_life->caption(), $this->toner_life->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->toner_life->FormValue)) {
			AddMessage($FormError, $this->toner_life->errorMessage());
		}
		if ($this->drum_life->Required) {
			if (!$this->drum_life->IsDetailKey && $this->drum_life->FormValue != NULL && $this->drum_life->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->drum_life->caption(), $this->drum_life->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->drum_life->FormValue)) {
			AddMessage($FormError, $this->drum_life->errorMessage());
		}
		if ($this->developer_life->Required) {
			if (!$this->developer_life->IsDetailKey && $this->developer_life->FormValue != NULL && $this->developer_life->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->developer_life->caption(), $this->developer_life->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->developer_life->FormValue)) {
			AddMessage($FormError, $this->developer_life->errorMessage());
		}
		if ($this->date_install->Required) {
			if (!$this->date_install->IsDetailKey && $this->date_install->FormValue != NULL && $this->date_install->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date_install->caption(), $this->date_install->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->date_install->FormValue)) {
			AddMessage($FormError, $this->date_install->errorMessage());
		}
		if ($this->date_start->Required) {
			if (!$this->date_start->IsDetailKey && $this->date_start->FormValue != NULL && $this->date_start->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->date_start->caption(), $this->date_start->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->date_start->FormValue)) {
			AddMessage($FormError, $this->date_start->errorMessage());
		}
		if ($this->remark->Required) {
			if (!$this->remark->IsDetailKey && $this->remark->FormValue != NULL && $this->remark->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remark->caption(), $this->remark->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->copy_average_1->Required) {
			if (!$this->copy_average_1->IsDetailKey && $this->copy_average_1->FormValue != NULL && $this->copy_average_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->copy_average_1->caption(), $this->copy_average_1->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->copy_average_1->FormValue)) {
			AddMessage($FormError, $this->copy_average_1->errorMessage());
		}
		if ($this->copy_average_2->Required) {
			if (!$this->copy_average_2->IsDetailKey && $this->copy_average_2->FormValue != NULL && $this->copy_average_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->copy_average_2->caption(), $this->copy_average_2->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->copy_average_2->FormValue)) {
			AddMessage($FormError, $this->copy_average_2->errorMessage());
		}
		if ($this->copy_average_3->Required) {
			if (!$this->copy_average_3->IsDetailKey && $this->copy_average_3->FormValue != NULL && $this->copy_average_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->copy_average_3->caption(), $this->copy_average_3->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->copy_average_3->FormValue)) {
			AddMessage($FormError, $this->copy_average_3->errorMessage());
		}
		if ($this->schedule_service_type->Required) {
			if (!$this->schedule_service_type->IsDetailKey && $this->schedule_service_type->FormValue != NULL && $this->schedule_service_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->schedule_service_type->caption(), $this->schedule_service_type->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->schedule_service_type->FormValue)) {
			AddMessage($FormError, $this->schedule_service_type->errorMessage());
		}
		if ($this->schedule_service_interval_days->Required) {
			if (!$this->schedule_service_interval_days->IsDetailKey && $this->schedule_service_interval_days->FormValue != NULL && $this->schedule_service_interval_days->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->schedule_service_interval_days->caption(), $this->schedule_service_interval_days->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->schedule_service_interval_days->FormValue)) {
			AddMessage($FormError, $this->schedule_service_interval_days->errorMessage());
		}
		if ($this->schedule_service_updated_till->Required) {
			if (!$this->schedule_service_updated_till->IsDetailKey && $this->schedule_service_updated_till->FormValue != NULL && $this->schedule_service_updated_till->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->schedule_service_updated_till->caption(), $this->schedule_service_updated_till->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->schedule_service_updated_till->FormValue)) {
			AddMessage($FormError, $this->schedule_service_updated_till->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->ref->CurrentValue <> "") { // Check field with unique index
			$filter = "(ref = '" . AdjustSql($this->ref->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->ref->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->ref->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// customer_grp
		$this->customer_grp->setDbValueDef($rsnew, $this->customer_grp->CurrentValue, "", FALSE);

		// ref
		$this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, NULL, FALSE);

		// partner_id
		$this->partner_id->setDbValueDef($rsnew, $this->partner_id->CurrentValue, NULL, FALSE);

		// name_ref
		$this->name_ref->setDbValueDef($rsnew, $this->name_ref->CurrentValue, NULL, FALSE);

		// city_name
		$this->city_name->setDbValueDef($rsnew, $this->city_name->CurrentValue, NULL, FALSE);

		// area
		$this->area->setDbValueDef($rsnew, $this->area->CurrentValue, NULL, FALSE);

		// billing_name
		$this->billing_name->setDbValueDef($rsnew, $this->billing_name->CurrentValue, NULL, FALSE);

		// address
		$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, "", FALSE);

		// personal_ref
		$this->personal_ref->setDbValueDef($rsnew, $this->personal_ref->CurrentValue, NULL, FALSE);

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, FALSE);

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, 0, FALSE);

		// rid_1
		$this->rid_1->setDbValueDef($rsnew, $this->rid_1->CurrentValue, NULL, FALSE);

		// harward_code
		$this->harward_code->setDbValueDef($rsnew, $this->harward_code->CurrentValue, NULL, FALSE);

		// serial_no
		$this->serial_no->setDbValueDef($rsnew, $this->serial_no->CurrentValue, NULL, FALSE);

		// invoice_no
		$this->invoice_no->setDbValueDef($rsnew, $this->invoice_no->CurrentValue, NULL, FALSE);

		// invoice_date
		$this->invoice_date->setDbValueDef($rsnew, UnFormatDateTime($this->invoice_date->CurrentValue, 7), NULL, FALSE);

		// first_counter
		$this->first_counter->setDbValueDef($rsnew, $this->first_counter->CurrentValue, NULL, FALSE);

		// guarantee
		$this->guarantee->setDbValueDef($rsnew, $this->guarantee->CurrentValue, NULL, FALSE);

		// valid_till
		$this->valid_till->setDbValueDef($rsnew, UnFormatDateTime($this->valid_till->CurrentValue, 7), NULL, FALSE);

		// valid_till_counter
		$this->valid_till_counter->setDbValueDef($rsnew, $this->valid_till_counter->CurrentValue, NULL, FALSE);

		// free_service
		$this->free_service->setDbValueDef($rsnew, $this->free_service->CurrentValue, NULL, FALSE);

		// toner_life
		$this->toner_life->setDbValueDef($rsnew, $this->toner_life->CurrentValue, NULL, FALSE);

		// drum_life
		$this->drum_life->setDbValueDef($rsnew, $this->drum_life->CurrentValue, NULL, FALSE);

		// developer_life
		$this->developer_life->setDbValueDef($rsnew, $this->developer_life->CurrentValue, NULL, FALSE);

		// date_install
		$this->date_install->setDbValueDef($rsnew, UnFormatDateTime($this->date_install->CurrentValue, 7), NULL, FALSE);

		// date_start
		$this->date_start->setDbValueDef($rsnew, UnFormatDateTime($this->date_start->CurrentValue, 7), NULL, FALSE);

		// remark
		$this->remark->setDbValueDef($rsnew, $this->remark->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// copy_average_1
		$this->copy_average_1->setDbValueDef($rsnew, $this->copy_average_1->CurrentValue, NULL, FALSE);

		// copy_average_2
		$this->copy_average_2->setDbValueDef($rsnew, $this->copy_average_2->CurrentValue, NULL, FALSE);

		// copy_average_3
		$this->copy_average_3->setDbValueDef($rsnew, $this->copy_average_3->CurrentValue, NULL, FALSE);

		// schedule_service_type
		$this->schedule_service_type->setDbValueDef($rsnew, $this->schedule_service_type->CurrentValue, 0, FALSE);

		// schedule_service_interval_days
		$this->schedule_service_interval_days->setDbValueDef($rsnew, $this->schedule_service_interval_days->CurrentValue, 0, FALSE);

		// schedule_service_updated_till
		$this->schedule_service_updated_till->setDbValueDef($rsnew, UnFormatDateTime($this->schedule_service_updated_till->CurrentValue, 0), CurrentDate(), FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("client_hardware_datalist.php"), "", $this->TableVar, TRUE);
		$pageId = "addopt";
		$Breadcrumb->add("addopt", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_customer_grp":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_personal_ref":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_customer_grp":
							break;
						case "x_partner_id":
							break;
						case "x_area":
							break;
						case "x_personal_ref":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'client_hardware_data');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>