<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class client_hardware_data_list extends client_hardware_data
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'client_hardware_data';

	// Page object name
	public $PageObjName = "client_hardware_data_list";

	// Grid form hidden field names
	public $FormName = "fclient_hardware_datalist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (client_hardware_data)
		if (!isset($GLOBALS["client_hardware_data"]) || get_class($GLOBALS["client_hardware_data"]) == PROJECT_NAMESPACE . "client_hardware_data") {
			$GLOBALS["client_hardware_data"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["client_hardware_data"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "client_hardware_dataadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "client_hardware_datadelete.php";
		$this->MultiUpdateUrl = "client_hardware_dataupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fclient_hardware_datalistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $client_hardware_data;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($client_hardware_data);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->customer_grp->Visible = FALSE;
		$this->ref->setVisibility();
		$this->partner_id->setVisibility();
		$this->name_ref->setVisibility();
		$this->city_name->setVisibility();
		$this->area->setVisibility();
		$this->billing_name->Visible = FALSE;
		$this->address->Visible = FALSE;
		$this->personal_ref->Visible = FALSE;
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->rid->Visible = FALSE;
		$this->rid_1->Visible = FALSE;
		$this->harward_code->setVisibility();
		$this->serial_no->setVisibility();
		$this->invoice_no->Visible = FALSE;
		$this->invoice_date->Visible = FALSE;
		$this->first_counter->Visible = FALSE;
		$this->guarantee->Visible = FALSE;
		$this->valid_till->Visible = FALSE;
		$this->valid_till_counter->Visible = FALSE;
		$this->free_service->Visible = FALSE;
		$this->toner_life->Visible = FALSE;
		$this->drum_life->Visible = FALSE;
		$this->developer_life->Visible = FALSE;
		$this->date_install->setVisibility();
		$this->date_start->Visible = FALSE;
		$this->remark->setVisibility();
		$this->status->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->copy_average_1->setVisibility();
		$this->copy_average_2->setVisibility();
		$this->copy_average_3->setVisibility();
		$this->schedule_service_type->setVisibility();
		$this->schedule_service_interval_days->setVisibility();
		$this->schedule_service_updated_till->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->customer_grp);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->area);
		$this->setupLookupOptions($this->personal_ref);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export selected records
		if ($this->isExport())
			$this->CurrentFilter = $this->buildExportSelectedFilter();

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fclient_hardware_datalistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->customer_grp->AdvancedSearch->toJson(), ","); // Field customer_grp
		$filterList = Concat($filterList, $this->ref->AdvancedSearch->toJson(), ","); // Field ref
		$filterList = Concat($filterList, $this->partner_id->AdvancedSearch->toJson(), ","); // Field partner_id
		$filterList = Concat($filterList, $this->name_ref->AdvancedSearch->toJson(), ","); // Field name_ref
		$filterList = Concat($filterList, $this->city_name->AdvancedSearch->toJson(), ","); // Field city_name
		$filterList = Concat($filterList, $this->area->AdvancedSearch->toJson(), ","); // Field area
		$filterList = Concat($filterList, $this->billing_name->AdvancedSearch->toJson(), ","); // Field billing_name
		$filterList = Concat($filterList, $this->address->AdvancedSearch->toJson(), ","); // Field address
		$filterList = Concat($filterList, $this->personal_ref->AdvancedSearch->toJson(), ","); // Field personal_ref
		$filterList = Concat($filterList, $this->harward_code->AdvancedSearch->toJson(), ","); // Field harward_code
		$filterList = Concat($filterList, $this->serial_no->AdvancedSearch->toJson(), ","); // Field serial_no
		$filterList = Concat($filterList, $this->invoice_no->AdvancedSearch->toJson(), ","); // Field invoice_no
		$filterList = Concat($filterList, $this->invoice_date->AdvancedSearch->toJson(), ","); // Field invoice_date
		$filterList = Concat($filterList, $this->first_counter->AdvancedSearch->toJson(), ","); // Field first_counter
		$filterList = Concat($filterList, $this->guarantee->AdvancedSearch->toJson(), ","); // Field guarantee
		$filterList = Concat($filterList, $this->valid_till->AdvancedSearch->toJson(), ","); // Field valid_till
		$filterList = Concat($filterList, $this->valid_till_counter->AdvancedSearch->toJson(), ","); // Field valid_till_counter
		$filterList = Concat($filterList, $this->free_service->AdvancedSearch->toJson(), ","); // Field free_service
		$filterList = Concat($filterList, $this->toner_life->AdvancedSearch->toJson(), ","); // Field toner_life
		$filterList = Concat($filterList, $this->drum_life->AdvancedSearch->toJson(), ","); // Field drum_life
		$filterList = Concat($filterList, $this->developer_life->AdvancedSearch->toJson(), ","); // Field developer_life
		$filterList = Concat($filterList, $this->date_install->AdvancedSearch->toJson(), ","); // Field date_install
		$filterList = Concat($filterList, $this->date_start->AdvancedSearch->toJson(), ","); // Field date_start
		$filterList = Concat($filterList, $this->remark->AdvancedSearch->toJson(), ","); // Field remark
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->copy_average_1->AdvancedSearch->toJson(), ","); // Field copy_average_1
		$filterList = Concat($filterList, $this->copy_average_2->AdvancedSearch->toJson(), ","); // Field copy_average_2
		$filterList = Concat($filterList, $this->copy_average_3->AdvancedSearch->toJson(), ","); // Field copy_average_3
		$filterList = Concat($filterList, $this->schedule_service_type->AdvancedSearch->toJson(), ","); // Field schedule_service_type
		$filterList = Concat($filterList, $this->schedule_service_interval_days->AdvancedSearch->toJson(), ","); // Field schedule_service_interval_days
		$filterList = Concat($filterList, $this->schedule_service_updated_till->AdvancedSearch->toJson(), ","); // Field schedule_service_updated_till
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fclient_hardware_datalistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field customer_grp
		$this->customer_grp->AdvancedSearch->SearchValue = @$filter["x_customer_grp"];
		$this->customer_grp->AdvancedSearch->SearchOperator = @$filter["z_customer_grp"];
		$this->customer_grp->AdvancedSearch->SearchCondition = @$filter["v_customer_grp"];
		$this->customer_grp->AdvancedSearch->SearchValue2 = @$filter["y_customer_grp"];
		$this->customer_grp->AdvancedSearch->SearchOperator2 = @$filter["w_customer_grp"];
		$this->customer_grp->AdvancedSearch->save();

		// Field ref
		$this->ref->AdvancedSearch->SearchValue = @$filter["x_ref"];
		$this->ref->AdvancedSearch->SearchOperator = @$filter["z_ref"];
		$this->ref->AdvancedSearch->SearchCondition = @$filter["v_ref"];
		$this->ref->AdvancedSearch->SearchValue2 = @$filter["y_ref"];
		$this->ref->AdvancedSearch->SearchOperator2 = @$filter["w_ref"];
		$this->ref->AdvancedSearch->save();

		// Field partner_id
		$this->partner_id->AdvancedSearch->SearchValue = @$filter["x_partner_id"];
		$this->partner_id->AdvancedSearch->SearchOperator = @$filter["z_partner_id"];
		$this->partner_id->AdvancedSearch->SearchCondition = @$filter["v_partner_id"];
		$this->partner_id->AdvancedSearch->SearchValue2 = @$filter["y_partner_id"];
		$this->partner_id->AdvancedSearch->SearchOperator2 = @$filter["w_partner_id"];
		$this->partner_id->AdvancedSearch->save();

		// Field name_ref
		$this->name_ref->AdvancedSearch->SearchValue = @$filter["x_name_ref"];
		$this->name_ref->AdvancedSearch->SearchOperator = @$filter["z_name_ref"];
		$this->name_ref->AdvancedSearch->SearchCondition = @$filter["v_name_ref"];
		$this->name_ref->AdvancedSearch->SearchValue2 = @$filter["y_name_ref"];
		$this->name_ref->AdvancedSearch->SearchOperator2 = @$filter["w_name_ref"];
		$this->name_ref->AdvancedSearch->save();

		// Field city_name
		$this->city_name->AdvancedSearch->SearchValue = @$filter["x_city_name"];
		$this->city_name->AdvancedSearch->SearchOperator = @$filter["z_city_name"];
		$this->city_name->AdvancedSearch->SearchCondition = @$filter["v_city_name"];
		$this->city_name->AdvancedSearch->SearchValue2 = @$filter["y_city_name"];
		$this->city_name->AdvancedSearch->SearchOperator2 = @$filter["w_city_name"];
		$this->city_name->AdvancedSearch->save();

		// Field area
		$this->area->AdvancedSearch->SearchValue = @$filter["x_area"];
		$this->area->AdvancedSearch->SearchOperator = @$filter["z_area"];
		$this->area->AdvancedSearch->SearchCondition = @$filter["v_area"];
		$this->area->AdvancedSearch->SearchValue2 = @$filter["y_area"];
		$this->area->AdvancedSearch->SearchOperator2 = @$filter["w_area"];
		$this->area->AdvancedSearch->save();

		// Field billing_name
		$this->billing_name->AdvancedSearch->SearchValue = @$filter["x_billing_name"];
		$this->billing_name->AdvancedSearch->SearchOperator = @$filter["z_billing_name"];
		$this->billing_name->AdvancedSearch->SearchCondition = @$filter["v_billing_name"];
		$this->billing_name->AdvancedSearch->SearchValue2 = @$filter["y_billing_name"];
		$this->billing_name->AdvancedSearch->SearchOperator2 = @$filter["w_billing_name"];
		$this->billing_name->AdvancedSearch->save();

		// Field address
		$this->address->AdvancedSearch->SearchValue = @$filter["x_address"];
		$this->address->AdvancedSearch->SearchOperator = @$filter["z_address"];
		$this->address->AdvancedSearch->SearchCondition = @$filter["v_address"];
		$this->address->AdvancedSearch->SearchValue2 = @$filter["y_address"];
		$this->address->AdvancedSearch->SearchOperator2 = @$filter["w_address"];
		$this->address->AdvancedSearch->save();

		// Field personal_ref
		$this->personal_ref->AdvancedSearch->SearchValue = @$filter["x_personal_ref"];
		$this->personal_ref->AdvancedSearch->SearchOperator = @$filter["z_personal_ref"];
		$this->personal_ref->AdvancedSearch->SearchCondition = @$filter["v_personal_ref"];
		$this->personal_ref->AdvancedSearch->SearchValue2 = @$filter["y_personal_ref"];
		$this->personal_ref->AdvancedSearch->SearchOperator2 = @$filter["w_personal_ref"];
		$this->personal_ref->AdvancedSearch->save();

		// Field harward_code
		$this->harward_code->AdvancedSearch->SearchValue = @$filter["x_harward_code"];
		$this->harward_code->AdvancedSearch->SearchOperator = @$filter["z_harward_code"];
		$this->harward_code->AdvancedSearch->SearchCondition = @$filter["v_harward_code"];
		$this->harward_code->AdvancedSearch->SearchValue2 = @$filter["y_harward_code"];
		$this->harward_code->AdvancedSearch->SearchOperator2 = @$filter["w_harward_code"];
		$this->harward_code->AdvancedSearch->save();

		// Field serial_no
		$this->serial_no->AdvancedSearch->SearchValue = @$filter["x_serial_no"];
		$this->serial_no->AdvancedSearch->SearchOperator = @$filter["z_serial_no"];
		$this->serial_no->AdvancedSearch->SearchCondition = @$filter["v_serial_no"];
		$this->serial_no->AdvancedSearch->SearchValue2 = @$filter["y_serial_no"];
		$this->serial_no->AdvancedSearch->SearchOperator2 = @$filter["w_serial_no"];
		$this->serial_no->AdvancedSearch->save();

		// Field invoice_no
		$this->invoice_no->AdvancedSearch->SearchValue = @$filter["x_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchOperator = @$filter["z_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchCondition = @$filter["v_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchValue2 = @$filter["y_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_no"];
		$this->invoice_no->AdvancedSearch->save();

		// Field invoice_date
		$this->invoice_date->AdvancedSearch->SearchValue = @$filter["x_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator = @$filter["z_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchCondition = @$filter["v_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchValue2 = @$filter["y_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_date"];
		$this->invoice_date->AdvancedSearch->save();

		// Field first_counter
		$this->first_counter->AdvancedSearch->SearchValue = @$filter["x_first_counter"];
		$this->first_counter->AdvancedSearch->SearchOperator = @$filter["z_first_counter"];
		$this->first_counter->AdvancedSearch->SearchCondition = @$filter["v_first_counter"];
		$this->first_counter->AdvancedSearch->SearchValue2 = @$filter["y_first_counter"];
		$this->first_counter->AdvancedSearch->SearchOperator2 = @$filter["w_first_counter"];
		$this->first_counter->AdvancedSearch->save();

		// Field guarantee
		$this->guarantee->AdvancedSearch->SearchValue = @$filter["x_guarantee"];
		$this->guarantee->AdvancedSearch->SearchOperator = @$filter["z_guarantee"];
		$this->guarantee->AdvancedSearch->SearchCondition = @$filter["v_guarantee"];
		$this->guarantee->AdvancedSearch->SearchValue2 = @$filter["y_guarantee"];
		$this->guarantee->AdvancedSearch->SearchOperator2 = @$filter["w_guarantee"];
		$this->guarantee->AdvancedSearch->save();

		// Field valid_till
		$this->valid_till->AdvancedSearch->SearchValue = @$filter["x_valid_till"];
		$this->valid_till->AdvancedSearch->SearchOperator = @$filter["z_valid_till"];
		$this->valid_till->AdvancedSearch->SearchCondition = @$filter["v_valid_till"];
		$this->valid_till->AdvancedSearch->SearchValue2 = @$filter["y_valid_till"];
		$this->valid_till->AdvancedSearch->SearchOperator2 = @$filter["w_valid_till"];
		$this->valid_till->AdvancedSearch->save();

		// Field valid_till_counter
		$this->valid_till_counter->AdvancedSearch->SearchValue = @$filter["x_valid_till_counter"];
		$this->valid_till_counter->AdvancedSearch->SearchOperator = @$filter["z_valid_till_counter"];
		$this->valid_till_counter->AdvancedSearch->SearchCondition = @$filter["v_valid_till_counter"];
		$this->valid_till_counter->AdvancedSearch->SearchValue2 = @$filter["y_valid_till_counter"];
		$this->valid_till_counter->AdvancedSearch->SearchOperator2 = @$filter["w_valid_till_counter"];
		$this->valid_till_counter->AdvancedSearch->save();

		// Field free_service
		$this->free_service->AdvancedSearch->SearchValue = @$filter["x_free_service"];
		$this->free_service->AdvancedSearch->SearchOperator = @$filter["z_free_service"];
		$this->free_service->AdvancedSearch->SearchCondition = @$filter["v_free_service"];
		$this->free_service->AdvancedSearch->SearchValue2 = @$filter["y_free_service"];
		$this->free_service->AdvancedSearch->SearchOperator2 = @$filter["w_free_service"];
		$this->free_service->AdvancedSearch->save();

		// Field toner_life
		$this->toner_life->AdvancedSearch->SearchValue = @$filter["x_toner_life"];
		$this->toner_life->AdvancedSearch->SearchOperator = @$filter["z_toner_life"];
		$this->toner_life->AdvancedSearch->SearchCondition = @$filter["v_toner_life"];
		$this->toner_life->AdvancedSearch->SearchValue2 = @$filter["y_toner_life"];
		$this->toner_life->AdvancedSearch->SearchOperator2 = @$filter["w_toner_life"];
		$this->toner_life->AdvancedSearch->save();

		// Field drum_life
		$this->drum_life->AdvancedSearch->SearchValue = @$filter["x_drum_life"];
		$this->drum_life->AdvancedSearch->SearchOperator = @$filter["z_drum_life"];
		$this->drum_life->AdvancedSearch->SearchCondition = @$filter["v_drum_life"];
		$this->drum_life->AdvancedSearch->SearchValue2 = @$filter["y_drum_life"];
		$this->drum_life->AdvancedSearch->SearchOperator2 = @$filter["w_drum_life"];
		$this->drum_life->AdvancedSearch->save();

		// Field developer_life
		$this->developer_life->AdvancedSearch->SearchValue = @$filter["x_developer_life"];
		$this->developer_life->AdvancedSearch->SearchOperator = @$filter["z_developer_life"];
		$this->developer_life->AdvancedSearch->SearchCondition = @$filter["v_developer_life"];
		$this->developer_life->AdvancedSearch->SearchValue2 = @$filter["y_developer_life"];
		$this->developer_life->AdvancedSearch->SearchOperator2 = @$filter["w_developer_life"];
		$this->developer_life->AdvancedSearch->save();

		// Field date_install
		$this->date_install->AdvancedSearch->SearchValue = @$filter["x_date_install"];
		$this->date_install->AdvancedSearch->SearchOperator = @$filter["z_date_install"];
		$this->date_install->AdvancedSearch->SearchCondition = @$filter["v_date_install"];
		$this->date_install->AdvancedSearch->SearchValue2 = @$filter["y_date_install"];
		$this->date_install->AdvancedSearch->SearchOperator2 = @$filter["w_date_install"];
		$this->date_install->AdvancedSearch->save();

		// Field date_start
		$this->date_start->AdvancedSearch->SearchValue = @$filter["x_date_start"];
		$this->date_start->AdvancedSearch->SearchOperator = @$filter["z_date_start"];
		$this->date_start->AdvancedSearch->SearchCondition = @$filter["v_date_start"];
		$this->date_start->AdvancedSearch->SearchValue2 = @$filter["y_date_start"];
		$this->date_start->AdvancedSearch->SearchOperator2 = @$filter["w_date_start"];
		$this->date_start->AdvancedSearch->save();

		// Field remark
		$this->remark->AdvancedSearch->SearchValue = @$filter["x_remark"];
		$this->remark->AdvancedSearch->SearchOperator = @$filter["z_remark"];
		$this->remark->AdvancedSearch->SearchCondition = @$filter["v_remark"];
		$this->remark->AdvancedSearch->SearchValue2 = @$filter["y_remark"];
		$this->remark->AdvancedSearch->SearchOperator2 = @$filter["w_remark"];
		$this->remark->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field copy_average_1
		$this->copy_average_1->AdvancedSearch->SearchValue = @$filter["x_copy_average_1"];
		$this->copy_average_1->AdvancedSearch->SearchOperator = @$filter["z_copy_average_1"];
		$this->copy_average_1->AdvancedSearch->SearchCondition = @$filter["v_copy_average_1"];
		$this->copy_average_1->AdvancedSearch->SearchValue2 = @$filter["y_copy_average_1"];
		$this->copy_average_1->AdvancedSearch->SearchOperator2 = @$filter["w_copy_average_1"];
		$this->copy_average_1->AdvancedSearch->save();

		// Field copy_average_2
		$this->copy_average_2->AdvancedSearch->SearchValue = @$filter["x_copy_average_2"];
		$this->copy_average_2->AdvancedSearch->SearchOperator = @$filter["z_copy_average_2"];
		$this->copy_average_2->AdvancedSearch->SearchCondition = @$filter["v_copy_average_2"];
		$this->copy_average_2->AdvancedSearch->SearchValue2 = @$filter["y_copy_average_2"];
		$this->copy_average_2->AdvancedSearch->SearchOperator2 = @$filter["w_copy_average_2"];
		$this->copy_average_2->AdvancedSearch->save();

		// Field copy_average_3
		$this->copy_average_3->AdvancedSearch->SearchValue = @$filter["x_copy_average_3"];
		$this->copy_average_3->AdvancedSearch->SearchOperator = @$filter["z_copy_average_3"];
		$this->copy_average_3->AdvancedSearch->SearchCondition = @$filter["v_copy_average_3"];
		$this->copy_average_3->AdvancedSearch->SearchValue2 = @$filter["y_copy_average_3"];
		$this->copy_average_3->AdvancedSearch->SearchOperator2 = @$filter["w_copy_average_3"];
		$this->copy_average_3->AdvancedSearch->save();

		// Field schedule_service_type
		$this->schedule_service_type->AdvancedSearch->SearchValue = @$filter["x_schedule_service_type"];
		$this->schedule_service_type->AdvancedSearch->SearchOperator = @$filter["z_schedule_service_type"];
		$this->schedule_service_type->AdvancedSearch->SearchCondition = @$filter["v_schedule_service_type"];
		$this->schedule_service_type->AdvancedSearch->SearchValue2 = @$filter["y_schedule_service_type"];
		$this->schedule_service_type->AdvancedSearch->SearchOperator2 = @$filter["w_schedule_service_type"];
		$this->schedule_service_type->AdvancedSearch->save();

		// Field schedule_service_interval_days
		$this->schedule_service_interval_days->AdvancedSearch->SearchValue = @$filter["x_schedule_service_interval_days"];
		$this->schedule_service_interval_days->AdvancedSearch->SearchOperator = @$filter["z_schedule_service_interval_days"];
		$this->schedule_service_interval_days->AdvancedSearch->SearchCondition = @$filter["v_schedule_service_interval_days"];
		$this->schedule_service_interval_days->AdvancedSearch->SearchValue2 = @$filter["y_schedule_service_interval_days"];
		$this->schedule_service_interval_days->AdvancedSearch->SearchOperator2 = @$filter["w_schedule_service_interval_days"];
		$this->schedule_service_interval_days->AdvancedSearch->save();

		// Field schedule_service_updated_till
		$this->schedule_service_updated_till->AdvancedSearch->SearchValue = @$filter["x_schedule_service_updated_till"];
		$this->schedule_service_updated_till->AdvancedSearch->SearchOperator = @$filter["z_schedule_service_updated_till"];
		$this->schedule_service_updated_till->AdvancedSearch->SearchCondition = @$filter["v_schedule_service_updated_till"];
		$this->schedule_service_updated_till->AdvancedSearch->SearchValue2 = @$filter["y_schedule_service_updated_till"];
		$this->schedule_service_updated_till->AdvancedSearch->SearchOperator2 = @$filter["w_schedule_service_updated_till"];
		$this->schedule_service_updated_till->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->customer_grp, $default, TRUE); // customer_grp
		$this->buildSearchSql($where, $this->ref, $default, FALSE); // ref
		$this->buildSearchSql($where, $this->partner_id, $default, FALSE); // partner_id
		$this->buildSearchSql($where, $this->name_ref, $default, FALSE); // name_ref
		$this->buildSearchSql($where, $this->city_name, $default, FALSE); // city_name
		$this->buildSearchSql($where, $this->area, $default, FALSE); // area
		$this->buildSearchSql($where, $this->billing_name, $default, FALSE); // billing_name
		$this->buildSearchSql($where, $this->address, $default, FALSE); // address
		$this->buildSearchSql($where, $this->personal_ref, $default, TRUE); // personal_ref
		$this->buildSearchSql($where, $this->harward_code, $default, FALSE); // harward_code
		$this->buildSearchSql($where, $this->serial_no, $default, FALSE); // serial_no
		$this->buildSearchSql($where, $this->invoice_no, $default, FALSE); // invoice_no
		$this->buildSearchSql($where, $this->invoice_date, $default, FALSE); // invoice_date
		$this->buildSearchSql($where, $this->first_counter, $default, FALSE); // first_counter
		$this->buildSearchSql($where, $this->guarantee, $default, FALSE); // guarantee
		$this->buildSearchSql($where, $this->valid_till, $default, FALSE); // valid_till
		$this->buildSearchSql($where, $this->valid_till_counter, $default, FALSE); // valid_till_counter
		$this->buildSearchSql($where, $this->free_service, $default, FALSE); // free_service
		$this->buildSearchSql($where, $this->toner_life, $default, FALSE); // toner_life
		$this->buildSearchSql($where, $this->drum_life, $default, FALSE); // drum_life
		$this->buildSearchSql($where, $this->developer_life, $default, FALSE); // developer_life
		$this->buildSearchSql($where, $this->date_install, $default, FALSE); // date_install
		$this->buildSearchSql($where, $this->date_start, $default, FALSE); // date_start
		$this->buildSearchSql($where, $this->remark, $default, FALSE); // remark
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->copy_average_1, $default, FALSE); // copy_average_1
		$this->buildSearchSql($where, $this->copy_average_2, $default, FALSE); // copy_average_2
		$this->buildSearchSql($where, $this->copy_average_3, $default, FALSE); // copy_average_3
		$this->buildSearchSql($where, $this->schedule_service_type, $default, FALSE); // schedule_service_type
		$this->buildSearchSql($where, $this->schedule_service_interval_days, $default, FALSE); // schedule_service_interval_days
		$this->buildSearchSql($where, $this->schedule_service_updated_till, $default, FALSE); // schedule_service_updated_till

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->customer_grp->AdvancedSearch->save(); // customer_grp
			$this->ref->AdvancedSearch->save(); // ref
			$this->partner_id->AdvancedSearch->save(); // partner_id
			$this->name_ref->AdvancedSearch->save(); // name_ref
			$this->city_name->AdvancedSearch->save(); // city_name
			$this->area->AdvancedSearch->save(); // area
			$this->billing_name->AdvancedSearch->save(); // billing_name
			$this->address->AdvancedSearch->save(); // address
			$this->personal_ref->AdvancedSearch->save(); // personal_ref
			$this->harward_code->AdvancedSearch->save(); // harward_code
			$this->serial_no->AdvancedSearch->save(); // serial_no
			$this->invoice_no->AdvancedSearch->save(); // invoice_no
			$this->invoice_date->AdvancedSearch->save(); // invoice_date
			$this->first_counter->AdvancedSearch->save(); // first_counter
			$this->guarantee->AdvancedSearch->save(); // guarantee
			$this->valid_till->AdvancedSearch->save(); // valid_till
			$this->valid_till_counter->AdvancedSearch->save(); // valid_till_counter
			$this->free_service->AdvancedSearch->save(); // free_service
			$this->toner_life->AdvancedSearch->save(); // toner_life
			$this->drum_life->AdvancedSearch->save(); // drum_life
			$this->developer_life->AdvancedSearch->save(); // developer_life
			$this->date_install->AdvancedSearch->save(); // date_install
			$this->date_start->AdvancedSearch->save(); // date_start
			$this->remark->AdvancedSearch->save(); // remark
			$this->status->AdvancedSearch->save(); // status
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->copy_average_1->AdvancedSearch->save(); // copy_average_1
			$this->copy_average_2->AdvancedSearch->save(); // copy_average_2
			$this->copy_average_3->AdvancedSearch->save(); // copy_average_3
			$this->schedule_service_type->AdvancedSearch->save(); // schedule_service_type
			$this->schedule_service_interval_days->AdvancedSearch->save(); // schedule_service_interval_days
			$this->schedule_service_updated_till->AdvancedSearch->save(); // schedule_service_updated_till
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->customer_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->partner_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->name_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->city_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->area, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->address, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->personal_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->harward_code, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->serial_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->invoice_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remark, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->customer_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->partner_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->name_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->city_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->area->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->billing_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->address->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->personal_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->harward_code->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->serial_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->first_counter->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->guarantee->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->valid_till->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->valid_till_counter->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->free_service->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->toner_life->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->drum_life->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->developer_life->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->date_install->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->date_start->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remark->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->copy_average_1->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->copy_average_2->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->copy_average_3->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->schedule_service_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->schedule_service_interval_days->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->schedule_service_updated_till->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->customer_grp->AdvancedSearch->unsetSession();
		$this->ref->AdvancedSearch->unsetSession();
		$this->partner_id->AdvancedSearch->unsetSession();
		$this->name_ref->AdvancedSearch->unsetSession();
		$this->city_name->AdvancedSearch->unsetSession();
		$this->area->AdvancedSearch->unsetSession();
		$this->billing_name->AdvancedSearch->unsetSession();
		$this->address->AdvancedSearch->unsetSession();
		$this->personal_ref->AdvancedSearch->unsetSession();
		$this->harward_code->AdvancedSearch->unsetSession();
		$this->serial_no->AdvancedSearch->unsetSession();
		$this->invoice_no->AdvancedSearch->unsetSession();
		$this->invoice_date->AdvancedSearch->unsetSession();
		$this->first_counter->AdvancedSearch->unsetSession();
		$this->guarantee->AdvancedSearch->unsetSession();
		$this->valid_till->AdvancedSearch->unsetSession();
		$this->valid_till_counter->AdvancedSearch->unsetSession();
		$this->free_service->AdvancedSearch->unsetSession();
		$this->toner_life->AdvancedSearch->unsetSession();
		$this->drum_life->AdvancedSearch->unsetSession();
		$this->developer_life->AdvancedSearch->unsetSession();
		$this->date_install->AdvancedSearch->unsetSession();
		$this->date_start->AdvancedSearch->unsetSession();
		$this->remark->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->copy_average_1->AdvancedSearch->unsetSession();
		$this->copy_average_2->AdvancedSearch->unsetSession();
		$this->copy_average_3->AdvancedSearch->unsetSession();
		$this->schedule_service_type->AdvancedSearch->unsetSession();
		$this->schedule_service_interval_days->AdvancedSearch->unsetSession();
		$this->schedule_service_updated_till->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->customer_grp->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->name_ref->AdvancedSearch->load();
		$this->city_name->AdvancedSearch->load();
		$this->area->AdvancedSearch->load();
		$this->billing_name->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->personal_ref->AdvancedSearch->load();
		$this->harward_code->AdvancedSearch->load();
		$this->serial_no->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->first_counter->AdvancedSearch->load();
		$this->guarantee->AdvancedSearch->load();
		$this->valid_till->AdvancedSearch->load();
		$this->valid_till_counter->AdvancedSearch->load();
		$this->free_service->AdvancedSearch->load();
		$this->toner_life->AdvancedSearch->load();
		$this->drum_life->AdvancedSearch->load();
		$this->developer_life->AdvancedSearch->load();
		$this->date_install->AdvancedSearch->load();
		$this->date_start->AdvancedSearch->load();
		$this->remark->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->copy_average_1->AdvancedSearch->load();
		$this->copy_average_2->AdvancedSearch->load();
		$this->copy_average_3->AdvancedSearch->load();
		$this->schedule_service_type->AdvancedSearch->load();
		$this->schedule_service_interval_days->AdvancedSearch->load();
		$this->schedule_service_updated_till->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id); // id
			$this->updateSort($this->ref); // ref
			$this->updateSort($this->partner_id); // partner_id
			$this->updateSort($this->name_ref); // name_ref
			$this->updateSort($this->city_name); // city_name
			$this->updateSort($this->area); // area
			$this->updateSort($this->harward_code); // harward_code
			$this->updateSort($this->serial_no); // serial_no
			$this->updateSort($this->date_install); // date_install
			$this->updateSort($this->remark); // remark
			$this->updateSort($this->copy_average_1); // copy_average_1
			$this->updateSort($this->copy_average_2); // copy_average_2
			$this->updateSort($this->copy_average_3); // copy_average_3
			$this->updateSort($this->schedule_service_type); // schedule_service_type
			$this->updateSort($this->schedule_service_interval_days); // schedule_service_interval_days
			$this->updateSort($this->schedule_service_updated_till); // schedule_service_updated_till
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->ref->setSort("");
				$this->partner_id->setSort("");
				$this->name_ref->setSort("");
				$this->city_name->setSort("");
				$this->area->setSort("");
				$this->harward_code->setSort("");
				$this->serial_no->setSort("");
				$this->date_install->setSort("");
				$this->remark->setSort("");
				$this->copy_average_1->setSort("");
				$this->copy_average_2->setSort("");
				$this->copy_average_3->setSort("");
				$this->schedule_service_type->setSort("");
				$this->schedule_service_interval_days->setSort("");
				$this->schedule_service_updated_till->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = TRUE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fclient_hardware_datalistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fclient_hardware_datalistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fclient_hardware_datalist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fclient_hardware_datalistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"client_hardware_datasrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fclient_hardware_datalistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// customer_grp
		if (!$this->isAddOrEdit())
			$this->customer_grp->AdvancedSearch->setSearchValue(Get("x_customer_grp", Get("customer_grp", "")));
		if ($this->customer_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->customer_grp->AdvancedSearch->setSearchOperator(Get("z_customer_grp", ""));
		if (is_array($this->customer_grp->AdvancedSearch->SearchValue))
			$this->customer_grp->AdvancedSearch->SearchValue = implode(",", $this->customer_grp->AdvancedSearch->SearchValue);
		if (is_array($this->customer_grp->AdvancedSearch->SearchValue2))
			$this->customer_grp->AdvancedSearch->SearchValue2 = implode(",", $this->customer_grp->AdvancedSearch->SearchValue2);

		// ref
		if (!$this->isAddOrEdit())
			$this->ref->AdvancedSearch->setSearchValue(Get("x_ref", Get("ref", "")));
		if ($this->ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ref->AdvancedSearch->setSearchOperator(Get("z_ref", ""));

		// partner_id
		if (!$this->isAddOrEdit())
			$this->partner_id->AdvancedSearch->setSearchValue(Get("x_partner_id", Get("partner_id", "")));
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_id->AdvancedSearch->setSearchOperator(Get("z_partner_id", ""));
		$this->partner_id->AdvancedSearch->setSearchCondition(Get("v_partner_id", ""));
		$this->partner_id->AdvancedSearch->setSearchValue2(Get("y_partner_id", ""));
		if ($this->partner_id->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->partner_id->AdvancedSearch->setSearchOperator2(Get("w_partner_id", ""));

		// name_ref
		if (!$this->isAddOrEdit())
			$this->name_ref->AdvancedSearch->setSearchValue(Get("x_name_ref", Get("name_ref", "")));
		if ($this->name_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->name_ref->AdvancedSearch->setSearchOperator(Get("z_name_ref", ""));

		// city_name
		if (!$this->isAddOrEdit())
			$this->city_name->AdvancedSearch->setSearchValue(Get("x_city_name", Get("city_name", "")));
		if ($this->city_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->city_name->AdvancedSearch->setSearchOperator(Get("z_city_name", ""));

		// area
		if (!$this->isAddOrEdit())
			$this->area->AdvancedSearch->setSearchValue(Get("x_area", Get("area", "")));
		if ($this->area->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->area->AdvancedSearch->setSearchOperator(Get("z_area", ""));

		// billing_name
		if (!$this->isAddOrEdit())
			$this->billing_name->AdvancedSearch->setSearchValue(Get("x_billing_name", Get("billing_name", "")));
		if ($this->billing_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->billing_name->AdvancedSearch->setSearchOperator(Get("z_billing_name", ""));

		// address
		if (!$this->isAddOrEdit())
			$this->address->AdvancedSearch->setSearchValue(Get("x_address", Get("address", "")));
		if ($this->address->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->address->AdvancedSearch->setSearchOperator(Get("z_address", ""));

		// personal_ref
		if (!$this->isAddOrEdit())
			$this->personal_ref->AdvancedSearch->setSearchValue(Get("x_personal_ref", Get("personal_ref", "")));
		if ($this->personal_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->personal_ref->AdvancedSearch->setSearchOperator(Get("z_personal_ref", ""));
		if (is_array($this->personal_ref->AdvancedSearch->SearchValue))
			$this->personal_ref->AdvancedSearch->SearchValue = implode(",", $this->personal_ref->AdvancedSearch->SearchValue);
		if (is_array($this->personal_ref->AdvancedSearch->SearchValue2))
			$this->personal_ref->AdvancedSearch->SearchValue2 = implode(",", $this->personal_ref->AdvancedSearch->SearchValue2);

		// harward_code
		if (!$this->isAddOrEdit())
			$this->harward_code->AdvancedSearch->setSearchValue(Get("x_harward_code", Get("harward_code", "")));
		if ($this->harward_code->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->harward_code->AdvancedSearch->setSearchOperator(Get("z_harward_code", ""));

		// serial_no
		if (!$this->isAddOrEdit())
			$this->serial_no->AdvancedSearch->setSearchValue(Get("x_serial_no", Get("serial_no", "")));
		if ($this->serial_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->serial_no->AdvancedSearch->setSearchOperator(Get("z_serial_no", ""));

		// invoice_no
		if (!$this->isAddOrEdit())
			$this->invoice_no->AdvancedSearch->setSearchValue(Get("x_invoice_no", Get("invoice_no", "")));
		if ($this->invoice_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_no->AdvancedSearch->setSearchOperator(Get("z_invoice_no", ""));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue(Get("x_invoice_date", Get("invoice_date", "")));
		if ($this->invoice_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_date->AdvancedSearch->setSearchOperator(Get("z_invoice_date", ""));

		// first_counter
		if (!$this->isAddOrEdit())
			$this->first_counter->AdvancedSearch->setSearchValue(Get("x_first_counter", Get("first_counter", "")));
		if ($this->first_counter->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->first_counter->AdvancedSearch->setSearchOperator(Get("z_first_counter", ""));

		// guarantee
		if (!$this->isAddOrEdit())
			$this->guarantee->AdvancedSearch->setSearchValue(Get("x_guarantee", Get("guarantee", "")));
		if ($this->guarantee->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->guarantee->AdvancedSearch->setSearchOperator(Get("z_guarantee", ""));

		// valid_till
		if (!$this->isAddOrEdit())
			$this->valid_till->AdvancedSearch->setSearchValue(Get("x_valid_till", Get("valid_till", "")));
		if ($this->valid_till->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->valid_till->AdvancedSearch->setSearchOperator(Get("z_valid_till", ""));

		// valid_till_counter
		if (!$this->isAddOrEdit())
			$this->valid_till_counter->AdvancedSearch->setSearchValue(Get("x_valid_till_counter", Get("valid_till_counter", "")));
		if ($this->valid_till_counter->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->valid_till_counter->AdvancedSearch->setSearchOperator(Get("z_valid_till_counter", ""));

		// free_service
		if (!$this->isAddOrEdit())
			$this->free_service->AdvancedSearch->setSearchValue(Get("x_free_service", Get("free_service", "")));
		if ($this->free_service->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->free_service->AdvancedSearch->setSearchOperator(Get("z_free_service", ""));

		// toner_life
		if (!$this->isAddOrEdit())
			$this->toner_life->AdvancedSearch->setSearchValue(Get("x_toner_life", Get("toner_life", "")));
		if ($this->toner_life->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->toner_life->AdvancedSearch->setSearchOperator(Get("z_toner_life", ""));

		// drum_life
		if (!$this->isAddOrEdit())
			$this->drum_life->AdvancedSearch->setSearchValue(Get("x_drum_life", Get("drum_life", "")));
		if ($this->drum_life->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->drum_life->AdvancedSearch->setSearchOperator(Get("z_drum_life", ""));

		// developer_life
		if (!$this->isAddOrEdit())
			$this->developer_life->AdvancedSearch->setSearchValue(Get("x_developer_life", Get("developer_life", "")));
		if ($this->developer_life->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->developer_life->AdvancedSearch->setSearchOperator(Get("z_developer_life", ""));

		// date_install
		if (!$this->isAddOrEdit())
			$this->date_install->AdvancedSearch->setSearchValue(Get("x_date_install", Get("date_install", "")));
		if ($this->date_install->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->date_install->AdvancedSearch->setSearchOperator(Get("z_date_install", ""));

		// date_start
		if (!$this->isAddOrEdit())
			$this->date_start->AdvancedSearch->setSearchValue(Get("x_date_start", Get("date_start", "")));
		if ($this->date_start->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->date_start->AdvancedSearch->setSearchOperator(Get("z_date_start", ""));

		// remark
		if (!$this->isAddOrEdit())
			$this->remark->AdvancedSearch->setSearchValue(Get("x_remark", Get("remark", "")));
		if ($this->remark->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remark->AdvancedSearch->setSearchOperator(Get("z_remark", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// copy_average_1
		if (!$this->isAddOrEdit())
			$this->copy_average_1->AdvancedSearch->setSearchValue(Get("x_copy_average_1", Get("copy_average_1", "")));
		if ($this->copy_average_1->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->copy_average_1->AdvancedSearch->setSearchOperator(Get("z_copy_average_1", ""));

		// copy_average_2
		if (!$this->isAddOrEdit())
			$this->copy_average_2->AdvancedSearch->setSearchValue(Get("x_copy_average_2", Get("copy_average_2", "")));
		if ($this->copy_average_2->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->copy_average_2->AdvancedSearch->setSearchOperator(Get("z_copy_average_2", ""));

		// copy_average_3
		if (!$this->isAddOrEdit())
			$this->copy_average_3->AdvancedSearch->setSearchValue(Get("x_copy_average_3", Get("copy_average_3", "")));
		if ($this->copy_average_3->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->copy_average_3->AdvancedSearch->setSearchOperator(Get("z_copy_average_3", ""));

		// schedule_service_type
		if (!$this->isAddOrEdit())
			$this->schedule_service_type->AdvancedSearch->setSearchValue(Get("x_schedule_service_type", Get("schedule_service_type", "")));
		if ($this->schedule_service_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->schedule_service_type->AdvancedSearch->setSearchOperator(Get("z_schedule_service_type", ""));

		// schedule_service_interval_days
		if (!$this->isAddOrEdit())
			$this->schedule_service_interval_days->AdvancedSearch->setSearchValue(Get("x_schedule_service_interval_days", Get("schedule_service_interval_days", "")));
		if ($this->schedule_service_interval_days->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->schedule_service_interval_days->AdvancedSearch->setSearchOperator(Get("z_schedule_service_interval_days", ""));

		// schedule_service_updated_till
		if (!$this->isAddOrEdit())
			$this->schedule_service_updated_till->AdvancedSearch->setSearchValue(Get("x_schedule_service_updated_till", Get("schedule_service_updated_till", "")));
		if ($this->schedule_service_updated_till->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->schedule_service_updated_till->AdvancedSearch->setSearchOperator(Get("z_schedule_service_updated_till", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->customer_grp->setDbValue($row['customer_grp']);
		$this->ref->setDbValue($row['ref']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->name_ref->setDbValue($row['name_ref']);
		$this->city_name->setDbValue($row['city_name']);
		$this->area->setDbValue($row['area']);
		$this->billing_name->setDbValue($row['billing_name']);
		$this->address->setDbValue($row['address']);
		$this->personal_ref->setDbValue($row['personal_ref']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		if (array_key_exists('EV__product', $rs->fields)) {
			$this->product->VirtualValue = $rs->fields('EV__product'); // Set up virtual field value
		} else {
			$this->product->VirtualValue = ""; // Clear value
		}
		$this->rid->setDbValue($row['rid']);
		if (array_key_exists('EV__rid', $rs->fields)) {
			$this->rid->VirtualValue = $rs->fields('EV__rid'); // Set up virtual field value
		} else {
			$this->rid->VirtualValue = ""; // Clear value
		}
		$this->rid_1->setDbValue($row['rid_1']);
		$this->harward_code->setDbValue($row['harward_code']);
		$this->serial_no->setDbValue($row['serial_no']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->first_counter->setDbValue($row['first_counter']);
		$this->guarantee->setDbValue($row['guarantee']);
		$this->valid_till->setDbValue($row['valid_till']);
		$this->valid_till_counter->setDbValue($row['valid_till_counter']);
		$this->free_service->setDbValue($row['free_service']);
		$this->toner_life->setDbValue($row['toner_life']);
		$this->drum_life->setDbValue($row['drum_life']);
		$this->developer_life->setDbValue($row['developer_life']);
		$this->date_install->setDbValue($row['date_install']);
		$this->date_start->setDbValue($row['date_start']);
		$this->remark->setDbValue($row['remark']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->copy_average_1->setDbValue($row['copy_average_1']);
		$this->copy_average_2->setDbValue($row['copy_average_2']);
		$this->copy_average_3->setDbValue($row['copy_average_3']);
		$this->schedule_service_type->setDbValue($row['schedule_service_type']);
		$this->schedule_service_interval_days->setDbValue($row['schedule_service_interval_days']);
		$this->schedule_service_updated_till->setDbValue($row['schedule_service_updated_till']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['customer_grp'] = NULL;
		$row['ref'] = NULL;
		$row['partner_id'] = NULL;
		$row['name_ref'] = NULL;
		$row['city_name'] = NULL;
		$row['area'] = NULL;
		$row['billing_name'] = NULL;
		$row['address'] = NULL;
		$row['personal_ref'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['rid'] = NULL;
		$row['rid_1'] = NULL;
		$row['harward_code'] = NULL;
		$row['serial_no'] = NULL;
		$row['invoice_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['first_counter'] = NULL;
		$row['guarantee'] = NULL;
		$row['valid_till'] = NULL;
		$row['valid_till_counter'] = NULL;
		$row['free_service'] = NULL;
		$row['toner_life'] = NULL;
		$row['drum_life'] = NULL;
		$row['developer_life'] = NULL;
		$row['date_install'] = NULL;
		$row['date_start'] = NULL;
		$row['remark'] = NULL;
		$row['status'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['copy_average_1'] = NULL;
		$row['copy_average_2'] = NULL;
		$row['copy_average_3'] = NULL;
		$row['schedule_service_type'] = NULL;
		$row['schedule_service_interval_days'] = NULL;
		$row['schedule_service_updated_till'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// customer_grp
		// ref
		// partner_id
		// name_ref
		// city_name
		// area
		// billing_name
		// address
		// personal_ref
		// grp

		$this->grp->CellCssStyle = "white-space: nowrap;";

		// s_grp
		$this->s_grp->CellCssStyle = "white-space: nowrap;";

		// product
		$this->product->CellCssStyle = "white-space: nowrap;";

		// rid
		$this->rid->CellCssStyle = "white-space: nowrap;";

		// rid_1
		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// harward_code
		// serial_no
		// invoice_no
		// invoice_date
		// first_counter
		// guarantee
		// valid_till
		// valid_till_counter
		// free_service
		// toner_life
		// drum_life
		// developer_life
		// date_install
		// date_start
		// remark
		// status
		// operator
		// datetime
		// copy_average_1
		// copy_average_2
		// copy_average_3
		// schedule_service_type
		// schedule_service_interval_days
		// schedule_service_updated_till

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// customer_grp
			$curVal = strval($this->customer_grp->CurrentValue);
			if ($curVal <> "") {
				$this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
				if ($this->customer_grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->customer_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->customer_grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
					}
				}
			} else {
				$this->customer_grp->ViewValue = NULL;
			}
			$this->customer_grp->ViewCustomAttributes = "";

			// ref
			$this->ref->ViewValue = $this->ref->CurrentValue;
			$this->ref->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// name_ref
			$this->name_ref->ViewValue = $this->name_ref->CurrentValue;
			$this->name_ref->ViewCustomAttributes = "";

			// city_name
			$this->city_name->ViewValue = $this->city_name->CurrentValue;
			$this->city_name->ViewCustomAttributes = "";

			// area
			$this->area->ViewValue = $this->area->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->area->CurrentValue;
			$this->area->ViewValue = $this->area->displayValue($arwrk);
			$this->area->ViewCustomAttributes = "";

			// billing_name
			$this->billing_name->ViewValue = $this->billing_name->CurrentValue;
			$this->billing_name->ViewCustomAttributes = "";

			// personal_ref
			$curVal = strval($this->personal_ref->CurrentValue);
			if ($curVal <> "") {
				$this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
				if ($this->personal_ref->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->personal_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->personal_ref->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
							$this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
					}
				}
			} else {
				$this->personal_ref->ViewValue = NULL;
			}
			$this->personal_ref->ViewCustomAttributes = "";

			// harward_code
			$this->harward_code->ViewValue = $this->harward_code->CurrentValue;
			$this->harward_code->ViewCustomAttributes = "";

			// serial_no
			$this->serial_no->ViewValue = $this->serial_no->CurrentValue;
			$this->serial_no->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 7);
			$this->invoice_date->ViewCustomAttributes = "";

			// first_counter
			$this->first_counter->ViewValue = $this->first_counter->CurrentValue;
			$this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, 0, -2, -2, -2);
			$this->first_counter->ViewCustomAttributes = "";

			// guarantee
			if (strval($this->guarantee->CurrentValue) <> "") {
				$this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
			} else {
				$this->guarantee->ViewValue = NULL;
			}
			$this->guarantee->ViewCustomAttributes = "";

			// valid_till
			$this->valid_till->ViewValue = $this->valid_till->CurrentValue;
			$this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, 7);
			$this->valid_till->ViewCustomAttributes = "";

			// valid_till_counter
			$this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
			$this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, 0, -2, -2, -2);
			$this->valid_till_counter->ViewCustomAttributes = "";

			// free_service
			$this->free_service->ViewValue = $this->free_service->CurrentValue;
			$this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, 0, -2, -2, -2);
			$this->free_service->ViewCustomAttributes = "";

			// toner_life
			$this->toner_life->ViewValue = $this->toner_life->CurrentValue;
			$this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, 0, -2, -2, -2);
			$this->toner_life->ViewCustomAttributes = "";

			// drum_life
			$this->drum_life->ViewValue = $this->drum_life->CurrentValue;
			$this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, 0, -2, -2, -2);
			$this->drum_life->ViewCustomAttributes = "";

			// developer_life
			$this->developer_life->ViewValue = $this->developer_life->CurrentValue;
			$this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, 0, -2, -2, -2);
			$this->developer_life->ViewCustomAttributes = "";

			// date_install
			$this->date_install->ViewValue = $this->date_install->CurrentValue;
			$this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, 7);
			$this->date_install->ViewCustomAttributes = "";

			// date_start
			$this->date_start->ViewValue = $this->date_start->CurrentValue;
			$this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, 7);
			$this->date_start->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// copy_average_1
			$this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
			$this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, 0, -2, -2, -2);
			$this->copy_average_1->ViewCustomAttributes = "";

			// copy_average_2
			$this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
			$this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, 0, -2, -2, -2);
			$this->copy_average_2->ViewCustomAttributes = "";

			// copy_average_3
			$this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
			$this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, 0, -2, -2, -2);
			$this->copy_average_3->ViewCustomAttributes = "";

			// schedule_service_type
			$this->schedule_service_type->ViewValue = $this->schedule_service_type->CurrentValue;
			$this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->ViewValue, 0, -2, -2, -2);
			$this->schedule_service_type->ViewCustomAttributes = "";

			// schedule_service_interval_days
			$this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
			$this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, 0, -2, -2, -2);
			$this->schedule_service_interval_days->ViewCustomAttributes = "";

			// schedule_service_updated_till
			$this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
			$this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, 0);
			$this->schedule_service_updated_till->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";
			if (!$this->isExport())
				$this->ref->ViewValue = $this->highlightValue($this->ref);

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";
			if (!$this->isExport())
				$this->partner_id->ViewValue = $this->highlightValue($this->partner_id);

			// name_ref
			$this->name_ref->LinkCustomAttributes = "";
			$this->name_ref->HrefValue = "";
			$this->name_ref->TooltipValue = "";
			if (!$this->isExport())
				$this->name_ref->ViewValue = $this->highlightValue($this->name_ref);

			// city_name
			$this->city_name->LinkCustomAttributes = "";
			$this->city_name->HrefValue = "";
			$this->city_name->TooltipValue = "";
			if (!$this->isExport())
				$this->city_name->ViewValue = $this->highlightValue($this->city_name);

			// area
			$this->area->LinkCustomAttributes = "";
			$this->area->HrefValue = "";
			$this->area->TooltipValue = "";
			if (!$this->isExport())
				$this->area->ViewValue = $this->highlightValue($this->area);

			// harward_code
			$this->harward_code->LinkCustomAttributes = "";
			$this->harward_code->HrefValue = "";
			$this->harward_code->TooltipValue = "";
			if (!$this->isExport())
				$this->harward_code->ViewValue = $this->highlightValue($this->harward_code);

			// serial_no
			$this->serial_no->LinkCustomAttributes = "";
			$this->serial_no->HrefValue = "";
			$this->serial_no->TooltipValue = "";
			if (!$this->isExport())
				$this->serial_no->ViewValue = $this->highlightValue($this->serial_no);

			// date_install
			$this->date_install->LinkCustomAttributes = "";
			$this->date_install->HrefValue = "";
			$this->date_install->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";
			if (!$this->isExport())
				$this->remark->ViewValue = $this->highlightValue($this->remark);

			// copy_average_1
			$this->copy_average_1->LinkCustomAttributes = "";
			$this->copy_average_1->HrefValue = "";
			$this->copy_average_1->TooltipValue = "";

			// copy_average_2
			$this->copy_average_2->LinkCustomAttributes = "";
			$this->copy_average_2->HrefValue = "";
			$this->copy_average_2->TooltipValue = "";

			// copy_average_3
			$this->copy_average_3->LinkCustomAttributes = "";
			$this->copy_average_3->HrefValue = "";
			$this->copy_average_3->TooltipValue = "";

			// schedule_service_type
			$this->schedule_service_type->LinkCustomAttributes = "";
			$this->schedule_service_type->HrefValue = "";
			$this->schedule_service_type->TooltipValue = "";

			// schedule_service_interval_days
			$this->schedule_service_interval_days->LinkCustomAttributes = "";
			$this->schedule_service_interval_days->HrefValue = "";
			$this->schedule_service_interval_days->TooltipValue = "";

			// schedule_service_updated_till
			$this->schedule_service_updated_till->LinkCustomAttributes = "";
			$this->schedule_service_updated_till->HrefValue = "";
			$this->schedule_service_updated_till->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue2 = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue2);
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

			// name_ref
			$this->name_ref->EditAttrs["class"] = "form-control";
			$this->name_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name_ref->AdvancedSearch->SearchValue = HtmlDecode($this->name_ref->AdvancedSearch->SearchValue);
			$this->name_ref->EditValue = HtmlEncode($this->name_ref->AdvancedSearch->SearchValue);
			$this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

			// city_name
			$this->city_name->EditAttrs["class"] = "form-control";
			$this->city_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->city_name->AdvancedSearch->SearchValue = HtmlDecode($this->city_name->AdvancedSearch->SearchValue);
			$this->city_name->EditValue = HtmlEncode($this->city_name->AdvancedSearch->SearchValue);
			$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

			// area
			$this->area->EditAttrs["class"] = "form-control";
			$this->area->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->area->AdvancedSearch->SearchValue = HtmlDecode($this->area->AdvancedSearch->SearchValue);
			$this->area->EditValue = HtmlEncode($this->area->AdvancedSearch->SearchValue);
			$this->area->PlaceHolder = RemoveHtml($this->area->caption());

			// harward_code
			$this->harward_code->EditAttrs["class"] = "form-control";
			$this->harward_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->harward_code->AdvancedSearch->SearchValue = HtmlDecode($this->harward_code->AdvancedSearch->SearchValue);
			$this->harward_code->EditValue = HtmlEncode($this->harward_code->AdvancedSearch->SearchValue);
			$this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

			// serial_no
			$this->serial_no->EditAttrs["class"] = "form-control";
			$this->serial_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->serial_no->AdvancedSearch->SearchValue = HtmlDecode($this->serial_no->AdvancedSearch->SearchValue);
			$this->serial_no->EditValue = HtmlEncode($this->serial_no->AdvancedSearch->SearchValue);
			$this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

			// date_install
			$this->date_install->EditAttrs["class"] = "form-control";
			$this->date_install->EditCustomAttributes = "";
			$this->date_install->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date_install->AdvancedSearch->SearchValue, 7), 7));
			$this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// copy_average_1
			$this->copy_average_1->EditAttrs["class"] = "form-control";
			$this->copy_average_1->EditCustomAttributes = "";
			$this->copy_average_1->EditValue = HtmlEncode($this->copy_average_1->AdvancedSearch->SearchValue);
			$this->copy_average_1->PlaceHolder = RemoveHtml($this->copy_average_1->caption());

			// copy_average_2
			$this->copy_average_2->EditAttrs["class"] = "form-control";
			$this->copy_average_2->EditCustomAttributes = "";
			$this->copy_average_2->EditValue = HtmlEncode($this->copy_average_2->AdvancedSearch->SearchValue);
			$this->copy_average_2->PlaceHolder = RemoveHtml($this->copy_average_2->caption());

			// copy_average_3
			$this->copy_average_3->EditAttrs["class"] = "form-control";
			$this->copy_average_3->EditCustomAttributes = "";
			$this->copy_average_3->EditValue = HtmlEncode($this->copy_average_3->AdvancedSearch->SearchValue);
			$this->copy_average_3->PlaceHolder = RemoveHtml($this->copy_average_3->caption());

			// schedule_service_type
			$this->schedule_service_type->EditAttrs["class"] = "form-control";
			$this->schedule_service_type->EditCustomAttributes = "";
			$this->schedule_service_type->EditValue = HtmlEncode($this->schedule_service_type->AdvancedSearch->SearchValue);
			$this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

			// schedule_service_interval_days
			$this->schedule_service_interval_days->EditAttrs["class"] = "form-control";
			$this->schedule_service_interval_days->EditCustomAttributes = "";
			$this->schedule_service_interval_days->EditValue = HtmlEncode($this->schedule_service_interval_days->AdvancedSearch->SearchValue);
			$this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());

			// schedule_service_updated_till
			$this->schedule_service_updated_till->EditAttrs["class"] = "form-control";
			$this->schedule_service_updated_till->EditCustomAttributes = "";
			$this->schedule_service_updated_till->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->schedule_service_updated_till->AdvancedSearch->SearchValue, 0), 8));
			$this->schedule_service_updated_till->PlaceHolder = RemoveHtml($this->schedule_service_updated_till->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->customer_grp->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->name_ref->AdvancedSearch->load();
		$this->city_name->AdvancedSearch->load();
		$this->area->AdvancedSearch->load();
		$this->billing_name->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->personal_ref->AdvancedSearch->load();
		$this->harward_code->AdvancedSearch->load();
		$this->serial_no->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->first_counter->AdvancedSearch->load();
		$this->guarantee->AdvancedSearch->load();
		$this->valid_till->AdvancedSearch->load();
		$this->valid_till_counter->AdvancedSearch->load();
		$this->free_service->AdvancedSearch->load();
		$this->toner_life->AdvancedSearch->load();
		$this->drum_life->AdvancedSearch->load();
		$this->developer_life->AdvancedSearch->load();
		$this->date_install->AdvancedSearch->load();
		$this->date_start->AdvancedSearch->load();
		$this->remark->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->copy_average_1->AdvancedSearch->load();
		$this->copy_average_2->AdvancedSearch->load();
		$this->copy_average_3->AdvancedSearch->load();
		$this->schedule_service_type->AdvancedSearch->load();
		$this->schedule_service_interval_days->AdvancedSearch->load();
		$this->schedule_service_updated_till->AdvancedSearch->load();
	}

	// Build export filter for selected records
	protected function buildExportSelectedFilter()
	{
		global $Language;
		$wrkFilter = "";
		if ($this->isExport())
			$wrkFilter = $this->getFilterFromRecordKeys();
		return $wrkFilter;
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','excel',true,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','excel',false,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','word',true,true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','word',false,true);\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','pdf',true,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','pdf',false,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','html',false,true);\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','xml',false,true);\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','csv',false,true);\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" onclick=\"ew.export(document.fclient_hardware_datalist,'" . CurrentPageName() . "','print',false,true);\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_client_hardware_data\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_client_hardware_data',hdr:ew.language.phrase('ExportToEmailText'),f:document.fclient_hardware_datalist,sel:true" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_customer_grp":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_personal_ref":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_customer_grp":
							break;
						case "x_partner_id":
							break;
						case "x_area":
							break;
						case "x_personal_ref":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'client_hardware_data');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>