<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class client_hardware_data_search extends client_hardware_data
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'client_hardware_data';

	// Page object name
	public $PageObjName = "client_hardware_data_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (client_hardware_data)
		if (!isset($GLOBALS["client_hardware_data"]) || get_class($GLOBALS["client_hardware_data"]) == PROJECT_NAMESPACE . "client_hardware_data") {
			$GLOBALS["client_hardware_data"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["client_hardware_data"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'client_hardware_data');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $client_hardware_data;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($client_hardware_data);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "client_hardware_dataview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("client_hardware_datalist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->customer_grp->setVisibility();
		$this->ref->setVisibility();
		$this->partner_id->setVisibility();
		$this->name_ref->setVisibility();
		$this->city_name->setVisibility();
		$this->area->setVisibility();
		$this->billing_name->setVisibility();
		$this->address->setVisibility();
		$this->personal_ref->setVisibility();
		$this->grp->Visible = FALSE;
		$this->s_grp->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->rid->Visible = FALSE;
		$this->rid_1->Visible = FALSE;
		$this->harward_code->setVisibility();
		$this->serial_no->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->first_counter->setVisibility();
		$this->guarantee->setVisibility();
		$this->valid_till->setVisibility();
		$this->valid_till_counter->setVisibility();
		$this->free_service->setVisibility();
		$this->toner_life->setVisibility();
		$this->drum_life->setVisibility();
		$this->developer_life->setVisibility();
		$this->date_install->setVisibility();
		$this->date_start->setVisibility();
		$this->remark->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->copy_average_1->setVisibility();
		$this->copy_average_2->setVisibility();
		$this->copy_average_3->setVisibility();
		$this->schedule_service_type->setVisibility();
		$this->schedule_service_interval_days->setVisibility();
		$this->schedule_service_updated_till->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->customer_grp);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->area);
		$this->setupLookupOptions($this->personal_ref);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "client_hardware_datalist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->customer_grp); // customer_grp
		$this->buildSearchUrl($srchUrl, $this->ref); // ref
		$this->buildSearchUrl($srchUrl, $this->partner_id); // partner_id
		$this->buildSearchUrl($srchUrl, $this->name_ref); // name_ref
		$this->buildSearchUrl($srchUrl, $this->city_name); // city_name
		$this->buildSearchUrl($srchUrl, $this->area); // area
		$this->buildSearchUrl($srchUrl, $this->billing_name); // billing_name
		$this->buildSearchUrl($srchUrl, $this->address); // address
		$this->buildSearchUrl($srchUrl, $this->personal_ref); // personal_ref
		$this->buildSearchUrl($srchUrl, $this->harward_code); // harward_code
		$this->buildSearchUrl($srchUrl, $this->serial_no); // serial_no
		$this->buildSearchUrl($srchUrl, $this->invoice_no); // invoice_no
		$this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
		$this->buildSearchUrl($srchUrl, $this->first_counter); // first_counter
		$this->buildSearchUrl($srchUrl, $this->guarantee); // guarantee
		$this->buildSearchUrl($srchUrl, $this->valid_till); // valid_till
		$this->buildSearchUrl($srchUrl, $this->valid_till_counter); // valid_till_counter
		$this->buildSearchUrl($srchUrl, $this->free_service); // free_service
		$this->buildSearchUrl($srchUrl, $this->toner_life); // toner_life
		$this->buildSearchUrl($srchUrl, $this->drum_life); // drum_life
		$this->buildSearchUrl($srchUrl, $this->developer_life); // developer_life
		$this->buildSearchUrl($srchUrl, $this->date_install); // date_install
		$this->buildSearchUrl($srchUrl, $this->date_start); // date_start
		$this->buildSearchUrl($srchUrl, $this->remark); // remark
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->copy_average_1); // copy_average_1
		$this->buildSearchUrl($srchUrl, $this->copy_average_2); // copy_average_2
		$this->buildSearchUrl($srchUrl, $this->copy_average_3); // copy_average_3
		$this->buildSearchUrl($srchUrl, $this->schedule_service_type); // schedule_service_type
		$this->buildSearchUrl($srchUrl, $this->schedule_service_interval_days); // schedule_service_interval_days
		$this->buildSearchUrl($srchUrl, $this->schedule_service_updated_till); // schedule_service_updated_till
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// customer_grp
		if (!$this->isAddOrEdit())
			$this->customer_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_customer_grp"));
		$this->customer_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_customer_grp"));
		if (is_array($this->customer_grp->AdvancedSearch->SearchValue))
			$this->customer_grp->AdvancedSearch->SearchValue = implode(",", $this->customer_grp->AdvancedSearch->SearchValue);
		if (is_array($this->customer_grp->AdvancedSearch->SearchValue2))
			$this->customer_grp->AdvancedSearch->SearchValue2 = implode(",", $this->customer_grp->AdvancedSearch->SearchValue2);

		// ref
		if (!$this->isAddOrEdit())
			$this->ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ref"));
		$this->ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ref"));

		// partner_id
		if (!$this->isAddOrEdit())
			$this->partner_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_partner_id"));
		$this->partner_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_partner_id"));
		$this->partner_id->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_partner_id"));
		$this->partner_id->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_partner_id"));
		$this->partner_id->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_partner_id"));

		// name_ref
		if (!$this->isAddOrEdit())
			$this->name_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_name_ref"));
		$this->name_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_name_ref"));

		// city_name
		if (!$this->isAddOrEdit())
			$this->city_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_city_name"));
		$this->city_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_city_name"));

		// area
		if (!$this->isAddOrEdit())
			$this->area->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_area"));
		$this->area->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_area"));

		// billing_name
		if (!$this->isAddOrEdit())
			$this->billing_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_billing_name"));
		$this->billing_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_billing_name"));

		// address
		if (!$this->isAddOrEdit())
			$this->address->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_address"));
		$this->address->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_address"));

		// personal_ref
		if (!$this->isAddOrEdit())
			$this->personal_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_personal_ref"));
		$this->personal_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_personal_ref"));
		if (is_array($this->personal_ref->AdvancedSearch->SearchValue))
			$this->personal_ref->AdvancedSearch->SearchValue = implode(",", $this->personal_ref->AdvancedSearch->SearchValue);
		if (is_array($this->personal_ref->AdvancedSearch->SearchValue2))
			$this->personal_ref->AdvancedSearch->SearchValue2 = implode(",", $this->personal_ref->AdvancedSearch->SearchValue2);

		// harward_code
		if (!$this->isAddOrEdit())
			$this->harward_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_harward_code"));
		$this->harward_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_harward_code"));

		// serial_no
		if (!$this->isAddOrEdit())
			$this->serial_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_serial_no"));
		$this->serial_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_serial_no"));

		// invoice_no
		if (!$this->isAddOrEdit())
			$this->invoice_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_no"));
		$this->invoice_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_no"));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_date"));

		// first_counter
		if (!$this->isAddOrEdit())
			$this->first_counter->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_first_counter"));
		$this->first_counter->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_first_counter"));

		// guarantee
		if (!$this->isAddOrEdit())
			$this->guarantee->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_guarantee"));
		$this->guarantee->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_guarantee"));

		// valid_till
		if (!$this->isAddOrEdit())
			$this->valid_till->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_valid_till"));
		$this->valid_till->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_valid_till"));

		// valid_till_counter
		if (!$this->isAddOrEdit())
			$this->valid_till_counter->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_valid_till_counter"));
		$this->valid_till_counter->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_valid_till_counter"));

		// free_service
		if (!$this->isAddOrEdit())
			$this->free_service->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_free_service"));
		$this->free_service->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_free_service"));

		// toner_life
		if (!$this->isAddOrEdit())
			$this->toner_life->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_toner_life"));
		$this->toner_life->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_toner_life"));

		// drum_life
		if (!$this->isAddOrEdit())
			$this->drum_life->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_drum_life"));
		$this->drum_life->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_drum_life"));

		// developer_life
		if (!$this->isAddOrEdit())
			$this->developer_life->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_developer_life"));
		$this->developer_life->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_developer_life"));

		// date_install
		if (!$this->isAddOrEdit())
			$this->date_install->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_date_install"));
		$this->date_install->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_date_install"));

		// date_start
		if (!$this->isAddOrEdit())
			$this->date_start->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_date_start"));
		$this->date_start->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_date_start"));

		// remark
		if (!$this->isAddOrEdit())
			$this->remark->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remark"));
		$this->remark->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remark"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// copy_average_1
		if (!$this->isAddOrEdit())
			$this->copy_average_1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_copy_average_1"));
		$this->copy_average_1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_copy_average_1"));

		// copy_average_2
		if (!$this->isAddOrEdit())
			$this->copy_average_2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_copy_average_2"));
		$this->copy_average_2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_copy_average_2"));

		// copy_average_3
		if (!$this->isAddOrEdit())
			$this->copy_average_3->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_copy_average_3"));
		$this->copy_average_3->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_copy_average_3"));

		// schedule_service_type
		if (!$this->isAddOrEdit())
			$this->schedule_service_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_schedule_service_type"));
		$this->schedule_service_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_schedule_service_type"));

		// schedule_service_interval_days
		if (!$this->isAddOrEdit())
			$this->schedule_service_interval_days->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_schedule_service_interval_days"));
		$this->schedule_service_interval_days->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_schedule_service_interval_days"));

		// schedule_service_updated_till
		if (!$this->isAddOrEdit())
			$this->schedule_service_updated_till->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_schedule_service_updated_till"));
		$this->schedule_service_updated_till->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_schedule_service_updated_till"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// customer_grp
		// ref
		// partner_id
		// name_ref
		// city_name
		// area
		// billing_name
		// address
		// personal_ref
		// grp
		// s_grp
		// product
		// rid
		// rid_1
		// harward_code
		// serial_no
		// invoice_no
		// invoice_date
		// first_counter
		// guarantee
		// valid_till
		// valid_till_counter
		// free_service
		// toner_life
		// drum_life
		// developer_life
		// date_install
		// date_start
		// remark
		// status
		// operator
		// datetime
		// copy_average_1
		// copy_average_2
		// copy_average_3
		// schedule_service_type
		// schedule_service_interval_days
		// schedule_service_updated_till

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// customer_grp
			$curVal = strval($this->customer_grp->CurrentValue);
			if ($curVal <> "") {
				$this->customer_grp->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
				if ($this->customer_grp->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->customer_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->customer_grp->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->customer_grp->ViewValue->add($this->customer_grp->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->customer_grp->ViewValue = $this->customer_grp->CurrentValue;
					}
				}
			} else {
				$this->customer_grp->ViewValue = NULL;
			}
			$this->customer_grp->ViewCustomAttributes = "";

			// ref
			$this->ref->ViewValue = $this->ref->CurrentValue;
			$this->ref->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// name_ref
			$this->name_ref->ViewValue = $this->name_ref->CurrentValue;
			$this->name_ref->ViewCustomAttributes = "";

			// city_name
			$this->city_name->ViewValue = $this->city_name->CurrentValue;
			$this->city_name->ViewCustomAttributes = "";

			// area
			$this->area->ViewValue = $this->area->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->area->CurrentValue;
			$this->area->ViewValue = $this->area->displayValue($arwrk);
			$this->area->ViewCustomAttributes = "";

			// billing_name
			$this->billing_name->ViewValue = $this->billing_name->CurrentValue;
			$this->billing_name->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// personal_ref
			$curVal = strval($this->personal_ref->CurrentValue);
			if ($curVal <> "") {
				$this->personal_ref->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
				if ($this->personal_ref->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->personal_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->personal_ref->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
							$this->personal_ref->ViewValue->add($this->personal_ref->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->personal_ref->ViewValue = $this->personal_ref->CurrentValue;
					}
				}
			} else {
				$this->personal_ref->ViewValue = NULL;
			}
			$this->personal_ref->ViewCustomAttributes = "";

			// harward_code
			$this->harward_code->ViewValue = $this->harward_code->CurrentValue;
			$this->harward_code->ViewCustomAttributes = "";

			// serial_no
			$this->serial_no->ViewValue = $this->serial_no->CurrentValue;
			$this->serial_no->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 7);
			$this->invoice_date->ViewCustomAttributes = "";

			// first_counter
			$this->first_counter->ViewValue = $this->first_counter->CurrentValue;
			$this->first_counter->ViewValue = FormatNumber($this->first_counter->ViewValue, 0, -2, -2, -2);
			$this->first_counter->ViewCustomAttributes = "";

			// guarantee
			if (strval($this->guarantee->CurrentValue) <> "") {
				$this->guarantee->ViewValue = $this->guarantee->optionCaption($this->guarantee->CurrentValue);
			} else {
				$this->guarantee->ViewValue = NULL;
			}
			$this->guarantee->ViewCustomAttributes = "";

			// valid_till
			$this->valid_till->ViewValue = $this->valid_till->CurrentValue;
			$this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, 7);
			$this->valid_till->ViewCustomAttributes = "";

			// valid_till_counter
			$this->valid_till_counter->ViewValue = $this->valid_till_counter->CurrentValue;
			$this->valid_till_counter->ViewValue = FormatNumber($this->valid_till_counter->ViewValue, 0, -2, -2, -2);
			$this->valid_till_counter->ViewCustomAttributes = "";

			// free_service
			$this->free_service->ViewValue = $this->free_service->CurrentValue;
			$this->free_service->ViewValue = FormatNumber($this->free_service->ViewValue, 0, -2, -2, -2);
			$this->free_service->ViewCustomAttributes = "";

			// toner_life
			$this->toner_life->ViewValue = $this->toner_life->CurrentValue;
			$this->toner_life->ViewValue = FormatNumber($this->toner_life->ViewValue, 0, -2, -2, -2);
			$this->toner_life->ViewCustomAttributes = "";

			// drum_life
			$this->drum_life->ViewValue = $this->drum_life->CurrentValue;
			$this->drum_life->ViewValue = FormatNumber($this->drum_life->ViewValue, 0, -2, -2, -2);
			$this->drum_life->ViewCustomAttributes = "";

			// developer_life
			$this->developer_life->ViewValue = $this->developer_life->CurrentValue;
			$this->developer_life->ViewValue = FormatNumber($this->developer_life->ViewValue, 0, -2, -2, -2);
			$this->developer_life->ViewCustomAttributes = "";

			// date_install
			$this->date_install->ViewValue = $this->date_install->CurrentValue;
			$this->date_install->ViewValue = FormatDateTime($this->date_install->ViewValue, 7);
			$this->date_install->ViewCustomAttributes = "";

			// date_start
			$this->date_start->ViewValue = $this->date_start->CurrentValue;
			$this->date_start->ViewValue = FormatDateTime($this->date_start->ViewValue, 7);
			$this->date_start->ViewCustomAttributes = "";

			// remark
			$this->remark->ViewValue = $this->remark->CurrentValue;
			$this->remark->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 7);
			$this->datetime->ViewCustomAttributes = "";

			// copy_average_1
			$this->copy_average_1->ViewValue = $this->copy_average_1->CurrentValue;
			$this->copy_average_1->ViewValue = FormatNumber($this->copy_average_1->ViewValue, 0, -2, -2, -2);
			$this->copy_average_1->ViewCustomAttributes = "";

			// copy_average_2
			$this->copy_average_2->ViewValue = $this->copy_average_2->CurrentValue;
			$this->copy_average_2->ViewValue = FormatNumber($this->copy_average_2->ViewValue, 0, -2, -2, -2);
			$this->copy_average_2->ViewCustomAttributes = "";

			// copy_average_3
			$this->copy_average_3->ViewValue = $this->copy_average_3->CurrentValue;
			$this->copy_average_3->ViewValue = FormatNumber($this->copy_average_3->ViewValue, 0, -2, -2, -2);
			$this->copy_average_3->ViewCustomAttributes = "";

			// schedule_service_type
			$this->schedule_service_type->ViewValue = $this->schedule_service_type->CurrentValue;
			$this->schedule_service_type->ViewValue = FormatNumber($this->schedule_service_type->ViewValue, 0, -2, -2, -2);
			$this->schedule_service_type->ViewCustomAttributes = "";

			// schedule_service_interval_days
			$this->schedule_service_interval_days->ViewValue = $this->schedule_service_interval_days->CurrentValue;
			$this->schedule_service_interval_days->ViewValue = FormatNumber($this->schedule_service_interval_days->ViewValue, 0, -2, -2, -2);
			$this->schedule_service_interval_days->ViewCustomAttributes = "";

			// schedule_service_updated_till
			$this->schedule_service_updated_till->ViewValue = $this->schedule_service_updated_till->CurrentValue;
			$this->schedule_service_updated_till->ViewValue = FormatDateTime($this->schedule_service_updated_till->ViewValue, 0);
			$this->schedule_service_updated_till->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// customer_grp
			$this->customer_grp->LinkCustomAttributes = "";
			$this->customer_grp->HrefValue = "";
			$this->customer_grp->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			$this->partner_id->HrefValue = "";
			$this->partner_id->TooltipValue = "";

			// name_ref
			$this->name_ref->LinkCustomAttributes = "";
			$this->name_ref->HrefValue = "";
			$this->name_ref->TooltipValue = "";

			// city_name
			$this->city_name->LinkCustomAttributes = "";
			$this->city_name->HrefValue = "";
			$this->city_name->TooltipValue = "";

			// area
			$this->area->LinkCustomAttributes = "";
			$this->area->HrefValue = "";
			$this->area->TooltipValue = "";

			// billing_name
			$this->billing_name->LinkCustomAttributes = "";
			$this->billing_name->HrefValue = "";
			$this->billing_name->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// personal_ref
			$this->personal_ref->LinkCustomAttributes = "";
			$this->personal_ref->HrefValue = "";
			$this->personal_ref->TooltipValue = "";

			// harward_code
			$this->harward_code->LinkCustomAttributes = "";
			$this->harward_code->HrefValue = "";
			$this->harward_code->TooltipValue = "";

			// serial_no
			$this->serial_no->LinkCustomAttributes = "";
			$this->serial_no->HrefValue = "";
			$this->serial_no->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// first_counter
			$this->first_counter->LinkCustomAttributes = "";
			$this->first_counter->HrefValue = "";
			$this->first_counter->TooltipValue = "";

			// guarantee
			$this->guarantee->LinkCustomAttributes = "";
			$this->guarantee->HrefValue = "";
			$this->guarantee->TooltipValue = "";

			// valid_till
			$this->valid_till->LinkCustomAttributes = "";
			$this->valid_till->HrefValue = "";
			$this->valid_till->TooltipValue = "";

			// valid_till_counter
			$this->valid_till_counter->LinkCustomAttributes = "";
			$this->valid_till_counter->HrefValue = "";
			$this->valid_till_counter->TooltipValue = "";

			// free_service
			$this->free_service->LinkCustomAttributes = "";
			$this->free_service->HrefValue = "";
			$this->free_service->TooltipValue = "";

			// toner_life
			$this->toner_life->LinkCustomAttributes = "";
			$this->toner_life->HrefValue = "";
			$this->toner_life->TooltipValue = "";

			// drum_life
			$this->drum_life->LinkCustomAttributes = "";
			$this->drum_life->HrefValue = "";
			$this->drum_life->TooltipValue = "";

			// developer_life
			$this->developer_life->LinkCustomAttributes = "";
			$this->developer_life->HrefValue = "";
			$this->developer_life->TooltipValue = "";

			// date_install
			$this->date_install->LinkCustomAttributes = "";
			$this->date_install->HrefValue = "";
			$this->date_install->TooltipValue = "";

			// date_start
			$this->date_start->LinkCustomAttributes = "";
			$this->date_start->HrefValue = "";
			$this->date_start->TooltipValue = "";

			// remark
			$this->remark->LinkCustomAttributes = "";
			$this->remark->HrefValue = "";
			$this->remark->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// copy_average_1
			$this->copy_average_1->LinkCustomAttributes = "";
			$this->copy_average_1->HrefValue = "";
			$this->copy_average_1->TooltipValue = "";

			// copy_average_2
			$this->copy_average_2->LinkCustomAttributes = "";
			$this->copy_average_2->HrefValue = "";
			$this->copy_average_2->TooltipValue = "";

			// copy_average_3
			$this->copy_average_3->LinkCustomAttributes = "";
			$this->copy_average_3->HrefValue = "";
			$this->copy_average_3->TooltipValue = "";

			// schedule_service_type
			$this->schedule_service_type->LinkCustomAttributes = "";
			$this->schedule_service_type->HrefValue = "";
			$this->schedule_service_type->TooltipValue = "";

			// schedule_service_interval_days
			$this->schedule_service_interval_days->LinkCustomAttributes = "";
			$this->schedule_service_interval_days->HrefValue = "";
			$this->schedule_service_interval_days->TooltipValue = "";

			// schedule_service_updated_till
			$this->schedule_service_updated_till->LinkCustomAttributes = "";
			$this->schedule_service_updated_till->HrefValue = "";
			$this->schedule_service_updated_till->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// customer_grp
			$this->customer_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->customer_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->customer_grp->AdvancedSearch->ViewValue = $this->customer_grp->lookupCacheOption($curVal);
			else
				$this->customer_grp->AdvancedSearch->ViewValue = $this->customer_grp->Lookup !== NULL && is_array($this->customer_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->customer_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->customer_grp->EditValue = array_values($this->customer_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1 and `id` > 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->customer_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->customer_grp->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ref->AdvancedSearch->SearchValue = HtmlDecode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->EditValue = HtmlEncode($this->ref->AdvancedSearch->SearchValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue);
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			$this->partner_id->EditValue2 = HtmlEncode($this->partner_id->AdvancedSearch->SearchValue2);
			$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

			// name_ref
			$this->name_ref->EditAttrs["class"] = "form-control";
			$this->name_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name_ref->AdvancedSearch->SearchValue = HtmlDecode($this->name_ref->AdvancedSearch->SearchValue);
			$this->name_ref->EditValue = HtmlEncode($this->name_ref->AdvancedSearch->SearchValue);
			$this->name_ref->PlaceHolder = RemoveHtml($this->name_ref->caption());

			// city_name
			$this->city_name->EditAttrs["class"] = "form-control";
			$this->city_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->city_name->AdvancedSearch->SearchValue = HtmlDecode($this->city_name->AdvancedSearch->SearchValue);
			$this->city_name->EditValue = HtmlEncode($this->city_name->AdvancedSearch->SearchValue);
			$this->city_name->PlaceHolder = RemoveHtml($this->city_name->caption());

			// area
			$this->area->EditAttrs["class"] = "form-control";
			$this->area->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->area->AdvancedSearch->SearchValue = HtmlDecode($this->area->AdvancedSearch->SearchValue);
			$this->area->EditValue = HtmlEncode($this->area->AdvancedSearch->SearchValue);
			$arwrk = array();
			$arwrk[1] = HtmlEncode($this->area->CurrentValue);
			$this->area->EditValue = $this->area->displayValue($arwrk);
			$this->area->PlaceHolder = RemoveHtml($this->area->caption());

			// billing_name
			$this->billing_name->EditAttrs["class"] = "form-control";
			$this->billing_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->billing_name->AdvancedSearch->SearchValue = HtmlDecode($this->billing_name->AdvancedSearch->SearchValue);
			$this->billing_name->EditValue = HtmlEncode($this->billing_name->AdvancedSearch->SearchValue);
			$this->billing_name->PlaceHolder = RemoveHtml($this->billing_name->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			$this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// personal_ref
			$this->personal_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->personal_ref->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->personal_ref->AdvancedSearch->ViewValue = $this->personal_ref->lookupCacheOption($curVal);
			else
				$this->personal_ref->AdvancedSearch->ViewValue = $this->personal_ref->Lookup !== NULL && is_array($this->personal_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->personal_ref->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->personal_ref->EditValue = array_values($this->personal_ref->Lookup->Options);
				if ($this->personal_ref->AdvancedSearch->ViewValue == "")
					$this->personal_ref->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->personal_ref->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->personal_ref->AdvancedSearch->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2));
						$this->personal_ref->AdvancedSearch->ViewValue->add($this->personal_ref->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->personal_ref->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 0, -2, -2, -2);
				}
				$this->personal_ref->EditValue = $arwrk;
			}

			// harward_code
			$this->harward_code->EditAttrs["class"] = "form-control";
			$this->harward_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->harward_code->AdvancedSearch->SearchValue = HtmlDecode($this->harward_code->AdvancedSearch->SearchValue);
			$this->harward_code->EditValue = HtmlEncode($this->harward_code->AdvancedSearch->SearchValue);
			$this->harward_code->PlaceHolder = RemoveHtml($this->harward_code->caption());

			// serial_no
			$this->serial_no->EditAttrs["class"] = "form-control";
			$this->serial_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->serial_no->AdvancedSearch->SearchValue = HtmlDecode($this->serial_no->AdvancedSearch->SearchValue);
			$this->serial_no->EditValue = HtmlEncode($this->serial_no->AdvancedSearch->SearchValue);
			$this->serial_no->PlaceHolder = RemoveHtml($this->serial_no->caption());

			// invoice_no
			$this->invoice_no->EditAttrs["class"] = "form-control";
			$this->invoice_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice_no->AdvancedSearch->SearchValue = HtmlDecode($this->invoice_no->AdvancedSearch->SearchValue);
			$this->invoice_no->EditValue = HtmlEncode($this->invoice_no->AdvancedSearch->SearchValue);
			$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, 7), 7));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// first_counter
			$this->first_counter->EditAttrs["class"] = "form-control";
			$this->first_counter->EditCustomAttributes = "";
			$this->first_counter->EditValue = HtmlEncode($this->first_counter->AdvancedSearch->SearchValue);
			$this->first_counter->PlaceHolder = RemoveHtml($this->first_counter->caption());

			// guarantee
			$this->guarantee->EditAttrs["class"] = "form-control";
			$this->guarantee->EditCustomAttributes = "";
			$this->guarantee->EditValue = $this->guarantee->options(TRUE);

			// valid_till
			$this->valid_till->EditAttrs["class"] = "form-control";
			$this->valid_till->EditCustomAttributes = "";
			$this->valid_till->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->valid_till->AdvancedSearch->SearchValue, 7), 7));
			$this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

			// valid_till_counter
			$this->valid_till_counter->EditAttrs["class"] = "form-control";
			$this->valid_till_counter->EditCustomAttributes = "";
			$this->valid_till_counter->EditValue = HtmlEncode($this->valid_till_counter->AdvancedSearch->SearchValue);
			$this->valid_till_counter->PlaceHolder = RemoveHtml($this->valid_till_counter->caption());

			// free_service
			$this->free_service->EditAttrs["class"] = "form-control";
			$this->free_service->EditCustomAttributes = "";
			$this->free_service->EditValue = HtmlEncode($this->free_service->AdvancedSearch->SearchValue);
			$this->free_service->PlaceHolder = RemoveHtml($this->free_service->caption());

			// toner_life
			$this->toner_life->EditAttrs["class"] = "form-control";
			$this->toner_life->EditCustomAttributes = "";
			$this->toner_life->EditValue = HtmlEncode($this->toner_life->AdvancedSearch->SearchValue);
			$this->toner_life->PlaceHolder = RemoveHtml($this->toner_life->caption());

			// drum_life
			$this->drum_life->EditAttrs["class"] = "form-control";
			$this->drum_life->EditCustomAttributes = "";
			$this->drum_life->EditValue = HtmlEncode($this->drum_life->AdvancedSearch->SearchValue);
			$this->drum_life->PlaceHolder = RemoveHtml($this->drum_life->caption());

			// developer_life
			$this->developer_life->EditAttrs["class"] = "form-control";
			$this->developer_life->EditCustomAttributes = "";
			$this->developer_life->EditValue = HtmlEncode($this->developer_life->AdvancedSearch->SearchValue);
			$this->developer_life->PlaceHolder = RemoveHtml($this->developer_life->caption());

			// date_install
			$this->date_install->EditAttrs["class"] = "form-control";
			$this->date_install->EditCustomAttributes = "";
			$this->date_install->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date_install->AdvancedSearch->SearchValue, 7), 7));
			$this->date_install->PlaceHolder = RemoveHtml($this->date_install->caption());

			// date_start
			$this->date_start->EditAttrs["class"] = "form-control";
			$this->date_start->EditCustomAttributes = "";
			$this->date_start->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->date_start->AdvancedSearch->SearchValue, 7), 7));
			$this->date_start->PlaceHolder = RemoveHtml($this->date_start->caption());

			// remark
			$this->remark->EditAttrs["class"] = "form-control";
			$this->remark->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remark->AdvancedSearch->SearchValue = HtmlDecode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->EditValue = HtmlEncode($this->remark->AdvancedSearch->SearchValue);
			$this->remark->PlaceHolder = RemoveHtml($this->remark->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 7), 7));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// copy_average_1
			$this->copy_average_1->EditAttrs["class"] = "form-control";
			$this->copy_average_1->EditCustomAttributes = "";
			$this->copy_average_1->EditValue = HtmlEncode($this->copy_average_1->AdvancedSearch->SearchValue);
			$this->copy_average_1->PlaceHolder = RemoveHtml($this->copy_average_1->caption());

			// copy_average_2
			$this->copy_average_2->EditAttrs["class"] = "form-control";
			$this->copy_average_2->EditCustomAttributes = "";
			$this->copy_average_2->EditValue = HtmlEncode($this->copy_average_2->AdvancedSearch->SearchValue);
			$this->copy_average_2->PlaceHolder = RemoveHtml($this->copy_average_2->caption());

			// copy_average_3
			$this->copy_average_3->EditAttrs["class"] = "form-control";
			$this->copy_average_3->EditCustomAttributes = "";
			$this->copy_average_3->EditValue = HtmlEncode($this->copy_average_3->AdvancedSearch->SearchValue);
			$this->copy_average_3->PlaceHolder = RemoveHtml($this->copy_average_3->caption());

			// schedule_service_type
			$this->schedule_service_type->EditAttrs["class"] = "form-control";
			$this->schedule_service_type->EditCustomAttributes = "";
			$this->schedule_service_type->EditValue = HtmlEncode($this->schedule_service_type->AdvancedSearch->SearchValue);
			$this->schedule_service_type->PlaceHolder = RemoveHtml($this->schedule_service_type->caption());

			// schedule_service_interval_days
			$this->schedule_service_interval_days->EditAttrs["class"] = "form-control";
			$this->schedule_service_interval_days->EditCustomAttributes = "";
			$this->schedule_service_interval_days->EditValue = HtmlEncode($this->schedule_service_interval_days->AdvancedSearch->SearchValue);
			$this->schedule_service_interval_days->PlaceHolder = RemoveHtml($this->schedule_service_interval_days->caption());

			// schedule_service_updated_till
			$this->schedule_service_updated_till->EditAttrs["class"] = "form-control";
			$this->schedule_service_updated_till->EditCustomAttributes = "";
			$this->schedule_service_updated_till->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->schedule_service_updated_till->AdvancedSearch->SearchValue, 0), 8));
			$this->schedule_service_updated_till->PlaceHolder = RemoveHtml($this->schedule_service_updated_till->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckEuroDate($this->invoice_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->invoice_date->errorMessage());
		}
		if (!CheckInteger($this->first_counter->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->first_counter->errorMessage());
		}
		if (!CheckEuroDate($this->valid_till->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->valid_till->errorMessage());
		}
		if (!CheckInteger($this->valid_till_counter->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->valid_till_counter->errorMessage());
		}
		if (!CheckInteger($this->free_service->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->free_service->errorMessage());
		}
		if (!CheckInteger($this->toner_life->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->toner_life->errorMessage());
		}
		if (!CheckInteger($this->drum_life->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->drum_life->errorMessage());
		}
		if (!CheckInteger($this->developer_life->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->developer_life->errorMessage());
		}
		if (!CheckEuroDate($this->date_install->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->date_install->errorMessage());
		}
		if (!CheckEuroDate($this->date_start->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->date_start->errorMessage());
		}
		if (!CheckInteger($this->copy_average_1->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->copy_average_1->errorMessage());
		}
		if (!CheckInteger($this->copy_average_2->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->copy_average_2->errorMessage());
		}
		if (!CheckInteger($this->copy_average_3->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->copy_average_3->errorMessage());
		}
		if (!CheckInteger($this->schedule_service_type->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->schedule_service_type->errorMessage());
		}
		if (!CheckInteger($this->schedule_service_interval_days->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->schedule_service_interval_days->errorMessage());
		}
		if (!CheckDate($this->schedule_service_updated_till->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->schedule_service_updated_till->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->customer_grp->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->name_ref->AdvancedSearch->load();
		$this->city_name->AdvancedSearch->load();
		$this->area->AdvancedSearch->load();
		$this->billing_name->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->personal_ref->AdvancedSearch->load();
		$this->harward_code->AdvancedSearch->load();
		$this->serial_no->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->first_counter->AdvancedSearch->load();
		$this->guarantee->AdvancedSearch->load();
		$this->valid_till->AdvancedSearch->load();
		$this->valid_till_counter->AdvancedSearch->load();
		$this->free_service->AdvancedSearch->load();
		$this->toner_life->AdvancedSearch->load();
		$this->drum_life->AdvancedSearch->load();
		$this->developer_life->AdvancedSearch->load();
		$this->date_install->AdvancedSearch->load();
		$this->date_start->AdvancedSearch->load();
		$this->remark->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->copy_average_1->AdvancedSearch->load();
		$this->copy_average_2->AdvancedSearch->load();
		$this->copy_average_3->AdvancedSearch->load();
		$this->schedule_service_type->AdvancedSearch->load();
		$this->schedule_service_interval_days->AdvancedSearch->load();
		$this->schedule_service_updated_till->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("client_hardware_datalist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_customer_grp":
					$lookupFilter = function() {
						return "`status`=1 and `id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_personal_ref":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_customer_grp":
							break;
						case "x_partner_id":
							break;
						case "x_area":
							break;
						case "x_personal_ref":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_rid":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'client_hardware_data');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>