<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class composition_add extends composition
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'composition';

	// Page object name
	public $PageObjName = "composition_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (composition)
		if (!isset($GLOBALS["composition"]) || get_class($GLOBALS["composition"]) == PROJECT_NAMESPACE . "composition") {
			$GLOBALS["composition"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["composition"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'composition');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $composition;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($composition);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "compositionview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("compositionlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->grp->setVisibility();
		$this->wool->setVisibility();
		$this->viscose->setVisibility();
		$this->polyester->setVisibility();
		$this->cotton->setVisibility();
		$this->jute->setVisibility();
		$this->other->setVisibility();
		$this->other_name->setVisibility();
		$this->description_type->setVisibility();
		$this->code->Visible = FALSE;
		$this->composition->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->uid->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("compositionlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "compositionlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "compositionview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->wool->CurrentValue = 0;
		$this->viscose->CurrentValue = 0;
		$this->polyester->CurrentValue = 0;
		$this->cotton->CurrentValue = 0;
		$this->jute->CurrentValue = 0;
		$this->other->CurrentValue = 0;
		$this->other_name->CurrentValue = NULL;
		$this->other_name->OldValue = $this->other_name->CurrentValue;
		$this->description_type->CurrentValue = NULL;
		$this->description_type->OldValue = $this->description_type->CurrentValue;
		$this->code->CurrentValue = NULL;
		$this->code->OldValue = $this->code->CurrentValue;
		$this->composition->CurrentValue = NULL;
		$this->composition->OldValue = $this->composition->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->uid->CurrentValue = NULL;
		$this->uid->OldValue = $this->uid->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 'wool' first before field var 'x_wool'
		$val = $CurrentForm->hasValue("wool") ? $CurrentForm->getValue("wool") : $CurrentForm->getValue("x_wool");
		if (!$this->wool->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wool->Visible = FALSE; // Disable update for API request
			else
				$this->wool->setFormValue($val);
		}

		// Check field name 'viscose' first before field var 'x_viscose'
		$val = $CurrentForm->hasValue("viscose") ? $CurrentForm->getValue("viscose") : $CurrentForm->getValue("x_viscose");
		if (!$this->viscose->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->viscose->Visible = FALSE; // Disable update for API request
			else
				$this->viscose->setFormValue($val);
		}

		// Check field name 'polyester' first before field var 'x_polyester'
		$val = $CurrentForm->hasValue("polyester") ? $CurrentForm->getValue("polyester") : $CurrentForm->getValue("x_polyester");
		if (!$this->polyester->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->polyester->Visible = FALSE; // Disable update for API request
			else
				$this->polyester->setFormValue($val);
		}

		// Check field name 'cotton' first before field var 'x_cotton'
		$val = $CurrentForm->hasValue("cotton") ? $CurrentForm->getValue("cotton") : $CurrentForm->getValue("x_cotton");
		if (!$this->cotton->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cotton->Visible = FALSE; // Disable update for API request
			else
				$this->cotton->setFormValue($val);
		}

		// Check field name 'jute' first before field var 'x_jute'
		$val = $CurrentForm->hasValue("jute") ? $CurrentForm->getValue("jute") : $CurrentForm->getValue("x_jute");
		if (!$this->jute->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jute->Visible = FALSE; // Disable update for API request
			else
				$this->jute->setFormValue($val);
		}

		// Check field name 'other' first before field var 'x_other'
		$val = $CurrentForm->hasValue("other") ? $CurrentForm->getValue("other") : $CurrentForm->getValue("x_other");
		if (!$this->other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other->Visible = FALSE; // Disable update for API request
			else
				$this->other->setFormValue($val);
		}

		// Check field name 'other_name' first before field var 'x_other_name'
		$val = $CurrentForm->hasValue("other_name") ? $CurrentForm->getValue("other_name") : $CurrentForm->getValue("x_other_name");
		if (!$this->other_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_name->Visible = FALSE; // Disable update for API request
			else
				$this->other_name->setFormValue($val);
		}

		// Check field name 'description_type' first before field var 'x_description_type'
		$val = $CurrentForm->hasValue("description_type") ? $CurrentForm->getValue("description_type") : $CurrentForm->getValue("x_description_type");
		if (!$this->description_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_type->Visible = FALSE; // Disable update for API request
			else
				$this->description_type->setFormValue($val);
		}

		// Check field name 'composition' first before field var 'x_composition'
		$val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
		if (!$this->composition->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->composition->Visible = FALSE; // Disable update for API request
			else
				$this->composition->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->wool->CurrentValue = $this->wool->FormValue;
		$this->viscose->CurrentValue = $this->viscose->FormValue;
		$this->polyester->CurrentValue = $this->polyester->FormValue;
		$this->cotton->CurrentValue = $this->cotton->FormValue;
		$this->jute->CurrentValue = $this->jute->FormValue;
		$this->other->CurrentValue = $this->other->FormValue;
		$this->other_name->CurrentValue = $this->other_name->FormValue;
		$this->description_type->CurrentValue = $this->description_type->FormValue;
		$this->composition->CurrentValue = $this->composition->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->wool->setDbValue($row['wool']);
		$this->viscose->setDbValue($row['viscose']);
		$this->polyester->setDbValue($row['polyester']);
		$this->cotton->setDbValue($row['cotton']);
		$this->jute->setDbValue($row['jute']);
		$this->other->setDbValue($row['other']);
		$this->other_name->setDbValue($row['other_name']);
		$this->description_type->setDbValue($row['description_type']);
		$this->code->setDbValue($row['code']);
		$this->composition->setDbValue($row['composition']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->uid->setDbValue($row['uid']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['wool'] = $this->wool->CurrentValue;
		$row['viscose'] = $this->viscose->CurrentValue;
		$row['polyester'] = $this->polyester->CurrentValue;
		$row['cotton'] = $this->cotton->CurrentValue;
		$row['jute'] = $this->jute->CurrentValue;
		$row['other'] = $this->other->CurrentValue;
		$row['other_name'] = $this->other_name->CurrentValue;
		$row['description_type'] = $this->description_type->CurrentValue;
		$row['code'] = $this->code->CurrentValue;
		$row['composition'] = $this->composition->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['uid'] = $this->uid->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// wool
		// viscose
		// polyester
		// cotton
		// jute
		// other
		// other_name
		// description_type
		// code
		// composition
		// status
		// operator
		// datetime
		// uid

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// wool
			$this->wool->ViewValue = $this->wool->CurrentValue;
			$this->wool->ViewValue = FormatNumber($this->wool->ViewValue, 0, -2, -2, -2);
			$this->wool->ViewCustomAttributes = "";

			// viscose
			$this->viscose->ViewValue = $this->viscose->CurrentValue;
			$this->viscose->ViewValue = FormatNumber($this->viscose->ViewValue, 0, -2, -2, -2);
			$this->viscose->ViewCustomAttributes = "";

			// polyester
			$this->polyester->ViewValue = $this->polyester->CurrentValue;
			$this->polyester->ViewValue = FormatNumber($this->polyester->ViewValue, 0, -2, -2, -2);
			$this->polyester->ViewCustomAttributes = "";

			// cotton
			$this->cotton->ViewValue = $this->cotton->CurrentValue;
			$this->cotton->ViewValue = FormatNumber($this->cotton->ViewValue, 0, -2, -2, -2);
			$this->cotton->ViewCustomAttributes = "";

			// jute
			$this->jute->ViewValue = $this->jute->CurrentValue;
			$this->jute->ViewValue = FormatNumber($this->jute->ViewValue, 0, -2, -2, -2);
			$this->jute->ViewCustomAttributes = "";

			// other
			$this->other->ViewValue = $this->other->CurrentValue;
			$this->other->ViewValue = FormatNumber($this->other->ViewValue, 0, -2, -2, -2);
			$this->other->ViewCustomAttributes = "";

			// other_name
			$this->other_name->ViewValue = $this->other_name->CurrentValue;
			$this->other_name->ViewCustomAttributes = "";

			// description_type
			if (strval($this->description_type->CurrentValue) <> "") {
				$this->description_type->ViewValue = $this->description_type->optionCaption($this->description_type->CurrentValue);
			} else {
				$this->description_type->ViewValue = NULL;
			}
			$this->description_type->ViewCustomAttributes = "";

			// code
			$this->code->ViewValue = $this->code->CurrentValue;
			$this->code->ViewCustomAttributes = "";

			// composition
			$this->composition->ViewValue = $this->composition->CurrentValue;
			$this->composition->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// wool
			$this->wool->LinkCustomAttributes = "";
			$this->wool->HrefValue = "";
			$this->wool->TooltipValue = "";

			// viscose
			$this->viscose->LinkCustomAttributes = "";
			$this->viscose->HrefValue = "";
			$this->viscose->TooltipValue = "";

			// polyester
			$this->polyester->LinkCustomAttributes = "";
			$this->polyester->HrefValue = "";
			$this->polyester->TooltipValue = "";

			// cotton
			$this->cotton->LinkCustomAttributes = "";
			$this->cotton->HrefValue = "";
			$this->cotton->TooltipValue = "";

			// jute
			$this->jute->LinkCustomAttributes = "";
			$this->jute->HrefValue = "";
			$this->jute->TooltipValue = "";

			// other
			$this->other->LinkCustomAttributes = "";
			$this->other->HrefValue = "";
			$this->other->TooltipValue = "";

			// other_name
			$this->other_name->LinkCustomAttributes = "";
			$this->other_name->HrefValue = "";
			$this->other_name->TooltipValue = "";

			// description_type
			$this->description_type->LinkCustomAttributes = "";
			$this->description_type->HrefValue = "";
			$this->description_type->TooltipValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";
			$this->composition->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// wool
			$this->wool->EditAttrs["class"] = "form-control";
			$this->wool->EditCustomAttributes = "";
			$this->wool->EditValue = HtmlEncode($this->wool->CurrentValue);
			$this->wool->PlaceHolder = RemoveHtml($this->wool->caption());

			// viscose
			$this->viscose->EditAttrs["class"] = "form-control";
			$this->viscose->EditCustomAttributes = "";
			$this->viscose->EditValue = HtmlEncode($this->viscose->CurrentValue);
			$this->viscose->PlaceHolder = RemoveHtml($this->viscose->caption());

			// polyester
			$this->polyester->EditAttrs["class"] = "form-control";
			$this->polyester->EditCustomAttributes = "";
			$this->polyester->EditValue = HtmlEncode($this->polyester->CurrentValue);
			$this->polyester->PlaceHolder = RemoveHtml($this->polyester->caption());

			// cotton
			$this->cotton->EditAttrs["class"] = "form-control";
			$this->cotton->EditCustomAttributes = "";
			$this->cotton->EditValue = HtmlEncode($this->cotton->CurrentValue);
			$this->cotton->PlaceHolder = RemoveHtml($this->cotton->caption());

			// jute
			$this->jute->EditAttrs["class"] = "form-control";
			$this->jute->EditCustomAttributes = "";
			$this->jute->EditValue = HtmlEncode($this->jute->CurrentValue);
			$this->jute->PlaceHolder = RemoveHtml($this->jute->caption());

			// other
			$this->other->EditAttrs["class"] = "form-control";
			$this->other->EditCustomAttributes = "";
			$this->other->EditValue = HtmlEncode($this->other->CurrentValue);
			$this->other->PlaceHolder = RemoveHtml($this->other->caption());

			// other_name
			$this->other_name->EditAttrs["class"] = "form-control";
			$this->other_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other_name->CurrentValue = HtmlDecode($this->other_name->CurrentValue);
			$this->other_name->EditValue = HtmlEncode($this->other_name->CurrentValue);
			$this->other_name->PlaceHolder = RemoveHtml($this->other_name->caption());

			// description_type
			$this->description_type->EditAttrs["class"] = "form-control";
			$this->description_type->EditCustomAttributes = "";
			$this->description_type->EditValue = $this->description_type->options(TRUE);

			// composition
			$this->composition->EditAttrs["class"] = "form-control";
			$this->composition->EditCustomAttributes = 'readonly';
			if (REMOVE_XSS)
				$this->composition->CurrentValue = HtmlDecode($this->composition->CurrentValue);
			$this->composition->EditValue = HtmlEncode($this->composition->CurrentValue);
			$this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			// datetime
			// Add refer script
			// grp

			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// wool
			$this->wool->LinkCustomAttributes = "";
			$this->wool->HrefValue = "";

			// viscose
			$this->viscose->LinkCustomAttributes = "";
			$this->viscose->HrefValue = "";

			// polyester
			$this->polyester->LinkCustomAttributes = "";
			$this->polyester->HrefValue = "";

			// cotton
			$this->cotton->LinkCustomAttributes = "";
			$this->cotton->HrefValue = "";

			// jute
			$this->jute->LinkCustomAttributes = "";
			$this->jute->HrefValue = "";

			// other
			$this->other->LinkCustomAttributes = "";
			$this->other->HrefValue = "";

			// other_name
			$this->other_name->LinkCustomAttributes = "";
			$this->other_name->HrefValue = "";

			// description_type
			$this->description_type->LinkCustomAttributes = "";
			$this->description_type->HrefValue = "";

			// composition
			$this->composition->LinkCustomAttributes = "";
			$this->composition->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->wool->Required) {
			if (!$this->wool->IsDetailKey && $this->wool->FormValue != NULL && $this->wool->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wool->caption(), $this->wool->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->wool->FormValue)) {
			AddMessage($FormError, $this->wool->errorMessage());
		}
		if ($this->viscose->Required) {
			if (!$this->viscose->IsDetailKey && $this->viscose->FormValue != NULL && $this->viscose->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->viscose->caption(), $this->viscose->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->viscose->FormValue)) {
			AddMessage($FormError, $this->viscose->errorMessage());
		}
		if ($this->polyester->Required) {
			if (!$this->polyester->IsDetailKey && $this->polyester->FormValue != NULL && $this->polyester->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->polyester->caption(), $this->polyester->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->polyester->FormValue)) {
			AddMessage($FormError, $this->polyester->errorMessage());
		}
		if ($this->cotton->Required) {
			if (!$this->cotton->IsDetailKey && $this->cotton->FormValue != NULL && $this->cotton->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cotton->caption(), $this->cotton->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->cotton->FormValue)) {
			AddMessage($FormError, $this->cotton->errorMessage());
		}
		if ($this->jute->Required) {
			if (!$this->jute->IsDetailKey && $this->jute->FormValue != NULL && $this->jute->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jute->caption(), $this->jute->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jute->FormValue)) {
			AddMessage($FormError, $this->jute->errorMessage());
		}
		if ($this->other->Required) {
			if (!$this->other->IsDetailKey && $this->other->FormValue != NULL && $this->other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other->caption(), $this->other->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->other->FormValue)) {
			AddMessage($FormError, $this->other->errorMessage());
		}
		if ($this->other_name->Required) {
			if (!$this->other_name->IsDetailKey && $this->other_name->FormValue != NULL && $this->other_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_name->caption(), $this->other_name->RequiredErrorMessage));
			}
		}
		if ($this->description_type->Required) {
			if (!$this->description_type->IsDetailKey && $this->description_type->FormValue != NULL && $this->description_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_type->caption(), $this->description_type->RequiredErrorMessage));
			}
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->composition->Required) {
			if (!$this->composition->IsDetailKey && $this->composition->FormValue != NULL && $this->composition->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->uid->Required) {
			if (!$this->uid->IsDetailKey && $this->uid->FormValue != NULL && $this->uid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uid->caption(), $this->uid->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, NULL, FALSE);

		// wool
		$this->wool->setDbValueDef($rsnew, $this->wool->CurrentValue, 0, strval($this->wool->CurrentValue) == "");

		// viscose
		$this->viscose->setDbValueDef($rsnew, $this->viscose->CurrentValue, 0, strval($this->viscose->CurrentValue) == "");

		// polyester
		$this->polyester->setDbValueDef($rsnew, $this->polyester->CurrentValue, 0, strval($this->polyester->CurrentValue) == "");

		// cotton
		$this->cotton->setDbValueDef($rsnew, $this->cotton->CurrentValue, 0, strval($this->cotton->CurrentValue) == "");

		// jute
		$this->jute->setDbValueDef($rsnew, $this->jute->CurrentValue, 0, strval($this->jute->CurrentValue) == "");

		// other
		$this->other->setDbValueDef($rsnew, $this->other->CurrentValue, 0, strval($this->other->CurrentValue) == "");

		// other_name
		$this->other_name->setDbValueDef($rsnew, $this->other_name->CurrentValue, NULL, FALSE);

		// description_type
		$this->description_type->setDbValueDef($rsnew, $this->description_type->CurrentValue, NULL, FALSE);

		// composition
		$this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("compositionlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>