<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for cost_calculator
 */
class cost_calculator extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $buyer_id;
	public $rid;
	public $batch_no;
	public $price_inr;
	public $shape;
	public $w_cm;
	public $l_cm;
	public $bom_percent;
	public $process_percent;
	public $other_sqm;
	public $margin_percent;
	public $price;
	public $currency;
	public $dated;
	public $packing_type;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'cost_calculator';
		$this->TableName = 'cost_calculator';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`cost_calculator`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('cost_calculator', 'cost_calculator', 'x_id', 'id', '`id`', '`id`', 2, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// buyer_id
		$this->buyer_id = new DbField('cost_calculator', 'cost_calculator', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 2, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_id->Lookup = new Lookup('buyer_id', 'buyer', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// rid
		$this->rid = new DbField('cost_calculator', 'cost_calculator', 'x_rid', 'rid', '`rid`', '`rid`', 2, -1, FALSE, '`EV__rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->rid->Lookup = new Lookup('rid', 'ref', FALSE, 'id', ["product_code","","",""], [], ["x_batch_no"], [], [], [], [], '`product_code` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// batch_no
		$this->batch_no = new DbField('cost_calculator', 'cost_calculator', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 2, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Required = TRUE; // Required field
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","","",""], ["x_rid"], [], ["rid"], ["x_rid"], [], [], '`batch_no` ASC', '');
		$this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['batch_no'] = &$this->batch_no;

		// price_inr
		$this->price_inr = new DbField('cost_calculator', 'cost_calculator', 'x_price_inr', 'price_inr', '`price_inr`', '`price_inr`', 131, -1, FALSE, '`price_inr`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price_inr->Sortable = TRUE; // Allow sort
		$this->price_inr->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price_inr'] = &$this->price_inr;

		// shape
		$this->shape = new DbField('cost_calculator', 'cost_calculator', 'x_shape', 'shape', '`shape`', '`shape`', 2, -1, FALSE, '`shape`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shape->Required = TRUE; // Required field
		$this->shape->Sortable = TRUE; // Allow sort
		$this->shape->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shape->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shape->Lookup = new Lookup('shape', 'shape', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->shape->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shape'] = &$this->shape;

		// w_cm
		$this->w_cm = new DbField('cost_calculator', 'cost_calculator', 'x_w_cm', 'w_cm', '`w_cm`', '`w_cm`', 2, -1, FALSE, '`w_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->w_cm->Required = TRUE; // Required field
		$this->w_cm->Sortable = TRUE; // Allow sort
		$this->w_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['w_cm'] = &$this->w_cm;

		// l_cm
		$this->l_cm = new DbField('cost_calculator', 'cost_calculator', 'x_l_cm', 'l_cm', '`l_cm`', '`l_cm`', 2, -1, FALSE, '`l_cm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->l_cm->Required = TRUE; // Required field
		$this->l_cm->Sortable = TRUE; // Allow sort
		$this->l_cm->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['l_cm'] = &$this->l_cm;

		// bom_percent
		$this->bom_percent = new DbField('cost_calculator', 'cost_calculator', 'x_bom_percent', 'bom_percent', '`bom_percent`', '`bom_percent`', 131, -1, FALSE, '`bom_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->bom_percent->Sortable = TRUE; // Allow sort
		$this->bom_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['bom_percent'] = &$this->bom_percent;

		// process_percent
		$this->process_percent = new DbField('cost_calculator', 'cost_calculator', 'x_process_percent', 'process_percent', '`process_percent`', '`process_percent`', 131, -1, FALSE, '`process_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->process_percent->Sortable = TRUE; // Allow sort
		$this->process_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['process_percent'] = &$this->process_percent;

		// other_sqm
		$this->other_sqm = new DbField('cost_calculator', 'cost_calculator', 'x_other_sqm', 'other_sqm', '`other_sqm`', '`other_sqm`', 131, -1, FALSE, '`other_sqm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other_sqm->Sortable = TRUE; // Allow sort
		$this->other_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['other_sqm'] = &$this->other_sqm;

		// margin_percent
		$this->margin_percent = new DbField('cost_calculator', 'cost_calculator', 'x_margin_percent', 'margin_percent', '`margin_percent`', '`margin_percent`', 131, -1, FALSE, '`margin_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->margin_percent->Sortable = TRUE; // Allow sort
		$this->margin_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['margin_percent'] = &$this->margin_percent;

		// price
		$this->price = new DbField('cost_calculator', 'cost_calculator', 'x_price', 'price', '`price`', '`price`', 131, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Sortable = TRUE; // Allow sort
		$this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['price'] = &$this->price;

		// currency
		$this->currency = new DbField('cost_calculator', 'cost_calculator', 'x_currency', 'currency', '`currency`', '`currency`', 2, -1, FALSE, '`currency`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->currency->Sortable = TRUE; // Allow sort
		$this->currency->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->currency->Lookup = new Lookup('currency', 'currency', FALSE, 'id', ["code","","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['currency'] = &$this->currency;

		// dated
		$this->dated = new DbField('cost_calculator', 'cost_calculator', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 133, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// packing_type
		$this->packing_type = new DbField('cost_calculator', 'cost_calculator', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 18, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// operator
		$this->operator = new DbField('cost_calculator', 'cost_calculator', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('cost_calculator', 'cost_calculator', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`cost_calculator`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `cost_calculator`.`rid` LIMIT 1) AS `EV__rid` FROM `cost_calculator`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->rid->AdvancedSearch->SearchValue <> "" ||
			$this->rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->rid->DbValue = $row['rid'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->price_inr->DbValue = $row['price_inr'];
		$this->shape->DbValue = $row['shape'];
		$this->w_cm->DbValue = $row['w_cm'];
		$this->l_cm->DbValue = $row['l_cm'];
		$this->bom_percent->DbValue = $row['bom_percent'];
		$this->process_percent->DbValue = $row['process_percent'];
		$this->other_sqm->DbValue = $row['other_sqm'];
		$this->margin_percent->DbValue = $row['margin_percent'];
		$this->price->DbValue = $row['price'];
		$this->currency->DbValue = $row['currency'];
		$this->dated->DbValue = $row['dated'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "cost_calculatorlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "cost_calculatorview.php")
			return $Language->phrase("View");
		elseif ($pageName == "cost_calculatoredit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "cost_calculatoradd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "cost_calculatorlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("cost_calculatorview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("cost_calculatorview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "cost_calculatoradd.php?" . $this->getUrlParm($parm);
		else
			$url = "cost_calculatoradd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("cost_calculatoredit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("cost_calculatoradd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("cost_calculatordelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->price_inr->setDbValue($rs->fields('price_inr'));
		$this->shape->setDbValue($rs->fields('shape'));
		$this->w_cm->setDbValue($rs->fields('w_cm'));
		$this->l_cm->setDbValue($rs->fields('l_cm'));
		$this->bom_percent->setDbValue($rs->fields('bom_percent'));
		$this->process_percent->setDbValue($rs->fields('process_percent'));
		$this->other_sqm->setDbValue($rs->fields('other_sqm'));
		$this->margin_percent->setDbValue($rs->fields('margin_percent'));
		$this->price->setDbValue($rs->fields('price'));
		$this->currency->setDbValue($rs->fields('currency'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// buyer_id
		// rid
		// batch_no
		// price_inr
		// shape
		// w_cm
		// l_cm
		// bom_percent
		// process_percent
		// other_sqm
		// margin_percent
		// price
		// currency
		// dated
		// packing_type
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// buyer_id
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` >= 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->ViewValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// rid
		if ($this->rid->VirtualValue <> "") {
			$this->rid->ViewValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// price_inr
		$this->price_inr->ViewValue = $this->price_inr->CurrentValue;
		$this->price_inr->ViewValue = FormatNumber($this->price_inr->ViewValue, 2, -2, -2, -2);
		$this->price_inr->ViewCustomAttributes = "";

		// shape
		$curVal = strval($this->shape->CurrentValue);
		if ($curVal <> "") {
			$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
			if ($this->shape->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->shape->ViewValue = $this->shape->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shape->ViewValue = $this->shape->CurrentValue;
				}
			}
		} else {
			$this->shape->ViewValue = NULL;
		}
		$this->shape->ViewCustomAttributes = "";

		// w_cm
		$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
		$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 0, -2, -2, -2);
		$this->w_cm->ViewCustomAttributes = "";

		// l_cm
		$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
		$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 0, -2, -2, -2);
		$this->l_cm->ViewCustomAttributes = "";

		// bom_percent
		$this->bom_percent->ViewValue = $this->bom_percent->CurrentValue;
		$this->bom_percent->ViewValue = FormatNumber($this->bom_percent->ViewValue, 2, -2, -2, -2);
		$this->bom_percent->ViewCustomAttributes = "";

		// process_percent
		$this->process_percent->ViewValue = $this->process_percent->CurrentValue;
		$this->process_percent->ViewValue = FormatNumber($this->process_percent->ViewValue, 2, -2, -2, -2);
		$this->process_percent->ViewCustomAttributes = "";

		// other_sqm
		$this->other_sqm->ViewValue = $this->other_sqm->CurrentValue;
		$this->other_sqm->ViewValue = FormatNumber($this->other_sqm->ViewValue, 2, -2, -2, -2);
		$this->other_sqm->ViewCustomAttributes = "";

		// margin_percent
		$this->margin_percent->ViewValue = $this->margin_percent->CurrentValue;
		$this->margin_percent->ViewValue = FormatNumber($this->margin_percent->ViewValue, 2, -2, -2, -2);
		$this->margin_percent->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
		$this->price->ViewCustomAttributes = "";

		// currency
		$curVal = strval($this->currency->CurrentValue);
		if ($curVal <> "") {
			$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
			if ($this->currency->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->currency->ViewValue = $this->currency->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->currency->ViewValue = $this->currency->CurrentValue;
				}
			}
		} else {
			$this->currency->ViewValue = NULL;
		}
		$this->currency->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->batch_no->CurrentValue)) {
			$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
			$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
		} else {
			$this->batch_no->HrefValue = "";
		}
		$this->batch_no->TooltipValue = "";

		// price_inr
		$this->price_inr->LinkCustomAttributes = "";
		if (!EmptyValue($this->id->CurrentValue)) {
			$this->price_inr->HrefValue = "cost_calculator_detailedlist.php?x_cc_id=" . $this->id->CurrentValue; // Add prefix/suffix
			$this->price_inr->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->price_inr->HrefValue = FullUrl($this->price_inr->HrefValue, "href");
		} else {
			$this->price_inr->HrefValue = "";
		}
		$this->price_inr->TooltipValue = "";

		// shape
		$this->shape->LinkCustomAttributes = "";
		$this->shape->HrefValue = "";
		$this->shape->TooltipValue = "";

		// w_cm
		$this->w_cm->LinkCustomAttributes = "";
		$this->w_cm->HrefValue = "";
		$this->w_cm->TooltipValue = "";

		// l_cm
		$this->l_cm->LinkCustomAttributes = "";
		$this->l_cm->HrefValue = "";
		$this->l_cm->TooltipValue = "";

		// bom_percent
		$this->bom_percent->LinkCustomAttributes = "";
		$this->bom_percent->HrefValue = "";
		$this->bom_percent->TooltipValue = "";

		// process_percent
		$this->process_percent->LinkCustomAttributes = "";
		$this->process_percent->HrefValue = "";
		$this->process_percent->TooltipValue = "";

		// other_sqm
		$this->other_sqm->LinkCustomAttributes = "";
		$this->other_sqm->HrefValue = "";
		$this->other_sqm->TooltipValue = "";

		// margin_percent
		$this->margin_percent->LinkCustomAttributes = "";
		$this->margin_percent->HrefValue = "";
		$this->margin_percent->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// currency
		$this->currency->LinkCustomAttributes = "";
		$this->currency->HrefValue = "";
		$this->currency->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` >= 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->EditValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		if ($this->rid->VirtualValue <> "") {
			$this->rid->EditValue = $this->rid->VirtualValue;
		} else {
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`product_type`  != 9 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->rid->EditValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->EditValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->EditValue = NULL;
		}
		}
		$this->rid->ViewCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// price_inr
		$this->price_inr->EditAttrs["class"] = "form-control";
		$this->price_inr->EditCustomAttributes = "";
		$this->price_inr->EditValue = $this->price_inr->CurrentValue;
		$this->price_inr->PlaceHolder = RemoveHtml($this->price_inr->caption());
		if (strval($this->price_inr->EditValue) <> "" && is_numeric($this->price_inr->EditValue))
			$this->price_inr->EditValue = FormatNumber($this->price_inr->EditValue, -2, -2, -2, -2);

		// shape
		$this->shape->EditAttrs["class"] = "form-control";
		$this->shape->EditCustomAttributes = "";

		// w_cm
		$this->w_cm->EditAttrs["class"] = "form-control";
		$this->w_cm->EditCustomAttributes = "";
		$this->w_cm->EditValue = $this->w_cm->CurrentValue;
		$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

		// l_cm
		$this->l_cm->EditAttrs["class"] = "form-control";
		$this->l_cm->EditCustomAttributes = "";
		$this->l_cm->EditValue = $this->l_cm->CurrentValue;
		$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

		// bom_percent
		$this->bom_percent->EditAttrs["class"] = "form-control";
		$this->bom_percent->EditCustomAttributes = "";
		$this->bom_percent->EditValue = $this->bom_percent->CurrentValue;
		$this->bom_percent->PlaceHolder = RemoveHtml($this->bom_percent->caption());
		if (strval($this->bom_percent->EditValue) <> "" && is_numeric($this->bom_percent->EditValue))
			$this->bom_percent->EditValue = FormatNumber($this->bom_percent->EditValue, -2, -2, -2, -2);

		// process_percent
		$this->process_percent->EditAttrs["class"] = "form-control";
		$this->process_percent->EditCustomAttributes = "";
		$this->process_percent->EditValue = $this->process_percent->CurrentValue;
		$this->process_percent->PlaceHolder = RemoveHtml($this->process_percent->caption());
		if (strval($this->process_percent->EditValue) <> "" && is_numeric($this->process_percent->EditValue))
			$this->process_percent->EditValue = FormatNumber($this->process_percent->EditValue, -2, -2, -2, -2);

		// other_sqm
		$this->other_sqm->EditAttrs["class"] = "form-control";
		$this->other_sqm->EditCustomAttributes = "";
		$this->other_sqm->EditValue = $this->other_sqm->CurrentValue;
		$this->other_sqm->PlaceHolder = RemoveHtml($this->other_sqm->caption());
		if (strval($this->other_sqm->EditValue) <> "" && is_numeric($this->other_sqm->EditValue))
			$this->other_sqm->EditValue = FormatNumber($this->other_sqm->EditValue, -2, -2, -2, -2);

		// margin_percent
		$this->margin_percent->EditAttrs["class"] = "form-control";
		$this->margin_percent->EditCustomAttributes = "";
		$this->margin_percent->EditValue = $this->margin_percent->CurrentValue;
		$this->margin_percent->PlaceHolder = RemoveHtml($this->margin_percent->caption());
		if (strval($this->margin_percent->EditValue) <> "" && is_numeric($this->margin_percent->EditValue))
			$this->margin_percent->EditValue = FormatNumber($this->margin_percent->EditValue, -2, -2, -2, -2);

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());
		if (strval($this->price->EditValue) <> "" && is_numeric($this->price->EditValue))
			$this->price->EditValue = FormatNumber($this->price->EditValue, -2, -2, -2, -2);

		// currency
		$this->currency->EditAttrs["class"] = "form-control";
		$this->currency->EditCustomAttributes = "";

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, 8);
		$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->price_inr);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->l_cm);
					$doc->exportCaption($this->bom_percent);
					$doc->exportCaption($this->process_percent);
					$doc->exportCaption($this->other_sqm);
					$doc->exportCaption($this->margin_percent);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->price_inr);
					$doc->exportCaption($this->shape);
					$doc->exportCaption($this->w_cm);
					$doc->exportCaption($this->l_cm);
					$doc->exportCaption($this->bom_percent);
					$doc->exportCaption($this->process_percent);
					$doc->exportCaption($this->other_sqm);
					$doc->exportCaption($this->margin_percent);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->currency);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->rid);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->price_inr);
						$doc->exportField($this->shape);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->l_cm);
						$doc->exportField($this->bom_percent);
						$doc->exportField($this->process_percent);
						$doc->exportField($this->other_sqm);
						$doc->exportField($this->margin_percent);
						$doc->exportField($this->price);
						$doc->exportField($this->currency);
						$doc->exportField($this->dated);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->rid);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->price_inr);
						$doc->exportField($this->shape);
						$doc->exportField($this->w_cm);
						$doc->exportField($this->l_cm);
						$doc->exportField($this->bom_percent);
						$doc->exportField($this->process_percent);
						$doc->exportField($this->other_sqm);
						$doc->exportField($this->margin_percent);
						$doc->exportField($this->price);
						$doc->exportField($this->currency);
						$doc->exportField($this->dated);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>