<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class cost_calculator_search extends cost_calculator
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'cost_calculator';

	// Page object name
	public $PageObjName = "cost_calculator_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (cost_calculator)
		if (!isset($GLOBALS["cost_calculator"]) || get_class($GLOBALS["cost_calculator"]) == PROJECT_NAMESPACE . "cost_calculator") {
			$GLOBALS["cost_calculator"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["cost_calculator"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'cost_calculator');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $cost_calculator;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($cost_calculator);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "cost_calculatorview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("cost_calculatorlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->buyer_id->setVisibility();
		$this->rid->setVisibility();
		$this->batch_no->setVisibility();
		$this->price_inr->setVisibility();
		$this->shape->setVisibility();
		$this->w_cm->setVisibility();
		$this->l_cm->setVisibility();
		$this->bom_percent->setVisibility();
		$this->process_percent->setVisibility();
		$this->other_sqm->setVisibility();
		$this->margin_percent->setVisibility();
		$this->price->setVisibility();
		$this->currency->setVisibility();
		$this->dated->setVisibility();
		$this->packing_type->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "cost_calculatorlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
		$this->buildSearchUrl($srchUrl, $this->rid); // rid
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->price_inr); // price_inr
		$this->buildSearchUrl($srchUrl, $this->shape); // shape
		$this->buildSearchUrl($srchUrl, $this->w_cm); // w_cm
		$this->buildSearchUrl($srchUrl, $this->l_cm); // l_cm
		$this->buildSearchUrl($srchUrl, $this->bom_percent); // bom_percent
		$this->buildSearchUrl($srchUrl, $this->process_percent); // process_percent
		$this->buildSearchUrl($srchUrl, $this->other_sqm); // other_sqm
		$this->buildSearchUrl($srchUrl, $this->margin_percent); // margin_percent
		$this->buildSearchUrl($srchUrl, $this->price); // price
		$this->buildSearchUrl($srchUrl, $this->currency); // currency
		$this->buildSearchUrl($srchUrl, $this->dated); // dated
		$this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_id"));
		$this->buyer_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_id"));

		// rid
		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rid"));
		$this->rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rid"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));

		// price_inr
		if (!$this->isAddOrEdit())
			$this->price_inr->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_price_inr"));
		$this->price_inr->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_price_inr"));

		// shape
		if (!$this->isAddOrEdit())
			$this->shape->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_shape"));
		$this->shape->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_shape"));

		// w_cm
		if (!$this->isAddOrEdit())
			$this->w_cm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_w_cm"));
		$this->w_cm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_w_cm"));

		// l_cm
		if (!$this->isAddOrEdit())
			$this->l_cm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_l_cm"));
		$this->l_cm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_l_cm"));

		// bom_percent
		if (!$this->isAddOrEdit())
			$this->bom_percent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bom_percent"));
		$this->bom_percent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bom_percent"));

		// process_percent
		if (!$this->isAddOrEdit())
			$this->process_percent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_process_percent"));
		$this->process_percent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_process_percent"));

		// other_sqm
		if (!$this->isAddOrEdit())
			$this->other_sqm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other_sqm"));
		$this->other_sqm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other_sqm"));

		// margin_percent
		if (!$this->isAddOrEdit())
			$this->margin_percent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_margin_percent"));
		$this->margin_percent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_margin_percent"));

		// price
		if (!$this->isAddOrEdit())
			$this->price->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_price"));
		$this->price->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_price"));

		// currency
		if (!$this->isAddOrEdit())
			$this->currency->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_currency"));
		$this->currency->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_currency"));

		// dated
		if (!$this->isAddOrEdit())
			$this->dated->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dated"));
		$this->dated->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dated"));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_type"));
		$this->packing_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_type"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->price_inr->FormValue == $this->price_inr->CurrentValue && is_numeric(ConvertToFloatString($this->price_inr->CurrentValue)))
			$this->price_inr->CurrentValue = ConvertToFloatString($this->price_inr->CurrentValue);

		// Convert decimal values if posted back
		if ($this->bom_percent->FormValue == $this->bom_percent->CurrentValue && is_numeric(ConvertToFloatString($this->bom_percent->CurrentValue)))
			$this->bom_percent->CurrentValue = ConvertToFloatString($this->bom_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->process_percent->FormValue == $this->process_percent->CurrentValue && is_numeric(ConvertToFloatString($this->process_percent->CurrentValue)))
			$this->process_percent->CurrentValue = ConvertToFloatString($this->process_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->other_sqm->FormValue == $this->other_sqm->CurrentValue && is_numeric(ConvertToFloatString($this->other_sqm->CurrentValue)))
			$this->other_sqm->CurrentValue = ConvertToFloatString($this->other_sqm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->margin_percent->FormValue == $this->margin_percent->CurrentValue && is_numeric(ConvertToFloatString($this->margin_percent->CurrentValue)))
			$this->margin_percent->CurrentValue = ConvertToFloatString($this->margin_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// buyer_id
		// rid
		// batch_no
		// price_inr
		// shape
		// w_cm
		// l_cm
		// bom_percent
		// process_percent
		// other_sqm
		// margin_percent
		// price
		// currency
		// dated
		// packing_type
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// buyer_id
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` >= 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// rid
			if ($this->rid->VirtualValue <> "") {
				$this->rid->ViewValue = $this->rid->VirtualValue;
			} else {
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			}
			$this->rid->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// price_inr
			$this->price_inr->ViewValue = $this->price_inr->CurrentValue;
			$this->price_inr->ViewValue = FormatNumber($this->price_inr->ViewValue, 2, -2, -2, -2);
			$this->price_inr->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->shape->ViewValue = $this->shape->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// w_cm
			$this->w_cm->ViewValue = $this->w_cm->CurrentValue;
			$this->w_cm->ViewValue = FormatNumber($this->w_cm->ViewValue, 0, -2, -2, -2);
			$this->w_cm->ViewCustomAttributes = "";

			// l_cm
			$this->l_cm->ViewValue = $this->l_cm->CurrentValue;
			$this->l_cm->ViewValue = FormatNumber($this->l_cm->ViewValue, 0, -2, -2, -2);
			$this->l_cm->ViewCustomAttributes = "";

			// bom_percent
			$this->bom_percent->ViewValue = $this->bom_percent->CurrentValue;
			$this->bom_percent->ViewValue = FormatNumber($this->bom_percent->ViewValue, 2, -2, -2, -2);
			$this->bom_percent->ViewCustomAttributes = "";

			// process_percent
			$this->process_percent->ViewValue = $this->process_percent->CurrentValue;
			$this->process_percent->ViewValue = FormatNumber($this->process_percent->ViewValue, 2, -2, -2, -2);
			$this->process_percent->ViewCustomAttributes = "";

			// other_sqm
			$this->other_sqm->ViewValue = $this->other_sqm->CurrentValue;
			$this->other_sqm->ViewValue = FormatNumber($this->other_sqm->ViewValue, 2, -2, -2, -2);
			$this->other_sqm->ViewCustomAttributes = "";

			// margin_percent
			$this->margin_percent->ViewValue = $this->margin_percent->CurrentValue;
			$this->margin_percent->ViewValue = FormatNumber($this->margin_percent->ViewValue, 2, -2, -2, -2);
			$this->margin_percent->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// price_inr
			$this->price_inr->LinkCustomAttributes = "";
			if (!EmptyValue($this->id->CurrentValue)) {
				$this->price_inr->HrefValue = "cost_calculator_detailedlist.php?x_cc_id=" . $this->id->CurrentValue; // Add prefix/suffix
				$this->price_inr->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->price_inr->HrefValue = FullUrl($this->price_inr->HrefValue, "href");
			} else {
				$this->price_inr->HrefValue = "";
			}
			$this->price_inr->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// w_cm
			$this->w_cm->LinkCustomAttributes = "";
			$this->w_cm->HrefValue = "";
			$this->w_cm->TooltipValue = "";

			// l_cm
			$this->l_cm->LinkCustomAttributes = "";
			$this->l_cm->HrefValue = "";
			$this->l_cm->TooltipValue = "";

			// bom_percent
			$this->bom_percent->LinkCustomAttributes = "";
			$this->bom_percent->HrefValue = "";
			$this->bom_percent->TooltipValue = "";

			// process_percent
			$this->process_percent->LinkCustomAttributes = "";
			$this->process_percent->HrefValue = "";
			$this->process_percent->TooltipValue = "";

			// other_sqm
			$this->other_sqm->LinkCustomAttributes = "";
			$this->other_sqm->HrefValue = "";
			$this->other_sqm->TooltipValue = "";

			// margin_percent
			$this->margin_percent->LinkCustomAttributes = "";
			$this->margin_percent->HrefValue = "";
			$this->margin_percent->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->buyer_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			else
				$this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->Lookup !== NULL && is_array($this->buyer_id->Lookup->Options) ? $curVal : NULL;
			if ($this->buyer_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->buyer_id->EditValue = array_values($this->buyer_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->buyer_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` >= 1000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->buyer_id->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}

			// price_inr
			$this->price_inr->EditAttrs["class"] = "form-control";
			$this->price_inr->EditCustomAttributes = "";
			$this->price_inr->EditValue = HtmlEncode($this->price_inr->AdvancedSearch->SearchValue);
			$this->price_inr->PlaceHolder = RemoveHtml($this->price_inr->caption());

			// shape
			$this->shape->EditAttrs["class"] = "form-control";
			$this->shape->EditCustomAttributes = "";
			$curVal = trim(strval($this->shape->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->shape->AdvancedSearch->ViewValue = $this->shape->lookupCacheOption($curVal);
			else
				$this->shape->AdvancedSearch->ViewValue = $this->shape->Lookup !== NULL && is_array($this->shape->Lookup->Options) ? $curVal : NULL;
			if ($this->shape->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->shape->EditValue = array_values($this->shape->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->shape->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->shape->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->shape->EditValue = $arwrk;
			}

			// w_cm
			$this->w_cm->EditAttrs["class"] = "form-control";
			$this->w_cm->EditCustomAttributes = "";
			$this->w_cm->EditValue = HtmlEncode($this->w_cm->AdvancedSearch->SearchValue);
			$this->w_cm->PlaceHolder = RemoveHtml($this->w_cm->caption());

			// l_cm
			$this->l_cm->EditAttrs["class"] = "form-control";
			$this->l_cm->EditCustomAttributes = "";
			$this->l_cm->EditValue = HtmlEncode($this->l_cm->AdvancedSearch->SearchValue);
			$this->l_cm->PlaceHolder = RemoveHtml($this->l_cm->caption());

			// bom_percent
			$this->bom_percent->EditAttrs["class"] = "form-control";
			$this->bom_percent->EditCustomAttributes = "";
			$this->bom_percent->EditValue = HtmlEncode($this->bom_percent->AdvancedSearch->SearchValue);
			$this->bom_percent->PlaceHolder = RemoveHtml($this->bom_percent->caption());

			// process_percent
			$this->process_percent->EditAttrs["class"] = "form-control";
			$this->process_percent->EditCustomAttributes = "";
			$this->process_percent->EditValue = HtmlEncode($this->process_percent->AdvancedSearch->SearchValue);
			$this->process_percent->PlaceHolder = RemoveHtml($this->process_percent->caption());

			// other_sqm
			$this->other_sqm->EditAttrs["class"] = "form-control";
			$this->other_sqm->EditCustomAttributes = "";
			$this->other_sqm->EditValue = HtmlEncode($this->other_sqm->AdvancedSearch->SearchValue);
			$this->other_sqm->PlaceHolder = RemoveHtml($this->other_sqm->caption());

			// margin_percent
			$this->margin_percent->EditAttrs["class"] = "form-control";
			$this->margin_percent->EditCustomAttributes = "";
			$this->margin_percent->EditValue = HtmlEncode($this->margin_percent->AdvancedSearch->SearchValue);
			$this->margin_percent->PlaceHolder = RemoveHtml($this->margin_percent->caption());

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = HtmlEncode($this->price->AdvancedSearch->SearchValue);
			$this->price->PlaceHolder = RemoveHtml($this->price->caption());

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->currency->AdvancedSearch->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->AdvancedSearch->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, 0), 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckNumber($this->price_inr->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->price_inr->errorMessage());
		}
		if (!CheckInteger($this->w_cm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->w_cm->errorMessage());
		}
		if (!CheckInteger($this->l_cm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->l_cm->errorMessage());
		}
		if (!CheckNumber($this->bom_percent->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->bom_percent->errorMessage());
		}
		if (!CheckNumber($this->process_percent->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->process_percent->errorMessage());
		}
		if (!CheckNumber($this->other_sqm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->other_sqm->errorMessage());
		}
		if (!CheckNumber($this->margin_percent->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->margin_percent->errorMessage());
		}
		if (!CheckNumber($this->price->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->price->errorMessage());
		}
		if (!CheckDate($this->dated->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->dated->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->rid->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->price_inr->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->w_cm->AdvancedSearch->load();
		$this->l_cm->AdvancedSearch->load();
		$this->bom_percent->AdvancedSearch->load();
		$this->process_percent->AdvancedSearch->load();
		$this->other_sqm->AdvancedSearch->load();
		$this->margin_percent->AdvancedSearch->load();
		$this->price->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->dated->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("cost_calculatorlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` >= 1000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_rid":
					$lookupFilter = function() {
						return "`product_type`  != 9 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_rid":
							break;
						case "x_batch_no":
							break;
						case "x_shape":
							break;
						case "x_currency":
							break;
						case "x_packing_type":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>