<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for customized_message
 */
class customized_message extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $reference;
	public $message_type;
	public $wa_type;
	public $wa_id;
	public $mobile_no;
	public $_email;
	public $subject;
	public $message;
	public $sms;
	public $uploads;
	public $b_type;
	public $b_1;
	public $b_2;
	public $b_3;
	public $trigger_time;
	public $status;
	public $operator;
	public $datetime;
	public $b_4;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'customized_message';
		$this->TableName = 'customized_message';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`customized_message`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('customized_message', 'customized_message', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// reference
		$this->reference = new DbField('customized_message', 'customized_message', 'x_reference', 'reference', '`reference`', '`reference`', 200, -1, FALSE, '`reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->reference->Sortable = TRUE; // Allow sort
		$this->fields['reference'] = &$this->reference;

		// message_type
		$this->message_type = new DbField('customized_message', 'customized_message', 'x_message_type', 'message_type', '`message_type`', '`message_type`', 18, -1, FALSE, '`message_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->message_type->Sortable = TRUE; // Allow sort
		$this->message_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->message_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->message_type->Lookup = new Lookup('message_type', 'message_type', FALSE, 'id', ["item","status_text","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->message_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['message_type'] = &$this->message_type;

		// wa_type
		$this->wa_type = new DbField('customized_message', 'customized_message', 'x_wa_type', 'wa_type', '`wa_type`', '`wa_type`', 18, -1, FALSE, '`wa_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->wa_type->Sortable = TRUE; // Allow sort
		$this->wa_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->wa_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->wa_type->Lookup = new Lookup('wa_type', 'message_type', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->wa_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['wa_type'] = &$this->wa_type;

		// wa_id
		$this->wa_id = new DbField('customized_message', 'customized_message', 'x_wa_id', 'wa_id', '`wa_id`', '`wa_id`', 18, -1, FALSE, '`wa_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->wa_id->Nullable = FALSE; // NOT NULL field
		$this->wa_id->Required = TRUE; // Required field
		$this->wa_id->Sortable = TRUE; // Allow sort
		$this->wa_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->wa_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->wa_id->Lookup = new Lookup('wa_id', 'whatsapp_setup', FALSE, 'id', ["mobile","","",""], [], [], [], [], [], [], '`mobile` ASC', '');
		$this->wa_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['wa_id'] = &$this->wa_id;

		// mobile_no
		$this->mobile_no = new DbField('customized_message', 'customized_message', 'x_mobile_no', 'mobile_no', '`mobile_no`', '`mobile_no`', 201, -1, FALSE, '`mobile_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile_no->Nullable = FALSE; // NOT NULL field
		$this->mobile_no->Required = TRUE; // Required field
		$this->mobile_no->Sortable = TRUE; // Allow sort
		$this->fields['mobile_no'] = &$this->mobile_no;

		// email
		$this->_email = new DbField('customized_message', 'customized_message', 'x__email', 'email', '`email`', '`email`', 201, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->_email->DefaultErrorMessage = $Language->phrase("IncorrectEmail");
		$this->fields['email'] = &$this->_email;

		// subject
		$this->subject = new DbField('customized_message', 'customized_message', 'x_subject', 'subject', '`subject`', '`subject`', 200, -1, FALSE, '`subject`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->subject->Nullable = FALSE; // NOT NULL field
		$this->subject->Required = TRUE; // Required field
		$this->subject->Sortable = TRUE; // Allow sort
		$this->fields['subject'] = &$this->subject;

		// message
		$this->message = new DbField('customized_message', 'customized_message', 'x_message', 'message', '`message`', '`message`', 201, -1, FALSE, '`message`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->message->Sortable = TRUE; // Allow sort
		$this->fields['message'] = &$this->message;

		// sms
		$this->sms = new DbField('customized_message', 'customized_message', 'x_sms', 'sms', '`sms`', '`sms`', 201, -1, FALSE, '`sms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->sms->Sortable = TRUE; // Allow sort
		$this->fields['sms'] = &$this->sms;

		// uploads
		$this->uploads = new DbField('customized_message', 'customized_message', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->uploads->Sortable = TRUE; // Allow sort
		$this->uploads->UploadMultiple = TRUE;
		$this->uploads->Upload->UploadMultiple = TRUE;
		$this->uploads->UploadMaxFileCount = 0;
		$this->fields['uploads'] = &$this->uploads;

		// b_type
		$this->b_type = new DbField('customized_message', 'customized_message', 'x_b_type', 'b_type', '`b_type`', '`b_type`', 18, -1, FALSE, '`b_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->b_type->Sortable = TRUE; // Allow sort
		$this->b_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->b_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->b_type->Lookup = new Lookup('b_type', 'customized_message', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->b_type->OptionCount = 3;
		$this->b_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['b_type'] = &$this->b_type;

		// b_1
		$this->b_1 = new DbField('customized_message', 'customized_message', 'x_b_1', 'b_1', '`b_1`', '`b_1`', 200, -1, FALSE, '`b_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_1->Sortable = TRUE; // Allow sort
		$this->fields['b_1'] = &$this->b_1;

		// b_2
		$this->b_2 = new DbField('customized_message', 'customized_message', 'x_b_2', 'b_2', '`b_2`', '`b_2`', 200, -1, FALSE, '`b_2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_2->Sortable = TRUE; // Allow sort
		$this->fields['b_2'] = &$this->b_2;

		// b_3
		$this->b_3 = new DbField('customized_message', 'customized_message', 'x_b_3', 'b_3', '`b_3`', '`b_3`', 200, -1, FALSE, '`b_3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_3->Sortable = TRUE; // Allow sort
		$this->fields['b_3'] = &$this->b_3;

		// trigger_time
		$this->trigger_time = new DbField('customized_message', 'customized_message', 'x_trigger_time', 'trigger_time', '`trigger_time`', CastDateFieldForLike('`trigger_time`', 0, "DB"), 135, 0, FALSE, '`trigger_time`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->trigger_time->Nullable = FALSE; // NOT NULL field
		$this->trigger_time->Required = TRUE; // Required field
		$this->trigger_time->Sortable = FALSE; // Allow sort
		$this->trigger_time->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['trigger_time'] = &$this->trigger_time;

		// status
		$this->status = new DbField('customized_message', 'customized_message', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = FALSE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'customized_message', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('customized_message', 'customized_message', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('customized_message', 'customized_message', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// b_4
		$this->b_4 = new DbField('customized_message', 'customized_message', 'x_b_4', 'b_4', '`b_4`', '`b_4`', 200, -1, FALSE, '`b_4`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_4->Sortable = FALSE; // Allow sort
		$this->fields['b_4'] = &$this->b_4;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`customized_message`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->reference->DbValue = $row['reference'];
		$this->message_type->DbValue = $row['message_type'];
		$this->wa_type->DbValue = $row['wa_type'];
		$this->wa_id->DbValue = $row['wa_id'];
		$this->mobile_no->DbValue = $row['mobile_no'];
		$this->_email->DbValue = $row['email'];
		$this->subject->DbValue = $row['subject'];
		$this->message->DbValue = $row['message'];
		$this->sms->DbValue = $row['sms'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->b_type->DbValue = $row['b_type'];
		$this->b_1->DbValue = $row['b_1'];
		$this->b_2->DbValue = $row['b_2'];
		$this->b_3->DbValue = $row['b_3'];
		$this->trigger_time->DbValue = $row['trigger_time'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->b_4->DbValue = $row['b_4'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->uploads->OldUploadPath = '.p_uploads/message/' . $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['uploads']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['uploads']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "customized_messagelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "customized_messageview.php")
			return $Language->phrase("View");
		elseif ($pageName == "customized_messageedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "customized_messageadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "customized_messagelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("customized_messageview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("customized_messageview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "customized_messageadd.php?" . $this->getUrlParm($parm);
		else
			$url = "customized_messageadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("customized_messageedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("customized_messageadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("customized_messagedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->reference->setDbValue($rs->fields('reference'));
		$this->message_type->setDbValue($rs->fields('message_type'));
		$this->wa_type->setDbValue($rs->fields('wa_type'));
		$this->wa_id->setDbValue($rs->fields('wa_id'));
		$this->mobile_no->setDbValue($rs->fields('mobile_no'));
		$this->_email->setDbValue($rs->fields('email'));
		$this->subject->setDbValue($rs->fields('subject'));
		$this->message->setDbValue($rs->fields('message'));
		$this->sms->setDbValue($rs->fields('sms'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->b_type->setDbValue($rs->fields('b_type'));
		$this->b_1->setDbValue($rs->fields('b_1'));
		$this->b_2->setDbValue($rs->fields('b_2'));
		$this->b_3->setDbValue($rs->fields('b_3'));
		$this->trigger_time->setDbValue($rs->fields('trigger_time'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->b_4->setDbValue($rs->fields('b_4'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// reference
		// message_type
		// wa_type
		// wa_id
		// mobile_no
		// email
		// subject
		// message
		// sms
		// uploads
		// b_type
		// b_1
		// b_2
		// b_3
		// trigger_time

		$this->trigger_time->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// operator
		// datetime
		// b_4

		$this->b_4->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// reference
		$this->reference->ViewValue = $this->reference->CurrentValue;
		$this->reference->ViewCustomAttributes = "";

		// message_type
		$curVal = strval($this->message_type->CurrentValue);
		if ($curVal <> "") {
			$this->message_type->ViewValue = $this->message_type->lookupCacheOption($curVal);
			if ($this->message_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->message_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->message_type->ViewValue = $this->message_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->message_type->ViewValue = $this->message_type->CurrentValue;
				}
			}
		} else {
			$this->message_type->ViewValue = NULL;
		}
		$this->message_type->ViewCustomAttributes = "";

		// wa_type
		$curVal = strval($this->wa_type->CurrentValue);
		if ($curVal <> "") {
			$this->wa_type->ViewValue = $this->wa_type->lookupCacheOption($curVal);
			if ($this->wa_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 2 and `status`= 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->wa_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->wa_type->ViewValue = $this->wa_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->wa_type->ViewValue = $this->wa_type->CurrentValue;
				}
			}
		} else {
			$this->wa_type->ViewValue = NULL;
		}
		$this->wa_type->ViewCustomAttributes = "";

		// wa_id
		$curVal = strval($this->wa_id->CurrentValue);
		if ($curVal <> "") {
			$this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
			if ($this->wa_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->wa_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->wa_id->ViewValue = $this->wa_id->CurrentValue;
				}
			}
		} else {
			$this->wa_id->ViewValue = NULL;
		}
		$this->wa_id->ViewCustomAttributes = "";

		// mobile_no
		$this->mobile_no->ViewValue = $this->mobile_no->CurrentValue;
		$this->mobile_no->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// subject
		$this->subject->ViewValue = $this->subject->CurrentValue;
		$this->subject->ViewCustomAttributes = "";

		// message
		$this->message->ViewValue = $this->message->CurrentValue;
		$this->message->ViewCustomAttributes = "";

		// sms
		$this->sms->ViewValue = $this->sms->CurrentValue;
		$this->sms->ViewCustomAttributes = "";

		// uploads
		$this->uploads->UploadPath = '.p_uploads/message/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->ViewCustomAttributes = "";

		// b_type
		if (strval($this->b_type->CurrentValue) <> "") {
			$this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
		} else {
			$this->b_type->ViewValue = NULL;
		}
		$this->b_type->ViewCustomAttributes = "";

		// b_1
		$this->b_1->ViewValue = $this->b_1->CurrentValue;
		$this->b_1->ViewCustomAttributes = "";

		// b_2
		$this->b_2->ViewValue = $this->b_2->CurrentValue;
		$this->b_2->ViewCustomAttributes = "";

		// b_3
		$this->b_3->ViewValue = $this->b_3->CurrentValue;
		$this->b_3->ViewCustomAttributes = "";

		// trigger_time
		$this->trigger_time->ViewValue = $this->trigger_time->CurrentValue;
		$this->trigger_time->ViewValue = FormatDateTime($this->trigger_time->ViewValue, 0);
		$this->trigger_time->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// b_4
		$this->b_4->ViewValue = $this->b_4->CurrentValue;
		$this->b_4->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// reference
		$this->reference->LinkCustomAttributes = "";
		$this->reference->HrefValue = "";
		$this->reference->TooltipValue = "";

		// message_type
		$this->message_type->LinkCustomAttributes = "";
		$this->message_type->HrefValue = "";
		$this->message_type->TooltipValue = "";

		// wa_type
		$this->wa_type->LinkCustomAttributes = "";
		$this->wa_type->HrefValue = "";
		$this->wa_type->TooltipValue = "";

		// wa_id
		$this->wa_id->LinkCustomAttributes = "";
		$this->wa_id->HrefValue = "";
		$this->wa_id->TooltipValue = "";

		// mobile_no
		$this->mobile_no->LinkCustomAttributes = "";
		$this->mobile_no->HrefValue = "";
		$this->mobile_no->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// subject
		$this->subject->LinkCustomAttributes = "";
		$this->subject->HrefValue = "";
		$this->subject->TooltipValue = "";

		// message
		$this->message->LinkCustomAttributes = "";
		$this->message->HrefValue = "";
		$this->message->TooltipValue = "";

		// sms
		$this->sms->LinkCustomAttributes = "";
		$this->sms->HrefValue = "";
		$this->sms->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->HrefValue = "";
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";

		// b_type
		$this->b_type->LinkCustomAttributes = "";
		$this->b_type->HrefValue = "";
		$this->b_type->TooltipValue = "";

		// b_1
		$this->b_1->LinkCustomAttributes = "";
		$this->b_1->HrefValue = "";
		$this->b_1->TooltipValue = "";

		// b_2
		$this->b_2->LinkCustomAttributes = "";
		$this->b_2->HrefValue = "";
		$this->b_2->TooltipValue = "";

		// b_3
		$this->b_3->LinkCustomAttributes = "";
		$this->b_3->HrefValue = "";
		$this->b_3->TooltipValue = "";

		// trigger_time
		$this->trigger_time->LinkCustomAttributes = "";
		$this->trigger_time->HrefValue = "";
		$this->trigger_time->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// b_4
		$this->b_4->LinkCustomAttributes = "";
		$this->b_4->HrefValue = "";
		$this->b_4->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// reference
		$this->reference->EditAttrs["class"] = "form-control";
		$this->reference->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
		$this->reference->EditValue = $this->reference->CurrentValue;
		$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

		// message_type
		$this->message_type->EditAttrs["class"] = "form-control";
		$this->message_type->EditCustomAttributes = "";

		// wa_type
		$this->wa_type->EditAttrs["class"] = "form-control";
		$this->wa_type->EditCustomAttributes = "";

		// wa_id
		$this->wa_id->EditAttrs["class"] = "form-control";
		$this->wa_id->EditCustomAttributes = "";

		// mobile_no
		$this->mobile_no->EditAttrs["class"] = "form-control";
		$this->mobile_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile_no->CurrentValue = HtmlDecode($this->mobile_no->CurrentValue);
		$this->mobile_no->EditValue = $this->mobile_no->CurrentValue;
		$this->mobile_no->PlaceHolder = RemoveHtml($this->mobile_no->caption());

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// subject
		$this->subject->EditAttrs["class"] = "form-control";
		$this->subject->EditCustomAttributes = "";
		$this->subject->EditValue = $this->subject->CurrentValue;
		$this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

		// message
		$this->message->EditAttrs["class"] = "form-control";
		$this->message->EditCustomAttributes = "";
		$this->message->EditValue = $this->message->CurrentValue;
		$this->message->PlaceHolder = RemoveHtml($this->message->caption());

		// sms
		$this->sms->EditAttrs["class"] = "form-control";
		$this->sms->EditCustomAttributes = "";
		$this->sms->EditValue = $this->sms->CurrentValue;
		$this->sms->PlaceHolder = RemoveHtml($this->sms->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->UploadPath = '.p_uploads/message/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// b_type
		$this->b_type->EditAttrs["class"] = "form-control";
		$this->b_type->EditCustomAttributes = "";
		$this->b_type->EditValue = $this->b_type->options(TRUE);

		// b_1
		$this->b_1->EditAttrs["class"] = "form-control";
		$this->b_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_1->CurrentValue = HtmlDecode($this->b_1->CurrentValue);
		$this->b_1->EditValue = $this->b_1->CurrentValue;
		$this->b_1->PlaceHolder = RemoveHtml($this->b_1->caption());

		// b_2
		$this->b_2->EditAttrs["class"] = "form-control";
		$this->b_2->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_2->CurrentValue = HtmlDecode($this->b_2->CurrentValue);
		$this->b_2->EditValue = $this->b_2->CurrentValue;
		$this->b_2->PlaceHolder = RemoveHtml($this->b_2->caption());

		// b_3
		$this->b_3->EditAttrs["class"] = "form-control";
		$this->b_3->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_3->CurrentValue = HtmlDecode($this->b_3->CurrentValue);
		$this->b_3->EditValue = $this->b_3->CurrentValue;
		$this->b_3->PlaceHolder = RemoveHtml($this->b_3->caption());

		// trigger_time
		$this->trigger_time->EditAttrs["class"] = "form-control";
		$this->trigger_time->EditCustomAttributes = "";
		$this->trigger_time->EditValue = FormatDateTime($this->trigger_time->CurrentValue, 8);
		$this->trigger_time->PlaceHolder = RemoveHtml($this->trigger_time->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// operator
		// datetime
		// b_4

		$this->b_4->EditAttrs["class"] = "form-control";
		$this->b_4->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->b_4->CurrentValue = HtmlDecode($this->b_4->CurrentValue);
		$this->b_4->EditValue = $this->b_4->CurrentValue;
		$this->b_4->PlaceHolder = RemoveHtml($this->b_4->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->message_type);
					$doc->exportCaption($this->wa_type);
					$doc->exportCaption($this->wa_id);
					$doc->exportCaption($this->mobile_no);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->subject);
					$doc->exportCaption($this->message);
					$doc->exportCaption($this->sms);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->b_type);
					$doc->exportCaption($this->b_1);
					$doc->exportCaption($this->b_2);
					$doc->exportCaption($this->b_3);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->reference);
					$doc->exportCaption($this->message_type);
					$doc->exportCaption($this->wa_type);
					$doc->exportCaption($this->wa_id);
					$doc->exportCaption($this->subject);
					$doc->exportCaption($this->message);
					$doc->exportCaption($this->b_type);
					$doc->exportCaption($this->b_1);
					$doc->exportCaption($this->b_2);
					$doc->exportCaption($this->b_3);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->reference);
						$doc->exportField($this->message_type);
						$doc->exportField($this->wa_type);
						$doc->exportField($this->wa_id);
						$doc->exportField($this->mobile_no);
						$doc->exportField($this->_email);
						$doc->exportField($this->subject);
						$doc->exportField($this->message);
						$doc->exportField($this->sms);
						$doc->exportField($this->uploads);
						$doc->exportField($this->b_type);
						$doc->exportField($this->b_1);
						$doc->exportField($this->b_2);
						$doc->exportField($this->b_3);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->reference);
						$doc->exportField($this->message_type);
						$doc->exportField($this->wa_type);
						$doc->exportField($this->wa_id);
						$doc->exportField($this->subject);
						$doc->exportField($this->message);
						$doc->exportField($this->b_type);
						$doc->exportField($this->b_1);
						$doc->exportField($this->b_2);
						$doc->exportField($this->b_3);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>