<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class customized_message_add extends customized_message
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'customized_message';

	// Page object name
	public $PageObjName = "customized_message_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (customized_message)
		if (!isset($GLOBALS["customized_message"]) || get_class($GLOBALS["customized_message"]) == PROJECT_NAMESPACE . "customized_message") {
			$GLOBALS["customized_message"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["customized_message"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'customized_message');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $customized_message;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($customized_message);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "customized_messageview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("customized_messagelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->reference->setVisibility();
		$this->message_type->setVisibility();
		$this->wa_type->setVisibility();
		$this->wa_id->setVisibility();
		$this->mobile_no->setVisibility();
		$this->_email->setVisibility();
		$this->subject->setVisibility();
		$this->message->setVisibility();
		$this->sms->setVisibility();
		$this->uploads->setVisibility();
		$this->b_type->setVisibility();
		$this->b_1->setVisibility();
		$this->b_2->setVisibility();
		$this->b_3->setVisibility();
		$this->trigger_time->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->b_4->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->message_type);
		$this->setupLookupOptions($this->wa_type);
		$this->setupLookupOptions($this->wa_id);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("customized_messagelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = 'autoprogramme.php?apcid=b4e62d5681b956d7cf98e467f6427ae4';
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->reference->CurrentValue = ((isset($_GET["ref"]))? 'REQID:'.$_GET["ref"]:"");
		$this->message_type->CurrentValue = NULL;
		$this->message_type->OldValue = $this->message_type->CurrentValue;
		$this->wa_type->CurrentValue = NULL;
		$this->wa_type->OldValue = $this->wa_type->CurrentValue;
		$this->wa_id->CurrentValue = NULL;
		$this->wa_id->OldValue = $this->wa_id->CurrentValue;
		$this->mobile_no->CurrentValue = NULL;
		$this->mobile_no->OldValue = $this->mobile_no->CurrentValue;
		$this->_email->CurrentValue = NULL;
		$this->_email->OldValue = $this->_email->CurrentValue;
		$this->subject->CurrentValue = NULL;
		$this->subject->OldValue = $this->subject->CurrentValue;
		$this->message->CurrentValue = NULL;
		$this->message->OldValue = $this->message->CurrentValue;
		$this->sms->CurrentValue = NULL;
		$this->sms->OldValue = $this->sms->CurrentValue;
		$this->uploads->Upload->DbValue = NULL;
		$this->uploads->OldValue = $this->uploads->Upload->DbValue;
		$this->uploads->CurrentValue = NULL; // Clear file related field
		$this->b_type->CurrentValue = NULL;
		$this->b_type->OldValue = $this->b_type->CurrentValue;
		$this->b_1->CurrentValue = NULL;
		$this->b_1->OldValue = $this->b_1->CurrentValue;
		$this->b_2->CurrentValue = NULL;
		$this->b_2->OldValue = $this->b_2->CurrentValue;
		$this->b_3->CurrentValue = NULL;
		$this->b_3->OldValue = $this->b_3->CurrentValue;
		$this->trigger_time->CurrentValue = CurrentDateTime();
		$this->status->CurrentValue = 1;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->b_4->CurrentValue = NULL;
		$this->b_4->OldValue = $this->b_4->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'reference' first before field var 'x_reference'
		$val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
		if (!$this->reference->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reference->Visible = FALSE; // Disable update for API request
			else
				$this->reference->setFormValue($val);
		}

		// Check field name 'message_type' first before field var 'x_message_type'
		$val = $CurrentForm->hasValue("message_type") ? $CurrentForm->getValue("message_type") : $CurrentForm->getValue("x_message_type");
		if (!$this->message_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->message_type->Visible = FALSE; // Disable update for API request
			else
				$this->message_type->setFormValue($val);
		}

		// Check field name 'wa_type' first before field var 'x_wa_type'
		$val = $CurrentForm->hasValue("wa_type") ? $CurrentForm->getValue("wa_type") : $CurrentForm->getValue("x_wa_type");
		if (!$this->wa_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_type->Visible = FALSE; // Disable update for API request
			else
				$this->wa_type->setFormValue($val);
		}

		// Check field name 'wa_id' first before field var 'x_wa_id'
		$val = $CurrentForm->hasValue("wa_id") ? $CurrentForm->getValue("wa_id") : $CurrentForm->getValue("x_wa_id");
		if (!$this->wa_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->wa_id->Visible = FALSE; // Disable update for API request
			else
				$this->wa_id->setFormValue($val);
		}

		// Check field name 'mobile_no' first before field var 'x_mobile_no'
		$val = $CurrentForm->hasValue("mobile_no") ? $CurrentForm->getValue("mobile_no") : $CurrentForm->getValue("x_mobile_no");
		if (!$this->mobile_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile_no->Visible = FALSE; // Disable update for API request
			else
				$this->mobile_no->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'subject' first before field var 'x_subject'
		$val = $CurrentForm->hasValue("subject") ? $CurrentForm->getValue("subject") : $CurrentForm->getValue("x_subject");
		if (!$this->subject->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->subject->Visible = FALSE; // Disable update for API request
			else
				$this->subject->setFormValue($val);
		}

		// Check field name 'message' first before field var 'x_message'
		$val = $CurrentForm->hasValue("message") ? $CurrentForm->getValue("message") : $CurrentForm->getValue("x_message");
		if (!$this->message->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->message->Visible = FALSE; // Disable update for API request
			else
				$this->message->setFormValue($val);
		}

		// Check field name 'sms' first before field var 'x_sms'
		$val = $CurrentForm->hasValue("sms") ? $CurrentForm->getValue("sms") : $CurrentForm->getValue("x_sms");
		if (!$this->sms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sms->Visible = FALSE; // Disable update for API request
			else
				$this->sms->setFormValue($val);
		}

		// Check field name 'b_type' first before field var 'x_b_type'
		$val = $CurrentForm->hasValue("b_type") ? $CurrentForm->getValue("b_type") : $CurrentForm->getValue("x_b_type");
		if (!$this->b_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_type->Visible = FALSE; // Disable update for API request
			else
				$this->b_type->setFormValue($val);
		}

		// Check field name 'b_1' first before field var 'x_b_1'
		$val = $CurrentForm->hasValue("b_1") ? $CurrentForm->getValue("b_1") : $CurrentForm->getValue("x_b_1");
		if (!$this->b_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_1->Visible = FALSE; // Disable update for API request
			else
				$this->b_1->setFormValue($val);
		}

		// Check field name 'b_2' first before field var 'x_b_2'
		$val = $CurrentForm->hasValue("b_2") ? $CurrentForm->getValue("b_2") : $CurrentForm->getValue("x_b_2");
		if (!$this->b_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_2->Visible = FALSE; // Disable update for API request
			else
				$this->b_2->setFormValue($val);
		}

		// Check field name 'b_3' first before field var 'x_b_3'
		$val = $CurrentForm->hasValue("b_3") ? $CurrentForm->getValue("b_3") : $CurrentForm->getValue("x_b_3");
		if (!$this->b_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_3->Visible = FALSE; // Disable update for API request
			else
				$this->b_3->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->reference->CurrentValue = $this->reference->FormValue;
		$this->message_type->CurrentValue = $this->message_type->FormValue;
		$this->wa_type->CurrentValue = $this->wa_type->FormValue;
		$this->wa_id->CurrentValue = $this->wa_id->FormValue;
		$this->mobile_no->CurrentValue = $this->mobile_no->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->subject->CurrentValue = $this->subject->FormValue;
		$this->message->CurrentValue = $this->message->FormValue;
		$this->sms->CurrentValue = $this->sms->FormValue;
		$this->b_type->CurrentValue = $this->b_type->FormValue;
		$this->b_1->CurrentValue = $this->b_1->FormValue;
		$this->b_2->CurrentValue = $this->b_2->FormValue;
		$this->b_3->CurrentValue = $this->b_3->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->reference->setDbValue($row['reference']);
		$this->message_type->setDbValue($row['message_type']);
		$this->wa_type->setDbValue($row['wa_type']);
		$this->wa_id->setDbValue($row['wa_id']);
		$this->mobile_no->setDbValue($row['mobile_no']);
		$this->_email->setDbValue($row['email']);
		$this->subject->setDbValue($row['subject']);
		$this->message->setDbValue($row['message']);
		$this->sms->setDbValue($row['sms']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->b_type->setDbValue($row['b_type']);
		$this->b_1->setDbValue($row['b_1']);
		$this->b_2->setDbValue($row['b_2']);
		$this->b_3->setDbValue($row['b_3']);
		$this->trigger_time->setDbValue($row['trigger_time']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->b_4->setDbValue($row['b_4']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['reference'] = $this->reference->CurrentValue;
		$row['message_type'] = $this->message_type->CurrentValue;
		$row['wa_type'] = $this->wa_type->CurrentValue;
		$row['wa_id'] = $this->wa_id->CurrentValue;
		$row['mobile_no'] = $this->mobile_no->CurrentValue;
		$row['email'] = $this->_email->CurrentValue;
		$row['subject'] = $this->subject->CurrentValue;
		$row['message'] = $this->message->CurrentValue;
		$row['sms'] = $this->sms->CurrentValue;
		$row['uploads'] = $this->uploads->Upload->DbValue;
		$row['b_type'] = $this->b_type->CurrentValue;
		$row['b_1'] = $this->b_1->CurrentValue;
		$row['b_2'] = $this->b_2->CurrentValue;
		$row['b_3'] = $this->b_3->CurrentValue;
		$row['trigger_time'] = $this->trigger_time->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['b_4'] = $this->b_4->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// reference
		// message_type
		// wa_type
		// wa_id
		// mobile_no
		// email
		// subject
		// message
		// sms
		// uploads
		// b_type
		// b_1
		// b_2
		// b_3
		// trigger_time
		// status
		// operator
		// datetime
		// b_4

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// reference
			$this->reference->ViewValue = $this->reference->CurrentValue;
			$this->reference->ViewCustomAttributes = "";

			// message_type
			$curVal = strval($this->message_type->CurrentValue);
			if ($curVal <> "") {
				$this->message_type->ViewValue = $this->message_type->lookupCacheOption($curVal);
				if ($this->message_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->message_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->message_type->ViewValue = $this->message_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->message_type->ViewValue = $this->message_type->CurrentValue;
					}
				}
			} else {
				$this->message_type->ViewValue = NULL;
			}
			$this->message_type->ViewCustomAttributes = "";

			// wa_type
			$curVal = strval($this->wa_type->CurrentValue);
			if ($curVal <> "") {
				$this->wa_type->ViewValue = $this->wa_type->lookupCacheOption($curVal);
				if ($this->wa_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wa_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_type->ViewValue = $this->wa_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_type->ViewValue = $this->wa_type->CurrentValue;
					}
				}
			} else {
				$this->wa_type->ViewValue = NULL;
			}
			$this->wa_type->ViewCustomAttributes = "";

			// wa_id
			$curVal = strval($this->wa_id->CurrentValue);
			if ($curVal <> "") {
				$this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
				if ($this->wa_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->wa_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->wa_id->ViewValue = $this->wa_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wa_id->ViewValue = $this->wa_id->CurrentValue;
					}
				}
			} else {
				$this->wa_id->ViewValue = NULL;
			}
			$this->wa_id->ViewCustomAttributes = "";

			// mobile_no
			$this->mobile_no->ViewValue = $this->mobile_no->CurrentValue;
			$this->mobile_no->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// subject
			$this->subject->ViewValue = $this->subject->CurrentValue;
			$this->subject->ViewCustomAttributes = "";

			// message
			$this->message->ViewValue = $this->message->CurrentValue;
			$this->message->ViewCustomAttributes = "";

			// sms
			$this->sms->ViewValue = $this->sms->CurrentValue;
			$this->sms->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/message/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// b_type
			if (strval($this->b_type->CurrentValue) <> "") {
				$this->b_type->ViewValue = $this->b_type->optionCaption($this->b_type->CurrentValue);
			} else {
				$this->b_type->ViewValue = NULL;
			}
			$this->b_type->ViewCustomAttributes = "";

			// b_1
			$this->b_1->ViewValue = $this->b_1->CurrentValue;
			$this->b_1->ViewCustomAttributes = "";

			// b_2
			$this->b_2->ViewValue = $this->b_2->CurrentValue;
			$this->b_2->ViewCustomAttributes = "";

			// b_3
			$this->b_3->ViewValue = $this->b_3->CurrentValue;
			$this->b_3->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";
			$this->reference->TooltipValue = "";

			// message_type
			$this->message_type->LinkCustomAttributes = "";
			$this->message_type->HrefValue = "";
			$this->message_type->TooltipValue = "";

			// wa_type
			$this->wa_type->LinkCustomAttributes = "";
			$this->wa_type->HrefValue = "";
			$this->wa_type->TooltipValue = "";

			// wa_id
			$this->wa_id->LinkCustomAttributes = "";
			$this->wa_id->HrefValue = "";
			$this->wa_id->TooltipValue = "";

			// mobile_no
			$this->mobile_no->LinkCustomAttributes = "";
			$this->mobile_no->HrefValue = "";
			$this->mobile_no->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// subject
			$this->subject->LinkCustomAttributes = "";
			$this->subject->HrefValue = "";
			$this->subject->TooltipValue = "";

			// message
			$this->message->LinkCustomAttributes = "";
			$this->message->HrefValue = "";
			$this->message->TooltipValue = "";

			// sms
			$this->sms->LinkCustomAttributes = "";
			$this->sms->HrefValue = "";
			$this->sms->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";

			// b_type
			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";
			$this->b_type->TooltipValue = "";

			// b_1
			$this->b_1->LinkCustomAttributes = "";
			$this->b_1->HrefValue = "";
			$this->b_1->TooltipValue = "";

			// b_2
			$this->b_2->LinkCustomAttributes = "";
			$this->b_2->HrefValue = "";
			$this->b_2->TooltipValue = "";

			// b_3
			$this->b_3->LinkCustomAttributes = "";
			$this->b_3->HrefValue = "";
			$this->b_3->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// reference
			$this->reference->EditAttrs["class"] = "form-control";
			$this->reference->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->reference->CurrentValue = HtmlDecode($this->reference->CurrentValue);
			$this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
			$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

			// message_type
			$this->message_type->EditAttrs["class"] = "form-control";
			$this->message_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->message_type->CurrentValue));
			if ($curVal <> "")
				$this->message_type->ViewValue = $this->message_type->lookupCacheOption($curVal);
			else
				$this->message_type->ViewValue = $this->message_type->Lookup !== NULL && is_array($this->message_type->Lookup->Options) ? $curVal : NULL;
			if ($this->message_type->ViewValue !== NULL) { // Load from cache
				$this->message_type->EditValue = array_values($this->message_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->message_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 3";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->message_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->message_type->EditValue = $arwrk;
			}

			// wa_type
			$this->wa_type->EditAttrs["class"] = "form-control";
			$this->wa_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->wa_type->CurrentValue));
			if ($curVal <> "")
				$this->wa_type->ViewValue = $this->wa_type->lookupCacheOption($curVal);
			else
				$this->wa_type->ViewValue = $this->wa_type->Lookup !== NULL && is_array($this->wa_type->Lookup->Options) ? $curVal : NULL;
			if ($this->wa_type->ViewValue !== NULL) { // Load from cache
				$this->wa_type->EditValue = array_values($this->wa_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->wa_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 2 and `status`= 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->wa_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->wa_type->EditValue = $arwrk;
			}

			// wa_id
			$this->wa_id->EditAttrs["class"] = "form-control";
			$this->wa_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->wa_id->CurrentValue));
			if ($curVal <> "")
				$this->wa_id->ViewValue = $this->wa_id->lookupCacheOption($curVal);
			else
				$this->wa_id->ViewValue = $this->wa_id->Lookup !== NULL && is_array($this->wa_id->Lookup->Options) ? $curVal : NULL;
			if ($this->wa_id->ViewValue !== NULL) { // Load from cache
				$this->wa_id->EditValue = array_values($this->wa_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->wa_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->wa_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->wa_id->EditValue = $arwrk;
			}

			// mobile_no
			$this->mobile_no->EditAttrs["class"] = "form-control";
			$this->mobile_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile_no->CurrentValue = HtmlDecode($this->mobile_no->CurrentValue);
			$this->mobile_no->EditValue = HtmlEncode($this->mobile_no->CurrentValue);
			$this->mobile_no->PlaceHolder = RemoveHtml($this->mobile_no->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// subject
			$this->subject->EditAttrs["class"] = "form-control";
			$this->subject->EditCustomAttributes = "";
			$this->subject->EditValue = HtmlEncode($this->subject->CurrentValue);
			$this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

			// message
			$this->message->EditAttrs["class"] = "form-control";
			$this->message->EditCustomAttributes = "";
			$this->message->EditValue = HtmlEncode($this->message->CurrentValue);
			$this->message->PlaceHolder = RemoveHtml($this->message->caption());

			// sms
			$this->sms->EditAttrs["class"] = "form-control";
			$this->sms->EditCustomAttributes = "";
			$this->sms->EditValue = HtmlEncode($this->sms->CurrentValue);
			$this->sms->PlaceHolder = RemoveHtml($this->sms->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/message/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if (($this->isShow() || $this->isCopy()) && !$this->EventCancelled)
				RenderUploadField($this->uploads);

			// b_type
			$this->b_type->EditAttrs["class"] = "form-control";
			$this->b_type->EditCustomAttributes = "";
			$this->b_type->EditValue = $this->b_type->options(TRUE);

			// b_1
			$this->b_1->EditAttrs["class"] = "form-control";
			$this->b_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_1->CurrentValue = HtmlDecode($this->b_1->CurrentValue);
			$this->b_1->EditValue = HtmlEncode($this->b_1->CurrentValue);
			$this->b_1->PlaceHolder = RemoveHtml($this->b_1->caption());

			// b_2
			$this->b_2->EditAttrs["class"] = "form-control";
			$this->b_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_2->CurrentValue = HtmlDecode($this->b_2->CurrentValue);
			$this->b_2->EditValue = HtmlEncode($this->b_2->CurrentValue);
			$this->b_2->PlaceHolder = RemoveHtml($this->b_2->caption());

			// b_3
			$this->b_3->EditAttrs["class"] = "form-control";
			$this->b_3->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_3->CurrentValue = HtmlDecode($this->b_3->CurrentValue);
			$this->b_3->EditValue = HtmlEncode($this->b_3->CurrentValue);
			$this->b_3->PlaceHolder = RemoveHtml($this->b_3->caption());

			// operator
			// datetime
			// Add refer script
			// reference

			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";

			// message_type
			$this->message_type->LinkCustomAttributes = "";
			$this->message_type->HrefValue = "";

			// wa_type
			$this->wa_type->LinkCustomAttributes = "";
			$this->wa_type->HrefValue = "";

			// wa_id
			$this->wa_id->LinkCustomAttributes = "";
			$this->wa_id->HrefValue = "";

			// mobile_no
			$this->mobile_no->LinkCustomAttributes = "";
			$this->mobile_no->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// subject
			$this->subject->LinkCustomAttributes = "";
			$this->subject->HrefValue = "";

			// message
			$this->message->LinkCustomAttributes = "";
			$this->message->HrefValue = "";

			// sms
			$this->sms->LinkCustomAttributes = "";
			$this->sms->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// b_type
			$this->b_type->LinkCustomAttributes = "";
			$this->b_type->HrefValue = "";

			// b_1
			$this->b_1->LinkCustomAttributes = "";
			$this->b_1->HrefValue = "";

			// b_2
			$this->b_2->LinkCustomAttributes = "";
			$this->b_2->HrefValue = "";

			// b_3
			$this->b_3->LinkCustomAttributes = "";
			$this->b_3->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->reference->Required) {
			if (!$this->reference->IsDetailKey && $this->reference->FormValue != NULL && $this->reference->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
			}
		}
		if ($this->message_type->Required) {
			if (!$this->message_type->IsDetailKey && $this->message_type->FormValue != NULL && $this->message_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->message_type->caption(), $this->message_type->RequiredErrorMessage));
			}
		}
		if ($this->wa_type->Required) {
			if (!$this->wa_type->IsDetailKey && $this->wa_type->FormValue != NULL && $this->wa_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_type->caption(), $this->wa_type->RequiredErrorMessage));
			}
		}
		if ($this->wa_id->Required) {
			if (!$this->wa_id->IsDetailKey && $this->wa_id->FormValue != NULL && $this->wa_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wa_id->caption(), $this->wa_id->RequiredErrorMessage));
			}
		}
		if ($this->mobile_no->Required) {
			if (!$this->mobile_no->IsDetailKey && $this->mobile_no->FormValue != NULL && $this->mobile_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile_no->caption(), $this->mobile_no->RequiredErrorMessage));
			}
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if (!CheckEmail($this->_email->FormValue)) {
			AddMessage($FormError, $this->_email->errorMessage());
		}
		if ($this->subject->Required) {
			if (!$this->subject->IsDetailKey && $this->subject->FormValue != NULL && $this->subject->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->subject->caption(), $this->subject->RequiredErrorMessage));
			}
		}
		if ($this->message->Required) {
			if (!$this->message->IsDetailKey && $this->message->FormValue != NULL && $this->message->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->message->caption(), $this->message->RequiredErrorMessage));
			}
		}
		if ($this->sms->Required) {
			if (!$this->sms->IsDetailKey && $this->sms->FormValue != NULL && $this->sms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sms->caption(), $this->sms->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->b_type->Required) {
			if (!$this->b_type->IsDetailKey && $this->b_type->FormValue != NULL && $this->b_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_type->caption(), $this->b_type->RequiredErrorMessage));
			}
		}
		if ($this->b_1->Required) {
			if (!$this->b_1->IsDetailKey && $this->b_1->FormValue != NULL && $this->b_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_1->caption(), $this->b_1->RequiredErrorMessage));
			}
		}
		if ($this->b_2->Required) {
			if (!$this->b_2->IsDetailKey && $this->b_2->FormValue != NULL && $this->b_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_2->caption(), $this->b_2->RequiredErrorMessage));
			}
		}
		if ($this->b_3->Required) {
			if (!$this->b_3->IsDetailKey && $this->b_3->FormValue != NULL && $this->b_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_3->caption(), $this->b_3->RequiredErrorMessage));
			}
		}
		if ($this->trigger_time->Required) {
			if (!$this->trigger_time->IsDetailKey && $this->trigger_time->FormValue != NULL && $this->trigger_time->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->trigger_time->caption(), $this->trigger_time->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->b_4->Required) {
			if (!$this->b_4->IsDetailKey && $this->b_4->FormValue != NULL && $this->b_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_4->caption(), $this->b_4->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->uploads->OldUploadPath = '.p_uploads/message/' . $this->id->CurrentValue . '/';
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
		}
		$rsnew = [];

		// reference
		$this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, NULL, FALSE);

		// message_type
		$this->message_type->setDbValueDef($rsnew, $this->message_type->CurrentValue, NULL, FALSE);

		// wa_type
		$this->wa_type->setDbValueDef($rsnew, $this->wa_type->CurrentValue, NULL, FALSE);

		// wa_id
		$this->wa_id->setDbValueDef($rsnew, $this->wa_id->CurrentValue, 0, FALSE);

		// mobile_no
		$this->mobile_no->setDbValueDef($rsnew, $this->mobile_no->CurrentValue, "", FALSE);

		// email
		$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, FALSE);

		// subject
		$this->subject->setDbValueDef($rsnew, $this->subject->CurrentValue, "", FALSE);

		// message
		$this->message->setDbValueDef($rsnew, $this->message->CurrentValue, NULL, FALSE);

		// sms
		$this->sms->setDbValueDef($rsnew, $this->sms->CurrentValue, NULL, FALSE);

		// uploads
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->Upload->DbValue = ""; // No need to delete old file
			if ($this->uploads->Upload->FileName == "") {
				$rsnew['uploads'] = NULL;
			} else {
				if ($rsold && $rsold->fields['uploads'] <> "" && $this->uploads->Upload->FileName <> "") {
					$oldFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsold->fields['uploads']);
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->uploads->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i], UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['uploads'] = $this->uploads->Upload->FileName;
			}
			$this->uploads->ImageWidth = 640; // Resize width
			$this->uploads->ImageHeight = 640; // Resize height
		}

		// b_type
		$this->b_type->setDbValueDef($rsnew, $this->b_type->CurrentValue, NULL, FALSE);

		// b_1
		$this->b_1->setDbValueDef($rsnew, $this->b_1->CurrentValue, NULL, FALSE);

		// b_2
		$this->b_2->setDbValueDef($rsnew, $this->b_2->CurrentValue, NULL, FALSE);

		// b_3
		$this->b_3->setDbValueDef($rsnew, $this->b_3->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->UploadPath = '.p_uploads/message/' . $this->id->CurrentValue . '/';
			$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
			if (!EmptyValue($this->uploads->Upload->FileName)) {
				$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->FileName));
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
					if (!EmptyValue($this->uploads->Upload->FileName)) {
						$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
						$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['uploads']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("customized_messagelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_message_type":
					$lookupFilter = function() {
						return "`grp` = 3";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_wa_type":
					$lookupFilter = function() {
						return "`grp` = 2 and `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_message_type":
							break;
						case "x_wa_type":
							break;
						case "x_wa_id":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		isset($_GET['ref']) ? '' : $_GET['ref'] = 0; 
		if ($_GET['ref'] > 0)
		{
			$this->reference->ReadOnly = true;
		}
		else
		{
			$this->reference->Visible = False;
		}
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>