<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for dyeing_process_shortage
 */
class dyeing_process_shortage extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $product;
	public $product_code;
	public $IN;
	public $OUT;
	public $Balance;
	public $_action;
	public $y;
	public $sy;
	public $lot_no;
	public $tmp_lot;
	public $godown;
	public $remarks;
	public $status;
	public $rid;
	public $url;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'dyeing_process_shortage';
		$this->TableName = 'dyeing_process_shortage';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`dyeing_process_shortage`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// product
		$this->product = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->Lookup = new Lookup('product', 'product_f', FALSE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->fields['product'] = &$this->product;

		// product_code
		$this->product_code = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// IN
		$this->IN = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_IN', 'IN', '`IN`', '`IN`', 131, -1, FALSE, '`IN`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IN->Sortable = TRUE; // Allow sort
		$this->IN->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['IN'] = &$this->IN;

		// OUT
		$this->OUT = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_OUT', 'OUT', '`OUT`', '`OUT`', 131, -1, FALSE, '`OUT`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->OUT->Nullable = FALSE; // NOT NULL field
		$this->OUT->Required = TRUE; // Required field
		$this->OUT->Sortable = TRUE; // Allow sort
		$this->OUT->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['OUT'] = &$this->OUT;

		// Balance
		$this->Balance = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_Balance', 'Balance', '`Balance`', '`Balance`', 131, -1, FALSE, '`Balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Balance->Sortable = TRUE; // Allow sort
		$this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Balance'] = &$this->Balance;

		// action
		$this->_action = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x__action', 'action', 'if(status=2,\'Completed\',\'Pending<BR>Click to Complete\')', 'if(status=2,\'Completed\',\'Pending<BR>Click to Complete\')', 200, -1, FALSE, 'if(status=2,\'Completed\',\'Pending<BR>Click to Complete\')', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_action->IsCustom = TRUE; // Custom field
		$this->_action->Sortable = TRUE; // Allow sort
		$this->fields['action'] = &$this->_action;

		// y
		$this->y = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_y', 'y', '`y`', '`y`', 131, -1, FALSE, '`y`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->y->Sortable = TRUE; // Allow sort
		$this->y->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['y'] = &$this->y;

		// sy
		$this->sy = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_sy', 'sy', '`sy`', '`sy`', 131, -1, FALSE, '`sy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sy->Sortable = TRUE; // Allow sort
		$this->sy->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['sy'] = &$this->sy;

		// lot_no
		$this->lot_no = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->lot_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['lot_no'] = &$this->lot_no;

		// tmp_lot
		$this->tmp_lot = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_tmp_lot', 'tmp_lot', '`tmp_lot`', '`tmp_lot`', 131, -1, FALSE, '`tmp_lot`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tmp_lot->IsForeignKey = TRUE; // Foreign key field
		$this->tmp_lot->Sortable = TRUE; // Allow sort
		$this->tmp_lot->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['tmp_lot'] = &$this->tmp_lot;

		// godown
		$this->godown = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_godown', 'godown', '`godown`', '`godown`', 19, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["code","name","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// remarks
		$this->remarks = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// status
		$this->status = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->status->Sortable = FALSE; // Allow sort
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// rid
		$this->rid = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_rid', 'rid', '`rid`', '`rid`', 2, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = FALSE; // Allow sort
		$this->fields['rid'] = &$this->rid;

		// url
		$this->url = new DbField('dyeing_process_shortage', 'dyeing_process_shortage', 'x_url', 'url', '`url`', '`url`', 200, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "dyeing_dw") {
			$detailUrl = $GLOBALS["dyeing_dw"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_tmp_lot=" . urlencode($this->tmp_lot->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "dyeing_process_shortagelist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`dyeing_process_shortage`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, if(status=2,'Completed','Pending<BR>Click to Complete') AS `action` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`product` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->product->DbValue = $row['product'];
		$this->product_code->DbValue = $row['product_code'];
		$this->IN->DbValue = $row['IN'];
		$this->OUT->DbValue = $row['OUT'];
		$this->Balance->DbValue = $row['Balance'];
		$this->_action->DbValue = $row['action'];
		$this->y->DbValue = $row['y'];
		$this->sy->DbValue = $row['sy'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->tmp_lot->DbValue = $row['tmp_lot'];
		$this->godown->DbValue = $row['godown'];
		$this->remarks->DbValue = $row['remarks'];
		$this->status->DbValue = $row['status'];
		$this->rid->DbValue = $row['rid'];
		$this->url->DbValue = $row['url'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "dyeing_process_shortagelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "dyeing_process_shortageview.php")
			return $Language->phrase("View");
		elseif ($pageName == "dyeing_process_shortageedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "dyeing_process_shortageadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "dyeing_process_shortagelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("dyeing_process_shortageview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("dyeing_process_shortageview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "dyeing_process_shortageadd.php?" . $this->getUrlParm($parm);
		else
			$url = "dyeing_process_shortageadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("dyeing_process_shortageedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("dyeing_process_shortageedit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("dyeing_process_shortageadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("dyeing_process_shortageadd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("dyeing_process_shortagedelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->IN->setDbValue($rs->fields('IN'));
		$this->OUT->setDbValue($rs->fields('OUT'));
		$this->Balance->setDbValue($rs->fields('Balance'));
		$this->_action->setDbValue($rs->fields('action'));
		$this->y->setDbValue($rs->fields('y'));
		$this->sy->setDbValue($rs->fields('sy'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->tmp_lot->setDbValue($rs->fields('tmp_lot'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->status->setDbValue($rs->fields('status'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->url->setDbValue($rs->fields('url'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// product

		$this->product->CellCssStyle = "width: 100px;";

		// product_code
		// IN
		// OUT
		// Balance
		// action
		// y
		// sy
		// lot_no
		// tmp_lot
		// godown
		// remarks
		// status

		$this->status->CellCssStyle = "white-space: nowrap;";

		// rid
		$this->rid->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// IN
		$this->IN->ViewValue = $this->IN->CurrentValue;
		$this->IN->ViewCustomAttributes = "";

		// OUT
		$this->OUT->ViewValue = $this->OUT->CurrentValue;
		$this->OUT->ViewCustomAttributes = "";

		// Balance
		$this->Balance->ViewValue = $this->Balance->CurrentValue;
		$this->Balance->ViewCustomAttributes = "";

		// action
		$this->_action->ViewValue = $this->_action->CurrentValue;
		$this->_action->CssClass = "font-weight-bold";
		$this->_action->ViewCustomAttributes = 'class = "btn btn-default"';

		// y
		$this->y->ViewValue = $this->y->CurrentValue;
		$this->y->ViewCustomAttributes = "";

		// sy
		$this->sy->ViewValue = $this->sy->CurrentValue;
		$this->sy->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// tmp_lot
		$this->tmp_lot->ViewValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->ViewValue = FormatNumber($this->tmp_lot->ViewValue, 2, -2, -2, -2);
		$this->tmp_lot->ViewCustomAttributes = "";

		// godown
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = $this->status->CurrentValue;
		$this->status->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$this->rid->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "dyeing_process_shortagelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		if (!EmptyValue($this->product_code->CurrentValue)) {
			$this->product_code->HrefValue = "dyeing_process_shortagelist.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
			$this->product_code->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
		} else {
			$this->product_code->HrefValue = "";
		}
		$this->product_code->TooltipValue = "";

		// IN
		$this->IN->LinkCustomAttributes = "";
		if (!EmptyValue($this->id->CurrentValue)) {
			$this->IN->HrefValue = "material_outlist.php?x_id=" . $this->id->CurrentValue; // Add prefix/suffix
			$this->IN->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->IN->HrefValue = FullUrl($this->IN->HrefValue, "href");
		} else {
			$this->IN->HrefValue = "";
		}
		$this->IN->TooltipValue = "";

		// OUT
		$this->OUT->LinkCustomAttributes = "";
		if (!EmptyValue($this->id->CurrentValue)) {
			$this->OUT->HrefValue = "dyeing_tablelist.php?x_ref=" . $this->id->CurrentValue; // Add prefix/suffix
			$this->OUT->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->OUT->HrefValue = FullUrl($this->OUT->HrefValue, "href");
		} else {
			$this->OUT->HrefValue = "";
		}
		$this->OUT->TooltipValue = "";

		// Balance
		$this->Balance->LinkCustomAttributes = "";
		$this->Balance->HrefValue = "";
		$this->Balance->TooltipValue = "";

		// action
		$this->_action->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->_action->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->_action->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->_action->HrefValue = FullUrl($this->_action->HrefValue, "href");
		} else {
			$this->_action->HrefValue = "";
		}
		$this->_action->TooltipValue = "";

		// y
		$this->y->LinkCustomAttributes = "";
		$this->y->HrefValue = "";
		$this->y->TooltipValue = "";

		// sy
		$this->sy->LinkCustomAttributes = "";
		$this->sy->HrefValue = "";
		$this->sy->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->lot_no->CurrentValue)) {
			$this->lot_no->HrefValue = "dyeing_process_shortagelist.php?x_lot_no=" . $this->lot_no->CurrentValue; // Add prefix/suffix
			$this->lot_no->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->lot_no->HrefValue = FullUrl($this->lot_no->HrefValue, "href");
		} else {
			$this->lot_no->HrefValue = "";
		}
		$this->lot_no->TooltipValue = "";

		// tmp_lot
		$this->tmp_lot->LinkCustomAttributes = "";
		$this->tmp_lot->HrefValue = "";
		$this->tmp_lot->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "dyeing_processlist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// IN
		$this->IN->EditAttrs["class"] = "form-control";
		$this->IN->EditCustomAttributes = "";
		$this->IN->EditValue = $this->IN->CurrentValue;
		$this->IN->PlaceHolder = RemoveHtml($this->IN->caption());
		if (strval($this->IN->EditValue) <> "" && is_numeric($this->IN->EditValue))
			$this->IN->EditValue = FormatNumber($this->IN->EditValue, -2, -1, -2, 0);

		// OUT
		$this->OUT->EditAttrs["class"] = "form-control";
		$this->OUT->EditCustomAttributes = "";
		$this->OUT->EditValue = $this->OUT->CurrentValue;
		$this->OUT->ViewCustomAttributes = "";

		// Balance
		$this->Balance->EditAttrs["class"] = "form-control";
		$this->Balance->EditCustomAttributes = "";
		$this->Balance->EditValue = $this->Balance->CurrentValue;
		$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
		if (strval($this->Balance->EditValue) <> "" && is_numeric($this->Balance->EditValue))
			$this->Balance->EditValue = FormatNumber($this->Balance->EditValue, -2, -1, -2, 0);

		// action
		$this->_action->EditAttrs["class"] = "form-control";
		$this->_action->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_action->CurrentValue = HtmlDecode($this->_action->CurrentValue);
		$this->_action->EditValue = $this->_action->CurrentValue;
		$this->_action->PlaceHolder = RemoveHtml($this->_action->caption());

		// y
		$this->y->EditAttrs["class"] = "form-control";
		$this->y->EditCustomAttributes = "";
		$this->y->EditValue = $this->y->CurrentValue;
		$this->y->PlaceHolder = RemoveHtml($this->y->caption());
		if (strval($this->y->EditValue) <> "" && is_numeric($this->y->EditValue))
			$this->y->EditValue = FormatNumber($this->y->EditValue, -2, -1, -2, 0);

		// sy
		$this->sy->EditAttrs["class"] = "form-control";
		$this->sy->EditCustomAttributes = "";
		$this->sy->EditValue = $this->sy->CurrentValue;
		$this->sy->PlaceHolder = RemoveHtml($this->sy->caption());
		if (strval($this->sy->EditValue) <> "" && is_numeric($this->sy->EditValue))
			$this->sy->EditValue = FormatNumber($this->sy->EditValue, -2, -1, -2, 0);

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// tmp_lot
		$this->tmp_lot->EditAttrs["class"] = "form-control";
		$this->tmp_lot->EditCustomAttributes = "";
		$this->tmp_lot->EditValue = $this->tmp_lot->CurrentValue;
		$this->tmp_lot->PlaceHolder = RemoveHtml($this->tmp_lot->caption());
		if (strval($this->tmp_lot->EditValue) <> "" && is_numeric($this->tmp_lot->EditValue))
			$this->tmp_lot->EditValue = FormatNumber($this->tmp_lot->EditValue, -2, -2, -2, -2);

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->CurrentValue;
		$this->status->PlaceHolder = RemoveHtml($this->status->caption());

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->IN->CurrentValue))
				$this->IN->Total += $this->IN->CurrentValue; // Accumulate total
			if (is_numeric($this->OUT->CurrentValue))
				$this->OUT->Total += $this->OUT->CurrentValue; // Accumulate total
			if (is_numeric($this->Balance->CurrentValue))
				$this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
			$this->y->Count++; // Increment count
			if (is_numeric($this->y->CurrentValue))
				$this->y->Total += $this->y->CurrentValue; // Accumulate total
			$this->sy->Count++; // Increment count
			if (is_numeric($this->sy->CurrentValue))
				$this->sy->Total += $this->sy->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->IN->CurrentValue = $this->IN->Total;
			$this->IN->ViewValue = $this->IN->CurrentValue;
			$this->IN->ViewCustomAttributes = "";
			$this->IN->HrefValue = ""; // Clear href value
			$this->OUT->CurrentValue = $this->OUT->Total;
			$this->OUT->ViewValue = $this->OUT->CurrentValue;
			$this->OUT->ViewCustomAttributes = "";
			$this->OUT->HrefValue = ""; // Clear href value
			$this->Balance->CurrentValue = $this->Balance->Total;
			$this->Balance->ViewValue = $this->Balance->CurrentValue;
			$this->Balance->ViewCustomAttributes = "";
			$this->Balance->HrefValue = ""; // Clear href value
			if ($this->y->Count > 0) {
				$this->y->CurrentValue = $this->y->Total / $this->y->Count;
			}
			$this->y->ViewValue = $this->y->CurrentValue;
			$this->y->ViewCustomAttributes = "";
			$this->y->HrefValue = ""; // Clear href value
			if ($this->sy->Count > 0) {
				$this->sy->CurrentValue = $this->sy->Total / $this->sy->Count;
			}
			$this->sy->ViewValue = $this->sy->CurrentValue;
			$this->sy->ViewCustomAttributes = "";
			$this->sy->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->_action);
					$doc->exportCaption($this->y);
					$doc->exportCaption($this->sy);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->tmp_lot);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->remarks);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->_action);
					$doc->exportCaption($this->y);
					$doc->exportCaption($this->sy);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->tmp_lot);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->remarks);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->product);
						$doc->exportField($this->product_code);
						$doc->exportField($this->IN);
						$doc->exportField($this->OUT);
						$doc->exportField($this->Balance);
						$doc->exportField($this->_action);
						$doc->exportField($this->y);
						$doc->exportField($this->sy);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->tmp_lot);
						$doc->exportField($this->godown);
						$doc->exportField($this->remarks);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->product);
						$doc->exportField($this->product_code);
						$doc->exportField($this->IN);
						$doc->exportField($this->OUT);
						$doc->exportField($this->Balance);
						$doc->exportField($this->_action);
						$doc->exportField($this->y);
						$doc->exportField($this->sy);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->tmp_lot);
						$doc->exportField($this->godown);
						$doc->exportField($this->remarks);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->product_code, '');
				$doc->exportAggregate($this->IN, 'TOTAL');
				$doc->exportAggregate($this->OUT, 'TOTAL');
				$doc->exportAggregate($this->Balance, 'TOTAL');
				$doc->exportAggregate($this->_action, '');
				$doc->exportAggregate($this->y, 'AVERAGE');
				$doc->exportAggregate($this->sy, 'AVERAGE');
				$doc->exportAggregate($this->lot_no, '');
				$doc->exportAggregate($this->tmp_lot, '');
				$doc->exportAggregate($this->godown, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>