<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class gate_pass_edit extends gate_pass
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'gate_pass';

	// Page object name
	public $PageObjName = "gate_pass_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (gate_pass)
		if (!isset($GLOBALS["gate_pass"]) || get_class($GLOBALS["gate_pass"]) == PROJECT_NAMESPACE . "gate_pass") {
			$GLOBALS["gate_pass"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["gate_pass"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'gate_pass');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $gate_pass;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($gate_pass);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "gate_passview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['gp_no'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->gp_no->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("gate_passlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->gp_no->setVisibility();
		$this->_print->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->from->setVisibility();
		$this->to->setVisibility();
		$this->to_other->setVisibility();
		$this->attention->setVisibility();
		$this->transfer_nature->setVisibility();
		$this->due_date->setVisibility();
		$this->jc_no->setVisibility();
		$this->item->setVisibility();
		$this->quantity->Visible = FALSE;
		$this->sender_comments->setVisibility();
		$this->despatch_details->setVisibility();
		$this->t_mode->setVisibility();
		$this->t_distance->setVisibility();
		$this->t_v_no->setVisibility();
		$this->purpose->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->e_operator->Visible = FALSE;
		$this->e_datetime->Visible = FALSE;
		$this->receiving_condition->setVisibility();
		$this->receiver_comments->setVisibility();
		$this->r_operator->setVisibility();
		$this->r_datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->r_e_user_id->Visible = FALSE;
		$this->r_e_datetime->Visible = FALSE;
		$this->group->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->count_received->Visible = FALSE;
		$this->gt_id->Visible = FALSE;
		$this->to_category->Visible = FALSE;
		$this->from_po->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->from->Required = FALSE;
		$this->to->Required = FALSE;
		$this->transfer_nature->Required = FALSE;
		$this->item->Required = FALSE;
		$this->receiving_condition->Required = FALSE;
		$this->receiver_comments->Required = FALSE;
		$this->r_operator->Required = FALSE;
		$this->r_datetime->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->from);
		$this->setupLookupOptions($this->to);
		$this->setupLookupOptions($this->attention);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->r_operator);
		$this->setupLookupOptions($this->r_e_user_id);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_gp_no")) {
				$this->gp_no->setFormValue($CurrentForm->getValue("x_gp_no"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("gp_no") !== NULL) {
				$this->gp_no->setQueryStringValue(Get("gp_no"));
				$loadByQuery = TRUE;
			} else {
				$this->gp_no->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("gate_passlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "gate_passlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'gp_no' first before field var 'x_gp_no'
		$val = $CurrentForm->hasValue("gp_no") ? $CurrentForm->getValue("gp_no") : $CurrentForm->getValue("x_gp_no");
		if (!$this->gp_no->IsDetailKey)
			$this->gp_no->setFormValue($val);

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'from' first before field var 'x_from'
		$val = $CurrentForm->hasValue("from") ? $CurrentForm->getValue("from") : $CurrentForm->getValue("x_from");
		if (!$this->from->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->from->Visible = FALSE; // Disable update for API request
			else
				$this->from->setFormValue($val);
		}

		// Check field name 'to' first before field var 'x_to'
		$val = $CurrentForm->hasValue("to") ? $CurrentForm->getValue("to") : $CurrentForm->getValue("x_to");
		if (!$this->to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->to->Visible = FALSE; // Disable update for API request
			else
				$this->to->setFormValue($val);
		}

		// Check field name 'to_other' first before field var 'x_to_other'
		$val = $CurrentForm->hasValue("to_other") ? $CurrentForm->getValue("to_other") : $CurrentForm->getValue("x_to_other");
		if (!$this->to_other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->to_other->Visible = FALSE; // Disable update for API request
			else
				$this->to_other->setFormValue($val);
		}

		// Check field name 'attention' first before field var 'x_attention'
		$val = $CurrentForm->hasValue("attention") ? $CurrentForm->getValue("attention") : $CurrentForm->getValue("x_attention");
		if (!$this->attention->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->attention->Visible = FALSE; // Disable update for API request
			else
				$this->attention->setFormValue($val);
		}

		// Check field name 'transfer_nature' first before field var 'x_transfer_nature'
		$val = $CurrentForm->hasValue("transfer_nature") ? $CurrentForm->getValue("transfer_nature") : $CurrentForm->getValue("x_transfer_nature");
		if (!$this->transfer_nature->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->transfer_nature->Visible = FALSE; // Disable update for API request
			else
				$this->transfer_nature->setFormValue($val);
		}

		// Check field name 'due_date' first before field var 'x_due_date'
		$val = $CurrentForm->hasValue("due_date") ? $CurrentForm->getValue("due_date") : $CurrentForm->getValue("x_due_date");
		if (!$this->due_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->due_date->Visible = FALSE; // Disable update for API request
			else
				$this->due_date->setFormValue($val);
			$this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, 0);
		}

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->jc_no->Visible = FALSE; // Disable update for API request
			else
				$this->jc_no->setFormValue($val);
		}

		// Check field name 'item' first before field var 'x_item'
		$val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
		if (!$this->item->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->item->Visible = FALSE; // Disable update for API request
			else
				$this->item->setFormValue($val);
		}

		// Check field name 'sender_comments' first before field var 'x_sender_comments'
		$val = $CurrentForm->hasValue("sender_comments") ? $CurrentForm->getValue("sender_comments") : $CurrentForm->getValue("x_sender_comments");
		if (!$this->sender_comments->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sender_comments->Visible = FALSE; // Disable update for API request
			else
				$this->sender_comments->setFormValue($val);
		}

		// Check field name 'despatch details' first before field var 'x_despatch_details'
		$val = $CurrentForm->hasValue("despatch details") ? $CurrentForm->getValue("despatch details") : $CurrentForm->getValue("x_despatch_details");
		if (!$this->despatch_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->despatch_details->Visible = FALSE; // Disable update for API request
			else
				$this->despatch_details->setFormValue($val);
		}

		// Check field name 't_mode' first before field var 'x_t_mode'
		$val = $CurrentForm->hasValue("t_mode") ? $CurrentForm->getValue("t_mode") : $CurrentForm->getValue("x_t_mode");
		if (!$this->t_mode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_mode->Visible = FALSE; // Disable update for API request
			else
				$this->t_mode->setFormValue($val);
		}

		// Check field name 't_distance' first before field var 'x_t_distance'
		$val = $CurrentForm->hasValue("t_distance") ? $CurrentForm->getValue("t_distance") : $CurrentForm->getValue("x_t_distance");
		if (!$this->t_distance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_distance->Visible = FALSE; // Disable update for API request
			else
				$this->t_distance->setFormValue($val);
		}

		// Check field name 't_v_no' first before field var 'x_t_v_no'
		$val = $CurrentForm->hasValue("t_v_no") ? $CurrentForm->getValue("t_v_no") : $CurrentForm->getValue("x_t_v_no");
		if (!$this->t_v_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->t_v_no->Visible = FALSE; // Disable update for API request
			else
				$this->t_v_no->setFormValue($val);
		}

		// Check field name 'purpose' first before field var 'x_purpose'
		$val = $CurrentForm->hasValue("purpose") ? $CurrentForm->getValue("purpose") : $CurrentForm->getValue("x_purpose");
		if (!$this->purpose->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->purpose->Visible = FALSE; // Disable update for API request
			else
				$this->purpose->setFormValue($val);
		}

		// Check field name 'receiving_condition' first before field var 'x_receiving_condition'
		$val = $CurrentForm->hasValue("receiving_condition") ? $CurrentForm->getValue("receiving_condition") : $CurrentForm->getValue("x_receiving_condition");
		if (!$this->receiving_condition->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->receiving_condition->Visible = FALSE; // Disable update for API request
			else
				$this->receiving_condition->setFormValue($val);
		}

		// Check field name 'receiver_comments' first before field var 'x_receiver_comments'
		$val = $CurrentForm->hasValue("receiver_comments") ? $CurrentForm->getValue("receiver_comments") : $CurrentForm->getValue("x_receiver_comments");
		if (!$this->receiver_comments->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->receiver_comments->Visible = FALSE; // Disable update for API request
			else
				$this->receiver_comments->setFormValue($val);
		}

		// Check field name 'r_operator' first before field var 'x_r_operator'
		$val = $CurrentForm->hasValue("r_operator") ? $CurrentForm->getValue("r_operator") : $CurrentForm->getValue("x_r_operator");
		if (!$this->r_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->r_operator->Visible = FALSE; // Disable update for API request
			else
				$this->r_operator->setFormValue($val);
		}

		// Check field name 'r_datetime' first before field var 'x_r_datetime'
		$val = $CurrentForm->hasValue("r_datetime") ? $CurrentForm->getValue("r_datetime") : $CurrentForm->getValue("x_r_datetime");
		if (!$this->r_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->r_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->r_datetime->setFormValue($val);
			$this->r_datetime->CurrentValue = UnFormatDateTime($this->r_datetime->CurrentValue, 0);
		}

		// Check field name 'from_po' first before field var 'x_from_po'
		$val = $CurrentForm->hasValue("from_po") ? $CurrentForm->getValue("from_po") : $CurrentForm->getValue("x_from_po");
		if (!$this->from_po->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->from_po->Visible = FALSE; // Disable update for API request
			else
				$this->from_po->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->gp_no->CurrentValue = $this->gp_no->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->from->CurrentValue = $this->from->FormValue;
		$this->to->CurrentValue = $this->to->FormValue;
		$this->to_other->CurrentValue = $this->to_other->FormValue;
		$this->attention->CurrentValue = $this->attention->FormValue;
		$this->transfer_nature->CurrentValue = $this->transfer_nature->FormValue;
		$this->due_date->CurrentValue = $this->due_date->FormValue;
		$this->due_date->CurrentValue = UnFormatDateTime($this->due_date->CurrentValue, 0);
		$this->jc_no->CurrentValue = $this->jc_no->FormValue;
		$this->item->CurrentValue = $this->item->FormValue;
		$this->sender_comments->CurrentValue = $this->sender_comments->FormValue;
		$this->despatch_details->CurrentValue = $this->despatch_details->FormValue;
		$this->t_mode->CurrentValue = $this->t_mode->FormValue;
		$this->t_distance->CurrentValue = $this->t_distance->FormValue;
		$this->t_v_no->CurrentValue = $this->t_v_no->FormValue;
		$this->purpose->CurrentValue = $this->purpose->FormValue;
		$this->receiving_condition->CurrentValue = $this->receiving_condition->FormValue;
		$this->receiver_comments->CurrentValue = $this->receiver_comments->FormValue;
		$this->r_operator->CurrentValue = $this->r_operator->FormValue;
		$this->r_datetime->CurrentValue = $this->r_datetime->FormValue;
		$this->r_datetime->CurrentValue = UnFormatDateTime($this->r_datetime->CurrentValue, 0);
		$this->from_po->CurrentValue = $this->from_po->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->gp_no->setDbValue($row['gp_no']);
		$this->_print->setDbValue($row['print']);
		$this->company_id->setDbValue($row['company_id']);
		$this->from->setDbValue($row['from']);
		$this->to->setDbValue($row['to']);
		$this->to_other->setDbValue($row['to_other']);
		$this->attention->setDbValue($row['attention']);
		$this->transfer_nature->setDbValue($row['transfer_nature']);
		$this->due_date->setDbValue($row['due_date']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->item->setDbValue($row['item']);
		$this->quantity->setDbValue($row['quantity']);
		$this->sender_comments->setDbValue($row['sender_comments']);
		$this->despatch_details->setDbValue($row['despatch details']);
		$this->t_mode->setDbValue($row['t_mode']);
		$this->t_distance->setDbValue($row['t_distance']);
		$this->t_v_no->setDbValue($row['t_v_no']);
		$this->purpose->setDbValue($row['purpose']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->e_operator->setDbValue($row['e_operator']);
		$this->e_datetime->setDbValue($row['e_datetime']);
		$this->receiving_condition->setDbValue($row['receiving_condition']);
		$this->receiver_comments->setDbValue($row['receiver_comments']);
		$this->r_operator->setDbValue($row['r_operator']);
		$this->r_datetime->setDbValue($row['r_datetime']);
		$this->updated->setDbValue($row['updated']);
		$this->r_e_user_id->setDbValue($row['r_e_user_id']);
		$this->r_e_datetime->setDbValue($row['r_e_datetime']);
		$this->group->setDbValue($row['group']);
		$this->product->setDbValue($row['product']);
		$this->count_received->setDbValue($row['count_received']);
		$this->gt_id->setDbValue($row['gt_id']);
		$this->to_category->setDbValue($row['to_category']);
		$this->from_po->setDbValue($row['from_po']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['gp_no'] = NULL;
		$row['print'] = NULL;
		$row['company_id'] = NULL;
		$row['from'] = NULL;
		$row['to'] = NULL;
		$row['to_other'] = NULL;
		$row['attention'] = NULL;
		$row['transfer_nature'] = NULL;
		$row['due_date'] = NULL;
		$row['jc_no'] = NULL;
		$row['item'] = NULL;
		$row['quantity'] = NULL;
		$row['sender_comments'] = NULL;
		$row['despatch details'] = NULL;
		$row['t_mode'] = NULL;
		$row['t_distance'] = NULL;
		$row['t_v_no'] = NULL;
		$row['purpose'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['e_operator'] = NULL;
		$row['e_datetime'] = NULL;
		$row['receiving_condition'] = NULL;
		$row['receiver_comments'] = NULL;
		$row['r_operator'] = NULL;
		$row['r_datetime'] = NULL;
		$row['updated'] = NULL;
		$row['r_e_user_id'] = NULL;
		$row['r_e_datetime'] = NULL;
		$row['group'] = NULL;
		$row['product'] = NULL;
		$row['count_received'] = NULL;
		$row['gt_id'] = NULL;
		$row['to_category'] = NULL;
		$row['from_po'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("gp_no")) <> "")
			$this->gp_no->CurrentValue = $this->getKey("gp_no"); // gp_no
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// gp_no
		// print
		// company_id
		// from
		// to
		// to_other
		// attention
		// transfer_nature
		// due_date
		// jc_no
		// item
		// quantity
		// sender_comments
		// despatch details
		// t_mode
		// t_distance
		// t_v_no
		// purpose
		// operator
		// datetime
		// e_operator
		// e_datetime
		// receiving_condition
		// receiver_comments
		// r_operator
		// r_datetime
		// updated
		// r_e_user_id
		// r_e_datetime
		// group
		// product
		// count_received
		// gt_id
		// to_category
		// from_po

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// gp_no
			$this->gp_no->ViewValue = $this->gp_no->CurrentValue;
			$this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, 0, -2, -2, -2);
			$this->gp_no->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// from
			$curVal = strval($this->from->CurrentValue);
			if ($curVal <> "") {
				$this->from->ViewValue = $this->from->lookupCacheOption($curVal);
				if ($this->from->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() != 0) ? "`id` > 10 and `status` = 1 and `id` IN (".User_Site().")" : "`id` > 10 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->from->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->from->ViewValue = $this->from->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->from->ViewValue = $this->from->CurrentValue;
					}
				}
			} else {
				$this->from->ViewValue = NULL;
			}
			$this->from->ViewCustomAttributes = "";

			// to
			$curVal = strval($this->to->CurrentValue);
			if ($curVal <> "") {
				$this->to->ViewValue = $this->to->lookupCacheOption($curVal);
				if ($this->to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "((FIND_IN_SET(`partner_type`, '1,0') and `status` = 1 and `id` > 10 and `category` != 1) || (`id` = 0))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->to->ViewValue = $this->to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->to->ViewValue = $this->to->CurrentValue;
					}
				}
			} else {
				$this->to->ViewValue = NULL;
			}
			$this->to->ViewCustomAttributes = "";

			// to_other
			$this->to_other->ViewValue = $this->to_other->CurrentValue;
			$this->to_other->ViewCustomAttributes = "";

			// attention
			$curVal = strval($this->attention->CurrentValue);
			if ($curVal <> "") {
				$this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
				if ($this->attention->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->attention->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->attention->ViewValue = $this->attention->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->attention->ViewValue = $this->attention->CurrentValue;
					}
				}
			} else {
				$this->attention->ViewValue = NULL;
			}
			$this->attention->ViewCustomAttributes = "";

			// transfer_nature
			if (strval($this->transfer_nature->CurrentValue) <> "") {
				$this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
			} else {
				$this->transfer_nature->ViewValue = NULL;
			}
			$this->transfer_nature->ViewCustomAttributes = "";

			// due_date
			$this->due_date->ViewValue = $this->due_date->CurrentValue;
			$this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, 0);
			$this->due_date->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			if ($this->item->ViewValue != NULL) $this->item->ViewValue = str_replace("\n", "<br>", $this->item->ViewValue);
			$this->item->ViewCustomAttributes = "";

			// sender_comments
			$this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;
			$this->sender_comments->ViewCustomAttributes = "";

			// despatch details
			$this->despatch_details->ViewValue = $this->despatch_details->CurrentValue;
			$this->despatch_details->ViewCustomAttributes = "";

			// t_mode
			if (strval($this->t_mode->CurrentValue) <> "") {
				$this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
			} else {
				$this->t_mode->ViewValue = NULL;
			}
			$this->t_mode->ViewCustomAttributes = "";

			// t_distance
			$this->t_distance->ViewValue = $this->t_distance->CurrentValue;
			$this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, 0, -2, -2, -2);
			$this->t_distance->ViewCustomAttributes = "";

			// t_v_no
			$this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;
			$this->t_v_no->ViewCustomAttributes = "";

			// purpose
			$this->purpose->ViewValue = $this->purpose->CurrentValue;
			$this->purpose->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// e_operator
			$this->e_operator->ViewValue = $this->e_operator->CurrentValue;
			$this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, 0, -2, -2, -2);
			$this->e_operator->ViewCustomAttributes = "";

			// e_datetime
			$this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
			$this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, 0);
			$this->e_datetime->ViewCustomAttributes = "";

			// receiving_condition
			if (strval($this->receiving_condition->CurrentValue) <> "") {
				$this->receiving_condition->ViewValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
			} else {
				$this->receiving_condition->ViewValue = NULL;
			}
			$this->receiving_condition->ViewCustomAttributes = "";

			// receiver_comments
			$this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;
			$this->receiver_comments->ViewCustomAttributes = "";

			// r_operator
			$curVal = strval($this->r_operator->CurrentValue);
			if ($curVal <> "") {
				$this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
				if ($this->r_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->r_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->r_operator->ViewValue = $this->r_operator->CurrentValue;
					}
				}
			} else {
				$this->r_operator->ViewValue = NULL;
			}
			$this->r_operator->ViewCustomAttributes = "";

			// r_datetime
			$this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
			$this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, 0);
			$this->r_datetime->ViewCustomAttributes = "";

			// from_po
			$this->from_po->ViewValue = $this->from_po->CurrentValue;
			$this->from_po->ViewValue = FormatNumber($this->from_po->ViewValue, 0, -2, -2, -2);
			$this->from_po->ViewCustomAttributes = "";

			// gp_no
			$this->gp_no->LinkCustomAttributes = "";
			$this->gp_no->HrefValue = "";
			$this->gp_no->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// from
			$this->from->LinkCustomAttributes = "";
			if (!EmptyValue($this->from->CurrentValue)) {
				$this->from->HrefValue = "gate_passlist.php?x_from=" . $this->from->CurrentValue; // Add prefix/suffix
				$this->from->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->from->HrefValue = FullUrl($this->from->HrefValue, "href");
			} else {
				$this->from->HrefValue = "";
			}
			$this->from->TooltipValue = "";

			// to
			$this->to->LinkCustomAttributes = "";
			if (!EmptyValue($this->to->CurrentValue)) {
				$this->to->HrefValue = "gate_passlist.php?x_to=" . $this->to->CurrentValue; // Add prefix/suffix
				$this->to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
			} else {
				$this->to->HrefValue = "";
			}
			$this->to->TooltipValue = "";

			// to_other
			$this->to_other->LinkCustomAttributes = "";
			$this->to_other->HrefValue = "";
			$this->to_other->TooltipValue = "";

			// attention
			$this->attention->LinkCustomAttributes = "";
			if (!EmptyValue($this->attention->CurrentValue)) {
				$this->attention->HrefValue = "gate_passlist.php?x_attention=" . $this->attention->CurrentValue; // Add prefix/suffix
				$this->attention->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
			} else {
				$this->attention->HrefValue = "";
			}
			$this->attention->TooltipValue = "";

			// transfer_nature
			$this->transfer_nature->LinkCustomAttributes = "";
			if (!EmptyValue($this->transfer_nature->CurrentValue)) {
				$this->transfer_nature->HrefValue = "gate_passlist.php?x_transfer_nature=" . $this->transfer_nature->CurrentValue; // Add prefix/suffix
				$this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
			} else {
				$this->transfer_nature->HrefValue = "";
			}
			$this->transfer_nature->TooltipValue = "";

			// due_date
			$this->due_date->LinkCustomAttributes = "";
			if (!EmptyValue($this->due_date->CurrentValue)) {
				$this->due_date->HrefValue = "gate_passlist.php?x_due_date=" . $this->due_date->CurrentValue; // Add prefix/suffix
				$this->due_date->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
			} else {
				$this->due_date->HrefValue = "";
			}
			$this->due_date->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "gate_passlist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}
			$this->item->TooltipValue = "";

			// sender_comments
			$this->sender_comments->LinkCustomAttributes = "";
			$this->sender_comments->HrefValue = "";
			$this->sender_comments->TooltipValue = "";

			// despatch details
			$this->despatch_details->LinkCustomAttributes = "";
			$this->despatch_details->HrefValue = "";
			$this->despatch_details->TooltipValue = "";

			// t_mode
			$this->t_mode->LinkCustomAttributes = "";
			if (!EmptyValue($this->t_mode->CurrentValue)) {
				$this->t_mode->HrefValue = "gate_passlist.php?x_t_mode=" . $this->t_mode->CurrentValue; // Add prefix/suffix
				$this->t_mode->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
			} else {
				$this->t_mode->HrefValue = "";
			}
			$this->t_mode->TooltipValue = "";

			// t_distance
			$this->t_distance->LinkCustomAttributes = "";
			if (!EmptyValue($this->t_distance->CurrentValue)) {
				$this->t_distance->HrefValue = "http://" . $this->t_distance->CurrentValue; // Add prefix/suffix
				$this->t_distance->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->t_distance->HrefValue = FullUrl($this->t_distance->HrefValue, "href");
			} else {
				$this->t_distance->HrefValue = "";
			}
			$this->t_distance->TooltipValue = "";

			// t_v_no
			$this->t_v_no->LinkCustomAttributes = "";
			$this->t_v_no->HrefValue = "";
			$this->t_v_no->TooltipValue = "";

			// purpose
			$this->purpose->LinkCustomAttributes = "";
			$this->purpose->HrefValue = "";
			$this->purpose->TooltipValue = "";

			// receiving_condition
			$this->receiving_condition->LinkCustomAttributes = "";
			if (!EmptyValue($this->receiving_condition->CurrentValue)) {
				$this->receiving_condition->HrefValue = "gate_passlist.php?x_receiving_condition=" . $this->receiving_condition->CurrentValue; // Add prefix/suffix
				$this->receiving_condition->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->receiving_condition->HrefValue = FullUrl($this->receiving_condition->HrefValue, "href");
			} else {
				$this->receiving_condition->HrefValue = "";
			}
			$this->receiving_condition->TooltipValue = "";

			// receiver_comments
			$this->receiver_comments->LinkCustomAttributes = "";
			$this->receiver_comments->HrefValue = "";
			$this->receiver_comments->TooltipValue = "";

			// r_operator
			$this->r_operator->LinkCustomAttributes = "";
			$this->r_operator->HrefValue = "";
			$this->r_operator->TooltipValue = "";

			// r_datetime
			$this->r_datetime->LinkCustomAttributes = "";
			$this->r_datetime->HrefValue = "";
			$this->r_datetime->TooltipValue = "";

			// from_po
			$this->from_po->LinkCustomAttributes = "";
			$this->from_po->HrefValue = "";
			$this->from_po->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// gp_no
			$this->gp_no->EditAttrs["class"] = "form-control";
			$this->gp_no->EditCustomAttributes = "";
			$this->gp_no->EditValue = $this->gp_no->CurrentValue;
			$this->gp_no->EditValue = FormatNumber($this->gp_no->EditValue, 0, -2, -2, -2);
			$this->gp_no->ViewCustomAttributes = "";

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->CurrentValue));
			if ($curVal <> "")
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `category` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// from
			$this->from->EditAttrs["class"] = "form-control";
			$this->from->EditCustomAttributes = "";
			$curVal = strval($this->from->CurrentValue);
			if ($curVal <> "") {
				$this->from->EditValue = $this->from->lookupCacheOption($curVal);
				if ($this->from->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() != 0) ? "`id` > 10 and `status` = 1 and `id` IN (".User_Site().")" : "`id` > 10 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->from->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->from->EditValue = $this->from->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->from->EditValue = $this->from->CurrentValue;
					}
				}
			} else {
				$this->from->EditValue = NULL;
			}
			$this->from->ViewCustomAttributes = "";

			// to
			$this->to->EditAttrs["class"] = "form-control";
			$this->to->EditCustomAttributes = "";
			$curVal = strval($this->to->CurrentValue);
			if ($curVal <> "") {
				$this->to->EditValue = $this->to->lookupCacheOption($curVal);
				if ($this->to->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "((FIND_IN_SET(`partner_type`, '1,0') and `status` = 1 and `id` > 10 and `category` != 1) || (`id` = 0))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->to->EditValue = $this->to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->to->EditValue = $this->to->CurrentValue;
					}
				}
			} else {
				$this->to->EditValue = NULL;
			}
			$this->to->ViewCustomAttributes = "";

			// to_other
			$this->to_other->EditAttrs["class"] = "form-control";
			$this->to_other->EditCustomAttributes = "";
			$this->to_other->EditValue = HtmlEncode($this->to_other->CurrentValue);
			$this->to_other->PlaceHolder = RemoveHtml($this->to_other->caption());

			// attention
			$this->attention->EditAttrs["class"] = "form-control";
			$this->attention->EditCustomAttributes = "";
			$curVal = trim(strval($this->attention->CurrentValue));
			if ($curVal <> "")
				$this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
			else
				$this->attention->ViewValue = $this->attention->Lookup !== NULL && is_array($this->attention->Lookup->Options) ? $curVal : NULL;
			if ($this->attention->ViewValue !== NULL) { // Load from cache
				$this->attention->EditValue = array_values($this->attention->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->attention->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->attention->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->attention->EditValue = $arwrk;
			}

			// transfer_nature
			$this->transfer_nature->EditAttrs["class"] = "form-control";
			$this->transfer_nature->EditCustomAttributes = "";
			if (strval($this->transfer_nature->CurrentValue) <> "") {
				$this->transfer_nature->EditValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
			} else {
				$this->transfer_nature->EditValue = NULL;
			}
			$this->transfer_nature->ViewCustomAttributes = "";

			// due_date
			$this->due_date->EditAttrs["class"] = "form-control";
			$this->due_date->EditCustomAttributes = "";
			$this->due_date->EditValue = $this->due_date->CurrentValue;
			$this->due_date->EditValue = FormatDateTime($this->due_date->EditValue, 0);
			$this->due_date->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = $this->jc_no->CurrentValue;
			$this->jc_no->EditValue = FormatNumber($this->jc_no->EditValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			$this->item->EditValue = $this->item->CurrentValue;
			if ($this->item->EditValue != NULL) $this->item->EditValue = str_replace("\n", "<br>", $this->item->EditValue);
			$this->item->ViewCustomAttributes = "";

			// sender_comments
			$this->sender_comments->EditAttrs["class"] = "form-control";
			$this->sender_comments->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sender_comments->CurrentValue = HtmlDecode($this->sender_comments->CurrentValue);
			$this->sender_comments->EditValue = HtmlEncode($this->sender_comments->CurrentValue);
			$this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

			// despatch details
			$this->despatch_details->EditAttrs["class"] = "form-control";
			$this->despatch_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->despatch_details->CurrentValue = HtmlDecode($this->despatch_details->CurrentValue);
			$this->despatch_details->EditValue = HtmlEncode($this->despatch_details->CurrentValue);
			$this->despatch_details->PlaceHolder = RemoveHtml($this->despatch_details->caption());

			// t_mode
			$this->t_mode->EditAttrs["class"] = "form-control";
			$this->t_mode->EditCustomAttributes = "";
			$this->t_mode->EditValue = $this->t_mode->options(TRUE);

			// t_distance
			$this->t_distance->EditAttrs["class"] = "form-control";
			$this->t_distance->EditCustomAttributes = "";
			$this->t_distance->EditValue = HtmlEncode($this->t_distance->CurrentValue);
			$this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());

			// t_v_no
			$this->t_v_no->EditAttrs["class"] = "form-control";
			$this->t_v_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_v_no->CurrentValue = HtmlDecode($this->t_v_no->CurrentValue);
			$this->t_v_no->EditValue = HtmlEncode($this->t_v_no->CurrentValue);
			$this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

			// purpose
			$this->purpose->EditAttrs["class"] = "form-control";
			$this->purpose->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->purpose->CurrentValue = HtmlDecode($this->purpose->CurrentValue);
			$this->purpose->EditValue = HtmlEncode($this->purpose->CurrentValue);
			$this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

			// receiving_condition
			$this->receiving_condition->EditAttrs["class"] = "form-control";
			$this->receiving_condition->EditCustomAttributes = "";
			if (strval($this->receiving_condition->CurrentValue) <> "") {
				$this->receiving_condition->EditValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
			} else {
				$this->receiving_condition->EditValue = NULL;
			}
			$this->receiving_condition->ViewCustomAttributes = "";

			// receiver_comments
			$this->receiver_comments->EditAttrs["class"] = "form-control";
			$this->receiver_comments->EditCustomAttributes = "";
			$this->receiver_comments->EditValue = $this->receiver_comments->CurrentValue;
			$this->receiver_comments->ViewCustomAttributes = "";

			// r_operator
			$this->r_operator->EditAttrs["class"] = "form-control";
			$this->r_operator->EditCustomAttributes = "";
			$curVal = strval($this->r_operator->CurrentValue);
			if ($curVal <> "") {
				$this->r_operator->EditValue = $this->r_operator->lookupCacheOption($curVal);
				if ($this->r_operator->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->r_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->r_operator->EditValue = $this->r_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->r_operator->EditValue = $this->r_operator->CurrentValue;
					}
				}
			} else {
				$this->r_operator->EditValue = NULL;
			}
			$this->r_operator->ViewCustomAttributes = "";

			// r_datetime
			$this->r_datetime->EditAttrs["class"] = "form-control";
			$this->r_datetime->EditCustomAttributes = "";
			$this->r_datetime->EditValue = $this->r_datetime->CurrentValue;
			$this->r_datetime->EditValue = FormatDateTime($this->r_datetime->EditValue, 0);
			$this->r_datetime->ViewCustomAttributes = "";

			// from_po
			$this->from_po->EditAttrs["class"] = "form-control";
			$this->from_po->EditCustomAttributes = "";
			$this->from_po->EditValue = HtmlEncode($this->from_po->CurrentValue);
			$this->from_po->PlaceHolder = RemoveHtml($this->from_po->caption());

			// Edit refer script
			// gp_no

			$this->gp_no->LinkCustomAttributes = "";
			$this->gp_no->HrefValue = "";
			$this->gp_no->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";

			// from
			$this->from->LinkCustomAttributes = "";
			if (!EmptyValue($this->from->CurrentValue)) {
				$this->from->HrefValue = "gate_passlist.php?x_from=" . $this->from->CurrentValue; // Add prefix/suffix
				$this->from->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->from->HrefValue = FullUrl($this->from->HrefValue, "href");
			} else {
				$this->from->HrefValue = "";
			}
			$this->from->TooltipValue = "";

			// to
			$this->to->LinkCustomAttributes = "";
			if (!EmptyValue($this->to->CurrentValue)) {
				$this->to->HrefValue = "gate_passlist.php?x_to=" . $this->to->CurrentValue; // Add prefix/suffix
				$this->to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
			} else {
				$this->to->HrefValue = "";
			}
			$this->to->TooltipValue = "";

			// to_other
			$this->to_other->LinkCustomAttributes = "";
			$this->to_other->HrefValue = "";

			// attention
			$this->attention->LinkCustomAttributes = "";
			if (!EmptyValue($this->attention->CurrentValue)) {
				$this->attention->HrefValue = "gate_passlist.php?x_attention=" . $this->attention->CurrentValue; // Add prefix/suffix
				$this->attention->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
			} else {
				$this->attention->HrefValue = "";
			}

			// transfer_nature
			$this->transfer_nature->LinkCustomAttributes = "";
			if (!EmptyValue($this->transfer_nature->CurrentValue)) {
				$this->transfer_nature->HrefValue = "gate_passlist.php?x_transfer_nature=" . $this->transfer_nature->CurrentValue; // Add prefix/suffix
				$this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
			} else {
				$this->transfer_nature->HrefValue = "";
			}
			$this->transfer_nature->TooltipValue = "";

			// due_date
			$this->due_date->LinkCustomAttributes = "";
			if (!EmptyValue($this->due_date->CurrentValue)) {
				$this->due_date->HrefValue = "gate_passlist.php?x_due_date=" . $this->due_date->CurrentValue; // Add prefix/suffix
				$this->due_date->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
			} else {
				$this->due_date->HrefValue = "";
			}
			$this->due_date->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "gate_passlist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}
			$this->item->TooltipValue = "";

			// sender_comments
			$this->sender_comments->LinkCustomAttributes = "";
			$this->sender_comments->HrefValue = "";

			// despatch details
			$this->despatch_details->LinkCustomAttributes = "";
			$this->despatch_details->HrefValue = "";

			// t_mode
			$this->t_mode->LinkCustomAttributes = "";
			if (!EmptyValue($this->t_mode->CurrentValue)) {
				$this->t_mode->HrefValue = "gate_passlist.php?x_t_mode=" . $this->t_mode->CurrentValue; // Add prefix/suffix
				$this->t_mode->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
			} else {
				$this->t_mode->HrefValue = "";
			}

			// t_distance
			$this->t_distance->LinkCustomAttributes = "";
			if (!EmptyValue($this->t_distance->CurrentValue)) {
				$this->t_distance->HrefValue = "http://" . $this->t_distance->CurrentValue; // Add prefix/suffix
				$this->t_distance->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->t_distance->HrefValue = FullUrl($this->t_distance->HrefValue, "href");
			} else {
				$this->t_distance->HrefValue = "";
			}

			// t_v_no
			$this->t_v_no->LinkCustomAttributes = "";
			$this->t_v_no->HrefValue = "";

			// purpose
			$this->purpose->LinkCustomAttributes = "";
			$this->purpose->HrefValue = "";

			// receiving_condition
			$this->receiving_condition->LinkCustomAttributes = "";
			if (!EmptyValue($this->receiving_condition->CurrentValue)) {
				$this->receiving_condition->HrefValue = "gate_passlist.php?x_receiving_condition=" . $this->receiving_condition->CurrentValue; // Add prefix/suffix
				$this->receiving_condition->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->receiving_condition->HrefValue = FullUrl($this->receiving_condition->HrefValue, "href");
			} else {
				$this->receiving_condition->HrefValue = "";
			}
			$this->receiving_condition->TooltipValue = "";

			// receiver_comments
			$this->receiver_comments->LinkCustomAttributes = "";
			$this->receiver_comments->HrefValue = "";
			$this->receiver_comments->TooltipValue = "";

			// r_operator
			$this->r_operator->LinkCustomAttributes = "";
			$this->r_operator->HrefValue = "";
			$this->r_operator->TooltipValue = "";

			// r_datetime
			$this->r_datetime->LinkCustomAttributes = "";
			$this->r_datetime->HrefValue = "";
			$this->r_datetime->TooltipValue = "";

			// from_po
			$this->from_po->LinkCustomAttributes = "";
			$this->from_po->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->gp_no->Required) {
			if (!$this->gp_no->IsDetailKey && $this->gp_no->FormValue != NULL && $this->gp_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gp_no->caption(), $this->gp_no->RequiredErrorMessage));
			}
		}
		if ($this->_print->Required) {
			if (!$this->_print->IsDetailKey && $this->_print->FormValue != NULL && $this->_print->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_print->caption(), $this->_print->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->from->Required) {
			if (!$this->from->IsDetailKey && $this->from->FormValue != NULL && $this->from->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->from->caption(), $this->from->RequiredErrorMessage));
			}
		}
		if ($this->to->Required) {
			if (!$this->to->IsDetailKey && $this->to->FormValue != NULL && $this->to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->to->caption(), $this->to->RequiredErrorMessage));
			}
		}
		if ($this->to_other->Required) {
			if (!$this->to_other->IsDetailKey && $this->to_other->FormValue != NULL && $this->to_other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->to_other->caption(), $this->to_other->RequiredErrorMessage));
			}
		}
		if ($this->attention->Required) {
			if (!$this->attention->IsDetailKey && $this->attention->FormValue != NULL && $this->attention->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->attention->caption(), $this->attention->RequiredErrorMessage));
			}
		}
		if ($this->transfer_nature->Required) {
			if (!$this->transfer_nature->IsDetailKey && $this->transfer_nature->FormValue != NULL && $this->transfer_nature->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->transfer_nature->caption(), $this->transfer_nature->RequiredErrorMessage));
			}
		}
		if ($this->due_date->Required) {
			if (!$this->due_date->IsDetailKey && $this->due_date->FormValue != NULL && $this->due_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->due_date->caption(), $this->due_date->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->item->Required) {
			if (!$this->item->IsDetailKey && $this->item->FormValue != NULL && $this->item->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->sender_comments->Required) {
			if (!$this->sender_comments->IsDetailKey && $this->sender_comments->FormValue != NULL && $this->sender_comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sender_comments->caption(), $this->sender_comments->RequiredErrorMessage));
			}
		}
		if ($this->despatch_details->Required) {
			if (!$this->despatch_details->IsDetailKey && $this->despatch_details->FormValue != NULL && $this->despatch_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->despatch_details->caption(), $this->despatch_details->RequiredErrorMessage));
			}
		}
		if ($this->t_mode->Required) {
			if (!$this->t_mode->IsDetailKey && $this->t_mode->FormValue != NULL && $this->t_mode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_mode->caption(), $this->t_mode->RequiredErrorMessage));
			}
		}
		if ($this->t_distance->Required) {
			if (!$this->t_distance->IsDetailKey && $this->t_distance->FormValue != NULL && $this->t_distance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_distance->caption(), $this->t_distance->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->t_distance->FormValue)) {
			AddMessage($FormError, $this->t_distance->errorMessage());
		}
		if ($this->t_v_no->Required) {
			if (!$this->t_v_no->IsDetailKey && $this->t_v_no->FormValue != NULL && $this->t_v_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_v_no->caption(), $this->t_v_no->RequiredErrorMessage));
			}
		}
		if ($this->purpose->Required) {
			if (!$this->purpose->IsDetailKey && $this->purpose->FormValue != NULL && $this->purpose->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->purpose->caption(), $this->purpose->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->e_operator->Required) {
			if (!$this->e_operator->IsDetailKey && $this->e_operator->FormValue != NULL && $this->e_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->e_operator->caption(), $this->e_operator->RequiredErrorMessage));
			}
		}
		if ($this->e_datetime->Required) {
			if (!$this->e_datetime->IsDetailKey && $this->e_datetime->FormValue != NULL && $this->e_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->e_datetime->caption(), $this->e_datetime->RequiredErrorMessage));
			}
		}
		if ($this->receiving_condition->Required) {
			if (!$this->receiving_condition->IsDetailKey && $this->receiving_condition->FormValue != NULL && $this->receiving_condition->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->receiving_condition->caption(), $this->receiving_condition->RequiredErrorMessage));
			}
		}
		if ($this->receiver_comments->Required) {
			if (!$this->receiver_comments->IsDetailKey && $this->receiver_comments->FormValue != NULL && $this->receiver_comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->receiver_comments->caption(), $this->receiver_comments->RequiredErrorMessage));
			}
		}
		if ($this->r_operator->Required) {
			if (!$this->r_operator->IsDetailKey && $this->r_operator->FormValue != NULL && $this->r_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_operator->caption(), $this->r_operator->RequiredErrorMessage));
			}
		}
		if ($this->r_datetime->Required) {
			if (!$this->r_datetime->IsDetailKey && $this->r_datetime->FormValue != NULL && $this->r_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_datetime->caption(), $this->r_datetime->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}
		if ($this->r_e_user_id->Required) {
			if (!$this->r_e_user_id->IsDetailKey && $this->r_e_user_id->FormValue != NULL && $this->r_e_user_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_e_user_id->caption(), $this->r_e_user_id->RequiredErrorMessage));
			}
		}
		if ($this->r_e_datetime->Required) {
			if (!$this->r_e_datetime->IsDetailKey && $this->r_e_datetime->FormValue != NULL && $this->r_e_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_e_datetime->caption(), $this->r_e_datetime->RequiredErrorMessage));
			}
		}
		if ($this->group->Required) {
			if (!$this->group->IsDetailKey && $this->group->FormValue != NULL && $this->group->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->group->caption(), $this->group->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->count_received->Required) {
			if (!$this->count_received->IsDetailKey && $this->count_received->FormValue != NULL && $this->count_received->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->count_received->caption(), $this->count_received->RequiredErrorMessage));
			}
		}
		if ($this->gt_id->Required) {
			if (!$this->gt_id->IsDetailKey && $this->gt_id->FormValue != NULL && $this->gt_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gt_id->caption(), $this->gt_id->RequiredErrorMessage));
			}
		}
		if ($this->to_category->Required) {
			if (!$this->to_category->IsDetailKey && $this->to_category->FormValue != NULL && $this->to_category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->to_category->caption(), $this->to_category->RequiredErrorMessage));
			}
		}
		if ($this->from_po->Required) {
			if (!$this->from_po->IsDetailKey && $this->from_po->FormValue != NULL && $this->from_po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->from_po->caption(), $this->from_po->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->from_po->FormValue)) {
			AddMessage($FormError, $this->from_po->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// company_id
			$this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, NULL, $this->company_id->ReadOnly);

			// to_other
			$this->to_other->setDbValueDef($rsnew, $this->to_other->CurrentValue, NULL, $this->to_other->ReadOnly);

			// attention
			$this->attention->setDbValueDef($rsnew, $this->attention->CurrentValue, 0, $this->attention->ReadOnly);

			// sender_comments
			$this->sender_comments->setDbValueDef($rsnew, $this->sender_comments->CurrentValue, "", $this->sender_comments->ReadOnly);

			// despatch details
			$this->despatch_details->setDbValueDef($rsnew, $this->despatch_details->CurrentValue, "", $this->despatch_details->ReadOnly);

			// t_mode
			$this->t_mode->setDbValueDef($rsnew, $this->t_mode->CurrentValue, NULL, $this->t_mode->ReadOnly);

			// t_distance
			$this->t_distance->setDbValueDef($rsnew, $this->t_distance->CurrentValue, NULL, $this->t_distance->ReadOnly);

			// t_v_no
			$this->t_v_no->setDbValueDef($rsnew, $this->t_v_no->CurrentValue, NULL, $this->t_v_no->ReadOnly);

			// purpose
			$this->purpose->setDbValueDef($rsnew, $this->purpose->CurrentValue, NULL, $this->purpose->ReadOnly);

			// from_po
			$this->from_po->setDbValueDef($rsnew, $this->from_po->CurrentValue, NULL, $this->from_po->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("gate_passlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_from":
					$lookupFilter = function() {
						return (User_Site() != 0) ? "`id` > 10 and `status` = 1 and `id` IN (".User_Site().")" : "`id` > 10 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_to":
					$lookupFilter = function() {
						return "((FIND_IN_SET(`partner_type`, '1,0') and `status` = 1 and `id` > 10 and `category` != 1) || (`id` = 0))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_attention":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_from":
							break;
						case "x_to":
							break;
						case "x_attention":
							break;
						case "x_operator":
							break;
						case "x_r_operator":
							break;
						case "x_r_e_user_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>