<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class gate_pass_list extends gate_pass
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'gate_pass';

	// Page object name
	public $PageObjName = "gate_pass_list";

	// Grid form hidden field names
	public $FormName = "fgate_passlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (gate_pass)
		if (!isset($GLOBALS["gate_pass"]) || get_class($GLOBALS["gate_pass"]) == PROJECT_NAMESPACE . "gate_pass") {
			$GLOBALS["gate_pass"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["gate_pass"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "gate_passadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "gate_passdelete.php";
		$this->MultiUpdateUrl = "gate_passupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'gate_pass');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fgate_passlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $gate_pass;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($gate_pass);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['gp_no'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->gp_no->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->gp_no->setVisibility();
		$this->_print->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->from->setVisibility();
		$this->to->setVisibility();
		$this->to_other->Visible = FALSE;
		$this->attention->setVisibility();
		$this->transfer_nature->setVisibility();
		$this->due_date->setVisibility();
		$this->jc_no->setVisibility();
		$this->item->setVisibility();
		$this->quantity->Visible = FALSE;
		$this->sender_comments->setVisibility();
		$this->despatch_details->setVisibility();
		$this->t_mode->setVisibility();
		$this->t_distance->setVisibility();
		$this->t_v_no->setVisibility();
		$this->purpose->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->e_operator->setVisibility();
		$this->e_datetime->setVisibility();
		$this->receiving_condition->setVisibility();
		$this->receiver_comments->setVisibility();
		$this->r_operator->setVisibility();
		$this->r_datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->r_e_user_id->Visible = FALSE;
		$this->r_e_datetime->Visible = FALSE;
		$this->group->Visible = FALSE;
		$this->product->Visible = FALSE;
		$this->count_received->Visible = FALSE;
		$this->gt_id->Visible = FALSE;
		$this->to_category->Visible = FALSE;
		$this->from_po->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->from);
		$this->setupLookupOptions($this->to);
		$this->setupLookupOptions($this->attention);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->r_operator);
		$this->setupLookupOptions($this->r_e_user_id);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->gp_no->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->gp_no->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fgate_passlistsrch");
		$filterList = Concat($filterList, $this->gp_no->AdvancedSearch->toJson(), ","); // Field gp_no
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->from->AdvancedSearch->toJson(), ","); // Field from
		$filterList = Concat($filterList, $this->to->AdvancedSearch->toJson(), ","); // Field to
		$filterList = Concat($filterList, $this->to_other->AdvancedSearch->toJson(), ","); // Field to_other
		$filterList = Concat($filterList, $this->attention->AdvancedSearch->toJson(), ","); // Field attention
		$filterList = Concat($filterList, $this->transfer_nature->AdvancedSearch->toJson(), ","); // Field transfer_nature
		$filterList = Concat($filterList, $this->due_date->AdvancedSearch->toJson(), ","); // Field due_date
		$filterList = Concat($filterList, $this->jc_no->AdvancedSearch->toJson(), ","); // Field jc_no
		$filterList = Concat($filterList, $this->item->AdvancedSearch->toJson(), ","); // Field item
		$filterList = Concat($filterList, $this->sender_comments->AdvancedSearch->toJson(), ","); // Field sender_comments
		$filterList = Concat($filterList, $this->despatch_details->AdvancedSearch->toJson(), ","); // Field despatch details
		$filterList = Concat($filterList, $this->t_mode->AdvancedSearch->toJson(), ","); // Field t_mode
		$filterList = Concat($filterList, $this->t_distance->AdvancedSearch->toJson(), ","); // Field t_distance
		$filterList = Concat($filterList, $this->t_v_no->AdvancedSearch->toJson(), ","); // Field t_v_no
		$filterList = Concat($filterList, $this->purpose->AdvancedSearch->toJson(), ","); // Field purpose
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->e_operator->AdvancedSearch->toJson(), ","); // Field e_operator
		$filterList = Concat($filterList, $this->e_datetime->AdvancedSearch->toJson(), ","); // Field e_datetime
		$filterList = Concat($filterList, $this->receiving_condition->AdvancedSearch->toJson(), ","); // Field receiving_condition
		$filterList = Concat($filterList, $this->receiver_comments->AdvancedSearch->toJson(), ","); // Field receiver_comments
		$filterList = Concat($filterList, $this->r_operator->AdvancedSearch->toJson(), ","); // Field r_operator
		$filterList = Concat($filterList, $this->r_datetime->AdvancedSearch->toJson(), ","); // Field r_datetime
		$filterList = Concat($filterList, $this->updated->AdvancedSearch->toJson(), ","); // Field updated
		$filterList = Concat($filterList, $this->r_e_user_id->AdvancedSearch->toJson(), ","); // Field r_e_user_id
		$filterList = Concat($filterList, $this->r_e_datetime->AdvancedSearch->toJson(), ","); // Field r_e_datetime
		$filterList = Concat($filterList, $this->group->AdvancedSearch->toJson(), ","); // Field group
		$filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
		$filterList = Concat($filterList, $this->count_received->AdvancedSearch->toJson(), ","); // Field count_received
		$filterList = Concat($filterList, $this->gt_id->AdvancedSearch->toJson(), ","); // Field gt_id
		$filterList = Concat($filterList, $this->from_po->AdvancedSearch->toJson(), ","); // Field from_po
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fgate_passlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field gp_no
		$this->gp_no->AdvancedSearch->SearchValue = @$filter["x_gp_no"];
		$this->gp_no->AdvancedSearch->SearchOperator = @$filter["z_gp_no"];
		$this->gp_no->AdvancedSearch->SearchCondition = @$filter["v_gp_no"];
		$this->gp_no->AdvancedSearch->SearchValue2 = @$filter["y_gp_no"];
		$this->gp_no->AdvancedSearch->SearchOperator2 = @$filter["w_gp_no"];
		$this->gp_no->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field from
		$this->from->AdvancedSearch->SearchValue = @$filter["x_from"];
		$this->from->AdvancedSearch->SearchOperator = @$filter["z_from"];
		$this->from->AdvancedSearch->SearchCondition = @$filter["v_from"];
		$this->from->AdvancedSearch->SearchValue2 = @$filter["y_from"];
		$this->from->AdvancedSearch->SearchOperator2 = @$filter["w_from"];
		$this->from->AdvancedSearch->save();

		// Field to
		$this->to->AdvancedSearch->SearchValue = @$filter["x_to"];
		$this->to->AdvancedSearch->SearchOperator = @$filter["z_to"];
		$this->to->AdvancedSearch->SearchCondition = @$filter["v_to"];
		$this->to->AdvancedSearch->SearchValue2 = @$filter["y_to"];
		$this->to->AdvancedSearch->SearchOperator2 = @$filter["w_to"];
		$this->to->AdvancedSearch->save();

		// Field to_other
		$this->to_other->AdvancedSearch->SearchValue = @$filter["x_to_other"];
		$this->to_other->AdvancedSearch->SearchOperator = @$filter["z_to_other"];
		$this->to_other->AdvancedSearch->SearchCondition = @$filter["v_to_other"];
		$this->to_other->AdvancedSearch->SearchValue2 = @$filter["y_to_other"];
		$this->to_other->AdvancedSearch->SearchOperator2 = @$filter["w_to_other"];
		$this->to_other->AdvancedSearch->save();

		// Field attention
		$this->attention->AdvancedSearch->SearchValue = @$filter["x_attention"];
		$this->attention->AdvancedSearch->SearchOperator = @$filter["z_attention"];
		$this->attention->AdvancedSearch->SearchCondition = @$filter["v_attention"];
		$this->attention->AdvancedSearch->SearchValue2 = @$filter["y_attention"];
		$this->attention->AdvancedSearch->SearchOperator2 = @$filter["w_attention"];
		$this->attention->AdvancedSearch->save();

		// Field transfer_nature
		$this->transfer_nature->AdvancedSearch->SearchValue = @$filter["x_transfer_nature"];
		$this->transfer_nature->AdvancedSearch->SearchOperator = @$filter["z_transfer_nature"];
		$this->transfer_nature->AdvancedSearch->SearchCondition = @$filter["v_transfer_nature"];
		$this->transfer_nature->AdvancedSearch->SearchValue2 = @$filter["y_transfer_nature"];
		$this->transfer_nature->AdvancedSearch->SearchOperator2 = @$filter["w_transfer_nature"];
		$this->transfer_nature->AdvancedSearch->save();

		// Field due_date
		$this->due_date->AdvancedSearch->SearchValue = @$filter["x_due_date"];
		$this->due_date->AdvancedSearch->SearchOperator = @$filter["z_due_date"];
		$this->due_date->AdvancedSearch->SearchCondition = @$filter["v_due_date"];
		$this->due_date->AdvancedSearch->SearchValue2 = @$filter["y_due_date"];
		$this->due_date->AdvancedSearch->SearchOperator2 = @$filter["w_due_date"];
		$this->due_date->AdvancedSearch->save();

		// Field jc_no
		$this->jc_no->AdvancedSearch->SearchValue = @$filter["x_jc_no"];
		$this->jc_no->AdvancedSearch->SearchOperator = @$filter["z_jc_no"];
		$this->jc_no->AdvancedSearch->SearchCondition = @$filter["v_jc_no"];
		$this->jc_no->AdvancedSearch->SearchValue2 = @$filter["y_jc_no"];
		$this->jc_no->AdvancedSearch->SearchOperator2 = @$filter["w_jc_no"];
		$this->jc_no->AdvancedSearch->save();

		// Field item
		$this->item->AdvancedSearch->SearchValue = @$filter["x_item"];
		$this->item->AdvancedSearch->SearchOperator = @$filter["z_item"];
		$this->item->AdvancedSearch->SearchCondition = @$filter["v_item"];
		$this->item->AdvancedSearch->SearchValue2 = @$filter["y_item"];
		$this->item->AdvancedSearch->SearchOperator2 = @$filter["w_item"];
		$this->item->AdvancedSearch->save();

		// Field sender_comments
		$this->sender_comments->AdvancedSearch->SearchValue = @$filter["x_sender_comments"];
		$this->sender_comments->AdvancedSearch->SearchOperator = @$filter["z_sender_comments"];
		$this->sender_comments->AdvancedSearch->SearchCondition = @$filter["v_sender_comments"];
		$this->sender_comments->AdvancedSearch->SearchValue2 = @$filter["y_sender_comments"];
		$this->sender_comments->AdvancedSearch->SearchOperator2 = @$filter["w_sender_comments"];
		$this->sender_comments->AdvancedSearch->save();

		// Field despatch details
		$this->despatch_details->AdvancedSearch->SearchValue = @$filter["x_despatch_details"];
		$this->despatch_details->AdvancedSearch->SearchOperator = @$filter["z_despatch_details"];
		$this->despatch_details->AdvancedSearch->SearchCondition = @$filter["v_despatch_details"];
		$this->despatch_details->AdvancedSearch->SearchValue2 = @$filter["y_despatch_details"];
		$this->despatch_details->AdvancedSearch->SearchOperator2 = @$filter["w_despatch_details"];
		$this->despatch_details->AdvancedSearch->save();

		// Field t_mode
		$this->t_mode->AdvancedSearch->SearchValue = @$filter["x_t_mode"];
		$this->t_mode->AdvancedSearch->SearchOperator = @$filter["z_t_mode"];
		$this->t_mode->AdvancedSearch->SearchCondition = @$filter["v_t_mode"];
		$this->t_mode->AdvancedSearch->SearchValue2 = @$filter["y_t_mode"];
		$this->t_mode->AdvancedSearch->SearchOperator2 = @$filter["w_t_mode"];
		$this->t_mode->AdvancedSearch->save();

		// Field t_distance
		$this->t_distance->AdvancedSearch->SearchValue = @$filter["x_t_distance"];
		$this->t_distance->AdvancedSearch->SearchOperator = @$filter["z_t_distance"];
		$this->t_distance->AdvancedSearch->SearchCondition = @$filter["v_t_distance"];
		$this->t_distance->AdvancedSearch->SearchValue2 = @$filter["y_t_distance"];
		$this->t_distance->AdvancedSearch->SearchOperator2 = @$filter["w_t_distance"];
		$this->t_distance->AdvancedSearch->save();

		// Field t_v_no
		$this->t_v_no->AdvancedSearch->SearchValue = @$filter["x_t_v_no"];
		$this->t_v_no->AdvancedSearch->SearchOperator = @$filter["z_t_v_no"];
		$this->t_v_no->AdvancedSearch->SearchCondition = @$filter["v_t_v_no"];
		$this->t_v_no->AdvancedSearch->SearchValue2 = @$filter["y_t_v_no"];
		$this->t_v_no->AdvancedSearch->SearchOperator2 = @$filter["w_t_v_no"];
		$this->t_v_no->AdvancedSearch->save();

		// Field purpose
		$this->purpose->AdvancedSearch->SearchValue = @$filter["x_purpose"];
		$this->purpose->AdvancedSearch->SearchOperator = @$filter["z_purpose"];
		$this->purpose->AdvancedSearch->SearchCondition = @$filter["v_purpose"];
		$this->purpose->AdvancedSearch->SearchValue2 = @$filter["y_purpose"];
		$this->purpose->AdvancedSearch->SearchOperator2 = @$filter["w_purpose"];
		$this->purpose->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field e_operator
		$this->e_operator->AdvancedSearch->SearchValue = @$filter["x_e_operator"];
		$this->e_operator->AdvancedSearch->SearchOperator = @$filter["z_e_operator"];
		$this->e_operator->AdvancedSearch->SearchCondition = @$filter["v_e_operator"];
		$this->e_operator->AdvancedSearch->SearchValue2 = @$filter["y_e_operator"];
		$this->e_operator->AdvancedSearch->SearchOperator2 = @$filter["w_e_operator"];
		$this->e_operator->AdvancedSearch->save();

		// Field e_datetime
		$this->e_datetime->AdvancedSearch->SearchValue = @$filter["x_e_datetime"];
		$this->e_datetime->AdvancedSearch->SearchOperator = @$filter["z_e_datetime"];
		$this->e_datetime->AdvancedSearch->SearchCondition = @$filter["v_e_datetime"];
		$this->e_datetime->AdvancedSearch->SearchValue2 = @$filter["y_e_datetime"];
		$this->e_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_e_datetime"];
		$this->e_datetime->AdvancedSearch->save();

		// Field receiving_condition
		$this->receiving_condition->AdvancedSearch->SearchValue = @$filter["x_receiving_condition"];
		$this->receiving_condition->AdvancedSearch->SearchOperator = @$filter["z_receiving_condition"];
		$this->receiving_condition->AdvancedSearch->SearchCondition = @$filter["v_receiving_condition"];
		$this->receiving_condition->AdvancedSearch->SearchValue2 = @$filter["y_receiving_condition"];
		$this->receiving_condition->AdvancedSearch->SearchOperator2 = @$filter["w_receiving_condition"];
		$this->receiving_condition->AdvancedSearch->save();

		// Field receiver_comments
		$this->receiver_comments->AdvancedSearch->SearchValue = @$filter["x_receiver_comments"];
		$this->receiver_comments->AdvancedSearch->SearchOperator = @$filter["z_receiver_comments"];
		$this->receiver_comments->AdvancedSearch->SearchCondition = @$filter["v_receiver_comments"];
		$this->receiver_comments->AdvancedSearch->SearchValue2 = @$filter["y_receiver_comments"];
		$this->receiver_comments->AdvancedSearch->SearchOperator2 = @$filter["w_receiver_comments"];
		$this->receiver_comments->AdvancedSearch->save();

		// Field r_operator
		$this->r_operator->AdvancedSearch->SearchValue = @$filter["x_r_operator"];
		$this->r_operator->AdvancedSearch->SearchOperator = @$filter["z_r_operator"];
		$this->r_operator->AdvancedSearch->SearchCondition = @$filter["v_r_operator"];
		$this->r_operator->AdvancedSearch->SearchValue2 = @$filter["y_r_operator"];
		$this->r_operator->AdvancedSearch->SearchOperator2 = @$filter["w_r_operator"];
		$this->r_operator->AdvancedSearch->save();

		// Field r_datetime
		$this->r_datetime->AdvancedSearch->SearchValue = @$filter["x_r_datetime"];
		$this->r_datetime->AdvancedSearch->SearchOperator = @$filter["z_r_datetime"];
		$this->r_datetime->AdvancedSearch->SearchCondition = @$filter["v_r_datetime"];
		$this->r_datetime->AdvancedSearch->SearchValue2 = @$filter["y_r_datetime"];
		$this->r_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_r_datetime"];
		$this->r_datetime->AdvancedSearch->save();

		// Field updated
		$this->updated->AdvancedSearch->SearchValue = @$filter["x_updated"];
		$this->updated->AdvancedSearch->SearchOperator = @$filter["z_updated"];
		$this->updated->AdvancedSearch->SearchCondition = @$filter["v_updated"];
		$this->updated->AdvancedSearch->SearchValue2 = @$filter["y_updated"];
		$this->updated->AdvancedSearch->SearchOperator2 = @$filter["w_updated"];
		$this->updated->AdvancedSearch->save();

		// Field r_e_user_id
		$this->r_e_user_id->AdvancedSearch->SearchValue = @$filter["x_r_e_user_id"];
		$this->r_e_user_id->AdvancedSearch->SearchOperator = @$filter["z_r_e_user_id"];
		$this->r_e_user_id->AdvancedSearch->SearchCondition = @$filter["v_r_e_user_id"];
		$this->r_e_user_id->AdvancedSearch->SearchValue2 = @$filter["y_r_e_user_id"];
		$this->r_e_user_id->AdvancedSearch->SearchOperator2 = @$filter["w_r_e_user_id"];
		$this->r_e_user_id->AdvancedSearch->save();

		// Field r_e_datetime
		$this->r_e_datetime->AdvancedSearch->SearchValue = @$filter["x_r_e_datetime"];
		$this->r_e_datetime->AdvancedSearch->SearchOperator = @$filter["z_r_e_datetime"];
		$this->r_e_datetime->AdvancedSearch->SearchCondition = @$filter["v_r_e_datetime"];
		$this->r_e_datetime->AdvancedSearch->SearchValue2 = @$filter["y_r_e_datetime"];
		$this->r_e_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_r_e_datetime"];
		$this->r_e_datetime->AdvancedSearch->save();

		// Field group
		$this->group->AdvancedSearch->SearchValue = @$filter["x_group"];
		$this->group->AdvancedSearch->SearchOperator = @$filter["z_group"];
		$this->group->AdvancedSearch->SearchCondition = @$filter["v_group"];
		$this->group->AdvancedSearch->SearchValue2 = @$filter["y_group"];
		$this->group->AdvancedSearch->SearchOperator2 = @$filter["w_group"];
		$this->group->AdvancedSearch->save();

		// Field product
		$this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
		$this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
		$this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
		$this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
		$this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
		$this->product->AdvancedSearch->save();

		// Field count_received
		$this->count_received->AdvancedSearch->SearchValue = @$filter["x_count_received"];
		$this->count_received->AdvancedSearch->SearchOperator = @$filter["z_count_received"];
		$this->count_received->AdvancedSearch->SearchCondition = @$filter["v_count_received"];
		$this->count_received->AdvancedSearch->SearchValue2 = @$filter["y_count_received"];
		$this->count_received->AdvancedSearch->SearchOperator2 = @$filter["w_count_received"];
		$this->count_received->AdvancedSearch->save();

		// Field gt_id
		$this->gt_id->AdvancedSearch->SearchValue = @$filter["x_gt_id"];
		$this->gt_id->AdvancedSearch->SearchOperator = @$filter["z_gt_id"];
		$this->gt_id->AdvancedSearch->SearchCondition = @$filter["v_gt_id"];
		$this->gt_id->AdvancedSearch->SearchValue2 = @$filter["y_gt_id"];
		$this->gt_id->AdvancedSearch->SearchOperator2 = @$filter["w_gt_id"];
		$this->gt_id->AdvancedSearch->save();

		// Field from_po
		$this->from_po->AdvancedSearch->SearchValue = @$filter["x_from_po"];
		$this->from_po->AdvancedSearch->SearchOperator = @$filter["z_from_po"];
		$this->from_po->AdvancedSearch->SearchCondition = @$filter["v_from_po"];
		$this->from_po->AdvancedSearch->SearchValue2 = @$filter["y_from_po"];
		$this->from_po->AdvancedSearch->SearchOperator2 = @$filter["w_from_po"];
		$this->from_po->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->gp_no, $default, FALSE); // gp_no
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->from, $default, FALSE); // from
		$this->buildSearchSql($where, $this->to, $default, FALSE); // to
		$this->buildSearchSql($where, $this->to_other, $default, FALSE); // to_other
		$this->buildSearchSql($where, $this->attention, $default, FALSE); // attention
		$this->buildSearchSql($where, $this->transfer_nature, $default, FALSE); // transfer_nature
		$this->buildSearchSql($where, $this->due_date, $default, FALSE); // due_date
		$this->buildSearchSql($where, $this->jc_no, $default, FALSE); // jc_no
		$this->buildSearchSql($where, $this->item, $default, FALSE); // item
		$this->buildSearchSql($where, $this->sender_comments, $default, FALSE); // sender_comments
		$this->buildSearchSql($where, $this->despatch_details, $default, FALSE); // despatch details
		$this->buildSearchSql($where, $this->t_mode, $default, FALSE); // t_mode
		$this->buildSearchSql($where, $this->t_distance, $default, FALSE); // t_distance
		$this->buildSearchSql($where, $this->t_v_no, $default, FALSE); // t_v_no
		$this->buildSearchSql($where, $this->purpose, $default, FALSE); // purpose
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->e_operator, $default, FALSE); // e_operator
		$this->buildSearchSql($where, $this->e_datetime, $default, FALSE); // e_datetime
		$this->buildSearchSql($where, $this->receiving_condition, $default, FALSE); // receiving_condition
		$this->buildSearchSql($where, $this->receiver_comments, $default, FALSE); // receiver_comments
		$this->buildSearchSql($where, $this->r_operator, $default, FALSE); // r_operator
		$this->buildSearchSql($where, $this->r_datetime, $default, FALSE); // r_datetime
		$this->buildSearchSql($where, $this->updated, $default, FALSE); // updated
		$this->buildSearchSql($where, $this->r_e_user_id, $default, FALSE); // r_e_user_id
		$this->buildSearchSql($where, $this->r_e_datetime, $default, FALSE); // r_e_datetime
		$this->buildSearchSql($where, $this->group, $default, FALSE); // group
		$this->buildSearchSql($where, $this->product, $default, FALSE); // product
		$this->buildSearchSql($where, $this->count_received, $default, FALSE); // count_received
		$this->buildSearchSql($where, $this->gt_id, $default, FALSE); // gt_id
		$this->buildSearchSql($where, $this->from_po, $default, FALSE); // from_po

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->gp_no->AdvancedSearch->save(); // gp_no
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->from->AdvancedSearch->save(); // from
			$this->to->AdvancedSearch->save(); // to
			$this->to_other->AdvancedSearch->save(); // to_other
			$this->attention->AdvancedSearch->save(); // attention
			$this->transfer_nature->AdvancedSearch->save(); // transfer_nature
			$this->due_date->AdvancedSearch->save(); // due_date
			$this->jc_no->AdvancedSearch->save(); // jc_no
			$this->item->AdvancedSearch->save(); // item
			$this->sender_comments->AdvancedSearch->save(); // sender_comments
			$this->despatch_details->AdvancedSearch->save(); // despatch details
			$this->t_mode->AdvancedSearch->save(); // t_mode
			$this->t_distance->AdvancedSearch->save(); // t_distance
			$this->t_v_no->AdvancedSearch->save(); // t_v_no
			$this->purpose->AdvancedSearch->save(); // purpose
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->e_operator->AdvancedSearch->save(); // e_operator
			$this->e_datetime->AdvancedSearch->save(); // e_datetime
			$this->receiving_condition->AdvancedSearch->save(); // receiving_condition
			$this->receiver_comments->AdvancedSearch->save(); // receiver_comments
			$this->r_operator->AdvancedSearch->save(); // r_operator
			$this->r_datetime->AdvancedSearch->save(); // r_datetime
			$this->updated->AdvancedSearch->save(); // updated
			$this->r_e_user_id->AdvancedSearch->save(); // r_e_user_id
			$this->r_e_datetime->AdvancedSearch->save(); // r_e_datetime
			$this->group->AdvancedSearch->save(); // group
			$this->product->AdvancedSearch->save(); // product
			$this->count_received->AdvancedSearch->save(); // count_received
			$this->gt_id->AdvancedSearch->save(); // gt_id
			$this->from_po->AdvancedSearch->save(); // from_po
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->to_other, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->item, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sender_comments, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->despatch_details, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_v_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->purpose, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->gp_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->from->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->to->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->to_other->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->attention->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->transfer_nature->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->due_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->jc_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->item->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sender_comments->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->despatch_details->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_mode->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_distance->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_v_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->purpose->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->e_operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->e_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->receiving_condition->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->receiver_comments->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->r_operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->r_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->updated->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->r_e_user_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->r_e_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->group->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->count_received->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gt_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->from_po->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->gp_no->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->from->AdvancedSearch->unsetSession();
		$this->to->AdvancedSearch->unsetSession();
		$this->to_other->AdvancedSearch->unsetSession();
		$this->attention->AdvancedSearch->unsetSession();
		$this->transfer_nature->AdvancedSearch->unsetSession();
		$this->due_date->AdvancedSearch->unsetSession();
		$this->jc_no->AdvancedSearch->unsetSession();
		$this->item->AdvancedSearch->unsetSession();
		$this->sender_comments->AdvancedSearch->unsetSession();
		$this->despatch_details->AdvancedSearch->unsetSession();
		$this->t_mode->AdvancedSearch->unsetSession();
		$this->t_distance->AdvancedSearch->unsetSession();
		$this->t_v_no->AdvancedSearch->unsetSession();
		$this->purpose->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->e_operator->AdvancedSearch->unsetSession();
		$this->e_datetime->AdvancedSearch->unsetSession();
		$this->receiving_condition->AdvancedSearch->unsetSession();
		$this->receiver_comments->AdvancedSearch->unsetSession();
		$this->r_operator->AdvancedSearch->unsetSession();
		$this->r_datetime->AdvancedSearch->unsetSession();
		$this->updated->AdvancedSearch->unsetSession();
		$this->r_e_user_id->AdvancedSearch->unsetSession();
		$this->r_e_datetime->AdvancedSearch->unsetSession();
		$this->group->AdvancedSearch->unsetSession();
		$this->product->AdvancedSearch->unsetSession();
		$this->count_received->AdvancedSearch->unsetSession();
		$this->gt_id->AdvancedSearch->unsetSession();
		$this->from_po->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->gp_no->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->from->AdvancedSearch->load();
		$this->to->AdvancedSearch->load();
		$this->to_other->AdvancedSearch->load();
		$this->attention->AdvancedSearch->load();
		$this->transfer_nature->AdvancedSearch->load();
		$this->due_date->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->sender_comments->AdvancedSearch->load();
		$this->despatch_details->AdvancedSearch->load();
		$this->t_mode->AdvancedSearch->load();
		$this->t_distance->AdvancedSearch->load();
		$this->t_v_no->AdvancedSearch->load();
		$this->purpose->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->e_operator->AdvancedSearch->load();
		$this->e_datetime->AdvancedSearch->load();
		$this->receiving_condition->AdvancedSearch->load();
		$this->receiver_comments->AdvancedSearch->load();
		$this->r_operator->AdvancedSearch->load();
		$this->r_datetime->AdvancedSearch->load();
		$this->updated->AdvancedSearch->load();
		$this->r_e_user_id->AdvancedSearch->load();
		$this->r_e_datetime->AdvancedSearch->load();
		$this->group->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->count_received->AdvancedSearch->load();
		$this->gt_id->AdvancedSearch->load();
		$this->from_po->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->gp_no, $ctrl); // gp_no
			$this->updateSort($this->company_id, $ctrl); // company_id
			$this->updateSort($this->from, $ctrl); // from
			$this->updateSort($this->to, $ctrl); // to
			$this->updateSort($this->attention, $ctrl); // attention
			$this->updateSort($this->transfer_nature, $ctrl); // transfer_nature
			$this->updateSort($this->due_date, $ctrl); // due_date
			$this->updateSort($this->jc_no, $ctrl); // jc_no
			$this->updateSort($this->item, $ctrl); // item
			$this->updateSort($this->sender_comments, $ctrl); // sender_comments
			$this->updateSort($this->despatch_details, $ctrl); // despatch details
			$this->updateSort($this->t_mode, $ctrl); // t_mode
			$this->updateSort($this->t_distance, $ctrl); // t_distance
			$this->updateSort($this->t_v_no, $ctrl); // t_v_no
			$this->updateSort($this->purpose, $ctrl); // purpose
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->e_operator, $ctrl); // e_operator
			$this->updateSort($this->e_datetime, $ctrl); // e_datetime
			$this->updateSort($this->receiving_condition, $ctrl); // receiving_condition
			$this->updateSort($this->receiver_comments, $ctrl); // receiver_comments
			$this->updateSort($this->r_operator, $ctrl); // r_operator
			$this->updateSort($this->r_datetime, $ctrl); // r_datetime
			$this->updateSort($this->from_po, $ctrl); // from_po
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->gp_no->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->gp_no->setSort("");
				$this->company_id->setSort("");
				$this->from->setSort("");
				$this->to->setSort("");
				$this->attention->setSort("");
				$this->transfer_nature->setSort("");
				$this->due_date->setSort("");
				$this->jc_no->setSort("");
				$this->item->setSort("");
				$this->sender_comments->setSort("");
				$this->despatch_details->setSort("");
				$this->t_mode->setSort("");
				$this->t_distance->setSort("");
				$this->t_v_no->setSort("");
				$this->purpose->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->e_operator->setSort("");
				$this->e_datetime->setSort("");
				$this->receiving_condition->setSort("");
				$this->receiver_comments->setSort("");
				$this->r_operator->setSort("");
				$this->r_datetime->setSort("");
				$this->from_po->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->gp_no->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fgate_passlistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fgate_passlistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fgate_passlist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fgate_passlistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		$item->Body = "<a class=\"btn btn-default ew-advanced-aearch\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"gate_passsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fgate_passlistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// gp_no

		if (!$this->isAddOrEdit())
			$this->gp_no->AdvancedSearch->setSearchValue(Get("x_gp_no", Get("gp_no", "")));
		if ($this->gp_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gp_no->AdvancedSearch->setSearchOperator(Get("z_gp_no", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// from
		if (!$this->isAddOrEdit())
			$this->from->AdvancedSearch->setSearchValue(Get("x_from", Get("from", "")));
		if ($this->from->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->from->AdvancedSearch->setSearchOperator(Get("z_from", ""));

		// to
		if (!$this->isAddOrEdit())
			$this->to->AdvancedSearch->setSearchValue(Get("x_to", Get("to", "")));
		if ($this->to->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->to->AdvancedSearch->setSearchOperator(Get("z_to", ""));

		// to_other
		if (!$this->isAddOrEdit())
			$this->to_other->AdvancedSearch->setSearchValue(Get("x_to_other", Get("to_other", "")));
		if ($this->to_other->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->to_other->AdvancedSearch->setSearchOperator(Get("z_to_other", ""));

		// attention
		if (!$this->isAddOrEdit())
			$this->attention->AdvancedSearch->setSearchValue(Get("x_attention", Get("attention", "")));
		if ($this->attention->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->attention->AdvancedSearch->setSearchOperator(Get("z_attention", ""));

		// transfer_nature
		if (!$this->isAddOrEdit())
			$this->transfer_nature->AdvancedSearch->setSearchValue(Get("x_transfer_nature", Get("transfer_nature", "")));
		if ($this->transfer_nature->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->transfer_nature->AdvancedSearch->setSearchOperator(Get("z_transfer_nature", ""));

		// due_date
		if (!$this->isAddOrEdit())
			$this->due_date->AdvancedSearch->setSearchValue(Get("x_due_date", Get("due_date", "")));
		if ($this->due_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->due_date->AdvancedSearch->setSearchOperator(Get("z_due_date", ""));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue(Get("x_jc_no", Get("jc_no", "")));
		if ($this->jc_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->jc_no->AdvancedSearch->setSearchOperator(Get("z_jc_no", ""));

		// item
		if (!$this->isAddOrEdit())
			$this->item->AdvancedSearch->setSearchValue(Get("x_item", Get("item", "")));
		if ($this->item->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->item->AdvancedSearch->setSearchOperator(Get("z_item", ""));

		// sender_comments
		if (!$this->isAddOrEdit())
			$this->sender_comments->AdvancedSearch->setSearchValue(Get("x_sender_comments", Get("sender_comments", "")));
		if ($this->sender_comments->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sender_comments->AdvancedSearch->setSearchOperator(Get("z_sender_comments", ""));

		// despatch details
		if (!$this->isAddOrEdit())
			$this->despatch_details->AdvancedSearch->setSearchValue(Get("x_despatch_details", Get("despatch_details", "")));
		if ($this->despatch_details->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->despatch_details->AdvancedSearch->setSearchOperator(Get("z_despatch_details", ""));

		// t_mode
		if (!$this->isAddOrEdit())
			$this->t_mode->AdvancedSearch->setSearchValue(Get("x_t_mode", Get("t_mode", "")));
		if ($this->t_mode->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_mode->AdvancedSearch->setSearchOperator(Get("z_t_mode", ""));

		// t_distance
		if (!$this->isAddOrEdit())
			$this->t_distance->AdvancedSearch->setSearchValue(Get("x_t_distance", Get("t_distance", "")));
		if ($this->t_distance->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_distance->AdvancedSearch->setSearchOperator(Get("z_t_distance", ""));

		// t_v_no
		if (!$this->isAddOrEdit())
			$this->t_v_no->AdvancedSearch->setSearchValue(Get("x_t_v_no", Get("t_v_no", "")));
		if ($this->t_v_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_v_no->AdvancedSearch->setSearchOperator(Get("z_t_v_no", ""));

		// purpose
		if (!$this->isAddOrEdit())
			$this->purpose->AdvancedSearch->setSearchValue(Get("x_purpose", Get("purpose", "")));
		if ($this->purpose->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->purpose->AdvancedSearch->setSearchOperator(Get("z_purpose", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// e_operator
		if (!$this->isAddOrEdit())
			$this->e_operator->AdvancedSearch->setSearchValue(Get("x_e_operator", Get("e_operator", "")));
		if ($this->e_operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->e_operator->AdvancedSearch->setSearchOperator(Get("z_e_operator", ""));

		// e_datetime
		if (!$this->isAddOrEdit())
			$this->e_datetime->AdvancedSearch->setSearchValue(Get("x_e_datetime", Get("e_datetime", "")));
		if ($this->e_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->e_datetime->AdvancedSearch->setSearchOperator(Get("z_e_datetime", ""));

		// receiving_condition
		if (!$this->isAddOrEdit())
			$this->receiving_condition->AdvancedSearch->setSearchValue(Get("x_receiving_condition", Get("receiving_condition", "")));
		if ($this->receiving_condition->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->receiving_condition->AdvancedSearch->setSearchOperator(Get("z_receiving_condition", ""));

		// receiver_comments
		if (!$this->isAddOrEdit())
			$this->receiver_comments->AdvancedSearch->setSearchValue(Get("x_receiver_comments", Get("receiver_comments", "")));
		if ($this->receiver_comments->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->receiver_comments->AdvancedSearch->setSearchOperator(Get("z_receiver_comments", ""));

		// r_operator
		if (!$this->isAddOrEdit())
			$this->r_operator->AdvancedSearch->setSearchValue(Get("x_r_operator", Get("r_operator", "")));
		if ($this->r_operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->r_operator->AdvancedSearch->setSearchOperator(Get("z_r_operator", ""));

		// r_datetime
		if (!$this->isAddOrEdit())
			$this->r_datetime->AdvancedSearch->setSearchValue(Get("x_r_datetime", Get("r_datetime", "")));
		if ($this->r_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->r_datetime->AdvancedSearch->setSearchOperator(Get("z_r_datetime", ""));

		// updated
		if (!$this->isAddOrEdit())
			$this->updated->AdvancedSearch->setSearchValue(Get("x_updated", Get("updated", "")));
		if ($this->updated->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->updated->AdvancedSearch->setSearchOperator(Get("z_updated", ""));

		// r_e_user_id
		if (!$this->isAddOrEdit())
			$this->r_e_user_id->AdvancedSearch->setSearchValue(Get("x_r_e_user_id", Get("r_e_user_id", "")));
		if ($this->r_e_user_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->r_e_user_id->AdvancedSearch->setSearchOperator(Get("z_r_e_user_id", ""));

		// r_e_datetime
		if (!$this->isAddOrEdit())
			$this->r_e_datetime->AdvancedSearch->setSearchValue(Get("x_r_e_datetime", Get("r_e_datetime", "")));
		if ($this->r_e_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->r_e_datetime->AdvancedSearch->setSearchOperator(Get("z_r_e_datetime", ""));

		// group
		if (!$this->isAddOrEdit())
			$this->group->AdvancedSearch->setSearchValue(Get("x_group", Get("group", "")));
		if ($this->group->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->group->AdvancedSearch->setSearchOperator(Get("z_group", ""));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue(Get("x_product", Get("product", "")));
		if ($this->product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product->AdvancedSearch->setSearchOperator(Get("z_product", ""));

		// count_received
		if (!$this->isAddOrEdit())
			$this->count_received->AdvancedSearch->setSearchValue(Get("x_count_received", Get("count_received", "")));
		if ($this->count_received->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->count_received->AdvancedSearch->setSearchOperator(Get("z_count_received", ""));

		// gt_id
		if (!$this->isAddOrEdit())
			$this->gt_id->AdvancedSearch->setSearchValue(Get("x_gt_id", Get("gt_id", "")));
		if ($this->gt_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gt_id->AdvancedSearch->setSearchOperator(Get("z_gt_id", ""));

		// from_po
		if (!$this->isAddOrEdit())
			$this->from_po->AdvancedSearch->setSearchValue(Get("x_from_po", Get("from_po", "")));
		if ($this->from_po->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->from_po->AdvancedSearch->setSearchOperator(Get("z_from_po", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->gp_no->setDbValue($row['gp_no']);
		$this->_print->setDbValue($row['print']);
		$this->company_id->setDbValue($row['company_id']);
		$this->from->setDbValue($row['from']);
		$this->to->setDbValue($row['to']);
		$this->to_other->setDbValue($row['to_other']);
		$this->attention->setDbValue($row['attention']);
		$this->transfer_nature->setDbValue($row['transfer_nature']);
		$this->due_date->setDbValue($row['due_date']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->item->setDbValue($row['item']);
		$this->quantity->setDbValue($row['quantity']);
		$this->sender_comments->setDbValue($row['sender_comments']);
		$this->despatch_details->setDbValue($row['despatch details']);
		$this->t_mode->setDbValue($row['t_mode']);
		$this->t_distance->setDbValue($row['t_distance']);
		$this->t_v_no->setDbValue($row['t_v_no']);
		$this->purpose->setDbValue($row['purpose']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->e_operator->setDbValue($row['e_operator']);
		$this->e_datetime->setDbValue($row['e_datetime']);
		$this->receiving_condition->setDbValue($row['receiving_condition']);
		$this->receiver_comments->setDbValue($row['receiver_comments']);
		$this->r_operator->setDbValue($row['r_operator']);
		$this->r_datetime->setDbValue($row['r_datetime']);
		$this->updated->setDbValue($row['updated']);
		$this->r_e_user_id->setDbValue($row['r_e_user_id']);
		$this->r_e_datetime->setDbValue($row['r_e_datetime']);
		$this->group->setDbValue($row['group']);
		$this->product->setDbValue($row['product']);
		$this->count_received->setDbValue($row['count_received']);
		$this->gt_id->setDbValue($row['gt_id']);
		$this->to_category->setDbValue($row['to_category']);
		$this->from_po->setDbValue($row['from_po']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['gp_no'] = NULL;
		$row['print'] = NULL;
		$row['company_id'] = NULL;
		$row['from'] = NULL;
		$row['to'] = NULL;
		$row['to_other'] = NULL;
		$row['attention'] = NULL;
		$row['transfer_nature'] = NULL;
		$row['due_date'] = NULL;
		$row['jc_no'] = NULL;
		$row['item'] = NULL;
		$row['quantity'] = NULL;
		$row['sender_comments'] = NULL;
		$row['despatch details'] = NULL;
		$row['t_mode'] = NULL;
		$row['t_distance'] = NULL;
		$row['t_v_no'] = NULL;
		$row['purpose'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['e_operator'] = NULL;
		$row['e_datetime'] = NULL;
		$row['receiving_condition'] = NULL;
		$row['receiver_comments'] = NULL;
		$row['r_operator'] = NULL;
		$row['r_datetime'] = NULL;
		$row['updated'] = NULL;
		$row['r_e_user_id'] = NULL;
		$row['r_e_datetime'] = NULL;
		$row['group'] = NULL;
		$row['product'] = NULL;
		$row['count_received'] = NULL;
		$row['gt_id'] = NULL;
		$row['to_category'] = NULL;
		$row['from_po'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("gp_no")) <> "")
			$this->gp_no->CurrentValue = $this->getKey("gp_no"); // gp_no
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// gp_no
		// print

		$this->_print->CellCssStyle = "white-space: nowrap;";

		// company_id
		// from
		// to
		// to_other
		// attention
		// transfer_nature
		// due_date
		// jc_no
		// item
		// quantity

		$this->quantity->CellCssStyle = "white-space: nowrap;";

		// sender_comments
		// despatch details
		// t_mode
		// t_distance
		// t_v_no
		// purpose
		// operator
		// datetime
		// e_operator
		// e_datetime
		// receiving_condition
		// receiver_comments
		// r_operator
		// r_datetime
		// updated

		$this->updated->CellCssStyle = "white-space: nowrap;";

		// r_e_user_id
		$this->r_e_user_id->CellCssStyle = "white-space: nowrap;";

		// r_e_datetime
		$this->r_e_datetime->CellCssStyle = "white-space: nowrap;";

		// group
		$this->group->CellCssStyle = "white-space: nowrap;";

		// product
		$this->product->CellCssStyle = "white-space: nowrap;";

		// count_received
		$this->count_received->CellCssStyle = "white-space: nowrap;";

		// gt_id
		$this->gt_id->CellCssStyle = "white-space: nowrap;";

		// to_category
		$this->to_category->CellCssStyle = "white-space: nowrap;";

		// from_po
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// gp_no
			$this->gp_no->ViewValue = $this->gp_no->CurrentValue;
			$this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, 0, -2, -2, -2);
			$this->gp_no->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// from
			$curVal = strval($this->from->CurrentValue);
			if ($curVal <> "") {
				$this->from->ViewValue = $this->from->lookupCacheOption($curVal);
				if ($this->from->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Site() != 0) ? "`id` > 10 and `status` = 1 and `id` IN (".User_Site().")" : "`id` > 10 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->from->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->from->ViewValue = $this->from->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->from->ViewValue = $this->from->CurrentValue;
					}
				}
			} else {
				$this->from->ViewValue = NULL;
			}
			$this->from->ViewCustomAttributes = "";

			// to
			$curVal = strval($this->to->CurrentValue);
			if ($curVal <> "") {
				$this->to->ViewValue = $this->to->lookupCacheOption($curVal);
				if ($this->to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "((FIND_IN_SET(`partner_type`, '1,0') and `status` = 1 and `id` > 10 and `category` != 1) || (`id` = 0))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->to->ViewValue = $this->to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->to->ViewValue = $this->to->CurrentValue;
					}
				}
			} else {
				$this->to->ViewValue = NULL;
			}
			$this->to->ViewCustomAttributes = "";

			// attention
			$curVal = strval($this->attention->CurrentValue);
			if ($curVal <> "") {
				$this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
				if ($this->attention->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->attention->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->attention->ViewValue = $this->attention->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->attention->ViewValue = $this->attention->CurrentValue;
					}
				}
			} else {
				$this->attention->ViewValue = NULL;
			}
			$this->attention->ViewCustomAttributes = "";

			// transfer_nature
			if (strval($this->transfer_nature->CurrentValue) <> "") {
				$this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
			} else {
				$this->transfer_nature->ViewValue = NULL;
			}
			$this->transfer_nature->ViewCustomAttributes = "";

			// due_date
			$this->due_date->ViewValue = $this->due_date->CurrentValue;
			$this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, 0);
			$this->due_date->ViewCustomAttributes = "";

			// jc_no
			$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
			$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
			$this->jc_no->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			if ($this->item->ViewValue != NULL) $this->item->ViewValue = str_replace("\n", "<br>", $this->item->ViewValue);
			$this->item->ViewCustomAttributes = "";

			// sender_comments
			$this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;
			$this->sender_comments->ViewCustomAttributes = "";

			// despatch details
			$this->despatch_details->ViewValue = $this->despatch_details->CurrentValue;
			$this->despatch_details->ViewCustomAttributes = "";

			// t_mode
			if (strval($this->t_mode->CurrentValue) <> "") {
				$this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
			} else {
				$this->t_mode->ViewValue = NULL;
			}
			$this->t_mode->ViewCustomAttributes = "";

			// t_distance
			$this->t_distance->ViewValue = $this->t_distance->CurrentValue;
			$this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, 0, -2, -2, -2);
			$this->t_distance->ViewCustomAttributes = "";

			// t_v_no
			$this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;
			$this->t_v_no->ViewCustomAttributes = "";

			// purpose
			$this->purpose->ViewValue = $this->purpose->CurrentValue;
			$this->purpose->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// e_operator
			$this->e_operator->ViewValue = $this->e_operator->CurrentValue;
			$this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, 0, -2, -2, -2);
			$this->e_operator->ViewCustomAttributes = "";

			// e_datetime
			$this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
			$this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, 0);
			$this->e_datetime->ViewCustomAttributes = "";

			// receiving_condition
			if (strval($this->receiving_condition->CurrentValue) <> "") {
				$this->receiving_condition->ViewValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
			} else {
				$this->receiving_condition->ViewValue = NULL;
			}
			$this->receiving_condition->ViewCustomAttributes = "";

			// receiver_comments
			$this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;
			$this->receiver_comments->ViewCustomAttributes = "";

			// r_operator
			$curVal = strval($this->r_operator->CurrentValue);
			if ($curVal <> "") {
				$this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
				if ($this->r_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->r_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->r_operator->ViewValue = $this->r_operator->CurrentValue;
					}
				}
			} else {
				$this->r_operator->ViewValue = NULL;
			}
			$this->r_operator->ViewCustomAttributes = "";

			// r_datetime
			$this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
			$this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, 0);
			$this->r_datetime->ViewCustomAttributes = "";

			// from_po
			$this->from_po->ViewValue = $this->from_po->CurrentValue;
			$this->from_po->ViewValue = FormatNumber($this->from_po->ViewValue, 0, -2, -2, -2);
			$this->from_po->ViewCustomAttributes = "";

			// gp_no
			$this->gp_no->LinkCustomAttributes = "";
			$this->gp_no->HrefValue = "";
			$this->gp_no->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// from
			$this->from->LinkCustomAttributes = "";
			if (!EmptyValue($this->from->CurrentValue)) {
				$this->from->HrefValue = "gate_passlist.php?x_from=" . $this->from->CurrentValue; // Add prefix/suffix
				$this->from->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->from->HrefValue = FullUrl($this->from->HrefValue, "href");
			} else {
				$this->from->HrefValue = "";
			}
			$this->from->TooltipValue = "";

			// to
			$this->to->LinkCustomAttributes = "";
			if (!EmptyValue($this->to->CurrentValue)) {
				$this->to->HrefValue = "gate_passlist.php?x_to=" . $this->to->CurrentValue; // Add prefix/suffix
				$this->to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
			} else {
				$this->to->HrefValue = "";
			}
			$this->to->TooltipValue = "";

			// attention
			$this->attention->LinkCustomAttributes = "";
			if (!EmptyValue($this->attention->CurrentValue)) {
				$this->attention->HrefValue = "gate_passlist.php?x_attention=" . $this->attention->CurrentValue; // Add prefix/suffix
				$this->attention->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
			} else {
				$this->attention->HrefValue = "";
			}
			$this->attention->TooltipValue = "";

			// transfer_nature
			$this->transfer_nature->LinkCustomAttributes = "";
			if (!EmptyValue($this->transfer_nature->CurrentValue)) {
				$this->transfer_nature->HrefValue = "gate_passlist.php?x_transfer_nature=" . $this->transfer_nature->CurrentValue; // Add prefix/suffix
				$this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
			} else {
				$this->transfer_nature->HrefValue = "";
			}
			$this->transfer_nature->TooltipValue = "";

			// due_date
			$this->due_date->LinkCustomAttributes = "";
			if (!EmptyValue($this->due_date->CurrentValue)) {
				$this->due_date->HrefValue = "gate_passlist.php?x_due_date=" . $this->due_date->CurrentValue; // Add prefix/suffix
				$this->due_date->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
			} else {
				$this->due_date->HrefValue = "";
			}
			$this->due_date->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "gate_passlist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}
			$this->item->TooltipValue = "";
			if (!$this->isExport())
				$this->item->ViewValue = $this->highlightValue($this->item);

			// sender_comments
			$this->sender_comments->LinkCustomAttributes = "";
			$this->sender_comments->HrefValue = "";
			$this->sender_comments->TooltipValue = "";
			if (!$this->isExport())
				$this->sender_comments->ViewValue = $this->highlightValue($this->sender_comments);

			// despatch details
			$this->despatch_details->LinkCustomAttributes = "";
			$this->despatch_details->HrefValue = "";
			$this->despatch_details->TooltipValue = "";
			if (!$this->isExport())
				$this->despatch_details->ViewValue = $this->highlightValue($this->despatch_details);

			// t_mode
			$this->t_mode->LinkCustomAttributes = "";
			if (!EmptyValue($this->t_mode->CurrentValue)) {
				$this->t_mode->HrefValue = "gate_passlist.php?x_t_mode=" . $this->t_mode->CurrentValue; // Add prefix/suffix
				$this->t_mode->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
			} else {
				$this->t_mode->HrefValue = "";
			}
			$this->t_mode->TooltipValue = "";

			// t_distance
			$this->t_distance->LinkCustomAttributes = "";
			if (!EmptyValue($this->t_distance->CurrentValue)) {
				$this->t_distance->HrefValue = "http://" . $this->t_distance->CurrentValue; // Add prefix/suffix
				$this->t_distance->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->t_distance->HrefValue = FullUrl($this->t_distance->HrefValue, "href");
			} else {
				$this->t_distance->HrefValue = "";
			}
			$this->t_distance->TooltipValue = "";

			// t_v_no
			$this->t_v_no->LinkCustomAttributes = "";
			$this->t_v_no->HrefValue = "";
			$this->t_v_no->TooltipValue = "";
			if (!$this->isExport())
				$this->t_v_no->ViewValue = $this->highlightValue($this->t_v_no);

			// purpose
			$this->purpose->LinkCustomAttributes = "";
			$this->purpose->HrefValue = "";
			$this->purpose->TooltipValue = "";
			if (!$this->isExport())
				$this->purpose->ViewValue = $this->highlightValue($this->purpose);

			// operator
			$this->operator->LinkCustomAttributes = "";
			if (!EmptyValue($this->operator->CurrentValue)) {
				$this->operator->HrefValue = $this->operator->CurrentValue; // Add prefix/suffix
				$this->operator->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
			} else {
				$this->operator->HrefValue = "";
			}
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// e_operator
			$this->e_operator->LinkCustomAttributes = "";
			$this->e_operator->HrefValue = "";
			$this->e_operator->TooltipValue = "";

			// e_datetime
			$this->e_datetime->LinkCustomAttributes = "";
			$this->e_datetime->HrefValue = "";
			$this->e_datetime->TooltipValue = "";

			// receiving_condition
			$this->receiving_condition->LinkCustomAttributes = "";
			if (!EmptyValue($this->receiving_condition->CurrentValue)) {
				$this->receiving_condition->HrefValue = "gate_passlist.php?x_receiving_condition=" . $this->receiving_condition->CurrentValue; // Add prefix/suffix
				$this->receiving_condition->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->receiving_condition->HrefValue = FullUrl($this->receiving_condition->HrefValue, "href");
			} else {
				$this->receiving_condition->HrefValue = "";
			}
			$this->receiving_condition->TooltipValue = "";

			// receiver_comments
			$this->receiver_comments->LinkCustomAttributes = "";
			$this->receiver_comments->HrefValue = "";
			$this->receiver_comments->TooltipValue = "";

			// r_operator
			$this->r_operator->LinkCustomAttributes = "";
			$this->r_operator->HrefValue = "";
			$this->r_operator->TooltipValue = "";

			// r_datetime
			$this->r_datetime->LinkCustomAttributes = "";
			$this->r_datetime->HrefValue = "";
			$this->r_datetime->TooltipValue = "";

			// from_po
			$this->from_po->LinkCustomAttributes = "";
			$this->from_po->HrefValue = "";
			$this->from_po->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// gp_no
			$this->gp_no->EditAttrs["class"] = "form-control";
			$this->gp_no->EditCustomAttributes = "";
			$this->gp_no->EditValue = HtmlEncode($this->gp_no->AdvancedSearch->SearchValue);
			$this->gp_no->PlaceHolder = RemoveHtml($this->gp_no->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";

			// from
			$this->from->EditAttrs["class"] = "form-control";
			$this->from->EditCustomAttributes = "";
			$curVal = trim(strval($this->from->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->from->AdvancedSearch->ViewValue = $this->from->lookupCacheOption($curVal);
			else
				$this->from->AdvancedSearch->ViewValue = $this->from->Lookup !== NULL && is_array($this->from->Lookup->Options) ? $curVal : NULL;
			if ($this->from->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->from->EditValue = array_values($this->from->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->from->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Site() != 0) ? "`id` > 10 and `status` = 1 and `id` IN (".User_Site().")" : "`id` > 10 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->from->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->from->EditValue = $arwrk;
			}

			// to
			$this->to->EditAttrs["class"] = "form-control";
			$this->to->EditCustomAttributes = "";
			$curVal = trim(strval($this->to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->to->AdvancedSearch->ViewValue = $this->to->lookupCacheOption($curVal);
			else
				$this->to->AdvancedSearch->ViewValue = $this->to->Lookup !== NULL && is_array($this->to->Lookup->Options) ? $curVal : NULL;
			if ($this->to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->to->EditValue = array_values($this->to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "((FIND_IN_SET(`partner_type`, '1,0') and `status` = 1 and `id` > 10 and `category` != 1) || (`id` = 0))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->to->EditValue = $arwrk;
			}

			// attention
			$this->attention->EditAttrs["class"] = "form-control";
			$this->attention->EditCustomAttributes = "";

			// transfer_nature
			$this->transfer_nature->EditAttrs["class"] = "form-control";
			$this->transfer_nature->EditCustomAttributes = "";
			$this->transfer_nature->EditValue = $this->transfer_nature->options(TRUE);

			// due_date
			$this->due_date->EditAttrs["class"] = "form-control";
			$this->due_date->EditCustomAttributes = "";
			$this->due_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->due_date->AdvancedSearch->SearchValue, 0), 8));
			$this->due_date->PlaceHolder = RemoveHtml($this->due_date->caption());

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$this->jc_no->EditValue = HtmlEncode($this->jc_no->AdvancedSearch->SearchValue);
			$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			$this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// sender_comments
			$this->sender_comments->EditAttrs["class"] = "form-control";
			$this->sender_comments->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sender_comments->AdvancedSearch->SearchValue = HtmlDecode($this->sender_comments->AdvancedSearch->SearchValue);
			$this->sender_comments->EditValue = HtmlEncode($this->sender_comments->AdvancedSearch->SearchValue);
			$this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

			// despatch details
			$this->despatch_details->EditAttrs["class"] = "form-control";
			$this->despatch_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->despatch_details->AdvancedSearch->SearchValue = HtmlDecode($this->despatch_details->AdvancedSearch->SearchValue);
			$this->despatch_details->EditValue = HtmlEncode($this->despatch_details->AdvancedSearch->SearchValue);
			$this->despatch_details->PlaceHolder = RemoveHtml($this->despatch_details->caption());

			// t_mode
			$this->t_mode->EditAttrs["class"] = "form-control";
			$this->t_mode->EditCustomAttributes = "";
			$this->t_mode->EditValue = $this->t_mode->options(TRUE);

			// t_distance
			$this->t_distance->EditAttrs["class"] = "form-control";
			$this->t_distance->EditCustomAttributes = "";
			$this->t_distance->EditValue = HtmlEncode($this->t_distance->AdvancedSearch->SearchValue);
			$this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());

			// t_v_no
			$this->t_v_no->EditAttrs["class"] = "form-control";
			$this->t_v_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_v_no->AdvancedSearch->SearchValue = HtmlDecode($this->t_v_no->AdvancedSearch->SearchValue);
			$this->t_v_no->EditValue = HtmlEncode($this->t_v_no->AdvancedSearch->SearchValue);
			$this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

			// purpose
			$this->purpose->EditAttrs["class"] = "form-control";
			$this->purpose->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->purpose->AdvancedSearch->SearchValue = HtmlDecode($this->purpose->AdvancedSearch->SearchValue);
			$this->purpose->EditValue = HtmlEncode($this->purpose->AdvancedSearch->SearchValue);
			$this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// e_operator
			$this->e_operator->EditAttrs["class"] = "form-control";
			$this->e_operator->EditCustomAttributes = "";
			$this->e_operator->EditValue = HtmlEncode($this->e_operator->AdvancedSearch->SearchValue);
			$this->e_operator->PlaceHolder = RemoveHtml($this->e_operator->caption());

			// e_datetime
			$this->e_datetime->EditAttrs["class"] = "form-control";
			$this->e_datetime->EditCustomAttributes = "";
			$this->e_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->e_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());

			// receiving_condition
			$this->receiving_condition->EditAttrs["class"] = "form-control";
			$this->receiving_condition->EditCustomAttributes = "";
			$this->receiving_condition->EditValue = $this->receiving_condition->options(TRUE);

			// receiver_comments
			$this->receiver_comments->EditAttrs["class"] = "form-control";
			$this->receiver_comments->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->receiver_comments->AdvancedSearch->SearchValue = HtmlDecode($this->receiver_comments->AdvancedSearch->SearchValue);
			$this->receiver_comments->EditValue = HtmlEncode($this->receiver_comments->AdvancedSearch->SearchValue);
			$this->receiver_comments->PlaceHolder = RemoveHtml($this->receiver_comments->caption());

			// r_operator
			$this->r_operator->EditAttrs["class"] = "form-control";
			$this->r_operator->EditCustomAttributes = "";

			// r_datetime
			$this->r_datetime->EditAttrs["class"] = "form-control";
			$this->r_datetime->EditCustomAttributes = "";
			$this->r_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->r_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

			// from_po
			$this->from_po->EditAttrs["class"] = "form-control";
			$this->from_po->EditCustomAttributes = "";
			$this->from_po->EditValue = HtmlEncode($this->from_po->AdvancedSearch->SearchValue);
			$this->from_po->PlaceHolder = RemoveHtml($this->from_po->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->gp_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->gp_no->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->gp_no->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->from->AdvancedSearch->load();
		$this->to->AdvancedSearch->load();
		$this->to_other->AdvancedSearch->load();
		$this->attention->AdvancedSearch->load();
		$this->transfer_nature->AdvancedSearch->load();
		$this->due_date->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->sender_comments->AdvancedSearch->load();
		$this->despatch_details->AdvancedSearch->load();
		$this->t_mode->AdvancedSearch->load();
		$this->t_distance->AdvancedSearch->load();
		$this->t_v_no->AdvancedSearch->load();
		$this->purpose->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->e_operator->AdvancedSearch->load();
		$this->e_datetime->AdvancedSearch->load();
		$this->receiving_condition->AdvancedSearch->load();
		$this->receiver_comments->AdvancedSearch->load();
		$this->r_operator->AdvancedSearch->load();
		$this->r_datetime->AdvancedSearch->load();
		$this->updated->AdvancedSearch->load();
		$this->r_e_user_id->AdvancedSearch->load();
		$this->r_e_datetime->AdvancedSearch->load();
		$this->group->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->count_received->AdvancedSearch->load();
		$this->gt_id->AdvancedSearch->load();
		$this->from_po->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fgate_passlist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fgate_passlist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fgate_passlist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_gate_pass\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_gate_pass',hdr:ew.language.phrase('ExportToEmailText'),f:document.fgate_passlist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1 and `category` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_from":
					$lookupFilter = function() {
						return (User_Site() != 0) ? "`id` > 10 and `status` = 1 and `id` IN (".User_Site().")" : "`id` > 10 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_to":
					$lookupFilter = function() {
						return "((FIND_IN_SET(`partner_type`, '1,0') and `status` = 1 and `id` > 10 and `category` != 1) || (`id` = 0))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_attention":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_from":
							break;
						case "x_to":
							break;
						case "x_attention":
							break;
						case "x_operator":
							break;
						case "x_r_operator":
							break;
						case "x_r_e_user_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

			$this->ListOptions->Add("Print");
			$this->ListOptions->Items["Print"]->Body =
			'<a href="gst_challan.php?id='.$this->gp_no->CurrentValue . '" data-original-title ="Print GST Challan"><i data-phrase="Print"  class="fa fa-print ew-icon" ></i></a>';
			if($this->receiving_condition->CurrentValue==2)
			{
			$this->ListOptions->Items["edit"]->Visible=False;
			}
			else
			{
			$this->ListOptions->Items["edit"]->Visible=True;
			}		
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>