<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class gate_pass_received_search extends gate_pass_received
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'gate_pass_received';

	// Page object name
	public $PageObjName = "gate_pass_received_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (gate_pass_received)
		if (!isset($GLOBALS["gate_pass_received"]) || get_class($GLOBALS["gate_pass_received"]) == PROJECT_NAMESPACE . "gate_pass_received") {
			$GLOBALS["gate_pass_received"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["gate_pass_received"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'gate_pass_received');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $gate_pass_received;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($gate_pass_received);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "gate_pass_receivedview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['gp_no'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->gp_no->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("gate_pass_receivedlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
				if (strval($Security->currentUserID()) == "") {
					$this->setFailureMessage(DeniedMessage()); // Set no permission
					$this->terminate(GetUrl("gate_pass_receivedlist.php"));
					return;
				}
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->gp_no->setVisibility();
		$this->_print->Visible = FALSE;
		$this->from->setVisibility();
		$this->to->setVisibility();
		$this->attention->setVisibility();
		$this->transfer_nature->setVisibility();
		$this->due_date->setVisibility();
		$this->group->setVisibility();
		$this->product->setVisibility();
		$this->count_received->setVisibility();
		$this->item->setVisibility();
		$this->gt_id->setVisibility();
		$this->quantity->Visible = FALSE;
		$this->despatch_details->setVisibility();
		$this->sender_comments->setVisibility();
		$this->t_mode->setVisibility();
		$this->t_distance->setVisibility();
		$this->t_v_no->setVisibility();
		$this->purpose->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->e_operator->setVisibility();
		$this->e_datetime->setVisibility();
		$this->receiving_condition->setVisibility();
		$this->receiver_comments->setVisibility();
		$this->r_operator->setVisibility();
		$this->r_datetime->setVisibility();
		$this->updated->setVisibility();
		$this->r_e_user_id->setVisibility();
		$this->r_e_datetime->setVisibility();
		$this->jc_no->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->from);
		$this->setupLookupOptions($this->to);
		$this->setupLookupOptions($this->attention);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->r_operator);
		$this->setupLookupOptions($this->jc_no);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "gate_pass_receivedlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->gp_no); // gp_no
		$this->buildSearchUrl($srchUrl, $this->from); // from
		$this->buildSearchUrl($srchUrl, $this->to); // to
		$this->buildSearchUrl($srchUrl, $this->attention); // attention
		$this->buildSearchUrl($srchUrl, $this->transfer_nature); // transfer_nature
		$this->buildSearchUrl($srchUrl, $this->due_date); // due_date
		$this->buildSearchUrl($srchUrl, $this->group); // group
		$this->buildSearchUrl($srchUrl, $this->product); // product
		$this->buildSearchUrl($srchUrl, $this->count_received); // count_received
		$this->buildSearchUrl($srchUrl, $this->item); // item
		$this->buildSearchUrl($srchUrl, $this->gt_id); // gt_id
		$this->buildSearchUrl($srchUrl, $this->despatch_details); // despatch details
		$this->buildSearchUrl($srchUrl, $this->sender_comments); // sender_comments
		$this->buildSearchUrl($srchUrl, $this->t_mode); // t_mode
		$this->buildSearchUrl($srchUrl, $this->t_distance); // t_distance
		$this->buildSearchUrl($srchUrl, $this->t_v_no); // t_v_no
		$this->buildSearchUrl($srchUrl, $this->purpose); // purpose
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->e_operator); // e_operator
		$this->buildSearchUrl($srchUrl, $this->e_datetime); // e_datetime
		$this->buildSearchUrl($srchUrl, $this->receiving_condition); // receiving_condition
		$this->buildSearchUrl($srchUrl, $this->receiver_comments); // receiver_comments
		$this->buildSearchUrl($srchUrl, $this->r_operator); // r_operator
		$this->buildSearchUrl($srchUrl, $this->r_datetime); // r_datetime
		$this->buildSearchUrl($srchUrl, $this->updated); // updated
		$this->buildSearchUrl($srchUrl, $this->r_e_user_id); // r_e_user_id
		$this->buildSearchUrl($srchUrl, $this->r_e_datetime); // r_e_datetime
		$this->buildSearchUrl($srchUrl, $this->jc_no); // jc_no
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// gp_no

		if (!$this->isAddOrEdit())
			$this->gp_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gp_no"));
		$this->gp_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gp_no"));

		// from
		if (!$this->isAddOrEdit())
			$this->from->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_from"));
		$this->from->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_from"));

		// to
		if (!$this->isAddOrEdit())
			$this->to->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_to"));
		$this->to->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_to"));

		// attention
		if (!$this->isAddOrEdit())
			$this->attention->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_attention"));
		$this->attention->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_attention"));

		// transfer_nature
		if (!$this->isAddOrEdit())
			$this->transfer_nature->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_transfer_nature"));
		$this->transfer_nature->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_transfer_nature"));

		// due_date
		if (!$this->isAddOrEdit())
			$this->due_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_due_date"));
		$this->due_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_due_date"));

		// group
		if (!$this->isAddOrEdit())
			$this->group->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_group"));
		$this->group->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_group"));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product"));
		$this->product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product"));

		// count_received
		if (!$this->isAddOrEdit())
			$this->count_received->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_count_received"));
		$this->count_received->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_count_received"));

		// item
		if (!$this->isAddOrEdit())
			$this->item->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_item"));
		$this->item->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_item"));

		// gt_id
		if (!$this->isAddOrEdit())
			$this->gt_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gt_id"));
		$this->gt_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gt_id"));

		// despatch details
		if (!$this->isAddOrEdit())
			$this->despatch_details->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_despatch_details"));
		$this->despatch_details->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_despatch_details"));

		// sender_comments
		if (!$this->isAddOrEdit())
			$this->sender_comments->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sender_comments"));
		$this->sender_comments->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sender_comments"));

		// t_mode
		if (!$this->isAddOrEdit())
			$this->t_mode->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_mode"));
		$this->t_mode->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_mode"));

		// t_distance
		if (!$this->isAddOrEdit())
			$this->t_distance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_distance"));
		$this->t_distance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_distance"));

		// t_v_no
		if (!$this->isAddOrEdit())
			$this->t_v_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_v_no"));
		$this->t_v_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_v_no"));

		// purpose
		if (!$this->isAddOrEdit())
			$this->purpose->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_purpose"));
		$this->purpose->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_purpose"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// e_operator
		if (!$this->isAddOrEdit())
			$this->e_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_e_operator"));
		$this->e_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_e_operator"));

		// e_datetime
		if (!$this->isAddOrEdit())
			$this->e_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_e_datetime"));
		$this->e_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_e_datetime"));

		// receiving_condition
		if (!$this->isAddOrEdit())
			$this->receiving_condition->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_receiving_condition"));
		$this->receiving_condition->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_receiving_condition"));

		// receiver_comments
		if (!$this->isAddOrEdit())
			$this->receiver_comments->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_receiver_comments"));
		$this->receiver_comments->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_receiver_comments"));

		// r_operator
		if (!$this->isAddOrEdit())
			$this->r_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_r_operator"));
		$this->r_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_r_operator"));

		// r_datetime
		if (!$this->isAddOrEdit())
			$this->r_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_r_datetime"));
		$this->r_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_r_datetime"));

		// updated
		if (!$this->isAddOrEdit())
			$this->updated->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_updated"));
		$this->updated->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_updated"));

		// r_e_user_id
		if (!$this->isAddOrEdit())
			$this->r_e_user_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_r_e_user_id"));
		$this->r_e_user_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_r_e_user_id"));

		// r_e_datetime
		if (!$this->isAddOrEdit())
			$this->r_e_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_r_e_datetime"));
		$this->r_e_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_r_e_datetime"));

		// jc_no
		if (!$this->isAddOrEdit())
			$this->jc_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_jc_no"));
		$this->jc_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_jc_no"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// gp_no
		// print
		// from
		// to
		// attention
		// transfer_nature
		// due_date
		// group
		// product
		// count_received
		// item
		// gt_id
		// quantity
		// despatch details
		// sender_comments
		// t_mode
		// t_distance
		// t_v_no
		// purpose
		// operator
		// datetime
		// e_operator
		// e_datetime
		// receiving_condition
		// receiver_comments
		// r_operator
		// r_datetime
		// updated
		// r_e_user_id
		// r_e_datetime
		// jc_no

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// gp_no
			$this->gp_no->ViewValue = $this->gp_no->CurrentValue;
			$this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, 0, -2, -2, -2);
			$this->gp_no->ViewCustomAttributes = "";

			// from
			$this->from->ViewValue = $this->from->CurrentValue;
			$curVal = strval($this->from->CurrentValue);
			if ($curVal <> "") {
				$this->from->ViewValue = $this->from->lookupCacheOption($curVal);
				if ($this->from->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->from->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->from->ViewValue = $this->from->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->from->ViewValue = $this->from->CurrentValue;
					}
				}
			} else {
				$this->from->ViewValue = NULL;
			}
			$this->from->ViewCustomAttributes = "";

			// to
			$curVal = strval($this->to->CurrentValue);
			if ($curVal <> "") {
				$this->to->ViewValue = $this->to->lookupCacheOption($curVal);
				if ($this->to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET(`partner_type`, '1,0') and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->to->ViewValue = $this->to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->to->ViewValue = $this->to->CurrentValue;
					}
				}
			} else {
				$this->to->ViewValue = NULL;
			}
			$this->to->ViewCustomAttributes = "";

			// attention
			$curVal = strval($this->attention->CurrentValue);
			if ($curVal <> "") {
				$this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
				if ($this->attention->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->attention->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->attention->ViewValue = $this->attention->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->attention->ViewValue = $this->attention->CurrentValue;
					}
				}
			} else {
				$this->attention->ViewValue = NULL;
			}
			$this->attention->ViewCustomAttributes = "";

			// transfer_nature
			if (strval($this->transfer_nature->CurrentValue) <> "") {
				$this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
			} else {
				$this->transfer_nature->ViewValue = NULL;
			}
			$this->transfer_nature->ViewCustomAttributes = "";

			// due_date
			$this->due_date->ViewValue = $this->due_date->CurrentValue;
			$this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, 0);
			$this->due_date->ViewCustomAttributes = "";

			// group
			if (strval($this->group->CurrentValue) <> "") {
				$this->group->ViewValue = $this->group->optionCaption($this->group->CurrentValue);
			} else {
				$this->group->ViewValue = NULL;
			}
			$this->group->ViewCustomAttributes = "";

			// product
			$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
			$this->product->ViewCustomAttributes = "";

			// count_received
			$this->count_received->ViewValue = $this->count_received->CurrentValue;
			$this->count_received->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// gt_id
			$this->gt_id->ViewValue = $this->gt_id->CurrentValue;
			$this->gt_id->ViewCustomAttributes = "";

			// despatch details
			$this->despatch_details->ViewValue = $this->despatch_details->CurrentValue;
			$this->despatch_details->ViewCustomAttributes = "";

			// sender_comments
			$this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;
			$this->sender_comments->ViewCustomAttributes = "";

			// t_mode
			if (strval($this->t_mode->CurrentValue) <> "") {
				$this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
			} else {
				$this->t_mode->ViewValue = NULL;
			}
			$this->t_mode->ViewCustomAttributes = "";

			// t_distance
			$this->t_distance->ViewValue = $this->t_distance->CurrentValue;
			$this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, 0, -2, -2, -2);
			$this->t_distance->ViewCustomAttributes = "";

			// t_v_no
			$this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;
			$this->t_v_no->ViewCustomAttributes = "";

			// purpose
			$this->purpose->ViewValue = $this->purpose->CurrentValue;
			$this->purpose->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// e_operator
			$this->e_operator->ViewValue = $this->e_operator->CurrentValue;
			$this->e_operator->ViewValue = FormatNumber($this->e_operator->ViewValue, 0, -2, -2, -2);
			$this->e_operator->ViewCustomAttributes = "";

			// e_datetime
			$this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
			$this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, 0);
			$this->e_datetime->ViewCustomAttributes = "";

			// receiving_condition
			if (strval($this->receiving_condition->CurrentValue) <> "") {
				$this->receiving_condition->ViewValue = $this->receiving_condition->optionCaption($this->receiving_condition->CurrentValue);
			} else {
				$this->receiving_condition->ViewValue = NULL;
			}
			$this->receiving_condition->ViewCustomAttributes = "";

			// receiver_comments
			$this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;
			$this->receiver_comments->ViewCustomAttributes = "";

			// r_operator
			$curVal = strval($this->r_operator->CurrentValue);
			if ($curVal <> "") {
				$this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
				if ($this->r_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->r_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->r_operator->ViewValue = $this->r_operator->CurrentValue;
					}
				}
			} else {
				$this->r_operator->ViewValue = NULL;
			}
			$this->r_operator->ViewCustomAttributes = "";

			// r_datetime
			$this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
			$this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, 0);
			$this->r_datetime->ViewCustomAttributes = "";

			// updated
			$this->updated->ViewValue = $this->updated->CurrentValue;
			$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
			$this->updated->ViewCustomAttributes = "";

			// r_e_user_id
			$this->r_e_user_id->ViewValue = $this->r_e_user_id->CurrentValue;
			$this->r_e_user_id->ViewValue = FormatNumber($this->r_e_user_id->ViewValue, 0, -2, -2, -2);
			$this->r_e_user_id->ViewCustomAttributes = "";

			// r_e_datetime
			$this->r_e_datetime->ViewValue = $this->r_e_datetime->CurrentValue;
			$this->r_e_datetime->ViewValue = FormatDateTime($this->r_e_datetime->ViewValue, 0);
			$this->r_e_datetime->ViewCustomAttributes = "";

			// jc_no
			$curVal = strval($this->jc_no->CurrentValue);
			if ($curVal <> "") {
				$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
				if ($this->jc_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
					}
				}
			} else {
				$this->jc_no->ViewValue = NULL;
			}
			$this->jc_no->ViewCustomAttributes = "";

			// gp_no
			$this->gp_no->LinkCustomAttributes = "";
			$this->gp_no->HrefValue = "";
			$this->gp_no->TooltipValue = "";

			// from
			$this->from->LinkCustomAttributes = "";
			if (!EmptyValue($this->from->CurrentValue)) {
				$this->from->HrefValue = "gate_pass_receivedlist.php?x_from=" . $this->from->CurrentValue; // Add prefix/suffix
				$this->from->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->from->HrefValue = FullUrl($this->from->HrefValue, "href");
			} else {
				$this->from->HrefValue = "";
			}
			$this->from->TooltipValue = "";

			// to
			$this->to->LinkCustomAttributes = "";
			if (!EmptyValue($this->to->CurrentValue)) {
				$this->to->HrefValue = "gate_pass_receivedlist.php?x_to=" . $this->to->CurrentValue; // Add prefix/suffix
				$this->to->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->to->HrefValue = FullUrl($this->to->HrefValue, "href");
			} else {
				$this->to->HrefValue = "";
			}
			$this->to->TooltipValue = "";

			// attention
			$this->attention->LinkCustomAttributes = "";
			if (!EmptyValue($this->attention->CurrentValue)) {
				$this->attention->HrefValue = "gate_pass_receivedlist.php?x_attention=" . $this->attention->CurrentValue; // Add prefix/suffix
				$this->attention->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->attention->HrefValue = FullUrl($this->attention->HrefValue, "href");
			} else {
				$this->attention->HrefValue = "";
			}
			$this->attention->TooltipValue = "";

			// transfer_nature
			$this->transfer_nature->LinkCustomAttributes = "";
			if (!EmptyValue($this->transfer_nature->CurrentValue)) {
				$this->transfer_nature->HrefValue = "gate_pass_receivedlist.php?x_transfer_nature=" . $this->transfer_nature->CurrentValue; // Add prefix/suffix
				$this->transfer_nature->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->transfer_nature->HrefValue = FullUrl($this->transfer_nature->HrefValue, "href");
			} else {
				$this->transfer_nature->HrefValue = "";
			}
			$this->transfer_nature->TooltipValue = "";

			// due_date
			$this->due_date->LinkCustomAttributes = "";
			if (!EmptyValue($this->due_date->CurrentValue)) {
				$this->due_date->HrefValue = "gate_pass_receivedlist.php?x_due_date=" . $this->due_date->CurrentValue; // Add prefix/suffix
				$this->due_date->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->due_date->HrefValue = FullUrl($this->due_date->HrefValue, "href");
			} else {
				$this->due_date->HrefValue = "";
			}
			$this->due_date->TooltipValue = "";

			// group
			$this->group->LinkCustomAttributes = "";
			$this->group->HrefValue = "";
			$this->group->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "gate_pass_receivedlist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// count_received
			$this->count_received->LinkCustomAttributes = "";
			$this->count_received->HrefValue = "";
			$this->count_received->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "gate_pass_receivedlist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}
			$this->item->TooltipValue = "";

			// gt_id
			$this->gt_id->LinkCustomAttributes = "";
			$this->gt_id->HrefValue = "";
			$this->gt_id->TooltipValue = "";

			// despatch details
			$this->despatch_details->LinkCustomAttributes = "";
			$this->despatch_details->HrefValue = "";
			$this->despatch_details->TooltipValue = "";

			// sender_comments
			$this->sender_comments->LinkCustomAttributes = "";
			$this->sender_comments->HrefValue = "";
			$this->sender_comments->TooltipValue = "";

			// t_mode
			$this->t_mode->LinkCustomAttributes = "";
			if (!EmptyValue($this->t_mode->CurrentValue)) {
				$this->t_mode->HrefValue = "gate_pass_receivedlist.php?x_t_mode=" . $this->t_mode->CurrentValue; // Add prefix/suffix
				$this->t_mode->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->t_mode->HrefValue = FullUrl($this->t_mode->HrefValue, "href");
			} else {
				$this->t_mode->HrefValue = "";
			}
			$this->t_mode->TooltipValue = "";

			// t_distance
			$this->t_distance->LinkCustomAttributes = "";
			$this->t_distance->HrefValue = "";
			$this->t_distance->TooltipValue = "";

			// t_v_no
			$this->t_v_no->LinkCustomAttributes = "";
			$this->t_v_no->HrefValue = "";
			$this->t_v_no->TooltipValue = "";

			// purpose
			$this->purpose->LinkCustomAttributes = "";
			$this->purpose->HrefValue = "";
			$this->purpose->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			if (!EmptyValue($this->operator->CurrentValue)) {
				$this->operator->HrefValue = "gate_pass_receivedlist.php?x_operator=" . $this->operator->CurrentValue; // Add prefix/suffix
				$this->operator->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
			} else {
				$this->operator->HrefValue = "";
			}
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// e_operator
			$this->e_operator->LinkCustomAttributes = "";
			$this->e_operator->HrefValue = "";
			$this->e_operator->TooltipValue = "";

			// e_datetime
			$this->e_datetime->LinkCustomAttributes = "";
			$this->e_datetime->HrefValue = "";
			$this->e_datetime->TooltipValue = "";

			// receiving_condition
			$this->receiving_condition->LinkCustomAttributes = "";
			$this->receiving_condition->HrefValue = "";
			$this->receiving_condition->TooltipValue = "";

			// receiver_comments
			$this->receiver_comments->LinkCustomAttributes = "";
			$this->receiver_comments->HrefValue = "";
			$this->receiver_comments->TooltipValue = "";

			// r_operator
			$this->r_operator->LinkCustomAttributes = "";
			$this->r_operator->HrefValue = "";
			$this->r_operator->TooltipValue = "";

			// r_datetime
			$this->r_datetime->LinkCustomAttributes = "";
			$this->r_datetime->HrefValue = "";
			$this->r_datetime->TooltipValue = "";

			// updated
			$this->updated->LinkCustomAttributes = "";
			$this->updated->HrefValue = "";
			$this->updated->TooltipValue = "";

			// r_e_user_id
			$this->r_e_user_id->LinkCustomAttributes = "";
			$this->r_e_user_id->HrefValue = "";
			$this->r_e_user_id->TooltipValue = "";

			// r_e_datetime
			$this->r_e_datetime->LinkCustomAttributes = "";
			$this->r_e_datetime->HrefValue = "";
			$this->r_e_datetime->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			$this->jc_no->HrefValue = "";
			$this->jc_no->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// gp_no
			$this->gp_no->EditAttrs["class"] = "form-control";
			$this->gp_no->EditCustomAttributes = "";
			$this->gp_no->EditValue = HtmlEncode($this->gp_no->AdvancedSearch->SearchValue);
			$this->gp_no->PlaceHolder = RemoveHtml($this->gp_no->caption());

			// from
			$this->from->EditAttrs["class"] = "form-control";
			$this->from->EditCustomAttributes = "";
			$this->from->EditValue = HtmlEncode($this->from->AdvancedSearch->SearchValue);
			$curVal = strval($this->from->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->from->EditValue = $this->from->lookupCacheOption($curVal);
				if ($this->from->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->from->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->from->EditValue = $this->from->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->from->EditValue = HtmlEncode($this->from->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->from->EditValue = NULL;
			}
			$this->from->PlaceHolder = RemoveHtml($this->from->caption());

			// to
			$this->to->EditAttrs["class"] = "form-control";
			$this->to->EditCustomAttributes = "";
			$curVal = trim(strval($this->to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->to->AdvancedSearch->ViewValue = $this->to->lookupCacheOption($curVal);
			else
				$this->to->AdvancedSearch->ViewValue = $this->to->Lookup !== NULL && is_array($this->to->Lookup->Options) ? $curVal : NULL;
			if ($this->to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->to->EditValue = array_values($this->to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "FIND_IN_SET(`partner_type`, '1,0') and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->to->EditValue = $arwrk;
			}

			// attention
			$this->attention->EditAttrs["class"] = "form-control";
			$this->attention->EditCustomAttributes = "";
			if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("search")) { // Non system admin
			if (trim(strval($this->attention->AdvancedSearch->SearchValue)) == "") {
				$filterWrk = "0=1";
			} else {
				$filterWrk = "`id`" . SearchString("=", $this->attention->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
			}
			$sqlWrk = $this->attention->Lookup->getSql(TRUE, $filterWrk, '', $this);
			$rswrk = Conn()->execute($sqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->attention->EditValue = $arwrk;
			} else {
			$curVal = trim(strval($this->attention->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->attention->AdvancedSearch->ViewValue = $this->attention->lookupCacheOption($curVal);
			else
				$this->attention->AdvancedSearch->ViewValue = $this->attention->Lookup !== NULL && is_array($this->attention->Lookup->Options) ? $curVal : NULL;
			if ($this->attention->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->attention->EditValue = array_values($this->attention->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->attention->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->attention->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->attention->EditValue = $arwrk;
			}
			}

			// transfer_nature
			$this->transfer_nature->EditAttrs["class"] = "form-control";
			$this->transfer_nature->EditCustomAttributes = "";
			$this->transfer_nature->EditValue = $this->transfer_nature->options(TRUE);

			// due_date
			$this->due_date->EditAttrs["class"] = "form-control";
			$this->due_date->EditCustomAttributes = "";
			$this->due_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->due_date->AdvancedSearch->SearchValue, 0), 8));
			$this->due_date->PlaceHolder = RemoveHtml($this->due_date->caption());

			// group
			$this->group->EditAttrs["class"] = "form-control";
			$this->group->EditCustomAttributes = "";
			$this->group->EditValue = $this->group->options(TRUE);

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";

			// count_received
			$this->count_received->EditAttrs["class"] = "form-control";
			$this->count_received->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->count_received->AdvancedSearch->SearchValue = HtmlDecode($this->count_received->AdvancedSearch->SearchValue);
			$this->count_received->EditValue = HtmlEncode($this->count_received->AdvancedSearch->SearchValue);
			$this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
			$this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// gt_id
			$this->gt_id->EditAttrs["class"] = "form-control";
			$this->gt_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gt_id->AdvancedSearch->SearchValue = HtmlDecode($this->gt_id->AdvancedSearch->SearchValue);
			$this->gt_id->EditValue = HtmlEncode($this->gt_id->AdvancedSearch->SearchValue);
			$this->gt_id->PlaceHolder = RemoveHtml($this->gt_id->caption());

			// despatch details
			$this->despatch_details->EditAttrs["class"] = "form-control";
			$this->despatch_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->despatch_details->AdvancedSearch->SearchValue = HtmlDecode($this->despatch_details->AdvancedSearch->SearchValue);
			$this->despatch_details->EditValue = HtmlEncode($this->despatch_details->AdvancedSearch->SearchValue);
			$this->despatch_details->PlaceHolder = RemoveHtml($this->despatch_details->caption());

			// sender_comments
			$this->sender_comments->EditAttrs["class"] = "form-control";
			$this->sender_comments->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->sender_comments->AdvancedSearch->SearchValue = HtmlDecode($this->sender_comments->AdvancedSearch->SearchValue);
			$this->sender_comments->EditValue = HtmlEncode($this->sender_comments->AdvancedSearch->SearchValue);
			$this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

			// t_mode
			$this->t_mode->EditAttrs["class"] = "form-control";
			$this->t_mode->EditCustomAttributes = "";
			$this->t_mode->EditValue = $this->t_mode->options(TRUE);

			// t_distance
			$this->t_distance->EditAttrs["class"] = "form-control";
			$this->t_distance->EditCustomAttributes = "";
			$this->t_distance->EditValue = HtmlEncode($this->t_distance->AdvancedSearch->SearchValue);
			$this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());

			// t_v_no
			$this->t_v_no->EditAttrs["class"] = "form-control";
			$this->t_v_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_v_no->AdvancedSearch->SearchValue = HtmlDecode($this->t_v_no->AdvancedSearch->SearchValue);
			$this->t_v_no->EditValue = HtmlEncode($this->t_v_no->AdvancedSearch->SearchValue);
			$this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

			// purpose
			$this->purpose->EditAttrs["class"] = "form-control";
			$this->purpose->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->purpose->AdvancedSearch->SearchValue = HtmlDecode($this->purpose->AdvancedSearch->SearchValue);
			$this->purpose->EditValue = HtmlEncode($this->purpose->AdvancedSearch->SearchValue);
			$this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// e_operator
			$this->e_operator->EditAttrs["class"] = "form-control";
			$this->e_operator->EditCustomAttributes = "";
			$this->e_operator->EditValue = HtmlEncode($this->e_operator->AdvancedSearch->SearchValue);
			$this->e_operator->PlaceHolder = RemoveHtml($this->e_operator->caption());

			// e_datetime
			$this->e_datetime->EditAttrs["class"] = "form-control";
			$this->e_datetime->EditCustomAttributes = "";
			$this->e_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->e_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());

			// receiving_condition
			$this->receiving_condition->EditAttrs["class"] = "form-control";
			$this->receiving_condition->EditCustomAttributes = "";
			$this->receiving_condition->EditValue = $this->receiving_condition->options(TRUE);

			// receiver_comments
			$this->receiver_comments->EditAttrs["class"] = "form-control";
			$this->receiver_comments->EditCustomAttributes = "";
			$this->receiver_comments->EditValue = HtmlEncode($this->receiver_comments->AdvancedSearch->SearchValue);
			$this->receiver_comments->PlaceHolder = RemoveHtml($this->receiver_comments->caption());

			// r_operator
			$this->r_operator->EditAttrs["class"] = "form-control";
			$this->r_operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->r_operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->r_operator->AdvancedSearch->ViewValue = $this->r_operator->lookupCacheOption($curVal);
			else
				$this->r_operator->AdvancedSearch->ViewValue = $this->r_operator->Lookup !== NULL && is_array($this->r_operator->Lookup->Options) ? $curVal : NULL;
			if ($this->r_operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->r_operator->EditValue = array_values($this->r_operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->r_operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->r_operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->r_operator->EditValue = $arwrk;
			}

			// r_datetime
			$this->r_datetime->EditAttrs["class"] = "form-control";
			$this->r_datetime->EditCustomAttributes = "";
			$this->r_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->r_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

			// updated
			$this->updated->EditAttrs["class"] = "form-control";
			$this->updated->EditCustomAttributes = "";
			$this->updated->EditValue = HtmlEncode($this->updated->AdvancedSearch->SearchValue);
			$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

			// r_e_user_id
			$this->r_e_user_id->EditAttrs["class"] = "form-control";
			$this->r_e_user_id->EditCustomAttributes = "";
			$this->r_e_user_id->EditValue = HtmlEncode($this->r_e_user_id->AdvancedSearch->SearchValue);
			$this->r_e_user_id->PlaceHolder = RemoveHtml($this->r_e_user_id->caption());

			// r_e_datetime
			$this->r_e_datetime->EditAttrs["class"] = "form-control";
			$this->r_e_datetime->EditCustomAttributes = "";
			$this->r_e_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->r_e_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->r_e_datetime->PlaceHolder = RemoveHtml($this->r_e_datetime->caption());

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->jc_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->jc_no->AdvancedSearch->ViewValue = $this->jc_no->lookupCacheOption($curVal);
			else
				$this->jc_no->AdvancedSearch->ViewValue = $this->jc_no->Lookup !== NULL && is_array($this->jc_no->Lookup->Options) ? $curVal : NULL;
			if ($this->jc_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->jc_no->EditValue = array_values($this->jc_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->jc_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->jc_no->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 0, -2, -2, -2);
				}
				$this->jc_no->EditValue = $arwrk;
			}
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->gp_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->gp_no->errorMessage());
		}
		if (!CheckInteger($this->from->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->from->errorMessage());
		}
		if (!CheckDate($this->due_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->due_date->errorMessage());
		}
		if (!CheckInteger($this->t_distance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->t_distance->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->e_operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->e_operator->errorMessage());
		}
		if (!CheckDate($this->e_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->e_datetime->errorMessage());
		}
		if (!CheckDate($this->r_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->r_datetime->errorMessage());
		}
		if (!CheckInteger($this->updated->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->updated->errorMessage());
		}
		if (!CheckInteger($this->r_e_user_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->r_e_user_id->errorMessage());
		}
		if (!CheckDate($this->r_e_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->r_e_datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->gp_no->AdvancedSearch->load();
		$this->from->AdvancedSearch->load();
		$this->to->AdvancedSearch->load();
		$this->attention->AdvancedSearch->load();
		$this->transfer_nature->AdvancedSearch->load();
		$this->due_date->AdvancedSearch->load();
		$this->group->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->count_received->AdvancedSearch->load();
		$this->item->AdvancedSearch->load();
		$this->gt_id->AdvancedSearch->load();
		$this->despatch_details->AdvancedSearch->load();
		$this->sender_comments->AdvancedSearch->load();
		$this->t_mode->AdvancedSearch->load();
		$this->t_distance->AdvancedSearch->load();
		$this->t_v_no->AdvancedSearch->load();
		$this->purpose->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->e_operator->AdvancedSearch->load();
		$this->e_datetime->AdvancedSearch->load();
		$this->receiving_condition->AdvancedSearch->load();
		$this->receiver_comments->AdvancedSearch->load();
		$this->r_operator->AdvancedSearch->load();
		$this->r_datetime->AdvancedSearch->load();
		$this->updated->AdvancedSearch->load();
		$this->r_e_user_id->AdvancedSearch->load();
		$this->r_e_datetime->AdvancedSearch->load();
		$this->jc_no->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("gate_pass_receivedlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_to":
					$lookupFilter = function() {
						return "FIND_IN_SET(`partner_type`, '1,0') and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_from":
							break;
						case "x_to":
							break;
						case "x_attention":
							break;
						case "x_operator":
							break;
						case "x_r_operator":
							break;
						case "x_jc_no":
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>