<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for godown_transfer_new
 */
class godown_transfer_new extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $gp_no;
	public $from;
	public $to;
	public $attention;
	public $transfer_nature;
	public $due_date;
	public $group;
	public $item;
	public $quantity;
	public $despatch_details;
	public $sender_comments;
	public $t_mode;
	public $t_distance;
	public $t_v_no;
	public $purpose;
	public $user_id;
	public $datetime;
	public $e_user_id;
	public $e_datetime;
	public $receiving_condition;
	public $receiver_comments;
	public $r_user_id;
	public $r_datetime;
	public $updated;
	public $r_e_user_id;
	public $r_e_datetime;
	public $_print;
	public $jc_no;
	public $product;
	public $count_received;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'godown_transfer_new';
		$this->TableName = 'godown_transfer_new';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`godown_transfer_new`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// gp_no
		$this->gp_no = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_gp_no', 'gp_no', '`gp_no`', '`gp_no`', 18, -1, FALSE, '`gp_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gp_no->Nullable = FALSE; // NOT NULL field
		$this->gp_no->Required = TRUE; // Required field
		$this->gp_no->Sortable = TRUE; // Allow sort
		$this->gp_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gp_no'] = &$this->gp_no;

		// from
		$this->from = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_from', 'from', '`from`', '`from`', 18, -1, FALSE, '`from`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->from->Nullable = FALSE; // NOT NULL field
		$this->from->Required = TRUE; // Required field
		$this->from->Sortable = TRUE; // Allow sort
		$this->from->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->from->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->from->Lookup = new Lookup('from', 'godown_table', FALSE, 'id', ["name","code","location",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->from->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['from'] = &$this->from;

		// to
		$this->to = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_to', 'to', '`to`', '`to`', 18, -1, FALSE, '`to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->to->Nullable = FALSE; // NOT NULL field
		$this->to->Required = TRUE; // Required field
		$this->to->Sortable = TRUE; // Allow sort
		$this->to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->to->Lookup = new Lookup('to', 'godown_table', FALSE, 'id', ["name","code","location",""], [], [], [], [], ["incharge"], ["x_attention"], '`id` ASC', '');
		$this->to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['to'] = &$this->to;

		// attention
		$this->attention = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_attention', 'attention', '`attention`', '`attention`', 18, -1, FALSE, '`attention`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->attention->Nullable = FALSE; // NOT NULL field
		$this->attention->Required = TRUE; // Required field
		$this->attention->Sortable = TRUE; // Allow sort
		$this->attention->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->attention->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->attention->Lookup = new Lookup('attention', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->attention->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['attention'] = &$this->attention;

		// transfer_nature
		$this->transfer_nature = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_transfer_nature', 'transfer_nature', '`transfer_nature`', '`transfer_nature`', 18, -1, FALSE, '`transfer_nature`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->transfer_nature->Nullable = FALSE; // NOT NULL field
		$this->transfer_nature->Required = TRUE; // Required field
		$this->transfer_nature->Sortable = TRUE; // Allow sort
		$this->transfer_nature->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->transfer_nature->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->transfer_nature->Lookup = new Lookup('transfer_nature', 'godown_transfer_new', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->transfer_nature->OptionCount = 3;
		$this->transfer_nature->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['transfer_nature'] = &$this->transfer_nature;

		// due_date
		$this->due_date = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_due_date', 'due_date', '`due_date`', CastDateFieldForLike('`due_date`', 0, "DB"), 133, 0, FALSE, '`due_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->due_date->Sortable = TRUE; // Allow sort
		$this->due_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['due_date'] = &$this->due_date;

		// group
		$this->group = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_group', 'group', '`group`', '`group`', 18, -1, FALSE, '`group`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->group->Nullable = FALSE; // NOT NULL field
		$this->group->Required = TRUE; // Required field
		$this->group->Sortable = TRUE; // Allow sort
		$this->group->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->group->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->group->Lookup = new Lookup('group', 'godown_transfer_new', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->group->OptionCount = 2;
		$this->group->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['group'] = &$this->group;

		// item
		$this->item = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_item', 'item', '`item`', '`item`', 201, -1, FALSE, '`item`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->item->Nullable = FALSE; // NOT NULL field
		$this->item->Required = TRUE; // Required field
		$this->item->Sortable = TRUE; // Allow sort
		$this->item->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->item->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->fields['item'] = &$this->item;

		// quantity
		$this->quantity = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 131, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['quantity'] = &$this->quantity;

		// despatch details
		$this->despatch_details = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_despatch_details', 'despatch details', '`despatch details`', '`despatch details`', 200, -1, FALSE, '`despatch details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->despatch_details->Nullable = FALSE; // NOT NULL field
		$this->despatch_details->Required = TRUE; // Required field
		$this->despatch_details->Sortable = TRUE; // Allow sort
		$this->fields['despatch details'] = &$this->despatch_details;

		// sender_comments
		$this->sender_comments = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_sender_comments', 'sender_comments', '`sender_comments`', '`sender_comments`', 200, -1, FALSE, '`sender_comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sender_comments->Nullable = FALSE; // NOT NULL field
		$this->sender_comments->Required = TRUE; // Required field
		$this->sender_comments->Sortable = TRUE; // Allow sort
		$this->fields['sender_comments'] = &$this->sender_comments;

		// t_mode
		$this->t_mode = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_t_mode', 't_mode', '`t_mode`', '`t_mode`', 17, -1, FALSE, '`t_mode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->t_mode->Sortable = TRUE; // Allow sort
		$this->t_mode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->t_mode->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->t_mode->Lookup = new Lookup('t_mode', 'godown_transfer_new', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->t_mode->OptionCount = 2;
		$this->t_mode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['t_mode'] = &$this->t_mode;

		// t_distance
		$this->t_distance = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_t_distance', 't_distance', '`t_distance`', '`t_distance`', 18, -1, FALSE, '`t_distance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_distance->Sortable = TRUE; // Allow sort
		$this->t_distance->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['t_distance'] = &$this->t_distance;

		// t_v_no
		$this->t_v_no = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_t_v_no', 't_v_no', '`t_v_no`', '`t_v_no`', 200, -1, FALSE, '`t_v_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->t_v_no->Sortable = TRUE; // Allow sort
		$this->fields['t_v_no'] = &$this->t_v_no;

		// purpose
		$this->purpose = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_purpose', 'purpose', '`purpose`', '`purpose`', 200, -1, FALSE, '`purpose`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->purpose->Sortable = TRUE; // Allow sort
		$this->purpose->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->purpose->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->purpose->Lookup = new Lookup('purpose', 'godown_transfer_new', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->purpose->OptionCount = 1;
		$this->fields['purpose'] = &$this->purpose;

		// user_id
		$this->user_id = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_user_id', 'user_id', '`user_id`', '`user_id`', 18, -1, FALSE, '`user_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->user_id->Nullable = FALSE; // NOT NULL field
		$this->user_id->Sortable = TRUE; // Allow sort
		$this->user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['user_id'] = &$this->user_id;

		// datetime
		$this->datetime = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// e_user_id
		$this->e_user_id = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_e_user_id', 'e_user_id', '`e_user_id`', '`e_user_id`', 18, -1, FALSE, '`e_user_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->e_user_id->Nullable = FALSE; // NOT NULL field
		$this->e_user_id->Required = TRUE; // Required field
		$this->e_user_id->Sortable = TRUE; // Allow sort
		$this->e_user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['e_user_id'] = &$this->e_user_id;

		// e_datetime
		$this->e_datetime = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_e_datetime', 'e_datetime', '`e_datetime`', CastDateFieldForLike('`e_datetime`', 0, "DB"), 135, 0, FALSE, '`e_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->e_datetime->Nullable = FALSE; // NOT NULL field
		$this->e_datetime->Required = TRUE; // Required field
		$this->e_datetime->Sortable = TRUE; // Allow sort
		$this->e_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['e_datetime'] = &$this->e_datetime;

		// receiving_condition
		$this->receiving_condition = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_receiving_condition', 'receiving_condition', '`receiving_condition`', '`receiving_condition`', 18, -1, FALSE, '`receiving_condition`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->receiving_condition->Nullable = FALSE; // NOT NULL field
		$this->receiving_condition->Required = TRUE; // Required field
		$this->receiving_condition->Sortable = TRUE; // Allow sort
		$this->receiving_condition->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['receiving_condition'] = &$this->receiving_condition;

		// receiver_comments
		$this->receiver_comments = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_receiver_comments', 'receiver_comments', '`receiver_comments`', '`receiver_comments`', 18, -1, FALSE, '`receiver_comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->receiver_comments->Nullable = FALSE; // NOT NULL field
		$this->receiver_comments->Required = TRUE; // Required field
		$this->receiver_comments->Sortable = TRUE; // Allow sort
		$this->receiver_comments->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['receiver_comments'] = &$this->receiver_comments;

		// r_user_id
		$this->r_user_id = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_r_user_id', 'r_user_id', '`r_user_id`', '`r_user_id`', 18, -1, FALSE, '`r_user_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_user_id->Nullable = FALSE; // NOT NULL field
		$this->r_user_id->Required = TRUE; // Required field
		$this->r_user_id->Sortable = TRUE; // Allow sort
		$this->r_user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['r_user_id'] = &$this->r_user_id;

		// r_datetime
		$this->r_datetime = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_r_datetime', 'r_datetime', '`r_datetime`', CastDateFieldForLike('`r_datetime`', 0, "DB"), 135, 0, FALSE, '`r_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_datetime->Nullable = FALSE; // NOT NULL field
		$this->r_datetime->Required = TRUE; // Required field
		$this->r_datetime->Sortable = TRUE; // Allow sort
		$this->r_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['r_datetime'] = &$this->r_datetime;

		// updated
		$this->updated = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_updated', 'updated', '`updated`', '`updated`', 17, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Nullable = FALSE; // NOT NULL field
		$this->updated->Required = TRUE; // Required field
		$this->updated->Sortable = TRUE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;

		// r_e_user_id
		$this->r_e_user_id = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_r_e_user_id', 'r_e_user_id', '`r_e_user_id`', '`r_e_user_id`', 18, -1, FALSE, '`r_e_user_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_e_user_id->Nullable = FALSE; // NOT NULL field
		$this->r_e_user_id->Required = TRUE; // Required field
		$this->r_e_user_id->Sortable = TRUE; // Allow sort
		$this->r_e_user_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['r_e_user_id'] = &$this->r_e_user_id;

		// r_e_datetime
		$this->r_e_datetime = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_r_e_datetime', 'r_e_datetime', '`r_e_datetime`', CastDateFieldForLike('`r_e_datetime`', 0, "DB"), 135, 0, FALSE, '`r_e_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_e_datetime->Nullable = FALSE; // NOT NULL field
		$this->r_e_datetime->Required = TRUE; // Required field
		$this->r_e_datetime->Sortable = TRUE; // Allow sort
		$this->r_e_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['r_e_datetime'] = &$this->r_e_datetime;

		// print
		$this->_print = new DbField('godown_transfer_new', 'godown_transfer_new', 'x__print', 'print', '`print`', '`print`', 200, -1, FALSE, '`print`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_print->Nullable = FALSE; // NOT NULL field
		$this->_print->Required = TRUE; // Required field
		$this->_print->Sortable = FALSE; // Allow sort
		$this->fields['print'] = &$this->_print;

		// jc_no
		$this->jc_no = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 18, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// product
		$this->product = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// count_received
		$this->count_received = new DbField('godown_transfer_new', 'godown_transfer_new', 'x_count_received', 'count_received', '`count_received`', '`count_received`', 200, -1, FALSE, '`count_received`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->count_received->Nullable = FALSE; // NOT NULL field
		$this->count_received->Required = TRUE; // Required field
		$this->count_received->Sortable = TRUE; // Allow sort
		$this->fields['count_received'] = &$this->count_received;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`godown_transfer_new`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->gp_no->DbValue = $row['gp_no'];
		$this->from->DbValue = $row['from'];
		$this->to->DbValue = $row['to'];
		$this->attention->DbValue = $row['attention'];
		$this->transfer_nature->DbValue = $row['transfer_nature'];
		$this->due_date->DbValue = $row['due_date'];
		$this->group->DbValue = $row['group'];
		$this->item->DbValue = $row['item'];
		$this->quantity->DbValue = $row['quantity'];
		$this->despatch_details->DbValue = $row['despatch details'];
		$this->sender_comments->DbValue = $row['sender_comments'];
		$this->t_mode->DbValue = $row['t_mode'];
		$this->t_distance->DbValue = $row['t_distance'];
		$this->t_v_no->DbValue = $row['t_v_no'];
		$this->purpose->DbValue = $row['purpose'];
		$this->user_id->DbValue = $row['user_id'];
		$this->datetime->DbValue = $row['datetime'];
		$this->e_user_id->DbValue = $row['e_user_id'];
		$this->e_datetime->DbValue = $row['e_datetime'];
		$this->receiving_condition->DbValue = $row['receiving_condition'];
		$this->receiver_comments->DbValue = $row['receiver_comments'];
		$this->r_user_id->DbValue = $row['r_user_id'];
		$this->r_datetime->DbValue = $row['r_datetime'];
		$this->updated->DbValue = $row['updated'];
		$this->r_e_user_id->DbValue = $row['r_e_user_id'];
		$this->r_e_datetime->DbValue = $row['r_e_datetime'];
		$this->_print->DbValue = $row['print'];
		$this->jc_no->DbValue = $row['jc_no'];
		$this->product->DbValue = $row['product'];
		$this->count_received->DbValue = $row['count_received'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "godown_transfer_newlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "godown_transfer_newview.php")
			return $Language->phrase("View");
		elseif ($pageName == "godown_transfer_newedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "godown_transfer_newadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "godown_transfer_newlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("godown_transfer_newview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("godown_transfer_newview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "godown_transfer_newadd.php?" . $this->getUrlParm($parm);
		else
			$url = "godown_transfer_newadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("godown_transfer_newedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("godown_transfer_newadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("godown_transfer_newdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->gp_no->setDbValue($rs->fields('gp_no'));
		$this->from->setDbValue($rs->fields('from'));
		$this->to->setDbValue($rs->fields('to'));
		$this->attention->setDbValue($rs->fields('attention'));
		$this->transfer_nature->setDbValue($rs->fields('transfer_nature'));
		$this->due_date->setDbValue($rs->fields('due_date'));
		$this->group->setDbValue($rs->fields('group'));
		$this->item->setDbValue($rs->fields('item'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->despatch_details->setDbValue($rs->fields('despatch details'));
		$this->sender_comments->setDbValue($rs->fields('sender_comments'));
		$this->t_mode->setDbValue($rs->fields('t_mode'));
		$this->t_distance->setDbValue($rs->fields('t_distance'));
		$this->t_v_no->setDbValue($rs->fields('t_v_no'));
		$this->purpose->setDbValue($rs->fields('purpose'));
		$this->user_id->setDbValue($rs->fields('user_id'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->e_user_id->setDbValue($rs->fields('e_user_id'));
		$this->e_datetime->setDbValue($rs->fields('e_datetime'));
		$this->receiving_condition->setDbValue($rs->fields('receiving_condition'));
		$this->receiver_comments->setDbValue($rs->fields('receiver_comments'));
		$this->r_user_id->setDbValue($rs->fields('r_user_id'));
		$this->r_datetime->setDbValue($rs->fields('r_datetime'));
		$this->updated->setDbValue($rs->fields('updated'));
		$this->r_e_user_id->setDbValue($rs->fields('r_e_user_id'));
		$this->r_e_datetime->setDbValue($rs->fields('r_e_datetime'));
		$this->_print->setDbValue($rs->fields('print'));
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->product->setDbValue($rs->fields('product'));
		$this->count_received->setDbValue($rs->fields('count_received'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// gp_no
		// from
		// to
		// attention
		// transfer_nature
		// due_date
		// group
		// item
		// quantity
		// despatch details
		// sender_comments
		// t_mode
		// t_distance
		// t_v_no
		// purpose
		// user_id
		// datetime
		// e_user_id
		// e_datetime
		// receiving_condition
		// receiver_comments
		// r_user_id
		// r_datetime
		// updated
		// r_e_user_id
		// r_e_datetime
		// print

		$this->_print->CellCssStyle = "white-space: nowrap;";

		// jc_no
		// product
		// count_received
		// gp_no

		$this->gp_no->ViewValue = $this->gp_no->CurrentValue;
		$this->gp_no->ViewValue = FormatNumber($this->gp_no->ViewValue, 0, -2, -2, -2);
		$this->gp_no->ViewCustomAttributes = "";

		// from
		$curVal = strval($this->from->CurrentValue);
		if ($curVal <> "") {
			$this->from->ViewValue = $this->from->lookupCacheOption($curVal);
			if ($this->from->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (!empty(User_Site())) ? "`id` IN (".User_Site().")" : "id = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->from->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->from->ViewValue = $this->from->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->from->ViewValue = $this->from->CurrentValue;
				}
			}
		} else {
			$this->from->ViewValue = NULL;
		}
		$this->from->ViewCustomAttributes = "";

		// to
		$curVal = strval($this->to->CurrentValue);
		if ($curVal <> "") {
			$this->to->ViewValue = $this->to->lookupCacheOption($curVal);
			if ($this->to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->to->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->to->ViewValue = $this->to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->to->ViewValue = $this->to->CurrentValue;
				}
			}
		} else {
			$this->to->ViewValue = NULL;
		}
		$this->to->ViewCustomAttributes = "";

		// attention
		$curVal = strval($this->attention->CurrentValue);
		if ($curVal <> "") {
			$this->attention->ViewValue = $this->attention->lookupCacheOption($curVal);
			if ($this->attention->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->attention->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->attention->ViewValue = $this->attention->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->attention->ViewValue = $this->attention->CurrentValue;
				}
			}
		} else {
			$this->attention->ViewValue = NULL;
		}
		$this->attention->ViewCustomAttributes = "";

		// transfer_nature
		if (strval($this->transfer_nature->CurrentValue) <> "") {
			$this->transfer_nature->ViewValue = $this->transfer_nature->optionCaption($this->transfer_nature->CurrentValue);
		} else {
			$this->transfer_nature->ViewValue = NULL;
		}
		$this->transfer_nature->ViewCustomAttributes = "";

		// due_date
		$this->due_date->ViewValue = $this->due_date->CurrentValue;
		$this->due_date->ViewValue = FormatDateTime($this->due_date->ViewValue, 0);
		$this->due_date->ViewCustomAttributes = "";

		// group
		if (strval($this->group->CurrentValue) <> "") {
			$this->group->ViewValue = $this->group->optionCaption($this->group->CurrentValue);
		} else {
			$this->group->ViewValue = NULL;
		}
		$this->group->ViewCustomAttributes = "";

		// item
		$this->item->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 2, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// despatch details
		$this->despatch_details->ViewValue = $this->despatch_details->CurrentValue;
		$this->despatch_details->ViewCustomAttributes = "";

		// sender_comments
		$this->sender_comments->ViewValue = $this->sender_comments->CurrentValue;
		$this->sender_comments->ViewCustomAttributes = "";

		// t_mode
		if (strval($this->t_mode->CurrentValue) <> "") {
			$this->t_mode->ViewValue = $this->t_mode->optionCaption($this->t_mode->CurrentValue);
		} else {
			$this->t_mode->ViewValue = NULL;
		}
		$this->t_mode->ViewCustomAttributes = "";

		// t_distance
		$this->t_distance->ViewValue = $this->t_distance->CurrentValue;
		$this->t_distance->ViewValue = FormatNumber($this->t_distance->ViewValue, 0, -2, -2, -2);
		$this->t_distance->ViewCustomAttributes = "";

		// t_v_no
		$this->t_v_no->ViewValue = $this->t_v_no->CurrentValue;
		$this->t_v_no->ViewCustomAttributes = "";

		// purpose
		if (strval($this->purpose->CurrentValue) <> "") {
			$this->purpose->ViewValue = $this->purpose->optionCaption($this->purpose->CurrentValue);
		} else {
			$this->purpose->ViewValue = NULL;
		}
		$this->purpose->ViewCustomAttributes = "";

		// user_id
		$this->user_id->ViewValue = $this->user_id->CurrentValue;
		$this->user_id->ViewValue = FormatNumber($this->user_id->ViewValue, 0, -2, -2, -2);
		$this->user_id->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// e_user_id
		$this->e_user_id->ViewValue = $this->e_user_id->CurrentValue;
		$this->e_user_id->ViewValue = FormatNumber($this->e_user_id->ViewValue, 0, -2, -2, -2);
		$this->e_user_id->ViewCustomAttributes = "";

		// e_datetime
		$this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
		$this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, 0);
		$this->e_datetime->ViewCustomAttributes = "";

		// receiving_condition
		$this->receiving_condition->ViewValue = $this->receiving_condition->CurrentValue;
		$this->receiving_condition->ViewValue = FormatNumber($this->receiving_condition->ViewValue, 0, -2, -2, -2);
		$this->receiving_condition->ViewCustomAttributes = "";

		// receiver_comments
		$this->receiver_comments->ViewValue = $this->receiver_comments->CurrentValue;
		$this->receiver_comments->ViewValue = FormatNumber($this->receiver_comments->ViewValue, 0, -2, -2, -2);
		$this->receiver_comments->ViewCustomAttributes = "";

		// r_user_id
		$this->r_user_id->ViewValue = $this->r_user_id->CurrentValue;
		$this->r_user_id->ViewValue = FormatNumber($this->r_user_id->ViewValue, 0, -2, -2, -2);
		$this->r_user_id->ViewCustomAttributes = "";

		// r_datetime
		$this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
		$this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, 0);
		$this->r_datetime->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// r_e_user_id
		$this->r_e_user_id->ViewValue = $this->r_e_user_id->CurrentValue;
		$this->r_e_user_id->ViewValue = FormatNumber($this->r_e_user_id->ViewValue, 0, -2, -2, -2);
		$this->r_e_user_id->ViewCustomAttributes = "";

		// r_e_datetime
		$this->r_e_datetime->ViewValue = $this->r_e_datetime->CurrentValue;
		$this->r_e_datetime->ViewValue = FormatDateTime($this->r_e_datetime->ViewValue, 0);
		$this->r_e_datetime->ViewCustomAttributes = "";

		// print
		$this->_print->ViewValue = $this->_print->CurrentValue;
		$this->_print->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
		$this->jc_no->ViewValue = FormatNumber($this->jc_no->ViewValue, 0, -2, -2, -2);
		$this->jc_no->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
		$this->product->ViewCustomAttributes = "";

		// count_received
		$this->count_received->ViewValue = $this->count_received->CurrentValue;
		$this->count_received->ViewCustomAttributes = "";

		// gp_no
		$this->gp_no->LinkCustomAttributes = "";
		$this->gp_no->HrefValue = "";
		$this->gp_no->TooltipValue = "";

		// from
		$this->from->LinkCustomAttributes = "";
		$this->from->HrefValue = "";
		$this->from->TooltipValue = "";

		// to
		$this->to->LinkCustomAttributes = "";
		$this->to->HrefValue = "";
		$this->to->TooltipValue = "";

		// attention
		$this->attention->LinkCustomAttributes = "";
		$this->attention->HrefValue = "";
		$this->attention->TooltipValue = "";

		// transfer_nature
		$this->transfer_nature->LinkCustomAttributes = "";
		$this->transfer_nature->HrefValue = "";
		$this->transfer_nature->TooltipValue = "";

		// due_date
		$this->due_date->LinkCustomAttributes = "";
		$this->due_date->HrefValue = "";
		$this->due_date->TooltipValue = "";

		// group
		$this->group->LinkCustomAttributes = "";
		$this->group->HrefValue = "";
		$this->group->TooltipValue = "";

		// item
		$this->item->LinkCustomAttributes = "";
		$this->item->HrefValue = "";
		$this->item->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// despatch details
		$this->despatch_details->LinkCustomAttributes = "";
		$this->despatch_details->HrefValue = "";
		$this->despatch_details->TooltipValue = "";

		// sender_comments
		$this->sender_comments->LinkCustomAttributes = "";
		$this->sender_comments->HrefValue = "";
		$this->sender_comments->TooltipValue = "";

		// t_mode
		$this->t_mode->LinkCustomAttributes = "";
		$this->t_mode->HrefValue = "";
		$this->t_mode->TooltipValue = "";

		// t_distance
		$this->t_distance->LinkCustomAttributes = "";
		$this->t_distance->HrefValue = "";
		$this->t_distance->TooltipValue = "";

		// t_v_no
		$this->t_v_no->LinkCustomAttributes = "";
		$this->t_v_no->HrefValue = "";
		$this->t_v_no->TooltipValue = "";

		// purpose
		$this->purpose->LinkCustomAttributes = "";
		$this->purpose->HrefValue = "";
		$this->purpose->TooltipValue = "";

		// user_id
		$this->user_id->LinkCustomAttributes = "";
		$this->user_id->HrefValue = "";
		$this->user_id->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// e_user_id
		$this->e_user_id->LinkCustomAttributes = "";
		$this->e_user_id->HrefValue = "";
		$this->e_user_id->TooltipValue = "";

		// e_datetime
		$this->e_datetime->LinkCustomAttributes = "";
		$this->e_datetime->HrefValue = "";
		$this->e_datetime->TooltipValue = "";

		// receiving_condition
		$this->receiving_condition->LinkCustomAttributes = "";
		$this->receiving_condition->HrefValue = "";
		$this->receiving_condition->TooltipValue = "";

		// receiver_comments
		$this->receiver_comments->LinkCustomAttributes = "";
		$this->receiver_comments->HrefValue = "";
		$this->receiver_comments->TooltipValue = "";

		// r_user_id
		$this->r_user_id->LinkCustomAttributes = "";
		$this->r_user_id->HrefValue = "";
		$this->r_user_id->TooltipValue = "";

		// r_datetime
		$this->r_datetime->LinkCustomAttributes = "";
		$this->r_datetime->HrefValue = "";
		$this->r_datetime->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// r_e_user_id
		$this->r_e_user_id->LinkCustomAttributes = "";
		$this->r_e_user_id->HrefValue = "";
		$this->r_e_user_id->TooltipValue = "";

		// r_e_datetime
		$this->r_e_datetime->LinkCustomAttributes = "";
		$this->r_e_datetime->HrefValue = "";
		$this->r_e_datetime->TooltipValue = "";

		// print
		$this->_print->LinkCustomAttributes = "";
		$this->_print->HrefValue = "";
		$this->_print->TooltipValue = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// count_received
		$this->count_received->LinkCustomAttributes = "";
		$this->count_received->HrefValue = "";
		$this->count_received->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// gp_no
		$this->gp_no->EditAttrs["class"] = "form-control";
		$this->gp_no->EditCustomAttributes = "";
		$this->gp_no->EditValue = $this->gp_no->CurrentValue;
		$this->gp_no->PlaceHolder = RemoveHtml($this->gp_no->caption());

		// from
		$this->from->EditAttrs["class"] = "form-control";
		$this->from->EditCustomAttributes = "";

		// to
		$this->to->EditAttrs["class"] = "form-control";
		$this->to->EditCustomAttributes = "";

		// attention
		$this->attention->EditAttrs["class"] = "form-control";
		$this->attention->EditCustomAttributes = "";

		// transfer_nature
		$this->transfer_nature->EditAttrs["class"] = "form-control";
		$this->transfer_nature->EditCustomAttributes = "";
		$this->transfer_nature->EditValue = $this->transfer_nature->options(TRUE);

		// due_date
		$this->due_date->EditAttrs["class"] = "form-control";
		$this->due_date->EditCustomAttributes = "";
		$this->due_date->EditValue = FormatDateTime($this->due_date->CurrentValue, 8);
		$this->due_date->PlaceHolder = RemoveHtml($this->due_date->caption());

		// group
		$this->group->EditAttrs["class"] = "form-control";
		$this->group->EditCustomAttributes = "";
		$this->group->EditValue = $this->group->options(TRUE);

		// item
		$this->item->EditAttrs["class"] = "form-control";
		$this->item->EditCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
		if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -2, -2, -2);

		// despatch details
		$this->despatch_details->EditAttrs["class"] = "form-control";
		$this->despatch_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->despatch_details->CurrentValue = HtmlDecode($this->despatch_details->CurrentValue);
		$this->despatch_details->EditValue = $this->despatch_details->CurrentValue;
		$this->despatch_details->PlaceHolder = RemoveHtml($this->despatch_details->caption());

		// sender_comments
		$this->sender_comments->EditAttrs["class"] = "form-control";
		$this->sender_comments->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->sender_comments->CurrentValue = HtmlDecode($this->sender_comments->CurrentValue);
		$this->sender_comments->EditValue = $this->sender_comments->CurrentValue;
		$this->sender_comments->PlaceHolder = RemoveHtml($this->sender_comments->caption());

		// t_mode
		$this->t_mode->EditAttrs["class"] = "form-control";
		$this->t_mode->EditCustomAttributes = "";
		$this->t_mode->EditValue = $this->t_mode->options(TRUE);

		// t_distance
		$this->t_distance->EditAttrs["class"] = "form-control";
		$this->t_distance->EditCustomAttributes = "";
		$this->t_distance->EditValue = $this->t_distance->CurrentValue;
		$this->t_distance->PlaceHolder = RemoveHtml($this->t_distance->caption());

		// t_v_no
		$this->t_v_no->EditAttrs["class"] = "form-control";
		$this->t_v_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->t_v_no->CurrentValue = HtmlDecode($this->t_v_no->CurrentValue);
		$this->t_v_no->EditValue = $this->t_v_no->CurrentValue;
		$this->t_v_no->PlaceHolder = RemoveHtml($this->t_v_no->caption());

		// purpose
		$this->purpose->EditAttrs["class"] = "form-control";
		$this->purpose->EditCustomAttributes = "";
		$this->purpose->EditValue = $this->purpose->options(TRUE);

		// user_id
		// datetime
		// e_user_id

		$this->e_user_id->EditAttrs["class"] = "form-control";
		$this->e_user_id->EditCustomAttributes = "";
		$this->e_user_id->EditValue = $this->e_user_id->CurrentValue;
		$this->e_user_id->PlaceHolder = RemoveHtml($this->e_user_id->caption());

		// e_datetime
		$this->e_datetime->EditAttrs["class"] = "form-control";
		$this->e_datetime->EditCustomAttributes = "";
		$this->e_datetime->EditValue = FormatDateTime($this->e_datetime->CurrentValue, 8);
		$this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());

		// receiving_condition
		$this->receiving_condition->EditAttrs["class"] = "form-control";
		$this->receiving_condition->EditCustomAttributes = "";
		$this->receiving_condition->EditValue = $this->receiving_condition->CurrentValue;
		$this->receiving_condition->PlaceHolder = RemoveHtml($this->receiving_condition->caption());

		// receiver_comments
		$this->receiver_comments->EditAttrs["class"] = "form-control";
		$this->receiver_comments->EditCustomAttributes = "";
		$this->receiver_comments->EditValue = $this->receiver_comments->CurrentValue;
		$this->receiver_comments->PlaceHolder = RemoveHtml($this->receiver_comments->caption());

		// r_user_id
		$this->r_user_id->EditAttrs["class"] = "form-control";
		$this->r_user_id->EditCustomAttributes = "";
		$this->r_user_id->EditValue = $this->r_user_id->CurrentValue;
		$this->r_user_id->PlaceHolder = RemoveHtml($this->r_user_id->caption());

		// r_datetime
		$this->r_datetime->EditAttrs["class"] = "form-control";
		$this->r_datetime->EditCustomAttributes = "";
		$this->r_datetime->EditValue = FormatDateTime($this->r_datetime->CurrentValue, 8);
		$this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

		// updated
		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// r_e_user_id
		$this->r_e_user_id->EditAttrs["class"] = "form-control";
		$this->r_e_user_id->EditCustomAttributes = "";
		$this->r_e_user_id->EditValue = $this->r_e_user_id->CurrentValue;
		$this->r_e_user_id->PlaceHolder = RemoveHtml($this->r_e_user_id->caption());

		// r_e_datetime
		$this->r_e_datetime->EditAttrs["class"] = "form-control";
		$this->r_e_datetime->EditCustomAttributes = "";
		$this->r_e_datetime->EditValue = FormatDateTime($this->r_e_datetime->CurrentValue, 8);
		$this->r_e_datetime->PlaceHolder = RemoveHtml($this->r_e_datetime->caption());

		// print
		$this->_print->EditAttrs["class"] = "form-control";
		$this->_print->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_print->CurrentValue = HtmlDecode($this->_print->CurrentValue);
		$this->_print->EditValue = $this->_print->CurrentValue;
		$this->_print->PlaceHolder = RemoveHtml($this->_print->caption());

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";
		$this->jc_no->EditValue = $this->jc_no->CurrentValue;
		$this->jc_no->PlaceHolder = RemoveHtml($this->jc_no->caption());

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// count_received
		$this->count_received->EditAttrs["class"] = "form-control";
		$this->count_received->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
		$this->count_received->EditValue = $this->count_received->CurrentValue;
		$this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->gp_no);
					$doc->exportCaption($this->from);
					$doc->exportCaption($this->to);
					$doc->exportCaption($this->attention);
					$doc->exportCaption($this->transfer_nature);
					$doc->exportCaption($this->due_date);
					$doc->exportCaption($this->group);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->despatch_details);
					$doc->exportCaption($this->sender_comments);
					$doc->exportCaption($this->t_mode);
					$doc->exportCaption($this->t_distance);
					$doc->exportCaption($this->t_v_no);
					$doc->exportCaption($this->purpose);
					$doc->exportCaption($this->user_id);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->e_user_id);
					$doc->exportCaption($this->e_datetime);
					$doc->exportCaption($this->receiving_condition);
					$doc->exportCaption($this->receiver_comments);
					$doc->exportCaption($this->r_user_id);
					$doc->exportCaption($this->r_datetime);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->r_e_user_id);
					$doc->exportCaption($this->r_e_datetime);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->count_received);
				} else {
					$doc->exportCaption($this->gp_no);
					$doc->exportCaption($this->from);
					$doc->exportCaption($this->to);
					$doc->exportCaption($this->attention);
					$doc->exportCaption($this->transfer_nature);
					$doc->exportCaption($this->due_date);
					$doc->exportCaption($this->group);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->despatch_details);
					$doc->exportCaption($this->sender_comments);
					$doc->exportCaption($this->t_mode);
					$doc->exportCaption($this->t_distance);
					$doc->exportCaption($this->t_v_no);
					$doc->exportCaption($this->purpose);
					$doc->exportCaption($this->user_id);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->e_user_id);
					$doc->exportCaption($this->e_datetime);
					$doc->exportCaption($this->receiving_condition);
					$doc->exportCaption($this->receiver_comments);
					$doc->exportCaption($this->r_user_id);
					$doc->exportCaption($this->r_datetime);
					$doc->exportCaption($this->updated);
					$doc->exportCaption($this->r_e_user_id);
					$doc->exportCaption($this->r_e_datetime);
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->count_received);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->gp_no);
						$doc->exportField($this->from);
						$doc->exportField($this->to);
						$doc->exportField($this->attention);
						$doc->exportField($this->transfer_nature);
						$doc->exportField($this->due_date);
						$doc->exportField($this->group);
						$doc->exportField($this->item);
						$doc->exportField($this->quantity);
						$doc->exportField($this->despatch_details);
						$doc->exportField($this->sender_comments);
						$doc->exportField($this->t_mode);
						$doc->exportField($this->t_distance);
						$doc->exportField($this->t_v_no);
						$doc->exportField($this->purpose);
						$doc->exportField($this->user_id);
						$doc->exportField($this->datetime);
						$doc->exportField($this->e_user_id);
						$doc->exportField($this->e_datetime);
						$doc->exportField($this->receiving_condition);
						$doc->exportField($this->receiver_comments);
						$doc->exportField($this->r_user_id);
						$doc->exportField($this->r_datetime);
						$doc->exportField($this->updated);
						$doc->exportField($this->r_e_user_id);
						$doc->exportField($this->r_e_datetime);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->product);
						$doc->exportField($this->count_received);
					} else {
						$doc->exportField($this->gp_no);
						$doc->exportField($this->from);
						$doc->exportField($this->to);
						$doc->exportField($this->attention);
						$doc->exportField($this->transfer_nature);
						$doc->exportField($this->due_date);
						$doc->exportField($this->group);
						$doc->exportField($this->quantity);
						$doc->exportField($this->despatch_details);
						$doc->exportField($this->sender_comments);
						$doc->exportField($this->t_mode);
						$doc->exportField($this->t_distance);
						$doc->exportField($this->t_v_no);
						$doc->exportField($this->purpose);
						$doc->exportField($this->user_id);
						$doc->exportField($this->datetime);
						$doc->exportField($this->e_user_id);
						$doc->exportField($this->e_datetime);
						$doc->exportField($this->receiving_condition);
						$doc->exportField($this->receiver_comments);
						$doc->exportField($this->r_user_id);
						$doc->exportField($this->r_datetime);
						$doc->exportField($this->updated);
						$doc->exportField($this->r_e_user_id);
						$doc->exportField($this->r_e_datetime);
						$doc->exportField($this->jc_no);
						$doc->exportField($this->product);
						$doc->exportField($this->count_received);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>