<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class help_list extends help
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'help';

	// Page object name
	public $PageObjName = "help_list";

	// Grid form hidden field names
	public $FormName = "fhelplist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (help)
		if (!isset($GLOBALS["help"]) || get_class($GLOBALS["help"]) == PROJECT_NAMESPACE . "help") {
			$GLOBALS["help"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["help"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "helpadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "helpdelete.php";
		$this->MultiUpdateUrl = "helpupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'help');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fhelplistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $help;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($help);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->level->setVisibility();
		$this->field_name->setVisibility();
		$this->field_caption->setVisibility();
		$this->field_description->setVisibility();
		$this->table_name->setVisibility();
		$this->table_caption->setVisibility();
		$this->table_description->setVisibility();
		$this->menu_group->setVisibility();
		$this->menu_description->setVisibility();
		$this->system_notes->Visible = FALSE;
		$this->portal_notes->Visible = FALSE;
		$this->admin_notes->Visible = FALSE;
		$this->visible->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Check QueryString parameters
			if (Get("action") !== NULL) {
				$this->CurrentAction = Get("action");

				// Clear inline mode
				if ($this->isCancel())
					$this->clearInlineMode();

				// Switch to grid edit mode
				if ($this->isGridEdit())
					$this->gridEditMode();
			} else {
				if (Post("action") !== NULL) {
					$this->CurrentAction = Post("action"); // Get action

					// Grid Update
					if (($this->isGridUpdate() || $this->isGridOverwrite()) && @$_SESSION[SESSION_INLINE_MODE] == "gridedit") {
						if ($this->validateGridForm()) {
							$gridUpdate = $this->gridUpdate();
						} else {
							$gridUpdate = FALSE;
							$this->setFailureMessage($FormError);
						}
						if ($gridUpdate) {
						} else {
							$this->EventCancelled = TRUE;
							$this->gridEditMode(); // Stay in Grid edit mode
						}
					}
				} elseif (@$_SESSION[SESSION_INLINE_MODE] == "gridedit") { // Previously in grid edit mode
					if (Get(TABLE_START_REC) !== NULL || Get(TABLE_PAGE_NO) !== NULL) // Stay in grid edit mode if paging
						$this->gridEditMode();
					else // Reset grid edit
						$this->clearInlineMode();
				}
			}

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Show grid delete link for grid add / grid edit
			if ($this->AllowAddDeleteRow) {
				if ($this->isGridAdd() || $this->isGridEdit()) {
					$item = &$this->ListOptions->getItem("griddelete");
					if ($item)
						$item->Visible = TRUE;
				}
			}

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Grid Edit mode
	protected function gridEditMode()
	{
		$this->CurrentAction = "gridedit";
		$_SESSION[SESSION_INLINE_MODE] = "gridedit";
		$this->hideFieldsForAddEdit();
	}

	// Perform update to grid
	public function gridUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$gridUpdate = TRUE;

		// Get old recordset
		$this->CurrentFilter = $this->buildKeyFilter();
		if ($this->CurrentFilter == "")
			$this->CurrentFilter = "0=1";
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sql)) {
			$rsold = $rs->getRows();
			$rs->close();
		}

		// Call Grid Updating event
		if (!$this->Grid_Updating($rsold)) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
			return FALSE;
		}

		// Begin transaction
		$conn->beginTrans();
		$key = "";

		// Update row index and get row key
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Update all rows based on key
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
			$CurrentForm->Index = $rowindex;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));

			// Load all values and keys
			if ($rowaction <> "insertdelete") { // Skip insert then deleted rows
				$this->loadFormValues(); // Get form values
				if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
					$gridUpdate = $this->setupKeyValues($rowkey); // Set up key values
				} else {
					$gridUpdate = TRUE;
				}

				// Skip empty row
				if ($rowaction == "insert" && $this->emptyRow()) {

					// No action required
				// Validate form and insert/update/delete record

				} elseif ($gridUpdate) {
					if ($rowaction == "delete") {
						$this->CurrentFilter = $this->getRecordFilter();
						$gridUpdate = $this->deleteRows(); // Delete this row
					} else if (!$this->validateForm()) {
						$gridUpdate = FALSE; // Form error, reset action
						$this->setFailureMessage($FormError);
					} else {
						if ($rowaction == "insert") {
							$gridUpdate = $this->addRow(); // Insert this row
						} else {
							if ($rowkey <> "") {
								$this->SendEmail = FALSE; // Do not send email on update success
								$gridUpdate = $this->editRow(); // Update this row
							}
						} // End update
					}
				}
				if ($gridUpdate) {
					if ($key <> "")
						$key .= ", ";
					$key .= $rowkey;
				} else {
					break;
				}
			}
		}
		if ($gridUpdate) {
			$conn->commitTrans(); // Commit transaction

			// Get new recordset
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Updated event
			$this->Grid_Updated($rsold, $rsnew);
			if ($this->getSuccessMessage() == "")
				$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			$conn->rollbackTrans(); // Rollback transaction
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
		}
		return $gridUpdate;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Check if empty row
	public function emptyRow()
	{
		global $CurrentForm;
		if ($CurrentForm->hasValue("x_level") && $CurrentForm->hasValue("o_level") && $this->level->CurrentValue <> $this->level->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_field_name") && $CurrentForm->hasValue("o_field_name") && $this->field_name->CurrentValue <> $this->field_name->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_field_caption") && $CurrentForm->hasValue("o_field_caption") && $this->field_caption->CurrentValue <> $this->field_caption->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_field_description") && $CurrentForm->hasValue("o_field_description") && $this->field_description->CurrentValue <> $this->field_description->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_table_name") && $CurrentForm->hasValue("o_table_name") && $this->table_name->CurrentValue <> $this->table_name->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_table_caption") && $CurrentForm->hasValue("o_table_caption") && $this->table_caption->CurrentValue <> $this->table_caption->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_table_description") && $CurrentForm->hasValue("o_table_description") && $this->table_description->CurrentValue <> $this->table_description->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_menu_group") && $CurrentForm->hasValue("o_menu_group") && $this->menu_group->CurrentValue <> $this->menu_group->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_menu_description") && $CurrentForm->hasValue("o_menu_description") && $this->menu_description->CurrentValue <> $this->menu_description->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_visible") && $CurrentForm->hasValue("o_visible") && $this->visible->CurrentValue <> $this->visible->OldValue)
			return FALSE;
		return TRUE;
	}

	// Validate grid form
	public function validateGridForm()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Validate all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else if (!$this->validateForm()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	// Get all form values of the grid
	public function getGridFormValues()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;
		$rows = array();

		// Loop through all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else {
					$rows[] = $this->getFieldValues("FormValue"); // Return row as array
				}
			}
		}
		return $rows; // Return as array of array
	}

	// Restore form values for current row
	public function restoreCurrentRowFormValues($idx)
	{
		global $CurrentForm;

		// Get row based on current index
		$CurrentForm->Index = $idx;
		$this->loadFormValues(); // Load form values
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fhelplistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->level->AdvancedSearch->toJson(), ","); // Field level
		$filterList = Concat($filterList, $this->field_name->AdvancedSearch->toJson(), ","); // Field field_name
		$filterList = Concat($filterList, $this->field_caption->AdvancedSearch->toJson(), ","); // Field field_caption
		$filterList = Concat($filterList, $this->field_description->AdvancedSearch->toJson(), ","); // Field field_description
		$filterList = Concat($filterList, $this->table_name->AdvancedSearch->toJson(), ","); // Field table_name
		$filterList = Concat($filterList, $this->table_caption->AdvancedSearch->toJson(), ","); // Field table_caption
		$filterList = Concat($filterList, $this->table_description->AdvancedSearch->toJson(), ","); // Field table_description
		$filterList = Concat($filterList, $this->menu_group->AdvancedSearch->toJson(), ","); // Field menu_group
		$filterList = Concat($filterList, $this->menu_description->AdvancedSearch->toJson(), ","); // Field menu_description
		$filterList = Concat($filterList, $this->portal_notes->AdvancedSearch->toJson(), ","); // Field portal_notes
		$filterList = Concat($filterList, $this->visible->AdvancedSearch->toJson(), ","); // Field visible
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fhelplistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field level
		$this->level->AdvancedSearch->SearchValue = @$filter["x_level"];
		$this->level->AdvancedSearch->SearchOperator = @$filter["z_level"];
		$this->level->AdvancedSearch->SearchCondition = @$filter["v_level"];
		$this->level->AdvancedSearch->SearchValue2 = @$filter["y_level"];
		$this->level->AdvancedSearch->SearchOperator2 = @$filter["w_level"];
		$this->level->AdvancedSearch->save();

		// Field field_name
		$this->field_name->AdvancedSearch->SearchValue = @$filter["x_field_name"];
		$this->field_name->AdvancedSearch->SearchOperator = @$filter["z_field_name"];
		$this->field_name->AdvancedSearch->SearchCondition = @$filter["v_field_name"];
		$this->field_name->AdvancedSearch->SearchValue2 = @$filter["y_field_name"];
		$this->field_name->AdvancedSearch->SearchOperator2 = @$filter["w_field_name"];
		$this->field_name->AdvancedSearch->save();

		// Field field_caption
		$this->field_caption->AdvancedSearch->SearchValue = @$filter["x_field_caption"];
		$this->field_caption->AdvancedSearch->SearchOperator = @$filter["z_field_caption"];
		$this->field_caption->AdvancedSearch->SearchCondition = @$filter["v_field_caption"];
		$this->field_caption->AdvancedSearch->SearchValue2 = @$filter["y_field_caption"];
		$this->field_caption->AdvancedSearch->SearchOperator2 = @$filter["w_field_caption"];
		$this->field_caption->AdvancedSearch->save();

		// Field field_description
		$this->field_description->AdvancedSearch->SearchValue = @$filter["x_field_description"];
		$this->field_description->AdvancedSearch->SearchOperator = @$filter["z_field_description"];
		$this->field_description->AdvancedSearch->SearchCondition = @$filter["v_field_description"];
		$this->field_description->AdvancedSearch->SearchValue2 = @$filter["y_field_description"];
		$this->field_description->AdvancedSearch->SearchOperator2 = @$filter["w_field_description"];
		$this->field_description->AdvancedSearch->save();

		// Field table_name
		$this->table_name->AdvancedSearch->SearchValue = @$filter["x_table_name"];
		$this->table_name->AdvancedSearch->SearchOperator = @$filter["z_table_name"];
		$this->table_name->AdvancedSearch->SearchCondition = @$filter["v_table_name"];
		$this->table_name->AdvancedSearch->SearchValue2 = @$filter["y_table_name"];
		$this->table_name->AdvancedSearch->SearchOperator2 = @$filter["w_table_name"];
		$this->table_name->AdvancedSearch->save();

		// Field table_caption
		$this->table_caption->AdvancedSearch->SearchValue = @$filter["x_table_caption"];
		$this->table_caption->AdvancedSearch->SearchOperator = @$filter["z_table_caption"];
		$this->table_caption->AdvancedSearch->SearchCondition = @$filter["v_table_caption"];
		$this->table_caption->AdvancedSearch->SearchValue2 = @$filter["y_table_caption"];
		$this->table_caption->AdvancedSearch->SearchOperator2 = @$filter["w_table_caption"];
		$this->table_caption->AdvancedSearch->save();

		// Field table_description
		$this->table_description->AdvancedSearch->SearchValue = @$filter["x_table_description"];
		$this->table_description->AdvancedSearch->SearchOperator = @$filter["z_table_description"];
		$this->table_description->AdvancedSearch->SearchCondition = @$filter["v_table_description"];
		$this->table_description->AdvancedSearch->SearchValue2 = @$filter["y_table_description"];
		$this->table_description->AdvancedSearch->SearchOperator2 = @$filter["w_table_description"];
		$this->table_description->AdvancedSearch->save();

		// Field menu_group
		$this->menu_group->AdvancedSearch->SearchValue = @$filter["x_menu_group"];
		$this->menu_group->AdvancedSearch->SearchOperator = @$filter["z_menu_group"];
		$this->menu_group->AdvancedSearch->SearchCondition = @$filter["v_menu_group"];
		$this->menu_group->AdvancedSearch->SearchValue2 = @$filter["y_menu_group"];
		$this->menu_group->AdvancedSearch->SearchOperator2 = @$filter["w_menu_group"];
		$this->menu_group->AdvancedSearch->save();

		// Field menu_description
		$this->menu_description->AdvancedSearch->SearchValue = @$filter["x_menu_description"];
		$this->menu_description->AdvancedSearch->SearchOperator = @$filter["z_menu_description"];
		$this->menu_description->AdvancedSearch->SearchCondition = @$filter["v_menu_description"];
		$this->menu_description->AdvancedSearch->SearchValue2 = @$filter["y_menu_description"];
		$this->menu_description->AdvancedSearch->SearchOperator2 = @$filter["w_menu_description"];
		$this->menu_description->AdvancedSearch->save();

		// Field portal_notes
		$this->portal_notes->AdvancedSearch->SearchValue = @$filter["x_portal_notes"];
		$this->portal_notes->AdvancedSearch->SearchOperator = @$filter["z_portal_notes"];
		$this->portal_notes->AdvancedSearch->SearchCondition = @$filter["v_portal_notes"];
		$this->portal_notes->AdvancedSearch->SearchValue2 = @$filter["y_portal_notes"];
		$this->portal_notes->AdvancedSearch->SearchOperator2 = @$filter["w_portal_notes"];
		$this->portal_notes->AdvancedSearch->save();

		// Field visible
		$this->visible->AdvancedSearch->SearchValue = @$filter["x_visible"];
		$this->visible->AdvancedSearch->SearchOperator = @$filter["z_visible"];
		$this->visible->AdvancedSearch->SearchCondition = @$filter["v_visible"];
		$this->visible->AdvancedSearch->SearchValue2 = @$filter["y_visible"];
		$this->visible->AdvancedSearch->SearchOperator2 = @$filter["w_visible"];
		$this->visible->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->level, $default, FALSE); // level
		$this->buildSearchSql($where, $this->field_name, $default, FALSE); // field_name
		$this->buildSearchSql($where, $this->field_caption, $default, FALSE); // field_caption
		$this->buildSearchSql($where, $this->field_description, $default, FALSE); // field_description
		$this->buildSearchSql($where, $this->table_name, $default, FALSE); // table_name
		$this->buildSearchSql($where, $this->table_caption, $default, FALSE); // table_caption
		$this->buildSearchSql($where, $this->table_description, $default, FALSE); // table_description
		$this->buildSearchSql($where, $this->menu_group, $default, FALSE); // menu_group
		$this->buildSearchSql($where, $this->menu_description, $default, FALSE); // menu_description
		$this->buildSearchSql($where, $this->portal_notes, $default, FALSE); // portal_notes
		$this->buildSearchSql($where, $this->visible, $default, FALSE); // visible
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->level->AdvancedSearch->save(); // level
			$this->field_name->AdvancedSearch->save(); // field_name
			$this->field_caption->AdvancedSearch->save(); // field_caption
			$this->field_description->AdvancedSearch->save(); // field_description
			$this->table_name->AdvancedSearch->save(); // table_name
			$this->table_caption->AdvancedSearch->save(); // table_caption
			$this->table_description->AdvancedSearch->save(); // table_description
			$this->menu_group->AdvancedSearch->save(); // menu_group
			$this->menu_description->AdvancedSearch->save(); // menu_description
			$this->portal_notes->AdvancedSearch->save(); // portal_notes
			$this->visible->AdvancedSearch->save(); // visible
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->table_caption, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->level->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->field_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->field_caption->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->field_description->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->table_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->table_caption->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->table_description->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->menu_group->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->menu_description->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->portal_notes->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->visible->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->level->AdvancedSearch->unsetSession();
		$this->field_name->AdvancedSearch->unsetSession();
		$this->field_caption->AdvancedSearch->unsetSession();
		$this->field_description->AdvancedSearch->unsetSession();
		$this->table_name->AdvancedSearch->unsetSession();
		$this->table_caption->AdvancedSearch->unsetSession();
		$this->table_description->AdvancedSearch->unsetSession();
		$this->menu_group->AdvancedSearch->unsetSession();
		$this->menu_description->AdvancedSearch->unsetSession();
		$this->portal_notes->AdvancedSearch->unsetSession();
		$this->visible->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->level->AdvancedSearch->load();
		$this->field_name->AdvancedSearch->load();
		$this->field_caption->AdvancedSearch->load();
		$this->field_description->AdvancedSearch->load();
		$this->table_name->AdvancedSearch->load();
		$this->table_caption->AdvancedSearch->load();
		$this->table_description->AdvancedSearch->load();
		$this->menu_group->AdvancedSearch->load();
		$this->menu_description->AdvancedSearch->load();
		$this->portal_notes->AdvancedSearch->load();
		$this->visible->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->level, $ctrl); // level
			$this->updateSort($this->field_name, $ctrl); // field_name
			$this->updateSort($this->field_caption, $ctrl); // field_caption
			$this->updateSort($this->field_description, $ctrl); // field_description
			$this->updateSort($this->table_name, $ctrl); // table_name
			$this->updateSort($this->table_caption, $ctrl); // table_caption
			$this->updateSort($this->table_description, $ctrl); // table_description
			$this->updateSort($this->menu_group, $ctrl); // menu_group
			$this->updateSort($this->menu_description, $ctrl); // menu_description
			$this->updateSort($this->visible, $ctrl); // visible
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->level->setSort("");
				$this->field_name->setSort("");
				$this->field_caption->setSort("");
				$this->field_description->setSort("");
				$this->table_name->setSort("");
				$this->table_caption->setSort("");
				$this->table_description->setSort("");
				$this->menu_group->setSort("");
				$this->menu_description->setSort("");
				$this->visible->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// "griddelete"
		if ($this->AllowAddDeleteRow) {
			$item = &$this->ListOptions->add("griddelete");
			$item->CssClass = "text-nowrap";
			$item->OnLeft = TRUE;
			$item->Visible = FALSE; // Default hidden
		}

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode <> "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "delete"
		if ($this->AllowAddDeleteRow) {
			if ($this->isGridAdd() || $this->isGridEdit()) {
				$options = &$this->ListOptions;
				$options->UseButtonGroup = TRUE; // Use button group for grid delete button
				$opt = &$options->Items["griddelete"];
				if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
					$opt->Body = "&nbsp;";
				} else {
					$opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
				}
			}
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		if ($this->isGridEdit() && is_numeric($this->RowIndex)) {
			$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . $this->id->CurrentValue . "\">";
		}
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;

		// Add grid edit
		$option = $options["addedit"];
		$item = &$option->add("gridedit");
		$item->Body = "<a class=\"ew-add-edit ew-grid-edit\" title=\"" . HtmlTitle($Language->phrase("GridEditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridEditLink")) . "\" href=\"" . HtmlEncode($this->GridEditUrl) . "\">" . $Language->phrase("GridEditLink") . "</a>";
		$item->Visible = ($this->GridEditUrl <> "" && $Security->canEdit());
		$option = $options["action"];

		// Add multi update
		$item = &$option->add("multiupdate");
		$item->Body = "<a class=\"ew-action ew-multi-update\" title=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" data-table=\"help\" data-caption=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" href=\"\" onclick=\"ew.modalDialogShow({lnk:this,btn:'UpdateBtn',f:document.fhelplist,url:'" . $this->MultiUpdateUrl . "'});return false;\">" . $Language->phrase("UpdateSelectedLink") . "</a>";
		$item->Visible = ($Security->canEdit());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fhelplistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fhelplistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		if (!$this->isGridAdd() && !$this->isGridEdit()) { // Not grid add/edit mode
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fhelplist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
		} else { // Grid add/edit mode

			// Hide all options first
			foreach ($options as &$option)
				$option->hideAllOptions();
			if ($this->isGridEdit()) {
				if ($this->AllowAddDeleteRow) {

					// Add add blank row
					$option = &$options["addedit"];
					$option->UseDropDownButton = FALSE;
					$item = &$option->add("addblankrow");
					$item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"javascript:void(0);\" onclick=\"ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
					$item->Visible = FALSE;
				}
				$option = &$options["action"];
				$option->UseDropDownButton = FALSE;
					$item = &$option->add("gridsave");
					$item->Body = "<a class=\"ew-action ew-grid-save\" title=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" href=\"\" onclick=\"return ew.forms(this).submit('" . $this->pageName() . "');\">" . $Language->phrase("GridSaveLink") . "</a>";
					$item = &$option->add("gridcancel");
					$item->Body = "<a class=\"ew-action ew-grid-cancel\" title=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" href=\"" . $this->CancelUrl . "\">" . $Language->phrase("GridCancelLink") . "</a>";
			}
		}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fhelplistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"helpsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"help\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'helpsrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fhelplistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->level->CurrentValue = 0;
		$this->level->OldValue = $this->level->CurrentValue;
		$this->field_name->CurrentValue = NULL;
		$this->field_name->OldValue = $this->field_name->CurrentValue;
		$this->field_caption->CurrentValue = NULL;
		$this->field_caption->OldValue = $this->field_caption->CurrentValue;
		$this->field_description->CurrentValue = NULL;
		$this->field_description->OldValue = $this->field_description->CurrentValue;
		$this->table_name->CurrentValue = NULL;
		$this->table_name->OldValue = $this->table_name->CurrentValue;
		$this->table_caption->CurrentValue = NULL;
		$this->table_caption->OldValue = $this->table_caption->CurrentValue;
		$this->table_description->CurrentValue = NULL;
		$this->table_description->OldValue = $this->table_description->CurrentValue;
		$this->menu_group->CurrentValue = NULL;
		$this->menu_group->OldValue = $this->menu_group->CurrentValue;
		$this->menu_description->CurrentValue = NULL;
		$this->menu_description->OldValue = $this->menu_description->CurrentValue;
		$this->system_notes->CurrentValue = NULL;
		$this->system_notes->OldValue = $this->system_notes->CurrentValue;
		$this->portal_notes->CurrentValue = NULL;
		$this->portal_notes->OldValue = $this->portal_notes->CurrentValue;
		$this->admin_notes->CurrentValue = NULL;
		$this->admin_notes->OldValue = $this->admin_notes->CurrentValue;
		$this->visible->CurrentValue = 0;
		$this->visible->OldValue = $this->visible->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// level
		if (!$this->isAddOrEdit())
			$this->level->AdvancedSearch->setSearchValue(Get("x_level", Get("level", "")));
		if ($this->level->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->level->AdvancedSearch->setSearchOperator(Get("z_level", ""));

		// field_name
		if (!$this->isAddOrEdit())
			$this->field_name->AdvancedSearch->setSearchValue(Get("x_field_name", Get("field_name", "")));
		if ($this->field_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->field_name->AdvancedSearch->setSearchOperator(Get("z_field_name", ""));
		$this->field_name->AdvancedSearch->setSearchCondition(Get("v_field_name", ""));
		$this->field_name->AdvancedSearch->setSearchValue2(Get("y_field_name", ""));
		if ($this->field_name->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->field_name->AdvancedSearch->setSearchOperator2(Get("w_field_name", ""));

		// field_caption
		if (!$this->isAddOrEdit())
			$this->field_caption->AdvancedSearch->setSearchValue(Get("x_field_caption", Get("field_caption", "")));
		if ($this->field_caption->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->field_caption->AdvancedSearch->setSearchOperator(Get("z_field_caption", ""));
		$this->field_caption->AdvancedSearch->setSearchCondition(Get("v_field_caption", ""));
		$this->field_caption->AdvancedSearch->setSearchValue2(Get("y_field_caption", ""));
		if ($this->field_caption->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->field_caption->AdvancedSearch->setSearchOperator2(Get("w_field_caption", ""));

		// field_description
		if (!$this->isAddOrEdit())
			$this->field_description->AdvancedSearch->setSearchValue(Get("x_field_description", Get("field_description", "")));
		if ($this->field_description->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->field_description->AdvancedSearch->setSearchOperator(Get("z_field_description", ""));
		$this->field_description->AdvancedSearch->setSearchCondition(Get("v_field_description", ""));
		$this->field_description->AdvancedSearch->setSearchValue2(Get("y_field_description", ""));
		if ($this->field_description->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->field_description->AdvancedSearch->setSearchOperator2(Get("w_field_description", ""));

		// table_name
		if (!$this->isAddOrEdit())
			$this->table_name->AdvancedSearch->setSearchValue(Get("x_table_name", Get("table_name", "")));
		if ($this->table_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->table_name->AdvancedSearch->setSearchOperator(Get("z_table_name", ""));
		$this->table_name->AdvancedSearch->setSearchCondition(Get("v_table_name", ""));
		$this->table_name->AdvancedSearch->setSearchValue2(Get("y_table_name", ""));
		if ($this->table_name->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->table_name->AdvancedSearch->setSearchOperator2(Get("w_table_name", ""));

		// table_caption
		if (!$this->isAddOrEdit())
			$this->table_caption->AdvancedSearch->setSearchValue(Get("x_table_caption", Get("table_caption", "")));
		if ($this->table_caption->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->table_caption->AdvancedSearch->setSearchOperator(Get("z_table_caption", ""));
		$this->table_caption->AdvancedSearch->setSearchCondition(Get("v_table_caption", ""));
		$this->table_caption->AdvancedSearch->setSearchValue2(Get("y_table_caption", ""));
		if ($this->table_caption->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->table_caption->AdvancedSearch->setSearchOperator2(Get("w_table_caption", ""));

		// table_description
		if (!$this->isAddOrEdit())
			$this->table_description->AdvancedSearch->setSearchValue(Get("x_table_description", Get("table_description", "")));
		if ($this->table_description->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->table_description->AdvancedSearch->setSearchOperator(Get("z_table_description", ""));

		// menu_group
		if (!$this->isAddOrEdit())
			$this->menu_group->AdvancedSearch->setSearchValue(Get("x_menu_group", Get("menu_group", "")));
		if ($this->menu_group->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->menu_group->AdvancedSearch->setSearchOperator(Get("z_menu_group", ""));
		$this->menu_group->AdvancedSearch->setSearchCondition(Get("v_menu_group", ""));
		$this->menu_group->AdvancedSearch->setSearchValue2(Get("y_menu_group", ""));
		if ($this->menu_group->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->menu_group->AdvancedSearch->setSearchOperator2(Get("w_menu_group", ""));

		// menu_description
		if (!$this->isAddOrEdit())
			$this->menu_description->AdvancedSearch->setSearchValue(Get("x_menu_description", Get("menu_description", "")));
		if ($this->menu_description->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->menu_description->AdvancedSearch->setSearchOperator(Get("z_menu_description", ""));
		$this->menu_description->AdvancedSearch->setSearchCondition(Get("v_menu_description", ""));
		$this->menu_description->AdvancedSearch->setSearchValue2(Get("y_menu_description", ""));
		if ($this->menu_description->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->menu_description->AdvancedSearch->setSearchOperator2(Get("w_menu_description", ""));

		// portal_notes
		if (!$this->isAddOrEdit())
			$this->portal_notes->AdvancedSearch->setSearchValue(Get("x_portal_notes", Get("portal_notes", "")));
		if ($this->portal_notes->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->portal_notes->AdvancedSearch->setSearchOperator(Get("z_portal_notes", ""));
		$this->portal_notes->AdvancedSearch->setSearchCondition(Get("v_portal_notes", ""));
		$this->portal_notes->AdvancedSearch->setSearchValue2(Get("y_portal_notes", ""));
		if ($this->portal_notes->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->portal_notes->AdvancedSearch->setSearchOperator2(Get("w_portal_notes", ""));

		// visible
		if (!$this->isAddOrEdit())
			$this->visible->AdvancedSearch->setSearchValue(Get("x_visible", Get("visible", "")));
		if ($this->visible->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->visible->AdvancedSearch->setSearchOperator(Get("z_visible", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd())
			$this->id->setFormValue($val);

		// Check field name 'level' first before field var 'x_level'
		$val = $CurrentForm->hasValue("level") ? $CurrentForm->getValue("level") : $CurrentForm->getValue("x_level");
		if (!$this->level->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->level->Visible = FALSE; // Disable update for API request
			else
				$this->level->setFormValue($val);
		}

		// Check field name 'field_name' first before field var 'x_field_name'
		$val = $CurrentForm->hasValue("field_name") ? $CurrentForm->getValue("field_name") : $CurrentForm->getValue("x_field_name");
		if (!$this->field_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->field_name->Visible = FALSE; // Disable update for API request
			else
				$this->field_name->setFormValue($val);
		}

		// Check field name 'field_caption' first before field var 'x_field_caption'
		$val = $CurrentForm->hasValue("field_caption") ? $CurrentForm->getValue("field_caption") : $CurrentForm->getValue("x_field_caption");
		if (!$this->field_caption->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->field_caption->Visible = FALSE; // Disable update for API request
			else
				$this->field_caption->setFormValue($val);
		}

		// Check field name 'field_description' first before field var 'x_field_description'
		$val = $CurrentForm->hasValue("field_description") ? $CurrentForm->getValue("field_description") : $CurrentForm->getValue("x_field_description");
		if (!$this->field_description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->field_description->Visible = FALSE; // Disable update for API request
			else
				$this->field_description->setFormValue($val);
		}

		// Check field name 'table_name' first before field var 'x_table_name'
		$val = $CurrentForm->hasValue("table_name") ? $CurrentForm->getValue("table_name") : $CurrentForm->getValue("x_table_name");
		if (!$this->table_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->table_name->Visible = FALSE; // Disable update for API request
			else
				$this->table_name->setFormValue($val);
		}

		// Check field name 'table_caption' first before field var 'x_table_caption'
		$val = $CurrentForm->hasValue("table_caption") ? $CurrentForm->getValue("table_caption") : $CurrentForm->getValue("x_table_caption");
		if (!$this->table_caption->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->table_caption->Visible = FALSE; // Disable update for API request
			else
				$this->table_caption->setFormValue($val);
		}

		// Check field name 'table_description' first before field var 'x_table_description'
		$val = $CurrentForm->hasValue("table_description") ? $CurrentForm->getValue("table_description") : $CurrentForm->getValue("x_table_description");
		if (!$this->table_description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->table_description->Visible = FALSE; // Disable update for API request
			else
				$this->table_description->setFormValue($val);
		}

		// Check field name 'menu_group' first before field var 'x_menu_group'
		$val = $CurrentForm->hasValue("menu_group") ? $CurrentForm->getValue("menu_group") : $CurrentForm->getValue("x_menu_group");
		if (!$this->menu_group->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->menu_group->Visible = FALSE; // Disable update for API request
			else
				$this->menu_group->setFormValue($val);
		}

		// Check field name 'menu_description' first before field var 'x_menu_description'
		$val = $CurrentForm->hasValue("menu_description") ? $CurrentForm->getValue("menu_description") : $CurrentForm->getValue("x_menu_description");
		if (!$this->menu_description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->menu_description->Visible = FALSE; // Disable update for API request
			else
				$this->menu_description->setFormValue($val);
		}

		// Check field name 'visible' first before field var 'x_visible'
		$val = $CurrentForm->hasValue("visible") ? $CurrentForm->getValue("visible") : $CurrentForm->getValue("x_visible");
		if (!$this->visible->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->visible->Visible = FALSE; // Disable update for API request
			else
				$this->visible->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		if (!$this->isGridAdd() && !$this->isAdd())
			$this->id->CurrentValue = $this->id->FormValue;
		$this->level->CurrentValue = $this->level->FormValue;
		$this->field_name->CurrentValue = $this->field_name->FormValue;
		$this->field_caption->CurrentValue = $this->field_caption->FormValue;
		$this->field_description->CurrentValue = $this->field_description->FormValue;
		$this->table_name->CurrentValue = $this->table_name->FormValue;
		$this->table_caption->CurrentValue = $this->table_caption->FormValue;
		$this->table_description->CurrentValue = $this->table_description->FormValue;
		$this->menu_group->CurrentValue = $this->menu_group->FormValue;
		$this->menu_description->CurrentValue = $this->menu_description->FormValue;
		$this->visible->CurrentValue = $this->visible->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			if (!$this->EventCancelled)
				$this->HashValue = $this->getRowHash($rs); // Get hash value for record
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->level->setDbValue($row['level']);
		$this->field_name->setDbValue($row['field_name']);
		$this->field_caption->setDbValue($row['field_caption']);
		$this->field_description->setDbValue($row['field_description']);
		$this->table_name->setDbValue($row['table_name']);
		$this->table_caption->setDbValue($row['table_caption']);
		$this->table_description->setDbValue($row['table_description']);
		$this->menu_group->setDbValue($row['menu_group']);
		$this->menu_description->setDbValue($row['menu_description']);
		$this->system_notes->setDbValue($row['system_notes']);
		$this->portal_notes->setDbValue($row['portal_notes']);
		$this->admin_notes->setDbValue($row['admin_notes']);
		$this->visible->setDbValue($row['visible']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['level'] = $this->level->CurrentValue;
		$row['field_name'] = $this->field_name->CurrentValue;
		$row['field_caption'] = $this->field_caption->CurrentValue;
		$row['field_description'] = $this->field_description->CurrentValue;
		$row['table_name'] = $this->table_name->CurrentValue;
		$row['table_caption'] = $this->table_caption->CurrentValue;
		$row['table_description'] = $this->table_description->CurrentValue;
		$row['menu_group'] = $this->menu_group->CurrentValue;
		$row['menu_description'] = $this->menu_description->CurrentValue;
		$row['system_notes'] = $this->system_notes->CurrentValue;
		$row['portal_notes'] = $this->portal_notes->CurrentValue;
		$row['admin_notes'] = $this->admin_notes->CurrentValue;
		$row['visible'] = $this->visible->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// level
		// field_name

		$this->field_name->CellCssStyle = "white-space: nowrap;";

		// field_caption
		$this->field_caption->CellCssStyle = "white-space: nowrap;";

		// field_description
		$this->field_description->CellCssStyle = "white-space: nowrap;";

		// table_name
		$this->table_name->CellCssStyle = "white-space: nowrap;";

		// table_caption
		// table_description

		$this->table_description->CellCssStyle = "white-space: nowrap;";

		// menu_group
		$this->menu_group->CellCssStyle = "white-space: nowrap;";

		// menu_description
		$this->menu_description->CellCssStyle = "white-space: nowrap;";

		// system_notes
		$this->system_notes->CellCssStyle = "white-space: nowrap;";

		// portal_notes
		$this->portal_notes->CellCssStyle = "white-space: nowrap;";

		// admin_notes
		$this->admin_notes->CellCssStyle = "white-space: nowrap;";

		// visible
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// level
			if (strval($this->level->CurrentValue) <> "") {
				$this->level->ViewValue = $this->level->optionCaption($this->level->CurrentValue);
			} else {
				$this->level->ViewValue = NULL;
			}
			$this->level->ViewCustomAttributes = "";

			// field_name
			$this->field_name->ViewValue = $this->field_name->CurrentValue;
			$this->field_name->ViewCustomAttributes = "";

			// field_caption
			$this->field_caption->ViewValue = $this->field_caption->CurrentValue;
			$this->field_caption->ViewCustomAttributes = "";

			// field_description
			$this->field_description->ViewValue = $this->field_description->CurrentValue;
			if ($this->field_description->ViewValue != NULL) $this->field_description->ViewValue = str_replace("\n", "<br>", $this->field_description->ViewValue);
			$this->field_description->ViewCustomAttributes = "";

			// table_name
			$this->table_name->ViewValue = $this->table_name->CurrentValue;
			$this->table_name->ViewCustomAttributes = "";

			// table_caption
			$this->table_caption->ViewValue = $this->table_caption->CurrentValue;
			$this->table_caption->ViewCustomAttributes = "";

			// table_description
			$this->table_description->ViewValue = $this->table_description->CurrentValue;
			if ($this->table_description->ViewValue != NULL) $this->table_description->ViewValue = str_replace("\n", "<br>", $this->table_description->ViewValue);
			$this->table_description->ViewCustomAttributes = "";

			// menu_group
			$this->menu_group->ViewValue = $this->menu_group->CurrentValue;
			$this->menu_group->ViewCustomAttributes = "";

			// menu_description
			$this->menu_description->ViewValue = $this->menu_description->CurrentValue;
			if ($this->menu_description->ViewValue != NULL) $this->menu_description->ViewValue = str_replace("\n", "<br>", $this->menu_description->ViewValue);
			$this->menu_description->ViewCustomAttributes = "";

			// visible
			if (strval($this->visible->CurrentValue) <> "") {
				$this->visible->ViewValue = $this->visible->optionCaption($this->visible->CurrentValue);
			} else {
				$this->visible->ViewValue = NULL;
			}
			$this->visible->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";

			// field_name
			$this->field_name->LinkCustomAttributes = "";
			$this->field_name->HrefValue = "";
			$this->field_name->TooltipValue = "";
			if (!$this->isExport())
				$this->field_name->ViewValue = $this->highlightValue($this->field_name);

			// field_caption
			$this->field_caption->LinkCustomAttributes = "";
			$this->field_caption->HrefValue = "";
			$this->field_caption->TooltipValue = "";
			if (!$this->isExport())
				$this->field_caption->ViewValue = $this->highlightValue($this->field_caption);

			// field_description
			$this->field_description->LinkCustomAttributes = "";
			$this->field_description->HrefValue = "";
			$this->field_description->TooltipValue = "";
			if (!$this->isExport())
				$this->field_description->ViewValue = $this->highlightValue($this->field_description);

			// table_name
			$this->table_name->LinkCustomAttributes = "";
			$this->table_name->HrefValue = "";
			$this->table_name->TooltipValue = "";
			if (!$this->isExport())
				$this->table_name->ViewValue = $this->highlightValue($this->table_name);

			// table_caption
			$this->table_caption->LinkCustomAttributes = "";
			$this->table_caption->HrefValue = "";
			$this->table_caption->TooltipValue = "";
			if (!$this->isExport())
				$this->table_caption->ViewValue = $this->highlightValue($this->table_caption);

			// table_description
			$this->table_description->LinkCustomAttributes = "";
			$this->table_description->HrefValue = "";
			$this->table_description->TooltipValue = "";
			if (!$this->isExport())
				$this->table_description->ViewValue = $this->highlightValue($this->table_description);

			// menu_group
			$this->menu_group->LinkCustomAttributes = "";
			$this->menu_group->HrefValue = "";
			$this->menu_group->TooltipValue = "";
			if (!$this->isExport())
				$this->menu_group->ViewValue = $this->highlightValue($this->menu_group);

			// menu_description
			$this->menu_description->LinkCustomAttributes = "";
			$this->menu_description->HrefValue = "";
			$this->menu_description->TooltipValue = "";
			if (!$this->isExport())
				$this->menu_description->ViewValue = $this->highlightValue($this->menu_description);

			// visible
			$this->visible->LinkCustomAttributes = "";
			$this->visible->HrefValue = "";
			$this->visible->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			// level

			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = $this->level->options(TRUE);

			// field_name
			$this->field_name->EditAttrs["class"] = "form-control";
			$this->field_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->field_name->CurrentValue = HtmlDecode($this->field_name->CurrentValue);
			$this->field_name->EditValue = HtmlEncode($this->field_name->CurrentValue);
			$this->field_name->PlaceHolder = RemoveHtml($this->field_name->caption());

			// field_caption
			$this->field_caption->EditAttrs["class"] = "form-control";
			$this->field_caption->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->field_caption->CurrentValue = HtmlDecode($this->field_caption->CurrentValue);
			$this->field_caption->EditValue = HtmlEncode($this->field_caption->CurrentValue);
			$this->field_caption->PlaceHolder = RemoveHtml($this->field_caption->caption());

			// field_description
			$this->field_description->EditAttrs["class"] = "form-control";
			$this->field_description->EditCustomAttributes = "";
			$this->field_description->EditValue = HtmlEncode($this->field_description->CurrentValue);
			$this->field_description->PlaceHolder = RemoveHtml($this->field_description->caption());

			// table_name
			$this->table_name->EditAttrs["class"] = "form-control";
			$this->table_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->table_name->CurrentValue = HtmlDecode($this->table_name->CurrentValue);
			$this->table_name->EditValue = HtmlEncode($this->table_name->CurrentValue);
			$this->table_name->PlaceHolder = RemoveHtml($this->table_name->caption());

			// table_caption
			$this->table_caption->EditAttrs["class"] = "form-control";
			$this->table_caption->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->table_caption->CurrentValue = HtmlDecode($this->table_caption->CurrentValue);
			$this->table_caption->EditValue = HtmlEncode($this->table_caption->CurrentValue);
			$this->table_caption->PlaceHolder = RemoveHtml($this->table_caption->caption());

			// table_description
			$this->table_description->EditAttrs["class"] = "form-control";
			$this->table_description->EditCustomAttributes = "";
			$this->table_description->EditValue = HtmlEncode($this->table_description->CurrentValue);
			$this->table_description->PlaceHolder = RemoveHtml($this->table_description->caption());

			// menu_group
			$this->menu_group->EditAttrs["class"] = "form-control";
			$this->menu_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->menu_group->CurrentValue = HtmlDecode($this->menu_group->CurrentValue);
			$this->menu_group->EditValue = HtmlEncode($this->menu_group->CurrentValue);
			$this->menu_group->PlaceHolder = RemoveHtml($this->menu_group->caption());

			// menu_description
			$this->menu_description->EditAttrs["class"] = "form-control";
			$this->menu_description->EditCustomAttributes = "";
			$this->menu_description->EditValue = HtmlEncode($this->menu_description->CurrentValue);
			$this->menu_description->PlaceHolder = RemoveHtml($this->menu_description->caption());

			// visible
			$this->visible->EditAttrs["class"] = "form-control";
			$this->visible->EditCustomAttributes = "";
			$this->visible->EditValue = $this->visible->options(TRUE);

			// operator
			// datetime
			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";

			// field_name
			$this->field_name->LinkCustomAttributes = "";
			$this->field_name->HrefValue = "";

			// field_caption
			$this->field_caption->LinkCustomAttributes = "";
			$this->field_caption->HrefValue = "";

			// field_description
			$this->field_description->LinkCustomAttributes = "";
			$this->field_description->HrefValue = "";

			// table_name
			$this->table_name->LinkCustomAttributes = "";
			$this->table_name->HrefValue = "";

			// table_caption
			$this->table_caption->LinkCustomAttributes = "";
			$this->table_caption->HrefValue = "";

			// table_description
			$this->table_description->LinkCustomAttributes = "";
			$this->table_description->HrefValue = "";

			// menu_group
			$this->menu_group->LinkCustomAttributes = "";
			$this->menu_group->HrefValue = "";

			// menu_description
			$this->menu_description->LinkCustomAttributes = "";
			$this->menu_description->HrefValue = "";

			// visible
			$this->visible->LinkCustomAttributes = "";
			$this->visible->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// level
			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			if (strval($this->level->CurrentValue) <> "") {
				$this->level->EditValue = $this->level->optionCaption($this->level->CurrentValue);
			} else {
				$this->level->EditValue = NULL;
			}
			$this->level->ViewCustomAttributes = "";

			// field_name
			$this->field_name->EditAttrs["class"] = "form-control";
			$this->field_name->EditCustomAttributes = "";
			$this->field_name->EditValue = $this->field_name->CurrentValue;
			$this->field_name->ViewCustomAttributes = "";

			// field_caption
			$this->field_caption->EditAttrs["class"] = "form-control";
			$this->field_caption->EditCustomAttributes = "";
			$this->field_caption->EditValue = $this->field_caption->CurrentValue;
			$this->field_caption->ViewCustomAttributes = "";

			// field_description
			$this->field_description->EditAttrs["class"] = "form-control";
			$this->field_description->EditCustomAttributes = "";
			$this->field_description->EditValue = HtmlEncode($this->field_description->CurrentValue);
			$this->field_description->PlaceHolder = RemoveHtml($this->field_description->caption());

			// table_name
			$this->table_name->EditAttrs["class"] = "form-control";
			$this->table_name->EditCustomAttributes = "";
			$this->table_name->EditValue = $this->table_name->CurrentValue;
			$this->table_name->ViewCustomAttributes = "";

			// table_caption
			$this->table_caption->EditAttrs["class"] = "form-control";
			$this->table_caption->EditCustomAttributes = "";
			$this->table_caption->EditValue = $this->table_caption->CurrentValue;
			$this->table_caption->ViewCustomAttributes = "";

			// table_description
			$this->table_description->EditAttrs["class"] = "form-control";
			$this->table_description->EditCustomAttributes = "";
			$this->table_description->EditValue = HtmlEncode($this->table_description->CurrentValue);
			$this->table_description->PlaceHolder = RemoveHtml($this->table_description->caption());

			// menu_group
			$this->menu_group->EditAttrs["class"] = "form-control";
			$this->menu_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->menu_group->CurrentValue = HtmlDecode($this->menu_group->CurrentValue);
			$this->menu_group->EditValue = HtmlEncode($this->menu_group->CurrentValue);
			$this->menu_group->PlaceHolder = RemoveHtml($this->menu_group->caption());

			// menu_description
			$this->menu_description->EditAttrs["class"] = "form-control";
			$this->menu_description->EditCustomAttributes = "";
			$this->menu_description->EditValue = HtmlEncode($this->menu_description->CurrentValue);
			$this->menu_description->PlaceHolder = RemoveHtml($this->menu_description->caption());

			// visible
			$this->visible->EditAttrs["class"] = "form-control";
			$this->visible->EditCustomAttributes = "";
			$this->visible->EditValue = $this->visible->options(TRUE);

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// level
			$this->level->LinkCustomAttributes = "";
			$this->level->HrefValue = "";
			$this->level->TooltipValue = "";

			// field_name
			$this->field_name->LinkCustomAttributes = "";
			$this->field_name->HrefValue = "";
			$this->field_name->TooltipValue = "";

			// field_caption
			$this->field_caption->LinkCustomAttributes = "";
			$this->field_caption->HrefValue = "";
			$this->field_caption->TooltipValue = "";

			// field_description
			$this->field_description->LinkCustomAttributes = "";
			$this->field_description->HrefValue = "";

			// table_name
			$this->table_name->LinkCustomAttributes = "";
			$this->table_name->HrefValue = "";
			$this->table_name->TooltipValue = "";

			// table_caption
			$this->table_caption->LinkCustomAttributes = "";
			$this->table_caption->HrefValue = "";
			$this->table_caption->TooltipValue = "";

			// table_description
			$this->table_description->LinkCustomAttributes = "";
			$this->table_description->HrefValue = "";

			// menu_group
			$this->menu_group->LinkCustomAttributes = "";
			$this->menu_group->HrefValue = "";

			// menu_description
			$this->menu_description->LinkCustomAttributes = "";
			$this->menu_description->HrefValue = "";

			// visible
			$this->visible->LinkCustomAttributes = "";
			$this->visible->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// level
			$this->level->EditAttrs["class"] = "form-control";
			$this->level->EditCustomAttributes = "";
			$this->level->EditValue = $this->level->options(TRUE);

			// field_name
			$this->field_name->EditAttrs["class"] = "form-control";
			$this->field_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->field_name->AdvancedSearch->SearchValue = HtmlDecode($this->field_name->AdvancedSearch->SearchValue);
			$this->field_name->EditValue = HtmlEncode($this->field_name->AdvancedSearch->SearchValue);
			$this->field_name->PlaceHolder = RemoveHtml($this->field_name->caption());
			$this->field_name->EditAttrs["class"] = "form-control";
			$this->field_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->field_name->AdvancedSearch->SearchValue2 = HtmlDecode($this->field_name->AdvancedSearch->SearchValue2);
			$this->field_name->EditValue2 = HtmlEncode($this->field_name->AdvancedSearch->SearchValue2);
			$this->field_name->PlaceHolder = RemoveHtml($this->field_name->caption());

			// field_caption
			$this->field_caption->EditAttrs["class"] = "form-control";
			$this->field_caption->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->field_caption->AdvancedSearch->SearchValue = HtmlDecode($this->field_caption->AdvancedSearch->SearchValue);
			$this->field_caption->EditValue = HtmlEncode($this->field_caption->AdvancedSearch->SearchValue);
			$this->field_caption->PlaceHolder = RemoveHtml($this->field_caption->caption());
			$this->field_caption->EditAttrs["class"] = "form-control";
			$this->field_caption->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->field_caption->AdvancedSearch->SearchValue2 = HtmlDecode($this->field_caption->AdvancedSearch->SearchValue2);
			$this->field_caption->EditValue2 = HtmlEncode($this->field_caption->AdvancedSearch->SearchValue2);
			$this->field_caption->PlaceHolder = RemoveHtml($this->field_caption->caption());

			// field_description
			$this->field_description->EditAttrs["class"] = "form-control";
			$this->field_description->EditCustomAttributes = "";
			$this->field_description->EditValue = HtmlEncode($this->field_description->AdvancedSearch->SearchValue);
			$this->field_description->PlaceHolder = RemoveHtml($this->field_description->caption());
			$this->field_description->EditAttrs["class"] = "form-control";
			$this->field_description->EditCustomAttributes = "";
			$this->field_description->EditValue2 = HtmlEncode($this->field_description->AdvancedSearch->SearchValue2);
			$this->field_description->PlaceHolder = RemoveHtml($this->field_description->caption());

			// table_name
			$this->table_name->EditAttrs["class"] = "form-control";
			$this->table_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->table_name->AdvancedSearch->SearchValue = HtmlDecode($this->table_name->AdvancedSearch->SearchValue);
			$this->table_name->EditValue = HtmlEncode($this->table_name->AdvancedSearch->SearchValue);
			$this->table_name->PlaceHolder = RemoveHtml($this->table_name->caption());
			$this->table_name->EditAttrs["class"] = "form-control";
			$this->table_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->table_name->AdvancedSearch->SearchValue2 = HtmlDecode($this->table_name->AdvancedSearch->SearchValue2);
			$this->table_name->EditValue2 = HtmlEncode($this->table_name->AdvancedSearch->SearchValue2);
			$this->table_name->PlaceHolder = RemoveHtml($this->table_name->caption());

			// table_caption
			$this->table_caption->EditAttrs["class"] = "form-control";
			$this->table_caption->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->table_caption->AdvancedSearch->SearchValue = HtmlDecode($this->table_caption->AdvancedSearch->SearchValue);
			$this->table_caption->EditValue = HtmlEncode($this->table_caption->AdvancedSearch->SearchValue);
			$this->table_caption->PlaceHolder = RemoveHtml($this->table_caption->caption());
			$this->table_caption->EditAttrs["class"] = "form-control";
			$this->table_caption->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->table_caption->AdvancedSearch->SearchValue2 = HtmlDecode($this->table_caption->AdvancedSearch->SearchValue2);
			$this->table_caption->EditValue2 = HtmlEncode($this->table_caption->AdvancedSearch->SearchValue2);
			$this->table_caption->PlaceHolder = RemoveHtml($this->table_caption->caption());

			// table_description
			$this->table_description->EditAttrs["class"] = "form-control";
			$this->table_description->EditCustomAttributes = "";
			$this->table_description->EditValue = HtmlEncode($this->table_description->AdvancedSearch->SearchValue);
			$this->table_description->PlaceHolder = RemoveHtml($this->table_description->caption());

			// menu_group
			$this->menu_group->EditAttrs["class"] = "form-control";
			$this->menu_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->menu_group->AdvancedSearch->SearchValue = HtmlDecode($this->menu_group->AdvancedSearch->SearchValue);
			$this->menu_group->EditValue = HtmlEncode($this->menu_group->AdvancedSearch->SearchValue);
			$this->menu_group->PlaceHolder = RemoveHtml($this->menu_group->caption());
			$this->menu_group->EditAttrs["class"] = "form-control";
			$this->menu_group->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->menu_group->AdvancedSearch->SearchValue2 = HtmlDecode($this->menu_group->AdvancedSearch->SearchValue2);
			$this->menu_group->EditValue2 = HtmlEncode($this->menu_group->AdvancedSearch->SearchValue2);
			$this->menu_group->PlaceHolder = RemoveHtml($this->menu_group->caption());

			// menu_description
			$this->menu_description->EditAttrs["class"] = "form-control";
			$this->menu_description->EditCustomAttributes = "";
			$this->menu_description->EditValue = HtmlEncode($this->menu_description->AdvancedSearch->SearchValue);
			$this->menu_description->PlaceHolder = RemoveHtml($this->menu_description->caption());
			$this->menu_description->EditAttrs["class"] = "form-control";
			$this->menu_description->EditCustomAttributes = "";
			$this->menu_description->EditValue2 = HtmlEncode($this->menu_description->AdvancedSearch->SearchValue2);
			$this->menu_description->PlaceHolder = RemoveHtml($this->menu_description->caption());

			// visible
			$this->visible->EditAttrs["class"] = "form-control";
			$this->visible->EditCustomAttributes = "";
			$this->visible->EditValue = $this->visible->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->level->Required) {
			if (!$this->level->IsDetailKey && $this->level->FormValue != NULL && $this->level->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->level->caption(), $this->level->RequiredErrorMessage));
			}
		}
		if ($this->field_name->Required) {
			if (!$this->field_name->IsDetailKey && $this->field_name->FormValue != NULL && $this->field_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->field_name->caption(), $this->field_name->RequiredErrorMessage));
			}
		}
		if ($this->field_caption->Required) {
			if (!$this->field_caption->IsDetailKey && $this->field_caption->FormValue != NULL && $this->field_caption->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->field_caption->caption(), $this->field_caption->RequiredErrorMessage));
			}
		}
		if ($this->field_description->Required) {
			if (!$this->field_description->IsDetailKey && $this->field_description->FormValue != NULL && $this->field_description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->field_description->caption(), $this->field_description->RequiredErrorMessage));
			}
		}
		if ($this->table_name->Required) {
			if (!$this->table_name->IsDetailKey && $this->table_name->FormValue != NULL && $this->table_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->table_name->caption(), $this->table_name->RequiredErrorMessage));
			}
		}
		if ($this->table_caption->Required) {
			if (!$this->table_caption->IsDetailKey && $this->table_caption->FormValue != NULL && $this->table_caption->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->table_caption->caption(), $this->table_caption->RequiredErrorMessage));
			}
		}
		if ($this->table_description->Required) {
			if (!$this->table_description->IsDetailKey && $this->table_description->FormValue != NULL && $this->table_description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->table_description->caption(), $this->table_description->RequiredErrorMessage));
			}
		}
		if ($this->menu_group->Required) {
			if (!$this->menu_group->IsDetailKey && $this->menu_group->FormValue != NULL && $this->menu_group->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->menu_group->caption(), $this->menu_group->RequiredErrorMessage));
			}
		}
		if ($this->menu_description->Required) {
			if (!$this->menu_description->IsDetailKey && $this->menu_description->FormValue != NULL && $this->menu_description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->menu_description->caption(), $this->menu_description->RequiredErrorMessage));
			}
		}
		if ($this->system_notes->Required) {
			if (!$this->system_notes->IsDetailKey && $this->system_notes->FormValue != NULL && $this->system_notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->system_notes->caption(), $this->system_notes->RequiredErrorMessage));
			}
		}
		if ($this->portal_notes->Required) {
			if (!$this->portal_notes->IsDetailKey && $this->portal_notes->FormValue != NULL && $this->portal_notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->portal_notes->caption(), $this->portal_notes->RequiredErrorMessage));
			}
		}
		if ($this->admin_notes->Required) {
			if (!$this->admin_notes->IsDetailKey && $this->admin_notes->FormValue != NULL && $this->admin_notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->admin_notes->caption(), $this->admin_notes->RequiredErrorMessage));
			}
		}
		if ($this->visible->Required) {
			if (!$this->visible->IsDetailKey && $this->visible->FormValue != NULL && $this->visible->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->visible->caption(), $this->visible->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// field_description
			$this->field_description->setDbValueDef($rsnew, $this->field_description->CurrentValue, NULL, $this->field_description->ReadOnly);

			// table_description
			$this->table_description->setDbValueDef($rsnew, $this->table_description->CurrentValue, NULL, $this->table_description->ReadOnly);

			// menu_group
			$this->menu_group->setDbValueDef($rsnew, $this->menu_group->CurrentValue, NULL, $this->menu_group->ReadOnly);

			// menu_description
			$this->menu_description->setDbValueDef($rsnew, $this->menu_description->CurrentValue, NULL, $this->menu_description->ReadOnly);

			// visible
			$this->visible->setDbValueDef($rsnew, $this->visible->CurrentValue, 0, $this->visible->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Load row hash
	protected function loadRowHash()
	{
		$filter = $this->getRecordFilter();

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$rsRow = $conn->Execute($sql);
		$this->HashValue = ($rsRow && !$rsRow->EOF) ? $this->getRowHash($rsRow) : ""; // Get hash value for record
		$rsRow->close();
	}

	// Get Row Hash
	public function getRowHash(&$rs)
	{
		if (!$rs)
			return "";
		$hash = "";
		$hash .= GetFieldHash($rs->fields('field_description')); // field_description
		$hash .= GetFieldHash($rs->fields('table_description')); // table_description
		$hash .= GetFieldHash($rs->fields('menu_group')); // menu_group
		$hash .= GetFieldHash($rs->fields('menu_description')); // menu_description
		$hash .= GetFieldHash($rs->fields('visible')); // visible
		$hash .= GetFieldHash($rs->fields('operator')); // operator
		$hash .= GetFieldHash($rs->fields('datetime')); // datetime
		return md5($hash);
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// level
		$this->level->setDbValueDef($rsnew, $this->level->CurrentValue, 0, strval($this->level->CurrentValue) == "");

		// field_name
		$this->field_name->setDbValueDef($rsnew, $this->field_name->CurrentValue, NULL, FALSE);

		// field_caption
		$this->field_caption->setDbValueDef($rsnew, $this->field_caption->CurrentValue, NULL, FALSE);

		// field_description
		$this->field_description->setDbValueDef($rsnew, $this->field_description->CurrentValue, NULL, FALSE);

		// table_name
		$this->table_name->setDbValueDef($rsnew, $this->table_name->CurrentValue, NULL, FALSE);

		// table_caption
		$this->table_caption->setDbValueDef($rsnew, $this->table_caption->CurrentValue, NULL, FALSE);

		// table_description
		$this->table_description->setDbValueDef($rsnew, $this->table_description->CurrentValue, NULL, FALSE);

		// menu_group
		$this->menu_group->setDbValueDef($rsnew, $this->menu_group->CurrentValue, NULL, FALSE);

		// menu_description
		$this->menu_description->setDbValueDef($rsnew, $this->menu_description->CurrentValue, NULL, FALSE);

		// visible
		$this->visible->setDbValueDef($rsnew, $this->visible->CurrentValue, 0, strval($this->visible->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->level->AdvancedSearch->load();
		$this->field_name->AdvancedSearch->load();
		$this->field_caption->AdvancedSearch->load();
		$this->field_description->AdvancedSearch->load();
		$this->table_name->AdvancedSearch->load();
		$this->table_caption->AdvancedSearch->load();
		$this->table_description->AdvancedSearch->load();
		$this->menu_group->AdvancedSearch->load();
		$this->menu_description->AdvancedSearch->load();
		$this->portal_notes->AdvancedSearch->load();
		$this->visible->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fhelplist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fhelplist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fhelplist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_help\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_help',hdr:ew.language.phrase('ExportToEmailText'),f:document.fhelplist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_operator":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		if ( (isset($_GET['action']) == 'gridedit') )
		{

			//$this->field_description->Visible=false;
			$this->table_description->Visible=false;
			$this->menu_description->Visible=false;
		}

	/*
		IF (CurrentUserID() == '-1')
		{
			$this->admin_notes->Visible = True;
		}
		else
		{
			$this->admin_notes->Visible = False;
		}
		if ((CurrentUserID() == -1) && ($_SERVER["HTTP_HOST"] == 'fibre.intsys.in'))
		{
			$this->level->ReadOnly = True;
			$this->menu_group->ReadOnly = False;
			$this->menu_description->Visible = True;
			$this->table_name->Visible = True;
			$this->table_caption->ReadOnly = True;
			$this->table_description->Visible = True;	
			$this->field_name->Visible = True;
			$this->field_caption->Visible = False;
			$this->field_description->Visible = True;
			$this->system_notes->Visible = True;
			$this->visible->Visible = True;
		}
		else
		{
			$this->level->Visible = False;
			$this->menu_group->ReadOnly = True;
			$this->menu_description->Visible = False;
			$this->table_name->Visible = False;
			$this->table_caption->ReadOnly = True;
			$this->table_description->Visible = False;	
			$this->field_name->Visible = False;
			$this->field_caption->Visible = False;
			$this->field_description->Visible = False;
			$this->system_notes->Visible = False;	
			$this->visible->Visible = False;
		}
		if (CurrentUserID() !=  -1)
		{
			$this->OtherOptions["addedit"]->Items["add"]->Visible = False;
		}
		if (CurrentUserID() == '-1')
		{		
			$item = &$this->OtherOptions['action']->Add("Import from INT_Fibre (Missing)");
			$item->Body = "<a href=\"autoprogramme.php?ac=93e87919d9c89e6459f4fbd0b03b5bc0&apcid=41f3cba68ffb2f2a2181b08abb545f89\" class=\"btn btn-danger ew-action\" style=\"color:blue\">Import from INT_Fibre (Missing)</a>";
		$item->Visible = True;
		}
		*/
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {
		if ( (isset($_GET['action']) == 'gridedit') && ($this->level->CurrentValue == 3) )
		{
			$this->menu_group->ReadOnly=TRUE;
		}
		else
		{
			$this->menu_group->ReadOnly=FALSE;
		}

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	/*	$IDS = ExecuteRow("SELECT ifnull(GROUP_CONCAT(`help`.`id`),0) as `ids` FROM `help` left join `int_fibre_help` on `int_fibre_help`.id = `help`.`id` where `int_fibre_help`.`table_caption` != `help`.`table_caption` || `int_fibre_help`.`id` is null");
	$ID = $IDS['ids'];
	$mismatch =  explode(",", $ID);
		if ((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $mismatch)))
			{
				$this->ListOptions->Add("Update to INT_Fibre (Export)"); // Replace abclink with your name of the link
				$this->ListOptions->Items["Update to INT_Fibre (Export)"]->Body ='<a href="autoprogramme.php?ac=6bd9e83aef373774188a51f80463f37b&apcid=41f3cba68ffb2f2a2181b08abb545f89&id=' . $this->id->CurrentValue . '" data-original-title ="Update to INT_Fibre (Export)"><i data-phrase="Update to INT_Fibre (Export)"  class="fa fa-sign-out ew-icon" style="color:red"></i></a>';
				$NIDS = ExecuteRow("SELECT ifnull(GROUP_CONCAT(`help`.`id`),0) as `ids` FROM `help` left join `int_fibre_help` on `int_fibre_help`.id = `help`.`id` where `int_fibre_help`.`id` is null");
	$NID = $NIDS['ids'];
	$Nmismatch =  explode(",", $NID);
				if (((CurrentUserID() == '-1') && (in_array($this->id->CurrentValue, $Nmismatch))) === false)
				{
					$this->ListOptions->Add("Update from INT_Fibre (Import)"); // Replace abclink with your name of the link
					$this->ListOptions->Items["Update from INT_Fibre (Import)"]->Body ='<a href="autoprogramme.php?ac=fa6c0ebbc86ee0d9d7ed3e7b4fdbf486&apcid=41f3cba68ffb2f2a2181b08abb545f89&id=' . $this->id->CurrentValue . '" data-original-title ="Update from INT_Fibre (Import)"><i data-phrase="Update from INT_Fibre (Import)"  class="fa fa-sign-in ew-icon" style="color:blue"></i></a>';
				}
			//}
		*/	
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>