<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for hs_count_stock
 */
class hs_count_stock extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $jc_no;
	public $emp_id;
	public $product;
	public $rid;
	public $OUT;
	public $item;
	public $item_code;
	public $IN;
	public $Balance;
	public $Shortage;
	public $godown;
	public $outid;
	public $emp_name;
	public $count;
	public $jc_quantity;
	public $jc_no_fp;
	public $count_received;
	public $status;
	public $countID;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'hs_count_stock';
		$this->TableName = 'hs_count_stock';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`hs_count_stock`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// jc_no
		$this->jc_no = new DbField('hs_count_stock', 'hs_count_stock', 'x_jc_no', 'jc_no', '`jc_no`', '`jc_no`', 18, -1, FALSE, '`jc_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->jc_no->Nullable = FALSE; // NOT NULL field
		$this->jc_no->Required = TRUE; // Required field
		$this->jc_no->Sortable = TRUE; // Allow sort
		$this->jc_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->jc_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->jc_no->Lookup = new Lookup('jc_no', 'stock_material_out_emp_hs', FALSE, 'jc_no', ["jc_no","item_code","",""], [], [], [], [], [], [], '`jc_no` ASC', '');
		$this->jc_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no'] = &$this->jc_no;

		// emp_id
		$this->emp_id = new DbField('hs_count_stock', 'hs_count_stock', 'x_emp_id', 'emp_id', '`emp_id`', '`emp_id`', 200, -1, FALSE, '`emp_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->emp_id->Nullable = FALSE; // NOT NULL field
		$this->emp_id->Required = TRUE; // Required field
		$this->emp_id->Sortable = TRUE; // Allow sort
		$this->emp_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->emp_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->emp_id->Lookup = new Lookup('emp_id', 'stock_material_out_emp_hs', FALSE, 'emp_id', ["emp_name","","",""], [], [], [], [], [], [], '`emp_id` ASC', '');
		$this->fields['emp_id'] = &$this->emp_id;

		// product
		$this->product = new DbField('hs_count_stock', 'hs_count_stock', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// rid
		$this->rid = new DbField('hs_count_stock', 'hs_count_stock', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// OUT
		$this->OUT = new DbField('hs_count_stock', 'hs_count_stock', 'x_OUT', 'OUT', '`OUT`', '`OUT`', 131, -1, FALSE, '`OUT`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->OUT->Nullable = FALSE; // NOT NULL field
		$this->OUT->Required = TRUE; // Required field
		$this->OUT->Sortable = TRUE; // Allow sort
		$this->OUT->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['OUT'] = &$this->OUT;

		// item
		$this->item = new DbField('hs_count_stock', 'hs_count_stock', 'x_item', 'item', '`item`', '`item`', 18, -1, FALSE, '`item`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->item->Nullable = FALSE; // NOT NULL field
		$this->item->Required = TRUE; // Required field
		$this->item->Sortable = TRUE; // Allow sort
		$this->fields['item'] = &$this->item;

		// item_code
		$this->item_code = new DbField('hs_count_stock', 'hs_count_stock', 'x_item_code', 'item_code', '`item_code`', '`item_code`', 201, -1, FALSE, '`item_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->item_code->Sortable = TRUE; // Allow sort
		$this->fields['item_code'] = &$this->item_code;

		// IN
		$this->IN = new DbField('hs_count_stock', 'hs_count_stock', 'x_IN', 'IN', '`IN`', '`IN`', 131, -1, FALSE, '`IN`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IN->Required = TRUE; // Required field
		$this->IN->Sortable = TRUE; // Allow sort
		$this->IN->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['IN'] = &$this->IN;

		// Balance
		$this->Balance = new DbField('hs_count_stock', 'hs_count_stock', 'x_Balance', 'Balance', '`Balance`', '`Balance`', 131, -1, FALSE, '`Balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Balance->Required = TRUE; // Required field
		$this->Balance->Sortable = TRUE; // Allow sort
		$this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Balance'] = &$this->Balance;

		// Shortage
		$this->Shortage = new DbField('hs_count_stock', 'hs_count_stock', 'x_Shortage', 'Shortage', '`Shortage`', '`Shortage`', 131, -1, FALSE, '`Shortage`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Shortage->Required = TRUE; // Required field
		$this->Shortage->Sortable = TRUE; // Allow sort
		$this->fields['Shortage'] = &$this->Shortage;

		// godown
		$this->godown = new DbField('hs_count_stock', 'hs_count_stock', 'x_godown', 'godown', '`godown`', '`godown`', 17, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown->Nullable = FALSE; // NOT NULL field
		$this->godown->Required = TRUE; // Required field
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// outid
		$this->outid = new DbField('hs_count_stock', 'hs_count_stock', 'x_outid', 'outid', '`outid`', '`outid`', 18, -1, FALSE, '`outid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->outid->Nullable = FALSE; // NOT NULL field
		$this->outid->Required = TRUE; // Required field
		$this->outid->Sortable = TRUE; // Allow sort
		$this->outid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['outid'] = &$this->outid;

		// emp_name
		$this->emp_name = new DbField('hs_count_stock', 'hs_count_stock', 'x_emp_name', 'emp_name', '`emp_name`', '`emp_name`', 200, -1, FALSE, '`emp_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->emp_name->Nullable = FALSE; // NOT NULL field
		$this->emp_name->Required = TRUE; // Required field
		$this->emp_name->Sortable = TRUE; // Allow sort
		$this->fields['emp_name'] = &$this->emp_name;

		// count
		$this->count = new DbField('hs_count_stock', 'hs_count_stock', 'x_count', 'count', '`count`', '`count`', 2, -1, FALSE, '`count`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->count->Nullable = FALSE; // NOT NULL field
		$this->count->Required = TRUE; // Required field
		$this->count->Sortable = TRUE; // Allow sort
		$this->count->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['count'] = &$this->count;

		// jc_quantity
		$this->jc_quantity = new DbField('hs_count_stock', 'hs_count_stock', 'x_jc_quantity', 'jc_quantity', '`jc_quantity`', '`jc_quantity`', 4, -1, FALSE, '`jc_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_quantity->Required = TRUE; // Required field
		$this->jc_quantity->Sortable = TRUE; // Allow sort
		$this->jc_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['jc_quantity'] = &$this->jc_quantity;

		// jc_no_fp
		$this->jc_no_fp = new DbField('hs_count_stock', 'hs_count_stock', 'x_jc_no_fp', 'jc_no_fp', '`jc_no_fp`', '`jc_no_fp`', 19, -1, FALSE, '`jc_no_fp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->jc_no_fp->Sortable = TRUE; // Allow sort
		$this->jc_no_fp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['jc_no_fp'] = &$this->jc_no_fp;

		// count_received
		$this->count_received = new DbField('hs_count_stock', 'hs_count_stock', 'x_count_received', 'count_received', '`count_received`', '`count_received`', 200, -1, FALSE, '`count_received`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->count_received->Nullable = FALSE; // NOT NULL field
		$this->count_received->Required = TRUE; // Required field
		$this->count_received->Sortable = TRUE; // Allow sort
		$this->count_received->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['count_received'] = &$this->count_received;

		// status
		$this->status = new DbField('hs_count_stock', 'hs_count_stock', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// countID
		$this->countID = new DbField('hs_count_stock', 'hs_count_stock', 'x_countID', 'countID', '`countID`', '`countID`', 201, -1, FALSE, '`countID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->countID->Nullable = FALSE; // NOT NULL field
		$this->countID->Required = TRUE; // Required field
		$this->countID->Sortable = TRUE; // Allow sort
		$this->countID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['countID'] = &$this->countID;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`hs_count_stock`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->jc_no->DbValue = $row['jc_no'];
		$this->emp_id->DbValue = $row['emp_id'];
		$this->product->DbValue = $row['product'];
		$this->rid->DbValue = $row['rid'];
		$this->OUT->DbValue = $row['OUT'];
		$this->item->DbValue = $row['item'];
		$this->item_code->DbValue = $row['item_code'];
		$this->IN->DbValue = $row['IN'];
		$this->Balance->DbValue = $row['Balance'];
		$this->Shortage->DbValue = $row['Shortage'];
		$this->godown->DbValue = $row['godown'];
		$this->outid->DbValue = $row['outid'];
		$this->emp_name->DbValue = $row['emp_name'];
		$this->count->DbValue = $row['count'];
		$this->jc_quantity->DbValue = $row['jc_quantity'];
		$this->jc_no_fp->DbValue = $row['jc_no_fp'];
		$this->count_received->DbValue = $row['count_received'];
		$this->status->DbValue = $row['status'];
		$this->countID->DbValue = $row['countID'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "hs_count_stocklist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "hs_count_stockview.php")
			return $Language->phrase("View");
		elseif ($pageName == "hs_count_stockedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "hs_count_stockadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "hs_count_stocklist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("hs_count_stockview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("hs_count_stockview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "hs_count_stockadd.php?" . $this->getUrlParm($parm);
		else
			$url = "hs_count_stockadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("hs_count_stockedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("hs_count_stockadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("hs_count_stockdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->jc_no->setDbValue($rs->fields('jc_no'));
		$this->emp_id->setDbValue($rs->fields('emp_id'));
		$this->product->setDbValue($rs->fields('product'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->OUT->setDbValue($rs->fields('OUT'));
		$this->item->setDbValue($rs->fields('item'));
		$this->item_code->setDbValue($rs->fields('item_code'));
		$this->IN->setDbValue($rs->fields('IN'));
		$this->Balance->setDbValue($rs->fields('Balance'));
		$this->Shortage->setDbValue($rs->fields('Shortage'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->outid->setDbValue($rs->fields('outid'));
		$this->emp_name->setDbValue($rs->fields('emp_name'));
		$this->count->setDbValue($rs->fields('count'));
		$this->jc_quantity->setDbValue($rs->fields('jc_quantity'));
		$this->jc_no_fp->setDbValue($rs->fields('jc_no_fp'));
		$this->count_received->setDbValue($rs->fields('count_received'));
		$this->status->setDbValue($rs->fields('status'));
		$this->countID->setDbValue($rs->fields('countID'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// jc_no
		// emp_id
		// product
		// rid
		// OUT
		// item
		// item_code
		// IN
		// Balance
		// Shortage
		// godown
		// outid
		// emp_name
		// count
		// jc_quantity
		// jc_no_fp
		// count_received
		// status
		// countID
		// jc_no

		$curVal = strval($this->jc_no->CurrentValue);
		if ($curVal <> "") {
			$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
			if ($this->jc_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`jc_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
				}
			}
		} else {
			$this->jc_no->ViewValue = NULL;
		}
		$this->jc_no->ViewCustomAttributes = "";

		// emp_id
		$curVal = strval($this->emp_id->CurrentValue);
		if ($curVal <> "") {
			$this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
			if ($this->emp_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`emp_id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->emp_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->emp_id->ViewValue = $this->emp_id->CurrentValue;
				}
			}
		} else {
			$this->emp_id->ViewValue = NULL;
		}
		$this->emp_id->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
		$this->product->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$this->rid->ViewValue = FormatNumber($this->rid->ViewValue, 0, -2, -2, -2);
		$this->rid->ViewCustomAttributes = "";

		// OUT
		$this->OUT->ViewValue = $this->OUT->CurrentValue;
		$this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, 2, -2, -2, -2);
		$this->OUT->ViewCustomAttributes = "";

		// item
		$this->item->ViewValue = $this->item->CurrentValue;
		$this->item->ViewCustomAttributes = "";

		// item_code
		$this->item_code->ViewValue = $this->item_code->CurrentValue;
		$this->item_code->ViewCustomAttributes = "";

		// IN
		$this->IN->ViewValue = $this->IN->CurrentValue;
		$this->IN->ViewValue = FormatNumber($this->IN->ViewValue, 2, -2, -2, -2);
		$this->IN->ViewCustomAttributes = "";

		// Balance
		$this->Balance->ViewValue = $this->Balance->CurrentValue;
		$this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, 2, -2, -2, -2);
		$this->Balance->ViewCustomAttributes = "";

		// Shortage
		$this->Shortage->ViewValue = $this->Shortage->CurrentValue;
		$this->Shortage->ViewCustomAttributes = "";

		// godown
		$this->godown->ViewValue = $this->godown->CurrentValue;
		$this->godown->ViewValue = FormatNumber($this->godown->ViewValue, 0, -2, -2, -2);
		$this->godown->ViewCustomAttributes = "";

		// outid
		$this->outid->ViewValue = $this->outid->CurrentValue;
		$this->outid->ViewValue = FormatNumber($this->outid->ViewValue, 0, -2, -2, -2);
		$this->outid->ViewCustomAttributes = "";

		// emp_name
		$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
		$this->emp_name->ViewCustomAttributes = "";

		// count
		$this->count->ViewValue = $this->count->CurrentValue;
		$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
		$this->count->ViewCustomAttributes = "";

		// jc_quantity
		$this->jc_quantity->ViewValue = $this->jc_quantity->CurrentValue;
		$this->jc_quantity->ViewValue = FormatNumber($this->jc_quantity->ViewValue, 2, -2, -2, -2);
		$this->jc_quantity->ViewCustomAttributes = "";

		// jc_no_fp
		$this->jc_no_fp->ViewValue = $this->jc_no_fp->CurrentValue;
		$this->jc_no_fp->ViewValue = FormatNumber($this->jc_no_fp->ViewValue, 0, -2, -2, -2);
		$this->jc_no_fp->ViewCustomAttributes = "";

		// count_received
		$this->count_received->ViewValue = $this->count_received->CurrentValue;
		$this->count_received->ViewCustomAttributes = "";

		// status
		$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
		$this->status->ViewCustomAttributes = "";

		// countID
		$this->countID->ViewValue = $this->countID->CurrentValue;
		$this->countID->ViewCustomAttributes = "";

		// jc_no
		$this->jc_no->LinkCustomAttributes = "";
		$this->jc_no->HrefValue = "";
		$this->jc_no->TooltipValue = "";

		// emp_id
		$this->emp_id->LinkCustomAttributes = "";
		$this->emp_id->HrefValue = "";
		$this->emp_id->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// OUT
		$this->OUT->LinkCustomAttributes = "";
		$this->OUT->HrefValue = "";
		$this->OUT->TooltipValue = "";

		// item
		$this->item->LinkCustomAttributes = "";
		$this->item->HrefValue = "";
		$this->item->TooltipValue = "";

		// item_code
		$this->item_code->LinkCustomAttributes = "";
		$this->item_code->HrefValue = "";
		$this->item_code->TooltipValue = "";

		// IN
		$this->IN->LinkCustomAttributes = "";
		$this->IN->HrefValue = "";
		$this->IN->TooltipValue = "";

		// Balance
		$this->Balance->LinkCustomAttributes = "";
		$this->Balance->HrefValue = "";
		$this->Balance->TooltipValue = "";

		// Shortage
		$this->Shortage->LinkCustomAttributes = "";
		$this->Shortage->HrefValue = "";
		$this->Shortage->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		$this->godown->HrefValue = "";
		$this->godown->TooltipValue = "";

		// outid
		$this->outid->LinkCustomAttributes = "";
		$this->outid->HrefValue = "";
		$this->outid->TooltipValue = "";

		// emp_name
		$this->emp_name->LinkCustomAttributes = "";
		$this->emp_name->HrefValue = "";
		$this->emp_name->TooltipValue = "";

		// count
		$this->count->LinkCustomAttributes = "";
		$this->count->HrefValue = "";
		$this->count->TooltipValue = "";

		// jc_quantity
		$this->jc_quantity->LinkCustomAttributes = "";
		$this->jc_quantity->HrefValue = "";
		$this->jc_quantity->TooltipValue = "";

		// jc_no_fp
		$this->jc_no_fp->LinkCustomAttributes = "";
		$this->jc_no_fp->HrefValue = "";
		$this->jc_no_fp->TooltipValue = "";

		// count_received
		$this->count_received->LinkCustomAttributes = "";
		$this->count_received->HrefValue = "";
		$this->count_received->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// countID
		$this->countID->LinkCustomAttributes = "";
		$this->countID->HrefValue = "";
		$this->countID->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// jc_no
		$this->jc_no->EditAttrs["class"] = "form-control";
		$this->jc_no->EditCustomAttributes = "";

		// emp_id
		$this->emp_id->EditAttrs["class"] = "form-control";
		$this->emp_id->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// OUT
		$this->OUT->EditAttrs["class"] = "form-control";
		$this->OUT->EditCustomAttributes = "";
		$this->OUT->EditValue = $this->OUT->CurrentValue;
		$this->OUT->PlaceHolder = RemoveHtml($this->OUT->caption());
		if (strval($this->OUT->EditValue) <> "" && is_numeric($this->OUT->EditValue))
			$this->OUT->EditValue = FormatNumber($this->OUT->EditValue, -2, -2, -2, -2);

		// item
		$this->item->EditAttrs["class"] = "form-control";
		$this->item->EditCustomAttributes = "";
		$this->item->EditValue = $this->item->CurrentValue;
		$this->item->PlaceHolder = RemoveHtml($this->item->caption());

		// item_code
		$this->item_code->EditAttrs["class"] = "form-control";
		$this->item_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->item_code->CurrentValue = HtmlDecode($this->item_code->CurrentValue);
		$this->item_code->EditValue = $this->item_code->CurrentValue;
		$this->item_code->PlaceHolder = RemoveHtml($this->item_code->caption());

		// IN
		$this->IN->EditAttrs["class"] = "form-control";
		$this->IN->EditCustomAttributes = "";
		$this->IN->EditValue = $this->IN->CurrentValue;
		$this->IN->PlaceHolder = RemoveHtml($this->IN->caption());
		if (strval($this->IN->EditValue) <> "" && is_numeric($this->IN->EditValue))
			$this->IN->EditValue = FormatNumber($this->IN->EditValue, -2, -2, -2, -2);

		// Balance
		$this->Balance->EditAttrs["class"] = "form-control";
		$this->Balance->EditCustomAttributes = "";
		$this->Balance->EditValue = $this->Balance->CurrentValue;
		$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
		if (strval($this->Balance->EditValue) <> "" && is_numeric($this->Balance->EditValue))
			$this->Balance->EditValue = FormatNumber($this->Balance->EditValue, -2, -2, -2, -2);

		// Shortage
		$this->Shortage->EditAttrs["class"] = "form-control";
		$this->Shortage->EditCustomAttributes = "";
		$this->Shortage->EditValue = $this->Shortage->CurrentValue;
		$this->Shortage->PlaceHolder = RemoveHtml($this->Shortage->caption());
		if (strval($this->Shortage->EditValue) <> "" && is_numeric($this->Shortage->EditValue))
			$this->Shortage->EditValue = FormatNumber($this->Shortage->EditValue, -2, -1, -2, 0);

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";
		$this->godown->EditValue = $this->godown->CurrentValue;
		$this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

		// outid
		$this->outid->EditAttrs["class"] = "form-control";
		$this->outid->EditCustomAttributes = "";
		$this->outid->EditValue = $this->outid->CurrentValue;
		$this->outid->PlaceHolder = RemoveHtml($this->outid->caption());

		// emp_name
		$this->emp_name->EditAttrs["class"] = "form-control";
		$this->emp_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->emp_name->CurrentValue = HtmlDecode($this->emp_name->CurrentValue);
		$this->emp_name->EditValue = $this->emp_name->CurrentValue;
		$this->emp_name->PlaceHolder = RemoveHtml($this->emp_name->caption());

		// count
		$this->count->EditAttrs["class"] = "form-control";
		$this->count->EditCustomAttributes = "";
		$this->count->EditValue = $this->count->CurrentValue;
		$this->count->PlaceHolder = RemoveHtml($this->count->caption());

		// jc_quantity
		$this->jc_quantity->EditAttrs["class"] = "form-control";
		$this->jc_quantity->EditCustomAttributes = "";
		$this->jc_quantity->EditValue = $this->jc_quantity->CurrentValue;
		$this->jc_quantity->PlaceHolder = RemoveHtml($this->jc_quantity->caption());
		if (strval($this->jc_quantity->EditValue) <> "" && is_numeric($this->jc_quantity->EditValue))
			$this->jc_quantity->EditValue = FormatNumber($this->jc_quantity->EditValue, -2, -2, -2, -2);

		// jc_no_fp
		$this->jc_no_fp->EditAttrs["class"] = "form-control";
		$this->jc_no_fp->EditCustomAttributes = "";
		$this->jc_no_fp->EditValue = $this->jc_no_fp->CurrentValue;
		$this->jc_no_fp->PlaceHolder = RemoveHtml($this->jc_no_fp->caption());

		// count_received
		$this->count_received->EditAttrs["class"] = "form-control";
		$this->count_received->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
		$this->count_received->EditValue = $this->count_received->CurrentValue;
		$this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// countID
		$this->countID->EditAttrs["class"] = "form-control";
		$this->countID->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->countID->CurrentValue = HtmlDecode($this->countID->CurrentValue);
		$this->countID->EditValue = $this->countID->CurrentValue;
		$this->countID->PlaceHolder = RemoveHtml($this->countID->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->emp_id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->item_code);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->Shortage);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->outid);
					$doc->exportCaption($this->emp_name);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->jc_quantity);
					$doc->exportCaption($this->jc_no_fp);
					$doc->exportCaption($this->count_received);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->countID);
				} else {
					$doc->exportCaption($this->jc_no);
					$doc->exportCaption($this->emp_id);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->item_code);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->Shortage);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->outid);
					$doc->exportCaption($this->emp_name);
					$doc->exportCaption($this->count);
					$doc->exportCaption($this->jc_quantity);
					$doc->exportCaption($this->jc_no_fp);
					$doc->exportCaption($this->count_received);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->countID);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->jc_no);
						$doc->exportField($this->emp_id);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->OUT);
						$doc->exportField($this->item);
						$doc->exportField($this->item_code);
						$doc->exportField($this->IN);
						$doc->exportField($this->Balance);
						$doc->exportField($this->Shortage);
						$doc->exportField($this->godown);
						$doc->exportField($this->outid);
						$doc->exportField($this->emp_name);
						$doc->exportField($this->count);
						$doc->exportField($this->jc_quantity);
						$doc->exportField($this->jc_no_fp);
						$doc->exportField($this->count_received);
						$doc->exportField($this->status);
						$doc->exportField($this->countID);
					} else {
						$doc->exportField($this->jc_no);
						$doc->exportField($this->emp_id);
						$doc->exportField($this->product);
						$doc->exportField($this->rid);
						$doc->exportField($this->OUT);
						$doc->exportField($this->item);
						$doc->exportField($this->item_code);
						$doc->exportField($this->IN);
						$doc->exportField($this->Balance);
						$doc->exportField($this->Shortage);
						$doc->exportField($this->godown);
						$doc->exportField($this->outid);
						$doc->exportField($this->emp_name);
						$doc->exportField($this->count);
						$doc->exportField($this->jc_quantity);
						$doc->exportField($this->jc_no_fp);
						$doc->exportField($this->count_received);
						$doc->exportField($this->status);
						$doc->exportField($this->countID);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>