<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class index
{

	// Page ID
	public $PageID = "index";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Page object name
	public $PageObjName = "index";

	// Page headings
	public $Heading = "";
	public $Subheading = "";

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'index');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &GetConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$Breadcrumb;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
		}

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();
		$Breadcrumb = new Breadcrumb();

		// If session expired, show session expired message
		if (Get("expired") == "1")
			$this->setFailureMessage($Language->phrase("SessionExpired"));
		if (!$Security->isLoggedIn())
			$Security->autoLogin();
		$Security->loadUserLevel(); // Load User Level
		if ($Security->allowList(CurrentProjectID() . 'db.php'))
			$this->terminate("db.php"); // Exit and go to default page
		if ($Security->allowList(CurrentProjectID() . '.htaccess'))
			$this->terminate("./.htaccess");
		if ($Security->allowList(CurrentProjectID() . 'account_grp'))
			$this->terminate("account_grplist.php");
		if ($Security->allowList(CurrentProjectID() . 'account_info'))
			$this->terminate("account_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'account_type'))
			$this->terminate("account_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'add_optional'))
			$this->terminate("add_optionallist.php");
		if ($Security->allowList(CurrentProjectID() . 'admin'))
			$this->terminate("adminlist.php");
		if ($Security->allowList(CurrentProjectID() . 'admin_category'))
			$this->terminate("admin_categorylist.php");
		if ($Security->allowList(CurrentProjectID() . 'agent'))
			$this->terminate("agentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'apc'))
			$this->terminate("apclist.php");
		if ($Security->allowList(CurrentProjectID() . 'apc_grp'))
			$this->terminate("apc_grplist.php");
		if ($Security->allowList(CurrentProjectID() . 'apc_pfv'))
			$this->terminate("apc_pfvlist.php");
		if ($Security->allowList(CurrentProjectID() . 'apcajax.php'))
			$this->terminate("./apcajax.php");
		if ($Security->allowList(CurrentProjectID() . 'apcajax_2.php'))
			$this->terminate("./apcajax_2.php");
		if ($Security->allowList(CurrentProjectID() . 'apcajax_fm.php'))
			$this->terminate("./apcajax_fm.php");
		if ($Security->allowList(CurrentProjectID() . 'apcajax_fs.php'))
			$this->terminate("./apcajax_fs.php");
		if ($Security->allowList(CurrentProjectID() . 'apcajax_tc.php'))
			$this->terminate("./apcajax_tc.php");
		if ($Security->allowList(CurrentProjectID() . 'apcajaxes.php'))
			$this->terminate("./apcajaxes.php");
		if ($Security->allowList(CurrentProjectID() . 'app.php'))
			$this->terminate("./app.php");
		if ($Security->allowList(CurrentProjectID() . 'assign_process.php'))
			$this->terminate("./assign_process.php");
		if ($Security->allowList(CurrentProjectID() . 'assign_production.php'))
			$this->terminate("./assign_production.php");
		if ($Security->allowList(CurrentProjectID() . 'audittrail'))
			$this->terminate("audittraillist.php");
		if ($Security->allowList(CurrentProjectID() . 'audittrail_l'))
			$this->terminate("audittrail_llist.php");
		if ($Security->allowList(CurrentProjectID() . 'audittrail_u'))
			$this->terminate("audittrail_ulist.php");
		if ($Security->allowList(CurrentProjectID() . 'auto_programme'))
			$this->terminate("auto_programmelist.php");
		if ($Security->allowList(CurrentProjectID() . 'autoprogramme.php'))
			$this->terminate("./autoprogramme.php");
		if ($Security->allowList(CurrentProjectID() . 'autoprogrammenhf.php'))
			$this->terminate("./autoprogrammenhf.php");
		if ($Security->allowList(CurrentProjectID() . 'b_account_compiled'))
			$this->terminate("b_account_compiledlist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_account_info'))
			$this->terminate("b_account_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_account_info_agent'))
			$this->terminate("b_account_info_agentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_account_int_log'))
			$this->terminate("b_account_int_loglist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_account_int_log_tmp'))
			$this->terminate("b_account_int_log_tmplist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_account_type'))
			$this->terminate("b_account_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_charges_plan'))
			$this->terminate("b_charges_planlist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_incentive'))
			$this->terminate("b_incentivelist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_incentive_pp'))
			$this->terminate("b_incentive_pplist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_status'))
			$this->terminate("b_statuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'b_status_view'))
			$this->terminate("_b_status_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'balance'))
			$this->terminate("balancelist.php");
		if ($Security->allowList(CurrentProjectID() . 'balance_detailed'))
			$this->terminate("balance_detailedlist.php");
		if ($Security->allowList(CurrentProjectID() . 'bank'))
			$this->terminate("banklist.php");
		if ($Security->allowList(CurrentProjectID() . 'bank_info'))
			$this->terminate("_bank_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'banner'))
			$this->terminate("bannerlist.php");
		if ($Security->allowList(CurrentProjectID() . 'barcode'))
			$this->terminate("_barcodelist.php");
		if ($Security->allowList(CurrentProjectID() . 'barcode_in_process'))
			$this->terminate("barcode_in_processlist.php");
		if ($Security->allowList(CurrentProjectID() . 'barcode_print'))
			$this->terminate("barcode_printlist.php");
		if ($Security->allowList(CurrentProjectID() . 'barcode_query'))
			$this->terminate("barcode_querylist.php");
		if ($Security->allowList(CurrentProjectID() . 'batch_no'))
			$this->terminate("batch_nolist.php");
		if ($Security->allowList(CurrentProjectID() . 'bcode'))
			$this->terminate("bcodelist.php");
		if ($Security->allowList(CurrentProjectID() . 'bcode_old'))
			$this->terminate("bcode_oldlist.php");
		if ($Security->allowList(CurrentProjectID() . 'bcode_s'))
			$this->terminate("bcode_slist.php");
		if ($Security->allowList(CurrentProjectID() . 'bcode_token'))
			$this->terminate("bcode_tokenlist.php");
		if ($Security->allowList(CurrentProjectID() . 'blending_process_f'))
			$this->terminate("blending_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'blending_table'))
			$this->terminate("blending_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'bom'))
			$this->terminate("bomlist.php");
		if ($Security->allowList(CurrentProjectID() . 'bom_f'))
			$this->terminate("bom_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'bom_fp'))
			$this->terminate("bom_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'booking'))
			$this->terminate("bookinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'booking_details'))
			$this->terminate("booking_detailslist.php");
		if ($Security->allowList(CurrentProjectID() . 'booking_ref'))
			$this->terminate("booking_reflist.php");
		if ($Security->allowList(CurrentProjectID() . 'buyer'))
			$this->terminate("buyerlist.php");
		if ($Security->allowList(CurrentProjectID() . 'buyer_product_ref_fp'))
			$this->terminate("buyer_product_ref_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'buyer_product_ref_g'))
			$this->terminate("buyer_product_ref_glist.php");
		if ($Security->allowList(CurrentProjectID() . 'buyer_sales'))
			$this->terminate("buyer_saleslist.php");
		if ($Security->allowList(CurrentProjectID() . 'buyer_seller_employee'))
			$this->terminate("buyer_seller_employeelist.php");
		if ($Security->allowList(CurrentProjectID() . 'buyer_seller_view'))
			$this->terminate("buyer_seller_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'bwfpbgvy.php'))
			$this->terminate("./bwfpbgvy.php");
		if ($Security->allowList(CurrentProjectID() . 'c_charge'))
			$this->terminate("c_chargelist.php");
		if ($Security->allowList(CurrentProjectID() . 'capacity_plan'))
			$this->terminate("capacity_planlist.php");
		if ($Security->allowList(CurrentProjectID() . 'carpet_setup'))
			$this->terminate("carpet_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'cha_agent'))
			$this->terminate("cha_agentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'check_security.php'))
			$this->terminate("./check_security.php");
		if ($Security->allowList(CurrentProjectID() . 'client_category'))
			$this->terminate("client_categorylist.php");
		if ($Security->allowList(CurrentProjectID() . 'client_db'))
			$this->terminate("client_dblist.php");
		if ($Security->allowList(CurrentProjectID() . 'client_hardware_data'))
			$this->terminate("client_hardware_datalist.php");
		if ($Security->allowList(CurrentProjectID() . 'code_exchange'))
			$this->terminate("code_exchangelist.php");
		if ($Security->allowList(CurrentProjectID() . 'collection_log'))
			$this->terminate("collection_loglist.php");
		if ($Security->allowList(CurrentProjectID() . 'complete_process.php'))
			$this->terminate("./complete_process.php");
		if ($Security->allowList(CurrentProjectID() . 'composition'))
			$this->terminate("compositionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'cost_calculator'))
			$this->terminate("cost_calculatorlist.php");
		if ($Security->allowList(CurrentProjectID() . 'cost_calculator_detailed'))
			$this->terminate("cost_calculator_detailedlist.php");
		if ($Security->allowList(CurrentProjectID() . 'csv_import'))
			$this->terminate("csv_importlist.php");
		if ($Security->allowList(CurrentProjectID() . 'currency'))
			$this->terminate("currencylist.php");
		if ($Security->allowList(CurrentProjectID() . 'customized_message'))
			$this->terminate("customized_messagelist.php");
		if ($Security->allowList(CurrentProjectID() . 'd_03'))
			$this->terminate("d_03list.php");
		if ($Security->allowList(CurrentProjectID() . 'd_04'))
			$this->terminate("d_04list.php");
		if ($Security->allowList(CurrentProjectID() . 'd_05'))
			$this->terminate("d_05list.php");
		if ($Security->allowList(CurrentProjectID() . 'd_06'))
			$this->terminate("d_06list.php");
		if ($Security->allowList(CurrentProjectID() . 'd_b_view'))
			$this->terminate("d_b_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'dashboard'))
			$this->terminate("dashboardlist.php");
		if ($Security->allowList(CurrentProjectID() . 'description'))
			$this->terminate("descriptionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'download'))
			$this->terminate("downloadlist.php");
		if ($Security->allowList(CurrentProjectID() . 'dummy.php'))
			$this->terminate("./dummy.php");
		if ($Security->allowList(CurrentProjectID() . 'dyeing_dw'))
			$this->terminate("dyeing_dwlist.php");
		if ($Security->allowList(CurrentProjectID() . 'dyeing_process_f'))
			$this->terminate("dyeing_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'dyeing_process_shortage'))
			$this->terminate("dyeing_process_shortagelist.php");
		if ($Security->allowList(CurrentProjectID() . 'dyeing_table'))
			$this->terminate("dyeing_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'dyeing_type'))
			$this->terminate("dyeing_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'emi_calculator.php'))
			$this->terminate("./emi_calculator.php");
		if ($Security->allowList(CurrentProjectID() . 'emp_payment_hs'))
			$this->terminate("emp_payment_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'employee_card.php'))
			$this->terminate("./employee_card.php");
		if ($Security->allowList(CurrentProjectID() . 'fe_setup'))
			$this->terminate("fe_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'gallery'))
			$this->terminate("gallerylist.php");
		if ($Security->allowList(CurrentProjectID() . 'gallery_misc'))
			$this->terminate("gallery_misclist.php");
		if ($Security->allowList(CurrentProjectID() . 'gate_pass'))
			$this->terminate("gate_passlist.php");
		if ($Security->allowList(CurrentProjectID() . 'gate_pass_print_hsc_fp.php'))
			$this->terminate("./gate_pass_print_hsc_fp.php");
		if ($Security->allowList(CurrentProjectID() . 'gate_pass_received'))
			$this->terminate("gate_pass_receivedlist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown'))
			$this->terminate("godownlist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_table'))
			$this->terminate("godown_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_dw'))
			$this->terminate("godown_transfer_dwlist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_fp'))
			$this->terminate("godown_transfer_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_hs'))
			$this->terminate("godown_transfer_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_new'))
			$this->terminate("godown_transfer_newlist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_new_fp'))
			$this->terminate("godown_transfer_new_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_new_hs'))
			$this->terminate("godown_transfer_new_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_process_f'))
			$this->terminate("godown_transfer_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'godown_transfer_table'))
			$this->terminate("godown_transfer_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'grp'))
			$this->terminate("grplist.php");
		if ($Security->allowList(CurrentProjectID() . 'gst_challan.php'))
			$this->terminate("./gst_challan.php");
		if ($Security->allowList(CurrentProjectID() . 'gst_challan_extra.php'))
			$this->terminate("./gst_challan_extra.php");
		if ($Security->allowList(CurrentProjectID() . 'gst_challan_f.php'))
			$this->terminate("./gst_challan_f.php");
		if ($Security->allowList(CurrentProjectID() . 'gst_challan_g.php'))
			$this->terminate("./gst_challan_g.php");
		if ($Security->allowList(CurrentProjectID() . 'help'))
			$this->terminate("helplist.php");
		if ($Security->allowList(CurrentProjectID() . 'home'))
			$this->terminate("homelist.php");
		if ($Security->allowList(CurrentProjectID() . 'hs_count_stock'))
			$this->terminate("hs_count_stocklist.php");
		if ($Security->allowList(CurrentProjectID() . 'hs_stock_product'))
			$this->terminate("hs_stock_productlist.php");
		if ($Security->allowList(CurrentProjectID() . 'import_bcode'))
			$this->terminate("import_bcodelist.php");
		if ($Security->allowList(CurrentProjectID() . 'import_csv.php'))
			$this->terminate("./import_csv.php");
		if ($Security->allowList(CurrentProjectID() . 'importer'))
			$this->terminate("importerlist.php");
		if ($Security->allowList(CurrentProjectID() . 'incoterm'))
			$this->terminate("incotermlist.php");
		if ($Security->allowList(CurrentProjectID() . 'int_fibre_account_grp'))
			$this->terminate("int_fibre_account_grplist.php");
		if ($Security->allowList(CurrentProjectID() . 'int_fibre_help'))
			$this->terminate("int_fibre_helplist.php");
		if ($Security->allowList(CurrentProjectID() . 'int_fibre_packing_type'))
			$this->terminate("int_fibre_packing_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'int_portal_list'))
			$this->terminate("int_portal_listlist.php");
		if ($Security->allowList(CurrentProjectID() . 'int_portal_updates'))
			$this->terminate("int_portal_updateslist.php");
		if ($Security->allowList(CurrentProjectID() . 'int_shop'))
			$this->terminate("int_shoplist.php");
		if ($Security->allowList(CurrentProjectID() . 'investor_info'))
			$this->terminate("investor_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'investor_list'))
			$this->terminate("investor_listlist.php");
		if ($Security->allowList(CurrentProjectID() . 'invoice_details'))
			$this->terminate("invoice_detailslist.php");
		if ($Security->allowList(CurrentProjectID() . 'jc_mrlot'))
			$this->terminate("jc_mrlotlist.php");
		if ($Security->allowList(CurrentProjectID() . 'job_card'))
			$this->terminate("job_cardlist.php");
		if ($Security->allowList(CurrentProjectID() . 'job_card_bc'))
			$this->terminate("job_card_bclist.php");
		if ($Security->allowList(CurrentProjectID() . 'job_card_description'))
			$this->terminate("job_card_descriptionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'job_card_f'))
			$this->terminate("job_card_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'job_card_fp'))
			$this->terminate("job_card_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'job_card_hs'))
			$this->terminate("job_card_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'job_card_pending_query'))
			$this->terminate("job_card_pending_querylist.php");
		if ($Security->allowList(CurrentProjectID() . 'journal'))
			$this->terminate("journallist.php");
		if ($Security->allowList(CurrentProjectID() . 'KiogUmVwbGFjZSBGaWxl.php'))
			$this->terminate("./KiogUmVwbGFjZSBGaWxl.php");
		if ($Security->allowList(CurrentProjectID() . 'l_examination'))
			$this->terminate("l_examinationlist.php");
		if ($Security->allowList(CurrentProjectID() . 'l_examination_report'))
			$this->terminate("_l_examination_reportlist.php");
		if ($Security->allowList(CurrentProjectID() . 'l_examination_type'))
			$this->terminate("l_examination_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'l_pending_examination'))
			$this->terminate("l_pending_examinationlist.php");
		if ($Security->allowList(CurrentProjectID() . 'l_receipt'))
			$this->terminate("l_receiptlist.php");
		if ($Security->allowList(CurrentProjectID() . 'l_referral'))
			$this->terminate("l_referrallist.php");
		if ($Security->allowList(CurrentProjectID() . 'ledger'))
			$this->terminate("ledgerlist.php");
		if ($Security->allowList(CurrentProjectID() . 'loginip'))
			$this->terminate("loginiplist.php");
		if ($Security->allowList(CurrentProjectID() . 'loom_info'))
			$this->terminate("loom_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'mail_record'))
			$this->terminate("mail_recordlist.php");
		if ($Security->allowList(CurrentProjectID() . 'mail_setup'))
			$this->terminate("mail_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'mailer_cron'))
			$this->terminate("mailer_cronlist.php");
		if ($Security->allowList(CurrentProjectID() . 'mailer_view.php'))
			$this->terminate("./mailer_view.php");
		if ($Security->allowList(CurrentProjectID() . 'margin_list'))
			$this->terminate("margin_listlist.php");
		if ($Security->allowList(CurrentProjectID() . 'margin_list_monthly'))
			$this->terminate("margin_list_monthlylist.php");
		if ($Security->allowList(CurrentProjectID() . 'material order'))
			$this->terminate("material_orderlist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_out'))
			$this->terminate("material_outlist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_out_bc'))
			$this->terminate("material_out_bclist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_out_f'))
			$this->terminate("material_out_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_out_fp'))
			$this->terminate("material_out_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_out_hs'))
			$this->terminate("material_out_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_out_po'))
			$this->terminate("material_out_polist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_out_wbc'))
			$this->terminate("material_out_wbclist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required'))
			$this->terminate("material_requiredlist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_export'))
			$this->terminate("material_required_exportlist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_issue'))
			$this->terminate("material_required_issuelist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_issue_fp'))
			$this->terminate("material_required_issue_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_job_card'))
			$this->terminate("material_required_job_cardlist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_live'))
			$this->terminate("material_required_livelist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_monthly_cross_company'))
			$this->terminate("material_required_monthly_cross_companylist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_processing_outside'))
			$this->terminate("material_required_processing_outsidelist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_weekly'))
			$this->terminate("material_required_weeklylist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_weekly_loomplan'))
			$this->terminate("material_required_weekly_loomplanlist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_required_weekly_loomplan_short'))
			$this->terminate("material_required_weekly_loomplan_shortlist.php");
		if ($Security->allowList(CurrentProjectID() . 'material_status'))
			$this->terminate("material_statuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'member_info'))
			$this->terminate("member_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'menus'))
			$this->terminate("menuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'message_template_admin'))
			$this->terminate("message_template_adminlist.php");
		if ($Security->allowList(CurrentProjectID() . 'message_template_office'))
			$this->terminate("message_template_officelist.php");
		if ($Security->allowList(CurrentProjectID() . 'message_type'))
			$this->terminate("message_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'method'))
			$this->terminate("methodlist.php");
		if ($Security->allowList(CurrentProjectID() . 'mgs_certificate'))
			$this->terminate("mgs_certificatelist.php");
		if ($Security->allowList(CurrentProjectID() . 'mgs_certificate_data'))
			$this->terminate("mgs_certificate_datalist.php");
		if ($Security->allowList(CurrentProjectID() . 'mgs_mail.php'))
			$this->terminate("./mgs_mail.php");
		if ($Security->allowList(CurrentProjectID() . 'minimum_inventory_level'))
			$this->terminate("minimum_inventory_levellist.php");
		if ($Security->allowList(CurrentProjectID() . 'misc'))
			$this->terminate("misclist.php");
		if ($Security->allowList(CurrentProjectID() . 'misc_items'))
			$this->terminate("misc_itemslist.php");
		if ($Security->allowList(CurrentProjectID() . 'misc_items_cost'))
			$this->terminate("misc_items_costlist.php");
		if ($Security->allowList(CurrentProjectID() . 'mlogin.php'))
			$this->terminate("./mlogin.php");
		if ($Security->allowList(CurrentProjectID() . 'mn_record'))
			$this->terminate("mn_recordlist.php");
		if ($Security->allowList(CurrentProjectID() . 'monthly_production'))
			$this->terminate("monthly_productionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'monthly_production_buyerwise'))
			$this->terminate("monthly_production_buyerwiselist.php");
		if ($Security->allowList(CurrentProjectID() . 'multiple_price'))
			$this->terminate("multiple_pricelist.php");
		if ($Security->allowList(CurrentProjectID() . 'news_letter'))
			$this->terminate("news_letterlist.php");
		if ($Security->allowList(CurrentProjectID() . 'not month'))
			$this->terminate("not_monthlist.php");
		if ($Security->allowList(CurrentProjectID() . 'not week'))
			$this->terminate("not_weeklist.php");
		if ($Security->allowList(CurrentProjectID() . 'oms_table'))
			$this->terminate("oms_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'oms_table_2'))
			$this->terminate("oms_table_2list.php");
		if ($Security->allowList(CurrentProjectID() . 'other_all'))
			$this->terminate("other_alllist.php");
		if ($Security->allowList(CurrentProjectID() . 'p_cart'))
			$this->terminate("p_cartlist.php");
		if ($Security->allowList(CurrentProjectID() . 'p_eastimate'))
			$this->terminate("p_eastimatelist.php");
		if ($Security->allowList(CurrentProjectID() . 'p_po'))
			$this->terminate("p_polist.php");
		if ($Security->allowList(CurrentProjectID() . 'p_process_wbc.php'))
			$this->terminate("./p_process_wbc.php");
		if ($Security->allowList(CurrentProjectID() . 'p_size'))
			$this->terminate("p_sizelist.php");
		if ($Security->allowList(CurrentProjectID() . 'p_stock'))
			$this->terminate("p_stocklist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_dw'))
			$this->terminate("packing_dwlist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_list'))
			$this->terminate("packing_listlist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_list_no'))
			$this->terminate("packing_list_nolist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_list_tmp'))
			$this->terminate("packing_list_tmplist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_process_f'))
			$this->terminate("packing_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_process_shortage'))
			$this->terminate("packing_process_shortagelist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_process_shortage_fp'))
			$this->terminate("packing_process_shortage_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_table'))
			$this->terminate("packing_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_table_fp'))
			$this->terminate("packing_table_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_type'))
			$this->terminate("packing_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'packing_type_table'))
			$this->terminate("packing_type_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'partner_balance'))
			$this->terminate("partner_balancelist.php");
		if ($Security->allowList(CurrentProjectID() . 'partner_balance_compiled'))
			$this->terminate("partner_balance_compiledlist.php");
		if ($Security->allowList(CurrentProjectID() . 'partner_product_ref'))
			$this->terminate("partner_product_reflist.php");
		if ($Security->allowList(CurrentProjectID() . 'partner_quotation_buyer'))
			$this->terminate("partner_quotation_buyerlist.php");
		if ($Security->allowList(CurrentProjectID() . 'partner_quotation_pp'))
			$this->terminate("partner_quotation_pplist.php");
		if ($Security->allowList(CurrentProjectID() . 'password_reset_temp'))
			$this->terminate("password_reset_templist.php");
		if ($Security->allowList(CurrentProjectID() . 'pay_sprit.php'))
			$this->terminate("./pay_sprit.php");
		if ($Security->allowList(CurrentProjectID() . 'payment'))
			$this->terminate("paymentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_emp_grp_check'))
			$this->terminate("payment_emp_grp_checklist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_hs'))
			$this->terminate("payment_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_period'))
			$this->terminate("payment_periodlist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_period_f'))
			$this->terminate("payment_period_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_period_fp'))
			$this->terminate("payment_period_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_plan'))
			$this->terminate("payment_planlist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_plan_check'))
			$this->terminate("payment_plan_checklist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_plan_extra_weaving'))
			$this->terminate("payment_plan_extra_weavinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_plan_hs'))
			$this->terminate("payment_plan_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_plan_material'))
			$this->terminate("payment_plan_materiallist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_plan_pending'))
			$this->terminate("payment_plan_pendinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_response'))
			$this->terminate("payment_responselist.php");
		if ($Security->allowList(CurrentProjectID() . 'payment_summary'))
			$this->terminate("payment_summarylist.php");
		if ($Security->allowList(CurrentProjectID() . 'payroll_details'))
			$this->terminate("payroll_detailslist.php");
		if ($Security->allowList(CurrentProjectID() . 'payroll_fix_details'))
			$this->terminate("payroll_fix_detailslist.php");
		if ($Security->allowList(CurrentProjectID() . 'personal_info'))
			$this->terminate("personal_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'pl_setup'))
			$this->terminate("pl_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'plan_pending_material.php'))
			$this->terminate("./plan_pending_material.php");
		if ($Security->allowList(CurrentProjectID() . 'po'))
			$this->terminate("polist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_b'))
			$this->terminate("po_blist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_b_app'))
			$this->terminate("po_b_applist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_b_auth'))
			$this->terminate("po_b_authlist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_b_wbc'))
			$this->terminate("po_b_wbclist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_desc'))
			$this->terminate("po_desclist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_f'))
			$this->terminate("po_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_fp'))
			$this->terminate("po_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_overall'))
			$this->terminate("po_overalllist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_overall_compiled'))
			$this->terminate("po_overall_compiledlist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_overall_cross'))
			$this->terminate("po_overall_crosslist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_pending'))
			$this->terminate("po_pendinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_pending_wbc'))
			$this->terminate("po_pending_wbclist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_s'))
			$this->terminate("po_slist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_s_app'))
			$this->terminate("po_s_applist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_s_auth'))
			$this->terminate("po_s_authlist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_s_pending'))
			$this->terminate("po_s_pendinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_setup'))
			$this->terminate("po_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'po_status'))
			$this->terminate("po_statuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'port'))
			$this->terminate("portlist.php");
		if ($Security->allowList(CurrentProjectID() . 'portal_image_size'))
			$this->terminate("portal_image_sizelist.php");
		if ($Security->allowList(CurrentProjectID() . 'portal_info'))
			$this->terminate("portal_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'portal_list'))
			$this->terminate("portal_listlist.php");
		if ($Security->allowList(CurrentProjectID() . 'portal_setup'))
			$this->terminate("portal_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'portal_updates'))
			$this->terminate("portal_updateslist.php");
		if ($Security->allowList(CurrentProjectID() . 'portal_version'))
			$this->terminate("portal_versionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'pp_category'))
			$this->terminate("pp_categorylist.php");
		if ($Security->allowList(CurrentProjectID() . 'pp_verify'))
			$this->terminate("pp_verifylist.php");
		if ($Security->allowList(CurrentProjectID() . 'pp_verify_compiled'))
			$this->terminate("pp_verify_compiledlist.php");
		if ($Security->allowList(CurrentProjectID() . 'prepone_dispatch.php'))
			$this->terminate("./prepone_dispatch.php");
		if ($Security->allowList(CurrentProjectID() . 'print_job_card_bc.php'))
			$this->terminate("./print_job_card_bc.php");
		if ($Security->allowList(CurrentProjectID() . 'print_job_card_post_data_fp.php'))
			$this->terminate("./print_job_card_post_data_fp.php");
		if ($Security->allowList(CurrentProjectID() . 'print_job_card_wbc.php'))
			$this->terminate("./print_job_card_wbc.php");
		if ($Security->allowList(CurrentProjectID() . 'print_pd.php'))
			$this->terminate("./print_pd.php");
		if ($Security->allowList(CurrentProjectID() . 'print_po.php'))
			$this->terminate("./print_po.php");
		if ($Security->allowList(CurrentProjectID() . 'print_po_b.php'))
			$this->terminate("./print_po_b.php");
		if ($Security->allowList(CurrentProjectID() . 'print_po_c.php'))
			$this->terminate("./print_po_c.php");
		if ($Security->allowList(CurrentProjectID() . 'print_po_fp.php'))
			$this->terminate("./print_po_fp.php");
		if ($Security->allowList(CurrentProjectID() . 'print_po_s.php'))
			$this->terminate("./print_po_s.php");
		if ($Security->allowList(CurrentProjectID() . 'print_sp_label.php'))
			$this->terminate("./print_sp_label.php");
		if ($Security->allowList(CurrentProjectID() . 'print_ted.php'))
			$this->terminate("./print_ted.php");
		if ($Security->allowList(CurrentProjectID() . 'print_ted_c.php'))
			$this->terminate("./print_ted_c.php");
		if ($Security->allowList(CurrentProjectID() . 'print_ted_f.php'))
			$this->terminate("./print_ted_f.php");
		if ($Security->allowList(CurrentProjectID() . 'print_ted_fp.php'))
			$this->terminate("./print_ted_fp.php");
		if ($Security->allowList(CurrentProjectID() . 'privacy-policy.php'))
			$this->terminate("./privacy-policy.php");
		if ($Security->allowList(CurrentProjectID() . 'process'))
			$this->terminate("processlist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action'))
			$this->terminate("process_actionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_f'))
			$this->terminate("process_action_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_fp'))
			$this->terminate("process_action_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_material'))
			$this->terminate("process_action_materiallist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_material_old'))
			$this->terminate("process_action_material_oldlist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_material_payment'))
			$this->terminate("process_action_material_paymentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment'))
			$this->terminate("process_action_paymentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_c'))
			$this->terminate("process_action_payment_clist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_e'))
			$this->terminate("process_action_payment_elist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_emp_ref_grp'))
			$this->terminate("process_action_payment_emp_ref_grplist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_f'))
			$this->terminate("process_action_payment_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_fe'))
			$this->terminate("process_action_payment_felist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_fp'))
			$this->terminate("process_action_payment_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_fpe'))
			$this->terminate("process_action_payment_fpelist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_payment_pe'))
			$this->terminate("process_action_payment_pelist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_action_single'))
			$this->terminate("process_action_singlelist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_fp'))
			$this->terminate("process_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_house'))
			$this->terminate("process_houselist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_mismatch'))
			$this->terminate("process_mismatchlist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_product_f'))
			$this->terminate("process_product_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_product_fp'))
			$this->terminate("process_product_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_table'))
			$this->terminate("process_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_table_fp'))
			$this->terminate("process_table_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_table_hs'))
			$this->terminate("process_table_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_type'))
			$this->terminate("process_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_type_f'))
			$this->terminate("process_type_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_type_fp'))
			$this->terminate("process_type_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'process_type_g'))
			$this->terminate("process_type_glist.php");
		if ($Security->allowList(CurrentProjectID() . 'prod_plan_log'))
			$this->terminate("prod_plan_loglist.php");
		if ($Security->allowList(CurrentProjectID() . 'product'))
			$this->terminate("productlist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_askprice'))
			$this->terminate("product_askpricelist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_cart_b'))
			$this->terminate("product_cart_blist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_cart_b_sample'))
			$this->terminate("product_cart_b_samplelist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_cart_b_wbc'))
			$this->terminate("product_cart_b_wbclist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_cart_s'))
			$this->terminate("product_cart_slist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_cart_s_sample'))
			$this->terminate("product_cart_s_samplelist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_category'))
			$this->terminate("product_categorylist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_f'))
			$this->terminate("product_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_fp'))
			$this->terminate("product_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_g'))
			$this->terminate("product_glist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_group'))
			$this->terminate("product_grouplist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_group_cross'))
			$this->terminate("product_group_crosslist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_notify'))
			$this->terminate("product_notifylist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_refer'))
			$this->terminate("product_referlist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_type'))
			$this->terminate("product_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'product_view'))
			$this->terminate("_product_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_employee'))
			$this->terminate("production_employeelist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_employee_c'))
			$this->terminate("production_employee_clist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_employee_f'))
			$this->terminate("production_employee_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_employee_fp'))
			$this->terminate("production_employee_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_employee_hs'))
			$this->terminate("production_employee_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_employee_view'))
			$this->terminate("_production_employee_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_employee_view_pw'))
			$this->terminate("production_employee_view_pwlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_partner'))
			$this->terminate("production_partnerlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_partner_view'))
			$this->terminate("_production_partner_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_plan'))
			$this->terminate("production_planlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_plan_head'))
			$this->terminate("production_plan_headlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_process'))
			$this->terminate("production_processlist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_process_f'))
			$this->terminate("production_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_process_fp'))
			$this->terminate("production_process_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_process_g'))
			$this->terminate("production_process_glist.php");
		if ($Security->allowList(CurrentProjectID() . 'production_process_live'))
			$this->terminate("production_process_livelist.php");
		if ($Security->allowList(CurrentProjectID() . 'promotional_message_text'))
			$this->terminate("promotional_message_textlist.php");
		if ($Security->allowList(CurrentProjectID() . 'property_details'))
			$this->terminate("property_detailslist.php");
		if ($Security->allowList(CurrentProjectID() . 'property_misc'))
			$this->terminate("property_misclist.php");
		if ($Security->allowList(CurrentProjectID() . 'purchase_a'))
			$this->terminate("purchase_alist.php");
		if ($Security->allowList(CurrentProjectID() . 'purchase_l'))
			$this->terminate("purchase_llist.php");
		if ($Security->allowList(CurrentProjectID() . 'purchase_l_audit'))
			$this->terminate("purchase_l_auditlist.php");
		if ($Security->allowList(CurrentProjectID() . 'purchase_l_audit_old'))
			$this->terminate("purchase_l_audit_oldlist.php");
		if ($Security->allowList(CurrentProjectID() . 'purchase_l_bc'))
			$this->terminate("purchase_l_bclist.php");
		if ($Security->allowList(CurrentProjectID() . 'purchase_ref'))
			$this->terminate("purchase_reflist.php");
		if ($Security->allowList(CurrentProjectID() . 'purchase_ref_monthly'))
			$this->terminate("purchase_ref_monthlylist.php");
		if ($Security->allowList(CurrentProjectID() . 'qc'))
			$this->terminate("qclist.php");
		if ($Security->allowList(CurrentProjectID() . 'qc_authorised'))
			$this->terminate("qc_authorisedlist.php");
		if ($Security->allowList(CurrentProjectID() . 'qc_items'))
			$this->terminate("qc_itemslist.php");
		if ($Security->allowList(CurrentProjectID() . 'qc_missing'))
			$this->terminate("qc_missinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'qc_old'))
			$this->terminate("qc_oldlist.php");
		if ($Security->allowList(CurrentProjectID() . 'qpb_setup'))
			$this->terminate("qpb_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'query_oms'))
			$this->terminate("query_omslist.php");
		if ($Security->allowList(CurrentProjectID() . 'query_oms_2'))
			$this->terminate("query_oms_2list.php");
		if ($Security->allowList(CurrentProjectID() . 'query_pppo_pending'))
			$this->terminate("query_pppo_pendinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'query_production'))
			$this->terminate("query_productionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'query_production_table'))
			$this->terminate("query_production_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'quotation'))
			$this->terminate("quotationlist.php");
		if ($Security->allowList(CurrentProjectID() . 'quotation_setup'))
			$this->terminate("quotation_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 're.php'))
			$this->terminate("./re.php");
		if ($Security->allowList(CurrentProjectID() . 'receipt'))
			$this->terminate("receiptlist.php");
		if ($Security->allowList(CurrentProjectID() . 'receipt_b'))
			$this->terminate("receipt_blist.php");
		if ($Security->allowList(CurrentProjectID() . 'ref'))
			$this->terminate("reflist.php");
		if ($Security->allowList(CurrentProjectID() . 'ref_f'))
			$this->terminate("ref_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'ref_fp'))
			$this->terminate("ref_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'ref_image'))
			$this->terminate("ref_imagelist.php");
		if ($Security->allowList(CurrentProjectID() . 'ref_multi'))
			$this->terminate("ref_multilist.php");
		if ($Security->allowList(CurrentProjectID() . 'ref_view'))
			$this->terminate("_ref_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'refer_to_friend'))
			$this->terminate("refer_to_friendlist.php");
		if ($Security->allowList(CurrentProjectID() . 'refresh_update'))
			$this->terminate("refresh_updatelist.php");
		if ($Security->allowList(CurrentProjectID() . 'rental_cart'))
			$this->terminate("rental_cartlist.php");
		if ($Security->allowList(CurrentProjectID() . 'rental_po'))
			$this->terminate("rental_polist.php");
		if ($Security->allowList(CurrentProjectID() . 'request'))
			$this->terminate("__requestlist.php");
		if ($Security->allowList(CurrentProjectID() . 'request_archive'))
			$this->terminate("request_archivelist.php");
		if ($Security->allowList(CurrentProjectID() . 'request_group'))
			$this->terminate("request_grouplist.php");
		if ($Security->allowList(CurrentProjectID() . 'request_type'))
			$this->terminate("request_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'required_material_compiled'))
			$this->terminate("required_material_compiledlist.php");
		if ($Security->allowList(CurrentProjectID() . 'required_material_compiled_live'))
			$this->terminate("required_material_compiled_livelist.php");
		if ($Security->allowList(CurrentProjectID() . 'required_material_overall_table'))
			$this->terminate("required_material_overall_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 's_eval_scheme'))
			$this->terminate("s_eval_schemelist.php");
		if ($Security->allowList(CurrentProjectID() . 's_omr_value'))
			$this->terminate("s_omr_valuelist.php");
		if ($Security->allowList(CurrentProjectID() . 'salary_expenses'))
			$this->terminate("salary_expenseslist.php");
		if ($Security->allowList(CurrentProjectID() . 'salary_payment'))
			$this->terminate("salary_paymentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sales_ref'))
			$this->terminate("sales_reflist.php");
		if ($Security->allowList(CurrentProjectID() . 'sales_ref_monthly'))
			$this->terminate("sales_ref_monthlylist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req'))
			$this->terminate("sample_reqlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart'))
			$this->terminate("sample_req_cartlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_app'))
			$this->terminate("sample_req_cart_applist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_auth'))
			$this->terminate("sample_req_cart_authlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_dispatch'))
			$this->terminate("sample_req_cart_dispatchlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_dispatch_app'))
			$this->terminate("sample_req_cart_dispatch_applist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_feedback'))
			$this->terminate("sample_req_cart_feedbacklist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_po'))
			$this->terminate("sample_req_cart_polist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_pre_dispatch'))
			$this->terminate("sample_req_cart_pre_dispatchlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_cart_status'))
			$this->terminate("sample_req_cart_statuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_req_misc'))
			$this->terminate("sample_req_misclist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_request_receive'))
			$this->terminate("sample_request_receivelist.php");
		if ($Security->allowList(CurrentProjectID() . 'sample_request_status'))
			$this->terminate("sample_request_statuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'scouring_dw'))
			$this->terminate("scouring_dwlist.php");
		if ($Security->allowList(CurrentProjectID() . 'scouring_process_f'))
			$this->terminate("scouring_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'scouring_process_shortage'))
			$this->terminate("scouring_process_shortagelist.php");
		if ($Security->allowList(CurrentProjectID() . 'scouring_process_shortage_tmplot'))
			$this->terminate("scouring_process_shortage_tmplotlist.php");
		if ($Security->allowList(CurrentProjectID() . 'scouring_table'))
			$this->terminate("scouring_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'scouring_type'))
			$this->terminate("scouring_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'service_misc'))
			$this->terminate("service_misclist.php");
		if ($Security->allowList(CurrentProjectID() . 'service_report'))
			$this->terminate("service_reportlist.php");
		if ($Security->allowList(CurrentProjectID() . 'service_request'))
			$this->terminate("service_requestlist.php");
		if ($Security->allowList(CurrentProjectID() . 'shade_type'))
			$this->terminate("shade_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'shape'))
			$this->terminate("shapelist.php");
		if ($Security->allowList(CurrentProjectID() . 'share_transfer'))
			$this->terminate("share_transferlist.php");
		if ($Security->allowList(CurrentProjectID() . 'shipping_address'))
			$this->terminate("shipping_addresslist.php");
		if ($Security->allowList(CurrentProjectID() . 'shipping_company'))
			$this->terminate("shipping_companylist.php");
		if ($Security->allowList(CurrentProjectID() . 'shipping_details'))
			$this->terminate("shipping_detailslist.php");
		if ($Security->allowList(CurrentProjectID() . 'shipping_line'))
			$this->terminate("shipping_linelist.php");
		if ($Security->allowList(CurrentProjectID() . 'shipping_type'))
			$this->terminate("shipping_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'shop'))
			$this->terminate("shoplist.php");
		if ($Security->allowList(CurrentProjectID() . 'site_search'))
			$this->terminate("site_searchlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sms_record'))
			$this->terminate("sms_recordlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sms_setup'))
			$this->terminate("sms_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'social_icons'))
			$this->terminate("social_iconslist.php");
		if ($Security->allowList(CurrentProjectID() . 'sorting_dw'))
			$this->terminate("sorting_dwlist.php");
		if ($Security->allowList(CurrentProjectID() . 'sorting_process_f'))
			$this->terminate("sorting_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'sorting_process_shortage'))
			$this->terminate("sorting_process_shortagelist.php");
		if ($Security->allowList(CurrentProjectID() . 'sorting_table'))
			$this->terminate("sorting_tablelist.php");
		if ($Security->allowList(CurrentProjectID() . 'sorting_type'))
			$this->terminate("sorting_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'special_permissions'))
			$this->terminate("special_permissionslist.php");
		if ($Security->allowList(CurrentProjectID() . 'special_task'))
			$this->terminate("special_tasklist.php");
		if ($Security->allowList(CurrentProjectID() . 'static_pages'))
			$this->terminate("static_pageslist.php");
		if ($Security->allowList(CurrentProjectID() . 'status'))
			$this->terminate("statuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock'))
			$this->terminate("stocklist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_barcode'))
			$this->terminate("stock_barcodelist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_blending'))
			$this->terminate("stock_blendinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_consume'))
			$this->terminate("stock_consumelist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_datewise'))
			$this->terminate("stock_datewiselist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_dyeing'))
			$this->terminate("stock_dyeinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_emp_hs_pending'))
			$this->terminate("stock_emp_hs_pendinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_godown_fp'))
			$this->terminate("stock_godown_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_godown_hs'))
			$this->terminate("stock_godown_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_godown_transfer'))
			$this->terminate("stock_godown_transferlist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_godown_transfer_old'))
			$this->terminate("stock_godown_transfer_oldlist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_lcgp'))
			$this->terminate("stock_lcgplist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_lcgp_all'))
			$this->terminate("stock_lcgp_alllist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_lcgpd'))
			$this->terminate("stock_lcgpdlist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_hs'))
			$this->terminate("stock_material_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_in_hs'))
			$this->terminate("stock_material_in_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_out'))
			$this->terminate("stock_material_outlist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_out_emp_hs'))
			$this->terminate("stock_material_out_emp_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_out_f'))
			$this->terminate("stock_material_out_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_out_f_fp_hs'))
			$this->terminate("stock_material_out_f_fp_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_out_fp'))
			$this->terminate("stock_material_out_fplist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_material_out_hs'))
			$this->terminate("stock_material_out_hslist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_movement_detailed'))
			$this->terminate("stock_movement_detailedlist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_online'))
			$this->terminate("stock_onlinelist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_packing'))
			$this->terminate("stock_packinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_process'))
			$this->terminate("stock_processlist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_process_action_material'))
			$this->terminate("stock_process_action_materiallist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_process_f'))
			$this->terminate("stock_process_flist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_processing_job'))
			$this->terminate("stock_processing_joblist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_processing_outside'))
			$this->terminate("stock_processing_outsidelist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_purchase_l'))
			$this->terminate("stock_purchase_llist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_scouring'))
			$this->terminate("stock_scouringlist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_setup'))
			$this->terminate("stock_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'stock_sorting'))
			$this->terminate("stock_sortinglist.php");
		if ($Security->allowList(CurrentProjectID() . 'sub_process_type'))
			$this->terminate("sub_process_typelist.php");
		if ($Security->allowList(CurrentProjectID() . 'sw.js'))
			$this->terminate("./sw.js");
		if ($Security->allowList(CurrentProjectID() . 't_balance'))
			$this->terminate("t_balancelist.php");
		if ($Security->allowList(CurrentProjectID() . 't_balance_detailed'))
			$this->terminate("t_balance_detailedlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_daily_km'))
			$this->terminate("t_daily_kmlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_diesal_expenses'))
			$this->terminate("t_diesal_expenseslist.php");
		if ($Security->allowList(CurrentProjectID() . 't_diesal_expenses_d'))
			$this->terminate("t_diesal_expenses_dlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_driver_info'))
			$this->terminate("t_driver_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 't_due_payment'))
			$this->terminate("t_due_paymentlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_expenses'))
			$this->terminate("t_expenseslist.php");
		if ($Security->allowList(CurrentProjectID() . 't_expenses_d'))
			$this->terminate("t_expenses_dlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_expenses_info'))
			$this->terminate("_t_expenses_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 't_expenses_o'))
			$this->terminate("t_expenses_olist.php");
		if ($Security->allowList(CurrentProjectID() . 't_fasttag_expenses'))
			$this->terminate("t_fasttag_expenseslist.php");
		if ($Security->allowList(CurrentProjectID() . 't_ledger'))
			$this->terminate("t_ledgerlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_maintenance'))
			$this->terminate("t_maintenancelist.php");
		if ($Security->allowList(CurrentProjectID() . 't_maintenance_exp'))
			$this->terminate("t_maintenance_explist.php");
		if ($Security->allowList(CurrentProjectID() . 't_maintenance_info'))
			$this->terminate("_t_maintenance_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 't_payment'))
			$this->terminate("t_paymentlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_payment_bulk'))
			$this->terminate("t_payment_bulklist.php");
		if ($Security->allowList(CurrentProjectID() . 't_receipt_bulk'))
			$this->terminate("t_receipt_bulklist.php");
		if ($Security->allowList(CurrentProjectID() . 't_receipt_d'))
			$this->terminate("t_receipt_dlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_route_info'))
			$this->terminate("t_route_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_balance'))
			$this->terminate("t_trip_balancelist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_buyer'))
			$this->terminate("t_trip_buyerlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_expenses_detailed'))
			$this->terminate("t_trip_expenses_detailedlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_expenses_report'))
			$this->terminate("t_trip_expenses_reportlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_info'))
			$this->terminate("t_trip_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_info_d'))
			$this->terminate("t_trip_info_dlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_info_d_unload'))
			$this->terminate("t_trip_info_d_unloadlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_loadslip'))
			$this->terminate("t_trip_loadsliplist.php");
		if ($Security->allowList(CurrentProjectID() . 't_trip_start'))
			$this->terminate("t_trip_startlist.php");
		if ($Security->allowList(CurrentProjectID() . 't_tyre_info'))
			$this->terminate("t_tyre_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 't_tyre_maintenance'))
			$this->terminate("t_tyre_maintenancelist.php");
		if ($Security->allowList(CurrentProjectID() . 'tax_category'))
			$this->terminate("tax_categorylist.php");
		if ($Security->allowList(CurrentProjectID() . 'test_report'))
			$this->terminate("test_reportlist.php");
		if ($Security->allowList(CurrentProjectID() . 'test_report_g'))
			$this->terminate("test_report_glist.php");
		if ($Security->allowList(CurrentProjectID() . 'test_report_head'))
			$this->terminate("test_report_headlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tmp_lot_query'))
			$this->terminate("tmp_lot_querylist.php");
		if ($Security->allowList(CurrentProjectID() . 'tmp_notes_bc'))
			$this->terminate("tmp_notes_bclist.php");
		if ($Security->allowList(CurrentProjectID() . 'tufting_complete.php'))
			$this->terminate("./tufting_complete.php");
		if ($Security->allowList(CurrentProjectID() . 'tufting_plan.php'))
			$this->terminate("./tufting_plan.php");
		if ($Security->allowList(CurrentProjectID() . 'tufting_plan_wc.php'))
			$this->terminate("./tufting_plan_wc.php");
		if ($Security->allowList(CurrentProjectID() . 'tufting_plan_wlz.php'))
			$this->terminate("./tufting_plan_wlz.php");
		if ($Security->allowList(CurrentProjectID() . 'unit'))
			$this->terminate("unitlist.php");
		if ($Security->allowList(CurrentProjectID() . 'update_old_payment'))
			$this->terminate("update_old_paymentlist.php");
		if ($Security->allowList(CurrentProjectID() . 'upload.php'))
			$this->terminate("./upload.php");
		if ($Security->allowList(CurrentProjectID() . 'user'))
			$this->terminate("userlist.php");
		if ($Security->allowList(CurrentProjectID() . 'userlevelpermissions'))
			$this->terminate("userlevelpermissionslist.php");
		if ($Security->allowList(CurrentProjectID() . 'userlevels'))
			$this->terminate("userlevelslist.php");
		if ($Security->allowList(CurrentProjectID() . 'varient'))
			$this->terminate("varientlist.php");
		if ($Security->allowList(CurrentProjectID() . 'varient_view'))
			$this->terminate("_varient_viewlist.php");
		if ($Security->allowList(CurrentProjectID() . 'vehicle_info'))
			$this->terminate("vehicle_infolist.php");
		if ($Security->allowList(CurrentProjectID() . 'weekly_production'))
			$this->terminate("weekly_productionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'weight_comparision'))
			$this->terminate("weight_comparisionlist.php");
		if ($Security->allowList(CurrentProjectID() . 'whatsapp_setup'))
			$this->terminate("whatsapp_setuplist.php");
		if ($Security->allowList(CurrentProjectID() . 'wool_import_calculator'))
			$this->terminate("wool_import_calculatorlist.php");
		if ($Security->allowList(CurrentProjectID() . 'wool_import_calculator1'))
			$this->terminate("wool_import_calculator1list.php");
		if ($Security->allowList(CurrentProjectID() . 'world_city'))
			$this->terminate("world_citylist.php");
		if ($Security->allowList(CurrentProjectID() . 'world_country'))
			$this->terminate("world_countrylist.php");
		if ($Security->allowList(CurrentProjectID() . 'world_state'))
			$this->terminate("world_statelist.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_color'))
			$this->terminate("ww_colorlist.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_color_order'))
			$this->terminate("ww_color_orderlist.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_color_req'))
			$this->terminate("ww_color_reqlist.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_color_req_detailed'))
			$this->terminate("ww_color_req_detailedlist.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_color_req_detailed_2'))
			$this->terminate("ww_color_req_detailed_2list.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_tufting_plan.php'))
			$this->terminate("./ww_tufting_plan.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_tufting_plan_wc.php'))
			$this->terminate("./ww_tufting_plan_wc.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_tufting_plan_wlz.php'))
			$this->terminate("./ww_tufting_plan_wlz.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_yarn'))
			$this->terminate("ww_yarnlist.php");
		if ($Security->allowList(CurrentProjectID() . 'ww_yarn_plan'))
			$this->terminate("ww_yarn_planlist.php");
		if ($Security->allowList(CurrentProjectID() . 'y3jvbxjt.php'))
			$this->terminate("./y3jvbxjt.php");
		if ($Security->allowList(CurrentProjectID() . 'ziparchive.php'))
			$this->terminate("./ziparchive.php");
		if ($Security->isLoggedIn()) {
			$this->setFailureMessage(DeniedMessage() . "<br><br><a href=\"logout.php\">" . $Language->phrase("BackToLogin") . "</a>");
		} else {
			$this->terminate("login.php"); // Exit and go to login page
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'
	function Message_Showing(&$msg, $type) {

		// Example:
		//if ($type == 'success') $msg = "your success message";

	}
}
?>