<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for investor_info
 */
class investor_info extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $qty;
	public $aadhaar_no;
	public $name;
	public $gender;
	public $dob;
	public $mobile;
	public $_email;
	public $address;
	public $care_of;
	public $father_name;
	public $mother_name;
	public $nominee_name;
	public $nominee_relation;
	public $pan_no;
	public $uploads;
	public $image;
	public $adviser;
	public $share_no;
	public $inv_start_date;
	public $amount;
	public $gurantee;
	public $remarks;
	public $operator;
	public $datetime;
	public $otp;
	public $pan_response;
	public $pan_verify_datetime;
	public $aadhaar_response;
	public $aadhaar_verify_datetime;
	public $thumb_data;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'investor_info';
		$this->TableName = 'investor_info';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`investor_info`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('investor_info', 'investor_info', 'x_id', 'id', '`id`', '`id`', 2, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// qty
		$this->qty = new DbField('investor_info', 'investor_info', 'x_qty', 'qty', '`qty`', '`qty`', 3, -1, FALSE, '`qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->qty->Sortable = TRUE; // Allow sort
		$this->qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['qty'] = &$this->qty;

		// aadhaar_no
		$this->aadhaar_no = new DbField('investor_info', 'investor_info', 'x_aadhaar_no', 'aadhaar_no', '`aadhaar_no`', '`aadhaar_no`', 200, -1, FALSE, '`aadhaar_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->aadhaar_no->Required = TRUE; // Required field
		$this->aadhaar_no->Sortable = TRUE; // Allow sort
		$this->aadhaar_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['aadhaar_no'] = &$this->aadhaar_no;

		// name
		$this->name = new DbField('investor_info', 'investor_info', 'x_name', 'name', '`name`', '`name`', 200, -1, FALSE, '`name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->name->Sortable = TRUE; // Allow sort
		$this->fields['name'] = &$this->name;

		// gender
		$this->gender = new DbField('investor_info', 'investor_info', 'x_gender', 'gender', '`gender`', '`gender`', 200, -1, FALSE, '`gender`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->gender->Sortable = TRUE; // Allow sort
		$this->gender->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->gender->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->gender->Lookup = new Lookup('gender', 'investor_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->gender->OptionCount = 3;
		$this->fields['gender'] = &$this->gender;

		// dob
		$this->dob = new DbField('investor_info', 'investor_info', 'x_dob', 'dob', '`dob`', CastDateFieldForLike('`dob`', 7, "DB"), 133, 7, FALSE, '`dob`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dob->Required = TRUE; // Required field
		$this->dob->Sortable = TRUE; // Allow sort
		$this->fields['dob'] = &$this->dob;

		// mobile
		$this->mobile = new DbField('investor_info', 'investor_info', 'x_mobile', 'mobile', '`mobile`', '`mobile`', 200, -1, FALSE, '`mobile`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mobile->Sortable = TRUE; // Allow sort
		$this->fields['mobile'] = &$this->mobile;

		// email
		$this->_email = new DbField('investor_info', 'investor_info', 'x__email', 'email', '`email`', '`email`', 200, -1, FALSE, '`email`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_email->Sortable = TRUE; // Allow sort
		$this->fields['email'] = &$this->_email;

		// address
		$this->address = new DbField('investor_info', 'investor_info', 'x_address', 'address', '`address`', '`address`', 200, -1, FALSE, '`address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->address->Sortable = TRUE; // Allow sort
		$this->fields['address'] = &$this->address;

		// care_of
		$this->care_of = new DbField('investor_info', 'investor_info', 'x_care_of', 'care_of', '`care_of`', '`care_of`', 200, -1, FALSE, '`care_of`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->care_of->Sortable = TRUE; // Allow sort
		$this->fields['care_of'] = &$this->care_of;

		// father_name
		$this->father_name = new DbField('investor_info', 'investor_info', 'x_father_name', 'father_name', '`father_name`', '`father_name`', 200, -1, FALSE, '`father_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->father_name->Sortable = TRUE; // Allow sort
		$this->fields['father_name'] = &$this->father_name;

		// mother_name
		$this->mother_name = new DbField('investor_info', 'investor_info', 'x_mother_name', 'mother_name', '`mother_name`', '`mother_name`', 200, -1, FALSE, '`mother_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mother_name->Sortable = TRUE; // Allow sort
		$this->fields['mother_name'] = &$this->mother_name;

		// nominee_name
		$this->nominee_name = new DbField('investor_info', 'investor_info', 'x_nominee_name', 'nominee_name', '`nominee_name`', '`nominee_name`', 200, -1, FALSE, '`nominee_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nominee_name->Sortable = TRUE; // Allow sort
		$this->fields['nominee_name'] = &$this->nominee_name;

		// nominee_relation
		$this->nominee_relation = new DbField('investor_info', 'investor_info', 'x_nominee_relation', 'nominee_relation', '`nominee_relation`', '`nominee_relation`', 200, -1, FALSE, '`nominee_relation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->nominee_relation->Sortable = TRUE; // Allow sort
		$this->nominee_relation->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->nominee_relation->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->nominee_relation->Lookup = new Lookup('nominee_relation', 'investor_info', FALSE, 'nominee_relation', ["nominee_relation","","",""], [], [], [], [], [], [], '`nominee_relation` ASC', '');
		$this->nominee_relation->OptionCount = 8;
		$this->fields['nominee_relation'] = &$this->nominee_relation;

		// pan_no
		$this->pan_no = new DbField('investor_info', 'investor_info', 'x_pan_no', 'pan_no', '`pan_no`', '`pan_no`', 200, -1, FALSE, '`pan_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan_no->Sortable = TRUE; // Allow sort
		$this->fields['pan_no'] = &$this->pan_no;

		// uploads
		$this->uploads = new DbField('investor_info', 'investor_info', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->uploads->Sortable = TRUE; // Allow sort
		$this->uploads->ImageResize = TRUE;
		$this->uploads->UploadMultiple = TRUE;
		$this->uploads->Upload->UploadMultiple = TRUE;
		$this->uploads->UploadMaxFileCount = 0;
		$this->fields['uploads'] = &$this->uploads;

		// image
		$this->image = new DbField('investor_info', 'investor_info', 'x_image', 'image', '`image`', '`image`', 201, -1, TRUE, '`image`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->image->Sortable = FALSE; // Allow sort
		$this->fields['image'] = &$this->image;

		// adviser
		$this->adviser = new DbField('investor_info', 'investor_info', 'x_adviser', 'adviser', '`adviser`', '`adviser`', 2, -1, FALSE, '`adviser`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->adviser->Sortable = TRUE; // Allow sort
		$this->adviser->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->adviser->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->adviser->Lookup = new Lookup('adviser', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->adviser->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['adviser'] = &$this->adviser;

		// share_no
		$this->share_no = new DbField('investor_info', 'investor_info', 'x_share_no', 'share_no', '`share_no`', '`share_no`', 201, -1, FALSE, '`share_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->share_no->Sortable = TRUE; // Allow sort
		$this->fields['share_no'] = &$this->share_no;

		// inv_start_date
		$this->inv_start_date = new DbField('investor_info', 'investor_info', 'x_inv_start_date', 'inv_start_date', '`inv_start_date`', CastDateFieldForLike('`inv_start_date`', 0, "DB"), 133, 0, FALSE, '`inv_start_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->inv_start_date->Sortable = TRUE; // Allow sort
		$this->inv_start_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['inv_start_date'] = &$this->inv_start_date;

		// amount
		$this->amount = new DbField('investor_info', 'investor_info', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// gurantee
		$this->gurantee = new DbField('investor_info', 'investor_info', 'x_gurantee', 'gurantee', '`gurantee`', '`gurantee`', 131, -1, FALSE, '`gurantee`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gurantee->Sortable = TRUE; // Allow sort
		$this->gurantee->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['gurantee'] = &$this->gurantee;

		// remarks
		$this->remarks = new DbField('investor_info', 'investor_info', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// operator
		$this->operator = new DbField('investor_info', 'investor_info', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('investor_info', 'investor_info', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// otp
		$this->otp = new DbField('investor_info', 'investor_info', 'x_otp', 'otp', '`otp`', '`otp`', 3, -1, FALSE, '`otp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->otp->Sortable = FALSE; // Allow sort
		$this->otp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['otp'] = &$this->otp;

		// pan_response
		$this->pan_response = new DbField('investor_info', 'investor_info', 'x_pan_response', 'pan_response', '`pan_response`', '`pan_response`', 201, 0, FALSE, '`pan_response`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan_response->Sortable = FALSE; // Allow sort
		$this->pan_response->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['pan_response'] = &$this->pan_response;

		// pan_verify_datetime
		$this->pan_verify_datetime = new DbField('investor_info', 'investor_info', 'x_pan_verify_datetime', 'pan_verify_datetime', '`pan_verify_datetime`', CastDateFieldForLike('`pan_verify_datetime`', 0, "DB"), 135, 0, FALSE, '`pan_verify_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan_verify_datetime->Sortable = FALSE; // Allow sort
		$this->pan_verify_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['pan_verify_datetime'] = &$this->pan_verify_datetime;

		// aadhaar_response
		$this->aadhaar_response = new DbField('investor_info', 'investor_info', 'x_aadhaar_response', 'aadhaar_response', '`aadhaar_response`', '`aadhaar_response`', 201, -1, FALSE, '`aadhaar_response`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->aadhaar_response->Sortable = FALSE; // Allow sort
		$this->fields['aadhaar_response'] = &$this->aadhaar_response;

		// aadhaar_verify_datetime
		$this->aadhaar_verify_datetime = new DbField('investor_info', 'investor_info', 'x_aadhaar_verify_datetime', 'aadhaar_verify_datetime', '`aadhaar_verify_datetime`', CastDateFieldForLike('`aadhaar_verify_datetime`', 0, "DB"), 135, 0, FALSE, '`aadhaar_verify_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->aadhaar_verify_datetime->Sortable = FALSE; // Allow sort
		$this->aadhaar_verify_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['aadhaar_verify_datetime'] = &$this->aadhaar_verify_datetime;

		// thumb_data
		$this->thumb_data = new DbField('investor_info', 'investor_info', 'x_thumb_data', 'thumb_data', '`thumb_data`', '`thumb_data`', 201, -1, FALSE, '`thumb_data`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->thumb_data->Sortable = FALSE; // Allow sort
		$this->fields['thumb_data'] = &$this->thumb_data;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`investor_info`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (CurrentUserID() == 51) ? '' : "`operator` = " . CurrentUserID() . "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->qty->DbValue = $row['qty'];
		$this->aadhaar_no->DbValue = $row['aadhaar_no'];
		$this->name->DbValue = $row['name'];
		$this->gender->DbValue = $row['gender'];
		$this->dob->DbValue = $row['dob'];
		$this->mobile->DbValue = $row['mobile'];
		$this->_email->DbValue = $row['email'];
		$this->address->DbValue = $row['address'];
		$this->care_of->DbValue = $row['care_of'];
		$this->father_name->DbValue = $row['father_name'];
		$this->mother_name->DbValue = $row['mother_name'];
		$this->nominee_name->DbValue = $row['nominee_name'];
		$this->nominee_relation->DbValue = $row['nominee_relation'];
		$this->pan_no->DbValue = $row['pan_no'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->image->Upload->DbValue = $row['image'];
		$this->adviser->DbValue = $row['adviser'];
		$this->share_no->DbValue = $row['share_no'];
		$this->inv_start_date->DbValue = $row['inv_start_date'];
		$this->amount->DbValue = $row['amount'];
		$this->gurantee->DbValue = $row['gurantee'];
		$this->remarks->DbValue = $row['remarks'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->otp->DbValue = $row['otp'];
		$this->pan_response->DbValue = $row['pan_response'];
		$this->pan_verify_datetime->DbValue = $row['pan_verify_datetime'];
		$this->aadhaar_response->DbValue = $row['aadhaar_response'];
		$this->aadhaar_verify_datetime->DbValue = $row['aadhaar_verify_datetime'];
		$this->thumb_data->DbValue = $row['thumb_data'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->uploads->OldUploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['uploads']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['uploads']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
		$this->image->OldUploadPath = '.p_uploads/member_info/';
		$oldFiles = EmptyValue($row['image']) ? [] : [$row['image']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->image->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "investor_infolist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "investor_infoview.php")
			return $Language->phrase("View");
		elseif ($pageName == "investor_infoedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "investor_infoadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "investor_infolist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("investor_infoview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("investor_infoview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "investor_infoadd.php?" . $this->getUrlParm($parm);
		else
			$url = "investor_infoadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("investor_infoedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("investor_infoadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("investor_infodelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->qty->setDbValue($rs->fields('qty'));
		$this->aadhaar_no->setDbValue($rs->fields('aadhaar_no'));
		$this->name->setDbValue($rs->fields('name'));
		$this->gender->setDbValue($rs->fields('gender'));
		$this->dob->setDbValue($rs->fields('dob'));
		$this->mobile->setDbValue($rs->fields('mobile'));
		$this->_email->setDbValue($rs->fields('email'));
		$this->address->setDbValue($rs->fields('address'));
		$this->care_of->setDbValue($rs->fields('care_of'));
		$this->father_name->setDbValue($rs->fields('father_name'));
		$this->mother_name->setDbValue($rs->fields('mother_name'));
		$this->nominee_name->setDbValue($rs->fields('nominee_name'));
		$this->nominee_relation->setDbValue($rs->fields('nominee_relation'));
		$this->pan_no->setDbValue($rs->fields('pan_no'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->image->Upload->DbValue = $rs->fields('image');
		$this->adviser->setDbValue($rs->fields('adviser'));
		$this->share_no->setDbValue($rs->fields('share_no'));
		$this->inv_start_date->setDbValue($rs->fields('inv_start_date'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->gurantee->setDbValue($rs->fields('gurantee'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->otp->setDbValue($rs->fields('otp'));
		$this->pan_response->setDbValue($rs->fields('pan_response'));
		$this->pan_verify_datetime->setDbValue($rs->fields('pan_verify_datetime'));
		$this->aadhaar_response->setDbValue($rs->fields('aadhaar_response'));
		$this->aadhaar_verify_datetime->setDbValue($rs->fields('aadhaar_verify_datetime'));
		$this->thumb_data->setDbValue($rs->fields('thumb_data'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// qty
		// aadhaar_no
		// name
		// gender
		// dob
		// mobile
		// email
		// address
		// care_of
		// father_name
		// mother_name
		// nominee_name
		// nominee_relation
		// pan_no
		// uploads
		// image

		$this->image->CellCssStyle = "white-space: nowrap;";

		// adviser
		// share_no
		// inv_start_date
		// amount
		// gurantee
		// remarks
		// operator
		// datetime
		// otp

		$this->otp->CellCssStyle = "white-space: nowrap;";

		// pan_response
		$this->pan_response->CellCssStyle = "white-space: nowrap;";

		// pan_verify_datetime
		// aadhaar_response

		$this->aadhaar_response->CellCssStyle = "white-space: nowrap;";

		// aadhaar_verify_datetime
		$this->aadhaar_verify_datetime->CellCssStyle = "white-space: nowrap;";

		// thumb_data
		$this->thumb_data->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// qty
		$this->qty->ViewValue = $this->qty->CurrentValue;
		$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
		$this->qty->ViewCustomAttributes = "";

		// aadhaar_no
		$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->ViewCustomAttributes = "";

		// name
		$this->name->ViewValue = $this->name->CurrentValue;
		$this->name->ViewCustomAttributes = "";

		// gender
		if (strval($this->gender->CurrentValue) <> "") {
			$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
		} else {
			$this->gender->ViewValue = NULL;
		}
		$this->gender->ViewCustomAttributes = "";

		// dob
		$this->dob->ViewValue = $this->dob->CurrentValue;
		$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 7);
		$this->dob->ViewCustomAttributes = "";

		// mobile
		$this->mobile->ViewValue = $this->mobile->CurrentValue;
		$this->mobile->ViewCustomAttributes = "";

		// email
		$this->_email->ViewValue = $this->_email->CurrentValue;
		$this->_email->ViewCustomAttributes = "";

		// address
		$this->address->ViewValue = $this->address->CurrentValue;
		$this->address->ViewCustomAttributes = "";

		// care_of
		$this->care_of->ViewValue = $this->care_of->CurrentValue;
		$this->care_of->ViewCustomAttributes = "";

		// father_name
		$this->father_name->ViewValue = $this->father_name->CurrentValue;
		$this->father_name->ViewCustomAttributes = "";

		// mother_name
		$this->mother_name->ViewValue = $this->mother_name->CurrentValue;
		$this->mother_name->ViewCustomAttributes = "";

		// nominee_name
		$this->nominee_name->ViewValue = $this->nominee_name->CurrentValue;
		$this->nominee_name->ViewCustomAttributes = "";

		// nominee_relation
		if (strval($this->nominee_relation->CurrentValue) <> "") {
			$this->nominee_relation->ViewValue = $this->nominee_relation->optionCaption($this->nominee_relation->CurrentValue);
		} else {
			$this->nominee_relation->ViewValue = NULL;
		}
		$this->nominee_relation->ViewCustomAttributes = "";

		// pan_no
		$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
		$this->pan_no->ViewCustomAttributes = "";

		// uploads
		$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->ViewCustomAttributes = "";

		// image
		$this->image->UploadPath = '.p_uploads/member_info/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 50;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->ViewValue = $this->image->Upload->DbValue;
		} else {
			$this->image->ViewValue = "";
		}
		$this->image->ViewCustomAttributes = "";

		// adviser
		$curVal = strval($this->adviser->CurrentValue);
		if ($curVal <> "") {
			$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
			if ($this->adviser->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`userlevel`=1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->adviser->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->adviser->ViewValue = $this->adviser->CurrentValue;
				}
			}
		} else {
			$this->adviser->ViewValue = NULL;
		}
		$this->adviser->ViewCustomAttributes = "";

		// share_no
		$this->share_no->ViewValue = $this->share_no->CurrentValue;
		$this->share_no->ViewCustomAttributes = "";

		// inv_start_date
		$this->inv_start_date->ViewValue = $this->inv_start_date->CurrentValue;
		$this->inv_start_date->ViewValue = FormatDateTime($this->inv_start_date->ViewValue, 0);
		$this->inv_start_date->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// gurantee
		$this->gurantee->ViewValue = $this->gurantee->CurrentValue;
		$this->gurantee->ViewValue = FormatNumber($this->gurantee->ViewValue, 2, -2, -2, -2);
		$this->gurantee->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// otp
		$this->otp->ViewValue = $this->otp->CurrentValue;
		$this->otp->ViewValue = FormatNumber($this->otp->ViewValue, 0, -2, -2, -2);
		$this->otp->ViewCustomAttributes = "";

		// pan_response
		$this->pan_response->ViewValue = $this->pan_response->CurrentValue;
		$this->pan_response->ViewCustomAttributes = "";

		// pan_verify_datetime
		$this->pan_verify_datetime->ViewValue = $this->pan_verify_datetime->CurrentValue;
		$this->pan_verify_datetime->ViewValue = FormatDateTime($this->pan_verify_datetime->ViewValue, 0);
		$this->pan_verify_datetime->ViewCustomAttributes = "";

		// aadhaar_response
		$this->aadhaar_response->ViewValue = $this->aadhaar_response->CurrentValue;
		$this->aadhaar_response->ViewCustomAttributes = "";

		// aadhaar_verify_datetime
		$this->aadhaar_verify_datetime->ViewValue = $this->aadhaar_verify_datetime->CurrentValue;
		$this->aadhaar_verify_datetime->ViewValue = FormatDateTime($this->aadhaar_verify_datetime->ViewValue, 0);
		$this->aadhaar_verify_datetime->ViewCustomAttributes = "";

		// thumb_data
		$this->thumb_data->ViewValue = $this->thumb_data->CurrentValue;
		$this->thumb_data->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// qty
		$this->qty->LinkCustomAttributes = "";
		if (!EmptyValue($this->id->CurrentValue)) {
			$this->qty->HrefValue = "share_transferadd.php?FN=" . $this->id->CurrentValue; // Add prefix/suffix
			$this->qty->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->qty->HrefValue = FullUrl($this->qty->HrefValue, "href");
		} else {
			$this->qty->HrefValue = "";
		}
		$this->qty->TooltipValue = "";

		// aadhaar_no
		$this->aadhaar_no->LinkCustomAttributes = "";
		$this->aadhaar_no->HrefValue = "";
		$this->aadhaar_no->TooltipValue = "";

		// name
		$this->name->LinkCustomAttributes = "";
		$this->name->HrefValue = "";
		$this->name->TooltipValue = "";

		// gender
		$this->gender->LinkCustomAttributes = "";
		$this->gender->HrefValue = "";
		$this->gender->TooltipValue = "";

		// dob
		$this->dob->LinkCustomAttributes = "";
		$this->dob->HrefValue = "";
		$this->dob->TooltipValue = "";

		// mobile
		$this->mobile->LinkCustomAttributes = "";
		$this->mobile->HrefValue = "";
		$this->mobile->TooltipValue = "";

		// email
		$this->_email->LinkCustomAttributes = "";
		$this->_email->HrefValue = "";
		$this->_email->TooltipValue = "";

		// address
		$this->address->LinkCustomAttributes = "";
		$this->address->HrefValue = "";
		$this->address->TooltipValue = "";

		// care_of
		$this->care_of->LinkCustomAttributes = "";
		$this->care_of->HrefValue = "";
		$this->care_of->TooltipValue = "";

		// father_name
		$this->father_name->LinkCustomAttributes = "";
		$this->father_name->HrefValue = "";
		$this->father_name->TooltipValue = "";

		// mother_name
		$this->mother_name->LinkCustomAttributes = "";
		$this->mother_name->HrefValue = "";
		$this->mother_name->TooltipValue = "";

		// nominee_name
		$this->nominee_name->LinkCustomAttributes = "";
		$this->nominee_name->HrefValue = "";
		$this->nominee_name->TooltipValue = "";

		// nominee_relation
		$this->nominee_relation->LinkCustomAttributes = "";
		$this->nominee_relation->HrefValue = "";
		$this->nominee_relation->TooltipValue = "";

		// pan_no
		$this->pan_no->LinkCustomAttributes = "";
		$this->pan_no->HrefValue = "";
		$this->pan_no->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->HrefValue = "%u"; // Add prefix/suffix
			$this->uploads->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
		} else {
			$this->uploads->HrefValue = "";
		}
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";
		if ($this->uploads->UseColorbox) {
			if (EmptyValue($this->uploads->TooltipValue))
				$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->uploads->LinkAttrs["data-rel"] = "investor_info_x_uploads";
			AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
		}

		// image
		$this->image->LinkCustomAttributes = "";
		$this->image->UploadPath = '.p_uploads/member_info/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
			$this->image->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
		} else {
			$this->image->HrefValue = "";
		}
		$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
		$this->image->TooltipValue = "";
		if ($this->image->UseColorbox) {
			if (EmptyValue($this->image->TooltipValue))
				$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->image->LinkAttrs["data-rel"] = "investor_info_x_image";
			AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
		}

		// adviser
		$this->adviser->LinkCustomAttributes = "";
		$this->adviser->HrefValue = "";
		$this->adviser->TooltipValue = "";

		// share_no
		$this->share_no->LinkCustomAttributes = "";
		$this->share_no->HrefValue = "";
		$this->share_no->TooltipValue = "";

		// inv_start_date
		$this->inv_start_date->LinkCustomAttributes = "";
		$this->inv_start_date->HrefValue = "";
		$this->inv_start_date->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// gurantee
		$this->gurantee->LinkCustomAttributes = "";
		$this->gurantee->HrefValue = "";
		$this->gurantee->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// otp
		$this->otp->LinkCustomAttributes = "";
		$this->otp->HrefValue = "";
		$this->otp->TooltipValue = "";

		// pan_response
		$this->pan_response->LinkCustomAttributes = "";
		$this->pan_response->HrefValue = "";
		$this->pan_response->TooltipValue = "";

		// pan_verify_datetime
		$this->pan_verify_datetime->LinkCustomAttributes = "";
		$this->pan_verify_datetime->HrefValue = "";
		$this->pan_verify_datetime->TooltipValue = "";

		// aadhaar_response
		$this->aadhaar_response->LinkCustomAttributes = "";
		$this->aadhaar_response->HrefValue = "";
		$this->aadhaar_response->TooltipValue = "";

		// aadhaar_verify_datetime
		$this->aadhaar_verify_datetime->LinkCustomAttributes = "";
		$this->aadhaar_verify_datetime->HrefValue = "";
		$this->aadhaar_verify_datetime->TooltipValue = "";

		// thumb_data
		$this->thumb_data->LinkCustomAttributes = "";
		$this->thumb_data->HrefValue = "";
		$this->thumb_data->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// qty
		$this->qty->EditAttrs["class"] = "form-control";
		$this->qty->EditCustomAttributes = "";
		$this->qty->EditValue = $this->qty->CurrentValue;
		$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

		// aadhaar_no
		$this->aadhaar_no->EditAttrs["class"] = "form-control";
		$this->aadhaar_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
		$this->aadhaar_no->EditValue = $this->aadhaar_no->CurrentValue;
		$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

		// name
		$this->name->EditAttrs["class"] = "form-control";
		$this->name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
		$this->name->EditValue = $this->name->CurrentValue;
		$this->name->PlaceHolder = RemoveHtml($this->name->caption());

		// gender
		$this->gender->EditAttrs["class"] = "form-control";
		$this->gender->EditCustomAttributes = "";
		$this->gender->EditValue = $this->gender->options(TRUE);

		// dob
		$this->dob->EditAttrs["class"] = "form-control";
		$this->dob->EditCustomAttributes = "";
		$this->dob->EditValue = FormatDateTime($this->dob->CurrentValue, 7);
		$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

		// mobile
		$this->mobile->EditAttrs["class"] = "form-control";
		$this->mobile->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
		$this->mobile->EditValue = $this->mobile->CurrentValue;
		$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

		// email
		$this->_email->EditAttrs["class"] = "form-control";
		$this->_email->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
		$this->_email->EditValue = $this->_email->CurrentValue;
		$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

		// address
		$this->address->EditAttrs["class"] = "form-control";
		$this->address->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
		$this->address->EditValue = $this->address->CurrentValue;
		$this->address->PlaceHolder = RemoveHtml($this->address->caption());

		// care_of
		$this->care_of->EditAttrs["class"] = "form-control";
		$this->care_of->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->care_of->CurrentValue = HtmlDecode($this->care_of->CurrentValue);
		$this->care_of->EditValue = $this->care_of->CurrentValue;
		$this->care_of->PlaceHolder = RemoveHtml($this->care_of->caption());

		// father_name
		$this->father_name->EditAttrs["class"] = "form-control";
		$this->father_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
		$this->father_name->EditValue = $this->father_name->CurrentValue;
		$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

		// mother_name
		$this->mother_name->EditAttrs["class"] = "form-control";
		$this->mother_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
		$this->mother_name->EditValue = $this->mother_name->CurrentValue;
		$this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

		// nominee_name
		$this->nominee_name->EditAttrs["class"] = "form-control";
		$this->nominee_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->nominee_name->CurrentValue = HtmlDecode($this->nominee_name->CurrentValue);
		$this->nominee_name->EditValue = $this->nominee_name->CurrentValue;
		$this->nominee_name->PlaceHolder = RemoveHtml($this->nominee_name->caption());

		// nominee_relation
		$this->nominee_relation->EditAttrs["class"] = "form-control";
		$this->nominee_relation->EditCustomAttributes = "";
		$this->nominee_relation->EditValue = $this->nominee_relation->options(TRUE);

		// pan_no
		$this->pan_no->EditAttrs["class"] = "form-control";
		$this->pan_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
		$this->pan_no->EditValue = $this->pan_no->CurrentValue;
		$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// image
		$this->image->EditAttrs["class"] = "form-control";
		$this->image->EditCustomAttributes = "";
		$this->image->UploadPath = '.p_uploads/member_info/';
		if (!EmptyValue($this->image->Upload->DbValue)) {
			$this->image->ImageWidth = 0;
			$this->image->ImageHeight = 50;
			$this->image->ImageAlt = $this->image->alt();
			$this->image->EditValue = $this->image->Upload->DbValue;
		} else {
			$this->image->EditValue = "";
		}
		if (!EmptyValue($this->image->CurrentValue))
				$this->image->Upload->FileName = $this->image->CurrentValue;

		// adviser
		$this->adviser->EditAttrs["class"] = "form-control";
		$this->adviser->EditCustomAttributes = "";

		// share_no
		$this->share_no->EditAttrs["class"] = "form-control";
		$this->share_no->EditCustomAttributes = 'ReadOnly';
		$this->share_no->EditValue = $this->share_no->CurrentValue;
		$this->share_no->PlaceHolder = RemoveHtml($this->share_no->caption());

		// inv_start_date
		$this->inv_start_date->EditAttrs["class"] = "form-control";
		$this->inv_start_date->EditCustomAttributes = "";
		$this->inv_start_date->EditValue = FormatDateTime($this->inv_start_date->CurrentValue, 8);
		$this->inv_start_date->PlaceHolder = RemoveHtml($this->inv_start_date->caption());

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
		if (strval($this->amount->EditValue) <> "" && is_numeric($this->amount->EditValue))
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, -2, -2, -2, -2);

		// gurantee
		$this->gurantee->EditAttrs["class"] = "form-control";
		$this->gurantee->EditCustomAttributes = "";
		$this->gurantee->EditValue = $this->gurantee->CurrentValue;
		$this->gurantee->PlaceHolder = RemoveHtml($this->gurantee->caption());
		if (strval($this->gurantee->EditValue) <> "" && is_numeric($this->gurantee->EditValue))
			$this->gurantee->EditValue = FormatNumber($this->gurantee->EditValue, -2, -2, -2, -2);

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// operator
		// datetime
		// otp

		$this->otp->EditAttrs["class"] = "form-control";
		$this->otp->EditCustomAttributes = "";
		$this->otp->EditValue = $this->otp->CurrentValue;
		$this->otp->PlaceHolder = RemoveHtml($this->otp->caption());

		// pan_response
		$this->pan_response->EditAttrs["class"] = "form-control";
		$this->pan_response->EditCustomAttributes = "";
		$this->pan_response->EditValue = $this->pan_response->CurrentValue;
		$this->pan_response->ViewCustomAttributes = "";

		// pan_verify_datetime
		$this->pan_verify_datetime->EditAttrs["class"] = "form-control";
		$this->pan_verify_datetime->EditCustomAttributes = "";
		$this->pan_verify_datetime->EditValue = FormatDateTime($this->pan_verify_datetime->CurrentValue, 8);
		$this->pan_verify_datetime->PlaceHolder = RemoveHtml($this->pan_verify_datetime->caption());

		// aadhaar_response
		$this->aadhaar_response->EditAttrs["class"] = "form-control";
		$this->aadhaar_response->EditCustomAttributes = "";
		$this->aadhaar_response->EditValue = $this->aadhaar_response->CurrentValue;
		$this->aadhaar_response->ViewCustomAttributes = "";

		// aadhaar_verify_datetime
		$this->aadhaar_verify_datetime->EditAttrs["class"] = "form-control";
		$this->aadhaar_verify_datetime->EditCustomAttributes = "";
		$this->aadhaar_verify_datetime->EditValue = FormatDateTime($this->aadhaar_verify_datetime->CurrentValue, 8);
		$this->aadhaar_verify_datetime->PlaceHolder = RemoveHtml($this->aadhaar_verify_datetime->caption());

		// thumb_data
		$this->thumb_data->EditAttrs["class"] = "form-control";
		$this->thumb_data->EditCustomAttributes = "";
		$this->thumb_data->EditValue = $this->thumb_data->CurrentValue;
		$this->thumb_data->PlaceHolder = RemoveHtml($this->thumb_data->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->qty->CurrentValue))
				$this->qty->Total += $this->qty->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->qty->CurrentValue = $this->qty->Total;
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";
			$this->qty->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->dob);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->care_of);
					$doc->exportCaption($this->father_name);
					$doc->exportCaption($this->mother_name);
					$doc->exportCaption($this->nominee_name);
					$doc->exportCaption($this->nominee_relation);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->image);
					$doc->exportCaption($this->adviser);
					$doc->exportCaption($this->share_no);
					$doc->exportCaption($this->inv_start_date);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->gurantee);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->qty);
					$doc->exportCaption($this->aadhaar_no);
					$doc->exportCaption($this->name);
					$doc->exportCaption($this->gender);
					$doc->exportCaption($this->dob);
					$doc->exportCaption($this->mobile);
					$doc->exportCaption($this->_email);
					$doc->exportCaption($this->address);
					$doc->exportCaption($this->care_of);
					$doc->exportCaption($this->father_name);
					$doc->exportCaption($this->mother_name);
					$doc->exportCaption($this->nominee_name);
					$doc->exportCaption($this->nominee_relation);
					$doc->exportCaption($this->pan_no);
					$doc->exportCaption($this->adviser);
					$doc->exportCaption($this->inv_start_date);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->gurantee);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->qty);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->name);
						$doc->exportField($this->gender);
						$doc->exportField($this->dob);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->address);
						$doc->exportField($this->care_of);
						$doc->exportField($this->father_name);
						$doc->exportField($this->mother_name);
						$doc->exportField($this->nominee_name);
						$doc->exportField($this->nominee_relation);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->uploads);
						$doc->exportField($this->image);
						$doc->exportField($this->adviser);
						$doc->exportField($this->share_no);
						$doc->exportField($this->inv_start_date);
						$doc->exportField($this->amount);
						$doc->exportField($this->gurantee);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->qty);
						$doc->exportField($this->aadhaar_no);
						$doc->exportField($this->name);
						$doc->exportField($this->gender);
						$doc->exportField($this->dob);
						$doc->exportField($this->mobile);
						$doc->exportField($this->_email);
						$doc->exportField($this->address);
						$doc->exportField($this->care_of);
						$doc->exportField($this->father_name);
						$doc->exportField($this->mother_name);
						$doc->exportField($this->nominee_name);
						$doc->exportField($this->nominee_relation);
						$doc->exportField($this->pan_no);
						$doc->exportField($this->adviser);
						$doc->exportField($this->inv_start_date);
						$doc->exportField($this->amount);
						$doc->exportField($this->gurantee);
						$doc->exportField($this->remarks);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->qty, 'TOTAL');
				$doc->exportAggregate($this->aadhaar_no, '');
				$doc->exportAggregate($this->name, '');
				$doc->exportAggregate($this->gender, '');
				$doc->exportAggregate($this->dob, '');
				$doc->exportAggregate($this->mobile, '');
				$doc->exportAggregate($this->_email, '');
				$doc->exportAggregate($this->address, '');
				$doc->exportAggregate($this->care_of, '');
				$doc->exportAggregate($this->father_name, '');
				$doc->exportAggregate($this->mother_name, '');
				$doc->exportAggregate($this->nominee_name, '');
				$doc->exportAggregate($this->nominee_relation, '');
				$doc->exportAggregate($this->pan_no, '');
				$doc->exportAggregate($this->adviser, '');
				$doc->exportAggregate($this->inv_start_date, '');
				$doc->exportAggregate($this->amount, '');
				$doc->exportAggregate($this->gurantee, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} elseif ($fldparm == 'image') {
			$fldName = "image";
			$fileNameFld = "image";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>