<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class investor_info_add extends investor_info
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'investor_info';

	// Page object name
	public $PageObjName = "investor_info_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (investor_info)
		if (!isset($GLOBALS["investor_info"]) || get_class($GLOBALS["investor_info"]) == PROJECT_NAMESPACE . "investor_info") {
			$GLOBALS["investor_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["investor_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'investor_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $investor_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($investor_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "investor_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("investor_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->qty->Visible = FALSE;
		$this->aadhaar_no->setVisibility();
		$this->name->setVisibility();
		$this->gender->setVisibility();
		$this->dob->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->address->setVisibility();
		$this->care_of->setVisibility();
		$this->father_name->setVisibility();
		$this->mother_name->setVisibility();
		$this->nominee_name->setVisibility();
		$this->nominee_relation->setVisibility();
		$this->pan_no->setVisibility();
		$this->uploads->setVisibility();
		$this->image->Visible = FALSE;
		$this->adviser->setVisibility();
		$this->share_no->setVisibility();
		$this->inv_start_date->Visible = FALSE;
		$this->amount->Visible = FALSE;
		$this->gurantee->Visible = FALSE;
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->otp->Visible = FALSE;
		$this->pan_response->Visible = FALSE;
		$this->pan_verify_datetime->Visible = FALSE;
		$this->aadhaar_response->Visible = FALSE;
		$this->aadhaar_verify_datetime->Visible = FALSE;
		$this->thumb_data->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->adviser);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("investor_infolist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = 'autoprogramme.php?apcid=6fc6754722b8e76ed6808d9ee828e7e6';
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->qty->CurrentValue = NULL;
		$this->qty->OldValue = $this->qty->CurrentValue;
		$this->aadhaar_no->CurrentValue = NULL;
		$this->aadhaar_no->OldValue = $this->aadhaar_no->CurrentValue;
		$this->name->CurrentValue = NULL;
		$this->name->OldValue = $this->name->CurrentValue;
		$this->gender->CurrentValue = NULL;
		$this->gender->OldValue = $this->gender->CurrentValue;
		$this->dob->CurrentValue = NULL;
		$this->dob->OldValue = $this->dob->CurrentValue;
		$this->mobile->CurrentValue = NULL;
		$this->mobile->OldValue = $this->mobile->CurrentValue;
		$this->_email->CurrentValue = NULL;
		$this->_email->OldValue = $this->_email->CurrentValue;
		$this->address->CurrentValue = NULL;
		$this->address->OldValue = $this->address->CurrentValue;
		$this->care_of->CurrentValue = NULL;
		$this->care_of->OldValue = $this->care_of->CurrentValue;
		$this->father_name->CurrentValue = NULL;
		$this->father_name->OldValue = $this->father_name->CurrentValue;
		$this->mother_name->CurrentValue = NULL;
		$this->mother_name->OldValue = $this->mother_name->CurrentValue;
		$this->nominee_name->CurrentValue = NULL;
		$this->nominee_name->OldValue = $this->nominee_name->CurrentValue;
		$this->nominee_relation->CurrentValue = NULL;
		$this->nominee_relation->OldValue = $this->nominee_relation->CurrentValue;
		$this->pan_no->CurrentValue = NULL;
		$this->pan_no->OldValue = $this->pan_no->CurrentValue;
		$this->uploads->Upload->DbValue = NULL;
		$this->uploads->OldValue = $this->uploads->Upload->DbValue;
		$this->uploads->CurrentValue = NULL; // Clear file related field
		$this->image->Upload->DbValue = NULL;
		$this->image->OldValue = $this->image->Upload->DbValue;
		$this->image->CurrentValue = NULL; // Clear file related field
		$this->adviser->CurrentValue = NULL;
		$this->adviser->OldValue = $this->adviser->CurrentValue;
		$this->share_no->CurrentValue = NULL;
		$this->share_no->OldValue = $this->share_no->CurrentValue;
		$this->inv_start_date->CurrentValue = NULL;
		$this->inv_start_date->OldValue = $this->inv_start_date->CurrentValue;
		$this->amount->CurrentValue = NULL;
		$this->amount->OldValue = $this->amount->CurrentValue;
		$this->gurantee->CurrentValue = NULL;
		$this->gurantee->OldValue = $this->gurantee->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->otp->CurrentValue = NULL;
		$this->otp->OldValue = $this->otp->CurrentValue;
		$this->pan_response->CurrentValue = NULL;
		$this->pan_response->OldValue = $this->pan_response->CurrentValue;
		$this->pan_verify_datetime->CurrentValue = NULL;
		$this->pan_verify_datetime->OldValue = $this->pan_verify_datetime->CurrentValue;
		$this->aadhaar_response->CurrentValue = NULL;
		$this->aadhaar_response->OldValue = $this->aadhaar_response->CurrentValue;
		$this->aadhaar_verify_datetime->CurrentValue = NULL;
		$this->aadhaar_verify_datetime->OldValue = $this->aadhaar_verify_datetime->CurrentValue;
		$this->thumb_data->CurrentValue = NULL;
		$this->thumb_data->OldValue = $this->thumb_data->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'aadhaar_no' first before field var 'x_aadhaar_no'
		$val = $CurrentForm->hasValue("aadhaar_no") ? $CurrentForm->getValue("aadhaar_no") : $CurrentForm->getValue("x_aadhaar_no");
		if (!$this->aadhaar_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->aadhaar_no->Visible = FALSE; // Disable update for API request
			else
				$this->aadhaar_no->setFormValue($val);
		}

		// Check field name 'name' first before field var 'x_name'
		$val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
		if (!$this->name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->name->Visible = FALSE; // Disable update for API request
			else
				$this->name->setFormValue($val);
		}

		// Check field name 'gender' first before field var 'x_gender'
		$val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
		if (!$this->gender->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gender->Visible = FALSE; // Disable update for API request
			else
				$this->gender->setFormValue($val);
		}

		// Check field name 'dob' first before field var 'x_dob'
		$val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
		if (!$this->dob->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dob->Visible = FALSE; // Disable update for API request
			else
				$this->dob->setFormValue($val);
			$this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, 7);
		}

		// Check field name 'mobile' first before field var 'x_mobile'
		$val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
		if (!$this->mobile->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mobile->Visible = FALSE; // Disable update for API request
			else
				$this->mobile->setFormValue($val);
		}

		// Check field name 'email' first before field var 'x__email'
		$val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
		if (!$this->_email->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_email->Visible = FALSE; // Disable update for API request
			else
				$this->_email->setFormValue($val);
		}

		// Check field name 'address' first before field var 'x_address'
		$val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
		if (!$this->address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->address->Visible = FALSE; // Disable update for API request
			else
				$this->address->setFormValue($val);
		}

		// Check field name 'care_of' first before field var 'x_care_of'
		$val = $CurrentForm->hasValue("care_of") ? $CurrentForm->getValue("care_of") : $CurrentForm->getValue("x_care_of");
		if (!$this->care_of->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->care_of->Visible = FALSE; // Disable update for API request
			else
				$this->care_of->setFormValue($val);
		}

		// Check field name 'father_name' first before field var 'x_father_name'
		$val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
		if (!$this->father_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->father_name->Visible = FALSE; // Disable update for API request
			else
				$this->father_name->setFormValue($val);
		}

		// Check field name 'mother_name' first before field var 'x_mother_name'
		$val = $CurrentForm->hasValue("mother_name") ? $CurrentForm->getValue("mother_name") : $CurrentForm->getValue("x_mother_name");
		if (!$this->mother_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->mother_name->Visible = FALSE; // Disable update for API request
			else
				$this->mother_name->setFormValue($val);
		}

		// Check field name 'nominee_name' first before field var 'x_nominee_name'
		$val = $CurrentForm->hasValue("nominee_name") ? $CurrentForm->getValue("nominee_name") : $CurrentForm->getValue("x_nominee_name");
		if (!$this->nominee_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nominee_name->Visible = FALSE; // Disable update for API request
			else
				$this->nominee_name->setFormValue($val);
		}

		// Check field name 'nominee_relation' first before field var 'x_nominee_relation'
		$val = $CurrentForm->hasValue("nominee_relation") ? $CurrentForm->getValue("nominee_relation") : $CurrentForm->getValue("x_nominee_relation");
		if (!$this->nominee_relation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nominee_relation->Visible = FALSE; // Disable update for API request
			else
				$this->nominee_relation->setFormValue($val);
		}

		// Check field name 'pan_no' first before field var 'x_pan_no'
		$val = $CurrentForm->hasValue("pan_no") ? $CurrentForm->getValue("pan_no") : $CurrentForm->getValue("x_pan_no");
		if (!$this->pan_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pan_no->Visible = FALSE; // Disable update for API request
			else
				$this->pan_no->setFormValue($val);
		}

		// Check field name 'adviser' first before field var 'x_adviser'
		$val = $CurrentForm->hasValue("adviser") ? $CurrentForm->getValue("adviser") : $CurrentForm->getValue("x_adviser");
		if (!$this->adviser->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->adviser->Visible = FALSE; // Disable update for API request
			else
				$this->adviser->setFormValue($val);
		}

		// Check field name 'share_no' first before field var 'x_share_no'
		$val = $CurrentForm->hasValue("share_no") ? $CurrentForm->getValue("share_no") : $CurrentForm->getValue("x_share_no");
		if (!$this->share_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->share_no->Visible = FALSE; // Disable update for API request
			else
				$this->share_no->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->aadhaar_no->CurrentValue = $this->aadhaar_no->FormValue;
		$this->name->CurrentValue = $this->name->FormValue;
		$this->gender->CurrentValue = $this->gender->FormValue;
		$this->dob->CurrentValue = $this->dob->FormValue;
		$this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, 7);
		$this->mobile->CurrentValue = $this->mobile->FormValue;
		$this->_email->CurrentValue = $this->_email->FormValue;
		$this->address->CurrentValue = $this->address->FormValue;
		$this->care_of->CurrentValue = $this->care_of->FormValue;
		$this->father_name->CurrentValue = $this->father_name->FormValue;
		$this->mother_name->CurrentValue = $this->mother_name->FormValue;
		$this->nominee_name->CurrentValue = $this->nominee_name->FormValue;
		$this->nominee_relation->CurrentValue = $this->nominee_relation->FormValue;
		$this->pan_no->CurrentValue = $this->pan_no->FormValue;
		$this->adviser->CurrentValue = $this->adviser->FormValue;
		$this->share_no->CurrentValue = $this->share_no->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->qty->setDbValue($row['qty']);
		$this->aadhaar_no->setDbValue($row['aadhaar_no']);
		$this->name->setDbValue($row['name']);
		$this->gender->setDbValue($row['gender']);
		$this->dob->setDbValue($row['dob']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->address->setDbValue($row['address']);
		$this->care_of->setDbValue($row['care_of']);
		$this->father_name->setDbValue($row['father_name']);
		$this->mother_name->setDbValue($row['mother_name']);
		$this->nominee_name->setDbValue($row['nominee_name']);
		$this->nominee_relation->setDbValue($row['nominee_relation']);
		$this->pan_no->setDbValue($row['pan_no']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->adviser->setDbValue($row['adviser']);
		$this->share_no->setDbValue($row['share_no']);
		$this->inv_start_date->setDbValue($row['inv_start_date']);
		$this->amount->setDbValue($row['amount']);
		$this->gurantee->setDbValue($row['gurantee']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->otp->setDbValue($row['otp']);
		$this->pan_response->setDbValue($row['pan_response']);
		$this->pan_verify_datetime->setDbValue($row['pan_verify_datetime']);
		$this->aadhaar_response->setDbValue($row['aadhaar_response']);
		$this->aadhaar_verify_datetime->setDbValue($row['aadhaar_verify_datetime']);
		$this->thumb_data->setDbValue($row['thumb_data']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['qty'] = $this->qty->CurrentValue;
		$row['aadhaar_no'] = $this->aadhaar_no->CurrentValue;
		$row['name'] = $this->name->CurrentValue;
		$row['gender'] = $this->gender->CurrentValue;
		$row['dob'] = $this->dob->CurrentValue;
		$row['mobile'] = $this->mobile->CurrentValue;
		$row['email'] = $this->_email->CurrentValue;
		$row['address'] = $this->address->CurrentValue;
		$row['care_of'] = $this->care_of->CurrentValue;
		$row['father_name'] = $this->father_name->CurrentValue;
		$row['mother_name'] = $this->mother_name->CurrentValue;
		$row['nominee_name'] = $this->nominee_name->CurrentValue;
		$row['nominee_relation'] = $this->nominee_relation->CurrentValue;
		$row['pan_no'] = $this->pan_no->CurrentValue;
		$row['uploads'] = $this->uploads->Upload->DbValue;
		$row['image'] = $this->image->Upload->DbValue;
		$row['adviser'] = $this->adviser->CurrentValue;
		$row['share_no'] = $this->share_no->CurrentValue;
		$row['inv_start_date'] = $this->inv_start_date->CurrentValue;
		$row['amount'] = $this->amount->CurrentValue;
		$row['gurantee'] = $this->gurantee->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['otp'] = $this->otp->CurrentValue;
		$row['pan_response'] = $this->pan_response->CurrentValue;
		$row['pan_verify_datetime'] = $this->pan_verify_datetime->CurrentValue;
		$row['aadhaar_response'] = $this->aadhaar_response->CurrentValue;
		$row['aadhaar_verify_datetime'] = $this->aadhaar_verify_datetime->CurrentValue;
		$row['thumb_data'] = $this->thumb_data->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// qty
		// aadhaar_no
		// name
		// gender
		// dob
		// mobile
		// email
		// address
		// care_of
		// father_name
		// mother_name
		// nominee_name
		// nominee_relation
		// pan_no
		// uploads
		// image
		// adviser
		// share_no
		// inv_start_date
		// amount
		// gurantee
		// remarks
		// operator
		// datetime
		// otp
		// pan_response
		// pan_verify_datetime
		// aadhaar_response
		// aadhaar_verify_datetime
		// thumb_data

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) <> "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// dob
			$this->dob->ViewValue = $this->dob->CurrentValue;
			$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 7);
			$this->dob->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// care_of
			$this->care_of->ViewValue = $this->care_of->CurrentValue;
			$this->care_of->ViewCustomAttributes = "";

			// father_name
			$this->father_name->ViewValue = $this->father_name->CurrentValue;
			$this->father_name->ViewCustomAttributes = "";

			// mother_name
			$this->mother_name->ViewValue = $this->mother_name->CurrentValue;
			$this->mother_name->ViewCustomAttributes = "";

			// nominee_name
			$this->nominee_name->ViewValue = $this->nominee_name->CurrentValue;
			$this->nominee_name->ViewCustomAttributes = "";

			// nominee_relation
			if (strval($this->nominee_relation->CurrentValue) <> "") {
				$this->nominee_relation->ViewValue = $this->nominee_relation->optionCaption($this->nominee_relation->CurrentValue);
			} else {
				$this->nominee_relation->ViewValue = NULL;
			}
			$this->nominee_relation->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// adviser
			$curVal = strval($this->adviser->CurrentValue);
			if ($curVal <> "") {
				$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
				if ($this->adviser->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->adviser->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->adviser->ViewValue = $this->adviser->CurrentValue;
					}
				}
			} else {
				$this->adviser->ViewValue = NULL;
			}
			$this->adviser->ViewCustomAttributes = "";

			// share_no
			$this->share_no->ViewValue = $this->share_no->CurrentValue;
			$this->share_no->ViewCustomAttributes = "";

			// inv_start_date
			$this->inv_start_date->ViewValue = $this->inv_start_date->CurrentValue;
			$this->inv_start_date->ViewValue = FormatDateTime($this->inv_start_date->ViewValue, 0);
			$this->inv_start_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// gurantee
			$this->gurantee->ViewValue = $this->gurantee->CurrentValue;
			$this->gurantee->ViewValue = FormatNumber($this->gurantee->ViewValue, 2, -2, -2, -2);
			$this->gurantee->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";
			$this->dob->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// care_of
			$this->care_of->LinkCustomAttributes = "";
			$this->care_of->HrefValue = "";
			$this->care_of->TooltipValue = "";

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";
			$this->father_name->TooltipValue = "";

			// mother_name
			$this->mother_name->LinkCustomAttributes = "";
			$this->mother_name->HrefValue = "";
			$this->mother_name->TooltipValue = "";

			// nominee_name
			$this->nominee_name->LinkCustomAttributes = "";
			$this->nominee_name->HrefValue = "";
			$this->nominee_name->TooltipValue = "";

			// nominee_relation
			$this->nominee_relation->LinkCustomAttributes = "";
			$this->nominee_relation->HrefValue = "";
			$this->nominee_relation->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "investor_info_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// adviser
			$this->adviser->LinkCustomAttributes = "";
			$this->adviser->HrefValue = "";
			$this->adviser->TooltipValue = "";

			// share_no
			$this->share_no->LinkCustomAttributes = "";
			$this->share_no->HrefValue = "";
			$this->share_no->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->CurrentValue = HtmlDecode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->CurrentValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
			$this->name->EditValue = HtmlEncode($this->name->CurrentValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// gender
			$this->gender->EditAttrs["class"] = "form-control";
			$this->gender->EditCustomAttributes = "";
			$this->gender->EditValue = $this->gender->options(TRUE);

			// dob
			$this->dob->EditAttrs["class"] = "form-control";
			$this->dob->EditCustomAttributes = "";
			$this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, 7));
			$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
			$this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
			$this->address->EditValue = HtmlEncode($this->address->CurrentValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// care_of
			$this->care_of->EditAttrs["class"] = "form-control";
			$this->care_of->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->care_of->CurrentValue = HtmlDecode($this->care_of->CurrentValue);
			$this->care_of->EditValue = HtmlEncode($this->care_of->CurrentValue);
			$this->care_of->PlaceHolder = RemoveHtml($this->care_of->caption());

			// father_name
			$this->father_name->EditAttrs["class"] = "form-control";
			$this->father_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
			$this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
			$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

			// mother_name
			$this->mother_name->EditAttrs["class"] = "form-control";
			$this->mother_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
			$this->mother_name->EditValue = HtmlEncode($this->mother_name->CurrentValue);
			$this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

			// nominee_name
			$this->nominee_name->EditAttrs["class"] = "form-control";
			$this->nominee_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->nominee_name->CurrentValue = HtmlDecode($this->nominee_name->CurrentValue);
			$this->nominee_name->EditValue = HtmlEncode($this->nominee_name->CurrentValue);
			$this->nominee_name->PlaceHolder = RemoveHtml($this->nominee_name->caption());

			// nominee_relation
			$this->nominee_relation->EditAttrs["class"] = "form-control";
			$this->nominee_relation->EditCustomAttributes = "";
			$this->nominee_relation->EditValue = $this->nominee_relation->options(TRUE);

			// pan_no
			$this->pan_no->EditAttrs["class"] = "form-control";
			$this->pan_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_no->CurrentValue = HtmlDecode($this->pan_no->CurrentValue);
			$this->pan_no->EditValue = HtmlEncode($this->pan_no->CurrentValue);
			$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if (($this->isShow() || $this->isCopy()) && !$this->EventCancelled)
				RenderUploadField($this->uploads);

			// adviser
			$this->adviser->EditAttrs["class"] = "form-control";
			$this->adviser->EditCustomAttributes = "";
			$curVal = trim(strval($this->adviser->CurrentValue));
			if ($curVal <> "")
				$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
			else
				$this->adviser->ViewValue = $this->adviser->Lookup !== NULL && is_array($this->adviser->Lookup->Options) ? $curVal : NULL;
			if ($this->adviser->ViewValue !== NULL) { // Load from cache
				$this->adviser->EditValue = array_values($this->adviser->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->adviser->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`userlevel`=1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->adviser->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->adviser->EditValue = $arwrk;
			}

			// share_no
			$this->share_no->EditAttrs["class"] = "form-control";
			$this->share_no->EditCustomAttributes = 'ReadOnly';
			$this->share_no->EditValue = HtmlEncode($this->share_no->CurrentValue);
			$this->share_no->PlaceHolder = RemoveHtml($this->share_no->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			// datetime
			// Add refer script
			// aadhaar_no

			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";

			// care_of
			$this->care_of->LinkCustomAttributes = "";
			$this->care_of->HrefValue = "";

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";

			// mother_name
			$this->mother_name->LinkCustomAttributes = "";
			$this->mother_name->HrefValue = "";

			// nominee_name
			$this->nominee_name->LinkCustomAttributes = "";
			$this->nominee_name->HrefValue = "";

			// nominee_relation
			$this->nominee_relation->LinkCustomAttributes = "";
			$this->nominee_relation->HrefValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// adviser
			$this->adviser->LinkCustomAttributes = "";
			$this->adviser->HrefValue = "";

			// share_no
			$this->share_no->LinkCustomAttributes = "";
			$this->share_no->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->qty->Required) {
			if (!$this->qty->IsDetailKey && $this->qty->FormValue != NULL && $this->qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->qty->caption(), $this->qty->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar_no->Required) {
			if (!$this->aadhaar_no->IsDetailKey && $this->aadhaar_no->FormValue != NULL && $this->aadhaar_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar_no->caption(), $this->aadhaar_no->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->aadhaar_no->FormValue)) {
			AddMessage($FormError, $this->aadhaar_no->errorMessage());
		}
		if ($this->name->Required) {
			if (!$this->name->IsDetailKey && $this->name->FormValue != NULL && $this->name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
			}
		}
		if ($this->gender->Required) {
			if (!$this->gender->IsDetailKey && $this->gender->FormValue != NULL && $this->gender->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
			}
		}
		if ($this->dob->Required) {
			if (!$this->dob->IsDetailKey && $this->dob->FormValue != NULL && $this->dob->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
			}
		}
		if ($this->mobile->Required) {
			if (!$this->mobile->IsDetailKey && $this->mobile->FormValue != NULL && $this->mobile->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
			}
		}
		if ($this->_email->Required) {
			if (!$this->_email->IsDetailKey && $this->_email->FormValue != NULL && $this->_email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
			}
		}
		if ($this->address->Required) {
			if (!$this->address->IsDetailKey && $this->address->FormValue != NULL && $this->address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
			}
		}
		if ($this->care_of->Required) {
			if (!$this->care_of->IsDetailKey && $this->care_of->FormValue != NULL && $this->care_of->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->care_of->caption(), $this->care_of->RequiredErrorMessage));
			}
		}
		if ($this->father_name->Required) {
			if (!$this->father_name->IsDetailKey && $this->father_name->FormValue != NULL && $this->father_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
			}
		}
		if ($this->mother_name->Required) {
			if (!$this->mother_name->IsDetailKey && $this->mother_name->FormValue != NULL && $this->mother_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->mother_name->caption(), $this->mother_name->RequiredErrorMessage));
			}
		}
		if ($this->nominee_name->Required) {
			if (!$this->nominee_name->IsDetailKey && $this->nominee_name->FormValue != NULL && $this->nominee_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nominee_name->caption(), $this->nominee_name->RequiredErrorMessage));
			}
		}
		if ($this->nominee_relation->Required) {
			if (!$this->nominee_relation->IsDetailKey && $this->nominee_relation->FormValue != NULL && $this->nominee_relation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nominee_relation->caption(), $this->nominee_relation->RequiredErrorMessage));
			}
		}
		if ($this->pan_no->Required) {
			if (!$this->pan_no->IsDetailKey && $this->pan_no->FormValue != NULL && $this->pan_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan_no->caption(), $this->pan_no->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->image->Required) {
			if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
			}
		}
		if ($this->adviser->Required) {
			if (!$this->adviser->IsDetailKey && $this->adviser->FormValue != NULL && $this->adviser->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->adviser->caption(), $this->adviser->RequiredErrorMessage));
			}
		}
		if ($this->share_no->Required) {
			if (!$this->share_no->IsDetailKey && $this->share_no->FormValue != NULL && $this->share_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->share_no->caption(), $this->share_no->RequiredErrorMessage));
			}
		}
		if ($this->inv_start_date->Required) {
			if (!$this->inv_start_date->IsDetailKey && $this->inv_start_date->FormValue != NULL && $this->inv_start_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->inv_start_date->caption(), $this->inv_start_date->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if ($this->gurantee->Required) {
			if (!$this->gurantee->IsDetailKey && $this->gurantee->FormValue != NULL && $this->gurantee->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gurantee->caption(), $this->gurantee->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->otp->Required) {
			if (!$this->otp->IsDetailKey && $this->otp->FormValue != NULL && $this->otp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->otp->caption(), $this->otp->RequiredErrorMessage));
			}
		}
		if ($this->pan_response->Required) {
			if (!$this->pan_response->IsDetailKey && $this->pan_response->FormValue != NULL && $this->pan_response->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan_response->caption(), $this->pan_response->RequiredErrorMessage));
			}
		}
		if ($this->pan_verify_datetime->Required) {
			if (!$this->pan_verify_datetime->IsDetailKey && $this->pan_verify_datetime->FormValue != NULL && $this->pan_verify_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan_verify_datetime->caption(), $this->pan_verify_datetime->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar_response->Required) {
			if (!$this->aadhaar_response->IsDetailKey && $this->aadhaar_response->FormValue != NULL && $this->aadhaar_response->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar_response->caption(), $this->aadhaar_response->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar_verify_datetime->Required) {
			if (!$this->aadhaar_verify_datetime->IsDetailKey && $this->aadhaar_verify_datetime->FormValue != NULL && $this->aadhaar_verify_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar_verify_datetime->caption(), $this->aadhaar_verify_datetime->RequiredErrorMessage));
			}
		}
		if ($this->thumb_data->Required) {
			if (!$this->thumb_data->IsDetailKey && $this->thumb_data->FormValue != NULL && $this->thumb_data->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->thumb_data->caption(), $this->thumb_data->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->uploads->OldUploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
			$this->image->OldUploadPath = '.p_uploads/member_info/';
			$this->image->UploadPath = $this->image->OldUploadPath;
		}
		$rsnew = [];

		// aadhaar_no
		$this->aadhaar_no->setDbValueDef($rsnew, $this->aadhaar_no->CurrentValue, NULL, FALSE);

		// name
		$this->name->setDbValueDef($rsnew, $this->name->CurrentValue, NULL, FALSE);

		// gender
		$this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, NULL, FALSE);

		// dob
		$this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, 7), NULL, FALSE);

		// mobile
		$this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, NULL, FALSE);

		// email
		$this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, NULL, FALSE);

		// address
		$this->address->setDbValueDef($rsnew, $this->address->CurrentValue, NULL, FALSE);

		// care_of
		$this->care_of->setDbValueDef($rsnew, $this->care_of->CurrentValue, NULL, FALSE);

		// father_name
		$this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, NULL, FALSE);

		// mother_name
		$this->mother_name->setDbValueDef($rsnew, $this->mother_name->CurrentValue, NULL, FALSE);

		// nominee_name
		$this->nominee_name->setDbValueDef($rsnew, $this->nominee_name->CurrentValue, NULL, FALSE);

		// nominee_relation
		$this->nominee_relation->setDbValueDef($rsnew, $this->nominee_relation->CurrentValue, NULL, FALSE);

		// pan_no
		$this->pan_no->setDbValueDef($rsnew, $this->pan_no->CurrentValue, NULL, FALSE);

		// uploads
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->Upload->DbValue = ""; // No need to delete old file
			if ($this->uploads->Upload->FileName == "") {
				$rsnew['uploads'] = NULL;
			} else {
				if ($rsold && $rsold->fields['uploads'] <> "" && $this->uploads->Upload->FileName <> "") {
					$oldFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsold->fields['uploads']);
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->uploads->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i], UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['uploads'] = $this->uploads->Upload->FileName;
			}
			$this->uploads->ImageWidth = 640; // Resize width
			$this->uploads->ImageHeight = 640; // Resize height
		}

		// adviser
		$this->adviser->setDbValueDef($rsnew, $this->adviser->CurrentValue, NULL, FALSE);

		// share_no
		$this->share_no->setDbValueDef($rsnew, $this->share_no->CurrentValue, NULL, FALSE);

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
			if (!EmptyValue($this->uploads->Upload->FileName)) {
				$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->FileName));
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
					if (!EmptyValue($this->uploads->Upload->FileName)) {
						$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
						$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['uploads']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("investor_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_adviser":
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_adviser":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>