<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class investor_info_list extends investor_info
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'investor_info';

	// Page object name
	public $PageObjName = "investor_info_list";

	// Grid form hidden field names
	public $FormName = "finvestor_infolist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (investor_info)
		if (!isset($GLOBALS["investor_info"]) || get_class($GLOBALS["investor_info"]) == PROJECT_NAMESPACE . "investor_info") {
			$GLOBALS["investor_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["investor_info"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "investor_infoadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "investor_infodelete.php";
		$this->MultiUpdateUrl = "investor_infoupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'investor_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option finvestor_infolistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $investor_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($investor_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->qty->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->name->setVisibility();
		$this->gender->setVisibility();
		$this->dob->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->address->setVisibility();
		$this->care_of->setVisibility();
		$this->father_name->setVisibility();
		$this->mother_name->setVisibility();
		$this->nominee_name->setVisibility();
		$this->nominee_relation->setVisibility();
		$this->pan_no->setVisibility();
		$this->uploads->Visible = FALSE;
		$this->image->setVisibility();
		$this->adviser->setVisibility();
		$this->share_no->setVisibility();
		$this->inv_start_date->setVisibility();
		$this->amount->setVisibility();
		$this->gurantee->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->otp->Visible = FALSE;
		$this->pan_response->Visible = FALSE;
		$this->pan_verify_datetime->Visible = FALSE;
		$this->aadhaar_response->Visible = FALSE;
		$this->aadhaar_verify_datetime->Visible = FALSE;
		$this->thumb_data->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->adviser);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "finvestor_infolistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->qty->AdvancedSearch->toJson(), ","); // Field qty
		$filterList = Concat($filterList, $this->aadhaar_no->AdvancedSearch->toJson(), ","); // Field aadhaar_no
		$filterList = Concat($filterList, $this->name->AdvancedSearch->toJson(), ","); // Field name
		$filterList = Concat($filterList, $this->gender->AdvancedSearch->toJson(), ","); // Field gender
		$filterList = Concat($filterList, $this->dob->AdvancedSearch->toJson(), ","); // Field dob
		$filterList = Concat($filterList, $this->mobile->AdvancedSearch->toJson(), ","); // Field mobile
		$filterList = Concat($filterList, $this->_email->AdvancedSearch->toJson(), ","); // Field email
		$filterList = Concat($filterList, $this->address->AdvancedSearch->toJson(), ","); // Field address
		$filterList = Concat($filterList, $this->care_of->AdvancedSearch->toJson(), ","); // Field care_of
		$filterList = Concat($filterList, $this->father_name->AdvancedSearch->toJson(), ","); // Field father_name
		$filterList = Concat($filterList, $this->mother_name->AdvancedSearch->toJson(), ","); // Field mother_name
		$filterList = Concat($filterList, $this->nominee_name->AdvancedSearch->toJson(), ","); // Field nominee_name
		$filterList = Concat($filterList, $this->nominee_relation->AdvancedSearch->toJson(), ","); // Field nominee_relation
		$filterList = Concat($filterList, $this->pan_no->AdvancedSearch->toJson(), ","); // Field pan_no
		$filterList = Concat($filterList, $this->uploads->AdvancedSearch->toJson(), ","); // Field uploads
		$filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
		$filterList = Concat($filterList, $this->adviser->AdvancedSearch->toJson(), ","); // Field adviser
		$filterList = Concat($filterList, $this->share_no->AdvancedSearch->toJson(), ","); // Field share_no
		$filterList = Concat($filterList, $this->inv_start_date->AdvancedSearch->toJson(), ","); // Field inv_start_date
		$filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
		$filterList = Concat($filterList, $this->gurantee->AdvancedSearch->toJson(), ","); // Field gurantee
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		$filterList = Concat($filterList, $this->otp->AdvancedSearch->toJson(), ","); // Field otp
		$filterList = Concat($filterList, $this->pan_response->AdvancedSearch->toJson(), ","); // Field pan_response
		$filterList = Concat($filterList, $this->pan_verify_datetime->AdvancedSearch->toJson(), ","); // Field pan_verify_datetime
		$filterList = Concat($filterList, $this->aadhaar_response->AdvancedSearch->toJson(), ","); // Field aadhaar_response
		$filterList = Concat($filterList, $this->aadhaar_verify_datetime->AdvancedSearch->toJson(), ","); // Field aadhaar_verify_datetime
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "finvestor_infolistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field qty
		$this->qty->AdvancedSearch->SearchValue = @$filter["x_qty"];
		$this->qty->AdvancedSearch->SearchOperator = @$filter["z_qty"];
		$this->qty->AdvancedSearch->SearchCondition = @$filter["v_qty"];
		$this->qty->AdvancedSearch->SearchValue2 = @$filter["y_qty"];
		$this->qty->AdvancedSearch->SearchOperator2 = @$filter["w_qty"];
		$this->qty->AdvancedSearch->save();

		// Field aadhaar_no
		$this->aadhaar_no->AdvancedSearch->SearchValue = @$filter["x_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchOperator = @$filter["z_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchCondition = @$filter["v_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchValue2 = @$filter["y_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->SearchOperator2 = @$filter["w_aadhaar_no"];
		$this->aadhaar_no->AdvancedSearch->save();

		// Field name
		$this->name->AdvancedSearch->SearchValue = @$filter["x_name"];
		$this->name->AdvancedSearch->SearchOperator = @$filter["z_name"];
		$this->name->AdvancedSearch->SearchCondition = @$filter["v_name"];
		$this->name->AdvancedSearch->SearchValue2 = @$filter["y_name"];
		$this->name->AdvancedSearch->SearchOperator2 = @$filter["w_name"];
		$this->name->AdvancedSearch->save();

		// Field gender
		$this->gender->AdvancedSearch->SearchValue = @$filter["x_gender"];
		$this->gender->AdvancedSearch->SearchOperator = @$filter["z_gender"];
		$this->gender->AdvancedSearch->SearchCondition = @$filter["v_gender"];
		$this->gender->AdvancedSearch->SearchValue2 = @$filter["y_gender"];
		$this->gender->AdvancedSearch->SearchOperator2 = @$filter["w_gender"];
		$this->gender->AdvancedSearch->save();

		// Field dob
		$this->dob->AdvancedSearch->SearchValue = @$filter["x_dob"];
		$this->dob->AdvancedSearch->SearchOperator = @$filter["z_dob"];
		$this->dob->AdvancedSearch->SearchCondition = @$filter["v_dob"];
		$this->dob->AdvancedSearch->SearchValue2 = @$filter["y_dob"];
		$this->dob->AdvancedSearch->SearchOperator2 = @$filter["w_dob"];
		$this->dob->AdvancedSearch->save();

		// Field mobile
		$this->mobile->AdvancedSearch->SearchValue = @$filter["x_mobile"];
		$this->mobile->AdvancedSearch->SearchOperator = @$filter["z_mobile"];
		$this->mobile->AdvancedSearch->SearchCondition = @$filter["v_mobile"];
		$this->mobile->AdvancedSearch->SearchValue2 = @$filter["y_mobile"];
		$this->mobile->AdvancedSearch->SearchOperator2 = @$filter["w_mobile"];
		$this->mobile->AdvancedSearch->save();

		// Field email
		$this->_email->AdvancedSearch->SearchValue = @$filter["x__email"];
		$this->_email->AdvancedSearch->SearchOperator = @$filter["z__email"];
		$this->_email->AdvancedSearch->SearchCondition = @$filter["v__email"];
		$this->_email->AdvancedSearch->SearchValue2 = @$filter["y__email"];
		$this->_email->AdvancedSearch->SearchOperator2 = @$filter["w__email"];
		$this->_email->AdvancedSearch->save();

		// Field address
		$this->address->AdvancedSearch->SearchValue = @$filter["x_address"];
		$this->address->AdvancedSearch->SearchOperator = @$filter["z_address"];
		$this->address->AdvancedSearch->SearchCondition = @$filter["v_address"];
		$this->address->AdvancedSearch->SearchValue2 = @$filter["y_address"];
		$this->address->AdvancedSearch->SearchOperator2 = @$filter["w_address"];
		$this->address->AdvancedSearch->save();

		// Field care_of
		$this->care_of->AdvancedSearch->SearchValue = @$filter["x_care_of"];
		$this->care_of->AdvancedSearch->SearchOperator = @$filter["z_care_of"];
		$this->care_of->AdvancedSearch->SearchCondition = @$filter["v_care_of"];
		$this->care_of->AdvancedSearch->SearchValue2 = @$filter["y_care_of"];
		$this->care_of->AdvancedSearch->SearchOperator2 = @$filter["w_care_of"];
		$this->care_of->AdvancedSearch->save();

		// Field father_name
		$this->father_name->AdvancedSearch->SearchValue = @$filter["x_father_name"];
		$this->father_name->AdvancedSearch->SearchOperator = @$filter["z_father_name"];
		$this->father_name->AdvancedSearch->SearchCondition = @$filter["v_father_name"];
		$this->father_name->AdvancedSearch->SearchValue2 = @$filter["y_father_name"];
		$this->father_name->AdvancedSearch->SearchOperator2 = @$filter["w_father_name"];
		$this->father_name->AdvancedSearch->save();

		// Field mother_name
		$this->mother_name->AdvancedSearch->SearchValue = @$filter["x_mother_name"];
		$this->mother_name->AdvancedSearch->SearchOperator = @$filter["z_mother_name"];
		$this->mother_name->AdvancedSearch->SearchCondition = @$filter["v_mother_name"];
		$this->mother_name->AdvancedSearch->SearchValue2 = @$filter["y_mother_name"];
		$this->mother_name->AdvancedSearch->SearchOperator2 = @$filter["w_mother_name"];
		$this->mother_name->AdvancedSearch->save();

		// Field nominee_name
		$this->nominee_name->AdvancedSearch->SearchValue = @$filter["x_nominee_name"];
		$this->nominee_name->AdvancedSearch->SearchOperator = @$filter["z_nominee_name"];
		$this->nominee_name->AdvancedSearch->SearchCondition = @$filter["v_nominee_name"];
		$this->nominee_name->AdvancedSearch->SearchValue2 = @$filter["y_nominee_name"];
		$this->nominee_name->AdvancedSearch->SearchOperator2 = @$filter["w_nominee_name"];
		$this->nominee_name->AdvancedSearch->save();

		// Field nominee_relation
		$this->nominee_relation->AdvancedSearch->SearchValue = @$filter["x_nominee_relation"];
		$this->nominee_relation->AdvancedSearch->SearchOperator = @$filter["z_nominee_relation"];
		$this->nominee_relation->AdvancedSearch->SearchCondition = @$filter["v_nominee_relation"];
		$this->nominee_relation->AdvancedSearch->SearchValue2 = @$filter["y_nominee_relation"];
		$this->nominee_relation->AdvancedSearch->SearchOperator2 = @$filter["w_nominee_relation"];
		$this->nominee_relation->AdvancedSearch->save();

		// Field pan_no
		$this->pan_no->AdvancedSearch->SearchValue = @$filter["x_pan_no"];
		$this->pan_no->AdvancedSearch->SearchOperator = @$filter["z_pan_no"];
		$this->pan_no->AdvancedSearch->SearchCondition = @$filter["v_pan_no"];
		$this->pan_no->AdvancedSearch->SearchValue2 = @$filter["y_pan_no"];
		$this->pan_no->AdvancedSearch->SearchOperator2 = @$filter["w_pan_no"];
		$this->pan_no->AdvancedSearch->save();

		// Field uploads
		$this->uploads->AdvancedSearch->SearchValue = @$filter["x_uploads"];
		$this->uploads->AdvancedSearch->SearchOperator = @$filter["z_uploads"];
		$this->uploads->AdvancedSearch->SearchCondition = @$filter["v_uploads"];
		$this->uploads->AdvancedSearch->SearchValue2 = @$filter["y_uploads"];
		$this->uploads->AdvancedSearch->SearchOperator2 = @$filter["w_uploads"];
		$this->uploads->AdvancedSearch->save();

		// Field image
		$this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
		$this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
		$this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
		$this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
		$this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
		$this->image->AdvancedSearch->save();

		// Field adviser
		$this->adviser->AdvancedSearch->SearchValue = @$filter["x_adviser"];
		$this->adviser->AdvancedSearch->SearchOperator = @$filter["z_adviser"];
		$this->adviser->AdvancedSearch->SearchCondition = @$filter["v_adviser"];
		$this->adviser->AdvancedSearch->SearchValue2 = @$filter["y_adviser"];
		$this->adviser->AdvancedSearch->SearchOperator2 = @$filter["w_adviser"];
		$this->adviser->AdvancedSearch->save();

		// Field share_no
		$this->share_no->AdvancedSearch->SearchValue = @$filter["x_share_no"];
		$this->share_no->AdvancedSearch->SearchOperator = @$filter["z_share_no"];
		$this->share_no->AdvancedSearch->SearchCondition = @$filter["v_share_no"];
		$this->share_no->AdvancedSearch->SearchValue2 = @$filter["y_share_no"];
		$this->share_no->AdvancedSearch->SearchOperator2 = @$filter["w_share_no"];
		$this->share_no->AdvancedSearch->save();

		// Field inv_start_date
		$this->inv_start_date->AdvancedSearch->SearchValue = @$filter["x_inv_start_date"];
		$this->inv_start_date->AdvancedSearch->SearchOperator = @$filter["z_inv_start_date"];
		$this->inv_start_date->AdvancedSearch->SearchCondition = @$filter["v_inv_start_date"];
		$this->inv_start_date->AdvancedSearch->SearchValue2 = @$filter["y_inv_start_date"];
		$this->inv_start_date->AdvancedSearch->SearchOperator2 = @$filter["w_inv_start_date"];
		$this->inv_start_date->AdvancedSearch->save();

		// Field amount
		$this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
		$this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
		$this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
		$this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
		$this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
		$this->amount->AdvancedSearch->save();

		// Field gurantee
		$this->gurantee->AdvancedSearch->SearchValue = @$filter["x_gurantee"];
		$this->gurantee->AdvancedSearch->SearchOperator = @$filter["z_gurantee"];
		$this->gurantee->AdvancedSearch->SearchCondition = @$filter["v_gurantee"];
		$this->gurantee->AdvancedSearch->SearchValue2 = @$filter["y_gurantee"];
		$this->gurantee->AdvancedSearch->SearchOperator2 = @$filter["w_gurantee"];
		$this->gurantee->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();

		// Field otp
		$this->otp->AdvancedSearch->SearchValue = @$filter["x_otp"];
		$this->otp->AdvancedSearch->SearchOperator = @$filter["z_otp"];
		$this->otp->AdvancedSearch->SearchCondition = @$filter["v_otp"];
		$this->otp->AdvancedSearch->SearchValue2 = @$filter["y_otp"];
		$this->otp->AdvancedSearch->SearchOperator2 = @$filter["w_otp"];
		$this->otp->AdvancedSearch->save();

		// Field pan_response
		$this->pan_response->AdvancedSearch->SearchValue = @$filter["x_pan_response"];
		$this->pan_response->AdvancedSearch->SearchOperator = @$filter["z_pan_response"];
		$this->pan_response->AdvancedSearch->SearchCondition = @$filter["v_pan_response"];
		$this->pan_response->AdvancedSearch->SearchValue2 = @$filter["y_pan_response"];
		$this->pan_response->AdvancedSearch->SearchOperator2 = @$filter["w_pan_response"];
		$this->pan_response->AdvancedSearch->save();

		// Field pan_verify_datetime
		$this->pan_verify_datetime->AdvancedSearch->SearchValue = @$filter["x_pan_verify_datetime"];
		$this->pan_verify_datetime->AdvancedSearch->SearchOperator = @$filter["z_pan_verify_datetime"];
		$this->pan_verify_datetime->AdvancedSearch->SearchCondition = @$filter["v_pan_verify_datetime"];
		$this->pan_verify_datetime->AdvancedSearch->SearchValue2 = @$filter["y_pan_verify_datetime"];
		$this->pan_verify_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_pan_verify_datetime"];
		$this->pan_verify_datetime->AdvancedSearch->save();

		// Field aadhaar_response
		$this->aadhaar_response->AdvancedSearch->SearchValue = @$filter["x_aadhaar_response"];
		$this->aadhaar_response->AdvancedSearch->SearchOperator = @$filter["z_aadhaar_response"];
		$this->aadhaar_response->AdvancedSearch->SearchCondition = @$filter["v_aadhaar_response"];
		$this->aadhaar_response->AdvancedSearch->SearchValue2 = @$filter["y_aadhaar_response"];
		$this->aadhaar_response->AdvancedSearch->SearchOperator2 = @$filter["w_aadhaar_response"];
		$this->aadhaar_response->AdvancedSearch->save();

		// Field aadhaar_verify_datetime
		$this->aadhaar_verify_datetime->AdvancedSearch->SearchValue = @$filter["x_aadhaar_verify_datetime"];
		$this->aadhaar_verify_datetime->AdvancedSearch->SearchOperator = @$filter["z_aadhaar_verify_datetime"];
		$this->aadhaar_verify_datetime->AdvancedSearch->SearchCondition = @$filter["v_aadhaar_verify_datetime"];
		$this->aadhaar_verify_datetime->AdvancedSearch->SearchValue2 = @$filter["y_aadhaar_verify_datetime"];
		$this->aadhaar_verify_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_aadhaar_verify_datetime"];
		$this->aadhaar_verify_datetime->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->qty, $default, FALSE); // qty
		$this->buildSearchSql($where, $this->aadhaar_no, $default, FALSE); // aadhaar_no
		$this->buildSearchSql($where, $this->name, $default, FALSE); // name
		$this->buildSearchSql($where, $this->gender, $default, FALSE); // gender
		$this->buildSearchSql($where, $this->dob, $default, FALSE); // dob
		$this->buildSearchSql($where, $this->mobile, $default, FALSE); // mobile
		$this->buildSearchSql($where, $this->_email, $default, FALSE); // email
		$this->buildSearchSql($where, $this->address, $default, FALSE); // address
		$this->buildSearchSql($where, $this->care_of, $default, FALSE); // care_of
		$this->buildSearchSql($where, $this->father_name, $default, FALSE); // father_name
		$this->buildSearchSql($where, $this->mother_name, $default, FALSE); // mother_name
		$this->buildSearchSql($where, $this->nominee_name, $default, FALSE); // nominee_name
		$this->buildSearchSql($where, $this->nominee_relation, $default, FALSE); // nominee_relation
		$this->buildSearchSql($where, $this->pan_no, $default, FALSE); // pan_no
		$this->buildSearchSql($where, $this->uploads, $default, FALSE); // uploads
		$this->buildSearchSql($where, $this->image, $default, FALSE); // image
		$this->buildSearchSql($where, $this->adviser, $default, FALSE); // adviser
		$this->buildSearchSql($where, $this->share_no, $default, FALSE); // share_no
		$this->buildSearchSql($where, $this->inv_start_date, $default, FALSE); // inv_start_date
		$this->buildSearchSql($where, $this->amount, $default, FALSE); // amount
		$this->buildSearchSql($where, $this->gurantee, $default, FALSE); // gurantee
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime
		$this->buildSearchSql($where, $this->otp, $default, FALSE); // otp
		$this->buildSearchSql($where, $this->pan_response, $default, FALSE); // pan_response
		$this->buildSearchSql($where, $this->pan_verify_datetime, $default, FALSE); // pan_verify_datetime
		$this->buildSearchSql($where, $this->aadhaar_response, $default, FALSE); // aadhaar_response
		$this->buildSearchSql($where, $this->aadhaar_verify_datetime, $default, FALSE); // aadhaar_verify_datetime

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->qty->AdvancedSearch->save(); // qty
			$this->aadhaar_no->AdvancedSearch->save(); // aadhaar_no
			$this->name->AdvancedSearch->save(); // name
			$this->gender->AdvancedSearch->save(); // gender
			$this->dob->AdvancedSearch->save(); // dob
			$this->mobile->AdvancedSearch->save(); // mobile
			$this->_email->AdvancedSearch->save(); // email
			$this->address->AdvancedSearch->save(); // address
			$this->care_of->AdvancedSearch->save(); // care_of
			$this->father_name->AdvancedSearch->save(); // father_name
			$this->mother_name->AdvancedSearch->save(); // mother_name
			$this->nominee_name->AdvancedSearch->save(); // nominee_name
			$this->nominee_relation->AdvancedSearch->save(); // nominee_relation
			$this->pan_no->AdvancedSearch->save(); // pan_no
			$this->uploads->AdvancedSearch->save(); // uploads
			$this->image->AdvancedSearch->save(); // image
			$this->adviser->AdvancedSearch->save(); // adviser
			$this->share_no->AdvancedSearch->save(); // share_no
			$this->inv_start_date->AdvancedSearch->save(); // inv_start_date
			$this->amount->AdvancedSearch->save(); // amount
			$this->gurantee->AdvancedSearch->save(); // gurantee
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
			$this->otp->AdvancedSearch->save(); // otp
			$this->pan_response->AdvancedSearch->save(); // pan_response
			$this->pan_verify_datetime->AdvancedSearch->save(); // pan_verify_datetime
			$this->aadhaar_response->AdvancedSearch->save(); // aadhaar_response
			$this->aadhaar_verify_datetime->AdvancedSearch->save(); // aadhaar_verify_datetime
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->aadhaar_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->gender, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->dob, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->mobile, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_email, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->address, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->care_of, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->father_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->mother_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nominee_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nominee_relation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->pan_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->uploads, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->share_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->aadhaar_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gender->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->dob->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->mobile->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_email->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->address->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->care_of->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->father_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->mother_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->nominee_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->nominee_relation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pan_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->uploads->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->image->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->adviser->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->share_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->inv_start_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gurantee->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->otp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pan_response->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pan_verify_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->aadhaar_response->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->aadhaar_verify_datetime->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->qty->AdvancedSearch->unsetSession();
		$this->aadhaar_no->AdvancedSearch->unsetSession();
		$this->name->AdvancedSearch->unsetSession();
		$this->gender->AdvancedSearch->unsetSession();
		$this->dob->AdvancedSearch->unsetSession();
		$this->mobile->AdvancedSearch->unsetSession();
		$this->_email->AdvancedSearch->unsetSession();
		$this->address->AdvancedSearch->unsetSession();
		$this->care_of->AdvancedSearch->unsetSession();
		$this->father_name->AdvancedSearch->unsetSession();
		$this->mother_name->AdvancedSearch->unsetSession();
		$this->nominee_name->AdvancedSearch->unsetSession();
		$this->nominee_relation->AdvancedSearch->unsetSession();
		$this->pan_no->AdvancedSearch->unsetSession();
		$this->uploads->AdvancedSearch->unsetSession();
		$this->image->AdvancedSearch->unsetSession();
		$this->adviser->AdvancedSearch->unsetSession();
		$this->share_no->AdvancedSearch->unsetSession();
		$this->inv_start_date->AdvancedSearch->unsetSession();
		$this->amount->AdvancedSearch->unsetSession();
		$this->gurantee->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
		$this->otp->AdvancedSearch->unsetSession();
		$this->pan_response->AdvancedSearch->unsetSession();
		$this->pan_verify_datetime->AdvancedSearch->unsetSession();
		$this->aadhaar_response->AdvancedSearch->unsetSession();
		$this->aadhaar_verify_datetime->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->aadhaar_no->AdvancedSearch->load();
		$this->name->AdvancedSearch->load();
		$this->gender->AdvancedSearch->load();
		$this->dob->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->care_of->AdvancedSearch->load();
		$this->father_name->AdvancedSearch->load();
		$this->mother_name->AdvancedSearch->load();
		$this->nominee_name->AdvancedSearch->load();
		$this->nominee_relation->AdvancedSearch->load();
		$this->pan_no->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->adviser->AdvancedSearch->load();
		$this->share_no->AdvancedSearch->load();
		$this->inv_start_date->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->gurantee->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->otp->AdvancedSearch->load();
		$this->pan_response->AdvancedSearch->load();
		$this->pan_verify_datetime->AdvancedSearch->load();
		$this->aadhaar_response->AdvancedSearch->load();
		$this->aadhaar_verify_datetime->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->qty, $ctrl); // qty
			$this->updateSort($this->aadhaar_no, $ctrl); // aadhaar_no
			$this->updateSort($this->name, $ctrl); // name
			$this->updateSort($this->gender, $ctrl); // gender
			$this->updateSort($this->dob, $ctrl); // dob
			$this->updateSort($this->mobile, $ctrl); // mobile
			$this->updateSort($this->_email, $ctrl); // email
			$this->updateSort($this->address, $ctrl); // address
			$this->updateSort($this->care_of, $ctrl); // care_of
			$this->updateSort($this->father_name, $ctrl); // father_name
			$this->updateSort($this->mother_name, $ctrl); // mother_name
			$this->updateSort($this->nominee_name, $ctrl); // nominee_name
			$this->updateSort($this->nominee_relation, $ctrl); // nominee_relation
			$this->updateSort($this->pan_no, $ctrl); // pan_no
			$this->updateSort($this->image, $ctrl); // image
			$this->updateSort($this->adviser, $ctrl); // adviser
			$this->updateSort($this->share_no, $ctrl); // share_no
			$this->updateSort($this->inv_start_date, $ctrl); // inv_start_date
			$this->updateSort($this->amount, $ctrl); // amount
			$this->updateSort($this->gurantee, $ctrl); // gurantee
			$this->updateSort($this->remarks, $ctrl); // remarks
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->qty->setSort("");
				$this->aadhaar_no->setSort("");
				$this->name->setSort("");
				$this->gender->setSort("");
				$this->dob->setSort("");
				$this->mobile->setSort("");
				$this->_email->setSort("");
				$this->address->setSort("");
				$this->care_of->setSort("");
				$this->father_name->setSort("");
				$this->mother_name->setSort("");
				$this->nominee_name->setSort("");
				$this->nominee_relation->setSort("");
				$this->pan_no->setSort("");
				$this->image->setSort("");
				$this->adviser->setSort("");
				$this->share_no->setSort("");
				$this->inv_start_date->setSort("");
				$this->amount->setSort("");
				$this->gurantee->setSort("");
				$this->remarks->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"finvestor_infolistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"finvestor_infolistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.finvestor_infolist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"finvestor_infolistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"investor_infosrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"investor_info\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'investor_infosrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"finvestor_infolistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue(Get("x_qty", Get("qty", "")));
		if ($this->qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->qty->AdvancedSearch->setSearchOperator(Get("z_qty", ""));

		// aadhaar_no
		if (!$this->isAddOrEdit())
			$this->aadhaar_no->AdvancedSearch->setSearchValue(Get("x_aadhaar_no", Get("aadhaar_no", "")));
		if ($this->aadhaar_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->aadhaar_no->AdvancedSearch->setSearchOperator(Get("z_aadhaar_no", ""));

		// name
		if (!$this->isAddOrEdit())
			$this->name->AdvancedSearch->setSearchValue(Get("x_name", Get("name", "")));
		if ($this->name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->name->AdvancedSearch->setSearchOperator(Get("z_name", ""));

		// gender
		if (!$this->isAddOrEdit())
			$this->gender->AdvancedSearch->setSearchValue(Get("x_gender", Get("gender", "")));
		if ($this->gender->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gender->AdvancedSearch->setSearchOperator(Get("z_gender", ""));

		// dob
		if (!$this->isAddOrEdit())
			$this->dob->AdvancedSearch->setSearchValue(Get("x_dob", Get("dob", "")));
		if ($this->dob->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->dob->AdvancedSearch->setSearchOperator(Get("z_dob", ""));

		// mobile
		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue(Get("x_mobile", Get("mobile", "")));
		if ($this->mobile->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->mobile->AdvancedSearch->setSearchOperator(Get("z_mobile", ""));

		// email
		if (!$this->isAddOrEdit())
			$this->_email->AdvancedSearch->setSearchValue(Get("x__email", Get("_email", "")));
		if ($this->_email->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_email->AdvancedSearch->setSearchOperator(Get("z__email", ""));

		// address
		if (!$this->isAddOrEdit())
			$this->address->AdvancedSearch->setSearchValue(Get("x_address", Get("address", "")));
		if ($this->address->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->address->AdvancedSearch->setSearchOperator(Get("z_address", ""));

		// care_of
		if (!$this->isAddOrEdit())
			$this->care_of->AdvancedSearch->setSearchValue(Get("x_care_of", Get("care_of", "")));
		if ($this->care_of->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->care_of->AdvancedSearch->setSearchOperator(Get("z_care_of", ""));

		// father_name
		if (!$this->isAddOrEdit())
			$this->father_name->AdvancedSearch->setSearchValue(Get("x_father_name", Get("father_name", "")));
		if ($this->father_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->father_name->AdvancedSearch->setSearchOperator(Get("z_father_name", ""));

		// mother_name
		if (!$this->isAddOrEdit())
			$this->mother_name->AdvancedSearch->setSearchValue(Get("x_mother_name", Get("mother_name", "")));
		if ($this->mother_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->mother_name->AdvancedSearch->setSearchOperator(Get("z_mother_name", ""));

		// nominee_name
		if (!$this->isAddOrEdit())
			$this->nominee_name->AdvancedSearch->setSearchValue(Get("x_nominee_name", Get("nominee_name", "")));
		if ($this->nominee_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->nominee_name->AdvancedSearch->setSearchOperator(Get("z_nominee_name", ""));

		// nominee_relation
		if (!$this->isAddOrEdit())
			$this->nominee_relation->AdvancedSearch->setSearchValue(Get("x_nominee_relation", Get("nominee_relation", "")));
		if ($this->nominee_relation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->nominee_relation->AdvancedSearch->setSearchOperator(Get("z_nominee_relation", ""));

		// pan_no
		if (!$this->isAddOrEdit())
			$this->pan_no->AdvancedSearch->setSearchValue(Get("x_pan_no", Get("pan_no", "")));
		if ($this->pan_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pan_no->AdvancedSearch->setSearchOperator(Get("z_pan_no", ""));

		// uploads
		if (!$this->isAddOrEdit())
			$this->uploads->AdvancedSearch->setSearchValue(Get("x_uploads", Get("uploads", "")));
		if ($this->uploads->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->uploads->AdvancedSearch->setSearchOperator(Get("z_uploads", ""));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue(Get("x_image", Get("image", "")));
		if ($this->image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->image->AdvancedSearch->setSearchOperator(Get("z_image", ""));

		// adviser
		if (!$this->isAddOrEdit())
			$this->adviser->AdvancedSearch->setSearchValue(Get("x_adviser", Get("adviser", "")));
		if ($this->adviser->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->adviser->AdvancedSearch->setSearchOperator(Get("z_adviser", ""));

		// share_no
		if (!$this->isAddOrEdit())
			$this->share_no->AdvancedSearch->setSearchValue(Get("x_share_no", Get("share_no", "")));
		if ($this->share_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->share_no->AdvancedSearch->setSearchOperator(Get("z_share_no", ""));

		// inv_start_date
		if (!$this->isAddOrEdit())
			$this->inv_start_date->AdvancedSearch->setSearchValue(Get("x_inv_start_date", Get("inv_start_date", "")));
		if ($this->inv_start_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->inv_start_date->AdvancedSearch->setSearchOperator(Get("z_inv_start_date", ""));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue(Get("x_amount", Get("amount", "")));
		if ($this->amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount->AdvancedSearch->setSearchOperator(Get("z_amount", ""));

		// gurantee
		if (!$this->isAddOrEdit())
			$this->gurantee->AdvancedSearch->setSearchValue(Get("x_gurantee", Get("gurantee", "")));
		if ($this->gurantee->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gurantee->AdvancedSearch->setSearchOperator(Get("z_gurantee", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));

		// otp
		if (!$this->isAddOrEdit())
			$this->otp->AdvancedSearch->setSearchValue(Get("x_otp", Get("otp", "")));
		if ($this->otp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->otp->AdvancedSearch->setSearchOperator(Get("z_otp", ""));

		// pan_response
		if (!$this->isAddOrEdit())
			$this->pan_response->AdvancedSearch->setSearchValue(Get("x_pan_response", Get("pan_response", "")));
		if ($this->pan_response->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pan_response->AdvancedSearch->setSearchOperator(Get("z_pan_response", ""));

		// pan_verify_datetime
		if (!$this->isAddOrEdit())
			$this->pan_verify_datetime->AdvancedSearch->setSearchValue(Get("x_pan_verify_datetime", Get("pan_verify_datetime", "")));
		if ($this->pan_verify_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pan_verify_datetime->AdvancedSearch->setSearchOperator(Get("z_pan_verify_datetime", ""));

		// aadhaar_response
		if (!$this->isAddOrEdit())
			$this->aadhaar_response->AdvancedSearch->setSearchValue(Get("x_aadhaar_response", Get("aadhaar_response", "")));
		if ($this->aadhaar_response->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->aadhaar_response->AdvancedSearch->setSearchOperator(Get("z_aadhaar_response", ""));

		// aadhaar_verify_datetime
		if (!$this->isAddOrEdit())
			$this->aadhaar_verify_datetime->AdvancedSearch->setSearchValue(Get("x_aadhaar_verify_datetime", Get("aadhaar_verify_datetime", "")));
		if ($this->aadhaar_verify_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->aadhaar_verify_datetime->AdvancedSearch->setSearchOperator(Get("z_aadhaar_verify_datetime", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->qty->setDbValue($row['qty']);
		$this->aadhaar_no->setDbValue($row['aadhaar_no']);
		$this->name->setDbValue($row['name']);
		$this->gender->setDbValue($row['gender']);
		$this->dob->setDbValue($row['dob']);
		$this->mobile->setDbValue($row['mobile']);
		$this->_email->setDbValue($row['email']);
		$this->address->setDbValue($row['address']);
		$this->care_of->setDbValue($row['care_of']);
		$this->father_name->setDbValue($row['father_name']);
		$this->mother_name->setDbValue($row['mother_name']);
		$this->nominee_name->setDbValue($row['nominee_name']);
		$this->nominee_relation->setDbValue($row['nominee_relation']);
		$this->pan_no->setDbValue($row['pan_no']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->adviser->setDbValue($row['adviser']);
		$this->share_no->setDbValue($row['share_no']);
		$this->inv_start_date->setDbValue($row['inv_start_date']);
		$this->amount->setDbValue($row['amount']);
		$this->gurantee->setDbValue($row['gurantee']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->otp->setDbValue($row['otp']);
		$this->pan_response->setDbValue($row['pan_response']);
		$this->pan_verify_datetime->setDbValue($row['pan_verify_datetime']);
		$this->aadhaar_response->setDbValue($row['aadhaar_response']);
		$this->aadhaar_verify_datetime->setDbValue($row['aadhaar_verify_datetime']);
		$this->thumb_data->setDbValue($row['thumb_data']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['qty'] = NULL;
		$row['aadhaar_no'] = NULL;
		$row['name'] = NULL;
		$row['gender'] = NULL;
		$row['dob'] = NULL;
		$row['mobile'] = NULL;
		$row['email'] = NULL;
		$row['address'] = NULL;
		$row['care_of'] = NULL;
		$row['father_name'] = NULL;
		$row['mother_name'] = NULL;
		$row['nominee_name'] = NULL;
		$row['nominee_relation'] = NULL;
		$row['pan_no'] = NULL;
		$row['uploads'] = NULL;
		$row['image'] = NULL;
		$row['adviser'] = NULL;
		$row['share_no'] = NULL;
		$row['inv_start_date'] = NULL;
		$row['amount'] = NULL;
		$row['gurantee'] = NULL;
		$row['remarks'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['otp'] = NULL;
		$row['pan_response'] = NULL;
		$row['pan_verify_datetime'] = NULL;
		$row['aadhaar_response'] = NULL;
		$row['aadhaar_verify_datetime'] = NULL;
		$row['thumb_data'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gurantee->FormValue == $this->gurantee->CurrentValue && is_numeric(ConvertToFloatString($this->gurantee->CurrentValue)))
			$this->gurantee->CurrentValue = ConvertToFloatString($this->gurantee->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// qty
		// aadhaar_no
		// name
		// gender
		// dob
		// mobile
		// email
		// address
		// care_of
		// father_name
		// mother_name
		// nominee_name
		// nominee_relation
		// pan_no
		// uploads
		// image

		$this->image->CellCssStyle = "white-space: nowrap;";

		// adviser
		// share_no
		// inv_start_date
		// amount
		// gurantee
		// remarks
		// operator
		// datetime
		// otp

		$this->otp->CellCssStyle = "white-space: nowrap;";

		// pan_response
		$this->pan_response->CellCssStyle = "white-space: nowrap;";

		// pan_verify_datetime
		// aadhaar_response

		$this->aadhaar_response->CellCssStyle = "white-space: nowrap;";

		// aadhaar_verify_datetime
		$this->aadhaar_verify_datetime->CellCssStyle = "white-space: nowrap;";

		// thumb_data
		$this->thumb_data->CellCssStyle = "white-space: nowrap;";

		// Accumulate aggregate value
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->qty->CurrentValue))
				$this->qty->Total += $this->qty->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) <> "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// dob
			$this->dob->ViewValue = $this->dob->CurrentValue;
			$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 7);
			$this->dob->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// care_of
			$this->care_of->ViewValue = $this->care_of->CurrentValue;
			$this->care_of->ViewCustomAttributes = "";

			// father_name
			$this->father_name->ViewValue = $this->father_name->CurrentValue;
			$this->father_name->ViewCustomAttributes = "";

			// mother_name
			$this->mother_name->ViewValue = $this->mother_name->CurrentValue;
			$this->mother_name->ViewCustomAttributes = "";

			// nominee_name
			$this->nominee_name->ViewValue = $this->nominee_name->CurrentValue;
			$this->nominee_name->ViewCustomAttributes = "";

			// nominee_relation
			if (strval($this->nominee_relation->CurrentValue) <> "") {
				$this->nominee_relation->ViewValue = $this->nominee_relation->optionCaption($this->nominee_relation->CurrentValue);
			} else {
				$this->nominee_relation->ViewValue = NULL;
			}
			$this->nominee_relation->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/member_info/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// adviser
			$curVal = strval($this->adviser->CurrentValue);
			if ($curVal <> "") {
				$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
				if ($this->adviser->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->adviser->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->adviser->ViewValue = $this->adviser->CurrentValue;
					}
				}
			} else {
				$this->adviser->ViewValue = NULL;
			}
			$this->adviser->ViewCustomAttributes = "";

			// share_no
			$this->share_no->ViewValue = $this->share_no->CurrentValue;
			$this->share_no->ViewCustomAttributes = "";

			// inv_start_date
			$this->inv_start_date->ViewValue = $this->inv_start_date->CurrentValue;
			$this->inv_start_date->ViewValue = FormatDateTime($this->inv_start_date->ViewValue, 0);
			$this->inv_start_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// gurantee
			$this->gurantee->ViewValue = $this->gurantee->CurrentValue;
			$this->gurantee->ViewValue = FormatNumber($this->gurantee->ViewValue, 2, -2, -2, -2);
			$this->gurantee->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// qty
			$this->qty->LinkCustomAttributes = "";
			if (!EmptyValue($this->id->CurrentValue)) {
				$this->qty->HrefValue = "share_transferadd.php?FN=" . $this->id->CurrentValue; // Add prefix/suffix
				$this->qty->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->qty->HrefValue = FullUrl($this->qty->HrefValue, "href");
			} else {
				$this->qty->HrefValue = "";
			}
			$this->qty->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";
			if (!$this->isExport())
				$this->name->ViewValue = $this->highlightValue($this->name);

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";
			$this->dob->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";
			if (!$this->isExport())
				$this->mobile->ViewValue = $this->highlightValue($this->mobile);

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";
			if (!$this->isExport())
				$this->_email->ViewValue = $this->highlightValue($this->_email);

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";
			if (!$this->isExport())
				$this->address->ViewValue = $this->highlightValue($this->address);

			// care_of
			$this->care_of->LinkCustomAttributes = "";
			$this->care_of->HrefValue = "";
			$this->care_of->TooltipValue = "";
			if (!$this->isExport())
				$this->care_of->ViewValue = $this->highlightValue($this->care_of);

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";
			$this->father_name->TooltipValue = "";
			if (!$this->isExport())
				$this->father_name->ViewValue = $this->highlightValue($this->father_name);

			// mother_name
			$this->mother_name->LinkCustomAttributes = "";
			$this->mother_name->HrefValue = "";
			$this->mother_name->TooltipValue = "";
			if (!$this->isExport())
				$this->mother_name->ViewValue = $this->highlightValue($this->mother_name);

			// nominee_name
			$this->nominee_name->LinkCustomAttributes = "";
			$this->nominee_name->HrefValue = "";
			$this->nominee_name->TooltipValue = "";
			if (!$this->isExport())
				$this->nominee_name->ViewValue = $this->highlightValue($this->nominee_name);

			// nominee_relation
			$this->nominee_relation->LinkCustomAttributes = "";
			$this->nominee_relation->HrefValue = "";
			$this->nominee_relation->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";
			if (!$this->isExport())
				$this->pan_no->ViewValue = $this->highlightValue($this->pan_no);

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '.p_uploads/member_info/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "investor_info_x" . $this->RowCnt . "_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}

			// adviser
			$this->adviser->LinkCustomAttributes = "";
			$this->adviser->HrefValue = "";
			$this->adviser->TooltipValue = "";

			// share_no
			$this->share_no->LinkCustomAttributes = "";
			$this->share_no->HrefValue = "";
			$this->share_no->TooltipValue = "";
			if (!$this->isExport())
				$this->share_no->ViewValue = $this->highlightValue($this->share_no);

			// inv_start_date
			$this->inv_start_date->LinkCustomAttributes = "";
			$this->inv_start_date->HrefValue = "";
			$this->inv_start_date->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// gurantee
			$this->gurantee->LinkCustomAttributes = "";
			$this->gurantee->HrefValue = "";
			$this->gurantee->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";
			if (!$this->isExport())
				$this->remarks->ViewValue = $this->highlightValue($this->remarks);

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->qty->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->qty->CurrentValue = $this->qty->Total;
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";
			$this->qty->HrefValue = ""; // Clear href value
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->aadhaar_no->AdvancedSearch->load();
		$this->name->AdvancedSearch->load();
		$this->gender->AdvancedSearch->load();
		$this->dob->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->care_of->AdvancedSearch->load();
		$this->father_name->AdvancedSearch->load();
		$this->mother_name->AdvancedSearch->load();
		$this->nominee_name->AdvancedSearch->load();
		$this->nominee_relation->AdvancedSearch->load();
		$this->pan_no->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->adviser->AdvancedSearch->load();
		$this->share_no->AdvancedSearch->load();
		$this->inv_start_date->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->gurantee->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->otp->AdvancedSearch->load();
		$this->pan_response->AdvancedSearch->load();
		$this->pan_verify_datetime->AdvancedSearch->load();
		$this->aadhaar_response->AdvancedSearch->load();
		$this->aadhaar_verify_datetime->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.finvestor_infolist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.finvestor_infolist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.finvestor_infolist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_investor_info\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_investor_info',hdr:ew.language.phrase('ExportToEmailText'),f:document.finvestor_infolist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_adviser":
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_adviser":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";
	//		$this->ListOptions->Add("Receive Share"); 
	//		$this->ListOptions->Items["Receive Share"]->Body = '<a href="share_transferadd.php?FN='.$this->id->CurrentValue.'" data-original-title ="Receive Share"><i data-phrase="Receive Share"  style="color:IndianRed" class="fa fa-chevron-down ew-icon"></i></a>';
		//$this->ListOptions->Items["new"]->Body = "xxx";

			$this->ListOptions->Add("Print MemberShip From"); 
			$this->ListOptions->Items["Print MemberShip From"]->Body = '<a href="autoprogramme.php?apcid=5f798f5a3adcaeeca1ece15e954ae46f&id='.$this->id->CurrentValue.'" data-original-title ="Print MemberShip From"><i data-phrase="Print MemberShip From"  style="color:IndianRed" class="fa fa-print ew-icon"></i></a>';
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>