<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class investor_info_search extends investor_info
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'investor_info';

	// Page object name
	public $PageObjName = "investor_info_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (investor_info)
		if (!isset($GLOBALS["investor_info"]) || get_class($GLOBALS["investor_info"]) == PROJECT_NAMESPACE . "investor_info") {
			$GLOBALS["investor_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["investor_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'investor_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $investor_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($investor_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "investor_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("investor_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->qty->setVisibility();
		$this->aadhaar_no->setVisibility();
		$this->name->setVisibility();
		$this->gender->setVisibility();
		$this->dob->setVisibility();
		$this->mobile->setVisibility();
		$this->_email->setVisibility();
		$this->address->setVisibility();
		$this->care_of->setVisibility();
		$this->father_name->setVisibility();
		$this->mother_name->setVisibility();
		$this->nominee_name->setVisibility();
		$this->nominee_relation->setVisibility();
		$this->pan_no->setVisibility();
		$this->uploads->setVisibility();
		$this->image->setVisibility();
		$this->adviser->setVisibility();
		$this->share_no->setVisibility();
		$this->inv_start_date->setVisibility();
		$this->amount->setVisibility();
		$this->gurantee->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->otp->setVisibility();
		$this->pan_response->setVisibility();
		$this->pan_verify_datetime->setVisibility();
		$this->aadhaar_response->setVisibility();
		$this->aadhaar_verify_datetime->setVisibility();
		$this->thumb_data->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->adviser);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "investor_infolist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->qty); // qty
		$this->buildSearchUrl($srchUrl, $this->aadhaar_no); // aadhaar_no
		$this->buildSearchUrl($srchUrl, $this->name); // name
		$this->buildSearchUrl($srchUrl, $this->gender); // gender
		$this->buildSearchUrl($srchUrl, $this->dob); // dob
		$this->buildSearchUrl($srchUrl, $this->mobile); // mobile
		$this->buildSearchUrl($srchUrl, $this->_email); // email
		$this->buildSearchUrl($srchUrl, $this->address); // address
		$this->buildSearchUrl($srchUrl, $this->care_of); // care_of
		$this->buildSearchUrl($srchUrl, $this->father_name); // father_name
		$this->buildSearchUrl($srchUrl, $this->mother_name); // mother_name
		$this->buildSearchUrl($srchUrl, $this->nominee_name); // nominee_name
		$this->buildSearchUrl($srchUrl, $this->nominee_relation); // nominee_relation
		$this->buildSearchUrl($srchUrl, $this->pan_no); // pan_no
		$this->buildSearchUrl($srchUrl, $this->uploads); // uploads
		$this->buildSearchUrl($srchUrl, $this->image); // image
		$this->buildSearchUrl($srchUrl, $this->adviser); // adviser
		$this->buildSearchUrl($srchUrl, $this->share_no); // share_no
		$this->buildSearchUrl($srchUrl, $this->inv_start_date); // inv_start_date
		$this->buildSearchUrl($srchUrl, $this->amount); // amount
		$this->buildSearchUrl($srchUrl, $this->gurantee); // gurantee
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->otp); // otp
		$this->buildSearchUrl($srchUrl, $this->pan_response); // pan_response
		$this->buildSearchUrl($srchUrl, $this->pan_verify_datetime); // pan_verify_datetime
		$this->buildSearchUrl($srchUrl, $this->aadhaar_response); // aadhaar_response
		$this->buildSearchUrl($srchUrl, $this->aadhaar_verify_datetime); // aadhaar_verify_datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// qty
		if (!$this->isAddOrEdit())
			$this->qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_qty"));
		$this->qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_qty"));

		// aadhaar_no
		if (!$this->isAddOrEdit())
			$this->aadhaar_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_aadhaar_no"));
		$this->aadhaar_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_aadhaar_no"));

		// name
		if (!$this->isAddOrEdit())
			$this->name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_name"));
		$this->name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_name"));

		// gender
		if (!$this->isAddOrEdit())
			$this->gender->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gender"));
		$this->gender->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gender"));

		// dob
		if (!$this->isAddOrEdit())
			$this->dob->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dob"));
		$this->dob->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dob"));

		// mobile
		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile"));
		$this->mobile->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile"));

		// email
		if (!$this->isAddOrEdit())
			$this->_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__email"));
		$this->_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__email"));

		// address
		if (!$this->isAddOrEdit())
			$this->address->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_address"));
		$this->address->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_address"));

		// care_of
		if (!$this->isAddOrEdit())
			$this->care_of->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_care_of"));
		$this->care_of->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_care_of"));

		// father_name
		if (!$this->isAddOrEdit())
			$this->father_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_father_name"));
		$this->father_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_father_name"));

		// mother_name
		if (!$this->isAddOrEdit())
			$this->mother_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mother_name"));
		$this->mother_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mother_name"));

		// nominee_name
		if (!$this->isAddOrEdit())
			$this->nominee_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_nominee_name"));
		$this->nominee_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_nominee_name"));

		// nominee_relation
		if (!$this->isAddOrEdit())
			$this->nominee_relation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_nominee_relation"));
		$this->nominee_relation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_nominee_relation"));

		// pan_no
		if (!$this->isAddOrEdit())
			$this->pan_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pan_no"));
		$this->pan_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pan_no"));

		// uploads
		if (!$this->isAddOrEdit())
			$this->uploads->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_uploads"));
		$this->uploads->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_uploads"));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_image"));
		$this->image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_image"));

		// adviser
		if (!$this->isAddOrEdit())
			$this->adviser->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_adviser"));
		$this->adviser->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_adviser"));

		// share_no
		if (!$this->isAddOrEdit())
			$this->share_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_share_no"));
		$this->share_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_share_no"));

		// inv_start_date
		if (!$this->isAddOrEdit())
			$this->inv_start_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_inv_start_date"));
		$this->inv_start_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_inv_start_date"));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_amount"));
		$this->amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_amount"));

		// gurantee
		if (!$this->isAddOrEdit())
			$this->gurantee->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gurantee"));
		$this->gurantee->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gurantee"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// otp
		if (!$this->isAddOrEdit())
			$this->otp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_otp"));
		$this->otp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_otp"));

		// pan_response
		if (!$this->isAddOrEdit())
			$this->pan_response->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pan_response"));
		$this->pan_response->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pan_response"));

		// pan_verify_datetime
		if (!$this->isAddOrEdit())
			$this->pan_verify_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pan_verify_datetime"));
		$this->pan_verify_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pan_verify_datetime"));

		// aadhaar_response
		if (!$this->isAddOrEdit())
			$this->aadhaar_response->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_aadhaar_response"));
		$this->aadhaar_response->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_aadhaar_response"));

		// aadhaar_verify_datetime
		if (!$this->isAddOrEdit())
			$this->aadhaar_verify_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_aadhaar_verify_datetime"));
		$this->aadhaar_verify_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_aadhaar_verify_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gurantee->FormValue == $this->gurantee->CurrentValue && is_numeric(ConvertToFloatString($this->gurantee->CurrentValue)))
			$this->gurantee->CurrentValue = ConvertToFloatString($this->gurantee->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// qty
		// aadhaar_no
		// name
		// gender
		// dob
		// mobile
		// email
		// address
		// care_of
		// father_name
		// mother_name
		// nominee_name
		// nominee_relation
		// pan_no
		// uploads
		// image
		// adviser
		// share_no
		// inv_start_date
		// amount
		// gurantee
		// remarks
		// operator
		// datetime
		// otp
		// pan_response
		// pan_verify_datetime
		// aadhaar_response
		// aadhaar_verify_datetime
		// thumb_data

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// qty
			$this->qty->ViewValue = $this->qty->CurrentValue;
			$this->qty->ViewValue = FormatNumber($this->qty->ViewValue, 0, -2, -2, -2);
			$this->qty->ViewCustomAttributes = "";

			// aadhaar_no
			$this->aadhaar_no->ViewValue = $this->aadhaar_no->CurrentValue;
			$this->aadhaar_no->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$this->name->ViewCustomAttributes = "";

			// gender
			if (strval($this->gender->CurrentValue) <> "") {
				$this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
			} else {
				$this->gender->ViewValue = NULL;
			}
			$this->gender->ViewCustomAttributes = "";

			// dob
			$this->dob->ViewValue = $this->dob->CurrentValue;
			$this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, 7);
			$this->dob->ViewCustomAttributes = "";

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$this->mobile->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// address
			$this->address->ViewValue = $this->address->CurrentValue;
			$this->address->ViewCustomAttributes = "";

			// care_of
			$this->care_of->ViewValue = $this->care_of->CurrentValue;
			$this->care_of->ViewCustomAttributes = "";

			// father_name
			$this->father_name->ViewValue = $this->father_name->CurrentValue;
			$this->father_name->ViewCustomAttributes = "";

			// mother_name
			$this->mother_name->ViewValue = $this->mother_name->CurrentValue;
			$this->mother_name->ViewCustomAttributes = "";

			// nominee_name
			$this->nominee_name->ViewValue = $this->nominee_name->CurrentValue;
			$this->nominee_name->ViewCustomAttributes = "";

			// nominee_relation
			if (strval($this->nominee_relation->CurrentValue) <> "") {
				$this->nominee_relation->ViewValue = $this->nominee_relation->optionCaption($this->nominee_relation->CurrentValue);
			} else {
				$this->nominee_relation->ViewValue = NULL;
			}
			$this->nominee_relation->ViewCustomAttributes = "";

			// pan_no
			$this->pan_no->ViewValue = $this->pan_no->CurrentValue;
			$this->pan_no->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '.p_uploads/member_info/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// adviser
			$curVal = strval($this->adviser->CurrentValue);
			if ($curVal <> "") {
				$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
				if ($this->adviser->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->adviser->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->adviser->ViewValue = $this->adviser->CurrentValue;
					}
				}
			} else {
				$this->adviser->ViewValue = NULL;
			}
			$this->adviser->ViewCustomAttributes = "";

			// share_no
			$this->share_no->ViewValue = $this->share_no->CurrentValue;
			$this->share_no->ViewCustomAttributes = "";

			// inv_start_date
			$this->inv_start_date->ViewValue = $this->inv_start_date->CurrentValue;
			$this->inv_start_date->ViewValue = FormatDateTime($this->inv_start_date->ViewValue, 0);
			$this->inv_start_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// gurantee
			$this->gurantee->ViewValue = $this->gurantee->CurrentValue;
			$this->gurantee->ViewValue = FormatNumber($this->gurantee->ViewValue, 2, -2, -2, -2);
			$this->gurantee->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// otp
			$this->otp->ViewValue = $this->otp->CurrentValue;
			$this->otp->ViewValue = FormatNumber($this->otp->ViewValue, 0, -2, -2, -2);
			$this->otp->ViewCustomAttributes = "";

			// pan_response
			$this->pan_response->ViewValue = $this->pan_response->CurrentValue;
			$this->pan_response->ViewCustomAttributes = "";

			// pan_verify_datetime
			$this->pan_verify_datetime->ViewValue = $this->pan_verify_datetime->CurrentValue;
			$this->pan_verify_datetime->ViewValue = FormatDateTime($this->pan_verify_datetime->ViewValue, 0);
			$this->pan_verify_datetime->ViewCustomAttributes = "";

			// aadhaar_response
			$this->aadhaar_response->ViewValue = $this->aadhaar_response->CurrentValue;
			$this->aadhaar_response->ViewCustomAttributes = "";

			// aadhaar_verify_datetime
			$this->aadhaar_verify_datetime->ViewValue = $this->aadhaar_verify_datetime->CurrentValue;
			$this->aadhaar_verify_datetime->ViewValue = FormatDateTime($this->aadhaar_verify_datetime->ViewValue, 0);
			$this->aadhaar_verify_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// qty
			$this->qty->LinkCustomAttributes = "";
			if (!EmptyValue($this->id->CurrentValue)) {
				$this->qty->HrefValue = "share_transferadd.php?FN=" . $this->id->CurrentValue; // Add prefix/suffix
				$this->qty->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->qty->HrefValue = FullUrl($this->qty->HrefValue, "href");
			} else {
				$this->qty->HrefValue = "";
			}
			$this->qty->TooltipValue = "";

			// aadhaar_no
			$this->aadhaar_no->LinkCustomAttributes = "";
			$this->aadhaar_no->HrefValue = "";
			$this->aadhaar_no->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// gender
			$this->gender->LinkCustomAttributes = "";
			$this->gender->HrefValue = "";
			$this->gender->TooltipValue = "";

			// dob
			$this->dob->LinkCustomAttributes = "";
			$this->dob->HrefValue = "";
			$this->dob->TooltipValue = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// address
			$this->address->LinkCustomAttributes = "";
			$this->address->HrefValue = "";
			$this->address->TooltipValue = "";

			// care_of
			$this->care_of->LinkCustomAttributes = "";
			$this->care_of->HrefValue = "";
			$this->care_of->TooltipValue = "";

			// father_name
			$this->father_name->LinkCustomAttributes = "";
			$this->father_name->HrefValue = "";
			$this->father_name->TooltipValue = "";

			// mother_name
			$this->mother_name->LinkCustomAttributes = "";
			$this->mother_name->HrefValue = "";
			$this->mother_name->TooltipValue = "";

			// nominee_name
			$this->nominee_name->LinkCustomAttributes = "";
			$this->nominee_name->HrefValue = "";
			$this->nominee_name->TooltipValue = "";

			// nominee_relation
			$this->nominee_relation->LinkCustomAttributes = "";
			$this->nominee_relation->HrefValue = "";
			$this->nominee_relation->TooltipValue = "";

			// pan_no
			$this->pan_no->LinkCustomAttributes = "";
			$this->pan_no->HrefValue = "";
			$this->pan_no->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/member_info/'.  $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "investor_info_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '.p_uploads/member_info/';
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->Upload->DbValue); // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "investor_info_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}

			// adviser
			$this->adviser->LinkCustomAttributes = "";
			$this->adviser->HrefValue = "";
			$this->adviser->TooltipValue = "";

			// share_no
			$this->share_no->LinkCustomAttributes = "";
			$this->share_no->HrefValue = "";
			$this->share_no->TooltipValue = "";

			// inv_start_date
			$this->inv_start_date->LinkCustomAttributes = "";
			$this->inv_start_date->HrefValue = "";
			$this->inv_start_date->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// gurantee
			$this->gurantee->LinkCustomAttributes = "";
			$this->gurantee->HrefValue = "";
			$this->gurantee->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// otp
			$this->otp->LinkCustomAttributes = "";
			$this->otp->HrefValue = "";
			$this->otp->TooltipValue = "";

			// pan_response
			$this->pan_response->LinkCustomAttributes = "";
			$this->pan_response->HrefValue = "";
			$this->pan_response->TooltipValue = "";

			// pan_verify_datetime
			$this->pan_verify_datetime->LinkCustomAttributes = "";
			$this->pan_verify_datetime->HrefValue = "";
			$this->pan_verify_datetime->TooltipValue = "";

			// aadhaar_response
			$this->aadhaar_response->LinkCustomAttributes = "";
			$this->aadhaar_response->HrefValue = "";
			$this->aadhaar_response->TooltipValue = "";

			// aadhaar_verify_datetime
			$this->aadhaar_verify_datetime->LinkCustomAttributes = "";
			$this->aadhaar_verify_datetime->HrefValue = "";
			$this->aadhaar_verify_datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// qty
			$this->qty->EditAttrs["class"] = "form-control";
			$this->qty->EditCustomAttributes = "";
			$this->qty->EditValue = HtmlEncode($this->qty->AdvancedSearch->SearchValue);
			$this->qty->PlaceHolder = RemoveHtml($this->qty->caption());

			// aadhaar_no
			$this->aadhaar_no->EditAttrs["class"] = "form-control";
			$this->aadhaar_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->aadhaar_no->AdvancedSearch->SearchValue = HtmlDecode($this->aadhaar_no->AdvancedSearch->SearchValue);
			$this->aadhaar_no->EditValue = HtmlEncode($this->aadhaar_no->AdvancedSearch->SearchValue);
			$this->aadhaar_no->PlaceHolder = RemoveHtml($this->aadhaar_no->caption());

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
			$this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// gender
			$this->gender->EditAttrs["class"] = "form-control";
			$this->gender->EditCustomAttributes = "";
			$this->gender->EditValue = $this->gender->options(TRUE);

			// dob
			$this->dob->EditAttrs["class"] = "form-control";
			$this->dob->EditCustomAttributes = "";
			$this->dob->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dob->AdvancedSearch->SearchValue, 7), 7));
			$this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// address
			$this->address->EditAttrs["class"] = "form-control";
			$this->address->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->address->AdvancedSearch->SearchValue = HtmlDecode($this->address->AdvancedSearch->SearchValue);
			$this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
			$this->address->PlaceHolder = RemoveHtml($this->address->caption());

			// care_of
			$this->care_of->EditAttrs["class"] = "form-control";
			$this->care_of->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->care_of->AdvancedSearch->SearchValue = HtmlDecode($this->care_of->AdvancedSearch->SearchValue);
			$this->care_of->EditValue = HtmlEncode($this->care_of->AdvancedSearch->SearchValue);
			$this->care_of->PlaceHolder = RemoveHtml($this->care_of->caption());

			// father_name
			$this->father_name->EditAttrs["class"] = "form-control";
			$this->father_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->father_name->AdvancedSearch->SearchValue = HtmlDecode($this->father_name->AdvancedSearch->SearchValue);
			$this->father_name->EditValue = HtmlEncode($this->father_name->AdvancedSearch->SearchValue);
			$this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

			// mother_name
			$this->mother_name->EditAttrs["class"] = "form-control";
			$this->mother_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mother_name->AdvancedSearch->SearchValue = HtmlDecode($this->mother_name->AdvancedSearch->SearchValue);
			$this->mother_name->EditValue = HtmlEncode($this->mother_name->AdvancedSearch->SearchValue);
			$this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

			// nominee_name
			$this->nominee_name->EditAttrs["class"] = "form-control";
			$this->nominee_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->nominee_name->AdvancedSearch->SearchValue = HtmlDecode($this->nominee_name->AdvancedSearch->SearchValue);
			$this->nominee_name->EditValue = HtmlEncode($this->nominee_name->AdvancedSearch->SearchValue);
			$this->nominee_name->PlaceHolder = RemoveHtml($this->nominee_name->caption());

			// nominee_relation
			$this->nominee_relation->EditAttrs["class"] = "form-control";
			$this->nominee_relation->EditCustomAttributes = "";
			$this->nominee_relation->EditValue = $this->nominee_relation->options(TRUE);

			// pan_no
			$this->pan_no->EditAttrs["class"] = "form-control";
			$this->pan_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_no->AdvancedSearch->SearchValue = HtmlDecode($this->pan_no->AdvancedSearch->SearchValue);
			$this->pan_no->EditValue = HtmlEncode($this->pan_no->AdvancedSearch->SearchValue);
			$this->pan_no->PlaceHolder = RemoveHtml($this->pan_no->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
			$this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
			$this->image->PlaceHolder = RemoveHtml($this->image->caption());

			// adviser
			$this->adviser->EditAttrs["class"] = "form-control";
			$this->adviser->EditCustomAttributes = "";
			$curVal = trim(strval($this->adviser->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->adviser->AdvancedSearch->ViewValue = $this->adviser->lookupCacheOption($curVal);
			else
				$this->adviser->AdvancedSearch->ViewValue = $this->adviser->Lookup !== NULL && is_array($this->adviser->Lookup->Options) ? $curVal : NULL;
			if ($this->adviser->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->adviser->EditValue = array_values($this->adviser->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->adviser->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`userlevel`=1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->adviser->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->adviser->EditValue = $arwrk;
			}

			// share_no
			$this->share_no->EditAttrs["class"] = "form-control";
			$this->share_no->EditCustomAttributes = 'ReadOnly';
			$this->share_no->EditValue = HtmlEncode($this->share_no->AdvancedSearch->SearchValue);
			$this->share_no->PlaceHolder = RemoveHtml($this->share_no->caption());

			// inv_start_date
			$this->inv_start_date->EditAttrs["class"] = "form-control";
			$this->inv_start_date->EditCustomAttributes = "";
			$this->inv_start_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->inv_start_date->AdvancedSearch->SearchValue, 0), 8));
			$this->inv_start_date->PlaceHolder = RemoveHtml($this->inv_start_date->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// gurantee
			$this->gurantee->EditAttrs["class"] = "form-control";
			$this->gurantee->EditCustomAttributes = "";
			$this->gurantee->EditValue = HtmlEncode($this->gurantee->AdvancedSearch->SearchValue);
			$this->gurantee->PlaceHolder = RemoveHtml($this->gurantee->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// otp
			$this->otp->EditAttrs["class"] = "form-control";
			$this->otp->EditCustomAttributes = "";
			$this->otp->EditValue = HtmlEncode($this->otp->AdvancedSearch->SearchValue);
			$this->otp->PlaceHolder = RemoveHtml($this->otp->caption());

			// pan_response
			$this->pan_response->EditAttrs["class"] = "form-control";
			$this->pan_response->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pan_response->AdvancedSearch->SearchValue = HtmlDecode($this->pan_response->AdvancedSearch->SearchValue);
			$this->pan_response->EditValue = HtmlEncode($this->pan_response->AdvancedSearch->SearchValue);
			$this->pan_response->PlaceHolder = RemoveHtml($this->pan_response->caption());

			// pan_verify_datetime
			$this->pan_verify_datetime->EditAttrs["class"] = "form-control";
			$this->pan_verify_datetime->EditCustomAttributes = "";
			$this->pan_verify_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->pan_verify_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->pan_verify_datetime->PlaceHolder = RemoveHtml($this->pan_verify_datetime->caption());

			// aadhaar_response
			$this->aadhaar_response->EditAttrs["class"] = "form-control";
			$this->aadhaar_response->EditCustomAttributes = "";
			$this->aadhaar_response->EditValue = HtmlEncode($this->aadhaar_response->AdvancedSearch->SearchValue);
			$this->aadhaar_response->PlaceHolder = RemoveHtml($this->aadhaar_response->caption());

			// aadhaar_verify_datetime
			$this->aadhaar_verify_datetime->EditAttrs["class"] = "form-control";
			$this->aadhaar_verify_datetime->EditCustomAttributes = "";
			$this->aadhaar_verify_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->aadhaar_verify_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->aadhaar_verify_datetime->PlaceHolder = RemoveHtml($this->aadhaar_verify_datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->qty->errorMessage());
		}
		if (!CheckInteger($this->aadhaar_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->aadhaar_no->errorMessage());
		}
		if (!CheckDate($this->inv_start_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->inv_start_date->errorMessage());
		}
		if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->amount->errorMessage());
		}
		if (!CheckNumber($this->gurantee->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->gurantee->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->otp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->otp->errorMessage());
		}
		if (!CheckDate($this->pan_response->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pan_response->errorMessage());
		}
		if (!CheckDate($this->pan_verify_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pan_verify_datetime->errorMessage());
		}
		if (!CheckDate($this->aadhaar_verify_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->aadhaar_verify_datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->qty->AdvancedSearch->load();
		$this->aadhaar_no->AdvancedSearch->load();
		$this->name->AdvancedSearch->load();
		$this->gender->AdvancedSearch->load();
		$this->dob->AdvancedSearch->load();
		$this->mobile->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->address->AdvancedSearch->load();
		$this->care_of->AdvancedSearch->load();
		$this->father_name->AdvancedSearch->load();
		$this->mother_name->AdvancedSearch->load();
		$this->nominee_name->AdvancedSearch->load();
		$this->nominee_relation->AdvancedSearch->load();
		$this->pan_no->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->adviser->AdvancedSearch->load();
		$this->share_no->AdvancedSearch->load();
		$this->inv_start_date->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->gurantee->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->otp->AdvancedSearch->load();
		$this->pan_response->AdvancedSearch->load();
		$this->pan_verify_datetime->AdvancedSearch->load();
		$this->aadhaar_response->AdvancedSearch->load();
		$this->aadhaar_verify_datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("investor_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_adviser":
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_adviser":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>