<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for invoice_details
 */
class invoice_details extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $_barcode;
	public $exporter;
	public $consignee;
	public $consignee_other;
	public $packing_list_no;
	public $d_11;
	public $description_11;
	public $in_template;
	public $pl_template;
	public $invoice_no;
	public $invoice_date;
	public $po_no;
	public $other_reference;
	public $origin;
	public $final_destination;
	public $payment_terms;
	public $pre_carriage_receipt;
	public $place_of_receipt;
	public $loading_port;
	public $port_discharge;
	public $d_01;
	public $description_01;
	public $d_02;
	public $description_02;
	public $gross_weight;
	public $nett_weight;
	public $cbm;
	public $exporter_bank_details;
	public $intermediary_bank;
	public $shipment_mode;
	public $ex_factory_date;
	public $sailing_date;
	public $operator;
	public $datetime;
	public $delivery_terms;
	public $po_date;
	public $cart_lines;
	public $pl_lines;
	public $freezed;
	public $pl_pdf;
	public $in_pdf;
	public $a_operator;
	public $port_delivery;
	public $dispatch_details;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'invoice_details';
		$this->TableName = 'invoice_details';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`invoice_details`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('invoice_details', 'invoice_details', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// barcode
		$this->_barcode = new DbField('invoice_details', 'invoice_details', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 201, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->_barcode->Sortable = TRUE; // Allow sort
		$this->fields['barcode'] = &$this->_barcode;

		// exporter
		$this->exporter = new DbField('invoice_details', 'invoice_details', 'x_exporter', 'exporter', '`exporter`', '`exporter`', 201, -1, FALSE, '`exporter`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->exporter->Required = TRUE; // Required field
		$this->exporter->Sortable = TRUE; // Allow sort
		$this->exporter->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->exporter->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->exporter->Lookup = new Lookup('exporter', 'production_partner', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['exporter'] = &$this->exporter;

		// consignee
		$this->consignee = new DbField('invoice_details', 'invoice_details', 'x_consignee', 'consignee', '`consignee`', '`consignee`', 201, -1, FALSE, '`consignee`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->consignee->Required = TRUE; // Required field
		$this->consignee->Sortable = TRUE; // Allow sort
		$this->consignee->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->consignee->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->consignee->Lookup = new Lookup('consignee', 'buyer', FALSE, 'id', ["name","code","",""], [], ["x_packing_list_no"], [], [], [], [], '`name` ASC', '');
		$this->fields['consignee'] = &$this->consignee;

		// consignee_other
		$this->consignee_other = new DbField('invoice_details', 'invoice_details', 'x_consignee_other', 'consignee_other', '`consignee_other`', '`consignee_other`', 201, -1, FALSE, '`consignee_other`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->consignee_other->Sortable = TRUE; // Allow sort
		$this->consignee_other->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->consignee_other->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->consignee_other->Lookup = new Lookup('consignee_other', 'buyer', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->fields['consignee_other'] = &$this->consignee_other;

		// packing_list_no
		$this->packing_list_no = new DbField('invoice_details', 'invoice_details', 'x_packing_list_no', 'packing_list_no', '`packing_list_no`', '`packing_list_no`', 131, -1, FALSE, '`packing_list_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_list_no->Sortable = TRUE; // Allow sort
		$this->packing_list_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_list_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_list_no->Lookup = new Lookup('packing_list_no', 'bcode', TRUE, 'pl_no', ["pl_no","","",""], ["x_consignee"], [], ["buyers_id"], ["x_buyers_id"], [], [], '`pl_no` DESC', '');
		$this->packing_list_no->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packing_list_no'] = &$this->packing_list_no;

		// d_11
		$this->d_11 = new DbField('invoice_details', 'invoice_details', 'x_d_11', 'd_11', '`d_11`', '`d_11`', 200, -1, FALSE, '`d_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_11->Sortable = TRUE; // Allow sort
		$this->fields['d_11'] = &$this->d_11;

		// description_11
		$this->description_11 = new DbField('invoice_details', 'invoice_details', 'x_description_11', 'description_11', '`description_11`', '`description_11`', 201, -1, FALSE, '`description_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->description_11->Sortable = TRUE; // Allow sort
		$this->fields['description_11'] = &$this->description_11;

		// in_template
		$this->in_template = new DbField('invoice_details', 'invoice_details', 'x_in_template', 'in_template', '`in_template`', '`in_template`', 200, -1, FALSE, '`in_template`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->in_template->Sortable = TRUE; // Allow sort
		$this->in_template->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->in_template->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->in_template->Lookup = new Lookup('in_template', 'apc', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->in_template->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['in_template'] = &$this->in_template;

		// pl_template
		$this->pl_template = new DbField('invoice_details', 'invoice_details', 'x_pl_template', 'pl_template', '`pl_template`', '`pl_template`', 200, -1, FALSE, '`pl_template`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pl_template->Sortable = TRUE; // Allow sort
		$this->pl_template->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pl_template->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->pl_template->Lookup = new Lookup('pl_template', 'apc', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->pl_template->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pl_template'] = &$this->pl_template;

		// invoice_no
		$this->invoice_no = new DbField('invoice_details', 'invoice_details', 'x_invoice_no', 'invoice_no', '`invoice_no`', '`invoice_no`', 200, -1, FALSE, '`invoice_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_no->Required = TRUE; // Required field
		$this->invoice_no->Sortable = TRUE; // Allow sort
		$this->fields['invoice_no'] = &$this->invoice_no;

		// invoice_date
		$this->invoice_date = new DbField('invoice_details', 'invoice_details', 'x_invoice_date', 'invoice_date', '`invoice_date`', CastDateFieldForLike('`invoice_date`', 0, "DB"), 135, 0, FALSE, '`invoice_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_date->Sortable = TRUE; // Allow sort
		$this->invoice_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['invoice_date'] = &$this->invoice_date;

		// po_no
		$this->po_no = new DbField('invoice_details', 'invoice_details', 'x_po_no', 'po_no', '`po_no`', '`po_no`', 201, -1, FALSE, '`po_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->po_no->Sortable = TRUE; // Allow sort
		$this->fields['po_no'] = &$this->po_no;

		// other_reference
		$this->other_reference = new DbField('invoice_details', 'invoice_details', 'x_other_reference', 'other_reference', '`other_reference`', '`other_reference`', 200, -1, FALSE, '`other_reference`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other_reference->Sortable = TRUE; // Allow sort
		$this->fields['other_reference'] = &$this->other_reference;

		// origin
		$this->origin = new DbField('invoice_details', 'invoice_details', 'x_origin', 'origin', '`origin`', '`origin`', 200, -1, FALSE, '`origin`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->origin->Sortable = TRUE; // Allow sort
		$this->fields['origin'] = &$this->origin;

		// final_destination
		$this->final_destination = new DbField('invoice_details', 'invoice_details', 'x_final_destination', 'final_destination', '`final_destination`', '`final_destination`', 200, -1, FALSE, '`final_destination`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->final_destination->Sortable = TRUE; // Allow sort
		$this->fields['final_destination'] = &$this->final_destination;

		// payment_terms
		$this->payment_terms = new DbField('invoice_details', 'invoice_details', 'x_payment_terms', 'payment_terms', '`payment_terms`', '`payment_terms`', 200, -1, FALSE, '`payment_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->payment_terms->Sortable = TRUE; // Allow sort
		$this->fields['payment_terms'] = &$this->payment_terms;

		// pre_carriage_receipt
		$this->pre_carriage_receipt = new DbField('invoice_details', 'invoice_details', 'x_pre_carriage_receipt', 'pre_carriage_receipt', '`pre_carriage_receipt`', '`pre_carriage_receipt`', 200, -1, FALSE, '`pre_carriage_receipt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pre_carriage_receipt->Sortable = TRUE; // Allow sort
		$this->fields['pre_carriage_receipt'] = &$this->pre_carriage_receipt;

		// place_of_receipt
		$this->place_of_receipt = new DbField('invoice_details', 'invoice_details', 'x_place_of_receipt', 'place_of_receipt', '`place_of_receipt`', '`place_of_receipt`', 200, -1, FALSE, '`place_of_receipt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->place_of_receipt->Sortable = TRUE; // Allow sort
		$this->fields['place_of_receipt'] = &$this->place_of_receipt;

		// loading_port
		$this->loading_port = new DbField('invoice_details', 'invoice_details', 'x_loading_port', 'loading_port', '`loading_port`', '`loading_port`', 200, -1, FALSE, '`loading_port`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->loading_port->Sortable = TRUE; // Allow sort
		$this->fields['loading_port'] = &$this->loading_port;

		// port_discharge
		$this->port_discharge = new DbField('invoice_details', 'invoice_details', 'x_port_discharge', 'port_discharge', '`port_discharge`', '`port_discharge`', 200, -1, FALSE, '`port_discharge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->port_discharge->Sortable = TRUE; // Allow sort
		$this->fields['port_discharge'] = &$this->port_discharge;

		// d_01
		$this->d_01 = new DbField('invoice_details', 'invoice_details', 'x_d_01', 'd_01', '`d_01`', '`d_01`', 200, -1, FALSE, '`d_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_01->Sortable = TRUE; // Allow sort
		$this->fields['d_01'] = &$this->d_01;

		// description_01
		$this->description_01 = new DbField('invoice_details', 'invoice_details', 'x_description_01', 'description_01', '`description_01`', '`description_01`', 200, -1, FALSE, '`description_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_01->Sortable = TRUE; // Allow sort
		$this->fields['description_01'] = &$this->description_01;

		// d_02
		$this->d_02 = new DbField('invoice_details', 'invoice_details', 'x_d_02', 'd_02', '`d_02`', '`d_02`', 200, -1, FALSE, '`d_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_02->Sortable = TRUE; // Allow sort
		$this->fields['d_02'] = &$this->d_02;

		// description_02
		$this->description_02 = new DbField('invoice_details', 'invoice_details', 'x_description_02', 'description_02', '`description_02`', '`description_02`', 200, -1, FALSE, '`description_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->description_02->Sortable = TRUE; // Allow sort
		$this->fields['description_02'] = &$this->description_02;

		// gross_weight
		$this->gross_weight = new DbField('invoice_details', 'invoice_details', 'x_gross_weight', 'gross_weight', '`gross_weight`', '`gross_weight`', 200, -1, FALSE, '`gross_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gross_weight->Sortable = TRUE; // Allow sort
		$this->fields['gross_weight'] = &$this->gross_weight;

		// nett_weight
		$this->nett_weight = new DbField('invoice_details', 'invoice_details', 'x_nett_weight', 'nett_weight', '`nett_weight`', '`nett_weight`', 200, -1, FALSE, '`nett_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nett_weight->Sortable = TRUE; // Allow sort
		$this->fields['nett_weight'] = &$this->nett_weight;

		// cbm
		$this->cbm = new DbField('invoice_details', 'invoice_details', 'x_cbm', 'cbm', '`cbm`', '`cbm`', 200, -1, FALSE, '`cbm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cbm->Sortable = TRUE; // Allow sort
		$this->fields['cbm'] = &$this->cbm;

		// exporter_bank_details
		$this->exporter_bank_details = new DbField('invoice_details', 'invoice_details', 'x_exporter_bank_details', 'exporter_bank_details', '`exporter_bank_details`', '`exporter_bank_details`', 201, -1, FALSE, '`exporter_bank_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->exporter_bank_details->Sortable = TRUE; // Allow sort
		$this->fields['exporter_bank_details'] = &$this->exporter_bank_details;

		// intermediary_bank
		$this->intermediary_bank = new DbField('invoice_details', 'invoice_details', 'x_intermediary_bank', 'intermediary_bank', '`intermediary_bank`', '`intermediary_bank`', 201, -1, FALSE, '`intermediary_bank`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->intermediary_bank->Sortable = TRUE; // Allow sort
		$this->fields['intermediary_bank'] = &$this->intermediary_bank;

		// shipment_mode
		$this->shipment_mode = new DbField('invoice_details', 'invoice_details', 'x_shipment_mode', 'shipment_mode', '`shipment_mode`', '`shipment_mode`', 2, -1, FALSE, '`shipment_mode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipment_mode->Sortable = TRUE; // Allow sort
		$this->shipment_mode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shipment_mode'] = &$this->shipment_mode;

		// ex_factory_date
		$this->ex_factory_date = new DbField('invoice_details', 'invoice_details', 'x_ex_factory_date', 'ex_factory_date', '`ex_factory_date`', CastDateFieldForLike('`ex_factory_date`', 0, "DB"), 133, 0, FALSE, '`ex_factory_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ex_factory_date->Sortable = TRUE; // Allow sort
		$this->ex_factory_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['ex_factory_date'] = &$this->ex_factory_date;

		// sailing_date
		$this->sailing_date = new DbField('invoice_details', 'invoice_details', 'x_sailing_date', 'sailing_date', '`sailing_date`', CastDateFieldForLike('`sailing_date`', 0, "DB"), 133, 0, FALSE, '`sailing_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->sailing_date->Sortable = TRUE; // Allow sort
		$this->sailing_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['sailing_date'] = &$this->sailing_date;

		// operator
		$this->operator = new DbField('invoice_details', 'invoice_details', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('invoice_details', 'invoice_details', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// delivery_terms
		$this->delivery_terms = new DbField('invoice_details', 'invoice_details', 'x_delivery_terms', 'delivery_terms', '`delivery_terms`', '`delivery_terms`', 200, -1, FALSE, '`delivery_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->delivery_terms->Sortable = FALSE; // Allow sort
		$this->fields['delivery_terms'] = &$this->delivery_terms;

		// po_date
		$this->po_date = new DbField('invoice_details', 'invoice_details', 'x_po_date', 'po_date', '`po_date`', CastDateFieldForLike('`po_date`', 0, "DB"), 135, 0, FALSE, '`po_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_date->Sortable = FALSE; // Allow sort
		$this->po_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['po_date'] = &$this->po_date;

		// cart_lines
		$this->cart_lines = new DbField('invoice_details', 'invoice_details', 'x_cart_lines', 'cart_lines', '`cart_lines`', '`cart_lines`', 200, -1, FALSE, '`cart_lines`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cart_lines->Required = TRUE; // Required field
		$this->cart_lines->Sortable = TRUE; // Allow sort
		$this->cart_lines->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['cart_lines'] = &$this->cart_lines;

		// pl_lines
		$this->pl_lines = new DbField('invoice_details', 'invoice_details', 'x_pl_lines', 'pl_lines', '`pl_lines`', '`pl_lines`', 200, -1, FALSE, '`pl_lines`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pl_lines->Required = TRUE; // Required field
		$this->pl_lines->Sortable = TRUE; // Allow sort
		$this->pl_lines->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['pl_lines'] = &$this->pl_lines;

		// freezed
		$this->freezed = new DbField('invoice_details', 'invoice_details', 'x_freezed', 'freezed', '`freezed`', '`freezed`', 17, -1, FALSE, '`freezed`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->freezed->Nullable = FALSE; // NOT NULL field
		$this->freezed->Sortable = TRUE; // Allow sort
		$this->freezed->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->freezed->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->freezed->Lookup = new Lookup('freezed', 'invoice_details', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->freezed->OptionCount = 2;
		$this->freezed->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['freezed'] = &$this->freezed;

		// pl_pdf
		$this->pl_pdf = new DbField('invoice_details', 'invoice_details', 'x_pl_pdf', 'pl_pdf', '`pl_pdf`', '`pl_pdf`', 200, -1, FALSE, '`pl_pdf`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pl_pdf->Sortable = FALSE; // Allow sort
		$this->fields['pl_pdf'] = &$this->pl_pdf;

		// in_pdf
		$this->in_pdf = new DbField('invoice_details', 'invoice_details', 'x_in_pdf', 'in_pdf', '`in_pdf`', '`in_pdf`', 200, -1, FALSE, '`in_pdf`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->in_pdf->Sortable = FALSE; // Allow sort
		$this->fields['in_pdf'] = &$this->in_pdf;

		// a_operator
		$this->a_operator = new DbField('invoice_details', 'invoice_details', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 2, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// port_delivery
		$this->port_delivery = new DbField('invoice_details', 'invoice_details', 'x_port_delivery', 'port_delivery', '`port_delivery`', '`port_delivery`', 200, -1, FALSE, '`port_delivery`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->port_delivery->Sortable = TRUE; // Allow sort
		$this->fields['port_delivery'] = &$this->port_delivery;

		// dispatch_details
		$this->dispatch_details = new DbField('invoice_details', 'invoice_details', 'x_dispatch_details', 'dispatch_details', '`dispatch_details`', '`dispatch_details`', 200, -1, FALSE, '`dispatch_details`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dispatch_details->Sortable = TRUE; // Allow sort
		$this->fields['dispatch_details'] = &$this->dispatch_details;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`invoice_details`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->exporter->DbValue = $row['exporter'];
		$this->consignee->DbValue = $row['consignee'];
		$this->consignee_other->DbValue = $row['consignee_other'];
		$this->packing_list_no->DbValue = $row['packing_list_no'];
		$this->d_11->DbValue = $row['d_11'];
		$this->description_11->DbValue = $row['description_11'];
		$this->in_template->DbValue = $row['in_template'];
		$this->pl_template->DbValue = $row['pl_template'];
		$this->invoice_no->DbValue = $row['invoice_no'];
		$this->invoice_date->DbValue = $row['invoice_date'];
		$this->po_no->DbValue = $row['po_no'];
		$this->other_reference->DbValue = $row['other_reference'];
		$this->origin->DbValue = $row['origin'];
		$this->final_destination->DbValue = $row['final_destination'];
		$this->payment_terms->DbValue = $row['payment_terms'];
		$this->pre_carriage_receipt->DbValue = $row['pre_carriage_receipt'];
		$this->place_of_receipt->DbValue = $row['place_of_receipt'];
		$this->loading_port->DbValue = $row['loading_port'];
		$this->port_discharge->DbValue = $row['port_discharge'];
		$this->d_01->DbValue = $row['d_01'];
		$this->description_01->DbValue = $row['description_01'];
		$this->d_02->DbValue = $row['d_02'];
		$this->description_02->DbValue = $row['description_02'];
		$this->gross_weight->DbValue = $row['gross_weight'];
		$this->nett_weight->DbValue = $row['nett_weight'];
		$this->cbm->DbValue = $row['cbm'];
		$this->exporter_bank_details->DbValue = $row['exporter_bank_details'];
		$this->intermediary_bank->DbValue = $row['intermediary_bank'];
		$this->shipment_mode->DbValue = $row['shipment_mode'];
		$this->ex_factory_date->DbValue = $row['ex_factory_date'];
		$this->sailing_date->DbValue = $row['sailing_date'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->delivery_terms->DbValue = $row['delivery_terms'];
		$this->po_date->DbValue = $row['po_date'];
		$this->cart_lines->DbValue = $row['cart_lines'];
		$this->pl_lines->DbValue = $row['pl_lines'];
		$this->freezed->DbValue = $row['freezed'];
		$this->pl_pdf->DbValue = $row['pl_pdf'];
		$this->in_pdf->DbValue = $row['in_pdf'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->port_delivery->DbValue = $row['port_delivery'];
		$this->dispatch_details->DbValue = $row['dispatch_details'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "invoice_detailslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "invoice_detailsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "invoice_detailsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "invoice_detailsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "invoice_detailslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("invoice_detailsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("invoice_detailsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "invoice_detailsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "invoice_detailsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("invoice_detailsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("invoice_detailsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("invoice_detailsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->exporter->setDbValue($rs->fields('exporter'));
		$this->consignee->setDbValue($rs->fields('consignee'));
		$this->consignee_other->setDbValue($rs->fields('consignee_other'));
		$this->packing_list_no->setDbValue($rs->fields('packing_list_no'));
		$this->d_11->setDbValue($rs->fields('d_11'));
		$this->description_11->setDbValue($rs->fields('description_11'));
		$this->in_template->setDbValue($rs->fields('in_template'));
		$this->pl_template->setDbValue($rs->fields('pl_template'));
		$this->invoice_no->setDbValue($rs->fields('invoice_no'));
		$this->invoice_date->setDbValue($rs->fields('invoice_date'));
		$this->po_no->setDbValue($rs->fields('po_no'));
		$this->other_reference->setDbValue($rs->fields('other_reference'));
		$this->origin->setDbValue($rs->fields('origin'));
		$this->final_destination->setDbValue($rs->fields('final_destination'));
		$this->payment_terms->setDbValue($rs->fields('payment_terms'));
		$this->pre_carriage_receipt->setDbValue($rs->fields('pre_carriage_receipt'));
		$this->place_of_receipt->setDbValue($rs->fields('place_of_receipt'));
		$this->loading_port->setDbValue($rs->fields('loading_port'));
		$this->port_discharge->setDbValue($rs->fields('port_discharge'));
		$this->d_01->setDbValue($rs->fields('d_01'));
		$this->description_01->setDbValue($rs->fields('description_01'));
		$this->d_02->setDbValue($rs->fields('d_02'));
		$this->description_02->setDbValue($rs->fields('description_02'));
		$this->gross_weight->setDbValue($rs->fields('gross_weight'));
		$this->nett_weight->setDbValue($rs->fields('nett_weight'));
		$this->cbm->setDbValue($rs->fields('cbm'));
		$this->exporter_bank_details->setDbValue($rs->fields('exporter_bank_details'));
		$this->intermediary_bank->setDbValue($rs->fields('intermediary_bank'));
		$this->shipment_mode->setDbValue($rs->fields('shipment_mode'));
		$this->ex_factory_date->setDbValue($rs->fields('ex_factory_date'));
		$this->sailing_date->setDbValue($rs->fields('sailing_date'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->delivery_terms->setDbValue($rs->fields('delivery_terms'));
		$this->po_date->setDbValue($rs->fields('po_date'));
		$this->cart_lines->setDbValue($rs->fields('cart_lines'));
		$this->pl_lines->setDbValue($rs->fields('pl_lines'));
		$this->freezed->setDbValue($rs->fields('freezed'));
		$this->pl_pdf->setDbValue($rs->fields('pl_pdf'));
		$this->in_pdf->setDbValue($rs->fields('in_pdf'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->port_delivery->setDbValue($rs->fields('port_delivery'));
		$this->dispatch_details->setDbValue($rs->fields('dispatch_details'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// barcode
		// exporter
		// consignee
		// consignee_other
		// packing_list_no
		// d_11
		// description_11
		// in_template
		// pl_template
		// invoice_no
		// invoice_date
		// po_no
		// other_reference
		// origin
		// final_destination
		// payment_terms
		// pre_carriage_receipt
		// place_of_receipt
		// loading_port
		// port_discharge
		// d_01
		// description_01
		// d_02
		// description_02
		// gross_weight
		// nett_weight
		// cbm
		// exporter_bank_details
		// intermediary_bank
		// shipment_mode
		// ex_factory_date
		// sailing_date
		// operator
		// datetime
		// delivery_terms

		$this->delivery_terms->CellCssStyle = "white-space: nowrap;";

		// po_date
		$this->po_date->CellCssStyle = "white-space: nowrap;";

		// cart_lines
		// pl_lines
		// freezed
		// pl_pdf

		$this->pl_pdf->CellCssStyle = "white-space: nowrap;";

		// in_pdf
		$this->in_pdf->CellCssStyle = "white-space: nowrap;";

		// a_operator
		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// port_delivery
		// dispatch_details
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// exporter
		$curVal = strval($this->exporter->CurrentValue);
		if ($curVal <> "") {
			$this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
			if ($this->exporter->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->exporter->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->exporter->ViewValue = $this->exporter->CurrentValue;
				}
			}
		} else {
			$this->exporter->ViewValue = NULL;
		}
		$this->exporter->ViewCustomAttributes = "";

		// consignee
		$curVal = strval($this->consignee->CurrentValue);
		if ($curVal <> "") {
			$this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
			if ($this->consignee->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->consignee->ViewValue = $this->consignee->CurrentValue;
				}
			}
		} else {
			$this->consignee->ViewValue = NULL;
		}
		$this->consignee->ViewCustomAttributes = "";

		// consignee_other
		$curVal = strval($this->consignee_other->CurrentValue);
		if ($curVal <> "") {
			$this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
			if ($this->consignee_other->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consignee_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
				}
			}
		} else {
			$this->consignee_other->ViewValue = NULL;
		}
		$this->consignee_other->ViewCustomAttributes = "";

		// packing_list_no
		$curVal = strval($this->packing_list_no->CurrentValue);
		if ($curVal <> "") {
			$this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
			if ($this->packing_list_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`pl_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`pl_no` != 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_list_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
					$this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_list_no->ViewValue = $this->packing_list_no->CurrentValue;
				}
			}
		} else {
			$this->packing_list_no->ViewValue = NULL;
		}
		$this->packing_list_no->ViewCustomAttributes = "";

		// d_11
		$this->d_11->ViewValue = $this->d_11->CurrentValue;
		$this->d_11->ViewCustomAttributes = "";

		// description_11
		$this->description_11->ViewValue = $this->description_11->CurrentValue;
		$this->description_11->ViewCustomAttributes = "";

		// in_template
		$curVal = strval($this->in_template->CurrentValue);
		if ($curVal <> "") {
			$this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
			if ($this->in_template->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$lookupFilter = function() {
					return "`apcid` between 45501 and 45999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->in_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->in_template->ViewValue = $this->in_template->CurrentValue;
				}
			}
		} else {
			$this->in_template->ViewValue = NULL;
		}
		$this->in_template->ViewCustomAttributes = "";

		// pl_template
		$curVal = strval($this->pl_template->CurrentValue);
		if ($curVal <> "") {
			$this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
			if ($this->pl_template->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$lookupFilter = function() {
					return "`apcid` between 45001 and 45500";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->pl_template->ViewValue = $this->pl_template->CurrentValue;
				}
			}
		} else {
			$this->pl_template->ViewValue = NULL;
		}
		$this->pl_template->ViewCustomAttributes = "";

		// invoice_no
		$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
		$this->invoice_no->ViewCustomAttributes = "";

		// invoice_date
		$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
		$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
		$this->invoice_date->ViewCustomAttributes = "";

		// po_no
		$this->po_no->ViewValue = $this->po_no->CurrentValue;
		$this->po_no->ViewCustomAttributes = "";

		// other_reference
		$this->other_reference->ViewValue = $this->other_reference->CurrentValue;
		$this->other_reference->ViewCustomAttributes = "";

		// origin
		$this->origin->ViewValue = $this->origin->CurrentValue;
		$this->origin->ViewCustomAttributes = "";

		// final_destination
		$this->final_destination->ViewValue = $this->final_destination->CurrentValue;
		$this->final_destination->ViewCustomAttributes = "";

		// payment_terms
		$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
		$this->payment_terms->ViewCustomAttributes = "";

		// pre_carriage_receipt
		$this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;
		$this->pre_carriage_receipt->ViewCustomAttributes = "";

		// place_of_receipt
		$this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;
		$this->place_of_receipt->ViewCustomAttributes = "";

		// loading_port
		$this->loading_port->ViewValue = $this->loading_port->CurrentValue;
		$this->loading_port->ViewCustomAttributes = "";

		// port_discharge
		$this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;
		$this->port_discharge->ViewCustomAttributes = "";

		// d_01
		$this->d_01->ViewValue = $this->d_01->CurrentValue;
		$this->d_01->ViewCustomAttributes = "";

		// description_01
		$this->description_01->ViewValue = $this->description_01->CurrentValue;
		$this->description_01->ViewCustomAttributes = "";

		// d_02
		$this->d_02->ViewValue = $this->d_02->CurrentValue;
		$this->d_02->ViewCustomAttributes = "";

		// description_02
		$this->description_02->ViewValue = $this->description_02->CurrentValue;
		$this->description_02->ViewCustomAttributes = "";

		// gross_weight
		$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
		$this->gross_weight->ViewCustomAttributes = "";

		// nett_weight
		$this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;
		$this->nett_weight->ViewCustomAttributes = "";

		// cbm
		$this->cbm->ViewValue = $this->cbm->CurrentValue;
		$this->cbm->ViewCustomAttributes = "";

		// exporter_bank_details
		$this->exporter_bank_details->ViewValue = $this->exporter_bank_details->CurrentValue;
		$this->exporter_bank_details->ViewCustomAttributes = "";

		// intermediary_bank
		$this->intermediary_bank->ViewValue = $this->intermediary_bank->CurrentValue;
		$this->intermediary_bank->ViewCustomAttributes = "";

		// shipment_mode
		$this->shipment_mode->ViewValue = $this->shipment_mode->CurrentValue;
		$this->shipment_mode->ViewValue = FormatNumber($this->shipment_mode->ViewValue, 0, -2, -2, -2);
		$this->shipment_mode->ViewCustomAttributes = "";

		// ex_factory_date
		$this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
		$this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, 0);
		$this->ex_factory_date->ViewCustomAttributes = "";

		// sailing_date
		$this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
		$this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, 0);
		$this->sailing_date->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// delivery_terms
		$this->delivery_terms->ViewValue = $this->delivery_terms->CurrentValue;
		$this->delivery_terms->ViewCustomAttributes = "";

		// po_date
		$this->po_date->ViewValue = $this->po_date->CurrentValue;
		$this->po_date->ViewValue = FormatDateTime($this->po_date->ViewValue, 0);
		$this->po_date->ViewCustomAttributes = "";

		// cart_lines
		$this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;
		$this->cart_lines->ViewCustomAttributes = "";

		// pl_lines
		$this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;
		$this->pl_lines->ViewCustomAttributes = "";

		// freezed
		if (strval($this->freezed->CurrentValue) <> "") {
			$this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
		} else {
			$this->freezed->ViewValue = NULL;
		}
		$this->freezed->ViewCustomAttributes = "";

		// pl_pdf
		$this->pl_pdf->ViewValue = $this->pl_pdf->CurrentValue;
		$this->pl_pdf->ViewCustomAttributes = "";

		// in_pdf
		$this->in_pdf->ViewValue = $this->in_pdf->CurrentValue;
		$this->in_pdf->ViewCustomAttributes = "";

		// a_operator
		$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
		$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
		$this->a_operator->ViewCustomAttributes = "";

		// port_delivery
		$this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;
		$this->port_delivery->ViewCustomAttributes = "";

		// dispatch_details
		$this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;
		$this->dispatch_details->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// exporter
		$this->exporter->LinkCustomAttributes = "";
		$this->exporter->HrefValue = "";
		$this->exporter->TooltipValue = "";

		// consignee
		$this->consignee->LinkCustomAttributes = "";
		$this->consignee->HrefValue = "";
		$this->consignee->TooltipValue = "";

		// consignee_other
		$this->consignee_other->LinkCustomAttributes = "";
		$this->consignee_other->HrefValue = "";
		$this->consignee_other->TooltipValue = "";

		// packing_list_no
		$this->packing_list_no->LinkCustomAttributes = "";
		$this->packing_list_no->HrefValue = "";
		$this->packing_list_no->TooltipValue = "";

		// d_11
		$this->d_11->LinkCustomAttributes = "";
		$this->d_11->HrefValue = "";
		$this->d_11->TooltipValue = "";

		// description_11
		$this->description_11->LinkCustomAttributes = "";
		$this->description_11->HrefValue = "";
		$this->description_11->TooltipValue = "";

		// in_template
		$this->in_template->LinkCustomAttributes = "";
		$this->in_template->HrefValue = "";
		$this->in_template->TooltipValue = "";

		// pl_template
		$this->pl_template->LinkCustomAttributes = "";
		$this->pl_template->HrefValue = "";
		$this->pl_template->TooltipValue = "";

		// invoice_no
		$this->invoice_no->LinkCustomAttributes = "";
		$this->invoice_no->HrefValue = "";
		$this->invoice_no->TooltipValue = "";

		// invoice_date
		$this->invoice_date->LinkCustomAttributes = "";
		$this->invoice_date->HrefValue = "";
		$this->invoice_date->TooltipValue = "";

		// po_no
		$this->po_no->LinkCustomAttributes = "";
		$this->po_no->HrefValue = "";
		$this->po_no->TooltipValue = "";

		// other_reference
		$this->other_reference->LinkCustomAttributes = "";
		$this->other_reference->HrefValue = "";
		$this->other_reference->TooltipValue = "";

		// origin
		$this->origin->LinkCustomAttributes = "";
		$this->origin->HrefValue = "";
		$this->origin->TooltipValue = "";

		// final_destination
		$this->final_destination->LinkCustomAttributes = "";
		$this->final_destination->HrefValue = "";
		$this->final_destination->TooltipValue = "";

		// payment_terms
		$this->payment_terms->LinkCustomAttributes = "";
		$this->payment_terms->HrefValue = "";
		$this->payment_terms->TooltipValue = "";

		// pre_carriage_receipt
		$this->pre_carriage_receipt->LinkCustomAttributes = "";
		$this->pre_carriage_receipt->HrefValue = "";
		$this->pre_carriage_receipt->TooltipValue = "";

		// place_of_receipt
		$this->place_of_receipt->LinkCustomAttributes = "";
		$this->place_of_receipt->HrefValue = "";
		$this->place_of_receipt->TooltipValue = "";

		// loading_port
		$this->loading_port->LinkCustomAttributes = "";
		$this->loading_port->HrefValue = "";
		$this->loading_port->TooltipValue = "";

		// port_discharge
		$this->port_discharge->LinkCustomAttributes = "";
		$this->port_discharge->HrefValue = "";
		$this->port_discharge->TooltipValue = "";

		// d_01
		$this->d_01->LinkCustomAttributes = "";
		$this->d_01->HrefValue = "";
		$this->d_01->TooltipValue = "";

		// description_01
		$this->description_01->LinkCustomAttributes = "";
		$this->description_01->HrefValue = "";
		$this->description_01->TooltipValue = "";

		// d_02
		$this->d_02->LinkCustomAttributes = "";
		$this->d_02->HrefValue = "";
		$this->d_02->TooltipValue = "";

		// description_02
		$this->description_02->LinkCustomAttributes = "";
		$this->description_02->HrefValue = "";
		$this->description_02->TooltipValue = "";

		// gross_weight
		$this->gross_weight->LinkCustomAttributes = "";
		$this->gross_weight->HrefValue = "";
		$this->gross_weight->TooltipValue = "";

		// nett_weight
		$this->nett_weight->LinkCustomAttributes = "";
		$this->nett_weight->HrefValue = "";
		$this->nett_weight->TooltipValue = "";

		// cbm
		$this->cbm->LinkCustomAttributes = "";
		$this->cbm->HrefValue = "";
		$this->cbm->TooltipValue = "";

		// exporter_bank_details
		$this->exporter_bank_details->LinkCustomAttributes = "";
		$this->exporter_bank_details->HrefValue = "";
		$this->exporter_bank_details->TooltipValue = "";

		// intermediary_bank
		$this->intermediary_bank->LinkCustomAttributes = "";
		$this->intermediary_bank->HrefValue = "";
		$this->intermediary_bank->TooltipValue = "";

		// shipment_mode
		$this->shipment_mode->LinkCustomAttributes = "";
		$this->shipment_mode->HrefValue = "";
		$this->shipment_mode->TooltipValue = "";

		// ex_factory_date
		$this->ex_factory_date->LinkCustomAttributes = "";
		$this->ex_factory_date->HrefValue = "";
		$this->ex_factory_date->TooltipValue = "";

		// sailing_date
		$this->sailing_date->LinkCustomAttributes = "";
		$this->sailing_date->HrefValue = "";
		$this->sailing_date->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// delivery_terms
		$this->delivery_terms->LinkCustomAttributes = "";
		$this->delivery_terms->HrefValue = "";
		$this->delivery_terms->TooltipValue = "";

		// po_date
		$this->po_date->LinkCustomAttributes = "";
		$this->po_date->HrefValue = "";
		$this->po_date->TooltipValue = "";

		// cart_lines
		$this->cart_lines->LinkCustomAttributes = "";
		$this->cart_lines->HrefValue = "";
		$this->cart_lines->TooltipValue = "";

		// pl_lines
		$this->pl_lines->LinkCustomAttributes = "";
		$this->pl_lines->HrefValue = "";
		$this->pl_lines->TooltipValue = "";

		// freezed
		$this->freezed->LinkCustomAttributes = "";
		$this->freezed->HrefValue = "";
		$this->freezed->TooltipValue = "";

		// pl_pdf
		$this->pl_pdf->LinkCustomAttributes = "";
		$this->pl_pdf->HrefValue = "";
		$this->pl_pdf->TooltipValue = "";

		// in_pdf
		$this->in_pdf->LinkCustomAttributes = "";
		$this->in_pdf->HrefValue = "";
		$this->in_pdf->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// port_delivery
		$this->port_delivery->LinkCustomAttributes = "";
		$this->port_delivery->HrefValue = "";
		$this->port_delivery->TooltipValue = "";

		// dispatch_details
		$this->dispatch_details->LinkCustomAttributes = "";
		$this->dispatch_details->HrefValue = "";
		$this->dispatch_details->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// exporter
		$this->exporter->EditAttrs["class"] = "form-control";
		$this->exporter->EditCustomAttributes = "";

		// consignee
		$this->consignee->EditAttrs["class"] = "form-control";
		$this->consignee->EditCustomAttributes = "";

		// consignee_other
		$this->consignee_other->EditAttrs["class"] = "form-control";
		$this->consignee_other->EditCustomAttributes = "";

		// packing_list_no
		$this->packing_list_no->EditAttrs["class"] = "form-control";
		$this->packing_list_no->EditCustomAttributes = "";

		// d_11
		$this->d_11->EditAttrs["class"] = "form-control";
		$this->d_11->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_11->CurrentValue = HtmlDecode($this->d_11->CurrentValue);
		$this->d_11->EditValue = $this->d_11->CurrentValue;
		$this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

		// description_11
		$this->description_11->EditAttrs["class"] = "form-control";
		$this->description_11->EditCustomAttributes = "";
		$this->description_11->EditValue = $this->description_11->CurrentValue;
		$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

		// in_template
		$this->in_template->EditAttrs["class"] = "form-control";
		$this->in_template->EditCustomAttributes = "";

		// pl_template
		$this->pl_template->EditAttrs["class"] = "form-control";
		$this->pl_template->EditCustomAttributes = "";

		// invoice_no
		$this->invoice_no->EditAttrs["class"] = "form-control";
		$this->invoice_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
		$this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
		$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

		// invoice_date
		$this->invoice_date->EditAttrs["class"] = "form-control";
		$this->invoice_date->EditCustomAttributes = "";
		$this->invoice_date->EditValue = FormatDateTime($this->invoice_date->CurrentValue, 8);
		$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

		// po_no
		$this->po_no->EditAttrs["class"] = "form-control";
		$this->po_no->EditCustomAttributes = "";
		$this->po_no->EditValue = $this->po_no->CurrentValue;
		$this->po_no->PlaceHolder = RemoveHtml($this->po_no->caption());

		// other_reference
		$this->other_reference->EditAttrs["class"] = "form-control";
		$this->other_reference->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->other_reference->CurrentValue = HtmlDecode($this->other_reference->CurrentValue);
		$this->other_reference->EditValue = $this->other_reference->CurrentValue;
		$this->other_reference->PlaceHolder = RemoveHtml($this->other_reference->caption());

		// origin
		$this->origin->EditAttrs["class"] = "form-control";
		$this->origin->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->origin->CurrentValue = HtmlDecode($this->origin->CurrentValue);
		$this->origin->EditValue = $this->origin->CurrentValue;
		$this->origin->PlaceHolder = RemoveHtml($this->origin->caption());

		// final_destination
		$this->final_destination->EditAttrs["class"] = "form-control";
		$this->final_destination->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->final_destination->CurrentValue = HtmlDecode($this->final_destination->CurrentValue);
		$this->final_destination->EditValue = $this->final_destination->CurrentValue;
		$this->final_destination->PlaceHolder = RemoveHtml($this->final_destination->caption());

		// payment_terms
		$this->payment_terms->EditAttrs["class"] = "form-control";
		$this->payment_terms->EditCustomAttributes = "";
		$this->payment_terms->EditValue = $this->payment_terms->CurrentValue;
		$this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

		// pre_carriage_receipt
		$this->pre_carriage_receipt->EditAttrs["class"] = "form-control";
		$this->pre_carriage_receipt->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pre_carriage_receipt->CurrentValue = HtmlDecode($this->pre_carriage_receipt->CurrentValue);
		$this->pre_carriage_receipt->EditValue = $this->pre_carriage_receipt->CurrentValue;
		$this->pre_carriage_receipt->PlaceHolder = RemoveHtml($this->pre_carriage_receipt->caption());

		// place_of_receipt
		$this->place_of_receipt->EditAttrs["class"] = "form-control";
		$this->place_of_receipt->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->place_of_receipt->CurrentValue = HtmlDecode($this->place_of_receipt->CurrentValue);
		$this->place_of_receipt->EditValue = $this->place_of_receipt->CurrentValue;
		$this->place_of_receipt->PlaceHolder = RemoveHtml($this->place_of_receipt->caption());

		// loading_port
		$this->loading_port->EditAttrs["class"] = "form-control";
		$this->loading_port->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->loading_port->CurrentValue = HtmlDecode($this->loading_port->CurrentValue);
		$this->loading_port->EditValue = $this->loading_port->CurrentValue;
		$this->loading_port->PlaceHolder = RemoveHtml($this->loading_port->caption());

		// port_discharge
		$this->port_discharge->EditAttrs["class"] = "form-control";
		$this->port_discharge->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->port_discharge->CurrentValue = HtmlDecode($this->port_discharge->CurrentValue);
		$this->port_discharge->EditValue = $this->port_discharge->CurrentValue;
		$this->port_discharge->PlaceHolder = RemoveHtml($this->port_discharge->caption());

		// d_01
		$this->d_01->EditAttrs["class"] = "form-control";
		$this->d_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
		$this->d_01->EditValue = $this->d_01->CurrentValue;
		$this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

		// description_01
		$this->description_01->EditAttrs["class"] = "form-control";
		$this->description_01->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_01->CurrentValue = HtmlDecode($this->description_01->CurrentValue);
		$this->description_01->EditValue = $this->description_01->CurrentValue;
		$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

		// d_02
		$this->d_02->EditAttrs["class"] = "form-control";
		$this->d_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
		$this->d_02->EditValue = $this->d_02->CurrentValue;
		$this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

		// description_02
		$this->description_02->EditAttrs["class"] = "form-control";
		$this->description_02->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->description_02->CurrentValue = HtmlDecode($this->description_02->CurrentValue);
		$this->description_02->EditValue = $this->description_02->CurrentValue;
		$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

		// gross_weight
		$this->gross_weight->EditAttrs["class"] = "form-control";
		$this->gross_weight->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->gross_weight->CurrentValue = HtmlDecode($this->gross_weight->CurrentValue);
		$this->gross_weight->EditValue = $this->gross_weight->CurrentValue;
		$this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

		// nett_weight
		$this->nett_weight->EditAttrs["class"] = "form-control";
		$this->nett_weight->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->nett_weight->CurrentValue = HtmlDecode($this->nett_weight->CurrentValue);
		$this->nett_weight->EditValue = $this->nett_weight->CurrentValue;
		$this->nett_weight->PlaceHolder = RemoveHtml($this->nett_weight->caption());

		// cbm
		$this->cbm->EditAttrs["class"] = "form-control";
		$this->cbm->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->cbm->CurrentValue = HtmlDecode($this->cbm->CurrentValue);
		$this->cbm->EditValue = $this->cbm->CurrentValue;
		$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

		// exporter_bank_details
		$this->exporter_bank_details->EditAttrs["class"] = "form-control";
		$this->exporter_bank_details->EditCustomAttributes = "";
		$this->exporter_bank_details->EditValue = $this->exporter_bank_details->CurrentValue;
		$this->exporter_bank_details->PlaceHolder = RemoveHtml($this->exporter_bank_details->caption());

		// intermediary_bank
		$this->intermediary_bank->EditAttrs["class"] = "form-control";
		$this->intermediary_bank->EditCustomAttributes = "";
		$this->intermediary_bank->EditValue = $this->intermediary_bank->CurrentValue;
		$this->intermediary_bank->PlaceHolder = RemoveHtml($this->intermediary_bank->caption());

		// shipment_mode
		$this->shipment_mode->EditAttrs["class"] = "form-control";
		$this->shipment_mode->EditCustomAttributes = "";
		$this->shipment_mode->EditValue = $this->shipment_mode->CurrentValue;
		$this->shipment_mode->PlaceHolder = RemoveHtml($this->shipment_mode->caption());

		// ex_factory_date
		$this->ex_factory_date->EditAttrs["class"] = "form-control";
		$this->ex_factory_date->EditCustomAttributes = "";
		$this->ex_factory_date->EditValue = FormatDateTime($this->ex_factory_date->CurrentValue, 8);
		$this->ex_factory_date->PlaceHolder = RemoveHtml($this->ex_factory_date->caption());

		// sailing_date
		$this->sailing_date->EditAttrs["class"] = "form-control";
		$this->sailing_date->EditCustomAttributes = "";
		$this->sailing_date->EditValue = FormatDateTime($this->sailing_date->CurrentValue, 8);
		$this->sailing_date->PlaceHolder = RemoveHtml($this->sailing_date->caption());

		// operator
		// datetime
		// delivery_terms

		$this->delivery_terms->EditAttrs["class"] = "form-control";
		$this->delivery_terms->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->delivery_terms->CurrentValue = HtmlDecode($this->delivery_terms->CurrentValue);
		$this->delivery_terms->EditValue = $this->delivery_terms->CurrentValue;
		$this->delivery_terms->PlaceHolder = RemoveHtml($this->delivery_terms->caption());

		// po_date
		$this->po_date->EditAttrs["class"] = "form-control";
		$this->po_date->EditCustomAttributes = "";
		$this->po_date->EditValue = FormatDateTime($this->po_date->CurrentValue, 8);
		$this->po_date->PlaceHolder = RemoveHtml($this->po_date->caption());

		// cart_lines
		$this->cart_lines->EditAttrs["class"] = "form-control";
		$this->cart_lines->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->cart_lines->CurrentValue = HtmlDecode($this->cart_lines->CurrentValue);
		$this->cart_lines->EditValue = $this->cart_lines->CurrentValue;
		$this->cart_lines->PlaceHolder = RemoveHtml($this->cart_lines->caption());

		// pl_lines
		$this->pl_lines->EditAttrs["class"] = "form-control";
		$this->pl_lines->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pl_lines->CurrentValue = HtmlDecode($this->pl_lines->CurrentValue);
		$this->pl_lines->EditValue = $this->pl_lines->CurrentValue;
		$this->pl_lines->PlaceHolder = RemoveHtml($this->pl_lines->caption());

		// freezed
		$this->freezed->EditAttrs["class"] = "form-control";
		$this->freezed->EditCustomAttributes = "";
		$this->freezed->EditValue = $this->freezed->options(TRUE);

		// pl_pdf
		$this->pl_pdf->EditAttrs["class"] = "form-control";
		$this->pl_pdf->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pl_pdf->CurrentValue = HtmlDecode($this->pl_pdf->CurrentValue);
		$this->pl_pdf->EditValue = $this->pl_pdf->CurrentValue;
		$this->pl_pdf->PlaceHolder = RemoveHtml($this->pl_pdf->caption());

		// in_pdf
		$this->in_pdf->EditAttrs["class"] = "form-control";
		$this->in_pdf->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->in_pdf->CurrentValue = HtmlDecode($this->in_pdf->CurrentValue);
		$this->in_pdf->EditValue = $this->in_pdf->CurrentValue;
		$this->in_pdf->PlaceHolder = RemoveHtml($this->in_pdf->caption());

		// a_operator
		$this->a_operator->EditAttrs["class"] = "form-control";
		$this->a_operator->EditCustomAttributes = "";
		$this->a_operator->EditValue = $this->a_operator->CurrentValue;
		$this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

		// port_delivery
		$this->port_delivery->EditAttrs["class"] = "form-control";
		$this->port_delivery->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->port_delivery->CurrentValue = HtmlDecode($this->port_delivery->CurrentValue);
		$this->port_delivery->EditValue = $this->port_delivery->CurrentValue;
		$this->port_delivery->PlaceHolder = RemoveHtml($this->port_delivery->caption());

		// dispatch_details
		$this->dispatch_details->EditAttrs["class"] = "form-control";
		$this->dispatch_details->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->dispatch_details->CurrentValue = HtmlDecode($this->dispatch_details->CurrentValue);
		$this->dispatch_details->EditValue = $this->dispatch_details->CurrentValue;
		$this->dispatch_details->PlaceHolder = RemoveHtml($this->dispatch_details->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->_barcode);
					$doc->exportCaption($this->exporter);
					$doc->exportCaption($this->consignee);
					$doc->exportCaption($this->consignee_other);
					$doc->exportCaption($this->packing_list_no);
					$doc->exportCaption($this->d_11);
					$doc->exportCaption($this->description_11);
					$doc->exportCaption($this->in_template);
					$doc->exportCaption($this->pl_template);
					$doc->exportCaption($this->invoice_no);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->po_no);
					$doc->exportCaption($this->other_reference);
					$doc->exportCaption($this->origin);
					$doc->exportCaption($this->final_destination);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->pre_carriage_receipt);
					$doc->exportCaption($this->place_of_receipt);
					$doc->exportCaption($this->loading_port);
					$doc->exportCaption($this->port_discharge);
					$doc->exportCaption($this->d_01);
					$doc->exportCaption($this->description_01);
					$doc->exportCaption($this->d_02);
					$doc->exportCaption($this->description_02);
					$doc->exportCaption($this->gross_weight);
					$doc->exportCaption($this->nett_weight);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->exporter_bank_details);
					$doc->exportCaption($this->intermediary_bank);
					$doc->exportCaption($this->shipment_mode);
					$doc->exportCaption($this->ex_factory_date);
					$doc->exportCaption($this->sailing_date);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->cart_lines);
					$doc->exportCaption($this->pl_lines);
					$doc->exportCaption($this->freezed);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->port_delivery);
					$doc->exportCaption($this->dispatch_details);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->exporter);
					$doc->exportCaption($this->consignee);
					$doc->exportCaption($this->consignee_other);
					$doc->exportCaption($this->packing_list_no);
					$doc->exportCaption($this->d_11);
					$doc->exportCaption($this->in_template);
					$doc->exportCaption($this->pl_template);
					$doc->exportCaption($this->invoice_no);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->po_no);
					$doc->exportCaption($this->other_reference);
					$doc->exportCaption($this->origin);
					$doc->exportCaption($this->final_destination);
					$doc->exportCaption($this->payment_terms);
					$doc->exportCaption($this->pre_carriage_receipt);
					$doc->exportCaption($this->place_of_receipt);
					$doc->exportCaption($this->loading_port);
					$doc->exportCaption($this->port_discharge);
					$doc->exportCaption($this->d_01);
					$doc->exportCaption($this->description_01);
					$doc->exportCaption($this->d_02);
					$doc->exportCaption($this->description_02);
					$doc->exportCaption($this->gross_weight);
					$doc->exportCaption($this->nett_weight);
					$doc->exportCaption($this->cbm);
					$doc->exportCaption($this->shipment_mode);
					$doc->exportCaption($this->ex_factory_date);
					$doc->exportCaption($this->sailing_date);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->cart_lines);
					$doc->exportCaption($this->pl_lines);
					$doc->exportCaption($this->freezed);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->port_delivery);
					$doc->exportCaption($this->dispatch_details);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->_barcode);
						$doc->exportField($this->exporter);
						$doc->exportField($this->consignee);
						$doc->exportField($this->consignee_other);
						$doc->exportField($this->packing_list_no);
						$doc->exportField($this->d_11);
						$doc->exportField($this->description_11);
						$doc->exportField($this->in_template);
						$doc->exportField($this->pl_template);
						$doc->exportField($this->invoice_no);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->po_no);
						$doc->exportField($this->other_reference);
						$doc->exportField($this->origin);
						$doc->exportField($this->final_destination);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->pre_carriage_receipt);
						$doc->exportField($this->place_of_receipt);
						$doc->exportField($this->loading_port);
						$doc->exportField($this->port_discharge);
						$doc->exportField($this->d_01);
						$doc->exportField($this->description_01);
						$doc->exportField($this->d_02);
						$doc->exportField($this->description_02);
						$doc->exportField($this->gross_weight);
						$doc->exportField($this->nett_weight);
						$doc->exportField($this->cbm);
						$doc->exportField($this->exporter_bank_details);
						$doc->exportField($this->intermediary_bank);
						$doc->exportField($this->shipment_mode);
						$doc->exportField($this->ex_factory_date);
						$doc->exportField($this->sailing_date);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->cart_lines);
						$doc->exportField($this->pl_lines);
						$doc->exportField($this->freezed);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->port_delivery);
						$doc->exportField($this->dispatch_details);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->exporter);
						$doc->exportField($this->consignee);
						$doc->exportField($this->consignee_other);
						$doc->exportField($this->packing_list_no);
						$doc->exportField($this->d_11);
						$doc->exportField($this->in_template);
						$doc->exportField($this->pl_template);
						$doc->exportField($this->invoice_no);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->po_no);
						$doc->exportField($this->other_reference);
						$doc->exportField($this->origin);
						$doc->exportField($this->final_destination);
						$doc->exportField($this->payment_terms);
						$doc->exportField($this->pre_carriage_receipt);
						$doc->exportField($this->place_of_receipt);
						$doc->exportField($this->loading_port);
						$doc->exportField($this->port_discharge);
						$doc->exportField($this->d_01);
						$doc->exportField($this->description_01);
						$doc->exportField($this->d_02);
						$doc->exportField($this->description_02);
						$doc->exportField($this->gross_weight);
						$doc->exportField($this->nett_weight);
						$doc->exportField($this->cbm);
						$doc->exportField($this->shipment_mode);
						$doc->exportField($this->ex_factory_date);
						$doc->exportField($this->sailing_date);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->cart_lines);
						$doc->exportField($this->pl_lines);
						$doc->exportField($this->freezed);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->port_delivery);
						$doc->exportField($this->dispatch_details);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'invoice_details';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'invoice_details';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'invoice_details';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'invoice_details';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>