<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class invoice_details_edit extends invoice_details
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'invoice_details';

	// Page object name
	public $PageObjName = "invoice_details_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (invoice_details)
		if (!isset($GLOBALS["invoice_details"]) || get_class($GLOBALS["invoice_details"]) == PROJECT_NAMESPACE . "invoice_details") {
			$GLOBALS["invoice_details"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["invoice_details"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'invoice_details');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $invoice_details;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($invoice_details);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "invoice_detailsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("invoice_detailslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->_barcode->setVisibility();
		$this->exporter->setVisibility();
		$this->consignee->setVisibility();
		$this->consignee_other->setVisibility();
		$this->packing_list_no->setVisibility();
		$this->d_11->setVisibility();
		$this->description_11->setVisibility();
		$this->in_template->setVisibility();
		$this->pl_template->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->po_no->setVisibility();
		$this->other_reference->setVisibility();
		$this->origin->setVisibility();
		$this->final_destination->setVisibility();
		$this->payment_terms->setVisibility();
		$this->pre_carriage_receipt->setVisibility();
		$this->place_of_receipt->setVisibility();
		$this->loading_port->setVisibility();
		$this->port_discharge->setVisibility();
		$this->d_01->setVisibility();
		$this->description_01->setVisibility();
		$this->d_02->setVisibility();
		$this->description_02->setVisibility();
		$this->gross_weight->setVisibility();
		$this->nett_weight->setVisibility();
		$this->cbm->setVisibility();
		$this->exporter_bank_details->setVisibility();
		$this->intermediary_bank->setVisibility();
		$this->shipment_mode->setVisibility();
		$this->ex_factory_date->setVisibility();
		$this->sailing_date->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->delivery_terms->Visible = FALSE;
		$this->po_date->Visible = FALSE;
		$this->cart_lines->setVisibility();
		$this->pl_lines->setVisibility();
		$this->freezed->setVisibility();
		$this->pl_pdf->Visible = FALSE;
		$this->in_pdf->Visible = FALSE;
		$this->a_operator->Visible = FALSE;
		$this->port_delivery->setVisibility();
		$this->dispatch_details->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->exporter);
		$this->setupLookupOptions($this->consignee);
		$this->setupLookupOptions($this->consignee_other);
		$this->setupLookupOptions($this->packing_list_no);
		$this->setupLookupOptions($this->in_template);
		$this->setupLookupOptions($this->pl_template);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("invoice_detailslist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "invoice_detailslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'barcode' first before field var 'x__barcode'
		$val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
		if (!$this->_barcode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_barcode->Visible = FALSE; // Disable update for API request
			else
				$this->_barcode->setFormValue($val);
		}

		// Check field name 'exporter' first before field var 'x_exporter'
		$val = $CurrentForm->hasValue("exporter") ? $CurrentForm->getValue("exporter") : $CurrentForm->getValue("x_exporter");
		if (!$this->exporter->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->exporter->Visible = FALSE; // Disable update for API request
			else
				$this->exporter->setFormValue($val);
		}

		// Check field name 'consignee' first before field var 'x_consignee'
		$val = $CurrentForm->hasValue("consignee") ? $CurrentForm->getValue("consignee") : $CurrentForm->getValue("x_consignee");
		if (!$this->consignee->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consignee->Visible = FALSE; // Disable update for API request
			else
				$this->consignee->setFormValue($val);
		}

		// Check field name 'consignee_other' first before field var 'x_consignee_other'
		$val = $CurrentForm->hasValue("consignee_other") ? $CurrentForm->getValue("consignee_other") : $CurrentForm->getValue("x_consignee_other");
		if (!$this->consignee_other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consignee_other->Visible = FALSE; // Disable update for API request
			else
				$this->consignee_other->setFormValue($val);
		}

		// Check field name 'packing_list_no' first before field var 'x_packing_list_no'
		$val = $CurrentForm->hasValue("packing_list_no") ? $CurrentForm->getValue("packing_list_no") : $CurrentForm->getValue("x_packing_list_no");
		if (!$this->packing_list_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_list_no->Visible = FALSE; // Disable update for API request
			else
				$this->packing_list_no->setFormValue($val);
		}

		// Check field name 'd_11' first before field var 'x_d_11'
		$val = $CurrentForm->hasValue("d_11") ? $CurrentForm->getValue("d_11") : $CurrentForm->getValue("x_d_11");
		if (!$this->d_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_11->Visible = FALSE; // Disable update for API request
			else
				$this->d_11->setFormValue($val);
		}

		// Check field name 'description_11' first before field var 'x_description_11'
		$val = $CurrentForm->hasValue("description_11") ? $CurrentForm->getValue("description_11") : $CurrentForm->getValue("x_description_11");
		if (!$this->description_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_11->Visible = FALSE; // Disable update for API request
			else
				$this->description_11->setFormValue($val);
		}

		// Check field name 'in_template' first before field var 'x_in_template'
		$val = $CurrentForm->hasValue("in_template") ? $CurrentForm->getValue("in_template") : $CurrentForm->getValue("x_in_template");
		if (!$this->in_template->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->in_template->Visible = FALSE; // Disable update for API request
			else
				$this->in_template->setFormValue($val);
		}

		// Check field name 'pl_template' first before field var 'x_pl_template'
		$val = $CurrentForm->hasValue("pl_template") ? $CurrentForm->getValue("pl_template") : $CurrentForm->getValue("x_pl_template");
		if (!$this->pl_template->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_template->Visible = FALSE; // Disable update for API request
			else
				$this->pl_template->setFormValue($val);
		}

		// Check field name 'invoice_no' first before field var 'x_invoice_no'
		$val = $CurrentForm->hasValue("invoice_no") ? $CurrentForm->getValue("invoice_no") : $CurrentForm->getValue("x_invoice_no");
		if (!$this->invoice_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_no->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_no->setFormValue($val);
		}

		// Check field name 'invoice_date' first before field var 'x_invoice_date'
		$val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
		if (!$this->invoice_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_date->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_date->setFormValue($val);
			$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		}

		// Check field name 'po_no' first before field var 'x_po_no'
		$val = $CurrentForm->hasValue("po_no") ? $CurrentForm->getValue("po_no") : $CurrentForm->getValue("x_po_no");
		if (!$this->po_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_no->Visible = FALSE; // Disable update for API request
			else
				$this->po_no->setFormValue($val);
		}

		// Check field name 'other_reference' first before field var 'x_other_reference'
		$val = $CurrentForm->hasValue("other_reference") ? $CurrentForm->getValue("other_reference") : $CurrentForm->getValue("x_other_reference");
		if (!$this->other_reference->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_reference->Visible = FALSE; // Disable update for API request
			else
				$this->other_reference->setFormValue($val);
		}

		// Check field name 'origin' first before field var 'x_origin'
		$val = $CurrentForm->hasValue("origin") ? $CurrentForm->getValue("origin") : $CurrentForm->getValue("x_origin");
		if (!$this->origin->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->origin->Visible = FALSE; // Disable update for API request
			else
				$this->origin->setFormValue($val);
		}

		// Check field name 'final_destination' first before field var 'x_final_destination'
		$val = $CurrentForm->hasValue("final_destination") ? $CurrentForm->getValue("final_destination") : $CurrentForm->getValue("x_final_destination");
		if (!$this->final_destination->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->final_destination->Visible = FALSE; // Disable update for API request
			else
				$this->final_destination->setFormValue($val);
		}

		// Check field name 'payment_terms' first before field var 'x_payment_terms'
		$val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
		if (!$this->payment_terms->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->payment_terms->Visible = FALSE; // Disable update for API request
			else
				$this->payment_terms->setFormValue($val);
		}

		// Check field name 'pre_carriage_receipt' first before field var 'x_pre_carriage_receipt'
		$val = $CurrentForm->hasValue("pre_carriage_receipt") ? $CurrentForm->getValue("pre_carriage_receipt") : $CurrentForm->getValue("x_pre_carriage_receipt");
		if (!$this->pre_carriage_receipt->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pre_carriage_receipt->Visible = FALSE; // Disable update for API request
			else
				$this->pre_carriage_receipt->setFormValue($val);
		}

		// Check field name 'place_of_receipt' first before field var 'x_place_of_receipt'
		$val = $CurrentForm->hasValue("place_of_receipt") ? $CurrentForm->getValue("place_of_receipt") : $CurrentForm->getValue("x_place_of_receipt");
		if (!$this->place_of_receipt->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->place_of_receipt->Visible = FALSE; // Disable update for API request
			else
				$this->place_of_receipt->setFormValue($val);
		}

		// Check field name 'loading_port' first before field var 'x_loading_port'
		$val = $CurrentForm->hasValue("loading_port") ? $CurrentForm->getValue("loading_port") : $CurrentForm->getValue("x_loading_port");
		if (!$this->loading_port->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->loading_port->Visible = FALSE; // Disable update for API request
			else
				$this->loading_port->setFormValue($val);
		}

		// Check field name 'port_discharge' first before field var 'x_port_discharge'
		$val = $CurrentForm->hasValue("port_discharge") ? $CurrentForm->getValue("port_discharge") : $CurrentForm->getValue("x_port_discharge");
		if (!$this->port_discharge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_discharge->Visible = FALSE; // Disable update for API request
			else
				$this->port_discharge->setFormValue($val);
		}

		// Check field name 'd_01' first before field var 'x_d_01'
		$val = $CurrentForm->hasValue("d_01") ? $CurrentForm->getValue("d_01") : $CurrentForm->getValue("x_d_01");
		if (!$this->d_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_01->Visible = FALSE; // Disable update for API request
			else
				$this->d_01->setFormValue($val);
		}

		// Check field name 'description_01' first before field var 'x_description_01'
		$val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
		if (!$this->description_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_01->Visible = FALSE; // Disable update for API request
			else
				$this->description_01->setFormValue($val);
		}

		// Check field name 'd_02' first before field var 'x_d_02'
		$val = $CurrentForm->hasValue("d_02") ? $CurrentForm->getValue("d_02") : $CurrentForm->getValue("x_d_02");
		if (!$this->d_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_02->Visible = FALSE; // Disable update for API request
			else
				$this->d_02->setFormValue($val);
		}

		// Check field name 'description_02' first before field var 'x_description_02'
		$val = $CurrentForm->hasValue("description_02") ? $CurrentForm->getValue("description_02") : $CurrentForm->getValue("x_description_02");
		if (!$this->description_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description_02->Visible = FALSE; // Disable update for API request
			else
				$this->description_02->setFormValue($val);
		}

		// Check field name 'gross_weight' first before field var 'x_gross_weight'
		$val = $CurrentForm->hasValue("gross_weight") ? $CurrentForm->getValue("gross_weight") : $CurrentForm->getValue("x_gross_weight");
		if (!$this->gross_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gross_weight->Visible = FALSE; // Disable update for API request
			else
				$this->gross_weight->setFormValue($val);
		}

		// Check field name 'nett_weight' first before field var 'x_nett_weight'
		$val = $CurrentForm->hasValue("nett_weight") ? $CurrentForm->getValue("nett_weight") : $CurrentForm->getValue("x_nett_weight");
		if (!$this->nett_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->nett_weight->Visible = FALSE; // Disable update for API request
			else
				$this->nett_weight->setFormValue($val);
		}

		// Check field name 'cbm' first before field var 'x_cbm'
		$val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
		if (!$this->cbm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cbm->Visible = FALSE; // Disable update for API request
			else
				$this->cbm->setFormValue($val);
		}

		// Check field name 'exporter_bank_details' first before field var 'x_exporter_bank_details'
		$val = $CurrentForm->hasValue("exporter_bank_details") ? $CurrentForm->getValue("exporter_bank_details") : $CurrentForm->getValue("x_exporter_bank_details");
		if (!$this->exporter_bank_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->exporter_bank_details->Visible = FALSE; // Disable update for API request
			else
				$this->exporter_bank_details->setFormValue($val);
		}

		// Check field name 'intermediary_bank' first before field var 'x_intermediary_bank'
		$val = $CurrentForm->hasValue("intermediary_bank") ? $CurrentForm->getValue("intermediary_bank") : $CurrentForm->getValue("x_intermediary_bank");
		if (!$this->intermediary_bank->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->intermediary_bank->Visible = FALSE; // Disable update for API request
			else
				$this->intermediary_bank->setFormValue($val);
		}

		// Check field name 'shipment_mode' first before field var 'x_shipment_mode'
		$val = $CurrentForm->hasValue("shipment_mode") ? $CurrentForm->getValue("shipment_mode") : $CurrentForm->getValue("x_shipment_mode");
		if (!$this->shipment_mode->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipment_mode->Visible = FALSE; // Disable update for API request
			else
				$this->shipment_mode->setFormValue($val);
		}

		// Check field name 'ex_factory_date' first before field var 'x_ex_factory_date'
		$val = $CurrentForm->hasValue("ex_factory_date") ? $CurrentForm->getValue("ex_factory_date") : $CurrentForm->getValue("x_ex_factory_date");
		if (!$this->ex_factory_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ex_factory_date->Visible = FALSE; // Disable update for API request
			else
				$this->ex_factory_date->setFormValue($val);
			$this->ex_factory_date->CurrentValue = UnFormatDateTime($this->ex_factory_date->CurrentValue, 0);
		}

		// Check field name 'sailing_date' first before field var 'x_sailing_date'
		$val = $CurrentForm->hasValue("sailing_date") ? $CurrentForm->getValue("sailing_date") : $CurrentForm->getValue("x_sailing_date");
		if (!$this->sailing_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sailing_date->Visible = FALSE; // Disable update for API request
			else
				$this->sailing_date->setFormValue($val);
			$this->sailing_date->CurrentValue = UnFormatDateTime($this->sailing_date->CurrentValue, 0);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'cart_lines' first before field var 'x_cart_lines'
		$val = $CurrentForm->hasValue("cart_lines") ? $CurrentForm->getValue("cart_lines") : $CurrentForm->getValue("x_cart_lines");
		if (!$this->cart_lines->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cart_lines->Visible = FALSE; // Disable update for API request
			else
				$this->cart_lines->setFormValue($val);
		}

		// Check field name 'pl_lines' first before field var 'x_pl_lines'
		$val = $CurrentForm->hasValue("pl_lines") ? $CurrentForm->getValue("pl_lines") : $CurrentForm->getValue("x_pl_lines");
		if (!$this->pl_lines->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pl_lines->Visible = FALSE; // Disable update for API request
			else
				$this->pl_lines->setFormValue($val);
		}

		// Check field name 'freezed' first before field var 'x_freezed'
		$val = $CurrentForm->hasValue("freezed") ? $CurrentForm->getValue("freezed") : $CurrentForm->getValue("x_freezed");
		if (!$this->freezed->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->freezed->Visible = FALSE; // Disable update for API request
			else
				$this->freezed->setFormValue($val);
		}

		// Check field name 'port_delivery' first before field var 'x_port_delivery'
		$val = $CurrentForm->hasValue("port_delivery") ? $CurrentForm->getValue("port_delivery") : $CurrentForm->getValue("x_port_delivery");
		if (!$this->port_delivery->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->port_delivery->Visible = FALSE; // Disable update for API request
			else
				$this->port_delivery->setFormValue($val);
		}

		// Check field name 'dispatch_details' first before field var 'x_dispatch_details'
		$val = $CurrentForm->hasValue("dispatch_details") ? $CurrentForm->getValue("dispatch_details") : $CurrentForm->getValue("x_dispatch_details");
		if (!$this->dispatch_details->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dispatch_details->Visible = FALSE; // Disable update for API request
			else
				$this->dispatch_details->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->_barcode->CurrentValue = $this->_barcode->FormValue;
		$this->exporter->CurrentValue = $this->exporter->FormValue;
		$this->consignee->CurrentValue = $this->consignee->FormValue;
		$this->consignee_other->CurrentValue = $this->consignee_other->FormValue;
		$this->packing_list_no->CurrentValue = $this->packing_list_no->FormValue;
		$this->d_11->CurrentValue = $this->d_11->FormValue;
		$this->description_11->CurrentValue = $this->description_11->FormValue;
		$this->in_template->CurrentValue = $this->in_template->FormValue;
		$this->pl_template->CurrentValue = $this->pl_template->FormValue;
		$this->invoice_no->CurrentValue = $this->invoice_no->FormValue;
		$this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
		$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		$this->po_no->CurrentValue = $this->po_no->FormValue;
		$this->other_reference->CurrentValue = $this->other_reference->FormValue;
		$this->origin->CurrentValue = $this->origin->FormValue;
		$this->final_destination->CurrentValue = $this->final_destination->FormValue;
		$this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
		$this->pre_carriage_receipt->CurrentValue = $this->pre_carriage_receipt->FormValue;
		$this->place_of_receipt->CurrentValue = $this->place_of_receipt->FormValue;
		$this->loading_port->CurrentValue = $this->loading_port->FormValue;
		$this->port_discharge->CurrentValue = $this->port_discharge->FormValue;
		$this->d_01->CurrentValue = $this->d_01->FormValue;
		$this->description_01->CurrentValue = $this->description_01->FormValue;
		$this->d_02->CurrentValue = $this->d_02->FormValue;
		$this->description_02->CurrentValue = $this->description_02->FormValue;
		$this->gross_weight->CurrentValue = $this->gross_weight->FormValue;
		$this->nett_weight->CurrentValue = $this->nett_weight->FormValue;
		$this->cbm->CurrentValue = $this->cbm->FormValue;
		$this->exporter_bank_details->CurrentValue = $this->exporter_bank_details->FormValue;
		$this->intermediary_bank->CurrentValue = $this->intermediary_bank->FormValue;
		$this->shipment_mode->CurrentValue = $this->shipment_mode->FormValue;
		$this->ex_factory_date->CurrentValue = $this->ex_factory_date->FormValue;
		$this->ex_factory_date->CurrentValue = UnFormatDateTime($this->ex_factory_date->CurrentValue, 0);
		$this->sailing_date->CurrentValue = $this->sailing_date->FormValue;
		$this->sailing_date->CurrentValue = UnFormatDateTime($this->sailing_date->CurrentValue, 0);
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->cart_lines->CurrentValue = $this->cart_lines->FormValue;
		$this->pl_lines->CurrentValue = $this->pl_lines->FormValue;
		$this->freezed->CurrentValue = $this->freezed->FormValue;
		$this->port_delivery->CurrentValue = $this->port_delivery->FormValue;
		$this->dispatch_details->CurrentValue = $this->dispatch_details->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->exporter->setDbValue($row['exporter']);
		$this->consignee->setDbValue($row['consignee']);
		$this->consignee_other->setDbValue($row['consignee_other']);
		$this->packing_list_no->setDbValue($row['packing_list_no']);
		$this->d_11->setDbValue($row['d_11']);
		$this->description_11->setDbValue($row['description_11']);
		$this->in_template->setDbValue($row['in_template']);
		$this->pl_template->setDbValue($row['pl_template']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->po_no->setDbValue($row['po_no']);
		$this->other_reference->setDbValue($row['other_reference']);
		$this->origin->setDbValue($row['origin']);
		$this->final_destination->setDbValue($row['final_destination']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->pre_carriage_receipt->setDbValue($row['pre_carriage_receipt']);
		$this->place_of_receipt->setDbValue($row['place_of_receipt']);
		$this->loading_port->setDbValue($row['loading_port']);
		$this->port_discharge->setDbValue($row['port_discharge']);
		$this->d_01->setDbValue($row['d_01']);
		$this->description_01->setDbValue($row['description_01']);
		$this->d_02->setDbValue($row['d_02']);
		$this->description_02->setDbValue($row['description_02']);
		$this->gross_weight->setDbValue($row['gross_weight']);
		$this->nett_weight->setDbValue($row['nett_weight']);
		$this->cbm->setDbValue($row['cbm']);
		$this->exporter_bank_details->setDbValue($row['exporter_bank_details']);
		$this->intermediary_bank->setDbValue($row['intermediary_bank']);
		$this->shipment_mode->setDbValue($row['shipment_mode']);
		$this->ex_factory_date->setDbValue($row['ex_factory_date']);
		$this->sailing_date->setDbValue($row['sailing_date']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->delivery_terms->setDbValue($row['delivery_terms']);
		$this->po_date->setDbValue($row['po_date']);
		$this->cart_lines->setDbValue($row['cart_lines']);
		$this->pl_lines->setDbValue($row['pl_lines']);
		$this->freezed->setDbValue($row['freezed']);
		$this->pl_pdf->setDbValue($row['pl_pdf']);
		$this->in_pdf->setDbValue($row['in_pdf']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->port_delivery->setDbValue($row['port_delivery']);
		$this->dispatch_details->setDbValue($row['dispatch_details']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['barcode'] = NULL;
		$row['exporter'] = NULL;
		$row['consignee'] = NULL;
		$row['consignee_other'] = NULL;
		$row['packing_list_no'] = NULL;
		$row['d_11'] = NULL;
		$row['description_11'] = NULL;
		$row['in_template'] = NULL;
		$row['pl_template'] = NULL;
		$row['invoice_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['po_no'] = NULL;
		$row['other_reference'] = NULL;
		$row['origin'] = NULL;
		$row['final_destination'] = NULL;
		$row['payment_terms'] = NULL;
		$row['pre_carriage_receipt'] = NULL;
		$row['place_of_receipt'] = NULL;
		$row['loading_port'] = NULL;
		$row['port_discharge'] = NULL;
		$row['d_01'] = NULL;
		$row['description_01'] = NULL;
		$row['d_02'] = NULL;
		$row['description_02'] = NULL;
		$row['gross_weight'] = NULL;
		$row['nett_weight'] = NULL;
		$row['cbm'] = NULL;
		$row['exporter_bank_details'] = NULL;
		$row['intermediary_bank'] = NULL;
		$row['shipment_mode'] = NULL;
		$row['ex_factory_date'] = NULL;
		$row['sailing_date'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['delivery_terms'] = NULL;
		$row['po_date'] = NULL;
		$row['cart_lines'] = NULL;
		$row['pl_lines'] = NULL;
		$row['freezed'] = NULL;
		$row['pl_pdf'] = NULL;
		$row['in_pdf'] = NULL;
		$row['a_operator'] = NULL;
		$row['port_delivery'] = NULL;
		$row['dispatch_details'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// barcode
		// exporter
		// consignee
		// consignee_other
		// packing_list_no
		// d_11
		// description_11
		// in_template
		// pl_template
		// invoice_no
		// invoice_date
		// po_no
		// other_reference
		// origin
		// final_destination
		// payment_terms
		// pre_carriage_receipt
		// place_of_receipt
		// loading_port
		// port_discharge
		// d_01
		// description_01
		// d_02
		// description_02
		// gross_weight
		// nett_weight
		// cbm
		// exporter_bank_details
		// intermediary_bank
		// shipment_mode
		// ex_factory_date
		// sailing_date
		// operator
		// datetime
		// delivery_terms
		// po_date
		// cart_lines
		// pl_lines
		// freezed
		// pl_pdf
		// in_pdf
		// a_operator
		// port_delivery
		// dispatch_details

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
			$this->_barcode->ViewCustomAttributes = "";

			// exporter
			$curVal = strval($this->exporter->CurrentValue);
			if ($curVal <> "") {
				$this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
				if ($this->exporter->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->exporter->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->exporter->ViewValue = $this->exporter->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->exporter->ViewValue = $this->exporter->CurrentValue;
					}
				}
			} else {
				$this->exporter->ViewValue = NULL;
			}
			$this->exporter->ViewCustomAttributes = "";

			// consignee
			$curVal = strval($this->consignee->CurrentValue);
			if ($curVal <> "") {
				$this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
				if ($this->consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee->ViewValue = $this->consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee->ViewValue = $this->consignee->CurrentValue;
					}
				}
			} else {
				$this->consignee->ViewValue = NULL;
			}
			$this->consignee->ViewCustomAttributes = "";

			// consignee_other
			$curVal = strval($this->consignee_other->CurrentValue);
			if ($curVal <> "") {
				$this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
				if ($this->consignee_other->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignee_other->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->consignee_other->ViewValue = $this->consignee_other->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignee_other->ViewValue = $this->consignee_other->CurrentValue;
					}
				}
			} else {
				$this->consignee_other->ViewValue = NULL;
			}
			$this->consignee_other->ViewCustomAttributes = "";

			// packing_list_no
			$curVal = strval($this->packing_list_no->CurrentValue);
			if ($curVal <> "") {
				$this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
				if ($this->packing_list_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`pl_no`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_list_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
						$this->packing_list_no->ViewValue = $this->packing_list_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_list_no->ViewValue = $this->packing_list_no->CurrentValue;
					}
				}
			} else {
				$this->packing_list_no->ViewValue = NULL;
			}
			$this->packing_list_no->ViewCustomAttributes = "";

			// d_11
			$this->d_11->ViewValue = $this->d_11->CurrentValue;
			$this->d_11->ViewCustomAttributes = "";

			// description_11
			$this->description_11->ViewValue = $this->description_11->CurrentValue;
			$this->description_11->ViewCustomAttributes = "";

			// in_template
			$curVal = strval($this->in_template->CurrentValue);
			if ($curVal <> "") {
				$this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
				if ($this->in_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->in_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->in_template->ViewValue = $this->in_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->in_template->ViewValue = $this->in_template->CurrentValue;
					}
				}
			} else {
				$this->in_template->ViewValue = NULL;
			}
			$this->in_template->ViewCustomAttributes = "";

			// pl_template
			$curVal = strval($this->pl_template->CurrentValue);
			if ($curVal <> "") {
				$this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
				if ($this->pl_template->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->pl_template->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pl_template->ViewValue = $this->pl_template->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pl_template->ViewValue = $this->pl_template->CurrentValue;
					}
				}
			} else {
				$this->pl_template->ViewValue = NULL;
			}
			$this->pl_template->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// po_no
			$this->po_no->ViewValue = $this->po_no->CurrentValue;
			$this->po_no->ViewCustomAttributes = "";

			// other_reference
			$this->other_reference->ViewValue = $this->other_reference->CurrentValue;
			$this->other_reference->ViewCustomAttributes = "";

			// origin
			$this->origin->ViewValue = $this->origin->CurrentValue;
			$this->origin->ViewCustomAttributes = "";

			// final_destination
			$this->final_destination->ViewValue = $this->final_destination->CurrentValue;
			$this->final_destination->ViewCustomAttributes = "";

			// payment_terms
			$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
			$this->payment_terms->ViewCustomAttributes = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->ViewValue = $this->pre_carriage_receipt->CurrentValue;
			$this->pre_carriage_receipt->ViewCustomAttributes = "";

			// place_of_receipt
			$this->place_of_receipt->ViewValue = $this->place_of_receipt->CurrentValue;
			$this->place_of_receipt->ViewCustomAttributes = "";

			// loading_port
			$this->loading_port->ViewValue = $this->loading_port->CurrentValue;
			$this->loading_port->ViewCustomAttributes = "";

			// port_discharge
			$this->port_discharge->ViewValue = $this->port_discharge->CurrentValue;
			$this->port_discharge->ViewCustomAttributes = "";

			// d_01
			$this->d_01->ViewValue = $this->d_01->CurrentValue;
			$this->d_01->ViewCustomAttributes = "";

			// description_01
			$this->description_01->ViewValue = $this->description_01->CurrentValue;
			$this->description_01->ViewCustomAttributes = "";

			// d_02
			$this->d_02->ViewValue = $this->d_02->CurrentValue;
			$this->d_02->ViewCustomAttributes = "";

			// description_02
			$this->description_02->ViewValue = $this->description_02->CurrentValue;
			$this->description_02->ViewCustomAttributes = "";

			// gross_weight
			$this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
			$this->gross_weight->ViewCustomAttributes = "";

			// nett_weight
			$this->nett_weight->ViewValue = $this->nett_weight->CurrentValue;
			$this->nett_weight->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// exporter_bank_details
			$this->exporter_bank_details->ViewValue = $this->exporter_bank_details->CurrentValue;
			$this->exporter_bank_details->ViewCustomAttributes = "";

			// intermediary_bank
			$this->intermediary_bank->ViewValue = $this->intermediary_bank->CurrentValue;
			$this->intermediary_bank->ViewCustomAttributes = "";

			// shipment_mode
			$this->shipment_mode->ViewValue = $this->shipment_mode->CurrentValue;
			$this->shipment_mode->ViewValue = FormatNumber($this->shipment_mode->ViewValue, 0, -2, -2, -2);
			$this->shipment_mode->ViewCustomAttributes = "";

			// ex_factory_date
			$this->ex_factory_date->ViewValue = $this->ex_factory_date->CurrentValue;
			$this->ex_factory_date->ViewValue = FormatDateTime($this->ex_factory_date->ViewValue, 0);
			$this->ex_factory_date->ViewCustomAttributes = "";

			// sailing_date
			$this->sailing_date->ViewValue = $this->sailing_date->CurrentValue;
			$this->sailing_date->ViewValue = FormatDateTime($this->sailing_date->ViewValue, 0);
			$this->sailing_date->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// cart_lines
			$this->cart_lines->ViewValue = $this->cart_lines->CurrentValue;
			$this->cart_lines->ViewCustomAttributes = "";

			// pl_lines
			$this->pl_lines->ViewValue = $this->pl_lines->CurrentValue;
			$this->pl_lines->ViewCustomAttributes = "";

			// freezed
			if (strval($this->freezed->CurrentValue) <> "") {
				$this->freezed->ViewValue = $this->freezed->optionCaption($this->freezed->CurrentValue);
			} else {
				$this->freezed->ViewValue = NULL;
			}
			$this->freezed->ViewCustomAttributes = "";

			// a_operator
			$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
			$this->a_operator->ViewValue = FormatNumber($this->a_operator->ViewValue, 0, -2, -2, -2);
			$this->a_operator->ViewCustomAttributes = "";

			// port_delivery
			$this->port_delivery->ViewValue = $this->port_delivery->CurrentValue;
			$this->port_delivery->ViewCustomAttributes = "";

			// dispatch_details
			$this->dispatch_details->ViewValue = $this->dispatch_details->CurrentValue;
			$this->dispatch_details->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";
			$this->_barcode->TooltipValue = "";

			// exporter
			$this->exporter->LinkCustomAttributes = "";
			$this->exporter->HrefValue = "";
			$this->exporter->TooltipValue = "";

			// consignee
			$this->consignee->LinkCustomAttributes = "";
			$this->consignee->HrefValue = "";
			$this->consignee->TooltipValue = "";

			// consignee_other
			$this->consignee_other->LinkCustomAttributes = "";
			$this->consignee_other->HrefValue = "";
			$this->consignee_other->TooltipValue = "";

			// packing_list_no
			$this->packing_list_no->LinkCustomAttributes = "";
			$this->packing_list_no->HrefValue = "";
			$this->packing_list_no->TooltipValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";
			$this->d_11->TooltipValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";
			$this->description_11->TooltipValue = "";

			// in_template
			$this->in_template->LinkCustomAttributes = "";
			$this->in_template->HrefValue = "";
			$this->in_template->TooltipValue = "";

			// pl_template
			$this->pl_template->LinkCustomAttributes = "";
			$this->pl_template->HrefValue = "";
			$this->pl_template->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// po_no
			$this->po_no->LinkCustomAttributes = "";
			$this->po_no->HrefValue = "";
			$this->po_no->TooltipValue = "";

			// other_reference
			$this->other_reference->LinkCustomAttributes = "";
			$this->other_reference->HrefValue = "";
			$this->other_reference->TooltipValue = "";

			// origin
			$this->origin->LinkCustomAttributes = "";
			$this->origin->HrefValue = "";
			$this->origin->TooltipValue = "";

			// final_destination
			$this->final_destination->LinkCustomAttributes = "";
			$this->final_destination->HrefValue = "";
			$this->final_destination->TooltipValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";
			$this->payment_terms->TooltipValue = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->LinkCustomAttributes = "";
			$this->pre_carriage_receipt->HrefValue = "";
			$this->pre_carriage_receipt->TooltipValue = "";

			// place_of_receipt
			$this->place_of_receipt->LinkCustomAttributes = "";
			$this->place_of_receipt->HrefValue = "";
			$this->place_of_receipt->TooltipValue = "";

			// loading_port
			$this->loading_port->LinkCustomAttributes = "";
			$this->loading_port->HrefValue = "";
			$this->loading_port->TooltipValue = "";

			// port_discharge
			$this->port_discharge->LinkCustomAttributes = "";
			$this->port_discharge->HrefValue = "";
			$this->port_discharge->TooltipValue = "";

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";
			$this->d_01->TooltipValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";
			$this->description_01->TooltipValue = "";

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";
			$this->d_02->TooltipValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";
			$this->description_02->TooltipValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";
			$this->gross_weight->TooltipValue = "";

			// nett_weight
			$this->nett_weight->LinkCustomAttributes = "";
			$this->nett_weight->HrefValue = "";
			$this->nett_weight->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// exporter_bank_details
			$this->exporter_bank_details->LinkCustomAttributes = "";
			$this->exporter_bank_details->HrefValue = "";
			$this->exporter_bank_details->TooltipValue = "";

			// intermediary_bank
			$this->intermediary_bank->LinkCustomAttributes = "";
			$this->intermediary_bank->HrefValue = "";
			$this->intermediary_bank->TooltipValue = "";

			// shipment_mode
			$this->shipment_mode->LinkCustomAttributes = "";
			$this->shipment_mode->HrefValue = "";
			$this->shipment_mode->TooltipValue = "";

			// ex_factory_date
			$this->ex_factory_date->LinkCustomAttributes = "";
			$this->ex_factory_date->HrefValue = "";
			$this->ex_factory_date->TooltipValue = "";

			// sailing_date
			$this->sailing_date->LinkCustomAttributes = "";
			$this->sailing_date->HrefValue = "";
			$this->sailing_date->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// cart_lines
			$this->cart_lines->LinkCustomAttributes = "";
			$this->cart_lines->HrefValue = "";
			$this->cart_lines->TooltipValue = "";

			// pl_lines
			$this->pl_lines->LinkCustomAttributes = "";
			$this->pl_lines->HrefValue = "";
			$this->pl_lines->TooltipValue = "";

			// freezed
			$this->freezed->LinkCustomAttributes = "";
			$this->freezed->HrefValue = "";
			$this->freezed->TooltipValue = "";

			// port_delivery
			$this->port_delivery->LinkCustomAttributes = "";
			$this->port_delivery->HrefValue = "";
			$this->port_delivery->TooltipValue = "";

			// dispatch_details
			$this->dispatch_details->LinkCustomAttributes = "";
			$this->dispatch_details->HrefValue = "";
			$this->dispatch_details->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// barcode
			$this->_barcode->EditAttrs["class"] = "form-control";
			$this->_barcode->EditCustomAttributes = "";
			$this->_barcode->EditValue = HtmlEncode($this->_barcode->CurrentValue);
			$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

			// exporter
			$this->exporter->EditAttrs["class"] = "form-control";
			$this->exporter->EditCustomAttributes = "";
			$curVal = trim(strval($this->exporter->CurrentValue));
			if ($curVal <> "")
				$this->exporter->ViewValue = $this->exporter->lookupCacheOption($curVal);
			else
				$this->exporter->ViewValue = $this->exporter->Lookup !== NULL && is_array($this->exporter->Lookup->Options) ? $curVal : NULL;
			if ($this->exporter->ViewValue !== NULL) { // Load from cache
				$this->exporter->EditValue = array_values($this->exporter->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->exporter->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->exporter->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->exporter->EditValue = $arwrk;
			}

			// consignee
			$this->consignee->EditAttrs["class"] = "form-control";
			$this->consignee->EditCustomAttributes = "";
			$curVal = trim(strval($this->consignee->CurrentValue));
			if ($curVal <> "")
				$this->consignee->ViewValue = $this->consignee->lookupCacheOption($curVal);
			else
				$this->consignee->ViewValue = $this->consignee->Lookup !== NULL && is_array($this->consignee->Lookup->Options) ? $curVal : NULL;
			if ($this->consignee->ViewValue !== NULL) { // Load from cache
				$this->consignee->EditValue = array_values($this->consignee->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->consignee->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consignee->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->consignee->EditValue = $arwrk;
			}

			// consignee_other
			$this->consignee_other->EditAttrs["class"] = "form-control";
			$this->consignee_other->EditCustomAttributes = "";
			$curVal = trim(strval($this->consignee_other->CurrentValue));
			if ($curVal <> "")
				$this->consignee_other->ViewValue = $this->consignee_other->lookupCacheOption($curVal);
			else
				$this->consignee_other->ViewValue = $this->consignee_other->Lookup !== NULL && is_array($this->consignee_other->Lookup->Options) ? $curVal : NULL;
			if ($this->consignee_other->ViewValue !== NULL) { // Load from cache
				$this->consignee_other->EditValue = array_values($this->consignee_other->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->consignee_other->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consignee_other->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->consignee_other->EditValue = $arwrk;
			}

			// packing_list_no
			$this->packing_list_no->EditAttrs["class"] = "form-control";
			$this->packing_list_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_list_no->CurrentValue));
			if ($curVal <> "")
				$this->packing_list_no->ViewValue = $this->packing_list_no->lookupCacheOption($curVal);
			else
				$this->packing_list_no->ViewValue = $this->packing_list_no->Lookup !== NULL && is_array($this->packing_list_no->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_list_no->ViewValue !== NULL) { // Load from cache
				$this->packing_list_no->EditValue = array_values($this->packing_list_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`pl_no`" . SearchString("=", $this->packing_list_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`pl_no` != 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_list_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 2, -2, -2, -2);
				}
				$this->packing_list_no->EditValue = $arwrk;
			}

			// d_11
			$this->d_11->EditAttrs["class"] = "form-control";
			$this->d_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_11->CurrentValue = HtmlDecode($this->d_11->CurrentValue);
			$this->d_11->EditValue = HtmlEncode($this->d_11->CurrentValue);
			$this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

			// description_11
			$this->description_11->EditAttrs["class"] = "form-control";
			$this->description_11->EditCustomAttributes = "";
			$this->description_11->EditValue = HtmlEncode($this->description_11->CurrentValue);
			$this->description_11->PlaceHolder = RemoveHtml($this->description_11->caption());

			// in_template
			$this->in_template->EditAttrs["class"] = "form-control";
			$this->in_template->EditCustomAttributes = "";
			$curVal = trim(strval($this->in_template->CurrentValue));
			if ($curVal <> "")
				$this->in_template->ViewValue = $this->in_template->lookupCacheOption($curVal);
			else
				$this->in_template->ViewValue = $this->in_template->Lookup !== NULL && is_array($this->in_template->Lookup->Options) ? $curVal : NULL;
			if ($this->in_template->ViewValue !== NULL) { // Load from cache
				$this->in_template->EditValue = array_values($this->in_template->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->in_template->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`apcid` between 45501 and 45999";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->in_template->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->in_template->EditValue = $arwrk;
			}

			// pl_template
			$this->pl_template->EditAttrs["class"] = "form-control";
			$this->pl_template->EditCustomAttributes = "";
			$curVal = trim(strval($this->pl_template->CurrentValue));
			if ($curVal <> "")
				$this->pl_template->ViewValue = $this->pl_template->lookupCacheOption($curVal);
			else
				$this->pl_template->ViewValue = $this->pl_template->Lookup !== NULL && is_array($this->pl_template->Lookup->Options) ? $curVal : NULL;
			if ($this->pl_template->ViewValue !== NULL) { // Load from cache
				$this->pl_template->EditValue = array_values($this->pl_template->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->pl_template->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`apcid` between 45001 and 45500";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->pl_template->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->pl_template->EditValue = $arwrk;
			}

			// invoice_no
			$this->invoice_no->EditAttrs["class"] = "form-control";
			$this->invoice_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice_no->CurrentValue = HtmlDecode($this->invoice_no->CurrentValue);
			$this->invoice_no->EditValue = HtmlEncode($this->invoice_no->CurrentValue);
			$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime($this->invoice_date->CurrentValue, 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// po_no
			$this->po_no->EditAttrs["class"] = "form-control";
			$this->po_no->EditCustomAttributes = "";
			$this->po_no->EditValue = HtmlEncode($this->po_no->CurrentValue);
			$this->po_no->PlaceHolder = RemoveHtml($this->po_no->caption());

			// other_reference
			$this->other_reference->EditAttrs["class"] = "form-control";
			$this->other_reference->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other_reference->CurrentValue = HtmlDecode($this->other_reference->CurrentValue);
			$this->other_reference->EditValue = HtmlEncode($this->other_reference->CurrentValue);
			$this->other_reference->PlaceHolder = RemoveHtml($this->other_reference->caption());

			// origin
			$this->origin->EditAttrs["class"] = "form-control";
			$this->origin->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->origin->CurrentValue = HtmlDecode($this->origin->CurrentValue);
			$this->origin->EditValue = HtmlEncode($this->origin->CurrentValue);
			$this->origin->PlaceHolder = RemoveHtml($this->origin->caption());

			// final_destination
			$this->final_destination->EditAttrs["class"] = "form-control";
			$this->final_destination->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->final_destination->CurrentValue = HtmlDecode($this->final_destination->CurrentValue);
			$this->final_destination->EditValue = HtmlEncode($this->final_destination->CurrentValue);
			$this->final_destination->PlaceHolder = RemoveHtml($this->final_destination->caption());

			// payment_terms
			$this->payment_terms->EditAttrs["class"] = "form-control";
			$this->payment_terms->EditCustomAttributes = "";
			$this->payment_terms->EditValue = HtmlEncode($this->payment_terms->CurrentValue);
			$this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

			// pre_carriage_receipt
			$this->pre_carriage_receipt->EditAttrs["class"] = "form-control";
			$this->pre_carriage_receipt->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pre_carriage_receipt->CurrentValue = HtmlDecode($this->pre_carriage_receipt->CurrentValue);
			$this->pre_carriage_receipt->EditValue = HtmlEncode($this->pre_carriage_receipt->CurrentValue);
			$this->pre_carriage_receipt->PlaceHolder = RemoveHtml($this->pre_carriage_receipt->caption());

			// place_of_receipt
			$this->place_of_receipt->EditAttrs["class"] = "form-control";
			$this->place_of_receipt->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->place_of_receipt->CurrentValue = HtmlDecode($this->place_of_receipt->CurrentValue);
			$this->place_of_receipt->EditValue = HtmlEncode($this->place_of_receipt->CurrentValue);
			$this->place_of_receipt->PlaceHolder = RemoveHtml($this->place_of_receipt->caption());

			// loading_port
			$this->loading_port->EditAttrs["class"] = "form-control";
			$this->loading_port->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->loading_port->CurrentValue = HtmlDecode($this->loading_port->CurrentValue);
			$this->loading_port->EditValue = HtmlEncode($this->loading_port->CurrentValue);
			$this->loading_port->PlaceHolder = RemoveHtml($this->loading_port->caption());

			// port_discharge
			$this->port_discharge->EditAttrs["class"] = "form-control";
			$this->port_discharge->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->port_discharge->CurrentValue = HtmlDecode($this->port_discharge->CurrentValue);
			$this->port_discharge->EditValue = HtmlEncode($this->port_discharge->CurrentValue);
			$this->port_discharge->PlaceHolder = RemoveHtml($this->port_discharge->caption());

			// d_01
			$this->d_01->EditAttrs["class"] = "form-control";
			$this->d_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_01->CurrentValue = HtmlDecode($this->d_01->CurrentValue);
			$this->d_01->EditValue = HtmlEncode($this->d_01->CurrentValue);
			$this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

			// description_01
			$this->description_01->EditAttrs["class"] = "form-control";
			$this->description_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_01->CurrentValue = HtmlDecode($this->description_01->CurrentValue);
			$this->description_01->EditValue = HtmlEncode($this->description_01->CurrentValue);
			$this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

			// d_02
			$this->d_02->EditAttrs["class"] = "form-control";
			$this->d_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_02->CurrentValue = HtmlDecode($this->d_02->CurrentValue);
			$this->d_02->EditValue = HtmlEncode($this->d_02->CurrentValue);
			$this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

			// description_02
			$this->description_02->EditAttrs["class"] = "form-control";
			$this->description_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description_02->CurrentValue = HtmlDecode($this->description_02->CurrentValue);
			$this->description_02->EditValue = HtmlEncode($this->description_02->CurrentValue);
			$this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

			// gross_weight
			$this->gross_weight->EditAttrs["class"] = "form-control";
			$this->gross_weight->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gross_weight->CurrentValue = HtmlDecode($this->gross_weight->CurrentValue);
			$this->gross_weight->EditValue = HtmlEncode($this->gross_weight->CurrentValue);
			$this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

			// nett_weight
			$this->nett_weight->EditAttrs["class"] = "form-control";
			$this->nett_weight->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->nett_weight->CurrentValue = HtmlDecode($this->nett_weight->CurrentValue);
			$this->nett_weight->EditValue = HtmlEncode($this->nett_weight->CurrentValue);
			$this->nett_weight->PlaceHolder = RemoveHtml($this->nett_weight->caption());

			// cbm
			$this->cbm->EditAttrs["class"] = "form-control";
			$this->cbm->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cbm->CurrentValue = HtmlDecode($this->cbm->CurrentValue);
			$this->cbm->EditValue = HtmlEncode($this->cbm->CurrentValue);
			$this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());

			// exporter_bank_details
			$this->exporter_bank_details->EditAttrs["class"] = "form-control";
			$this->exporter_bank_details->EditCustomAttributes = "";
			$this->exporter_bank_details->EditValue = HtmlEncode($this->exporter_bank_details->CurrentValue);
			$this->exporter_bank_details->PlaceHolder = RemoveHtml($this->exporter_bank_details->caption());

			// intermediary_bank
			$this->intermediary_bank->EditAttrs["class"] = "form-control";
			$this->intermediary_bank->EditCustomAttributes = "";
			$this->intermediary_bank->EditValue = HtmlEncode($this->intermediary_bank->CurrentValue);
			$this->intermediary_bank->PlaceHolder = RemoveHtml($this->intermediary_bank->caption());

			// shipment_mode
			$this->shipment_mode->EditAttrs["class"] = "form-control";
			$this->shipment_mode->EditCustomAttributes = "";
			$this->shipment_mode->EditValue = HtmlEncode($this->shipment_mode->CurrentValue);
			$this->shipment_mode->PlaceHolder = RemoveHtml($this->shipment_mode->caption());

			// ex_factory_date
			$this->ex_factory_date->EditAttrs["class"] = "form-control";
			$this->ex_factory_date->EditCustomAttributes = "";
			$this->ex_factory_date->EditValue = HtmlEncode(FormatDateTime($this->ex_factory_date->CurrentValue, 8));
			$this->ex_factory_date->PlaceHolder = RemoveHtml($this->ex_factory_date->caption());

			// sailing_date
			$this->sailing_date->EditAttrs["class"] = "form-control";
			$this->sailing_date->EditCustomAttributes = "";
			$this->sailing_date->EditValue = HtmlEncode(FormatDateTime($this->sailing_date->CurrentValue, 8));
			$this->sailing_date->PlaceHolder = RemoveHtml($this->sailing_date->caption());

			// operator
			// datetime
			// cart_lines

			$this->cart_lines->EditAttrs["class"] = "form-control";
			$this->cart_lines->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cart_lines->CurrentValue = HtmlDecode($this->cart_lines->CurrentValue);
			$this->cart_lines->EditValue = HtmlEncode($this->cart_lines->CurrentValue);
			$this->cart_lines->PlaceHolder = RemoveHtml($this->cart_lines->caption());

			// pl_lines
			$this->pl_lines->EditAttrs["class"] = "form-control";
			$this->pl_lines->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pl_lines->CurrentValue = HtmlDecode($this->pl_lines->CurrentValue);
			$this->pl_lines->EditValue = HtmlEncode($this->pl_lines->CurrentValue);
			$this->pl_lines->PlaceHolder = RemoveHtml($this->pl_lines->caption());

			// freezed
			$this->freezed->EditAttrs["class"] = "form-control";
			$this->freezed->EditCustomAttributes = "";
			$this->freezed->EditValue = $this->freezed->options(TRUE);

			// port_delivery
			$this->port_delivery->EditAttrs["class"] = "form-control";
			$this->port_delivery->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->port_delivery->CurrentValue = HtmlDecode($this->port_delivery->CurrentValue);
			$this->port_delivery->EditValue = HtmlEncode($this->port_delivery->CurrentValue);
			$this->port_delivery->PlaceHolder = RemoveHtml($this->port_delivery->caption());

			// dispatch_details
			$this->dispatch_details->EditAttrs["class"] = "form-control";
			$this->dispatch_details->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->dispatch_details->CurrentValue = HtmlDecode($this->dispatch_details->CurrentValue);
			$this->dispatch_details->EditValue = HtmlEncode($this->dispatch_details->CurrentValue);
			$this->dispatch_details->PlaceHolder = RemoveHtml($this->dispatch_details->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// barcode
			$this->_barcode->LinkCustomAttributes = "";
			$this->_barcode->HrefValue = "";

			// exporter
			$this->exporter->LinkCustomAttributes = "";
			$this->exporter->HrefValue = "";

			// consignee
			$this->consignee->LinkCustomAttributes = "";
			$this->consignee->HrefValue = "";

			// consignee_other
			$this->consignee_other->LinkCustomAttributes = "";
			$this->consignee_other->HrefValue = "";

			// packing_list_no
			$this->packing_list_no->LinkCustomAttributes = "";
			$this->packing_list_no->HrefValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";

			// description_11
			$this->description_11->LinkCustomAttributes = "";
			$this->description_11->HrefValue = "";

			// in_template
			$this->in_template->LinkCustomAttributes = "";
			$this->in_template->HrefValue = "";

			// pl_template
			$this->pl_template->LinkCustomAttributes = "";
			$this->pl_template->HrefValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";

			// po_no
			$this->po_no->LinkCustomAttributes = "";
			$this->po_no->HrefValue = "";

			// other_reference
			$this->other_reference->LinkCustomAttributes = "";
			$this->other_reference->HrefValue = "";

			// origin
			$this->origin->LinkCustomAttributes = "";
			$this->origin->HrefValue = "";

			// final_destination
			$this->final_destination->LinkCustomAttributes = "";
			$this->final_destination->HrefValue = "";

			// payment_terms
			$this->payment_terms->LinkCustomAttributes = "";
			$this->payment_terms->HrefValue = "";

			// pre_carriage_receipt
			$this->pre_carriage_receipt->LinkCustomAttributes = "";
			$this->pre_carriage_receipt->HrefValue = "";

			// place_of_receipt
			$this->place_of_receipt->LinkCustomAttributes = "";
			$this->place_of_receipt->HrefValue = "";

			// loading_port
			$this->loading_port->LinkCustomAttributes = "";
			$this->loading_port->HrefValue = "";

			// port_discharge
			$this->port_discharge->LinkCustomAttributes = "";
			$this->port_discharge->HrefValue = "";

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";

			// description_01
			$this->description_01->LinkCustomAttributes = "";
			$this->description_01->HrefValue = "";

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";

			// description_02
			$this->description_02->LinkCustomAttributes = "";
			$this->description_02->HrefValue = "";

			// gross_weight
			$this->gross_weight->LinkCustomAttributes = "";
			$this->gross_weight->HrefValue = "";

			// nett_weight
			$this->nett_weight->LinkCustomAttributes = "";
			$this->nett_weight->HrefValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";

			// exporter_bank_details
			$this->exporter_bank_details->LinkCustomAttributes = "";
			$this->exporter_bank_details->HrefValue = "";

			// intermediary_bank
			$this->intermediary_bank->LinkCustomAttributes = "";
			$this->intermediary_bank->HrefValue = "";

			// shipment_mode
			$this->shipment_mode->LinkCustomAttributes = "";
			$this->shipment_mode->HrefValue = "";

			// ex_factory_date
			$this->ex_factory_date->LinkCustomAttributes = "";
			$this->ex_factory_date->HrefValue = "";

			// sailing_date
			$this->sailing_date->LinkCustomAttributes = "";
			$this->sailing_date->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// cart_lines
			$this->cart_lines->LinkCustomAttributes = "";
			$this->cart_lines->HrefValue = "";

			// pl_lines
			$this->pl_lines->LinkCustomAttributes = "";
			$this->pl_lines->HrefValue = "";

			// freezed
			$this->freezed->LinkCustomAttributes = "";
			$this->freezed->HrefValue = "";

			// port_delivery
			$this->port_delivery->LinkCustomAttributes = "";
			$this->port_delivery->HrefValue = "";

			// dispatch_details
			$this->dispatch_details->LinkCustomAttributes = "";
			$this->dispatch_details->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->exporter->Required) {
			if (!$this->exporter->IsDetailKey && $this->exporter->FormValue != NULL && $this->exporter->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->exporter->caption(), $this->exporter->RequiredErrorMessage));
			}
		}
		if ($this->consignee->Required) {
			if (!$this->consignee->IsDetailKey && $this->consignee->FormValue != NULL && $this->consignee->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consignee->caption(), $this->consignee->RequiredErrorMessage));
			}
		}
		if ($this->consignee_other->Required) {
			if (!$this->consignee_other->IsDetailKey && $this->consignee_other->FormValue != NULL && $this->consignee_other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consignee_other->caption(), $this->consignee_other->RequiredErrorMessage));
			}
		}
		if ($this->packing_list_no->Required) {
			if (!$this->packing_list_no->IsDetailKey && $this->packing_list_no->FormValue != NULL && $this->packing_list_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_list_no->caption(), $this->packing_list_no->RequiredErrorMessage));
			}
		}
		if ($this->d_11->Required) {
			if (!$this->d_11->IsDetailKey && $this->d_11->FormValue != NULL && $this->d_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_11->caption(), $this->d_11->RequiredErrorMessage));
			}
		}
		if ($this->description_11->Required) {
			if (!$this->description_11->IsDetailKey && $this->description_11->FormValue != NULL && $this->description_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_11->caption(), $this->description_11->RequiredErrorMessage));
			}
		}
		if ($this->in_template->Required) {
			if (!$this->in_template->IsDetailKey && $this->in_template->FormValue != NULL && $this->in_template->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->in_template->caption(), $this->in_template->RequiredErrorMessage));
			}
		}
		if ($this->pl_template->Required) {
			if (!$this->pl_template->IsDetailKey && $this->pl_template->FormValue != NULL && $this->pl_template->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_template->caption(), $this->pl_template->RequiredErrorMessage));
			}
		}
		if ($this->invoice_no->Required) {
			if (!$this->invoice_no->IsDetailKey && $this->invoice_no->FormValue != NULL && $this->invoice_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_no->caption(), $this->invoice_no->RequiredErrorMessage));
			}
		}
		if ($this->invoice_date->Required) {
			if (!$this->invoice_date->IsDetailKey && $this->invoice_date->FormValue != NULL && $this->invoice_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->invoice_date->FormValue)) {
			AddMessage($FormError, $this->invoice_date->errorMessage());
		}
		if ($this->po_no->Required) {
			if (!$this->po_no->IsDetailKey && $this->po_no->FormValue != NULL && $this->po_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_no->caption(), $this->po_no->RequiredErrorMessage));
			}
		}
		if ($this->other_reference->Required) {
			if (!$this->other_reference->IsDetailKey && $this->other_reference->FormValue != NULL && $this->other_reference->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_reference->caption(), $this->other_reference->RequiredErrorMessage));
			}
		}
		if ($this->origin->Required) {
			if (!$this->origin->IsDetailKey && $this->origin->FormValue != NULL && $this->origin->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->origin->caption(), $this->origin->RequiredErrorMessage));
			}
		}
		if ($this->final_destination->Required) {
			if (!$this->final_destination->IsDetailKey && $this->final_destination->FormValue != NULL && $this->final_destination->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->final_destination->caption(), $this->final_destination->RequiredErrorMessage));
			}
		}
		if ($this->payment_terms->Required) {
			if (!$this->payment_terms->IsDetailKey && $this->payment_terms->FormValue != NULL && $this->payment_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
			}
		}
		if ($this->pre_carriage_receipt->Required) {
			if (!$this->pre_carriage_receipt->IsDetailKey && $this->pre_carriage_receipt->FormValue != NULL && $this->pre_carriage_receipt->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pre_carriage_receipt->caption(), $this->pre_carriage_receipt->RequiredErrorMessage));
			}
		}
		if ($this->place_of_receipt->Required) {
			if (!$this->place_of_receipt->IsDetailKey && $this->place_of_receipt->FormValue != NULL && $this->place_of_receipt->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->place_of_receipt->caption(), $this->place_of_receipt->RequiredErrorMessage));
			}
		}
		if ($this->loading_port->Required) {
			if (!$this->loading_port->IsDetailKey && $this->loading_port->FormValue != NULL && $this->loading_port->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->loading_port->caption(), $this->loading_port->RequiredErrorMessage));
			}
		}
		if ($this->port_discharge->Required) {
			if (!$this->port_discharge->IsDetailKey && $this->port_discharge->FormValue != NULL && $this->port_discharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_discharge->caption(), $this->port_discharge->RequiredErrorMessage));
			}
		}
		if ($this->d_01->Required) {
			if (!$this->d_01->IsDetailKey && $this->d_01->FormValue != NULL && $this->d_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_01->caption(), $this->d_01->RequiredErrorMessage));
			}
		}
		if ($this->description_01->Required) {
			if (!$this->description_01->IsDetailKey && $this->description_01->FormValue != NULL && $this->description_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
			}
		}
		if ($this->d_02->Required) {
			if (!$this->d_02->IsDetailKey && $this->d_02->FormValue != NULL && $this->d_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_02->caption(), $this->d_02->RequiredErrorMessage));
			}
		}
		if ($this->description_02->Required) {
			if (!$this->description_02->IsDetailKey && $this->description_02->FormValue != NULL && $this->description_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
			}
		}
		if ($this->gross_weight->Required) {
			if (!$this->gross_weight->IsDetailKey && $this->gross_weight->FormValue != NULL && $this->gross_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gross_weight->caption(), $this->gross_weight->RequiredErrorMessage));
			}
		}
		if ($this->nett_weight->Required) {
			if (!$this->nett_weight->IsDetailKey && $this->nett_weight->FormValue != NULL && $this->nett_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->nett_weight->caption(), $this->nett_weight->RequiredErrorMessage));
			}
		}
		if ($this->cbm->Required) {
			if (!$this->cbm->IsDetailKey && $this->cbm->FormValue != NULL && $this->cbm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
			}
		}
		if ($this->exporter_bank_details->Required) {
			if (!$this->exporter_bank_details->IsDetailKey && $this->exporter_bank_details->FormValue != NULL && $this->exporter_bank_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->exporter_bank_details->caption(), $this->exporter_bank_details->RequiredErrorMessage));
			}
		}
		if ($this->intermediary_bank->Required) {
			if (!$this->intermediary_bank->IsDetailKey && $this->intermediary_bank->FormValue != NULL && $this->intermediary_bank->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->intermediary_bank->caption(), $this->intermediary_bank->RequiredErrorMessage));
			}
		}
		if ($this->shipment_mode->Required) {
			if (!$this->shipment_mode->IsDetailKey && $this->shipment_mode->FormValue != NULL && $this->shipment_mode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipment_mode->caption(), $this->shipment_mode->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->shipment_mode->FormValue)) {
			AddMessage($FormError, $this->shipment_mode->errorMessage());
		}
		if ($this->ex_factory_date->Required) {
			if (!$this->ex_factory_date->IsDetailKey && $this->ex_factory_date->FormValue != NULL && $this->ex_factory_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ex_factory_date->caption(), $this->ex_factory_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->ex_factory_date->FormValue)) {
			AddMessage($FormError, $this->ex_factory_date->errorMessage());
		}
		if ($this->sailing_date->Required) {
			if (!$this->sailing_date->IsDetailKey && $this->sailing_date->FormValue != NULL && $this->sailing_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sailing_date->caption(), $this->sailing_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->sailing_date->FormValue)) {
			AddMessage($FormError, $this->sailing_date->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->delivery_terms->Required) {
			if (!$this->delivery_terms->IsDetailKey && $this->delivery_terms->FormValue != NULL && $this->delivery_terms->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_terms->caption(), $this->delivery_terms->RequiredErrorMessage));
			}
		}
		if ($this->po_date->Required) {
			if (!$this->po_date->IsDetailKey && $this->po_date->FormValue != NULL && $this->po_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_date->caption(), $this->po_date->RequiredErrorMessage));
			}
		}
		if ($this->cart_lines->Required) {
			if (!$this->cart_lines->IsDetailKey && $this->cart_lines->FormValue != NULL && $this->cart_lines->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cart_lines->caption(), $this->cart_lines->RequiredErrorMessage));
			}
		}
		if ($this->pl_lines->Required) {
			if (!$this->pl_lines->IsDetailKey && $this->pl_lines->FormValue != NULL && $this->pl_lines->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_lines->caption(), $this->pl_lines->RequiredErrorMessage));
			}
		}
		if ($this->freezed->Required) {
			if (!$this->freezed->IsDetailKey && $this->freezed->FormValue != NULL && $this->freezed->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->freezed->caption(), $this->freezed->RequiredErrorMessage));
			}
		}
		if ($this->pl_pdf->Required) {
			if (!$this->pl_pdf->IsDetailKey && $this->pl_pdf->FormValue != NULL && $this->pl_pdf->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pl_pdf->caption(), $this->pl_pdf->RequiredErrorMessage));
			}
		}
		if ($this->in_pdf->Required) {
			if (!$this->in_pdf->IsDetailKey && $this->in_pdf->FormValue != NULL && $this->in_pdf->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->in_pdf->caption(), $this->in_pdf->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->port_delivery->Required) {
			if (!$this->port_delivery->IsDetailKey && $this->port_delivery->FormValue != NULL && $this->port_delivery->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->port_delivery->caption(), $this->port_delivery->RequiredErrorMessage));
			}
		}
		if ($this->dispatch_details->Required) {
			if (!$this->dispatch_details->IsDetailKey && $this->dispatch_details->FormValue != NULL && $this->dispatch_details->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dispatch_details->caption(), $this->dispatch_details->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->packing_list_no->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`packing_list_no` = " . AdjustSql($this->packing_list_no->CurrentValue, $this->Dbid) . ")";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->packing_list_no->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->packing_list_no->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		if ($this->invoice_no->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`invoice_no` = '" . AdjustSql($this->invoice_no->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->invoice_no->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->invoice_no->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// barcode
			$this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, NULL, $this->_barcode->ReadOnly);

			// exporter
			$this->exporter->setDbValueDef($rsnew, $this->exporter->CurrentValue, NULL, $this->exporter->ReadOnly);

			// consignee
			$this->consignee->setDbValueDef($rsnew, $this->consignee->CurrentValue, NULL, $this->consignee->ReadOnly);

			// consignee_other
			$this->consignee_other->setDbValueDef($rsnew, $this->consignee_other->CurrentValue, NULL, $this->consignee_other->ReadOnly);

			// packing_list_no
			$this->packing_list_no->setDbValueDef($rsnew, $this->packing_list_no->CurrentValue, NULL, $this->packing_list_no->ReadOnly);

			// d_11
			$this->d_11->setDbValueDef($rsnew, $this->d_11->CurrentValue, NULL, $this->d_11->ReadOnly);

			// description_11
			$this->description_11->setDbValueDef($rsnew, $this->description_11->CurrentValue, NULL, $this->description_11->ReadOnly);

			// in_template
			$this->in_template->setDbValueDef($rsnew, $this->in_template->CurrentValue, NULL, $this->in_template->ReadOnly);

			// pl_template
			$this->pl_template->setDbValueDef($rsnew, $this->pl_template->CurrentValue, NULL, $this->pl_template->ReadOnly);

			// invoice_no
			$this->invoice_no->setDbValueDef($rsnew, $this->invoice_no->CurrentValue, NULL, $this->invoice_no->ReadOnly);

			// invoice_date
			$this->invoice_date->setDbValueDef($rsnew, UnFormatDateTime($this->invoice_date->CurrentValue, 0), NULL, $this->invoice_date->ReadOnly);

			// po_no
			$this->po_no->setDbValueDef($rsnew, $this->po_no->CurrentValue, NULL, $this->po_no->ReadOnly);

			// other_reference
			$this->other_reference->setDbValueDef($rsnew, $this->other_reference->CurrentValue, NULL, $this->other_reference->ReadOnly);

			// origin
			$this->origin->setDbValueDef($rsnew, $this->origin->CurrentValue, NULL, $this->origin->ReadOnly);

			// final_destination
			$this->final_destination->setDbValueDef($rsnew, $this->final_destination->CurrentValue, NULL, $this->final_destination->ReadOnly);

			// payment_terms
			$this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, NULL, $this->payment_terms->ReadOnly);

			// pre_carriage_receipt
			$this->pre_carriage_receipt->setDbValueDef($rsnew, $this->pre_carriage_receipt->CurrentValue, NULL, $this->pre_carriage_receipt->ReadOnly);

			// place_of_receipt
			$this->place_of_receipt->setDbValueDef($rsnew, $this->place_of_receipt->CurrentValue, NULL, $this->place_of_receipt->ReadOnly);

			// loading_port
			$this->loading_port->setDbValueDef($rsnew, $this->loading_port->CurrentValue, NULL, $this->loading_port->ReadOnly);

			// port_discharge
			$this->port_discharge->setDbValueDef($rsnew, $this->port_discharge->CurrentValue, NULL, $this->port_discharge->ReadOnly);

			// d_01
			$this->d_01->setDbValueDef($rsnew, $this->d_01->CurrentValue, NULL, $this->d_01->ReadOnly);

			// description_01
			$this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, NULL, $this->description_01->ReadOnly);

			// d_02
			$this->d_02->setDbValueDef($rsnew, $this->d_02->CurrentValue, NULL, $this->d_02->ReadOnly);

			// description_02
			$this->description_02->setDbValueDef($rsnew, $this->description_02->CurrentValue, NULL, $this->description_02->ReadOnly);

			// gross_weight
			$this->gross_weight->setDbValueDef($rsnew, $this->gross_weight->CurrentValue, NULL, $this->gross_weight->ReadOnly);

			// nett_weight
			$this->nett_weight->setDbValueDef($rsnew, $this->nett_weight->CurrentValue, NULL, $this->nett_weight->ReadOnly);

			// cbm
			$this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, NULL, $this->cbm->ReadOnly);

			// exporter_bank_details
			$this->exporter_bank_details->setDbValueDef($rsnew, $this->exporter_bank_details->CurrentValue, NULL, $this->exporter_bank_details->ReadOnly);

			// intermediary_bank
			$this->intermediary_bank->setDbValueDef($rsnew, $this->intermediary_bank->CurrentValue, NULL, $this->intermediary_bank->ReadOnly);

			// shipment_mode
			$this->shipment_mode->setDbValueDef($rsnew, $this->shipment_mode->CurrentValue, NULL, $this->shipment_mode->ReadOnly);

			// ex_factory_date
			$this->ex_factory_date->setDbValueDef($rsnew, UnFormatDateTime($this->ex_factory_date->CurrentValue, 0), NULL, $this->ex_factory_date->ReadOnly);

			// sailing_date
			$this->sailing_date->setDbValueDef($rsnew, UnFormatDateTime($this->sailing_date->CurrentValue, 0), NULL, $this->sailing_date->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// cart_lines
			$this->cart_lines->setDbValueDef($rsnew, $this->cart_lines->CurrentValue, NULL, $this->cart_lines->ReadOnly);

			// pl_lines
			$this->pl_lines->setDbValueDef($rsnew, $this->pl_lines->CurrentValue, NULL, $this->pl_lines->ReadOnly);

			// freezed
			$this->freezed->setDbValueDef($rsnew, $this->freezed->CurrentValue, 0, $this->freezed->ReadOnly);

			// port_delivery
			$this->port_delivery->setDbValueDef($rsnew, $this->port_delivery->CurrentValue, NULL, $this->port_delivery->ReadOnly);

			// dispatch_details
			$this->dispatch_details->setDbValueDef($rsnew, $this->dispatch_details->CurrentValue, NULL, $this->dispatch_details->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("invoice_detailslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_exporter":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignee_other":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_list_no":
					$lookupFilter = function() {
						return "`pl_no` != 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_in_template":
					$lookupFilter = function() {
						return "`apcid` between 45501 and 45999";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_pl_template":
					$lookupFilter = function() {
						return "`apcid` between 45001 and 45500";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_exporter":
							break;
						case "x_consignee":
							break;
						case "x_consignee_other":
							break;
						case "x_packing_list_no":
							$row[1] = FormatNumber($row[1], 2, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_in_template":
							break;
						case "x_pl_template":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>